/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;

public enum CharacterEncoding {
    SJIS("Shift-JIS"),
    ANSI("ASCII"),
    UTF8("UTF-8"),
    WINDOWS31J("windows-31j"),
    MS932("MS932"),
    CP932("CP932");

    private static final Map<String, CharacterEncoding> TABLE;
    private String encoding;

    public static CharacterEncoding fromCharSet(Charset set) {
        return TABLE.get(set.name());
    }

    private CharacterEncoding(String enc) {
        this.encoding = enc;
    }

    public String getEncoding() {
        return this.encoding;
    }

    static {
        TABLE = new LinkedHashMap<String, CharacterEncoding>();
        for (CharacterEncoding set : CharacterEncoding.values()) {
            TABLE.put(set.encoding, set);
        }
    }
}

