/*
 * Decompiled with CFR 0.152.
 */
package com.hammurapi.jcapture;

import com.hammurapi.jcapture.CaptureFrame;
import java.awt.Component;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProxySelector;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.SwingUtilities;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.net.URLCodec;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;

public abstract class AbstractCaptureApplet
extends JApplet {
    private static final String OUTPUT_DIR_PARAMETER = "outputDir";
    private CaptureFrame captureFrame;
    private Collection<Closeable> closeables = new ArrayList<Closeable>();
    private ExecutorService backgroundProcessor;
    protected File preferencesFile = new File(System.getProperty("user.home") + File.separator + "." + this.getClass().getName() + ".properties");
    protected ProxySelector proxySelector;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.captureFrame != null) {
            this.captureFrame.dispose();
            this.captureFrame = null;
        }
        this.backgroundProcessor.shutdown();
        Collection<Closeable> collection = this.closeables;
        synchronized (collection) {
            Iterator<Closeable> cit = this.closeables.iterator();
            while (cit.hasNext()) {
                try {
                    cit.next().close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                cit.remove();
            }
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCloseable(Closeable closeable) {
        Collection<Closeable> collection = this.closeables;
        synchronized (collection) {
            this.closeables.add(closeable);
        }
    }

    public void showCaptureFrame() {
        System.out.println("Showing capture frame");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (AbstractCaptureApplet.this.captureFrame == null) {
                        AbstractCaptureApplet.this.createCaptureFrame();
                    }
                    AbstractCaptureApplet.this.captureFrame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void start() {
        super.start();
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread th = new Thread(r, "Background processor");
                th.setPriority(5);
                return th;
            }
        };
        this.backgroundProcessor = Executors.newSingleThreadExecutor(threadFactory);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractCaptureApplet.this.createCaptureFrame();
            }
        });
        try {
            this.proxySelector = ProxySelector.getDefault();
        }
        catch (Exception e) {
            System.err.println("Can't obtain proxy information: " + e);
            e.printStackTrace();
        }
    }

    public ExecutorService getBackgroundProcessor() {
        return this.backgroundProcessor;
    }

    protected void createCaptureFrame() {
        try {
            this.captureFrame = new CaptureFrame(this);
            this.captureFrame.setVisible(true);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error: " + e, "Cannot create capture window", 0);
            e.printStackTrace();
        }
    }

    public static String formatByteSize(long bytes) {
        if (bytes < 1024L) {
            return bytes + "bytes";
        }
        if (bytes < 0x100000L) {
            return MessageFormat.format("{0,number,0.0} Kb", (double)bytes / 1024.0);
        }
        if (bytes < 0x40000000L) {
            return MessageFormat.format("{0,number,0.00} Mb", (double)bytes / 1048576.0);
        }
        return MessageFormat.format("{0,number,0.00} Gb", (double)bytes / 1.073741824E9);
    }

    public Properties loadConfig() {
        try {
            if (this.preferencesFile.isFile()) {
                FileInputStream configStream = new FileInputStream(this.preferencesFile);
                Properties ret = new Properties();
                ret.load(configStream);
                ((InputStream)configStream).close();
                return ret;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void storeConfig(Properties properties) {
        try {
            FileOutputStream out = new FileOutputStream(this.preferencesFile);
            properties.store(out, "Config");
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String getCookies() throws DecoderException {
        String cookiesStr = this.getParameter("cookies");
        if (cookiesStr == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        StringTokenizer st = new StringTokenizer(cookiesStr, ";");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            int idx = tok.indexOf("=");
            ret.append(this.hex2urlEncoded(tok.substring(0, idx)));
            ret.append("=");
            ret.append(this.hex2urlEncoded(tok.substring(idx + 1)));
            if (!st.hasMoreElements()) continue;
            ret.append(";");
        }
        return ret.toString();
    }

    private String hex2urlEncoded(String hexStr) throws DecoderException {
        return new String(URLCodec.encodeUrl(null, Hex.decodeHex(hexStr.toCharArray())));
    }

    public HttpResponse post(Component parentComponent, InputStream content, final long contentLength, String fileName, String mimeType) throws Exception {
        System.out.println("jCapture applet, build 20140226073822");
        if (this.getParameter(OUTPUT_DIR_PARAMETER) != null) {
            int l;
            FileOutputStream out = new FileOutputStream(new File(this.getParameter(OUTPUT_DIR_PARAMETER) + File.separator + fileName));
            byte[] buf = new byte[4096];
            while ((l = content.read(buf)) != -1) {
                ((OutputStream)out).write(buf, 0, l);
            }
            ((OutputStream)out).close();
            content.close();
            return null;
        }
        ProgressMonitorInputStream pmis = new ProgressMonitorInputStream(parentComponent, "Uploading " + fileName + " (" + AbstractCaptureApplet.formatByteSize(contentLength) + ")", content);
        InputStreamBody bin = new InputStreamBody(pmis, mimeType, this.bodyName(fileName)){

            public long getContentLength() {
                return contentLength;
            }
        };
        DefaultHttpClient httpClient = new DefaultHttpClient();
        if (this.proxySelector != null) {
            ProxySelectorRoutePlanner routePlanner = new ProxySelectorRoutePlanner(httpClient.getConnectionManager().getSchemeRegistry(), this.proxySelector);
            httpClient.setRoutePlanner((HttpRoutePlanner)routePlanner);
        }
        return httpClient.execute(this.createRequest(fileName, bin));
    }

    protected abstract HttpUriRequest createRequest(String var1, InputStreamBody var2) throws Exception;

    protected abstract String bodyName(String var1);
}

