/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.fillstyle;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.datatype.Color;
import com.flagstone.transform.fillstyle.FillStyle;
import java.io.IOException;

public final class MorphSolidFill
implements FillStyle {
    private static final String FORMAT = "MorphSolidFill: { start=%s; end=%s}";
    private Color startColor;
    private Color endColor;

    public MorphSolidFill(SWFDecoder coder, Context context) throws IOException {
        this.startColor = new Color(coder, context);
        this.endColor = new Color(coder, context);
    }

    public MorphSolidFill(Color start, Color end) {
        this.setStartColor(start);
        this.setEndColor(end);
    }

    public MorphSolidFill(MorphSolidFill object) {
        this.startColor = object.startColor;
        this.endColor = object.endColor;
    }

    public Color getStartColor() {
        return this.startColor;
    }

    public Color getEndColor() {
        return this.endColor;
    }

    public void setStartColor(Color aColor) {
        if (aColor == null) {
            throw new IllegalArgumentException();
        }
        this.startColor = aColor;
    }

    public void setEndColor(Color aColor) {
        if (aColor == null) {
            throw new IllegalArgumentException();
        }
        this.endColor = aColor;
    }

    @Override
    public MorphSolidFill copy() {
        return new MorphSolidFill(this);
    }

    public String toString() {
        return String.format(FORMAT, this.startColor, this.endColor);
    }

    @Override
    public int prepareToEncode(Context context) {
        return 9;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(0);
        this.startColor.encode(coder, context);
        this.endColor.encode(coder, context);
    }
}

