/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.datatype;

import com.flagstone.transform.coder.Coder;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncodeable;
import com.flagstone.transform.coder.SWFEncoder;
import java.io.IOException;

public final class Bounds
implements SWFEncodeable {
    private static final int ROUND_TO_BYTES = 7;
    private static final int BITS_TO_BYTES = 3;
    private static final String FORMAT = "Bounds: (%d, %d) (%d, %d)";
    private static final int FIELD_SIZE = 5;
    private final transient int minX;
    private final transient int minY;
    private final transient int maxX;
    private final transient int maxY;
    private transient int size;

    public static Bounds pad(Bounds rect, int padding) {
        return new Bounds(rect.getMinX() - padding, rect.getMinY() - padding, rect.getMaxX() + padding, rect.getMaxY() + padding);
    }

    public static Bounds pad(Bounds rect, int top, int right, int bottom, int left) {
        return new Bounds(rect.getMinX() - left, rect.getMinY() - top, rect.getMaxX() + right, rect.getMaxY() + bottom);
    }

    public Bounds(SWFDecoder coder) throws IOException {
        this.size = coder.readBits(5, false);
        this.minX = coder.readBits(this.size, true);
        this.maxX = coder.readBits(this.size, true);
        this.minY = coder.readBits(this.size, true);
        this.maxY = coder.readBits(this.size, true);
        coder.alignToByte();
    }

    public Bounds(int xmin, int ymin, int xmax, int ymax) {
        this.minX = xmin;
        this.minY = ymin;
        this.maxX = xmax;
        this.maxY = ymax;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getWidth() {
        return this.maxX - this.minX;
    }

    public int getHeight() {
        return this.maxY - this.minY;
    }

    public String toString() {
        return String.format(FORMAT, this.minX, this.minY, this.maxX, this.maxY);
    }

    public boolean equals(Object object) {
        boolean result;
        if (object == null) {
            result = false;
        } else if (object == this) {
            result = true;
        } else if (object instanceof Bounds) {
            Bounds bounds = (Bounds)object;
            result = this.minX == bounds.minX && this.minY == bounds.minY && this.maxX == bounds.maxX && this.maxY == bounds.maxY;
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        return ((this.minX * 31 + this.minY) * 31 + this.maxX) * 31 + this.maxY;
    }

    @Override
    public int prepareToEncode(Context context) {
        this.size = Coder.maxSize(this.minX, this.minY, this.maxX, this.maxY);
        return 12 + (this.size << 2) >> 3;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeBits(this.size, 5);
        coder.writeBits(this.minX, this.size);
        coder.writeBits(this.maxX, this.size);
        coder.writeBits(this.minY, this.size);
        coder.writeBits(this.maxY, this.size);
        coder.alignToByte();
    }
}

