package pike

import (
	"fmt"
)

// GetAZUREDataPermissions gets permissions required for datasources.
func GetAZUREDataPermissions(result ResourceV2) ([]string, error) {
	temp := AzureDataLookup(result.Name)

	var (
		Permissions []string
		err         error
	)

	if temp != nil {
		Permissions, err = GetPermissionMap(temp.([]byte), result.Attributes, result.Name)
	} else {
		return nil, fmt.Errorf("data.%s not implemented", result.Name)
	}

	return Permissions, err
}

func AzureDataLookup(name string) interface{} {
	TFLookup := map[string]interface{}{
		"azurerm_app_service":                                    dataAzurermAppService,
		"azurerm_app_service_certificate":                        dataAzurermAppServiceCertificate,
		"azurerm_app_service_certificate_order":                  dataAzurermAppServiceCertificateOrder,
		"azurerm_app_service_environment":                        dataAzurermAppServiceEnvironment,
		"azurerm_app_service_environment_v3":                     dataAzurermAppServiceEnvironmentV3,
		"azurerm_app_service_plan":                               dataAzurermAppServicePlan,
		"azurerm_client_config":                                  placeholder,
		"azurerm_key_vault":                                      dataAzurermKeyVault,
		"azurerm_key_vault_access_policy":                        placeholder,
		"azurerm_key_vault_certificate":                          dataAzurermKeyVaultCertificate,
		"azurerm_key_vault_certificate_data":                     dataAzurermKeyVaultCertificateData,
		"azurerm_key_vault_certificate_issuer":                   dataAzurermKeyVaultCertificateIssuer,
		"azurerm_key_vault_certificates":                         dataAzurermKeyVaultCertificates,
		"azurerm_key_vault_encrypted_value":                      placeholder,
		"azurerm_key_vault_key":                                  dataAzurermKeyVaultKey,
		"azurerm_key_vault_managed_hardware_security_module":     dataAzurermKeyVaultManagedHardwareSecurityModule,
		"azurerm_key_vault_secret":                               dataAzurermKeyVaultSecret,
		"azurerm_key_vault_secrets":                              dataAzurermKeyVaultSecrets,
		"azurerm_network_watcher":                                dataAzurermNetworkWatcher,
		"azurerm_public_ip":                                      dataAzurermPublicIP,
		"azurerm_public_ip_prefix":                               dataAzurermPublicIPPrefix,
		"azurerm_public_ips":                                     dataAzurermPublicIps,
		"azurerm_redis_cache":                                    dataAzurermRedisCache,
		"azurerm_redis_enterprise_database":                      dataAzurermRedisEnterpriseDatabase,
		"azurerm_resource_group":                                 dataAzurermResourceGroup,
		"azurerm_resource_group_template_deployment":             dataAzurermResourceGroupTemplateDeployment,
		"azurerm_resources":                                      placeholder,
		"azurerm_role_definition":                                placeholder,
		"azurerm_route_filter":                                   dataAzurermRouteFilter,
		"azurerm_route_table":                                    dataAzurermRouteTable,
		"azurerm_sentinel_alert_rule":                            dataAzurermSentinelAlertRule,
		"azurerm_sentinel_alert_rule_template":                   placeholder,
		"azurerm_service_plan":                                   dataAzurermServicePlan,
		"azurerm_servicebus_namespace":                           dataAzurermServicebusNamespace,
		"azurerm_servicebus_namespace_authorization_rule":        dataAzurermServicebusNamespaceAuthorizationRule,
		"azurerm_servicebus_queue":                               dataAzurermServicebusQueue,
		"azurerm_servicebus_queue_authorization_rule":            dataAzurermServicebusQueueAuthorizationRule,
		"azurerm_servicebus_subscription":                        dataAzurermServicebusSubscription,
		"azurerm_servicebus_topic":                               dataAzurermServicebusTopic,
		"azurerm_shared_image":                                   dataAzurermSharedImage,
		"azurerm_shared_image_gallery":                           dataAzurermSharedImageGallery,
		"azurerm_shared_image_version":                           placeholder,
		"azurerm_shared_image_versions":                          placeholder,
		"azurerm_signalr_service":                                dataAzurermSignalrService,
		"azurerm_site_recovery_fabric":                           dataAzurermSiteRecoveryFabric,
		"azurerm_site_recovery_protection_container":             dataAzurermSiteRecoveryProtectionContainer,
		"azurerm_site_recovery_replication_policy":               dataAzurermSiteRecoveryReplicationPolicy,
		"azurerm_snapshot":                                       placeholder,
		"azurerm_source_control_token":                           placeholder,
		"azurerm_spring_cloud_app":                               dataAzurermSpringCloudApp,
		"azurerm_spring_cloud_service":                           dataAzurermSpringCloudService,
		"azurerm_sql_database":                                   dataAzurermSqlDatabase,
		"azurerm_sql_managed_instance":                           dataAzurermSqlManagedInstance,
		"azurerm_sql_server":                                     dataAzurermSqlServer,
		"azurerm_ssh_public_key":                                 dataAzurermSSHPublicKey,
		"azurerm_stack_hci_cluster":                              dataAzurermStackHCICluster,
		"azurerm_storage_account":                                dataAzurermStorageAccount,
		"azurerm_storage_account_blob_container_sas":             placeholder,
		"azurerm_storage_account_sas":                            placeholder,
		"azurerm_storage_blob":                                   dataAzurermStorageBlob,
		"azurerm_storage_container":                              dataAzurermStorageContainer,
		"azurerm_storage_containers":                             placeholder,
		"azurerm_storage_encryption_scope":                       dataAzurermStorageEncryptionScope,
		"azurerm_storage_management_policy":                      dataAzurermStorageManagementPolicy,
		"azurerm_storage_share":                                  dataAzurermStorageShare,
		"azurerm_storage_sync":                                   dataAzurermStorageSync,
		"azurerm_storage_sync_group":                             dataAzurermStorageSyncGroup,
		"azurerm_storage_table_entity":                           dataAzurermStorageTableEntity,
		"azurerm_stream_analytics_job":                           dataAzurermStreamAnalyticsJob,
		"azurerm_subnet":                                         dataAzurermSubnet,
		"azurerm_subscription":                                   dataAzurermSubscription,
		"azurerm_subscription_template_deployment":               dataAzurermSubscriptionTemplateDeployment,
		"azurerm_subscriptions":                                  placeholder,
		"azurerm_synapse_workspace":                              dataAzurermSynapseWorkspace,
		"azurerm_template_spec_version":                          dataAzurermTemplateSpecVersion,
		"azurerm_tenant_template_deployment":                     dataAzurermTenantTemplateDeployment,
		"azurerm_traffic_manager_geographical_location":          placeholder,
		"azurerm_traffic_manager_profile":                        dataAzurermTrafficManagerProfile,
		"azurerm_user_assigned_identity":                         dataAzurermUserAssignedIdentity,
		"azurerm_virtual_desktop_host_pool":                      dataAzurermVirtualDesktopHostPool,
		"azurerm_virtual_hub":                                    dataAzurermVirtualHub,
		"azurerm_virtual_hub_connection":                         dataAzurermVirtualHubConnection,
		"azurerm_virtual_hub_route_table":                        dataAzurermVirtualHubRouteTable,
		"azurerm_virtual_machine":                                dataAzurermVirtualMachine,
		"azurerm_virtual_machine_scale_set":                      dataAzurermVirtualNetworkScaleSet,
		"azurerm_virtual_network":                                dataAzurermVirtualNetwork,
		"azurerm_virtual_network_gateway":                        dataAzurermVirtualNetworkGateway,
		"azurerm_virtual_network_gateway_connection":             dataAzurermVirtualNetworkGatewayConnection,
		"azurerm_virtual_wan":                                    dataAzurermVirtualWan,
		"azurerm_vmware_private_cloud":                           dataAzurermVmwarePrivateCloud,
		"azurerm_vpn_gateway":                                    dataAzurermVpnGateway,
		"azurerm_web_application_firewall_policy":                dataAzurermWebApplicationFirewallPolicy,
		"azurerm_web_pubsub":                                     dataAzurermWebpubsub,
		"azurerm_web_pubsub_private_link_resource":               placeholder,
		"azurerm_windows_function_app":                           dataAzurermWindowsFunctionApp,
		"azurerm_windows_web_app":                                dataAzurermWindowsWebApp,
		"azurerm_api_management":                                 dataAzurermApiManagement,
		"azurerm_api_management_api":                             dataAzurermApiManagementApi,
		"azurerm_api_management_api_version_set":                 dataAzurermApiManagementVersionSet,
		"azurerm_api_management_gateway":                         dataAzurermApiManagementGateway,
		"azurerm_api_management_gateway_host_name_configuration": dataAzurermApiManagementGatewayHostNameConfiguration,
		"azurerm_api_management_group":                           dataAzurermApiManagementGroup,
		"azurerm_api_management_product":                         dataAzurermApiManagmentProduct,
		"azurerm_api_management_user":                            dataAzurermApiManagementUser,
		"azurerm_app_configuration":                              dataAzurermAppConfiguration,
		"azurerm_app_configuration_key":                          dataAzurermAppConfigurationKey,
		"azurerm_app_configuration_keys":                         dataAzurermAppConfigurationKeys,
		"azurerm_application_gateway":                            dataAzurermApplicationGateway,
		"azurerm_application_insights":                           dataAzurermApplicationInsights,
		"azurerm_application_security_group":                     dataAzurermApplicationSecurityGroup,
		"azurerm_arc_machine":                                    dataAzurermArcMachine,
		"azurerm_automation_account":                             dataAzurermAutomationAccount,
		"azurerm_automation_variable_bool":                       dataAzurermAutomationVariable,
		"azurerm_automation_variable_datetime":                   dataAzurermAutomationVariable,
		"azurerm_automation_variable_int":                        dataAzurermAutomationVariable,
		"azurerm_automation_variable_object":                     dataAzurermAutomationVariable,
		"azurerm_automation_variable_string":                     dataAzurermAutomationVariable,
		"azurerm_automation_variables":                           dataAzurermAutomationVariable,
		"azurerm_availability_set":                               dataAzurermAvailabilitySet,
		"azurerm_backup_policy_file_share":                       dataAzurermBackupPolicyFileShare,
		"azurerm_backup_policy_vm":                               dataAzurermBackupPolicyVm,
		"azurerm_bastion_host":                                   dataAzurermBastionHost,
		"azurerm_batch_account":                                  dataAzurermBatchAccount,
		"azurerm_batch_application":                              dataAzurermBatchApplication,
		"azurerm_batch_certificate":                              dataAzurermBatchCertificate,
		"azurerm_batch_pool":                                     dataAzurermBatchPool,
	}

	return TFLookup[name]
}
