// Copyright (C) 2020 Intel Corporation
// SPDX-License-Identifier: Apache-2.0
//

#pragma once

#include <memory>
#include <ngraph/ngraph.hpp>
#include "layer_transformation.hpp"

namespace ngraph {
namespace pass {
namespace low_precision {

class TRANSFORMATIONS_API EltwiseBaseTransformation : public LayerTransformation {
public:
    EltwiseBaseTransformation(const Params& params) : LayerTransformation(params) {}
    bool canBeTransformed(const TransformationContext& context, std::shared_ptr<Node> layer) const override;
    bool isPrecisionPreserved(std::shared_ptr<Node> layer) const noexcept override;

    static bool isBroadcasted(const Shape& shape) noexcept;
protected:
    int getNotEmpty(const std::shared_ptr<Node>& eltwise) const;
    std::pair<int, int> getMultiplyConstBranch(const std::shared_ptr<Node>& eltwise) const;
};

}  // namespace low_precision
}  // namespace pass
}  // namespace ngraph
