//*****************************************************************************
// Copyright 2017-2020 Intel Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//*****************************************************************************

#pragma once

#include <functional>
#include <string>
#include <unordered_map>

#include "ngraph/node.hpp"
#include "onnx_import/core/node.hpp"

namespace ngraph
{
    namespace onnx_import
    {
        /// \brief      Function which transforms single ONNX operator to nGraph sub-graph.
        using Operator = std::function<OutputVector(const Node&)>;

        /// \brief      Map which contains ONNX operators accessible by std::string value as a key.
        using OperatorSet = std::unordered_map<std::string, std::reference_wrapper<const Operator>>;

    } // namespace onnx_import

} // namespace ngraph
