// Copyright (C) 2018-2020 Intel Corporation
// SPDX-License-Identifier: Apache-2.0
//

#pragma once

#include <memory>

#include <transformations_visibility.hpp>

#include "ngraph/op/op.hpp"

namespace ngraph {
namespace op {

class TRANSFORMATIONS_API ReLUIE : public Op {
public:
    static constexpr NodeTypeInfo type_info{"ReLUIE", 1};
    const NodeTypeInfo& get_type_info() const override { return type_info; }

    ReLUIE(const Output<Node> & data, const float & negative_slope);

    void validate_and_infer_types() override;

    std::shared_ptr<Node> clone_with_new_inputs(const OutputVector& new_args) const override;

    float get_slope() { return m_negative_slope; }

private:
    float m_negative_slope;
};

}  // namespace op
}  // namespace ngraph
