# nGraph Function C++ Sample {#openvino_inference_engine_samples_ngraph_function_creation_sample_README}

This sample demonstrates how to execute an inference using ngraph::Function to create a network. The sample uses the LeNet classifications network as an example.

You do not need an XML file to create a network. The API of ngraph::Function allows to create a network on the fly from the source code. The sample uses one-channel `ubyte` pictures as an input.

## How It Works

Upon the start-up, the sample reads command-line parameters and creates a network using the ngraph::Function API and passed weights file.
Then, the application loads the created network and an image to the Inference Engine core.

When the inference is done, the application outputs inference results to the standard output stream.

> **NOTE**: This sample supports models with FP32 weights only.

The `lenet.bin` weights file was generated by the [Model Optimizer](../../../docs/MO_DG/Deep_Learning_Model_Optimizer_DevGuide.md) 
tool from the public LeNet model with the `--input_shape [64,1,28,28]` parameter specified. 
The original model is available in the [Caffe* repository](https://github.com/BVLC/caffe/tree/master/examples/mnist) on GitHub\*.


> **NOTE**: By default, Inference Engine samples and demos expect input with BGR channels order. If you trained your model to work with RGB order, you need to manually rearrange the default channels order in the sample or demo application or reconvert your model using the Model Optimizer tool with `--reverse_input_channels` argument specified. For more information about the argument, refer to **When to Reverse Input Channels** section of [Converting a Model Using General Conversion Parameters](../../../docs/MO_DG/prepare_model/convert_model/Converting_Model_General.md).

## Running

Running the application with the `-h` option yields the following usage message:
```sh
./ngraph_function_creation_sample -h
[ INFO ] InferenceEngine:
        API version ............ <version>
        Build .................. <number>
        Description ....... API
[ INFO ] Parsing input parameters

ngraph_function_creation_sample [OPTION]
Options:

    -h                      Print a usage message.
    -m "<path>"             Path to a .bin file with weights for the trained model
    -i "<path>"             Required. Path to an image or folder with images
    -d "<device>"           Specify the target device to infer on it. See the list of available devices below. The sample looks for a suitable plugin for the specified device. The default value is CPU.
    -nt "<integer>"         Number of top results. The default value is 10.

Available target devices: <devices>

```

For example, to do inference of an UByte image on a GPU run the following command:
```sh
./ngraph_function_creation_sample -i <path_to_image> -m <path_to_weights_file> -d GPU
```

## Sample Output

By default, the application outputs top-10 inference results for each inference request.

## Deprecation Notice

<table>
  <tr>
    <td><strong>Deprecation Begins</strong></td>
    <td>June 1, 2020</td>
  </tr>
  <tr>
    <td><strong>Removal Date</strong></td>
    <td>December 1, 2020</td>
  </tr>
</table> 

*Starting with the OpenVINO™ toolkit 2020.2 release, all of the features previously available through nGraph have been merged into the OpenVINO™ toolkit. As a result, all the features previously available through ONNX RT Execution Provider for nGraph have been merged with ONNX RT Execution Provider for OpenVINO™ toolkit.*

*Therefore, ONNX RT Execution Provider for nGraph will be deprecated starting June 1, 2020 and will be completely removed on December 1, 2020. Users are recommended to migrate to the ONNX RT Execution Provider for OpenVINO™ toolkit as the unified solution for all AI inferencing on Intel® hardware.*

## See Also

* [Using Inference Engine Samples](../../../docs/IE_DG/Samples_Overview.md)
