# Inference Engine coverage report build {#openvino_docs_Inference_Engine_Development_Procedure_COVERAGE}

The coverage report is generated using Lcov tool and based on profile data generated by GCC.
The generated reports are in HTML form and located in `<dldt_build>/coverage`. The reports are generated for the following components:

1. `inference_engine` - main Inference Engine library
1. `inference_engine_legacy` - legacy Inference Engine library
1. `inference_engine_ir_reader` - Inference Engine IR reader library
1. `low_precision_transformations` - library with Low Precision transformations.
1. `inference_engine_transformations` - Ngraph-based transformation for Inference Engine.
1. `preprocessing` - Inference Engine G-API based preprocessing plugin.
1. Inference Engine open-sources plugins:
    - `hetero_plugin` - Heterogeneous plugin.
    - `multi_device` - Multi device plugin.
    - `cldnn_engine` - GPU plugin.
    - `mkldnn_plugin` - CPU plugin.
    - `gna_plugin` - GNA plugin.

## Build with profiling data support

To build coverage report, compile DLDT with an additional CMake option `-DENABLE_COVERAGE=ON`:

```bash
$ cmake -DENABLE_COVERAGE=ON .
```

And build DLDT as usual.

## Generate coverage report

In order to generate coverage reports, first of all, the tests must be run. Depending on how many tests are run, the better covegare percentage can be achieved. E.g. for `inference_engine` component, `InferenceEngineUnitTests`, `ieUnitTests`, `ieFuncTests` must be run as well as plugin tests.

```bash
$ ctest -V -L IE
```

After sufficient number of tests are executed, the coverage numbers can be calculated. In order to do this, run:

```bash
$ make ie_coverage
```

The following tree of reports are generated:

```bash
$ find coverage/ -maxdepth 2 -name index.html
coverage/hetero_plugin/index.html
coverage/inference_engine/index.html
coverage/inference_engine_ir_reader/index.html
coverage/inference_engine_legacy/index.html
coverage/low_precision_transformations/index.html
coverage/mkldnn_plugin/index.html
coverage/multi_device/index.html
coverage/preprocessing/index.html
coverage/inference_engine_transformations/index.html
coverage/gna_plugin/index.html
coverage/cldnn_engine/index.html
```