---
name: Bug
about: Create a report to help us improve
title: "[Bug]"
labels: bug, support_request
assignees: ''

---

##### System information (version)
<!-- Example
- OpenVINO => 2020.4
- Operating System / Platform => Windows 64 Bit
- Compiler => Visual Studio 2017
- Problem classification: Model Conversion
- Framework: TensorFlow (if applicable)
- Model name: ResNet50 (if applicable)
-->

- OpenVINO=> :grey_question:
- Operating System / Platform => :grey_question:
- Compiler => :grey_question:
- Problem classification => :grey_question:

##### Detailed description
<!-- your description -->

##### Steps to reproduce

<!--
   Describe your problem and steps you've done before you got to this point.    
   to add code example fence it with triple backticks and optional file extension
    ```.cpp
    // C++ code example
    ```
 or attach as .txt or .zip file
-->

##### Issue submission checklist

 - [ ] I report the issue, it's not a question
   <!--
   OpenVINO team works with support forum, Stack Overflow and other communities
   to discuss problems. Tickets with question without real issue statement will be
   closed.
   -->
 - [ ] I checked the problem with documentation, FAQ, open issues, Stack Overflow, etc and have not found solution
   <!--
   Places to check:
   * OpenVINO documentation: https://docs.openvinotoolkit.org/
   * OpenVINO forum: https://community.intel.com/t5/Intel-Distribution-of-OpenVINO/bd-p/distribution-openvino-toolkit
   * OpenVINO issue tracker: https://github.com/openvinotoolkit/openvino/issues?q=is%3Aissue
   * Stack Overflow branch: https://stackoverflow.com/questions/tagged/openvino
   -->
 - [ ] There is reproducer code and related data files: images, videos, models, etc.
   <!--
   The best reproducer -- test case for OpenVINO that we can add to the library.
   -->
