// Copyright (C) 2018-2020 Intel Corporation
// SPDX-License-Identifier: Apache-2.0
//

#pragma once

#include <string>

#include <vpu/vpu_plugin_config.hpp>

namespace InferenceEngine {
namespace VPUConfigParams {

//
// Compilation options
//

DECLARE_VPU_CONFIG_KEY(NUMBER_OF_SHAVES);
DECLARE_VPU_CONFIG_KEY(NUMBER_OF_CMX_SLICES);

DECLARE_VPU_CONFIG_KEY(TENSOR_STRIDES);

DECLARE_VPU_CONFIG_KEY(IR_WITH_SCALES_DIRECTORY);
DECLARE_VPU_CONFIG_KEY(DETECT_NETWORK_BATCH);
DECLARE_VPU_CONFIG_KEY(COPY_OPTIMIZATION);
DECLARE_VPU_CONFIG_KEY(HW_INJECT_STAGES);
DECLARE_VPU_CONFIG_KEY(HW_POOL_CONV_MERGE);
DECLARE_VPU_CONFIG_KEY(PACK_DATA_IN_CMX);
DECLARE_VPU_CONFIG_KEY(HW_DILATION);
DECLARE_VPU_CONFIG_KEY(FORCE_DEPRECATED_CNN_CONVERSION);

DECLARE_VPU_CONFIG_KEY(PERF_REPORT_MODE);
DECLARE_VPU_CONFIG_VALUE(PER_LAYER);
DECLARE_VPU_CONFIG_VALUE(PER_STAGE);

//
// Debug options
//

DECLARE_VPU_CONFIG_KEY(HW_WHITE_LIST);
DECLARE_VPU_CONFIG_KEY(HW_BLACK_LIST);

DECLARE_VPU_CONFIG_KEY(NONE_LAYERS);
DECLARE_VPU_CONFIG_KEY(IGNORE_UNKNOWN_LAYERS);

DECLARE_VPU_CONFIG_KEY(COMPILER_LOG_FILE_PATH);

DECLARE_VPU_CONFIG_KEY(DUMP_INTERNAL_GRAPH_FILE_NAME);
DECLARE_VPU_CONFIG_KEY(DUMP_INTERNAL_GRAPH_DIRECTORY);
DECLARE_VPU_CONFIG_KEY(DUMP_ALL_PASSES);

/**
 * @brief Used to disable reorder passes in tests to be able to precisely set
 * desired layout on every stage.
 */
DECLARE_VPU_CONFIG_KEY(DISABLE_REORDER);

/**
 * @brief Used to disable permute merging pass (with setting "NO") in tests to check it preserves behaviour. Default = "YES"
 */
DECLARE_VPU_CONFIG_KEY(ENABLE_PERMUTE_MERGING);

DECLARE_VPU_CONFIG_KEY(ENABLE_REPL_WITH_SCRELU);

DECLARE_VPU_CONFIG_KEY(ENABLE_REPLACE_WITH_REDUCE_MEAN);

//
// Myriad plugin options
//

DECLARE_VPU_MYRIAD_CONFIG_KEY(POWER_MANAGEMENT);
DECLARE_VPU_MYRIAD_CONFIG_VALUE(POWER_FULL);
DECLARE_VPU_MYRIAD_CONFIG_VALUE(POWER_INFER);
DECLARE_VPU_MYRIAD_CONFIG_VALUE(POWER_STAGE);
DECLARE_VPU_MYRIAD_CONFIG_VALUE(POWER_STAGE_SHAVES);
DECLARE_VPU_MYRIAD_CONFIG_VALUE(POWER_STAGE_NCES);

DECLARE_VPU_MYRIAD_CONFIG_KEY(THROUGHPUT_STREAMS);

DECLARE_VPU_MYRIAD_CONFIG_KEY(WATCHDOG);

DECLARE_VPU_MYRIAD_CONFIG_KEY(PLUGIN_LOG_FILE_PATH);

DECLARE_VPU_MYRIAD_CONFIG_KEY(DEVICE_CONNECT_TIMEOUT);

}  // namespace VPUConfigParams
}  // namespace InferenceEngine
