# OS

| OS             | Source                                                                              |
| ---------------| ---------------------------------------- |
| Arch Linux     | [Vulnerable Issues][arch]                |
| Alpine Linux   | [secdb][alpine]                          |
| Amazon Linux 1 | [Amazon Linux Security Center][amazon1]  |
| Amazon Linux 2 | [Amazon Linux Security Center][amazon2]  |
| Debian         | [Security Bug Tracker][debian-tracker]   |
|                | [OVAL][debian-oval]                      |
| Ubuntu         | [Ubuntu CVE Tracker][ubuntu]             |
| RHEL/CentOS    | [OVAL][rhel-oval]                        |
|                | [Security Data][rhel-api]                |
| Oracle Linux   | [OVAL][oracle]                           |
| OpenSUSE/SLES	 | [CVRF][suse]                             |
| Photon OS      | [Photon Security Advisory][photon]       |

# Programming Language

| Language                     | Source                                           | Commercial Use  | Delay[^1]|
| ---------------------------- | -------------------------------------------------|:---------------:|:--------:|
| PHP                          | [PHP Security Advisories Database][php]          | ✅              | -        |
|                              | [GitHub Advisory Database (Composer)][php-ghsa]  | ✅              | -        |
| Python                       | [Safety DB][python]                              | ❌              | 1 month  |
|                              | [GitHub Advisory Database (pip)][python-ghsa]    | ✅              | -        |
| Ruby                         | [Ruby Advisory Database][ruby]                   | ✅              | -        |
|                              | [GitHub Advisory Database (RubyGems)][ruby-ghsa] | ✅              | -        |
| Node.js                      | [Ecosystem Security Working Group][nodejs]       | ✅              | -        |
|                              | [GitHub Advisory Database (npm)][nodejs-ghsa]    | ✅              | -        |
| Java                         | [GitLab Advisories Community][gitlab]            | ✅              | 1 month  |
|                              | [GitHub Advisory Database (Maven)][java-ghsa]    | ✅              | -        |
| Go                           | [GitLab Advisories Community][gitlab]            | ✅              | 1 month  |
|                              | [The Go Vulnerability Database][go]              | ✅              | -        |
| Rust                         | [RustSec Advisory Database][rust]                | ✅              | -        |
| .NET                         | [GitHub Advisory Database (NuGet)][dotnet-ghsa]  | ✅              | -        |

[^1]: Intentional delay between vulnerability disclosure and registration in the DB

# Others

| Name                            | Source     |  
| --------------------------------|------------|
| National Vulnerability Database | [NVD][nvd] | 

[arch]: https://security.archlinux.org/
[alpine]: https://secdb.alpinelinux.org/
[amazon1]: https://alas.aws.amazon.com/
[amazon2]: https://alas.aws.amazon.com/alas2.html
[debian-tracker]: https://security-tracker.debian.org/tracker/
[debian-oval]: https://www.debian.org/security/oval/
[ubuntu]: https://ubuntu.com/security/cve
[rhel-oval]: https://www.redhat.com/security/data/oval/v2/
[rhel-api]: https://www.redhat.com/security/data/metrics/
[oracle]: https://linux.oracle.com/security/oval/
[suse]: http://ftp.suse.com/pub/projects/security/cvrf/
[photon]: https://packages.vmware.com/photon/photon_cve_metadata/

[php-ghsa]: https://github.com/advisories?query=ecosystem%3Acomposer
[python-ghsa]: https://github.com/advisories?query=ecosystem%3Apip
[ruby-ghsa]: https://github.com/advisories?query=ecosystem%3Arubygems
[nodejs-ghsa]: https://github.com/advisories?query=ecosystem%3Anpm
[java-ghsa]: https://github.com/advisories?query=ecosystem%3Amaven
[dotnet-ghsa]: https://github.com/advisories?query=ecosystem%3Anuget

[php]: https://github.com/FriendsOfPHP/security-advisories
[python]: https://github.com/pyupio/safety-db
[ruby]: https://github.com/rubysec/ruby-advisory-db
[nodejs]: https://github.com/nodejs/security-wg
[gitlab]: https://gitlab.com/gitlab-org/advisories-community
[go]: https://github.com/golang/vulndb
[rust]: (https://github.com/RustSec/advisory-db)

[nvd]: https://nvd.nist.gov/
