const { join } = require('path');

const { settings, env } = require('../configuration');

module.exports = {
  test: /\.(js|mjs)$/,
  include: /node_modules/,
  exclude: [
    /@babel(?:\/|\\{1,2})runtime/,
    /tesseract.js/,
  ],
  use: [
    {
      loader: 'babel-loader',
      options: {
        babelrc: false,
        plugins: [
          'transform-react-remove-prop-types',
        ],
        cacheDirectory: join(settings.cache_path, 'babel-loader-node-modules'),
        cacheCompression: env.NODE_ENV === 'production',
        compact: false,
        sourceMaps: false,
      },
    },
  ],
};
