/*
  File autogenerated by gengetopt version 2.22.5
  generated with the following command:
  gengetopt -i imagetag.ggo -f imagetag_cmdline --file-name=imagetag_cmdline

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include <getopt.h>

#include "imagetag_cmdline.h"

const char *gengetopt_args_info_purpose = "Generate image with CFE imagetag for Broadcom 63xx routers.";

const char *gengetopt_args_info_usage = "Usage: imagetag [OPTIONS]...";

const char *gengetopt_args_info_description = "Copyright (C) 2008 Axel Gembe\nCopyright (C) 2009-2010 Daniel Dickinson\nLicensed unter the terms of the Gnu General Public License.\n\nGiven a root filesystem, a linux kernel, and an optional CFE, generates an \nimage with an imagetag for a Broadcom 63xx-based router.  Additional parameters \nto be specified depend on the specfic brand and model of router.";

const char *gengetopt_args_info_help[] = {
  "  -h, --help                    Print help and exit",
  "  -V, --version                 Print version and exit",
  "  -i, --kernel=filename         File with LZMA compressed kernel to include in \n                                  the image.",
  "  -f, --rootfs=filename         File with RootFS to include in the image.",
  "  -o, --output=filename         Name of output file.",
  "      --cfe=filename            File with CFE to include in the image.",
  "  -b, --boardid=STRING          Board ID to set in the image (must match what \n                                  router expects, e.g. \"96345GW2\").",
  "  -c, --chipid=STRING           Chip ID to set in the image (must match the \n                                  actual hardware, e.g. \"6345\").",
  "  -s, --flash-start=address     Flash start address.  (default=`0xBFC00000')",
  "  -n, --image-offset=offset     Offset from start address for the first byte \n                                  after the CFE (in memory).  \n                                  (default=`0x10000')",
  "  -v, --tag-version=STRING      Version number for imagetag format.  \n                                  (default=`6')",
  "  -a, --signature=STRING        Magic string (signature), for boards that need \n                                  it.  (default=`Broadcom Corporatio')",
  "  -m, --signature2=STRING       Second magic string (signature2).  \n                                  (default=`ver. 2.0')",
  "  -k, --block-size=STRING       Flash erase block size.  (default=`0x10000')",
  "  -l, --load-addr=address       Kernel load address.",
  "  -e, --entry=address           Address where the kernel entry point will be \n                                  for booting.",
  "  -y, --layoutver=STRING        Flash layout version (version 2.2x of the \n                                  Broadcom code requires this).",
  "  -1, --info1=STRING            String for first vendor information section.",
  "      --altinfo=STRING          String for vendor information section \n                                  (alternate/pirelli).",
  "  -2, --info2=STRING            String for second vendor information section.",
  "      --root-first              Put the rootfs before the kernel (only for \n                                  stock images, e.g. captured from the router's \n                                  flash memory).  (default=off)",
  "  -r, --rsa-signature=STRING    String for RSA Signature section.",
  "      --second-image-flag=flag-value\n                                Dual Image Flag (2=not-specified).  (possible \n                                  values=\"0\", \"1\", \"2\" default=`2')",
  "      --inactive=flag-value     Inactive Flag (2=not-specified).  (possible \n                                  values=\"0\", \"1\", \"2\" default=`2')",
  "      --reserved2=STRING        String for second reserved section.",
  "      --kernel-file-has-header  Indicates that the kernel file includes the \n                                  kernel header with correct load address and \n                                  entry point, so no changes are needed  \n                                  (default=off)",
  "  -p, --pad=size (in MiB)       Pad the image to this size if smaller (in MiB)",
  "      --align-rootfs            Align the rootfs start to erase block size  \n                                  (default=off)",
    0
};

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
  , ARG_INT
} imagetag_cmdline_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
imagetag_cmdline_internal (int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct imagetag_cmdline_params *params, const char *additional_error);

static int
imagetag_cmdline_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error);

const char *imagetag_cmdline_second_image_flag_values[] = {"0", "1", "2", 0}; /*< Possible values for second-image-flag. */
const char *imagetag_cmdline_inactive_values[] = {"0", "1", "2", 0}; /*< Possible values for inactive. */

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->kernel_given = 0 ;
  args_info->rootfs_given = 0 ;
  args_info->output_given = 0 ;
  args_info->cfe_given = 0 ;
  args_info->boardid_given = 0 ;
  args_info->chipid_given = 0 ;
  args_info->flash_start_given = 0 ;
  args_info->image_offset_given = 0 ;
  args_info->tag_version_given = 0 ;
  args_info->signature_given = 0 ;
  args_info->signature2_given = 0 ;
  args_info->block_size_given = 0 ;
  args_info->load_addr_given = 0 ;
  args_info->entry_given = 0 ;
  args_info->layoutver_given = 0 ;
  args_info->info1_given = 0 ;
  args_info->altinfo_given = 0 ;
  args_info->info2_given = 0 ;
  args_info->root_first_given = 0 ;
  args_info->rsa_signature_given = 0 ;
  args_info->second_image_flag_given = 0 ;
  args_info->inactive_given = 0 ;
  args_info->reserved2_given = 0 ;
  args_info->kernel_file_has_header_given = 0 ;
  args_info->pad_given = 0 ;
  args_info->align_rootfs_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->kernel_arg = NULL;
  args_info->kernel_orig = NULL;
  args_info->rootfs_arg = NULL;
  args_info->rootfs_orig = NULL;
  args_info->output_arg = NULL;
  args_info->output_orig = NULL;
  args_info->cfe_arg = NULL;
  args_info->cfe_orig = NULL;
  args_info->boardid_arg = NULL;
  args_info->boardid_orig = NULL;
  args_info->chipid_arg = NULL;
  args_info->chipid_orig = NULL;
  args_info->flash_start_arg = gengetopt_strdup ("0xBFC00000");
  args_info->flash_start_orig = NULL;
  args_info->image_offset_arg = gengetopt_strdup ("0x10000");
  args_info->image_offset_orig = NULL;
  args_info->tag_version_arg = gengetopt_strdup ("6");
  args_info->tag_version_orig = NULL;
  args_info->signature_arg = gengetopt_strdup ("Broadcom Corporatio");
  args_info->signature_orig = NULL;
  args_info->signature2_arg = gengetopt_strdup ("ver. 2.0");
  args_info->signature2_orig = NULL;
  args_info->block_size_arg = gengetopt_strdup ("0x10000");
  args_info->block_size_orig = NULL;
  args_info->load_addr_arg = NULL;
  args_info->load_addr_orig = NULL;
  args_info->entry_arg = NULL;
  args_info->entry_orig = NULL;
  args_info->layoutver_arg = NULL;
  args_info->layoutver_orig = NULL;
  args_info->info1_arg = NULL;
  args_info->info1_orig = NULL;
  args_info->altinfo_arg = NULL;
  args_info->altinfo_orig = NULL;
  args_info->info2_arg = NULL;
  args_info->info2_orig = NULL;
  args_info->root_first_flag = 0;
  args_info->rsa_signature_arg = NULL;
  args_info->rsa_signature_orig = NULL;
  args_info->second_image_flag_arg = gengetopt_strdup ("2");
  args_info->second_image_flag_orig = NULL;
  args_info->inactive_arg = gengetopt_strdup ("2");
  args_info->inactive_orig = NULL;
  args_info->reserved2_arg = NULL;
  args_info->reserved2_orig = NULL;
  args_info->kernel_file_has_header_flag = 0;
  args_info->pad_orig = NULL;
  args_info->align_rootfs_flag = 0;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{


  args_info->help_help = gengetopt_args_info_help[0] ;
  args_info->version_help = gengetopt_args_info_help[1] ;
  args_info->kernel_help = gengetopt_args_info_help[2] ;
  args_info->rootfs_help = gengetopt_args_info_help[3] ;
  args_info->output_help = gengetopt_args_info_help[4] ;
  args_info->cfe_help = gengetopt_args_info_help[5] ;
  args_info->boardid_help = gengetopt_args_info_help[6] ;
  args_info->chipid_help = gengetopt_args_info_help[7] ;
  args_info->flash_start_help = gengetopt_args_info_help[8] ;
  args_info->image_offset_help = gengetopt_args_info_help[9] ;
  args_info->tag_version_help = gengetopt_args_info_help[10] ;
  args_info->signature_help = gengetopt_args_info_help[11] ;
  args_info->signature2_help = gengetopt_args_info_help[12] ;
  args_info->block_size_help = gengetopt_args_info_help[13] ;
  args_info->load_addr_help = gengetopt_args_info_help[14] ;
  args_info->entry_help = gengetopt_args_info_help[15] ;
  args_info->layoutver_help = gengetopt_args_info_help[16] ;
  args_info->info1_help = gengetopt_args_info_help[17] ;
  args_info->altinfo_help = gengetopt_args_info_help[18] ;
  args_info->info2_help = gengetopt_args_info_help[19] ;
  args_info->root_first_help = gengetopt_args_info_help[20] ;
  args_info->rsa_signature_help = gengetopt_args_info_help[21] ;
  args_info->second_image_flag_help = gengetopt_args_info_help[22] ;
  args_info->inactive_help = gengetopt_args_info_help[23] ;
  args_info->reserved2_help = gengetopt_args_info_help[24] ;
  args_info->kernel_file_has_header_help = gengetopt_args_info_help[25] ;
  args_info->pad_help = gengetopt_args_info_help[26] ;
  args_info->align_rootfs_help = gengetopt_args_info_help[27] ;
  
}

void
imagetag_cmdline_print_version (void)
{
  printf ("%s %s\n",
     (strlen(IMAGETAG_CMDLINE_PACKAGE_NAME) ? IMAGETAG_CMDLINE_PACKAGE_NAME : IMAGETAG_CMDLINE_PACKAGE),
     IMAGETAG_CMDLINE_VERSION);
}

static void print_help_common(void) {
  imagetag_cmdline_print_version ();

  if (strlen(gengetopt_args_info_purpose) > 0)
    printf("\n%s\n", gengetopt_args_info_purpose);

  if (strlen(gengetopt_args_info_usage) > 0)
    printf("\n%s\n", gengetopt_args_info_usage);

  printf("\n");

  if (strlen(gengetopt_args_info_description) > 0)
    printf("%s\n\n", gengetopt_args_info_description);
}

void
imagetag_cmdline_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
imagetag_cmdline_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
imagetag_cmdline_params_init(struct imagetag_cmdline_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct imagetag_cmdline_params *
imagetag_cmdline_params_create(void)
{
  struct imagetag_cmdline_params *params = 
    (struct imagetag_cmdline_params *)malloc(sizeof(struct imagetag_cmdline_params));
  imagetag_cmdline_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
imagetag_cmdline_release (struct gengetopt_args_info *args_info)
{

  free_string_field (&(args_info->kernel_arg));
  free_string_field (&(args_info->kernel_orig));
  free_string_field (&(args_info->rootfs_arg));
  free_string_field (&(args_info->rootfs_orig));
  free_string_field (&(args_info->output_arg));
  free_string_field (&(args_info->output_orig));
  free_string_field (&(args_info->cfe_arg));
  free_string_field (&(args_info->cfe_orig));
  free_string_field (&(args_info->boardid_arg));
  free_string_field (&(args_info->boardid_orig));
  free_string_field (&(args_info->chipid_arg));
  free_string_field (&(args_info->chipid_orig));
  free_string_field (&(args_info->flash_start_arg));
  free_string_field (&(args_info->flash_start_orig));
  free_string_field (&(args_info->image_offset_arg));
  free_string_field (&(args_info->image_offset_orig));
  free_string_field (&(args_info->tag_version_arg));
  free_string_field (&(args_info->tag_version_orig));
  free_string_field (&(args_info->signature_arg));
  free_string_field (&(args_info->signature_orig));
  free_string_field (&(args_info->signature2_arg));
  free_string_field (&(args_info->signature2_orig));
  free_string_field (&(args_info->block_size_arg));
  free_string_field (&(args_info->block_size_orig));
  free_string_field (&(args_info->load_addr_arg));
  free_string_field (&(args_info->load_addr_orig));
  free_string_field (&(args_info->entry_arg));
  free_string_field (&(args_info->entry_orig));
  free_string_field (&(args_info->layoutver_arg));
  free_string_field (&(args_info->layoutver_orig));
  free_string_field (&(args_info->info1_arg));
  free_string_field (&(args_info->info1_orig));
  free_string_field (&(args_info->altinfo_arg));
  free_string_field (&(args_info->altinfo_orig));
  free_string_field (&(args_info->info2_arg));
  free_string_field (&(args_info->info2_orig));
  free_string_field (&(args_info->rsa_signature_arg));
  free_string_field (&(args_info->rsa_signature_orig));
  free_string_field (&(args_info->second_image_flag_arg));
  free_string_field (&(args_info->second_image_flag_orig));
  free_string_field (&(args_info->inactive_arg));
  free_string_field (&(args_info->inactive_orig));
  free_string_field (&(args_info->reserved2_arg));
  free_string_field (&(args_info->reserved2_orig));
  free_string_field (&(args_info->pad_orig));
  
  

  clear_given (args_info);
}

/**
 * @param val the value to check
 * @param values the possible values
 * @return the index of the matched value:
 * -1 if no value matched,
 * -2 if more than one value has matched
 */
static int
check_possible_values(const char *val, const char *values[])
{
  int i, found, last;
  size_t len;

  if (!val)   /* otherwise strlen() crashes below */
    return -1; /* -1 means no argument for the option */

  found = last = 0;

  for (i = 0, len = strlen(val); values[i]; ++i)
    {
      if (strncmp(val, values[i], len) == 0)
        {
          ++found;
          last = i;
          if (strlen(values[i]) == len)
            return i; /* exact macth no need to check more */
        }
    }

  if (found == 1) /* one match: OK */
    return last;

  return (found ? -2 : -1); /* return many values or none matched */
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  int found = -1;
  if (arg) {
    if (values) {
      found = check_possible_values(arg, values);      
    }
    if (found >= 0)
      fprintf(outfile, "%s=\"%s\" # %s\n", opt, arg, values[found]);
    else
      fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}


int
imagetag_cmdline_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", IMAGETAG_CMDLINE_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->kernel_given)
    write_into_file(outfile, "kernel", args_info->kernel_orig, 0);
  if (args_info->rootfs_given)
    write_into_file(outfile, "rootfs", args_info->rootfs_orig, 0);
  if (args_info->output_given)
    write_into_file(outfile, "output", args_info->output_orig, 0);
  if (args_info->cfe_given)
    write_into_file(outfile, "cfe", args_info->cfe_orig, 0);
  if (args_info->boardid_given)
    write_into_file(outfile, "boardid", args_info->boardid_orig, 0);
  if (args_info->chipid_given)
    write_into_file(outfile, "chipid", args_info->chipid_orig, 0);
  if (args_info->flash_start_given)
    write_into_file(outfile, "flash-start", args_info->flash_start_orig, 0);
  if (args_info->image_offset_given)
    write_into_file(outfile, "image-offset", args_info->image_offset_orig, 0);
  if (args_info->tag_version_given)
    write_into_file(outfile, "tag-version", args_info->tag_version_orig, 0);
  if (args_info->signature_given)
    write_into_file(outfile, "signature", args_info->signature_orig, 0);
  if (args_info->signature2_given)
    write_into_file(outfile, "signature2", args_info->signature2_orig, 0);
  if (args_info->block_size_given)
    write_into_file(outfile, "block-size", args_info->block_size_orig, 0);
  if (args_info->load_addr_given)
    write_into_file(outfile, "load-addr", args_info->load_addr_orig, 0);
  if (args_info->entry_given)
    write_into_file(outfile, "entry", args_info->entry_orig, 0);
  if (args_info->layoutver_given)
    write_into_file(outfile, "layoutver", args_info->layoutver_orig, 0);
  if (args_info->info1_given)
    write_into_file(outfile, "info1", args_info->info1_orig, 0);
  if (args_info->altinfo_given)
    write_into_file(outfile, "altinfo", args_info->altinfo_orig, 0);
  if (args_info->info2_given)
    write_into_file(outfile, "info2", args_info->info2_orig, 0);
  if (args_info->root_first_given)
    write_into_file(outfile, "root-first", 0, 0 );
  if (args_info->rsa_signature_given)
    write_into_file(outfile, "rsa-signature", args_info->rsa_signature_orig, 0);
  if (args_info->second_image_flag_given)
    write_into_file(outfile, "second-image-flag", args_info->second_image_flag_orig, imagetag_cmdline_second_image_flag_values);
  if (args_info->inactive_given)
    write_into_file(outfile, "inactive", args_info->inactive_orig, imagetag_cmdline_inactive_values);
  if (args_info->reserved2_given)
    write_into_file(outfile, "reserved2", args_info->reserved2_orig, 0);
  if (args_info->kernel_file_has_header_given)
    write_into_file(outfile, "kernel-file-has-header", 0, 0 );
  if (args_info->pad_given)
    write_into_file(outfile, "pad", args_info->pad_orig, 0);
  if (args_info->align_rootfs_given)
    write_into_file(outfile, "align-rootfs", 0, 0 );
  

  i = EXIT_SUCCESS;
  return i;
}

int
imagetag_cmdline_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", IMAGETAG_CMDLINE_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = imagetag_cmdline_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
imagetag_cmdline_free (struct gengetopt_args_info *args_info)
{
  imagetag_cmdline_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
imagetag_cmdline (int argc, char **argv, struct gengetopt_args_info *args_info)
{
  return imagetag_cmdline2 (argc, argv, args_info, 0, 1, 1);
}

int
imagetag_cmdline_ext (int argc, char **argv, struct gengetopt_args_info *args_info,
                   struct imagetag_cmdline_params *params)
{
  int result;
  result = imagetag_cmdline_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      imagetag_cmdline_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
imagetag_cmdline2 (int argc, char **argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct imagetag_cmdline_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = imagetag_cmdline_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      imagetag_cmdline_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
imagetag_cmdline_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (imagetag_cmdline_required2(args_info, prog_name, 0) > 0)
    result = EXIT_FAILURE;

  if (result == EXIT_FAILURE)
    {
      imagetag_cmdline_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
imagetag_cmdline_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error = 0;
  FIX_UNUSED (additional_error);

  /* checks for required options */
  if (! args_info->kernel_given)
    {
      fprintf (stderr, "%s: '--kernel' ('-i') option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  
  if (! args_info->rootfs_given)
    {
      fprintf (stderr, "%s: '--rootfs' ('-f') option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  
  if (! args_info->output_given)
    {
      fprintf (stderr, "%s: '--output' ('-o') option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  
  if (! args_info->boardid_given)
    {
      fprintf (stderr, "%s: '--boardid' ('-b') option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  
  if (! args_info->chipid_given)
    {
      fprintf (stderr, "%s: '--chipid' ('-c') option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  
  if (! args_info->load_addr_given)
    {
      fprintf (stderr, "%s: '--load-addr' ('-l') option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  
  if (! args_info->entry_given)
    {
      fprintf (stderr, "%s: '--entry' ('-e') option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  
  
  /* checks for dependences among options */

  return error;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see imagetag_cmdline_params.check_ambiguity
 * @param override @see imagetag_cmdline_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               imagetag_cmdline_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  if (possible_values && (found = check_possible_values((value ? value : default_value), possible_values)) < 0)
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s' (`-%c')%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt, short_opt,
          (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s'%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt,
          (additional_error ? additional_error : ""));
      return 1; /* failure */
    }
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


int
imagetag_cmdline_internal (
  int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct imagetag_cmdline_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    imagetag_cmdline_init (args_info);

  imagetag_cmdline_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "kernel",	1, NULL, 'i' },
        { "rootfs",	1, NULL, 'f' },
        { "output",	1, NULL, 'o' },
        { "cfe",	1, NULL, 0 },
        { "boardid",	1, NULL, 'b' },
        { "chipid",	1, NULL, 'c' },
        { "flash-start",	1, NULL, 's' },
        { "image-offset",	1, NULL, 'n' },
        { "tag-version",	1, NULL, 'v' },
        { "signature",	1, NULL, 'a' },
        { "signature2",	1, NULL, 'm' },
        { "block-size",	1, NULL, 'k' },
        { "load-addr",	1, NULL, 'l' },
        { "entry",	1, NULL, 'e' },
        { "layoutver",	1, NULL, 'y' },
        { "info1",	1, NULL, '1' },
        { "altinfo",	1, NULL, 0 },
        { "info2",	1, NULL, '2' },
        { "root-first",	0, NULL, 0 },
        { "rsa-signature",	1, NULL, 'r' },
        { "second-image-flag",	1, NULL, 0 },
        { "inactive",	1, NULL, 0 },
        { "reserved2",	1, NULL, 0 },
        { "kernel-file-has-header",	0, NULL, 0 },
        { "pad",	1, NULL, 'p' },
        { "align-rootfs",	0, NULL, 0 },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hVi:f:o:b:c:s:n:v:a:m:k:l:e:y:1:2:r:p:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          imagetag_cmdline_print_help ();
          imagetag_cmdline_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          imagetag_cmdline_print_version ();
          imagetag_cmdline_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'i':	/* File with LZMA compressed kernel to include in the image..  */
        
        
          if (update_arg( (void *)&(args_info->kernel_arg), 
               &(args_info->kernel_orig), &(args_info->kernel_given),
              &(local_args_info.kernel_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "kernel", 'i',
              additional_error))
            goto failure;
        
          break;
        case 'f':	/* File with RootFS to include in the image..  */
        
        
          if (update_arg( (void *)&(args_info->rootfs_arg), 
               &(args_info->rootfs_orig), &(args_info->rootfs_given),
              &(local_args_info.rootfs_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "rootfs", 'f',
              additional_error))
            goto failure;
        
          break;
        case 'o':	/* Name of output file..  */
        
        
          if (update_arg( (void *)&(args_info->output_arg), 
               &(args_info->output_orig), &(args_info->output_given),
              &(local_args_info.output_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "output", 'o',
              additional_error))
            goto failure;
        
          break;
        case 'b':	/* Board ID to set in the image (must match what router expects, e.g. \"96345GW2\")..  */
        
        
          if (update_arg( (void *)&(args_info->boardid_arg), 
               &(args_info->boardid_orig), &(args_info->boardid_given),
              &(local_args_info.boardid_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "boardid", 'b',
              additional_error))
            goto failure;
        
          break;
        case 'c':	/* Chip ID to set in the image (must match the actual hardware, e.g. \"6345\")..  */
        
        
          if (update_arg( (void *)&(args_info->chipid_arg), 
               &(args_info->chipid_orig), &(args_info->chipid_given),
              &(local_args_info.chipid_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "chipid", 'c',
              additional_error))
            goto failure;
        
          break;
        case 's':	/* Flash start address..  */
        
        
          if (update_arg( (void *)&(args_info->flash_start_arg), 
               &(args_info->flash_start_orig), &(args_info->flash_start_given),
              &(local_args_info.flash_start_given), optarg, 0, "0xBFC00000", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "flash-start", 's',
              additional_error))
            goto failure;
        
          break;
        case 'n':	/* Offset from start address for the first byte after the CFE (in memory)..  */
        
        
          if (update_arg( (void *)&(args_info->image_offset_arg), 
               &(args_info->image_offset_orig), &(args_info->image_offset_given),
              &(local_args_info.image_offset_given), optarg, 0, "0x10000", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "image-offset", 'n',
              additional_error))
            goto failure;
        
          break;
        case 'v':	/* Version number for imagetag format..  */
        
        
          if (update_arg( (void *)&(args_info->tag_version_arg), 
               &(args_info->tag_version_orig), &(args_info->tag_version_given),
              &(local_args_info.tag_version_given), optarg, 0, "6", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "tag-version", 'v',
              additional_error))
            goto failure;
        
          break;
        case 'a':	/* Magic string (signature), for boards that need it..  */
        
        
          if (update_arg( (void *)&(args_info->signature_arg), 
               &(args_info->signature_orig), &(args_info->signature_given),
              &(local_args_info.signature_given), optarg, 0, "Broadcom Corporatio", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "signature", 'a',
              additional_error))
            goto failure;
        
          break;
        case 'm':	/* Second magic string (signature2)..  */
        
        
          if (update_arg( (void *)&(args_info->signature2_arg), 
               &(args_info->signature2_orig), &(args_info->signature2_given),
              &(local_args_info.signature2_given), optarg, 0, "ver. 2.0", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "signature2", 'm',
              additional_error))
            goto failure;
        
          break;
        case 'k':	/* Flash erase block size..  */
        
        
          if (update_arg( (void *)&(args_info->block_size_arg), 
               &(args_info->block_size_orig), &(args_info->block_size_given),
              &(local_args_info.block_size_given), optarg, 0, "0x10000", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "block-size", 'k',
              additional_error))
            goto failure;
        
          break;
        case 'l':	/* Kernel load address..  */
        
        
          if (update_arg( (void *)&(args_info->load_addr_arg), 
               &(args_info->load_addr_orig), &(args_info->load_addr_given),
              &(local_args_info.load_addr_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "load-addr", 'l',
              additional_error))
            goto failure;
        
          break;
        case 'e':	/* Address where the kernel entry point will be for booting..  */
        
        
          if (update_arg( (void *)&(args_info->entry_arg), 
               &(args_info->entry_orig), &(args_info->entry_given),
              &(local_args_info.entry_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "entry", 'e',
              additional_error))
            goto failure;
        
          break;
        case 'y':	/* Flash layout version (version 2.2x of the Broadcom code requires this)..  */
        
        
          if (update_arg( (void *)&(args_info->layoutver_arg), 
               &(args_info->layoutver_orig), &(args_info->layoutver_given),
              &(local_args_info.layoutver_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "layoutver", 'y',
              additional_error))
            goto failure;
        
          break;
        case '1':	/* String for first vendor information section..  */
        
        
          if (update_arg( (void *)&(args_info->info1_arg), 
               &(args_info->info1_orig), &(args_info->info1_given),
              &(local_args_info.info1_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "info1", '1',
              additional_error))
            goto failure;
        
          break;
        case '2':	/* String for second vendor information section..  */
        
        
          if (update_arg( (void *)&(args_info->info2_arg), 
               &(args_info->info2_orig), &(args_info->info2_given),
              &(local_args_info.info2_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "info2", '2',
              additional_error))
            goto failure;
        
          break;
        case 'r':	/* String for RSA Signature section..  */
        
        
          if (update_arg( (void *)&(args_info->rsa_signature_arg), 
               &(args_info->rsa_signature_orig), &(args_info->rsa_signature_given),
              &(local_args_info.rsa_signature_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "rsa-signature", 'r',
              additional_error))
            goto failure;
        
          break;
        case 'p':	/* Pad the image to this size if smaller (in MiB).  */
        
        
          if (update_arg( (void *)&(args_info->pad_arg), 
               &(args_info->pad_orig), &(args_info->pad_given),
              &(local_args_info.pad_given), optarg, 0, 0, ARG_INT,
              check_ambiguity, override, 0, 0,
              "pad", 'p',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          /* File with CFE to include in the image..  */
          if (strcmp (long_options[option_index].name, "cfe") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->cfe_arg), 
                 &(args_info->cfe_orig), &(args_info->cfe_given),
                &(local_args_info.cfe_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "cfe", '-',
                additional_error))
              goto failure;
          
          }
          /* String for vendor information section (alternate/pirelli)..  */
          else if (strcmp (long_options[option_index].name, "altinfo") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->altinfo_arg), 
                 &(args_info->altinfo_orig), &(args_info->altinfo_given),
                &(local_args_info.altinfo_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "altinfo", '-',
                additional_error))
              goto failure;
          
          }
          /* Put the rootfs before the kernel (only for stock images, e.g. captured from the router's flash memory)..  */
          else if (strcmp (long_options[option_index].name, "root-first") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->root_first_flag), 0, &(args_info->root_first_given),
                &(local_args_info.root_first_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "root-first", '-',
                additional_error))
              goto failure;
          
          }
          /* Dual Image Flag (2=not-specified)..  */
          else if (strcmp (long_options[option_index].name, "second-image-flag") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->second_image_flag_arg), 
                 &(args_info->second_image_flag_orig), &(args_info->second_image_flag_given),
                &(local_args_info.second_image_flag_given), optarg, imagetag_cmdline_second_image_flag_values, "2", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "second-image-flag", '-',
                additional_error))
              goto failure;
          
          }
          /* Inactive Flag (2=not-specified)..  */
          else if (strcmp (long_options[option_index].name, "inactive") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->inactive_arg), 
                 &(args_info->inactive_orig), &(args_info->inactive_given),
                &(local_args_info.inactive_given), optarg, imagetag_cmdline_inactive_values, "2", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "inactive", '-',
                additional_error))
              goto failure;
          
          }
          /* String for second reserved section..  */
          else if (strcmp (long_options[option_index].name, "reserved2") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->reserved2_arg), 
                 &(args_info->reserved2_orig), &(args_info->reserved2_given),
                &(local_args_info.reserved2_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "reserved2", '-',
                additional_error))
              goto failure;
          
          }
          /* Indicates that the kernel file includes the kernel header with correct load address and entry point, so no changes are needed.  */
          else if (strcmp (long_options[option_index].name, "kernel-file-has-header") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->kernel_file_has_header_flag), 0, &(args_info->kernel_file_has_header_given),
                &(local_args_info.kernel_file_has_header_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "kernel-file-has-header", '-',
                additional_error))
              goto failure;
          
          }
          /* Align the rootfs start to erase block size.  */
          else if (strcmp (long_options[option_index].name, "align-rootfs") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->align_rootfs_flag), 0, &(args_info->align_rootfs_given),
                &(local_args_info.align_rootfs_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "align-rootfs", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", IMAGETAG_CMDLINE_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */



  if (check_required)
    {
      error += imagetag_cmdline_required2 (args_info, argv[0], additional_error);
    }

  imagetag_cmdline_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  return 0;

failure:
  
  imagetag_cmdline_release (&local_args_info);
  return (EXIT_FAILURE);
}
