// Code generated by go generate; DO NOT EDIT.
// 2018-04-07 13:51:33.918407222 -0700 PDT m=+0.014850034

package template

var templateViewsMap = map[string]string{
	"about": `{{ define "title"}}{{ t "About" }}{{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "About" }}</h1>
    <ul>
        <li>
            <a href="{{ route "settings" }}">{{ t "Settings" }}</a>
        </li>
        <li>
            <a href="{{ route "integrations" }}">{{ t "Integrations" }}</a>
        </li>
        <li>
            <a href="{{ route "sessions" }}">{{ t "Sessions" }}</a>
        </li>
        {{ if .user.IsAdmin }}
        <li>
            <a href="{{ route "users" }}">{{ t "Users" }}</a>
        </li>
        {{ end }}
    </ul>
</section>

<div class="panel">
    <h3>{{ t "Version" }}</h3>
    <ul>
        <li><strong>{{ t "Version:" }}</strong> {{ .version }}</li>
        <li><strong>{{ t "Build Date:" }}</strong> {{ .build_date }}</li>
    </ul>
</div>

<div class="panel">
    <h3>{{ t "Authors" }}</h3>
    <ul>
        <li><strong>{{ t "Author:" }}</strong> Frédéric Guillot</li>
        <li><strong>{{ t "License:" }}</strong> Apache 2.0</li>
    </ul>
</div>

{{ end }}
`,
	"add_subscription": `{{ define "title"}}{{ t "New Subscription" }}{{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "New Subscription" }}</h1>
    <ul>
        <li>
            <a href="{{ route "feeds" }}">{{ t "Feeds" }}</a>
        </li>
        <li>
            <a href="{{ route "export" }}">{{ t "Export" }}</a>
        </li>
        <li>
            <a href="{{ route "import" }}">{{ t "Import" }}</a>
        </li>
    </ul>
</section>

{{ if not .categories }}
    <p class="alert alert-error">{{ t "There is no category. You must have at least one category." }}</p>
{{ else }}
    <form action="{{ route "submitSubscription" }}" method="post" autocomplete="off">
        <input type="hidden" name="csrf" value="{{ .csrf }}">

        {{ if .errorMessage }}
            <div class="alert alert-error">{{ t .errorMessage }}</div>
        {{ end }}

        <label for="form-url">{{ t "URL" }}</label>
        <input type="url" name="url" id="form-url" placeholder="https://domain.tld/" value="{{ .form.URL }}" required autofocus>

        <label for="form-category">{{ t "Category" }}</label>
        <select id="form-category" name="category_id">
            {{ range .categories }}
                <option value="{{ .ID }}">{{ .Title }}</option>
            {{ end }}
        </select>

        <label><input type="checkbox" name="crawler" value="1" {{ if .form.Crawler }}checked{{ end }}> {{ t "Fetch original content" }}</label>

        <div class="buttons">
            <button type="submit" class="button button-primary" data-label-loading="{{ t "Loading..." }}">{{ t "Find a subscription" }}</button>
        </div>
    </form>
{{ end }}

{{ end }}
`,
	"categories": `{{ define "title"}}{{ t "Categories" }} ({{ .total }}){{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "Categories" }} ({{ .total }})</h1>
    <ul>
        <li>
            <a href="{{ route "createCategory" }}">{{ t "Create a category" }}</a>
        </li>
    </ul>
</section>

{{ if not .categories }}
    <p class="alert alert-error">{{ t "There is no category." }}</p>
{{ else }}
    <div class="items">
        {{ range .categories }}
        <article class="item">
            <div class="item-header">
                <span class="item-title">
                    <a href="{{ route "categoryEntries" "categoryID" .ID }}">{{ .Title }}</a>
                </span>
            </div>
            <div class="item-meta">
                <ul>
                    <li>
                        {{ if eq .FeedCount 0 }}
                            {{ t "No feed." }}
                        {{ else }}
                            {{ plural "plural.categories.feed_count" .FeedCount .FeedCount }}
                        {{ end }}
                    </li>
                </ul>
                <ul>
                    <li>
                        <a href="{{ route "editCategory" "categoryID" .ID }}">{{ t "Edit" }}</a>
                    </li>
                    {{ if eq .FeedCount 0 }}
                    <li>
                        <a href="#"
                            data-confirm="true"
                            data-label-question="{{ t "Are you sure?" }}"
                            data-label-yes="{{ t "yes" }}"
                            data-label-no="{{ t "no" }}"
                            data-label-loading="{{ t "Work in progress..." }}"
                            data-url="{{ route "removeCategory" "categoryID" .ID }}">{{ t "Remove" }}</a>
                    </li>
                    {{ end }}
                </ul>
            </div>
        </article>
        {{ end }}
    </div>
{{ end }}

{{ end }}
`,
	"category_entries": `{{ define "title"}}{{ .category.Title }} ({{ .total }}){{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ .category.Title }} ({{ .total }})</h1>
    {{ if .entries }}
    <ul>
        <li>
            <a href="#" data-on-click="markPageAsRead">{{ t "Mark this page as read" }}</a>
        </li>
    </ul>
    {{ end }}
</section>

{{ if not .entries }}
    <p class="alert">{{ t "There is no article in this category." }}</p>
{{ else }}
    <div class="items">
        {{ range .entries }}
        <article class="item touch-item item-status-{{ .Status }}" data-id="{{ .ID }}">
            <div class="item-header">
                <span class="item-title">
                    {{ if ne .Feed.Icon.IconID 0 }}
                        <img src="{{ route "icon" "iconID" .Feed.Icon.IconID }}" width="16" height="16">
                    {{ end }}
                    <a href="{{ route "categoryEntry" "categoryID" .Feed.Category.ID "entryID" .ID }}">{{ .Title }}</a>
                </span>
                <span class="category"><a href="{{ route "categoryEntries" "categoryID" .Feed.Category.ID }}">{{ .Feed.Category.Title }}</a></span>
            </div>
            {{ template "item_meta" dict "user" $.user "entry" . }}
        </article>
        {{ end }}
    </div>
    {{ template "pagination" .pagination }}
{{ end }}

{{ end }}
`,
	"choose_subscription": `{{ define "title"}}{{ t "Choose a Subscription" }}{{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "New Subscription" }}</h1>
    <ul>
        <li>
            <a href="{{ route "feeds" }}">{{ t "Feeds" }}</a>
        </li>
        <li>
            <a href="{{ route "export" }}">{{ t "Export" }}</a>
        </li>
        <li>
            <a href="{{ route "import" }}">{{ t "Import" }}</a>
        </li>
    </ul>
</section>

<form action="{{ route "chooseSubscription" }}" method="POST">
    <input type="hidden" name="csrf" value="{{ .csrf }}">
    <input type="hidden" name="category_id" value="{{ .categoryID }}">

    <h3>{{ t "Choose a Subscription" }}</h3>

    {{ range .subscriptions }}
        <div class="radio-group">
            <label title="{{ .URL }}"><input type="radio" name="url" value="{{ .URL }}"> {{ .Title }}</label> ({{ .Type }})
            <small title="Type = {{ .Type }}"><a href="{{ .URL }}" target="_blank" rel="noopener noreferrer" referrerpolicy="no-referrer">{{ .URL }}</a></small>
        </div>
    {{ end }}

    <br>
    <label><input type="checkbox" name="crawler" value="1" {{ if .form.Crawler }}checked{{ end }}> {{ t "Fetch original content" }}</label>

    <div class="buttons">
        <button type="submit" class="button button-primary" data-label-loading="{{ t "Loading..." }}">{{ t "Subscribe" }}</button>
    </div>
</form>
{{ end }}
`,
	"create_category": `{{ define "title"}}{{ t "New Category" }}{{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "New Category" }}</h1>
    <ul>
        <li>
            <a href="{{ route "categories" }}">{{ t "Categories" }}</a>
        </li>
    </ul>
</section>

<form action="{{ route "saveCategory" }}" method="post" autocomplete="off">
    <input type="hidden" name="csrf" value="{{ .csrf }}">

    {{ if .errorMessage }}
        <div class="alert alert-error">{{ t .errorMessage }}</div>
    {{ end }}

    <label for="form-title">{{ t "Title" }}</label>
    <input type="text" name="title" id="form-title" value="{{ .form.Title }}" required autofocus>

    <div class="buttons">
        <button type="submit" class="button button-primary" data-label-loading="{{ t "Loading..." }}">{{ t "Save" }}</button> {{ t "or" }} <a href="{{ route "categories" }}">{{ t "cancel" }}</a>
    </div>
</form>
{{ end }}
`,
	"create_user": `{{ define "title"}}{{ t "New User" }}{{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "New User" }}</h1>
    <ul>
        <li>
            <a href="{{ route "settings" }}">{{ t "Settings" }}</a>
        </li>
        <li>
            <a href="{{ route "integrations" }}">{{ t "Integrations" }}</a>
        </li>
        <li>
            <a href="{{ route "sessions" }}">{{ t "Sessions" }}</a>
        </li>
        <li>
            <a href="{{ route "users" }}">{{ t "Users" }}</a>
        </li>
        <li>
            <a href="{{ route "about" }}">{{ t "About" }}</a>
        </li>
    </ul>
</section>

<form action="{{ route "saveUser" }}" method="post" autocomplete="off">
    <input type="hidden" name="csrf" value="{{ .csrf }}">

    {{ if .errorMessage }}
        <div class="alert alert-error">{{ t .errorMessage }}</div>
    {{ end }}

    <label for="form-username">{{ t "Username" }}</label>
    <input type="text" name="username" id="form-username" value="{{ .form.Username }}" required autofocus>

    <label for="form-password">{{ t "Password" }}</label>
    <input type="password" name="password" id="form-password" value="{{ .form.Password }}" required>

    <label for="form-confirmation">{{ t "Confirmation" }}</label>
    <input type="password" name="confirmation" id="form-confirmation" value="{{ .form.Confirmation }}" required>

    <label><input type="checkbox" name="is_admin" value="1" {{ if .form.IsAdmin }}checked{{ end }}> {{ t "Administrator" }}</label>

    <div class="buttons">
        <button type="submit" class="button button-primary" data-label-loading="{{ t "Loading..." }}">{{ t "Save" }}</button> {{ t "or" }} <a href="{{ route "users" }}">{{ t "cancel" }}</a>
    </div>
</form>
{{ end }}
`,
	"edit_category": `{{ define "title"}}{{ t "Edit Category: %s" .category.Title }}{{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "Edit Category: %s" .category.Title }}</h1>
    <ul>
        <li>
            <a href="{{ route "categories" }}">{{ t "Categories" }}</a>
        </li>
        <li>
            <a href="{{ route "createCategory" }}">{{ t "Create a category" }}</a>
        </li>
    </ul>
</section>

<form action="{{ route "updateCategory" "categoryID" .category.ID }}" method="post" autocomplete="off">
    <input type="hidden" name="csrf" value="{{ .csrf }}">

    {{ if .errorMessage }}
        <div class="alert alert-error">{{ t .errorMessage }}</div>
    {{ end }}

    <label for="form-title">{{ t "Title" }}</label>
    <input type="text" name="title" id="form-title" value="{{ .form.Title }}" required autofocus>

    <div class="buttons">
        <button type="submit" class="button button-primary" data-label-loading="{{ t "Loading..." }}">{{ t "Update" }}</button> {{ t "or" }} <a href="{{ route "categories" }}">{{ t "cancel" }}</a>
    </div>
</form>
{{ end }}
`,
	"edit_feed": `{{ define "title"}}{{ t "Edit Feed: %s" .feed.Title }}{{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ .feed.Title }}</h1>
    <ul>
        <li>
            <a href="{{ route "feeds" }}">{{ t "Feeds" }}</a>
        </li>
        <li>
            <a href="{{ route "addSubscription" }}">{{ t "Add subscription" }}</a>
        </li>
        <li>
            <a href="{{ route "export" }}">{{ t "Export" }}</a>
        </li>
        <li>
            <a href="{{ route "import" }}">{{ t "Import" }}</a>
        </li>
    </ul>
</section>

{{ if not .categories }}
    <p class="alert alert-error">{{ t "There is no category!" }}</p>
{{ else }}
    {{ if ne .feed.ParsingErrorCount 0 }}
    <div class="alert alert-error">
        <h3>{{ t "Last Parsing Error" }}</h3>
        <p>{{ t .feed.ParsingErrorMsg }}</p>
    </div>
    {{ end }}

    <form action="{{ route "updateFeed" "feedID" .feed.ID }}" method="post" autocomplete="off">
        <input type="hidden" name="csrf" value="{{ .csrf }}">

        {{ if .errorMessage }}
            <div class="alert alert-error">{{ t .errorMessage }}</div>
        {{ end }}

        <label for="form-title">{{ t "Title" }}</label>
        <input type="text" name="title" id="form-title" value="{{ .form.Title }}" required autofocus>

        <label for="form-site-url">{{ t "Site URL" }}</label>
        <input type="url" name="site_url" id="form-site-url" placeholder="https://domain.tld/" value="{{ .form.SiteURL }}" required>

        <label for="form-feed-url">{{ t "Feed URL" }}</label>
        <input type="url" name="feed_url" id="form-feed-url" placeholder="https://domain.tld/" value="{{ .form.FeedURL }}" required>

        <label for="form-scraper-rules">{{ t "Scraper Rules" }}</label>
        <input type="text" name="scraper_rules" id="form-scraper-rules" value="{{ .form.ScraperRules }}">

        <label for="form-rewrite-rules">{{ t "Rewrite Rules" }}</label>
        <input type="text" name="rewrite_rules" id="form-rewrite-rules" value="{{ .form.RewriteRules }}">

        <label for="form-category">{{ t "Category" }}</label>
        <select id="form-category" name="category_id">
        {{ range .categories }}
            <option value="{{ .ID }}" {{ if eq .ID $.form.CategoryID }}selected="selected"{{ end }}>{{ .Title }}</option>
        {{ end }}
        </select>

        <label><input type="checkbox" name="crawler" value="1" {{ if .form.Crawler }}checked{{ end }}> {{ t "Fetch original content" }}</label>

        <div class="buttons">
            <button type="submit" class="button button-primary" data-label-loading="{{ t "Loading..." }}">{{ t "Update" }}</button> {{ t "or" }} <a href="{{ route "feeds" }}">{{ t "cancel" }}</a>
        </div>
    </form>

    <div class="panel">
        <ul>
            <li><strong>{{ t "Last checked:" }} </strong><time datetime="{{ isodate .feed.CheckedAt }}" title="{{ isodate .feed.CheckedAt }}">{{ elapsed $.user.Timezone .feed.CheckedAt }}</time></li>
            <li><strong>{{ t "ETag header:" }} </strong>{{ if .feed.EtagHeader }}{{ .feed.EtagHeader }}{{ else }}{{ t "None" }}{{ end }}</li>
            <li><strong>{{ t "LastModified header:" }} </strong>{{ if .feed.LastModifiedHeader }}{{ .feed.LastModifiedHeader }}{{ else }}{{ t "None" }}{{ end }}</li>
        </ul>
    </div>
{{ end }}

{{ end }}`,
	"edit_user": `{{ define "title"}}{{ t "Edit user: %s" .selected_user.Username }}{{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "Edit user %s" .selected_user.Username }}</h1>
    <ul>
        <li>
            <a href="{{ route "settings" }}">{{ t "Settings" }}</a>
        </li>
        <li>
            <a href="{{ route "integrations" }}">{{ t "Integrations" }}</a>
        </li>
        <li>
            <a href="{{ route "sessions" }}">{{ t "Sessions" }}</a>
        </li>
        <li>
            <a href="{{ route "users" }}">{{ t "Users" }}</a>
        </li>
        <li>
            <a href="{{ route "createUser" }}">{{ t "Add user" }}</a>
        </li>
        <li>
            <a href="{{ route "about" }}">{{ t "About" }}</a>
        </li>
    </ul>
</section>

<form action="{{ route "updateUser" "userID" .selected_user.ID }}" method="post" autocomplete="off">
    <input type="hidden" name="csrf" value="{{ .csrf }}">

    {{ if .errorMessage }}
        <div class="alert alert-error">{{ t .errorMessage }}</div>
    {{ end }}

    <label for="form-username">{{ t "Username" }}</label>
    <input type="text" name="username" id="form-username" value="{{ .form.Username }}" required autofocus>

    <label for="form-password">{{ t "Password" }}</label>
    <input type="password" name="password" id="form-password" value="{{ .form.Password }}">

    <label for="form-confirmation">{{ t "Confirmation" }}</label>
    <input type="password" name="confirmation" id="form-confirmation" value="{{ .form.Confirmation }}">

    <label><input type="checkbox" name="is_admin" value="1" {{ if .form.IsAdmin }}checked{{ end }}> {{ t "Administrator" }}</label>

    <div class="buttons">
        <button type="submit" class="button button-primary" data-label-loading="{{ t "Loading..." }}">{{ t "Update" }}</button> {{ t "or" }} <a href="{{ route "users" }}">{{ t "cancel" }}</a>
    </div>
</form>
{{ end }}
`,
	"entry": `{{ define "title"}}{{ .entry.Title }}{{ end }}

{{ define "content"}}
<section class="entry">
    <header class="entry-header">
        <h1>
            <a href="{{ .entry.URL }}" target="_blank" rel="noopener noreferrer" referrerpolicy="no-referrer">{{ .entry.Title }}</a>
        </h1>
        <div class="entry-actions">
            <ul>
                <li>
                    <a href="#"
                        data-toggle-bookmark="true"
                        data-bookmark-url="{{ route "toggleBookmark" "entryID" .entry.ID }}"
                        data-label-loading="{{ t "Saving..." }}"
                        data-label-star="☆ {{ t "Star" }}"
                        data-label-unstar="★ {{ t "Unstar" }}"
                        data-value="{{ if .Starred }}star{{ else }}unstar{{ end }}"
                        >{{ if .entry.Starred }}★ {{ t "Unstar" }}{{ else }}☆ {{ t "Star" }}{{ end }}</a>
                </li>
                <li>
                    <a href="#"
                        title="{{ t "Save this article" }}"
                        data-save-entry="true"
                        data-save-url="{{ route "saveEntry" "entryID" .entry.ID }}"
                        data-label-loading="{{ t "Saving..." }}"
                        data-label-done="{{ t "Done!" }}"
                        >{{ t "Save" }}</a>
                </li>
                <li>
                    <a href="#"
                        title="{{ t "Fetch original content" }}"
                        data-fetch-content-entry="true"
                        data-fetch-content-url="{{ route "fetchContent" "entryID" .entry.ID }}"
                        data-label-loading="{{ t "Loading..." }}"
                        data-label-done="{{ t "Done!" }}"
                        >{{ t "Fetch original content" }}</a>
                </li>
                {{ if .entry.CommentsURL }}
                    <li>
                        <a href="{{ .entry.CommentsURL }}" title="{{ t "View Comments" }}" target="_blank" rel="noopener noreferrer" referrerpolicy="no-referrer">{{ t "Comments" }}</a>
                    </li>
                {{ end }}
            </ul>
        </div>
        <div class="entry-meta">
            <span class="entry-website">
                {{ if ne .entry.Feed.Icon.IconID 0 }}
                    <img src="{{ route "icon" "iconID" .entry.Feed.Icon.IconID }}" width="16" height="16">
                {{ end }}
                <a href="{{ route "feedEntries" "feedID" .entry.Feed.ID }}">{{ .entry.Feed.Title }}</a>
            </span>
            {{ if .entry.Author }}
                <span class="entry-author">
                    {{ if isEmail .entry.Author }}
                        - <a href="mailto:{{ .entry.Author }}">{{ .entry.Author }}</a>
                    {{ else }}
                        – <em>{{ .entry.Author }}</em>
                    {{ end }}
                </span>
            {{ end }}
            <span class="category">
                <a href="{{ route "categoryEntries" "categoryID" .entry.Feed.Category.ID }}">{{ .entry.Feed.Category.Title }}</a>
            </span>
        </div>
        <div class="entry-date">
            <time datetime="{{ isodate .entry.Date }}" title="{{ isodate .entry.Date }}">{{ elapsed $.user.Timezone .entry.Date }}</time>
        </div>
    </header>
    {{ if gt (len .entry.Content) 120 }}
    <div class="pagination-top">
        {{ template "entry_pagination" . }}
    </div>
    {{ end }}
    <article class="entry-content">
        {{ noescape (proxyFilter .entry.Content) }}
    </article>
    {{ if .entry.Enclosures }}
    <aside class="entry-enclosures">
        <h3>{{ t "Attachments" }}</h3>
        {{ range .entry.Enclosures }}
            <div class="entry-enclosure">
                {{ if hasPrefix .MimeType "audio/" }}
                    <div class="enclosure-audio">
                        <audio controls preload="metadata">
                            <source src="{{ .URL }}" type="{{ .MimeType }}">
                        </audio>
                    </div>
                {{ else if hasPrefix .MimeType "video/" }}
                    <div class="enclosure-video">
                        <video controls preload="metadata">
                            <source src="{{ .URL }}" type="{{ .MimeType }}">
                        </video>
                    </div>
                {{ else if hasPrefix .MimeType "image/" }}
                    <div class="enclosure-image">
                        <img src="{{ proxyURL .URL }}" title="{{ .URL }} ({{ .MimeType }})" alt="{{ .URL }} ({{ .MimeType }})">
                    </div>
                {{ end }}

                <div class="entry-enclosure-download">
                    <a href="{{ .URL }}" title="{{ .URL }} ({{ .MimeType }})" target="_blank" rel="noopener noreferrer" referrerpolicy="no-referrer">{{ t "Download" }}</a>
                    <small>({{ .URL }})</small>
                </div>
            </div>
        {{ end }}
    </aside>
    {{ end }}
</section>

<div class="pagination-bottom">
    {{ template "entry_pagination" . }}
</div>
{{ end }}
`,
	"feed_entries": `{{ define "title"}}{{ .feed.Title }} ({{ .total }}){{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ .feed.Title }} ({{ .total }})</h1>
    <ul>
        <li>
            <a href="{{ route "refreshFeed" "feedID" .feed.ID }}">{{ t "Refresh" }}</a>
        </li>
        <li>
            <a href="{{ route "editFeed" "feedID" .feed.ID }}">{{ t "Edit" }}</a>
        </li>
        {{ if .entries }}
        <li>
            <a href="#" data-on-click="markPageAsRead">{{ t "Mark this page as read" }}</a>
        </li>
        {{ end }}
    </ul>
</section>

{{ if ne .feed.ParsingErrorCount 0 }}
<div class="alert alert-error">
    <h3>{{ t "There is a problem with this feed" }}</h3>
    <p>{{ t .feed.ParsingErrorMsg }}</p>
</div>
{{ else if not .entries }}
    <p class="alert">{{ t "There is no article for this feed." }}</p>
{{ else }}
    <div class="items">
        {{ range .entries }}
        <article class="item touch-item item-status-{{ .Status }}" data-id="{{ .ID }}">
            <div class="item-header">
                <span class="item-title">
                    {{ if ne .Feed.Icon.IconID 0 }}
                        <img src="{{ route "icon" "iconID" .Feed.Icon.IconID }}" width="16" height="16">
                    {{ end }}
                    <a href="{{ route "feedEntry" "feedID" .Feed.ID "entryID" .ID }}">{{ .Title }}</a>
                </span>
                <span class="category"><a href="{{ route "categoryEntries" "categoryID" .Feed.Category.ID }}">{{ .Feed.Category.Title }}</a></span>
            </div>
            {{ template "item_meta" dict "user" $.user "entry" . }}
        </article>
        {{ end }}
    </div>
    {{ template "pagination" .pagination }}
{{ end }}

{{ end }}
`,
	"feeds": `{{ define "title"}}{{ t "Feeds" }} ({{ .total }}){{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "Feeds" }} ({{ .total }})</h1>
    <ul>
        <li>
            <a href="{{ route "addSubscription" }}">{{ t "Add subscription" }}</a>
        </li>
        <li>
            <a href="{{ route "export" }}">{{ t "Export" }}</a>
        </li>
        <li>
            <a href="{{ route "import" }}">{{ t "Import" }}</a>
        </li>
        <li>
            <a href="{{ route "refreshAllFeeds" }}">{{ t "Refresh all feeds in background" }}</a>
        </li>
    </ul>
</section>

{{ if not .feeds }}
    <p class="alert">{{ t "You don't have any subscription." }}</p>
{{ else }}
    <div class="items">
        {{ range .feeds }}
        <article class="item {{ if ne .ParsingErrorCount 0 }}feed-parsing-error{{ end }}">
            <div class="item-header">
                <span class="item-title">
                    {{ if .Icon }}
                        <img src="{{ route "icon" "iconID" .Icon.IconID }}" width="16" height="16">
                    {{ end }}
                    <a href="{{ route "feedEntries" "feedID" .ID }}">{{ .Title }}</a>
                </span>
                <span class="category">
                    <a href="{{ route "categoryEntries" "categoryID" .Category.ID }}">{{ .Category.Title }}</a>
                </span>
            </div>
            <div class="item-meta">
                <ul>
                    <li>
                        <a href="{{ .SiteURL }}" target="_blank" rel="noopener noreferrer" referrerpolicy="no-referrer" data-original-link="true">{{ domain .SiteURL }}</a>
                    </li>
                    <li>
                        {{ t "Last check:" }} <time datetime="{{ isodate .CheckedAt }}" title="{{ isodate .CheckedAt }}">{{ elapsed $.user.Timezone .CheckedAt }}</time>
                    </li>
                </ul>
                <ul>
                    <li>
                        <a href="{{ route "refreshFeed" "feedID" .ID }}">{{ t "Refresh" }}</a>
                    </li>
                    <li>
                        <a href="{{ route "editFeed" "feedID" .ID }}">{{ t "Edit" }}</a>
                    </li>
                    <li>
                        <a href="#"
                            data-confirm="true"
                            data-label-question="{{ t "Are you sure?" }}"
                            data-label-yes="{{ t "yes" }}"
                            data-label-no="{{ t "no" }}"
                            data-label-loading="{{ t "Work in progress..." }}"
                            data-url="{{ route "removeFeed" "feedID" .ID }}">{{ t "Remove" }}</a>
                    </li>
                </ul>
            </div>
            {{ if ne .ParsingErrorCount 0 }}
                <div class="parsing-error">
                    <strong title="{{ .ParsingErrorMsg }}" class="parsing-error-count">{{ plural "plural.feed.error_count" .ParsingErrorCount .ParsingErrorCount }}</strong>
                    - <small class="parsing-error-message">{{ .ParsingErrorMsg }}</small>
                </div>
            {{ end }}
        </article>
        {{ end }}
    </div>
{{ end }}

{{ end }}
`,
	"history": `{{ define "title"}}{{ t "History" }} ({{ .total }}){{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "History" }} ({{ .total }})</h1>
    {{ if .entries }}
    <ul>
        <li>
            <a href="{{ route "flushHistory" }}">{{ t "Flush history" }}</a>
        </li>
    </ul>
    {{ end }}
</section>

{{ if not .entries }}
    <p class="alert alert-info">{{ t "There is no history at the moment." }}</p>
{{ else }}
    <div class="items">
        {{ range .entries }}
        <article class="item touch-item item-status-{{ .Status }}" data-id="{{ .ID }}">
            <div class="item-header">
                <span class="item-title">
                    {{ if ne .Feed.Icon.IconID 0 }}
                        <img src="{{ route "icon" "iconID" .Feed.Icon.IconID }}" width="16" height="16">
                    {{ end }}
                    <a href="{{ route "readEntry" "entryID" .ID }}">{{ .Title }}</a>
                </span>
                <span class="category"><a href="{{ route "categoryEntries" "categoryID" .Feed.Category.ID }}">{{ .Feed.Category.Title }}</a></span>
            </div>
            {{ template "item_meta" dict "user" $.user "entry" . }}
        </article>
        {{ end }}
    </div>
    {{ template "pagination" .pagination }}
{{ end }}

{{ end }}
`,
	"import": `{{ define "title"}}{{ t "Import" }}{{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "Import" }}</h1>
    <ul>
        <li>
            <a href="{{ route "feeds" }}">{{ t "Feeds" }}</a>
        </li>
        <li>
            <a href="{{ route "addSubscription" }}">{{ t "Add subscription" }}</a>
        </li>
        <li>
            <a href="{{ route "export" }}">{{ t "Export" }}</a>
        </li>
    </ul>
</section>

<form action="{{ route "uploadOPML" }}" method="post" enctype="multipart/form-data">
    <input type="hidden" name="csrf" value="{{ .csrf }}">

    {{ if .errorMessage }}
        <div class="alert alert-error">{{ t .errorMessage }}</div>
    {{ end }}

    <label for="form-file">{{ t "OPML file" }}</label>
    <input type="file" name="file" id="form-file">

    <div class="buttons">
        <button type="submit" class="button button-primary" data-label-loading="{{ t "Loading..." }}">{{ t "Import" }}</button>
    </div>
</form>

{{ end }}
`,
	"integrations": `{{ define "title"}}{{ t "Integrations" }}{{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "Integrations" }}</h1>
    <ul>
        <li>
            <a href="{{ route "settings" }}">{{ t "Settings" }}</a>
        </li>
        <li>
            <a href="{{ route "sessions" }}">{{ t "Sessions" }}</a>
        </li>
        {{ if .user.IsAdmin }}
        <li>
            <a href="{{ route "users" }}">{{ t "Users" }}</a>
        </li>
        {{ end }}
        <li>
            <a href="{{ route "about" }}">{{ t "About" }}</a>
        </li>
    </ul>
</section>

<form method="post" autocomplete="off" action="{{ route "updateIntegration" }}">
    <input type="hidden" name="csrf" value="{{ .csrf }}">

    {{ if .errorMessage }}
        <div class="alert alert-error">{{ t .errorMessage }}</div>
    {{ end }}

    <h3>Fever</h3>
    <div class="form-section">
        <label>
            <input type="checkbox" name="fever_enabled" value="1" {{ if .form.FeverEnabled }}checked{{ end }}> {{ t "Activate Fever API" }}
        </label>

        <label for="form-fever-username">{{ t "Fever Username" }}</label>
        <input type="text" name="fever_username" id="form-fever-username" value="{{ .form.FeverUsername }}">

        <label for="form-fever-password">{{ t "Fever Password" }}</label>
        <input type="password" name="fever_password" id="form-fever-password" value="{{ .form.FeverPassword }}">

        <p>{{ t "Fever API endpoint:" }} <strong>{{ rootURL }}{{ route "feverEndpoint" }}</strong></p>
    </div>

    <h3>Pinboard</h3>
    <div class="form-section">
        <label>
            <input type="checkbox" name="pinboard_enabled" value="1" {{ if .form.PinboardEnabled }}checked{{ end }}> {{ t "Save articles to Pinboard" }}
        </label>

        <label for="form-pinboard-token">{{ t "Pinboard API Token" }}</label>
        <input type="password" name="pinboard_token" id="form-pinboard-token" value="{{ .form.PinboardToken }}">

        <label for="form-pinboard-tags">{{ t "Pinboard Tags" }}</label>
        <input type="text" name="pinboard_tags" id="form-pinboard-tags" value="{{ .form.PinboardTags }}">

        <label>
            <input type="checkbox" name="pinboard_mark_as_unread" value="1" {{ if .form.PinboardMarkAsUnread }}checked{{ end }}> {{ t "Mark bookmark as unread" }}
        </label>
    </div>

    <h3>Instapaper</h3>
    <div class="form-section">
        <label>
            <input type="checkbox" name="instapaper_enabled" value="1" {{ if .form.InstapaperEnabled }}checked{{ end }}> {{ t "Save articles to Instapaper" }}
        </label>

        <label for="form-instapaper-username">{{ t "Instapaper Username" }}</label>
        <input type="text" name="instapaper_username" id="form-instapaper-username" value="{{ .form.InstapaperUsername }}">

        <label for="form-instapaper-password">{{ t "Instapaper Password" }}</label>
        <input type="password" name="instapaper_password" id="form-instapaper-password" value="{{ .form.InstapaperPassword }}">
    </div>

    <h3>Wallabag</h3>
    <div class="form-section">
        <label>
            <input type="checkbox" name="wallabag_enabled" value="1" {{ if .form.WallabagEnabled }}checked{{ end }}> {{ t "Save articles to Wallabag" }}
        </label>

        <label for="form-wallabag-url">{{ t "Wallabag API Endpoint" }}</label>
        <input type="url" name="wallabag_url" id="form-wallabag-url" value="{{ .form.WallabagURL }}" placeholder="http://v2.wallabag.org/">

        <label for="form-wallabag-client-id">{{ t "Wallabag Client ID" }}</label>
        <input type="text" name="wallabag_client_id" id="form-wallabag-client-id" value="{{ .form.WallabagClientID }}">

        <label for="form-wallabag-client-secret">{{ t "Wallabag Client Secret" }}</label>
        <input type="password" name="wallabag_client_secret" id="form-wallabag-client-secret" value="{{ .form.WallabagClientSecret }}">

        <label for="form-wallabag-username">{{ t "Wallabag Username" }}</label>
        <input type="text" name="wallabag_username" id="form-wallabag-username" value="{{ .form.WallabagUsername }}">

        <label for="form-wallabag-password">{{ t "Wallabag Password" }}</label>
        <input type="password" name="wallabag_password" id="form-wallabag-password" value="{{ .form.WallabagPassword }}">
    </div>
    
    <h3>Nunux Keeper</h3>
    <div class="form-section">
        <label>
            <input type="checkbox" name="nunux_keeper_enabled" value="1" {{ if .form.NunuxKeeperEnabled }}checked{{ end }}> {{ t "Save articles to Nunux Keeper" }}
        </label>

        <label for="form-nunux-keeper-url">{{ t "Nunux Keeper API Endpoint" }}</label>
        <input type="url" name="nunux_keeper_url" id="form-nunux-keeper-url" value="{{ .form.NunuxKeeperURL }}" placeholder="https://api.nunux.org/keeper">

        <label for="form-nunux-keeper-api-key">{{ t "Nunux Keeper API key" }}</label>
        <input type="text" name="nunux_keeper_api_key" id="form-nunux-keeper-api-key" value="{{ .form.NunuxKeeperAPIKey }}">
    </div>

    <div class="buttons">
        <button type="submit" class="button button-primary" data-label-loading="{{ t "Loading..." }}">{{ t "Update" }}</button>
    </div>
</form>

<h3>{{ t "Miniflux API" }}</h3>
<div class="panel">
    <ul>
        <li>
            {{ t "API Endpoint" }} = <strong>{{ baseURL }}/v1/</strong>
        </li>
        <li>
            {{ t "Username" }} = <strong>{{ .user.Username }}</strong>
        </li>
        <li>
            {{ t "Password" }} = <strong>{{ t "Your account password" }}</strong>
        </li>
    </ul>
</div>

<h3>{{ t "Bookmarklet" }}</h3>
<div class="panel">
    <p>{{ t "This special link allows you to subscribe to a website directly by using a bookmark in your web browser." }}</p>

    <div class="bookmarklet">
        <a href="javascript:location.href='{{ rootURL }}{{ route "bookmarklet" }}?uri='+encodeURIComponent(window.location.href)">{{ t "Add to Miniflux" }}</a>
    </div>

    <p>{{ t "Drag and drop this link to your bookmarks." }}</p>
</div>

{{ end }}
`,
	"login": `{{ define "title"}}{{ t "Sign In" }}{{ end }}

{{ define "content"}}
<section class="login-form">
    <form action="{{ route "checkLogin" }}" method="post">
        <input type="hidden" name="csrf" value="{{ .csrf }}">

        {{ if .errorMessage }}
            <div class="alert alert-error">{{ t .errorMessage }}</div>
        {{ end }}

        <label for="form-username">{{ t "Username" }}</label>
        <input type="text" name="username" id="form-username" value="{{ .form.Username }}" required autofocus>

        <label for="form-password">{{ t "Password" }}</label>
        <input type="password" name="password" id="form-password" value="{{ .form.Password }}" required>

        <div class="buttons">
            <button type="submit" class="button button-primary" data-label-loading="{{ t "Loading..." }}">{{ t "Sign in" }}</button>
        </div>
    </form>
    {{ if hasOAuth2Provider "google" }}
    <div class="oauth2">
        <a href="{{ route "oauth2Redirect" "provider" "google" }}">{{ t "Sign in with Google" }}</a>
    </div>
    {{ end }}
</section>
{{ end }}
`,
	"sessions": `{{ define "title"}}{{ t "Sessions" }}{{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "Sessions" }}</h1>
    <ul>
        <li>
            <a href="{{ route "settings" }}">{{ t "Settings" }}</a>
        </li>
        <li>
            <a href="{{ route "integrations" }}">{{ t "Integrations" }}</a>
        </li>
        {{ if .user.IsAdmin }}
        <li>
            <a href="{{ route "users" }}">{{ t "Users" }}</a>
        </li>
        <li>
            <a href="{{ route "createUser" }}">{{ t "Add user" }}</a>
        </li>
        {{ end }}
        <li>
            <a href="{{ route "about" }}">{{ t "About" }}</a>
        </li>
    </ul>
</section>

<table>
    <tr>
        <th>{{ t "Date" }}</th>
        <th>{{ t "IP Address" }}</th>
        <th>{{ t "User Agent" }}</th>
        <th>{{ t "Actions" }}</th>
    </tr>
    {{ range .sessions }}
    <tr {{ if eq .Token $.currentSessionToken }}class="row-highlighted"{{ end }}>
        <td class="column-20" title="{{ isodate .CreatedAt }}">{{ elapsed $.user.Timezone .CreatedAt }}</td>
        <td class="column-20" title="{{ .IP }}">{{ .IP }}</td>
        <td title="{{ .UserAgent }}">{{ .UserAgent }}</td>
        <td class="column-20">
            {{ if eq .Token $.currentSessionToken }}
                {{ t "Current session" }}
            {{ else }}
                <a href="#"
                    data-confirm="true"
                    data-label-question="{{ t "Are you sure?" }}"
                    data-label-yes="{{ t "yes" }}"
                    data-label-no="{{ t "no" }}"
                    data-label-loading="{{ t "Work in progress..." }}"
                    data-url="{{ route "removeSession" "sessionID" .ID }}">{{ t "Remove" }}</a>
            {{ end }}
        </td>
    </tr>
    {{ end }}
</table>

{{ end }}
`,
	"settings": `{{ define "title"}}{{ t "Settings" }}{{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "Settings" }}</h1>
    <ul>
        <li>
            <a href="{{ route "integrations" }}">{{ t "Integrations" }}</a>
        </li>
        <li>
            <a href="{{ route "sessions" }}">{{ t "Sessions" }}</a>
        </li>
        {{ if .user.IsAdmin }}
        <li>
            <a href="{{ route "users" }}">{{ t "Users" }}</a>
        </li>
        {{ end }}
        <li>
            <a href="{{ route "about" }}">{{ t "About" }}</a>
        </li>
    </ul>
</section>

<form method="post" autocomplete="off" action="{{ route "updateSettings" }}">
    <input type="hidden" name="csrf" value="{{ .csrf }}">

    {{ if .errorMessage }}
        <div class="alert alert-error">{{ t .errorMessage }}</div>
    {{ end }}

    <label for="form-username">{{ t "Username" }}</label>
    <input type="text" name="username" id="form-username" value="{{ .form.Username }}" required>

    <label for="form-password">{{ t "Password" }}</label>
    <input type="password" name="password" id="form-password" value="{{ .form.Password }}" autocomplete="off">

    <label for="form-confirmation">{{ t "Confirmation" }}</label>
    <input type="password" name="confirmation" id="form-confirmation" value="{{ .form.Confirmation }}" autocomplete="off">

    <label for="form-language">{{ t "Language" }}</label>
    <select id="form-language" name="language">
    {{ range $key, $value := .languages }}
        <option value="{{ $key }}" {{ if eq $key $.form.Language }}selected="selected"{{ end }}>{{ $value }}</option>
    {{ end }}
    </select>

    <label for="form-timezone">{{ t "Timezone" }}</label>
    <select id="form-timezone" name="timezone">
    {{ range $key, $value := .timezones }}
        <option value="{{ $key }}" {{ if eq $key $.form.Timezone }}selected="selected"{{ end }}>{{ $value }}</option>
    {{ end }}
    </select>

    <label for="form-theme">{{ t "Theme" }}</label>
    <select id="form-theme" name="theme">
    {{ range $key, $value := .themes }}
        <option value="{{ $key }}" {{ if eq $key $.form.Theme }}selected="selected"{{ end }}>{{ $value }}</option>
    {{ end }}
    </select>

    <label for="form-entry-direction">{{ t "Entry Sorting" }}</label>
    <select id="form-entry-direction" name="entry_direction">
        <option value="asc" {{ if eq "asc" $.form.EntryDirection }}selected="selected"{{ end }}>{{ t "Older entries first" }}</option>
        <option value="desc" {{ if eq "desc" $.form.EntryDirection }}selected="selected"{{ end }}>{{ t "Recent entries first" }}</option>
    </select>

    <div class="buttons">
        <button type="submit" class="button button-primary" data-label-loading="{{ t "Loading..." }}">{{ t "Update" }}</button>
    </div>
</form>

{{ if hasOAuth2Provider "google" }}
<div class="panel">
    {{ if hasKey .user.Extra "google_id" }}
        <a href="{{ route "oauth2Unlink" "provider" "google" }}">{{ t "Unlink my Google account" }}</a>
    {{ else }}
        <a href="{{ route "oauth2Redirect" "provider" "google" }}">{{ t "Link my Google account" }}</a>
    {{ end }}
</div>
{{ end }}

{{ end }}
`,
	"starred": `{{ define "title"}}{{ t "Favorites" }} ({{ .total }}){{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "Favorites" }} ({{ .total }})</h1>
</section>

{{ if not .entries }}
    <p class="alert alert-info">{{ t "There is no bookmark at the moment." }}</p>
{{ else }}
    <div class="items">
        {{ range .entries }}
        <article class="item touch-item item-status-{{ .Status }}" data-id="{{ .ID }}">
            <div class="item-header">
                <span class="item-title">
                    {{ if ne .Feed.Icon.IconID 0 }}
                        <img src="{{ route "icon" "iconID" .Feed.Icon.IconID }}" width="16" height="16">
                    {{ end }}
                    <a href="{{ route "starredEntry" "entryID" .ID }}">{{ .Title }}</a>
                </span>
                <span class="category"><a href="{{ route "categoryEntries" "categoryID" .Feed.Category.ID }}">{{ .Feed.Category.Title }}</a></span>
            </div>
            {{ template "item_meta" dict "user" $.user "entry" . }}
        </article>
        {{ end }}
    </div>
    {{ template "pagination" .pagination }}
{{ end }}

{{ end }}
`,
	"unread": `{{ define "title"}}{{ t "Unread Items" }} {{ if gt .countUnread 0 }}({{ .countUnread }}){{ end }} {{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "Unread" }} (<span class="unread-counter">{{ .countUnread }}</span>)</h1>
    {{ if .entries }}
    <ul>
        <li>
            <a href="#" data-on-click="markPageAsRead">{{ t "Mark this page as read" }}</a>
        </li>
        <li>
            <a href="{{ route "markAllAsRead" }}">{{ t "Mark all as read" }}</a>
        </li>
    </ul>
    {{ end }}
</section>

{{ if not .entries }}
    <p class="alert">{{ t "There is no unread article." }}</p>
{{ else }}
    <div class="items hide-read-items">
        {{ range .entries }}
        <article class="item touch-item item-status-{{ .Status }}" data-id="{{ .ID }}">
            <div class="item-header">
                <span class="item-title">
                    {{ if ne .Feed.Icon.IconID 0 }}
                        <img src="{{ route "icon" "iconID" .Feed.Icon.IconID }}" width="16" height="16">
                    {{ end }}
                    <a href="{{ route "unreadEntry" "entryID" .ID }}">{{ .Title }}</a>
                </span>
                <span class="category"><a href="{{ route "categoryEntries" "categoryID" .Feed.Category.ID }}">{{ .Feed.Category.Title }}</a></span>
            </div>
            {{ template "item_meta" dict "user" $.user "entry" . }}
        </article>
        {{ end }}
    </div>
    {{ template "pagination" .pagination }}
{{ end }}

{{ end }}`,
	"users": `{{ define "title"}}{{ t "Users" }}{{ end }}

{{ define "content"}}
<section class="page-header">
    <h1>{{ t "Users" }}</h1>
    <ul>
        <li>
            <a href="{{ route "settings" }}">{{ t "Settings" }}</a>
        </li>
        <li>
            <a href="{{ route "integrations" }}">{{ t "Integrations" }}</a>
        </li>
        <li>
            <a href="{{ route "sessions" }}">{{ t "Sessions" }}</a>
        </li>
        <li>
            <a href="{{ route "createUser" }}">{{ t "Add user" }}</a>
        </li>
        <li>
            <a href="{{ route "about" }}">{{ t "About" }}</a>
        </li>
    </ul>
</section>

{{ if eq (len .users) 1 }}
    <p class="alert">{{ t "You are the only user." }}</p>
{{ else }}
    <table>
        <tr>
            <th class="column-20">{{ t "Username" }}</th>
            <th>{{ t "Administrator" }}</th>
            <th>{{ t "Last Login" }}</th>
            <th>{{ t "Actions" }}</th>
        </tr>
        {{ range .users }}
            {{ if ne .ID $.user.ID }}
            <tr>
                <td>{{ .Username }}</td>
                <td>{{ if eq .IsAdmin true }}{{ t "Yes" }}{{ else }}{{ t "No" }}{{ end }}</td>
                <td>
                    {{ if .LastLoginAt }}
                        <time datetime="{{ isodate .LastLoginAt }}" title="{{ isodate .LastLoginAt }}">{{ elapsed $.user.Timezone .LastLoginAt }}</time>
                    {{ else }}
                        {{ t "Never" }}
                    {{ end }}
                </td>
                <td>
                    <a href="{{ route "editUser" "userID" .ID }}">{{ t "Edit" }}</a>,
                    <a href="#"
                        data-confirm="true"
                        data-label-question="{{ t "Are you sure?" }}"
                        data-label-yes="{{ t "yes" }}"
                        data-label-no="{{ t "no" }}"
                        data-label-loading="{{ t "Work in progress..." }}"
                        data-url="{{ route "removeUser" "userID" .ID }}">{{ t "Remove" }}</a>
                </td>
            </tr>
            {{ end }}
        {{ end }}
    </table>
{{ end }}

{{ end }}
`,
}

var templateViewsMapChecksums = map[string]string{
	"about":               "ad2fb778fc73c39b733b3f81b13e5c7d689b041fadd24ee2d4577f545aa788ad",
	"add_subscription":    "053c920b0d7e109ea19dce6a448e304ce720db8633588ea04db16677f7209a7b",
	"categories":          "ca1280cd157bb527d4fc907da67b05a8347378f6dce965b9389d4bcdf3600a11",
	"category_entries":    "686132d71c52a665329670756ac09959d915f7bc3227970149c623059988b035",
	"choose_subscription": "a325f9c976ca2b2dc148e25c8fef0cf6ccab0e04e86e604e7812bb18dc4cdde1",
	"create_category":     "2b82af5d2dcd67898dc5daa57a6461e6ff8121a6089b2a2a1be909f35e4a2275",
	"create_user":         "233764778c915754141a20429ec8db9bf80ef2d7704867a2d7232c1e9df233ae",
	"edit_category":       "cee720faadcec58289b707ad30af623d2ee66c1ce23a732965463250d7ff41c5",
	"edit_feed":           "d2c1c8486d7faf4ee58151ccf3e3c690e53bd6872050d291c5db8452a83c3d53",
	"edit_user":           "321e0a60cf3bf7441bff970f4920e4c5b7c1883f80ab1d1674f8137954b25033",
	"entry":               "656a33552c3662c5d38a6178c811316ff55b38460b1f57d4087d51d631efe896",
	"feed_entries":        "420da786e827a77fecc8794207d158af3a30e489ca2b2019f48d5228919af4a7",
	"feeds":               "2a5abe37968ea34a0576dbef52341645cb1fc9562e351382fbf721491da6f4fa",
	"history":             "967bc95236269ab3a77455910aca1939f43f93171fe1af77eb3b1b4eac579e55",
	"import":              "73b5112e20bfd232bf73334544186ea419505936bc237d481517a8622901878f",
	"integrations":        "979193f39c2a3b43cec192aa119713cc9cbe2d5fdaedf8d2b3573c752823446c",
	"login":               "7d83c3067c02f1f6aafdd8816c7f97a4eb5a5a4bdaaaa4cc1e2fbb9c17ea65e8",
	"sessions":            "3fa79031dd883847eba92fbafe5f535fa3a4e1614bb610f20588b6f8fc8b3624",
	"settings":            "ea2505b9d0a6d6bb594dba87a92079de19baa6d494f0651693a7685489fb7de9",
	"starred":             "d006f5bcfca7abc7c68b6bb38fe25838acb81b65f960fbf06b97b259ba03b936",
	"unread":              "ad71a7bdd46c1d650efecbeeb37b7606a046027c15284c0712912b77397f90d4",
	"users":               "c6d91b0b29984b4cb3073bec6a2933cfb72981ec60f54b6c7aa05194f0e860bd",
}
