window.ydoc_plugin_search_json = {
  "教程": [
    {
      "title": "YApi",
      "content": "在开始使用 YApi 之前，我们先来熟悉一下 YApi 的网站结构，这将让你快速了解YApi。",
      "url": "/documents/index.html",
      "children": [
        {
          "title": "登录与注册",
          "url": "/documents/index.html#登录与注册",
          "content": "登录与注册想要使用 YApi ，首先要注册账号。"
        },
        {
          "title": "首页",
          "url": "/documents/index.html#首页",
          "content": "首页登录后进入首页，首页展示了分组与项目。此时你作为新用户，没有任何分组与项目的权限，因此只能搜索、浏览 “公开项目” 的接口，如果在首页找不到任何项目，请联系管理员将你加入对应项目。1首页头部展示了当前所在的位置、搜索框、新建项目、查看文档和用户信息。2首页左侧展示分组信息，“分组”是“项目”的集合，只有超级管理员可以管理分组。3首页右侧是分组下的项目和成员列表，点击左侧的某个分组，右侧会出现该分组下的项目和成员信息。4点击项目右上角的星星即可关注项目，关注的项目可以在“我的关注”页面查看。"
        },
        {
          "title": "项目页",
          "url": "/documents/index.html#项目页",
          "content": "项目页点击一个项目，进入项目页，项目页展示了属于该项目的全部接口，并提供项目、接口的全部操作。此时你作为新用户，只能浏览接口信息，不可以编辑项目或接口，如果需要编辑，请联系管理员将你加入该项目。1项目页左侧的 “接口列表” 展示了该项目下的所有接口，右侧默认显示该项目下所有接口的列表。2点击左侧的某个接口，右侧会出现“预览”、“编辑”和“运行”。3点击左侧的 “测试集合” 使用测试集功能。4点击二级导航的“设置”，项目组长即可编辑项目信息和管理成员列表。5点击二级导航的“动态”，即可查看项目的操作日志。"
        },
        {
          "title": "个人中心",
          "url": "/documents/index.html#个人中心",
          "content": "个人中心鼠标移动到右上角的用户头像或用户名上，即可点击“个人中心”查看个人信息。在个人信息页面可以查看并修改自己的用户名、密码等信息。"
        }
      ]
    },
    {
      "title": "YApi",
      "content": "在开始使用 YApi 之前，我们先来熟悉一下 YApi 的网站结构，这将让你快速了解YApi。",
      "url": "/documents/index.html",
      "children": [
        {
          "title": "登录与注册",
          "url": "/documents/index.html#登录与注册",
          "content": "登录与注册想要使用 YApi ，首先要注册账号。"
        },
        {
          "title": "首页",
          "url": "/documents/index.html#首页",
          "content": "首页登录后进入首页，首页展示了分组与项目。此时你作为新用户，没有任何分组与项目的权限，因此只能搜索、浏览 “公开项目” 的接口，如果在首页找不到任何项目，请联系管理员将你加入对应项目。1首页头部展示了当前所在的位置、搜索框、新建项目、查看文档和用户信息。2首页左侧展示分组信息，“分组”是“项目”的集合，只有超级管理员可以管理分组。3首页右侧是分组下的项目和成员列表，点击左侧的某个分组，右侧会出现该分组下的项目和成员信息。4点击项目右上角的星星即可关注项目，关注的项目可以在“我的关注”页面查看。"
        },
        {
          "title": "项目页",
          "url": "/documents/index.html#项目页",
          "content": "项目页点击一个项目，进入项目页，项目页展示了属于该项目的全部接口，并提供项目、接口的全部操作。此时你作为新用户，只能浏览接口信息，不可以编辑项目或接口，如果需要编辑，请联系管理员将你加入该项目。1项目页左侧的 “接口列表” 展示了该项目下的所有接口，右侧默认显示该项目下所有接口的列表。2点击左侧的某个接口，右侧会出现“预览”、“编辑”和“运行”。3点击左侧的 “测试集合” 使用测试集功能。4点击二级导航的“设置”，项目组长即可编辑项目信息和管理成员列表。5点击二级导航的“动态”，即可查看项目的操作日志。"
        },
        {
          "title": "个人中心",
          "url": "/documents/index.html#个人中心",
          "content": "个人中心鼠标移动到右上角的用户头像或用户名上，即可点击“个人中心”查看个人信息。在个人信息页面可以查看并修改自己的用户名、密码等信息。"
        }
      ]
    },
    {
      "title": "如何创建接口？",
      "content": "把大象装进冰箱分几步？三步：把冰箱门打开，把大象装进去，关门，搞定~新建接口分几步？也是三步：获取权限\n找到一个项目\n新建接口\n搞定~",
      "url": "/documents/quickstart.html",
      "children": [
        {
          "title": "获取权限",
          "url": "/documents/quickstart.html#获取权限",
          "content": "获取权限新用户登录拥有 个人空间 分组下的全部权限，个人空间分组仅自己可见，因此可以在这里任意试用 YApi 的功能。除此以外没有任何项目或分组的权限，只能浏览已存在分组下面的公开项目。如果找不到想找的项目，可能是尚未成为项目成员，此时应联系 项目组长 将你加入该项目。怎样联系组长？想创建分组，请看: 创建分组\n想创建项目，请看: 创建项目\n想了解更多权限信息，请查看权限列表\n"
        },
        {
          "title": "选择项目",
          "url": "/documents/quickstart.html#选择项目",
          "content": "选择项目\n如果你已经登录，会在首页右侧看到一些项目 (可以在左侧的分组列表切换分组来查看不同分组下的项目)。\n\n\n点击一个项目，进入该项目的详情页。\n\n"
        },
        {
          "title": "新建接口",
          "url": "/documents/quickstart.html#新建接口",
          "content": "新建接口点击左侧接口分组右侧的菜单按钮，选择 添加接口，或者点击接口列表右上角的 添加接口。\n选择接口分类，输入接口名称和接口路径，点击 提交。\n恭喜你！创建了第一个YApi的接口，你可以看到在左侧看到接口名称，右侧有该接口的信息预览。\n"
        }
      ]
    },
    {
      "title": "如何创建接口？",
      "content": "把大象装进冰箱分几步？三步：把冰箱门打开，把大象装进去，关门，搞定~新建接口分几步？也是三步：获取权限\n找到一个项目\n新建接口\n搞定~",
      "url": "/documents/quickstart.html",
      "children": [
        {
          "title": "获取权限",
          "url": "/documents/quickstart.html#获取权限",
          "content": "获取权限新用户登录拥有 个人空间 分组下的全部权限，个人空间分组仅自己可见，因此可以在这里任意试用 YApi 的功能。除此以外没有任何项目或分组的权限，只能浏览已存在分组下面的公开项目。如果找不到想找的项目，可能是尚未成为项目成员，此时应联系 项目组长 将你加入该项目。怎样联系组长？想创建分组，请看: 创建分组\n想创建项目，请看: 创建项目\n想了解更多权限信息，请查看权限列表\n"
        },
        {
          "title": "选择项目",
          "url": "/documents/quickstart.html#选择项目",
          "content": "选择项目\n如果你已经登录，会在首页右侧看到一些项目 (可以在左侧的分组列表切换分组来查看不同分组下的项目)。\n\n\n点击一个项目，进入该项目的详情页。\n\n"
        },
        {
          "title": "新建接口",
          "url": "/documents/quickstart.html#新建接口",
          "content": "新建接口点击左侧接口分组右侧的菜单按钮，选择 添加接口，或者点击接口列表右上角的 添加接口。\n选择接口分类，输入接口名称和接口路径，点击 提交。\n恭喜你！创建了第一个YApi的接口，你可以看到在左侧看到接口名称，右侧有该接口的信息预览。\n"
        }
      ]
    },
    {
      "title": "权限权利",
      "content": "接口管理的逻辑较为复杂，操作频率高，层层审批将严重拖慢生产效率，因此传统的金字塔管理模式并不适用。YApi 将扁平化管理模式的思想引入到产品的权限管理中，超级管理员 拥有最高的权限，并将权限分配给若干 组长，超级管理员 只需管理组长 即可，实际上管理YAPI各大分组与项目的是“组长”。组长对分组或项目负责，一般由BU负责人/项目负责人担任。",
      "url": "/documents/manage.html",
      "children": [
        {
          "title": "认识组长",
          "url": "/documents/manage.html#认识组长",
          "content": "认识组长组长分为 分组组长 与 项目组长，他们的关系就是 一个分组内有若干 分组组长 ，这些 分组组长 在创建项目时就可以指定 项目组长。因此他们在职责上的区别就在于 分组组长 对分组负责 项目组长 对项目负责，二者其他具体区别如下：分组组长 的权限包括修改分组、删除分组、创建分组下的项目。一般来说，分组组长 只需要对项目负责，将项目的操作任务安排给 项目组长 处理即可。项目组长 只属于某一个项目因此它无法操作项目所属分组，但拥有项目的全部权限，项目组长 是 YApi 的基层管理者，承担了 YApi 绝大部分的日常管理工作。"
        },
        {
          "title": "创建分组",
          "url": "/documents/manage.html#创建分组",
          "content": "创建分组只有 超级管理员 有权限创建分组"
        },
        {
          "title": "创建项目",
          "url": "/documents/manage.html#创建项目",
          "content": "创建项目成为 分组成员，即可在分组中创建项目。想成为 分组组长 ，在分组成员列表中找到 分组组长，联系 分组组长 将你设置为分组组长。\n怎样联系组长？"
        },
        {
          "title": "权限列表",
          "url": "/documents/manage.html#权限列表",
          "content": "权限列表新用户未加入项目或分组时，我们称为 “游客”。"
        },
        {
          "title": "项目权限",
          "url": "/documents/manage.html#权限列表-项目权限",
          "content": "项目权限\n\n操作\n游客\n项目开发者\n项目组长\n超级管理员\n\n\n\n\n浏览公开项目与接口\n✓\n✓\n✓\n✓\n\n\n浏览私有项目与接口\n\n✓\n✓\n✓\n\n\n编辑项目信息\n\n✓\n✓\n✓\n\n\n新建接口\n\n✓\n✓\n✓\n\n\n编辑接口\n\n✓\n✓\n✓\n\n\n编辑项目头像\n\n\n✓\n✓\n\n\n删除项目\n\n\n✓\n✓\n\n\n"
        },
        {
          "title": "分组权限",
          "url": "/documents/manage.html#权限列表-分组权限",
          "content": "分组权限\n\n操作\n游客\n分组开发者\n分组组长\n超级管理员\n\n\n\n\n浏览分组\n✓\n✓\n✓\n✓\n\n\n在分组中新建项目\n\n✓\n✓\n✓\n\n\n编辑分组信息\n\n\n✓\n✓\n\n\n管理分组成员\n\n\n✓\n✓\n\n\n删除分组\n\n\n✓\n✓\n\n\n"
        }
      ]
    },
    {
      "title": "权限权利",
      "content": "接口管理的逻辑较为复杂，操作频率高，层层审批将严重拖慢生产效率，因此传统的金字塔管理模式并不适用。YApi 将扁平化管理模式的思想引入到产品的权限管理中，超级管理员 拥有最高的权限，并将权限分配给若干 组长，超级管理员 只需管理组长 即可，实际上管理YAPI各大分组与项目的是“组长”。组长对分组或项目负责，一般由BU负责人/项目负责人担任。",
      "url": "/documents/manage.html",
      "children": [
        {
          "title": "认识组长",
          "url": "/documents/manage.html#认识组长",
          "content": "认识组长组长分为 分组组长 与 项目组长，他们的关系就是 一个分组内有若干 分组组长 ，这些 分组组长 在创建项目时就可以指定 项目组长。因此他们在职责上的区别就在于 分组组长 对分组负责 项目组长 对项目负责，二者其他具体区别如下：分组组长 的权限包括修改分组、删除分组、创建分组下的项目。一般来说，分组组长 只需要对项目负责，将项目的操作任务安排给 项目组长 处理即可。项目组长 只属于某一个项目因此它无法操作项目所属分组，但拥有项目的全部权限，项目组长 是 YApi 的基层管理者，承担了 YApi 绝大部分的日常管理工作。"
        },
        {
          "title": "创建分组",
          "url": "/documents/manage.html#创建分组",
          "content": "创建分组只有 超级管理员 有权限创建分组"
        },
        {
          "title": "创建项目",
          "url": "/documents/manage.html#创建项目",
          "content": "创建项目成为 分组成员，即可在分组中创建项目。想成为 分组组长 ，在分组成员列表中找到 分组组长，联系 分组组长 将你设置为分组组长。\n怎样联系组长？"
        },
        {
          "title": "权限列表",
          "url": "/documents/manage.html#权限列表",
          "content": "权限列表新用户未加入项目或分组时，我们称为 “游客”。"
        },
        {
          "title": "项目权限",
          "url": "/documents/manage.html#权限列表-项目权限",
          "content": "项目权限\n\n操作\n游客\n项目开发者\n项目组长\n超级管理员\n\n\n\n\n浏览公开项目与接口\n✓\n✓\n✓\n✓\n\n\n浏览私有项目与接口\n\n✓\n✓\n✓\n\n\n编辑项目信息\n\n✓\n✓\n✓\n\n\n新建接口\n\n✓\n✓\n✓\n\n\n编辑接口\n\n✓\n✓\n✓\n\n\n编辑项目头像\n\n\n✓\n✓\n\n\n删除项目\n\n\n✓\n✓\n\n\n"
        },
        {
          "title": "分组权限",
          "url": "/documents/manage.html#权限列表-分组权限",
          "content": "分组权限\n\n操作\n游客\n分组开发者\n分组组长\n超级管理员\n\n\n\n\n浏览分组\n✓\n✓\n✓\n✓\n\n\n在分组中新建项目\n\n✓\n✓\n✓\n\n\n编辑分组信息\n\n\n✓\n✓\n\n\n管理分组成员\n\n\n✓\n✓\n\n\n删除分组\n\n\n✓\n✓\n\n\n"
        }
      ]
    },
    {
      "title": "项目操作",
      "content": "",
      "url": "/documents/project.html",
      "children": [
        {
          "title": "基本设置",
          "url": "/documents/project.html#基本设置",
          "content": "基本设置tag 信息：可自定义tag名称和tag描述，tag信息可用在接口tag标识中;\nmock 严格模式：开启后 mock 请求会对 query，body form 的必须字段和 json schema 进行校验;\n开启json5：开启后允许接口请求body 和返回值中写 json 字段。yapi建议用户关闭 json5， 因为json-schema 格式可以进行接口格式校验。\n"
        },
        {
          "title": "新建项目",
          "url": "/documents/project.html#新建项目",
          "content": "新建项目点击右上角的 + 新建项目，进入新建项目页面。在新建项目页，填写项目信息：\n项目名称不允许重复，包括其他分组\n基本路径为接口统一添加了前缀\n新建项目页只列出了部分配置，其他详细配置(环境配置、项目图标等)需要进入项目页的“设置”面板进行配置。\n\n"
        },
        {
          "title": "修改项目",
          "url": "/documents/project.html#修改项目",
          "content": "修改项目在项目页点击上方的 设置 Tab 进入项目设置面板，这个面板涵盖了项目的所有配置。这里比新建项目页面新增的功能如下："
        },
        {
          "title": "修改项目图标",
          "url": "/documents/project.html#修改项目-修改项目图标",
          "content": "修改项目图标点击项目图标，可以修改图标及背景色："
        },
        {
          "title": "项目迁移",
          "url": "/documents/project.html#项目迁移",
          "content": "项目迁移YApi 中支持项目迁移到不同的分组中。迁移权限： 只有管理员和该项目的 owner 有权限对位置进行修改。项目 owner 主要有创建该项目的人、项目中的组长、创建分组的人、分组中的组长。Tips: owner 权限判断的优先级是 项目权限 > 分组权限\n"
        },
        {
          "title": "项目拷贝",
          "url": "/documents/project.html#项目拷贝",
          "content": "项目拷贝该功能在 v1.3.12 版本上线，项目克隆功能可复制项目全部接口到一个新项目，如下图所示,点击红色框里面的 icon 使用。YApi 支持项目复制功能，但是无法复制项目中的测试集合 list。操作： 点击下图左上角的复制按钮，在弹窗中写入复制项目名称点击确定就可以完成项目复制Tips: 如果你在该分组下有新建项目的权限，那你也同时拥有复制项目的权限\n"
        },
        {
          "title": "删除项目",
          "url": "/documents/project.html#删除项目",
          "content": "删除项目点击下方的删除按钮，输入项目名称进行删除。删除项目是高风险操作，因此 YApi 对这个操作进行了特别的约束。\n"
        },
        {
          "title": "配置环境",
          "url": "/documents/project.html#配置环境",
          "content": "配置环境环境配置 一项可以添加该项目下接口的实际环境，供 接口测试 使用，这里增加了全局 header，可以在项目中设置全局 header 值。在接口运行页面的选择环境 select 中也增加环境配置弹层。v1.3.21 新增全局变量，用户可以在环境列表中定义全局变量的名称和值, 接口运行或者测试集合里面可以通过 {{ global.err }} 来访问当前环境变量下定义的全局变量"
        },
        {
          "title": "请求配置",
          "url": "/documents/project.html#请求配置",
          "content": "请求配置通过自定义 js 脚本方式改变请求的参数和返回的 response 数据"
        },
        {
          "title": "请求参数示例",
          "url": "/documents/project.html#请求配置-请求参数示例",
          "content": "请求参数示例以 jquery ajax 为例，假设当前的请求参数是{  url: '/api/user?id=1',\n  method: 'POST',\n  headers: {\n    xxx: 'xxx'\n  },\n  data: {\n    type: 1\n  }\n}\n那么公共变量 context 包含以下属性：context = {  pathname: '/api/user',\n  query: {\n    id: 1\n  },\n  requestHeader: {\n    xxx: 'xxx'\n  },\n  method: 'POST',\n  requestBody: {\n    type:1\n  }\n}\n假设我们需要在一组接口的 url 上增加一个公共的 token 参数，可以写如下自定义脚本：context.query.token = context.utils.md5(context.pathname + 'salt');"
        },
        {
          "title": "返回数据示例",
          "url": "/documents/project.html#请求配置-返回数据示例",
          "content": "返回数据示例在上面的示例请求完成后，假设返回 responseData={a:1},公共变量 context 包含以下属性：context = {  pathname: '/api/user',\n  query: {\n    id: 1\n  },\n  requestHeader: {\n    xxx: 'xxx'\n  },\n  method: 'POST',\n  requestBody: {\n    type:1\n  },\n  responseData: {\n    a:1\n  },\n  responseHeader: {\n    content-type: 'application/json'\n    ...\n  }\n}\n假设我们需要修改响应数据 responseData a 的值为 2，可以填写如下自定义脚本：context.responseData.a = 2;\n（v1.3.16+新增）context.href 和 context.hostname\n（v1.3.17+新增）context.caseId 测试用例的唯一 key 值\n"
        },
        {
          "title": "工具函数",
          "url": "/documents/project.html#请求配置-工具函数",
          "content": "工具函数context.utils = {  _         //underscore 函数,详细 API 查看官网 http://underscorejs.org/\n  CryptoJS  // crypto-js（v1.3.21+新增）, 详细用法看 https://github.com/brix/crypto-js\n  base64    //转换字符串为 base64 编码\n  md5       //转换字符串为 md5 编码\n  sha1      //转换字符串为 sha1 编码\n  sha224    //转换字符串为 sha224 编码\n  sha256    //转换字符串为 sha256 编码\n  sha384    //转换字符串为 sha384 编码\n  sha512    //转换字符串为 sha512 编码\n  unbase64  //转换 base64 编码为字符串  \n  axios     // axios 库，可用于 api 请求，官网 https://github.com/axios/axios\n}\nCryptoJS 具体用法var data = [{ id: 1 }, { id: 2 }];\n// Encrypt\nvar ciphertext = context.utils.CryptoJS.AES.encrypt(JSON.stringify(data), 'secret key 123');\n\n// Decrypt\nvar bytes = context.utils.CryptoJS.AES.decrypt(ciphertext.toString(), 'secret key 123');\nvar decryptedData = JSON.parse(bytes.toString(CryptoJS.enc.Utf8));\n\nconsole.log('decryptedData', decryptedData);\n"
        },
        {
          "title": "异步处理（v1.3.13+支持）",
          "url": "/documents/project.html#请求配置-异步处理（v1.3.13+支持）",
          "content": "异步处理（v1.3.13+支持）处理请求参数，或返回数据，可能还会涉及到异步处理，比如 ajax 请求，YApi 在 v1.3.13 版本支持了异步处理。context.promise = new Promise(function(resolve) {  var api = context.utils.axios.get('http://yapi.local.qunar.com:3000/api/user/status');\n  api.then(function(result) {\n    //...\n    console.log(result.data);\n    resolve();\n  });\n});\npromise 还可以来设置接口延迟context.promise = new Promise(function(resolve) {  setTimeout(function() {\n    console.log('delay 1000ms');\n    resolve('ok');\n  }, 1000);\n});\n使用方法就是在 context 里面添加 promise 参数,并且返回一个 Promise，不熟悉 Promise 的童鞋可以查下相关用法，ajax 请求可以使用 context.utils.axios 库。处理完成后，不要忘记 resolve()，不然会一直处于挂起状态\n"
        },
        {
          "title": "token配置",
          "url": "/documents/project.html#token配置",
          "content": "token配置每个项目都有唯一的标识 token，用户可以使用这个 token 值来请求 openapi。openapi 文档地址"
        },
        {
          "title": "全局mock",
          "url": "/documents/project.html#全局mock",
          "content": "全局mockv1.3.21 新增全局 mock 设置，方便用户在项目层面上全局设置公共的mock数据，具体 mock 脚本详细使用方法详见 自定义 Mock 脚本可以针对项目自定义 Mock 占位符，具体使用方法如下：Random.extend({    constellation: function(date) {\n        var constellations = ['白羊座', '金牛座', '双子座', '巨蟹座', '狮子座', '处女座', '天秤座', '天蝎座', '射手座', '摩羯座', '水瓶座', '双鱼座']\n        return this.pick(constellations)\n    }\n})\n\n在接口编辑中使用{  \"data\": \"@CONSTELLATION\"   // => \"水瓶座\"\n}\n"
        },
        {
          "title": "Mock 优先级说明",
          "url": "/documents/project.html#全局mock-mock-优先级说明",
          "content": "Mock 优先级说明请求 Mock 数据时，规则匹配优先级：Mock 期望 > 自定义 Mock 脚本 > 项目全局 mock 脚本 > 普通 Mock。如果前面匹配到 Mock 数据，后面 Mock 则不返回。"
        }
      ]
    },
    {
      "title": "项目操作",
      "content": "",
      "url": "/documents/project.html",
      "children": [
        {
          "title": "基本设置",
          "url": "/documents/project.html#基本设置",
          "content": "基本设置tag 信息：可自定义tag名称和tag描述，tag信息可用在接口tag标识中;\nmock 严格模式：开启后 mock 请求会对 query，body form 的必须字段和 json schema 进行校验;\n开启json5：开启后允许接口请求body 和返回值中写 json 字段。yapi建议用户关闭 json5， 因为json-schema 格式可以进行接口格式校验。\n"
        },
        {
          "title": "新建项目",
          "url": "/documents/project.html#新建项目",
          "content": "新建项目点击右上角的 + 新建项目，进入新建项目页面。在新建项目页，填写项目信息：\n项目名称不允许重复，包括其他分组\n基本路径为接口统一添加了前缀\n新建项目页只列出了部分配置，其他详细配置(环境配置、项目图标等)需要进入项目页的“设置”面板进行配置。\n\n"
        },
        {
          "title": "修改项目",
          "url": "/documents/project.html#修改项目",
          "content": "修改项目在项目页点击上方的 设置 Tab 进入项目设置面板，这个面板涵盖了项目的所有配置。这里比新建项目页面新增的功能如下："
        },
        {
          "title": "修改项目图标",
          "url": "/documents/project.html#修改项目-修改项目图标",
          "content": "修改项目图标点击项目图标，可以修改图标及背景色："
        },
        {
          "title": "项目迁移",
          "url": "/documents/project.html#项目迁移",
          "content": "项目迁移YApi 中支持项目迁移到不同的分组中。迁移权限： 只有管理员和该项目的 owner 有权限对位置进行修改。项目 owner 主要有创建该项目的人、项目中的组长、创建分组的人、分组中的组长。Tips: owner 权限判断的优先级是 项目权限 > 分组权限\n"
        },
        {
          "title": "项目拷贝",
          "url": "/documents/project.html#项目拷贝",
          "content": "项目拷贝该功能在 v1.3.12 版本上线，项目克隆功能可复制项目全部接口到一个新项目，如下图所示,点击红色框里面的 icon 使用。YApi 支持项目复制功能，但是无法复制项目中的测试集合 list。操作： 点击下图左上角的复制按钮，在弹窗中写入复制项目名称点击确定就可以完成项目复制Tips: 如果你在该分组下有新建项目的权限，那你也同时拥有复制项目的权限\n"
        },
        {
          "title": "删除项目",
          "url": "/documents/project.html#删除项目",
          "content": "删除项目点击下方的删除按钮，输入项目名称进行删除。删除项目是高风险操作，因此 YApi 对这个操作进行了特别的约束。\n"
        },
        {
          "title": "配置环境",
          "url": "/documents/project.html#配置环境",
          "content": "配置环境环境配置 一项可以添加该项目下接口的实际环境，供 接口测试 使用，这里增加了全局 header，可以在项目中设置全局 header 值。在接口运行页面的选择环境 select 中也增加环境配置弹层。v1.3.21 新增全局变量，用户可以在环境列表中定义全局变量的名称和值, 接口运行或者测试集合里面可以通过 {{ global.err }} 来访问当前环境变量下定义的全局变量"
        },
        {
          "title": "请求配置",
          "url": "/documents/project.html#请求配置",
          "content": "请求配置通过自定义 js 脚本方式改变请求的参数和返回的 response 数据"
        },
        {
          "title": "请求参数示例",
          "url": "/documents/project.html#请求配置-请求参数示例",
          "content": "请求参数示例以 jquery ajax 为例，假设当前的请求参数是{  url: '/api/user?id=1',\n  method: 'POST',\n  headers: {\n    xxx: 'xxx'\n  },\n  data: {\n    type: 1\n  }\n}\n那么公共变量 context 包含以下属性：context = {  pathname: '/api/user',\n  query: {\n    id: 1\n  },\n  requestHeader: {\n    xxx: 'xxx'\n  },\n  method: 'POST',\n  requestBody: {\n    type:1\n  }\n}\n假设我们需要在一组接口的 url 上增加一个公共的 token 参数，可以写如下自定义脚本：context.query.token = context.utils.md5(context.pathname + 'salt');"
        },
        {
          "title": "返回数据示例",
          "url": "/documents/project.html#请求配置-返回数据示例",
          "content": "返回数据示例在上面的示例请求完成后，假设返回 responseData={a:1},公共变量 context 包含以下属性：context = {  pathname: '/api/user',\n  query: {\n    id: 1\n  },\n  requestHeader: {\n    xxx: 'xxx'\n  },\n  method: 'POST',\n  requestBody: {\n    type:1\n  },\n  responseData: {\n    a:1\n  },\n  responseHeader: {\n    content-type: 'application/json'\n    ...\n  }\n}\n假设我们需要修改响应数据 responseData a 的值为 2，可以填写如下自定义脚本：context.responseData.a = 2;\n（v1.3.16+新增）context.href 和 context.hostname\n（v1.3.17+新增）context.caseId 测试用例的唯一 key 值\n"
        },
        {
          "title": "工具函数",
          "url": "/documents/project.html#请求配置-工具函数",
          "content": "工具函数context.utils = {  _         //underscore 函数,详细 API 查看官网 http://underscorejs.org/\n  CryptoJS  // crypto-js（v1.3.21+新增）, 详细用法看 https://github.com/brix/crypto-js\n  base64    //转换字符串为 base64 编码\n  md5       //转换字符串为 md5 编码\n  sha1      //转换字符串为 sha1 编码\n  sha224    //转换字符串为 sha224 编码\n  sha256    //转换字符串为 sha256 编码\n  sha384    //转换字符串为 sha384 编码\n  sha512    //转换字符串为 sha512 编码\n  unbase64  //转换 base64 编码为字符串  \n  axios     // axios 库，可用于 api 请求，官网 https://github.com/axios/axios\n}\nCryptoJS 具体用法var data = [{ id: 1 }, { id: 2 }];\n// Encrypt\nvar ciphertext = context.utils.CryptoJS.AES.encrypt(JSON.stringify(data), 'secret key 123');\n\n// Decrypt\nvar bytes = context.utils.CryptoJS.AES.decrypt(ciphertext.toString(), 'secret key 123');\nvar decryptedData = JSON.parse(bytes.toString(CryptoJS.enc.Utf8));\n\nconsole.log('decryptedData', decryptedData);\n"
        },
        {
          "title": "异步处理（v1.3.13+支持）",
          "url": "/documents/project.html#请求配置-异步处理（v1.3.13+支持）",
          "content": "异步处理（v1.3.13+支持）处理请求参数，或返回数据，可能还会涉及到异步处理，比如 ajax 请求，YApi 在 v1.3.13 版本支持了异步处理。context.promise = new Promise(function(resolve) {  var api = context.utils.axios.get('http://yapi.local.qunar.com:3000/api/user/status');\n  api.then(function(result) {\n    //...\n    console.log(result.data);\n    resolve();\n  });\n});\npromise 还可以来设置接口延迟context.promise = new Promise(function(resolve) {  setTimeout(function() {\n    console.log('delay 1000ms');\n    resolve('ok');\n  }, 1000);\n});\n使用方法就是在 context 里面添加 promise 参数,并且返回一个 Promise，不熟悉 Promise 的童鞋可以查下相关用法，ajax 请求可以使用 context.utils.axios 库。处理完成后，不要忘记 resolve()，不然会一直处于挂起状态\n"
        },
        {
          "title": "token配置",
          "url": "/documents/project.html#token配置",
          "content": "token配置每个项目都有唯一的标识 token，用户可以使用这个 token 值来请求 openapi。openapi 文档地址"
        },
        {
          "title": "全局mock",
          "url": "/documents/project.html#全局mock",
          "content": "全局mockv1.3.21 新增全局 mock 设置，方便用户在项目层面上全局设置公共的mock数据，具体 mock 脚本详细使用方法详见 自定义 Mock 脚本可以针对项目自定义 Mock 占位符，具体使用方法如下：Random.extend({    constellation: function(date) {\n        var constellations = ['白羊座', '金牛座', '双子座', '巨蟹座', '狮子座', '处女座', '天秤座', '天蝎座', '射手座', '摩羯座', '水瓶座', '双鱼座']\n        return this.pick(constellations)\n    }\n})\n\n在接口编辑中使用{  \"data\": \"@CONSTELLATION\"   // => \"水瓶座\"\n}\n"
        },
        {
          "title": "Mock 优先级说明",
          "url": "/documents/project.html#全局mock-mock-优先级说明",
          "content": "Mock 优先级说明请求 Mock 数据时，规则匹配优先级：Mock 期望 > 自定义 Mock 脚本 > 项目全局 mock 脚本 > 普通 Mock。如果前面匹配到 Mock 数据，后面 Mock 则不返回。"
        }
      ]
    },
    {
      "title": "接口设置",
      "content": "进入项目页，可以看到项目下的所有接口，需要注意的是，YApi有 接口集合 和 测试集合 两个概念。接口集合 将接口进行分类，使接口结构更清晰，一个接口只能属于一个集合，且不允许与其他接口重名。\n测试集合 为了方便我们测试接口，测试集合 将若干接口组合在一起，在这里一个接口可以属于不同集合。\n",
      "url": "/documents/api.html",
      "children": [
        {
          "title": "接口配置",
          "url": "/documents/api.html#接口配置",
          "content": "接口配置新建接口 后，点击新添加的接口，右侧可以看到接口的预览信息，点击右侧的 编辑 Tab项进入编辑面板。在该面板中你可以看到接口的基本信息(接口名称、分类、路径)，除此以外，你还可以完善以下接口信息："
        },
        {
          "title": "基本设置",
          "url": "/documents/api.html#接口配置-基本设置",
          "content": "基本设置接口路径：可以更改 HTTP 请求方式，并且支持 restful 动态路由，例如 /api/{id}/{name}, id和name是动态参数\n选择分类：可以更改接口所在分类\n状态：用于标识接口是否开发完成。\nTag：用于标识接口tag信息（v1.3.23+）,在接口list页可以根据tag过滤接口\n"
        },
        {
          "title": "请求参数设置",
          "url": "/documents/api.html#接口配置-请求参数设置",
          "content": "请求参数设置Query参数： 接口 url 的查询字符串，点击『添加Query参数』按钮来添加参数，可以通过拖动来交换参数位置\n请求Body：http 请求 body 部分，如果http请求方式是 post, put 等请求方式时会有 req_body 部分。req_body_type 形式有4种，分别是 form, json, file 和 raw 。\nHeaders:  http 请求头字段，在 req_body 形式是 form 格式下会在 header 中自动生成 'Content-Type\tapplication/x-www-form-urlencoded'，其他3种格式也会自动生成不同 header\n"
        },
        {
          "title": "返回数据设置",
          "url": "/documents/api.html#接口配置-返回数据设置",
          "content": "返回数据设置返回数据分为 json & raw 两种形式。基于 mockjs （具体使用方法详见Mock 介绍）和 json5，使用注释方式写参数说明。 为了方便数据编写可以按F9来使用全局编辑\n选择json-schema 则进入了 json 结构可视化编辑器形式, 数据以 json schema 格式解析 快速入门 Json Schema 。\n"
        },
        {
          "title": "备注 & 其他",
          "url": "/documents/api.html#接口配置-备注-&-其他",
          "content": "备注 & 其他接口描述: 用简短的文字描述接口的作用。\n邮件通知：开启后将此次接口的改动以邮件的形式发送至项目组所有成员和关注该项目的成员（邮件默认情况下自动开启）\n开放接口：默认为关闭状态，用户可以在 数据导出 时选择只导出公开接口\n"
        },
        {
          "title": "接口运行",
          "url": "/documents/api.html#接口运行",
          "content": "接口运行接口运行功能，是用来测试真实接口的，类似『Postman』的功能。点击运行 tab ,可进入到接口测试页面，首先安装\b『chrome crossRequest』扩展，才可正常使用此功能。点击保存按钮可把当前接口保存到测试集，方便下次调试。安装完插件记得刷新页面\n"
        },
        {
          "title": "接口返回数据验证",
          "url": "/documents/api.html#接口运行-接口返回数据验证",
          "content": "接口返回数据验证版本 v1.3.22 新增返回数据验证功能， 如果接口的返回数据格式为json schema 在接口运行时会对接口返回数据和定义数据格式进行校验"
        }
      ]
    },
    {
      "title": "接口设置",
      "content": "进入项目页，可以看到项目下的所有接口，需要注意的是，YApi有 接口集合 和 测试集合 两个概念。接口集合 将接口进行分类，使接口结构更清晰，一个接口只能属于一个集合，且不允许与其他接口重名。\n测试集合 为了方便我们测试接口，测试集合 将若干接口组合在一起，在这里一个接口可以属于不同集合。\n",
      "url": "/documents/api.html",
      "children": [
        {
          "title": "接口配置",
          "url": "/documents/api.html#接口配置",
          "content": "接口配置新建接口 后，点击新添加的接口，右侧可以看到接口的预览信息，点击右侧的 编辑 Tab项进入编辑面板。在该面板中你可以看到接口的基本信息(接口名称、分类、路径)，除此以外，你还可以完善以下接口信息："
        },
        {
          "title": "基本设置",
          "url": "/documents/api.html#接口配置-基本设置",
          "content": "基本设置接口路径：可以更改 HTTP 请求方式，并且支持 restful 动态路由，例如 /api/{id}/{name}, id和name是动态参数\n选择分类：可以更改接口所在分类\n状态：用于标识接口是否开发完成。\nTag：用于标识接口tag信息（v1.3.23+）,在接口list页可以根据tag过滤接口\n"
        },
        {
          "title": "请求参数设置",
          "url": "/documents/api.html#接口配置-请求参数设置",
          "content": "请求参数设置Query参数： 接口 url 的查询字符串，点击『添加Query参数』按钮来添加参数，可以通过拖动来交换参数位置\n请求Body：http 请求 body 部分，如果http请求方式是 post, put 等请求方式时会有 req_body 部分。req_body_type 形式有4种，分别是 form, json, file 和 raw 。\nHeaders:  http 请求头字段，在 req_body 形式是 form 格式下会在 header 中自动生成 'Content-Type\tapplication/x-www-form-urlencoded'，其他3种格式也会自动生成不同 header\n"
        },
        {
          "title": "返回数据设置",
          "url": "/documents/api.html#接口配置-返回数据设置",
          "content": "返回数据设置返回数据分为 json & raw 两种形式。基于 mockjs （具体使用方法详见Mock 介绍）和 json5，使用注释方式写参数说明。 为了方便数据编写可以按F9来使用全局编辑\n选择json-schema 则进入了 json 结构可视化编辑器形式, 数据以 json schema 格式解析 快速入门 Json Schema 。\n"
        },
        {
          "title": "备注 & 其他",
          "url": "/documents/api.html#接口配置-备注-&-其他",
          "content": "备注 & 其他接口描述: 用简短的文字描述接口的作用。\n邮件通知：开启后将此次接口的改动以邮件的形式发送至项目组所有成员和关注该项目的成员（邮件默认情况下自动开启）\n开放接口：默认为关闭状态，用户可以在 数据导出 时选择只导出公开接口\n"
        },
        {
          "title": "接口运行",
          "url": "/documents/api.html#接口运行",
          "content": "接口运行接口运行功能，是用来测试真实接口的，类似『Postman』的功能。点击运行 tab ,可进入到接口测试页面，首先安装\b『chrome crossRequest』扩展，才可正常使用此功能。点击保存按钮可把当前接口保存到测试集，方便下次调试。安装完插件记得刷新页面\n"
        },
        {
          "title": "接口返回数据验证",
          "url": "/documents/api.html#接口运行-接口返回数据验证",
          "content": "接口返回数据验证版本 v1.3.22 新增返回数据验证功能， 如果接口的返回数据格式为json schema 在接口运行时会对接口返回数据和定义数据格式进行校验"
        }
      ]
    },
    {
      "title": "Mock介绍",
      "content": " YApi的 Mock 功能可以根据用户的输入接口信息如协议、URL、接口名、请求头、请求参数、返回数据（[返回数据](#mock)）生成 Mock 接口，这些接口会自动生成模拟数据，创建者可以自由构造需要的数据。 mock地址解析：YApi平台网址 + mock + 您的项目id +\b 接口实际请求path假设你 YApi 的部署地址为：http://yapi.xxx.com 然后用这个地址作为示例mockd 地址： http://yapi.xxx.com/mock/29/api/hackathon/login注：项目 id 可以在项目设置里查看到\n",
      "url": "/documents/mock.html",
      "children": [
        {
          "title": "定义 mock 数据示例",
          "url": "/documents/mock.html#定义-mock-数据示例",
          "content": "定义 mock 数据示例项目 -> 接口编辑 -> 返回数据设置返回数据设置有两种方式，最新版本默认是基于 json+注释 的方式，另外一种是基于 json-schema 定义数据结构,请根据实际情况灵活选择使用。"
        },
        {
          "title": "方式1. mockjs",
          "url": "/documents/mock.html#方式1.-mockjs",
          "content": "方式1. mockjs"
        },
        {
          "title": "原理",
          "url": "/documents/mock.html#方式1.-mockjs-原理",
          "content": "原理基于 mockjs，跟 Mockjs 区别是 yapi 基于 json + 注释 定义 mock 数据，无法使用 mockjs 原有的函数功能。正则表达式需要基于 rule 书写，示例如下：\n{  \"name|regexp\": \"[a-z0-9_]+?\",\n  \"type|regexp\": \"json|text|xml\"\n}\n\n支持替换请求的 query, body 参数\n{  \"name\": \"${query.name}\", //请求的url是/path?name=xiaoming, 返回的name字段是xiaoming\n  \"type\": \"${body.type}\",   //请求的requestBody type=1,返回的type字段是1\n  \n}\n\n示例\n/** * 这是一个接口返回数据示例\n */\n\n{\n    \"errcode\": 0,\n    \"errmsg\": \"@word\",\n    \"data\": {\n        \"id\": \"@id\", //@id 随机生成 id\n        \"name\": \"@name\" //@name 随机生成用户名\n    }\n}\n\n详细使用文档请查看：Mockjs 官网"
        },
        {
          "title": "方式2. json-schema",
          "url": "/documents/mock.html#方式2.-json-schema",
          "content": "方式2. json-schema开启 json-schema 功能后，根据 json-schema 定义的数据结构，生成随机数据。"
        },
        {
          "title": "如何生成随机的邮箱或 ip(该方法在v1.3.22之后不再适用)？",
          "url": "/documents/mock.html#方式2.-json-schema-如何生成随机的邮箱或-ip该方法在v1.3.22之后不再适用？",
          "content": "如何生成随机的邮箱或 ip(该方法在v1.3.22之后不再适用)？点击高级设置，选择 format 选项，比如选择 email 则该字段生成随机邮箱字符串。"
        },
        {
          "title": "集成 mockjs",
          "url": "/documents/mock.html#方式2.-json-schema-集成-mockjs",
          "content": "集成 mockjs基本书写方式为 mock 的数据占位符@xxx, 具体字段详见Mockjs 官网\n如果不是以@字符开头的话或者匹配不到Mockjs中的占位符就会直接生成输入的值\n"
        },
        {
          "title": "如何使用 Mock",
          "url": "/documents/mock.html#如何使用-mock",
          "content": "如何使用 Mock"
        },
        {
          "title": "1 在 js 代码直接请求yapi提供的 mock 地址（不用担心跨域问题）",
          "url": "/documents/mock.html#如何使用-mock-1-在-js-代码直接请求yapi提供的-mock-地址（不用担心跨域问题）",
          "content": "1 在 js 代码直接请求yapi提供的 mock 地址（不用担心跨域问题）在代码直接请求 yapi 提供的 mock 地址，以 jQuery 为例：let prefix = 'http://yapi.xxx.com/mock/2817'$.post(prefix+'/baseapi/path', {username: 'xxx'}, function(res){\n    console.log(res) //返回上图预览部分的数据\n})\n"
        },
        {
          "title": "2 \b基于本地服务器反向代理",
          "url": "/documents/mock.html#如何使用-mock-2-\b基于本地服务器反向代理",
          "content": "2 \b基于本地服务器反向代理优点:不用修改项目代码2.1 基于 nginx 反向代理location /baseapi{\nproxy_pass   http://yapi.xxx.com/mock/2817/baseapi; #baseapi后面没有\"/\"\n}\n2.2 基于 ykit mock功能{    pattern: /\\/api\\/(.*)/,\n    responder: 'http://yapi.xxx.com/mock/58/api/$1'\n}\n上面通过正则匹配，将所有接口转到 http://yapi.xxx.com 上，比如 http://localhost/api/user/status 会成为 http://yapi.xxx.com/mock/58/api/user/status详细使用指南: ykit-config-mock2.3 基于 ykit Jerry 代理假设您本地服务器访问地址是： http://xxx.com具体用法如下：清除本地配置的 hosts\n下载 Chrome 插件 SwitchyOmega 点击“选项” => 新建情景模式 设置代理服务器 127.0.0.1 代理端口 999\n启动 sudo ykit s -x 浏览器访问 http://127.0.0.1:1334/jerry\n在 jerry 中重新配置 hosts\n在 Jerry 中点击 URL MAP 并添加配置\n详细使用指南: 代理工具2.4 基于 Charles 代理点击 Charles 工具栏下的 tools >> Rewrite Settings 填写如下信息："
        },
        {
          "title": "mock请求严格模式",
          "url": "/documents/mock.html#mock请求严格模式",
          "content": "mock请求严格模式版本 v1.3.22 新增 mock 接口请求字段参数验证功能，具体使用方法如下：\n打开 项目 -> 设置 开启 mock 严格模式\n\n\n针对 query, form 中设置的必须字段会进行必填校验\n\n\n\n针对 req_body_type 是json schema 格式的数据进行校验\n\n"
        }
      ]
    },
    {
      "title": "Mock介绍",
      "content": " YApi的 Mock 功能可以根据用户的输入接口信息如协议、URL、接口名、请求头、请求参数、返回数据（[返回数据](#mock)）生成 Mock 接口，这些接口会自动生成模拟数据，创建者可以自由构造需要的数据。 mock地址解析：YApi平台网址 + mock + 您的项目id +\b 接口实际请求path假设你 YApi 的部署地址为：http://yapi.xxx.com 然后用这个地址作为示例mockd 地址： http://yapi.xxx.com/mock/29/api/hackathon/login注：项目 id 可以在项目设置里查看到\n",
      "url": "/documents/mock.html",
      "children": [
        {
          "title": "定义 mock 数据示例",
          "url": "/documents/mock.html#定义-mock-数据示例",
          "content": "定义 mock 数据示例项目 -> 接口编辑 -> 返回数据设置返回数据设置有两种方式，最新版本默认是基于 json+注释 的方式，另外一种是基于 json-schema 定义数据结构,请根据实际情况灵活选择使用。"
        },
        {
          "title": "方式1. mockjs",
          "url": "/documents/mock.html#方式1.-mockjs",
          "content": "方式1. mockjs"
        },
        {
          "title": "原理",
          "url": "/documents/mock.html#方式1.-mockjs-原理",
          "content": "原理基于 mockjs，跟 Mockjs 区别是 yapi 基于 json + 注释 定义 mock 数据，无法使用 mockjs 原有的函数功能。正则表达式需要基于 rule 书写，示例如下：\n{  \"name|regexp\": \"[a-z0-9_]+?\",\n  \"type|regexp\": \"json|text|xml\"\n}\n\n支持替换请求的 query, body 参数\n{  \"name\": \"${query.name}\", //请求的url是/path?name=xiaoming, 返回的name字段是xiaoming\n  \"type\": \"${body.type}\",   //请求的requestBody type=1,返回的type字段是1\n  \n}\n\n示例\n/** * 这是一个接口返回数据示例\n */\n\n{\n    \"errcode\": 0,\n    \"errmsg\": \"@word\",\n    \"data\": {\n        \"id\": \"@id\", //@id 随机生成 id\n        \"name\": \"@name\" //@name 随机生成用户名\n    }\n}\n\n详细使用文档请查看：Mockjs 官网"
        },
        {
          "title": "方式2. json-schema",
          "url": "/documents/mock.html#方式2.-json-schema",
          "content": "方式2. json-schema开启 json-schema 功能后，根据 json-schema 定义的数据结构，生成随机数据。"
        },
        {
          "title": "如何生成随机的邮箱或 ip(该方法在v1.3.22之后不再适用)？",
          "url": "/documents/mock.html#方式2.-json-schema-如何生成随机的邮箱或-ip该方法在v1.3.22之后不再适用？",
          "content": "如何生成随机的邮箱或 ip(该方法在v1.3.22之后不再适用)？点击高级设置，选择 format 选项，比如选择 email 则该字段生成随机邮箱字符串。"
        },
        {
          "title": "集成 mockjs",
          "url": "/documents/mock.html#方式2.-json-schema-集成-mockjs",
          "content": "集成 mockjs基本书写方式为 mock 的数据占位符@xxx, 具体字段详见Mockjs 官网\n如果不是以@字符开头的话或者匹配不到Mockjs中的占位符就会直接生成输入的值\n"
        },
        {
          "title": "如何使用 Mock",
          "url": "/documents/mock.html#如何使用-mock",
          "content": "如何使用 Mock"
        },
        {
          "title": "1 在 js 代码直接请求yapi提供的 mock 地址（不用担心跨域问题）",
          "url": "/documents/mock.html#如何使用-mock-1-在-js-代码直接请求yapi提供的-mock-地址（不用担心跨域问题）",
          "content": "1 在 js 代码直接请求yapi提供的 mock 地址（不用担心跨域问题）在代码直接请求 yapi 提供的 mock 地址，以 jQuery 为例：let prefix = 'http://yapi.xxx.com/mock/2817'$.post(prefix+'/baseapi/path', {username: 'xxx'}, function(res){\n    console.log(res) //返回上图预览部分的数据\n})\n"
        },
        {
          "title": "2 \b基于本地服务器反向代理",
          "url": "/documents/mock.html#如何使用-mock-2-\b基于本地服务器反向代理",
          "content": "2 \b基于本地服务器反向代理优点:不用修改项目代码2.1 基于 nginx 反向代理location /baseapi{\nproxy_pass   http://yapi.xxx.com/mock/2817/baseapi; #baseapi后面没有\"/\"\n}\n2.2 基于 ykit mock功能{    pattern: /\\/api\\/(.*)/,\n    responder: 'http://yapi.xxx.com/mock/58/api/$1'\n}\n上面通过正则匹配，将所有接口转到 http://yapi.xxx.com 上，比如 http://localhost/api/user/status 会成为 http://yapi.xxx.com/mock/58/api/user/status详细使用指南: ykit-config-mock2.3 基于 ykit Jerry 代理假设您本地服务器访问地址是： http://xxx.com具体用法如下：清除本地配置的 hosts\n下载 Chrome 插件 SwitchyOmega 点击“选项” => 新建情景模式 设置代理服务器 127.0.0.1 代理端口 999\n启动 sudo ykit s -x 浏览器访问 http://127.0.0.1:1334/jerry\n在 jerry 中重新配置 hosts\n在 Jerry 中点击 URL MAP 并添加配置\n详细使用指南: 代理工具2.4 基于 Charles 代理点击 Charles 工具栏下的 tools >> Rewrite Settings 填写如下信息："
        },
        {
          "title": "mock请求严格模式",
          "url": "/documents/mock.html#mock请求严格模式",
          "content": "mock请求严格模式版本 v1.3.22 新增 mock 接口请求字段参数验证功能，具体使用方法如下：\n打开 项目 -> 设置 开启 mock 严格模式\n\n\n针对 query, form 中设置的必须字段会进行必填校验\n\n\n\n针对 req_body_type 是json schema 格式的数据进行校验\n\n"
        }
      ]
    },
    {
      "title": "高级Mock",
      "content": "高级 Mock 分为Mock 期望和自定义 Mock 脚本两种方式。",
      "url": "/documents/adv_mock.html",
      "children": [
        {
          "title": "Mock 期望",
          "url": "/documents/adv_mock.html#mock-期望",
          "content": "Mock 期望在测试时，很多时候需要根据不同的请求参数、IP 返回不同的 HTTP Code、HTTP 头和 JSON 数据。Mock 期望就是根据设置的请求过滤规则，返回期望数据。"
        },
        {
          "title": "使用方法",
          "url": "/documents/adv_mock.html#mock-期望-使用方法",
          "content": "使用方法进入接口详情页，点击『高级 Mock』选项。\n2. 点击『添加期望』，填写过滤规则以及期望返回数据，点击『确定』保存。\n3. 然后尝试在浏览器里发送符合规则的请求，查看返回的数据是否符合期望。\n"
        },
        {
          "title": "期望填写",
          "url": "/documents/adv_mock.html#mock-期望-期望填写",
          "content": "期望填写基本信息期望名称：给此条期望命名\nIP 过滤：请求的 IP 是设置的地址才可能返回期望。默认 IP 过滤关闭，任何 IP 地址都可能返回期望。\n参数过滤：请求必须包含设置的参数，并且值相等才可能返回期望。参数可以在 Body 或 Query 中。\n响应HTTP Code：期望响应的 HTTP 状态码\n延时：期望响应的延迟时间\nHTTP 头：期望响应带有的 HTTP 头\n返回 JSON：期望返回的 JSON 数据\n"
        },
        {
          "title": "自定义 Mock 脚本",
          "url": "/documents/adv_mock.html#自定义-mock-脚本",
          "content": "自定义 Mock 脚本在前端开发阶段，对于某些接口，业务相对复杂，而 UI 端也需要根据接口返回的不同内容去做相应的处理。YApi 提供了写\b JS 脚本方式处理这一问题，可以根据用户请求的参数修改返回内容。"
        },
        {
          "title": "全局变量",
          "url": "/documents/adv_mock.html#自定义-mock-脚本-全局变量",
          "content": "全局变量请求header 请求的 HTTP 头\nparams 请求参数，包括 Body、Query 中所有参数\ncookie 请求带的 Cookies\n响应\nmockJson\n接口定义的响应数据 Mock 模板\n\n\nresHeader\n响应的 HTTP 头\n\n\nhttpCode\n响应的 HTTP 状态码\n\n\ndelay\nMock 响应延时，单位为 ms\n\n\nRandom\nMock.Random 方法，可以添加自定义占位符,详细使用方法请查看 Wiki\n\n"
        },
        {
          "title": "使用方法",
          "url": "/documents/adv_mock.html#自定义-mock-脚本-使用方法",
          "content": "使用方法首先开启此功能\nMock 脚本就是用 JavaScript 对 mockJson 变量修改,请避免被全局变量(httpCode, resHeader, delay)的修改\n"
        },
        {
          "title": "示例1, 根据请求参数重写 mockJson",
          "url": "/documents/adv_mock.html#自定义-mock-脚本-示例1,-根据请求参数重写-mockjson",
          "content": "示例1, 根据请求参数重写 mockJsonif(params.type == 1){  mockJson.errcode = 400;\n  mockJson.errmsg = 'error';\n}\n\nif(header.token == 't'){\n  mockJson.errcode = 300;\n  mockJson.errmsg = 'error';\n}\n\nif(cookie.type == 'a'){\n  mockJson.errcode = 500;\n  mockJson.errmsg = 'error';\n}\n\n"
        },
        {
          "title": "示例2, 生成高度自定义数据内容",
          "url": "/documents/adv_mock.html#自定义-mock-脚本-示例2,-生成高度自定义数据内容",
          "content": "示例2, 生成高度自定义数据内容var a = [1,1,1,1,1,1,1,1,1,1]\nmockJson = {\n    errcode: 0,\n    email: Random.email('qq.com'),\n    data: a.map(function(item){\n        return Random.city() + '银行'\n    })\n}\n\n"
        },
        {
          "title": "Mock 优先级说明",
          "url": "/documents/adv_mock.html#mock-优先级说明",
          "content": "Mock 优先级说明请求 Mock 数据时，规则匹配优先级：Mock 期望 > 自定义 Mock 脚本 > 项目全局 mock 脚本 > 普通 Mock。如果前面匹配到 Mock 数据，后面 Mock 则不返回。"
        }
      ]
    },
    {
      "title": "高级Mock",
      "content": "高级 Mock 分为Mock 期望和自定义 Mock 脚本两种方式。",
      "url": "/documents/adv_mock.html",
      "children": [
        {
          "title": "Mock 期望",
          "url": "/documents/adv_mock.html#mock-期望",
          "content": "Mock 期望在测试时，很多时候需要根据不同的请求参数、IP 返回不同的 HTTP Code、HTTP 头和 JSON 数据。Mock 期望就是根据设置的请求过滤规则，返回期望数据。"
        },
        {
          "title": "使用方法",
          "url": "/documents/adv_mock.html#mock-期望-使用方法",
          "content": "使用方法进入接口详情页，点击『高级 Mock』选项。\n2. 点击『添加期望』，填写过滤规则以及期望返回数据，点击『确定』保存。\n3. 然后尝试在浏览器里发送符合规则的请求，查看返回的数据是否符合期望。\n"
        },
        {
          "title": "期望填写",
          "url": "/documents/adv_mock.html#mock-期望-期望填写",
          "content": "期望填写基本信息期望名称：给此条期望命名\nIP 过滤：请求的 IP 是设置的地址才可能返回期望。默认 IP 过滤关闭，任何 IP 地址都可能返回期望。\n参数过滤：请求必须包含设置的参数，并且值相等才可能返回期望。参数可以在 Body 或 Query 中。\n响应HTTP Code：期望响应的 HTTP 状态码\n延时：期望响应的延迟时间\nHTTP 头：期望响应带有的 HTTP 头\n返回 JSON：期望返回的 JSON 数据\n"
        },
        {
          "title": "自定义 Mock 脚本",
          "url": "/documents/adv_mock.html#自定义-mock-脚本",
          "content": "自定义 Mock 脚本在前端开发阶段，对于某些接口，业务相对复杂，而 UI 端也需要根据接口返回的不同内容去做相应的处理。YApi 提供了写\b JS 脚本方式处理这一问题，可以根据用户请求的参数修改返回内容。"
        },
        {
          "title": "全局变量",
          "url": "/documents/adv_mock.html#自定义-mock-脚本-全局变量",
          "content": "全局变量请求header 请求的 HTTP 头\nparams 请求参数，包括 Body、Query 中所有参数\ncookie 请求带的 Cookies\n响应\nmockJson\n接口定义的响应数据 Mock 模板\n\n\nresHeader\n响应的 HTTP 头\n\n\nhttpCode\n响应的 HTTP 状态码\n\n\ndelay\nMock 响应延时，单位为 ms\n\n\nRandom\nMock.Random 方法，可以添加自定义占位符,详细使用方法请查看 Wiki\n\n"
        },
        {
          "title": "使用方法",
          "url": "/documents/adv_mock.html#自定义-mock-脚本-使用方法",
          "content": "使用方法首先开启此功能\nMock 脚本就是用 JavaScript 对 mockJson 变量修改,请避免被全局变量(httpCode, resHeader, delay)的修改\n"
        },
        {
          "title": "示例1, 根据请求参数重写 mockJson",
          "url": "/documents/adv_mock.html#自定义-mock-脚本-示例1,-根据请求参数重写-mockjson",
          "content": "示例1, 根据请求参数重写 mockJsonif(params.type == 1){  mockJson.errcode = 400;\n  mockJson.errmsg = 'error';\n}\n\nif(header.token == 't'){\n  mockJson.errcode = 300;\n  mockJson.errmsg = 'error';\n}\n\nif(cookie.type == 'a'){\n  mockJson.errcode = 500;\n  mockJson.errmsg = 'error';\n}\n\n"
        },
        {
          "title": "示例2, 生成高度自定义数据内容",
          "url": "/documents/adv_mock.html#自定义-mock-脚本-示例2,-生成高度自定义数据内容",
          "content": "示例2, 生成高度自定义数据内容var a = [1,1,1,1,1,1,1,1,1,1]\nmockJson = {\n    errcode: 0,\n    email: Random.email('qq.com'),\n    data: a.map(function(item){\n        return Random.city() + '银行'\n    })\n}\n\n"
        },
        {
          "title": "Mock 优先级说明",
          "url": "/documents/adv_mock.html#mock-优先级说明",
          "content": "Mock 优先级说明请求 Mock 数据时，规则匹配优先级：Mock 期望 > 自定义 Mock 脚本 > 项目全局 mock 脚本 > 普通 Mock。如果前面匹配到 Mock 数据，后面 Mock 则不返回。"
        }
      ]
    },
    {
      "title": "自动化测试",
      "content": "传统的接口自动化测试成本高，大量的项目没有使用自动化测试保证接口的质量，仅仅依靠手动测试，是非常不可靠和容易出错的。YApi 为了解决这个问题，开发了可视化接口自动化测试功能，只需要配置每个接口的入参和对 RESPONSE 断言，即可实现对接口的自动化测试，大大提升了接口测试的效率。",
      "url": "/documents/case.html",
      "children": [
        {
          "title": "第一步，测试集合",
          "url": "/documents/case.html#第一步，测试集合",
          "content": "第一步，测试集合使用 YApi 自动化测试，第一步需要做得是创建测试集合和导入接口,点击添加集合创建，创建完成后导入接口(同一个接口可以多次导入)。"
        },
        {
          "title": "第二步，编辑测试用例",
          "url": "/documents/case.html#第二步，编辑测试用例",
          "content": "第二步，编辑测试用例编写测试用例主要涉及两个方面，一个是请求参数，另外一个是断言脚本。"
        },
        {
          "title": "编辑请求参数",
          "url": "/documents/case.html#第二步，编辑测试用例-编辑请求参数",
          "content": "编辑请求参数请求参数可以填写期望的字符串，YApi 还提供了 Mock 参数和 变量参数。Mock参数用来生成随机字符串，变量参数是为了解决请求参数依赖其他接口的返回数据或参数。Mock 参数Mock 参数每次请求都会生成随机字符串变量参数YApi 提供了强大的变量参数功能，你可以在测试的时候使用前面接口的 参数 或 返回值 作为 后面接口的参数，即使接口之间存在依赖，也可以轻松 一键测试~Tips: 参数只能是测试过程中排在前面的接口中的变量参数\n格式：$.{key}.{params|body}.{path}例如：现有两个接口，分别是“导航标题”和“文章列表”文章列表接口需要传参数: 当前标题(id)，而这个 id 需要通过 导航标题 的返回值获取，这时应在 文章列表 的参数输入框中根据前者的 key 找到对应 id。导航标题 的参数和返回值有如下结构：  参数：\n  \n  返回值：\n  \n则 文章列表 的参数可以如下配置：其中 $. 是使用 动态变量 的标志，$.269.params 即表示 key 值为 269 用例的请求参数，$.269.body 即表示 key 值为 269 用例的返回值。如果 requestBody 是 json 格式也可以在 json 中写变量参数，如下图：Tips: 上下拖动测试集合的列表项可以调整测试的顺序。\n目前 yapi 中的query，body,header和pathParam的输入参数已经支持点击选择功能。无需自己填写表达式，只需在弹窗中选择需要展示的表达式即可。 输入选项包括常量，mock数据，在测试集合中也支持变量选择。具体用法：单击编辑按钮打开表达式生成器，点击需要的数据创建表达式，这里也可以实时查看表达式结果。Tips: 在测试集合中插入变量参数可以会出现下图的提示信息，这是正常现象。因为该参数只能在各个接口顺序执行的时候才能拉到变量参数中的值\n"
        },
        {
          "title": "编写断言脚本",
          "url": "/documents/case.html#第二步，编辑测试用例-编写断言脚本",
          "content": "编写断言脚本编写完请求参数，可通过 js 脚本写断言，实现精准测试，在接口用例页面点击 Test 编辑。"
        },
        {
          "title": "第三步，运行自动化测试",
          "url": "/documents/case.html#第三步，运行自动化测试",
          "content": "第三步，运行自动化测试在测试列表可以看到每个测试用例的 key,还有 开始测试、报告等功能点击开始测试会按照 case 定义的参数从上往下一个一个进行测试，如果顺序有问题，可以拖动调整测试完成之后，点击报告查看该次请求的结果"
        },
        {
          "title": "断言脚本公共变量",
          "url": "/documents/case.html#断言脚本公共变量",
          "content": "断言脚本公共变量"
        },
        {
          "title": "1.assert",
          "url": "/documents/case.html#断言脚本公共变量-1.assert",
          "content": "1.assert断言函数，详细 api 可查看 document常用 api\nassert(value)\n判断 value 是否为 truth, 例如 assert(1) 通过， assert(0) 不通过，只要 value 不是 null, 0, false 等值验证通过\n\n\nassert.equal(actual, expected)\n判断 actual 是否等于 expected，例如 assert(1, 1)通过\n\n\nassert.notEqual(actual, expected)\n判断 actual 是否不等于 expected\n\n\nassert.deepEqual(actual, expected)\n假设： actual = {a:1} 是一个对象，即便 expected = {a:1}，如果使用 assert.equal 可能也是不相等的，因为在 js 引用的只是对象的一个指针，需要使用 assert.deepEqual 比较两个对象是否相等\n\n\nassert.notDeepEaual(actual, expected)\n深度比较两个对象是否不相等\n\n2.statushttp 状态码3.paramshttp request params, 合并了 query 和 body4.body返回 response body5.header返回 response header6.records记录的 http 请求信息，假设需要获取 key 为 555 的接口参数或者响应数据，可通过 records[555].params 或 records[555].body 获取7.loglog（message） 函数,调试时使用，log 信息仅仅在断言失败后打印,失败断言前的信息log(234)   assert.equal(status, 400)\nlog(123)\n输出结果：log: 234\nAssertionError: 200 == 400"
        },
        {
          "title": "示例",
          "url": "/documents/case.html#断言脚本公共变量-示例",
          "content": "示例assert.equal(body.errcode, 0)\nassert.equal(body.data.group_name, 'testGroup')\nassert.equal(status, 200)\n"
        },
        {
          "title": "服务端自动化测试",
          "url": "/documents/case.html#服务端自动化测试",
          "content": "服务端自动化测试开始测试功能是在浏览器跑自动化测试，他依赖于浏览器的使用环境。服务端自动化测试功能是在YApi服务端跑自动化测试，不需要依赖浏览器环境，只需要访问 YApi 提供的 url 链接就能跑自动化测试，\b非常的简单易用，\b而且可以集成到 jenkins。"
        },
        {
          "title": "详细使用方法",
          "url": "/documents/case.html#服务端自动化测试-详细使用方法",
          "content": "详细使用方法点击服务端测试，出现如下弹窗，用户访问该 url 就可以获取当前测试用例的所有测试结果。"
        },
        {
          "title": "配置通用规则",
          "url": "/documents/case.html#配置通用规则",
          "content": "配置通用规则配置通用规则能够使自动化测试，可以基于通用的规则去控制，无需手动一个一个维护case."
        }
      ]
    },
    {
      "title": "自动化测试",
      "content": "传统的接口自动化测试成本高，大量的项目没有使用自动化测试保证接口的质量，仅仅依靠手动测试，是非常不可靠和容易出错的。YApi 为了解决这个问题，开发了可视化接口自动化测试功能，只需要配置每个接口的入参和对 RESPONSE 断言，即可实现对接口的自动化测试，大大提升了接口测试的效率。",
      "url": "/documents/case.html",
      "children": [
        {
          "title": "第一步，测试集合",
          "url": "/documents/case.html#第一步，测试集合",
          "content": "第一步，测试集合使用 YApi 自动化测试，第一步需要做得是创建测试集合和导入接口,点击添加集合创建，创建完成后导入接口(同一个接口可以多次导入)。"
        },
        {
          "title": "第二步，编辑测试用例",
          "url": "/documents/case.html#第二步，编辑测试用例",
          "content": "第二步，编辑测试用例编写测试用例主要涉及两个方面，一个是请求参数，另外一个是断言脚本。"
        },
        {
          "title": "编辑请求参数",
          "url": "/documents/case.html#第二步，编辑测试用例-编辑请求参数",
          "content": "编辑请求参数请求参数可以填写期望的字符串，YApi 还提供了 Mock 参数和 变量参数。Mock参数用来生成随机字符串，变量参数是为了解决请求参数依赖其他接口的返回数据或参数。Mock 参数Mock 参数每次请求都会生成随机字符串变量参数YApi 提供了强大的变量参数功能，你可以在测试的时候使用前面接口的 参数 或 返回值 作为 后面接口的参数，即使接口之间存在依赖，也可以轻松 一键测试~Tips: 参数只能是测试过程中排在前面的接口中的变量参数\n格式：$.{key}.{params|body}.{path}例如：现有两个接口，分别是“导航标题”和“文章列表”文章列表接口需要传参数: 当前标题(id)，而这个 id 需要通过 导航标题 的返回值获取，这时应在 文章列表 的参数输入框中根据前者的 key 找到对应 id。导航标题 的参数和返回值有如下结构：  参数：\n  \n  返回值：\n  \n则 文章列表 的参数可以如下配置：其中 $. 是使用 动态变量 的标志，$.269.params 即表示 key 值为 269 用例的请求参数，$.269.body 即表示 key 值为 269 用例的返回值。如果 requestBody 是 json 格式也可以在 json 中写变量参数，如下图：Tips: 上下拖动测试集合的列表项可以调整测试的顺序。\n目前 yapi 中的query，body,header和pathParam的输入参数已经支持点击选择功能。无需自己填写表达式，只需在弹窗中选择需要展示的表达式即可。 输入选项包括常量，mock数据，在测试集合中也支持变量选择。具体用法：单击编辑按钮打开表达式生成器，点击需要的数据创建表达式，这里也可以实时查看表达式结果。Tips: 在测试集合中插入变量参数可以会出现下图的提示信息，这是正常现象。因为该参数只能在各个接口顺序执行的时候才能拉到变量参数中的值\n"
        },
        {
          "title": "编写断言脚本",
          "url": "/documents/case.html#第二步，编辑测试用例-编写断言脚本",
          "content": "编写断言脚本编写完请求参数，可通过 js 脚本写断言，实现精准测试，在接口用例页面点击 Test 编辑。"
        },
        {
          "title": "第三步，运行自动化测试",
          "url": "/documents/case.html#第三步，运行自动化测试",
          "content": "第三步，运行自动化测试在测试列表可以看到每个测试用例的 key,还有 开始测试、报告等功能点击开始测试会按照 case 定义的参数从上往下一个一个进行测试，如果顺序有问题，可以拖动调整测试完成之后，点击报告查看该次请求的结果"
        },
        {
          "title": "断言脚本公共变量",
          "url": "/documents/case.html#断言脚本公共变量",
          "content": "断言脚本公共变量"
        },
        {
          "title": "1.assert",
          "url": "/documents/case.html#断言脚本公共变量-1.assert",
          "content": "1.assert断言函数，详细 api 可查看 document常用 api\nassert(value)\n判断 value 是否为 truth, 例如 assert(1) 通过， assert(0) 不通过，只要 value 不是 null, 0, false 等值验证通过\n\n\nassert.equal(actual, expected)\n判断 actual 是否等于 expected，例如 assert(1, 1)通过\n\n\nassert.notEqual(actual, expected)\n判断 actual 是否不等于 expected\n\n\nassert.deepEqual(actual, expected)\n假设： actual = {a:1} 是一个对象，即便 expected = {a:1}，如果使用 assert.equal 可能也是不相等的，因为在 js 引用的只是对象的一个指针，需要使用 assert.deepEqual 比较两个对象是否相等\n\n\nassert.notDeepEaual(actual, expected)\n深度比较两个对象是否不相等\n\n2.statushttp 状态码3.paramshttp request params, 合并了 query 和 body4.body返回 response body5.header返回 response header6.records记录的 http 请求信息，假设需要获取 key 为 555 的接口参数或者响应数据，可通过 records[555].params 或 records[555].body 获取7.loglog（message） 函数,调试时使用，log 信息仅仅在断言失败后打印,失败断言前的信息log(234)   assert.equal(status, 400)\nlog(123)\n输出结果：log: 234\nAssertionError: 200 == 400"
        },
        {
          "title": "示例",
          "url": "/documents/case.html#断言脚本公共变量-示例",
          "content": "示例assert.equal(body.errcode, 0)\nassert.equal(body.data.group_name, 'testGroup')\nassert.equal(status, 200)\n"
        },
        {
          "title": "服务端自动化测试",
          "url": "/documents/case.html#服务端自动化测试",
          "content": "服务端自动化测试开始测试功能是在浏览器跑自动化测试，他依赖于浏览器的使用环境。服务端自动化测试功能是在YApi服务端跑自动化测试，不需要依赖浏览器环境，只需要访问 YApi 提供的 url 链接就能跑自动化测试，\b非常的简单易用，\b而且可以集成到 jenkins。"
        },
        {
          "title": "详细使用方法",
          "url": "/documents/case.html#服务端自动化测试-详细使用方法",
          "content": "详细使用方法点击服务端测试，出现如下弹窗，用户访问该 url 就可以获取当前测试用例的所有测试结果。"
        },
        {
          "title": "配置通用规则",
          "url": "/documents/case.html#配置通用规则",
          "content": "配置通用规则配置通用规则能够使自动化测试，可以基于通用的规则去控制，无需手动一个一个维护case."
        }
      ]
    },
    {
      "title": "数据导入",
      "content": "在数据管理可快速导入其他格式的接口数据，方便快速添加接口。YApi 目前支持 postman, swagger, har 数据导入。v1.3.23+ 增加数据导入的3种同步方式  normal, good, mergin普通模式(normal)：不导入已存在的接口；\n智能合并(good)：已存在的接口，将合并返回数据的 response，适用于导入了 swagger 数据，保留对数据结构的改动；例如，用户对字段code 添加了mock信息, 当再次数据导入的时候 mock 字段将不会被覆盖\n完全覆盖(mergin)：不保留旧数据，完全使用新数据，适用于接口定义完全交给后端定义， 默认为 normal\n",
      "url": "/documents/data.html",
      "children": [
        {
          "title": "Postman 数据导入",
          "url": "/documents/data.html#postman-数据导入",
          "content": "Postman 数据导入1.首先在 postman 导出接口2.选择 collection_v1,点击 export 导出接口到文件 xxx3.打开 yapi 平台，进入到项目页面，点击数据管理，选择相应的分组和 postman 导入 \b 方式，\b 选择刚才保存的文件路径，开始导入数据"
        },
        {
          "title": "HAR\b\b 数据导入",
          "url": "/documents/data.html#har\b\b-数据导入",
          "content": "HAR\b\b 数据导入可用 chrome 实现录制接口数据的功能，方便开发者快速导入项目接口1.打开 Chrome 浏览器开发者工具，点击 network，首次使用请先 clear 所有请求信息，确保录制功能开启（红色为开启状态）2.操作页面实际功能，完成后点击 save as HAR with content,将数据保存到文件 xxx3.打开 yapi 平台，进入到项目页面，点击数据管理，选择相应的分组和 har 导入 \b 方式，\b 选择刚才保存的文件路径，开始导入数据Tips: har 数据导入只支持 response.content.mimeType 为 application/json 类型的数据\n"
        },
        {
          "title": "Swagger 数据导入",
          "url": "/documents/data.html#swagger-数据导入",
          "content": "Swagger 数据导入什么是 Swagger ？[Swagger从入门到精通](https://www.gitbook.com/book/huangwenchao/swagger/details)1.生成 JSON 语言编写的 Swagger API 文档文件  例如这样的数据 （http://petstore.swagger.io/v2/swagger.json），可以将其内容复制到 JSON 文件中。Tips: v1.3.19 版本开始支持 swagger url 导入功能\n2.打开 yapi 平台，进入到项目页面，点击数据管理，选择相应的分组和 swagger 导入 \b 方式，\b 选择刚才的文件，开始导入数据"
        },
        {
          "title": "YApi 接口 JSON 数据导入",
          "url": "/documents/data.html#yapi-接口-json-数据导入",
          "content": "YApi 接口 JSON 数据导入该功能在 v1.3.12 版本上线，可导入在 yapi 平台导出的 json 接口数据。"
        },
        {
          "title": "通过命令行导入接口数据",
          "url": "/documents/data.html#通过命令行导入接口数据",
          "content": "通过命令行导入接口数据YApi 支持通过命令行导入接口数据，他的应用场景是做自动化集成，比如配合 swagger ，接口文档前端不用维护，交由后端生成。"
        },
        {
          "title": "使用方法",
          "url": "/documents/data.html#通过命令行导入接口数据-使用方法",
          "content": "使用方法第一步，确保 yapi-cli >= 1.2.7 版本，如果低于此版本请升级 yapi-cli 工具npm install -g yapi-cli第二步，在任意一个目录下新建配置文件 yapi-import.json，内容如下：{  \"type\": \"swagger\",\n  \"token\": \"17fba0027f300248b804\",\n  \"file\": \"swagger.json\",\n  \"merge\": \"normal\",\n  \"server\": \"http://yapi.local.qunar.com:3000\"\n}\ntype 是数据数据方式，目前官方只支持 swaggertoken 是项目 token，在 项目设置 -> token 设置获取file 是 swagger 接口文档文件，可使用绝对路径或 urlmerge 有三种导入方式(v1.3.23+支持) normal, good, mergin普通模式(normal)：不导入已存在的接口；\n智能合并(good)：已存在的接口，将合并返回数据的 response，适用于导入了 swagger 数据，保留对数据结构的改动；\n完全覆盖(mergin)：不保留旧数据，完全使用新数据，适用于接口定义完全交给后端定义， 默认为 normal\nserver 是 yapi 服务器地址第三步，在新建配置文件的当前目录，执行下面指令yapi import"
        }
      ]
    },
    {
      "title": "数据导入",
      "content": "在数据管理可快速导入其他格式的接口数据，方便快速添加接口。YApi 目前支持 postman, swagger, har 数据导入。v1.3.23+ 增加数据导入的3种同步方式  normal, good, mergin普通模式(normal)：不导入已存在的接口；\n智能合并(good)：已存在的接口，将合并返回数据的 response，适用于导入了 swagger 数据，保留对数据结构的改动；例如，用户对字段code 添加了mock信息, 当再次数据导入的时候 mock 字段将不会被覆盖\n完全覆盖(mergin)：不保留旧数据，完全使用新数据，适用于接口定义完全交给后端定义， 默认为 normal\n",
      "url": "/documents/data.html",
      "children": [
        {
          "title": "Postman 数据导入",
          "url": "/documents/data.html#postman-数据导入",
          "content": "Postman 数据导入1.首先在 postman 导出接口2.选择 collection_v1,点击 export 导出接口到文件 xxx3.打开 yapi 平台，进入到项目页面，点击数据管理，选择相应的分组和 postman 导入 \b 方式，\b 选择刚才保存的文件路径，开始导入数据"
        },
        {
          "title": "HAR\b\b 数据导入",
          "url": "/documents/data.html#har\b\b-数据导入",
          "content": "HAR\b\b 数据导入可用 chrome 实现录制接口数据的功能，方便开发者快速导入项目接口1.打开 Chrome 浏览器开发者工具，点击 network，首次使用请先 clear 所有请求信息，确保录制功能开启（红色为开启状态）2.操作页面实际功能，完成后点击 save as HAR with content,将数据保存到文件 xxx3.打开 yapi 平台，进入到项目页面，点击数据管理，选择相应的分组和 har 导入 \b 方式，\b 选择刚才保存的文件路径，开始导入数据Tips: har 数据导入只支持 response.content.mimeType 为 application/json 类型的数据\n"
        },
        {
          "title": "Swagger 数据导入",
          "url": "/documents/data.html#swagger-数据导入",
          "content": "Swagger 数据导入什么是 Swagger ？[Swagger从入门到精通](https://www.gitbook.com/book/huangwenchao/swagger/details)1.生成 JSON 语言编写的 Swagger API 文档文件  例如这样的数据 （http://petstore.swagger.io/v2/swagger.json），可以将其内容复制到 JSON 文件中。Tips: v1.3.19 版本开始支持 swagger url 导入功能\n2.打开 yapi 平台，进入到项目页面，点击数据管理，选择相应的分组和 swagger 导入 \b 方式，\b 选择刚才的文件，开始导入数据"
        },
        {
          "title": "YApi 接口 JSON 数据导入",
          "url": "/documents/data.html#yapi-接口-json-数据导入",
          "content": "YApi 接口 JSON 数据导入该功能在 v1.3.12 版本上线，可导入在 yapi 平台导出的 json 接口数据。"
        },
        {
          "title": "通过命令行导入接口数据",
          "url": "/documents/data.html#通过命令行导入接口数据",
          "content": "通过命令行导入接口数据YApi 支持通过命令行导入接口数据，他的应用场景是做自动化集成，比如配合 swagger ，接口文档前端不用维护，交由后端生成。"
        },
        {
          "title": "使用方法",
          "url": "/documents/data.html#通过命令行导入接口数据-使用方法",
          "content": "使用方法第一步，确保 yapi-cli >= 1.2.7 版本，如果低于此版本请升级 yapi-cli 工具npm install -g yapi-cli第二步，在任意一个目录下新建配置文件 yapi-import.json，内容如下：{  \"type\": \"swagger\",\n  \"token\": \"17fba0027f300248b804\",\n  \"file\": \"swagger.json\",\n  \"merge\": \"normal\",\n  \"server\": \"http://yapi.local.qunar.com:3000\"\n}\ntype 是数据数据方式，目前官方只支持 swaggertoken 是项目 token，在 项目设置 -> token 设置获取file 是 swagger 接口文档文件，可使用绝对路径或 urlmerge 有三种导入方式(v1.3.23+支持) normal, good, mergin普通模式(normal)：不导入已存在的接口；\n智能合并(good)：已存在的接口，将合并返回数据的 response，适用于导入了 swagger 数据，保留对数据结构的改动；\n完全覆盖(mergin)：不保留旧数据，完全使用新数据，适用于接口定义完全交给后端定义， 默认为 normal\nserver 是 yapi 服务器地址第三步，在新建配置文件的当前目录，执行下面指令yapi import"
        }
      ]
    },
    {
      "title": "数据导出",
      "content": "为了方便开发者将接口数据分析给第三方或其他使用者，YApi 内置了方便易用的接口数据导出功能。",
      "url": "/documents/export-data.html",
      "children": [
        {
          "title": "使用教程",
          "url": "/documents/export-data.html#使用教程",
          "content": "使用教程在 项目 -> 数据管理，选择需要导出的数据方式，一共有三种导出方式，html,markdown,json。然后点击导出按钮，将会下载数据文件。"
        }
      ]
    },
    {
      "title": "数据导出",
      "content": "为了方便开发者将接口数据分析给第三方或其他使用者，YApi 内置了方便易用的接口数据导出功能。",
      "url": "/documents/export-data.html",
      "children": [
        {
          "title": "使用教程",
          "url": "/documents/export-data.html#使用教程",
          "content": "使用教程在 项目 -> 数据管理，选择需要导出的数据方式，一共有三种导出方式，html,markdown,json。然后点击导出按钮，将会下载数据文件。"
        }
      ]
    },
    {
      "title": "",
      "content": "",
      "url": "/documents/plugin-index.html",
      "children": [
        {
          "title": "安装",
          "url": "/documents/plugin-index.html#安装",
          "content": "安装假设插件名为：yapi-plugin-demo,安装方法如下：cd {项目目录}yapi plugin yapi-plugin-demo\n"
        },
        {
          "title": "卸载插件",
          "url": "/documents/plugin-index.html#卸载插件",
          "content": "卸载插件假设插件名为：yapi-plugin-demo,卸载方法如下：cd {项目目录}yapi unplugin yapi-plugin-demo\n"
        }
      ]
    },
    {
      "title": "",
      "content": "",
      "url": "/documents/plugin-index.html",
      "children": [
        {
          "title": "安装",
          "url": "/documents/plugin-index.html#安装",
          "content": "安装假设插件名为：yapi-plugin-demo,安装方法如下：cd {项目目录}yapi plugin yapi-plugin-demo\n"
        },
        {
          "title": "卸载插件",
          "url": "/documents/plugin-index.html#卸载插件",
          "content": "卸载插件假设插件名为：yapi-plugin-demo,卸载方法如下：cd {项目目录}yapi unplugin yapi-plugin-demo\n"
        }
      ]
    },
    {
      "title": "",
      "content": "",
      "url": "/documents/plugin-dev.html",
      "children": [
        {
          "title": "运行开发服务器",
          "url": "/documents/plugin-dev.html#运行开发服务器",
          "content": "运行开发服务器npm installnpm install -g ykit #依赖 ykit \nnpm run dev #启动开发服务器\n"
        },
        {
          "title": "加载插件",
          "url": "/documents/plugin-dev.html#加载插件",
          "content": "加载插件在config.json plugins配置项，加入 demo 插件,{  \"port\": \"3000\",\n  \"db\": {\n    \"servername\": \"127.0.0.1\",\n    \"DATABASE\": \"yapi\"\n  },\n  ...\n  \"plugins\": [{\n    \"name\": \"demo\"，\n    \"options\": {}\n  }]\n}\n"
        },
        {
          "title": "初始化目录",
          "url": "/documents/plugin-dev.html#初始化目录",
          "content": "初始化目录可参考 项目vendors/exts 目录下的插件在 vendors/node_modules 下新建 yapi-plugin-demo 目录和 npm init,最后生成的目录接口如下yapi-plugin-demo  client.js  //客户端入口文件\n  server.js  //服务端入口文件\n  packjson.json //插件依赖管理\n  index.js //插件配置文件\n"
        },
        {
          "title": "index.js 配置说明",
          "url": "/documents/plugin-dev.html#index.js-配置说明",
          "content": "index.js 配置说明server: true // 如果为true,表名该插件需要经过后端服务器加载client: true // 如果为true,表名该插件需要经过前端编译\n"
        },
        {
          "title": "server.js",
          "url": "/documents/plugin-dev.html#server.js",
          "content": "server.js在server.js 需要导出一个 function ,例如： module.exports = function(options){}options 可在 config.json 配置"
        },
        {
          "title": "绑定钩子",
          "url": "/documents/plugin-dev.html#server.js-绑定钩子",
          "content": "绑定钩子this.bindHook(hookname, listener) //绑定钩子hookname //钩子名\nlistener //监听函数，可以是普通函数，也可以是 asyncFunction\n"
        },
        {
          "title": "如何使用 YApi vendors/server 目录下的模块",
          "url": "/documents/plugin-dev.html#server.js-如何使用-yapi-vendorsserver-目录下的模块",
          "content": "如何使用 YApi vendors/server 目录下的模块可以直接 require vendors 目录下的模块，注意：后端 node 不能使用 import关键字，只能使用 require例如： require('yapi')"
        },
        {
          "title": "controller 和 model",
          "url": "/documents/plugin-dev.html#server.js-controller-和-model",
          "content": "controller 和 model新增 controller 需要继承 baseController(controller/base.js)新增 model 需要继承 baseModel(model/base.js)"
        },
        {
          "title": "client.js",
          "url": "/documents/plugin-dev.html#client.js",
          "content": "client.js"
        },
        {
          "title": "绑定钩子(同后端 server.js )",
          "url": "/documents/plugin-dev.html#client.js-绑定钩子同后端-server.js-",
          "content": "绑定钩子(同后端 server.js )this.bindHook(hookname, listener) //绑定钩子hookname //钩子名\nlistener //监听函数，可以是普通函数，也可以是 asyncFunction\n"
        }
      ]
    },
    {
      "title": "",
      "content": "",
      "url": "/documents/plugin-dev.html",
      "children": [
        {
          "title": "运行开发服务器",
          "url": "/documents/plugin-dev.html#运行开发服务器",
          "content": "运行开发服务器npm installnpm install -g ykit #依赖 ykit \nnpm run dev #启动开发服务器\n"
        },
        {
          "title": "加载插件",
          "url": "/documents/plugin-dev.html#加载插件",
          "content": "加载插件在config.json plugins配置项，加入 demo 插件,{  \"port\": \"3000\",\n  \"db\": {\n    \"servername\": \"127.0.0.1\",\n    \"DATABASE\": \"yapi\"\n  },\n  ...\n  \"plugins\": [{\n    \"name\": \"demo\"，\n    \"options\": {}\n  }]\n}\n"
        },
        {
          "title": "初始化目录",
          "url": "/documents/plugin-dev.html#初始化目录",
          "content": "初始化目录可参考 项目vendors/exts 目录下的插件在 vendors/node_modules 下新建 yapi-plugin-demo 目录和 npm init,最后生成的目录接口如下yapi-plugin-demo  client.js  //客户端入口文件\n  server.js  //服务端入口文件\n  packjson.json //插件依赖管理\n  index.js //插件配置文件\n"
        },
        {
          "title": "index.js 配置说明",
          "url": "/documents/plugin-dev.html#index.js-配置说明",
          "content": "index.js 配置说明server: true // 如果为true,表名该插件需要经过后端服务器加载client: true // 如果为true,表名该插件需要经过前端编译\n"
        },
        {
          "title": "server.js",
          "url": "/documents/plugin-dev.html#server.js",
          "content": "server.js在server.js 需要导出一个 function ,例如： module.exports = function(options){}options 可在 config.json 配置"
        },
        {
          "title": "绑定钩子",
          "url": "/documents/plugin-dev.html#server.js-绑定钩子",
          "content": "绑定钩子this.bindHook(hookname, listener) //绑定钩子hookname //钩子名\nlistener //监听函数，可以是普通函数，也可以是 asyncFunction\n"
        },
        {
          "title": "如何使用 YApi vendors/server 目录下的模块",
          "url": "/documents/plugin-dev.html#server.js-如何使用-yapi-vendorsserver-目录下的模块",
          "content": "如何使用 YApi vendors/server 目录下的模块可以直接 require vendors 目录下的模块，注意：后端 node 不能使用 import关键字，只能使用 require例如： require('yapi')"
        },
        {
          "title": "controller 和 model",
          "url": "/documents/plugin-dev.html#server.js-controller-和-model",
          "content": "controller 和 model新增 controller 需要继承 baseController(controller/base.js)新增 model 需要继承 baseModel(model/base.js)"
        },
        {
          "title": "client.js",
          "url": "/documents/plugin-dev.html#client.js",
          "content": "client.js"
        },
        {
          "title": "绑定钩子(同后端 server.js )",
          "url": "/documents/plugin-dev.html#client.js-绑定钩子同后端-server.js-",
          "content": "绑定钩子(同后端 server.js )this.bindHook(hookname, listener) //绑定钩子hookname //钩子名\nlistener //监听函数，可以是普通函数，也可以是 asyncFunction\n"
        }
      ]
    },
    {
      "title": "",
      "content": "",
      "url": "/documents/plugin-list.html",
      "children": [
        {
          "title": "怎么分享我的插件？",
          "url": "/documents/plugin-list.html#怎么分享我的插件？",
          "content": "怎么分享我的插件？Fork yapi, 然后修改 docs/documents/plugin-list.md, 修改完成后请 Pull-Request."
        },
        {
          "title": "插件列表",
          "url": "/documents/plugin-list.html#插件列表",
          "content": "插件列表dingding 钉钉机器人推送插件\nqsso sso 第三方登录\nimport-rap 从rap中导入项目\n"
        }
      ]
    },
    {
      "title": "",
      "content": "",
      "url": "/documents/plugin-list.html",
      "children": [
        {
          "title": "怎么分享我的插件？",
          "url": "/documents/plugin-list.html#怎么分享我的插件？",
          "content": "怎么分享我的插件？Fork yapi, 然后修改 docs/documents/plugin-list.md, 修改完成后请 Pull-Request."
        },
        {
          "title": "插件列表",
          "url": "/documents/plugin-list.html#插件列表",
          "content": "插件列表dingding 钉钉机器人推送插件\nqsso sso 第三方登录\nimport-rap 从rap中导入项目\n"
        }
      ]
    },
    {
      "title": "",
      "content": "",
      "url": "/documents/plugin-hooks.html",
      "children": [
        {
          "title": "后端 hookList",
          "url": "/documents/plugin-hooks.html#后端-hooklist",
          "content": "后端 hookList目前 hooksList 只有下面列出的部分，如果您有其他的需求，可提建议到 github 或者 qq 群/** * 钩子配置\n */\nvar hooks = {\n    /**\n     * 第三方sso登录钩子，暂只支持设置一个\n     * @param ctx\n     * @return 必需返回一个 promise 对象，resolve({username: '', email: ''})\n     */\n    'third_login': {\n        type: 'single',\n        listener: null\n    },\n     /**\n   * 客户端增加接口成功后触发\n   * @param data 接口的详细信息\n   */\n    interface_add: {\n      type: 'multi',\n     listener: []\n    },\n    /**\n    * 客户端删除接口成功后触发\n     * @param data 接口id\n     */\n    interface_del: {\n     type: 'multi',\n     listener: []\n    },\n    /**\n     * 客户端更新接口成功后触发\n     * @param id 接口id\n    */\n    interface_update: {\n      type: 'multi',\n      listener: []\n    },\n    /**\n    * 客户端获取接口数据列表\n    * @param list 返回接口的数据列表\n    */\n    interface_list: {\n      type: 'multi',\n      listener: []\n    },\n    /**\n    * 客户端获取一条接口信息触发\n    * @param data 接口的详细信息\n    */\n    interface_get: {\n      type: 'multi',\n      listener: []\n    },\n    /**\n     * 客户端增加一个新项目\n     * @param id 项目id\n     */\n    'project_add':{\n        type: 'multi',\n        listener: []\n    },\n    /**\n     * 客户端删除删除一个项目\n     * @param id 项目id\n     */\n    'project_del':{\n        type: 'multi',\n        listener: []\n    },\n    /**\n     * MockServer生成mock数据后触发\n     * @param context Object\n     * {\n     *  projectData: project,\n        interfaceData: interfaceData,\n        ctx: ctx,\n        mockJson: res\n     * }\n     *\n     */\n    mock_after: {\n        type: 'multi',\n        listener: []\n    },\n    /**\n     * 增加路由的钩子\n     * type Sync\n     * @param addPluginRouter Function\n     * addPLuginPLugin(config)\n     * config = {\n     *  path,      // String\n     *  method,    // String\n     *  controller // Class 继承baseController的class\n     *  action     // String controller的Action\n     * }\n     */\n    add_router: {\n        type: 'multi',\n        listener: []\n    }\n};\n"
        },
        {
          "title": "前端 hookList",
          "url": "/documents/plugin-hooks.html#前端-hooklist",
          "content": "前端 hookList/** * type component  组件\n *      listener   监听函数\n * mulit 是否绑定多个监听函数\n *\n */\n\nhooks = {\n  /**\n   * 第三方登录 //可参考 yapi-plugin-qsso 插件\n   */\n  third_login: {\n    type: 'component',\n    mulit: false,\n    listener: null\n  },\n  /**\n   * 导入数据\n   * @param Object importDataModule\n   *\n   * @info\n   * 可参考 vendors/exts/yapi-plugin-import-swagger插件\n   * importDataModule = {};\n   *\n   */\n  import_data: {\n    type: 'listener',\n    mulit: true,\n    listener: []\n  },\n  /**\n   * 导出数据\n   * @param Object exportDataModule\n   * @param projectId\n   * @info\n   * exportDataModule = {};\n   * exportDataModule.pdf = {\n   *   name: 'Pdf',\n   *   route: '/api/plugin/export/pdf',\n   *   desc: '导出项目接口文档为 pdf 文件'\n   * }\n   */\n  export_data: {\n    type: 'listener',\n    mulit: true,\n    listener: []\n  },\n  /**\n   * 接口页面 tab 钩子\n   * @param InterfaceTabs\n   *\n   * @info\n   * 可参考 vendors/exts/yapi-plugin-advanced-mock\n   * let InterfaceTabs = {\n      view: {\n        component: View,\n        name: '预览'\n      },\n      edit: {\n        component: Edit,\n        name: '编辑'\n      },\n      run: {\n        component: Run,\n        name: '运行'\n      }\n    }\n   */\n  interface_tab: {\n    type: 'listener',\n    mulit: true,\n    listener: []\n  },\n  /**\n   * header下拉菜单 menu 钩子\n   * @param HeaderMenu\n   *\n   * @info\n   * 可参考 vendors/exts/yapi-plugin-statistics\n   * let HeaderMenu = {\n  user: {\n    path: '/user/profile',\n    name: '个人中心',\n    icon: 'user',\n    adminFlag: false\n  },\n  star: {\n    path: '/follow',\n    name: '我的关注',\n    icon: 'star-o',\n    adminFlag: false\n  },\n  solution: {\n    path: '/user/list',\n    name: '用户管理',\n    icon: 'solution',\n    adminFlag: true\n\n  },\n  logout: {\n    path: '',\n    name: '退出',\n    icon: 'logout',\n    adminFlag: false\n\n  }\n};\n   */\n  header_menu: {\n    type: 'listener',\n    mulit: true,\n    listener: []\n  },\n  /**\n   * Route路由列表钩子\n   * @param AppRoute\n   *\n   * @info\n   * 可参考 vendors/exts/yapi-plugin-statistics\n   * 添加位置在Application.js 中\n   * let AppRoute = {\n  home: {\n    path: '/',\n    component: Home\n  },\n  group: {\n    path: '/group',\n    component: Group\n  },\n  project: {\n    path: '/project/:id',\n    component: Project\n  },\n  user: {\n    path: '/user',\n    component: User\n  },\n  follow: {\n    path: '/follow',\n    component: Follows\n  },\n  addProject: {\n    path: '/add-project',\n    component: AddProject\n  },\n  login: {\n    path: '/login',\n    component: Login\n  }\n};\n};\n   */\n  app_route: {\n    type: 'listener',\n    mulit: true,\n    listener: []\n  },\n  /*\n   * 添加 reducer\n   * @param Object reducerModules\n   *\n   * @info\n   * importDataModule = {};\n   *\n   */\n\n  add_reducer: {\n    type: 'listener',\n    mulit: true,\n    listener: []\n  }\n};\n"
        }
      ]
    },
    {
      "title": "",
      "content": "",
      "url": "/documents/plugin-hooks.html",
      "children": [
        {
          "title": "后端 hookList",
          "url": "/documents/plugin-hooks.html#后端-hooklist",
          "content": "后端 hookList目前 hooksList 只有下面列出的部分，如果您有其他的需求，可提建议到 github 或者 qq 群/** * 钩子配置\n */\nvar hooks = {\n    /**\n     * 第三方sso登录钩子，暂只支持设置一个\n     * @param ctx\n     * @return 必需返回一个 promise 对象，resolve({username: '', email: ''})\n     */\n    'third_login': {\n        type: 'single',\n        listener: null\n    },\n     /**\n   * 客户端增加接口成功后触发\n   * @param data 接口的详细信息\n   */\n    interface_add: {\n      type: 'multi',\n     listener: []\n    },\n    /**\n    * 客户端删除接口成功后触发\n     * @param data 接口id\n     */\n    interface_del: {\n     type: 'multi',\n     listener: []\n    },\n    /**\n     * 客户端更新接口成功后触发\n     * @param id 接口id\n    */\n    interface_update: {\n      type: 'multi',\n      listener: []\n    },\n    /**\n    * 客户端获取接口数据列表\n    * @param list 返回接口的数据列表\n    */\n    interface_list: {\n      type: 'multi',\n      listener: []\n    },\n    /**\n    * 客户端获取一条接口信息触发\n    * @param data 接口的详细信息\n    */\n    interface_get: {\n      type: 'multi',\n      listener: []\n    },\n    /**\n     * 客户端增加一个新项目\n     * @param id 项目id\n     */\n    'project_add':{\n        type: 'multi',\n        listener: []\n    },\n    /**\n     * 客户端删除删除一个项目\n     * @param id 项目id\n     */\n    'project_del':{\n        type: 'multi',\n        listener: []\n    },\n    /**\n     * MockServer生成mock数据后触发\n     * @param context Object\n     * {\n     *  projectData: project,\n        interfaceData: interfaceData,\n        ctx: ctx,\n        mockJson: res\n     * }\n     *\n     */\n    mock_after: {\n        type: 'multi',\n        listener: []\n    },\n    /**\n     * 增加路由的钩子\n     * type Sync\n     * @param addPluginRouter Function\n     * addPLuginPLugin(config)\n     * config = {\n     *  path,      // String\n     *  method,    // String\n     *  controller // Class 继承baseController的class\n     *  action     // String controller的Action\n     * }\n     */\n    add_router: {\n        type: 'multi',\n        listener: []\n    }\n};\n"
        },
        {
          "title": "前端 hookList",
          "url": "/documents/plugin-hooks.html#前端-hooklist",
          "content": "前端 hookList/** * type component  组件\n *      listener   监听函数\n * mulit 是否绑定多个监听函数\n *\n */\n\nhooks = {\n  /**\n   * 第三方登录 //可参考 yapi-plugin-qsso 插件\n   */\n  third_login: {\n    type: 'component',\n    mulit: false,\n    listener: null\n  },\n  /**\n   * 导入数据\n   * @param Object importDataModule\n   *\n   * @info\n   * 可参考 vendors/exts/yapi-plugin-import-swagger插件\n   * importDataModule = {};\n   *\n   */\n  import_data: {\n    type: 'listener',\n    mulit: true,\n    listener: []\n  },\n  /**\n   * 导出数据\n   * @param Object exportDataModule\n   * @param projectId\n   * @info\n   * exportDataModule = {};\n   * exportDataModule.pdf = {\n   *   name: 'Pdf',\n   *   route: '/api/plugin/export/pdf',\n   *   desc: '导出项目接口文档为 pdf 文件'\n   * }\n   */\n  export_data: {\n    type: 'listener',\n    mulit: true,\n    listener: []\n  },\n  /**\n   * 接口页面 tab 钩子\n   * @param InterfaceTabs\n   *\n   * @info\n   * 可参考 vendors/exts/yapi-plugin-advanced-mock\n   * let InterfaceTabs = {\n      view: {\n        component: View,\n        name: '预览'\n      },\n      edit: {\n        component: Edit,\n        name: '编辑'\n      },\n      run: {\n        component: Run,\n        name: '运行'\n      }\n    }\n   */\n  interface_tab: {\n    type: 'listener',\n    mulit: true,\n    listener: []\n  },\n  /**\n   * header下拉菜单 menu 钩子\n   * @param HeaderMenu\n   *\n   * @info\n   * 可参考 vendors/exts/yapi-plugin-statistics\n   * let HeaderMenu = {\n  user: {\n    path: '/user/profile',\n    name: '个人中心',\n    icon: 'user',\n    adminFlag: false\n  },\n  star: {\n    path: '/follow',\n    name: '我的关注',\n    icon: 'star-o',\n    adminFlag: false\n  },\n  solution: {\n    path: '/user/list',\n    name: '用户管理',\n    icon: 'solution',\n    adminFlag: true\n\n  },\n  logout: {\n    path: '',\n    name: '退出',\n    icon: 'logout',\n    adminFlag: false\n\n  }\n};\n   */\n  header_menu: {\n    type: 'listener',\n    mulit: true,\n    listener: []\n  },\n  /**\n   * Route路由列表钩子\n   * @param AppRoute\n   *\n   * @info\n   * 可参考 vendors/exts/yapi-plugin-statistics\n   * 添加位置在Application.js 中\n   * let AppRoute = {\n  home: {\n    path: '/',\n    component: Home\n  },\n  group: {\n    path: '/group',\n    component: Group\n  },\n  project: {\n    path: '/project/:id',\n    component: Project\n  },\n  user: {\n    path: '/user',\n    component: User\n  },\n  follow: {\n    path: '/follow',\n    component: Follows\n  },\n  addProject: {\n    path: '/add-project',\n    component: AddProject\n  },\n  login: {\n    path: '/login',\n    component: Login\n  }\n};\n};\n   */\n  app_route: {\n    type: 'listener',\n    mulit: true,\n    listener: []\n  },\n  /*\n   * 添加 reducer\n   * @param Object reducerModules\n   *\n   * @info\n   * importDataModule = {};\n   *\n   */\n\n  add_reducer: {\n    type: 'listener',\n    mulit: true,\n    listener: []\n  }\n};\n"
        }
      ]
    },
    {
      "title": "",
      "content": "",
      "url": "/documents/redev.html",
      "children": [
        {
          "title": "安装YApi",
          "url": "/documents/redev.html#安装yapi",
          "content": "安装YApi1.创建工程目录mkdir yapi && cd yapigit clone https://github.com/YMFE/yapi.git vendors --depth=1 # 或者下载 zip 包解压到 vendors 目录\n2.修改配置cp vendors/config_example.json ./config.json # 复制完成后请修改相关配置vi ./config.json\n配置如下，主要配置 MongoDB 数据库，以及 Admin 账号。{  \"port\": \"3011\",\n  \"adminAccount\": \"admin@admin.com\",\n  \"db\": {\n    \"servername\": \"127.0.0.1\",\n    \"DATABASE\":  \"yapi\",\n    \"port\": 27017,\n    \"user\": \"yapi\",\n    \"pass\": \"yapi123\"\n  },\n  \"mail\": {\n    \"enable\": true,\n    \"host\": \"smtp.163.com\",\n    \"port\": 465,\n    \"from\": \"***@163.com\",\n    \"auth\": {\n        \"user\": \"***@163.com\",\n        \"pass\": \"*****\"\n    }\n  }\n}\ndb.user 和 db.pass 是 mongodb 的用户名和密码，如果没有开启 mongo 认证功能，请删除这两个选项。\n3.安装依赖cd vendorsnpm install  --registry https://registry.npm.taobao.org # 安装依赖\n4.初始化npm run install-server  # 安装程序会初始化数据库索引和管理员账号，管理员账号名可在 config.json 配置# 默认输出\n# 初始化管理员账号成功,账号名：\"admin@admin.com\"，密码：\"ymfe.org\"\n5.启动开发机npm run dev# 启动服务器后，请访问 127.0.0.1:{config.json配置的端口}，初次运行会有个编译的过程，请耐心等候\n# 127.0.0.1:3011\n目录结构|-- config.json|-- init.lock\n|-- log\n`-- vendors\n    |-- CHANGELOG.md\n    |-- LICENSE\n    |-- README.md\n    |-- client\n    |-- common\n    |-- config_example.json\n    |-- doc\n    |-- exts\n    |-- nodemon.json\n    |-- npm-debug.log\n    |-- package.json\n    |-- plugin.json\n    |-- server\n    |-- static\n    |-- test\n    |-- webpack.alias.js\n    |-- yapi-base-flow.jpg\n    |-- ydocfile.js\n    `-- ykit.config.js\n"
        },
        {
          "title": "技术栈说明",
          "url": "/documents/redev.html#技术栈说明",
          "content": "技术栈说明后端： koa mongoose前端： react redux"
        },
        {
          "title": "启动开发环境服务器",
          "url": "/documents/redev.html#启动开发环境服务器",
          "content": "启动开发环境服务器  cd vendors  npm run dev\n  # 启动服务器后，请访问 127.0.0.1:{config.json配置的端口}，初次运行会有个编译的过程，请耐心等候\n"
        },
        {
          "title": "启动生产环境服务器",
          "url": "/documents/redev.html#启动生产环境服务器",
          "content": "启动生产环境服务器  cd vendors  ykit pack -m\n  node server/app.js\n"
        }
      ]
    },
    {
      "title": "",
      "content": "",
      "url": "/documents/redev.html",
      "children": [
        {
          "title": "安装YApi",
          "url": "/documents/redev.html#安装yapi",
          "content": "安装YApi1.创建工程目录mkdir yapi && cd yapigit clone https://github.com/YMFE/yapi.git vendors --depth=1 # 或者下载 zip 包解压到 vendors 目录\n2.修改配置cp vendors/config_example.json ./config.json # 复制完成后请修改相关配置vi ./config.json\n配置如下，主要配置 MongoDB 数据库，以及 Admin 账号。{  \"port\": \"3011\",\n  \"adminAccount\": \"admin@admin.com\",\n  \"db\": {\n    \"servername\": \"127.0.0.1\",\n    \"DATABASE\":  \"yapi\",\n    \"port\": 27017,\n    \"user\": \"yapi\",\n    \"pass\": \"yapi123\"\n  },\n  \"mail\": {\n    \"enable\": true,\n    \"host\": \"smtp.163.com\",\n    \"port\": 465,\n    \"from\": \"***@163.com\",\n    \"auth\": {\n        \"user\": \"***@163.com\",\n        \"pass\": \"*****\"\n    }\n  }\n}\ndb.user 和 db.pass 是 mongodb 的用户名和密码，如果没有开启 mongo 认证功能，请删除这两个选项。\n3.安装依赖cd vendorsnpm install  --registry https://registry.npm.taobao.org # 安装依赖\n4.初始化npm run install-server  # 安装程序会初始化数据库索引和管理员账号，管理员账号名可在 config.json 配置# 默认输出\n# 初始化管理员账号成功,账号名：\"admin@admin.com\"，密码：\"ymfe.org\"\n5.启动开发机npm run dev# 启动服务器后，请访问 127.0.0.1:{config.json配置的端口}，初次运行会有个编译的过程，请耐心等候\n# 127.0.0.1:3011\n目录结构|-- config.json|-- init.lock\n|-- log\n`-- vendors\n    |-- CHANGELOG.md\n    |-- LICENSE\n    |-- README.md\n    |-- client\n    |-- common\n    |-- config_example.json\n    |-- doc\n    |-- exts\n    |-- nodemon.json\n    |-- npm-debug.log\n    |-- package.json\n    |-- plugin.json\n    |-- server\n    |-- static\n    |-- test\n    |-- webpack.alias.js\n    |-- yapi-base-flow.jpg\n    |-- ydocfile.js\n    `-- ykit.config.js\n"
        },
        {
          "title": "技术栈说明",
          "url": "/documents/redev.html#技术栈说明",
          "content": "技术栈说明后端： koa mongoose前端： react redux"
        },
        {
          "title": "启动开发环境服务器",
          "url": "/documents/redev.html#启动开发环境服务器",
          "content": "启动开发环境服务器  cd vendors  npm run dev\n  # 启动服务器后，请访问 127.0.0.1:{config.json配置的端口}，初次运行会有个编译的过程，请耐心等候\n"
        },
        {
          "title": "启动生产环境服务器",
          "url": "/documents/redev.html#启动生产环境服务器",
          "content": "启动生产环境服务器  cd vendors  ykit pack -m\n  node server/app.js\n"
        }
      ]
    },
    {
      "title": "常见问题解答",
      "content": "本页面罗列了大家使用 YApi 时遇到的常见问题.如果没有找到您要的答案，请联系管理员.",
      "url": "/documents/qa.html",
      "children": [
        {
          "title": "Q1 怎样联系组长？",
          "url": "/documents/qa.html#q1-怎样联系组长？",
          "content": "Q1 怎样联系组长？组长分为 分组组长 和 项目组长:分组组长：选择首页左侧的分组，点击右侧面板的 成员列表，成员右侧显示着 组长/开发者 的权限信息。\n\n项目组长: 点击项目页的 设置 - 成员列表，成员右侧显示着 组长/开发者 的权限信息。\n\n"
        },
        {
          "title": "Q2 怎么快速迁移旧项目？",
          "url": "/documents/qa.html#q2-怎么快速迁移旧项目？",
          "content": "Q2 怎么快速迁移旧项目？第一步. 使用 Chrome 浏览器开发者工具录制功能第二步 录制当前项目所有请求，导出到 har 文件第三步 将Har数据导入到 YApi 平台具体使用方法请参考 YApi 文档"
        },
        {
          "title": "Q3 忘记密码怎么办？",
          "url": "/documents/qa.html#q3-忘记密码怎么办？",
          "content": "Q3 忘记密码怎么办？请联系 超级管理员 ，只有超级管理员能重置密码。"
        },
        {
          "title": "Q4 发现了 Bug 怎么办？",
          "url": "/documents/qa.html#q4-发现了-bug-怎么办？",
          "content": "Q4 发现了 Bug 怎么办？请反馈到 Github，功能性的问题我们会在一周内修复，并在每周一发布新的版本 Tag."
        },
        {
          "title": "Q5 部署不成功怎么办？",
          "url": "/documents/qa.html#q5-部署不成功怎么办？",
          "content": "Q5 部署不成功怎么办？确保 node 版本=> 7.6,请运行 node -v 查看版本号\n确保 mongodb 版本 => 2.6，请运行 mongo --version 查看版本号\n确保安装了 npm, 运行 npm -v 查看版本号\n确保安装了 git,运行 git --version 查看版本号\n确认版本号没问题，请删除原有的安装文件和数据库，重新安装。如果还是无法安装，请不要选择最新的版本，可选择上一个版本或上上一个版本等，最新版本出问题的概率会比较大。"
        },
        {
          "title": "Q6 部署YApi遇到mongodb认证问题？",
          "url": "/documents/qa.html#q6-部署yapi遇到mongodb认证问题？",
          "content": "Q6 部署YApi遇到mongodb认证问题？mongodb3.03以上开启认证,解决程序认证连接报错以及第三方客户端无法认证问题\n"
        }
      ]
    },
    {
      "title": "常见问题解答",
      "content": "本页面罗列了大家使用 YApi 时遇到的常见问题.如果没有找到您要的答案，请联系管理员.",
      "url": "/documents/qa.html",
      "children": [
        {
          "title": "Q1 怎样联系组长？",
          "url": "/documents/qa.html#q1-怎样联系组长？",
          "content": "Q1 怎样联系组长？组长分为 分组组长 和 项目组长:分组组长：选择首页左侧的分组，点击右侧面板的 成员列表，成员右侧显示着 组长/开发者 的权限信息。\n\n项目组长: 点击项目页的 设置 - 成员列表，成员右侧显示着 组长/开发者 的权限信息。\n\n"
        },
        {
          "title": "Q2 怎么快速迁移旧项目？",
          "url": "/documents/qa.html#q2-怎么快速迁移旧项目？",
          "content": "Q2 怎么快速迁移旧项目？第一步. 使用 Chrome 浏览器开发者工具录制功能第二步 录制当前项目所有请求，导出到 har 文件第三步 将Har数据导入到 YApi 平台具体使用方法请参考 YApi 文档"
        },
        {
          "title": "Q3 忘记密码怎么办？",
          "url": "/documents/qa.html#q3-忘记密码怎么办？",
          "content": "Q3 忘记密码怎么办？请联系 超级管理员 ，只有超级管理员能重置密码。"
        },
        {
          "title": "Q4 发现了 Bug 怎么办？",
          "url": "/documents/qa.html#q4-发现了-bug-怎么办？",
          "content": "Q4 发现了 Bug 怎么办？请反馈到 Github，功能性的问题我们会在一周内修复，并在每周一发布新的版本 Tag."
        },
        {
          "title": "Q5 部署不成功怎么办？",
          "url": "/documents/qa.html#q5-部署不成功怎么办？",
          "content": "Q5 部署不成功怎么办？确保 node 版本=> 7.6,请运行 node -v 查看版本号\n确保 mongodb 版本 => 2.6，请运行 mongo --version 查看版本号\n确保安装了 npm, 运行 npm -v 查看版本号\n确保安装了 git,运行 git --version 查看版本号\n确认版本号没问题，请删除原有的安装文件和数据库，重新安装。如果还是无法安装，请不要选择最新的版本，可选择上一个版本或上上一个版本等，最新版本出问题的概率会比较大。"
        },
        {
          "title": "Q6 部署YApi遇到mongodb认证问题？",
          "url": "/documents/qa.html#q6-部署yapi遇到mongodb认证问题？",
          "content": "Q6 部署YApi遇到mongodb认证问题？mongodb3.03以上开启认证,解决程序认证连接报错以及第三方客户端无法认证问题\n"
        }
      ]
    },
    {
      "title": "",
      "content": "",
      "url": "/documents/CHANGELOG.html",
      "children": [
        {
          "title": "v1.5.6",
          "url": "/documents/CHANGELOG.html#v1.5.6",
          "content": "v1.5.6修复 /api/open/import_data 参数bug\n修复  /api/open/import_data 文档错误，merge 参数误写为 dataSync\n"
        },
        {
          "title": "v1.5.5",
          "url": "/documents/CHANGELOG.html#v1.5.5",
          "content": "v1.5.5cross-request 升级到 2.10\n/api/open/import_data 新增 url 参数，支持服务端 url 导入\n"
        },
        {
          "title": "v1.5.2",
          "url": "/documents/CHANGELOG.html#v1.5.2",
          "content": "v1.5.2新增 openapi /api/project/get，可获取项目基本信息\n"
        },
        {
          "title": "v1.5.1",
          "url": "/documents/CHANGELOG.html#v1.5.1",
          "content": "v1.5.1优化 restful api 动态路由权重匹配算法，匹配更加精确\nopenapi 新增 /api/interface/list_cat，获取某个分类下所有接口\n新增了 rap数据导入到 yapi 插件 rap2yapi\n"
        },
        {
          "title": "v1.5.0",
          "url": "/documents/CHANGELOG.html#v1.5.0",
          "content": "v1.5.0优化开放 api功能，现在 token 带有用户信息了\n修复无法获取请求302 跳转前的 headers\n"
        },
        {
          "title": "v1.4.4",
          "url": "/documents/CHANGELOG.html#v1.4.4",
          "content": "v1.4.4优化了 json-schema 编辑器交互，修复了参数名写到一半提示重复的问题\n优化了首页体验，提升页面打开速度\n新增自动化测试通用规则配置功能\n"
        },
        {
          "title": "v1.4.3",
          "url": "/documents/CHANGELOG.html#v1.4.3",
          "content": "v1.4.3修复了可视化安装，mongodb 报错的问题\n支持了 swagger 导出功能\n支持了克隆测试用例\n"
        },
        {
          "title": "v1.4.2",
          "url": "/documents/CHANGELOG.html#v1.4.2",
          "content": "v1.4.2优化数据导入对 headers 处理，如果 requestType 是 json，自动增加header \"content-type/json\"\nfix: 修改了测试集合有多个项目接口时，切换执行环境相互覆盖不生效的问题 #692\nfix: mongoose warning 'Error: (node:3819) DeprecationWarning: collection.ensureIndex is deprecated. Use createIndexes instead'\nopti: 去掉没必要的redux-thunk\n接口更新没有变化时，不记录日志，避免cron多次导入swagger的接口时，导致动态里展示一大堆的无意义日志\n"
        },
        {
          "title": "v1.4.1",
          "url": "/documents/CHANGELOG.html#v1.4.1",
          "content": "v1.4.1支持任何人都可以添加分组，只有管理员才能修改项目是否公开\n支持 mongodb 集群\nBug Fixed修改 mock严格模式，GET带有 JSON BODY 导致的验证问题\n对 queryPath 改动导致的bug，支持通过 xxx?controller=name 等 query 参数区分路径\n因 tui-editor 需要安装github 依赖，导致部分机器无法部署成功的问题\n"
        },
        {
          "title": "v1.3.23",
          "url": "/documents/CHANGELOG.html#v1.3.23",
          "content": "v1.3.23接口tag功能\n数据导入增加 merge 功能\n增加参数的批量导入功能\njson schema 可视化编辑器增加 mock 功能\nBug Fixed接口path中写入 ?name=xxx bug\n高级mock 匹配 data: [{item: XXX}] 时匹配不成功\n接口运行 query params 自动勾选\nmock get 带 cookie 时跨域\njson schema 嵌套多层 array 预览不展示 bug\nswagger URL 导入 跨域问题\n"
        },
        {
          "title": "v1.3.22",
          "url": "/documents/CHANGELOG.html#v1.3.22",
          "content": "v1.3.22json schema number和integer支持枚举\n服务端测试增加下载功能\n增加 mock 接口请求字段参数验证\n增加返回数据验证\nBug Fixed命令行导入成员信息为 undefined\n修复form 参数为空时 接口无法保存的问题\n"
        },
        {
          "title": "v1.3.21",
          "url": "/documents/CHANGELOG.html#v1.3.21",
          "content": "v1.3.21请求配置增加 context.utils.CryptoJS\n环境变量支持自定义全局变量\n增加wiki数据导出功能\n用户管理处增加搜索功能\n增加项目全局 mock 脚本功能\n高级 mock 期望 支持关闭开启功能\nBug Fixed优化ldap登陆\nswagger 导入公共params\n接口编辑 mockEditor 修改为 AceEditor\n"
        },
        {
          "title": "v1.3.20",
          "url": "/documents/CHANGELOG.html#v1.3.20",
          "content": "v1.3.20Bug Fixed修复 ykit 打包代码问题\n修复 swagger url 导入选中后再切换其他数据方式时拖拽区域不出现问题\n修复 wiki controller 后端报错问题\n"
        },
        {
          "title": "v1.3.19",
          "url": "/documents/CHANGELOG.html#v1.3.19",
          "content": "v1.3.19增加项目文档记录wiki\n支持swagger URL 导入\n接口运行和测试集合中加入参数备注信息\n测试接口导入支持状态过滤\njson schema 增加枚举备注功能\n左侧菜单栏可以支持单独滚动条\n支持新版本通知\nBug Fixed修复测试用例名称为空时保存测试用例出现的bug\n导出markdown 路径参数处格式错误和参数table备注信息换行后样式错误\n"
        },
        {
          "title": "v1.3.18",
          "url": "/documents/CHANGELOG.html#v1.3.18",
          "content": "v1.3.18增加全局接口搜索功能\n邮件通知过滤功能\nBug Fixed新建接口自动添加为项目成员\n修复type为raw header type 为form 时运行body 为空问题\nmongodb3.4-> 3.6 聚合 cursor报错\npath 路径支持 ！\njson-schema 编辑器修复修改 type 导致描述信息被重置的问题\n"
        },
        {
          "title": "v1.3.17",
          "url": "/documents/CHANGELOG.html#v1.3.17",
          "content": "v1.3.17请求配置中添加 context.castId 字段用于标识测试用例\nBug Fixed修复服务器端测试，邮件通知开启token undefined bug\n将状态由未完成修改成已完成之后，原来的json格式的数据会变成json-schema\n有分类为空时导出json后再导入报错\n只修改参数 必需/非必需, 文本/文件 时, 查看改动详情, 提示没有改动\nldap登陆允许用户输入的登陆账号非邮箱\n"
        },
        {
          "title": "v1.3.16",
          "url": "/documents/CHANGELOG.html#v1.3.16",
          "content": "v1.3.16支持自定义域名邮箱登录\n测试用例支持导入不同项目接口\n完善可视化表达式，可根据焦点编辑表达式\nreq_body json 支持指针位置可视化插入表达式\nBug Fixed导入postman  headers 为 null 时报错\nformat-data 数据解析不成功\n导出的接口顺序按照api的接口顺序\n"
        },
        {
          "title": "v1.3.15",
          "url": "/documents/CHANGELOG.html#v1.3.15",
          "content": "v1.3.15增强跨域请求安全性，只允许 YApi 网站进行跨域请求\n优化文档\n修复 schema 描述信息展示 bug\n增加禁止普通用户注册功能\n"
        },
        {
          "title": "v1.3.14",
          "url": "/documents/CHANGELOG.html#v1.3.14",
          "content": "v1.3.14修复接口编辑白屏问题\n"
        },
        {
          "title": "v1.3.13",
          "url": "/documents/CHANGELOG.html#v1.3.13",
          "content": "v1.3.13新增通过命令行导入 swagger 接口数据功能\n接口请求设置新增异步处理特性\n"
        },
        {
          "title": "v1.3.12",
          "url": "/documents/CHANGELOG.html#v1.3.12",
          "content": "v1.3.12Feature接口列表支持路径查询\n项目复制\n预览页面交互优化\n优化服务端自动化测试文案\n增加项目接口json数据导入导出功能\nBug Fixed项目中访客权限的账号可以 增、删、改接口中高级mock的设置\n高级Mock 中的响应时间值无法保存（实际提示为：保存成功）\n分类为空时添加接口\n"
        },
        {
          "title": "v1.3.11",
          "url": "/documents/CHANGELOG.html#v1.3.11",
          "content": "v1.3.11Bug Fixed修复 v1.3.10 websocket 连接问题\n修复运行报错问题\n修复数据导入 har 文件问题\n"
        },
        {
          "title": "v1.3.9",
          "url": "/documents/CHANGELOG.html#v1.3.9",
          "content": "v1.3.9Feature增加接口编辑返回数据预览\n修复旧的文档链接\nBug Fixed导入数据为空提示\n"
        },
        {
          "title": "v1.3.8",
          "url": "/documents/CHANGELOG.html#v1.3.8",
          "content": "v1.3.8Feature新增 json 结构可视化编辑器\npre-script 增加 method 字段数据\nBug Fixed点击编辑 tab 可能导致运行功能异常\n修复postman导入没有分类的问题\n修复postman参数导入缺失\n"
        },
        {
          "title": "v1.3.7",
          "url": "/documents/CHANGELOG.html#v1.3.7",
          "content": "v1.3.7Feature完美支持 swagger, 接口请求参数和返回数据支持使用 json-schema 定义数据结构\n增加测试集合列表的拖动功能\n接口列表中增加“开放接口”状态\n接口列表树形组件支持拖动\njson-schema 导出 table 表单\n接口列表和测试集树形组件支持拖动\n图标从阿里 cdn 替换到本地\nBug Fixed修复高级 Mock 服务端报错\n修复测试集合 table 拖动频繁请求的问题\n修复 swagger 数据导入部分 bug\n"
        },
        {
          "title": "v1.3.6",
          "url": "/documents/CHANGELOG.html#v1.3.6",
          "content": "v1.3.6Feature增加服务端的自动化测试功能,可集成到 jenkins, github 做接口自动化测试\n增加导出公共接口功能\n增加复制接口路径按钮\n增加项目 token 功能，可通过 token 访问开放接口\nantd 升级到 v3\nBug Fixed修复接口动态提示有误\n修复变量表达式无法反向展示的问题\n"
        },
        {
          "title": "v1.3.5",
          "url": "/documents/CHANGELOG.html#v1.3.5",
          "content": "v1.3.5Feature增加项目成员批量导入\n数据导入同步，数据导入支持 swagger 3.0\nswagger 数据导入支持 2xx 的 httpcode\n新增系统信息页面\nBug Fixed修复离开接口编辑页面的 confirm 框有时候会触发两次 & confirm 的 ‘X’ 按钮无效\n修复添加集合后测试集合 list 不更新问题\n测试集合点击对应接口侧边栏不切换\n测试集合处，点击删除不成功\n修改编辑接口后，再回到测试集合处数据不更新问题\n修复 mongodb 帐号密码配置错误时引发的错误\n修复删除分组后侧边数据没有更新问题\n"
        },
        {
          "title": "v1.3.4",
          "url": "/documents/CHANGELOG.html#v1.3.4",
          "content": "v1.3.4Feature帮助文档首页增加部署公司\n进入 project 页面加入 loading\n接口 list 页 table 中加入分页\n项目添加者自动变成项目组长\nBug Fixed修复无权限进入项目 bug\n修复复制接口，query 等参数无法复制 bug\n修复导出 html markdown 参数丢失问题\n修复项目设置 pre-script 无法显示问题\n"
        },
        {
          "title": "v1.3.3",
          "url": "/documents/CHANGELOG.html#v1.3.3",
          "content": "v1.3.3Feature邮件功能中： 1）接口信息改动增加通知对应项目所有的成员；2）默认开启接口改动邮件提醒；3) 增加邮件内容的 jsondiff 信息\nBug Fixed优化接口运行页面插件提醒\n完善 log 记录不到的问题\n修复接口内容改动不发送邮件问题\n修复部分 swagger 数据导入丢失问题\n"
        },
        {
          "title": "v1.3.2",
          "url": "/documents/CHANGELOG.html#v1.3.2",
          "content": "v1.3.2Feature分组中新增接口自定义字段，便于用户在项目中添加额外字段数据\n导入数据时新增导入 loading 显示\n"
        },
        {
          "title": "v1.3.1",
          "url": "/documents/CHANGELOG.html#v1.3.1",
          "content": "v1.3.1Bug Fixed修复接口状态和 req_params 参数无法更新问题\n修复搜索测试集合不展开问题\n修复测试过程中全局 header 不存在的问题\n"
        },
        {
          "title": "v1.3.0",
          "url": "/documents/CHANGELOG.html#v1.3.0",
          "content": "v1.3.0Featureyapi 默认集成 ldap 登录方式\nyapi 做一个 sso 登录插件，基于现有的 qsso 改造成大多数公司可用的\n环境设置支持全局 header\n接口运行页面选择环境增加管理环境的弹层\n接口运行支持加工运行前后的 request 和 response ，主要是处理加密的接口或各种 token 参数问题\n自动化测试除提供自定义脚本外，还提供可视化表单形式验证一些数据，例如 statusCode、bodyContent\n增加查看接口详细改动\n支持接口运行页面 body 全屏编辑\n数据导出到 html 支持了分类\nBug Fixed修复了高级 Mock 无法获取到真实客户端 ip\n"
        },
        {
          "title": "v1.2.9",
          "url": "/documents/CHANGELOG.html#v1.2.9",
          "content": "v1.2.9Bug FixedApi 路径兼容 postman {varible}\nView Response Height 问题\nFeature新增克隆测试集功能\n高级 Mock 期望支持 mockjs\npathname 允许只有一个 /\n"
        },
        {
          "title": "v1.2.8",
          "url": "/documents/CHANGELOG.html#v1.2.8",
          "content": "v1.2.8Bug Fixed修复接口运行 json 格式问题\n修复测试报告显示问题\n增加了接口数量统计\n多参数表达式改用双大括号{{}}\n修复了环境变量设置样式问题\nFeature测试用例增加自定义测试脚本功能\n"
        },
        {
          "title": "v1.2.7",
          "url": "/documents/CHANGELOG.html#v1.2.7",
          "content": "v1.2.7Bug Fixed修复接口运行功能，当 httpCode 不是 200 时，导致无法获取 response body 问题\n修复路径参数无法删除优化测试集 table 页面，当文字超出一定长度会换行的问题\n优化测试集断言错误提示\n优化接口编辑 save 按钮样式\nFeature测试集断言增加 log 方法，用于输出调试日志\n可视化动态参数表达式生成器，生成类似表达式 {@email | concat: pass | md5 | substr: 1,10}\n"
        },
        {
          "title": "v1.2.6",
          "url": "/documents/CHANGELOG.html#v1.2.6",
          "content": "v1.2.6Bug Fixed修复路径参数无法删除\nFeature参数值支持多个动态参数，类似 str{@email}str{$.55.body.id}\n参数值支持管道表达式,例如 {@email | concat: pass | md5 | substr: 1,10}\n接口编辑参数可拖动排序\n修复路径参数无法删除问题\n"
        },
        {
          "title": "v1.2.5",
          "url": "/documents/CHANGELOG.html#v1.2.5",
          "content": "v1.2.5Bug Fixed成员如果第一次添加成员时选择组长，接着再添加下一个成员，如果 select 是默认的开发者，这时候会出现与上次 select 相同的值\n如果添加了一个不存在的成员还是会提示添加成功，并且发送的数据是原来发送成功的数据，这里需要重置初始值并在未找到对应用户名时对未找到的人名应该提示用户不存在\nFix 接口集自动化测试 header 没有解析 mock 和 变量参数\n在接口开发阶段，多个人并行改接口，如果最后一个人改之前没刷新页面，会把之前的人修改过的都冲掉了\n修复 cross-request，response header 字段重复 bug\nFeature优化了分组添加，编辑交互\ncross-request 计算了接口请求时间\n新增接口文档导出 html, markdown 功能\n"
        },
        {
          "title": "v1.2.4",
          "url": "/documents/CHANGELOG.html#v1.2.4",
          "content": "v1.2.4Bug Fixed期望值输入时候换成字符串，导致 diff 时因类型不一致匹配不上\nswagger 导入数据时出现的 id 未定义 bug\nfix: kerberos dependencies 导致安装依赖需要编译的问题\n修复了高级 mock 期望过滤参数为空时匹配不到的 bug\n将接口编辑页的保存按钮变成一直在窗口底部\n修改需求文档中项目操作处修改项目中的接口测试 a 链接指向的网页错误问题\n添加接口时重名，现在提示“已存在”，并在提示信息中告知用户删改接口的位置\n已添加的成员，再次添加会提示“添加成功”，优化提示为已成功添加人数，和已存在人数\n添加分组和修改分组时有个权限问题没有更新，切换列表才更新，该问题已解决\n解决修改和删除公共分类名称处，在添加接口时，选择接口分类名称没有修改的问题\nFeature接口 path 支持了后面带 /\ncross-request 支持了不安全的 header，如 cookie, referer...\n支持了 path 带特殊符号\"!\"\n请求参数可改变顺序，目前只是对必需和非必需进行自动排序\n用户头像上传问题，txt 改成 jpg 格式上传，用户头像显示空白，然后无法再次上传头像。无法再次上传的问题已经解决\n解决用户头像改变但是 header 处图片不变的问题。问题描述：用户上传头像成功但是 Header 处的头像没有改变，并且点击其他页面后再回到个人中心里面的头像又变成没有重新上传时的图片，必须重新刷新才可以将 Header 处的图片更新\n解决导入 postman 接口动态路由无法导入的 Bug\n"
        },
        {
          "title": "v1.2.0",
          "url": "/documents/CHANGELOG.html#v1.2.0",
          "content": "v1.2.0Features增加高级 Mock 期望功能，根据设置的请求过滤规则，返回期望数据。\n增加统计功能\n增加自动化测试功能，写断言脚本，实现精准测试\nBug Fixed修复了切换集合环境的 Bug\n修复了 mockServer 拿不到 Post 请求 Body\n修复了接口调试 pathParams 无法使用 mock 参数和变量参数\n"
        },
        {
          "title": "v1.1.2",
          "url": "/documents/CHANGELOG.html#v1.1.2",
          "content": "v1.1.2Features接口运行增加了 query 和 body 的 enable 选项，可选择是否请求该字段\nMock 支持了时间戳占位符 @timestamp\n接口集运行页面可选择环境\n接口集动态参数格式由原来的 $.{key}.{jsonPath} 改为 $.{key}.{body|params}.{jsonPath}\nBug Fixed修复了接口集运行功能会忽略环境配置的 domain 路径\n修复了动态路由 mock 返回结果不是该接口定义返回数据\n修复了日志链接错误问题\n修复了添加用户 loading 问题\n修复了用户名编辑，前台未更新问题\n修复了复制接口导致 GET 请求显示 request-body 问题\n修复了接口集页面刷新后跳转到第一个接口集问题\n修复了接口用例页面修改 header 参数值没有效果 bug\n修复了接口集页面导入接口会导致 reqBody 清空 bug\n"
        },
        {
          "title": "v1.1.1",
          "url": "/documents/CHANGELOG.html#v1.1.1",
          "content": "v1.1.1Features添加插件开发文档\n接口和测试用例可拖动\n优化动态提示\nBug Fixed修复接口状态将接口方法重置为 get\n环境配置域名带 path 无效\n修复 Swagger 数据导入分类 bug\nMockServer 支持 CORS 跨域\n优化 JSON-SCHEMA 转化为 JSON 的逻辑，由原来随机转换不被 required 字段改为转换全部字段\n修复了项目成员无法看到该项目的 Bug\n修复了无法查看公共项目的 Bug\n优化了部分样式和交互\n"
        },
        {
          "title": "v1.1.0",
          "url": "/documents/CHANGELOG.html#v1.1.0",
          "content": "v1.1.0Features新增个人空间功能，拥有这个分组的全部权限，可以在这个分组里探索 YApi 的功能\n新增分组动态功能\n优化接口运行页面交互\nCrossRequest 扩展支持 https\n增加了 Swagger 数据导入功能\n"
        },
        {
          "title": "v1.0.2",
          "url": "/documents/CHANGELOG.html#v1.0.2",
          "content": "v1.0.2Features网站改为 100%布局\n优化搜索的提示\n支持了 queryPath\n接口浏览页面和编辑页面交互\n新增高级 Mock 功能，可通过 js 代码去控制 mock 数据的生成\n测试集支持了自动化测试\n增加复制接口功能\n在组长和开发者权限基础上，添加了 查看着 权限\n"
        },
        {
          "title": "v1.0.1",
          "url": "/documents/CHANGELOG.html#v1.0.1",
          "content": "v1.0.1Fix Bug修改接口名字后，需要刷新页面左边的侧边栏才会显示正确的名字\nmockJson 出现 null，mock 出现格式不对问题\n没有权限的分组不可选\n项目列表图标设计大小优化下\n关注的项目不显眼\n添加接口之后，再次选择添加接口，会保留上次填写的信息\n用例名称太长，导致无法使用删除功能\n别人知道项目 id 虽然没有权限，但能看到里面所有内容\nFeatures接口备注集成了富文本编辑\n支持 har 协议的接口数据导入\ntodo:新增 crypto 加密函数"
        }
      ]
    },
    {
      "title": "",
      "content": "",
      "url": "/documents/CHANGELOG.html",
      "children": [
        {
          "title": "v1.5.6",
          "url": "/documents/CHANGELOG.html#v1.5.6",
          "content": "v1.5.6修复 /api/open/import_data 参数bug\n修复  /api/open/import_data 文档错误，merge 参数误写为 dataSync\n"
        },
        {
          "title": "v1.5.5",
          "url": "/documents/CHANGELOG.html#v1.5.5",
          "content": "v1.5.5cross-request 升级到 2.10\n/api/open/import_data 新增 url 参数，支持服务端 url 导入\n"
        },
        {
          "title": "v1.5.2",
          "url": "/documents/CHANGELOG.html#v1.5.2",
          "content": "v1.5.2新增 openapi /api/project/get，可获取项目基本信息\n"
        },
        {
          "title": "v1.5.1",
          "url": "/documents/CHANGELOG.html#v1.5.1",
          "content": "v1.5.1优化 restful api 动态路由权重匹配算法，匹配更加精确\nopenapi 新增 /api/interface/list_cat，获取某个分类下所有接口\n新增了 rap数据导入到 yapi 插件 rap2yapi\n"
        },
        {
          "title": "v1.5.0",
          "url": "/documents/CHANGELOG.html#v1.5.0",
          "content": "v1.5.0优化开放 api功能，现在 token 带有用户信息了\n修复无法获取请求302 跳转前的 headers\n"
        },
        {
          "title": "v1.4.4",
          "url": "/documents/CHANGELOG.html#v1.4.4",
          "content": "v1.4.4优化了 json-schema 编辑器交互，修复了参数名写到一半提示重复的问题\n优化了首页体验，提升页面打开速度\n新增自动化测试通用规则配置功能\n"
        },
        {
          "title": "v1.4.3",
          "url": "/documents/CHANGELOG.html#v1.4.3",
          "content": "v1.4.3修复了可视化安装，mongodb 报错的问题\n支持了 swagger 导出功能\n支持了克隆测试用例\n"
        },
        {
          "title": "v1.4.2",
          "url": "/documents/CHANGELOG.html#v1.4.2",
          "content": "v1.4.2优化数据导入对 headers 处理，如果 requestType 是 json，自动增加header \"content-type/json\"\nfix: 修改了测试集合有多个项目接口时，切换执行环境相互覆盖不生效的问题 #692\nfix: mongoose warning 'Error: (node:3819) DeprecationWarning: collection.ensureIndex is deprecated. Use createIndexes instead'\nopti: 去掉没必要的redux-thunk\n接口更新没有变化时，不记录日志，避免cron多次导入swagger的接口时，导致动态里展示一大堆的无意义日志\n"
        },
        {
          "title": "v1.4.1",
          "url": "/documents/CHANGELOG.html#v1.4.1",
          "content": "v1.4.1支持任何人都可以添加分组，只有管理员才能修改项目是否公开\n支持 mongodb 集群\nBug Fixed修改 mock严格模式，GET带有 JSON BODY 导致的验证问题\n对 queryPath 改动导致的bug，支持通过 xxx?controller=name 等 query 参数区分路径\n因 tui-editor 需要安装github 依赖，导致部分机器无法部署成功的问题\n"
        },
        {
          "title": "v1.3.23",
          "url": "/documents/CHANGELOG.html#v1.3.23",
          "content": "v1.3.23接口tag功能\n数据导入增加 merge 功能\n增加参数的批量导入功能\njson schema 可视化编辑器增加 mock 功能\nBug Fixed接口path中写入 ?name=xxx bug\n高级mock 匹配 data: [{item: XXX}] 时匹配不成功\n接口运行 query params 自动勾选\nmock get 带 cookie 时跨域\njson schema 嵌套多层 array 预览不展示 bug\nswagger URL 导入 跨域问题\n"
        },
        {
          "title": "v1.3.22",
          "url": "/documents/CHANGELOG.html#v1.3.22",
          "content": "v1.3.22json schema number和integer支持枚举\n服务端测试增加下载功能\n增加 mock 接口请求字段参数验证\n增加返回数据验证\nBug Fixed命令行导入成员信息为 undefined\n修复form 参数为空时 接口无法保存的问题\n"
        },
        {
          "title": "v1.3.21",
          "url": "/documents/CHANGELOG.html#v1.3.21",
          "content": "v1.3.21请求配置增加 context.utils.CryptoJS\n环境变量支持自定义全局变量\n增加wiki数据导出功能\n用户管理处增加搜索功能\n增加项目全局 mock 脚本功能\n高级 mock 期望 支持关闭开启功能\nBug Fixed优化ldap登陆\nswagger 导入公共params\n接口编辑 mockEditor 修改为 AceEditor\n"
        },
        {
          "title": "v1.3.20",
          "url": "/documents/CHANGELOG.html#v1.3.20",
          "content": "v1.3.20Bug Fixed修复 ykit 打包代码问题\n修复 swagger url 导入选中后再切换其他数据方式时拖拽区域不出现问题\n修复 wiki controller 后端报错问题\n"
        },
        {
          "title": "v1.3.19",
          "url": "/documents/CHANGELOG.html#v1.3.19",
          "content": "v1.3.19增加项目文档记录wiki\n支持swagger URL 导入\n接口运行和测试集合中加入参数备注信息\n测试接口导入支持状态过滤\njson schema 增加枚举备注功能\n左侧菜单栏可以支持单独滚动条\n支持新版本通知\nBug Fixed修复测试用例名称为空时保存测试用例出现的bug\n导出markdown 路径参数处格式错误和参数table备注信息换行后样式错误\n"
        },
        {
          "title": "v1.3.18",
          "url": "/documents/CHANGELOG.html#v1.3.18",
          "content": "v1.3.18增加全局接口搜索功能\n邮件通知过滤功能\nBug Fixed新建接口自动添加为项目成员\n修复type为raw header type 为form 时运行body 为空问题\nmongodb3.4-> 3.6 聚合 cursor报错\npath 路径支持 ！\njson-schema 编辑器修复修改 type 导致描述信息被重置的问题\n"
        },
        {
          "title": "v1.3.17",
          "url": "/documents/CHANGELOG.html#v1.3.17",
          "content": "v1.3.17请求配置中添加 context.castId 字段用于标识测试用例\nBug Fixed修复服务器端测试，邮件通知开启token undefined bug\n将状态由未完成修改成已完成之后，原来的json格式的数据会变成json-schema\n有分类为空时导出json后再导入报错\n只修改参数 必需/非必需, 文本/文件 时, 查看改动详情, 提示没有改动\nldap登陆允许用户输入的登陆账号非邮箱\n"
        },
        {
          "title": "v1.3.16",
          "url": "/documents/CHANGELOG.html#v1.3.16",
          "content": "v1.3.16支持自定义域名邮箱登录\n测试用例支持导入不同项目接口\n完善可视化表达式，可根据焦点编辑表达式\nreq_body json 支持指针位置可视化插入表达式\nBug Fixed导入postman  headers 为 null 时报错\nformat-data 数据解析不成功\n导出的接口顺序按照api的接口顺序\n"
        },
        {
          "title": "v1.3.15",
          "url": "/documents/CHANGELOG.html#v1.3.15",
          "content": "v1.3.15增强跨域请求安全性，只允许 YApi 网站进行跨域请求\n优化文档\n修复 schema 描述信息展示 bug\n增加禁止普通用户注册功能\n"
        },
        {
          "title": "v1.3.14",
          "url": "/documents/CHANGELOG.html#v1.3.14",
          "content": "v1.3.14修复接口编辑白屏问题\n"
        },
        {
          "title": "v1.3.13",
          "url": "/documents/CHANGELOG.html#v1.3.13",
          "content": "v1.3.13新增通过命令行导入 swagger 接口数据功能\n接口请求设置新增异步处理特性\n"
        },
        {
          "title": "v1.3.12",
          "url": "/documents/CHANGELOG.html#v1.3.12",
          "content": "v1.3.12Feature接口列表支持路径查询\n项目复制\n预览页面交互优化\n优化服务端自动化测试文案\n增加项目接口json数据导入导出功能\nBug Fixed项目中访客权限的账号可以 增、删、改接口中高级mock的设置\n高级Mock 中的响应时间值无法保存（实际提示为：保存成功）\n分类为空时添加接口\n"
        },
        {
          "title": "v1.3.11",
          "url": "/documents/CHANGELOG.html#v1.3.11",
          "content": "v1.3.11Bug Fixed修复 v1.3.10 websocket 连接问题\n修复运行报错问题\n修复数据导入 har 文件问题\n"
        },
        {
          "title": "v1.3.9",
          "url": "/documents/CHANGELOG.html#v1.3.9",
          "content": "v1.3.9Feature增加接口编辑返回数据预览\n修复旧的文档链接\nBug Fixed导入数据为空提示\n"
        },
        {
          "title": "v1.3.8",
          "url": "/documents/CHANGELOG.html#v1.3.8",
          "content": "v1.3.8Feature新增 json 结构可视化编辑器\npre-script 增加 method 字段数据\nBug Fixed点击编辑 tab 可能导致运行功能异常\n修复postman导入没有分类的问题\n修复postman参数导入缺失\n"
        },
        {
          "title": "v1.3.7",
          "url": "/documents/CHANGELOG.html#v1.3.7",
          "content": "v1.3.7Feature完美支持 swagger, 接口请求参数和返回数据支持使用 json-schema 定义数据结构\n增加测试集合列表的拖动功能\n接口列表中增加“开放接口”状态\n接口列表树形组件支持拖动\njson-schema 导出 table 表单\n接口列表和测试集树形组件支持拖动\n图标从阿里 cdn 替换到本地\nBug Fixed修复高级 Mock 服务端报错\n修复测试集合 table 拖动频繁请求的问题\n修复 swagger 数据导入部分 bug\n"
        },
        {
          "title": "v1.3.6",
          "url": "/documents/CHANGELOG.html#v1.3.6",
          "content": "v1.3.6Feature增加服务端的自动化测试功能,可集成到 jenkins, github 做接口自动化测试\n增加导出公共接口功能\n增加复制接口路径按钮\n增加项目 token 功能，可通过 token 访问开放接口\nantd 升级到 v3\nBug Fixed修复接口动态提示有误\n修复变量表达式无法反向展示的问题\n"
        },
        {
          "title": "v1.3.5",
          "url": "/documents/CHANGELOG.html#v1.3.5",
          "content": "v1.3.5Feature增加项目成员批量导入\n数据导入同步，数据导入支持 swagger 3.0\nswagger 数据导入支持 2xx 的 httpcode\n新增系统信息页面\nBug Fixed修复离开接口编辑页面的 confirm 框有时候会触发两次 & confirm 的 ‘X’ 按钮无效\n修复添加集合后测试集合 list 不更新问题\n测试集合点击对应接口侧边栏不切换\n测试集合处，点击删除不成功\n修改编辑接口后，再回到测试集合处数据不更新问题\n修复 mongodb 帐号密码配置错误时引发的错误\n修复删除分组后侧边数据没有更新问题\n"
        },
        {
          "title": "v1.3.4",
          "url": "/documents/CHANGELOG.html#v1.3.4",
          "content": "v1.3.4Feature帮助文档首页增加部署公司\n进入 project 页面加入 loading\n接口 list 页 table 中加入分页\n项目添加者自动变成项目组长\nBug Fixed修复无权限进入项目 bug\n修复复制接口，query 等参数无法复制 bug\n修复导出 html markdown 参数丢失问题\n修复项目设置 pre-script 无法显示问题\n"
        },
        {
          "title": "v1.3.3",
          "url": "/documents/CHANGELOG.html#v1.3.3",
          "content": "v1.3.3Feature邮件功能中： 1）接口信息改动增加通知对应项目所有的成员；2）默认开启接口改动邮件提醒；3) 增加邮件内容的 jsondiff 信息\nBug Fixed优化接口运行页面插件提醒\n完善 log 记录不到的问题\n修复接口内容改动不发送邮件问题\n修复部分 swagger 数据导入丢失问题\n"
        },
        {
          "title": "v1.3.2",
          "url": "/documents/CHANGELOG.html#v1.3.2",
          "content": "v1.3.2Feature分组中新增接口自定义字段，便于用户在项目中添加额外字段数据\n导入数据时新增导入 loading 显示\n"
        },
        {
          "title": "v1.3.1",
          "url": "/documents/CHANGELOG.html#v1.3.1",
          "content": "v1.3.1Bug Fixed修复接口状态和 req_params 参数无法更新问题\n修复搜索测试集合不展开问题\n修复测试过程中全局 header 不存在的问题\n"
        },
        {
          "title": "v1.3.0",
          "url": "/documents/CHANGELOG.html#v1.3.0",
          "content": "v1.3.0Featureyapi 默认集成 ldap 登录方式\nyapi 做一个 sso 登录插件，基于现有的 qsso 改造成大多数公司可用的\n环境设置支持全局 header\n接口运行页面选择环境增加管理环境的弹层\n接口运行支持加工运行前后的 request 和 response ，主要是处理加密的接口或各种 token 参数问题\n自动化测试除提供自定义脚本外，还提供可视化表单形式验证一些数据，例如 statusCode、bodyContent\n增加查看接口详细改动\n支持接口运行页面 body 全屏编辑\n数据导出到 html 支持了分类\nBug Fixed修复了高级 Mock 无法获取到真实客户端 ip\n"
        },
        {
          "title": "v1.2.9",
          "url": "/documents/CHANGELOG.html#v1.2.9",
          "content": "v1.2.9Bug FixedApi 路径兼容 postman {varible}\nView Response Height 问题\nFeature新增克隆测试集功能\n高级 Mock 期望支持 mockjs\npathname 允许只有一个 /\n"
        },
        {
          "title": "v1.2.8",
          "url": "/documents/CHANGELOG.html#v1.2.8",
          "content": "v1.2.8Bug Fixed修复接口运行 json 格式问题\n修复测试报告显示问题\n增加了接口数量统计\n多参数表达式改用双大括号{{}}\n修复了环境变量设置样式问题\nFeature测试用例增加自定义测试脚本功能\n"
        },
        {
          "title": "v1.2.7",
          "url": "/documents/CHANGELOG.html#v1.2.7",
          "content": "v1.2.7Bug Fixed修复接口运行功能，当 httpCode 不是 200 时，导致无法获取 response body 问题\n修复路径参数无法删除优化测试集 table 页面，当文字超出一定长度会换行的问题\n优化测试集断言错误提示\n优化接口编辑 save 按钮样式\nFeature测试集断言增加 log 方法，用于输出调试日志\n可视化动态参数表达式生成器，生成类似表达式 {@email | concat: pass | md5 | substr: 1,10}\n"
        },
        {
          "title": "v1.2.6",
          "url": "/documents/CHANGELOG.html#v1.2.6",
          "content": "v1.2.6Bug Fixed修复路径参数无法删除\nFeature参数值支持多个动态参数，类似 str{@email}str{$.55.body.id}\n参数值支持管道表达式,例如 {@email | concat: pass | md5 | substr: 1,10}\n接口编辑参数可拖动排序\n修复路径参数无法删除问题\n"
        },
        {
          "title": "v1.2.5",
          "url": "/documents/CHANGELOG.html#v1.2.5",
          "content": "v1.2.5Bug Fixed成员如果第一次添加成员时选择组长，接着再添加下一个成员，如果 select 是默认的开发者，这时候会出现与上次 select 相同的值\n如果添加了一个不存在的成员还是会提示添加成功，并且发送的数据是原来发送成功的数据，这里需要重置初始值并在未找到对应用户名时对未找到的人名应该提示用户不存在\nFix 接口集自动化测试 header 没有解析 mock 和 变量参数\n在接口开发阶段，多个人并行改接口，如果最后一个人改之前没刷新页面，会把之前的人修改过的都冲掉了\n修复 cross-request，response header 字段重复 bug\nFeature优化了分组添加，编辑交互\ncross-request 计算了接口请求时间\n新增接口文档导出 html, markdown 功能\n"
        },
        {
          "title": "v1.2.4",
          "url": "/documents/CHANGELOG.html#v1.2.4",
          "content": "v1.2.4Bug Fixed期望值输入时候换成字符串，导致 diff 时因类型不一致匹配不上\nswagger 导入数据时出现的 id 未定义 bug\nfix: kerberos dependencies 导致安装依赖需要编译的问题\n修复了高级 mock 期望过滤参数为空时匹配不到的 bug\n将接口编辑页的保存按钮变成一直在窗口底部\n修改需求文档中项目操作处修改项目中的接口测试 a 链接指向的网页错误问题\n添加接口时重名，现在提示“已存在”，并在提示信息中告知用户删改接口的位置\n已添加的成员，再次添加会提示“添加成功”，优化提示为已成功添加人数，和已存在人数\n添加分组和修改分组时有个权限问题没有更新，切换列表才更新，该问题已解决\n解决修改和删除公共分类名称处，在添加接口时，选择接口分类名称没有修改的问题\nFeature接口 path 支持了后面带 /\ncross-request 支持了不安全的 header，如 cookie, referer...\n支持了 path 带特殊符号\"!\"\n请求参数可改变顺序，目前只是对必需和非必需进行自动排序\n用户头像上传问题，txt 改成 jpg 格式上传，用户头像显示空白，然后无法再次上传头像。无法再次上传的问题已经解决\n解决用户头像改变但是 header 处图片不变的问题。问题描述：用户上传头像成功但是 Header 处的头像没有改变，并且点击其他页面后再回到个人中心里面的头像又变成没有重新上传时的图片，必须重新刷新才可以将 Header 处的图片更新\n解决导入 postman 接口动态路由无法导入的 Bug\n"
        },
        {
          "title": "v1.2.0",
          "url": "/documents/CHANGELOG.html#v1.2.0",
          "content": "v1.2.0Features增加高级 Mock 期望功能，根据设置的请求过滤规则，返回期望数据。\n增加统计功能\n增加自动化测试功能，写断言脚本，实现精准测试\nBug Fixed修复了切换集合环境的 Bug\n修复了 mockServer 拿不到 Post 请求 Body\n修复了接口调试 pathParams 无法使用 mock 参数和变量参数\n"
        },
        {
          "title": "v1.1.2",
          "url": "/documents/CHANGELOG.html#v1.1.2",
          "content": "v1.1.2Features接口运行增加了 query 和 body 的 enable 选项，可选择是否请求该字段\nMock 支持了时间戳占位符 @timestamp\n接口集运行页面可选择环境\n接口集动态参数格式由原来的 $.{key}.{jsonPath} 改为 $.{key}.{body|params}.{jsonPath}\nBug Fixed修复了接口集运行功能会忽略环境配置的 domain 路径\n修复了动态路由 mock 返回结果不是该接口定义返回数据\n修复了日志链接错误问题\n修复了添加用户 loading 问题\n修复了用户名编辑，前台未更新问题\n修复了复制接口导致 GET 请求显示 request-body 问题\n修复了接口集页面刷新后跳转到第一个接口集问题\n修复了接口用例页面修改 header 参数值没有效果 bug\n修复了接口集页面导入接口会导致 reqBody 清空 bug\n"
        },
        {
          "title": "v1.1.1",
          "url": "/documents/CHANGELOG.html#v1.1.1",
          "content": "v1.1.1Features添加插件开发文档\n接口和测试用例可拖动\n优化动态提示\nBug Fixed修复接口状态将接口方法重置为 get\n环境配置域名带 path 无效\n修复 Swagger 数据导入分类 bug\nMockServer 支持 CORS 跨域\n优化 JSON-SCHEMA 转化为 JSON 的逻辑，由原来随机转换不被 required 字段改为转换全部字段\n修复了项目成员无法看到该项目的 Bug\n修复了无法查看公共项目的 Bug\n优化了部分样式和交互\n"
        },
        {
          "title": "v1.1.0",
          "url": "/documents/CHANGELOG.html#v1.1.0",
          "content": "v1.1.0Features新增个人空间功能，拥有这个分组的全部权限，可以在这个分组里探索 YApi 的功能\n新增分组动态功能\n优化接口运行页面交互\nCrossRequest 扩展支持 https\n增加了 Swagger 数据导入功能\n"
        },
        {
          "title": "v1.0.2",
          "url": "/documents/CHANGELOG.html#v1.0.2",
          "content": "v1.0.2Features网站改为 100%布局\n优化搜索的提示\n支持了 queryPath\n接口浏览页面和编辑页面交互\n新增高级 Mock 功能，可通过 js 代码去控制 mock 数据的生成\n测试集支持了自动化测试\n增加复制接口功能\n在组长和开发者权限基础上，添加了 查看着 权限\n"
        },
        {
          "title": "v1.0.1",
          "url": "/documents/CHANGELOG.html#v1.0.1",
          "content": "v1.0.1Fix Bug修改接口名字后，需要刷新页面左边的侧边栏才会显示正确的名字\nmockJson 出现 null，mock 出现格式不对问题\n没有权限的分组不可选\n项目列表图标设计大小优化下\n关注的项目不显眼\n添加接口之后，再次选择添加接口，会保留上次填写的信息\n用例名称太长，导致无法使用删除功能\n别人知道项目 id 虽然没有权限，但能看到里面所有内容\nFeatures接口备注集成了富文本编辑\n支持 har 协议的接口数据导入\ntodo:新增 crypto 加密函数"
        }
      ]
    }
  ],
  "内网部署": [
    {
      "title": "内网部署",
      "content": "使用我们提供的 yapi-cli 工具，部署 YApi 平台是非常容易的。建议部署成 http 站点，因 chrome 浏览器安全限制，部署成 https 会导致测试功能在请求 http 站点时文件上传功能异常。如果您是将服务器代理到 nginx 服务器，请配置 nginx 支持 websocket。在location /添加proxy_http_version 1.1;\nproxy_set_header Upgrade $http_upgrade;\nproxy_set_header Connection \"upgrade\";\n",
      "url": "/devops/index.html",
      "children": [
        {
          "title": "环境要求",
          "url": "/devops/index.html#环境要求",
          "content": "环境要求nodejs（7.6+)\nmongodb（2.6+）\n"
        },
        {
          "title": "安装",
          "url": "/devops/index.html#安装",
          "content": "安装"
        },
        {
          "title": "方式一. 可视化部署[推荐]",
          "url": "/devops/index.html#安装-方式一.-可视化部署[推荐]",
          "content": "方式一. 可视化部署[推荐]执行 yapi server 启动可视化部署程序，输入相应的配置和点击开始部署，就能完成整个网站的部署。部署完成之后，可按照提示信息，执行 node/{网站路径/server/app.js} 启动服务器。在浏览器打开指定url, 点击登录输入您刚才设置的管理员邮箱，默认密码(ymfe.org) 登录系统（默认密码可在个人中心修改）。npm install -g yapi-cli --registry https://registry.npm.taobao.orgyapi server\n"
        },
        {
          "title": "方式二. 命令行部署",
          "url": "/devops/index.html#安装-方式二.-命令行部署",
          "content": "方式二. 命令行部署如果 github 压缩文件无法下载，或需要部署到一些特殊的服务器，可尝试此方法mkdir yapicd yapi\ngit clone https://github.com/YMFE/yapi.git vendors //或者下载 zip 包解压到 vendors 目录（clone 整个仓库大概 140+ M，可以通过 `git clone --depth=1 https://github.com/YMFE/yapi.git vendors` 命令减少，大概 10+ M）\ncp vendors/config_example.json ./config.json //复制完成后请修改相关配置\ncd vendors\nnpm install --production --registry https://registry.npm.taobao.org\nnpm run install-server //安装程序会初始化数据库索引和管理员账号，管理员账号名可在 config.json 配置\nnode server/app.js //启动服务器后，请访问 127.0.0.1:{config.json配置的端口}，初次运行会有个编译的过程，请耐心等候\n安装后的目录结构如下：|-- config.json|-- init.lock\n|-- log\n`-- vendors\n    |-- CHANGELOG.md\n    |-- LICENSE\n    |-- README.md\n    |-- client\n    |-- common\n    |-- config_example.json\n    |-- doc\n    |-- exts\n    |-- nodemon.json\n    |-- npm-debug.log\n    |-- package.json\n    |-- plugin.json\n    |-- server\n    |-- static\n    |-- test\n    |-- webpack.alias.js\n    |-- yapi-base-flow.jpg\n    |-- ydocfile.js\n    `-- ykit.config.js\n"
        },
        {
          "title": "服务器管理",
          "url": "/devops/index.html#服务器管理",
          "content": "服务器管理推荐使用 pm2 管理 node 服务器启动，停止，具体使用方法可参考下面的教程：官网文档\nPM2实用入门指南\n"
        },
        {
          "title": "升级",
          "url": "/devops/index.html#升级",
          "content": "升级升级项目版本是非常容易的，并且不会影响已有的项目数据，只会同步 vendors 目录下的源码文件。cd  {项目目录}yapi ls //查看版本号列表\nyapi update //升级到最新版本\nyapi update -v v1.1.0 //升级到指定版本\n"
        },
        {
          "title": "配置邮箱",
          "url": "/devops/index.html#配置邮箱",
          "content": "配置邮箱打开项目目录 config.json 文件，新增 mail 配置， 替换默认的邮箱配置{  \"port\": \"*****\",\n  \"adminAccount\": \"********\",\n  \"db\": {...},\n  \"mail\": {\n    \"enable\": true,\n    \"host\": \"smtp.163.com\",    //邮箱服务器\n    \"port\": 465,               //端口\n    \"from\": \"***@163.com\",     //发送人邮箱\n    \"auth\": {\n        \"user\": \"***@163.com\", //邮箱服务器账号\n        \"pass\": \"*****\"        //邮箱服务器密码\n    }\n  }\n}\n如何申请STMP服务器账号和密码可以参考下面的教程：如何开通电子邮箱的SMTP功能"
        },
        {
          "title": "配置LDAP登录",
          "url": "/devops/index.html#配置ldap登录",
          "content": "配置LDAP登录打开项目目录 config.json 文件，添加如下字段：{  \"port\": \"*****\",\n  \"adminAccount\": \"********\",\n  \"db\": {...},\n  \"mail\": {...},\n  \"ldapLogin\": {\n      \"enable\": true,\n      \"server\": \"ldap://l-ldapt1.com\",\n      \"baseDn\": \"CN=Admin,CN=Users,DC=test,DC=com\",\n      \"bindPassword\": \"password123\",\n      \"searchDn\": \"OU=UserContainer,DC=test,DC=com\",\n      \"searchStandard\": \"mail\",    // 自定义格式： \"searchStandard\": \"&(objectClass=user)(cn=%s)\"\n      \"emailPostfix\": \"@163.com\",\n      \"emailKey\": \"mail\",\n      \"usernameKey\": \"name\"\n   }\n}\n\n这里面的配置项含义如下：enable 表示是否配置 LDAP 登录，true(支持 LDAP登录 )/false(不支持LDAP登录);\nserver LDAP 服务器地址，前面需要加上 ldap:// 前缀，也可以是 ldaps:// 表示是通过 SSL 连接;\nbaseDn LDAP 服务器的登录用户名，必须是从根结点到用户节点的全路径(非必须);\nbindPassword 登录该 LDAP 服务器的密码(非必须);\nsearchDn 查询用户数据的路径，类似数据库中的一张表的地址，注意这里也必须是全路径;\nsearchStandard 查询条件，这里是 mail 表示查询用户信息是通过邮箱信息来查询的。注意，该字段信息与LDAP数据库存储数据的字段相对应，如果如果存储用户邮箱信息的字段是 email,  这里就需要修改成 email.（1.3.18+支持）自定义filter表达式，基本形式为：&(objectClass=user)(cn=%s), 其中%s会被username替换\nemailPostfix 登陆邮箱后缀（非必须）\nemailKey: ldap数据库存放邮箱信息的字段（v1.3.21 新增 非必须）\nusernameKey: ldap数据库存放用户名信息的字段（v1.3.21 新增 非必须）\n重启服务器后，可以在登录页看到如下画面，说明 ladp 配置成功"
        },
        {
          "title": "禁止注册",
          "url": "/devops/index.html#禁止注册",
          "content": "禁止注册在 config.json 添加 closeRegister:true 配置项,就可以禁止用户注册 yapi 平台，修改完成后，请重启 yapi 服务器。{  \"port\": \"*****\",\n  \"closeRegister\":true\n}\n\n"
        },
        {
          "title": "版本通知",
          "url": "/devops/index.html#版本通知",
          "content": "版本通知（v1.3.19+ 增加）在 config.json 添加 \"versionNotify\": true 配置项，就可以开启版本通知功能，默认为 false，修改完成后，请重启 yapi 服务器。{  \"port\": \"******\",\n  \"adminAccount\": \"*****\",\n  \"versionNotify\": true\n}\n\n"
        },
        {
          "title": "如何配置mongodb集群",
          "url": "/devops/index.html#版本通知-如何配置mongodb集群",
          "content": "如何配置mongodb集群请升级到 yapi >= 1.4.0以上版本，然后在 config.json db项，配置 connectString:{\n  \"port\": \"***\",\n  \"db\": {\n    \"connectString\": \"mongodb://127.0.0.100:8418,127.0.0.101:8418,127.0.0.102:8418/yapidb?slaveOk=true\",\n    \"user\": \"******\",\n    \"pass\": \"******\"\n  },\n}\n\n详细配置参考： wiki"
        }
      ]
    },
    {
      "title": "内网部署",
      "content": "使用我们提供的 yapi-cli 工具，部署 YApi 平台是非常容易的。建议部署成 http 站点，因 chrome 浏览器安全限制，部署成 https 会导致测试功能在请求 http 站点时文件上传功能异常。如果您是将服务器代理到 nginx 服务器，请配置 nginx 支持 websocket。在location /添加proxy_http_version 1.1;\nproxy_set_header Upgrade $http_upgrade;\nproxy_set_header Connection \"upgrade\";\n",
      "url": "/devops/index.html",
      "children": [
        {
          "title": "环境要求",
          "url": "/devops/index.html#环境要求",
          "content": "环境要求nodejs（7.6+)\nmongodb（2.6+）\n"
        },
        {
          "title": "安装",
          "url": "/devops/index.html#安装",
          "content": "安装"
        },
        {
          "title": "方式一. 可视化部署[推荐]",
          "url": "/devops/index.html#安装-方式一.-可视化部署[推荐]",
          "content": "方式一. 可视化部署[推荐]执行 yapi server 启动可视化部署程序，输入相应的配置和点击开始部署，就能完成整个网站的部署。部署完成之后，可按照提示信息，执行 node/{网站路径/server/app.js} 启动服务器。在浏览器打开指定url, 点击登录输入您刚才设置的管理员邮箱，默认密码(ymfe.org) 登录系统（默认密码可在个人中心修改）。npm install -g yapi-cli --registry https://registry.npm.taobao.orgyapi server\n"
        },
        {
          "title": "方式二. 命令行部署",
          "url": "/devops/index.html#安装-方式二.-命令行部署",
          "content": "方式二. 命令行部署如果 github 压缩文件无法下载，或需要部署到一些特殊的服务器，可尝试此方法mkdir yapicd yapi\ngit clone https://github.com/YMFE/yapi.git vendors //或者下载 zip 包解压到 vendors 目录（clone 整个仓库大概 140+ M，可以通过 `git clone --depth=1 https://github.com/YMFE/yapi.git vendors` 命令减少，大概 10+ M）\ncp vendors/config_example.json ./config.json //复制完成后请修改相关配置\ncd vendors\nnpm install --production --registry https://registry.npm.taobao.org\nnpm run install-server //安装程序会初始化数据库索引和管理员账号，管理员账号名可在 config.json 配置\nnode server/app.js //启动服务器后，请访问 127.0.0.1:{config.json配置的端口}，初次运行会有个编译的过程，请耐心等候\n安装后的目录结构如下：|-- config.json|-- init.lock\n|-- log\n`-- vendors\n    |-- CHANGELOG.md\n    |-- LICENSE\n    |-- README.md\n    |-- client\n    |-- common\n    |-- config_example.json\n    |-- doc\n    |-- exts\n    |-- nodemon.json\n    |-- npm-debug.log\n    |-- package.json\n    |-- plugin.json\n    |-- server\n    |-- static\n    |-- test\n    |-- webpack.alias.js\n    |-- yapi-base-flow.jpg\n    |-- ydocfile.js\n    `-- ykit.config.js\n"
        },
        {
          "title": "服务器管理",
          "url": "/devops/index.html#服务器管理",
          "content": "服务器管理推荐使用 pm2 管理 node 服务器启动，停止，具体使用方法可参考下面的教程：官网文档\nPM2实用入门指南\n"
        },
        {
          "title": "升级",
          "url": "/devops/index.html#升级",
          "content": "升级升级项目版本是非常容易的，并且不会影响已有的项目数据，只会同步 vendors 目录下的源码文件。cd  {项目目录}yapi ls //查看版本号列表\nyapi update //升级到最新版本\nyapi update -v v1.1.0 //升级到指定版本\n"
        },
        {
          "title": "配置邮箱",
          "url": "/devops/index.html#配置邮箱",
          "content": "配置邮箱打开项目目录 config.json 文件，新增 mail 配置， 替换默认的邮箱配置{  \"port\": \"*****\",\n  \"adminAccount\": \"********\",\n  \"db\": {...},\n  \"mail\": {\n    \"enable\": true,\n    \"host\": \"smtp.163.com\",    //邮箱服务器\n    \"port\": 465,               //端口\n    \"from\": \"***@163.com\",     //发送人邮箱\n    \"auth\": {\n        \"user\": \"***@163.com\", //邮箱服务器账号\n        \"pass\": \"*****\"        //邮箱服务器密码\n    }\n  }\n}\n如何申请STMP服务器账号和密码可以参考下面的教程：如何开通电子邮箱的SMTP功能"
        },
        {
          "title": "配置LDAP登录",
          "url": "/devops/index.html#配置ldap登录",
          "content": "配置LDAP登录打开项目目录 config.json 文件，添加如下字段：{  \"port\": \"*****\",\n  \"adminAccount\": \"********\",\n  \"db\": {...},\n  \"mail\": {...},\n  \"ldapLogin\": {\n      \"enable\": true,\n      \"server\": \"ldap://l-ldapt1.com\",\n      \"baseDn\": \"CN=Admin,CN=Users,DC=test,DC=com\",\n      \"bindPassword\": \"password123\",\n      \"searchDn\": \"OU=UserContainer,DC=test,DC=com\",\n      \"searchStandard\": \"mail\",    // 自定义格式： \"searchStandard\": \"&(objectClass=user)(cn=%s)\"\n      \"emailPostfix\": \"@163.com\",\n      \"emailKey\": \"mail\",\n      \"usernameKey\": \"name\"\n   }\n}\n\n这里面的配置项含义如下：enable 表示是否配置 LDAP 登录，true(支持 LDAP登录 )/false(不支持LDAP登录);\nserver LDAP 服务器地址，前面需要加上 ldap:// 前缀，也可以是 ldaps:// 表示是通过 SSL 连接;\nbaseDn LDAP 服务器的登录用户名，必须是从根结点到用户节点的全路径(非必须);\nbindPassword 登录该 LDAP 服务器的密码(非必须);\nsearchDn 查询用户数据的路径，类似数据库中的一张表的地址，注意这里也必须是全路径;\nsearchStandard 查询条件，这里是 mail 表示查询用户信息是通过邮箱信息来查询的。注意，该字段信息与LDAP数据库存储数据的字段相对应，如果如果存储用户邮箱信息的字段是 email,  这里就需要修改成 email.（1.3.18+支持）自定义filter表达式，基本形式为：&(objectClass=user)(cn=%s), 其中%s会被username替换\nemailPostfix 登陆邮箱后缀（非必须）\nemailKey: ldap数据库存放邮箱信息的字段（v1.3.21 新增 非必须）\nusernameKey: ldap数据库存放用户名信息的字段（v1.3.21 新增 非必须）\n重启服务器后，可以在登录页看到如下画面，说明 ladp 配置成功"
        },
        {
          "title": "禁止注册",
          "url": "/devops/index.html#禁止注册",
          "content": "禁止注册在 config.json 添加 closeRegister:true 配置项,就可以禁止用户注册 yapi 平台，修改完成后，请重启 yapi 服务器。{  \"port\": \"*****\",\n  \"closeRegister\":true\n}\n\n"
        },
        {
          "title": "版本通知",
          "url": "/devops/index.html#版本通知",
          "content": "版本通知（v1.3.19+ 增加）在 config.json 添加 \"versionNotify\": true 配置项，就可以开启版本通知功能，默认为 false，修改完成后，请重启 yapi 服务器。{  \"port\": \"******\",\n  \"adminAccount\": \"*****\",\n  \"versionNotify\": true\n}\n\n"
        },
        {
          "title": "如何配置mongodb集群",
          "url": "/devops/index.html#版本通知-如何配置mongodb集群",
          "content": "如何配置mongodb集群请升级到 yapi >= 1.4.0以上版本，然后在 config.json db项，配置 connectString:{\n  \"port\": \"***\",\n  \"db\": {\n    \"connectString\": \"mongodb://127.0.0.100:8418,127.0.0.101:8418,127.0.0.102:8418/yapidb?slaveOk=true\",\n    \"user\": \"******\",\n    \"pass\": \"******\"\n  },\n}\n\n详细配置参考： wiki"
        }
      ]
    }
  ]
}