﻿using System;
using System.Collections;
using System.Collections.Generic;

/// Sample source file indicating a wide variety of code elements that should work
/// with the "Open code in ILSpy" Visual Studio add-in feature. Each code element is
/// commented with the string generated by CodeElementXmlDocKeyProvider.GetKey and
/// used with the ILSpy /navigateTo command line option.
///
/// Note that this code is not compiled or used in the project in any way, it is
/// only provided for reference.


// N:ILSpy.AddIn.Tests
namespace ILSpy.AddIn.Tests
{
	// T:ILSpy.AddIn.Tests.SomeClass
	public class SomeClass
	{
		// E:ILSpy.AddIn.Tests.SomeClass.OnEvent
		public event Action OnEvent;

		// F:ILSpy.AddIn.Tests.SomeClass.mField
		private int mField;

		// P:ILSpy.AddIn.Tests.SomeClass.Property
		private int Property
		{
			get
			{
				return mField;
			}
			set
			{
				mField = value;
			}
		}

		// P:ILSpy.AddIn.Tests.SomeClass.Item(System.Int32,System.Int32)
		public int this[int x, int y]
		{
			get { return x + y + mField; }
		}

		// M:ILSpy.AddIn.Tests.SomeClass.#ctor
		public SomeClass()
		{
			mField = 0;
		}

		// M:ILSpy.AddIn.Tests.SomeClass.#ctor(System.Int32)
		public SomeClass(int x)
		{
			mField = x;
		}

		// M:ILSpy.AddIn.Tests.SomeClass.#ctor(System.Int32,System.Int32)
		public SomeClass(int x, int y)
		{
			mField = x + y;
		}

		// M:ILSpy.AddIn.Tests.SomeClass.Method
		public int Method()
		{
			return mField;
		}

		// M:ILSpy.AddIn.Tests.SomeClass.MethodWithGenericParameter(System.IEquatable{System.String})
		public void MethodWithGenericParameter(IEquatable<string> x)
		{

		}

		// M:ILSpy.AddIn.Tests.SomeClass.MethodWithGenericParameter(System.IEquatable{System.String},System.Int32)
		public void MethodWithGenericParameter(IEquatable<string> x, int y)
		{

		}

		// M:ILSpy.AddIn.Tests.SomeClass.GenericMethod``1(``0)
		public int GenericMethod<T>(T x)
		{
			return mField + x.GetHashCode();
		}

		// M:ILSpy.AddIn.Tests.SomeClass.GenericOverloadedMethod``1(System.Int32,``0)
		public int GenericOverloadedMethod<T1>(int x, T1 y)
		{
			return mField + x + y.GetHashCode();
		}

		// M:ILSpy.AddIn.Tests.SomeClass.GenericOverloadedMethod``2(System.Int32,``0,``1)
		public int GenericOverloadedMethod<T1, T2>(int x, T1 y, T2 z)
		{
			return mField + x + y.GetHashCode() + z.GetHashCode();
		}

		// M:ILSpy.AddIn.Tests.SomeClass.OverloadedMethod
		public int OverloadedMethod()
		{
			return mField * mField;
		}

		// M:ILSpy.AddIn.Tests.SomeClass.OverloadedMethod(System.Int32)
		public int OverloadedMethod(int m)
		{
			return mField * m;
		}

		// M:ILSpy.AddIn.Tests.SomeClass.OverloadedMethod(System.Int32,System.Int32)
		public int OverloadedMethod(int m1, int m2)
		{
			return mField * m1 * m2;
		}

		// M:ILSpy.AddIn.Tests.SomeClass.OverloadedGenericMethod``1
		public int OverloadedGenericMethod<T>()
		{
			return mField * mField;
		}

		// M:ILSpy.AddIn.Tests.SomeClass.OverloadedGenericMethod``1(System.Int32)
		public int OverloadedGenericMethod<T>(int m)
		{
			return mField * m;
		}

		// M:ILSpy.AddIn.Tests.SomeClass.OverloadedGenericMethod``1(System.Int32,System.Int32)
		public int OverloadedGenericMethod<T>(int m1, int m2)
		{
			return mField * m1 * m2;
		}

		// M:ILSpy.AddIn.Tests.SomeClass.OverloadedGenericMethod``1(System.Int32,System.Int32,System.Collections.IEnumerable)
		public int OverloadedGenericMethod<T>(int m1, int m2, IEnumerable m3)
		{
			return mField * m1 * m2;
		}

		// M:ILSpy.AddIn.Tests.SomeClass.OverloadedGenericMethod``1(System.Int32,System.Int32,System.Collections.Generic.IEnumerable{``0})
		public int OverloadedGenericMethod<T>(int m1, int m2, IEnumerable<T> m3)
		{
			return mField * m1 * m2;
		}

		// M:ILSpy.AddIn.Tests.SomeClass.OverloadedGenericMethod``1(System.Int32,System.Int32,System.Collections.Generic.IEnumerable{System.String})
		public int OverloadedGenericMethod<T>(int m1, int m2, IEnumerable<string> m3)
		{
			return mField * m1 * m2;
		}

		// M:ILSpy.AddIn.Tests.SomeClass.OverloadedGenericMethod``1(System.Collections.Generic.IEnumerable{System.Collections.Generic.IEnumerable{ILSpy.AddIn.Tests.SomeGenericClass{System.String,``0}}})
		public int OverloadedGenericMethod<T>(IEnumerable<IEnumerable<SomeGenericClass<string, T>>> m3)
		{
			return mField;
		}

		// M:ILSpy.AddIn.Tests.SomeClass.OverloadedGenericMethod``1(ILSpy.AddIn.Tests.SomeGenericClass{``0,ILSpy.AddIn.Tests.SomeGenericClass{``0,``0}}.NestedGeneric{System.String,``0})
		public void OverloadedGenericMethod<T>(SomeGenericClass<T, SomeGenericClass<T, T>>.NestedGeneric<string, T> wow)
		{
		}

		// T:ILSpy.AddIn.Tests.SomeClass.NestedEnum
		public enum NestedEnum
		{
			// F:ILSpy.AddIn.Tests.SomeClass.NestedEnum.First
			First = 1,
			Second = 2,
			Third = 3
		}

		// T:ILSpy.AddIn.Tests.SomeClass.NestedInterface
		public interface NestedInterface
		{
			// P:ILSpy.AddIn.Tests.SomeClass.NestedInterface.SomeProperty
			int SomeProperty { get; }

			// M:ILSpy.AddIn.Tests.SomeClass.NestedInterface.SomeMethod
			int SomeMethod();
		}

		// T:ILSpy.AddIn.Tests.SomeClass.NestedClass
		public class NestedClass : NestedInterface
		{
			// F:ILSpy.AddIn.Tests.SomeClass.NestedClass.mX
			private int mX;

			// M:ILSpy.AddIn.Tests.SomeClass.NestedClass.#ctor(System.Int32)
			public NestedClass(int x)
			{
				mX = x;
			}

			// M:ILSpy.AddIn.Tests.SomeClass.NestedClass.#ctor(ILSpy.AddIn.Tests.SomeClass.NestedEnum)
			public NestedClass(NestedEnum x)
			{
				mX = (int)x;
			}

			// P:ILSpy.AddIn.Tests.SomeClass.NestedClass.SomeProperty
			public int SomeProperty
			{
				get { return mX; }
			}

			// M:ILSpy.AddIn.Tests.SomeClass.NestedClass.SomeMethod
			public int SomeMethod()
			{
				return mX * mX;
			}
		}

		// T:ILSpy.AddIn.Tests.SomeClass.NestedStruct
		public struct NestedStruct : NestedInterface
		{
			// F:ILSpy.AddIn.Tests.SomeClass.NestedStruct.X
			public int X;
			// F:ILSpy.AddIn.Tests.SomeClass.NestedStruct.Y
			public int Y;

			// P:ILSpy.AddIn.Tests.SomeClass.NestedStruct.SomeProperty
			public int SomeProperty
			{
				get { return X + Y; }
			}

			// M:ILSpy.AddIn.Tests.SomeClass.NestedStruct.SomeMethod
			public int SomeMethod()
			{
				return X * Y;
			}
		}
	}

	// T:ILSpy.AddIn.Tests.SomeGenericClass`2
	public class SomeGenericClass<T1, T2>
	{
		// F:ILSpy.AddIn.Tests.SomeGenericClass`2.mField1
		T1 mField1;
		// F:ILSpy.AddIn.Tests.SomeGenericClass`2.mField2
		T2 mField2;

		// M:ILSpy.AddIn.Tests.SomeGenericClass`2.#ctor(`0,`1)
		public SomeGenericClass(T1 a, T2 b)
		{
			mField1 = a;
			mField2 = b;
		}

		// M:ILSpy.AddIn.Tests.SomeGenericClass`2.#ctor(`0)
		public SomeGenericClass(T1 a)
		{
			mField1 = a;
		}

		// M:ILSpy.AddIn.Tests.SomeGenericClass`2.#ctor
		public SomeGenericClass()
		{
		}

		// M:ILSpy.AddIn.Tests.SomeGenericClass`2.Finalize
		~SomeGenericClass()
		{
		}

		// M:ILSpy.AddIn.Tests.SomeGenericClass`2.GenericClassMethod(`0,`1)
		public void GenericClassMethod(T1 a, T2 b)
		{
			mField1 = a;
			mField2 = b;
		}

		// M:ILSpy.AddIn.Tests.SomeGenericClass`2.GenericClassMethod(System.Int32*)
		unsafe public void GenericClassMethod(int* x)
		{
		}

		// M:ILSpy.AddIn.Tests.SomeGenericClass`2.GenericClassMethod(System.Int32*[])
		unsafe public void GenericClassMethod(int*[] x)
		{
		}

		// M:ILSpy.AddIn.Tests.SomeGenericClass`2.GenericClassMethod(`0[]@)
		unsafe public void GenericClassMethod(out T1[] x)
		{
			x = null;
		}

		// M:ILSpy.AddIn.Tests.SomeGenericClass`2.GenericClassMethod(System.Int32@)
		public void GenericClassMethod(ref int a)
		{
		}

		// M:ILSpy.AddIn.Tests.SomeGenericClass`2.GenericClassGenericMethod``1(``0@)
		public T3 GenericClassGenericMethod<T3>(ref T3 x)
		{
			return x;
		}

		// M:ILSpy.AddIn.Tests.SomeGenericClass`2.GenericClassGenericMethod``1
		public T3 GenericClassGenericMethod<T3>()
		{
			return default(T3);
		}

		// M:ILSpy.AddIn.Tests.SomeGenericClass`2.GenericClassGenericMethod``1(System.Int32)
		public void GenericClassGenericMethod<T3>(int x)
		{
		}

		// M:ILSpy.AddIn.Tests.SomeGenericClass`2.GenericClassGenericMethod``2(`0,``1,System.Int32,`1@)
		public T4 GenericClassGenericMethod<T3, T4>(T1 x, T4 y, int z, out T2 result)
		{
			mField1 = x;
			string foo = y.ToString() + z.ToString();
			result = mField2;
			return y;
		}

		// M:ILSpy.AddIn.Tests.SomeGenericClass`2.GenericClassGenericMethod``2(`0,``0,System.Int32[])
		public T3 GenericClassGenericMethod<T3, T4>(T1 x, T3 y, int[] z)
		{
			mField1 = x;
			string foo = y.ToString() + z.ToString();
			return y;
		}

		// M:ILSpy.AddIn.Tests.SomeGenericClass`2.ArrayMethod(`0[],System.Int32[])
		public void ArrayMethod(T1[] x, int[] y)
		{
		}

		// M:ILSpy.AddIn.Tests.SomeGenericClass`2.ArrayMethod(`0[0:,0:],System.Int32[0:,0:])
		public void ArrayMethod(T1[,] x, int[,] y)
		{
		}

		// M:ILSpy.AddIn.Tests.SomeGenericClass`2.ArrayMethod(System.Int32[0:,0:],System.Int32[0:,0:])
		public void ArrayMethod(int[,] x, int[,] y)
		{
		}

		// M:ILSpy.AddIn.Tests.SomeGenericClass`2.ArrayMethod(`0[][],System.Int32[][])
		public void ArrayMethod(T1[][] x, int[][] y)
		{
		}

		// M:ILSpy.AddIn.Tests.SomeGenericClass`2.GenericClassGenericMethod``2(`0,``0,ILSpy.AddIn.Tests.SomeClass)
		public T3 GenericClassGenericMethod<T3, T4>(T1 x, T3 y, SomeClass z)
		{
			return y;
		}

		// M:ILSpy.AddIn.Tests.SomeGenericClass`2.GenericClassGenericMethod``2(`0,``0,ILSpy.AddIn.Tests.SomeClass[]@)
		public T3 GenericClassGenericMethod<T3, T4>(T1 x, T3 y, out SomeClass[] z)
		{
			z = null;
			return y;
		}

		// M:ILSpy.AddIn.Tests.SomeGenericClass`2.GenericClassGenericMethod``2(System.Int32[],ILSpy.AddIn.Tests.SomeGenericClass{``0[],``1[0:,0:,0:]}[0:,0:,0:])
		public void GenericClassGenericMethod<T3, T4>(int[] x, SomeGenericClass<T3[], T4[,,]>[,,] y)
		{
		}

		// M:ILSpy.AddIn.Tests.SomeGenericClass`2.op_Addition(ILSpy.AddIn.Tests.SomeGenericClass{`0,`1},ILSpy.AddIn.Tests.SomeGenericClass{`0,`1})
		public static SomeGenericClass<T1, T2> operator +(SomeGenericClass<T1, T2> a, SomeGenericClass<T1, T2> b)
		{
			return new SomeGenericClass<T1, T2>();
		}

		// M:ILSpy.AddIn.Tests.SomeGenericClass`2.op_Explicit(ILSpy.AddIn.Tests.SomeGenericClass{`0,`1})~ILSpy.AddIn.Tests.SomeGenericClass`2.NestedGeneric`2
		public static explicit operator NestedGeneric<T1, T2>(SomeGenericClass<T1, T2> sgc)
		{
			return new NestedGeneric<T1, T2>();
		}

		// M:ILSpy.AddIn.Tests.SomeGenericClass`2.op_Implicit(ILSpy.AddIn.Tests.SomeGenericClass{`0,`1})~ILSpy.AddIn.Tests.SomeGenericClass`2.NestedGeneric`2
		public static implicit operator NestedGeneric<T2, T1>(SomeGenericClass<T1, T2> sgc)
		{
			return new NestedGeneric<T2, T1>();
		}

		// T:ILSpy.AddIn.Tests.SomeGenericClass`2.NestedGeneric`2
		public class NestedGeneric<T3, T4>
		{
			// T:ILSpy.AddIn.Tests.SomeGenericClass`2.NestedGeneric`2.NestedDelegate
			public delegate int NestedDelegate(T3 x, IEnumerable<T4> y);

			// M:ILSpy.AddIn.Tests.SomeGenericClass`2.NestedGeneric`2.NestedGenericMethod``1(`0,``0)
			public void NestedGenericMethod<T5>(T1 x, T5 y)
			{
			}

			// M:ILSpy.AddIn.Tests.SomeGenericClass`2.NestedGeneric`2.NestedGenericMethod``3(`0,`3,``0[],System.Collections.Generic.IEnumerable{``2})
			public void NestedGenericMethod<T5, T6, T7>(T1 x, T4 y, T5[] z, IEnumerable<T7> w)
			{
			}
		}
	}
}

// T:SpaceFreeClass
class SpaceFreeClass
{
	// F:SpaceFreeClass.mField
	int mField;

	// M:SpaceFreeClass.Method
	private void Method()
	{
	}
}
