// Copyright (c) Cristian Civera (cristian@aspitalia.com)
// This code is distributed under the MS-PL (for details please see \doc\MS-PL.txt)

using System;
using System.Collections;
using System.Collections.Generic;

namespace Ricciolo.StylesExplorer.MarkupReflection
{
	public class KnownInfo
	{
		internal TypeDeclaration[] KnownTypeTable = null;
		internal PropertyDeclaration[] KnownPropertyTable = null;
		internal static String[] KnownAssemblyTable = null;
		internal Dictionary<int, ResourceName> KnownResourceTable = new Dictionary<int, ResourceName>();

		#region Initialize

		static KnownInfo()
		{
			KnownAssemblyTable = new string[5];
			KnownAssemblyTable[0] =
				"PresentationFramework, Version=3.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35";
			KnownAssemblyTable[1] =
				"PresentationCore, Version=3.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35";
			KnownAssemblyTable[2] = "mscorlib, Version=2.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089";
			KnownAssemblyTable[3] = "System, Version=2.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089";
			KnownAssemblyTable[4] = "WindowBase, Version=3.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35";
		}

		public KnownInfo() : this(null)
		{
		}

		public KnownInfo(ITypeResolver resolver)
		{
			switch (resolver.RuntimeVersion) {
				case "Net_2_0":
					LoadKnownAssemblies30();
					break;
				case "Net_4_0":
					LoadKnownAssemblies40();
					break;
				default:
					throw new NotSupportedException();
			}

			KnownTypeTable = new TypeDeclaration[760];
			KnownTypeTable[0] = new TypeDeclaration(resolver, string.Empty, string.Empty, 0);
			KnownTypeTable[1] = new TypeDeclaration(resolver, "AccessText", "System.Windows.Controls", 0);
			KnownTypeTable[2] = new TypeDeclaration(resolver, "AdornedElementPlaceholder", "System.Windows.Controls", 0);
			KnownTypeTable[3] = new TypeDeclaration(resolver, "Adorner", "System.Windows.Documents", 0);
			KnownTypeTable[4] = new TypeDeclaration(resolver, "AdornerDecorator", "System.Windows.Documents", 0);
			KnownTypeTable[5] = new TypeDeclaration(resolver, "AdornerLayer", "System.Windows.Documents", 0);
			KnownTypeTable[6] = new TypeDeclaration(resolver, "AffineTransform3D", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[7] = new TypeDeclaration(resolver, "AmbientLight", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[8] = new TypeDeclaration(resolver, "AnchoredBlock", "System.Windows.Documents", 0);
			KnownTypeTable[9] = new TypeDeclaration(resolver, "Animatable", "System.Windows.Media.Animaton", 1);
			KnownTypeTable[10] = new TypeDeclaration(resolver, "AnimationClock", "System.Windows.Media.Animation", 1);
			KnownTypeTable[11] = new TypeDeclaration(resolver, "AnimationTimeline", "System.Windows.Media.Animation", 1);
			KnownTypeTable[12] = new TypeDeclaration(resolver, "Application", "System.Windows", 0);
			KnownTypeTable[13] = new TypeDeclaration(resolver, "ArcSegment", "System.Windows.Media", 1);
			KnownTypeTable[14] = new TypeDeclaration(resolver, "ArrayExtension", "System.Windows.Markup", 0);
			KnownTypeTable[15] = new TypeDeclaration(resolver, "AxisAngleRotation3D", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x10] = new TypeDeclaration(resolver, "BaseIListConverter", "System.Windows.Media.Converters", 1);
			KnownTypeTable[0x11] = new TypeDeclaration(resolver, "BeginStoryboard", "System.Windows.Media.Animation", 0);
			KnownTypeTable[0x12] = new TypeDeclaration(resolver, "BevelBitmapEffect", "System.Windows.Media.Effects", 1);
			KnownTypeTable[0x13] = new TypeDeclaration(resolver, "BezierSegment", "System.Windows.Media", 1);
			KnownTypeTable[20] = new TypeDeclaration(resolver, "Binding", "System.Windows.Data", 0, true);
			KnownTypeTable[0x15] = new TypeDeclaration(resolver, "BindingBase", "System.Windows.Data", 0);
			KnownTypeTable[0x16] = new TypeDeclaration(resolver, "BindingExpression", "System.Windows.Data", 0);
			KnownTypeTable[0x17] = new TypeDeclaration(resolver, "BindingExpressionBase", "System.Windows.Data", 0);
			KnownTypeTable[0x18] = new TypeDeclaration(resolver, "BindingListCollectionView", "System.Windows.Data", 0);
			KnownTypeTable[0x19] = new TypeDeclaration(resolver, "BitmapDecoder", "System.Windows.Media.Imaging", 1);
			KnownTypeTable[0x1a] = new TypeDeclaration(resolver, "BitmapEffect", "System.Windows.Media.Effects", 1);
			KnownTypeTable[0x1b] = new TypeDeclaration(resolver, "BitmapEffectCollection", "System.Windows.Media.Effects", 1);
			KnownTypeTable[0x1c] = new TypeDeclaration(resolver, "BitmapEffectGroup", "System.Windows.Media.Effects", 1);
			KnownTypeTable[0x1d] = new TypeDeclaration(resolver, "BitmapEffectInput", "System.Windows.Media.Effects", 1);
			KnownTypeTable[30] = new TypeDeclaration(resolver, "BitmapEncoder", "System.Windows.Media.Imaging", 1);
			KnownTypeTable[0x1f] = new TypeDeclaration(resolver, "BitmapFrame", "System.Windows.Media.Imaging", 1);
			KnownTypeTable[0x20] = new TypeDeclaration(resolver, "BitmapImage", "System.Windows.Media.Imaging", 1);
			KnownTypeTable[0x21] = new TypeDeclaration(resolver, "BitmapMetadata", "System.Windows.Media.Imaging", 1);
			KnownTypeTable[0x22] = new TypeDeclaration(resolver, "BitmapPalette", "System.Windows.Media.Imaging", 1);
			KnownTypeTable[0x23] = new TypeDeclaration(resolver, "BitmapSource", "System.Windows.Media.Imaging", 1);
			KnownTypeTable[0x24] = new TypeDeclaration(resolver, "Block", "System.Windows.Documents", 0);
			KnownTypeTable[0x25] = new TypeDeclaration(resolver, "BlockUIContainer", "System.Windows.Documents", 0);
			KnownTypeTable[0x26] = new TypeDeclaration(resolver, "BlurBitmapEffect", "System.Windows.Media.Effects", 1);
			KnownTypeTable[0x27] = new TypeDeclaration(resolver, "BmpBitmapDecoder", "System.Windows.Media.Imaging", 1);
			KnownTypeTable[40] = new TypeDeclaration(resolver, "BmpBitmapEncoder", "System.Windows.Media.Imaging", 1);
			KnownTypeTable[0x29] = new TypeDeclaration(resolver, "Bold", "System.Windows.Documents", 0);
			KnownTypeTable[0x2b] = new TypeDeclaration(resolver, "Boolean", "System", 2);
			KnownTypeTable[0x2c] = new TypeDeclaration(resolver, "BooleanAnimationBase", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x2d] = new TypeDeclaration(resolver, "BooleanAnimationUsingKeyFrames", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x2e] = new TypeDeclaration(resolver, "BooleanConverter", "System.ComponentModel", 3);
			KnownTypeTable[0x2f] = new TypeDeclaration(resolver, "BooleanKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x30] = new TypeDeclaration(resolver, "BooleanKeyFrameCollection", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x31] = new TypeDeclaration(resolver, "BooleanToVisibilityConverter", "System.Windows.Controls", 0);
			KnownTypeTable[0x2a] = new TypeDeclaration(resolver, "BoolIListConverter", "System.Windows.Media.Converters", 1);
			KnownTypeTable[50] = new TypeDeclaration(resolver, "Border", "System.Windows.Controls", 0);
			KnownTypeTable[0x33] = new TypeDeclaration(resolver, "BorderGapMaskConverter", "System.Windows.Controls", 0);
			KnownTypeTable[0x34] = new TypeDeclaration(resolver, "Brush", "System.Windows.Media", 1);
			KnownTypeTable[0x35] = new TypeDeclaration(resolver, "BrushConverter", "System.Windows.Media", 1);
			KnownTypeTable[0x36] = new TypeDeclaration(resolver, "BulletDecorator", "System.Windows.Controls.Primitives", 0);
			KnownTypeTable[0x37] = new TypeDeclaration(resolver, "Button", "System.Windows.Controls", 0);
			KnownTypeTable[0x38] = new TypeDeclaration(resolver, "ButtonBase", "System.Windows.Controls.Primitives", 0);
			KnownTypeTable[0x39] = new TypeDeclaration(resolver, "Byte", "System", 2);
			KnownTypeTable[0x3a] = new TypeDeclaration(resolver, "ByteAnimation", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x3b] = new TypeDeclaration(resolver, "ByteAnimationBase", "System.Windows.Media.Animation", 1);
			KnownTypeTable[60] = new TypeDeclaration(resolver, "ByteAnimationUsingKeyFrames", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x3d] = new TypeDeclaration(resolver, "ByteConverter", "System.ComponentModel", 3);
			KnownTypeTable[0x3e] = new TypeDeclaration(resolver, "ByteKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x3f] = new TypeDeclaration(resolver, "ByteKeyFrameCollection", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x40] = new TypeDeclaration(resolver, "CachedBitmap", "System.Windows.Media.Imaging", 1);
			KnownTypeTable[0x41] = new TypeDeclaration(resolver, "Camera", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x42] = new TypeDeclaration(resolver, "Canvas", "System.Windows.Controls", 0);
			KnownTypeTable[0x43] = new TypeDeclaration(resolver, "Char", "System", 2);
			KnownTypeTable[0x44] = new TypeDeclaration(resolver, "CharAnimationBase", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x45] = new TypeDeclaration(resolver, "CharAnimationUsingKeyFrames", "System.Windows.Media.Animation", 1);
			KnownTypeTable[70] = new TypeDeclaration(resolver, "CharConverter", "System.ComponentModel", 3);
			KnownTypeTable[0x47] = new TypeDeclaration(resolver, "CharIListConverter", "System.Windows.Media.Converters", 1);
			KnownTypeTable[0x48] = new TypeDeclaration(resolver, "CharKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x49] = new TypeDeclaration(resolver, "CharKeyFrameCollection", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x4a] = new TypeDeclaration(resolver, "CheckBox", "System.Windows.Controls", 0);
			KnownTypeTable[0x4b] = new TypeDeclaration(resolver, "Clock", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x4c] = new TypeDeclaration(resolver, "ClockController", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x4d] = new TypeDeclaration(resolver, "ClockGroup", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x4e] = new TypeDeclaration(resolver, "CollectionContainer", "System.Windows.Data", 0);
			KnownTypeTable[0x4f] = new TypeDeclaration(resolver, "CollectionView", "System.Windows.Data", 0);
			KnownTypeTable[80] = new TypeDeclaration(resolver, "CollectionViewSource", "System.Windows.Data", 0);
			KnownTypeTable[0x51] = new TypeDeclaration(resolver, "Color", "Win32Native", "Microsoft.Win32", 2);
			KnownTypeTable[0x52] = new TypeDeclaration(resolver, "ColorAnimation", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x53] = new TypeDeclaration(resolver, "ColorAnimationBase", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x54] = new TypeDeclaration(resolver, "ColorAnimationUsingKeyFrames", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x55] = new TypeDeclaration(resolver, "ColorConvertedBitmap", "System.Windows.Media.Imaging", 1);
			KnownTypeTable[0x56] = new TypeDeclaration(resolver, "ColorConvertedBitmapExtension", "System.Windows", 0);
			KnownTypeTable[0x57] = new TypeDeclaration(resolver, "ColorConverter", "System.Windows.Media", 1);
			KnownTypeTable[0x58] = new TypeDeclaration(resolver, "ColorKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x59] = new TypeDeclaration(resolver, "ColorKeyFrameCollection", "System.Windows.Media.Animation", 1);
			KnownTypeTable[90] = new TypeDeclaration(resolver, "ColumnDefinition", "System.Windows.Controls", 0);
			KnownTypeTable[0x5b] = new TypeDeclaration(resolver, "CombinedGeometry", "System.Windows.Media", 1);
			KnownTypeTable[0x5c] = new TypeDeclaration(resolver, "ComboBox", "System.Windows.Controls", 0);
			KnownTypeTable[0x5d] = new TypeDeclaration(resolver, "ComboBoxItem", "System.Windows.Controls", 0);
			KnownTypeTable[0x5e] = new TypeDeclaration(resolver, "CommandConverter", "System.Windows.Input", 0);
			KnownTypeTable[0x5f] = new TypeDeclaration(resolver, "ComponentResourceKey", "System.Windows", 0, true);
			KnownTypeTable[0x60] = new TypeDeclaration(resolver, "ComponentResourceKeyConverter", "System.Windows.Markup", 0);
			KnownTypeTable[0x61] = new TypeDeclaration(resolver, "CompositionTarget", "System.Windows.Media", 1);
			KnownTypeTable[0x62] = new TypeDeclaration(resolver, "Condition", "System.Windows", 0);
			KnownTypeTable[0x63] = new TypeDeclaration(resolver, "ContainerVisual", "System.Windows.Media", 1);
			KnownTypeTable[100] = new TypeDeclaration(resolver, "ContentControl", "System.Windows.Controls", 0);
			KnownTypeTable[0x65] = new TypeDeclaration(resolver, "ContentElement", "System.Windows", 1);
			KnownTypeTable[0x66] = new TypeDeclaration(resolver, "ContentPresenter", "System.Windows.Controls", 0);
			KnownTypeTable[0x67] = new TypeDeclaration(resolver, "ContentPropertyAttribute", "System.Windows.Markup", 4);
			KnownTypeTable[0x68] = new TypeDeclaration(resolver, "ContentWrapperAttribute", "System.Windows.Markup", 4);
			KnownTypeTable[0x69] = new TypeDeclaration(resolver, "ContextMenu", "System.Windows.Controls", 0);
			KnownTypeTable[0x6a] = new TypeDeclaration(resolver, "ContextMenuService", "System.Windows.Controls", 0);
			KnownTypeTable[0x6b] = new TypeDeclaration(resolver, "Control", "System.Windows.Controls", 0);
			KnownTypeTable[0x6d] = new TypeDeclaration(resolver, "ControllableStoryboardAction", "System.Windows.Media.Animation", 0);
			KnownTypeTable[0x6c] = new TypeDeclaration(resolver, "ControlTemplate", "System.Windows.Controls", 0);
			KnownTypeTable[110] = new TypeDeclaration(resolver, "CornerRadius", "System.Windows", 0);
			KnownTypeTable[0x6f] = new TypeDeclaration(resolver, "CornerRadiusConverter", "System.Windows", 0);
			KnownTypeTable[0x70] = new TypeDeclaration(resolver, "CroppedBitmap", "System.Windows.Media.Imaging", 1);
			KnownTypeTable[0x71] = new TypeDeclaration(resolver, "CultureInfo", "System.Globalization", 2);
			KnownTypeTable[0x72] = new TypeDeclaration(resolver, "CultureInfoConverter", "System.ComponentModel", 3);
			KnownTypeTable[0x73] = new TypeDeclaration(resolver, "CultureInfoIetfLanguageTagConverter", "System.Windows", 1);
			KnownTypeTable[0x74] = new TypeDeclaration(resolver, "Cursor", "System.Windows.Input", 1);
			KnownTypeTable[0x75] = new TypeDeclaration(resolver, "CursorConverter", "System.Windows.Input", 1);
			KnownTypeTable[0x76] = new TypeDeclaration(resolver, "DashStyle", "System.Windows.Media", 1);
			KnownTypeTable[0x77] = new TypeDeclaration(resolver, "DataChangedEventManager", "System.Windows.Data", 0);
			KnownTypeTable[120] = new TypeDeclaration(resolver, "DataTemplate", "System.Windows", 0);
			KnownTypeTable[0x79] = new TypeDeclaration(resolver, "DataTemplateKey", "System.Windows", 0, true);
			KnownTypeTable[0x7a] = new TypeDeclaration(resolver, "DataTrigger", "System.Windows", 0);
			KnownTypeTable[0x7b] = new TypeDeclaration(resolver, "DateTime", "System", 2);
			KnownTypeTable[0x7c] = new TypeDeclaration(resolver, "DateTimeConverter", "System.ComponentModel", 3);
			KnownTypeTable[0x7d] = new TypeDeclaration(resolver, "DateTimeConverter2", "System.Windows.Markup", 4);
			KnownTypeTable[0x7e] = new TypeDeclaration(resolver, "Decimal", "System", 2);
			KnownTypeTable[0x7f] = new TypeDeclaration(resolver, "DecimalAnimation", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x80] = new TypeDeclaration(resolver, "DecimalAnimationBase", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x81] = new TypeDeclaration(resolver, "DecimalAnimationUsingKeyFrames", "System.Windows.Media.Animation", 1);
			KnownTypeTable[130] = new TypeDeclaration(resolver, "DecimalConverter", "System.ComponentModel", 3);
			KnownTypeTable[0x83] = new TypeDeclaration(resolver, "DecimalKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x84] = new TypeDeclaration(resolver, "DecimalKeyFrameCollection", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x85] = new TypeDeclaration(resolver, "Decorator", "System.Windows.Controls", 0);
			KnownTypeTable[0x86] = new TypeDeclaration(resolver, "DefinitionBase", "System.Windows.Controls", 0);
			KnownTypeTable[0x87] = new TypeDeclaration(resolver, "DependencyObject", "System.Windows", 4);
			KnownTypeTable[0x88] = new TypeDeclaration(resolver, "DependencyProperty", "System.Windows", 4);
			KnownTypeTable[0x89] = new TypeDeclaration(resolver, "DependencyPropertyConverter", "System.Windows.Markup", 0);
			KnownTypeTable[0x8a] = new TypeDeclaration(resolver, "DialogResultConverter", "System.Windows", 0);
			KnownTypeTable[0x8b] = new TypeDeclaration(resolver, "DiffuseMaterial", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[140] = new TypeDeclaration(resolver, "DirectionalLight", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x8d] = new TypeDeclaration(resolver, "DiscreteBooleanKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x8e] = new TypeDeclaration(resolver, "DiscreteByteKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x8f] = new TypeDeclaration(resolver, "DiscreteCharKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x90] = new TypeDeclaration(resolver, "DiscreteColorKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x91] = new TypeDeclaration(resolver, "DiscreteDecimalKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x92] = new TypeDeclaration(resolver, "DiscreteDoubleKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x93] = new TypeDeclaration(resolver, "DiscreteInt16KeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x94] = new TypeDeclaration(resolver, "DiscreteInt32KeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x95] = new TypeDeclaration(resolver, "DiscreteInt64KeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[150] = new TypeDeclaration(resolver, "DiscreteMatrixKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x97] = new TypeDeclaration(resolver, "DiscreteObjectKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x98] = new TypeDeclaration(resolver, "DiscretePoint3DKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x99] = new TypeDeclaration(resolver, "DiscretePointKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x9a] = new TypeDeclaration(resolver, "DiscreteQuaternionKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x9b] = new TypeDeclaration(resolver, "DiscreteRectKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x9c] = new TypeDeclaration(resolver, "DiscreteRotation3DKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x9d] = new TypeDeclaration(resolver, "DiscreteSingleKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x9e] = new TypeDeclaration(resolver, "DiscreteSizeKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x9f] = new TypeDeclaration(resolver, "DiscreteStringKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[160] = new TypeDeclaration(resolver, "DiscreteThicknessKeyFrame", "System.Windows.Media.Animation", 0);
			KnownTypeTable[0xa1] = new TypeDeclaration(resolver, "DiscreteVector3DKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0xa2] = new TypeDeclaration(resolver, "DiscreteVectorKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0xa3] = new TypeDeclaration(resolver, "DockPanel", "System.Windows.Controls", 0);
			KnownTypeTable[0xa4] = new TypeDeclaration(resolver, "DocumentPageView", "System.Windows.Controls.Primitives", 0);
			KnownTypeTable[0xa5] = new TypeDeclaration(resolver, "DocumentReference", "System.Windows.Documents", 0);
			KnownTypeTable[0xa6] = new TypeDeclaration(resolver, "DocumentViewer", "System.Windows.Controls", 0);
			KnownTypeTable[0xa7] = new TypeDeclaration(resolver, "DocumentViewerBase", "System.Windows.Controls.Primitives", 0);
			KnownTypeTable[0xa8] = new TypeDeclaration(resolver, "Double", "System", 2);
			KnownTypeTable[0xa9] = new TypeDeclaration(resolver, "DoubleAnimation", "System.Windows.Media.Animation", 1);
			KnownTypeTable[170] = new TypeDeclaration(resolver, "DoubleAnimationBase", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0xab] = new TypeDeclaration(resolver, "DoubleAnimationUsingKeyFrames", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0xac] = new TypeDeclaration(resolver, "DoubleAnimationUsingPath", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0xad] = new TypeDeclaration(resolver, "DoubleCollection", "System.Windows.Media", 1);
			KnownTypeTable[0xae] = new TypeDeclaration(resolver, "DoubleCollectionConverter", "System.Windows.Media", 1);
			KnownTypeTable[0xaf] = new TypeDeclaration(resolver, "DoubleConverter", "System.ComponentModel", 3);
			KnownTypeTable[0xb0] = new TypeDeclaration(resolver, "DoubleIListConverter", "System.Windows.Media.Converters", 1);
			KnownTypeTable[0xb1] = new TypeDeclaration(resolver, "DoubleKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0xb2] = new TypeDeclaration(resolver, "DoubleKeyFrameCollection", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0xb3] = new TypeDeclaration(resolver, "Drawing", "System.Windows.Media", 1);
			KnownTypeTable[180] = new TypeDeclaration(resolver, "DrawingBrush", "System.Windows.Media", 1);
			KnownTypeTable[0xb5] = new TypeDeclaration(resolver, "DrawingCollection", "System.Windows.Media", 1);
			KnownTypeTable[0xb6] = new TypeDeclaration(resolver, "DrawingContext", "System.Windows.Media", 1);
			KnownTypeTable[0xb7] = new TypeDeclaration(resolver, "DrawingGroup", "System.Windows.Media", 1);
			KnownTypeTable[0xb8] = new TypeDeclaration(resolver, "DrawingImage", "System.Windows.Media", 1);
			KnownTypeTable[0xb9] = new TypeDeclaration(resolver, "DrawingVisual", "System.Windows.Media", 1);
			KnownTypeTable[0xba] = new TypeDeclaration(resolver, "DropShadowBitmapEffect", "System.Windows.Media.Effects", 1);
			KnownTypeTable[0xbb] = new TypeDeclaration(resolver, "Duration", "System.Windows", 1);
			KnownTypeTable[0xbc] = new TypeDeclaration(resolver, "DurationConverter", "System.Windows", 1);
			KnownTypeTable[0xbd] = new TypeDeclaration(resolver, "DynamicResourceExtension", "System.Windows", 0, true);
			KnownTypeTable[190] = new TypeDeclaration(resolver, "DynamicResourceExtensionConverter", "System.Windows", 0);
			KnownTypeTable[0xbf] = new TypeDeclaration(resolver, "Ellipse", "System.Windows.Shapes", 0);
			KnownTypeTable[0xc0] = new TypeDeclaration(resolver, "EllipseGeometry", "System.Windows.Media", 1);
			KnownTypeTable[0xc1] = new TypeDeclaration(resolver, "EmbossBitmapEffect", "System.Windows.Media.Effects", 1);
			KnownTypeTable[0xc2] = new TypeDeclaration(resolver, "EmissiveMaterial", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0xc3] = new TypeDeclaration(resolver, "EnumConverter", "System.ComponentModel", 3);
			KnownTypeTable[0xc4] = new TypeDeclaration(resolver, "EventManager", "System.Windows", 1);
			KnownTypeTable[0xc5] = new TypeDeclaration(resolver, "EventSetter", "System.Windows", 0);
			KnownTypeTable[0xc6] = new TypeDeclaration(resolver, "EventTrigger", "System.Windows", 0);
			KnownTypeTable[0xc7] = new TypeDeclaration(resolver, "Expander", "System.Windows.Controls", 0);
			KnownTypeTable[200] = new TypeDeclaration(resolver, "Expression", "System.Windows", 4);
			KnownTypeTable[0xc9] = new TypeDeclaration(resolver, "ExpressionConverter", "System.Windows", 4);
			KnownTypeTable[0xca] = new TypeDeclaration(resolver, "Figure", "System.Windows.Documents", 0);
			KnownTypeTable[0xcb] = new TypeDeclaration(resolver, "FigureLength", "System.Windows", 0);
			KnownTypeTable[0xcc] = new TypeDeclaration(resolver, "FigureLengthConverter", "System.Windows", 0);
			KnownTypeTable[0xcd] = new TypeDeclaration(resolver, "FixedDocument", "System.Windows.Documents", 0);
			KnownTypeTable[0xce] = new TypeDeclaration(resolver, "FixedDocumentSequence", "System.Windows.Documents", 0);
			KnownTypeTable[0xcf] = new TypeDeclaration(resolver, "FixedPage", "System.Windows.Documents", 0);
			KnownTypeTable[0xd0] = new TypeDeclaration(resolver, "Floater", "System.Windows.Documents", 0);
			KnownTypeTable[0xd1] = new TypeDeclaration(resolver, "FlowDocument", "System.Windows.Documents", 0);
			KnownTypeTable[210] = new TypeDeclaration(resolver, "FlowDocumentPageViewer", "System.Windows.Controls", 0);
			KnownTypeTable[0xd3] = new TypeDeclaration(resolver, "FlowDocumentReader", "System.Windows.Controls", 0);
			KnownTypeTable[0xd4] = new TypeDeclaration(resolver, "FlowDocumentScrollViewer", "System.Windows.Controls", 0);
			KnownTypeTable[0xd5] = new TypeDeclaration(resolver, "FocusManager", "System.Windows.Input", 1);
			KnownTypeTable[0xd6] = new TypeDeclaration(resolver, "FontFamily", "System.Windows.Media", 1);
			KnownTypeTable[0xd7] = new TypeDeclaration(resolver, "FontFamilyConverter", "System.Windows.Media", 1);
			KnownTypeTable[0xd8] = new TypeDeclaration(resolver, "FontSizeConverter", "System.Windows", 0);
			KnownTypeTable[0xd9] = new TypeDeclaration(resolver, "FontStretch", "System.Windows", 1);
			KnownTypeTable[0xda] = new TypeDeclaration(resolver, "FontStretchConverter", "System.Windows", 1);
			KnownTypeTable[0xdb] = new TypeDeclaration(resolver, "FontStyle", "System.Windows", 1);
			KnownTypeTable[220] = new TypeDeclaration(resolver, "FontStyleConverter", "System.Windows", 1);
			KnownTypeTable[0xdd] = new TypeDeclaration(resolver, "FontWeight", "System.Windows", 1);
			KnownTypeTable[0xde] = new TypeDeclaration(resolver, "FontWeightConverter", "System.Windows", 1);
			KnownTypeTable[0xdf] = new TypeDeclaration(resolver, "FormatConvertedBitmap", "System.Windows.Media.Imaging", 1);
			KnownTypeTable[0xe0] = new TypeDeclaration(resolver, "Frame", "System.Windows.Controls", 0);
			KnownTypeTable[0xe1] = new TypeDeclaration(resolver, "FrameworkContentElement", "System.Windows", 0);
			KnownTypeTable[0xe2] = new TypeDeclaration(resolver, "FrameworkElement", "System.Windows", 0);
			KnownTypeTable[0xe3] = new TypeDeclaration(resolver, "FrameworkElementFactory", "System.Windows", 0);
			KnownTypeTable[0xe4] = new TypeDeclaration(resolver, "FrameworkPropertyMetadata", "System.Windows", 0);
			KnownTypeTable[0xe5] = new TypeDeclaration(resolver, "FrameworkPropertyMetadataOptions", "System.Windows", 0);
			KnownTypeTable[230] = new TypeDeclaration(resolver, "FrameworkRichTextComposition", "System.Windows.Documents", 0);
			KnownTypeTable[0xe7] = new TypeDeclaration(resolver, "FrameworkTemplate", "System.Windows", 0);
			KnownTypeTable[0xe8] = new TypeDeclaration(resolver, "FrameworkTextComposition", "System.Windows.Documents", 0);
			KnownTypeTable[0xe9] = new TypeDeclaration(resolver, "Freezable", "System.Windows", 4);
			KnownTypeTable[0xea] = new TypeDeclaration(resolver, "GeneralTransform", "System.Windows.Media", 1);
			KnownTypeTable[0xeb] = new TypeDeclaration(resolver, "GeneralTransformCollection", "System.Windows.Media", 1);
			KnownTypeTable[0xec] = new TypeDeclaration(resolver, "GeneralTransformGroup", "System.Windows.Media", 1);
			KnownTypeTable[0xed] = new TypeDeclaration(resolver, "Geometry", "System.Windows.Media", 1);
			KnownTypeTable[0xee] = new TypeDeclaration(resolver, "Geometry3D", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0xef] = new TypeDeclaration(resolver, "GeometryCollection", "System.Windows.Media", 1);
			KnownTypeTable[240] = new TypeDeclaration(resolver, "GeometryConverter", "System.Windows.Media", 1);
			KnownTypeTable[0xf1] = new TypeDeclaration(resolver, "GeometryDrawing", "System.Windows.Media", 1);
			KnownTypeTable[0xf2] = new TypeDeclaration(resolver, "GeometryGroup", "System.Windows.Media", 1);
			KnownTypeTable[0xf3] = new TypeDeclaration(resolver, "GeometryModel3D", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0xf4] = new TypeDeclaration(resolver, "GestureRecognizer", "System.Windows.Ink", 1);
			KnownTypeTable[0xf5] = new TypeDeclaration(resolver, "GifBitmapDecoder", "System.Windows.Media.Imaging", 1);
			KnownTypeTable[0xf6] = new TypeDeclaration(resolver, "GifBitmapEncoder", "System.Windows.Media.Imaging", 1);
			KnownTypeTable[0xf7] = new TypeDeclaration(resolver, "GlyphRun", "System.Windows.Media", 1);
			KnownTypeTable[0xf8] = new TypeDeclaration(resolver, "GlyphRunDrawing", "System.Windows.Media", 1);
			KnownTypeTable[250] = new TypeDeclaration(resolver, "Glyphs", "System.Windows.Documents", 0);
			KnownTypeTable[0xf9] = new TypeDeclaration(resolver, "GlyphTypeface", "System.Windows.Media", 1);
			KnownTypeTable[0xfb] = new TypeDeclaration(resolver, "GradientBrush", "System.Windows.Media", 1);
			KnownTypeTable[0xfc] = new TypeDeclaration(resolver, "GradientStop", "System.Windows.Media", 1);
			KnownTypeTable[0xfd] = new TypeDeclaration(resolver, "GradientStopCollection", "System.Windows.Media", 1);
			KnownTypeTable[0xfe] = new TypeDeclaration(resolver, "Grid", "System.Windows.Controls", 0);
			KnownTypeTable[0xff] = new TypeDeclaration(resolver, "GridLength", "System.Windows", 0);
			KnownTypeTable[0x100] = new TypeDeclaration(resolver, "GridLengthConverter", "System.Windows", 0);
			KnownTypeTable[0x101] = new TypeDeclaration(resolver, "GridSplitter", "System.Windows.Controls", 0);
			KnownTypeTable[0x102] = new TypeDeclaration(resolver, "GridView", "System.Windows.Controls", 0);
			KnownTypeTable[0x103] = new TypeDeclaration(resolver, "GridViewColumn", "System.Windows.Controls", 0);
			KnownTypeTable[260] = new TypeDeclaration(resolver, "GridViewColumnHeader", "System.Windows.Controls", 0);
			KnownTypeTable[0x105] = new TypeDeclaration(resolver, "GridViewHeaderRowPresenter", "System.Windows.Controls", 0);
			KnownTypeTable[0x106] = new TypeDeclaration(resolver, "GridViewRowPresenter", "System.Windows.Controls", 0);
			KnownTypeTable[0x107] = new TypeDeclaration(resolver, "GridViewRowPresenterBase", "System.Windows.Controls.Primitives", 0);
			KnownTypeTable[0x108] = new TypeDeclaration(resolver, "GroupBox", "System.Windows.Controls", 0);
			KnownTypeTable[0x109] = new TypeDeclaration(resolver, "GroupItem", "System.Windows.Controls", 0);
			KnownTypeTable[0x10a] = new TypeDeclaration(resolver, "Guid", "System", 2);
			KnownTypeTable[0x10b] = new TypeDeclaration(resolver, "GuidConverter", "System.ComponentModel", 3);
			KnownTypeTable[0x10c] = new TypeDeclaration(resolver, "GuidelineSet", "System.Windows.Media", 1);
			KnownTypeTable[0x10d] = new TypeDeclaration(resolver, "HeaderedContentControl", "System.Windows.Controls", 0);
			KnownTypeTable[270] = new TypeDeclaration(resolver, "HeaderedItemsControl", "System.Windows.Controls", 0);
			KnownTypeTable[0x10f] = new TypeDeclaration(resolver, "HierarchicalDataTemplate", "System.Windows", 0);
			KnownTypeTable[0x110] = new TypeDeclaration(resolver, "HostVisual", "System.Windows.Media", 1);
			KnownTypeTable[0x111] = new TypeDeclaration(resolver, "Hyperlink", "System.Windows.Documents", 0);
			KnownTypeTable[0x112] = new TypeDeclaration(resolver, "IAddChild", "System.Windows.Markup", 1);
			KnownTypeTable[0x113] = new TypeDeclaration(resolver, "IAddChildInternal", "System.Windows.Markup", 1);
			KnownTypeTable[0x114] = new TypeDeclaration(resolver, "ICommand", "System.Windows.Input", 1);
			KnownTypeTable[0x115] = new TypeDeclaration(resolver, "IComponentConnector", "System.Windows.Markup", 4);
			KnownTypeTable[280] = new TypeDeclaration(resolver, "IconBitmapDecoder", "System.Windows.Media.Imaging", 1);
			KnownTypeTable[0x119] = new TypeDeclaration(resolver, "Image", "System.Windows.Controls", 0);
			KnownTypeTable[0x11a] = new TypeDeclaration(resolver, "ImageBrush", "System.Windows.Media", 1);
			KnownTypeTable[0x11b] = new TypeDeclaration(resolver, "ImageDrawing", "System.Windows.Media", 1);
			KnownTypeTable[0x11c] = new TypeDeclaration(resolver, "ImageMetadata", "System.Windows.Media", 1);
			KnownTypeTable[0x11d] = new TypeDeclaration(resolver, "ImageSource", "System.Windows.Media", 1);
			KnownTypeTable[0x11e] = new TypeDeclaration(resolver, "ImageSourceConverter", "System.Windows.Media", 1);
			KnownTypeTable[0x116] = new TypeDeclaration(resolver, "INameScope", "System.Windows.Markup", 4);
			KnownTypeTable[0x120] = new TypeDeclaration(resolver, "InkCanvas", "System.Windows.Controls", 0);
			KnownTypeTable[0x121] = new TypeDeclaration(resolver, "InkPresenter", "System.Windows.Controls", 0);
			KnownTypeTable[290] = new TypeDeclaration(resolver, "Inline", "System.Windows.Documents", 0);
			KnownTypeTable[0x123] = new TypeDeclaration(resolver, "InlineCollection", "System.Windows.Documents", 0);
			KnownTypeTable[0x124] = new TypeDeclaration(resolver, "InlineUIContainer", "System.Windows.Documents", 0);
			KnownTypeTable[0x11f] = new TypeDeclaration(resolver, "InPlaceBitmapMetadataWriter", "System.Windows.Media.Imaging", 1);
			KnownTypeTable[0x125] = new TypeDeclaration(resolver, "InputBinding", "System.Windows.Input", 1);
			KnownTypeTable[0x126] = new TypeDeclaration(resolver, "InputDevice", "System.Windows.Input", 1);
			KnownTypeTable[0x127] = new TypeDeclaration(resolver, "InputLanguageManager", "System.Windows.Input", 1);
			KnownTypeTable[0x128] = new TypeDeclaration(resolver, "InputManager", "System.Windows.Input", 1);
			KnownTypeTable[0x129] = new TypeDeclaration(resolver, "InputMethod", "System.Windows.Input", 1);
			KnownTypeTable[0x12a] = new TypeDeclaration(resolver, "InputScope", "System.Windows.Input", 1);
			KnownTypeTable[0x12b] = new TypeDeclaration(resolver, "InputScopeConverter", "System.Windows.Input", 1);
			KnownTypeTable[300] = new TypeDeclaration(resolver, "InputScopeName", "System.Windows.Input", 1);
			KnownTypeTable[0x12d] = new TypeDeclaration(resolver, "InputScopeNameConverter", "System.Windows.Input", 1);
			KnownTypeTable[0x12e] = new TypeDeclaration(resolver, "Int16", "System", 2);
			KnownTypeTable[0x12f] = new TypeDeclaration(resolver, "Int16Animation", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x130] = new TypeDeclaration(resolver, "Int16AnimationBase", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x131] = new TypeDeclaration(resolver, "Int16AnimationUsingKeyFrames", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x132] = new TypeDeclaration(resolver, "Int16Converter", "System.ComponentModel", 3);
			KnownTypeTable[0x133] = new TypeDeclaration(resolver, "Int16KeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x134] = new TypeDeclaration(resolver, "Int16KeyFrameCollection", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x135] = new TypeDeclaration(resolver, "Int32", "System", 2);
			KnownTypeTable[310] = new TypeDeclaration(resolver, "Int32Animation", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x137] = new TypeDeclaration(resolver, "Int32AnimationBase", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x138] = new TypeDeclaration(resolver, "Int32AnimationUsingKeyFrames", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x139] = new TypeDeclaration(resolver, "Int32Collection", "System.Windows.Media", 1);
			KnownTypeTable[0x13a] = new TypeDeclaration(resolver, "Int32CollectionConverter", "System.Windows.Media", 1);
			KnownTypeTable[0x13b] = new TypeDeclaration(resolver, "Int32Converter", "System.ComponentModel", 3);
			KnownTypeTable[0x13c] = new TypeDeclaration(resolver, "Int32KeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x13d] = new TypeDeclaration(resolver, "Int32KeyFrameCollection", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x13e] = new TypeDeclaration(resolver, "Int32Rect", "System.Windows", 4);
			KnownTypeTable[0x13f] = new TypeDeclaration(resolver, "Int32RectConverter", "System.Windows", 4);
			KnownTypeTable[320] = new TypeDeclaration(resolver, "Int64", "System", 2);
			KnownTypeTable[0x141] = new TypeDeclaration(resolver, "Int64Animation", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x142] = new TypeDeclaration(resolver, "Int64AnimationBase", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x143] = new TypeDeclaration(resolver, "Int64AnimationUsingKeyFrames", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x144] = new TypeDeclaration(resolver, "Int64Converter", "System.ComponentModel", 3);
			KnownTypeTable[0x145] = new TypeDeclaration(resolver, "Int64KeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x146] = new TypeDeclaration(resolver, "Int64KeyFrameCollection", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x117] = new TypeDeclaration(resolver, "IStyleConnector", "System.Windows.Markup", 0);
			KnownTypeTable[0x147] = new TypeDeclaration(resolver, "Italic", "System.Windows.Documents", 0);
			KnownTypeTable[0x148] = new TypeDeclaration(resolver, "ItemCollection", "System.Windows.Controls", 0);
			KnownTypeTable[0x149] = new TypeDeclaration(resolver, "ItemsControl", "System.Windows.Controls", 0);
			KnownTypeTable[330] = new TypeDeclaration(resolver, "ItemsPanelTemplate", "System.Windows.Controls", 0);
			KnownTypeTable[0x14b] = new TypeDeclaration(resolver, "ItemsPresenter", "System.Windows.Controls", 0);
			KnownTypeTable[0x14c] = new TypeDeclaration(resolver, "JournalEntry", "System.Windows.Navigation", 0);
			KnownTypeTable[0x14d] = new TypeDeclaration(resolver, "JournalEntryListConverter", "System.Windows.Navigation", 0);
			KnownTypeTable[0x14e] = new TypeDeclaration(resolver, "JournalEntryUnifiedViewConverter", "System.Windows.Navigation", 0);
			KnownTypeTable[0x14f] = new TypeDeclaration(resolver, "JpegBitmapDecoder", "System.Windows.Media.Imaging", 1);
			KnownTypeTable[0x150] = new TypeDeclaration(resolver, "JpegBitmapEncoder", "System.Windows.Media.Imaging", 1);
			KnownTypeTable[0x151] = new TypeDeclaration(resolver, "KeyBinding", "System.Windows.Input", 1);
			KnownTypeTable[0x159] = new TypeDeclaration(resolver, "KeyboardDevice", "System.Windows.Input", 1);
			KnownTypeTable[0x152] = new TypeDeclaration(resolver, "KeyConverter", "System.Windows.Input", 4);
			KnownTypeTable[0x153] = new TypeDeclaration(resolver, "KeyGesture", "System.Windows.Input", 1);
			KnownTypeTable[340] = new TypeDeclaration(resolver, "KeyGestureConverter", "System.Windows.Input", 1);
			KnownTypeTable[0x155] = new TypeDeclaration(resolver, "KeySpline", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x156] = new TypeDeclaration(resolver, "KeySplineConverter", "System.Windows", 1);
			KnownTypeTable[0x157] = new TypeDeclaration(resolver, "KeyTime", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x158] = new TypeDeclaration(resolver, "KeyTimeConverter", "System.Windows", 1);
			KnownTypeTable[0x15a] = new TypeDeclaration(resolver, "Label", "System.Windows.Controls", 0);
			KnownTypeTable[0x15b] = new TypeDeclaration(resolver, "LateBoundBitmapDecoder", "System.Windows.Media.Imaging", 1);
			KnownTypeTable[0x15c] = new TypeDeclaration(resolver, "LengthConverter", "System.Windows", 0);
			KnownTypeTable[0x15d] = new TypeDeclaration(resolver, "Light", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[350] = new TypeDeclaration(resolver, "Line", "System.Windows.Shapes", 0);
			KnownTypeTable[0x162] = new TypeDeclaration(resolver, "LinearByteKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x163] = new TypeDeclaration(resolver, "LinearColorKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x164] = new TypeDeclaration(resolver, "LinearDecimalKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x165] = new TypeDeclaration(resolver, "LinearDoubleKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x166] = new TypeDeclaration(resolver, "LinearGradientBrush", "System.Windows.Media", 1);
			KnownTypeTable[0x167] = new TypeDeclaration(resolver, "LinearInt16KeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[360] = new TypeDeclaration(resolver, "LinearInt32KeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x169] = new TypeDeclaration(resolver, "LinearInt64KeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x16a] = new TypeDeclaration(resolver, "LinearPoint3DKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x16b] = new TypeDeclaration(resolver, "LinearPointKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x16c] = new TypeDeclaration(resolver, "LinearQuaternionKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x16d] = new TypeDeclaration(resolver, "LinearRectKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x16e] = new TypeDeclaration(resolver, "LinearRotation3DKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x16f] = new TypeDeclaration(resolver, "LinearSingleKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x170] = new TypeDeclaration(resolver, "LinearSizeKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x171] = new TypeDeclaration(resolver, "LinearThicknessKeyFrame", "System.Windows.Media.Animation", 0);
			KnownTypeTable[370] = new TypeDeclaration(resolver, "LinearVector3DKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x173] = new TypeDeclaration(resolver, "LinearVectorKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x15f] = new TypeDeclaration(resolver, "LineBreak", "System.Windows.Documents", 0);
			KnownTypeTable[0x160] = new TypeDeclaration(resolver, "LineGeometry", "System.Windows.Media", 1);
			KnownTypeTable[0x161] = new TypeDeclaration(resolver, "LineSegment", "System.Windows.Media", 1);
			KnownTypeTable[0x174] = new TypeDeclaration(resolver, "List", "System.Windows.Documents", 0);
			KnownTypeTable[0x175] = new TypeDeclaration(resolver, "ListBox", "System.Windows.Controls", 0);
			KnownTypeTable[0x176] = new TypeDeclaration(resolver, "ListBoxItem", "System.Windows.Controls", 0);
			KnownTypeTable[0x177] = new TypeDeclaration(resolver, "ListCollectionView", "System.Windows.Data", 0);
			KnownTypeTable[0x178] = new TypeDeclaration(resolver, "ListItem", "System.Windows.Documents", 0);
			KnownTypeTable[0x179] = new TypeDeclaration(resolver, "ListView", "System.Windows.Controls", 0);
			KnownTypeTable[0x17a] = new TypeDeclaration(resolver, "ListViewItem", "System.Windows.Controls", 0);
			KnownTypeTable[0x17b] = new TypeDeclaration(resolver, "Localization", "System.Windows", 0);
			KnownTypeTable[380] = new TypeDeclaration(resolver, "LostFocusEventManager", "System.Windows", 0);
			KnownTypeTable[0x17d] = new TypeDeclaration(resolver, "MarkupExtension", "System.Windows.Markup", 4);
			KnownTypeTable[0x17e] = new TypeDeclaration(resolver, "Material", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x17f] = new TypeDeclaration(resolver, "MaterialCollection", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x180] = new TypeDeclaration(resolver, "MaterialGroup", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x181] = new TypeDeclaration(resolver, "Matrix", "System.Windows.Media", 4);
			KnownTypeTable[0x182] = new TypeDeclaration(resolver, "Matrix3D", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x183] = new TypeDeclaration(resolver, "Matrix3DConverter", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x184] = new TypeDeclaration(resolver, "MatrixAnimationBase", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x185] = new TypeDeclaration(resolver, "MatrixAnimationUsingKeyFrames", "System.Windows.Media.Animation", 1);
			KnownTypeTable[390] = new TypeDeclaration(resolver, "MatrixAnimationUsingPath", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x187] = new TypeDeclaration(resolver, "MatrixCamera", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x188] = new TypeDeclaration(resolver, "MatrixConverter", "System.Windows.Media", 4);
			KnownTypeTable[0x189] = new TypeDeclaration(resolver, "MatrixKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x18a] = new TypeDeclaration(resolver, "MatrixKeyFrameCollection", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x18b] = new TypeDeclaration(resolver, "MatrixTransform", "System.Windows.Media", 1);
			KnownTypeTable[0x18c] = new TypeDeclaration(resolver, "MatrixTransform3D", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x18d] = new TypeDeclaration(resolver, "MediaClock", "System.Windows.Media", 1);
			KnownTypeTable[0x18e] = new TypeDeclaration(resolver, "MediaElement", "System.Windows.Controls", 0);
			KnownTypeTable[0x18f] = new TypeDeclaration(resolver, "MediaPlayer", "System.Windows.Media", 1);
			KnownTypeTable[400] = new TypeDeclaration(resolver, "MediaTimeline", "System.Windows.Media", 1);
			KnownTypeTable[0x191] = new TypeDeclaration(resolver, "Menu", "System.Windows.Controls", 0);
			KnownTypeTable[0x192] = new TypeDeclaration(resolver, "MenuBase", "System.Windows.Controls.Primitives", 0);
			KnownTypeTable[0x193] = new TypeDeclaration(resolver, "MenuItem", "System.Windows.Controls", 0);
			KnownTypeTable[0x194] = new TypeDeclaration(resolver, "MenuScrollingVisibilityConverter", "System.Windows.Controls", 0);
			KnownTypeTable[0x195] = new TypeDeclaration(resolver, "MeshGeometry3D", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x196] = new TypeDeclaration(resolver, "Model3D", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x197] = new TypeDeclaration(resolver, "Model3DCollection", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x198] = new TypeDeclaration(resolver, "Model3DGroup", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x199] = new TypeDeclaration(resolver, "ModelVisual3D", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[410] = new TypeDeclaration(resolver, "ModifierKeysConverter", "System.Windows.Input", 4);
			KnownTypeTable[0x19b] = new TypeDeclaration(resolver, "MouseActionConverter", "System.Windows.Input", 1);
			KnownTypeTable[0x19c] = new TypeDeclaration(resolver, "MouseBinding", "System.Windows.Input", 1);
			KnownTypeTable[0x19d] = new TypeDeclaration(resolver, "MouseDevice", "System.Windows.Input", 1);
			KnownTypeTable[0x19e] = new TypeDeclaration(resolver, "MouseGesture", "System.Windows.Input", 1);
			KnownTypeTable[0x19f] = new TypeDeclaration(resolver, "MouseGestureConverter", "System.Windows.Input", 1);
			KnownTypeTable[0x1a0] = new TypeDeclaration(resolver, "MultiBinding", "System.Windows.Data", 0, false);
			KnownTypeTable[0x1a1] = new TypeDeclaration(resolver, "MultiBindingExpression", "System.Windows.Data", 0);
			KnownTypeTable[0x1a2] = new TypeDeclaration(resolver, "MultiDataTrigger", "System.Windows", 0);
			KnownTypeTable[0x1a3] = new TypeDeclaration(resolver, "MultiTrigger", "System.Windows", 0);
			KnownTypeTable[420] = new TypeDeclaration(resolver, "NameScope", "System.Windows", 0);
			KnownTypeTable[0x1a5] = new TypeDeclaration(resolver, "NavigationWindow", "System.Windows.Navigation", 0);
			KnownTypeTable[0x1a7] = new TypeDeclaration(resolver, "NullableBoolConverter", "System.Windows", 0);
			KnownTypeTable[0x1a8] = new TypeDeclaration(resolver, "NullableConverter", "System.ComponentModel", 3);
			KnownTypeTable[0x1a6] = new TypeDeclaration(resolver, "NullExtension", "System.Windows.Markup", 0, true);
			KnownTypeTable[0x1a9] = new TypeDeclaration(resolver, "NumberSubstitution", "System.Windows.Media", 1);
			KnownTypeTable[0x1aa] = new TypeDeclaration(resolver, "Object", "System", 2);
			KnownTypeTable[0x1ab] = new TypeDeclaration(resolver, "ObjectAnimationBase", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x1ac] = new TypeDeclaration(resolver, "ObjectAnimationUsingKeyFrames", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x1ad] = new TypeDeclaration(resolver, "ObjectDataProvider", "System.Windows.Data", 0);
			KnownTypeTable[430] = new TypeDeclaration(resolver, "ObjectKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x1af] = new TypeDeclaration(resolver, "ObjectKeyFrameCollection", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x1b0] = new TypeDeclaration(resolver, "OrthographicCamera", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x1b1] = new TypeDeclaration(resolver, "OuterGlowBitmapEffect", "System.Windows.Media.Effects", 1);
			KnownTypeTable[0x1b2] = new TypeDeclaration(resolver, "Page", "System.Windows.Controls", 0);
			KnownTypeTable[0x1b3] = new TypeDeclaration(resolver, "PageContent", "System.Windows.Documents", 0);
			KnownTypeTable[0x1b4] = new TypeDeclaration(resolver, "PageFunctionBase", "System.Windows.Navigation", 0);
			KnownTypeTable[0x1b5] = new TypeDeclaration(resolver, "Panel", "System.Windows.Controls", 0);
			KnownTypeTable[0x1b6] = new TypeDeclaration(resolver, "Paragraph", "System.Windows.Documents", 0);
			KnownTypeTable[0x1b7] = new TypeDeclaration(resolver, "ParallelTimeline", "System.Windows.Media.Animation", 1);
			KnownTypeTable[440] = new TypeDeclaration(resolver, "ParserContext", "System.Windows.Markup", 0);
			KnownTypeTable[0x1b9] = new TypeDeclaration(resolver, "PasswordBox", "System.Windows.Controls", 0);
			KnownTypeTable[0x1ba] = new TypeDeclaration(resolver, "Path", "System.Windows.Shapes", 0);
			KnownTypeTable[0x1bb] = new TypeDeclaration(resolver, "PathFigure", "System.Windows.Media", 1);
			KnownTypeTable[0x1bc] = new TypeDeclaration(resolver, "PathFigureCollection", "System.Windows.Media", 1);
			KnownTypeTable[0x1bd] = new TypeDeclaration(resolver, "PathFigureCollectionConverter", "System.Windows.Media", 1);
			KnownTypeTable[0x1be] = new TypeDeclaration(resolver, "PathGeometry", "System.Windows.Media", 1);
			KnownTypeTable[0x1bf] = new TypeDeclaration(resolver, "PathSegment", "System.Windows.Media", 1);
			KnownTypeTable[0x1c0] = new TypeDeclaration(resolver, "PathSegmentCollection", "System.Windows.Media", 1);
			KnownTypeTable[0x1c1] = new TypeDeclaration(resolver, "PauseStoryboard", "System.Windows.Media.Animation", 0);
			KnownTypeTable[450] = new TypeDeclaration(resolver, "Pen", "System.Windows.Media", 1);
			KnownTypeTable[0x1c3] = new TypeDeclaration(resolver, "PerspectiveCamera", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x1c4] = new TypeDeclaration(resolver, "PixelFormat", "System.Windows.Media", 1);
			KnownTypeTable[0x1c5] = new TypeDeclaration(resolver, "PixelFormatConverter", "System.Windows.Media", 1);
			KnownTypeTable[0x1c6] = new TypeDeclaration(resolver, "PngBitmapDecoder", "System.Windows.Media.Imaging", 1);
			KnownTypeTable[0x1c7] = new TypeDeclaration(resolver, "PngBitmapEncoder", "System.Windows.Media.Imaging", 1);
			KnownTypeTable[0x1c8] = new TypeDeclaration(resolver, "Point", "System.Windows", 4);
			KnownTypeTable[0x1c9] = new TypeDeclaration(resolver, "Point3D", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x1ca] = new TypeDeclaration(resolver, "Point3DAnimation", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x1cb] = new TypeDeclaration(resolver, "Point3DAnimationBase", "System.Windows.Media.Animation", 1);
			KnownTypeTable[460] = new TypeDeclaration(resolver, "Point3DAnimationUsingKeyFrames", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x1cd] = new TypeDeclaration(resolver, "Point3DCollection", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x1ce] = new TypeDeclaration(resolver, "Point3DCollectionConverter", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x1cf] = new TypeDeclaration(resolver, "Point3DConverter", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x1d0] = new TypeDeclaration(resolver, "Point3DKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x1d1] = new TypeDeclaration(resolver, "Point3DKeyFrameCollection", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x1d2] = new TypeDeclaration(resolver, "Point4D", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x1d3] = new TypeDeclaration(resolver, "Point4DConverter", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x1d4] = new TypeDeclaration(resolver, "PointAnimation", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x1d5] = new TypeDeclaration(resolver, "PointAnimationBase", "System.Windows.Media.Animation", 1);
			KnownTypeTable[470] = new TypeDeclaration(resolver, "PointAnimationUsingKeyFrames", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x1d7] = new TypeDeclaration(resolver, "PointAnimationUsingPath", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x1d8] = new TypeDeclaration(resolver, "PointCollection", "System.Windows.Media", 1);
			KnownTypeTable[0x1d9] = new TypeDeclaration(resolver, "PointCollectionConverter", "System.Windows.Media", 1);
			KnownTypeTable[0x1da] = new TypeDeclaration(resolver, "PointConverter", "System.Windows", 4);
			KnownTypeTable[0x1db] = new TypeDeclaration(resolver, "PointIListConverter", "System.Windows.Media.Converters", 1);
			KnownTypeTable[0x1dc] = new TypeDeclaration(resolver, "PointKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x1dd] = new TypeDeclaration(resolver, "PointKeyFrameCollection", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x1de] = new TypeDeclaration(resolver, "PointLight", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x1df] = new TypeDeclaration(resolver, "PointLightBase", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[480] = new TypeDeclaration(resolver, "PolyBezierSegment", "System.Windows.Media", 1);
			KnownTypeTable[0x1e3] = new TypeDeclaration(resolver, "Polygon", "System.Windows.Shapes", 0);
			KnownTypeTable[0x1e4] = new TypeDeclaration(resolver, "Polyline", "System.Windows.Shapes", 0);
			KnownTypeTable[0x1e1] = new TypeDeclaration(resolver, "PolyLineSegment", "System.Windows.Media", 1);
			KnownTypeTable[0x1e2] = new TypeDeclaration(resolver, "PolyQuadraticBezierSegment", "System.Windows.Media", 1);
			KnownTypeTable[0x1e5] = new TypeDeclaration(resolver, "Popup", "System.Windows.Controls.Primitives", 0);
			KnownTypeTable[0x1e6] = new TypeDeclaration(resolver, "PresentationSource", "System.Windows", 1);
			KnownTypeTable[0x1e7] = new TypeDeclaration(resolver, "PriorityBinding", "System.Windows.Data", 0, true);
			KnownTypeTable[0x1e8] = new TypeDeclaration(resolver, "PriorityBindingExpression", "System.Windows.Data", 0);
			KnownTypeTable[0x1e9] = new TypeDeclaration(resolver, "ProgressBar", "System.Windows.Controls", 0);
			KnownTypeTable[490] = new TypeDeclaration(resolver, "ProjectionCamera", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x1eb] = new TypeDeclaration(resolver, "PropertyPath", "System.Windows", 0);
			KnownTypeTable[0x1ec] = new TypeDeclaration(resolver, "PropertyPathConverter", "System.Windows", 0);
			KnownTypeTable[0x1ed] = new TypeDeclaration(resolver, "QuadraticBezierSegment", "System.Windows.Media", 1);
			KnownTypeTable[0x1ee] = new TypeDeclaration(resolver, "Quaternion", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x1ef] = new TypeDeclaration(resolver, "QuaternionAnimation", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x1f0] = new TypeDeclaration(resolver, "QuaternionAnimationBase", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x1f1] = new TypeDeclaration(resolver, "QuaternionAnimationUsingKeyFrames", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x1f2] = new TypeDeclaration(resolver, "QuaternionConverter", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x1f3] = new TypeDeclaration(resolver, "QuaternionKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[500] = new TypeDeclaration(resolver, "QuaternionKeyFrameCollection", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x1f5] = new TypeDeclaration(resolver, "QuaternionRotation3D", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x1f6] = new TypeDeclaration(resolver, "RadialGradientBrush", "System.Windows.Media", 1);
			KnownTypeTable[0x1f7] = new TypeDeclaration(resolver, "RadioButton", "System.Windows.Controls", 0);
			KnownTypeTable[0x1f8] = new TypeDeclaration(resolver, "RangeBase", "System.Windows.Controls.Primitives", 0);
			KnownTypeTable[0x1f9] = new TypeDeclaration(resolver, "Rect", "System.Windows", 1);
			KnownTypeTable[0x1fa] = new TypeDeclaration(resolver, "Rect3D", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x1fb] = new TypeDeclaration(resolver, "Rect3DConverter", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x202] = new TypeDeclaration(resolver, "Rectangle", "System.Windows.Shapes", 0);
			KnownTypeTable[0x203] = new TypeDeclaration(resolver, "RectangleGeometry", "System.Windows.Media", 1);
			KnownTypeTable[0x1fc] = new TypeDeclaration(resolver, "RectAnimation", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x1fd] = new TypeDeclaration(resolver, "RectAnimationBase", "System.Windows.Media.Animation", 1);
			KnownTypeTable[510] = new TypeDeclaration(resolver, "RectAnimationUsingKeyFrames", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x1ff] = new TypeDeclaration(resolver, "RectConverter", "System.Windows", 4);
			KnownTypeTable[0x200] = new TypeDeclaration(resolver, "RectKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x201] = new TypeDeclaration(resolver, "RectKeyFrameCollection", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x204] = new TypeDeclaration(resolver, "RelativeSource", "System.Windows.Data", 0, true);
			KnownTypeTable[0x205] = new TypeDeclaration(resolver, "RemoveStoryboard", "System.Windows.Media.Animation", 0);
			KnownTypeTable[0x206] = new TypeDeclaration(resolver, "RenderOptions", "System.Windows.Media", 1);
			KnownTypeTable[0x207] = new TypeDeclaration(resolver, "RenderTargetBitmap", "System.Windows.Media.Imaging", 1);
			KnownTypeTable[520] = new TypeDeclaration(resolver, "RepeatBehavior", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x209] = new TypeDeclaration(resolver, "RepeatBehaviorConverter", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x20a] = new TypeDeclaration(resolver, "RepeatButton", "System.Windows.Controls.Primitives", 0);
			KnownTypeTable[0x20b] = new TypeDeclaration(resolver, "ResizeGrip", "System.Windows.Controls.Primitives", 0);
			KnownTypeTable[0x20c] = new TypeDeclaration(resolver, "ResourceDictionary", "System.Windows", 0);
			KnownTypeTable[0x20d] = new TypeDeclaration(resolver, "ResourceKey", "System.Windows", 0, true);
			KnownTypeTable[0x20e] = new TypeDeclaration(resolver, "ResumeStoryboard", "System.Windows.Media.Animation", 0);
			KnownTypeTable[0x20f] = new TypeDeclaration(resolver, "RichTextBox", "System.Windows.Controls", 0);
			KnownTypeTable[0x210] = new TypeDeclaration(resolver, "RotateTransform", "System.Windows.Media", 1);
			KnownTypeTable[0x211] = new TypeDeclaration(resolver, "RotateTransform3D", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[530] = new TypeDeclaration(resolver, "Rotation3D", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x213] = new TypeDeclaration(resolver, "Rotation3DAnimation", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x214] = new TypeDeclaration(resolver, "Rotation3DAnimationBase", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x215] = new TypeDeclaration(resolver, "Rotation3DAnimationUsingKeyFrames", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x216] = new TypeDeclaration(resolver, "Rotation3DKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x217] = new TypeDeclaration(resolver, "Rotation3DKeyFrameCollection", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x218] = new TypeDeclaration(resolver, "RoutedCommand", "System.Windows.Input", 1);
			KnownTypeTable[0x219] = new TypeDeclaration(resolver, "RoutedEvent", "System.Windows", 1);
			KnownTypeTable[0x21a] = new TypeDeclaration(resolver, "RoutedEventConverter", "System.Windows.Markup", 0);
			KnownTypeTable[0x21b] = new TypeDeclaration(resolver, "RoutedUICommand", "System.Windows.Input", 1);
			KnownTypeTable[540] = new TypeDeclaration(resolver, "RoutingStrategy", "System.Windows", 1);
			KnownTypeTable[0x21d] = new TypeDeclaration(resolver, "RowDefinition", "System.Windows.Controls", 0);
			KnownTypeTable[0x21e] = new TypeDeclaration(resolver, "Run", "System.Windows.Documents", 0);
			KnownTypeTable[0x21f] = new TypeDeclaration(resolver, "RuntimeNamePropertyAttribute", "System.Windows.Markup", 4);
			KnownTypeTable[0x220] = new TypeDeclaration(resolver, "SByte", "System", 2);
			KnownTypeTable[0x221] = new TypeDeclaration(resolver, "SByteConverter", "System.ComponentModel", 3);
			KnownTypeTable[0x222] = new TypeDeclaration(resolver, "ScaleTransform", "System.Windows.Media", 1);
			KnownTypeTable[0x223] = new TypeDeclaration(resolver, "ScaleTransform3D", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x224] = new TypeDeclaration(resolver, "ScrollBar", "System.Windows.Controls.Primitives", 0);
			KnownTypeTable[0x225] = new TypeDeclaration(resolver, "ScrollContentPresenter", "System.Windows.Controls", 0);
			KnownTypeTable[550] = new TypeDeclaration(resolver, "ScrollViewer", "System.Windows.Controls", 0);
			KnownTypeTable[0x227] = new TypeDeclaration(resolver, "Section", "System.Windows.Documents", 0);
			KnownTypeTable[0x228] = new TypeDeclaration(resolver, "SeekStoryboard", "System.Windows.Media.Animation", 0);
			KnownTypeTable[0x229] = new TypeDeclaration(resolver, "Selector", "System.Windows.Controls.Primitives", 0);
			KnownTypeTable[0x22a] = new TypeDeclaration(resolver, "Separator", "System.Windows.Controls", 0);
			KnownTypeTable[0x22b] = new TypeDeclaration(resolver, "SetStoryboardSpeedRatio", "System.Windows.Media.Animation", 0);
			KnownTypeTable[0x22c] = new TypeDeclaration(resolver, "Setter", "System.Windows", 0);
			KnownTypeTable[0x22d] = new TypeDeclaration(resolver, "SetterBase", "System.Windows", 0);
			KnownTypeTable[0x22e] = new TypeDeclaration(resolver, "Shape", "System.Windows.Shapes", 0);
			KnownTypeTable[0x22f] = new TypeDeclaration(resolver, "Single", "System", 2);
			KnownTypeTable[560] = new TypeDeclaration(resolver, "SingleAnimation", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x231] = new TypeDeclaration(resolver, "SingleAnimationBase", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x232] = new TypeDeclaration(resolver, "SingleAnimationUsingKeyFrames", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x233] = new TypeDeclaration(resolver, "SingleConverter", "System.ComponentModel", 3);
			KnownTypeTable[0x234] = new TypeDeclaration(resolver, "SingleKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x235] = new TypeDeclaration(resolver, "SingleKeyFrameCollection", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x236] = new TypeDeclaration(resolver, "Size", "System.Windows", 4);
			KnownTypeTable[0x237] = new TypeDeclaration(resolver, "Size3D", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x238] = new TypeDeclaration(resolver, "Size3DConverter", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x239] = new TypeDeclaration(resolver, "SizeAnimation", "System.Windows.Media.Animation", 1);
			KnownTypeTable[570] = new TypeDeclaration(resolver, "SizeAnimationBase", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x23b] = new TypeDeclaration(resolver, "SizeAnimationUsingKeyFrames", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x23c] = new TypeDeclaration(resolver, "SizeConverter", "System.Windows", 4);
			KnownTypeTable[0x23d] = new TypeDeclaration(resolver, "SizeKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x23e] = new TypeDeclaration(resolver, "SizeKeyFrameCollection", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x23f] = new TypeDeclaration(resolver, "SkewTransform", "System.Windows.Media", 1);
			KnownTypeTable[0x240] = new TypeDeclaration(resolver, "SkipStoryboardToFill", "System.Windows.Media.Animation", 0);
			KnownTypeTable[0x241] = new TypeDeclaration(resolver, "Slider", "System.Windows.Controls", 0);
			KnownTypeTable[0x242] = new TypeDeclaration(resolver, "SolidColorBrush", "System.Windows.Media", 1);
			KnownTypeTable[0x243] = new TypeDeclaration(resolver, "SoundPlayerAction", "System.Windows.Controls", 0);
			KnownTypeTable[580] = new TypeDeclaration(resolver, "Span", "System.Windows.Documents", 0);
			KnownTypeTable[0x245] = new TypeDeclaration(resolver, "SpecularMaterial", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x246] = new TypeDeclaration(resolver, "SpellCheck", "System.Windows.Controls", 0);
			KnownTypeTable[0x247] = new TypeDeclaration(resolver, "SplineByteKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x248] = new TypeDeclaration(resolver, "SplineColorKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x249] = new TypeDeclaration(resolver, "SplineDecimalKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x24a] = new TypeDeclaration(resolver, "SplineDoubleKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x24b] = new TypeDeclaration(resolver, "SplineInt16KeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x24c] = new TypeDeclaration(resolver, "SplineInt32KeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x24d] = new TypeDeclaration(resolver, "SplineInt64KeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[590] = new TypeDeclaration(resolver, "SplinePoint3DKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x24f] = new TypeDeclaration(resolver, "SplinePointKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x250] = new TypeDeclaration(resolver, "SplineQuaternionKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x251] = new TypeDeclaration(resolver, "SplineRectKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x252] = new TypeDeclaration(resolver, "SplineRotation3DKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x253] = new TypeDeclaration(resolver, "SplineSingleKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x254] = new TypeDeclaration(resolver, "SplineSizeKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x255] = new TypeDeclaration(resolver, "SplineThicknessKeyFrame", "System.Windows.Media.Animation", 0);
			KnownTypeTable[0x256] = new TypeDeclaration(resolver, "SplineVector3DKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x257] = new TypeDeclaration(resolver, "SplineVectorKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[600] = new TypeDeclaration(resolver, "SpotLight", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x259] = new TypeDeclaration(resolver, "StackPanel", "System.Windows.Controls", 0);
			KnownTypeTable[0x25a] = new TypeDeclaration(resolver, "StaticExtension", "System.Windows.Markup", 0);
			KnownTypeTable[0x25b] = new TypeDeclaration(resolver, "StaticResourceExtension", "System.Windows", 0, true);
			KnownTypeTable[0x25c] = new TypeDeclaration(resolver, "StatusBar", "System.Windows.Controls.Primitives", 0);
			KnownTypeTable[0x25d] = new TypeDeclaration(resolver, "StatusBarItem", "System.Windows.Controls.Primitives", 0);
			KnownTypeTable[0x25e] = new TypeDeclaration(resolver, "StickyNoteControl", "System.Windows.Controls", 0);
			KnownTypeTable[0x25f] = new TypeDeclaration(resolver, "StopStoryboard", "System.Windows.Media.Animation", 0);
			KnownTypeTable[0x260] = new TypeDeclaration(resolver, "Storyboard", "System.Windows.Media.Animation", 0);
			KnownTypeTable[0x261] = new TypeDeclaration(resolver, "StreamGeometry", "System.Windows.Media", 1);
			KnownTypeTable[610] = new TypeDeclaration(resolver, "StreamGeometryContext", "System.Windows.Media", 1);
			KnownTypeTable[0x263] = new TypeDeclaration(resolver, "StreamResourceInfo", "System.Windows.Resources", 0);
			KnownTypeTable[0x264] = new TypeDeclaration(resolver, "String", "System", 2);
			KnownTypeTable[0x265] = new TypeDeclaration(resolver, "StringAnimationBase", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x266] = new TypeDeclaration(resolver, "StringAnimationUsingKeyFrames", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x267] = new TypeDeclaration(resolver, "StringConverter", "System.ComponentModel", 3);
			KnownTypeTable[0x268] = new TypeDeclaration(resolver, "StringKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x269] = new TypeDeclaration(resolver, "StringKeyFrameCollection", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x26a] = new TypeDeclaration(resolver, "StrokeCollection", "System.Windows.Ink", 1);
			KnownTypeTable[0x26b] = new TypeDeclaration(resolver, "StrokeCollectionConverter", "System.Windows", 1);
			KnownTypeTable[620] = new TypeDeclaration(resolver, "Style", "System.Windows", 0);
			KnownTypeTable[0x26d] = new TypeDeclaration(resolver, "Stylus", "System.Windows.Input", 1);
			KnownTypeTable[0x26e] = new TypeDeclaration(resolver, "StylusDevice", "System.Windows.Input", 1);
			KnownTypeTable[0x26f] = new TypeDeclaration(resolver, "TabControl", "System.Windows.Controls", 0);
			KnownTypeTable[0x270] = new TypeDeclaration(resolver, "TabItem", "System.Windows.Controls", 0);
			KnownTypeTable[0x272] = new TypeDeclaration(resolver, "Table", "System.Windows.Documents", 0);
			KnownTypeTable[0x273] = new TypeDeclaration(resolver, "TableCell", "System.Windows.Documents", 0);
			KnownTypeTable[0x274] = new TypeDeclaration(resolver, "TableColumn", "System.Windows.Documents", 0);
			KnownTypeTable[0x275] = new TypeDeclaration(resolver, "TableRow", "System.Windows.Documents", 0);
			KnownTypeTable[630] = new TypeDeclaration(resolver, "TableRowGroup", "System.Windows.Documents", 0);
			KnownTypeTable[0x277] = new TypeDeclaration(resolver, "TabletDevice", "System.Windows.Input", 1);
			KnownTypeTable[0x271] = new TypeDeclaration(resolver, "TabPanel", "System.Windows.Controls.Primitives", 0);
			KnownTypeTable[0x278] = new TypeDeclaration(resolver, "TemplateBindingExpression", "System.Windows", 0);
			KnownTypeTable[0x279] = new TypeDeclaration(resolver, "TemplateBindingExpressionConverter", "System.Windows", 0);
			KnownTypeTable[0x27a] = new TypeDeclaration(resolver, "TemplateBindingExtension", "System.Windows", 0);
			KnownTypeTable[0x27b] = new TypeDeclaration(resolver, "TemplateBindingExtensionConverter", "System.Windows", 0);
			KnownTypeTable[0x27c] = new TypeDeclaration(resolver, "TemplateKey", "System.Windows", 0, true);
			KnownTypeTable[0x27d] = new TypeDeclaration(resolver, "TemplateKeyConverter", "System.Windows.Markup", 0);
			KnownTypeTable[0x27e] = new TypeDeclaration(resolver, "TextBlock", "System.Windows.Controls", 0);
			KnownTypeTable[0x27f] = new TypeDeclaration(resolver, "TextBox", "System.Windows.Controls", 0);
			KnownTypeTable[640] = new TypeDeclaration(resolver, "TextBoxBase", "System.Windows.Controls.Primitives", 0);
			KnownTypeTable[0x281] = new TypeDeclaration(resolver, "TextComposition", "System.Windows.Input", 1);
			KnownTypeTable[0x282] = new TypeDeclaration(resolver, "TextCompositionManager", "System.Windows.Input", 1);
			KnownTypeTable[0x283] = new TypeDeclaration(resolver, "TextDecoration", "System.Windows", 1);
			KnownTypeTable[0x284] = new TypeDeclaration(resolver, "TextDecorationCollection", "System.Windows", 1);
			KnownTypeTable[0x285] = new TypeDeclaration(resolver, "TextDecorationCollectionConverter", "System.Windows", 1);
			KnownTypeTable[0x286] = new TypeDeclaration(resolver, "TextEffect", "System.Windows.Media", 1);
			KnownTypeTable[0x287] = new TypeDeclaration(resolver, "TextEffectCollection", "System.Windows.Media", 1);
			KnownTypeTable[0x288] = new TypeDeclaration(resolver, "TextElement", "System.Windows.Documents", 0);
			KnownTypeTable[0x289] = new TypeDeclaration(resolver, "TextSearch", "System.Windows.Controls", 0);
			KnownTypeTable[650] = new TypeDeclaration(resolver, "ThemeDictionaryExtension", "System.Windows", 0, true);
			KnownTypeTable[0x28b] = new TypeDeclaration(resolver, "Thickness", "System.Windows", 0);
			KnownTypeTable[0x28c] = new TypeDeclaration(resolver, "ThicknessAnimation", "System.Windows.Media.Animation", 0);
			KnownTypeTable[0x28d] = new TypeDeclaration(resolver, "ThicknessAnimationBase", "System.Windows.Media.Animation", 0);
			KnownTypeTable[0x28e] = new TypeDeclaration(resolver, "ThicknessAnimationUsingKeyFrames", "System.Windows.Media.Animation", 0);
			KnownTypeTable[0x28f] = new TypeDeclaration(resolver, "ThicknessConverter", "System.Windows", 0);
			KnownTypeTable[0x290] = new TypeDeclaration(resolver, "ThicknessKeyFrame", "System.Windows.Media.Animation", 0);
			KnownTypeTable[0x291] = new TypeDeclaration(resolver, "ThicknessKeyFrameCollection", "System.Windows.Media.Animation", 0);
			KnownTypeTable[0x292] = new TypeDeclaration(resolver, "Thumb", "System.Windows.Controls.Primitives", 0);
			KnownTypeTable[0x293] = new TypeDeclaration(resolver, "TickBar", "System.Windows.Controls.Primitives", 0);
			KnownTypeTable[660] = new TypeDeclaration(resolver, "TiffBitmapDecoder", "System.Windows.Media.Imaging", 1);
			KnownTypeTable[0x295] = new TypeDeclaration(resolver, "TiffBitmapEncoder", "System.Windows.Media.Imaging", 1);
			KnownTypeTable[0x296] = new TypeDeclaration(resolver, "TileBrush", "System.Windows.Media", 1);
			KnownTypeTable[0x299] = new TypeDeclaration(resolver, "Timeline", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x29a] = new TypeDeclaration(resolver, "TimelineCollection", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x29b] = new TypeDeclaration(resolver, "TimelineGroup", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x297] = new TypeDeclaration(resolver, "TimeSpan", "System", 2);
			KnownTypeTable[0x298] = new TypeDeclaration(resolver, "TimeSpanConverter", "System.ComponentModel", 3);
			KnownTypeTable[0x29c] = new TypeDeclaration(resolver, "ToggleButton", "System.Windows.Controls.Primitives", 0);
			KnownTypeTable[0x29d] = new TypeDeclaration(resolver, "ToolBar", "System.Windows.Controls", 0);
			KnownTypeTable[670] = new TypeDeclaration(resolver, "ToolBarOverflowPanel", "System.Windows.Controls.Primitives", 0);
			KnownTypeTable[0x29f] = new TypeDeclaration(resolver, "ToolBarPanel", "System.Windows.Controls.Primitives", 0);
			KnownTypeTable[0x2a0] = new TypeDeclaration(resolver, "ToolBarTray", "System.Windows.Controls", 0);
			KnownTypeTable[0x2a1] = new TypeDeclaration(resolver, "ToolTip", "System.Windows.Controls", 0);
			KnownTypeTable[0x2a2] = new TypeDeclaration(resolver, "ToolTipService", "System.Windows.Controls", 0);
			KnownTypeTable[0x2a3] = new TypeDeclaration(resolver, "Track", "System.Windows.Controls.Primitives", 0);
			KnownTypeTable[0x2a4] = new TypeDeclaration(resolver, "Transform", "System.Windows.Media", 1);
			KnownTypeTable[0x2a5] = new TypeDeclaration(resolver, "Transform3D", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x2a6] = new TypeDeclaration(resolver, "Transform3DCollection", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x2a7] = new TypeDeclaration(resolver, "Transform3DGroup", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[680] = new TypeDeclaration(resolver, "TransformCollection", "System.Windows.Media", 1);
			KnownTypeTable[0x2a9] = new TypeDeclaration(resolver, "TransformConverter", "System.Windows.Media", 1);
			KnownTypeTable[0x2ab] = new TypeDeclaration(resolver, "TransformedBitmap", "System.Windows.Media.Imaging", 1);
			KnownTypeTable[0x2aa] = new TypeDeclaration(resolver, "TransformGroup", "System.Windows.Media", 1);
			KnownTypeTable[0x2ac] = new TypeDeclaration(resolver, "TranslateTransform", "System.Windows.Media", 1);
			KnownTypeTable[0x2ad] = new TypeDeclaration(resolver, "TranslateTransform3D", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x2ae] = new TypeDeclaration(resolver, "TreeView", "System.Windows.Controls", 0);
			KnownTypeTable[0x2af] = new TypeDeclaration(resolver, "TreeViewItem", "System.Windows.Controls", 0);
			KnownTypeTable[0x2b0] = new TypeDeclaration(resolver, "Trigger", "System.Windows", 0);
			KnownTypeTable[0x2b1] = new TypeDeclaration(resolver, "TriggerAction", "System.Windows", 0);
			KnownTypeTable[690] = new TypeDeclaration(resolver, "TriggerBase", "System.Windows", 0);
			KnownTypeTable[0x2b3] = new TypeDeclaration(resolver, "TypeExtension", "System.Windows.Markup", 0, true);
			KnownTypeTable[0x2b4] = new TypeDeclaration(resolver, "TypeTypeConverter", "System.Net.Configuration", 3);
			KnownTypeTable[0x2b5] = new TypeDeclaration(resolver, "Typography", "System.Windows.Documents", 0);
			KnownTypeTable[0x2b6] = new TypeDeclaration(resolver, "UIElement", "System.Windows", 1);
			KnownTypeTable[0x2b7] = new TypeDeclaration(resolver, "UInt16", "System", 2);
			KnownTypeTable[0x2b8] = new TypeDeclaration(resolver, "UInt16Converter", "System.ComponentModel", 3);
			KnownTypeTable[0x2b9] = new TypeDeclaration(resolver, "UInt32", "System", 2);
			KnownTypeTable[0x2ba] = new TypeDeclaration(resolver, "UInt32Converter", "System.ComponentModel", 3);
			KnownTypeTable[0x2bb] = new TypeDeclaration(resolver, "UInt64", "System", 2);
			KnownTypeTable[700] = new TypeDeclaration(resolver, "UInt64Converter", "System.ComponentModel", 3);
			KnownTypeTable[0x2be] = new TypeDeclaration(resolver, "Underline", "System.Windows.Documents", 0);
			KnownTypeTable[0x2bf] = new TypeDeclaration(resolver, "UniformGrid", "System.Windows.Controls.Primitives", 0);
			KnownTypeTable[0x2c0] = new TypeDeclaration(resolver, "Uri", "System", 3);
			KnownTypeTable[0x2c1] = new TypeDeclaration(resolver, "UriTypeConverter", "System", 3);
			KnownTypeTable[0x2c2] = new TypeDeclaration(resolver, "UserControl", "System.Windows.Controls", 0);
			KnownTypeTable[0x2bd] = new TypeDeclaration(resolver, "UShortIListConverter", "System.Windows.Media.Converters", 1);
			KnownTypeTable[0x2c3] = new TypeDeclaration(resolver, "Validation", "System.Windows.Controls", 0);
			KnownTypeTable[0x2c4] = new TypeDeclaration(resolver, "Vector", "System.Windows", 1);
			KnownTypeTable[0x2c5] = new TypeDeclaration(resolver, "Vector3D", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[710] = new TypeDeclaration(resolver, "Vector3DAnimation", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x2c7] = new TypeDeclaration(resolver, "Vector3DAnimationBase", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x2c8] = new TypeDeclaration(resolver, "Vector3DAnimationUsingKeyFrames", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x2c9] = new TypeDeclaration(resolver, "Vector3DCollection", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x2ca] = new TypeDeclaration(resolver, "Vector3DCollectionConverter", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x2cb] = new TypeDeclaration(resolver, "Vector3DConverter", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x2cc] = new TypeDeclaration(resolver, "Vector3DKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x2cd] = new TypeDeclaration(resolver, "Vector3DKeyFrameCollection", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x2ce] = new TypeDeclaration(resolver, "VectorAnimation", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x2cf] = new TypeDeclaration(resolver, "VectorAnimationBase", "System.Windows.Media.Animation", 1);
			KnownTypeTable[720] = new TypeDeclaration(resolver, "VectorAnimationUsingKeyFrames", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x2d1] = new TypeDeclaration(resolver, "VectorCollection", "System.Windows.Media", 1);
			KnownTypeTable[0x2d2] = new TypeDeclaration(resolver, "VectorCollectionConverter", "System.Windows.Media", 1);
			KnownTypeTable[0x2d3] = new TypeDeclaration(resolver, "VectorConverter", "System.Windows", 4);
			KnownTypeTable[0x2d4] = new TypeDeclaration(resolver, "VectorKeyFrame", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x2d5] = new TypeDeclaration(resolver, "VectorKeyFrameCollection", "System.Windows.Media.Animation", 1);
			KnownTypeTable[0x2d6] = new TypeDeclaration(resolver, "VideoDrawing", "System.Windows.Media", 1);
			KnownTypeTable[0x2d7] = new TypeDeclaration(resolver, "ViewBase", "System.Windows.Controls", 0);
			KnownTypeTable[0x2d8] = new TypeDeclaration(resolver, "Viewbox", "System.Windows.Controls", 0);
			KnownTypeTable[0x2d9] = new TypeDeclaration(resolver, "Viewport3D", "System.Windows.Controls", 0);
			KnownTypeTable[730] = new TypeDeclaration(resolver, "Viewport3DVisual", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x2db] = new TypeDeclaration(resolver, "VirtualizingPanel", "System.Windows.Controls", 0);
			KnownTypeTable[0x2dc] = new TypeDeclaration(resolver, "VirtualizingStackPanel", "System.Windows.Controls", 0);
			KnownTypeTable[0x2dd] = new TypeDeclaration(resolver, "Visual", "System.Windows.Media", 1);
			KnownTypeTable[0x2de] = new TypeDeclaration(resolver, "Visual3D", "System.Windows.Media.Media3D", 1);
			KnownTypeTable[0x2df] = new TypeDeclaration(resolver, "VisualBrush", "System.Windows.Media", 1);
			KnownTypeTable[0x2e0] = new TypeDeclaration(resolver, "VisualTarget", "System.Windows.Media", 1);
			KnownTypeTable[0x2e1] = new TypeDeclaration(resolver, "WeakEventManager", "System.Windows", 4);
			KnownTypeTable[0x2e2] = new TypeDeclaration(resolver, "WhitespaceSignificantCollectionAttribute", "System.Windows.Markup", 4);
			KnownTypeTable[0x2e3] = new TypeDeclaration(resolver, "Window", "System.Windows", 0);
			KnownTypeTable[740] = new TypeDeclaration(resolver, "WmpBitmapDecoder", "System.Windows.Media.Imaging", 1);
			KnownTypeTable[0x2e5] = new TypeDeclaration(resolver, "WmpBitmapEncoder", "System.Windows.Media.Imaging", 1);
			KnownTypeTable[0x2e6] = new TypeDeclaration(resolver, "WrapPanel", "System.Windows.Controls", 0);
			KnownTypeTable[0x2e7] = new TypeDeclaration(resolver, "WriteableBitmap", "System.Windows.Media.Imaging", 1);
			KnownTypeTable[0x2e8] = new TypeDeclaration(resolver, "XamlBrushSerializer", "System.Windows.Markup", 0);
			KnownTypeTable[0x2e9] = new TypeDeclaration(resolver, "XamlInt32CollectionSerializer", "System.Windows.Markup", 0);
			KnownTypeTable[0x2ea] = new TypeDeclaration(resolver, "XamlPathDataSerializer", "System.Windows.Markup", 0);
			KnownTypeTable[0x2eb] = new TypeDeclaration(resolver, "XamlPoint3DCollectionSerializer", "System.Windows.Markup", 0);
			KnownTypeTable[0x2ec] = new TypeDeclaration(resolver, "XamlPointCollectionSerializer", "System.Windows.Markup", 0);
			KnownTypeTable[0x2ed] = new TypeDeclaration(resolver, "XamlReader", "System.Windows.Markup", 0);
			KnownTypeTable[750] = new TypeDeclaration(resolver, "XamlStyleSerializer", "System.Windows.Markup", 0);
			KnownTypeTable[0x2ef] = new TypeDeclaration(resolver, "XamlTemplateSerializer", "System.Windows.Markup", 0);
			KnownTypeTable[0x2f0] = new TypeDeclaration(resolver, "XamlVector3DCollectionSerializer", "System.Windows.Markup", 0);
			KnownTypeTable[0x2f1] = new TypeDeclaration(resolver, "XamlWriter", "System.Windows.Markup", 0);
			KnownTypeTable[0x2f2] = new TypeDeclaration(resolver, "XmlDataProvider", "System.Windows.Data", 0);
			KnownTypeTable[0x2f3] = new TypeDeclaration(resolver, "XmlLangPropertyAttribute", "System.Windows.Markup", 4);
			KnownTypeTable[0x2f4] = new TypeDeclaration(resolver, "XmlLanguage", "System.Windows.Markup", 1);
			KnownTypeTable[0x2f5] = new TypeDeclaration(resolver, "XmlLanguageConverter", "System.Windows.Markup", 1);
			KnownTypeTable[0x2f6] = new TypeDeclaration(resolver, "XmlNamespaceMapping", "System.Windows.Data", 0);
			KnownTypeTable[0x2f7] = new TypeDeclaration(resolver, "ZoomPercentageConverter", "System.Windows.Documents", 0);
			KnownPropertyTable = new PropertyDeclaration[0x10d];
			KnownPropertyTable[1] = new PropertyDeclaration("Text", KnownTypeTable[1]);
			KnownPropertyTable[2] = new PropertyDeclaration("Storyboard", KnownTypeTable[0x11]);
			KnownPropertyTable[3] = new PropertyDeclaration("Children", KnownTypeTable[0x1c]);
			KnownPropertyTable[4] = new PropertyDeclaration("Background", KnownTypeTable[50]);
			KnownPropertyTable[5] = new PropertyDeclaration("BorderBrush", KnownTypeTable[50]);
			KnownPropertyTable[6] = new PropertyDeclaration("BorderThickness", KnownTypeTable[50]);
			KnownPropertyTable[7] = new PropertyDeclaration("Command", KnownTypeTable[0x38]);
			KnownPropertyTable[8] = new PropertyDeclaration("CommandParameter", KnownTypeTable[0x38]);
			KnownPropertyTable[9] = new PropertyDeclaration("CommandTarget", KnownTypeTable[0x38]);
			KnownPropertyTable[10] = new PropertyDeclaration("IsPressed", KnownTypeTable[0x38]);
			KnownPropertyTable[11] = new PropertyDeclaration("MaxWidth", KnownTypeTable[90]);
			KnownPropertyTable[12] = new PropertyDeclaration("MinWidth", KnownTypeTable[90]);
			KnownPropertyTable[13] = new PropertyDeclaration("Width", KnownTypeTable[90]);
			KnownPropertyTable[14] = new PropertyDeclaration("Content", KnownTypeTable[100]);
			KnownPropertyTable[15] = new PropertyDeclaration("ContentTemplate", KnownTypeTable[100]);
			KnownPropertyTable[0x10] = new PropertyDeclaration("ContentTemplateSelector", KnownTypeTable[100]);
			KnownPropertyTable[0x11] = new PropertyDeclaration("HasContent", KnownTypeTable[100]);
			KnownPropertyTable[0x12] = new PropertyDeclaration("Focusable", KnownTypeTable[0x65]);
			KnownPropertyTable[0x13] = new PropertyDeclaration("Content", KnownTypeTable[0x66]);
			KnownPropertyTable[20] = new PropertyDeclaration("ContentSource", KnownTypeTable[0x66]);
			KnownPropertyTable[0x15] = new PropertyDeclaration("ContentTemplate", KnownTypeTable[0x66]);
			KnownPropertyTable[0x16] = new PropertyDeclaration("ContentTemplateSelector", KnownTypeTable[0x66]);
			KnownPropertyTable[0x17] = new PropertyDeclaration("RecognizesAccessKey", KnownTypeTable[0x66]);
			KnownPropertyTable[0x18] = new PropertyDeclaration("Background", KnownTypeTable[0x6b]);
			KnownPropertyTable[0x19] = new PropertyDeclaration("BorderBrush", KnownTypeTable[0x6b]);
			KnownPropertyTable[0x1a] = new PropertyDeclaration("BorderThickness", KnownTypeTable[0x6b]);
			KnownPropertyTable[0x1b] = new PropertyDeclaration("FontFamily", KnownTypeTable[0x6b]);
			KnownPropertyTable[0x1c] = new PropertyDeclaration("FontSize", KnownTypeTable[0x6b]);
			KnownPropertyTable[0x1d] = new PropertyDeclaration("FontStretch", KnownTypeTable[0x6b]);
			KnownPropertyTable[30] = new PropertyDeclaration("FontStyle", KnownTypeTable[0x6b]);
			KnownPropertyTable[0x1f] = new PropertyDeclaration("FontWeight", KnownTypeTable[0x6b]);
			KnownPropertyTable[0x20] = new PropertyDeclaration("Foreground", KnownTypeTable[0x6b]);
			KnownPropertyTable[0x21] = new PropertyDeclaration("HorizontalContentAlignment", KnownTypeTable[0x6b]);
			KnownPropertyTable[0x22] = new PropertyDeclaration("IsTabStop", KnownTypeTable[0x6b]);
			KnownPropertyTable[0x23] = new PropertyDeclaration("Padding", KnownTypeTable[0x6b]);
			KnownPropertyTable[0x24] = new PropertyDeclaration("TabIndex", KnownTypeTable[0x6b]);
			KnownPropertyTable[0x25] = new PropertyDeclaration("Template", KnownTypeTable[0x6b]);
			KnownPropertyTable[0x26] = new PropertyDeclaration("VerticalContentAlignment", KnownTypeTable[0x6b]);
			KnownPropertyTable[0x27] = new PropertyDeclaration("Dock", KnownTypeTable[0xa3]);
			KnownPropertyTable[40] = new PropertyDeclaration("LastChildFill", KnownTypeTable[0xa3]);
			KnownPropertyTable[0x29] = new PropertyDeclaration("Document", KnownTypeTable[0xa7]);
			KnownPropertyTable[0x2a] = new PropertyDeclaration("Children", KnownTypeTable[0xb7]);
			KnownPropertyTable[0x2b] = new PropertyDeclaration("Document", KnownTypeTable[0xd3]);
			KnownPropertyTable[0x2c] = new PropertyDeclaration("Document", KnownTypeTable[0xd4]);
			KnownPropertyTable[0x2d] = new PropertyDeclaration("Style", KnownTypeTable[0xe1]);
			KnownPropertyTable[0x2e] = new PropertyDeclaration("FlowDirection", KnownTypeTable[0xe2]);
			KnownPropertyTable[0x2f] = new PropertyDeclaration("Height", KnownTypeTable[0xe2]);
			KnownPropertyTable[0x30] = new PropertyDeclaration("HorizontalAlignment", KnownTypeTable[0xe2]);
			KnownPropertyTable[0x31] = new PropertyDeclaration("Margin", KnownTypeTable[0xe2]);
			KnownPropertyTable[50] = new PropertyDeclaration("MaxHeight", KnownTypeTable[0xe2]);
			KnownPropertyTable[0x33] = new PropertyDeclaration("MaxWidth", KnownTypeTable[0xe2]);
			KnownPropertyTable[0x34] = new PropertyDeclaration("MinHeight", KnownTypeTable[0xe2]);
			KnownPropertyTable[0x35] = new PropertyDeclaration("MinWidth", KnownTypeTable[0xe2]);
			KnownPropertyTable[0x36] = new PropertyDeclaration("Name", KnownTypeTable[0xe2]);
			KnownPropertyTable[0x37] = new PropertyDeclaration("Style", KnownTypeTable[0xe2]);
			KnownPropertyTable[0x38] = new PropertyDeclaration("VerticalAlignment", KnownTypeTable[0xe2]);
			KnownPropertyTable[0x39] = new PropertyDeclaration("Width", KnownTypeTable[0xe2]);
			KnownPropertyTable[0x3a] = new PropertyDeclaration("Children", KnownTypeTable[0xec]);
			KnownPropertyTable[0x3b] = new PropertyDeclaration("Children", KnownTypeTable[0xf2]);
			KnownPropertyTable[60] = new PropertyDeclaration("GradientStops", KnownTypeTable[0xfb]);
			KnownPropertyTable[0x3d] = new PropertyDeclaration("Column", KnownTypeTable[0xfe]);
			KnownPropertyTable[0x3e] = new PropertyDeclaration("ColumnSpan", KnownTypeTable[0xfe]);
			KnownPropertyTable[0x3f] = new PropertyDeclaration("Row", KnownTypeTable[0xfe]);
			KnownPropertyTable[0x40] = new PropertyDeclaration("RowSpan", KnownTypeTable[0xfe]);
			KnownPropertyTable[0x41] = new PropertyDeclaration("Header", KnownTypeTable[0x103]);
			KnownPropertyTable[0x42] = new PropertyDeclaration("HasHeader", KnownTypeTable[0x10d]);
			KnownPropertyTable[0x43] = new PropertyDeclaration("Header", KnownTypeTable[0x10d]);
			KnownPropertyTable[0x44] = new PropertyDeclaration("HeaderTemplate", KnownTypeTable[0x10d]);
			KnownPropertyTable[0x45] = new PropertyDeclaration("HeaderTemplateSelector", KnownTypeTable[0x10d]);
			KnownPropertyTable[70] = new PropertyDeclaration("HasHeader", KnownTypeTable[270]);
			KnownPropertyTable[0x47] = new PropertyDeclaration("Header", KnownTypeTable[270]);
			KnownPropertyTable[0x48] = new PropertyDeclaration("HeaderTemplate", KnownTypeTable[270]);
			KnownPropertyTable[0x49] = new PropertyDeclaration("HeaderTemplateSelector", KnownTypeTable[270]);
			KnownPropertyTable[0x4a] = new PropertyDeclaration("NavigateUri", KnownTypeTable[0x111]);
			KnownPropertyTable[0x4b] = new PropertyDeclaration("Source", KnownTypeTable[0x119]);
			KnownPropertyTable[0x4c] = new PropertyDeclaration("Stretch", KnownTypeTable[0x119]);
			KnownPropertyTable[0x4d] = new PropertyDeclaration("ItemContainerStyle", KnownTypeTable[0x149]);
			KnownPropertyTable[0x4e] = new PropertyDeclaration("ItemContainerStyleSelector", KnownTypeTable[0x149]);
			KnownPropertyTable[0x4f] = new PropertyDeclaration("ItemTemplate", KnownTypeTable[0x149]);
			KnownPropertyTable[80] = new PropertyDeclaration("ItemTemplateSelector", KnownTypeTable[0x149]);
			KnownPropertyTable[0x51] = new PropertyDeclaration("ItemsPanel", KnownTypeTable[0x149]);
			KnownPropertyTable[0x52] = new PropertyDeclaration("ItemsSource", KnownTypeTable[0x149]);
			KnownPropertyTable[0x53] = new PropertyDeclaration("Children", KnownTypeTable[0x180]);
			KnownPropertyTable[0x54] = new PropertyDeclaration("Children", KnownTypeTable[0x198]);
			KnownPropertyTable[0x55] = new PropertyDeclaration("Content", KnownTypeTable[0x1b2]);
			KnownPropertyTable[0x56] = new PropertyDeclaration("Background", KnownTypeTable[0x1b5]);
			KnownPropertyTable[0x57] = new PropertyDeclaration("Data", KnownTypeTable[0x1ba]);
			KnownPropertyTable[0x58] = new PropertyDeclaration("Segments", KnownTypeTable[0x1bb]);
			KnownPropertyTable[0x59] = new PropertyDeclaration("Figures", KnownTypeTable[0x1be]);
			KnownPropertyTable[90] = new PropertyDeclaration("Child", KnownTypeTable[0x1e5]);
			KnownPropertyTable[0x5b] = new PropertyDeclaration("IsOpen", KnownTypeTable[0x1e5]);
			KnownPropertyTable[0x5c] = new PropertyDeclaration("Placement", KnownTypeTable[0x1e5]);
			KnownPropertyTable[0x5d] = new PropertyDeclaration("PopupAnimation", KnownTypeTable[0x1e5]);
			KnownPropertyTable[0x5e] = new PropertyDeclaration("Height", KnownTypeTable[0x21d]);
			KnownPropertyTable[0x5f] = new PropertyDeclaration("MaxHeight", KnownTypeTable[0x21d]);
			KnownPropertyTable[0x60] = new PropertyDeclaration("MinHeight", KnownTypeTable[0x21d]);
			KnownPropertyTable[0x61] = new PropertyDeclaration("CanContentScroll", KnownTypeTable[550]);
			KnownPropertyTable[0x62] = new PropertyDeclaration("HorizontalScrollBarVisibility", KnownTypeTable[550]);
			KnownPropertyTable[0x63] = new PropertyDeclaration("VerticalScrollBarVisibility", KnownTypeTable[550]);
			KnownPropertyTable[100] = new PropertyDeclaration("Fill", KnownTypeTable[0x22e]);
			KnownPropertyTable[0x65] = new PropertyDeclaration("Stroke", KnownTypeTable[0x22e]);
			KnownPropertyTable[0x66] = new PropertyDeclaration("StrokeThickness", KnownTypeTable[0x22e]);
			KnownPropertyTable[0x67] = new PropertyDeclaration("Background", KnownTypeTable[0x27e]);
			KnownPropertyTable[0x68] = new PropertyDeclaration("FontFamily", KnownTypeTable[0x27e]);
			KnownPropertyTable[0x69] = new PropertyDeclaration("FontSize", KnownTypeTable[0x27e]);
			KnownPropertyTable[0x6a] = new PropertyDeclaration("FontStretch", KnownTypeTable[0x27e]);
			KnownPropertyTable[0x6b] = new PropertyDeclaration("FontStyle", KnownTypeTable[0x27e]);
			KnownPropertyTable[0x6c] = new PropertyDeclaration("FontWeight", KnownTypeTable[0x27e]);
			KnownPropertyTable[0x6d] = new PropertyDeclaration("Foreground", KnownTypeTable[0x27e]);
			KnownPropertyTable[110] = new PropertyDeclaration("Text", KnownTypeTable[0x27e]);
			KnownPropertyTable[0x6f] = new PropertyDeclaration("TextDecorations", KnownTypeTable[0x27e]);
			KnownPropertyTable[0x70] = new PropertyDeclaration("TextTrimming", KnownTypeTable[0x27e]);
			KnownPropertyTable[0x71] = new PropertyDeclaration("TextWrapping", KnownTypeTable[0x27e]);
			KnownPropertyTable[0x72] = new PropertyDeclaration("Text", KnownTypeTable[0x27f]);
			KnownPropertyTable[0x73] = new PropertyDeclaration("Background", KnownTypeTable[0x288]);
			KnownPropertyTable[0x74] = new PropertyDeclaration("FontFamily", KnownTypeTable[0x288]);
			KnownPropertyTable[0x75] = new PropertyDeclaration("FontSize", KnownTypeTable[0x288]);
			KnownPropertyTable[0x76] = new PropertyDeclaration("FontStretch", KnownTypeTable[0x288]);
			KnownPropertyTable[0x77] = new PropertyDeclaration("FontStyle", KnownTypeTable[0x288]);
			KnownPropertyTable[120] = new PropertyDeclaration("FontWeight", KnownTypeTable[0x288]);
			KnownPropertyTable[0x79] = new PropertyDeclaration("Foreground", KnownTypeTable[0x288]);
			KnownPropertyTable[0x7a] = new PropertyDeclaration("Children", KnownTypeTable[0x29b]);
			KnownPropertyTable[0x7b] = new PropertyDeclaration("IsDirectionReversed", KnownTypeTable[0x2a3]);
			KnownPropertyTable[0x7c] = new PropertyDeclaration("Maximum", KnownTypeTable[0x2a3]);
			KnownPropertyTable[0x7d] = new PropertyDeclaration("Minimum", KnownTypeTable[0x2a3]);
			KnownPropertyTable[0x7e] = new PropertyDeclaration("Orientation", KnownTypeTable[0x2a3]);
			KnownPropertyTable[0x7f] = new PropertyDeclaration("Value", KnownTypeTable[0x2a3]);
			KnownPropertyTable[0x80] = new PropertyDeclaration("ViewportSize", KnownTypeTable[0x2a3]);
			KnownPropertyTable[0x81] = new PropertyDeclaration("Children", KnownTypeTable[0x2a7]);
			KnownPropertyTable[130] = new PropertyDeclaration("Children", KnownTypeTable[0x2aa]);
			KnownPropertyTable[0x83] = new PropertyDeclaration("ClipToBounds", KnownTypeTable[0x2b6]);
			KnownPropertyTable[0x84] = new PropertyDeclaration("Focusable", KnownTypeTable[0x2b6]);
			KnownPropertyTable[0x85] = new PropertyDeclaration("IsEnabled", KnownTypeTable[0x2b6]);
			KnownPropertyTable[0x86] = new PropertyDeclaration("RenderTransform", KnownTypeTable[0x2b6]);
			KnownPropertyTable[0x87] = new PropertyDeclaration("Visibility", KnownTypeTable[0x2b6]);
			KnownPropertyTable[0x88] = new PropertyDeclaration("Children", KnownTypeTable[0x2d9]);
			KnownPropertyTable[0x8a] = new PropertyDeclaration("Child", KnownTypeTable[2]);
			KnownPropertyTable[0x8b] = new PropertyDeclaration("Child", KnownTypeTable[4]);
			KnownPropertyTable[140] = new PropertyDeclaration("Blocks", KnownTypeTable[8]);
			KnownPropertyTable[0x8d] = new PropertyDeclaration("Items", KnownTypeTable[14]);
			KnownPropertyTable[0x8e] = new PropertyDeclaration("Child", KnownTypeTable[0x25]);
			KnownPropertyTable[0x8f] = new PropertyDeclaration("Inlines", KnownTypeTable[0x29]);
			KnownPropertyTable[0x90] = new PropertyDeclaration("KeyFrames", KnownTypeTable[0x2d]);
			KnownPropertyTable[0x91] = new PropertyDeclaration("Child", KnownTypeTable[50]);
			KnownPropertyTable[0x92] = new PropertyDeclaration("Child", KnownTypeTable[0x36]);
			KnownPropertyTable[0x93] = new PropertyDeclaration("Content", KnownTypeTable[0x37]);
			KnownPropertyTable[0x94] = new PropertyDeclaration("Content", KnownTypeTable[0x38]);
			KnownPropertyTable[0x95] = new PropertyDeclaration("KeyFrames", KnownTypeTable[60]);
			KnownPropertyTable[150] = new PropertyDeclaration("Children", KnownTypeTable[0x42]);
			KnownPropertyTable[0x97] = new PropertyDeclaration("KeyFrames", KnownTypeTable[0x45]);
			KnownPropertyTable[0x98] = new PropertyDeclaration("Content", KnownTypeTable[0x4a]);
			KnownPropertyTable[0x99] = new PropertyDeclaration("KeyFrames", KnownTypeTable[0x54]);
			KnownPropertyTable[0x9a] = new PropertyDeclaration("Items", KnownTypeTable[0x5c]);
			KnownPropertyTable[0x9b] = new PropertyDeclaration("Content", KnownTypeTable[0x5d]);
			KnownPropertyTable[0x9c] = new PropertyDeclaration("Items", KnownTypeTable[0x69]);
			KnownPropertyTable[0x9d] = new PropertyDeclaration("VisualTree", KnownTypeTable[0x6c]);
			KnownPropertyTable[0x9e] = new PropertyDeclaration("VisualTree", KnownTypeTable[120]);
			KnownPropertyTable[0x9f] = new PropertyDeclaration("Setters", KnownTypeTable[0x7a]);
			KnownPropertyTable[160] = new PropertyDeclaration("KeyFrames", KnownTypeTable[0x81]);
			KnownPropertyTable[0xa1] = new PropertyDeclaration("Child", KnownTypeTable[0x85]);
			KnownPropertyTable[0xa2] = new PropertyDeclaration("Children", KnownTypeTable[0xa3]);
			KnownPropertyTable[0xa3] = new PropertyDeclaration("Document", KnownTypeTable[0xa6]);
			KnownPropertyTable[0xa4] = new PropertyDeclaration("KeyFrames", KnownTypeTable[0xab]);
			KnownPropertyTable[0xa5] = new PropertyDeclaration("Actions", KnownTypeTable[0xc6]);
			KnownPropertyTable[0xa6] = new PropertyDeclaration("Content", KnownTypeTable[0xc7]);
			KnownPropertyTable[0xa7] = new PropertyDeclaration("Blocks", KnownTypeTable[0xca]);
			KnownPropertyTable[0xa8] = new PropertyDeclaration("Pages", KnownTypeTable[0xcd]);
			KnownPropertyTable[0xa9] = new PropertyDeclaration("References", KnownTypeTable[0xce]);
			KnownPropertyTable[170] = new PropertyDeclaration("Children", KnownTypeTable[0xcf]);
			KnownPropertyTable[0xab] = new PropertyDeclaration("Blocks", KnownTypeTable[0xd0]);
			KnownPropertyTable[0xac] = new PropertyDeclaration("Blocks", KnownTypeTable[0xd1]);
			KnownPropertyTable[0xad] = new PropertyDeclaration("Document", KnownTypeTable[210]);
			KnownPropertyTable[0xae] = new PropertyDeclaration("VisualTree", KnownTypeTable[0xe7]);
			KnownPropertyTable[0xaf] = new PropertyDeclaration("Children", KnownTypeTable[0xfe]);
			KnownPropertyTable[0xb0] = new PropertyDeclaration("Columns", KnownTypeTable[0x102]);
			KnownPropertyTable[0xb1] = new PropertyDeclaration("Content", KnownTypeTable[260]);
			KnownPropertyTable[0xb2] = new PropertyDeclaration("Content", KnownTypeTable[0x108]);
			KnownPropertyTable[0xb3] = new PropertyDeclaration("Content", KnownTypeTable[0x109]);
			KnownPropertyTable[180] = new PropertyDeclaration("Content", KnownTypeTable[0x10d]);
			KnownPropertyTable[0xb5] = new PropertyDeclaration("Items", KnownTypeTable[270]);
			KnownPropertyTable[0xb6] = new PropertyDeclaration("VisualTree", KnownTypeTable[0x10f]);
			KnownPropertyTable[0xb7] = new PropertyDeclaration("Inlines", KnownTypeTable[0x111]);
			KnownPropertyTable[0xb8] = new PropertyDeclaration("Children", KnownTypeTable[0x120]);
			KnownPropertyTable[0xb9] = new PropertyDeclaration("Child", KnownTypeTable[0x121]);
			KnownPropertyTable[0xba] = new PropertyDeclaration("Child", KnownTypeTable[0x124]);
			KnownPropertyTable[0xbb] = new PropertyDeclaration("NameValue", KnownTypeTable[300]);
			KnownPropertyTable[0xbc] = new PropertyDeclaration("KeyFrames", KnownTypeTable[0x131]);
			KnownPropertyTable[0xbd] = new PropertyDeclaration("KeyFrames", KnownTypeTable[0x138]);
			KnownPropertyTable[190] = new PropertyDeclaration("KeyFrames", KnownTypeTable[0x143]);
			KnownPropertyTable[0xbf] = new PropertyDeclaration("Inlines", KnownTypeTable[0x147]);
			KnownPropertyTable[0xc0] = new PropertyDeclaration("Items", KnownTypeTable[0x149]);
			KnownPropertyTable[0xc1] = new PropertyDeclaration("VisualTree", KnownTypeTable[330]);
			KnownPropertyTable[0xc2] = new PropertyDeclaration("Content", KnownTypeTable[0x15a]);
			KnownPropertyTable[0xc3] = new PropertyDeclaration("GradientStops", KnownTypeTable[0x166]);
			KnownPropertyTable[0xc4] = new PropertyDeclaration("ListItems", KnownTypeTable[0x174]);
			KnownPropertyTable[0xc5] = new PropertyDeclaration("Items", KnownTypeTable[0x175]);
			KnownPropertyTable[0xc6] = new PropertyDeclaration("Content", KnownTypeTable[0x176]);
			KnownPropertyTable[0xc7] = new PropertyDeclaration("Blocks", KnownTypeTable[0x178]);
			KnownPropertyTable[200] = new PropertyDeclaration("Items", KnownTypeTable[0x179]);
			KnownPropertyTable[0xc9] = new PropertyDeclaration("Content", KnownTypeTable[0x17a]);
			KnownPropertyTable[0xca] = new PropertyDeclaration("KeyFrames", KnownTypeTable[0x185]);
			KnownPropertyTable[0xcb] = new PropertyDeclaration("Items", KnownTypeTable[0x191]);
			KnownPropertyTable[0xcc] = new PropertyDeclaration("Items", KnownTypeTable[0x192]);
			KnownPropertyTable[0xcd] = new PropertyDeclaration("Items", KnownTypeTable[0x193]);
			KnownPropertyTable[0xce] = new PropertyDeclaration("Children", KnownTypeTable[0x199]);
			KnownPropertyTable[0xcf] = new PropertyDeclaration("Bindings", KnownTypeTable[0x1a0]);
			KnownPropertyTable[0xd0] = new PropertyDeclaration("Setters", KnownTypeTable[0x1a2]);
			KnownPropertyTable[0xd1] = new PropertyDeclaration("Setters", KnownTypeTable[0x1a3]);
			KnownPropertyTable[210] = new PropertyDeclaration("KeyFrames", KnownTypeTable[0x1ac]);
			KnownPropertyTable[0xd3] = new PropertyDeclaration("Child", KnownTypeTable[0x1b3]);
			KnownPropertyTable[0xd4] = new PropertyDeclaration("Content", KnownTypeTable[0x1b4]);
			KnownPropertyTable[0xd5] = new PropertyDeclaration("Children", KnownTypeTable[0x1b5]);
			KnownPropertyTable[0xd6] = new PropertyDeclaration("Inlines", KnownTypeTable[0x1b6]);
			KnownPropertyTable[0xd7] = new PropertyDeclaration("Children", KnownTypeTable[0x1b7]);
			KnownPropertyTable[0xd8] = new PropertyDeclaration("KeyFrames", KnownTypeTable[460]);
			KnownPropertyTable[0xd9] = new PropertyDeclaration("KeyFrames", KnownTypeTable[470]);
			KnownPropertyTable[0xda] = new PropertyDeclaration("Bindings", KnownTypeTable[0x1e7]);
			KnownPropertyTable[0xdb] = new PropertyDeclaration("KeyFrames", KnownTypeTable[0x1f1]);
			KnownPropertyTable[220] = new PropertyDeclaration("GradientStops", KnownTypeTable[0x1f6]);
			KnownPropertyTable[0xdd] = new PropertyDeclaration("Content", KnownTypeTable[0x1f7]);
			KnownPropertyTable[0xde] = new PropertyDeclaration("KeyFrames", KnownTypeTable[510]);
			KnownPropertyTable[0xdf] = new PropertyDeclaration("Content", KnownTypeTable[0x20a]);
			KnownPropertyTable[0xe0] = new PropertyDeclaration("Document", KnownTypeTable[0x20f]);
			KnownPropertyTable[0xe1] = new PropertyDeclaration("KeyFrames", KnownTypeTable[0x215]);
			KnownPropertyTable[0xe2] = new PropertyDeclaration("Text", KnownTypeTable[0x21e]);
			KnownPropertyTable[0xe3] = new PropertyDeclaration("Content", KnownTypeTable[550]);
			KnownPropertyTable[0xe4] = new PropertyDeclaration("Blocks", KnownTypeTable[0x227]);
			KnownPropertyTable[0xe5] = new PropertyDeclaration("Items", KnownTypeTable[0x229]);
			KnownPropertyTable[230] = new PropertyDeclaration("KeyFrames", KnownTypeTable[0x232]);
			KnownPropertyTable[0xe7] = new PropertyDeclaration("KeyFrames", KnownTypeTable[0x23b]);
			KnownPropertyTable[0xe8] = new PropertyDeclaration("Inlines", KnownTypeTable[580]);
			KnownPropertyTable[0xe9] = new PropertyDeclaration("Children", KnownTypeTable[0x259]);
			KnownPropertyTable[0xea] = new PropertyDeclaration("Items", KnownTypeTable[0x25c]);
			KnownPropertyTable[0xeb] = new PropertyDeclaration("Content", KnownTypeTable[0x25d]);
			KnownPropertyTable[0xec] = new PropertyDeclaration("Children", KnownTypeTable[0x260]);
			KnownPropertyTable[0xed] = new PropertyDeclaration("KeyFrames", KnownTypeTable[0x266]);
			KnownPropertyTable[0xee] = new PropertyDeclaration("Setters", KnownTypeTable[620]);
			KnownPropertyTable[0xef] = new PropertyDeclaration("Items", KnownTypeTable[0x26f]);
			KnownPropertyTable[240] = new PropertyDeclaration("Content", KnownTypeTable[0x270]);
			KnownPropertyTable[0xf1] = new PropertyDeclaration("Children", KnownTypeTable[0x271]);
			KnownPropertyTable[0xf2] = new PropertyDeclaration("RowGroups", KnownTypeTable[0x272]);
			KnownPropertyTable[0xf3] = new PropertyDeclaration("Blocks", KnownTypeTable[0x273]);
			KnownPropertyTable[0xf4] = new PropertyDeclaration("Cells", KnownTypeTable[0x275]);
			KnownPropertyTable[0xf5] = new PropertyDeclaration("Rows", KnownTypeTable[630]);
			KnownPropertyTable[0xf6] = new PropertyDeclaration("Inlines", KnownTypeTable[0x27e]);
			KnownPropertyTable[0xf7] = new PropertyDeclaration("KeyFrames", KnownTypeTable[0x28e]);
			KnownPropertyTable[0xf8] = new PropertyDeclaration("Content", KnownTypeTable[0x29c]);
			KnownPropertyTable[0xf9] = new PropertyDeclaration("Items", KnownTypeTable[0x29d]);
			KnownPropertyTable[250] = new PropertyDeclaration("Children", KnownTypeTable[670]);
			KnownPropertyTable[0xfb] = new PropertyDeclaration("Children", KnownTypeTable[0x29f]);
			KnownPropertyTable[0xfc] = new PropertyDeclaration("ToolBars", KnownTypeTable[0x2a0]);
			KnownPropertyTable[0xfd] = new PropertyDeclaration("Content", KnownTypeTable[0x2a1]);
			KnownPropertyTable[0xfe] = new PropertyDeclaration("Items", KnownTypeTable[0x2ae]);
			KnownPropertyTable[0xff] = new PropertyDeclaration("Items", KnownTypeTable[0x2af]);
			KnownPropertyTable[0x100] = new PropertyDeclaration("Setters", KnownTypeTable[0x2b0]);
			KnownPropertyTable[0x101] = new PropertyDeclaration("Inlines", KnownTypeTable[0x2be]);
			KnownPropertyTable[0x102] = new PropertyDeclaration("Children", KnownTypeTable[0x2bf]);
			KnownPropertyTable[0x103] = new PropertyDeclaration("Content", KnownTypeTable[0x2c2]);
			KnownPropertyTable[260] = new PropertyDeclaration("KeyFrames", KnownTypeTable[0x2c8]);
			KnownPropertyTable[0x105] = new PropertyDeclaration("KeyFrames", KnownTypeTable[720]);
			KnownPropertyTable[0x106] = new PropertyDeclaration("Child", KnownTypeTable[0x2d8]);
			KnownPropertyTable[0x107] = new PropertyDeclaration("Children", KnownTypeTable[730]);
			KnownPropertyTable[0x108] = new PropertyDeclaration("Children", KnownTypeTable[0x2db]);
			KnownPropertyTable[0x109] = new PropertyDeclaration("Children", KnownTypeTable[0x2dc]);
			KnownPropertyTable[0x10a] = new PropertyDeclaration("Content", KnownTypeTable[0x2e3]);
			KnownPropertyTable[0x10b] = new PropertyDeclaration("Children", KnownTypeTable[0x2e6]);
			KnownPropertyTable[0x10c] = new PropertyDeclaration("XmlSerializer", KnownTypeTable[0x2f2]);
			KnownResourceTable.Add(1, new ResourceName("SystemColors.ActiveBorderBrush"));
			KnownResourceTable.Add(0x1f, new ResourceName("SystemColors.ActiveBorderColor"));
			KnownResourceTable.Add(2, new ResourceName("SystemColors.ActiveCaptionBrush"));
			KnownResourceTable.Add(0x20, new ResourceName("SystemColors.ActiveCaptionColor"));
			KnownResourceTable.Add(3, new ResourceName("SystemColors.ActiveCaptionTextBrush"));
			KnownResourceTable.Add(0x21, new ResourceName("SystemColors.ActiveCaptionTextColor"));
			KnownResourceTable.Add(4, new ResourceName("SystemColors.AppWorkspaceBrush"));
			KnownResourceTable.Add(0x22, new ResourceName("SystemParameters.AppWorkspaceColor"));
			KnownResourceTable.Add(0xc6, new ResourceName("SystemParameters.Border"));
			KnownResourceTable.Add(0xca, new ResourceName("SystemParameters.BorderWidth"));
			KnownResourceTable.Add(0x40, new ResourceName("SystemFonts.CaptionFontFamily"));
			KnownResourceTable.Add(0x3f, new ResourceName("SystemFonts.CaptionFontSize"));
			KnownResourceTable.Add(0x41, new ResourceName("SystemFonts.CaptionFontStyle"));
			KnownResourceTable.Add(0x43, new ResourceName("SystemFonts.CaptionFontTextDecorations"));
			KnownResourceTable.Add(0x42, new ResourceName("SystemFonts.CaptionFontWeight"));
			KnownResourceTable.Add(0xce, new ResourceName("SystemParameters.CaptionHeight"));
			KnownResourceTable.Add(0xcd, new ResourceName("SystemParameters.CaptionWidth"));
			KnownResourceTable.Add(0xc7, new ResourceName("SystemParameters.CaretWidth"));
			KnownResourceTable.Add(0xba, new ResourceName("SystemParameters.ClientAreaAnimation"));
			KnownResourceTable.Add(0xb9, new ResourceName("SystemParameters.ComboBoxAnimation"));
			KnownResourceTable.Add(210, new ResourceName("SystemParameters.ComboBoxPopupAnimation"));
			KnownResourceTable.Add(5, new ResourceName("SystemColors.ControlBrush"));
			KnownResourceTable.Add(0x23, new ResourceName("SystemColors.ControlColor"));
			KnownResourceTable.Add(6, new ResourceName("SystemColors.ControlDarkBrush"));
			KnownResourceTable.Add(0x24, new ResourceName("SystemColors.ControlDarkColor"));
			KnownResourceTable.Add(7, new ResourceName("SystemColors.ControlDarkDarkBrush"));
			KnownResourceTable.Add(0x25, new ResourceName("SystemColors.ControlDarkDarkColor"));
			KnownResourceTable.Add(8, new ResourceName("SystemColors.ControlLightBrush"));
			KnownResourceTable.Add(0x26, new ResourceName("SystemColors.ControlLightColor"));
			KnownResourceTable.Add(9, new ResourceName("SystemColors.ControlLightLightBrush"));
			KnownResourceTable.Add(0x27, new ResourceName("SystemColors.ControlLightLightColor"));
			KnownResourceTable.Add(10, new ResourceName("SystemColors.ControlTextBrush"));
			KnownResourceTable.Add(40, new ResourceName("SystemColors.ControlTextColor"));
			KnownResourceTable.Add(0x62, new ResourceName("SystemParameters.CursorHeight"));
			KnownResourceTable.Add(0xbb, new ResourceName("SystemParameters.CursorShadow"));
			KnownResourceTable.Add(0x61, new ResourceName("SystemParameters.CursorWidth"));
			KnownResourceTable.Add(11, new ResourceName("SystemColors.DesktopBrush"));
			KnownResourceTable.Add(0x29, new ResourceName("SystemColors.DesktopColor"));
			KnownResourceTable.Add(0xc9, new ResourceName("SystemParameters.DragFullWindows"));
			KnownResourceTable.Add(0xa7, new ResourceName("SystemParameters.DropShadow"));
			KnownResourceTable.Add(0x65, new ResourceName("SystemParameters.FixedFrameHorizontalBorderHeight"));
			KnownResourceTable.Add(0x66, new ResourceName("SystemParameters.FixedFrameVerticalBorderWidth"));
			KnownResourceTable.Add(0xa8, new ResourceName("SystemParameters.FlatMenu"));
			KnownResourceTable.Add(0xa5, new ResourceName("SystemParameters.FocusBorderHeight"));
			KnownResourceTable.Add(0xa4, new ResourceName("SystemParameters.FocusBorderWidth"));
			KnownResourceTable.Add(0x67, new ResourceName("SystemParameters.FocusHorizontalBorderHeight"));
			KnownResourceTable.Add(0x68, new ResourceName("SystemParameters.FocusVerticalBorderWidth"));
			KnownResourceTable.Add(0xd7, new ResourceName("SystemParameters.FocusVisualStyle"));
			KnownResourceTable.Add(200, new ResourceName("SystemParameters.ForegroundFlashCount"));
			KnownResourceTable.Add(0x6a, new ResourceName("SystemParameters.FullPrimaryScreenHeight"));
			KnownResourceTable.Add(0x69, new ResourceName("SystemParameters.FullPrimaryScreenWidth"));
			KnownResourceTable.Add(12, new ResourceName("SystemColors.GradientActiveCaptionBrush"));
			KnownResourceTable.Add(0x2a, new ResourceName("SystemColors.GradientActiveCaptionColor"));
			KnownResourceTable.Add(0xbc, new ResourceName("SystemColors.GradientCaptions"));
			KnownResourceTable.Add(13, new ResourceName("SystemColors.GradientInactiveCaptionBrush"));
			KnownResourceTable.Add(0x2b, new ResourceName("SystemColors.GradientInactiveCaptionColor"));
			KnownResourceTable.Add(14, new ResourceName("SystemColors.GrayTextBrush"));
			KnownResourceTable.Add(0x2c, new ResourceName("SystemColors.GrayTextColor"));
			KnownResourceTable.Add(0xde, new ResourceName("GridView.GridViewItemContainerStyle"));
			KnownResourceTable.Add(220, new ResourceName("GridView.GridViewScrollViewerStyle"));
			KnownResourceTable.Add(0xdd, new ResourceName("GridView.GridViewStyle"));
			KnownResourceTable.Add(0xa6, new ResourceName("SystemParameters.HighContrast"));
			KnownResourceTable.Add(15, new ResourceName("SystemColors.HighlightBrush"));
			KnownResourceTable.Add(0x2d, new ResourceName("SystemColors.HighlightColor"));
			KnownResourceTable.Add(0x10, new ResourceName("SystemColors.HighlightTextBrush"));
			KnownResourceTable.Add(0x2e, new ResourceName("SystemColors.HighlightTextColor"));
			KnownResourceTable.Add(0x6b, new ResourceName("SystemParameters.HorizontalScrollBarButtonWidth"));
			KnownResourceTable.Add(0x6c, new ResourceName("SystemParameters.HorizontalScrollBarHeight"));
			KnownResourceTable.Add(0x6d, new ResourceName("SystemParameters.HorizontalScrollBarThumbWidth"));
			KnownResourceTable.Add(0x11, new ResourceName("SystemColors.HotTrackBrush"));
			KnownResourceTable.Add(0x2f, new ResourceName("SystemColors.HotTrackColor"));
			KnownResourceTable.Add(0xbd, new ResourceName("SystemParameters.HotTracking"));
			KnownResourceTable.Add(0x59, new ResourceName("SystemParameters.IconFontFamily"));
			KnownResourceTable.Add(0x58, new ResourceName("SystemParameters.IconFontSize"));
			KnownResourceTable.Add(90, new ResourceName("SystemParameters.IconFontStyle"));
			KnownResourceTable.Add(0x5c, new ResourceName("SystemParameters.IconFontTextDecorations"));
			KnownResourceTable.Add(0x5b, new ResourceName("SystemParameters.IconFontWeight"));
			KnownResourceTable.Add(0x71, new ResourceName("SystemParameters.IconGridHeight"));
			KnownResourceTable.Add(0x70, new ResourceName("SystemParameters.IconGridWidth"));
			KnownResourceTable.Add(0x6f, new ResourceName("SystemParameters.IconHeight"));
			KnownResourceTable.Add(170, new ResourceName("SystemParameters.IconHorizontalSpacing"));
			KnownResourceTable.Add(0xac, new ResourceName("SystemParameters.IconTitleWrap"));
			KnownResourceTable.Add(0xab, new ResourceName("SystemParameters.IconVerticalSpacing"));
			KnownResourceTable.Add(110, new ResourceName("SystemParameters.IconWidth"));
			KnownResourceTable.Add(0x12, new ResourceName("SystemColors.InactiveBorderBrush"));
			KnownResourceTable.Add(0x30, new ResourceName("SystemColors.InactiveBorderColor"));
			KnownResourceTable.Add(0x13, new ResourceName("SystemColors.InactiveCaptionBrush"));
			KnownResourceTable.Add(0x31, new ResourceName("SystemColors.InactiveCaptionColor"));
			KnownResourceTable.Add(20, new ResourceName("SystemColors.InactiveCaptionTextBrush"));
			KnownResourceTable.Add(50, new ResourceName("SystemColors.InactiveCaptionTextColor"));
			KnownResourceTable.Add(0x15, new ResourceName("SystemColors.InfoBrush"));
			KnownResourceTable.Add(0x33, new ResourceName("SystemColors.InfoColor"));
			KnownResourceTable.Add(0x16, new ResourceName("SystemColors.InfoTextBrush"));
			KnownResourceTable.Add(0x34, new ResourceName("SystemColors.InfoTextColor"));
			KnownResourceTable.Add(0x3d, new ResourceName("SystemColors.InternalSystemColorsEnd"));
			KnownResourceTable.Add(0, new ResourceName("InternalSystemColorsStart"));
			KnownResourceTable.Add(0x5d, new ResourceName("InternalSystemFontsEnd"));
			KnownResourceTable.Add(0x3e, new ResourceName("InternalSystemFontsStart"));
			KnownResourceTable.Add(0xda, new ResourceName("InternalSystemParametersEnd"));
			KnownResourceTable.Add(0x5e, new ResourceName("InternalSystemParametersStart"));
			KnownResourceTable.Add(0xe8, new ResourceName("InternalSystemThemeStylesEnd"));
			KnownResourceTable.Add(0xd6, new ResourceName("InternalSystemThemeStylesStart"));
			KnownResourceTable.Add(0x95, new ResourceName("SystemParameters.IsImmEnabled"));
			KnownResourceTable.Add(150, new ResourceName("SystemParameters.IsMediaCenter"));
			KnownResourceTable.Add(0x97, new ResourceName("SystemParameters.IsMenuDropRightAligned"));
			KnownResourceTable.Add(0x98, new ResourceName("SystemParameters.IsMiddleEastEnabled"));
			KnownResourceTable.Add(0x99, new ResourceName("SystemParameters.IsMousePresent"));
			KnownResourceTable.Add(0x9a, new ResourceName("SystemParameters.IsMouseWheelPresent"));
			KnownResourceTable.Add(0x9b, new ResourceName("SystemParameters.IsPenWindows"));
			KnownResourceTable.Add(0x9c, new ResourceName("SystemParameters.IsRemotelyControlled"));
			KnownResourceTable.Add(0x9d, new ResourceName("SystemParameters.IsRemoteSession"));
			KnownResourceTable.Add(0x9f, new ResourceName("SystemParameters.IsSlowMachine"));
			KnownResourceTable.Add(0xa1, new ResourceName("SystemParameters.IsTabletPC"));
			KnownResourceTable.Add(0x91, new ResourceName("SystemParameters.KanjiWindowHeight"));
			KnownResourceTable.Add(0xad, new ResourceName("SystemParameters.KeyboardCues"));
			KnownResourceTable.Add(0xae, new ResourceName("SystemParameters.KeyboardDelay"));
			KnownResourceTable.Add(0xaf, new ResourceName("SystemParameters.KeyboardPreference"));
			KnownResourceTable.Add(0xb0, new ResourceName("SystemParameters.KeyboardSpeed"));
			KnownResourceTable.Add(190, new ResourceName("SystemParameters.ListBoxSmoothScrolling"));
			KnownResourceTable.Add(0x73, new ResourceName("SystemParameters.MaximizedPrimaryScreenHeight"));
			KnownResourceTable.Add(0x72, new ResourceName("SystemParameters.MaximizedPrimaryScreenWidth"));
			KnownResourceTable.Add(0x75, new ResourceName("SystemParameters.MaximumWindowTrackHeight"));
			KnownResourceTable.Add(0x74, new ResourceName("SystemParameters.MaximumWindowTrackWidth"));
			KnownResourceTable.Add(0xbf, new ResourceName("SystemParameters.MenuAnimation"));
			KnownResourceTable.Add(0x18, new ResourceName("SystemColors.MenuBarBrush"));
			KnownResourceTable.Add(0x36, new ResourceName("SystemColors.MenuBarColor"));
			KnownResourceTable.Add(0x92, new ResourceName("SystemParameters.MenuBarHeight"));
			KnownResourceTable.Add(0x17, new ResourceName("SystemColors.MenuBrush"));
			KnownResourceTable.Add(0x79, new ResourceName("SystemParameters.MenuButtonHeight"));
			KnownResourceTable.Add(120, new ResourceName("SystemParameters.MenuButtonWidth"));
			KnownResourceTable.Add(0x77, new ResourceName("SystemParameters.MenuCheckmarkHeight"));
			KnownResourceTable.Add(0x76, new ResourceName("SystemParameters.MenuCheckmarkWidth"));
			KnownResourceTable.Add(0x35, new ResourceName("SystemColors.MenuColor"));
			KnownResourceTable.Add(0xb6, new ResourceName("SystemParameters.MenuDropAlignment"));
			KnownResourceTable.Add(0xb7, new ResourceName("SystemParameters.MenuFade"));
			KnownResourceTable.Add(0x4a, new ResourceName("SystemFonts.MenuFontFamily"));
			KnownResourceTable.Add(0x49, new ResourceName("SystemFonts.MenuFontSize"));
			KnownResourceTable.Add(0x4b, new ResourceName("SystemFonts.MenuFontStyle"));
			KnownResourceTable.Add(0x4d, new ResourceName("SystemFonts.MenuFontTextDecorations"));
			KnownResourceTable.Add(0x4c, new ResourceName("SystemFonts.MenuFontWeight"));
			KnownResourceTable.Add(0xd1, new ResourceName("SystemParameters.MenuHeight"));
			KnownResourceTable.Add(0x19, new ResourceName("SystemColors.MenuHighlightBrush"));
			KnownResourceTable.Add(0x37, new ResourceName("SystemColors.MenuHighlightColor"));
			KnownResourceTable.Add(0xdb, new ResourceName("MenuItem.MenuItemSeparatorStyle"));
			KnownResourceTable.Add(0xd3, new ResourceName("SystemParameters.MenuPopupAnimation"));
			KnownResourceTable.Add(0xb8, new ResourceName("SystemParameters.MenuShowDelay"));
			KnownResourceTable.Add(0x1a, new ResourceName("SystemColors.MenuTextBrush"));
			KnownResourceTable.Add(0x38, new ResourceName("SystemColors.MenuTextColor"));
			KnownResourceTable.Add(0xd0, new ResourceName("SystemParameters.MenuWidth"));
			KnownResourceTable.Add(0x54, new ResourceName("SystemFonts.MessageFontFamily"));
			KnownResourceTable.Add(0x53, new ResourceName("SystemFonts..MessageFontSize"));
			KnownResourceTable.Add(0x55, new ResourceName("SystemFonts.MessageFontStyle"));
			KnownResourceTable.Add(0x57, new ResourceName("SystemFonts.MessageFontTextDecorations"));
			KnownResourceTable.Add(0x56, new ResourceName("SystemFonts.MessageFontWeight"));
			KnownResourceTable.Add(0xc5, new ResourceName("SystemParameters.MinimizeAnimation"));
			KnownResourceTable.Add(0x7f, new ResourceName("SystemParameters.MinimizedGridHeight"));
			KnownResourceTable.Add(0x7e, new ResourceName("SystemParameters.MinimizedGridWidth"));
			KnownResourceTable.Add(0x7d, new ResourceName("SystemParameters.MinimizedWindowHeight"));
			KnownResourceTable.Add(0x7c, new ResourceName("SystemParameters.MinimizedWindowWidth"));
			KnownResourceTable.Add(0x7b, new ResourceName("SystemParameters.MinimumWindowHeight"));
			KnownResourceTable.Add(0x81, new ResourceName("SystemParameters.MinimumWindowTrackHeight"));
			KnownResourceTable.Add(0x80, new ResourceName("SystemParameters.MinimumWindowTrackWidth"));
			KnownResourceTable.Add(0x7a, new ResourceName("SystemParameters.MinimumWindowWidth"));
			KnownResourceTable.Add(180, new ResourceName("SystemParameters.MouseHoverHeight"));
			KnownResourceTable.Add(0xb3, new ResourceName("SystemParameters.MouseHoverTime"));
			KnownResourceTable.Add(0xb5, new ResourceName("SystemParameters.MouseHoverWidth"));
			KnownResourceTable.Add(0xd8, new ResourceName("SystemParameters.NavigationChromeDownLevelStyle"));
			KnownResourceTable.Add(0xd9, new ResourceName("SystemParameters.NavigationChromeStyle"));
			KnownResourceTable.Add(0xd5, new ResourceName("SystemParameters.PowerLineStatus"));
			KnownResourceTable.Add(0x83, new ResourceName("SystemParameters.PrimaryScreenHeight"));
			KnownResourceTable.Add(130, new ResourceName("SystemParameters.PrimaryScreenWidth"));
			KnownResourceTable.Add(0x86, new ResourceName("SystemParameters.ResizeFrameHorizontalBorderHeight"));
			KnownResourceTable.Add(0x87, new ResourceName("SystemParameters.ResizeFrameVerticalBorderWidth"));
			KnownResourceTable.Add(0x1b, new ResourceName("SystemColors.ScrollBarBrush"));
			KnownResourceTable.Add(0x39, new ResourceName("SystemColors.ScrollBarColor"));
			KnownResourceTable.Add(0xcc, new ResourceName("SystemParameters.ScrollHeight"));
			KnownResourceTable.Add(0xcb, new ResourceName("SystemParameters.ScrollWidth"));
			KnownResourceTable.Add(0xc0, new ResourceName("SystemParameters.SelectionFade"));
			KnownResourceTable.Add(0x9e, new ResourceName("SystemParameters.ShowSounds"));
			KnownResourceTable.Add(0x45, new ResourceName("SystemFonts.SmallCaptionFontFamily"));
			KnownResourceTable.Add(0x44, new ResourceName("SystemFonts.SmallCaptionFontSize"));
			KnownResourceTable.Add(70, new ResourceName("SystemFonts.SmallCaptionFontStyle"));
			KnownResourceTable.Add(0x48, new ResourceName("SystemFonts.SmallCaptionFontTextDecorations"));
			KnownResourceTable.Add(0x47, new ResourceName("SystemFonts.SmallCaptionFontWeight"));
			KnownResourceTable.Add(0x93, new ResourceName("SystemParameters.SmallCaptionHeight"));
			KnownResourceTable.Add(0xcf, new ResourceName("SystemParameters.SmallCaptionWidth"));
			KnownResourceTable.Add(0x89, new ResourceName("SystemParameters.SmallIconHeight"));
			KnownResourceTable.Add(0x88, new ResourceName("SystemParameters.SmallIconWidth"));
			KnownResourceTable.Add(0x8b, new ResourceName("SystemParameters.SmallWindowCaptionButtonHeight"));
			KnownResourceTable.Add(0x8a, new ResourceName("SystemParameters.SmallWindowCaptionButtonWidth"));
			KnownResourceTable.Add(0xb1, new ResourceName("SystemParameters.SnapToDefaultButton"));
			KnownResourceTable.Add(0xdf, new ResourceName("StatusBar.StatusBarSeparatorStyle"));
			KnownResourceTable.Add(0x4f, new ResourceName("SystemFonts.StatusFontFamily"));
			KnownResourceTable.Add(0x4e, new ResourceName("SystemFonts.StatusFontSize"));
			KnownResourceTable.Add(80, new ResourceName("SystemFonts.StatusFontStyle"));
			KnownResourceTable.Add(0x52, new ResourceName("SystemFonts.StatusFontTextDecorations"));
			KnownResourceTable.Add(0x51, new ResourceName("SystemFonts.StatusFontWeight"));
			KnownResourceTable.Add(0xc1, new ResourceName("SystemParameters.StylusHotTracking"));
			KnownResourceTable.Add(160, new ResourceName("SystemParameters.SwapButtons"));
			KnownResourceTable.Add(0x63, new ResourceName("SystemParameters.ThickHorizontalBorderHeight"));
			KnownResourceTable.Add(100, new ResourceName("SystemParameters.ThickVerticalBorderWidth"));
			KnownResourceTable.Add(0x5f, new ResourceName("SystemParameters.ThinHorizontalBorderHeight"));
			KnownResourceTable.Add(0x60, new ResourceName("SystemParameters.ThinVerticalBorderWidth"));
			KnownResourceTable.Add(0xe0, new ResourceName("ToolBar.ButtonStyle"));
			KnownResourceTable.Add(0xe3, new ResourceName("ToolBar.CheckBoxStyle"));
			KnownResourceTable.Add(0xe5, new ResourceName("ToolBar.ComboBoxStyle"));
			KnownResourceTable.Add(0xe7, new ResourceName("ToolBar.MenuStyle"));
			KnownResourceTable.Add(0xe4, new ResourceName("ToolBar.RadioButtonStyle"));
			KnownResourceTable.Add(0xe2, new ResourceName("ToolBar.SeparatorStyle"));
			KnownResourceTable.Add(230, new ResourceName("ToolBar.TextBoxStyle"));
			KnownResourceTable.Add(0xe1, new ResourceName("ToolBar.ToggleButtonStyle"));
			KnownResourceTable.Add(0xc2, new ResourceName("SystemParameters.ToolTipAnimation"));
			KnownResourceTable.Add(0xc3, new ResourceName("SystemParameters.ToolTipFade"));
			KnownResourceTable.Add(0xd4, new ResourceName("SystemParameters.ToolTipPopupAnimation"));
			KnownResourceTable.Add(0xc4, new ResourceName("SystemParameters.UIEffects"));
			KnownResourceTable.Add(0x8f, new ResourceName("SystemParameters.VerticalScrollBarButtonHeight"));
			KnownResourceTable.Add(0x94, new ResourceName("SystemParameters.VerticalScrollBarThumbHeight"));
			KnownResourceTable.Add(0x8e, new ResourceName("SystemParameters.VerticalScrollBarWidth"));
			KnownResourceTable.Add(0x8d, new ResourceName("SystemParameters.VirtualScreenHeight"));
			KnownResourceTable.Add(0xa2, new ResourceName("SystemParameters.VirtualScreenLeft"));
			KnownResourceTable.Add(0xa3, new ResourceName("SystemParameters.VirtualScreenTop"));
			KnownResourceTable.Add(140, new ResourceName("SystemParameters.VirtualScreenWidth"));
			KnownResourceTable.Add(0xb2, new ResourceName("SystemParameters.WheelScrollLines"));
			KnownResourceTable.Add(0x1c, new ResourceName("SystemColors.WindowBrush"));
			KnownResourceTable.Add(0x85, new ResourceName("SystemParameters.WindowCaptionButtonHeight"));
			KnownResourceTable.Add(0x84, new ResourceName("SystemParameters.WindowCaptionButtonWidth"));
			KnownResourceTable.Add(0x90, new ResourceName("SystemParameters.WindowCaptionHeight"));
			KnownResourceTable.Add(0x3a, new ResourceName("SystemColors.WindowColor"));
			KnownResourceTable.Add(0x1d, new ResourceName("SystemColors.WindowFrameBrush"));
			KnownResourceTable.Add(0x3b, new ResourceName("SystemColors.WindowFrameColor"));
			KnownResourceTable.Add(30, new ResourceName("SystemColors.WindowTextBrush"));
			KnownResourceTable.Add(60, new ResourceName("SystemColors.WindowTextColor"));
			KnownResourceTable.Add(0xa9, new ResourceName("SystemParameters.WorkArea"));
		}

		void LoadKnownAssemblies30()
		{
			KnownAssemblyTable = new string[5];
			KnownAssemblyTable[0] = "PresentationFramework, Version=3.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35";
			KnownAssemblyTable[1] = "PresentationCore, Version=3.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35";
			KnownAssemblyTable[2] = "mscorlib, Version=2.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089";
			KnownAssemblyTable[3] = "System, Version=2.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089";
			KnownAssemblyTable[4] = "WindowBase, Version=3.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35";
		}
		
		void LoadKnownAssemblies40()
		{
			KnownAssemblyTable = new string[5];
			KnownAssemblyTable[0] = "PresentationFramework, Version=4.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35";
			KnownAssemblyTable[1] = "PresentationCore, Version=4.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35";
			KnownAssemblyTable[2] = "mscorlib, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089";
			KnownAssemblyTable[3] = "System, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089";
			KnownAssemblyTable[4] = "WindowBase, Version=4.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35";
		}

		#endregion

		public bool IsKnownType(string type)
		{
			foreach (TypeDeclaration td in KnownTypeTable)
				if (String.CompareOrdinal(td.Name, type) == 0)
					return true;

			return false;
		}
	}
}
