// created by jay 0.7 (c) 1998 Axel.Schreiner@informatik.uni-osnabrueck.de

#line 2 "cs-parser.jay"
//
// cs-parser.jay: The Parser for the C# compiler
//
// Authors: Miguel de Icaza (miguel@gnome.org)
//          Ravi Pratap     (ravi@ximian.com)
//          Marek Safar	    (marek.safar@gmail.com)
//
// Dual Licensed under the terms of the GNU GPL and the MIT X11 license
//
// (C) 2001 Ximian, Inc (http://www.ximian.com)
// (C) 2004-2011 Novell, Inc
// Copyright 2011-2012 Xamarin Inc.
//

using System.Text;
using System.IO;
using System;
using System.Collections.Generic;

namespace Mono.CSharp
{
	/// <summary>
	///    The C# Parser
	/// </summary>
	public class CSharpParser
	{
		[Flags]
		enum ParameterModifierType
		{
			Ref		= 1 << 1,
			Out		= 1 << 2,
			This	= 1 << 3,
			Params	= 1 << 4,
			Arglist	= 1 << 5,
			DefaultValue = 1 << 6,
			
			All = Ref | Out | This | Params | Arglist | DefaultValue
		}
		
		static readonly object ModifierNone = 0;
	
		NamespaceContainer current_namespace;
		TypeContainer current_container;
		TypeDefinition current_type;
		PropertyBase current_property;
		EventProperty current_event;
		EventField current_event_field;
		FieldBase current_field;
	
		/// <summary>
		///   Current block is used to add statements as we find
		///   them.  
		/// </summary>
		Block      current_block;
		
		BlockVariableDeclaration current_variable;

		Delegate   current_delegate;
		
		AnonymousMethodExpression current_anonymous_method;

		/// <summary>
		///   This is used by the unary_expression code to resolve
		///   a name against a parameter.  
		/// </summary>
		
		// FIXME: This is very ugly and it's very hard to reset it correctly
		// on all places, especially when some parameters are autogenerated.
		ParametersCompiled current_local_parameters;

		bool parsing_anonymous_method;
		
		bool async_block;

		///
		/// An out-of-band stack.
		///
		Stack<object> oob_stack;

		///
		/// Controls the verbosity of the errors produced by the parser
		///
		int yacc_verbose_flag;

		/// 
		/// Used by the interactive shell, flags whether EOF was reached
		/// and an error was produced
		///
		public bool UnexpectedEOF;

		///
		/// The current file.
		///
		readonly CompilationSourceFile file;

		///
		/// Temporary Xml documentation cache.
		/// For enum types, we need one more temporary store.
		///
		string tmpComment;
		string enumTypeComment;
	       		
		/// Current attribute target
		string current_attr_target;
		
		ParameterModifierType valid_param_mod;
		
		bool default_parameter_used;

		/// When using the interactive parser, this holds the
		/// resulting expression
		public Class InteractiveResult;

		//
		// Keeps track of global data changes to undo on parser error
		//
		public Undo undo;
		
		Stack<Linq.QueryBlock> linq_clause_blocks;

		ModuleContainer module;
		
		readonly CompilerContext compiler;
		readonly LanguageVersion lang_version;
		readonly bool doc_support;
		readonly CompilerSettings settings;
		readonly Report report;
		
		//
		// Instead of allocating carrier array everytime we
		// share the bucket for very common constructs which can never
		// be recursive
		//
		List<Parameter> parameters_bucket;
		
		//
		// Full AST support members
		//
		readonly LocationsBag lbag;

		public LocationsBag LocationsBag {
			get {
				return lbag;
			}
		}

		List<Tuple<Modifiers, Location>> mod_locations;
		Location parameterModifierLocation, savedLocation, savedOpenLocation, savedCloseLocation;
		Location savedAttrParenOpenLocation, savedAttrParenCloseLocation, savedOperatorLocation;
		Stack<List<Location>> locationListStack = new Stack<List<Location>> (); // used for type parameters
		Stack<Location> opt_intoStack = new Stack<Location> ();

		bool HadAttributeParens;
		List<Location> attributeCommas = new List<Location> ();
		List<Location> attributeArgumentCommas = new List<Location> ();
		List<Location> parameterListCommas = new List<Location> ();
#line default

  /** error output stream.
      It should be changeable.
    */
  public System.IO.TextWriter ErrorOutput = System.Console.Out;

  /** simplified error message.
      @see <a href="#yyerror(java.lang.String, java.lang.String[])">yyerror</a>
    */
  public void yyerror (string message) {
    yyerror(message, null);
  }
#pragma warning disable 649
  /* An EOF token */
  public int eof_token;
#pragma warning restore 649
  /** (syntax) error message.
      Can be overwritten to control message format.
      @param message text to be displayed.
      @param expected vector of acceptable tokens, if available.
    */
  public void yyerror (string message, string[] expected) {
    if ((yacc_verbose_flag > 0) && (expected != null) && (expected.Length  > 0)) {
      ErrorOutput.Write (message+", expecting");
      for (int n = 0; n < expected.Length; ++ n)
        ErrorOutput.Write (" "+expected[n]);
        ErrorOutput.WriteLine ();
    } else
      ErrorOutput.WriteLine (message);
  }

  /** debugging support, requires the package jay.yydebug.
      Set to null to suppress debugging messages.
    */
//t  internal yydebug.yyDebug debug;

  protected const int yyFinal = 7;
//t // Put this array into a separate class so it is only initialized if debugging is actually used
//t // Use MarshalByRefObject to disable inlining
//t class YYRules : MarshalByRefObject {
//t  public static readonly string [] yyRule = {
//t    "$accept : compilation_unit",
//t    "compilation_unit : outer_declaration opt_EOF",
//t    "$$1 :",
//t    "compilation_unit : interactive_parsing $$1 opt_EOF",
//t    "compilation_unit : documentation_parsing",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives namespace_or_type_declarations opt_attributes",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives attribute_sections",
//t    "outer_declaration : error",
//t    "opt_EOF :",
//t    "opt_EOF : EOF",
//t    "extern_alias_directives : extern_alias_directive",
//t    "extern_alias_directives : extern_alias_directives extern_alias_directive",
//t    "extern_alias_directive : EXTERN_ALIAS IDENTIFIER IDENTIFIER SEMICOLON",
//t    "extern_alias_directive : EXTERN_ALIAS error",
//t    "using_directives : using_directive",
//t    "using_directives : using_directives using_directive",
//t    "using_directive : using_namespace",
//t    "using_namespace : USING namespace_or_type_expr SEMICOLON",
//t    "using_namespace : USING IDENTIFIER ASSIGN namespace_or_type_expr SEMICOLON",
//t    "using_namespace : USING error",
//t    "$$2 :",
//t    "$$3 :",
//t    "namespace_declaration : opt_attributes NAMESPACE namespace_name $$2 OPEN_BRACE $$3 opt_extern_alias_directives opt_using_directives opt_namespace_or_type_declarations CLOSE_BRACE opt_semicolon",
//t    "namespace_name : IDENTIFIER",
//t    "namespace_name : namespace_name DOT IDENTIFIER",
//t    "namespace_name : error",
//t    "opt_semicolon :",
//t    "opt_semicolon : SEMICOLON",
//t    "opt_comma :",
//t    "opt_comma : COMMA",
//t    "opt_using_directives :",
//t    "opt_using_directives : using_directives",
//t    "opt_extern_alias_directives :",
//t    "opt_extern_alias_directives : extern_alias_directives",
//t    "opt_namespace_or_type_declarations :",
//t    "opt_namespace_or_type_declarations : namespace_or_type_declarations",
//t    "namespace_or_type_declarations : namespace_or_type_declaration",
//t    "namespace_or_type_declarations : namespace_or_type_declarations namespace_or_type_declaration",
//t    "namespace_or_type_declaration : type_declaration",
//t    "namespace_or_type_declaration : namespace_declaration",
//t    "namespace_or_type_declaration : attribute_sections CLOSE_BRACE",
//t    "type_declaration : class_declaration",
//t    "type_declaration : struct_declaration",
//t    "type_declaration : interface_declaration",
//t    "type_declaration : enum_declaration",
//t    "type_declaration : delegate_declaration",
//t    "opt_attributes :",
//t    "opt_attributes : attribute_sections",
//t    "attribute_sections : attribute_section",
//t    "attribute_sections : attribute_sections attribute_section",
//t    "$$4 :",
//t    "attribute_section : OPEN_BRACKET $$4 attribute_section_cont",
//t    "$$5 :",
//t    "attribute_section_cont : attribute_target COLON $$5 attribute_list opt_comma CLOSE_BRACKET",
//t    "attribute_section_cont : attribute_list opt_comma CLOSE_BRACKET",
//t    "attribute_target : IDENTIFIER",
//t    "attribute_target : EVENT",
//t    "attribute_target : RETURN",
//t    "attribute_target : error",
//t    "attribute_list : attribute",
//t    "attribute_list : attribute_list COMMA attribute",
//t    "$$6 :",
//t    "attribute : attribute_name $$6 opt_attribute_arguments",
//t    "attribute_name : namespace_or_type_expr",
//t    "opt_attribute_arguments :",
//t    "opt_attribute_arguments : OPEN_PARENS attribute_arguments CLOSE_PARENS",
//t    "attribute_arguments :",
//t    "attribute_arguments : positional_or_named_argument",
//t    "attribute_arguments : named_attribute_argument",
//t    "attribute_arguments : attribute_arguments COMMA positional_or_named_argument",
//t    "attribute_arguments : attribute_arguments COMMA named_attribute_argument",
//t    "positional_or_named_argument : expression",
//t    "positional_or_named_argument : named_argument",
//t    "$$7 :",
//t    "named_attribute_argument : IDENTIFIER ASSIGN $$7 expression",
//t    "named_argument : identifier_inside_body COLON opt_named_modifier expression",
//t    "opt_named_modifier :",
//t    "opt_named_modifier : REF",
//t    "opt_named_modifier : OUT",
//t    "opt_class_member_declarations :",
//t    "opt_class_member_declarations : class_member_declarations",
//t    "class_member_declarations : class_member_declaration",
//t    "class_member_declarations : class_member_declarations class_member_declaration",
//t    "class_member_declaration : constant_declaration",
//t    "class_member_declaration : field_declaration",
//t    "class_member_declaration : method_declaration",
//t    "class_member_declaration : property_declaration",
//t    "class_member_declaration : event_declaration",
//t    "class_member_declaration : indexer_declaration",
//t    "class_member_declaration : operator_declaration",
//t    "class_member_declaration : constructor_declaration",
//t    "class_member_declaration : destructor_declaration",
//t    "class_member_declaration : type_declaration",
//t    "class_member_declaration : attributes_without_members",
//t    "class_member_declaration : error",
//t    "$$8 :",
//t    "$$9 :",
//t    "$$10 :",
//t    "$$11 :",
//t    "$$12 :",
//t    "struct_declaration : opt_attributes opt_modifiers opt_partial STRUCT $$8 type_declaration_name $$9 opt_class_base opt_type_parameter_constraints_clauses $$10 OPEN_BRACE $$11 opt_class_member_declarations CLOSE_BRACE $$12 opt_semicolon",
//t    "struct_declaration : opt_attributes opt_modifiers opt_partial STRUCT error",
//t    "$$13 :",
//t    "constant_declaration : opt_attributes opt_modifiers CONST type IDENTIFIER $$13 constant_initializer opt_constant_declarators SEMICOLON",
//t    "opt_constant_declarators :",
//t    "opt_constant_declarators : constant_declarators",
//t    "constant_declarators : constant_declarator",
//t    "constant_declarators : constant_declarators constant_declarator",
//t    "constant_declarator : COMMA IDENTIFIER constant_initializer",
//t    "$$14 :",
//t    "constant_initializer : ASSIGN $$14 constant_initializer_expr",
//t    "constant_initializer : error",
//t    "constant_initializer_expr : constant_expression",
//t    "constant_initializer_expr : array_initializer",
//t    "$$15 :",
//t    "field_declaration : opt_attributes opt_modifiers member_type IDENTIFIER $$15 opt_field_initializer opt_field_declarators SEMICOLON",
//t    "$$16 :",
//t    "field_declaration : opt_attributes opt_modifiers FIXED simple_type IDENTIFIER $$16 fixed_field_size opt_fixed_field_declarators SEMICOLON",
//t    "field_declaration : opt_attributes opt_modifiers FIXED simple_type error SEMICOLON",
//t    "opt_field_initializer :",
//t    "$$17 :",
//t    "opt_field_initializer : ASSIGN $$17 variable_initializer",
//t    "opt_field_declarators :",
//t    "opt_field_declarators : field_declarators",
//t    "field_declarators : field_declarator",
//t    "field_declarators : field_declarators field_declarator",
//t    "field_declarator : COMMA IDENTIFIER",
//t    "$$18 :",
//t    "field_declarator : COMMA IDENTIFIER ASSIGN $$18 variable_initializer",
//t    "opt_fixed_field_declarators :",
//t    "opt_fixed_field_declarators : fixed_field_declarators",
//t    "fixed_field_declarators : fixed_field_declarator",
//t    "fixed_field_declarators : fixed_field_declarators fixed_field_declarator",
//t    "fixed_field_declarator : COMMA IDENTIFIER fixed_field_size",
//t    "$$19 :",
//t    "fixed_field_size : OPEN_BRACKET $$19 expression CLOSE_BRACKET",
//t    "fixed_field_size : OPEN_BRACKET error",
//t    "variable_initializer : expression",
//t    "variable_initializer : array_initializer",
//t    "variable_initializer : error",
//t    "$$20 :",
//t    "method_declaration : method_header $$20 method_body",
//t    "$$21 :",
//t    "$$22 :",
//t    "method_header : opt_attributes opt_modifiers member_type method_declaration_name OPEN_PARENS $$21 opt_formal_parameter_list CLOSE_PARENS $$22 opt_type_parameter_constraints_clauses",
//t    "$$23 :",
//t    "$$24 :",
//t    "$$25 :",
//t    "method_header : opt_attributes opt_modifiers PARTIAL VOID $$23 method_declaration_name OPEN_PARENS $$24 opt_formal_parameter_list CLOSE_PARENS $$25 opt_type_parameter_constraints_clauses",
//t    "method_header : opt_attributes opt_modifiers member_type modifiers method_declaration_name OPEN_PARENS opt_formal_parameter_list CLOSE_PARENS",
//t    "method_header : opt_attributes opt_modifiers member_type method_declaration_name error",
//t    "method_body : block",
//t    "method_body : SEMICOLON",
//t    "opt_formal_parameter_list :",
//t    "opt_formal_parameter_list : formal_parameter_list",
//t    "formal_parameter_list : fixed_parameters",
//t    "formal_parameter_list : fixed_parameters COMMA parameter_array",
//t    "formal_parameter_list : fixed_parameters COMMA arglist_modifier",
//t    "formal_parameter_list : parameter_array COMMA error",
//t    "formal_parameter_list : fixed_parameters COMMA parameter_array COMMA error",
//t    "formal_parameter_list : arglist_modifier COMMA error",
//t    "formal_parameter_list : fixed_parameters COMMA ARGLIST COMMA error",
//t    "formal_parameter_list : parameter_array",
//t    "formal_parameter_list : arglist_modifier",
//t    "formal_parameter_list : error",
//t    "fixed_parameters : fixed_parameter",
//t    "fixed_parameters : fixed_parameters COMMA fixed_parameter",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type IDENTIFIER",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type IDENTIFIER OPEN_BRACKET CLOSE_BRACKET",
//t    "fixed_parameter : attribute_sections error",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type error",
//t    "$$26 :",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type IDENTIFIER ASSIGN $$26 constant_expression",
//t    "opt_parameter_modifier :",
//t    "opt_parameter_modifier : parameter_modifiers",
//t    "parameter_modifiers : parameter_modifier",
//t    "parameter_modifiers : parameter_modifiers parameter_modifier",
//t    "parameter_modifier : REF",
//t    "parameter_modifier : OUT",
//t    "parameter_modifier : THIS",
//t    "parameter_array : opt_attributes params_modifier type IDENTIFIER",
//t    "parameter_array : opt_attributes params_modifier type IDENTIFIER ASSIGN constant_expression",
//t    "parameter_array : opt_attributes params_modifier type error",
//t    "params_modifier : PARAMS",
//t    "params_modifier : PARAMS parameter_modifier",
//t    "params_modifier : PARAMS params_modifier",
//t    "arglist_modifier : ARGLIST",
//t    "$$27 :",
//t    "$$28 :",
//t    "$$29 :",
//t    "property_declaration : opt_attributes opt_modifiers member_type member_declaration_name $$27 OPEN_BRACE $$28 accessor_declarations $$29 CLOSE_BRACE",
//t    "$$30 :",
//t    "$$31 :",
//t    "$$32 :",
//t    "indexer_declaration : opt_attributes opt_modifiers member_type indexer_declaration_name OPEN_BRACKET $$30 opt_formal_parameter_list CLOSE_BRACKET OPEN_BRACE $$31 accessor_declarations $$32 CLOSE_BRACE",
//t    "accessor_declarations : get_accessor_declaration",
//t    "accessor_declarations : get_accessor_declaration accessor_declarations",
//t    "accessor_declarations : set_accessor_declaration",
//t    "accessor_declarations : set_accessor_declaration accessor_declarations",
//t    "accessor_declarations : error",
//t    "$$33 :",
//t    "get_accessor_declaration : opt_attributes opt_modifiers GET $$33 accessor_body",
//t    "$$34 :",
//t    "set_accessor_declaration : opt_attributes opt_modifiers SET $$34 accessor_body",
//t    "accessor_body : block",
//t    "accessor_body : SEMICOLON",
//t    "accessor_body : error",
//t    "$$35 :",
//t    "$$36 :",
//t    "$$37 :",
//t    "$$38 :",
//t    "interface_declaration : opt_attributes opt_modifiers opt_partial INTERFACE $$35 type_declaration_name $$36 opt_class_base opt_type_parameter_constraints_clauses $$37 OPEN_BRACE opt_interface_member_declarations CLOSE_BRACE $$38 opt_semicolon",
//t    "interface_declaration : opt_attributes opt_modifiers opt_partial INTERFACE error",
//t    "opt_interface_member_declarations :",
//t    "opt_interface_member_declarations : interface_member_declarations",
//t    "interface_member_declarations : interface_member_declaration",
//t    "interface_member_declarations : interface_member_declarations interface_member_declaration",
//t    "interface_member_declaration : constant_declaration",
//t    "interface_member_declaration : field_declaration",
//t    "interface_member_declaration : method_declaration",
//t    "interface_member_declaration : property_declaration",
//t    "interface_member_declaration : event_declaration",
//t    "interface_member_declaration : indexer_declaration",
//t    "interface_member_declaration : operator_declaration",
//t    "interface_member_declaration : constructor_declaration",
//t    "interface_member_declaration : type_declaration",
//t    "$$39 :",
//t    "operator_declaration : opt_attributes opt_modifiers operator_declarator $$39 operator_body",
//t    "operator_body : block",
//t    "operator_body : SEMICOLON",
//t    "operator_type : type_expression_or_array",
//t    "operator_type : VOID",
//t    "$$40 :",
//t    "operator_declarator : operator_type OPERATOR overloadable_operator OPEN_PARENS $$40 opt_formal_parameter_list CLOSE_PARENS",
//t    "operator_declarator : conversion_operator_declarator",
//t    "overloadable_operator : BANG",
//t    "overloadable_operator : TILDE",
//t    "overloadable_operator : OP_INC",
//t    "overloadable_operator : OP_DEC",
//t    "overloadable_operator : TRUE",
//t    "overloadable_operator : FALSE",
//t    "overloadable_operator : PLUS",
//t    "overloadable_operator : MINUS",
//t    "overloadable_operator : STAR",
//t    "overloadable_operator : DIV",
//t    "overloadable_operator : PERCENT",
//t    "overloadable_operator : BITWISE_AND",
//t    "overloadable_operator : BITWISE_OR",
//t    "overloadable_operator : CARRET",
//t    "overloadable_operator : OP_SHIFT_LEFT",
//t    "overloadable_operator : OP_SHIFT_RIGHT",
//t    "overloadable_operator : OP_EQ",
//t    "overloadable_operator : OP_NE",
//t    "overloadable_operator : OP_GT",
//t    "overloadable_operator : OP_LT",
//t    "overloadable_operator : OP_GE",
//t    "overloadable_operator : OP_LE",
//t    "$$41 :",
//t    "conversion_operator_declarator : IMPLICIT OPERATOR type OPEN_PARENS $$41 opt_formal_parameter_list CLOSE_PARENS",
//t    "$$42 :",
//t    "conversion_operator_declarator : EXPLICIT OPERATOR type OPEN_PARENS $$42 opt_formal_parameter_list CLOSE_PARENS",
//t    "conversion_operator_declarator : IMPLICIT error",
//t    "conversion_operator_declarator : EXPLICIT error",
//t    "constructor_declaration : constructor_declarator constructor_body",
//t    "$$43 :",
//t    "$$44 :",
//t    "constructor_declarator : opt_attributes opt_modifiers IDENTIFIER $$43 OPEN_PARENS opt_formal_parameter_list CLOSE_PARENS $$44 opt_constructor_initializer",
//t    "constructor_body : block_prepared",
//t    "constructor_body : SEMICOLON",
//t    "opt_constructor_initializer :",
//t    "opt_constructor_initializer : constructor_initializer",
//t    "$$45 :",
//t    "constructor_initializer : COLON BASE OPEN_PARENS $$45 opt_argument_list CLOSE_PARENS",
//t    "$$46 :",
//t    "constructor_initializer : COLON THIS OPEN_PARENS $$46 opt_argument_list CLOSE_PARENS",
//t    "constructor_initializer : COLON error",
//t    "constructor_initializer : error",
//t    "$$47 :",
//t    "destructor_declaration : opt_attributes opt_modifiers TILDE $$47 IDENTIFIER OPEN_PARENS CLOSE_PARENS method_body",
//t    "$$48 :",
//t    "event_declaration : opt_attributes opt_modifiers EVENT type member_declaration_name $$48 opt_event_initializer opt_event_declarators SEMICOLON",
//t    "$$49 :",
//t    "$$50 :",
//t    "event_declaration : opt_attributes opt_modifiers EVENT type member_declaration_name OPEN_BRACE $$49 event_accessor_declarations $$50 CLOSE_BRACE",
//t    "opt_event_initializer :",
//t    "$$51 :",
//t    "opt_event_initializer : ASSIGN $$51 event_variable_initializer",
//t    "opt_event_declarators :",
//t    "opt_event_declarators : event_declarators",
//t    "event_declarators : event_declarator",
//t    "event_declarators : event_declarators event_declarator",
//t    "event_declarator : COMMA IDENTIFIER",
//t    "$$52 :",
//t    "event_declarator : COMMA IDENTIFIER ASSIGN $$52 event_variable_initializer",
//t    "$$53 :",
//t    "event_variable_initializer : $$53 variable_initializer",
//t    "event_accessor_declarations : add_accessor_declaration remove_accessor_declaration",
//t    "event_accessor_declarations : remove_accessor_declaration add_accessor_declaration",
//t    "event_accessor_declarations : add_accessor_declaration",
//t    "event_accessor_declarations : remove_accessor_declaration",
//t    "event_accessor_declarations : error",
//t    "$$54 :",
//t    "add_accessor_declaration : opt_attributes opt_modifiers ADD $$54 event_accessor_block",
//t    "$$55 :",
//t    "remove_accessor_declaration : opt_attributes opt_modifiers REMOVE $$55 event_accessor_block",
//t    "event_accessor_block : opt_semicolon",
//t    "event_accessor_block : block",
//t    "attributes_without_members : attribute_sections CLOSE_BRACE",
//t    "$$56 :",
//t    "$$57 :",
//t    "$$58 :",
//t    "enum_declaration : opt_attributes opt_modifiers ENUM type_declaration_name opt_enum_base $$56 OPEN_BRACE $$57 opt_enum_member_declarations $$58 CLOSE_BRACE opt_semicolon",
//t    "opt_enum_base :",
//t    "opt_enum_base : COLON type",
//t    "opt_enum_base : COLON error",
//t    "opt_enum_member_declarations :",
//t    "opt_enum_member_declarations : enum_member_declarations",
//t    "opt_enum_member_declarations : enum_member_declarations COMMA",
//t    "enum_member_declarations : enum_member_declaration",
//t    "enum_member_declarations : enum_member_declarations COMMA enum_member_declaration",
//t    "enum_member_declaration : opt_attributes IDENTIFIER",
//t    "$$59 :",
//t    "enum_member_declaration : opt_attributes IDENTIFIER $$59 ASSIGN constant_expression",
//t    "enum_member_declaration : opt_attributes IDENTIFIER error",
//t    "enum_member_declaration : attributes_without_members",
//t    "$$60 :",
//t    "$$61 :",
//t    "$$62 :",
//t    "delegate_declaration : opt_attributes opt_modifiers DELEGATE member_type type_declaration_name OPEN_PARENS $$60 opt_formal_parameter_list CLOSE_PARENS $$61 opt_type_parameter_constraints_clauses $$62 SEMICOLON",
//t    "opt_nullable :",
//t    "opt_nullable : INTERR_NULLABLE",
//t    "namespace_or_type_expr : member_name",
//t    "namespace_or_type_expr : qualified_alias_member IDENTIFIER opt_type_argument_list",
//t    "member_name : simple_name_expr",
//t    "member_name : namespace_or_type_expr DOT IDENTIFIER opt_type_argument_list",
//t    "simple_name_expr : IDENTIFIER opt_type_argument_list",
//t    "opt_type_argument_list :",
//t    "opt_type_argument_list : OP_GENERICS_LT type_arguments OP_GENERICS_GT",
//t    "opt_type_argument_list : OP_GENERICS_LT error",
//t    "type_arguments : type",
//t    "type_arguments : type_arguments COMMA type",
//t    "$$63 :",
//t    "type_declaration_name : IDENTIFIER $$63 opt_type_parameter_list",
//t    "member_declaration_name : method_declaration_name",
//t    "method_declaration_name : type_declaration_name",
//t    "method_declaration_name : explicit_interface IDENTIFIER opt_type_parameter_list",
//t    "indexer_declaration_name : THIS",
//t    "indexer_declaration_name : explicit_interface THIS",
//t    "explicit_interface : IDENTIFIER opt_type_argument_list DOT",
//t    "explicit_interface : qualified_alias_member IDENTIFIER opt_type_argument_list DOT",
//t    "explicit_interface : explicit_interface IDENTIFIER opt_type_argument_list DOT",
//t    "opt_type_parameter_list :",
//t    "opt_type_parameter_list : OP_GENERICS_LT_DECL type_parameters OP_GENERICS_GT",
//t    "type_parameters : type_parameter",
//t    "type_parameters : type_parameters COMMA type_parameter",
//t    "type_parameter : opt_attributes opt_type_parameter_variance IDENTIFIER",
//t    "type_parameter : error",
//t    "type_and_void : type_expression_or_array",
//t    "type_and_void : VOID",
//t    "member_type : type_and_void",
//t    "type : type_expression_or_array",
//t    "type : VOID",
//t    "simple_type : type_expression",
//t    "simple_type : VOID",
//t    "parameter_type : type_expression_or_array",
//t    "parameter_type : VOID",
//t    "type_expression_or_array : type_expression",
//t    "type_expression_or_array : type_expression rank_specifiers",
//t    "type_expression : namespace_or_type_expr opt_nullable",
//t    "type_expression : namespace_or_type_expr pointer_stars",
//t    "type_expression : builtin_types opt_nullable",
//t    "type_expression : builtin_types pointer_stars",
//t    "type_expression : VOID pointer_stars",
//t    "type_list : base_type_name",
//t    "type_list : type_list COMMA base_type_name",
//t    "base_type_name : type",
//t    "builtin_types : OBJECT",
//t    "builtin_types : STRING",
//t    "builtin_types : BOOL",
//t    "builtin_types : DECIMAL",
//t    "builtin_types : FLOAT",
//t    "builtin_types : DOUBLE",
//t    "builtin_types : integral_type",
//t    "integral_type : SBYTE",
//t    "integral_type : BYTE",
//t    "integral_type : SHORT",
//t    "integral_type : USHORT",
//t    "integral_type : INT",
//t    "integral_type : UINT",
//t    "integral_type : LONG",
//t    "integral_type : ULONG",
//t    "integral_type : CHAR",
//t    "primary_expression : primary_expression_or_type",
//t    "primary_expression : literal",
//t    "primary_expression : array_creation_expression",
//t    "primary_expression : parenthesized_expression",
//t    "primary_expression : default_value_expression",
//t    "primary_expression : invocation_expression",
//t    "primary_expression : element_access",
//t    "primary_expression : this_access",
//t    "primary_expression : base_access",
//t    "primary_expression : post_increment_expression",
//t    "primary_expression : post_decrement_expression",
//t    "primary_expression : object_or_delegate_creation_expression",
//t    "primary_expression : anonymous_type_expression",
//t    "primary_expression : typeof_expression",
//t    "primary_expression : sizeof_expression",
//t    "primary_expression : checked_expression",
//t    "primary_expression : unchecked_expression",
//t    "primary_expression : pointer_member_access",
//t    "primary_expression : anonymous_method_expression",
//t    "primary_expression : undocumented_expressions",
//t    "primary_expression_or_type : IDENTIFIER opt_type_argument_list",
//t    "primary_expression_or_type : IDENTIFIER GENERATE_COMPLETION",
//t    "primary_expression_or_type : member_access",
//t    "literal : boolean_literal",
//t    "literal : LITERAL",
//t    "literal : NULL",
//t    "boolean_literal : TRUE",
//t    "boolean_literal : FALSE",
//t    "open_parens_any : OPEN_PARENS",
//t    "open_parens_any : OPEN_PARENS_CAST",
//t    "close_parens : CLOSE_PARENS",
//t    "close_parens : COMPLETE_COMPLETION",
//t    "parenthesized_expression : OPEN_PARENS expression CLOSE_PARENS",
//t    "parenthesized_expression : OPEN_PARENS expression COMPLETE_COMPLETION",
//t    "member_access : primary_expression DOT IDENTIFIER opt_type_argument_list",
//t    "member_access : builtin_types DOT IDENTIFIER opt_type_argument_list",
//t    "member_access : BASE DOT IDENTIFIER opt_type_argument_list",
//t    "member_access : qualified_alias_member IDENTIFIER opt_type_argument_list",
//t    "member_access : primary_expression DOT GENERATE_COMPLETION",
//t    "member_access : primary_expression DOT IDENTIFIER GENERATE_COMPLETION",
//t    "member_access : builtin_types DOT GENERATE_COMPLETION",
//t    "member_access : builtin_types DOT IDENTIFIER GENERATE_COMPLETION",
//t    "invocation_expression : primary_expression open_parens_any opt_argument_list close_parens",
//t    "invocation_expression : primary_expression open_parens_any argument_list error",
//t    "opt_object_or_collection_initializer :",
//t    "opt_object_or_collection_initializer : object_or_collection_initializer",
//t    "object_or_collection_initializer : OPEN_BRACE opt_member_initializer_list close_brace_or_complete_completion",
//t    "object_or_collection_initializer : OPEN_BRACE member_initializer_list COMMA CLOSE_BRACE",
//t    "opt_member_initializer_list :",
//t    "opt_member_initializer_list : member_initializer_list",
//t    "member_initializer_list : member_initializer",
//t    "member_initializer_list : member_initializer_list COMMA member_initializer",
//t    "member_initializer_list : member_initializer_list error",
//t    "member_initializer : IDENTIFIER ASSIGN initializer_value",
//t    "member_initializer : GENERATE_COMPLETION",
//t    "member_initializer : non_assignment_expression opt_COMPLETE_COMPLETION",
//t    "member_initializer : OPEN_BRACE expression_list CLOSE_BRACE",
//t    "member_initializer : OPEN_BRACE CLOSE_BRACE",
//t    "initializer_value : expression",
//t    "initializer_value : object_or_collection_initializer",
//t    "opt_argument_list :",
//t    "opt_argument_list : argument_list",
//t    "argument_list : argument_or_named_argument",
//t    "argument_list : argument_list COMMA argument",
//t    "argument_list : argument_list COMMA named_argument",
//t    "argument_list : argument_list COMMA error",
//t    "argument_list : COMMA error",
//t    "argument : expression",
//t    "argument : non_simple_argument",
//t    "argument_or_named_argument : argument",
//t    "argument_or_named_argument : named_argument",
//t    "non_simple_argument : REF variable_reference",
//t    "non_simple_argument : OUT variable_reference",
//t    "non_simple_argument : ARGLIST OPEN_PARENS argument_list CLOSE_PARENS",
//t    "non_simple_argument : ARGLIST OPEN_PARENS CLOSE_PARENS",
//t    "variable_reference : expression",
//t    "element_access : primary_expression OPEN_BRACKET_EXPR expression_list_arguments CLOSE_BRACKET",
//t    "element_access : primary_expression OPEN_BRACKET_EXPR expression_list_arguments error",
//t    "element_access : primary_expression OPEN_BRACKET_EXPR error",
//t    "expression_list : expression",
//t    "expression_list : expression_list COMMA expression",
//t    "expression_list : expression_list error",
//t    "expression_list_arguments : expression_list_argument",
//t    "expression_list_arguments : expression_list_arguments COMMA expression_list_argument",
//t    "expression_list_argument : expression",
//t    "expression_list_argument : named_argument",
//t    "this_access : THIS",
//t    "base_access : BASE OPEN_BRACKET_EXPR expression_list_arguments CLOSE_BRACKET",
//t    "base_access : BASE OPEN_BRACKET error",
//t    "post_increment_expression : primary_expression OP_INC",
//t    "post_decrement_expression : primary_expression OP_DEC",
//t    "object_or_delegate_creation_expression : NEW new_expr_type open_parens_any opt_argument_list CLOSE_PARENS opt_object_or_collection_initializer",
//t    "object_or_delegate_creation_expression : NEW new_expr_type object_or_collection_initializer",
//t    "array_creation_expression : NEW new_expr_type OPEN_BRACKET_EXPR expression_list CLOSE_BRACKET opt_rank_specifier opt_array_initializer",
//t    "array_creation_expression : NEW new_expr_type rank_specifiers opt_array_initializer",
//t    "array_creation_expression : NEW rank_specifier array_initializer",
//t    "array_creation_expression : NEW new_expr_type OPEN_BRACKET CLOSE_BRACKET OPEN_BRACKET_EXPR error CLOSE_BRACKET",
//t    "array_creation_expression : NEW new_expr_type error",
//t    "$$64 :",
//t    "new_expr_type : $$64 simple_type",
//t    "anonymous_type_expression : NEW OPEN_BRACE anonymous_type_parameters_opt_comma CLOSE_BRACE",
//t    "anonymous_type_parameters_opt_comma : anonymous_type_parameters_opt",
//t    "anonymous_type_parameters_opt_comma : anonymous_type_parameters COMMA",
//t    "anonymous_type_parameters_opt :",
//t    "anonymous_type_parameters_opt : anonymous_type_parameters",
//t    "anonymous_type_parameters : anonymous_type_parameter",
//t    "anonymous_type_parameters : anonymous_type_parameters COMMA anonymous_type_parameter",
//t    "anonymous_type_parameter : IDENTIFIER ASSIGN variable_initializer",
//t    "anonymous_type_parameter : IDENTIFIER",
//t    "anonymous_type_parameter : member_access",
//t    "anonymous_type_parameter : error",
//t    "opt_rank_specifier :",
//t    "opt_rank_specifier : rank_specifiers",
//t    "rank_specifiers : rank_specifier",
//t    "rank_specifiers : rank_specifier rank_specifiers",
//t    "rank_specifier : OPEN_BRACKET CLOSE_BRACKET",
//t    "rank_specifier : OPEN_BRACKET dim_separators CLOSE_BRACKET",
//t    "dim_separators : COMMA",
//t    "dim_separators : dim_separators COMMA",
//t    "opt_array_initializer :",
//t    "opt_array_initializer : array_initializer",
//t    "array_initializer : OPEN_BRACE CLOSE_BRACE",
//t    "array_initializer : OPEN_BRACE variable_initializer_list opt_comma CLOSE_BRACE",
//t    "variable_initializer_list : variable_initializer",
//t    "variable_initializer_list : variable_initializer_list COMMA variable_initializer",
//t    "$$65 :",
//t    "typeof_expression : TYPEOF $$65 open_parens_any typeof_type_expression CLOSE_PARENS",
//t    "typeof_type_expression : type_and_void",
//t    "typeof_type_expression : unbound_type_name",
//t    "typeof_type_expression : error",
//t    "unbound_type_name : identifier_inside_body generic_dimension",
//t    "unbound_type_name : qualified_alias_member identifier_inside_body generic_dimension",
//t    "unbound_type_name : unbound_type_name DOT identifier_inside_body",
//t    "unbound_type_name : unbound_type_name DOT identifier_inside_body generic_dimension",
//t    "unbound_type_name : namespace_or_type_expr DOT identifier_inside_body generic_dimension",
//t    "generic_dimension : GENERIC_DIMENSION",
//t    "qualified_alias_member : IDENTIFIER DOUBLE_COLON",
//t    "sizeof_expression : SIZEOF open_parens_any type CLOSE_PARENS",
//t    "checked_expression : CHECKED open_parens_any expression CLOSE_PARENS",
//t    "unchecked_expression : UNCHECKED open_parens_any expression CLOSE_PARENS",
//t    "pointer_member_access : primary_expression OP_PTR IDENTIFIER opt_type_argument_list",
//t    "$$66 :",
//t    "anonymous_method_expression : DELEGATE opt_anonymous_method_signature $$66 block",
//t    "$$67 :",
//t    "anonymous_method_expression : ASYNC DELEGATE opt_anonymous_method_signature $$67 block",
//t    "opt_anonymous_method_signature :",
//t    "opt_anonymous_method_signature : anonymous_method_signature",
//t    "$$68 :",
//t    "anonymous_method_signature : OPEN_PARENS $$68 opt_formal_parameter_list CLOSE_PARENS",
//t    "default_value_expression : DEFAULT open_parens_any type CLOSE_PARENS",
//t    "unary_expression : primary_expression",
//t    "unary_expression : BANG prefixed_unary_expression",
//t    "unary_expression : TILDE prefixed_unary_expression",
//t    "unary_expression : OPEN_PARENS_CAST type CLOSE_PARENS prefixed_unary_expression",
//t    "unary_expression : AWAIT prefixed_unary_expression",
//t    "prefixed_unary_expression : unary_expression",
//t    "prefixed_unary_expression : PLUS prefixed_unary_expression",
//t    "prefixed_unary_expression : MINUS prefixed_unary_expression",
//t    "prefixed_unary_expression : OP_INC prefixed_unary_expression",
//t    "prefixed_unary_expression : OP_DEC prefixed_unary_expression",
//t    "prefixed_unary_expression : STAR prefixed_unary_expression",
//t    "prefixed_unary_expression : BITWISE_AND prefixed_unary_expression",
//t    "multiplicative_expression : prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression STAR prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression DIV prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression PERCENT prefixed_unary_expression",
//t    "additive_expression : multiplicative_expression",
//t    "additive_expression : additive_expression PLUS multiplicative_expression",
//t    "additive_expression : additive_expression MINUS multiplicative_expression",
//t    "additive_expression : additive_expression AS type",
//t    "additive_expression : additive_expression IS type",
//t    "shift_expression : additive_expression",
//t    "shift_expression : shift_expression OP_SHIFT_LEFT additive_expression",
//t    "shift_expression : shift_expression OP_SHIFT_RIGHT additive_expression",
//t    "relational_expression : shift_expression",
//t    "relational_expression : relational_expression OP_LT shift_expression",
//t    "relational_expression : relational_expression OP_GT shift_expression",
//t    "relational_expression : relational_expression OP_LE shift_expression",
//t    "relational_expression : relational_expression OP_GE shift_expression",
//t    "equality_expression : relational_expression",
//t    "equality_expression : equality_expression OP_EQ relational_expression",
//t    "equality_expression : equality_expression OP_NE relational_expression",
//t    "and_expression : equality_expression",
//t    "and_expression : and_expression BITWISE_AND equality_expression",
//t    "exclusive_or_expression : and_expression",
//t    "exclusive_or_expression : exclusive_or_expression CARRET and_expression",
//t    "inclusive_or_expression : exclusive_or_expression",
//t    "inclusive_or_expression : inclusive_or_expression BITWISE_OR exclusive_or_expression",
//t    "conditional_and_expression : inclusive_or_expression",
//t    "conditional_and_expression : conditional_and_expression OP_AND inclusive_or_expression",
//t    "conditional_or_expression : conditional_and_expression",
//t    "conditional_or_expression : conditional_or_expression OP_OR conditional_and_expression",
//t    "null_coalescing_expression : conditional_or_expression",
//t    "null_coalescing_expression : conditional_or_expression OP_COALESCING null_coalescing_expression",
//t    "conditional_expression : null_coalescing_expression",
//t    "conditional_expression : null_coalescing_expression INTERR expression COLON expression_or_error",
//t    "conditional_expression : null_coalescing_expression INTERR expression error",
//t    "assignment_expression : prefixed_unary_expression ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_MULT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_DIV_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_MOD_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_ADD_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SUB_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SHIFT_LEFT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SHIFT_RIGHT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_AND_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_OR_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_XOR_ASSIGN expression",
//t    "lambda_parameter_list : lambda_parameter",
//t    "lambda_parameter_list : lambda_parameter_list COMMA lambda_parameter",
//t    "lambda_parameter : parameter_modifier parameter_type identifier_inside_body",
//t    "lambda_parameter : parameter_type identifier_inside_body",
//t    "lambda_parameter : IDENTIFIER",
//t    "opt_lambda_parameter_list :",
//t    "opt_lambda_parameter_list : lambda_parameter_list",
//t    "lambda_expression_body : lambda_expression_body_simple",
//t    "lambda_expression_body : block",
//t    "$$69 :",
//t    "lambda_expression_body_simple : $$69 expression_or_error",
//t    "expression_or_error : expression",
//t    "expression_or_error : error",
//t    "$$70 :",
//t    "lambda_expression : IDENTIFIER ARROW $$70 lambda_expression_body",
//t    "$$71 :",
//t    "lambda_expression : ASYNC identifier_inside_body ARROW $$71 lambda_expression_body",
//t    "$$72 :",
//t    "$$73 :",
//t    "lambda_expression : OPEN_PARENS_LAMBDA $$72 opt_lambda_parameter_list CLOSE_PARENS ARROW $$73 lambda_expression_body",
//t    "$$74 :",
//t    "$$75 :",
//t    "lambda_expression : ASYNC OPEN_PARENS_LAMBDA $$74 opt_lambda_parameter_list CLOSE_PARENS ARROW $$75 lambda_expression_body",
//t    "expression : assignment_expression",
//t    "expression : non_assignment_expression",
//t    "non_assignment_expression : conditional_expression",
//t    "non_assignment_expression : lambda_expression",
//t    "non_assignment_expression : query_expression",
//t    "non_assignment_expression : ARGLIST",
//t    "undocumented_expressions : REFVALUE OPEN_PARENS non_assignment_expression COMMA type CLOSE_PARENS",
//t    "undocumented_expressions : REFTYPE open_parens_any expression CLOSE_PARENS",
//t    "undocumented_expressions : MAKEREF open_parens_any expression CLOSE_PARENS",
//t    "constant_expression : expression",
//t    "boolean_expression : expression",
//t    "$$76 :",
//t    "$$77 :",
//t    "$$78 :",
//t    "$$79 :",
//t    "class_declaration : opt_attributes opt_modifiers opt_partial CLASS $$76 type_declaration_name $$77 opt_class_base opt_type_parameter_constraints_clauses $$78 OPEN_BRACE opt_class_member_declarations CLOSE_BRACE $$79 opt_semicolon",
//t    "opt_partial :",
//t    "opt_partial : PARTIAL",
//t    "opt_modifiers :",
//t    "opt_modifiers : modifiers",
//t    "modifiers : modifier",
//t    "modifiers : modifiers modifier",
//t    "modifier : NEW",
//t    "modifier : PUBLIC",
//t    "modifier : PROTECTED",
//t    "modifier : INTERNAL",
//t    "modifier : PRIVATE",
//t    "modifier : ABSTRACT",
//t    "modifier : SEALED",
//t    "modifier : STATIC",
//t    "modifier : READONLY",
//t    "modifier : VIRTUAL",
//t    "modifier : OVERRIDE",
//t    "modifier : EXTERN",
//t    "modifier : VOLATILE",
//t    "modifier : UNSAFE",
//t    "modifier : ASYNC",
//t    "opt_class_base :",
//t    "opt_class_base : COLON type_list",
//t    "opt_class_base : COLON type_list error",
//t    "opt_type_parameter_constraints_clauses :",
//t    "opt_type_parameter_constraints_clauses : type_parameter_constraints_clauses",
//t    "type_parameter_constraints_clauses : type_parameter_constraints_clause",
//t    "type_parameter_constraints_clauses : type_parameter_constraints_clauses type_parameter_constraints_clause",
//t    "type_parameter_constraints_clause : WHERE IDENTIFIER COLON type_parameter_constraints",
//t    "type_parameter_constraints_clause : WHERE IDENTIFIER error",
//t    "type_parameter_constraints : type_parameter_constraint",
//t    "type_parameter_constraints : type_parameter_constraints COMMA type_parameter_constraint",
//t    "type_parameter_constraint : type",
//t    "type_parameter_constraint : NEW OPEN_PARENS CLOSE_PARENS",
//t    "type_parameter_constraint : CLASS",
//t    "type_parameter_constraint : STRUCT",
//t    "opt_type_parameter_variance :",
//t    "opt_type_parameter_variance : type_parameter_variance",
//t    "type_parameter_variance : OUT",
//t    "type_parameter_variance : IN",
//t    "$$80 :",
//t    "block : OPEN_BRACE $$80 opt_statement_list block_end",
//t    "block_end : CLOSE_BRACE",
//t    "block_end : COMPLETE_COMPLETION",
//t    "$$81 :",
//t    "block_prepared : OPEN_BRACE $$81 opt_statement_list CLOSE_BRACE",
//t    "block_prepared : CLOSE_BRACE",
//t    "opt_statement_list :",
//t    "opt_statement_list : statement_list",
//t    "statement_list : statement",
//t    "statement_list : statement_list statement",
//t    "statement : block_variable_declaration",
//t    "statement : valid_declaration_statement",
//t    "statement : labeled_statement",
//t    "statement : IDENTIFIER error",
//t    "statement : error",
//t    "interactive_statement_list : interactive_statement",
//t    "interactive_statement_list : interactive_statement_list interactive_statement",
//t    "interactive_statement : block_variable_declaration",
//t    "interactive_statement : interactive_valid_declaration_statement",
//t    "interactive_statement : labeled_statement",
//t    "valid_declaration_statement : block",
//t    "valid_declaration_statement : empty_statement",
//t    "valid_declaration_statement : expression_statement",
//t    "valid_declaration_statement : selection_statement",
//t    "valid_declaration_statement : iteration_statement",
//t    "valid_declaration_statement : jump_statement",
//t    "valid_declaration_statement : try_statement",
//t    "valid_declaration_statement : checked_statement",
//t    "valid_declaration_statement : unchecked_statement",
//t    "valid_declaration_statement : lock_statement",
//t    "valid_declaration_statement : using_statement",
//t    "valid_declaration_statement : unsafe_statement",
//t    "valid_declaration_statement : fixed_statement",
//t    "interactive_valid_declaration_statement : block",
//t    "interactive_valid_declaration_statement : empty_statement",
//t    "interactive_valid_declaration_statement : interactive_expression_statement",
//t    "interactive_valid_declaration_statement : selection_statement",
//t    "interactive_valid_declaration_statement : iteration_statement",
//t    "interactive_valid_declaration_statement : jump_statement",
//t    "interactive_valid_declaration_statement : try_statement",
//t    "interactive_valid_declaration_statement : checked_statement",
//t    "interactive_valid_declaration_statement : unchecked_statement",
//t    "interactive_valid_declaration_statement : lock_statement",
//t    "interactive_valid_declaration_statement : using_statement",
//t    "interactive_valid_declaration_statement : unsafe_statement",
//t    "interactive_valid_declaration_statement : fixed_statement",
//t    "embedded_statement : valid_declaration_statement",
//t    "embedded_statement : block_variable_declaration",
//t    "embedded_statement : labeled_statement",
//t    "embedded_statement : error",
//t    "empty_statement : SEMICOLON",
//t    "$$82 :",
//t    "labeled_statement : identifier_inside_body COLON $$82 statement",
//t    "variable_type : variable_type_simple",
//t    "variable_type : variable_type_simple rank_specifiers",
//t    "variable_type_simple : primary_expression_or_type opt_nullable",
//t    "variable_type_simple : primary_expression_or_type pointer_stars",
//t    "variable_type_simple : builtin_types opt_nullable",
//t    "variable_type_simple : builtin_types pointer_stars",
//t    "variable_type_simple : VOID pointer_stars",
//t    "variable_type_simple : VOID",
//t    "pointer_stars : pointer_star",
//t    "pointer_stars : pointer_star pointer_stars",
//t    "pointer_star : STAR",
//t    "identifier_inside_body : IDENTIFIER",
//t    "identifier_inside_body : AWAIT",
//t    "$$83 :",
//t    "block_variable_declaration : variable_type identifier_inside_body $$83 opt_local_variable_initializer opt_variable_declarators semicolon_or_handle_error_close_brace",
//t    "$$84 :",
//t    "block_variable_declaration : CONST variable_type identifier_inside_body $$84 const_variable_initializer opt_const_declarators SEMICOLON",
//t    "semicolon_or_handle_error_close_brace : SEMICOLON",
//t    "semicolon_or_handle_error_close_brace : CLOSE_BRACE",
//t    "opt_local_variable_initializer :",
//t    "opt_local_variable_initializer : ASSIGN block_variable_initializer",
//t    "opt_local_variable_initializer : ASSIGN error",
//t    "opt_local_variable_initializer : error",
//t    "opt_variable_declarators :",
//t    "opt_variable_declarators : variable_declarators",
//t    "opt_using_or_fixed_variable_declarators :",
//t    "opt_using_or_fixed_variable_declarators : variable_declarators",
//t    "variable_declarators : variable_declarator",
//t    "variable_declarators : variable_declarators variable_declarator",
//t    "variable_declarator : COMMA identifier_inside_body",
//t    "variable_declarator : COMMA identifier_inside_body ASSIGN block_variable_initializer",
//t    "const_variable_initializer :",
//t    "const_variable_initializer : ASSIGN constant_initializer_expr",
//t    "opt_const_declarators :",
//t    "opt_const_declarators : const_declarators",
//t    "const_declarators : const_declarator",
//t    "const_declarators : const_declarators const_declarator",
//t    "const_declarator : COMMA identifier_inside_body ASSIGN constant_initializer_expr",
//t    "block_variable_initializer : variable_initializer",
//t    "block_variable_initializer : STACKALLOC simple_type OPEN_BRACKET_EXPR expression CLOSE_BRACKET",
//t    "block_variable_initializer : STACKALLOC simple_type",
//t    "expression_statement : statement_expression SEMICOLON",
//t    "expression_statement : statement_expression COMPLETE_COMPLETION",
//t    "expression_statement : statement_expression CLOSE_BRACE",
//t    "interactive_expression_statement : interactive_statement_expression SEMICOLON",
//t    "interactive_expression_statement : interactive_statement_expression COMPLETE_COMPLETION",
//t    "statement_expression : expression",
//t    "interactive_statement_expression : expression",
//t    "interactive_statement_expression : error",
//t    "selection_statement : if_statement",
//t    "selection_statement : switch_statement",
//t    "if_statement : IF open_parens_any boolean_expression CLOSE_PARENS embedded_statement",
//t    "if_statement : IF open_parens_any boolean_expression CLOSE_PARENS embedded_statement ELSE embedded_statement",
//t    "if_statement : IF open_parens_any boolean_expression error",
//t    "$$85 :",
//t    "switch_statement : SWITCH open_parens_any expression CLOSE_PARENS OPEN_BRACE $$85 opt_switch_sections CLOSE_BRACE",
//t    "switch_statement : SWITCH open_parens_any expression error",
//t    "opt_switch_sections :",
//t    "opt_switch_sections : switch_sections",
//t    "switch_sections : switch_section",
//t    "switch_sections : switch_sections switch_section",
//t    "switch_sections : error",
//t    "$$86 :",
//t    "switch_section : switch_labels $$86 statement_list",
//t    "switch_labels : switch_label",
//t    "switch_labels : switch_labels switch_label",
//t    "switch_label : CASE constant_expression COLON",
//t    "switch_label : CASE constant_expression error",
//t    "switch_label : DEFAULT_COLON",
//t    "iteration_statement : while_statement",
//t    "iteration_statement : do_statement",
//t    "iteration_statement : for_statement",
//t    "iteration_statement : foreach_statement",
//t    "while_statement : WHILE open_parens_any boolean_expression CLOSE_PARENS embedded_statement",
//t    "while_statement : WHILE open_parens_any boolean_expression error",
//t    "do_statement : DO embedded_statement WHILE open_parens_any boolean_expression CLOSE_PARENS SEMICOLON",
//t    "do_statement : DO embedded_statement error",
//t    "do_statement : DO embedded_statement WHILE open_parens_any boolean_expression error",
//t    "$$87 :",
//t    "for_statement : FOR open_parens_any $$87 for_statement_cont",
//t    "$$88 :",
//t    "for_statement_cont : opt_for_initializer SEMICOLON $$88 for_statement_condition",
//t    "for_statement_cont : opt_for_initializer CLOSE_PARENS",
//t    "$$89 :",
//t    "for_statement_condition : opt_for_condition SEMICOLON $$89 for_statement_end",
//t    "for_statement_condition : boolean_expression CLOSE_PARENS",
//t    "for_statement_end : opt_for_iterator CLOSE_PARENS embedded_statement",
//t    "for_statement_end : error",
//t    "opt_for_initializer :",
//t    "opt_for_initializer : for_initializer",
//t    "$$90 :",
//t    "for_initializer : variable_type identifier_inside_body $$90 opt_local_variable_initializer opt_variable_declarators",
//t    "for_initializer : statement_expression_list",
//t    "opt_for_condition :",
//t    "opt_for_condition : boolean_expression",
//t    "opt_for_iterator :",
//t    "opt_for_iterator : for_iterator",
//t    "for_iterator : statement_expression_list",
//t    "statement_expression_list : statement_expression",
//t    "statement_expression_list : statement_expression_list COMMA statement_expression",
//t    "foreach_statement : FOREACH open_parens_any type error",
//t    "foreach_statement : FOREACH open_parens_any type identifier_inside_body error",
//t    "$$91 :",
//t    "foreach_statement : FOREACH open_parens_any type identifier_inside_body IN expression CLOSE_PARENS $$91 embedded_statement",
//t    "foreach_statement : FOREACH open_parens_any type identifier_inside_body error",
//t    "foreach_statement : FOREACH open_parens_any type error",
//t    "jump_statement : break_statement",
//t    "jump_statement : continue_statement",
//t    "jump_statement : goto_statement",
//t    "jump_statement : return_statement",
//t    "jump_statement : throw_statement",
//t    "jump_statement : yield_statement",
//t    "break_statement : BREAK SEMICOLON",
//t    "continue_statement : CONTINUE SEMICOLON",
//t    "continue_statement : CONTINUE error",
//t    "goto_statement : GOTO identifier_inside_body SEMICOLON",
//t    "goto_statement : GOTO CASE constant_expression SEMICOLON",
//t    "goto_statement : GOTO DEFAULT SEMICOLON",
//t    "return_statement : RETURN opt_expression SEMICOLON",
//t    "return_statement : RETURN expression error",
//t    "return_statement : RETURN error",
//t    "throw_statement : THROW opt_expression SEMICOLON",
//t    "throw_statement : THROW error",
//t    "yield_statement : identifier_inside_body RETURN opt_expression SEMICOLON",
//t    "yield_statement : identifier_inside_body RETURN expression error",
//t    "yield_statement : identifier_inside_body BREAK SEMICOLON",
//t    "opt_expression :",
//t    "opt_expression : expression",
//t    "try_statement : TRY block catch_clauses",
//t    "try_statement : TRY block FINALLY block",
//t    "try_statement : TRY block catch_clauses FINALLY block",
//t    "try_statement : TRY block error",
//t    "catch_clauses : catch_clause",
//t    "catch_clauses : catch_clauses catch_clause",
//t    "opt_identifier :",
//t    "opt_identifier : identifier_inside_body",
//t    "catch_clause : CATCH block",
//t    "$$92 :",
//t    "catch_clause : CATCH open_parens_any type opt_identifier CLOSE_PARENS $$92 block_prepared",
//t    "catch_clause : CATCH open_parens_any error",
//t    "checked_statement : CHECKED block",
//t    "unchecked_statement : UNCHECKED block",
//t    "$$93 :",
//t    "unsafe_statement : UNSAFE $$93 block",
//t    "lock_statement : LOCK open_parens_any expression CLOSE_PARENS embedded_statement",
//t    "lock_statement : LOCK open_parens_any expression error",
//t    "$$94 :",
//t    "$$95 :",
//t    "fixed_statement : FIXED open_parens_any variable_type identifier_inside_body $$94 using_or_fixed_variable_initializer opt_using_or_fixed_variable_declarators CLOSE_PARENS $$95 embedded_statement",
//t    "$$96 :",
//t    "$$97 :",
//t    "using_statement : USING open_parens_any variable_type identifier_inside_body $$96 using_initialization CLOSE_PARENS $$97 embedded_statement",
//t    "using_statement : USING open_parens_any expression CLOSE_PARENS embedded_statement",
//t    "using_statement : USING open_parens_any expression error",
//t    "using_initialization : using_or_fixed_variable_initializer opt_using_or_fixed_variable_declarators",
//t    "using_initialization : error",
//t    "using_or_fixed_variable_initializer :",
//t    "using_or_fixed_variable_initializer : ASSIGN variable_initializer",
//t    "query_expression : first_from_clause query_body",
//t    "query_expression : nested_from_clause query_body",
//t    "query_expression : first_from_clause COMPLETE_COMPLETION",
//t    "query_expression : nested_from_clause COMPLETE_COMPLETION",
//t    "first_from_clause : FROM_FIRST identifier_inside_body IN expression",
//t    "first_from_clause : FROM_FIRST type identifier_inside_body IN expression",
//t    "nested_from_clause : FROM identifier_inside_body IN expression",
//t    "nested_from_clause : FROM type identifier_inside_body IN expression",
//t    "$$98 :",
//t    "from_clause : FROM identifier_inside_body IN $$98 expression_or_error",
//t    "$$99 :",
//t    "from_clause : FROM type identifier_inside_body IN $$99 expression_or_error",
//t    "query_body : query_body_clauses select_or_group_clause opt_query_continuation",
//t    "query_body : select_or_group_clause opt_query_continuation",
//t    "query_body : query_body_clauses COMPLETE_COMPLETION",
//t    "query_body : query_body_clauses error",
//t    "query_body : error",
//t    "$$100 :",
//t    "select_or_group_clause : SELECT $$100 expression_or_error",
//t    "$$101 :",
//t    "$$102 :",
//t    "select_or_group_clause : GROUP $$101 expression_or_error $$102 BY expression_or_error",
//t    "query_body_clauses : query_body_clause",
//t    "query_body_clauses : query_body_clauses query_body_clause",
//t    "query_body_clause : from_clause",
//t    "query_body_clause : let_clause",
//t    "query_body_clause : where_clause",
//t    "query_body_clause : join_clause",
//t    "query_body_clause : orderby_clause",
//t    "$$103 :",
//t    "let_clause : LET identifier_inside_body ASSIGN $$103 expression_or_error",
//t    "$$104 :",
//t    "where_clause : WHERE $$104 expression_or_error",
//t    "$$105 :",
//t    "$$106 :",
//t    "$$107 :",
//t    "join_clause : JOIN identifier_inside_body IN $$105 expression_or_error ON $$106 expression_or_error EQUALS $$107 expression_or_error opt_join_into",
//t    "$$108 :",
//t    "$$109 :",
//t    "$$110 :",
//t    "join_clause : JOIN type identifier_inside_body IN $$108 expression_or_error ON $$109 expression_or_error EQUALS $$110 expression_or_error opt_join_into",
//t    "opt_join_into :",
//t    "opt_join_into : INTO identifier_inside_body",
//t    "$$111 :",
//t    "orderby_clause : ORDERBY $$111 orderings",
//t    "orderings : order_by",
//t    "$$112 :",
//t    "orderings : order_by COMMA $$112 orderings_then_by",
//t    "orderings_then_by : then_by",
//t    "$$113 :",
//t    "orderings_then_by : orderings_then_by COMMA $$113 then_by",
//t    "order_by : expression",
//t    "order_by : expression ASCENDING",
//t    "order_by : expression DESCENDING",
//t    "then_by : expression",
//t    "then_by : expression ASCENDING",
//t    "then_by : expression DESCENDING",
//t    "opt_query_continuation :",
//t    "$$114 :",
//t    "opt_query_continuation : INTO identifier_inside_body $$114 query_body",
//t    "interactive_parsing : EVAL_STATEMENT_PARSER EOF",
//t    "interactive_parsing : EVAL_USING_DECLARATIONS_UNIT_PARSER using_directives opt_COMPLETE_COMPLETION",
//t    "$$115 :",
//t    "interactive_parsing : EVAL_STATEMENT_PARSER $$115 interactive_statement_list opt_COMPLETE_COMPLETION",
//t    "interactive_parsing : EVAL_COMPILATION_UNIT_PARSER interactive_compilation_unit",
//t    "interactive_compilation_unit : opt_extern_alias_directives opt_using_directives",
//t    "interactive_compilation_unit : opt_extern_alias_directives opt_using_directives namespace_or_type_declarations",
//t    "opt_COMPLETE_COMPLETION :",
//t    "opt_COMPLETE_COMPLETION : COMPLETE_COMPLETION",
//t    "close_brace_or_complete_completion : CLOSE_BRACE",
//t    "close_brace_or_complete_completion : COMPLETE_COMPLETION",
//t    "documentation_parsing : DOC_SEE doc_cref",
//t    "doc_cref : doc_type_declaration_name opt_doc_method_sig",
//t    "doc_cref : builtin_types opt_doc_method_sig",
//t    "doc_cref : builtin_types DOT IDENTIFIER opt_doc_method_sig",
//t    "doc_cref : doc_type_declaration_name DOT THIS",
//t    "$$116 :",
//t    "doc_cref : doc_type_declaration_name DOT THIS OPEN_BRACKET $$116 opt_doc_parameters CLOSE_BRACKET",
//t    "doc_cref : EXPLICIT OPERATOR type opt_doc_method_sig",
//t    "doc_cref : IMPLICIT OPERATOR type opt_doc_method_sig",
//t    "doc_cref : OPERATOR overloadable_operator opt_doc_method_sig",
//t    "doc_type_declaration_name : type_declaration_name",
//t    "doc_type_declaration_name : doc_type_declaration_name DOT type_declaration_name",
//t    "opt_doc_method_sig :",
//t    "$$117 :",
//t    "opt_doc_method_sig : OPEN_PARENS $$117 opt_doc_parameters CLOSE_PARENS",
//t    "opt_doc_parameters :",
//t    "opt_doc_parameters : doc_parameters",
//t    "doc_parameters : doc_parameter",
//t    "doc_parameters : doc_parameters COMMA doc_parameter",
//t    "doc_parameter : opt_parameter_modifier parameter_type",
//t  };
//t public static string getRule (int index) {
//t    return yyRule [index];
//t }
//t}
  protected static readonly string [] yyNames = {    
    "end-of-file",null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,"EOF","NONE","ERROR",
    "FIRST_KEYWORD","ABSTRACT","AS","ADD","BASE","BOOL","BREAK","BYTE",
    "CASE","CATCH","CHAR","CHECKED","CLASS","CONST","CONTINUE","DECIMAL",
    "DEFAULT","DELEGATE","DO","DOUBLE","ELSE","ENUM","EVENT","EXPLICIT",
    "EXTERN","FALSE","FINALLY","FIXED","FLOAT","FOR","FOREACH","GOTO",
    "IF","IMPLICIT","IN","INT","INTERFACE","INTERNAL","IS","LOCK","LONG",
    "NAMESPACE","NEW","NULL","OBJECT","OPERATOR","OUT","OVERRIDE",
    "PARAMS","PRIVATE","PROTECTED","PUBLIC","READONLY","REF","RETURN",
    "REMOVE","SBYTE","SEALED","SHORT","SIZEOF","STACKALLOC","STATIC",
    "STRING","STRUCT","SWITCH","THIS","THROW","TRUE","TRY","TYPEOF",
    "UINT","ULONG","UNCHECKED","UNSAFE","USHORT","USING","VIRTUAL","VOID",
    "VOLATILE","WHERE","WHILE","ARGLIST","PARTIAL","ARROW","FROM",
    "FROM_FIRST","JOIN","ON","EQUALS","SELECT","GROUP","BY","LET",
    "ORDERBY","ASCENDING","DESCENDING","INTO","INTERR_NULLABLE",
    "EXTERN_ALIAS","REFVALUE","REFTYPE","MAKEREF","ASYNC","AWAIT","GET",
    "SET","LAST_KEYWORD","OPEN_BRACE","CLOSE_BRACE","OPEN_BRACKET",
    "CLOSE_BRACKET","OPEN_PARENS","CLOSE_PARENS","DOT","COMMA","COLON",
    "SEMICOLON","TILDE","PLUS","MINUS","BANG","ASSIGN","OP_LT","OP_GT",
    "BITWISE_AND","BITWISE_OR","STAR","PERCENT","DIV","CARRET","INTERR",
    "DOUBLE_COLON","OP_INC","OP_DEC","OP_SHIFT_LEFT","OP_SHIFT_RIGHT",
    "OP_LE","OP_GE","OP_EQ","OP_NE","OP_AND","OP_OR","OP_MULT_ASSIGN",
    "OP_DIV_ASSIGN","OP_MOD_ASSIGN","OP_ADD_ASSIGN","OP_SUB_ASSIGN",
    "OP_SHIFT_LEFT_ASSIGN","OP_SHIFT_RIGHT_ASSIGN","OP_AND_ASSIGN",
    "OP_XOR_ASSIGN","OP_OR_ASSIGN","OP_PTR","OP_COALESCING",
    "OP_GENERICS_LT","OP_GENERICS_LT_DECL","OP_GENERICS_GT","LITERAL",
    "IDENTIFIER","OPEN_PARENS_LAMBDA","OPEN_PARENS_CAST",
    "GENERIC_DIMENSION","DEFAULT_COLON","OPEN_BRACKET_EXPR",
    "EVAL_STATEMENT_PARSER","EVAL_COMPILATION_UNIT_PARSER",
    "EVAL_USING_DECLARATIONS_UNIT_PARSER","DOC_SEE","GENERATE_COMPLETION",
    "COMPLETE_COMPLETION","UMINUS",
  };

  /** index-checked interface to yyNames[].
      @param token single character or %token value.
      @return token name or [illegal] or [unknown].
    */
//t  public static string yyname (int token) {
//t    if ((token < 0) || (token > yyNames.Length)) return "[illegal]";
//t    string name;
//t    if ((name = yyNames[token]) != null) return name;
//t    return "[unknown]";
//t  }

#pragma warning disable 414
  int yyExpectingState;
#pragma warning restore 414
  /** computes list of expected tokens on error by tracing the tables.
      @param state for which to compute the list.
      @return list of token names.
    */
  protected int [] yyExpectingTokens (int state){
    int token, n, len = 0;
    bool[] ok = new bool[yyNames.Length];
    if ((n = yySindex[state]) != 0)
      for (token = n < 0 ? -n : 0;
           (token < yyNames.Length) && (n+token < yyTable.Length); ++ token)
        if (yyCheck[n+token] == token && !ok[token] && yyNames[token] != null) {
          ++ len;
          ok[token] = true;
        }
    if ((n = yyRindex[state]) != 0)
      for (token = n < 0 ? -n : 0;
           (token < yyNames.Length) && (n+token < yyTable.Length); ++ token)
        if (yyCheck[n+token] == token && !ok[token] && yyNames[token] != null) {
          ++ len;
          ok[token] = true;
        }
    int [] result = new int [len];
    for (n = token = 0; n < len;  ++ token)
      if (ok[token]) result[n++] = token;
    return result;
  }
  protected string[] yyExpecting (int state) {
    int [] tokens = yyExpectingTokens (state);
    string [] result = new string[tokens.Length];
    for (int n = 0; n < tokens.Length;  n++)
      result[n++] = yyNames[tokens [n]];
    return result;
  }

  /** the generated parser, with debugging messages.
      Maintains a state and a value stack, currently with fixed maximum size.
      @param yyLex scanner.
      @param yydebug debug message writer implementing yyDebug, or null.
      @return result of the last reduction, if any.
      @throws yyException on irrecoverable parse error.
    */
  internal Object yyparse (yyParser.yyInput yyLex, Object yyd)
				 {
//t    this.debug = (yydebug.yyDebug)yyd;
    return yyparse(yyLex);
  }

  /** initial size and increment of the state/value stack [default 256].
      This is not final so that it can be overwritten outside of invocations
      of yyparse().
    */
  protected int yyMax;

  /** executed at the beginning of a reduce action.
      Used as $$ = yyDefault($1), prior to the user-specified action, if any.
      Can be overwritten to provide deep copy, etc.
      @param first value for $1, or null.
      @return first.
    */
  protected Object yyDefault (Object first) {
    return first;
  }

	static int[] global_yyStates;
	static object[] global_yyVals;
#pragma warning disable 649
	protected bool use_global_stacks;
#pragma warning restore 649
	object[] yyVals;					// value stack
	object yyVal;						// value stack ptr
	int yyToken;						// current input
	int yyTop;

  /** the generated parser.
      Maintains a state and a value stack, currently with fixed maximum size.
      @param yyLex scanner.
      @return result of the last reduction, if any.
      @throws yyException on irrecoverable parse error.
    */
  internal Object yyparse (yyParser.yyInput yyLex)
  {
    if (yyMax <= 0) yyMax = 256;		// initial size
    int yyState = 0;                   // state stack ptr
    int [] yyStates;               	// state stack 
    yyVal = null;
    yyToken = -1;
    int yyErrorFlag = 0;				// #tks to shift
	if (use_global_stacks && global_yyStates != null) {
		yyVals = global_yyVals;
		yyStates = global_yyStates;
   } else {
		yyVals = new object [yyMax];
		yyStates = new int [yyMax];
		if (use_global_stacks) {
			global_yyVals = yyVals;
			global_yyStates = yyStates;
		}
	}

    /*yyLoop:*/ for (yyTop = 0;; ++ yyTop) {
      if (yyTop >= yyStates.Length) {			// dynamically increase
        global::System.Array.Resize (ref yyStates, yyStates.Length+yyMax);
        global::System.Array.Resize (ref yyVals, yyVals.Length+yyMax);
      }
      yyStates[yyTop] = yyState;
      yyVals[yyTop] = yyVal;
//t      if (debug != null) debug.push(yyState, yyVal);

      /*yyDiscarded:*/ while (true) {	// discarding a token does not change stack
        int yyN;
        if ((yyN = yyDefRed[yyState]) == 0) {	// else [default] reduce (yyN)
          if (yyToken < 0) {
            yyToken = yyLex.advance() ? yyLex.token() : 0;
//t            if (debug != null)
//t              debug.lex(yyState, yyToken, yyname(yyToken), yyLex.value());
          }
          if ((yyN = yySindex[yyState]) != 0 && ((yyN += yyToken) >= 0)
              && (yyN < yyTable.Length) && (yyCheck[yyN] == yyToken)) {
//t            if (debug != null)
//t              debug.shift(yyState, yyTable[yyN], yyErrorFlag-1);
            yyState = yyTable[yyN];		// shift to yyN
            yyVal = yyLex.value();
            yyToken = -1;
            if (yyErrorFlag > 0) -- yyErrorFlag;
            goto continue_yyLoop;
          }
          if ((yyN = yyRindex[yyState]) != 0 && (yyN += yyToken) >= 0
              && yyN < yyTable.Length && yyCheck[yyN] == yyToken)
            yyN = yyTable[yyN];			// reduce (yyN)
          else
            switch (yyErrorFlag) {
  
            case 0:
              yyExpectingState = yyState;
              // yyerror(String.Format ("syntax error, got token `{0}'", yyname (yyToken)), yyExpecting(yyState));
//t              if (debug != null) debug.error("syntax error");
              if (yyToken == 0 /*eof*/ || yyToken == eof_token) throw new yyParser.yyUnexpectedEof ();
              goto case 1;
            case 1: case 2:
              yyErrorFlag = 3;
              do {
                if ((yyN = yySindex[yyStates[yyTop]]) != 0
                    && (yyN += Token.yyErrorCode) >= 0 && yyN < yyTable.Length
                    && yyCheck[yyN] == Token.yyErrorCode) {
//t                  if (debug != null)
//t                    debug.shift(yyStates[yyTop], yyTable[yyN], 3);
                  yyState = yyTable[yyN];
                  yyVal = yyLex.value();
                  goto continue_yyLoop;
                }
//t                if (debug != null) debug.pop(yyStates[yyTop]);
              } while (-- yyTop >= 0);
//t              if (debug != null) debug.reject();
              throw new yyParser.yyException("irrecoverable syntax error");
  
            case 3:
              if (yyToken == 0) {
//t                if (debug != null) debug.reject();
                throw new yyParser.yyException("irrecoverable syntax error at end-of-file");
              }
//t              if (debug != null)
//t                debug.discard(yyState, yyToken, yyname(yyToken),
//t  							yyLex.value());
              yyToken = -1;
              goto continue_yyDiscarded;		// leave stack alone
            }
        }
        int yyV = yyTop + 1-yyLen[yyN];
//t        if (debug != null)
//t          debug.reduce(yyState, yyStates[yyV-1], yyN, YYRules.getRule (yyN), yyLen[yyN]);
        yyVal = yyV > yyTop ? null : yyVals[yyV]; // yyVal = yyDefault(yyV > yyTop ? null : yyVals[yyV]);
        switch (yyN) {
case 1:
#line 385 "cs-parser.jay"
  {
		Lexer.check_incorrect_doc_comment ();
	  }
  break;
case 2:
#line 386 "cs-parser.jay"
  { Lexer.CompleteOnEOF = false; }
  break;
case 6:
  case_6();
  break;
case 7:
#line 405 "cs-parser.jay"
  {
		module.AddAttributes ((Attributes) yyVals[0+yyTop], current_namespace);
	  }
  break;
case 8:
  case_8();
  break;
case 13:
  case_13();
  break;
case 14:
#line 450 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);
	  }
  break;
case 17:
  case_17();
  break;
case 18:
  case_18();
  break;
case 19:
  case_19();
  break;
case 20:
  case_20();
  break;
case 21:
  case_21();
  break;
case 22:
  case_22();
  break;
case 23:
  case_23();
  break;
case 24:
  case_24();
  break;
case 25:
  case_25();
  break;
case 26:
  case_26();
  break;
case 39:
  case_39();
  break;
case 40:
#line 616 "cs-parser.jay"
  {
		current_namespace.DeclarationFound = true;
	  }
  break;
case 41:
  case_41();
  break;
case 49:
  case_49();
  break;
case 50:
  case_50();
  break;
case 51:
  case_51();
  break;
case 52:
  case_52();
  break;
case 53:
  case_53();
  break;
case 54:
  case_54();
  break;
case 55:
  case_55();
  break;
case 56:
  case_56();
  break;
case 57:
#line 730 "cs-parser.jay"
  { yyVal = "event"; savedCloseLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 58:
#line 731 "cs-parser.jay"
  { yyVal = "return"; savedCloseLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 59:
  case_59();
  break;
case 60:
#line 748 "cs-parser.jay"
  {
		yyVal = new List<Attribute> (4) { (Attribute) yyVals[0+yyTop] };
	  }
  break;
case 61:
  case_61();
  break;
case 62:
#line 763 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 63:
  case_63();
  break;
case 65:
#line 791 "cs-parser.jay"
  { yyVal = null; HadAttributeParens = false;  }
  break;
case 66:
  case_66();
  break;
case 67:
#line 803 "cs-parser.jay"
  { yyVal = null; }
  break;
case 68:
  case_68();
  break;
case 69:
  case_69();
  break;
case 70:
  case_70();
  break;
case 71:
  case_71();
  break;
case 72:
#line 847 "cs-parser.jay"
  {
	  	yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 74:
#line 855 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 75:
  case_75();
  break;
case 76:
  case_76();
  break;
case 77:
#line 881 "cs-parser.jay"
  { yyVal = null; }
  break;
case 78:
#line 885 "cs-parser.jay"
  { 
		yyVal = Argument.AType.Ref;
	  }
  break;
case 79:
#line 889 "cs-parser.jay"
  { 
		yyVal = Argument.AType.Out;
	  }
  break;
case 82:
#line 901 "cs-parser.jay"
  {
		lexer.parsing_modifiers = true;
	  }
  break;
case 83:
#line 905 "cs-parser.jay"
  {
		lexer.parsing_modifiers = true;
	  }
  break;
case 95:
  case_95();
  break;
case 96:
#line 936 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 97:
  case_97();
  break;
case 98:
  case_98();
  break;
case 99:
  case_99();
  break;
case 100:
  case_100();
  break;
case 101:
  case_101();
  break;
case 102:
#line 979 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);
	  }
  break;
case 103:
  case_103();
  break;
case 104:
  case_104();
  break;
case 107:
#line 1020 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 108:
#line 1024 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 109:
  case_109();
  break;
case 110:
#line 1040 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 111:
  case_111();
  break;
case 112:
  case_112();
  break;
case 115:
  case_115();
  break;
case 116:
  case_116();
  break;
case 117:
  case_117();
  break;
case 118:
  case_118();
  break;
case 119:
#line 1119 "cs-parser.jay"
  {
		report.Error (1641, GetLocation (yyVals[-1+yyTop]), "A fixed size buffer field must have the array size specifier after the field name");
	  }
  break;
case 121:
  case_121();
  break;
case 122:
  case_122();
  break;
case 125:
#line 1149 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 126:
#line 1153 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 127:
  case_127();
  break;
case 128:
#line 1166 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 129:
  case_129();
  break;
case 132:
#line 1185 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 133:
#line 1189 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 134:
  case_134();
  break;
case 135:
#line 1205 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 136:
  case_136();
  break;
case 137:
  case_137();
  break;
case 140:
  case_140();
  break;
case 141:
  case_141();
  break;
case 142:
  case_142();
  break;
case 143:
#line 1276 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.All;
	  }
  break;
case 144:
#line 1280 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 145:
  case_145();
  break;
case 146:
#line 1306 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 147:
  case_147();
  break;
case 148:
#line 1316 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 149:
  case_149();
  break;
case 150:
  case_150();
  break;
case 151:
  case_151();
  break;
case 153:
#line 1381 "cs-parser.jay"
  { savedLocation = GetLocation (yyVals[0+yyTop]); yyVal = null; }
  break;
case 154:
#line 1385 "cs-parser.jay"
  { yyVal = ParametersCompiled.EmptyReadOnlyParameters; }
  break;
case 156:
  case_156();
  break;
case 157:
  case_157();
  break;
case 158:
  case_158();
  break;
case 159:
  case_159();
  break;
case 160:
  case_160();
  break;
case 161:
  case_161();
  break;
case 162:
  case_162();
  break;
case 163:
#line 1457 "cs-parser.jay"
  {
		yyVal = new ParametersCompiled (new Parameter[] { (Parameter) yyVals[0+yyTop] } );
	  }
  break;
case 164:
#line 1461 "cs-parser.jay"
  {
		yyVal = new ParametersCompiled (new Parameter [] { new ArglistParameter (GetLocation (yyVals[0+yyTop])) }, true);
	  }
  break;
case 165:
  case_165();
  break;
case 166:
  case_166();
  break;
case 167:
  case_167();
  break;
case 168:
  case_168();
  break;
case 169:
  case_169();
  break;
case 170:
  case_170();
  break;
case 171:
  case_171();
  break;
case 172:
#line 1542 "cs-parser.jay"
  {
	  	++lexer.parsing_block;
	  }
  break;
case 173:
  case_173();
  break;
case 174:
#line 1583 "cs-parser.jay"
  { yyVal = Parameter.Modifier.NONE; }
  break;
case 176:
#line 1591 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 177:
  case_177();
  break;
case 178:
  case_178();
  break;
case 179:
  case_179();
  break;
case 180:
  case_180();
  break;
case 181:
  case_181();
  break;
case 182:
  case_182();
  break;
case 183:
  case_183();
  break;
case 184:
  case_184();
  break;
case 185:
  case_185();
  break;
case 186:
#line 1684 "cs-parser.jay"
  {
		Error_DuplicateParameterModifier (GetLocation (yyVals[-1+yyTop]), Parameter.Modifier.PARAMS);
	  }
  break;
case 187:
  case_187();
  break;
case 188:
  case_188();
  break;
case 189:
  case_189();
  break;
case 190:
  case_190();
  break;
case 191:
  case_191();
  break;
case 192:
#line 1738 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Params | ParameterModifierType.DefaultValue;
	  }
  break;
case 193:
  case_193();
  break;
case 194:
#line 1767 "cs-parser.jay"
  {
		lexer.PropertyParsing = false;
	  }
  break;
case 195:
  case_195();
  break;
case 200:
  case_200();
  break;
case 201:
  case_201();
  break;
case 202:
  case_202();
  break;
case 203:
  case_203();
  break;
case 204:
  case_204();
  break;
case 206:
  case_206();
  break;
case 207:
  case_207();
  break;
case 208:
#line 1916 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 209:
  case_209();
  break;
case 210:
  case_210();
  break;
case 211:
  case_211();
  break;
case 212:
  case_212();
  break;
case 213:
#line 1955 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);	  
	  }
  break;
case 216:
#line 1967 "cs-parser.jay"
  {
		lexer.parsing_modifiers = true;
	  }
  break;
case 217:
#line 1971 "cs-parser.jay"
  {
		lexer.parsing_modifiers = true;
	  }
  break;
case 218:
#line 1978 "cs-parser.jay"
  {
		report.Error (525, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain fields or constants");
	  }
  break;
case 219:
#line 1982 "cs-parser.jay"
  {
		report.Error (525, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain fields or constants");
	  }
  break;
case 224:
#line 1990 "cs-parser.jay"
  {
	  	report.Error (567, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain operators");
	  }
  break;
case 225:
#line 1994 "cs-parser.jay"
  {
	  	report.Error (526, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain contructors");
	  }
  break;
case 226:
#line 1998 "cs-parser.jay"
  {
	  	report.Error (524, GetLocation (yyVals[0+yyTop]), "Interfaces cannot declare classes, structs, interfaces, delegates, or enumerations");
	  }
  break;
case 227:
#line 2004 "cs-parser.jay"
  {
	  }
  break;
case 228:
  case_228();
  break;
case 230:
#line 2037 "cs-parser.jay"
  { savedLocation = GetLocation (yyVals[0+yyTop]); yyVal = null; }
  break;
case 232:
  case_232();
  break;
case 233:
#line 2053 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue;
	  }
  break;
case 234:
  case_234();
  break;
case 236:
#line 2099 "cs-parser.jay"
  { yyVal = Operator.OpType.LogicalNot; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 237:
#line 2100 "cs-parser.jay"
  { yyVal = Operator.OpType.OnesComplement; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 238:
#line 2101 "cs-parser.jay"
  { yyVal = Operator.OpType.Increment; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 239:
#line 2102 "cs-parser.jay"
  { yyVal = Operator.OpType.Decrement; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 240:
#line 2103 "cs-parser.jay"
  { yyVal = Operator.OpType.True; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 241:
#line 2104 "cs-parser.jay"
  { yyVal = Operator.OpType.False; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 242:
#line 2106 "cs-parser.jay"
  { yyVal = Operator.OpType.Addition; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 243:
#line 2107 "cs-parser.jay"
  { yyVal = Operator.OpType.Subtraction; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 244:
#line 2109 "cs-parser.jay"
  { yyVal = Operator.OpType.Multiply; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 245:
#line 2110 "cs-parser.jay"
  {  yyVal = Operator.OpType.Division; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 246:
#line 2111 "cs-parser.jay"
  { yyVal = Operator.OpType.Modulus; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 247:
#line 2112 "cs-parser.jay"
  { yyVal = Operator.OpType.BitwiseAnd; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 248:
#line 2113 "cs-parser.jay"
  { yyVal = Operator.OpType.BitwiseOr; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 249:
#line 2114 "cs-parser.jay"
  { yyVal = Operator.OpType.ExclusiveOr; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 250:
#line 2115 "cs-parser.jay"
  { yyVal = Operator.OpType.LeftShift; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 251:
#line 2116 "cs-parser.jay"
  { yyVal = Operator.OpType.RightShift; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 252:
#line 2117 "cs-parser.jay"
  { yyVal = Operator.OpType.Equality; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 253:
#line 2118 "cs-parser.jay"
  { yyVal = Operator.OpType.Inequality; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 254:
#line 2119 "cs-parser.jay"
  { yyVal = Operator.OpType.GreaterThan; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 255:
#line 2120 "cs-parser.jay"
  { yyVal = Operator.OpType.LessThan; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 256:
#line 2121 "cs-parser.jay"
  { yyVal = Operator.OpType.GreaterThanOrEqual; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 257:
#line 2122 "cs-parser.jay"
  { yyVal = Operator.OpType.LessThanOrEqual; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 258:
#line 2129 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue;
	  }
  break;
case 259:
  case_259();
  break;
case 260:
#line 2148 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue;
	  }
  break;
case 261:
  case_261();
  break;
case 262:
  case_262();
  break;
case 263:
  case_263();
  break;
case 264:
  case_264();
  break;
case 265:
  case_265();
  break;
case 266:
  case_266();
  break;
case 267:
  case_267();
  break;
case 269:
#line 2254 "cs-parser.jay"
  { current_block = null; yyVal = null; }
  break;
case 272:
#line 2266 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 273:
  case_273();
  break;
case 274:
#line 2276 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 275:
  case_275();
  break;
case 276:
  case_276();
  break;
case 277:
  case_277();
  break;
case 278:
  case_278();
  break;
case 279:
  case_279();
  break;
case 280:
  case_280();
  break;
case 281:
  case_281();
  break;
case 282:
  case_282();
  break;
case 283:
  case_283();
  break;
case 284:
  case_284();
  break;
case 286:
#line 2392 "cs-parser.jay"
  {
	  	++lexer.parsing_block;
	  }
  break;
case 287:
  case_287();
  break;
case 290:
#line 2409 "cs-parser.jay"
  {
		current_event_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 291:
#line 2413 "cs-parser.jay"
  {
		current_event_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 292:
  case_292();
  break;
case 293:
#line 2426 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 294:
  case_294();
  break;
case 295:
  case_295();
  break;
case 296:
#line 2451 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 299:
  case_299();
  break;
case 300:
  case_300();
  break;
case 301:
  case_301();
  break;
case 302:
  case_302();
  break;
case 303:
  case_303();
  break;
case 304:
  case_304();
  break;
case 305:
  case_305();
  break;
case 306:
  case_306();
  break;
case 308:
  case_308();
  break;
case 309:
  case_309();
  break;
case 310:
  case_310();
  break;
case 311:
  case_311();
  break;
case 312:
  case_312();
  break;
case 314:
  case_314();
  break;
case 315:
  case_315();
  break;
case 318:
#line 2619 "cs-parser.jay"
  {
		lbag.AppendToMember (current_container, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 320:
  case_320();
  break;
case 321:
  case_321();
  break;
case 322:
  case_322();
  break;
case 323:
  case_323();
  break;
case 324:
  case_324();
  break;
case 326:
#line 2693 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out | ParameterModifierType.Params | ParameterModifierType.DefaultValue;
	  }
  break;
case 327:
  case_327();
  break;
case 328:
#line 2712 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = false;
	  }
  break;
case 329:
  case_329();
  break;
case 331:
  case_331();
  break;
case 333:
  case_333();
  break;
case 335:
  case_335();
  break;
case 336:
  case_336();
  break;
case 338:
  case_338();
  break;
case 339:
  case_339();
  break;
case 340:
  case_340();
  break;
case 341:
  case_341();
  break;
case 342:
#line 2818 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 343:
  case_343();
  break;
case 344:
  case_344();
  break;
case 346:
  case_346();
  break;
case 347:
  case_347();
  break;
case 348:
  case_348();
  break;
case 349:
  case_349();
  break;
case 350:
  case_350();
  break;
case 351:
  case_351();
  break;
case 353:
  case_353();
  break;
case 354:
  case_354();
  break;
case 355:
  case_355();
  break;
case 356:
  case_356();
  break;
case 357:
  case_357();
  break;
case 359:
#line 2940 "cs-parser.jay"
  {
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 360:
#line 2947 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 362:
  case_362();
  break;
case 364:
  case_364();
  break;
case 366:
  case_366();
  break;
case 368:
#line 2985 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 369:
  case_369();
  break;
case 370:
#line 3004 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((ATypeNameExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 371:
  case_371();
  break;
case 372:
#line 3013 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 373:
#line 3017 "cs-parser.jay"
  {
		yyVal = new ComposedCast (new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-1+yyTop])), (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 374:
  case_374();
  break;
case 375:
  case_375();
  break;
case 376:
  case_376();
  break;
case 377:
#line 3051 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Object, GetLocation (yyVals[0+yyTop])); }
  break;
case 378:
#line 3052 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.String, GetLocation (yyVals[0+yyTop])); }
  break;
case 379:
#line 3053 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Bool, GetLocation (yyVals[0+yyTop])); }
  break;
case 380:
#line 3054 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Decimal, GetLocation (yyVals[0+yyTop])); }
  break;
case 381:
#line 3055 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Float, GetLocation (yyVals[0+yyTop])); }
  break;
case 382:
#line 3056 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Double, GetLocation (yyVals[0+yyTop])); }
  break;
case 384:
#line 3061 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.SByte, GetLocation (yyVals[0+yyTop])); }
  break;
case 385:
#line 3062 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Byte, GetLocation (yyVals[0+yyTop])); }
  break;
case 386:
#line 3063 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Short, GetLocation (yyVals[0+yyTop])); }
  break;
case 387:
#line 3064 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.UShort, GetLocation (yyVals[0+yyTop])); }
  break;
case 388:
#line 3065 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Int, GetLocation (yyVals[0+yyTop])); }
  break;
case 389:
#line 3066 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.UInt, GetLocation (yyVals[0+yyTop])); }
  break;
case 390:
#line 3067 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Long, GetLocation (yyVals[0+yyTop])); }
  break;
case 391:
#line 3068 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.ULong, GetLocation (yyVals[0+yyTop])); }
  break;
case 392:
#line 3069 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Char, GetLocation (yyVals[0+yyTop])); }
  break;
case 413:
  case_413();
  break;
case 414:
  case_414();
  break;
case 418:
#line 3116 "cs-parser.jay"
  { yyVal = new NullLiteral (GetLocation (yyVals[0+yyTop])); }
  break;
case 419:
#line 3120 "cs-parser.jay"
  { yyVal = new BoolLiteral (compiler.BuiltinTypes, true, GetLocation (yyVals[0+yyTop])); }
  break;
case 420:
#line 3121 "cs-parser.jay"
  { yyVal = new BoolLiteral (compiler.BuiltinTypes, false, GetLocation (yyVals[0+yyTop])); }
  break;
case 425:
  case_425();
  break;
case 426:
#line 3154 "cs-parser.jay"
  {
		yyVal = new ParenthesizedExpression ((Expression) yyVals[-1+yyTop]);
	  }
  break;
case 427:
  case_427();
  break;
case 428:
  case_428();
  break;
case 429:
  case_429();
  break;
case 430:
  case_430();
  break;
case 431:
#line 3189 "cs-parser.jay"
  {
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-2+yyTop], null,GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 432:
  case_432();
  break;
case 433:
#line 3197 "cs-parser.jay"
  {
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-2+yyTop], null, lexer.Location);
	  }
  break;
case 434:
  case_434();
  break;
case 435:
  case_435();
  break;
case 436:
  case_436();
  break;
case 437:
#line 3221 "cs-parser.jay"
  { yyVal = null; }
  break;
case 439:
  case_439();
  break;
case 440:
  case_440();
  break;
case 441:
#line 3244 "cs-parser.jay"
  { yyVal = null; }
  break;
case 442:
#line 3248 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	}
  break;
case 443:
  case_443();
  break;
case 444:
  case_444();
  break;
case 445:
  case_445();
  break;
case 446:
  case_446();
  break;
case 447:
#line 3281 "cs-parser.jay"
  {
		yyVal = new CompletionElementInitializer (null, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 448:
  case_448();
  break;
case 449:
  case_449();
  break;
case 450:
  case_450();
  break;
case 453:
#line 3312 "cs-parser.jay"
  { yyVal = null; }
  break;
case 455:
  case_455();
  break;
case 456:
  case_456();
  break;
case 457:
  case_457();
  break;
case 458:
  case_458();
  break;
case 459:
  case_459();
  break;
case 460:
#line 3365 "cs-parser.jay"
  {
		yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 464:
  case_464();
  break;
case 465:
  case_465();
  break;
case 466:
  case_466();
  break;
case 467:
  case_467();
  break;
case 469:
  case_469();
  break;
case 470:
  case_470();
  break;
case 471:
  case_471();
  break;
case 472:
  case_472();
  break;
case 473:
  case_473();
  break;
case 474:
  case_474();
  break;
case 475:
  case_475();
  break;
case 476:
  case_476();
  break;
case 477:
#line 3462 "cs-parser.jay"
  {
	  	yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 479:
#line 3470 "cs-parser.jay"
  {
		yyVal = new This (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 480:
  case_480();
  break;
case 481:
  case_481();
  break;
case 482:
#line 3490 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PostIncrement, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 483:
#line 3497 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PostDecrement, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 484:
  case_484();
  break;
case 485:
  case_485();
  break;
case 486:
  case_486();
  break;
case 487:
  case_487();
  break;
case 488:
  case_488();
  break;
case 489:
  case_489();
  break;
case 490:
  case_490();
  break;
case 491:
#line 3564 "cs-parser.jay"
  {
		++lexer.parsing_type;
	  }
  break;
case 492:
  case_492();
  break;
case 493:
  case_493();
  break;
case 496:
#line 3591 "cs-parser.jay"
  { yyVal = null; }
  break;
case 498:
  case_498();
  break;
case 499:
  case_499();
  break;
case 500:
  case_500();
  break;
case 501:
  case_501();
  break;
case 502:
  case_502();
  break;
case 503:
  case_503();
  break;
case 507:
  case_507();
  break;
case 508:
  case_508();
  break;
case 509:
  case_509();
  break;
case 510:
#line 3669 "cs-parser.jay"
  {
		yyVal = 2;
	  }
  break;
case 511:
#line 3673 "cs-parser.jay"
  {
		yyVal = ((int) yyVals[-1+yyTop]) + 1;
	  }
  break;
case 512:
#line 3680 "cs-parser.jay"
  {
		yyVal = null;
	  }
  break;
case 513:
#line 3684 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 514:
  case_514();
  break;
case 515:
  case_515();
  break;
case 516:
  case_516();
  break;
case 517:
  case_517();
  break;
case 518:
#line 3728 "cs-parser.jay"
  {
	  	lexer.TypeOfParsing = true;
	  }
  break;
case 519:
  case_519();
  break;
case 522:
  case_522();
  break;
case 523:
  case_523();
  break;
case 524:
  case_524();
  break;
case 525:
  case_525();
  break;
case 526:
  case_526();
  break;
case 527:
  case_527();
  break;
case 528:
  case_528();
  break;
case 529:
  case_529();
  break;
case 530:
  case_530();
  break;
case 531:
  case_531();
  break;
case 532:
  case_532();
  break;
case 533:
  case_533();
  break;
case 534:
#line 3848 "cs-parser.jay"
  {
		start_anonymous (false, (ParametersCompiled) yyVals[0+yyTop], false, GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 535:
  case_535();
  break;
case 536:
#line 3861 "cs-parser.jay"
  {
		start_anonymous (false, (ParametersCompiled) yyVals[0+yyTop], true, GetLocation (yyVals[-2+yyTop]));
	  }
  break;
case 537:
  case_537();
  break;
case 538:
#line 3878 "cs-parser.jay"
  {
		yyVal = ParametersCompiled.Undefined;
	  }
  break;
case 540:
#line 3886 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 541:
  case_541();
  break;
case 542:
  case_542();
  break;
case 544:
#line 3912 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.LogicalNot, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 545:
#line 3916 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.OnesComplement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 546:
  case_546();
  break;
case 547:
  case_547();
  break;
case 549:
#line 3952 "cs-parser.jay"
  { 
	  	yyVal = new Unary (Unary.Operator.UnaryPlus, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 550:
#line 3956 "cs-parser.jay"
  { 
		yyVal = new Unary (Unary.Operator.UnaryNegation, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 551:
#line 3960 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PreIncrement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 552:
#line 3964 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PreDecrement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 553:
#line 3968 "cs-parser.jay"
  {
		yyVal = new Indirection ((Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 554:
#line 3972 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.AddressOf, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 556:
  case_556();
  break;
case 557:
  case_557();
  break;
case 558:
  case_558();
  break;
case 560:
  case_560();
  break;
case 561:
  case_561();
  break;
case 562:
#line 4009 "cs-parser.jay"
  {
		yyVal = new As ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 563:
#line 4013 "cs-parser.jay"
  {
		yyVal = new Is ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 565:
  case_565();
  break;
case 566:
  case_566();
  break;
case 568:
  case_568();
  break;
case 569:
  case_569();
  break;
case 570:
  case_570();
  break;
case 571:
  case_571();
  break;
case 573:
  case_573();
  break;
case 574:
  case_574();
  break;
case 576:
  case_576();
  break;
case 578:
  case_578();
  break;
case 580:
  case_580();
  break;
case 582:
  case_582();
  break;
case 584:
  case_584();
  break;
case 586:
  case_586();
  break;
case 588:
  case_588();
  break;
case 589:
  case_589();
  break;
case 590:
  case_590();
  break;
case 591:
  case_591();
  break;
case 592:
  case_592();
  break;
case 593:
  case_593();
  break;
case 594:
  case_594();
  break;
case 595:
  case_595();
  break;
case 596:
  case_596();
  break;
case 597:
  case_597();
  break;
case 598:
  case_598();
  break;
case 599:
  case_599();
  break;
case 600:
  case_600();
  break;
case 601:
  case_601();
  break;
case 602:
  case_602();
  break;
case 603:
  case_603();
  break;
case 604:
  case_604();
  break;
case 605:
  case_605();
  break;
case 606:
#line 4241 "cs-parser.jay"
  { yyVal = ParametersCompiled.EmptyReadOnlyParameters; }
  break;
case 607:
  case_607();
  break;
case 610:
#line 4257 "cs-parser.jay"
  {
		start_block (Location.Null);
	  }
  break;
case 611:
  case_611();
  break;
case 613:
  case_613();
  break;
case 614:
  case_614();
  break;
case 615:
  case_615();
  break;
case 616:
  case_616();
  break;
case 617:
  case_617();
  break;
case 618:
#line 4302 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 619:
  case_619();
  break;
case 620:
  case_620();
  break;
case 621:
#line 4316 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;	  
	  }
  break;
case 622:
  case_622();
  break;
case 623:
  case_623();
  break;
case 629:
#line 4341 "cs-parser.jay"
  {
		yyVal = new ArglistAccess (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 630:
  case_630();
  break;
case 631:
  case_631();
  break;
case 632:
  case_632();
  break;
case 634:
#line 4370 "cs-parser.jay"
  {
		yyVal = new BooleanExpression ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 635:
#line 4383 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 636:
  case_636();
  break;
case 637:
  case_637();
  break;
case 638:
  case_638();
  break;
case 639:
  case_639();
  break;
case 640:
#line 4428 "cs-parser.jay"
  { yyVal = null; }
  break;
case 641:
#line 4430 "cs-parser.jay"
  { yyVal = yyVals[0+yyTop]; StoreModifierLocation (Modifiers.PARTIAL, GetLocation (yyVals[0+yyTop])); }
  break;
case 642:
  case_642();
  break;
case 643:
#line 4443 "cs-parser.jay"
  {
		lexer.parsing_modifiers = false;		
	  }
  break;
case 645:
  case_645();
  break;
case 646:
  case_646();
  break;
case 647:
  case_647();
  break;
case 648:
  case_648();
  break;
case 649:
  case_649();
  break;
case 650:
  case_650();
  break;
case 651:
  case_651();
  break;
case 652:
  case_652();
  break;
case 653:
  case_653();
  break;
case 654:
  case_654();
  break;
case 655:
  case_655();
  break;
case 656:
  case_656();
  break;
case 657:
  case_657();
  break;
case 658:
  case_658();
  break;
case 659:
  case_659();
  break;
case 660:
  case_660();
  break;
case 662:
  case_662();
  break;
case 663:
  case_663();
  break;
case 665:
#line 4569 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 666:
  case_666();
  break;
case 667:
  case_667();
  break;
case 668:
  case_668();
  break;
case 669:
  case_669();
  break;
case 670:
  case_670();
  break;
case 671:
  case_671();
  break;
case 672:
  case_672();
  break;
case 673:
  case_673();
  break;
case 674:
#line 4662 "cs-parser.jay"
  {
		yyVal = new SpecialContraintExpr (SpecialConstraint.Class, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 675:
#line 4666 "cs-parser.jay"
  {
		yyVal = new SpecialContraintExpr (SpecialConstraint.Struct, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 676:
#line 4673 "cs-parser.jay"
  {
		yyVal = Variance.None;
	  }
  break;
case 677:
  case_677();
  break;
case 678:
  case_678();
  break;
case 679:
  case_679();
  break;
case 680:
  case_680();
  break;
case 681:
#line 4718 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 682:
  case_682();
  break;
case 683:
  case_683();
  break;
case 684:
  case_684();
  break;
case 685:
  case_685();
  break;
case 686:
  case_686();
  break;
case 691:
#line 4767 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 692:
#line 4771 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 694:
  case_694();
  break;
case 695:
  case_695();
  break;
case 698:
#line 4805 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 699:
#line 4809 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 728:
  case_728();
  break;
case 729:
  case_729();
  break;
case 730:
  case_730();
  break;
case 731:
  case_731();
  break;
case 732:
  case_732();
  break;
case 735:
  case_735();
  break;
case 736:
  case_736();
  break;
case 737:
  case_737();
  break;
case 738:
  case_738();
  break;
case 739:
#line 4953 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 740:
#line 4957 "cs-parser.jay"
  {
		yyVal = new ComposedCast (new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-1+yyTop])), (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 741:
  case_741();
  break;
case 743:
  case_743();
  break;
case 744:
#line 4978 "cs-parser.jay"
  {
		yyVal = ComposedTypeSpecifier.CreatePointer (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 746:
  case_746();
  break;
case 747:
  case_747();
  break;
case 748:
  case_748();
  break;
case 749:
  case_749();
  break;
case 750:
  case_750();
  break;
case 752:
  case_752();
  break;
case 754:
  case_754();
  break;
case 755:
  case_755();
  break;
case 756:
  case_756();
  break;
case 760:
  case_760();
  break;
case 763:
  case_763();
  break;
case 764:
  case_764();
  break;
case 765:
#line 5113 "cs-parser.jay"
  {
		report.Error (145, lexer.Location, "A const field requires a value to be provided");
	  }
  break;
case 766:
  case_766();
  break;
case 771:
  case_771();
  break;
case 773:
  case_773();
  break;
case 774:
  case_774();
  break;
case 775:
  case_775();
  break;
case 776:
#line 5163 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 777:
  case_777();
  break;
case 778:
#line 5173 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 779:
#line 5174 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 780:
  case_780();
  break;
case 781:
  case_781();
  break;
case 782:
  case_782();
  break;
case 785:
  case_785();
  break;
case 786:
  case_786();
  break;
case 787:
  case_787();
  break;
case 788:
#line 5249 "cs-parser.jay"
  {
		start_block (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 789:
  case_789();
  break;
case 790:
  case_790();
  break;
case 791:
  case_791();
  break;
case 793:
  case_793();
  break;
case 794:
  case_794();
  break;
case 795:
  case_795();
  break;
case 796:
#line 5300 "cs-parser.jay"
  {
		current_block = current_block.CreateSwitchBlock (lexer.Location);
	  }
  break;
case 797:
#line 5304 "cs-parser.jay"
  {
		yyVal = new SwitchSection ((List<SwitchLabel>) yyVals[-2+yyTop], current_block);
	  }
  break;
case 798:
  case_798();
  break;
case 799:
  case_799();
  break;
case 800:
  case_800();
  break;
case 801:
  case_801();
  break;
case 802:
#line 5338 "cs-parser.jay"
  {
		yyVal = new SwitchLabel (null, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 807:
  case_807();
  break;
case 808:
  case_808();
  break;
case 809:
  case_809();
  break;
case 810:
  case_810();
  break;
case 811:
  case_811();
  break;
case 812:
  case_812();
  break;
case 813:
#line 5399 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 814:
  case_814();
  break;
case 815:
#line 5414 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 816:
  case_816();
  break;
case 817:
  case_817();
  break;
case 818:
#line 5435 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 819:
  case_819();
  break;
case 820:
  case_820();
  break;
case 821:
  case_821();
  break;
case 822:
#line 5469 "cs-parser.jay"
  { yyVal = new EmptyStatement (lexer.Location); }
  break;
case 824:
  case_824();
  break;
case 825:
  case_825();
  break;
case 827:
#line 5490 "cs-parser.jay"
  { yyVal = null; }
  break;
case 829:
#line 5495 "cs-parser.jay"
  { yyVal = new EmptyStatement (lexer.Location); }
  break;
case 833:
  case_833();
  break;
case 834:
  case_834();
  break;
case 835:
  case_835();
  break;
case 836:
  case_836();
  break;
case 837:
  case_837();
  break;
case 838:
  case_838();
  break;
case 839:
  case_839();
  break;
case 846:
  case_846();
  break;
case 847:
  case_847();
  break;
case 848:
  case_848();
  break;
case 849:
  case_849();
  break;
case 850:
  case_850();
  break;
case 851:
  case_851();
  break;
case 852:
  case_852();
  break;
case 853:
  case_853();
  break;
case 854:
  case_854();
  break;
case 855:
  case_855();
  break;
case 856:
  case_856();
  break;
case 857:
  case_857();
  break;
case 858:
  case_858();
  break;
case 859:
  case_859();
  break;
case 862:
#line 5735 "cs-parser.jay"
  {
		yyVal = new TryCatch ((Block) yyVals[-1+yyTop], (List<Catch>) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]), false);
	  }
  break;
case 863:
  case_863();
  break;
case 864:
  case_864();
  break;
case 865:
  case_865();
  break;
case 866:
  case_866();
  break;
case 867:
  case_867();
  break;
case 870:
#line 5785 "cs-parser.jay"
  {
		yyVal = new Catch ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 871:
  case_871();
  break;
case 872:
#line 5804 "cs-parser.jay"
  {
		yyVal = yyVals[-1+yyTop];
	  }
  break;
case 873:
  case_873();
  break;
case 874:
#line 5822 "cs-parser.jay"
  {
		yyVal = new Checked ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 875:
#line 5829 "cs-parser.jay"
  {
		yyVal = new Unchecked ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 876:
  case_876();
  break;
case 877:
#line 5839 "cs-parser.jay"
  {
		yyVal = new Unsafe ((Block) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }
  break;
case 878:
  case_878();
  break;
case 879:
  case_879();
  break;
case 880:
  case_880();
  break;
case 881:
  case_881();
  break;
case 882:
  case_882();
  break;
case 883:
  case_883();
  break;
case 884:
  case_884();
  break;
case 885:
  case_885();
  break;
case 886:
  case_886();
  break;
case 887:
  case_887();
  break;
case 889:
  case_889();
  break;
case 890:
#line 5944 "cs-parser.jay"
  {
		Error_MissingInitializer (lexer.Location);
	  }
  break;
case 891:
  case_891();
  break;
case 892:
  case_892();
  break;
case 893:
  case_893();
  break;
case 894:
  case_894();
  break;
case 895:
  case_895();
  break;
case 896:
  case_896();
  break;
case 897:
  case_897();
  break;
case 898:
  case_898();
  break;
case 899:
  case_899();
  break;
case 900:
#line 6049 "cs-parser.jay"
  {
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 901:
  case_901();
  break;
case 902:
#line 6065 "cs-parser.jay"
  {
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 903:
  case_903();
  break;
case 904:
  case_904();
  break;
case 905:
  case_905();
  break;
case 907:
  case_907();
  break;
case 908:
  case_908();
  break;
case 909:
#line 6129 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 910:
  case_910();
  break;
case 911:
  case_911();
  break;
case 912:
  case_912();
  break;
case 913:
  case_913();
  break;
case 915:
  case_915();
  break;
case 921:
#line 6183 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 922:
  case_922();
  break;
case 923:
#line 6202 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 924:
  case_924();
  break;
case 925:
  case_925();
  break;
case 926:
  case_926();
  break;
case 927:
  case_927();
  break;
case 928:
  case_928();
  break;
case 929:
  case_929();
  break;
case 930:
  case_930();
  break;
case 931:
  case_931();
  break;
case 932:
  case_932();
  break;
case 934:
  case_934();
  break;
case 935:
#line 6356 "cs-parser.jay"
  {
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 936:
  case_936();
  break;
case 938:
  case_938();
  break;
case 939:
  case_939();
  break;
case 941:
  case_941();
  break;
case 942:
  case_942();
  break;
case 943:
#line 6402 "cs-parser.jay"
  {
		yyVal = new Linq.OrderByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[0+yyTop]);	
	  }
  break;
case 944:
  case_944();
  break;
case 945:
  case_945();
  break;
case 946:
#line 6419 "cs-parser.jay"
  {
		yyVal = new Linq.ThenByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[0+yyTop]);	
	  }
  break;
case 947:
  case_947();
  break;
case 948:
  case_948();
  break;
case 950:
  case_950();
  break;
case 951:
  case_951();
  break;
case 954:
  case_954();
  break;
case 955:
  case_955();
  break;
case 963:
#line 6541 "cs-parser.jay"
  {
		module.DocumentationBuilder.ParsedName = (MemberName) yyVals[0+yyTop];
	  }
  break;
case 964:
#line 6548 "cs-parser.jay"
  {
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
	  }
  break;
case 965:
  case_965();
  break;
case 966:
  case_966();
  break;
case 967:
#line 6565 "cs-parser.jay"
  {
		yyVal = new MemberName ((MemberName) yyVals[-2+yyTop], MemberCache.IndexerNameAlias, Location.Null);
	  }
  break;
case 968:
#line 6569 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 969:
  case_969();
  break;
case 970:
  case_970();
  break;
case 971:
  case_971();
  break;
case 972:
  case_972();
  break;
case 974:
#line 6605 "cs-parser.jay"
  {
		yyVal = new MemberName (((MemberName) yyVals[-2+yyTop]), (MemberName) yyVals[0+yyTop]);
	  }
  break;
case 976:
#line 6613 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 977:
#line 6617 "cs-parser.jay"
  {
		yyVal = yyVals[-1+yyTop];
	  }
  break;
case 978:
#line 6624 "cs-parser.jay"
  {
		yyVal = new List<DocumentationParameter> (0);
	  }
  break;
case 980:
  case_980();
  break;
case 981:
  case_981();
  break;
case 982:
  case_982();
  break;
#line default
        }
        yyTop -= yyLen[yyN];
        yyState = yyStates[yyTop];
        int yyM = yyLhs[yyN];
        if (yyState == 0 && yyM == 0) {
//t          if (debug != null) debug.shift(0, yyFinal);
          yyState = yyFinal;
          if (yyToken < 0) {
            yyToken = yyLex.advance() ? yyLex.token() : 0;
//t            if (debug != null)
//t               debug.lex(yyState, yyToken,yyname(yyToken), yyLex.value());
          }
          if (yyToken == 0) {
//t            if (debug != null) debug.accept(yyVal);
            return yyVal;
          }
          goto continue_yyLoop;
        }
        if (((yyN = yyGindex[yyM]) != 0) && ((yyN += yyState) >= 0)
            && (yyN < yyTable.Length) && (yyCheck[yyN] == yyState))
          yyState = yyTable[yyN];
        else
          yyState = yyDgoto[yyM];
//t        if (debug != null) debug.shift(yyStates[yyTop], yyState);
	 goto continue_yyLoop;
      continue_yyDiscarded: ;	// implements the named-loop continue: 'continue yyDiscarded'
      }
    continue_yyLoop: ;		// implements the named-loop continue: 'continue yyLoop'
    }
  }

/*
 All more than 3 lines long rules are wrapped into a method
*/
void case_6()
#line 393 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			Attributes attrs = (Attributes) yyVals[0+yyTop];
			report.Error (1730, attrs.Attrs [0].Location,
				"Assembly and module attributes must precede all other elements except using clauses and extern alias declarations");

			current_namespace.UnattachedAttributes = attrs;
		}
	  }

void case_8()
#line 407 "cs-parser.jay"
{
		if (yyToken == Token.EXTERN_ALIAS)
			report.Error (439, lexer.Location, "An extern alias declaration must precede all other elements");
		else
			Error_SyntaxError (yyToken);
	  }

void case_13()
#line 427 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		string s = lt.Value;
		if (s != "alias") {
			syntax_error (lt.Location, "`alias' expected");
		} else {
			if (lang_version == LanguageVersion.ISO_1)
				FeatureIsNotAvailable (lt.Location, "external alias");

			lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
			if (lt.Value == QualifiedAliasMember.GlobalAlias) {
				RootNamespace.Error_GlobalNamespaceRedefined (report, lt.Location);
			}
			
			var na = new UsingExternAlias (new SimpleMemberName (lt.Value, lt.Location), GetLocation (yyVals[-3+yyTop]));
			current_namespace.AddUsing (na);
			
			lbag.AddLocation (na, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
	  }

void case_17()
#line 460 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_18()
#line 468 "cs-parser.jay"
{
		var un = new UsingNamespace ((ATypeNameExpression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		current_namespace.AddUsing (un);
		
		lbag.AddLocation (un, GetLocation (yyVals[0+yyTop]));
	  }

void case_19()
#line 475 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		if (lang_version != LanguageVersion.ISO_1 && lt.Value == "global") {
			report.Warning (440, 2, lt.Location,
			 "An alias named `global' will not be used when resolving `global::'. The global namespace will be used instead");
		}

		var un = new UsingAliasNamespace (new SimpleMemberName (lt.Value, lt.Location), (ATypeNameExpression) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		current_namespace.AddUsing (un);
		lbag.AddLocation (un, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_20()
#line 487 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	 }

void case_21()
#line 500 "cs-parser.jay"
{
		Attributes attrs = (Attributes) yyVals[-2+yyTop];
		var name = (MemberName) yyVals[0+yyTop];
		if (attrs != null) {
			bool valid_global_attrs = true;
			if ((current_namespace.DeclarationFound || current_namespace != file)) {
				valid_global_attrs = false;
			} else {
				foreach (var a in attrs.Attrs) {
					if (a.ExplicitTarget == "assembly" || a.ExplicitTarget == "module")
						continue;
						
					valid_global_attrs = false;
					break;
				}
			}
			
			if (!valid_global_attrs)
				report.Error (1671, name.Location, "A namespace declaration cannot have modifiers or attributes");
		}
	
		module.AddAttributes (attrs, current_namespace);
		
		var ns = new NamespaceContainer (name, current_namespace);
		current_namespace.AddTypeContainer (ns);
		current_container = current_namespace = ns;
	  }

void case_22()
#line 528 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_23()
#line 533 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null)
			lbag.AddLocation (current_container, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
		else
			lbag.AddLocation (current_container, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  
		current_container = current_namespace = current_namespace.Parent;
	  }

void case_24()
#line 545 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new MemberName (lt.Value, lt.Location);
	  }

void case_25()
#line 550 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-2+yyTop], lt.Value, lt.Location) {
			DotLocation = GetLocation (yyVals[-1+yyTop])
		};
	  }

void case_26()
#line 557 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new MemberName ("<invalid>", lexer.Location);
	  }

void case_39()
#line 595 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			TypeContainer ds = (TypeContainer)yyVals[0+yyTop];

			if ((ds.ModFlags & (Modifiers.PRIVATE | Modifiers.PROTECTED)) != 0){
				report.Error (1527, ds.Location, 
				"Namespace elements cannot be explicitly declared as private, protected or protected internal");
			}

			/* Here is a trick, for explicit attributes we don't know where they belong to until*/
			/* we parse succeeding declaration hence we parse them as normal and re-attach them*/
			/* when we know whether they are global (assembly:, module:) or local (type:).*/
			if (ds.OptAttributes != null) {
				ds.OptAttributes.ConvertGlobalAttributes (ds, current_namespace, !current_namespace.DeclarationFound && current_namespace == file);
			}
		}
		current_namespace.DeclarationFound = true;
	  }

void case_41()
#line 617 "cs-parser.jay"
{
		current_namespace.UnattachedAttributes = (Attributes) yyVals[-1+yyTop];
		report.Error (1518, lexer.Location, "Attributes must be attached to class, delegate, enum, interface or struct");
		lexer.putback ('}');
	  }

void case_49()
#line 650 "cs-parser.jay"
{
		var sect = (List<Attribute>) yyVals[0+yyTop];
		yyVal = new Attributes (sect);
		if (locationListStack.Count > 0)
			lbag.AddLocation (sect, locationListStack.Pop ());
		if (attributeCommas.Count > 0) {
			lbag.AppendTo (sect, attributeCommas);
			attributeCommas.Clear ();
		}
	  }

void case_50()
#line 661 "cs-parser.jay"
{
		Attributes attrs = yyVals[-1+yyTop] as Attributes;
		var sect = (List<Attribute>) yyVals[0+yyTop];
		
		if (locationListStack.Count > 0)
			lbag.AddLocation (sect, locationListStack.Pop ());
		if (attrs == null)
			attrs = new Attributes (sect);
		else
			attrs.AddAttributes (sect);
		yyVal = attrs;
	  }

void case_51()
#line 677 "cs-parser.jay"
{
		lexer.parsing_attribute_section = true;
		savedOpenLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_52()
#line 682 "cs-parser.jay"
{
		lexer.parsing_attribute_section = false;
		yyVal = yyVals[0+yyTop];
	  }

void case_53()
#line 690 "cs-parser.jay"
{
		current_attr_target = (string) yyVals[-1+yyTop];
		if (current_attr_target == "assembly" || current_attr_target == "module") {
			Lexer.check_incorrect_doc_comment ();
		}
	  }

void case_54()
#line 697 "cs-parser.jay"
{
		/* when attribute target is invalid*/
		if (current_attr_target == string.Empty)
			yyVal = new List<Attribute> (0);
		else
			yyVal = yyVals[-2+yyTop];
	  
		current_attr_target = null;
		lexer.parsing_attribute_section = false;
		if (yyVals[-1+yyTop] != null) {
			locationListStack.Push (new List<Location>(new [] { savedOpenLocation, savedCloseLocation, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]) }));
		} else {
			locationListStack.Push (new List<Location>(new [] { savedOpenLocation, savedCloseLocation, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[0+yyTop]) }));
		}
 	  }

void case_55()
#line 713 "cs-parser.jay"
{
		yyVal = yyVals[-2+yyTop];
		if (yyVals[-1+yyTop] != null) {
			locationListStack.Push (new List<Location>(new [] { savedOpenLocation, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]) }));
		} else {
			locationListStack.Push (new List<Location>(new [] { savedOpenLocation, GetLocation (yyVals[0+yyTop]) }));
		}
	  }

void case_56()
#line 725 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = CheckAttributeTarget (lt.Value, lt.Location);
		savedCloseLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_59()
#line 733 "cs-parser.jay"
{
		if (yyToken == Token.IDENTIFIER) {
			Error_SyntaxError (yyToken);
			yyVal = null;
		} else {
			string name = GetTokenName (yyToken);
			yyVal = CheckAttributeTarget (name, GetLocation (yyVals[0+yyTop]));
		}
	  }

void case_61()
#line 750 "cs-parser.jay"
{
		var attrs = (List<Attribute>) yyVals[-2+yyTop];
		attrs.Add ((Attribute) yyVals[0+yyTop]);
		attributeCommas.Add (GetLocation (yyVals[-1+yyTop]));

		yyVal = attrs;
	  }

void case_63()
#line 765 "cs-parser.jay"
{
		--lexer.parsing_block;
		
		var tne = (ATypeNameExpression) yyVals[-2+yyTop];
		if (tne.HasTypeArguments) {
			report.Error (404, tne.Location, "Attributes cannot be generic");
		}
		Arguments [] arguments = (Arguments []) yyVals[0+yyTop];

		yyVal = new Attribute (current_attr_target, tne, (Arguments[]) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]), lexer.IsEscapedIdentifier (tne));
		if (arguments != null) {
			attributeArgumentCommas.Insert (0, savedAttrParenOpenLocation);
			attributeArgumentCommas.Add (savedAttrParenCloseLocation);
			lbag.AddLocation (yyVal, attributeArgumentCommas);
			attributeArgumentCommas.Clear ();
		} else if (HadAttributeParens) {
			lbag.AddLocation (yyVal, savedAttrParenOpenLocation, savedAttrParenCloseLocation);
		}
	  }

void case_66()
#line 793 "cs-parser.jay"
{
		savedAttrParenOpenLocation = GetLocation (yyVals[-2+yyTop]);
		savedAttrParenCloseLocation = GetLocation (yyVals[0+yyTop]);
		yyVal = yyVals[-1+yyTop];
		HadAttributeParens = true;
	  }

void case_68()
#line 805 "cs-parser.jay"
{
	  	Arguments a = new Arguments (4);
		a.Add ((Argument) yyVals[0+yyTop]);
		yyVal = new Arguments [] { a, null };
	  }

void case_69()
#line 811 "cs-parser.jay"
{
	  	Arguments a = new Arguments (4);
		a.Add ((Argument) yyVals[0+yyTop]);  
		yyVal = new Arguments [] { null, a };
	  }

void case_70()
#line 817 "cs-parser.jay"
{
		Arguments[] o = (Arguments[]) yyVals[-2+yyTop];
		if (o [1] != null) {
			report.Error (1016, ((Argument) yyVals[0+yyTop]).Expr.Location, "Named attribute arguments must appear after the positional arguments");
			o [0] = new Arguments (4);
		}
		
		Arguments args = ((Arguments) o [0]);
		if (args.Count > 0 && !(yyVals[0+yyTop] is NamedArgument) && args [args.Count - 1] is NamedArgument)
			Error_NamedArgumentExpected ((NamedArgument) args [args.Count - 1]);
		
		args.Add ((Argument) yyVals[0+yyTop]);
		attributeArgumentCommas.Add (GetLocation (yyVals[-1+yyTop]));
	  }

void case_71()
#line 832 "cs-parser.jay"
{
		Arguments[] o = (Arguments[]) yyVals[-2+yyTop];
		if (o [1] == null) {
			o [1] = new Arguments (4);
		}

		((Arguments) o [1]).Add ((Argument) yyVals[0+yyTop]);
		attributeArgumentCommas.Add (GetLocation (yyVals[-1+yyTop]));
	  }

void case_75()
#line 857 "cs-parser.jay"
{
	  	--lexer.parsing_block;
	  	var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		yyVal = new NamedArgument (lt.Value, lt.Location, (Expression) yyVals[0+yyTop]);	  
		lbag.AddLocation (yyVal, GetLocation(yyVals[-2+yyTop]));
	  }

void case_76()
#line 867 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.V_3)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "named argument");
			
		/* Avoid boxing in common case (no modifier)*/
		var arg_mod = yyVals[-1+yyTop] == null ? Argument.AType.None : (Argument.AType) yyVals[-1+yyTop];
			
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		yyVal = new NamedArgument (lt.Value, lt.Location, (Expression) yyVals[0+yyTop], arg_mod);
		lbag.AddLocation (yyVal, GetLocation(yyVals[-2+yyTop]));
	  }

void case_95()
#line 921 "cs-parser.jay"
{
		report.Error (1519, lexer.Location, "Unexpected symbol `{0}' in class, struct, or interface member declaration",
			GetSymbolName (yyToken));
		yyVal = null;
		lexer.parsing_generic_declaration = false;
	  }

void case_97()
#line 938 "cs-parser.jay"
{ 
		push_current_container (new Struct (current_container, (MemberName) yyVals[0+yyTop], (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]), yyVals[-3+yyTop]);
		lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]));
	  }

void case_98()
#line 944 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		if (yyVals[0+yyTop] != null)
			current_container.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support)
			current_container.PartialContainer.DocComment = Lexer.consume_doc_comment ();

		
		lexer.parsing_modifiers = true;
	  }

void case_99()
#line 957 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_100()
#line 962 "cs-parser.jay"
{
		--lexer.parsing_declaration;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_101()
#line 968 "cs-parser.jay"
{
		if (yyVals[0+yyTop] == null) {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]));
		} else {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = pop_current_class ();
	  }

void case_103()
#line 986 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var mod = (Modifiers) yyVals[-3+yyTop];
		current_field = new Const (current_type, (FullNamedExpression) yyVals[-1+yyTop], mod, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
		current_type.AddMember (current_field);
		
		if ((mod & Modifiers.STATIC) != 0) {
			report.Error (504, current_field.Location, "The constant `{0}' cannot be marked static", current_field.GetSignatureForError ());
		}
		
		yyVal = current_field;
	  }

void case_104()
#line 999 "cs-parser.jay"
{
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		current_field.Initializer = (ConstInitializer) yyVals[-2+yyTop];
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		current_field = null;
	  }

void case_109()
#line 1029 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (ConstInitializer) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_111()
#line 1042 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = new ConstInitializer (current_field, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_112()
#line 1048 "cs-parser.jay"
{
		report.Error (145, lexer.Location, "A const field requires a value to be provided");
		yyVal = null;
	  }

void case_115()
#line 1063 "cs-parser.jay"
{
	  	lexer.parsing_generic_declaration = false;

		FullNamedExpression type = (FullNamedExpression) yyVals[-1+yyTop];
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (670, GetLocation (yyVals[-1+yyTop]), "Fields cannot have void type");
			
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		current_field = new Field (current_type, type, (Modifiers) yyVals[-2+yyTop], new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-3+yyTop]);
		current_type.AddField (current_field);
		yyVal = current_field;
	  }

void case_116()
#line 1078 "cs-parser.jay"
{ 
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
			
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[0+yyTop]));
		yyVal = current_field;
		current_field = null;
	  }

void case_117()
#line 1091 "cs-parser.jay"
{ 
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "fixed size buffers");

		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		current_field = new FixedField (current_type, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop],
			new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
			
		current_type.AddField (current_field);
	  }

void case_118()
#line 1102 "cs-parser.jay"
{
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
	    }

		current_field.Initializer = (ConstInitializer) yyVals[-2+yyTop];	    
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = current_field;
	    current_field = null;
	  }

void case_121()
#line 1125 "cs-parser.jay"
{
	  	++lexer.parsing_block;
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  	start_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_122()
#line 1131 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		current_field.Initializer = (Expression) yyVals[0+yyTop];
		lbag.AppendToMember (current_field, GetLocation (yyVals[-2+yyTop]));
		end_block (lexer.Location);
		current_local_parameters = null;
	  }

void case_127()
#line 1158 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), null);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_129()
#line 1168 "cs-parser.jay"
{
		--lexer.parsing_block;
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];	  
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (Expression) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_134()
#line 1194 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];	  
		yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (ConstInitializer) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_136()
#line 1207 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = new ConstInitializer (current_field, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_137()
#line 1213 "cs-parser.jay"
{
		report.Error (443, lexer.Location, "Value or constant expected");
		yyVal = null;
	  }

void case_140()
#line 1223 "cs-parser.jay"
{
		/* It has to be here for the parent to safely restore artificial block*/
	  	Error_SyntaxError (yyToken);
	  	yyVal = null;
	  }

void case_141()
#line 1232 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.NotAllowed;

		/* Add it early in the case of body being eof for full ast*/
		Method m = (Method) yyVals[0+yyTop];
		async_block = (m.ModFlags & Modifiers.ASYNC) != 0;
		current_type.AddMember (m);
	  }

void case_142()
#line 1242 "cs-parser.jay"
{
		Method method = (Method) yyVals[-2+yyTop];
		method.Block = (ToplevelBlock) yyVals[0+yyTop];
		async_block = false;
		
		if (method.Block == null) {
			lbag.AppendToMember (method, savedLocation); /* semicolon*/
			method.ParameterInfo.CheckParameters (method);

			if ((method.ModFlags & Modifiers.ASYNC) != 0) {
				report.Error (1994, method.Location, "`{0}': The async modifier can only be used with methods that have a body",
					method.GetSignatureForError ());
			}
		} else {
			if (current_container.Kind == MemberKind.Interface) {
				report.Error (531, method.Location, "`{0}': interface members cannot have a definition",
					method.GetSignatureForError ());
			}
		}

		current_local_parameters = null;

		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_145()
#line 1282 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;
		valid_param_mod = 0;
		MemberName name = (MemberName) yyVals[-6+yyTop];
		current_local_parameters = (ParametersCompiled) yyVals[-3+yyTop];

		var method = Method.Create (current_type, (FullNamedExpression) yyVals[-7+yyTop], (Modifiers) yyVals[-8+yyTop],
				     name, current_local_parameters, (Attributes) yyVals[-9+yyTop], yyVals[0+yyTop] != null);

		if (yyVals[0+yyTop] != null)
			method.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);
				     
		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		lbag.AddMember (method, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = method;
	  }

void case_147()
#line 1309 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
	  	valid_param_mod = ParameterModifierType.All;
	  }

void case_149()
#line 1318 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;
		valid_param_mod = 0;

		MemberName name = (MemberName) yyVals[-6+yyTop];
		current_local_parameters = (ParametersCompiled) yyVals[-3+yyTop];

		var modifiers = (Modifiers) yyVals[-10+yyTop];
		modifiers |= Modifiers.PARTIAL;

		var method = Method.Create (current_type, new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-8+yyTop])),
				     modifiers, name, current_local_parameters, (Attributes) yyVals[-11+yyTop], yyVals[-1+yyTop] != null);

		if (yyVals[-1+yyTop] != null)
			method.SetConstraints ((List<Constraints>) yyVals[-1+yyTop]);

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		StoreModifierLocation (Modifiers.PARTIAL, GetLocation (yyVals[-9+yyTop]));
		lbag.AddMember (method, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = method;
	  }

void case_150()
#line 1345 "cs-parser.jay"
{
		MemberName name = (MemberName) yyVals[-3+yyTop];
		report.Error (1585, name.Location, 
			"Member modifier `{0}' must precede the member type and name", ModifiersExtensions.Name ((Modifiers) yyVals[-4+yyTop]));

		var method = Method.Create (current_type, (FullNamedExpression) yyVals[-5+yyTop],
					    0, name, (ParametersCompiled) yyVals[-1+yyTop], (Attributes) yyVals[-7+yyTop], false);

		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		yyVal = method;
	  }

void case_151()
#line 1364 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		current_local_parameters = ParametersCompiled.Undefined;

		MemberName name = (MemberName) yyVals[-1+yyTop];
		var method = Method.Create (current_type, (FullNamedExpression) yyVals[-2+yyTop], (Modifiers) yyVals[-3+yyTop],
									name, current_local_parameters, (Attributes) yyVals[-4+yyTop], false);

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		yyVal = method;
	  }

void case_156()
#line 1391 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[0+yyTop];
	  	yyVal = new ParametersCompiled (pars_list.ToArray ());
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_157()
#line 1397 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[-2+yyTop];
		pars_list.Add ((Parameter) yyVals[0+yyTop]);
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));
		
		yyVal = new ParametersCompiled (pars_list.ToArray ()); 
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_158()
#line 1406 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[-2+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[0+yyTop])));
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));
		
		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_159()
#line 1415 "cs-parser.jay"
{
		if (yyVals[-2+yyTop] != null)
			report.Error (231, ((Parameter) yyVals[-2+yyTop]).Location, "A params parameter must be the last parameter in a formal parameter list");

		yyVal = new ParametersCompiled (new Parameter[] { (Parameter) yyVals[-2+yyTop] } );			
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_160()
#line 1423 "cs-parser.jay"
{
		if (yyVals[-2+yyTop] != null)
			report.Error (231, ((Parameter) yyVals[-2+yyTop]).Location, "A params parameter must be the last parameter in a formal parameter list");

		var pars_list = (List<Parameter>) yyVals[-4+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[-2+yyTop])));
		parameterListCommas.Add (GetLocation (yyVals[-3+yyTop]));
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));
		
		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_161()
#line 1436 "cs-parser.jay"
{
		report.Error (257, GetLocation (yyVals[-2+yyTop]), "An __arglist parameter must be the last parameter in a formal parameter list");

		yyVal = new ParametersCompiled (new Parameter [] { new ArglistParameter (GetLocation (yyVals[-2+yyTop])) }, true);
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_162()
#line 1443 "cs-parser.jay"
{
		report.Error (257, GetLocation (yyVals[-2+yyTop]), "An __arglist parameter must be the last parameter in a formal parameter list");

		var pars_list = (List<Parameter>) yyVals[-4+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[-2+yyTop])));
		parameterListCommas.Add (GetLocation (yyVals[-3+yyTop]));
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));

		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_165()
#line 1463 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = ParametersCompiled.EmptyReadOnlyParameters;
	  }

void case_166()
#line 1471 "cs-parser.jay"
{
		parameters_bucket.Clear ();
		Parameter p = (Parameter) yyVals[0+yyTop];
		parameters_bucket.Add (p);
		parameterListCommas.Clear ();
		default_parameter_used = p.HasDefaultValue;
		yyVal = parameters_bucket;
	  }

void case_167()
#line 1480 "cs-parser.jay"
{
		var pars = (List<Parameter>) yyVals[-2+yyTop];
		Parameter p = (Parameter) yyVals[0+yyTop];
		if (p != null) {
			if (p.HasExtensionMethodModifier)
				report.Error (1100, p.Location, "The parameter modifier `this' can only be used on the first parameter");
			else if (!p.HasDefaultValue && default_parameter_used)
				report.Error (1737, p.Location, "Optional parameter cannot precede required parameters");

			default_parameter_used |= p.HasDefaultValue;
			pars.Add (p);
			
			parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));
		}
		
		yyVal = yyVals[-2+yyTop];
	  }

void case_168()
#line 1504 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Parameter.Modifier) yyVals[-2+yyTop], (Attributes) yyVals[-3+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_169()
#line 1513 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		report.Error (1552, lt.Location, "Array type specifier, [], must appear before parameter name");
		yyVal = new Parameter ((FullNamedExpression) yyVals[-3+yyTop], lt.Value, (Parameter.Modifier) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_170()
#line 1520 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  	Location l = GetLocation (yyVals[0+yyTop]);
		yyVal = new Parameter (null, null, Parameter.Modifier.NONE, (Attributes) yyVals[-1+yyTop], l);
	  }

void case_171()
#line 1529 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  	Location l = GetLocation (yyVals[0+yyTop]);
		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], null, (Parameter.Modifier) yyVals[-2+yyTop], (Attributes) yyVals[-3+yyTop], l);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_173()
#line 1544 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		if (lang_version <= LanguageVersion.V_3) {
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "optional parameter");
		}
		
		Parameter.Modifier mod = (Parameter.Modifier) yyVals[-5+yyTop];
		if (mod != Parameter.Modifier.NONE) {
			switch (mod) {
			case Parameter.Modifier.REF:
			case Parameter.Modifier.OUT:
				report.Error (1741, GetLocation (yyVals[-5+yyTop]), "Cannot specify a default value for the `{0}' parameter",
					Parameter.GetModifierSignature (mod));
				break;
				
			case Parameter.Modifier.This:
				report.Error (1743, GetLocation (yyVals[-5+yyTop]), "Cannot specify a default value for the `{0}' parameter",
					Parameter.GetModifierSignature (mod));
				break;
			default:
				throw new NotImplementedException (mod.ToString ());
			}
				
			mod = Parameter.Modifier.NONE;
		}
		
		if ((valid_param_mod & ParameterModifierType.DefaultValue) == 0)
			report.Error (1065, GetLocation (yyVals[-2+yyTop]), "Optional parameter is not valid in this context");
		
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		yyVal = new Parameter ((FullNamedExpression) yyVals[-4+yyTop], lt.Value, mod, (Attributes) yyVals[-6+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation, GetLocation (yyVals[-2+yyTop])); /* parameterModifierLocation should be ignored when mod == NONE*/
		
		if (yyVals[0+yyTop] != null)
			((Parameter) yyVal).DefaultValue = new DefaultParameterValueExpression ((Expression) yyVals[0+yyTop]);
	  }

void case_177()
#line 1593 "cs-parser.jay"
{
		Parameter.Modifier p2 = (Parameter.Modifier)yyVals[0+yyTop];
  		Parameter.Modifier mod = (Parameter.Modifier)yyVals[-1+yyTop] | p2;
  		if (((Parameter.Modifier)yyVals[-1+yyTop] & p2) == p2) {
  			Error_DuplicateParameterModifier (lexer.Location, p2);
  		} else {
	  		switch (mod & ~Parameter.Modifier.This) {
  				case Parameter.Modifier.REF:
					report.Error (1101, lexer.Location, "The parameter modifiers `this' and `ref' cannot be used altogether");
  					break;
   				case Parameter.Modifier.OUT:
					report.Error (1102, lexer.Location, "The parameter modifiers `this' and `out' cannot be used altogether");
  					break;
  				default:
 					report.Error (1108, lexer.Location, "A parameter cannot have specified more than one modifier");
 					break;
 			}
  		}
  		yyVal = mod;
	  }

void case_178()
#line 1617 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Ref) == 0)
	  		Error_ParameterModifierNotValid ("ref", GetLocation (yyVals[0+yyTop]));
		parameterModifierLocation = GetLocation (yyVals[0+yyTop]);
	  	yyVal = Parameter.Modifier.REF;
	  }

void case_179()
#line 1624 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Out) == 0)
	  		Error_ParameterModifierNotValid ("out", GetLocation (yyVals[0+yyTop]));
		parameterModifierLocation = GetLocation (yyVals[0+yyTop]);
	  	yyVal = Parameter.Modifier.OUT;
	  }

void case_180()
#line 1631 "cs-parser.jay"
{
		if ((valid_param_mod & ParameterModifierType.This) == 0)
	  		Error_ParameterModifierNotValid ("this", GetLocation (yyVals[0+yyTop]));

	  	if (lang_version <= LanguageVersion.ISO_2)
	  		FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "extension methods");
		parameterModifierLocation = GetLocation (yyVals[0+yyTop]);
		yyVal = Parameter.Modifier.This;
	  }

void case_181()
#line 1644 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new ParamsParameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Attributes) yyVals[-3+yyTop], lt.Location);
		lbag.AddLocation (yyVal, savedLocation);
	  }

void case_182()
#line 1650 "cs-parser.jay"
{
		report.Error (1751, GetLocation (yyVals[-4+yyTop]), "Cannot specify a default value for a parameter array");
		
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new ParamsParameter ((FullNamedExpression) yyVals[-3+yyTop], lt.Value, (Attributes) yyVals[-5+yyTop], lt.Location);		
		lbag.AddLocation (yyVal, savedLocation);
	  }

void case_183()
#line 1658 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_184()
#line 1666 "cs-parser.jay"
{
		if ((valid_param_mod & ParameterModifierType.Params) == 0)
			report.Error (1670, (GetLocation (yyVals[0+yyTop])), "The `params' modifier is not allowed in current context");
		savedLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_185()
#line 1672 "cs-parser.jay"
{
		Parameter.Modifier mod = (Parameter.Modifier)yyVals[0+yyTop];
		if ((mod & Parameter.Modifier.This) != 0) {
			report.Error (1104, GetLocation (yyVals[-1+yyTop]), "The parameter modifiers `this' and `params' cannot be used altogether");
		} else {
			report.Error (1611, GetLocation (yyVals[-1+yyTop]), "The params parameter cannot be declared as ref or out");
		}	  
		savedLocation = GetLocation (yyVals[-1+yyTop]);
	  }

void case_187()
#line 1689 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Arglist) == 0)
	  		report.Error (1669, GetLocation (yyVals[0+yyTop]), "__arglist is not valid in this context");
	  }

void case_188()
#line 1700 "cs-parser.jay"
{
		if (doc_support)
			tmpComment = Lexer.consume_doc_comment ();
	  }

void case_189()
#line 1705 "cs-parser.jay"
{
		var type = (FullNamedExpression) yyVals[-3+yyTop];
		current_property = new Property (current_type, type, (Modifiers) yyVals[-4+yyTop],
			(MemberName) yyVals[-2+yyTop], (Attributes) yyVals[-5+yyTop]);
			
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (547, GetLocation (yyVals[-3+yyTop]), "`{0}': property or indexer cannot have void type", current_property.GetSignatureForError ());					
			
		current_type.AddMember (current_property);
		lbag.AddMember (current_property, GetModifierLocations (), GetLocation (yyVals[0+yyTop]));
		
		lexer.PropertyParsing = true;
	  }

void case_190()
#line 1719 "cs-parser.jay"
{
		lexer.PropertyParsing = false;
		
		if (doc_support)
			current_property.DocComment = ConsumeStoredComment ();				
	  }

void case_191()
#line 1726 "cs-parser.jay"
{
		lbag.AppendToMember (current_property, GetLocation (yyVals[0+yyTop]));
		current_property = null;
	  }

void case_193()
#line 1740 "cs-parser.jay"
{
		valid_param_mod = 0;
		var type = (FullNamedExpression) yyVals[-6+yyTop];
		Indexer indexer = new Indexer (current_type, type, (MemberName) yyVals[-5+yyTop], (Modifiers) yyVals[-7+yyTop], (ParametersCompiled) yyVals[-2+yyTop], (Attributes) yyVals[-8+yyTop]);
			
		current_property = indexer;

  		current_type.AddIndexer (indexer);
		lbag.AddMember (current_property, GetModifierLocations (), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
  		
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (620, GetLocation (yyVals[-6+yyTop]), "`{0}': indexer return type cannot be `void'", indexer.GetSignatureForError ());  		

		if (indexer.ParameterInfo.IsEmpty) {
			report.Error (1551, GetLocation (yyVals[-4+yyTop]), "Indexers must have at least one parameter");
		}

		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}

		lexer.PropertyParsing = true;
	  }

void case_195()
#line 1769 "cs-parser.jay"
{
		if (current_property.AccessorFirst != null && current_property.AccessorFirst.Block == null)
			((Indexer) current_property).ParameterInfo.CheckParameters (current_property);
	  
		if (doc_support)
			current_property.DocComment = ConsumeStoredComment ();
			
		lbag.AppendToMember (current_property, GetLocation (yyVals[-1+yyTop]));
		current_property = null;		
	  }

void case_200()
#line 1788 "cs-parser.jay"
{
	  	if (yyToken == Token.CLOSE_BRACE) {
	  		report.Error (548, lexer.Location, "`{0}': property or indexer must have at least one accessor", current_property.GetSignatureForError ());
		} else {
			if (yyToken == Token.SEMICOLON)
				report.Error (1597, lexer.Location, "Semicolon after method or accessor block is not valid");
			else
				report.Error (1014, GetLocation (yyVals[0+yyTop]), "A get or set accessor expected");
		}
	  }

void case_201()
#line 1802 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != ModifierNone && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "access modifiers on properties");
		}
	  
		if (current_property.Get != null) {
			report.Error (1007, GetLocation (yyVals[0+yyTop]), "Property accessor already defined");
		}
		
		if (current_property is Indexer) {
			current_property.Get = new Indexer.GetIndexerMethod (current_property, (Modifiers) yyVals[-1+yyTop], ((Indexer)current_property).ParameterInfo.Clone (),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		} else {
			current_property.Get = new Property.GetMethod (current_property,
				(Modifiers) yyVals[-1+yyTop], (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		}	
	  
		current_local_parameters = current_property.Get.ParameterInfo;	  
		lexer.PropertyParsing = false;
	  }

void case_202()
#line 1823 "cs-parser.jay"
{
	  	if (yyVals[0+yyTop] != null) {
	  		current_property.Get.Block = (ToplevelBlock) yyVals[0+yyTop];			
	  	
			if (current_container.Kind == MemberKind.Interface) {
				report.Error (531, current_property.Get.Block.StartLocation,
					"`{0}': interface members cannot have a definition", current_property.Get.GetSignatureForError ());
			}
			lbag.AddMember (current_property.Get, GetModifierLocations ());
		} else {
			lbag.AddMember (current_property.Get, GetModifierLocations (), savedLocation);
		}
	  
		current_local_parameters = null;
		lexer.PropertyParsing = true;

		if (doc_support)
			if (Lexer.doc_state == XmlCommentState.Error)
				Lexer.doc_state = XmlCommentState.NotAllowed;
	  }

void case_203()
#line 1847 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != ModifierNone && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "access modifiers on properties");
		}
		
		if (current_property.Set != null) {
			report.Error (1007, GetLocation (yyVals[0+yyTop]), "Property accessor already defined");
		}
	  
		if (current_property is Indexer) {
			current_property.Set = new Indexer.SetIndexerMethod (current_property, (Modifiers) yyVals[-1+yyTop],
				ParametersCompiled.MergeGenerated (compiler,
				((Indexer)current_property).ParameterInfo, true, new Parameter (
					current_property.TypeExpression, "value", Parameter.Modifier.NONE, null, GetLocation (yyVals[0+yyTop])),
					null),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		} else {
			current_property.Set = new Property.SetMethod (current_property, (Modifiers) yyVals[-1+yyTop], 
				ParametersCompiled.CreateImplicitParameter (current_property.TypeExpression, GetLocation (yyVals[0+yyTop])),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		}
		
		current_local_parameters = current_property.Set.ParameterInfo;	
		lexer.PropertyParsing = false;
	  }

void case_204()
#line 1873 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {		
			current_property.Set.Block = (ToplevelBlock) yyVals[0+yyTop];
		
			if (current_container.Kind == MemberKind.Interface) {
				report.Error (531, current_property.Set.Block.StartLocation,
					"`{0}': interface members cannot have a definition", current_property.Set.GetSignatureForError ());
			}
			lbag.AddMember (current_property.Set, GetModifierLocations ());
		} else {
			lbag.AddMember (current_property.Set, GetModifierLocations (), savedLocation);
		}
		
		current_local_parameters = null;
		lexer.PropertyParsing = true;

		if (doc_support
			&& Lexer.doc_state == XmlCommentState.Error)
			Lexer.doc_state = XmlCommentState.NotAllowed;
	  }

void case_206()
#line 1898 "cs-parser.jay"
{
		savedLocation = GetLocation (yyVals[0+yyTop]);
	  	yyVal = null;
	  }

void case_207()
#line 1903 "cs-parser.jay"
{
	  	Error_SyntaxError (1043, yyToken, "Invalid accessor body");
	  	yyVal = null;
	  }

void case_209()
#line 1918 "cs-parser.jay"
{
		push_current_container (new Interface (current_container, (MemberName) yyVals[0+yyTop], (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]), yyVals[-3+yyTop]);
		lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]));		
	  }

void case_210()
#line 1924 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		if (yyVals[0+yyTop] != null)
			current_container.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support) {
			current_container.PartialContainer.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lexer.parsing_modifiers = true;
	  }

void case_211()
#line 1938 "cs-parser.jay"
{
		--lexer.parsing_declaration;	  
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_212()
#line 1944 "cs-parser.jay"
{
		if (yyVals[0+yyTop] == null) {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		} else {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = pop_current_class ();
	  }

void case_228()
#line 2006 "cs-parser.jay"
{
		OperatorDeclaration decl = (OperatorDeclaration) yyVals[-2+yyTop];
		if (decl != null) {
			Operator op = new Operator (
				current_type, decl.optype, decl.ret_type, (Modifiers) yyVals[-3+yyTop], 
				current_local_parameters,
				(ToplevelBlock) yyVals[0+yyTop], (Attributes) yyVals[-4+yyTop], decl.location);
				
			if (op.Block == null)
				op.ParameterInfo.CheckParameters (op);

			if (doc_support) {
				op.DocComment = tmpComment;
				Lexer.doc_state = XmlCommentState.Allowed;
			}

			/* Note again, checking is done in semantic analysis*/
			current_type.AddOperator (op);

			lbag.AddMember (op, GetModifierLocations (), lbag.GetLocations (decl));
			if (yyVals[0+yyTop] == null) { /* Semicolon*/
				lbag.AppendTo (op, savedLocation); 
			}
		}
		
		current_local_parameters = null;
	  }

void case_232()
#line 2043 "cs-parser.jay"
{
		report.Error (590, GetLocation (yyVals[0+yyTop]), "User-defined operators cannot return void");
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_234()
#line 2055 "cs-parser.jay"
{
		valid_param_mod = 0;

		Location loc = GetLocation (yyVals[-5+yyTop]);
		Operator.OpType op = (Operator.OpType) yyVals[-4+yyTop];
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];
		
		int p_count = current_local_parameters.Count;
		if (p_count == 1) {
			if (op == Operator.OpType.Addition)
				op = Operator.OpType.UnaryPlus;
			else if (op == Operator.OpType.Subtraction)
				op = Operator.OpType.UnaryNegation;
		}
		
		if (IsUnaryOperator (op)) {
			if (p_count == 2) {
				report.Error (1020, loc, "Overloadable binary operator expected");
			} else if (p_count != 1) {
				report.Error (1535, loc, "Overloaded unary operator `{0}' takes one parameter",
					Operator.GetName (op));
			}
		} else {
			if (p_count > 2) {
				report.Error (1534, loc, "Overloaded binary operator `{0}' takes two parameters",
					Operator.GetName (op));
			} else if (p_count != 2) {
				report.Error (1019, loc, "Overloadable unary operator expected");
			}
		}
		
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (op, (FullNamedExpression) yyVals[-6+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), savedOperatorLocation, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_259()
#line 2131 "cs-parser.jay"
{
		valid_param_mod = 0;

		Location loc = GetLocation (yyVals[-5+yyTop]);
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];  
		  
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (Operator.OpType.Implicit, (FullNamedExpression) yyVals[-4+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_261()
#line 2150 "cs-parser.jay"
{
		valid_param_mod = 0;
		
		Location loc = GetLocation (yyVals[-5+yyTop]);
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];  
		  
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (Operator.OpType.Explicit, (FullNamedExpression) yyVals[-4+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_262()
#line 2165 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
		yyVal = new OperatorDeclaration (Operator.OpType.Implicit, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_263()
#line 2171 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  	yyVal = new OperatorDeclaration (Operator.OpType.Explicit, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_264()
#line 2181 "cs-parser.jay"
{ 
		Constructor c = (Constructor) yyVals[-1+yyTop];
		c.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (doc_support)
			c.DocComment = ConsumeStoredComment ();

		current_local_parameters = null;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_265()
#line 2198 "cs-parser.jay"
{
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		valid_param_mod = ParameterModifierType.All;
	  }

void case_266()
#line 2207 "cs-parser.jay"
{
		valid_param_mod = 0;
		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];
		
		var lt = (Tokenizer.LocatedToken) yyVals[-4+yyTop];
		var mods = (Modifiers) yyVals[-5+yyTop];
		var c = new Constructor (current_type, lt.Value, mods, (Attributes) yyVals[-6+yyTop], current_local_parameters, lt.Location);

		if (lt.Value != current_container.MemberName.Name) {
			report.Error (1520, c.Location, "Class, struct, or interface method must have a return type");
		} else if ((mods & Modifiers.STATIC) != 0) {
			if ((mods & Modifiers.AccessibilityMask) != 0){
				report.Error (515, c.Location,
					"`{0}': static constructor cannot have an access modifier",
					c.GetSignatureForError ());
			}
		}

		current_type.AddConstructor (c);
		lbag.AddMember (c, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = c;

		/**/
		/* start block here, so possible anonymous methods inside*/
		/* constructor initializer can get correct parent block*/
		/**/
	  	start_block (lexer.Location);
	  }

void case_267()
#line 2236 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			var c = (Constructor) yyVals[-1+yyTop];
			c.Initializer = (ConstructorInitializer) yyVals[0+yyTop];
			
			if (c.IsStatic) {
				report.Error (514, c.Location,
					"`{0}': static constructor cannot have an explicit `this' or `base' constructor call",
					c.GetSignatureForError ());
			}
		}

		yyVal = yyVals[-1+yyTop];
	  }

void case_273()
#line 2268 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		yyVal = new ConstructorBaseInitializer ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_275()
#line 2278 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		yyVal = new ConstructorThisInitializer ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_276()
#line 2284 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);	  
		yyVal = new ConstructorThisInitializer (null, GetLocation (yyVals[0+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_277()
#line 2290 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_278()
#line 2298 "cs-parser.jay"
{
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}
		
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  }

void case_279()
#line 2307 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		if (lt.Value != current_container.MemberName.Name){
			report.Error (574, lt.Location, "Name of destructor must match name of class");
		} else if (current_container.Kind != MemberKind.Class){
			report.Error (575, lt.Location, "Only class types can contain destructor");
		}
		
		Destructor d = new Destructor (current_type, (Modifiers) yyVals[-6+yyTop],
			ParametersCompiled.EmptyReadOnlyParameters, (Attributes) yyVals[-7+yyTop], lt.Location);
		d.Identifier = lt.Value;
		if (doc_support)
			d.DocComment = ConsumeStoredComment ();
		  
		d.Block = (ToplevelBlock) yyVals[0+yyTop];
		current_type.AddMember (d);
		lbag.AddMember (d, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[-1+yyTop]));

		current_local_parameters = null;
	  }

void case_280()
#line 2333 "cs-parser.jay"
{
		current_event_field = new EventField (current_type, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop], (MemberName) yyVals[0+yyTop], (Attributes) yyVals[-4+yyTop]);
		current_type.AddMember (current_event_field);
		
		if (current_event_field.MemberName.ExplicitInterface != null) {
			report.Error (71, current_event_field.Location, "`{0}': An explicit interface implementation of an event must use property syntax",
			current_event_field.GetSignatureForError ());
		}
		
		yyVal = current_event_field;
	  }

void case_281()
#line 2347 "cs-parser.jay"
{
		if (doc_support) {
			current_event_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lbag.AddMember (current_event_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		current_event_field = null;
	  }

void case_282()
#line 2360 "cs-parser.jay"
{
		current_event = new EventProperty (current_type, (FullNamedExpression) yyVals[-2+yyTop], (Modifiers) yyVals[-4+yyTop], (MemberName) yyVals[-1+yyTop], (Attributes) yyVals[-5+yyTop]);
		current_type.AddMember (current_event);
		lbag.AddMember (current_event, GetModifierLocations (), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		
		lexer.EventParsing = true;
	  }

void case_283()
#line 2368 "cs-parser.jay"
{
		if (current_container.Kind == MemberKind.Interface)
			report.Error (69, GetLocation (yyVals[-2+yyTop]), "Event in interface cannot have add or remove accessors");
	  
		lexer.EventParsing = false;
	  }

void case_284()
#line 2375 "cs-parser.jay"
{
		if (doc_support) {
			current_event.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lbag.AppendToMember (current_event, GetLocation (yyVals[-1+yyTop]));
	  	current_event = null;	
		current_local_parameters = null;
	  }

void case_287()
#line 2394 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		current_event_field.Initializer = (Expression) yyVals[0+yyTop];
	  }

void case_292()
#line 2418 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), null);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_294()
#line 2428 "cs-parser.jay"
{
		--lexer.parsing_block;
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];	  
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (Expression) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_295()
#line 2437 "cs-parser.jay"
{
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (68, lexer.Location, "`{0}': event in interface cannot have an initializer",
				current_event_field.GetSignatureForError ());
		}
		
	  	if ((current_event_field.ModFlags & Modifiers.ABSTRACT) != 0) {
			report.Error (74, lexer.Location, "`{0}': abstract event cannot have an initializer",
				current_event_field.GetSignatureForError ());
	  	}		
	  }

void case_299()
#line 2458 "cs-parser.jay"
{
		report.Error (65, lexer.Location, "`{0}': event property must have both add and remove accessors",
			current_event.GetSignatureForError ());
	  }

void case_300()
#line 2463 "cs-parser.jay"
{
		report.Error (65, lexer.Location, "`{0}': event property must have both add and remove accessors",
			current_event.GetSignatureForError ());
	  }

void case_301()
#line 2468 "cs-parser.jay"
{ 
		report.Error (1055, GetLocation (yyVals[0+yyTop]), "An add or remove accessor expected");
		yyVal = null;
	  }

void case_302()
#line 2476 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] != ModifierNone) {
			report.Error (1609, GetLocation (yyVals[-1+yyTop]), "Modifiers cannot be placed on event accessor declarations");
	  	}
	  	
	  	current_event.Add = new EventProperty.AddDelegateMethod (current_event, (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		current_local_parameters = current_event.Add.ParameterInfo;
		
		lbag.AddMember (current_event.Add, GetModifierLocations ());
		lexer.EventParsing = false;		
	  }

void case_303()
#line 2488 "cs-parser.jay"
{
		lexer.EventParsing = true;
	  
	  	current_event.Add.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (531, current_event.Add.Block.StartLocation,
				"`{0}': interface members cannot have a definition", current_event.Add.GetSignatureForError ());
		}
		
		current_local_parameters = null;
	  }

void case_304()
#line 2504 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] != ModifierNone) {
			report.Error (1609, GetLocation (yyVals[-1+yyTop]), "Modifiers cannot be placed on event accessor declarations");
	  	}
	  	
	  	current_event.Remove = new EventProperty.RemoveDelegateMethod (current_event, (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		current_local_parameters = current_event.Remove.ParameterInfo;

		lbag.AddMember (current_event.Remove, GetModifierLocations ());
		lexer.EventParsing = false;		
	  }

void case_305()
#line 2516 "cs-parser.jay"
{
		lexer.EventParsing = true;
	  
	  	current_event.Remove.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (531, current_event.Remove.Block.StartLocation,
				"`{0}': interface members cannot have a definition", current_event.Remove.GetSignatureForError ());
		}
		
		current_local_parameters = null;
	  }

void case_306()
#line 2532 "cs-parser.jay"
{
		report.Error (73, lexer.Location, "An add or remove accessor must have a body");
		yyVal = null;
	  }

void case_308()
#line 2541 "cs-parser.jay"
{
		current_type.UnattachedAttributes = (Attributes) yyVals[-1+yyTop];
		report.Error (1519, GetLocation (yyVals[-1+yyTop]), "An attribute is missing member declaration");
		lexer.putback ('}');
	  }

void case_309()
#line 2554 "cs-parser.jay"
{
		if (doc_support)
			enumTypeComment = Lexer.consume_doc_comment ();
	  }

void case_310()
#line 2559 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;

		MemberName name = (MemberName) yyVals[-3+yyTop];
		if (name.IsGeneric) {
			report.Error (1675, name.Location, "Enums cannot have type parameters");
		}
		
		push_current_container (new Enum (current_container, (FullNamedExpression) yyVals[-2+yyTop], (Modifiers) yyVals[-5+yyTop], name, (Attributes) yyVals[-6+yyTop]), null);
		if (yyVals[-2+yyTop] != null) {
			lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-4+yyTop]), savedLocation, GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
	  }

void case_311()
#line 2576 "cs-parser.jay"
{
	  	/* here will be evaluated after CLOSE_BLACE is consumed.*/
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_312()
#line 2582 "cs-parser.jay"
{
		lbag.AppendToMember (current_container, GetLocation (yyVals[-1+yyTop]));
		if (yyVals[0+yyTop] != null) {
			lbag.AppendToMember (current_container, GetLocation (yyVals[0+yyTop]));
		}
		if (doc_support)
			current_container.DocComment = enumTypeComment;
			
		--lexer.parsing_declaration;

/*			if (doc_support)*/
/*				em.DocComment = ev.DocComment;*/

		yyVal = pop_current_class ();
	  }

void case_314()
#line 2602 "cs-parser.jay"
{
		savedLocation = GetLocation (yyVals[-1+yyTop]);
		yyVal = yyVals[0+yyTop];
	 }

void case_315()
#line 2607 "cs-parser.jay"
{
	 	Error_TypeExpected (GetLocation (yyVals[-1+yyTop]));
		yyVal = null;
	 }

void case_320()
#line 2625 "cs-parser.jay"
{
		lbag.AppendToMember (current_container, GetLocation (yyVals[-1+yyTop]));
	  	yyVal = yyVals[0+yyTop];
	  }

void case_321()
#line 2633 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
	  	var em = new EnumMember ((Enum) current_type, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-1+yyTop]);
	  	((Enum) current_type).AddEnumMember (em);

		if (doc_support) {
			em.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}

		yyVal = em;
	  }

void case_322()
#line 2646 "cs-parser.jay"
{
	  	++lexer.parsing_block;
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}
	  }

void case_323()
#line 2654 "cs-parser.jay"
{ 
		--lexer.parsing_block;
		
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
	  	var em = new EnumMember ((Enum) current_type, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
	  	em.Initializer = new ConstInitializer (em, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  	((Enum) current_type).AddEnumMember (em);
		
		if (doc_support)
			em.DocComment = ConsumeStoredComment ();

		yyVal = em;
	  }

void case_324()
#line 2668 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
	  	var em = new EnumMember ((Enum) current_type, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-2+yyTop]);
	  	((Enum) current_type).AddEnumMember (em);

		if (doc_support) {
			em.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}

		yyVal = em;
	  }

void case_327()
#line 2695 "cs-parser.jay"
{
		valid_param_mod = 0;

		ParametersCompiled p = (ParametersCompiled) yyVals[-1+yyTop];

		Delegate del = new Delegate (current_container, (FullNamedExpression) yyVals[-5+yyTop], (Modifiers) yyVals[-7+yyTop], (MemberName) yyVals[-4+yyTop], p, (Attributes) yyVals[-8+yyTop]);

		p.CheckParameters (del);

		current_container.AddTypeContainer (del);

		current_delegate = del;
		lexer.ConstraintsParsing = true;
	  }

void case_329()
#line 2714 "cs-parser.jay"
{
		if (doc_support) {
			current_delegate.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
	  
		if (yyVals[-2+yyTop] != null)
			current_delegate.SetConstraints ((List<Constraints>) yyVals[-2+yyTop]);
		lbag.AddMember (current_delegate, GetModifierLocations (), GetLocation (yyVals[-10+yyTop]), GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[0+yyTop]));

		yyVal = current_delegate;

		current_delegate = null;
	  }

void case_331()
#line 2733 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "nullable types");
	  
	  	yyVal = ComposedTypeSpecifier.CreateNullable (GetLocation (yyVals[0+yyTop]));
	  }

void case_333()
#line 2744 "cs-parser.jay"
{
		var lt1 = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var lt2 = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		
		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (TypeArguments) yyVals[0+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_335()
#line 2756 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_336()
#line 2765 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new SimpleName (lt.Value, (TypeArguments)yyVals[0+yyTop], lt.Location);
	  }

void case_338()
#line 2777 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "generics");
		var list = locationListStack.Pop ();
		list.Add (GetLocation (yyVals[-2+yyTop]));
		list.Add (GetLocation (yyVals[-1+yyTop]));
		lbag.AddLocation (yyVals[-1+yyTop], list);
	
		yyVal = yyVals[-1+yyTop];;
	  }

void case_339()
#line 2788 "cs-parser.jay"
{
		Error_TypeExpected (lexer.Location);
		yyVal = new TypeArguments ();
	  }

void case_340()
#line 2796 "cs-parser.jay"
{
		TypeArguments type_args = new TypeArguments ();
		type_args.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = type_args;
		locationListStack.Push (new List<Location> ());
	  }

void case_341()
#line 2803 "cs-parser.jay"
{
		TypeArguments type_args = (TypeArguments) yyVals[-2+yyTop];
		type_args.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = type_args;
		locationListStack.Peek ().Add (GetLocation (yyVals[-1+yyTop]));
	  }

void case_343()
#line 2820 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new MemberName (lt.Value, (TypeParameters)yyVals[0+yyTop], lt.Location);
	  }

void case_344()
#line 2829 "cs-parser.jay"
{
	  	MemberName mn = (MemberName)yyVals[0+yyTop];
	  	if (mn.TypeParameters != null)
	  		syntax_error (mn.Location, string.Format ("Member `{0}' cannot declare type arguments",
	  			mn.GetSignatureForError ()));
	  }

void case_346()
#line 2840 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;	  
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberName (lt.Value, (TypeParameters) yyVals[0+yyTop], (ATypeNameExpression) yyVals[-2+yyTop], lt.Location);
	  }

void case_347()
#line 2849 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;	  
		yyVal = new MemberName (TypeDefinition.DefaultIndexerName, GetLocation (yyVals[0+yyTop]));
	  }

void case_348()
#line 2854 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
		yyVal = new MemberName (TypeDefinition.DefaultIndexerName, null, (ATypeNameExpression) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }

void case_349()
#line 2862 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new SimpleName (lt.Value, (TypeArguments) yyVals[-1+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_350()
#line 2868 "cs-parser.jay"
{
		var lt1 = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var lt2 = (Tokenizer.LocatedToken) yyVals[-2+yyTop];

		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (TypeArguments) yyVals[-1+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_351()
#line 2876 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new MemberAccess ((ATypeNameExpression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[-1+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_353()
#line 2886 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "generics");
	  
		yyVal = yyVals[-1+yyTop];
		var list = locationListStack.Pop ();
		list.Add (GetLocation (yyVals[-2+yyTop]));
		list.Add (GetLocation (yyVals[-1+yyTop]));
		lbag.AddLocation (yyVals[-1+yyTop], list);
	  }

void case_354()
#line 2900 "cs-parser.jay"
{
		var tparams = new TypeParameters ();
		tparams.Add ((TypeParameter)yyVals[0+yyTop]);
		yyVal = tparams;
		locationListStack.Push (new List<Location> ());
	  }

void case_355()
#line 2907 "cs-parser.jay"
{
		var tparams = (TypeParameters) yyVals[-2+yyTop];
		tparams.Add ((TypeParameter)yyVals[0+yyTop]);
		yyVal = tparams;
		locationListStack.Peek ().Add (GetLocation (yyVals[-1+yyTop]));
	  }

void case_356()
#line 2917 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken)yyVals[0+yyTop];
		yyVal = new TypeParameter (new MemberName (lt.Value, lt.Location), (Attributes)yyVals[-2+yyTop], (Variance) yyVals[-1+yyTop]);
  	  }

void case_357()
#line 2922 "cs-parser.jay"
{
  	  	if (GetTokenName (yyToken) == "type")
			report.Error (81, GetLocation (yyVals[0+yyTop]), "Type parameter declaration must be an identifier not a type");
		else
			Error_SyntaxError (yyToken);
			
  	  	yyVal = new TypeParameter (MemberName.Null, null, Variance.None);
  	  }

void case_362()
#line 2956 "cs-parser.jay"
{
	  	Expression.Error_VoidInvalidInTheContext (GetLocation (yyVals[0+yyTop]), report);
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_364()
#line 2965 "cs-parser.jay"
{
	  	Expression.Error_VoidInvalidInTheContext (GetLocation (yyVals[0+yyTop]), report);
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_366()
#line 2974 "cs-parser.jay"
{
	  	report.Error (1536, GetLocation (yyVals[0+yyTop]), "Invalid parameter type `void'");
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_369()
#line 2990 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			yyVal = new ComposedCast ((ATypeNameExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			var sn = yyVals[-1+yyTop] as SimpleName;
			if (sn != null && sn.Name == "var")
				yyVal = new VarExpr (sn.Location);
			else
				yyVal = yyVals[-1+yyTop];
		}
	  }

void case_371()
#line 3006 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null)
			yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_374()
#line 3022 "cs-parser.jay"
{
		var types = new List<FullNamedExpression> (2);
		types.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = types;
	  }

void case_375()
#line 3028 "cs-parser.jay"
{
		var types = (List<FullNamedExpression>) yyVals[-2+yyTop];
		types.Add ((FullNamedExpression) yyVals[0+yyTop]);
		lbag.AppendTo (types, GetLocation (yyVals[-1+yyTop]));
		yyVal = types;
	  }

void case_376()
#line 3038 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is ComposedCast) {
			report.Error (1521, GetLocation (yyVals[0+yyTop]), "Invalid base type `{0}'", ((ComposedCast)yyVals[0+yyTop]).GetSignatureForError ());
		}
		yyVal = yyVals[0+yyTop];
	  }

void case_413()
#line 3102 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new SimpleName (lt.Value, (TypeArguments)yyVals[0+yyTop], lt.Location);	  
	  }

void case_414()
#line 3106 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
	       yyVal = new CompletionSimpleName (MemberName.MakeName (lt.Value, null), lt.Location);
	  }

void case_425()
#line 3147 "cs-parser.jay"
{
		yyVal = new ParenthesizedExpression ((Expression) yyVals[-1+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_427()
#line 3159 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location) {
			DotLocation = GetLocation (yyVals[-2+yyTop])
		};
	  }

void case_428()
#line 3166 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location) {
			DotLocation = GetLocation (yyVals[-2+yyTop])
		};
	  }

void case_429()
#line 3173 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (new BaseThis (GetLocation (yyVals[-3+yyTop])), lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location) {
			DotLocation = GetLocation (yyVals[-2+yyTop])
		};
	  }

void case_430()
#line 3180 "cs-parser.jay"
{
		var lt1 = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var lt2 = (Tokenizer.LocatedToken) yyVals[-1+yyTop];

		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (TypeArguments) yyVals[0+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_432()
#line 3190 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, lt.Location);
	  }

void case_434()
#line 3198 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, lt.Location);
 	  }

void case_435()
#line 3206 "cs-parser.jay"
{
		yyVal = new Invocation ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_436()
#line 3211 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Invocation ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_439()
#line 3227 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] == null) {
	  		yyVal = new CollectionOrObjectInitializers (new List<Expression> (), GetLocation (yyVals[-2+yyTop]));
	  		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  	} else {
	  		yyVal = new CollectionOrObjectInitializers ((List<Expression>) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  	}
	  }

void case_440()
#line 3237 "cs-parser.jay"
{
	  	yyVal = new CollectionOrObjectInitializers ((List<Expression>) yyVals[-2+yyTop], GetLocation (yyVals[-3+yyTop]));
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_443()
#line 3253 "cs-parser.jay"
{
	  	var a = new List<Expression> ();
	  	a.Add ((Expression) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_444()
#line 3259 "cs-parser.jay"
{
	  	var a = (List<Expression>)yyVals[-2+yyTop];
	  	a.Add ((Expression) yyVals[0+yyTop]);
		lbag.AppendTo (a, GetLocation (yyVals[-1+yyTop]));
	  	yyVal = a;
	  }

void case_445()
#line 3265 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		yyVal = yyVals[-1+yyTop];
	  }

void case_446()
#line 3273 "cs-parser.jay"
{
	  	var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
	  	yyVal = new ElementInitializer (lt.Value, (Expression)yyVals[0+yyTop], lt.Location);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_448()
#line 3282 "cs-parser.jay"
{
		CompletionSimpleName csn = yyVals[-1+yyTop] as CompletionSimpleName;
		if (csn == null)
			yyVal = new CollectionElementInitializer ((Expression)yyVals[-1+yyTop]);
		else
			yyVal = new CompletionElementInitializer (csn.Prefix, csn.Location);
	  }

void case_449()
#line 3290 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] == null)
			yyVal = null;
		else {
	  		yyVal = new CollectionElementInitializer ((List<Expression>)yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
			lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  	}
	  }

void case_450()
#line 3299 "cs-parser.jay"
{
	  	report.Error (1920, GetLocation (yyVals[-1+yyTop]), "An element initializer cannot be empty");
		yyVal = new CollectionElementInitializer (new List<Expression> (), GetLocation (yyVals[-1+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_455()
#line 3318 "cs-parser.jay"
{ 
		Arguments list = new Arguments (4);
		list.Add ((Argument) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_456()
#line 3324 "cs-parser.jay"
{
		Arguments list = (Arguments) yyVals[-2+yyTop];
		if (list [list.Count - 1] is NamedArgument)
			Error_NamedArgumentExpected ((NamedArgument) list [list.Count - 1]);
		
		list.Add ((Argument) yyVals[0+yyTop]);
		lbag.AppendTo (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_457()
#line 3334 "cs-parser.jay"
{
		Arguments list = (Arguments) yyVals[-2+yyTop];
		NamedArgument a = (NamedArgument) yyVals[0+yyTop];
		for (int i = 0; i < list.Count; ++i) {
			NamedArgument na = list [i] as NamedArgument;
			if (na != null && na.Name == a.Name)
				report.Error (1740, na.Location, "Named argument `{0}' specified multiple times",
					na.Name);
		}
		
		list.Add (a);
		lbag.AppendTo (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_458()
#line 3349 "cs-parser.jay"
{
	  	lexer.putback (')'); /* TODO: Wrong but what can I do*/
		Error_SyntaxError (yyToken);
		yyVal = yyVals[-2+yyTop];
	  }

void case_459()
#line 3355 "cs-parser.jay"
{
	  	report.Error (839, GetLocation (yyVals[-1+yyTop]), "An argument is missing");
	  	yyVal = null;
	  }

void case_464()
#line 3376 "cs-parser.jay"
{ 
		yyVal = new Argument ((Expression) yyVals[0+yyTop], Argument.AType.Ref);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_465()
#line 3381 "cs-parser.jay"
{ 
		yyVal = new Argument ((Expression) yyVals[0+yyTop], Argument.AType.Out);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_466()
#line 3386 "cs-parser.jay"
{
		yyVal = new Argument (new Arglist ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop])));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_467()
#line 3391 "cs-parser.jay"
{
		yyVal = new Argument (new Arglist (GetLocation (yyVals[-2+yyTop])));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_469()
#line 3403 "cs-parser.jay"
{
		yyVal = new ElementAccess ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_470()
#line 3408 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new ElementAccess ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_471()
#line 3413 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new ElementAccess ((Expression) yyVals[-2+yyTop], null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_472()
#line 3421 "cs-parser.jay"
{
		var list = new List<Expression> (4);
		list.Add ((Expression) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_473()
#line 3427 "cs-parser.jay"
{
		var list = (List<Expression>) yyVals[-2+yyTop];
		list.Add ((Expression) yyVals[0+yyTop]);
		lbag.AppendTo (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_474()
#line 3433 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		yyVal = yyVals[-1+yyTop];
	  }

void case_475()
#line 3441 "cs-parser.jay"
{
		Arguments args = new Arguments (4);
		args.Add ((Argument) yyVals[0+yyTop]);
		yyVal = args;
	  }

void case_476()
#line 3447 "cs-parser.jay"
{
		Arguments args = (Arguments) yyVals[-2+yyTop];
		if (args [args.Count - 1] is NamedArgument && !(yyVals[0+yyTop] is NamedArgument))
			Error_NamedArgumentExpected ((NamedArgument) args [args.Count - 1]);
	  
		args.Add ((Argument) yyVals[0+yyTop]);
		lbag.AppendTo (args, GetLocation (yyVals[-1+yyTop]));
		yyVal = args;	  
	  }

void case_480()
#line 3475 "cs-parser.jay"
{
	  	yyVal = new ElementAccess (new BaseThis (GetLocation (yyVals[-3+yyTop])), (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_481()
#line 3480 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		yyVal = new ElementAccess (null, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_484()
#line 3502 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			if (lang_version <= LanguageVersion.ISO_2)
				FeatureIsNotAvailable (GetLocation (yyVals[-5+yyTop]), "object initializers");
				
			yyVal = new NewInitialize ((FullNamedExpression) yyVals[-4+yyTop], (Arguments) yyVals[-2+yyTop], (CollectionOrObjectInitializers) yyVals[0+yyTop], GetLocation (yyVals[-5+yyTop]));
		} else {
			yyVal = new New ((FullNamedExpression) yyVals[-4+yyTop], (Arguments) yyVals[-2+yyTop], GetLocation (yyVals[-5+yyTop]));
		}
		
		lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_485()
#line 3515 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "collection initializers");
	  
		yyVal = new NewInitialize ((FullNamedExpression) yyVals[-1+yyTop], null, (CollectionOrObjectInitializers) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_486()
#line 3527 "cs-parser.jay"
{
		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-5+yyTop], (List<Expression>) yyVals[-3+yyTop],
				new ComposedTypeSpecifier (((List<Expression>) yyVals[-3+yyTop]).Count, GetLocation (yyVals[-4+yyTop])) {
	  				Next = (ComposedTypeSpecifier) yyVals[-1+yyTop]
			  	}, (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-6+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_487()
#line 3535 "cs-parser.jay"
{
	  	if (yyVals[0+yyTop] == null)
	  		report.Error (1586, GetLocation (yyVals[-3+yyTop]), "Array creation must have array size or array initializer");

		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-2+yyTop], (ComposedTypeSpecifier) yyVals[-1+yyTop], (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
	  }

void case_488()
#line 3542 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "implicitly typed arrays");
	  
		yyVal = new ImplicitlyTypedArrayCreation ((ComposedTypeSpecifier) yyVals[-1+yyTop], (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_489()
#line 3549 "cs-parser.jay"
{
		report.Error (178, GetLocation (yyVals[-1+yyTop]), "Invalid rank specifier, expecting `,' or `]'");
		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-5+yyTop], null, GetLocation (yyVals[-6+yyTop]));
	  }

void case_490()
#line 3554 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		/* It can be any of new expression, create the most common one*/
		yyVal = new New ((FullNamedExpression) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_492()
#line 3566 "cs-parser.jay"
{
		--lexer.parsing_type;
		yyVal = yyVals[0+yyTop];
	  }

void case_493()
#line 3574 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
	  		FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "anonymous types");

		yyVal = new NewAnonymousType ((List<AnonymousTypeParameter>) yyVals[-1+yyTop], current_container, GetLocation (yyVals[-3+yyTop]));
		
		/* TODO: lbag comma location*/
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_498()
#line 3597 "cs-parser.jay"
{
	  	var a = new List<AnonymousTypeParameter> (4);
	  	a.Add ((AnonymousTypeParameter) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_499()
#line 3603 "cs-parser.jay"
{
	  	var a = (List<AnonymousTypeParameter>) yyVals[-2+yyTop];
	  	a.Add ((AnonymousTypeParameter) yyVals[0+yyTop]);
	  	lbag.AppendTo (a, GetLocation (yyVals[-1+yyTop]));

	  	yyVal = a;
	  }

void case_500()
#line 3614 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken)yyVals[-2+yyTop];
	  	yyVal = new AnonymousTypeParameter ((Expression)yyVals[0+yyTop], lt.Value, lt.Location);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_501()
#line 3620 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken)yyVals[0+yyTop];
	  	yyVal = new AnonymousTypeParameter (new SimpleName (lt.Value, lt.Location),
	  		lt.Value, lt.Location);
	  }

void case_502()
#line 3626 "cs-parser.jay"
{
	  	MemberAccess ma = (MemberAccess) yyVals[0+yyTop];
	  	yyVal = new AnonymousTypeParameter (ma, ma.Name, ma.Location);
	  }

void case_503()
#line 3631 "cs-parser.jay"
{
		report.Error (746, lexer.Location,
			"Invalid anonymous type member declarator. Anonymous type members must be a member assignment, simple name or member access expression");
		yyVal = null;
	  }

void case_507()
#line 3646 "cs-parser.jay"
{
	  	((ComposedTypeSpecifier) yyVals[-1+yyTop]).Next = (ComposedTypeSpecifier) yyVals[0+yyTop];
	  	yyVal = yyVals[-1+yyTop];
	  }

void case_508()
#line 3654 "cs-parser.jay"
{
		yyVal = ComposedTypeSpecifier.CreateArrayDimension (1, GetLocation (yyVals[-1+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_509()
#line 3659 "cs-parser.jay"
{
		yyVal = ComposedTypeSpecifier.CreateArrayDimension ((int)yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_514()
#line 3689 "cs-parser.jay"
{
		var ai = new ArrayInitializer (0, GetLocation (yyVals[-1+yyTop]));
		ai.VariableDeclaration = current_variable;
		lbag.AddLocation (ai, GetLocation (yyVals[0+yyTop]));
		yyVal = ai;
	  }

void case_515()
#line 3696 "cs-parser.jay"
{
		var ai = new ArrayInitializer ((List<Expression>) yyVals[-2+yyTop], GetLocation (yyVals[-3+yyTop]));
		ai.VariableDeclaration = current_variable;
		if (yyVals[-1+yyTop] != null) {
			lbag.AddLocation (ai, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddLocation (ai, GetLocation (yyVals[0+yyTop]));
		}
		yyVal = ai;
	  }

void case_516()
#line 3710 "cs-parser.jay"
{
		var list = new List<Expression> (4);
		list.Add ((Expression) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_517()
#line 3716 "cs-parser.jay"
{
		var list = (List<Expression>) yyVals[-2+yyTop];
		list.Add ((Expression) yyVals[0+yyTop]);
		lbag.AppendTo (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_519()
#line 3730 "cs-parser.jay"
{
	  	lexer.TypeOfParsing = false;
		yyVal = new TypeOf ((FullNamedExpression) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_522()
#line 3741 "cs-parser.jay"
{
	 	Error_TypeExpected (lexer.Location);
	 	yyVal = null;
	 }

void case_523()
#line 3749 "cs-parser.jay"
{  
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];

		yyVal = new SimpleName (lt.Value, (int) yyVals[0+yyTop], lt.Location);
	  }

void case_524()
#line 3755 "cs-parser.jay"
{
		var lt1 = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var lt2 = (Tokenizer.LocatedToken) yyVals[-1+yyTop];

		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (int) yyVals[0+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_525()
#line 3763 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		
		yyVal = new MemberAccess ((Expression) yyVals[-2+yyTop], lt.Value, lt.Location) {
			DotLocation = GetLocation (yyVals[-1+yyTop])
		};
	  }

void case_526()
#line 3771 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (int) yyVals[0+yyTop], lt.Location) {
			DotLocation = GetLocation (yyVals[-2+yyTop])
		};
	  }

void case_527()
#line 3779 "cs-parser.jay"
{
		var tne = (ATypeNameExpression) yyVals[-3+yyTop];
		if (tne.HasTypeArguments)
			Error_TypeExpected (GetLocation (yyVals[0+yyTop]));

		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (tne, lt.Value, (int) yyVals[0+yyTop], lt.Location) {
			DotLocation = GetLocation (yyVals[-2+yyTop])
		};		
	  }

void case_528()
#line 3793 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "generics");

		yyVal = yyVals[0+yyTop];
	  }

void case_529()
#line 3803 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		if (lang_version == LanguageVersion.ISO_1)
			FeatureIsNotAvailable (lt.Location, "namespace alias qualifier");

		yyVal = lt;		
	  }

void case_530()
#line 3814 "cs-parser.jay"
{ 
		yyVal = new SizeOf ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_531()
#line 3822 "cs-parser.jay"
{
		yyVal = new CheckedExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_532()
#line 3830 "cs-parser.jay"
{
		yyVal = new UnCheckedExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_533()
#line 3838 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (new Indirection ((Expression) yyVals[-3+yyTop], GetLocation (yyVals[-2+yyTop])), lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
	  }

void case_535()
#line 3850 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		if ((ParametersCompiled) yyVals[-2+yyTop] != ParametersCompiled.Undefined) {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), savedOpenLocation, savedCloseLocation);
		} else {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]));
		}
	  }

void case_537()
#line 3863 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		
		if ((ParametersCompiled) yyVals[-2+yyTop] != ParametersCompiled.Undefined) {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), savedOpenLocation, savedCloseLocation);
		} else {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]));
		}
	  }

void case_541()
#line 3888 "cs-parser.jay"
{
		valid_param_mod = 0;
	  	yyVal = yyVals[-1+yyTop];
	  	savedOpenLocation = GetLocation (yyVals[-3+yyTop]);
	  	savedCloseLocation = GetLocation (yyVals[-2+yyTop]);
	  }

void case_542()
#line 3898 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "default value expression");

		yyVal = new DefaultValueExpression ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_546()
#line 3918 "cs-parser.jay"
{
		yyVal = new Cast ((FullNamedExpression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_547()
#line 3923 "cs-parser.jay"
{
		if (!async_block) {
			 if (current_anonymous_method is LambdaExpression) {
				report.Error (4034, GetLocation (yyVals[-1+yyTop]),
					"The `await' operator can only be used when its containing lambda expression is marked with the `async' modifier");
			} else if (current_anonymous_method is AnonymousMethodExpression) {
				report.Error (4035, GetLocation (yyVals[-1+yyTop]),
					"The `await' operator can only be used when its containing anonymous method is marked with the `async' modifier");
			} else {
				report.Error (4033, GetLocation (yyVals[-1+yyTop]),
					"The `await' operator can only be used when its containing method is marked with the `async' modifier");
			}
		} else {
			current_block.Explicit.RegisterAsyncAwait ();
		}
		
		yyVal = new Await ((Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_556()
#line 3978 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Multiply, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_557()
#line 3983 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Division, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_558()
#line 3988 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Modulus, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_560()
#line 3997 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Addition, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_561()
#line 4002 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_565()
#line 4019 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LeftShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_566()
#line 4024 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.RightShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_568()
#line 4033 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LessThan, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_569()
#line 4038 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.GreaterThan, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_570()
#line 4043 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LessThanOrEqual, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_571()
#line 4048 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.GreaterThanOrEqual, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_573()
#line 4057 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Equality, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_574()
#line 4062 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Inequality, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_576()
#line 4071 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.BitwiseAnd, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_578()
#line 4080 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.ExclusiveOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_580()
#line 4089 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.BitwiseOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_582()
#line 4098 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LogicalAnd, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_584()
#line 4107 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LogicalOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_586()
#line 4116 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "null coalescing operator");
			
		yyVal = new Nullable.NullCoalescingOperator ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_588()
#line 4128 "cs-parser.jay"
{
		yyVal = new Conditional (new BooleanExpression ((Expression) yyVals[-4+yyTop]), (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_589()
#line 4133 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Conditional (new BooleanExpression ((Expression) yyVals[-3+yyTop]), (Expression) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_590()
#line 4141 "cs-parser.jay"
{
		yyVal = new SimpleAssign ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_591()
#line 4146 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Multiply, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_592()
#line 4151 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Division, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_593()
#line 4156 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Modulus, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_594()
#line 4161 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Addition, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_595()
#line 4166 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_596()
#line 4171 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.LeftShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_597()
#line 4176 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.RightShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_598()
#line 4181 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.BitwiseAnd, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_599()
#line 4186 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.BitwiseOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_600()
#line 4191 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.ExclusiveOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_601()
#line 4199 "cs-parser.jay"
{
		var pars = new List<Parameter> (4);
		pars.Add ((Parameter) yyVals[0+yyTop]);
		parameterListCommas.Clear ();
		yyVal = pars;
	  }

void case_602()
#line 4206 "cs-parser.jay"
{
		var pars = (List<Parameter>) yyVals[-2+yyTop];
		Parameter p = (Parameter)yyVals[0+yyTop];
		if (pars[0].GetType () != p.GetType ()) {
			report.Error (748, p.Location, "All lambda parameters must be typed either explicitly or implicitly");
		}
		
		pars.Add (p);
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));

		yyVal = pars;
	  }

void case_603()
#line 4222 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];

		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Parameter.Modifier) yyVals[-2+yyTop], null, lt.Location);
	  }

void case_604()
#line 4228 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];

		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, Parameter.Modifier.NONE, null, lt.Location);
	  }

void case_605()
#line 4234 "cs-parser.jay"
{
	  	var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new ImplicitLambdaParameter (lt.Value, lt.Location);
	  }

void case_607()
#line 4242 "cs-parser.jay"
{ 
		var pars_list = (List<Parameter>) yyVals[0+yyTop];
		yyVal = new ParametersCompiled (pars_list.ToArray ());
		lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_611()
#line 4259 "cs-parser.jay"
{
		Block b = end_block (Location.Null);
		b.IsCompilerGenerated = true;
		b.AddStatement (new ContextualReturn ((Expression) yyVals[0+yyTop]));
		yyVal = b;
	  }

void case_613()
#line 4270 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);	
		yyVal = EmptyExpression.Null;
	  }

void case_614()
#line 4278 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];	
		Parameter p = new ImplicitLambdaParameter (lt.Value, lt.Location);
		start_anonymous (true, new ParametersCompiled (p), false, lt.Location);
	  }

void case_615()
#line 4284 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_616()
#line 4289 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		Parameter p = new ImplicitLambdaParameter (lt.Value, lt.Location);
		start_anonymous (true, new ParametersCompiled (p), true, lt.Location);
	  }

void case_617()
#line 4295 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_619()
#line 4304 "cs-parser.jay"
{
	  	valid_param_mod = 0;
		start_anonymous (true, (ParametersCompiled) yyVals[-2+yyTop], false, GetLocation (yyVals[-4+yyTop]));
	  }

void case_620()
#line 4309 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_622()
#line 4318 "cs-parser.jay"
{
	  	valid_param_mod = 0;
		start_anonymous (true, (ParametersCompiled) yyVals[-2+yyTop], true, GetLocation (yyVals[-5+yyTop]));
	  }

void case_623()
#line 4323 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_630()
#line 4346 "cs-parser.jay"
{
		yyVal = new RefValueExpr ((Expression) yyVals[-3+yyTop], (FullNamedExpression) yyVals[-1+yyTop], GetLocation (yyVals[-5+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_631()
#line 4351 "cs-parser.jay"
{
		yyVal = new RefTypeExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_632()
#line 4356 "cs-parser.jay"
{
		yyVal = new MakeRefExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));	  
	  }

void case_636()
#line 4385 "cs-parser.jay"
{
		Class c = new Class (current_container, (MemberName) yyVals[0+yyTop], (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]);
		if (((c.ModFlags & Modifiers.STATIC) != 0) && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (c.Location, "static classes");
		}
			
		push_current_container (c, yyVals[-3+yyTop]);
		lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]));
	  }

void case_637()
#line 4396 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		if (yyVals[0+yyTop] != null)
			current_container.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support) {
			current_container.PartialContainer.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lexer.parsing_modifiers = true;
	  }

void case_638()
#line 4410 "cs-parser.jay"
{
		--lexer.parsing_declaration;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_639()
#line 4416 "cs-parser.jay"
{
		if (yyVals[0+yyTop] == null) {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		} else {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = pop_current_class ();
	  }

void case_642()
#line 4435 "cs-parser.jay"
{
	    mod_locations = null;
		yyVal = ModifierNone;
		lexer.parsing_modifiers = false;
	  }

void case_645()
#line 4449 "cs-parser.jay"
{ 
		var m1 = (Modifiers) yyVals[-1+yyTop];
		var m2 = (Modifiers) yyVals[0+yyTop];

		if ((m1 & m2) != 0) {
			report.Error (1004, lexer.Location - ModifiersExtensions.Name (m2).Length,
				"Duplicate `{0}' modifier", ModifiersExtensions.Name (m2));
		} else if ((m2 & Modifiers.AccessibilityMask) != 0 && (m1 & Modifiers.AccessibilityMask) != 0 &&
			((m2 | m1 & Modifiers.AccessibilityMask) != (Modifiers.PROTECTED | Modifiers.INTERNAL))) {
			report.Error (107, lexer.Location - ModifiersExtensions.Name (m2).Length,
				"More than one protection modifier specified");
		}
		
		yyVal = m1 | m2;
	  }

void case_646()
#line 4468 "cs-parser.jay"
{
		yyVal = Modifiers.NEW;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
		
		if (current_container.Kind == MemberKind.Namespace)
			report.Error (1530, GetLocation (yyVals[0+yyTop]), "Keyword `new' is not allowed on namespace elements");
	  }

void case_647()
#line 4476 "cs-parser.jay"
{
		yyVal = Modifiers.PUBLIC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_648()
#line 4481 "cs-parser.jay"
{
		yyVal = Modifiers.PROTECTED;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_649()
#line 4486 "cs-parser.jay"
{
		yyVal = Modifiers.INTERNAL;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_650()
#line 4491 "cs-parser.jay"
{
		yyVal = Modifiers.PRIVATE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_651()
#line 4496 "cs-parser.jay"
{
		yyVal = Modifiers.ABSTRACT;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_652()
#line 4501 "cs-parser.jay"
{
		yyVal = Modifiers.SEALED;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_653()
#line 4506 "cs-parser.jay"
{
		yyVal = Modifiers.STATIC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_654()
#line 4511 "cs-parser.jay"
{
		yyVal = Modifiers.READONLY;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_655()
#line 4516 "cs-parser.jay"
{
		yyVal = Modifiers.VIRTUAL;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_656()
#line 4521 "cs-parser.jay"
{
		yyVal = Modifiers.OVERRIDE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_657()
#line 4526 "cs-parser.jay"
{
		yyVal = Modifiers.EXTERN;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_658()
#line 4531 "cs-parser.jay"
{
		yyVal = Modifiers.VOLATILE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_659()
#line 4536 "cs-parser.jay"
{
		yyVal = Modifiers.UNSAFE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
		if (!settings.Unsafe)
			Error_UnsafeCodeNotAllowed (GetLocation (yyVals[0+yyTop]));
	  }

void case_660()
#line 4543 "cs-parser.jay"
{
		yyVal = Modifiers.ASYNC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_662()
#line 4552 "cs-parser.jay"
{
		current_type.AddBasesForPart ((List<FullNamedExpression>) yyVals[0+yyTop]);
		lbag.AppendToMember (current_type, GetLocation (yyVals[-1+yyTop]));
	 }

void case_663()
#line 4557 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		current_type.AddBasesForPart ((List<FullNamedExpression>) yyVals[-1+yyTop]);
	  }

void case_666()
#line 4574 "cs-parser.jay"
{
		var constraints = new List<Constraints> (1);
		constraints.Add ((Constraints) yyVals[0+yyTop]);
		yyVal = constraints;
	  }

void case_667()
#line 4580 "cs-parser.jay"
{
		var constraints = (List<Constraints>) yyVals[-1+yyTop];
		Constraints new_constraint = (Constraints)yyVals[0+yyTop];

		foreach (Constraints c in constraints) {
			if (new_constraint.TypeParameter.Value == c.TypeParameter.Value) {
				report.Error (409, new_constraint.Location,
					"A constraint clause has already been specified for type parameter `{0}'",
					new_constraint.TypeParameter.Value);
			}
		}

		constraints.Add (new_constraint);
		yyVal = constraints;
	  }

void case_668()
#line 4599 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new Constraints (new SimpleMemberName (lt.Value, lt.Location), (List<FullNamedExpression>) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_669()
#line 4605 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new Constraints (new SimpleMemberName (lt.Value, lt.Location), null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_670()
#line 4615 "cs-parser.jay"
{
		var constraints = new List<FullNamedExpression> (1);
		constraints.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = constraints;
	  }

void case_671()
#line 4621 "cs-parser.jay"
{
		var constraints = (List<FullNamedExpression>) yyVals[-2+yyTop];
		var prev = constraints [constraints.Count - 1] as SpecialContraintExpr;
		if (prev != null && (prev.Constraint & SpecialConstraint.Constructor) != 0) {			
			report.Error (401, GetLocation (yyVals[-1+yyTop]), "The `new()' constraint must be the last constraint specified");
		}
		
		prev = yyVals[0+yyTop] as SpecialContraintExpr;
		if (prev != null) {
			if ((prev.Constraint & (SpecialConstraint.Class | SpecialConstraint.Struct)) != 0) {
				report.Error (449, prev.Location, "The `class' or `struct' constraint must be the first constraint specified");			
			} else {
			 	prev = constraints [0] as SpecialContraintExpr;
			 	if (prev != null && (prev.Constraint & SpecialConstraint.Struct) != 0) {			
					report.Error (451, GetLocation (yyVals[0+yyTop]), "The `new()' constraint cannot be used with the `struct' constraint");
				}
			}
		}

		constraints.Add ((FullNamedExpression) yyVals[0+yyTop]);
		lbag.AppendTo (constraints, GetLocation (yyVals[-1+yyTop]));
		yyVal = constraints;
	  }

void case_672()
#line 4648 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is ComposedCast)
			report.Error (706, GetLocation (yyVals[0+yyTop]), "Invalid constraint type `{0}'", ((ComposedCast)yyVals[0+yyTop]).GetSignatureForError ());
	  
	  	yyVal = yyVals[0+yyTop];
	  }

void case_673()
#line 4655 "cs-parser.jay"
{
		yyVal = new SpecialContraintExpr (SpecialConstraint.Constructor, GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_677()
#line 4675 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.V_3)
			FeatureIsNotAvailable (lexer.Location, "generic type variance");
		
		yyVal = yyVals[0+yyTop];
	  }

void case_678()
#line 4685 "cs-parser.jay"
{
		yyVal = Variance.Covariant;
		savedLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_679()
#line 4690 "cs-parser.jay"
{
		yyVal = Variance.Contravariant;
		savedLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_680()
#line 4711 "cs-parser.jay"
{
		++lexer.parsing_block;
		start_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_682()
#line 4723 "cs-parser.jay"
{
	 	--lexer.parsing_block;
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_683()
#line 4728 "cs-parser.jay"
{
	 	--lexer.parsing_block;
		yyVal = end_block (lexer.Location);
	  }

void case_684()
#line 4737 "cs-parser.jay"
{
		++lexer.parsing_block;
		current_block.StartLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_685()
#line 4742 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_686()
#line 4746 "cs-parser.jay"
{
		report.Error (1525, GetLocation (yyVals[0+yyTop]), "Unexpected symbol '}', expected '{'");
		lexer.putback ('}');
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_694()
#line 4775 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		var lt =(Tokenizer.LocatedToken) yyVals[-1+yyTop];
		var sn = new SimpleName (lt.Value, lt.Location);
		current_block.AddStatement(new StatementErrorExpression (sn));
		yyVal = null;
	}

void case_695()
#line 4784 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_728()
#line 4848 "cs-parser.jay"
{
		  report.Error (1023, GetLocation (yyVals[0+yyTop]), "An embedded statement may not be a declaration or labeled statement");
		  yyVal = null;
	  }

void case_729()
#line 4853 "cs-parser.jay"
{
		  report.Error (1023, GetLocation (yyVals[0+yyTop]), "An embedded statement may not be a declaration or labeled statement");
		  yyVal = null;
	  }

void case_730()
#line 4858 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_731()
#line 4866 "cs-parser.jay"
{
		/* Uses lexer.Location because semicolon location is not kept in quick mode*/
		yyVal = new EmptyStatement (lexer.Location);
	  }

void case_732()
#line 4874 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		LabeledStatement labeled = new LabeledStatement (lt.Value, current_block, lt.Location);
		lbag.AddLocation (labeled, GetLocation (yyVals[0+yyTop]));
		current_block.AddLabel (labeled);
		current_block.AddStatement (labeled);
	  }

void case_735()
#line 4887 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] is VarExpr)
			yyVals[-1+yyTop] = new SimpleName ("var", ((VarExpr) yyVals[-1+yyTop]).Location);
	  
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_736()
#line 4903 "cs-parser.jay"
{ 
		/* Ok, the above "primary_expression" is there to get rid of*/
		/* both reduce/reduce and shift/reduces in the grammar, it should*/
		/* really just be "type_name".  If you use type_name, a reduce/reduce*/
		/* creeps up.  If you use namespace_or_type_name (which is all we need*/
		/* really) two shift/reduces appear.*/
		/* */

		/* So the super-trick is that primary_expression*/
		/* can only be either a SimpleName or a MemberAccess. */
		/* The MemberAccess case arises when you have a fully qualified type-name like :*/
		/* Foo.Bar.Blah i;*/
		/* SimpleName is when you have*/
		/* Blah i;*/
		
		Expression expr = (Expression) yyVals[-1+yyTop];
		if (yyVals[0+yyTop] == null) {
			SimpleName sn = expr as SimpleName;
			if (sn != null && sn.Name == "var")
				yyVal = new VarExpr (sn.Location);
			else
				yyVal = yyVals[-1+yyTop];
		} else if (expr is ATypeNameExpression) {
			yyVal = new ComposedCast ((ATypeNameExpression)expr, (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			Error_ExpectingTypeName (expr);
			yyVal = null;
		}
	  }

void case_737()
#line 4933 "cs-parser.jay"
{
		ATypeNameExpression expr = yyVals[-1+yyTop] as ATypeNameExpression;

		if (expr != null) {
			yyVal = new ComposedCast (expr, (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			Error_ExpectingTypeName ((Expression)yyVals[-1+yyTop]);
			yyVal = expr;
		}
	  }

void case_738()
#line 4944 "cs-parser.jay"
{
		if (yyVals[0+yyTop] == null)
			yyVal = yyVals[-1+yyTop];
		else
			yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_741()
#line 4959 "cs-parser.jay"
{
		Expression.Error_VoidInvalidInTheContext (GetLocation (yyVals[0+yyTop]), report);
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_743()
#line 4968 "cs-parser.jay"
{
	  	((ComposedTypeSpecifier) yyVals[-1+yyTop]).Next = (ComposedTypeSpecifier) yyVals[0+yyTop];
	  	yyVal = yyVals[-1+yyTop];
	  }

void case_746()
#line 4984 "cs-parser.jay"
{
		if (async_block) {
			report.Error (4003, GetLocation (yyVals[0+yyTop]), "`await' cannot be used as an identifier within an async method or lambda expression");
			yyVal = new Tokenizer.LocatedToken ("await", GetLocation (yyVals[0+yyTop]));
		}
	  }

void case_747()
#line 4994 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockVariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_748()
#line 5001 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
		lbag.AppendTo (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_749()
#line 5007 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.Constant, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockConstantDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_750()
#line 5014 "cs-parser.jay"
{
		if (current_variable.Initializer != null) {
			lbag.AddLocation (current_variable, GetLocation (yyVals[-6+yyTop]), savedLocation, GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddLocation (current_variable, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = current_variable;;
		current_variable = null;
	  }

void case_752()
#line 5027 "cs-parser.jay"
{
		/* Redundant, but wont regress*/
		report.Error (1525, lexer.Location, "Unexpected symbol }");
		lexer.putback ('}');
		yyVal = yyVals[0+yyTop];
	  }

void case_754()
#line 5038 "cs-parser.jay"
{
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
		lbag.AppendTo (current_variable, GetLocation (yyVals[-1+yyTop]));
	  }

void case_755()
#line 5043 "cs-parser.jay"
{
	  	if (yyToken == Token.OPEN_BRACKET_EXPR) {
			report.Error (650, lexer.Location,
				"Syntax error, bad array declarator. To declare a managed array the rank specifier precedes the variable's identifier. To declare a fixed size buffer field, use the fixed keyword before the field type");
			current_variable.Initializer = ErrorExpression.Create (650, lexer.Location,
					"Syntax error, bad array declarator. To declare a managed array the rank specifier precedes the variable's identifier. To declare a fixed size buffer field, use the fixed keyword before the field type");
		} else {
			Error_SyntaxError (yyToken);
			current_variable.Initializer = ErrorExpression.Create (0, lexer.Location,
					"Syntax error");
		}
		lbag.AppendTo (current_variable, GetLocation (yyVals[-1+yyTop]));
	  }

void case_756()
#line 5057 "cs-parser.jay"
{
	  	if (yyToken == Token.OPEN_BRACKET_EXPR) {
			report.Error (650, lexer.Location,
				"Syntax error, bad array declarator. To declare a managed array the rank specifier precedes the variable's identifier. To declare a fixed size buffer field, use the fixed keyword before the field type");
		} else {
			Error_SyntaxError (yyToken);
		}
	  }

void case_760()
#line 5075 "cs-parser.jay"
{
		foreach (var d in current_variable.Declarators) {
			if (d.Initializer == null)
				Error_MissingInitializer (d.Variable.Location);
		}
	  }

void case_763()
#line 5090 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];	  
		var li = new LocalVariable (current_variable.Variable, lt.Value, lt.Location);
		var d = new BlockVariableDeclaration.Declarator (li, null);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-1+yyTop]));
	  }

void case_764()
#line 5099 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];	  
		var li = new LocalVariable (current_variable.Variable, lt.Value, lt.Location);
		var d = new BlockVariableDeclaration.Declarator (li, (Expression) yyVals[0+yyTop]);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_766()
#line 5115 "cs-parser.jay"
{
		savedLocation = GetLocation (yyVals[-1+yyTop]);
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
	  }

void case_771()
#line 5133 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];	  
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.Constant, lt.Location);
		var d = new BlockVariableDeclaration.Declarator (li, (Expression) yyVals[0+yyTop]);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_773()
#line 5146 "cs-parser.jay"
{
		yyVal = new StackAlloc ((Expression) yyVals[-3+yyTop], (Expression) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_774()
#line 5151 "cs-parser.jay"
{
		report.Error (1575, GetLocation (yyVals[-1+yyTop]), "A stackalloc expression requires [] after type");
		yyVal = new StackAlloc ((Expression) yyVals[0+yyTop], null, GetLocation (yyVals[-1+yyTop]));		
	  }

void case_775()
#line 5159 "cs-parser.jay"
{
		yyVal = yyVals[-1+yyTop];
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_777()
#line 5165 "cs-parser.jay"
{
		yyVal = yyVals[-1+yyTop];
		report.Error (1002, GetLocation (yyVals[0+yyTop]), "; expected");
		lexer.putback ('}');
	  }

void case_780()
#line 5183 "cs-parser.jay"
{
		ExpressionStatement s = yyVals[0+yyTop] as ExpressionStatement;
		if (s == null) {
			Expression.Error_InvalidExpressionStatement (report, GetLocation (yyVals[0+yyTop]));
			yyVal = new StatementErrorExpression (yyVals[0+yyTop] as Expression);
		} else {
			yyVal = new StatementExpression (s);
		}
	  }

void case_781()
#line 5196 "cs-parser.jay"
{
		Expression expr = (Expression) yyVals[0+yyTop];
		ExpressionStatement s;

	        s = new OptionalAssign (new SimpleName ("$retval", lexer.Location), expr, lexer.Location);
		yyVal = new StatementExpression (s);
	  }

void case_782()
#line 5204 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_785()
#line 5218 "cs-parser.jay"
{ 
		if (yyVals[0+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
		
		yyVal = new If ((BooleanExpression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_786()
#line 5227 "cs-parser.jay"
{
		yyVal = new If ((BooleanExpression) yyVals[-4+yyTop], (Statement) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-6+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
		
		if (yyVals[-2+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[-2+yyTop]));
		if (yyVals[0+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_787()
#line 5237 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		
		yyVal = new If ((BooleanExpression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_789()
#line 5251 "cs-parser.jay"
{
		yyVal = new Switch ((Expression) yyVals[-5+yyTop], (ExplicitBlock) current_block.Explicit, (List<SwitchSection>) yyVals[-1+yyTop], GetLocation (yyVals[-7+yyTop]));	
		end_block (GetLocation (yyVals[0+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_790()
#line 5257 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  
		yyVal = new Switch ((Expression) yyVals[-1+yyTop], null, null, GetLocation (yyVals[-3+yyTop]));	
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_791()
#line 5267 "cs-parser.jay"
{
		report.Warning (1522, 1, current_block.StartLocation, "Empty switch block"); 
		yyVal = new List<SwitchSection> ();
	  }

void case_793()
#line 5276 "cs-parser.jay"
{
		var sections = new List<SwitchSection> (4);

		sections.Add ((SwitchSection) yyVals[0+yyTop]);
		yyVal = sections;
	  }

void case_794()
#line 5283 "cs-parser.jay"
{
		var sections = (List<SwitchSection>) yyVals[-1+yyTop];

		sections.Add ((SwitchSection) yyVals[0+yyTop]);
		yyVal = sections;
	  }

void case_795()
#line 5290 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new List<SwitchSection> ();
	  }

void case_798()
#line 5309 "cs-parser.jay"
{
		var labels = new List<SwitchLabel> (2);

		labels.Add ((SwitchLabel) yyVals[0+yyTop]);
		yyVal = labels;
	  }

void case_799()
#line 5316 "cs-parser.jay"
{
		var labels = (List<SwitchLabel>) (yyVals[-1+yyTop]);
		labels.Add ((SwitchLabel) yyVals[0+yyTop]);

		yyVal = labels;
	  }

void case_800()
#line 5326 "cs-parser.jay"
{
	 	yyVal = new SwitchLabel ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	 	lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	 }

void case_801()
#line 5331 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new SwitchLabel ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_807()
#line 5350 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		yyVal = new While ((BooleanExpression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_808()
#line 5358 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		
		yyVal = new While ((BooleanExpression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_809()
#line 5368 "cs-parser.jay"
{
		yyVal = new Do ((Statement) yyVals[-5+yyTop], (BooleanExpression) yyVals[-2+yyTop], GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_810()
#line 5373 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Do ((Statement) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]), Location.Null);
	  }

void case_811()
#line 5378 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  
		yyVal = new Do ((Statement) yyVals[-4+yyTop], (BooleanExpression) yyVals[-1+yyTop], GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_812()
#line 5388 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[0+yyTop]));
		current_block.IsCompilerGenerated = true;
		For f = new For (GetLocation (yyVals[-1+yyTop]));
		current_block.AddStatement (f);
		lbag.AddStatement (f, current_block.StartLocation);
		yyVal = f;
	  }

void case_814()
#line 5405 "cs-parser.jay"
{
		For f =  (For) yyVals[-2+yyTop];
		f.Initializer = (Statement) yyVals[-1+yyTop];
		lbag.AppendTo (f, GetLocation (yyVals[0+yyTop]));
		yyVal = f;
	  }

void case_816()
#line 5415 "cs-parser.jay"
{
		report.Error (1525, GetLocation (yyVals[0+yyTop]), "Unexpected symbol ')', expected ';'");
		For f =  (For) yyVals[-2+yyTop];
		f.Initializer = (Statement) yyVals[-1+yyTop];
		lbag.AppendTo (f, GetLocation (yyVals[0+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	}

void case_817()
#line 5426 "cs-parser.jay"
{
		For f =  (For) yyVals[-2+yyTop];
		f.Condition = (BooleanExpression) yyVals[-1+yyTop];
		lbag.AppendTo (f, GetLocation (yyVals[0+yyTop]));
		yyVal = f;
	  }

void case_819()
#line 5437 "cs-parser.jay"
{
		report.Error (1525, GetLocation (yyVals[0+yyTop]), "Unexpected symbol ')', expected ';'");
		For f =  (For) yyVals[-2+yyTop];
		f.Condition = (BooleanExpression) yyVals[-1+yyTop];
		lbag.AppendTo (f, GetLocation (yyVals[0+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	}

void case_820()
#line 5449 "cs-parser.jay"
{
		For f =  (For) yyVals[-3+yyTop];
		f.Iterator = (Statement) yyVals[-2+yyTop];
		
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		f.Statement = (Statement) yyVals[0+yyTop];
		lbag.AppendTo (f, GetLocation (yyVals[-1+yyTop]));

		yyVal = end_block (GetLocation (yyVals[-1+yyTop]));
	  }

void case_821()
#line 5462 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = end_block (current_block.StartLocation);
	  }

void case_824()
#line 5475 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockVariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_825()
#line 5482 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
	  }

void case_833()
#line 5506 "cs-parser.jay"
{
	  	var sl = yyVals[-2+yyTop] as StatementList;
	  	if (sl == null) {
	  		sl = new StatementList ((Statement) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop]);
			lbag.AddStatement (sl, GetLocation (yyVals[-1+yyTop]));
	  	} else {
	  		sl.Add ((Statement) yyVals[0+yyTop]);
	  		lbag.AppendTo (sl, GetLocation (yyVals[-1+yyTop]));
	  		
	  	}
	  		
		yyVal = sl;
	  }

void case_834()
#line 5523 "cs-parser.jay"
{
		report.Error (230, GetLocation (yyVals[-3+yyTop]), "Type and identifier are both required in a foreach statement");

		start_block (GetLocation (yyVals[-2+yyTop]));
		current_block.IsCompilerGenerated = true;
		
		Foreach f = new Foreach ((Expression) yyVals[-1+yyTop], null, null, null, null, GetLocation (yyVals[-3+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-2+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_835()
#line 5536 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	
		start_block (GetLocation (yyVals[-3+yyTop]));
		current_block.IsCompilerGenerated = true;
		
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.ForeachVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		
		Foreach f = new Foreach ((Expression) yyVals[-2+yyTop], li, null, null, null, GetLocation (yyVals[-4+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-3+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_836()
#line 5553 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[-5+yyTop]));
		current_block.IsCompilerGenerated = true;
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.ForeachVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		yyVal = li;
	  }

void case_837()
#line 5562 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
		
		Foreach f = new Foreach ((Expression) yyVals[-6+yyTop], (LocalVariable) yyVals[-1+yyTop], (Expression) yyVals[-3+yyTop], (Statement) yyVals[0+yyTop], current_block, GetLocation (yyVals[-8+yyTop]));
		lbag.AddStatement (f, GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		end_block (GetLocation (yyVals[-2+yyTop]));
		
		yyVal = f;
	  }

void case_838()
#line 5573 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[-3+yyTop]));
		current_block.IsCompilerGenerated = true;
		var lt = yyVals[-1+yyTop] as Tokenizer.LocatedToken;
		var li = lt != null ? new LocalVariable (current_block, lt.Value, LocalVariable.Flags.ForeachVariable | LocalVariable.Flags.Used, lt.Location) : null;
		
		Foreach f = new Foreach ((Expression) yyVals[-2+yyTop], li, null, null, null, GetLocation (yyVals[-4+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-3+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_839()
#line 5586 "cs-parser.jay"
{
		Foreach f = new Foreach ((Expression) yyVals[-1+yyTop], null, null, null, null, GetLocation (yyVals[-3+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-2+yyTop]));
		yyVal = f;
	  }

void case_846()
#line 5606 "cs-parser.jay"
{
		yyVal = new Break (GetLocation (yyVals[-1+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_847()
#line 5614 "cs-parser.jay"
{
		yyVal = new Continue (GetLocation (yyVals[-1+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_848()
#line 5619 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Continue (GetLocation (yyVals[-1+yyTop]));
	  }

void case_849()
#line 5627 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new Goto (lt.Value, GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_850()
#line 5633 "cs-parser.jay"
{
		yyVal = new GotoCase ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_851()
#line 5638 "cs-parser.jay"
{
		yyVal = new GotoDefault (GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_852()
#line 5646 "cs-parser.jay"
{
		yyVal = new Return ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_853()
#line 5651 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Return ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_854()
#line 5656 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Return (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_855()
#line 5664 "cs-parser.jay"
{
		yyVal = new Throw ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_856()
#line 5669 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Throw (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_857()
#line 5677 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		string s = lt.Value;
		if (s != "yield"){
			report.Error (1003, lt.Location, "; expected");
		} else if (yyVals[-1+yyTop] == null) {
			report.Error (1627, GetLocation (yyVals[0+yyTop]), "Expression expected after yield return");
		} else if (lang_version == LanguageVersion.ISO_1){
			FeatureIsNotAvailable (lt.Location, "iterators");
		}
		
		current_block.Explicit.RegisterIteratorYield ();
		yyVal = new Yield ((Expression) yyVals[-1+yyTop], lt.Location);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_858()
#line 5693 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		string s = lt.Value;
		if (s != "yield"){
			report.Error (1003, lt.Location, "; expected");
		} else if (yyVals[-1+yyTop] == null) {
			report.Error (1627, GetLocation (yyVals[0+yyTop]), "Expression expected after yield return");
		} else if (lang_version == LanguageVersion.ISO_1){
			FeatureIsNotAvailable (lt.Location, "iterators");
		}
		
		current_block.Explicit.RegisterIteratorYield ();
		yyVal = new Yield ((Expression) yyVals[-1+yyTop], lt.Location);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_859()
#line 5711 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		string s = lt.Value;
		if (s != "yield"){
			report.Error (1003, lt.Location, "; expected");
		} else if (lang_version == LanguageVersion.ISO_1){
			FeatureIsNotAvailable (lt.Location, "iterators");
		}
		
		current_block.Explicit.RegisterIteratorYield ();
		yyVal = new YieldBreak (lt.Location);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_863()
#line 5737 "cs-parser.jay"
{
		yyVal = new TryFinally ((Statement) yyVals[-2+yyTop], (Block) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_864()
#line 5742 "cs-parser.jay"
{
		var loc = GetLocation (yyVals[-4+yyTop]);
		yyVal = new TryFinally (new TryCatch ((Block) yyVals[-3+yyTop], (List<Catch>) yyVals[-2+yyTop], loc, true), (Block) yyVals[0+yyTop], loc);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_865()
#line 5748 "cs-parser.jay"
{
		Error_SyntaxError (1524, yyToken);
		yyVal = new TryCatch ((Block) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]), false);
	  }

void case_866()
#line 5756 "cs-parser.jay"
{
		var l = new List<Catch> (2);

		l.Add ((Catch) yyVals[0+yyTop]);
		yyVal = l;
	  }

void case_867()
#line 5763 "cs-parser.jay"
{
		var l = (List<Catch>) yyVals[-1+yyTop];
		
		Catch c = (Catch) yyVals[0+yyTop];
		if (l [l.Count - 1].IsGeneral) {
			report.Error (1017, c.loc, "Try statement already has an empty catch block");
		}
		
		l.Add (c);
		yyVal = l;
	  }

void case_871()
#line 5787 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[-3+yyTop]));
		var c = new Catch (current_block, GetLocation (yyVals[-4+yyTop]));
		c.TypeExpression = (FullNamedExpression) yyVals[-2+yyTop];

		if (yyVals[-1+yyTop] != null) {
			var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
			c.Variable = new LocalVariable (current_block, lt.Value, lt.Location);
			current_block.AddLocalName (c.Variable);
		}

		lbag.AddLocation (c, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = c;
	  }

void case_873()
#line 5806 "cs-parser.jay"
{
	  	if (yyToken == Token.CLOSE_PARENS) {
			report.Error (1015, lexer.Location,
				"A type that derives from `System.Exception', `object', or `string' expected");
		} else {
			Error_SyntaxError (yyToken);
		}
		
		yyVal = new Catch (null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_876()
#line 5834 "cs-parser.jay"
{
		if (!settings.Unsafe)
			Error_UnsafeCodeNotAllowed (GetLocation (yyVals[0+yyTop]));
	  }

void case_878()
#line 5844 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		yyVal = new Lock ((Expression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_879()
#line 5852 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Lock ((Expression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_880()
#line 5862 "cs-parser.jay"
{
	    start_block (GetLocation (yyVals[-2+yyTop]));
	    
		current_block.IsCompilerGenerated = true;
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.FixedVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new Fixed.VariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_881()
#line 5872 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
	  }

void case_882()
#line 5877 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Fixed f = new Fixed ((Fixed.VariableDeclaration) yyVals[-1+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-9+yyTop]));
		current_block.AddStatement (f);
		lbag.AddStatement (f, GetLocation (yyVals[-8+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = end_block (GetLocation (yyVals[-2+yyTop]));
	  }

void case_883()
#line 5890 "cs-parser.jay"
{
	    start_block (GetLocation (yyVals[-2+yyTop]));
	    
		current_block.IsCompilerGenerated = true;
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.UsingVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new Using.VariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_884()
#line 5900 "cs-parser.jay"
{
		yyVal = current_variable;	  
		current_variable = null;
	  }

void case_885()
#line 5905 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Using u = new Using ((Using.VariableDeclaration) yyVals[-1+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-8+yyTop]));
		lbag.AddStatement (u, GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-2+yyTop]));
		current_block.AddStatement (u);
		yyVal = end_block (GetLocation (yyVals[-2+yyTop]));
	  }

void case_886()
#line 5915 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		yyVal = new Using ((Expression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_887()
#line 5923 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		
		yyVal = new Using ((Expression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_889()
#line 5934 "cs-parser.jay"
{
		/* It has to be here for the parent to safely restore artificial block*/
	  	Error_SyntaxError (yyToken);
	  }

void case_891()
#line 5946 "cs-parser.jay"
{
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
		lbag.AppendTo (current_variable, GetLocation (yyVals[-1+yyTop]));
		yyVal = current_variable;
	  }

void case_892()
#line 5958 "cs-parser.jay"
{
		lexer.query_parsing = false;
			
		Linq.AQueryClause from = yyVals[-1+yyTop] as Linq.AQueryClause;
			
		from.Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = from;
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_893()
#line 5970 "cs-parser.jay"
{
		Linq.AQueryClause from = yyVals[-1+yyTop] as Linq.AQueryClause;
			
		from.Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = from;
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_894()
#line 5981 "cs-parser.jay"
{
	        lexer.query_parsing = false;
		yyVal = yyVals[-1+yyTop];

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_895()
#line 5988 "cs-parser.jay"
{
	        yyVal = yyVals[-1+yyTop];
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_896()
#line 5997 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		var start = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (start, GetLocation (yyVals[-1+yyTop]));
		yyVal = new Linq.QueryExpression (start);
	  }

void case_897()
#line 6007 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		var start = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-4+yyTop])) {
			IdentifierType = (FullNamedExpression)yyVals[-3+yyTop]
		};
		lbag.AddLocation (start, GetLocation (yyVals[-1+yyTop]));
		yyVal = new Linq.QueryExpression (start);
	  }

void case_898()
#line 6022 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		var start = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (start, GetLocation (yyVals[-1+yyTop]));
		yyVal = new Linq.QueryExpression (start);
	  }

void case_899()
#line 6032 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		var start = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-4+yyTop])) {
			IdentifierType = (FullNamedExpression)yyVals[-3+yyTop]
		};
		lbag.AddLocation (start, GetLocation (yyVals[-1+yyTop]));
		yyVal = new Linq.QueryExpression (start);
	  }

void case_901()
#line 6051 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		yyVal = new Linq.SelectMany ((Linq.QueryBlock)current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);

		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_903()
#line 6067 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);

		yyVal = new Linq.SelectMany ((Linq.QueryBlock)current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-5+yyTop])) {
			IdentifierType = (FullNamedExpression)yyVals[-4+yyTop]
		};
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_904()
#line 6086 "cs-parser.jay"
{
	  	Linq.AQueryClause head = (Linq.AQueryClause)yyVals[-1+yyTop];
		
		if (yyVals[0+yyTop] != null)
			head.Next = (Linq.AQueryClause)yyVals[0+yyTop];
				
		if (yyVals[-2+yyTop] != null) {
			Linq.AQueryClause clause = (Linq.AQueryClause)yyVals[-2+yyTop];
			clause.Tail.Next = head;
			head = clause;
		}
		
		yyVal = head;
	  }

void case_905()
#line 6101 "cs-parser.jay"
{
	  	Linq.AQueryClause head = (Linq.AQueryClause)yyVals[0+yyTop];

		if (yyVals[-1+yyTop] != null) {
			Linq.AQueryClause clause = (Linq.AQueryClause)yyVals[-1+yyTop];
			clause.Tail.Next = head;
			head = clause;
		}
		
		yyVal = head;
	  }

void case_907()
#line 6114 "cs-parser.jay"
{
		report.Error (742, GetLocation (yyVals[0+yyTop]), "Unexpected symbol `{0}'. A query body must end with select or group clause", GetSymbolName (yyToken));
		yyVal = yyVals[-1+yyTop];
	  }

void case_908()
#line 6119 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_910()
#line 6131 "cs-parser.jay"
{
		yyVal = new Linq.Select ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_911()
#line 6138 "cs-parser.jay"
{
	  	if (linq_clause_blocks == null)
	  		linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  	linq_clause_blocks.Push ((Linq.QueryBlock)current_block);
	  }

void case_912()
#line 6146 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_913()
#line 6153 "cs-parser.jay"
{
		yyVal = new Linq.GroupBy ((Linq.QueryBlock)current_block, (Expression)yyVals[-3+yyTop], linq_clause_blocks.Pop (), (Expression)yyVals[0+yyTop], GetLocation (yyVals[-5+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_915()
#line 6165 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-1+yyTop]).Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-1+yyTop];
	  }

void case_922()
#line 6185 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
	  	yyVal = new Linq.Let ((Linq.QueryBlock) current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  	
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);
	  }

void case_924()
#line 6204 "cs-parser.jay"
{
		yyVal = new Linq.Where ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_925()
#line 6214 "cs-parser.jay"
{
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_926()
#line 6222 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_927()
#line 6230 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_928()
#line 6238 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
	  
		var outer_selector = linq_clause_blocks.Pop ();
		var block = linq_clause_blocks.Pop ();

		var lt = (Tokenizer.LocatedToken) yyVals[-10+yyTop];	
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		Linq.RangeVariable into;
		
		if (yyVals[0+yyTop] == null) {
			into = sn;
	  		yyVal = new Linq.Join (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, GetLocation (yyVals[-11+yyTop]));
			lbag.AddLocation (yyVal, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]));
		} else {
			/**/
			/* Set equals right side parent to beginning of linq query, it is not accessible therefore cannot cause name collisions*/
			/**/
			var parent = block.Parent;
			while (parent is Linq.QueryBlock) {
				parent = parent.Parent;
			}
			current_block.Parent = parent;
			
			((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		
			lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
			into = new Linq.RangeVariable (lt.Value, lt.Location);

			yyVal = new Linq.GroupJoin (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, into, GetLocation (yyVals[-11+yyTop]));	
			lbag.AddLocation (yyVal, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]), opt_intoStack.Pop ());
		}

		current_block = block.Parent;
		((Linq.QueryBlock)current_block).AddRangeVariable (into);
	  }

void case_929()
#line 6276 "cs-parser.jay"
{
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_930()
#line 6284 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_931()
#line 6292 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_932()
#line 6300 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
	  
		var outer_selector = linq_clause_blocks.Pop ();
		var block = linq_clause_blocks.Pop ();
		
		var lt = (Tokenizer.LocatedToken) yyVals[-10+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		Linq.RangeVariable into;
		
		if (yyVals[0+yyTop] == null) {
			into = sn;		
	  		yyVal = new Linq.Join (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, GetLocation (yyVals[-12+yyTop])) {
	  			IdentifierType = (FullNamedExpression)yyVals[-11+yyTop]
	  		};
			lbag.AddLocation (yyVal, GetLocation (yyVals[-10+yyTop]), GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]));
		} else {
			/**/
			/* Set equals right side parent to beginning of linq query, it is not accessible therefore cannot cause name collisions*/
			/**/
			var parent = block.Parent;
			while (parent is Linq.QueryBlock) {
				parent = parent.Parent;
			}
			current_block.Parent = parent;
		
			((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		
			lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
			into = new Linq.RangeVariable (lt.Value, lt.Location); /* TODO:*/
			
			yyVal = new Linq.GroupJoin (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, into, GetLocation (yyVals[-12+yyTop])) {
	  			IdentifierType = (FullNamedExpression)yyVals[-11+yyTop]
	  		};			
			lbag.AddLocation (yyVal, GetLocation (yyVals[-10+yyTop]), GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]), opt_intoStack.Pop ());
		}
		
		current_block = block.Parent;
		((Linq.QueryBlock)current_block).AddRangeVariable (into);		
	  }

void case_934()
#line 6346 "cs-parser.jay"
{
		opt_intoStack.Push (GetLocation (yyVals[-1+yyTop]));
		yyVal = yyVals[0+yyTop];
	  }

void case_936()
#line 6358 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		yyVal = yyVals[0+yyTop];
	  }

void case_938()
#line 6369 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_939()
#line 6376 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-3+yyTop]).Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-3+yyTop];
	  }

void case_941()
#line 6385 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock ((Linq.QueryBlock) current_block, lexer.Location);	 
	 }

void case_942()
#line 6392 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-3+yyTop]).Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-3+yyTop];
	 }

void case_944()
#line 6404 "cs-parser.jay"
{
		yyVal = new Linq.OrderByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_945()
#line 6409 "cs-parser.jay"
{
		yyVal = new Linq.OrderByDescending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_947()
#line 6421 "cs-parser.jay"
{
		yyVal = new Linq.ThenByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_948()
#line 6426 "cs-parser.jay"
{
		yyVal = new Linq.ThenByDescending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_950()
#line 6436 "cs-parser.jay"
{
		/* query continuation block is not linked with query block but with block*/
		/* before. This means each query can use same range variable names for*/
		/* different identifiers.*/

		current_block.SetEndLocation (GetLocation (yyVals[-1+yyTop]));
		current_block = current_block.Parent;
	
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);		
	  }

void case_951()
#line 6452 "cs-parser.jay"
{
		var current_block = linq_clause_blocks.Pop ();	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
  		yyVal = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, null, rv, GetLocation (yyVals[-3+yyTop])) {
  			next = (Linq.AQueryClause)yyVals[0+yyTop]
  		};
	  }

void case_954()
#line 6479 "cs-parser.jay"
{ 
		current_container = current_type = new Class (current_container, new MemberName ("<InteractiveExpressionClass>"), Modifiers.PUBLIC, null);

		/* (ref object retval)*/
		Parameter [] mpar = new Parameter [1];
		mpar [0] = new Parameter (new TypeExpression (compiler.BuiltinTypes.Object, Location.Null), "$retval", Parameter.Modifier.REF, null, Location.Null);

		ParametersCompiled pars = new ParametersCompiled (mpar);
		var mods = Modifiers.PUBLIC | Modifiers.STATIC;
		if (settings.Unsafe)
			mods |= Modifiers.UNSAFE;

		current_local_parameters = pars;
		Method method = new Method (
			current_type,
			new TypeExpression (compiler.BuiltinTypes.Void, Location.Null),
			mods,
			new MemberName ("Host"),
			pars,
			null /* attributes */);
			
		current_type.AddMember (method);			

		oob_stack.Push (method);
		++lexer.parsing_block;
		start_block (lexer.Location);
	  }

void case_955()
#line 6507 "cs-parser.jay"
{
		--lexer.parsing_block;
		Method method = (Method) oob_stack.Pop ();

		method.Block = (ToplevelBlock) end_block(lexer.Location);

		InteractiveResult = (Class) pop_current_class ();
		current_local_parameters = null;
	  }

void case_965()
#line 6550 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedBuiltinType = (TypeExpression)yyVals[-1+yyTop];
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
		yyVal = null;
	  }

void case_966()
#line 6556 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedBuiltinType = (TypeExpression)yyVals[-3+yyTop];
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberName (lt.Value);
	  }

void case_969()
#line 6571 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[-1+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-6+yyTop], MemberCache.IndexerNameAlias, Location.Null);
	  }

void case_970()
#line 6576 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop] ?? new List<DocumentationParameter> (1);
		p.Add (new DocumentationParameter ((FullNamedExpression) yyVals[-1+yyTop]));
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = Operator.OpType.Explicit;
		yyVal = null;
	  }

void case_971()
#line 6584 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop] ?? new List<DocumentationParameter> (1);
		p.Add (new DocumentationParameter ((FullNamedExpression) yyVals[-1+yyTop]));
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = Operator.OpType.Implicit;
		yyVal = null;
	  }

void case_972()
#line 6592 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop] ?? new List<DocumentationParameter> (1);
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = (Operator.OpType) yyVals[-1+yyTop];
		yyVal = null;
	  }

void case_980()
#line 6630 "cs-parser.jay"
{
		var parameters = new List<DocumentationParameter> ();
		parameters.Add ((DocumentationParameter) yyVals[0+yyTop]);
		yyVal = parameters;
	  }

void case_981()
#line 6636 "cs-parser.jay"
{
		var parameters = yyVals[-2+yyTop] as List<DocumentationParameter>;
		parameters.Add ((DocumentationParameter) yyVals[0+yyTop]);
		yyVal = parameters;
	  }

void case_982()
#line 6645 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != null)
			yyVal = new DocumentationParameter ((Parameter.Modifier) yyVals[-1+yyTop], (FullNamedExpression) yyVals[0+yyTop]);
		else
			yyVal = new DocumentationParameter ((FullNamedExpression) yyVals[0+yyTop]);
	  }

#line default
   static readonly short [] yyLhs  = {              -1,
    0,    4,    0,    0,    1,    1,    1,    1,    2,    2,
   11,   11,   12,   12,   13,   13,   14,   15,   15,   15,
   19,   20,   17,   18,   18,   18,   22,   22,   23,   23,
    7,    7,    6,    6,   21,   21,    8,    8,   24,   24,
   24,   25,   25,   25,   25,   25,    9,    9,   10,   10,
   33,   31,   36,   32,   32,   34,   34,   34,   34,   35,
   35,   40,   37,   38,   39,   39,   41,   41,   41,   41,
   41,   42,   42,   46,   43,   45,   48,   48,   48,   49,
   49,   50,   50,   51,   51,   51,   51,   51,   51,   51,
   51,   51,   51,   51,   51,   65,   67,   69,   70,   71,
   27,   27,   74,   52,   75,   75,   76,   76,   77,   79,
   73,   73,   78,   78,   84,   53,   88,   53,   53,   83,
   91,   83,   85,   85,   92,   92,   93,   94,   93,   89,
   89,   95,   95,   96,   97,   87,   87,   90,   90,   90,
  100,   54,  103,  104,   98,  105,  106,  107,   98,   98,
   98,   99,   99,  102,  102,  110,  110,  110,  110,  110,
  110,  110,  110,  110,  110,  111,  111,  114,  114,  114,
  114,  117,  114,  115,  115,  118,  118,  119,  119,  119,
  112,  112,  112,  120,  120,  120,  113,  122,  124,  125,
   55,  127,  128,  129,   57,  123,  123,  123,  123,  123,
  133,  130,  134,  131,  132,  132,  132,  135,  136,  137,
  139,   28,   28,  138,  138,  140,  140,  141,  141,  141,
  141,  141,  141,  141,  141,  141,  144,   58,  143,  143,
  145,  145,  148,  142,  142,  147,  147,  147,  147,  147,
  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,
  147,  147,  147,  147,  147,  147,  147,  150,  149,  151,
  149,  149,  149,   59,  154,  156,  152,  153,  153,  155,
  155,  160,  158,  161,  158,  158,  158,  162,   60,  164,
   56,  167,  168,   56,  163,  170,  163,  165,  165,  171,
  171,  172,  173,  172,  174,  169,  166,  166,  166,  166,
  166,  178,  175,  179,  176,  177,  177,   61,  181,  183,
  184,   29,  180,  180,  180,  182,  182,  182,  185,  185,
  186,  187,  186,  186,  186,  188,  189,  190,   30,  191,
  191,   16,   16,  192,  192,  195,  194,  194,  194,  196,
  196,  198,   64,  121,  101,  101,  126,  126,  199,  199,
  199,  197,  197,  200,  200,  201,  201,  203,  203,   82,
   72,   72,   86,   86,  116,  116,  146,  146,  204,  204,
  204,  204,  204,  208,  208,  209,  207,  207,  207,  207,
  207,  207,  207,  210,  210,  210,  210,  210,  210,  210,
  210,  210,  211,  211,  211,  211,  211,  211,  211,  211,
  211,  211,  211,  211,  211,  211,  211,  211,  211,  211,
  211,  211,  212,  212,  212,  213,  213,  213,  233,  233,
  234,  234,  235,  235,  215,  215,  232,  232,  232,  232,
  232,  232,  232,  232,  217,  217,  237,  237,  238,  238,
  239,  239,  241,  241,  241,  242,  242,  242,  242,  242,
  243,  243,  159,  159,  236,  236,  236,  236,  236,  248,
  248,  247,  247,  249,  249,  249,  249,  250,  218,  218,
  218,  246,  246,  246,  251,  251,  252,  252,  219,  220,
  220,  221,  222,  223,  223,  214,  214,  214,  214,  214,
  257,  253,  224,  258,  258,  259,  259,  260,  260,  261,
  261,  261,  261,  254,  254,  205,  205,  256,  256,  262,
  262,  255,  255,   81,   81,  263,  263,  264,  225,  265,
  265,  265,  266,  266,  266,  266,  266,  267,  193,  226,
  227,  228,  229,  269,  230,  270,  230,  268,  268,  272,
  271,  216,  273,  273,  273,  273,  273,  274,  274,  274,
  274,  274,  274,  274,  275,  275,  275,  275,  276,  276,
  276,  276,  276,  277,  277,  277,  278,  278,  278,  278,
  278,  279,  279,  279,  280,  280,  281,  281,  282,  282,
  283,  283,  284,  284,  285,  285,  286,  286,  286,  288,
  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,
  289,  289,  290,  290,  290,  291,  291,  292,  292,  294,
  293,  287,  287,  296,  295,  297,  295,  298,  299,  295,
  300,  301,  295,   44,   44,  244,  244,  244,  244,  231,
  231,  231,   80,  303,  304,  305,  306,  307,   26,   63,
   63,   62,   62,  108,  108,  308,  308,  308,  308,  308,
  308,  308,  308,  308,  308,  308,  308,  308,  308,  308,
   66,   66,   66,   68,   68,  309,  309,  310,  310,  311,
  311,  312,  312,  312,  312,  202,  202,  313,  313,  315,
  109,  316,  316,  317,  157,  157,  314,  314,  318,  318,
  319,  319,  319,  319,  319,  323,  323,  324,  324,  324,
  321,  321,  321,  321,  321,  321,  321,  321,  321,  321,
  321,  321,  321,  325,  325,  325,  325,  325,  325,  325,
  325,  325,  325,  325,  325,  325,  339,  339,  339,  339,
  326,  340,  322,  341,  341,  342,  342,  342,  342,  342,
  342,  206,  206,  343,   47,   47,  345,  320,  349,  320,
  347,  347,  344,  344,  344,  344,  346,  346,  353,  353,
  352,  352,  354,  354,  348,  348,  350,  350,  355,  355,
  356,  351,  351,  351,  327,  327,  327,  338,  338,  357,
  358,  358,  328,  328,  359,  359,  359,  362,  360,  360,
  361,  361,  363,  363,  363,  366,  364,  365,  365,  367,
  367,  367,  329,  329,  329,  329,  368,  368,  369,  369,
  369,  373,  370,  376,  372,  372,  379,  375,  375,  378,
  378,  374,  374,  382,  381,  381,  377,  377,  380,  380,
  384,  383,  383,  371,  371,  385,  371,  371,  371,  330,
  330,  330,  330,  330,  330,  386,  387,  387,  388,  388,
  388,  389,  389,  389,  390,  390,  391,  391,  391,  392,
  392,  331,  331,  331,  331,  393,  393,  395,  395,  394,
  396,  394,  394,  332,  333,  397,  336,  334,  334,  399,
  400,  337,  402,  403,  335,  335,  335,  401,  401,  398,
  398,  302,  302,  302,  302,  404,  404,  406,  406,  408,
  407,  409,  407,  405,  405,  405,  405,  405,  413,  411,
  414,  415,  411,  410,  410,  416,  416,  416,  416,  416,
  421,  417,  422,  418,  423,  424,  425,  419,  427,  428,
  429,  419,  426,  426,  431,  420,  430,  434,  430,  433,
  436,  433,  432,  432,  432,  435,  435,  435,  412,  437,
  412,    3,    3,  438,    3,    3,  439,  439,  245,  245,
  240,  240,    5,  440,  440,  440,  440,  444,  440,  440,
  440,  440,  441,  441,  442,  445,  442,  443,  443,  446,
  446,  447,
  };
   static readonly short [] yyLen = {           2,
    2,    0,    3,    1,    2,    4,    3,    1,    0,    1,
    1,    2,    4,    2,    1,    2,    1,    3,    5,    2,
    0,    0,   11,    1,    3,    1,    0,    1,    0,    1,
    0,    1,    0,    1,    0,    1,    1,    2,    1,    1,
    2,    1,    1,    1,    1,    1,    0,    1,    1,    2,
    0,    3,    0,    6,    3,    1,    1,    1,    1,    1,
    3,    0,    3,    1,    0,    3,    0,    1,    1,    3,
    3,    1,    1,    0,    4,    4,    0,    1,    1,    0,
    1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    0,    0,    0,    0,    0,
   16,    5,    0,    9,    0,    1,    1,    2,    3,    0,
    3,    1,    1,    1,    0,    8,    0,    9,    6,    0,
    0,    3,    0,    1,    1,    2,    2,    0,    5,    0,
    1,    1,    2,    3,    0,    4,    2,    1,    1,    1,
    0,    3,    0,    0,   10,    0,    0,    0,   12,    8,
    5,    1,    1,    0,    1,    1,    3,    3,    3,    5,
    3,    5,    1,    1,    1,    1,    3,    4,    6,    2,
    4,    0,    7,    0,    1,    1,    2,    1,    1,    1,
    4,    6,    4,    1,    2,    2,    1,    0,    0,    0,
   10,    0,    0,    0,   13,    1,    2,    1,    2,    1,
    0,    5,    0,    5,    1,    1,    1,    0,    0,    0,
    0,   15,    5,    0,    1,    1,    2,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    0,    5,    1,    1,
    1,    1,    0,    7,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    0,    7,    0,
    7,    2,    2,    2,    0,    0,    9,    1,    1,    0,
    1,    0,    6,    0,    6,    2,    1,    0,    8,    0,
    9,    0,    0,   10,    0,    0,    3,    0,    1,    1,
    2,    2,    0,    5,    0,    2,    2,    2,    1,    1,
    1,    0,    5,    0,    5,    1,    1,    2,    0,    0,
    0,   12,    0,    2,    2,    0,    1,    2,    1,    3,
    2,    0,    5,    3,    1,    0,    0,    0,   13,    0,
    1,    1,    3,    1,    4,    2,    0,    3,    2,    1,
    3,    0,    3,    1,    1,    3,    1,    2,    3,    4,
    4,    0,    3,    1,    3,    3,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    2,    2,    2,
    2,    2,    2,    1,    3,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    2,    2,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    3,    3,    4,    4,    4,    3,
    3,    4,    3,    4,    4,    4,    0,    1,    3,    4,
    0,    1,    1,    3,    2,    3,    1,    2,    3,    2,
    1,    1,    0,    1,    1,    3,    3,    3,    2,    1,
    1,    1,    1,    2,    2,    4,    3,    1,    4,    4,
    3,    1,    3,    2,    1,    3,    1,    1,    1,    4,
    3,    2,    2,    6,    3,    7,    4,    3,    7,    3,
    0,    2,    4,    1,    2,    0,    1,    1,    3,    3,
    1,    1,    1,    0,    1,    1,    2,    2,    3,    1,
    2,    0,    1,    2,    4,    1,    3,    0,    5,    1,
    1,    1,    2,    3,    3,    4,    4,    1,    2,    4,
    4,    4,    4,    0,    4,    0,    5,    0,    1,    0,
    4,    4,    1,    2,    2,    4,    2,    1,    2,    2,
    2,    2,    2,    2,    1,    3,    3,    3,    1,    3,
    3,    3,    3,    1,    3,    3,    1,    3,    3,    3,
    3,    1,    3,    3,    1,    3,    1,    3,    1,    3,
    1,    3,    1,    3,    1,    3,    1,    5,    4,    3,
    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
    1,    3,    3,    2,    1,    0,    1,    1,    1,    0,
    2,    1,    1,    0,    4,    0,    5,    0,    0,    7,
    0,    0,    8,    1,    1,    1,    1,    1,    1,    6,
    4,    4,    1,    1,    0,    0,    0,    0,   15,    0,
    1,    0,    1,    1,    2,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    0,    2,    3,    0,    1,    1,    2,    4,    3,    1,
    3,    1,    3,    1,    1,    0,    1,    1,    1,    0,
    4,    1,    1,    0,    4,    1,    0,    1,    1,    2,
    1,    1,    1,    2,    1,    1,    2,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    0,    4,    1,    2,    2,    2,    2,    2,    2,
    1,    1,    2,    1,    1,    1,    0,    6,    0,    7,
    1,    1,    0,    2,    2,    1,    0,    1,    0,    1,
    1,    2,    2,    4,    0,    2,    0,    1,    1,    2,
    4,    1,    5,    2,    2,    2,    2,    2,    2,    1,
    1,    1,    1,    1,    5,    7,    4,    0,    8,    4,
    0,    1,    1,    2,    1,    0,    3,    1,    2,    3,
    3,    1,    1,    1,    1,    1,    5,    4,    7,    3,
    6,    0,    4,    0,    4,    2,    0,    4,    2,    3,
    1,    0,    1,    0,    5,    1,    0,    1,    0,    1,
    1,    1,    3,    4,    5,    0,    9,    5,    4,    1,
    1,    1,    1,    1,    1,    2,    2,    2,    3,    4,
    3,    3,    3,    2,    3,    2,    4,    4,    3,    0,
    1,    3,    4,    5,    3,    1,    2,    0,    1,    2,
    0,    7,    3,    2,    2,    0,    3,    5,    4,    0,
    0,   10,    0,    0,    9,    5,    4,    2,    1,    0,
    2,    2,    2,    2,    2,    4,    5,    4,    5,    0,
    5,    0,    6,    3,    2,    2,    2,    1,    0,    3,
    0,    0,    6,    1,    2,    1,    1,    1,    1,    1,
    0,    5,    0,    3,    0,    0,    0,   12,    0,    0,
    0,   13,    0,    2,    0,    3,    1,    0,    4,    1,
    0,    4,    1,    2,    2,    1,    2,    2,    0,    0,
    4,    2,    3,    0,    4,    2,    2,    3,    0,    1,
    1,    1,    2,    2,    2,    4,    3,    0,    7,    4,
    4,    3,    1,    3,    0,    0,    4,    0,    1,    1,
    3,    2,
  };
   static readonly short [] yyDefRed = {            0,
    8,    0,    0,    0,    0,    0,    0,    0,    2,    4,
    0,    0,   11,   14,    0,  952,    0,    0,  956,    0,
    0,   15,   17,  379,  385,  392,  380,  382,    0,  381,
    0,  388,  390,  377,    0,  384,  386,  378,  389,  391,
  387,  342,  973,    0,  383,  963,    0,   10,    1,    0,
    0,    0,   12,    0,  782,    0,    0,    0,    0,    0,
    0,    0,    0,  420,    0,    0,    0,    0,    0,    0,
    0,  418,    0,    0,    0,  479,    0,  419,    0,  518,
    0,  876,    0,    0,    0,  629,    0,    0,    0,    0,
    0,    0,    0,  680,    0,  731,    0,    0,    0,    0,
    0,    0,    0,    0,  417,    0,  618,    0,  781,    0,
  714,    0,    0,    0,    0,  394,  395,  396,  397,  398,
  399,  400,  401,  402,  403,  404,  405,  406,  407,  408,
  409,  410,  411,  412,  415,  416,  625,  548,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  626,  624,  627,  628,  698,  700,    0,  696,  699,  715,
  717,  718,  719,  720,  721,  722,  723,  724,  725,  726,
  716,    0,    0,    0,  783,  784,  803,  804,  805,  806,
  840,  841,  842,  843,  844,  845,    0,    0,    0,   20,
    0,    0,  332,    0,  334,  960,   16,  953,    0,    0,
  241,  240,  237,  242,  243,  236,  255,  254,  247,  248,
  244,  246,  245,  249,  238,  239,  250,  251,  257,  256,
  252,  253,    0,    0,  976,    0,  965,    0,  964,    3,
   51,    0,    0,    0,   40,   37,   39,   42,   43,   44,
   45,   46,   49,   13,    0,    0,    0,  846,  421,  422,
  874,    0,    0,    0,    0,    0,    0,    0,  848,  847,
    0,  540,  534,  539,  730,  780,  701,  728,  727,  729,
  702,  703,  704,  705,  706,  707,  708,  709,  710,  711,
  712,  713,    0,    0,    0,  812,    0,    0,    0,  746,
  745,    0,    0,    0,    0,    0,    0,    0,    0,  854,
    0,    0,    0,    0,  393,    0,    0,    0,  856,  861,
    0,    0,    0,  875,    0,    0,    0,  744,  740,    0,
    0,    0,    0,    0,    0,    0,  361,    0,    0,    0,
    0,    0,    0,    0,    0,  621,    0,  547,    0,    0,
  545,  549,  550,  544,  554,  553,  551,  552,  614,  529,
    0,  414,  413,    0,    0,    0,    0,    0,  732,    0,
  331,    0,  738,  739,    0,  482,  483,    0,    0,    0,
  736,  737,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  955,  697,  747,  735,    0,
  778,  779,  908,  923,    0,    0,  909,  911,    0,  935,
  894,  892,  916,    0,    0,  914,  917,  918,  919,  920,
  895,  893,    0,    0,    0,  336,    0,   18,    0,    0,
    0,  972,    0,  343,    0,    0,    0,  974,    0,    0,
   38,  651,  657,  649,    0,  646,  656,  650,  648,  647,
  654,  652,  653,  659,  655,  658,  660,    0,    0,  644,
   41,   50,  481,    0,  477,  478,    0,    0,  475,    0,
  749,    0,    0,    0,  810,    0,  777,  775,  776,    0,
    0,    0,  633,    0,  851,  849,  634,    0,    0,  503,
    0,    0,    0,  494,    0,  498,  508,  510,    0,  490,
    0,    0,    0,    0,    0,  485,    0,  488,    0,  492,
  363,  853,  852,    0,    0,  855,  865,    0,    0,    0,
  866,    0,    0,  877,    0,    0,  743,    0,  373,  369,
  370,    0,    0,  368,  371,  372,    0,    0,    0,  555,
    0,    0,  536,    0,  616,  695,    0,    0,    0,  689,
  691,  692,  693,  425,  426,    0,  339,  340,    0,  179,
  178,  180,    0,    0,    0,    0,  365,    0,  601,    0,
    0,  859,    0,    0,    0,  430,    0,  433,    0,  431,
    0,  471,    0,    0,    0,    0,    0,  460,  463,    0,
    0,  455,  462,  461,  590,  591,  592,  593,  594,  595,
  596,  597,  598,  600,  599,  556,  558,  557,  562,  563,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  586,    0,    0,  507,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  907,  906,
    0,  915,    0,  905,    0,    0,  333,  970,  971,  357,
    0,    0,    0,  354,    0,    0,  176,    0,    0,  980,
  966,  968,   59,   57,   58,    0,    0,   52,    0,    0,
   60,   62,   26,   24,    0,    0,    0,  641,    0,  645,
  429,    0,  480,    0,  531,    0,  542,  165,  187,    0,
    0,    0,  155,    0,    0,    0,  166,  535,    0,  880,
    0,  832,  813,    0,  823,    0,  834,    0,  850,  787,
    0,  879,    0,    0,  493,    0,  509,  511,    0,    0,
  447,    0,    0,  443,    0,    0,  472,    0,  513,  487,
    0,    0,  140,  514,  138,  139,  516,    0,  530,  790,
    0,  870,    0,  863,    0,  867,  522,    0,    0,    0,
  358,    0,  520,    0,    0,  532,  887,    0,  883,  808,
    0,  898,    0,  896,    0,    0,  631,  632,    0,    0,
    0,  694,  682,  683,  681,  690,  609,  615,  608,    0,
    0,  338,  604,    0,    0,    0,  546,  858,  857,  733,
  434,  428,  432,  427,  533,  470,  469,  468,  465,  464,
    0,  459,  423,  424,  435,  436,    0,  589,    0,  756,
    0,    0,  613,  612,  924,  900,    0,  925,    0,  910,
  912,  921,    0,  936,    0,  904,  950,   19,  335,  679,
  678,    0,  677,    0,  353,  982,  177,  977,    0,    0,
   53,    0,    0,    0,    0,    0,    0,  360,    0,  635,
    0,    0,   79,   78,    0,  476,    0,    0,    0,    0,
    0,  170,  541,    0,    0,    0,    0,    0,  824,  816,
  814,    0,  835,    0,    0,  878,  500,  499,  450,    0,
    0,  961,  962,  439,  445,    0,  448,    0,  474,    0,
    0,    0,    0,    0,  788,  873,    0,  864,    0,  528,
  523,    0,    0,  519,    0,  886,    0,  807,  899,  897,
    0,  537,    0,  617,  611,  341,  603,  602,  619,  467,
    0,  458,  457,  456,  588,  140,    0,  772,  754,    0,
    0,    0,  761,    0,  902,    0,  929,    0,    0,  944,
  945,  938,    0,  356,  355,  981,    0,    0,   61,   55,
    0,   63,   25,   22,    0,    0,  309,    0,  213,    0,
  102,    0,   76,  766,  113,  114,    0,    0,    0,  769,
  185,  186,    0,    0,    0,    0,  158,  167,  159,  161,
  811,    0,    0,    0,    0,    0,  833,    0,    0,  449,
  451,  452,  446,  440,  444,    0,  505,    0,  473,  484,
  438,  517,  515,    0,  869,    0,    0,    0,  524,    0,
  889,    0,    0,  630,  622,    0,  466,    0,    0,  752,
  751,  748,  762,  901,    0,    0,    0,    0,  922,    0,
  951,  969,    0,    0,    0,   68,   69,   72,   73,    0,
  326,  315,  314,    0,  636,  209,   97,    0,  750,  770,
  171,    0,  183,    0,    0,    0,  809,  891,    0,    0,
    0,    0,  815,    0,  836,  786,  489,  486,  795,    0,
  802,    0,    0,  793,    0,  798,  871,  527,  526,  888,
  884,    0,  620,    0,    0,  903,  926,    0,  913,    0,
    0,  940,    0,   74,   66,    0,    0,    0,  310,    0,
    0,    0,    0,    0,  172,    0,  162,  160,  881,  825,
  819,  817,    0,    0,  789,  794,    0,  799,    0,    0,
  623,    0,  764,    0,  930,  947,  948,  941,   54,    0,
   70,   71,    0,    0,    0,    0,    0,    0,    0,  771,
  169,    0,  182,    0,    0,  837,  801,  800,    0,  684,
  686,  872,  885,  773,    0,    0,    0,   75,    0,    0,
  327,    0,    0,  325,  311,    0,  319,  376,    0,  374,
    0,  637,    0,  666,  210,   98,  173,  882,  821,  818,
    0,    0,  830,    0,  927,    0,  942,    0,    0,    0,
  308,    0,    0,  663,    0,    0,    0,  667,    0,    0,
    0,    0,    0,  931,   28,   23,  328,  324,    0,    0,
  320,  375,  669,    0,    0,    0,   99,  820,  685,    0,
    0,    0,    0,  312,  674,    0,  675,  672,    0,  670,
   95,    0,   93,    0,    0,   82,   84,   85,   86,   87,
   88,   89,   90,   91,   92,   94,  141,    0,    0,  226,
  218,  219,  220,  221,  222,  223,  224,  225,    0,    0,
  216,    0,    0,  928,    0,  329,  323,    0,    0,    0,
  638,   83,    0,  269,  264,  268,    0,  211,  217,    0,
  934,  932,  673,  671,    0,    0,    0,    0,    0,    0,
    0,  278,    0,    0,  227,    0,    0,  235,    0,  153,
  142,  152,    0,  100,    0,    0,  263,    0,    0,  262,
    0,  146,    0,    0,  347,    0,  345,    0,    0,  188,
    0,    0,    0,    0,    0,  639,  212,    0,  103,    0,
  344,    0,    0,    0,    0,  117,    0,    0,    0,    0,
    0,    0,  151,  143,    0,    0,  192,    0,  348,    0,
  230,  229,  228,    0,  101,    0,  282,    0,  260,  119,
    0,  258,    0,    0,    0,  121,    0,  349,    0,    0,
  189,    0,    0,    0,  346,  233,  112,  110,    0,    0,
  286,    0,    0,    0,    0,    0,  147,    0,  266,    0,
    0,    0,    0,  125,    0,    0,    0,    0,  350,  351,
    0,    0,    0,    0,    0,  107,  301,    0,  283,    0,
    0,  295,    0,    0,    0,  290,    0,  137,    0,    0,
    0,    0,  132,    0,    0,  279,    0,  122,    0,  116,
  126,  144,  150,  200,    0,  190,    0,    0,    0,    0,
  111,    0,  104,  108,    0,    0,    0,  297,    0,  298,
  287,    0,    0,  281,  291,  261,    0,    0,  118,  133,
  259,    0,  277,    0,  267,  271,  128,    0,    0,    0,
  197,  199,  193,  234,  109,  302,  304,  284,    0,    0,
  296,  293,  136,  134,  148,  276,    0,    0,    0,  145,
  201,  203,  191,    0,    0,    0,  295,    0,  272,  274,
  129,    0,    0,  194,  306,  307,  303,  305,  294,  149,
    0,    0,  207,  206,  205,  202,  204,    0,    0,    0,
  195,  273,  275,
  };
  protected static readonly short [] yyDgoto  = {             7,
    8,   49,    9,   50,   10,   11,   51,  232,  700,  662,
   12,   13,   52,   22,   23,  324,  235,  685,  856, 1050,
 1170, 1515,  853,  236,  237,  238,  239,  240,  241,  242,
  243,  678,  449,  679,  680,  958,  681,  682,  962,  854,
 1045, 1046, 1047,  266,  599, 1140,  110,  865, 1244, 1245,
 1246, 1247, 1248, 1249, 1250, 1251, 1252, 1253, 1254, 1255,
 1256,  468,  689, 1327,  972, 1147, 1112, 1182, 1210, 1272,
 1338, 1178, 1389, 1366, 1414, 1415, 1416,  974, 1412,  975,
  746, 1304, 1377, 1351, 1402,  520, 1395, 1371, 1431,  938,
 1400, 1403, 1404, 1499, 1432, 1433, 1429, 1257, 1311, 1283,
 1328,  702, 1379, 1478, 1348, 1435, 1508,  469,  267,  703,
  704,  705,  706,  707,  665,  575, 1152,  666,  667,  871,
 1330, 1356, 1446, 1407, 1480, 1331, 1382, 1504, 1528, 1447,
 1448, 1526, 1512, 1513,  970, 1111, 1209, 1269, 1313, 1270,
 1271, 1305, 1363, 1334, 1306,  327,  223, 1411, 1308, 1396,
 1393, 1258, 1285, 1324, 1475, 1437, 1162, 1476,  600, 1521,
 1522, 1323, 1392, 1368, 1424, 1419, 1390, 1456, 1461, 1422,
 1425, 1426, 1507, 1462, 1420, 1421, 1517, 1505, 1506,  967,
 1054, 1175, 1145, 1202, 1176, 1177, 1219, 1108, 1199, 1232,
  540,  193,  112,  353,  195,  569,  444,  224, 1343,  663,
  664,  842,  858,  328,  409,  539,  304, 1179, 1180,   45,
  114,  305,  116,  117,  118,  119,  120,  121,  122,  123,
  124,  125,  126,  127,  128,  129,  130,  131,  132,  133,
  134,  135,  136,  252,  815,  742, 1010,  516,  732,  894,
  733,  734, 1003,  137,  198,  738,  602,  603,  604,  809,
  478,  479,  297, 1008,  740,  410,  299,  503,  504,  505,
  506,  509,  748,  313,  764,  765,  911,  263,  484,  779,
  264,  483,  138,  139,  140,  141,  142,  143,  144,  145,
  146,  147,  148,  149,  150,  151,  825,  152,  578,  579,
  580,  788,  789,  790,  153,  566,  781,  354, 1026,  554,
 1092,  154,  498,  968, 1110, 1207, 1309,  470, 1183, 1184,
 1239, 1240,  843,  558,  339,  785, 1194,  559,  560,  268,
  269,  270,  157,  158,  159,  271,  272,  273,  274,  275,
  276,  277,  278,  279,  280,  281,  282,  171,  283,  585,
  172,  173,  320,  822,  638,  941, 1032,  868,  696,  978,
  939,  942, 1070,  943,  979,  980,  284,  174,  175,  176,
 1082, 1014, 1083, 1084, 1085, 1127, 1086,  177,  178,  179,
  180,  713,  491,  714, 1073,  996, 1074, 1190, 1155, 1191,
  715,  995,  716, 1193, 1123,  181,  182,  183,  184,  185,
  186,  306,  530,  531, 1016, 1129,  316,  994,  878, 1154,
 1023,  917, 1130,  187,  422,  188,  423,  944, 1035,  424,
  425,  654,  645,  646,  948,  426,  427,  428,  429,  430,
  949,  640,  946, 1134, 1213, 1274, 1037, 1166, 1231,  834,
  648,  835, 1101, 1040, 1102, 1167,  953,   17,   19,   46,
   47,  227,  668,  850,  445,  669,  670,
  };
  protected static readonly short [] yySindex = {         -167,
    0, -194,   51,   72,  108,12563,    0,  231,    0,    0,
  108,   72,    0,    0,  -63,    0, 6715,  108,    0, -179,
 -254,    0,    0,    0,    0,    0,    0,    0,  244,    0,
  327,    0,    0,    0, 3845,    0,    0,    0,    0,    0,
    0,    0,    0,  439,    0,    0,  575,    0,    0,  231,
  215,  108,    0,  319,    0,  264,  358,  279,12045, -163,
    9,  399, 6872,    0,    9,    9,    9, -137,    9,    9,
  706,    0, 8561,    9,    9,    0, 8718,    0,  482,    0,
  279,    0,    9,  419,    9,    0, 1465, 1465,  501,    9,
    9, -216,11828,    0,11148,    0,11828,11828,11828,11828,
11828,11828,11828,11828,    0,  133,    0, 7831,    0,  131,
    0,  437,  505,  318,  429,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1044,  775,
   84,  280,  559,  260,  523,  568,  580,  593, -288,  609,
    0,    0,    0,    0,    0,    0, 3546,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  168,  614,  250,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  317,  332,  215,    0,
  451,  191,    0,  587,    0,    0,    0,    0, 7831, 7831,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  665,  599,    0,  629,    0,   69,    0,    0,
    0,  215,13031,  713,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  794,  641,11284,    0,    0,    0,
    0,11148,    9,    9,  785,  331,  318,  168,    0,    0,
 7831,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, -176, -267,12045,    0, 7831,11148,  716,    0,
    0,  734,11148,11148, 9503, -251, -118,  772, 8126,    0,
11828,  133,  889,  800,    0,  818, 7831,11148,    0,    0,
  830,  591,    9,    0,11148,  482,10604,    0,    0,  419,
11148,  419, -279,  539,  854,  168,    0,  614,  429,  919,
  168,11148,11148,11148,  399,    0,  840,    0, 7029,   82,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 4270,    0,    0,12518, -279,  843,  857,11148,    0,  809,
    0, -294,    0,    0,  356,    0,    0,  810, 8875,10468,
    0,    0,11148,11148,11148,11148,11148,11148,11148,11148,
11148,11148,11148,11828,11828,11828, 7831, 7831,11828,11828,
11828,11828,11828,11828,11828,11828,11828,11828,11828,11828,
11828,11828,11828,11828,11148,    0,    0,    0,    0,  614,
    0,    0,    0,    0, 1465, 1465,    0,    0,  168,    0,
    0,    0,    0,  374,  875,    0,    0,    0,    0,    0,
    0,    0,  215,  713,  821,    0,  841,    0,  809,  665,
  665,    0,  -86,    0,  551,  665,  873,    0, -184,13031,
    0,    0,    0,    0, -174,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  198,13061,    0,
    0,    0,    0,  809,    0,    0,  872,  534,    0,  888,
    0,  890,  144,  482,    0,    9,    0,    0,    0,  168,
10604, -156,    0,  885,    0,    0,    0,  -40,   53,    0,
  438,    0,  897,    0,  892,    0,    0,    0,  596,    0,
 8245,  615,11148,  772,10468,    0, 7500,    0,  419,    0,
    0,    0,    0,  896,   92,    0,    0,  279,  482, -159,
    0, 4111,  900,    0,  135,  168,    0,  136,    0,    0,
    0,11148,  975,    0,    0,    0,11148,  979,  901,    0,
  904,  906,    0,12518,    0,    0, -186,   44, 7029,    0,
    0,    0,    0,    0,    0,  482,    0,    0, -268,    0,
    0,    0,  419, -279,  168, 8421,    0,  907,    0,  908,
11828,    0, 1029,  920, 7029,    0, -300,    0,  240,    0,
  809,    0,   81,11148,11148,  924, 1041,    0,    0,  123,
  -80,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  775,  775,   84,   84,  280,  280,  280,  280,  559,  559,
  260,  523,  568,  580,  593,    0, -161, -149,    0, 9032,
 1005,  168, 1006,  168, 9032, 9032,  921,11148,    0,    0,
  875,    0,  168,    0,  422,  809,    0,    0,    0,    0,
  481,  215,   31,    0, 8421,  551,    0,  931,  930,    0,
    0,    0,    0,    0,    0, -279,  933,    0,  934,  936,
    0,    0,    0,    0,  938, 8578,  894,    0,  267,    0,
    0,  321,    0,11284,    0,  932,    0,    0,    0,  454,
  -47,  942,    0,  941,  943,  944,    0,    0,11148,    0,
  168,    0,    0,  704,    0,  945,    0,  427,    0,    0,
 6872,    0, 6872, 8404,    0, 9503,    0,    0,10740,  151,
    0,  114,  -34,    0,  887,  899,    0,   91,    0,    0,
  948,  949,    0,    0,    0,    0,    0,  950,    0,    0,
  958,    0, 4429,    0,  482,    0,    0,  419,  617,  905,
    0,  175,    0,  955,  956,    0,    0, 6872,    0,    0,
 6872,    0,11148,    0,11148, 7831,    0,    0,  482,  959,
  482,    0,    0,    0,    0,    0,    0,    0,    0, 9032,
 7831,    0,    0,  168,12518,  987,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
10332,    0,    0,    0,    0,    0, 7657,    0, 9032,    0,
 7814,  964,    0,    0,    0,    0, 1038,    0, 1039,    0,
    0,    0,  566,    0,  966,    0,    0,    0,    0,    0,
    0,  926,    0,  -86,    0,    0,    0,    0,  551,  551,
    0,  821,  976,  974,  937,  981,  894,    0,  977,    0,
 1093, 1095,    0,    0,11148,    0,10876,  980,  454, 8421,
 7831,    0,    0, -233, 1100, 1102,  137,  984,    0,    0,
    0,11148,    0,11148, 1080,    0,    0,    0,    0,   41,
11012,    0,    0,    0,    0, 7950,    0, 1105,    0,  614,
11148,  999, 8404, 1001,    0,    0,  168,    0,  196,    0,
    0,  809,  905,    0,  168,    0,  -62,    0,    0,    0,
  995,    0, 1027,    0,    0,    0,    0,    0,    0,    0,
  729,    0,    0,    0,    0,    0, 8126,    0,    0,  168,
   13,  964,    0, 9032,    0, 9032,    0, 1020, 9032,    0,
    0,    0,  584,    0,    0,    0, 1004,  821,    0,    0,
11420,    0,    0,    0, 1007, 4594,    0,  894,    0,  894,
    0,  894,    0,    0,    0,    0,  168, 1000,  980,    0,
    0,    0, -166, -164, 1003, 1008,    0,    0,    0,    0,
    0, 1010, 8404,  964, -149,11148,    0, 1009, 6872,    0,
    0,    0,    0,    0,    0, 1014,    0,  772,    0,    0,
    0,    0,    0, -172,    0, 1015,  809,  905,    0,  905,
    0,  964, 1016,    0,    0,  482,    0,  952,  998,    0,
    0,    0,    0,    0, 9032, 1042, 9032, 9032,    0,11148,
    0,    0,  936,  208,  746,    0,    0,    0,    0,   72,
    0,    0,    0, 1023,    0,    0,    0, 1013,    0,    0,
    0,  428,    0, 1021, 1135, 1140,    0,    0,  964, 1025,
  964, 1037,    0, 1035,    0,    0,    0,    0,    0,11148,
    0, 1046, -153,    0, -153,    0,    0,    0,    0,    0,
    0,  482,    0,11148, 8109,    0,    0, 1068,    0,  760,
 1045,    0, 1048,    0,    0,11420,  108,  144,    0, 1049,
 1049, 1049,10876, 1050,    0,11148,    0,    0,    0,    0,
    0,    0, 6872, -139,    0,    0, 7029,    0,  784, 6872,
    0, 1056,    0, 9032,    0,    0,    0,    0,    0,11148,
    0,    0,  215, 1055,  215, 7831, 1077, 1077, 1077,    0,
    0,11148,    0, 6872, 9189,    0,    0,    0, 7029,    0,
    0,    0,    0,    0, 1082, 9032,11148,    0,  215, 1060,
    0, 1017,  789,    0,    0, 1057,    0,    0,   36,    0,
 1018,    0, 1077,    0,    0,    0,    0,    0,    0,    0,
 1061,  945,    0, 7029,    0, 1089,    0, 1063, 1077, 1184,
    0, 1073,  215,    0, 7831, -105, 1075,    0, 1090, 1092,
 6872, 1076, 9032,    0,    0,    0,    0,    0, 1079, 1063,
    0,    0,    0,12124,  120,  215,    0,    0,    0, 1106,
 9032, 1085,11148,    0,    0, 1094,    0,    0, 1097,    0,
    0,13061,    0, 1098,  120,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  583,13061,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1099,  215,
    0,  120,  168,    0, 1106,    0,    0, 1091,12124,12290,
    0,    0,   20,    0,    0,    0,12322,    0,    0, 1101,
    0,    0,    0,    0, 7831, 7831,  265, 8126,  278,  419,
 1127,    0, -279,  946,    0, 1163,    0,    0, 1063,    0,
    0,    0, 1063,    0, 1052, 1054,    0, 7831, -151,    0,
 7831,    0, 1059, 1103,    0, -279,    0,  -45,10251,    0,
 1104, 1062,   73,  506, 3845,    0,    0, 1063,    0, -279,
    0, 1111, 1065, 1110, 1108,    0, 1114, 1054, 1115,  144,
 1107, 1117,    0,    0, 1116, 1128,    0,  809,    0,  795,
    0,    0,    0, 1123,    0,  -52,    0, 1121,    0,    0,
 1129,    0, 1125, 1131, 1136,    0, 1133,    0,  144,  144,
    0,  144, 1124, 1138,    0,    0,    0,    0, 1141,  128,
    0, 1142,  144, 1253, 1143,  144,    0,   20,    0, 8404,
 1109, 1144, 1133,    0, 1147, 1149,  130, 1154,    0,    0,
  144,10876, 1112, 1152, 1141,    0,    0,13061,    0,  215,
  215,    0, 1126, 1153, 1142,    0, 1173,    0,11148, 1130,
 1170, 1143,    0, 1175,  144,    0,  -96,    0, 1168,    0,
    0,    0,    0,    0,13061,    0,  130,  130, 1145, 1178,
    0,  -52,    0,    0,  256, 1157,13061,    0,13061,    0,
    0, 8404, 1171,    0,    0,    0, 1181, 1129,    0,    0,
    0, 1182,    0,  294,    0,    0,    0, 1077,  847, 1185,
    0,    0,    0,    0,    0,    0,    0,    0, 1241, 1295,
    0,    0,    0,    0,    0,    0, 1189, 1193, 8404,    0,
    0,    0,    0,  130,  526,  526,    0, 1077,    0,    0,
    0,   55,   55,    0,    0,    0,    0,    0,    0,    0,
10468,10468,    0,    0,    0,    0,    0, 1197, 1194, 1195,
    0,    0,    0,
  };
  protected static readonly short [] yyRindex = {         1410,
    0,    0, 7186, 1410,    0,    0,    0, 1568,    0,    0,
 1513, 1341,    0,    0,    0,    0,    0, 1513,    0,    0,
   58,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1569,    0,    0, 1569,    0,    0, 1568,
 3215, 1788,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1203,    0,    0,    0,    0,    0,    0,    0,    0,
 8735,    0, 1196,    0,    0,    0, 1196,    0,    0,    0,
    0,    0,    0,  197,    0,    0,    0,    0,    0,    0,
    0,    0,  153,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 4587,    0,    0,    0,    0,
    0,    0,  286, 4680, 1796,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 4836, 4904,
 5144, 5348, 5688, 5892, 6028, 6164, 6300, 6436, 1187, 2889,
    0,    0,    0,    0,    0,    0,   58,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  199,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 3258,    0,
  512,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1569,  237,    0,    0,    0,    0,    0,    0,
    0, 3338,  320, 3381,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 3633,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1205,    0,    0,    0,    0,    0,
    0, 3633, 1202,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 2421,
    0, 2931,  420, 2551,    0,    0,    0, 2681, 2551,    0,
    0,    0,    0,    0, 1203,    0,    0,    0,  152,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1199, 2785,    0,    0, 1196,    0, 3633,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  146,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1605,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 3913,    0,    0,    0,    0,    0,
    0,    0, 3424, 3467,    0,    0,    0,    0, 2275, 1569,
 1569,    0,  -10,    0, 7517, 1569, 1595,    0,    0,  245,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  453,11977,    0,
    0,    0,    0, 3633,    0,    0,    0,    0,    0,    0,
    0,    0,12366,    0,    0,    0,    0,    0,    0,    0,
  711,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  604,  693,    0,    0, 1228,    0,    0,    0,    0,    0,
  165,    0,    0, 4110, 1225,    0,    0,    0,  670,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1982,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1199,    0,    0, 6555,    0,  176,    0,
    0,    0,    0,    0,    0, 9346,    0,    0,    0,    0,
    0,    0,    5,  802,    0,    0,    0, 1227,    0,    0,
    0,    0, 1202,    0,    0,    0, 3633,    0, 3633,    0,
 4269,    0,    0,    0,    0, -191,    0,    0,    0,    0,
  174,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 5008, 5076, 5212, 5280, 5416, 5484, 5552, 5620, 5756, 5824,
 5960, 6096, 6232, 6368, 6492,    0,    0,  675,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 3913,    0,    0,    0,    0, 2275,    0,    0,    0,    0,
 1183, 9694,    0,    0,    0, 8892,    0,    0,  755,    0,
    0,    0,    0,    0,    0,  683,  698,    0,    0, 1230,
    0,    0,    0,    0, 1236,    0,    0,    0,    0,    0,
    0,11556,    0,    0,    0,  758,    0,    0,    0, 9049,
12442,    0,    0,  759,  766,  796,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  722,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1238,    0,    0,    0, 3699,
    0,    0,  177,    0,   98, 3792,    0,    0,    0,    0,
    0, 1232,    0,    0,    0,    0,    0, 1239,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  -51,  676,    0,
    0,    0,    0,    0, 1237,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 9346,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  567,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, -181,    0,  472,    0,    0,    0,    0,    0,
    0,    0,    0,  -10,    0,    0,    0,    0, 9049, 7674,
    0, 1240,    0,  700,    0,    0,    0,    0, 1244,    0,
 1201, 1206,    0,    0,    0,    0,    0, 1245, 9206,    0,
    0,    0,    0,12474,    0,    0,    0,  798,    0,    0,
    0,    0,    0,    0, 2149,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 3951,
    0, 4428, 1246,    0,    0,    0, 1243,    0,    0,    0,
    0,  333,    0,    0,    0,    0,  798,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  657,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  807,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1247,    0,
    0,    0,    0,    0,  814,  820,    0,    0,    0,    0,
    0,    0,    0, 1248,  608, 1250,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 4110,    0,    0,
    0,    0,    0, 1249,    0,    0,  333,    0,    0,  846,
    0, 1248,    0,    0,    0, 9346,    0,  643,  654,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1230, 9540,    0,    0,    0,    0,    0,12605,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  630,    0,  737,    0,    0,    0,    0, 1255,    0,
  736, 1252,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1261,    0, 7343,    0,    0,    0,    0,    0,
    0, 9346,    0,    0,    0,    0,    0,    0,    0, -154,
  484,    0,    0,    0,    0,    0,12681,12366,    0,  218,
  218,  218,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,12724,    0, -285,    0, 1263, 1263, 1263,    0,
    0,    0,    0,    0, 1259,    0,    0,    0, -182,    0,
    0,    0,    0,    0,    0,    0,    0,    0,12767,    0,
    0,    0, 9997,    0,    0, 1264,    0,    0,  369,    0,
    0,    0,  533,    0,    0,    0,    0,    0,    0,    0,
    0, 1262,    0, 1267,    0,    0,    0, 3172, 1260,  537,
    0,    0, -269,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 3089,
    0,    0,    0,    0, 9799,10083,    0,    0,    0,  642,
    0,    0,    0,    0,    0,    0,    0,    0,  478,    0,
    0,12148,    0,    0, 9898,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,12216,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,10177,
    0, 9799,    0,    0,  642,    0,    0,    0,    0,  453,
    0,    0,    0,    0,    0,    0,  453,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1096,
  457,    0,10219,    0,    0,    0, 4810,    0, 3089,    0,
    0,    0, 3089,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  271,    0, 1272,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 3089,    0,  543,
    0,  494,    0,    0,    0,    0,    0,    0,    0,12366,
  819,    0,    0,    0,    0,    0,    0, 1235,    0,  516,
    0,    0,    0,    0,    0,    0,    0,  824,    0,    0,
    0,    0,    0,    0,    0,    0, 1265,    0,12366,12366,
    0,12398,    0,    0,    0,    0,    0,    0, 1268,12991,
    0, 1269,12366,11692, 1270,12366,    0,    0,    0,    0,
    0,    0, 1271,    0,    0,    0,12961,    0,    0,    0,
12366,    0,    0,    0, 1273,    0,    0,  378,    0,12885,
12923,    0,    0,    0, 1278,    0,    0,    0,    0,    0,
    0, 1279,    0,    0,12366,    0,  664,    0,  825,    0,
    0,    0,    0,    0,  861,    0,12809,12847,    0,    0,
    0,    0,    0,    0,    0,    0, 1325,    0, 1393,    0,
    0,    0,  829,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  571,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,12961, 9534,11864,    0,  571,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1225, 1225,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,
  };
  protected static readonly short [] yyGindex = {            0,
    0, 1607,    0,    0,    0,    2,  -16, -180,  -48,  -43,
    0, 1647, 1655,  101,    0,    4,    0,    0,    0,    0,
    0,-1020, -693, -215, -482,    0,    0,    0,    0,    0,
 -224,    0,    0,    0,  703,    0,  811,    0,    0,    0,
    0,  560,  563,  -17, -226,    0,  -46,    0,  393,    0,
  430, -573, -569, -553, -471, -469, -462, -444, -435,    0,
-1042,-1171,    0,    1,    0,  129,    0,-1095,    0,    0,
    0,  -44,  220,    0,    0,    0,  258,-1073,    0, -273,
 -293,  992,    0,    0,    0, -899,  212,    0,    0, -501,
    0,    0,  281,    0,    0,  249,    0,    0,  287,    0,
 -579, -976,    0,    0,    0,    0,    0,  382,  -13,    0,
    0,  815,  816,  822,  988, -528,    0,    0, -321,  823,
  377,    0,-1327,    0,    0,    0,    0,    0,    0,    0,
    0,  182,    0,    0,    0,    0,    0,    0,    0,    0,
  432,    0,    0,    0,    0, -335,  362,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  441,    0, -514,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  201,    0,
    0,  288,    0,    0,  283,  285,  210,    0,    0,    0,
    0,    0,    0,    0,    0,  511,    0,    0,    0,    0,
  -39,    0,  552, -173,    0,    0,  364,    0,  421,    0,
  882,    0, 1204, -286, -265,  -56,  947,    0,  524,    0,
  -30,   10,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, -256,    0,  367,    0, -333,    0, -773,    0,    0,
    0,  832,    0, -296, -126, 1012,    0,  917,    0, 1155,
 1368, 1053,    0,    0,  731, 1678,    0,    0,    0,    0,
 1028,    0,    0,    0,    0,    0, -506, 1416,    0,    0,
    0,    0,    0, 1190,  855,  845,  748,  852, 1356, 1358,
 1355, 1357, 1359,    0, 1360,    0, -611,    0,    0,  968,
 1207, -714,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, -298,    0,    0,    0,    0, -458,    0,  585,
    0,  487,    0,  573,    0,    0,    0,  646, -534,   -5,
 -313,   -3,    0, 1618,    0,   68,    0,   70,   74,   99,
  125,  142,  149,  156,  157,  163,  171,    0, -674,    0,
   -7,    0,    0,  782,    0,  707,    0,    0,    0,    0,
  685, -322,  762, -863,    0,  803, -461,    0,    0,    0,
    0,    0,    0,  708,    0,    0,  701,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  634,    0,    0,    0,    0,    0,    0,    0,
    0,  -27,    0, 1274,    0,    0,    0,  876,    0,    0,
    0,    0,    0,    0, -168,    0,    0,    0,    0,    0,
 1374, 1150,    0,    0,    0, 1376,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  517,    0,    0,    0,    0,
    0,    0,    0,    0,  636,    0,    0,    0,    0,    0,
    0,   64,  957,    0,    0,    0,  962,
  };
  protected static readonly short [] yyTable = {           109,
  741,  189,  233,  111,  518,   18,   43,  234,  433,  472,
  690,  155,  521,  156,  494,  747,  451,  436,  577,  432,
  476,  292,  538,  192,  786,  562,  115,  319,  257,  712,
  406,  514,  576,  830,  831,  549,  601, 1028,  502, 1150,
  325,  330,  326,  331,  251,  337,  885,  794,  886,  311,
  800,  258, 1185, 1186,  904,  303,  364,  959,  372,  310,
  335,   14,  544,  356,  629,  312,  924,  314,  115,  782,
 1280,  673,  115,  363,  943,  371,  190,  340, 1033,  485,
   20,  683,  316, 1079,  160,  797,  161, 1287,    1, 1061,
  162, 1063,  259,  916,  818, 1080,  918,  674,  318,  717,
  487,  946, 1174, 1217, 1345,  791,  820,  985,  488,  528,
  229,  350,  403,  351, 1080,  163, 1157, 1002,  507, 1481,
 1482,  197,  508,  587,  404,  408,  755,  801, 1011,  675,
  288, 1144,   47,  588,  351,  231,  846,  510,  289,  109,
  233,  164,  476,  111,  639,  434,  290,  792,   47,  436,
 1223,  155,  197,  156,  440,  441,  349,  943,  165, 1473,
 1174,  489,  943,  486,  943,  166,  115,  943,  943,  660,
  943,  943,  167,  168,  196,  816, 1514, 1216,  925,  169,
  629,  436,  629,  450,  946,  797,  586,  170,  434,  946,
    2,  946,  943, 1021,  946,  946,  761,  946,  946, 1234,
  477,  291,  336, 1387,  350, 1033,  290,  935,  872,  472,
 1353,  481,  260,  819,  735,  720,  482,  451,  577,  946,
  739,  895,  887,   15,  160,  290,  161,  351,  448,  475,
  162,  821,  576,  676,  480, 1158,  352,  629,  191,  797,
  577,  352,  492,  684,    6,  562, 1455,  943,  511, 1081,
  512, 1062,  249, 1064,  257,  163,    3,    4,    5,    6,
  366,  291,  524,  537,  257,  657, 1346,  541, 1081, 1224,
  493,  562,  546, 1479,  946,  497,  499,  490, 1474,  543,
  291,  164,  231,   47,  548, 1489,  442, 1490, 1336,  545,
  525, 1204, 1337,  817,  115,   47,  899,  533,  165,  535,
  691,  250,  534,  497,  513,  166,  568,   16,  722,  536,
 1523, 1093,  167,  168,  959,  551,  552, 1365,  993,  169,
  359,  231,  477,  477, 1076, 1354,  115,  170, 1388,  577,
  584,  721, 1034,  561, 1036,  563,  806, 1039, 1451,  896,
  583,  983,  619,  620,  847,  387,  899,  750,  115, 1103,
  761,  475,  598,  959,   54,  605,  606,  607,  608,  609,
  610,  611,  612,  613,  614,  615,  359,  366,  641,  643,
  642,  644,  647, 1375,  366, 1241,  366, 1131,  366,  249,
 1030,  388, 1500, 1417,  233, 1444,   94,  637, 1031,  434,
  767,  770,  991,  447,  661, 1310,  357, 1359, 1319,  698,
  436, 1012, 1405, 1406,  844, 1408, 1019,   47, 1000, 1205,
  877,  783, 1520,  802,  901,  804, 1427,  805,  746, 1434,
  997,   94,  366, 1096,  723, 1098, 1099,  261,  250,    2,
 1524,  285,  286,  287, 1450,  293,  294,  472,  655,  701,
  307,  308,   20,  710,  358,  718,  845,  315, 1156,  317,
  807,  321,  677,  564,  694, 1163,  333,  334, 1472,  577,
  900,  389,  390,  751,  901,  959,  746,  476,  477,  502,
  708,  959,  784,  576,  686,  349,  472,  931,  687, 1188,
  370,  892,  839,  711,  699,  760,   42,   48,  231,  769,
 1360, 1068,  352,  349,  813,  737,  231,  598,  231,  745,
  115,    6,  436,  658,  659,  359,  768,  771,  992,  671,
  565, 1088,  231, 1089,  752,  754,  642,  453, 1486,  687,
 1317,  642, 1165,  350,  772,  642,  342,  746,  793,  774,
  290,  891,  441, 1320,  577,  759, 1228,  290,  860,  688,
  642,  350,  893,  688,  442,  454,  351,  981,  199, 1496,
  349,  814,  787,  561, 1196,  563,  661, 1497,  290,  741,
  352,  734,  861,  437,  351,  741,  438,  642,  115, 1318,
 1487,  194,  413,  976,  453,  352,  808,  808,  352,  561,
  687,  563, 1321,  231,  661,  291,  642,  413, 1104,  862,
  933,  642,  912,  441,  115,  827,  642,  829,  350,  735,
  642, 1230,  454,  352,  688,  442,  837,  352,  897,  352,
  352,  352,  352, 1017,  741,  642,  734,  352, 1498, 1275,
  315,  351,  824,  370,  786,  411,  863,  824,  824,  649,
  833,  200,  245,  864, 1007,  352,  246,  342,  194,  194,
  642,  342,  642,  337,  115,   94,  115,  477,  330,  249,
  521,  115, 1261,  351,  330,  414, 1262,  397,  398,  194,
  415,  642,  416,  515,  879,  417,  418,  803,  419,  420,
  414, 1069, 1263,  391,  392,  415,  475,  416,  412,  532,
  417,  418,  883,  419,  420,  342,  247,  859,  249,  337,
  365,  497,  642,  712,  244,  257, 1261, 1072,  250, 1069,
 1262,  337,  541,  330,  337,  337,  745,  662,  907,  366,
  367,  737,  414,  745,  739,  913, 1263,  415,  337,  416,
  884,  350,  417,  418,  640,  419,  420,  937,  641,  368,
  115,  921,  115,  248, 1049,  662, 1341,  250,  657,  939,
  369,  908, 1243, 1260,  351,  421,  926,  927,  640, 1355,
  194,  194,  641,  745, 1264,  919, 1265,  920,  352,  570,
  431,  869, 1243, 1266,  477,  922,  571,  787, 1373,  262,
  477,  352,  824,  589,  840,  640,  337,  115,  572,  641,
  115, 1267,  337,  590, 1041,  361,  841, 1260,  337, 1243,
 1268,  337,  337,  598,  437,  661, 1114,  838, 1264,  598,
 1265,  824,  650,  745,  318,  337, 1124, 1266, 1115,  225,
  937,  226,  194,  562,  318,  937,  668,  937,  724,  976,
  937,  937,  939,  937,  937, 1267,  984,  939,  350,  939,
  701,  435,  939,  939, 1268,  939,  939,  337,  194,  413,
  745,  350, 1153,  839,  668,  562,  527,  973,   94,  493,
  194,  351,  709,  668,  360,  677,  570,  965,  194,  528,
 1015,  361, 1018,  571,  351,  352,  998,  280, 1020,  280,
  690,  332,   94, 1001,  280,  572,  529,  362, 1187, 1049,
  562, 1361,  352, 1009,  337,  745,  352,  337,  337,  352,
  318,  352,   94, 1029,  753,  361,  352,  933, 1438,  665,
  937, 1215,  194,  693,  321,  194,  399,  694,  665,  342,
  321,  437,  939,  342,  477,  337,  342,  322,  342,  950,
  951, 1053,  414,  342,  318,  364,  824,  415,  824,  416,
 1058,  824,  417,  418,  757,  419,  420,  664,  194,  194,
  393,  394,  757, 1048, 1307,  225,  664,  228,  472, 1160,
 1161, 1307,   44,  451,  395,  396,  400,  342, 1284, 1277,
 1491,  677, 1169,  113,  401,  727,  194,  194, 1055,  728,
 1056,  501, 1057,  361,  337,  745,  337,  501,  497,  753,
  933,  753,  296,  753,  736,  933,  194,  933,  508,  909,
  933,  933,  402,  933,  933,  337,  337, 1511,  405,  168,
  194,  168,  318,  168,  439,  113, 1529, 1530,  115,  113,
  774,  521,  787,  443,  774,  337,  774,  824,  774,  824,
  824,  763, 1100,  337,  758,  763,  337,  763,  758,  763,
  270,  270,  758,  329,  329,  225,  364,  364,  364,  270,
  364,  364,  753,  364,  330,  364,  446,  330,  753,  473,
  753, 1107,  337,  337,  329,  337,  337,   56,  474,  477,
  502,  335,  493,  415,  701,  415,  502,   64,   64,   65,
  933,   64,  295,   65,  296,  880, 1132,  745,  787,  881,
  471,  231,  822,  762,  415,  415,  822,  364, 1048,  364,
 1143,  495,  364,  826,  233,  493, 1172,  826,  493,  434,
 1027, 1173,  817,  113,  415,  194,  181,  757,  181,  496,
  181,  757,  415, 1136, 1137,  415,  824, 1105,  976, 1106,
  233,  561, 1168,  563,  979,  434,  979,  194,  156,  436,
  156,  765,  115,  765,  493,  163,  115,  163,  517,  115,
  625,  626,  627,  628,  522,  329,  329,  542,  824, 1100,
 1160, 1161, 1352,  561, 1172,  563, 1201,  231,  337, 1173,
  384,  385,  386,  115,  337,  164, 1352,  164,  115,  890,
  337,  890,  362,  605,  337,  605, 1242, 1259,   67, 1238,
   67, 1173,  555,  187, 1383,  187, 1384,  337,  561,  157,
  563,  157,  120,  523,  120,  824, 1242,  285,  127,  285,
  127, 1173,  292,  115,  292,  526,  452,  329,  351,  443,
 1501, 1502,  547,  824,  581,  493,  194,  525,  525,  337,
  115, 1259,  351, 1242,  642,  642, 1291,  591, 1173,  453,
  653,  113,  582,  329, 1238,  623,  624,  194,  355, 1148,
 1149,  672,  454,  621,  622,  329,  692,  456,  629,  630,
 1315, 1316,  457,  329,  458,  459,  460,  461,  656,  695,
  719,  697,  462,  113,  725,  726,  463,  749,  773, 1312,
 1325,  766,  775, 1344,  776,  777, 1347,  778,  464,  796,
  795,  465,  338,  466,  798,  113,  341,  342,  343,  344,
  345,  346,  347,  348,  811,  799,  812,  329,  826,  828,
  329,  832,  848,  849,  194,  437,  701,  467,  851,  852,
  855,   42,  867,  873,  874,  196,  875,  876,  882,  902,
 1362,  898,  817,  903,  905,  910,  914,  194,  915,  929,
  923,  945,  947,  329,  329,  701,  701,  940,  701,  952,
   34, 1418,  194,  954,  961,  960,  194,  964,  969,  701,
  971,  966,  701,  977,  963,  989,  359,  990, 1445,  999,
 1006,  329,  329, 1326,  993,  511, 1024,  701, 1013, 1025,
 1038, 1457, 1459, 1042, 1094, 1059, 1065, 1051, 1095,  359,
 1075, 1066,  745, 1077, 1312, 1067, 1087, 1091, 1097, 1109,
 1117,  701,  359, 1113,  493, 1118, 1119,  359, 1445, 1445,
  232, 1116,  359,  194,  359,  359,  359,  359, 1121,   33,
 1122, 1467,  359, 1125, 1135, 1181,  359, 1139, 1138, 1151,
  359,  194,  194, 1146,  373, 1164, 1171, 1198,  359, 1195,
 1203,  359, 1211,  359, 1200, 1206, 1214,  113, 1215, 1218,
 1220, 1225,  585, 1229,  745,  374,  375,  376,  377,  378,
  379,  380,  381,  382,  383, 1445, 1226,  359, 1227, 1233,
 1276, 1273, 1293, 1322, 1278, 1281, 1288, 1335, 1314, 1339,
 1279, 1340, 1357, 1350,  477,  477, 1349, 1367,  329, 1358,
 1369,  745, 1360, 1370, 1372, 1374, 1380, 1376,  194, 1378,
  338, 1516, 1516, 1386, 1381, 1397, 1409, 1394, 1525, 1525,
  329, 1391, 1398,  598,  598,  113, 1401, 1399, 1428,  194,
 1410, 1483,   31,  359, 1413, 1423, 1430,  194, 1442, 1440,
 1443,  550,  329, 1449, 1488,  585, 1439, 1453, 1464, 1452,
  585,  113,  585,  585,  585,  585,  585,  585,  585,  585,
  585,  585,  585, 1463, 1466, 1469, 1471, 1468, 1477, 1484,
 1493, 1492, 1503, 1495,  585, 1487,  585, 1486,  585, 1509,
  585,  585,  585, 1510, 1531, 1532, 1533,    9,  975,  538,
  606,  860,  496,  616,  617,  618,  585,  861,  550,  550,
  550,  550,  550,  550,  550,  550,  550,  550,  550,  550,
  550,  550,  550,  550,  967,  497,  453,   34,  607,   29,
  676,   34,   21,  454,  506,  495,   29,  337,  521,   30,
  313,  329,   34,   30,  868,  585,  791,   34,  208,  759,
  767,   34,  768,   96,   34,  827,  760,  828,  792,  664,
  829,  317,  329,  831,  687,  664,   34,   34,  344,  642,
  123,   34,   34,  105,  288,  130,  124,   34,  106,   34,
   34,   34,   34,  289,  131,  642,  230,   34,   53,   21,
 1043,   34,  959,   34, 1290, 1141,   33,  113, 1142,  113,
   33, 1485, 1454,   34, 1282,   34,   34,  857,   34, 1494,
 1470,   33,   34, 1441, 1436, 1329,   33,  870,  986,  987,
   33,  982, 1342,   33, 1527,  988, 1364,  194, 1286,  329,
  550, 1289,   34, 1460, 1458,   33,   33, 1519,   34,   34,
   33,   33, 1465, 1221,  113, 1518,   33,  113,   33,   33,
   33,   33,  329, 1385, 1333,  955,   33, 1005, 1222,   24,
   33,   25,   33,  934,   26,  763,  593,  329, 1078,   27,
  890,  329,   33,   28,   33,   33,  866,   33,  298,  810,
  553,   33,   30,  888,  631,  633,  194,  632,  634,   32,
  780,  635,  928,  636,   33, 1294, 1212, 1208,   34,   31,
  797,   33, 1159,   31,  407,  194, 1071, 1120,   33, 1133,
   36, 1060,   37, 1090,   31, 1128,   38,   32, 1192,   31,
 1126, 1292, 1022,   31,   39,   40,   31,  651,   41,  652,
  836,  322, 1197,  756,    0,    0,  957,    0,   31,   31,
  956,    0,    0,   31,   31,    0,  329,  329,    0,   31,
    0,   31,   31,   31,   31,    0,    0,  290,    0,   31,
  194,  194,    0,   31,    0,   31,    0,    0,  194,    0,
    0,    0,    0,    0,    0,   31,  194,  194,   31,  194,
   31,    0,    0,    0,   31, 1332,    0,    0,    0,    0,
  506,    0,    0,    0,    0,  506,  506, 1332,    0,  194,
    0,    0,  194,    0,   31,    0,    0,    0,    0,    0,
 1332,   31,  323,  329,    0,    0,    0,    0,  506,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1332,
    0,  506,  506,    0,    0,    0,  506,    0,    0,  506,
    0,  506,  329,  506,  506,  506,  506,    0,    0,    0,
    0,  506,    0,    0,    0,  506,    0,    0,    0,  506,
    0,    0,    0,    0,    0,    0,    0,  506,    0,    0,
  506,    0,  506,  506,    0,  113,    0,    0,  506,    0,
  506,  506,  506,  506,  506,  506,  506,  506,  506,  506,
  506,    0,    0,    0,    0,    0,  506,  506,    0,    0,
    0,  506,  506,    0,  506,  506,  506,  506,  506,  506,
  506,  862,  506,  506,    0,  506,  506,  506,  506,  506,
  506,  506,  506,  506,  506,    0,  506,  506,  506,  506,
  506,  506,  506,  506,  506,  506,  506,  506,  506,  506,
  506,  506,  506,  506,  506,  506,  506,  506,    0,    0,
  506,    0,  506,    0,  506,    0,    0,  506,    0,    0,
    0,    0,    0,  506,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   32,    0,    0,    0,   32,    0,
    0,  393,    0,    0,    0,    0,    0,  393,    0,   32,
    0,    0,    0,    0,   32,    0,    0,    0,   32,  113,
    0,   32,    0,  113,    0,    0,  113,    0,    0,    0,
    0,    0,    0,   32,   32,  550,    0,    0,   32,   32,
    0,    0,  329,  393,   32,    0,   32,   32,   32,   32,
  113,    0,    0,    0,   32,  113,    0,    0,   32,    0,
   32,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   32,    0,    0,   32,    0,   32,    0,    0,    0,   32,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  113,    0,    0,    0,    0,    0,    0,    0,  785,   32,
    0,  329,    0,    0,    0,   32,   32,  113,  330,    0,
    0,    0,    0,  393,  330,    0,  393,  393,  393,  393,
  329,  393,    0,  393,  393,    0,  393,  393,  393,  393,
  393,    0,  393,  393,  393,  393,    0,  393,  393,  393,
  393,  393,  393,  393,  393,  393,  393,  393,  393,  393,
  393,  393,  393,  393,  393,  393,  393,  393,  393,    0,
    0,    0,    0,  330,    0,  393,    0,    0,  393,    0,
    0,    0,    0,    0,  393,  329,  329,    0,    0,    0,
    0,    0,    0,  329,    0,    0,    0,  862,  862,    0,
    0,  329,  329,    0,  329,  862,  862,  862,  862,  862,
    0,  862,  862,    0,  862,  862,  862,  862,  862,  862,
  862,  862,    0,    0,  329,    0,  862,  329,  862,  862,
  862,  862,  862,  862,  337,    0,  862,    0,    0,    0,
  862,  862,    0,  862,  862,  862,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  862,    0,  862,    0,  862,
  862,    0,    0,  862,    0,  862,  862,  862,  862,  862,
  862,  862,  862,  862,  862,  862,  862,    0,  862,    0,
    0,  862,  862,    0,    0,  862,  862,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  862,  862,  862,  862,  862,    0,    0,    0,  862,  862,
    0,    0,  862,    0,    0,    0,    0,  862,  862,  862,
  862,  862,    0,    0,    0,  862,    0,  862,    0,    0,
    0,    0,    0,  862,  862,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  862,  862,
  862,  862,    0,  862,  785,  785,    0,    0,    0,    0,
  862,    0,  785,  785,  785,  785,  785,    0,  785,  785,
  742,  785,  785,  785,  785,  785,  785,  785,    0,    0,
    0,    0,    0,  785,    0,  785,  785,  785,  785,  785,
  785,    0,    0,  785,    0,    0,    0,  785,  785,    0,
  785,  785,  785,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  785,    0,  785,    0,  785,  785,    0,    0,
  785,    0,  785,  785,  785,  785,  785,  785,  785,  785,
  785,  785,  785,  785,    0,  785,    0,    0,  785,  785,
    0,    0,  785,  785,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  785,  785,  785,
  785,  785,    0,    0,    0,  785,  785,    0,    0,  785,
    0,    0,    0,    0,  785,  785,  785,  785,  785,    0,
  337,    0,  785,    0,  785,  337,  337,    0,    0,    0,
  785,  785,    0,    0,    0,    0,    0,    0,    0,    0,
  330,    0,    0,    0,    0,    0,    0,    0,  337,    0,
    0,    0,    0,    0,    0,  785,  785,  785,  785,    0,
  785,  337,  337,    0,    0,    0,  337,  785,    0,  337,
    0,  337,    0,  337,  337,  337,  337,    0,    0,    0,
    0,  337,    0,    0,    0,  337,    0,    0,    0,  337,
    0,    0,    0,    0,    0,    0,    0,  337,    0,    0,
  337,    0,  337,  337,    0,    0,    0,    0,  337,    0,
  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
  337,  337,    0,    0,    0,    0,  337,  337,    0,    0,
    0,  337,  337,  337,  337,  337,  337,  337,  337,  337,
  337,    0,  337,  337,    0,    0,  337,  337,  337,  337,
  337,    0,    0,  337,  337,    0,    0,    0,  337,  337,
  337,  337,  337,  337,  337,  337,  742,    0,    0,    0,
  367,  742,  742,    0,    0,    0,    0,  337,    0,    0,
  337,    0,  337,    0,  337,    0,    0,  337,    0,    0,
    0,    0,    0,  337,  742,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  742,  742,    0,
    0,    0,  742,    0,    0,  742,    0,  742,    0,  742,
  742,  742,  742,    0,    0,    0,    0,  742,    0,    0,
    0,  742,    0,    0,    0,  742,    0,    0,    0,    0,
    0,    0,    0,  742,    0,    0,  742,    0,  742,  742,
    0,    0,    0,    0,  742,    0,  742,  742,  742,  742,
  742,  742,  742,  742,  742,  742,  742,    0,    0,    0,
    0,    0,  742,  742,  337,    0,    0,  742,  742,  742,
  742,  742,  742,    0,  742,  742,  742,    0,  742,  742,
    0,    0,  742,  742,  742,  742,  330,    0,    0,  742,
  742,  330,  330,    0,  742,  742,  742,  742,  742,  742,
  742,  742,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  742,  330,    0,  742,    0,  742,    0,
  742,    0,    0,  742,    0,    0,    0,  330,  330,  742,
    0,    0,  330,    0,    0,  330,    0,  330,    0,  330,
  330,  330,  330,    0,    0,    0,    0,  330,    0,    0,
    0,  330,    0,    0,    0,  330,    0,    0,    0,    0,
    0,    0,    0,  330,    0,    0,  330,    0,  330,  330,
    0,    0,    0,    0,  330,    0,  330,  330,  330,  330,
  330,  330,  330,  330,  330,  330,  330,    0,    0,    0,
    0,    0,  330,  330,    0,    0,    0,  330,  330,  330,
  330,  330,  330,    0,  330,  330,  330,    0,  330,  330,
  362,    0,  330,  330,  330,  330,  367,    0,    0,  330,
  330,  367,  367,    0,  330,  330,  330,  330,  330,  330,
  330,  330,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  330,  367,    0,  330,    0,  330,    0,
  330,    0,    0,  330,    0,    0,    0,  367,  367,  330,
    0,    0,  367,    0,    0,  367,    0,  367,    0,  367,
  367,  367,  367,    0,    0,    0,    0,  367,    0,    0,
    0,  367,    0,    0,    0,  367,    0,    0,    0,    0,
    0,    0,    0,  367,    0,    0,  367,    0,  367,  367,
    0,    0,    0,    0,  367,    0,  367,  367,  367,  367,
  367,  367,  367,  367,  367,  367,  367,    0,    0,    0,
  337,    0,  367,  367,    0,    0,  337,  367,  367,    0,
  367,  367,  367,    0,  367,  367,  367,    0,  367,  367,
    0,    0,  367,  367,  367,  367,    0,    0,    0,  367,
  367,    0,    0,    0,  367,  367,  367,  367,  367,  367,
  367,  367,  337,    0,    0,    0,    0,    0,   27,    0,
    0,    0,    0,  367,    0,    0,  367,    0,  367,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  367,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  337,    0,    0,    0,    0,  337,    0,
  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
  337,  337,    0,    0,  587,    0,    0,  337,    0,    0,
    0,  337,  337,  337,  337,  337,  337,  337,  337,  337,
  337,    0,  337,  337,    0,    0,  337,  337,  337,  337,
  337,   27,    0,  337,  337,    0,    0,    0,  337,  337,
  337,  337,  337,  337,  337,  337,  362,    0,    0,    0,
    0,    0,  362,    0,    0,    0,    0,  337,    0,    0,
  337,    0,  337,    0,  337,    0,    0,  337,    0,    0,
    0,    0,    0,  337,    5,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  587,  362,    0,
    0,    0,  587,    0,  587,  587,  587,  587,  587,  587,
  587,  587,  587,  587,  587,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  587,  957,  587,    0,
  587,    0,  587,  587,  587,    0,    0,    0,    0,  362,
    0,    0,    0,    0,  362,    0,  362,  362,  362,  362,
  362,  362,  362,  362,  362,  362,  362,    0,    0,    0,
    0,    0,    0,  362,    0,    0,    0,  362,  362,    0,
  362,  362,  362,    0,  362,  362,  362,    0,  362,  362,
    0,    0,  362,  362,  362,  362,    0,  587,    0,  362,
  362,    0,    0,    0,  362,  362,  362,  362,  362,  362,
  362,  362,    0,    0,    0,    0,    0,   47,    0,    0,
    0,    0,    0,  362,   27,   27,  362,    0,  362,   27,
    0,    0,    0,   27,    0,   27,    0,    0,   27,  362,
   27,   27,    0,   27,    0,   27,    0,   27,    0,   27,
   27,   27,   27,    0,    0,   27,   27,    0,    0,    0,
    7,   27,    0,   27,   27,   27,    0,    0,   27,   27,
   27,    0,   27,    0,    0,   27,    0,   27,   27,   27,
   27,    0,    0,    0,   27,   27,   27,    0,    0,   27,
   27,   27,    0,    0,    0,    0,    0,    0,   27,   27,
    0,   27,   27,  958,   27,   27,   27,    0,   27,    0,
   27,    0,   27,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   27,    0,    0,    0,    0,   27,    0,
   27,    0,   27,    0,    0,   27,   27,   27,    0,    0,
    0,    0,    0,    0,    0,   27,   48,   27,   27,    0,
    0,    5,   27,   27,    0,   47,    0,    0,   27,    0,
   27,   27,   27,   27,    0,    0,   47,    0,   27,    0,
    0,   47,   27,    0,   27,   47,    0,    0,   47,    0,
    0,    0,    0,    0,   27,    0,   27,   27,    0,   27,
   47,   47,    0,   27,  957,   47,   47,    0,   47,    0,
    0,   47,    0,   47,   47,   47,   47,    0,    0,   47,
    0,   47,    0,   27,   47,   47,    0,   47,   47,   27,
   27,   47,    0,    0,    0,    0,    0,   47,    0,    0,
   47,    0,   47,   47,   47,    0,   47,    0,   47,   47,
    0,    0,    0,    0,   47,    0,   47,   47,   47,   47,
    0,    0,    0,    0,   47,    0,   47,    0,   47,    0,
   47,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   47,    0,    0,   47,   47,   47,    0,    0,   47,   47,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   47,
    0,    0,    0,    0,   47,    0,    0,    0,   47,   47,
    0,   47,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   47,   47,    0,    0,    7,   47,   47,
    0,   48,    0,    0,   47,    0,   47,   47,   47,   47,
    0,    0,   48,    0,   47,    0,    0,   48,   47,    0,
   47,   48,    0,    0,   48,    0,    0,    0,    0,    0,
   47,    0,    0,   47,    0,   47,   48,   48,    0,   47,
  958,   48,   48,    0,   47,    0,    0,   48,    0,   48,
   48,   48,   48,    0,    0,   47,    0,   48,    0,   47,
   47,   48,    0,   48,   47,    0,    0,   47,    0,    0,
    0,    0,    0,   48,    0,    0,   48,    0,   48,   47,
   47,    0,   48,   48,   47,   47,    0,   48,    0,    0,
   47,    0,   47,   47,   47,   47,    0,    0,   48,    0,
   47,    0,   48,   48,   47,    0,   47,   48,    0,    0,
   48,    0,    0,    0,    0,    0,   47,    0,    0,   47,
    0,   47,   48,   48,    0,   47,    0,   48,   48,    0,
    0,    0,    0,   48,    0,   48,   48,   48,   48,    0,
    0,    0,    0,   48,    0,   47,    0,   48,    0,   48,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   48,
    0,   55,   48,    0,   48,    0,    0,    0,   48,   56,
   24,   57,   25,    0,    0,   26,   58,    0,   59,   60,
   27,   61,   62,   63,   28,    0,    0,    0,   48,    0,
   64,    0,   65,   30,   66,   67,   68,   69,    0,    0,
   32,    0,    0,    0,   70,   33,    0,   71,   72,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   73,
    0,   36,    0,   37,   74,    0,    0,   38,    0,   75,
   76,   77,   78,   79,   80,   39,   40,   81,   82,   41,
   83,    0,   84,    0,    0,   85,   86,    0,  337,   87,
   88,    0,    0,    0,  337,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   89,   90,   91,   92,   93,    0,
    0,    0,   94,    0,    0,    0,   95,    0,    0,    0,
    0,   96,   97,   98,   99,  100,    0,    0,    0,  101,
  337,  102,    0,    0,    0,    0,    0,  103,  104,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  337,    0,    0,    0,    0,    0,
  337,    0,  105,  106,  107,  108,    0,    0,    0,    0,
    0,  337,    0,    0,  196,    0,  337,    0,  337,  337,
  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
    0,    0,    0,    0,    0,  337,  337,    0,    0,    0,
  337,  337,  337,  337,  337,  337,  337,  337,  337,    0,
  337,  337,    0,  337,  337,  337,  337,  337,  337,  337,
  337,  337,  337,    0,  337,  337,  337,  337,  337,  337,
  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
  337,  337,  337,  337,  337,  337,    0,  508,    0,    0,
  337,    0,  337,  508,    0,  337,    0,    0,    0,    0,
    0,  337,    0,    0,    0,    0,  337,    0,    0,  337,
    0,  337,  337,    0,    0,    0,  337,  337,    0,    0,
  337,  337,  337,  337,  337,  337,  337,  337,  337,  508,
  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  337,  337,    0,    0,    0,    0,    0,    0,  337,    0,
    0,  337,    0,    0,    0,    0,    0,  337,    0,  201,
  508,    0,    0,    0,    0,  508,    0,  508,  508,  508,
  508,  508,  508,  508,  508,  508,  508,  508,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  508,  508,
  508,  508,  508,  508,  508,  508,  508,  508,  949,  508,
  508,  202,  508,  508,  508,  508,  508,  508,  508,  508,
  508,  508,    0,  508,  508,  508,  508,  508,  508,  508,
  508,  508,  508,  508,  508,  508,  508,  508,  508,  508,
  508,  508,  508,  508,  508,    0,  504,    0,    0,    0,
    0,  508,  504,    0,    0,    0,    0,    0,    0,    0,
  508,  203,  204,  205,  206,    0,  207,  208,  209,  210,
  211,  212,  213,  214,    0,    0,  215,  216,  217,  218,
  219,  220,  221,  222,    0,    0,    0,    0,  504,    0,
    0,  949,    0,    0,    0,    0,  949,    0,  949,  949,
  949,  949,  949,  949,  949,  949,  949,  949,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  949,    0,  949,    0,  949,    0,  949,  949,  949,  504,
    0,    0,    0,    0,  504,    0,  504,  504,  504,  504,
  504,  504,  504,  504,  504,  504,  504,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  504,  504,    0,
  504,  504,  504,  504,  504,  504,  504,    0,  504,  504,
    0,  504,  504,  504,  504,  504,  504,  504,  504,  504,
  504,  949,  504,  504,  504,  504,  504,  504,  504,  504,
  504,  504,  504,  504,  504,  504,  504,  504,  504,  504,
  504,  504,  504,  504,    0,  512,  757,    0,    0,    0,
  504,  512,    0,  504,    0,   24,    0,   25,    0,  504,
   26,    0,    0,    0,    0,   27,    0,    0,    0,   28,
    0,    0,    0,    0,    0,    0,    0,    0,   30,    0,
    0,    0,    0,    0,    0,   32,    0,  512,    0,    0,
   33,    0,    0,    0,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,   37,    0,
    0,    0,   38,    0,    0,    0,    0,    0,    0,    0,
   39,   40,    0,    0,   41,    0,    0,  758,  512,    0,
    0,    0,    0,  512,    0,  512,  512,  512,  512,  512,
  512,  512,  512,  512,  512,  512,    0,    0,    0,    0,
    0,    0,    0,  290,    0,    0,    0,  512,    0,  512,
  512,  512,  512,  512,  512,  512,    0,  512,  512,    0,
  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,
    0,  512,  512,  512,  512,  512,  512,  512,  512,  512,
  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,
  512,  512,  512,    0,  337,  567,    0,    0,  323,  512,
  337,    0,  512,    0,   24,    0,   25,    0,  512,   26,
    0,    0,    0,    0,   27,    0,    0,    0,   28,    0,
    0,    0,    0,    0,    0,    0,    0,   30,    0,    0,
    0,    0,    0,    0,   32,    0,  337,    0,    0,   33,
    0,    0,    0,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,    0,    0,
    0,   38,    0,    0,    0,    0,    0,    0,    0,   39,
   40,    0,    0,   41,    0,    0,  322,  337,    0,    0,
    0,    0,  337,    0,  337,  337,  337,  337,  337,  337,
  337,  337,  337,  337,  337,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  337,    0,  337,  337,
  337,  337,  337,  337,  337,    0,  337,  337,    0,  337,
  337,  337,  337,  337,  337,  337,  337,  337,  337,    0,
  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
  337,  337,    0,  437,  906,    0,    0,  355,  337,  437,
    0,  337,    0,   24,    0,   25,    0,  337,   26,    0,
    0,    0,    0,   27,    0,    0,    0,   28,    0,    0,
    0,    0,    0,    0,    0,    0,   30,    0,    0,    0,
    0,    0,    0,   32,    0,  437,    0,    0,   33,    0,
    0,    0,   34,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   36,    0,   37,    0,    0,    0,
   38,    0,    0,    0,    0,    0,    0,    0,   39,   40,
    0,    0,   41,    0,    0,  322,  437,    0,    0,    0,
    0,  437,    0,  437,  437,  437,  437,  437,  437,  437,
  437,  437,  437,  437,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  437,    0,  437,  437,  437,
  437,  437,  437,  437,    0,  437,  437,    0,  437,  437,
  437,  437,  437,  437,  437,  437,  437,  437,    0,  437,
  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,
  437,  437,  437,  437,  437,  437,  437,  437,  437,  437,
  437,    0,  337,    0,    0,    0,  355,  437,  337, 1052,
  437,    0,  745,    0,    0,    0,  437,    0,   24,    0,
   25,    0,    0,   26,    0,    0,    0,    0,   27,    0,
    0,    0,   28,    0,    0,    0,    0,    0,    0,    0,
    0,   30,    0,    0,  337,    0,    0,    0,   32,    0,
    0,    0,    0,   33,    0,    0,    0,   34,    0,    0,
  745,    0,    0,    0,    0,    0,    0,    0,    0,   36,
    0,   37,    0,    0,    0,   38,    0,    0,    0,    0,
    0,    0,    0,   39,   40,    0,    0,   41,    0,    0,
  322,    0,    0,    0,    0,  543,    0,    0,    0,    0,
    0,  543,    0,  337,    0,    0,    0,    0,    0,  337,
    0,    0,    0,    0,  337,  337,  337,  337,  337,  337,
  337,  745,  337,    0,  337,  337,    0,  337,  337,  337,
  337,  337,  337,  337,  337,  337,  337,  543,  337,  337,
  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
    0,    0,    0,    0,  337,    0,  337,    0,    0,  337,
    0,  355,    0,    0,    0,  337,    0,    0,  543,    0,
    0,    0,    0,  543,    0,  543,  543,  543,  543,  543,
  543,  543,  543,  543,  543,  543,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  543,    0,  543,
    0,  543,    0,  543,  543,  543,    0,  543,  543,    0,
  543,  543,  543,  543,  543,  543,  543,  543,  543,  543,
  358,    0,    0,  543,  543,  543,  543,  543,  543,  543,
  543,  543,  543,  543,  543,  543,  543,  543,  543,  543,
  543,  555,  543,  358,    0,    0,    0,  555,    0,    0,
    0,    0,    0,    0,    0,    0,  358,    0,  543,    0,
    0,  358,    0,    0,  231,    0,  358,    0,  358,  358,
  358,  358,    0,    0,    0,    0,  358,    0,    0,    0,
  358,    0,    0,  555,  358,    0,    0,    0,    0,    0,
    0,    0,  358,    0,    0,  358,    0,  358,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  559,
    0,    0,    0,    0,    0,  559,    0,    0,    0,    0,
    0,  358,    0,    0,  555,    0,    0,    0,    0,  555,
    0,  555,  555,  555,  555,  555,  555,  555,  555,  555,
  555,  555,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  559,    0,  555,    0,  555,    0,  555,    0,  555,
  555,  555,    0,  555,  555,    0,    0,  555,  555,  555,
  555,  555,  555,  555,  555,  555,    0,  358,    0,  555,
  555,  555,  555,  555,  555,  555,  555,    0,    0,    0,
    0,    0,  559,    0,    0,    0,    0,  559,  555,  559,
  559,  559,  559,  559,  559,  559,  559,  559,  559,  559,
    0,    0,    0,  560,  555,    0,    0,    0,    0,  560,
    0,  559,    0,  559,    0,  559,    0,  559,  559,  559,
    0,  559,  559,    0,    0,  559,  559,  559,  559,    0,
    0,    0,  559,  559,    0,    0,    0,  559,  559,  559,
  559,  559,  559,  559,  559,  560,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  559,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  561,  559,    0,    0,    0,    0,  561,    0,    0,
    0,    0,    0,    0,    0,    0,  560,    0,    0,    0,
    0,  560,    0,  560,  560,  560,  560,  560,  560,  560,
  560,  560,  560,  560,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  561,    0,  560,    0,  560,    0,  560,
    0,  560,  560,  560,    0,  560,  560,    0,    0,  560,
  560,  560,  560,    0,    0,    0,  560,  560,    0,  564,
    0,  560,  560,  560,  560,  560,  560,  560,  560,    0,
    0,    0,    0,    0,  561,    0,    0,    0,    0,  561,
  560,  561,  561,  561,  561,  561,  561,  561,  561,  561,
  561,  561,    0,    0,    0,    0,  560,    0,    0,    0,
    0,    0,    0,  561,    0,  561,    0,  561,    0,  561,
  561,  561,    0,  561,  561,    0,    0,  561,  561,  561,
  561,    0,    0,    0,  561,  561,    0,  565,    0,  561,
  561,  561,  561,  561,  561,  561,  561,    0,    0,    0,
    0,    0,  564,    0,    0,    0,    0,  564,  561,  564,
  564,  564,  564,  564,  564,  564,  564,  564,  564,  564,
    0,    0,    0,    0,  561,    0,    0,    0,    0,    0,
    0,  564,    0,  564,    0,  564,    0,  564,  564,  564,
    0,    0,    0,    0,    0,  564,  564,  564,  564,    0,
    0,    0,  564,  564,    0,  566,    0,  564,  564,  564,
  564,  564,  564,  564,  564,    0,    0,    0,    0,    0,
  565,    0,    0,    0,    0,  565,  564,  565,  565,  565,
  565,  565,  565,  565,  565,  565,  565,  565,    0,    0,
    0,    0,  564,    0,    0,    0,    0,    0,    0,  565,
    0,  565,    0,  565,    0,  565,  565,  565,    0,    0,
    0,    0,    0,  565,  565,  565,  565,    0,    0,    0,
  565,  565,    0,  567,    0,  565,  565,  565,  565,  565,
  565,  565,  565,    0,    0,    0,    0,    0,  566,    0,
    0,    0,    0,  566,  565,  566,  566,  566,  566,  566,
  566,  566,  566,  566,  566,  566,    0,    0,    0,    0,
  565,    0,    0,    0,    0,    0,    0,  566,    0,  566,
    0,  566,    0,  566,  566,  566,    0,    0,    0,    0,
    0,  566,  566,  566,  566,    0,    0,    0,  566,  566,
    0,  568,    0,  566,  566,  566,  566,  566,  566,  566,
  566,    0,    0,    0,    0,    0,  567,    0,    0,    0,
    0,  567,  566,  567,  567,  567,  567,  567,  567,  567,
  567,  567,  567,  567,    0,    0,    0,    0,  566,    0,
    0,    0,    0,    0,    0,  567,    0,  567,    0,  567,
    0,  567,  567,  567,    0,    0,    0,    0,    0,  567,
  567,  567,  567,    0,    0,    0,  567,  567,    0,  569,
    0,    0,    0,  567,  567,  567,  567,  567,  567,    0,
    0,    0,    0,    0,  568,    0,    0,    0,    0,  568,
  567,  568,  568,  568,  568,  568,  568,  568,  568,  568,
  568,  568,    0,    0,    0,    0,  567,    0,    0,    0,
    0,    0,    0,  568,    0,  568,    0,  568,    0,  568,
  568,  568,    0,    0,    0,    0,    0,  568,  568,  568,
  568,    0,    0,    0,  568,  568,    0,  570,    0,    0,
    0,  568,  568,  568,  568,  568,  568,    0,    0,    0,
    0,    0,  569,    0,    0,    0,    0,  569,  568,  569,
  569,  569,  569,  569,  569,  569,  569,  569,  569,  569,
    0,    0,    0,    0,  568,    0,    0,    0,    0,    0,
    0,  569,    0,  569,    0,  569,    0,  569,  569,  569,
    0,    0,    0,    0,    0,  569,  569,  569,  569,    0,
    0,    0,  569,  569,    0,  571,    0,    0,    0,  569,
  569,  569,  569,  569,  569,    0,    0,    0,    0,    0,
  570,    0,    0,    0,    0,  570,  569,  570,  570,  570,
  570,  570,  570,  570,  570,  570,  570,  570,    0,    0,
    0,    0,  569,    0,    0,    0,    0,    0,    0,  570,
    0,  570,    0,  570,    0,  570,  570,  570,    0,    0,
    0,    0,    0,  570,  570,  570,  570,    0,    0,    0,
  570,  570,    0,  572,    0,    0,    0,  570,  570,  570,
  570,  570,  570,    0,    0,    0,    0,    0,  571,    0,
    0,    0,    0,  571,  570,  571,  571,  571,  571,  571,
  571,  571,  571,  571,  571,  571,    0,    0,    0,    0,
  570,    0,    0,    0,    0,    0,    0,  571,    0,  571,
    0,  571,    0,  571,  571,  571,    0,    0,    0,    0,
    0,  571,  571,  571,  571,    0,    0,    0,  571,  571,
    0,  573,    0,    0,    0,  571,  571,  571,  571,  571,
  571,    0,    0,    0,    0,    0,  572,    0,    0,    0,
    0,  572,  571,  572,  572,  572,  572,  572,  572,  572,
  572,  572,  572,  572,    0,    0,    0,    0,  571,    0,
    0,    0,    0,    0,    0,  572,    0,  572,    0,  572,
    0,  572,  572,  572,    0,    0,    0,    0,    0,    0,
    0,  572,  572,    0,    0,    0,  572,  572,    0,  574,
    0,    0,    0,    0,    0,  572,  572,  572,  572,    0,
    0,    0,    0,    0,  573,    0,    0,    0,    0,  573,
  572,  573,  573,  573,  573,  573,  573,  573,  573,  573,
  573,  573,    0,    0,    0,    0,  572,    0,    0,    0,
    0,    0,    0,  573,    0,  573,    0,  573,    0,  573,
  573,  573,    0,    0,    0,    0,    0,    0,    0,  573,
  573,    0,    0,    0,  573,  573,    0,  575,    0,    0,
    0,    0,    0,  573,  573,  573,  573,    0,    0,    0,
    0,    0,  574,    0,    0,    0,    0,  574,  573,  574,
  574,  574,  574,  574,  574,  574,  574,  574,  574,  574,
    0,    0,    0,    0,  573,    0,    0,    0,    0,    0,
    0,  574,    0,  574,    0,  574,    0,  574,  574,  574,
    0,    0,    0,    0,    0,    0,    0,  574,  574,    0,
    0,    0,  574,  574,    0,  576,    0,    0,    0,    0,
    0,  574,  574,  574,  574,    0,    0,    0,    0,    0,
  575,    0,    0,    0,    0,  575,  574,  575,  575,  575,
  575,  575,  575,  575,  575,  575,  575,  575,    0,    0,
    0,    0,  574,    0,    0,    0,    0,    0,    0,  575,
    0,  575,    0,  575,    0,  575,  575,  575,    0,    0,
    0,    0,    0,    0,    0,  575,  575,    0,    0,    0,
  575,  575,    0,  577,    0,    0,    0,    0,    0,    0,
    0,  575,  575,    0,    0,    0,    0,    0,  576,    0,
    0,    0,    0,  576,  575,  576,  576,  576,  576,  576,
  576,  576,  576,  576,  576,  576,    0,    0,    0,    0,
  575,    0,    0,    0,    0,    0,    0,  576,    0,  576,
    0,  576,    0,  576,  576,  576,    0,    0,    0,    0,
    0,    0,    0,  576,  576,    0,    0,    0,  576,  576,
    0,  578,    0,    0,    0,    0,    0,    0,    0,  576,
  576,    0,    0,    0,    0,    0,  577,    0,    0,    0,
    0,  577,  576,  577,  577,  577,  577,  577,  577,  577,
  577,  577,  577,  577,    0,    0,    0,    0,  576,    0,
    0,    0,    0,    0,    0,  577,    0,  577,    0,  577,
    0,  577,  577,  577,    0,    0,    0,    0,    0,    0,
    0,    0,  577,    0,    0,    0,  577,  577,    0,  579,
    0,    0,    0,    0,    0,    0,    0,  577,  577,    0,
    0,    0,    0,    0,  578,    0,    0,    0,    0,  578,
  577,  578,  578,  578,  578,  578,  578,  578,  578,  578,
  578,  578,    0,    0,    0,    0,  577,    0,    0,    0,
    0,    0,    0,  578,    0,  578,    0,  578,    0,  578,
  578,  578,    0,    0,    0,    0,    0,    0,    0,    0,
  578,    0,    0,    0,  578,  578,    0,  580,    0,    0,
    0,    0,    0,    0,    0,  578,  578,    0,    0,    0,
    0,    0,  579,    0,    0,    0,    0,  579,  578,  579,
  579,  579,  579,  579,  579,  579,  579,  579,  579,  579,
    0,    0,    0,    0,  578,    0,    0,    0,    0,    0,
    0,  579,    0,  579,    0,  579,    0,  579,  579,  579,
    0,    0,    0,    0,    0,    0,    0,    0,  579,    0,
    0,    0,    0,  579,    0,  581,    0,    0,    0,    0,
    0,    0,    0,  579,  579,    0,    0,    0,    0,    0,
  580,    0,    0,    0,    0,  580,  579,  580,  580,  580,
  580,  580,  580,  580,  580,  580,  580,  580,    0,    0,
    0,    0,  579,    0,    0,    0,    0,    0,    0,  580,
    0,  580,    0,  580,    0,  580,  580,  580,    0,    0,
    0,    0,    0,    0,    0,    0,  580,    0,    0,    0,
    0,  580,    0,  582,    0,    0,    0,    0,    0,    0,
    0,  580,  580,    0,    0,    0,    0,    0,  581,    0,
    0,    0,    0,  581,  580,  581,  581,  581,  581,  581,
  581,  581,  581,  581,  581,  581,    0,    0,    0,    0,
  580,    0,    0,    0,    0,    0,    0,  581,    0,  581,
    0,  581,    0,  581,  581,  581,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  581,
    0,  583,    0,    0,    0,    0,    0,    0,    0,  581,
  581,    0,    0,    0,    0,    0,  582,    0,    0,    0,
    0,  582,  581,  582,  582,  582,  582,  582,  582,  582,
  582,  582,  582,  582,    0,    0,    0,    0,  581,    0,
    0,    0,    0,    0,    0,  582,    0,  582,    0,  582,
    0,  582,  582,  582,    0,    0,    0,  584,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  582,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  582,  582,    0,
    0,    0,    0,    0,  583,    0,    0,    0,    0,  583,
  582,  583,  583,  583,  583,  583,  583,  583,  583,  583,
  583,  583,    0,    0,    0,    0,  582,    0,    0,    0,
    0,    0,    0,  583,    0,  583,    0,  583,    0,  583,
  583,  583,    0,    0,    0,    0,  337,    0,    0,    0,
  745,    0,    0,    0,    0,  583,    0,    0,    0,    0,
  584,    0,    0,    0,    0,  584,  583,  584,  584,  584,
  584,  584,  584,  584,  584,  584,  584,  584,  583,    0,
    0,    0,  337,    0,    0,    0,    0,    0,    0,  584,
    0,  584,    0,  584,  583,  584,  584,  584,  745,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  584,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  584,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  584,    0,    0,    0,    0,    0,
    0,  337,    0,    0,    0,    0,    0,  337,    0,    0,
  584,    0,  337,  337,    0,  337,    0,  337,    0,  745,
  337,    0,  337,  337,    0,  337,  337,  337,  337,  337,
  337,  337,  337,  337,  337,    0,  337,  337,  337,  337,
  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
  337,  337,  337,  337,  337,  337,  337,  337,    0,    0,
   55,    0,  337,    0,  337,    0,    0,  337,   56,   24,
   57,   25,    0,  337,   26,   58,    0,   59,   60,   27,
   61,   62,   63,   28,    0,    0,    0,    0,    0,   64,
    0,   65,   30,   66,   67,   68,   69,    0,    0,   32,
    0,    0,    0,   70,   33,    0,   71,   72,   34,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   73,    0,
   36,    0,   37,   74,    0,    0,   38,    0,   75,   76,
   77,   78,   79,   80,   39,   40,   81,   82,   41,   83,
    0,   84,    0,    0,   85,   86,    0,    0,   87,   88,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   89,   90,   91,   92,   93,    0,    0,
    0,   94,    0,    0,    0,   95,    0,    0,    0,    0,
   96,   97,   98,   99,  100,    0,    0,    0,  101,    0,
  102,    0,    0,    0,    0,    0,  103,  104,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  265,    0,    0,
    0,  105,  106,  107,  108,   56,   24,   57,   25,    0,
    0,   26,   58,    0,   59,   60,   27,   61,   62,   63,
   28,    0,    0,    0,    0,    0,   64,    0,   65,   30,
   66,   67,   68,   69,    0,    0,   32,    0,    0,    0,
   70,   33,    0,   71,   72,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   73,    0,   36,    0,   37,
   74,    0,    0,   38,    0,   75,   76,   77,   78,   79,
   80,   39,   40,   81,   82,   41,   83,    0,   84,    0,
    0,   85,   86,    0,    0,   87,   88,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   89,   90,   91,   92,   93,    0,    0,    0,   94,    0,
    0,    0,   95,    0,    0,    0,    0,   96,   97,   98,
   99,  100,    0,    0,    0,  101,    0,  102,    0,    0,
    0,    0,    0,  103,  104,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  556,    0,    0,    0,  105,  106,
  107,  108,   56,   24,   57,   25,    0,    0,   26,   58,
    0,   59,   60,   27,   61,   62,   63,   28,    0,    0,
    0,    0,    0,   64,    0,   65,   30,   66,   67,   68,
   69,    0,    0,   32,    0,    0,    0,   70,   33,    0,
   71,   72,   34,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   73,    0,   36,    0,   37,   74,    0,    0,
   38,    0,   75,   76,   77,   78,   79,   80,   39,   40,
   81,   82,   41,   83,    0,   84,    0,    0,   85,   86,
    0,    0,   87,   88,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   89,   90,   91,
   92,   93,    0,    0,    0,   94,    0,    0,    0,   95,
    0,    0,    0,    0,   96,   97,   98,   99,  100,    0,
    0,    0,  101,    0,  102,    0,    0,    0,    0,    0,
  103,  104,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  954,    0,    0,    0,  105,  557,  107,  108,  954,
  954,  954,  954,    0,    0,  954,  954,    0,  954,  954,
  954,  954,  954,  954,  954,    0,    0,    0,    0,    0,
  954,    0,  954,  954,  954,  954,  954,  954,    0,    0,
  954,    0,    0,    0,  954,  954,    0,  954,  954,  954,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  954,
    0,  954,    0,  954,  954,    0,    0,  954,    0,  954,
  954,  954,  954,  954,  954,  954,  954,  954,  954,  954,
  954,    0,  954,    0,    0,  954,  954,    0,    0,  954,
  954,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  954,  954,  954,  954,  954,    0,
    0,    0,  954,    0,    0,    0,  954,    0,    0,    0,
    0,  954,  954,  954,  954,  954,    0,    0,    0,  954,
    0,  954,    0,    0,    0,    0,    0,  954,  954,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  796,    0,
    0,    0,  954,  954,  954,  954,  796,  796,  796,  796,
    0,    0,  796,  796,    0,  796,  796,  796,  796,  796,
  796,  796,    0,    0,    0,    0,    0,  796,    0,  796,
  796,  796,  796,  796,  796,    0,    0,  796,    0,    0,
    0,  796,  796,    0,  796,  796,  796,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  796,    0,  796,    0,
  796,  796,    0,    0,  796,    0,  796,  796,  796,  796,
  796,  796,  796,  796,  796,  796,  796,  796,    0,  796,
    0,    0,  796,  796,    0,    0,  796,  796,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  796,  796,  796,  796,  796,    0,    0,    0,  796,
    0,    0,    0,  796,    0,    0,    0,    0,  796,  796,
  796,  796,  796,    0,    0,    0,  796,    0,  796,    0,
    0,    0,    0,    0,  796,  796,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  743,    0,    0,    0,  796,
  796,  796,  796,   56,   24,    0,   25,    0,    0,   26,
  253,    0,    0,    0,   27,   61,   62,    0,   28,    0,
    0,  174,    0,  174,   64,    0,  174,   30,    0,    0,
    0,  174,    0,    0,   32,  174,    0,    0,    0,   33,
    0,   71,   72,   34,  174,    0,    0,    0,    0,    0,
    0,  174,    0,    0,    0,   36,  174,   37,   74,    0,
  174,   38,    0,    0,   76,    0,   78,    0,   80,   39,
   40,  254,  174,   41,  174,    0,    0,    0,  174,    0,
   86,    0,    0,   87,   88,    0,  174,  174,    0,    0,
  174,    0,    0,  174,    0,    0,    0,    0,   89,   90,
   91,   92,  301,    0,    0,    0,  517,  744,    0,    0,
   95,    0,    0,    0,    0,    0,   97,   98,   99,  100,
    0,    0,    0,  101,    0,  102,    0,    0,  978,    0,
    0,  103,  104,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  932,    0,    0,    0,  105,  302,  107,  108,
   56,   24,    0,   25,    0,    0,   26,  253,    0,    0,
    0,   27,   61,   62,  174,   28,    0,    0,  174,    0,
  174,   64,    0,  174,   30,    0,    0,    0,  174,    0,
    0,   32,  174,    0,    0,    0,   33,    0,   71,   72,
   34,  174,  594,    0,    0,    0,    0,    0,  174,  595,
    0,    0,   36,  174,   37,   74,    0,  174,   38,    0,
    0,   76,    0,   78,    0,   80,   39,   40,  254,  174,
   41,  174,    0,    0,    0,  174,    0,  596,    0,    0,
   87,   88,    0,  174,  174,    0,    0,  174,    0,    0,
  174,    0,    0,    0,    0,   89,   90,   91,   92,   93,
    0,    0,    0,    0,    0,    0,    0,   95,    0,    0,
    0,    0,    0,   97,   98,   99,  100,    0,    0,    0,
  101,    0,  102,  978,    0,    0,    0,    0,  103,  104,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  936,
    0,    0,    0,  105,  106,  107,  108,   56,   24,    0,
   25,    0,    0,   26,  253,    0,    0,    0,   27,   61,
   62,  174,   28,    0,    0,   24,    0,   25,   64,    0,
   26,   30,    0,    0,    0,   27,    0,    0,   32,   28,
    0,    0,    0,   33,    0,   71,   72,   34,   30,    0,
    0,    0,    0,    0,    0,   32,    0,    0,    0,   36,
   33,   37,   74,  937,   34,   38,    0,    0,   76,    0,
   78,    0,   80,   39,   40,  254,   36,   41,   37,    0,
    0,    0,   38,    0,   86,    0,    0,   87,   88,    0,
   39,   40,    0,    0,   41,    0,    0,  322,    0,    0,
    0,    0,   89,   90,   91,   92,  301,    0,    0,    0,
  517,    0,    0,    0,   95,    0,    0,    0,    0,    0,
   97,   98,   99,  100,    0,    0,    0,  101,    0,  102,
    0,    0,    0,    0,    0,  103,  104,    0,    0,    0,
    0,    0,    0,   56,   24,    0,   25,    0,    0,   26,
  253,    0,    0,    0,   27,   61,   62,    0,   28,    0,
  105,  302,  107,  108,   64,    0,    0,   30,    0,    0,
    0,    0,    0,    0,   32,    0,    0,    0,  355,   33,
    0,   71,   72,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,   74,    0,
    0,   38,    0,    0,   76,    0,   78,    0,   80,   39,
   40,  254,    0,   41,    0,    0,    0,    0,    0,    0,
   86,    0,    0,   87,   88,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   89,   90,
   91,   92,  301,    0,    0,    0,  729, 1004,    0,    0,
   95,    0,    0,    0,    0,    0,   97,   98,   99,  100,
    0,    0,    0,  101,    0,  102,    0,    0,    0,    0,
    0,  103,  104,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  743,    0,  105,  730,  107,  108,
    0,    0,   56,   24,    0,   25,    0,  731,   26,  253,
    0,    0,    0,   27,   61,   62,    0,   28,    0,    0,
   24,    0,   25,   64,    0,   26,   30,    0,    0,    0,
   27,    0,    0,   32,   28,    0,    0,    0,   33,    0,
   71,   72,   34,   30,    0,    0,    0,    0,    0,    0,
   32,    0,    0,    0,   36,   33,   37,   74,  937,   34,
   38,    0,    0,   76,    0,   78,    0,   80,   39,   40,
  254,   36,   41,   37,    0,    0,    0,   38,    0,   86,
    0,    0,   87,   88,    0,   39,   40,    0,    0,   41,
    0,    0,  519,    0,    0,    0,    0,   89,   90,   91,
   92,  301,    0,    0,    0,  517,    0,    0,    0,   95,
    0,    0,    0,    0,    0,   97,   98,   99,  100,    0,
    0,    0,  101,    0,  102,    0,    0,    0,    0,    0,
  103,  104,    0,    0,    0,    0,    0,    0,   56,   24,
    0,   25,    0,    0,   26,  253,    0,    0,    0,   27,
   61,   62,    0,   28,    0,  105,  302,  107,  108,   64,
    0,    0,   30,    0,    0,    0,    0,    0,    0,   32,
    0,    0,    0,  355,   33,    0,   71,   72,   34,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   36,    0,   37,   74,    0,    0,   38,    0,    0,   76,
    0,   78,    0,   80,   39,   40,  254,    0,   41,    0,
    0,    0,    0,    0,    0,   86,    0,    0,   87,   88,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   89,   90,   91,   92,  301,    0,    0,
    0,  729,    0,    0,    0,   95,    0,    0,    0,    0,
    0,   97,   98,   99,  100,    0,    0,    0,  101,    0,
  102,    0,    0,    0,    0,    0,  103,  104,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  743,
    0,  105,  730,  107,  108,    0,    0,   56,   24,    0,
   25,    0,  731,   26,  253,    0,    0,    0,   27,   61,
   62,    0,   28,    0,    0,   24,    0,   25,   64,    0,
   26,   30,    0,    0,    0,   27,    0,    0,   32,   28,
    0,    0,    0,   33,    0,   71,   72,   34,   30,    0,
    0,    0,    0,    0,    0,   32,    0,    0,    0,   36,
   33,   37,   74,    0,   34,   38,    0,    0,   76,    0,
   78,    0,   80,   39,   40,  254,   36,   41,   37,    0,
    0,    0,   38,    0,   86,    0,    0,   87,   88,    0,
   39,   40,    0,    0,   41,    0,    0,  573,    0,    0,
    0,    0,   89,   90,   91,   92,  301,    0,    0,    0,
  517,    0,    0,    0,   95,    0,    0,    0,    0,    0,
   97,   98,   99,  100,    0,    0,    0,  101,    0,  102,
    0,    0,    0,    0,    0,  103,  104,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  300,    0,    0,    0,
  105,  302,  107,  108,   56,   24,    0,   25,    0,    0,
   26,  253,    0,    0,    0,   27,   61,   62,  355,   28,
    0,    0,   24,    0,   25,   64,    0,   26,   30,    0,
    0,    0,   27,    0,    0,   32,   28,    0,    0,    0,
   33,    0,   71,   72,   34,   30,    0,    0,    0,    0,
    0,    0,   32,    0,    0,    0,   36,   33,   37,   74,
    0,   34,   38,    0,    0,   76,    0,   78,    0,   80,
   39,   40,  254,   36,   41,   37,    0,    0,    0,   38,
    0,   86,    0,    0,   87,   88,    0,   39,   40,    0,
    0,   41,    0,    0,  758,    0,    0,    0,    0,   89,
   90,   91,   92,  301,    0,    0,    0,    0,    0,    0,
    0,   95,    0,    0,    0,    0,    0,   97,   98,   99,
  100,    0,    0,    0,  101,    0,  102,    0,    0,    0,
    0,    0,  103,  104,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  309,    0,    0,    0,  105,  302,  107,
  108,   56,   24,    0,   25,    0,    0,   26,  253,    0,
    0,    0,   27,   61,   62,  355,   28,    0,    0,  491,
    0,  491,   64,    0,  491,   30,    0,    0,    0,  491,
    0,    0,   32,  491,    0,    0,    0,   33,    0,   71,
   72,   34,  491,    0,    0,    0,    0,    0,    0,  491,
    0,    0,    0,   36,  491,   37,   74,    0,  491,   38,
    0,    0,   76,    0,   78,    0,   80,   39,   40,  254,
  491,   41,  491,    0,    0,    0,  491,    0,   86,    0,
    0,   87,   88,    0,  491,  491,    0,    0,  491,    0,
    0,  491,    0,    0,    0,    0,   89,   90,   91,   92,
  301,    0,    0,    0,    0,    0,    0,    0,   95,    0,
    0,    0,    0,    0,   97,   98,   99,  100,    0,    0,
    0,  101,    0,  102,    0,    0,    0,    0,    0,  103,
  104,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  592,    0,    0,    0,  105,  302,  107,  108,   56,   24,
    0,   25,    0,    0,   26,  253,    0,    0,    0,   27,
   61,   62,  491,   28,    0,    0,  175,    0,  175,   64,
    0,  175,   30,    0,    0,    0,  175,    0,    0,   32,
  175,    0,    0,    0,   33,    0,   71,   72,   34,  175,
    0,    0,    0,    0,    0,    0,  175,    0,    0,    0,
   36,  175,   37,   74,    0,  175,   38,    0,    0,   76,
    0,   78,    0,   80,   39,   40,  254,  175,   41,  175,
    0,    0,    0,  175,    0,   86,    0,    0,   87,   88,
    0,  175,  175,    0,    0,  175,    0,    0,  175,    0,
    0,    0,    0,   89,   90,   91,   92,   93,    0,    0,
    0,    0,    0,    0,    0,   95,    0,    0,    0,    0,
    0,   97,   98,   99,  100,    0,    0,    0,  101,    0,
  102,    0,    0,    0,    0,    0,  103,  104,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  823,    0,    0,
    0,  105,  106,  107,  108,   56,   24,    0,   25,    0,
    0,   26,  253,    0,    0,    0,   27,   61,   62,  175,
   28,    0,    0,  174,    0,  174,   64,    0,  174,   30,
    0,    0,    0,  174,    0,    0,   32,  174,    0,    0,
    0,   33,    0,   71,   72,   34,  174,    0,    0,    0,
    0,    0,    0,  174,    0,    0,    0,   36,  174,   37,
   74,    0,  174,   38,    0,    0,   76,    0,   78,    0,
   80,   39,   40,  254,  174,   41,  174,    0,    0,    0,
  174,    0,   86,    0,    0,   87,   88,    0,  174,  174,
    0,    0,  174,    0,    0,  174,    0,    0,    0,    0,
   89,   90,   91,   92,  301,    0,    0,    0,    0,    0,
    0,    0,   95,    0,    0,    0,    0,    0,   97,   98,
   99,  100,    0,    0,    0,  101,    0,  102,    0,    0,
    0,    0,    0,  103,  104,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1189,    0,    0,    0,  105,  302,
  107,  108,   56,   24,    0,   25,    0,    0,   26,  253,
    0,    0,    0,   27,   61,   62,  174,   28,    0,    0,
  184,    0,  184,   64,    0,  184,   30,    0,    0,    0,
  184,    0,    0,   32,  184,    0,    0,    0,   33,    0,
   71,   72,   34,  184,    0,    0,    0,    0,    0,    0,
  184,    0,    0,    0,   36,  184,   37,   74,    0,  184,
   38,    0,    0,   76,    0,   78,    0,   80,   39,   40,
  254,  184,   41,  184,    0,    0,    0,  184,    0,   86,
    0,    0,   87,   88,    0,  184,  184,    0,    0,  184,
    0,    0,  184,    0,    0,    0,    0,   89,   90,   91,
   92,  301,    0,    0,    0,    0,    0,    0,    0,   95,
    0,    0,    0,    0,    0,   97,   98,   99,  100,    0,
    0,    0,  101,    0,  102,    0,    0,    0,    0,    0,
  103,  104,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  610,    0,    0,    0,  105,  302,  107,  108,  610,
  610,    0,  610,    0,    0,  610,  610,    0,    0,    0,
  610,  610,  610,  184,  610,    0,    0,    0,    0,    0,
  610,    0,    0,  610,    0,    0,    0,    0,    0,    0,
  610,    0,    0,    0,    0,  610,    0,  610,  610,  610,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  610,    0,  610,  610,    0,    0,  610,    0,    0,
  610,    0,  610,    0,  610,  610,  610,  610,    0,  610,
    0,    0,    0,    0,    0,    0,  610,    0,    0,  610,
  610,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  610,  610,  610,  610,  610,    0,
    0,    0,    0,    0,    0,    0,  610,    0,    0,    0,
    0,    0,  610,  610,  610,  610,    0,    0,    0,  610,
    0,  610,    0,    0,    0,    0,    0,  610,  610,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  500,    0,
    0,    0,  610,  610,  610,  610,   56,   24,    0,   25,
    0,    0,   26,  253,    0,    0,    0,   27,   61,   62,
    0,   28,    0,    0,    0,    0,    0,   64,    0,    0,
   30,    0,    0,    0,   27,    0,    0,   32,    0,    0,
    0,  337,   33,    0,   71,   72,   34,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   27,   36,    0,
   37,   74,    0,    0,   38,    0,    0,   76,    0,   78,
   27,   80,   39,   40,  254,   27,   41,  337,    0,    0,
   27,    0,   27,   27,   27,   27,    0,    0,   27,    0,
   27,    0,    0,    0,   27,    0,    0,    0,    0,    0,
    0,   89,   90,   91,  255,    0,   27,    0,    0,   27,
    0,   27,    0,   95,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   27,    0,    0,    0,    0,
    0,   27,   27,    0,    0,    0,    0,    0,    0,    0,
  337,  337,  337,  337,  745,    0,    0,  337,  337,  105,
  501,  337,  337,  337,  337,  337,  337,  337,  337,  337,
    0,  337,  337,  337,  337,  337,  337,  337,  337,  337,
  337,  337,  337,  337,  337,  337,  337,  337,  337,  337,
  337,  337,  337,    0,   48,    0,   48,    0,   48,  337,
   48,    0,  337,   48,    0,   48,   48,    0,   48,    0,
   48,    0,   48,    0,   48,   48,   48,   48,    0,    0,
   48,   48,    0,    0,    0,    0,   48,   48,   48,   48,
   48,    0,    0,   48,    0,   48,    0,   48,    0,   48,
   48,    0,   48,   48,   48,   48,    0,    0,   48,   48,
   48,   48,    0,    0,   48,   48,   48,    0,    0,    0,
    0,    0,    0,   48,   48,    0,   48,   48,    0,   48,
   48,   48,    0,    0,    0,   48,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   48,    0,   48,   48,   47,
    0,    0,    0,   47,    0,   47,    0,    0,   47,    0,
   47,   47,    0,   47,    0,   47,    0,   47,    0,   47,
   47,   47,   47,    0,    0,   47,   47,    0,    0,    0,
    0,   47,    0,   47,   47,   47,    0,    0,   47,    0,
   47,    0,   47,    0,    0,   47,    0,   47,   47,   47,
   47,   48,    0,    0,   47,   47,   47,    0,    0,   47,
   47,   47,    0,    0,    0,    0,    0,    0,   47,   47,
    0,   47,   47,    0,   47,   47,   47,    0,    0,    0,
   47,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   47,    0,
   47,    0,   47,    0,   47,    0,   80,   47,    0,   47,
   47,    0,   47,    0,   47,   47,   47,    0,   47,   47,
   47,   47,    0,    0,   47,   47,    0,    0,    0,    0,
   47,    0,   47,   47,   47,    0,    0,   47,    0,   47,
    0,   47,    0,    0,   47,    0,   47,   47,   47,   47,
    0,    0,    0,   47,   47,   47,   47,    0,   47,   47,
   47,    0,    0,    0,    0,    0,    0,   47,   47,    0,
   47,   47,    0,   47,   47,   47,    0,    0,    0,   47,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   48,    0,   47,
    0,   48,    0,   48,    0,   81,   48,    0,   48,   48,
    0,   48,    0,   48,   47,   48,    0,   48,   48,   48,
   48,    0,    0,   48,   48,    0,    0,    0,    0,   48,
    0,   48,   48,   48,    0,    0,   48,    0,   48,    0,
   48,    0,    0,   48,    0,   48,   48,   48,   48,    0,
    0,    0,   48,   48,   48,   47,    0,   48,   48,   48,
    0,    0,    0,    0,    0,    0,   48,   48,    0,   48,
   48,    0,   48,   48,   48,    0,    0,    0,   48,    0,
    0,    0,    0,   47,    0,    0,    0,   47,    0,   47,
    0,    0,   47,    0,   47,   47,    0,   47,   48,   47,
    0,   47,    0,   47,   47,   47,   47,    0,    0,   47,
   47,    0,    0,   48,    0,   47,    0,   47,   47,   47,
    0,    0,   47,    0,   47,    0,   47,    0,    0,   47,
    0,   47,   47,   47,   47,    0,    0,    0,   47,   47,
   47,    0,    0,   47,   47,   47,    0,    0,    0,    0,
    0,    0,   47,   47,   48,   47,   47,    0,   47,   47,
   47,    0,    0,    0,   47,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   47,    0,    0,
    0,   47,    0,   47,   47,    0,   47,    0,   47,   47,
  214,   47,    0,   47,    0,   47,    0,   47,   47,   47,
   47,    0,    0,   47,   47,    0,    0,    0,    0,   47,
    0,   47,   47,   47,    0,    0,   47,    0,   47,  337,
   47,    0,    0,   47,    0,   47,   47,   47,   47,    0,
    0,    0,   47,   47,   47,    0,    0,   47,   47,   47,
   47,    0,  337,    0,    0,    0,   47,   47,    0,   47,
   47,  452,   47,   47,   47,  337,    0,    0,   47,    0,
  337,    0,    0,  337,    0,  337,    0,  337,  337,  337,
  337,    0,    0,    0,  453,  337,    0,    0,   47,  337,
    0,    0,    0,  337,  215,    0,    0,  454,    0,    0,
    0,  337,  456,    0,  337,    0,  337,  457,    0,  458,
  459,  460,  461,    0,    0,    0,    0,  462,    0,    0,
    0,  463,    0,    0,    0,  337,    0,    0,    0,    0,
  337,    0,    0,  464,    0,    0,  465,  337,  466,  265,
    0,  337,    0,    0,   47,   56,   24,    0,   25,    0,
    0,   26,  253,    0,  337,    0,   27,   61,   62,    0,
   28,    0,  467,    0,    0,    0,   64,    0,    0,   30,
    0,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   71,   72,   34,  337,  594,    0,    0,
    0,    0,    0,    0,  595,    0,    0,   36,    0,   37,
   74,    0,    0,   38,    0,    0,   76,    0,   78,    0,
   80,   39,   40,  254,    0,   41,    0,    0, 1340,    0,
    0,    0,  596,    0,    0,   87,   88,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   89,   90,   91,   92,   93,    0,    0,    0,    0,    0,
    0,    0,   95,  930,    0,  597,    0,    0,   97,   98,
   99,  100,    0,    0,    0,  101,    0,  102,    0,    0,
    0,    0,    0,  103,  104,    0,    0,    0,    0,    0,
    0,   56,   24,    0,   25,    0,    0,   26,  253,    0,
    0,    0,   27,   61,   62,    0,   28,    0,  105,  106,
  107,  108,   64,    0,    0,   30,    0,    0,    0,    0,
    0,    0,   32,    0,    0,    0,    0,   33,    0,   71,
   72,   34,    0,  594,    0,    0,    0,    0,    0,    0,
  595,    0,    0,   36,    0,   37,   74,    0,    0,   38,
    0,    0,   76,    0,   78,    0,   80,   39,   40,  254,
    0,   41,    0,    0,    0,    0,    0,    0,  596,    0,
    0,   87,   88,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   89,   90,   91,   92,
   93,    0,    0,    0,    0,    0,    0,    0,   95,    0,
    0,  597,    0,    0,   97,   98,   99,  100,    0,    0,
    0,  101,    0,  102,    0,    0,    0,    0,    0,  103,
  104,    0,    0,    0,    0,    0,    0,   56,   24,    0,
   25,    0,    0,   26,  253,    0,    0,    0,   27,   61,
   62,    0,   28,    0,  105,  106,  107,  108,   64,    0,
    0,   30,    0,    0,    0,    0,    0,    0,   32,    0,
    0,    0,    0,   33,    0,   71,   72,   34,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   36,
    0,   37,   74,    0,    0,   38,    0,    0,   76,    0,
   78,    0,   80,   39,   40,  254,    0,   41,    0,    0,
   84,    0,    0,    0,   86,    0,    0,   87,   88,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   89,   90,   91,   92,  301,    0,    0,    0,
    0,    0,    0,    0,   95,    0,    0,    0,    0,    0,
   97,   98,   99,  100,    0,    0,    0,  101,    0,  102,
    0,    0,    0,    0,    0,  103,  104,    0,    0,    0,
    0,    0,    0,   56,   24,    0,   25,    0,    0,   26,
  253,    0,    0,    0,   27,   61,   62,    0,   28,    0,
  105,  302,  107,  108,   64,    0,    0,   30,    0,    0,
    0,    0,    0,    0,   32,    0,    0,    0,    0,   33,
    0,   71,   72,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,   74,    0,
    0,   38,    0,    0,   76,    0,   78,    0,   80,   39,
   40,  254,    0,   41,    0,    0,    0,    0,    0,    0,
   86,    0,    0,   87,   88,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   89,   90,
   91,   92,  301,    0,    0,    0,    0,  889,    0,    0,
   95,    0,    0,    0,    0,    0,   97,   98,   99,  100,
    0,    0,    0,  101,    0,  102,    0,    0,    0,    0,
    0,  103,  104,    0,    0,    0,    0,    0,    0,   56,
   24,    0,   25,    0,    0,   26,  253,    0,    0,    0,
   27,   61,   62,    0,   28,    0,  105,  302,  107,  108,
   64,    0,    0,   30,    0,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   71,   72,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   74,    0,    0,   38,    0,    0,
   76,    0,   78,    0,   80,   39,   40,  254,    0,   41,
    0,    0,    0,    0,    0,    0,   86,    0,    0,   87,
   88,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   89,   90,   91,   92,  301,    0,
    0,    0,  517,    0,    0,    0,   95,    0,    0,    0,
    0,    0,   97,   98,   99,  100,    0,    0,    0,  101,
    0,  102,    0,    0,    0,    0,    0,  103,  104,    0,
    0,    0,    0,    0,    0,   56,   24,    0,   25,    0,
    0,   26,  253,    0,    0,    0,   27,   61,   62,    0,
   28,    0,  105,  302,  107,  108,   64,    0,    0,   30,
    0,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   71,   72,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   74,    0,    0,   38,    0,    0,   76,    0,   78,    0,
   80,   39,   40,  254,    0,   41,    0,    0,    0,    0,
    0,    0,   86,    0,    0,   87,   88,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   89,   90,   91,   92,  301,    0,    0,    0,  511,    0,
    0,    0,   95,    0,    0,    0,    0,    0,   97,   98,
   99,  100,    0,    0,    0,  101,    0,  102,    0,    0,
    0,    0,    0,  103,  104,    0,    0,    0,    0,    0,
    0,   56,   24,    0,   25,    0,    0,   26,  253,    0,
    0,    0,   27,   61,   62,    0,   28,    0,  105,  302,
  107,  108,   64,    0,    0,   30,    0,    0,    0,    0,
    0,    0,   32,    0,    0,    0,    0,   33,    0,   71,
   72,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   36,    0,   37,   74,    0,    0,   38,
    0,    0,   76,    0,   78,    0,   80,   39,   40,  254,
    0,   41,    0,    0,    0,    0,    0,    0,   86,    0,
    0,   87,   88,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   89,   90,   91,   92,
  301,    0,    0,    0,    0,    0,    0,    0,   95,    0,
    0,    0,    0,    0,   97,   98,   99,  100,    0,    0,
    0,  101,    0,  102,    0,    0,    0,    0,    0,  103,
  104,    0,    0,    0,    0,    0,    0,   56,   24,    0,
   25,    0,    0,   26,  253,    0,    0,    0,   27,   61,
   62,    0,   28,    0,  105,  302,  107,  108,   64,    0,
    0,   30,    0,    0,    0,    0,    0,    0,   32,    0,
    0,    0,    0,   33,    0,   71,   72,   34,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   36,
    0,   37,   74,    0,    0,   38,    0,    0,   76,    0,
   78,    0,   80,   39,   40,  254,    0,   41,    0,    0,
    0,    0,    0,    0,   86,    0,    0,   87,   88,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   89,   90,   91,   92,   93,    0,    0,    0,
    0,    0,    0,    0,   95,    0,    0,    0,    0,    0,
   97,   98,   99,  100,    0,    0,    0,  101,    0,  102,
    0,    0,    0,    0,    0,  103,  104,    0,    0,    0,
    0,    0,    0,   56,   24,    0,   25,    0,    0,   26,
  253,    0,    0,    0,   27,   61,   62,    0,   28,    0,
  105,  106,  107,  108,   64,    0,    0,   30,    0,    0,
    0,    0,    0,    0,   32,    0,    0,    0,    0,   33,
    0,   71,   72,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,   74,    0,
    0,   38,    0,    0,   76,    0,   78,    0,   80,   39,
   40,  254,    0,   41,    0,    0,    0,    0,    0,    0,
   86,    0,    0,   87,   88,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   89,   90,
   91,   92,   93,    0,    0,    0,    0,    0,    0,    0,
   95,    0,    0,    0,    0,    0,   97,   98,   99,  100,
    0,    0,    0,  101,    0,  102,    0,    0,    0,    0,
    0,  103,  104,    0,    0,    0,    0,    0,    0,   77,
   77,    0,   77,    0,    0,   77,   77,    0,    0,    0,
   77,   77,   77,    0,   77,    0,  105, 1044,  107,  108,
   77,    0,    0,   77,    0,    0,    0,    0,    0,    0,
   77,    0,    0,    0,    0,   77,    0,   77,   77,   77,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   77,    0,   77,   77,    0,    0,   77,    0,    0,
   77,    0,   77,    0,   77,   77,   77,   77,    0,   77,
    0,    0,    0,    0,    0,    0,   77,    0,    0,   77,
   77,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   77,   77,   77,   77,   77,    0,
    0,    0,    0,    0,    0,    0,   77,    0,    0,    0,
    0,    0,   77,   77,   77,   77,    0,    0,    0,   77,
    0,   77,    0,    0,    0,    0,    0,   77,   77,    0,
    0,    0,    0,    0,    0,  135,  135,    0,  135,    0,
    0,  135,  135,    0,    0,    0,  135,  135,  135,    0,
  135,    0,   77,   77,   77,   77,  135,    0,    0,  135,
    0,    0,    0,    0,    0,    0,  135,    0,    0,    0,
    0,  135,    0,  135,  135,  135,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  135,    0,  135,
  135,    0,    0,  135,    0,    0,  135,    0,  135,    0,
  135,  135,  135,  135,    0,  135,    0,    0,    0,    0,
    0,    0,  135,    0,    0,  135,  135,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  135,  135,  135,  135,  135,    0,    0,    0,    0,    0,
    0,    0,  135,    0,    0,    0,    0,    0,  135,  135,
  135,  135,    0,    0,    0,  135,    0,  135,    0,    0,
    0,    0,    0,  135,  135,    0,    0,    0,    0,    0,
    0,   56,   24,    0,   25,    0,    0,   26,  253,    0,
    0,    0,   27,   61,   62,    0,   28,    0,  135,  135,
  135,  135,   64,    0,    0,   30,    0,    0,    0,    0,
    0,    0,   32,    0,   27,    0,   27,   33,    0,   71,
   72,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   36,    0,   37,   74,   27,    0,   38,
    0,    0,   76,    0,   78,    0,   80,   39,   40,  254,
   27,   41,    0,    0,    0,   27,    0,    0,    0,    0,
   27,    0,   27,   27,   27,   27,    0,    0,    0,    0,
   27,    0,    0,    0,   27,    0,   89,   90,   91,  255,
  301,    0,    0,    0,    0,    0,   27,    0,   95,   27,
    0,   27,    0,    0,   97,   98,   99,  100,    0,    0,
    0,  101,    0,  102,    0,    0,    0,    0,    0,  103,
  104,    0,    0,    0,    0,   27,    0,    0,    0,    0,
    0,   27,   27,    0,    0,    0,    0,    0,    0,  643,
    0,  643,    0,  643,  105,  256,  643,  108,  643,  643,
    0,  643,    0,  643,    0,  643,    0,  643,  643,  643,
    0,    0,    0,  643,  643,    0,    0,    0,    0,  643,
    0,  643,  643,    0,    0,    0,  643,    0,    0,    0,
  643,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  643,  643,    0,  643,    0,    0,    0,  643,  643,
    0,    0,    0,    0,    0,    0,  643,  643,   56,   24,
  643,   25,    0,  643,   26,  253,    0,    0,  643,   27,
   61,   62,    0,   28,    0,    0,    0,    0,    0,   64,
    0,    0,   30,    0,    0,    0,    0,    0,    0,   32,
  643,  643,    0,    0,   33,    0,   71,   72,   34,    0,
    0,    0,    0,  643,    0,    0,    0,    0,    0,    0,
   36,    0,   37,   74,    0,    0,   38,    0,    0,   76,
    0,   78,    0,   80,   39,   40,  254,    0,   41,    0,
    0,   84,    0,    0,    0,    0,    0,    0,   24,    0,
   25,    0,    0,   26,  643, 1235,    0,    0,   27,    0,
    0,    0,   28,   89,   90,   91,  255,    0,    0,    0,
    0,   30,  642,    0,  642,   95,    0,  642,   32,  642,
  642,    0,  642,   33,  642, 1236,  642,   34,  642,  642,
  642,    0,    0,    0,  642,  642,    0,    0,    0,   36,
  642,   37,  642,  642,    0,   38, 1237,  642,    0,    0,
    0,  642,    0,   39,   40,    0,    0,   41,    0,    0,
  322,  105,  256,  642,    0,  642,    0,    0,    0,  642,
  642,    0,    0,    0,    0,    0,    0,  642,  642,    0,
  642,  642,  642,    0,  642,  642,    0,  642,  642,  642,
  642,    0,  642,    0,  642,    0,  642,  642,  642,    0,
    0,    0,  642,  642,    0,    0,    0,    0,  642,    0,
  642,  642,    0,    0,    0,  642,    0,    0,    0,  642,
    0,    0,    0,    0,  642,    0,    0,    0,    0,    0,
    0,  642,    0,  642,    0,    0,    0,  642,  642,    0,
    0,  355,    0,    0,    0,  642,  642,    0,    0,  642,
    0,    0,  642,    0,   24,    0,   25,  642,    0,   26,
    0,    0, 1295,    0,   27,  642,  686,    0,   28,    0,
  687, 1296, 1297,    0,    0,    0, 1298,   30,    0,    0,
    0,    0, 1299,    0,   32,    0,   24,    0,   25,   33,
    0,   26,    0,   34, 1295,    0,   27,    0,  686,    0,
   28,    0,  687, 1296, 1297,   36,    0,   37, 1298,   30,
    0,   38,    0,    0, 1299,    0,   32,    0,    0,   39,
   40,   33,    0,   41,    0,   34, 1300,    0,    0,    0,
   47, 1301,   47,  642,    0,   47,    0,   36,    0,   37,
   47,    0,    0,   38,   47,    0,    0,    0,    0,    0,
    0,   39,   40,   47,    0,   41,    0,    0, 1300,    0,
   47,    0,   47, 1301,   47,   47, 1302,   47,    0,   47,
    0,   47,   47,   47,    0,    0,   47,    0,   47,    0,
    0,   47,    0,   47,    0,   47,    0,   47,    0,    0,
   47,    0,   47,    0,    0,   47,   47,   47,    0,   47,
    0,   47,   47,   47,    0,   47,   48, 1303,   48,    0,
   47,   48,    0,   47,    0,   47,   48,    0,    0,   47,
   48,    0,   47,    0,    0,    0,    0,   47,   47,   48,
    0,   47,    0,    0,   47,    0,   48,  154,   47, 1303,
   47,   48,    0,   47,    0,   48,    0,   48,   47,   48,
    0,    0,   47,    0,   48,    0,    0,   48,    0,   48,
    0,   47,    0,   48,    0,    0,   48,  154,   47,    0,
    0,   48,   48,   47,    0,   48,    0,   47,   48,   47,
    0,   47,   24,   47,   25,    0,   47,   26,    0,   47,
    0,   47,   27,    0,    0,   47,   28,    0,   47,    0,
    0,    0,    0,   47,   47,   30,    0,   47,    0,    0,
   47,    0,   32,    0,    0,   47,    0,   33,    0,    0,
    0,   34,    0,  570,    0,    0,    0,   24,    0,   25,
  571,    0,   26,   36,    0,   37,    0,   27,    0,   38,
    0,   28,  572,    0,    0,   29,    0,   39,   40,    0,
   30,   41,    0,    0,  573,   31,    0,   32,    0,   48,
    0,    0,   33,    0,    0,   33,   34,   35,    0,    0,
    0,    0,    0,    0,    0,    0,   33,    0,   36,    0,
   37,   33,    0,    0,   38,   33,    0,    0,   33,    0,
    0,   47,   39,   40,    0,    0,   41,    0,    0,    0,
   33,   33,    0,    0,    0,   33,   33,    0,    0,    0,
    0,   33,    0,   33,   33,   33,   33,    0,    0,    0,
    0,   33,    0,    0,    0,   33,    0,   33,    0,    0,
    0,    0,    0,    0,    0,  574,    0,   33,    0,   33,
   33,   31,   33,    0,    0,    0,   33,    0,    0,    0,
    0,    0,   31,    0,    0,    0,    0,   31,    0,    0,
    0,   31,    0,    0,   31,    0,   33,    0,    0,    0,
    0,    0,   33,   33,    0,    0,   31,   31,    0,    0,
   42,   31,   31,    0,   47,    0,    0,   31,    0,   31,
   31,   31,   31,    0,    0,   47,    0,   31,    0,    0,
   47,   31,    0,   31,   47,    0,    0,   47,    0,    0,
    0,    0,    0,   31,    0,    0,   31,    0,   31,   47,
   47,    0,   31,    0,   47,   47,    0,   47,    0,    0,
   47,    0,   47,   47,   47,   47,    0,    0,   47,    0,
   47,    0,   31,   47,   47,    0,   47,   47,   31,   31,
   47,    0,    0,    0,    0,    0,   47,    0,    0,   47,
    0,   47,   47,   47,    0,   47,    0,   47,   47,   47,
    0,    0,    0,   47,    0,   47,   47,   47,   47,    0,
    0,    0,    0,   47,    0,   47,    0,   47,    0,   47,
    0,   35,   47,    0,    0,    0,    0,    0,    0,   47,
    0,    0,   47,    0,   47,   47,    0,   47,   47,    0,
   47,    0,    0,    0,    0,   47,    0,   47,   47,   47,
   47,    0,    0,    0,    0,   47,    0,    0,   47,   47,
   47,    0,    0,    0,   36,    0,    0,    0,    0,    0,
    0,   47,    0,   47,   47,   47,   47,    0,   47,    0,
    0,    0,    0,   47,    0,   47,   47,   47,   47,    0,
    0,    0,    0,   47,    0,    0,    0,   47,   47,    0,
   47,    0,   47,   47,    0,    0,  196,    0,    0,   47,
    0,   47,   47,   47,   47,   47,   47,    0,    0,    0,
    0,   47,    0,   47,   47,   47,   47,    0,    0,   47,
    0,   47,    0,    0,    0,   47,   47,    0,   47,    0,
   47,   47,    0,    0,  198,    0,    0,   47,    0,   47,
   47,   47,   47,    0,   47,    0,    0,    0,    0,   47,
    0,   47,   47,   47,   47,    0,    0,    0,    0,   47,
    0,    0,    0,   47,   47,    0,   47,    0,    0,    0,
    0,   47,  299,   47,    0,   47,    0,   47,   47,    0,
   47,    0,   47,    0,    0,    0,    0,   47,    0,   47,
   47,   47,   47,    0,   47,    0,    0,   47,    0,    0,
    0,   47,    0,    0,   47,    0,    0,   47,    0,    0,
  300,  452,   47,   47,    0,    0,   47,   47,   47,   47,
   47,   47,   47,    0,    0,   47,    0,   47,    0,    0,
    0,   47,    0,    0,  453,    0,    0,    0,    0,    0,
    0,  452,   47,   47,   47,   47,   47,  454,   47,    0,
    0,  455,  456,    0,    0,    0,    0,  457,    0,  458,
  459,  460,  461,    0,  453,    0,    0,  462,    0,    0,
    0,  463,   47,    0,    0,    0,    0,  454,    0,    0,
    0,    0,  456,  464,    0,    0,  465,  457,  466,  458,
  459,  460,  461,    0,    0,    0,    0,  462,    0,    0,
    0,  463,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  467,  464,    0,    0,  465,    0,  466,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  467,
  };
  protected static readonly short [] yyCheck = {            17,
  515,   18,   51,   17,  298,    4,    6,   51,  189,  234,
  469,   17,  299,   17,  288,  517,  232,  191,  354,  188,
  247,   68,  321,   20,  559,  339,   17,   84,   59,  491,
  157,  297,  354,  645,  646,  332,  370,  937,  295, 1113,
   87,   88,   87,   88,   58,   92,  721,  576,  723,   77,
  585,   59, 1148, 1149,  748,   73,  113,    0,  115,   77,
  277,  256,  328,  108,  256,   79,  781,   81,   59,  256,
 1242,  256,   63,  113,  256,  115,  256,   95,  942,  256,
  335,  256,  368,  256,   17,  268,   17, 1259,  256,  256,
   17,  256,  256,  768,  256,  268,  771,  282,  368,  256,
  368,  256, 1145, 1199,  256,  374,  256,  341,  376,  269,
   47,  391,  401,  414,  268,   17,  256,  891,  370, 1447,
 1448,   21,  374,  418,  413,  172,  286,  428,  902,  314,
  268, 1108,  418,  428,  414,  369,  665,  256,  276,  157,
  189,   17,  369,  157,  410,  189,  363,  416,  418,  323,
  256,  157,   52,  157,  199,  200,  343,  339,   17,  256,
 1203,  429,  344,  340,  346,   17,  157,  349,  350,  256,
  352,  353,   17,   17,  429,  256, 1504, 1198,  790,   17,
  372,  355,  374,  232,  339,  368,  360,   17,  232,  344,
  358,  346,  374,  256,  349,  350,  532,  352,  353, 1220,
  247,  418,  419,  256,  391, 1069,  363,  819,  256,  434,
  256,  258,  376,  375,  511,  256,  261,  433,  554,  374,
  514,  256,  724,  418,  157,  363,  157,  414,  228,  247,
  157,  381,  554,  418,  252,  375,    0,  429,  418,  422,
  576,  428,  287,  418,    0,  559, 1418,  429,  367,  422,
  369,  418,  371,  418,  285,  157,  424,  425,  426,  427,
  256,  418,  307,  320,  295,  439,  418,  324,  422,  375,
  288,  585,  329, 1445,  429,  293,  294,  285,  375,  326,
  418,  157,  369,  294,  331, 1457,  223, 1459, 1309,  329,
  308,  256, 1313,  374,  285,  306,  256,  315,  157,  317,
  474,  420,  316,  321,  423,  157,  351,  257,  256,  317,
  256, 1026,  157,  157,  257,  333,  334, 1338,  381,  157,
  372,  369,  369,  370,  999,  371,  317,  157,  381,  665,
  358,  372,  944,  339,  946,  339,  256,  949, 1412,  374,
  358,  870,  387,  388,  666,  262,  256,  256,  339, 1043,
  686,  369,  370,  256,  418,  373,  374,  375,  376,  377,
  378,  379,  380,  381,  382,  383,  418,  363,  415,  416,
  415,  416,  419, 1350,  370,  256,  372, 1092,  374,  371,
  368,  298, 1478,  256,  433,  256,  367,  405,  376,  433,
  256,  256,  256,  325,  443,  376,  266,  325, 1298,  256,
  574,  903, 1379, 1380,  374, 1382,  913,  418,  368,  374,
  709,  368, 1508,  587,  374,  589, 1393,  591,  266, 1396,
  882,  367,  418, 1035,  372, 1037, 1038,   61,  420,  358,
  376,   65,   66,   67, 1411,   69,   70,  662,  435,  483,
   74,   75,  335,  490,  314,  492,  416,   81, 1123,   83,
  370,   85,  449,  372,  374, 1130,   90,   91, 1435,  795,
  370,  378,  379,  372,  374,  368,  314,  694,  515,  726,
  484,  374,  429,  795,  277,  343,  701,  811,  281, 1154,
  114,  368,  656,  491,  341,  532,  418,  257,  369,  536,
  418,  993,  256,  343,  372,  513,  369,  515,  369,  517,
  491,  257,  676,  440,  441,  375,  372,  372,  372,  446,
  429, 1018,  369, 1020,  528,  529,  272,  372,  263,  368,
  256,  277, 1134,  391,  542,  281,  256,  375,  575,  547,
  363,  381,  368,  256,  870,  532, 1211,  363,  272,  342,
  296,  391,  429,  368,  368,  372,  414,  869,  305,  256,
  343,  429,  566,  559, 1166,  559,  339,  264,  363,  363,
  428,  363,  296,  373,  414,  369,  376,  323,  559,  305,
  315,   20,  256,  867,  429,  339,  594,  595,  428,  585,
  429,  585,  305,  369,  367,  418,  342,  256,  381,  323,
  817,  272,  418,  429,  585,  642,  277,  644,  391,  896,
  281, 1213,  429,  367,  429,  429,  653,  371,  735,  373,
  374,  375,  376,  418,  418,  296,  418,  381,  325, 1231,
  254,  414,  640,  257, 1159,  376,  306,  645,  646,  256,
  648,  305,  369,  313,  900,  428,  373,  367,   87,   88,
  263,  371,  323,  373,  374,  367,  376,  694,  363,  371,
  937,  381, 1226,  414,  369,  339, 1226,  398,  399,  108,
  344,  342,  346,  297,  711,  349,  350,  428,  352,  353,
  339,  994, 1226,  394,  395,  344,  694,  346,  429,  313,
  349,  350,  256,  352,  353,  415,  423,  687,  371,  357,
  373,  709,  315, 1155,  376,  726, 1270,  996,  420, 1022,
 1270,  369,  759,  418,  372,  373,  724,  339,  753,  392,
  393,  729,  339,  294, 1008,  762, 1270,  344,  386,  346,
  294,  391,  349,  350,  272,  352,  353,  256,  272,  412,
  721,  776,  723,  376,  961,  367, 1316,  420,  912,  256,
  423,  755, 1225, 1226,  414,  429,  791,  794,  296, 1329,
  199,  200,  296,  421, 1226,  773, 1226,  775,  428,  306,
  429,  308, 1245, 1226,  811,  779,  313,  781, 1348,  371,
  817,  256,  790,  418,  294,  323,  357,  768,  325,  323,
  771, 1226,  363,  428,  953,  357,  306, 1270,  369, 1272,
 1226,  372,  373,  811,  373,  844,  369,  376, 1270,  817,
 1270,  819,  429,  821,  386,  386, 1080, 1270,  381,  371,
  339,  373,  261, 1127,  386,  344,  339,  346,  381, 1113,
  349,  350,  339,  352,  353, 1270,  871,  344,  391,  346,
  874,  381,  349,  350, 1270,  352,  353,  418,  287,  256,
  421,  391, 1116, 1017,  367, 1159,  256,  865,  367,  867,
  299,  414,  486,  376,  418,  852,  306,  857,  307,  269,
  907,  357,  909,  313,  414,  428,  884,  374,  915,  376,
 1329,  371,  367,  891,  381,  325,  286,  373, 1152, 1106,
 1194,  376,  367,  901,  373,  903,  371,  376,  373,  374,
  386,  376,  367,  940,  528,  357,  381,  256, 1400,  367,
  429,  376,  351,  370,  368,  354,  384,  374,  376,  367,
  374,  373,  429,  371,  961,  373,  374,  381,  376,  354,
  355,  966,  339,  381,  386,  256,  944,  344,  946,  346,
  977,  949,  349,  350,  368,  352,  353,  367,  387,  388,
  382,  383,  376,  961, 1280,  371,  376,  373, 1173,  367,
  368, 1287,    6, 1169,  396,  397,  389,  415,  376, 1233,
 1462,  958, 1143,   17,  385,  370,  415,  416,  968,  374,
  970,  368,  972,  357,  371,  993,  373,  374,  996,  372,
  339,  374,  369,  376,  370,  344,  435,  346,  374,  373,
  349,  350,  400,  352,  353,  392,  393, 1499,  390,  370,
  449,  372,  386,  374,  418,   59, 1521, 1522,  999,   63,
  368, 1298, 1026,  415,  372,  412,  374, 1035,  376, 1037,
 1038,  368, 1040,  420,  368,  372,  423,  374,  372,  376,
  367,  368,  376,   87,   88,  371,  367,  368,  369,  376,
  371,  372,  368,  374,  369,  376,  418,  372,  374,  256,
  376, 1050,  370,  371,  108,  373,  374,  375,  418, 1106,
  368,  277, 1080,  371, 1108,  373,  374,  370,  371,  370,
  429,  374,  367,  374,  369,  372, 1094, 1095, 1092,  376,
  368,  369,  372,  532,  392,  393,  376,  418, 1106,  420,
 1107,  376,  423,  372, 1143, 1113, 1145,  376, 1116, 1143,
  372, 1145,  374,  157,  412,  554,  370,  372,  372,  376,
  374,  376,  420,  354,  355,  423, 1134,  372, 1412,  374,
 1169, 1127, 1140, 1127,  370, 1169,  372,  576,  370, 1303,
  372,  374, 1123,  376, 1152,  370, 1127,  372,  367, 1130,
  393,  394,  395,  396,  256,  199,  200,  294, 1166, 1167,
  367,  368, 1326, 1159, 1203, 1159,  368,  369,  357, 1203,
  386,  387,  388, 1154,  363,  370, 1340,  372, 1159,  372,
  369,  374,  373,  372,  373,  374, 1225, 1226,  372, 1224,
  374, 1225,  343,  370, 1358,  372, 1360,  386, 1194,  370,
 1194,  372,  374,  376,  376, 1213, 1245,  374,  374,  376,
  376, 1245,  374, 1194,  376,  376,  261,  261,  414,  415,
  364,  365,  294, 1231,  372, 1233,  665,  372,  373,  418,
 1211, 1270,  414, 1272,  364,  365, 1273,  418, 1272,  284,
  356,  285,  376,  287, 1279,  391,  392,  686,  418, 1111,
 1112,  369,  297,  389,  390,  299,  375,  302,  397,  398,
 1295, 1296,  307,  307,  309,  310,  311,  312,  418,  372,
  376,  372,  317,  317,  368,  374,  321,  372,  294, 1283,
  325,  372,  294, 1318,  374,  372, 1321,  372,  333,  372,
  374,  336,   93,  338,  256,  339,   97,   98,   99,  100,
  101,  102,  103,  104,  371,  376,  256,  351,  294,  294,
  354,  381,  372,  374,  753,  373, 1350,  362,  375,  374,
  373,  418,  381,  372,  374,  429,  374,  374,  374,  372,
 1334,  423,  374,  374,  367,  421,  372,  776,  373,  343,
  372,  294,  294,  387,  388, 1379, 1380,  374, 1382,  374,
    0, 1390,  791,  418,  371,  370,  795,  367,  256, 1393,
  256,  375, 1396,  374,  418,  256,  261,  256, 1407,  280,
  256,  415,  416,  418,  381,  367,  372, 1411,  368,  343,
  351, 1420, 1421,  370,  423,  376,  374,  371,  381,  284,
  372,  374, 1400,  370, 1398,  376,  372,  372,  347,  367,
  256, 1435,  297,  381, 1412,  256,  372,  302, 1447, 1448,
  305,  381,  307,  852,  309,  310,  311,  312,  372,    0,
  376, 1429,  317,  368,  347,  339,  321,  370,  374,  370,
  325,  870,  871,  375,  381,  370,  372,  368,  333,  348,
  374,  336,  372,  338,  418,  418,  348,  491,  376,  256,
  368,  367,  256,  368, 1462,  402,  403,  404,  405,  406,
  407,  408,  409,  410,  411, 1504,  367,  362,  367,  381,
  376,  356,  372,  337,  371,  368,  368,  305,  368,  418,
  374,  418,  369,  371, 1521, 1522,  418,  367,  532,  418,
  371, 1499,  418,  376,  371,  371,  371,  381,  937,  373,
  301, 1505, 1506,  371,  367,  371,  373,  369, 1512, 1513,
  554,  381,  372, 1521, 1522,  559,  374,  372,  256,  958,
  373,  367,    0,  418,  374,  374,  374,  966,  372,  376,
  372,  332,  576,  370,  368,  339,  418,  376,  376,  418,
  344,  585,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,  418,  372,  376,  372,  418,  381,  372,
  370,  381,  368,  372,  368,  315,  370,  263,  372,  371,
  374,  375,  376,  371,  368,  372,  372,    0,    0,  367,
  372,  376,  368,  384,  385,  386,  390,  376,  389,  390,
  391,  392,  393,  394,  395,  396,  397,  398,  399,  400,
  401,  402,  403,  404,    0,  368,  372,  257,  372,  370,
  418,  261,  367,  372,    0,  368,  368,  373,  372,  370,
  367,  665,  272,  368,  372,  429,  368,  277,  418,  372,
  376,  281,  376,  418,  284,  376,  372,  376,  368,  367,
  372,  368,  686,  372,  368,  376,  296,  297,  367,  315,
  376,  301,  302,  376,  376,  376,  376,  307,  376,  309,
  310,  311,  312,  376,  376,  263,   50,  317,   12,    5,
  958,  321,  852,  323, 1272, 1106,  257,  721, 1106,  723,
  261, 1452, 1415,  333, 1245,  335,  336,  686,  338, 1468,
 1432,  272,  342, 1403, 1398, 1304,  277,  700,  874,  874,
  281,  869, 1316,  284, 1513,  874, 1335, 1146, 1258,  753,
  511, 1270,  362, 1421, 1420,  296,  297, 1507,  368,  369,
  301,  302, 1425, 1203,  768, 1506,  307,  771,  309,  310,
  311,  312,  776, 1360, 1304,  844,  317,  896, 1205,  265,
  321,  267,  323,  817,  270,  532,  369,  791, 1008,  275,
  729,  795,  333,  279,  335,  336,  694,  338,   71,  595,
  335,  342,  288,  726,  399,  401, 1205,  400,  402,  295,
  554,  403,  795,  404,  300, 1279, 1194, 1183,  304,  257,
  581,  362, 1127,  261,  157, 1224,  995, 1071,  369, 1095,
  316,  979,  318, 1022,  272, 1085,  322,    0, 1155,  277,
 1083, 1275,  917,  281,  330,  331,  284,  424,  334,  424,
  651,  337, 1167,  530,   -1,   -1,  850,   -1,  296,  297,
  849,   -1,   -1,  301,  302,   -1,  870,  871,   -1,  307,
   -1,  309,  310,  311,  312,   -1,   -1,  363,   -1,  317,
 1279, 1280,   -1,  321,   -1,  323,   -1,   -1, 1287,   -1,
   -1,   -1,   -1,   -1,   -1,  333, 1295, 1296,  336, 1298,
  338,   -1,   -1,   -1,  342, 1304,   -1,   -1,   -1,   -1,
  256,   -1,   -1,   -1,   -1,  261,  262, 1316,   -1, 1318,
   -1,   -1, 1321,   -1,  362,   -1,   -1,   -1,   -1,   -1,
 1329,  369,  418,  937,   -1,   -1,   -1,   -1,  284,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 1348,
   -1,  297,  298,   -1,   -1,   -1,  302,   -1,   -1,  305,
   -1,  307,  966,  309,  310,  311,  312,   -1,   -1,   -1,
   -1,  317,   -1,   -1,   -1,  321,   -1,   -1,   -1,  325,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,
  336,   -1,  338,  339,   -1,  999,   -1,   -1,  344,   -1,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,   -1,   -1,  362,  363,   -1,   -1,
   -1,  367,  368,   -1,  370,  371,  372,  373,  374,  375,
  376,    0,  378,  379,   -1,  381,  382,  383,  384,  385,
  386,  387,  388,  389,  390,   -1,  392,  393,  394,  395,
  396,  397,  398,  399,  400,  401,  402,  403,  404,  405,
  406,  407,  408,  409,  410,  411,  412,  413,   -1,   -1,
  416,   -1,  418,   -1,  420,   -1,   -1,  423,   -1,   -1,
   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  257,   -1,   -1,   -1,  261,   -1,
   -1,  256,   -1,   -1,   -1,   -1,   -1,  262,   -1,  272,
   -1,   -1,   -1,   -1,  277,   -1,   -1,   -1,  281, 1123,
   -1,  284,   -1, 1127,   -1,   -1, 1130,   -1,   -1,   -1,
   -1,   -1,   -1,  296,  297,  896,   -1,   -1,  301,  302,
   -1,   -1, 1146,  298,  307,   -1,  309,  310,  311,  312,
 1154,   -1,   -1,   -1,  317, 1159,   -1,   -1,  321,   -1,
  323,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  333,   -1,   -1,  336,   -1,  338,   -1,   -1,   -1,  342,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
 1194,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,  362,
   -1, 1205,   -1,   -1,   -1,  368,  369, 1211,  363,   -1,
   -1,   -1,   -1,  368,  369,   -1,  371,  372,  373,  374,
 1224,  376,   -1,  378,  379,   -1,  381,  382,  383,  384,
  385,   -1,  387,  388,  389,  390,   -1,  392,  393,  394,
  395,  396,  397,  398,  399,  400,  401,  402,  403,  404,
  405,  406,  407,  408,  409,  410,  411,  412,  413,   -1,
   -1,   -1,   -1,  418,   -1,  420,   -1,   -1,  423,   -1,
   -1,   -1,   -1,   -1,  429, 1279, 1280,   -1,   -1,   -1,
   -1,   -1,   -1, 1287,   -1,   -1,   -1,  256,  257,   -1,
   -1, 1295, 1296,   -1, 1298,  264,  265,  266,  267,  268,
   -1,  270,  271,   -1,  273,  274,  275,  276,  277,  278,
  279,  280,   -1,   -1, 1318,   -1,  285, 1321,  287,  288,
  289,  290,  291,  292,    0,   -1,  295,   -1,   -1,   -1,
  299,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  314,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,  324,  325,  326,  327,  328,
  329,  330,  331,  332,  333,  334,  335,   -1,  337,   -1,
   -1,  340,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,  367,  368,
   -1,   -1,  371,   -1,   -1,   -1,   -1,  376,  377,  378,
  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,
   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  417,  418,
  419,  420,   -1,  422,  256,  257,   -1,   -1,   -1,   -1,
  429,   -1,  264,  265,  266,  267,  268,   -1,  270,  271,
    0,  273,  274,  275,  276,  277,  278,  279,   -1,   -1,
   -1,   -1,   -1,  285,   -1,  287,  288,  289,  290,  291,
  292,   -1,   -1,  295,   -1,   -1,   -1,  299,  300,   -1,
  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  314,   -1,  316,   -1,  318,  319,   -1,   -1,
  322,   -1,  324,  325,  326,  327,  328,  329,  330,  331,
  332,  333,  334,  335,   -1,  337,   -1,   -1,  340,  341,
   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,
  362,  363,   -1,   -1,   -1,  367,  368,   -1,   -1,  371,
   -1,   -1,   -1,   -1,  376,  377,  378,  379,  380,   -1,
  256,   -1,  384,   -1,  386,  261,  262,   -1,   -1,   -1,
  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,
   -1,   -1,   -1,   -1,   -1,  417,  418,  419,  420,   -1,
  422,  297,  298,   -1,   -1,   -1,  302,  429,   -1,  305,
   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,
   -1,  317,   -1,   -1,   -1,  321,   -1,   -1,   -1,  325,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,
  336,   -1,  338,  339,   -1,   -1,   -1,   -1,  344,   -1,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,  357,   -1,   -1,   -1,   -1,  362,  363,   -1,   -1,
   -1,  367,  368,  369,  370,  371,  372,  373,  374,  375,
  376,   -1,  378,  379,   -1,   -1,  382,  383,  384,  385,
  386,   -1,   -1,  389,  390,   -1,   -1,   -1,  394,  395,
  396,  397,  398,  399,  400,  401,  256,   -1,   -1,   -1,
    0,  261,  262,   -1,   -1,   -1,   -1,  413,   -1,   -1,
  416,   -1,  418,   -1,  420,   -1,   -1,  423,   -1,   -1,
   -1,   -1,   -1,  429,  284,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  297,  298,   -1,
   -1,   -1,  302,   -1,   -1,  305,   -1,  307,   -1,  309,
  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,
   -1,  321,   -1,   -1,   -1,  325,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,  339,
   -1,   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,   -1,  362,  363,    0,   -1,   -1,  367,  368,  369,
  370,  371,  372,   -1,  374,  375,  376,   -1,  378,  379,
   -1,   -1,  382,  383,  384,  385,  256,   -1,   -1,  389,
  390,  261,  262,   -1,  394,  395,  396,  397,  398,  399,
  400,  401,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  413,  284,   -1,  416,   -1,  418,   -1,
  420,   -1,   -1,  423,   -1,   -1,   -1,  297,  298,  429,
   -1,   -1,  302,   -1,   -1,  305,   -1,  307,   -1,  309,
  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,
   -1,  321,   -1,   -1,   -1,  325,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,  339,
   -1,   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,   -1,  362,  363,   -1,   -1,   -1,  367,  368,  369,
  370,  371,  372,   -1,  374,  375,  376,   -1,  378,  379,
    0,   -1,  382,  383,  384,  385,  256,   -1,   -1,  389,
  390,  261,  262,   -1,  394,  395,  396,  397,  398,  399,
  400,  401,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  413,  284,   -1,  416,   -1,  418,   -1,
  420,   -1,   -1,  423,   -1,   -1,   -1,  297,  298,  429,
   -1,   -1,  302,   -1,   -1,  305,   -1,  307,   -1,  309,
  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,
   -1,  321,   -1,   -1,   -1,  325,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,  339,
   -1,   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
  256,   -1,  362,  363,   -1,   -1,  262,  367,  368,   -1,
  370,  371,  372,   -1,  374,  375,  376,   -1,  378,  379,
   -1,   -1,  382,  383,  384,  385,   -1,   -1,   -1,  389,
  390,   -1,   -1,   -1,  394,  395,  396,  397,  398,  399,
  400,  401,  298,   -1,   -1,   -1,   -1,   -1,    0,   -1,
   -1,   -1,   -1,  413,   -1,   -1,  416,   -1,  418,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  429,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,  357,   -1,   -1,  256,   -1,   -1,  363,   -1,   -1,
   -1,  367,  368,  369,  370,  371,  372,  373,  374,  375,
  376,   -1,  378,  379,   -1,   -1,  382,  383,  384,  385,
  386,    0,   -1,  389,  390,   -1,   -1,   -1,  394,  395,
  396,  397,  398,  399,  400,  401,  256,   -1,   -1,   -1,
   -1,   -1,  262,   -1,   -1,   -1,   -1,  413,   -1,   -1,
  416,   -1,  418,   -1,  420,   -1,   -1,  423,   -1,   -1,
   -1,   -1,   -1,  429,    0,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,  298,   -1,
   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  368,    0,  370,   -1,
  372,   -1,  374,  375,  376,   -1,   -1,   -1,   -1,  339,
   -1,   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,   -1,   -1,  363,   -1,   -1,   -1,  367,  368,   -1,
  370,  371,  372,   -1,  374,  375,  376,   -1,  378,  379,
   -1,   -1,  382,  383,  384,  385,   -1,  429,   -1,  389,
  390,   -1,   -1,   -1,  394,  395,  396,  397,  398,  399,
  400,  401,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,
   -1,   -1,   -1,  413,  256,  257,  416,   -1,  418,  261,
   -1,   -1,   -1,  265,   -1,  267,   -1,   -1,  270,  429,
  272,  273,   -1,  275,   -1,  277,   -1,  279,   -1,  281,
  282,  283,  284,   -1,   -1,  287,  288,   -1,   -1,   -1,
    0,  293,   -1,  295,  296,  297,   -1,   -1,  300,  301,
  302,   -1,  304,   -1,   -1,  307,   -1,  309,  310,  311,
  312,   -1,   -1,   -1,  316,  317,  318,   -1,   -1,  321,
  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,
   -1,  333,  334,    0,  336,  337,  338,   -1,  257,   -1,
  342,   -1,  261,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  272,   -1,   -1,   -1,   -1,  277,   -1,
  362,   -1,  281,   -1,   -1,  284,  368,  369,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  377,    0,  296,  297,   -1,
   -1,  257,  301,  302,   -1,  261,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,  272,   -1,  317,   -1,
   -1,  277,  321,   -1,  323,  281,   -1,   -1,  284,   -1,
   -1,   -1,   -1,   -1,  333,   -1,  418,  336,   -1,  338,
  296,  297,   -1,  342,  257,  301,  302,   -1,  261,   -1,
   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,  272,
   -1,  317,   -1,  362,  277,  321,   -1,  323,  281,  368,
  369,  284,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,
  336,   -1,  338,  296,  297,   -1,  342,   -1,  301,  302,
   -1,   -1,   -1,   -1,  307,   -1,  309,  310,  311,  312,
   -1,   -1,   -1,   -1,  317,   -1,  362,   -1,  321,   -1,
  323,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  333,   -1,   -1,  336,  257,  338,   -1,   -1,  261,  342,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  272,
   -1,   -1,   -1,   -1,  277,   -1,   -1,   -1,  281,  362,
   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  296,  297,   -1,   -1,  257,  301,  302,
   -1,  261,   -1,   -1,  307,   -1,  309,  310,  311,  312,
   -1,   -1,  272,   -1,  317,   -1,   -1,  277,  321,   -1,
  323,  281,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,
  333,   -1,   -1,  336,   -1,  338,  296,  297,   -1,  342,
  257,  301,  302,   -1,  261,   -1,   -1,  307,   -1,  309,
  310,  311,  312,   -1,   -1,  272,   -1,  317,   -1,  362,
  277,  321,   -1,  323,  281,   -1,   -1,  284,   -1,   -1,
   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,  296,
  297,   -1,  342,  257,  301,  302,   -1,  261,   -1,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,  272,   -1,
  317,   -1,  362,  277,  321,   -1,  323,  281,   -1,   -1,
  284,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,
   -1,  338,  296,  297,   -1,  342,   -1,  301,  302,   -1,
   -1,   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,
   -1,   -1,   -1,  317,   -1,  362,   -1,  321,   -1,  323,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,
   -1,  256,  336,   -1,  338,   -1,   -1,   -1,  342,  264,
  265,  266,  267,   -1,   -1,  270,  271,   -1,  273,  274,
  275,  276,  277,  278,  279,   -1,   -1,   -1,  362,   -1,
  285,   -1,  287,  288,  289,  290,  291,  292,   -1,   -1,
  295,   -1,   -1,   -1,  299,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  314,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,  324,
  325,  326,  327,  328,  329,  330,  331,  332,  333,  334,
  335,   -1,  337,   -1,   -1,  340,  341,   -1,  256,  344,
  345,   -1,   -1,   -1,  262,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,  367,   -1,   -1,   -1,  371,   -1,   -1,   -1,
   -1,  376,  377,  378,  379,  380,   -1,   -1,   -1,  384,
  298,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,   -1,   -1,
  262,   -1,  417,  418,  419,  420,   -1,   -1,   -1,   -1,
   -1,  339,   -1,   -1,  429,   -1,  344,   -1,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,  357,
   -1,   -1,   -1,   -1,   -1,  363,  298,   -1,   -1,   -1,
  368,  369,  370,  371,  372,  373,  374,  375,  376,   -1,
  378,  379,   -1,  381,  382,  383,  384,  385,  386,  387,
  388,  389,  390,   -1,  392,  393,  394,  395,  396,  397,
  398,  399,  400,  401,  402,  403,  404,  405,  406,  407,
  408,  409,  410,  411,  412,  413,   -1,  256,   -1,   -1,
  418,   -1,  420,  262,   -1,  423,   -1,   -1,   -1,   -1,
   -1,  429,   -1,   -1,   -1,   -1,  368,   -1,   -1,  371,
   -1,  373,  374,   -1,   -1,   -1,  378,  379,   -1,   -1,
  382,  383,  384,  385,  386,  387,  388,  389,  390,  298,
  392,  393,  394,  395,  396,  397,  398,  399,  400,  401,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  412,  413,   -1,   -1,   -1,   -1,   -1,   -1,  420,   -1,
   -1,  423,   -1,   -1,   -1,   -1,   -1,  429,   -1,  285,
  339,   -1,   -1,   -1,   -1,  344,   -1,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  367,  368,
  369,  370,  371,  372,  373,  374,  375,  376,  256,  378,
  379,  327,  381,  382,  383,  384,  385,  386,  387,  388,
  389,  390,   -1,  392,  393,  394,  395,  396,  397,  398,
  399,  400,  401,  402,  403,  404,  405,  406,  407,  408,
  409,  410,  411,  412,  413,   -1,  256,   -1,   -1,   -1,
   -1,  420,  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  429,  377,  378,  379,  380,   -1,  382,  383,  384,  385,
  386,  387,  388,  389,   -1,   -1,  392,  393,  394,  395,
  396,  397,  398,  399,   -1,   -1,   -1,   -1,  298,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,  339,
   -1,   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  367,  368,   -1,
  370,  371,  372,  373,  374,  375,  376,   -1,  378,  379,
   -1,  381,  382,  383,  384,  385,  386,  387,  388,  389,
  390,  429,  392,  393,  394,  395,  396,  397,  398,  399,
  400,  401,  402,  403,  404,  405,  406,  407,  408,  409,
  410,  411,  412,  413,   -1,  256,  256,   -1,   -1,   -1,
  420,  262,   -1,  423,   -1,  265,   -1,  267,   -1,  429,
  270,   -1,   -1,   -1,   -1,  275,   -1,   -1,   -1,  279,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  288,   -1,
   -1,   -1,   -1,   -1,   -1,  295,   -1,  298,   -1,   -1,
  300,   -1,   -1,   -1,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,   -1,
   -1,   -1,  322,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  330,  331,   -1,   -1,  334,   -1,   -1,  337,  339,   -1,
   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  363,   -1,   -1,   -1,  368,   -1,  370,
  371,  372,  373,  374,  375,  376,   -1,  378,  379,   -1,
  381,  382,  383,  384,  385,  386,  387,  388,  389,  390,
   -1,  392,  393,  394,  395,  396,  397,  398,  399,  400,
  401,  402,  403,  404,  405,  406,  407,  408,  409,  410,
  411,  412,  413,   -1,  256,  256,   -1,   -1,  418,  420,
  262,   -1,  423,   -1,  265,   -1,  267,   -1,  429,  270,
   -1,   -1,   -1,   -1,  275,   -1,   -1,   -1,  279,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,   -1,  298,   -1,   -1,  300,
   -1,   -1,   -1,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,   -1,   -1,
   -1,  322,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  330,
  331,   -1,   -1,  334,   -1,   -1,  337,  339,   -1,   -1,
   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,  371,
  372,  373,  374,  375,  376,   -1,  378,  379,   -1,  381,
  382,  383,  384,  385,  386,  387,  388,  389,  390,   -1,
  392,  393,  394,  395,  396,  397,  398,  399,  400,  401,
  402,  403,  404,  405,  406,  407,  408,  409,  410,  411,
  412,  413,   -1,  256,  256,   -1,   -1,  418,  420,  262,
   -1,  423,   -1,  265,   -1,  267,   -1,  429,  270,   -1,
   -1,   -1,   -1,  275,   -1,   -1,   -1,  279,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  288,   -1,   -1,   -1,
   -1,   -1,   -1,  295,   -1,  298,   -1,   -1,  300,   -1,
   -1,   -1,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  316,   -1,  318,   -1,   -1,   -1,
  322,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,
   -1,   -1,  334,   -1,   -1,  337,  339,   -1,   -1,   -1,
   -1,  344,   -1,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,  371,  372,
  373,  374,  375,  376,   -1,  378,  379,   -1,  381,  382,
  383,  384,  385,  386,  387,  388,  389,  390,   -1,  392,
  393,  394,  395,  396,  397,  398,  399,  400,  401,  402,
  403,  404,  405,  406,  407,  408,  409,  410,  411,  412,
  413,   -1,  256,   -1,   -1,   -1,  418,  420,  262,  256,
  423,   -1,  266,   -1,   -1,   -1,  429,   -1,  265,   -1,
  267,   -1,   -1,  270,   -1,   -1,   -1,   -1,  275,   -1,
   -1,   -1,  279,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  288,   -1,   -1,  298,   -1,   -1,   -1,  295,   -1,
   -1,   -1,   -1,  300,   -1,   -1,   -1,  304,   -1,   -1,
  314,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,
   -1,  318,   -1,   -1,   -1,  322,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  330,  331,   -1,   -1,  334,   -1,   -1,
  337,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,   -1,
   -1,  262,   -1,  357,   -1,   -1,   -1,   -1,   -1,  363,
   -1,   -1,   -1,   -1,  368,  369,  370,  371,  372,  373,
  374,  375,  376,   -1,  378,  379,   -1,  381,  382,  383,
  384,  385,  386,  387,  388,  389,  390,  298,  392,  393,
  394,  395,  396,  397,  398,  399,  400,  401,  402,  403,
  404,  405,  406,  407,  408,  409,  410,  411,  412,  413,
   -1,   -1,   -1,   -1,  418,   -1,  420,   -1,   -1,  423,
   -1,  418,   -1,   -1,   -1,  429,   -1,   -1,  339,   -1,
   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,
   -1,  372,   -1,  374,  375,  376,   -1,  378,  379,   -1,
  381,  382,  383,  384,  385,  386,  387,  388,  389,  390,
  261,   -1,   -1,  394,  395,  396,  397,  398,  399,  400,
  401,  402,  403,  404,  405,  406,  407,  408,  409,  410,
  411,  256,  413,  284,   -1,   -1,   -1,  262,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  297,   -1,  429,   -1,
   -1,  302,   -1,   -1,  305,   -1,  307,   -1,  309,  310,
  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,
  321,   -1,   -1,  298,  325,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  333,   -1,   -1,  336,   -1,  338,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,
   -1,   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,   -1,
   -1,  362,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,
   -1,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  298,   -1,  368,   -1,  370,   -1,  372,   -1,  374,
  375,  376,   -1,  378,  379,   -1,   -1,  382,  383,  384,
  385,  386,  387,  388,  389,  390,   -1,  418,   -1,  394,
  395,  396,  397,  398,  399,  400,  401,   -1,   -1,   -1,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  413,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,  256,  429,   -1,   -1,   -1,   -1,  262,
   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,
   -1,  378,  379,   -1,   -1,  382,  383,  384,  385,   -1,
   -1,   -1,  389,  390,   -1,   -1,   -1,  394,  395,  396,
  397,  398,  399,  400,  401,  298,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  413,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  256,  429,   -1,   -1,   -1,   -1,  262,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,
   -1,  344,   -1,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  298,   -1,  368,   -1,  370,   -1,  372,
   -1,  374,  375,  376,   -1,  378,  379,   -1,   -1,  382,
  383,  384,  385,   -1,   -1,   -1,  389,  390,   -1,  256,
   -1,  394,  395,  396,  397,  398,  399,  400,  401,   -1,
   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,
  413,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,
   -1,   -1,   -1,  368,   -1,  370,   -1,  372,   -1,  374,
  375,  376,   -1,  378,  379,   -1,   -1,  382,  383,  384,
  385,   -1,   -1,   -1,  389,  390,   -1,  256,   -1,  394,
  395,  396,  397,  398,  399,  400,  401,   -1,   -1,   -1,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  413,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,
   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,
   -1,   -1,   -1,   -1,   -1,  382,  383,  384,  385,   -1,
   -1,   -1,  389,  390,   -1,  256,   -1,  394,  395,  396,
  397,  398,  399,  400,  401,   -1,   -1,   -1,   -1,   -1,
  339,   -1,   -1,   -1,   -1,  344,  413,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,
   -1,  370,   -1,  372,   -1,  374,  375,  376,   -1,   -1,
   -1,   -1,   -1,  382,  383,  384,  385,   -1,   -1,   -1,
  389,  390,   -1,  256,   -1,  394,  395,  396,  397,  398,
  399,  400,  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,
   -1,   -1,   -1,  344,  413,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,
  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,
   -1,  372,   -1,  374,  375,  376,   -1,   -1,   -1,   -1,
   -1,  382,  383,  384,  385,   -1,   -1,   -1,  389,  390,
   -1,  256,   -1,  394,  395,  396,  397,  398,  399,  400,
  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,
   -1,  344,  413,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,   -1,  429,   -1,
   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,  372,
   -1,  374,  375,  376,   -1,   -1,   -1,   -1,   -1,  382,
  383,  384,  385,   -1,   -1,   -1,  389,  390,   -1,  256,
   -1,   -1,   -1,  396,  397,  398,  399,  400,  401,   -1,
   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,
  413,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,
   -1,   -1,   -1,  368,   -1,  370,   -1,  372,   -1,  374,
  375,  376,   -1,   -1,   -1,   -1,   -1,  382,  383,  384,
  385,   -1,   -1,   -1,  389,  390,   -1,  256,   -1,   -1,
   -1,  396,  397,  398,  399,  400,  401,   -1,   -1,   -1,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  413,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,
   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,
   -1,   -1,   -1,   -1,   -1,  382,  383,  384,  385,   -1,
   -1,   -1,  389,  390,   -1,  256,   -1,   -1,   -1,  396,
  397,  398,  399,  400,  401,   -1,   -1,   -1,   -1,   -1,
  339,   -1,   -1,   -1,   -1,  344,  413,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,
   -1,  370,   -1,  372,   -1,  374,  375,  376,   -1,   -1,
   -1,   -1,   -1,  382,  383,  384,  385,   -1,   -1,   -1,
  389,  390,   -1,  256,   -1,   -1,   -1,  396,  397,  398,
  399,  400,  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,
   -1,   -1,   -1,  344,  413,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,
  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,
   -1,  372,   -1,  374,  375,  376,   -1,   -1,   -1,   -1,
   -1,  382,  383,  384,  385,   -1,   -1,   -1,  389,  390,
   -1,  256,   -1,   -1,   -1,  396,  397,  398,  399,  400,
  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,
   -1,  344,  413,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,   -1,  429,   -1,
   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,  372,
   -1,  374,  375,  376,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  384,  385,   -1,   -1,   -1,  389,  390,   -1,  256,
   -1,   -1,   -1,   -1,   -1,  398,  399,  400,  401,   -1,
   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,
  413,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,
   -1,   -1,   -1,  368,   -1,  370,   -1,  372,   -1,  374,
  375,  376,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  384,
  385,   -1,   -1,   -1,  389,  390,   -1,  256,   -1,   -1,
   -1,   -1,   -1,  398,  399,  400,  401,   -1,   -1,   -1,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  413,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,
   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  384,  385,   -1,
   -1,   -1,  389,  390,   -1,  256,   -1,   -1,   -1,   -1,
   -1,  398,  399,  400,  401,   -1,   -1,   -1,   -1,   -1,
  339,   -1,   -1,   -1,   -1,  344,  413,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,
   -1,  370,   -1,  372,   -1,  374,  375,  376,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  384,  385,   -1,   -1,   -1,
  389,  390,   -1,  256,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  400,  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,
   -1,   -1,   -1,  344,  413,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,
  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,
   -1,  372,   -1,  374,  375,  376,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  384,  385,   -1,   -1,   -1,  389,  390,
   -1,  256,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  400,
  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,
   -1,  344,  413,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,   -1,  429,   -1,
   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,  372,
   -1,  374,  375,  376,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  385,   -1,   -1,   -1,  389,  390,   -1,  256,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  400,  401,   -1,
   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,
  413,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,
   -1,   -1,   -1,  368,   -1,  370,   -1,  372,   -1,  374,
  375,  376,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  385,   -1,   -1,   -1,  389,  390,   -1,  256,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  400,  401,   -1,   -1,   -1,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  413,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,
   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  385,   -1,
   -1,   -1,   -1,  390,   -1,  256,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  400,  401,   -1,   -1,   -1,   -1,   -1,
  339,   -1,   -1,   -1,   -1,  344,  413,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,
   -1,  370,   -1,  372,   -1,  374,  375,  376,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  385,   -1,   -1,   -1,
   -1,  390,   -1,  256,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  400,  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,
   -1,   -1,   -1,  344,  413,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,
  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,
   -1,  372,   -1,  374,  375,  376,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  390,
   -1,  256,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  400,
  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,
   -1,  344,  413,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,   -1,  429,   -1,
   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,  372,
   -1,  374,  375,  376,   -1,   -1,   -1,  256,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  390,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  400,  401,   -1,
   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,
  413,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,
   -1,   -1,   -1,  368,   -1,  370,   -1,  372,   -1,  374,
  375,  376,   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,
  266,   -1,   -1,   -1,   -1,  390,   -1,   -1,   -1,   -1,
  339,   -1,   -1,   -1,   -1,  344,  401,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,  413,   -1,
   -1,   -1,  298,   -1,   -1,   -1,   -1,   -1,   -1,  368,
   -1,  370,   -1,  372,  429,  374,  375,  376,  314,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  390,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  401,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  413,   -1,   -1,   -1,   -1,   -1,
   -1,  357,   -1,   -1,   -1,   -1,   -1,  363,   -1,   -1,
  429,   -1,  368,  369,   -1,  371,   -1,  373,   -1,  375,
  376,   -1,  378,  379,   -1,  381,  382,  383,  384,  385,
  386,  387,  388,  389,  390,   -1,  392,  393,  394,  395,
  396,  397,  398,  399,  400,  401,  402,  403,  404,  405,
  406,  407,  408,  409,  410,  411,  412,  413,   -1,   -1,
  256,   -1,  418,   -1,  420,   -1,   -1,  423,  264,  265,
  266,  267,   -1,  429,  270,  271,   -1,  273,  274,  275,
  276,  277,  278,  279,   -1,   -1,   -1,   -1,   -1,  285,
   -1,  287,  288,  289,  290,  291,  292,   -1,   -1,  295,
   -1,   -1,   -1,  299,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  314,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,  324,  325,
  326,  327,  328,  329,  330,  331,  332,  333,  334,  335,
   -1,  337,   -1,   -1,  340,  341,   -1,   -1,  344,  345,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,
   -1,  367,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,
  376,  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,
  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,
   -1,  417,  418,  419,  420,  264,  265,  266,  267,   -1,
   -1,  270,  271,   -1,  273,  274,  275,  276,  277,  278,
  279,   -1,   -1,   -1,   -1,   -1,  285,   -1,  287,  288,
  289,  290,  291,  292,   -1,   -1,  295,   -1,   -1,   -1,
  299,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  314,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,  324,  325,  326,  327,  328,
  329,  330,  331,  332,  333,  334,  335,   -1,  337,   -1,
   -1,  340,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,  367,   -1,
   -1,   -1,  371,   -1,   -1,   -1,   -1,  376,  377,  378,
  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,
   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  417,  418,
  419,  420,  264,  265,  266,  267,   -1,   -1,  270,  271,
   -1,  273,  274,  275,  276,  277,  278,  279,   -1,   -1,
   -1,   -1,   -1,  285,   -1,  287,  288,  289,  290,  291,
  292,   -1,   -1,  295,   -1,   -1,   -1,  299,  300,   -1,
  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  314,   -1,  316,   -1,  318,  319,   -1,   -1,
  322,   -1,  324,  325,  326,  327,  328,  329,  330,  331,
  332,  333,  334,  335,   -1,  337,   -1,   -1,  340,  341,
   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,
  362,  363,   -1,   -1,   -1,  367,   -1,   -1,   -1,  371,
   -1,   -1,   -1,   -1,  376,  377,  378,  379,  380,   -1,
   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,
  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  256,   -1,   -1,   -1,  417,  418,  419,  420,  264,
  265,  266,  267,   -1,   -1,  270,  271,   -1,  273,  274,
  275,  276,  277,  278,  279,   -1,   -1,   -1,   -1,   -1,
  285,   -1,  287,  288,  289,  290,  291,  292,   -1,   -1,
  295,   -1,   -1,   -1,  299,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  314,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,  324,
  325,  326,  327,  328,  329,  330,  331,  332,  333,  334,
  335,   -1,  337,   -1,   -1,  340,  341,   -1,   -1,  344,
  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,  367,   -1,   -1,   -1,  371,   -1,   -1,   -1,
   -1,  376,  377,  378,  379,  380,   -1,   -1,   -1,  384,
   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,
   -1,   -1,  417,  418,  419,  420,  264,  265,  266,  267,
   -1,   -1,  270,  271,   -1,  273,  274,  275,  276,  277,
  278,  279,   -1,   -1,   -1,   -1,   -1,  285,   -1,  287,
  288,  289,  290,  291,  292,   -1,   -1,  295,   -1,   -1,
   -1,  299,  300,   -1,  302,  303,  304,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  314,   -1,  316,   -1,
  318,  319,   -1,   -1,  322,   -1,  324,  325,  326,  327,
  328,  329,  330,  331,  332,  333,  334,  335,   -1,  337,
   -1,   -1,  340,  341,   -1,   -1,  344,  345,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,  367,
   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,  376,  377,
  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,
   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  417,
  418,  419,  420,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
   -1,  265,   -1,  267,  285,   -1,  270,  288,   -1,   -1,
   -1,  275,   -1,   -1,  295,  279,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,  288,   -1,   -1,   -1,   -1,   -1,
   -1,  295,   -1,   -1,   -1,  316,  300,  318,  319,   -1,
  304,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,  316,  334,  318,   -1,   -1,   -1,  322,   -1,
  341,   -1,   -1,  344,  345,   -1,  330,  331,   -1,   -1,
  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,  367,  368,   -1,   -1,
  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,
   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,  372,   -1,
   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  256,   -1,   -1,   -1,  417,  418,  419,  420,
  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,  418,  279,   -1,   -1,  265,   -1,
  267,  285,   -1,  270,  288,   -1,   -1,   -1,  275,   -1,
   -1,  295,  279,   -1,   -1,   -1,  300,   -1,  302,  303,
  304,  288,  306,   -1,   -1,   -1,   -1,   -1,  295,  313,
   -1,   -1,  316,  300,  318,  319,   -1,  304,  322,   -1,
   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,  316,
  334,  318,   -1,   -1,   -1,  322,   -1,  341,   -1,   -1,
  344,  345,   -1,  330,  331,   -1,   -1,  334,   -1,   -1,
  337,   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,
   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,
  384,   -1,  386,  370,   -1,   -1,   -1,   -1,  392,  393,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,
   -1,   -1,   -1,  417,  418,  419,  420,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,  418,  279,   -1,   -1,  265,   -1,  267,  285,   -1,
  270,  288,   -1,   -1,   -1,  275,   -1,   -1,  295,  279,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,  288,   -1,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,  316,
  300,  318,  319,  320,  304,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,  316,  334,  318,   -1,
   -1,   -1,  322,   -1,  341,   -1,   -1,  344,  345,   -1,
  330,  331,   -1,   -1,  334,   -1,   -1,  337,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
  367,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,
  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,
   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,
   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
  417,  418,  419,  420,  285,   -1,   -1,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,  418,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,
  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,  367,  368,   -1,   -1,
  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,
   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,
   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  256,   -1,  417,  418,  419,  420,
   -1,   -1,  264,  265,   -1,  267,   -1,  428,  270,  271,
   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,
  265,   -1,  267,  285,   -1,  270,  288,   -1,   -1,   -1,
  275,   -1,   -1,  295,  279,   -1,   -1,   -1,  300,   -1,
  302,  303,  304,  288,   -1,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,  316,  300,  318,  319,  320,  304,
  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,
  332,  316,  334,  318,   -1,   -1,   -1,  322,   -1,  341,
   -1,   -1,  344,  345,   -1,  330,  331,   -1,   -1,  334,
   -1,   -1,  337,   -1,   -1,   -1,   -1,  359,  360,  361,
  362,  363,   -1,   -1,   -1,  367,   -1,   -1,   -1,  371,
   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,
   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,
  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,   -1,  279,   -1,  417,  418,  419,  420,  285,
   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,  418,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,
   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,
   -1,  367,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,
   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,
  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,
   -1,  417,  418,  419,  420,   -1,   -1,  264,  265,   -1,
  267,   -1,  428,  270,  271,   -1,   -1,   -1,  275,  276,
  277,   -1,  279,   -1,   -1,  265,   -1,  267,  285,   -1,
  270,  288,   -1,   -1,   -1,  275,   -1,   -1,  295,  279,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,  288,   -1,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,  316,
  300,  318,  319,   -1,  304,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,  316,  334,  318,   -1,
   -1,   -1,  322,   -1,  341,   -1,   -1,  344,  345,   -1,
  330,  331,   -1,   -1,  334,   -1,   -1,  337,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
  367,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,
  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,
   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,
  417,  418,  419,  420,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,  418,  279,
   -1,   -1,  265,   -1,  267,  285,   -1,  270,  288,   -1,
   -1,   -1,  275,   -1,   -1,  295,  279,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,  288,   -1,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,  316,  300,  318,  319,
   -1,  304,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,  316,  334,  318,   -1,   -1,   -1,  322,
   -1,  341,   -1,   -1,  344,  345,   -1,  330,  331,   -1,
   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,
  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,
   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  256,   -1,   -1,   -1,  417,  418,  419,
  420,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,  418,  279,   -1,   -1,  265,
   -1,  267,  285,   -1,  270,  288,   -1,   -1,   -1,  275,
   -1,   -1,  295,  279,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,  316,  300,  318,  319,   -1,  304,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
  316,  334,  318,   -1,   -1,   -1,  322,   -1,  341,   -1,
   -1,  344,  345,   -1,  330,  331,   -1,   -1,  334,   -1,
   -1,  337,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,
   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,
   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,
  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  256,   -1,   -1,   -1,  417,  418,  419,  420,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,  418,  279,   -1,   -1,  265,   -1,  267,  285,
   -1,  270,  288,   -1,   -1,   -1,  275,   -1,   -1,  295,
  279,   -1,   -1,   -1,  300,   -1,  302,  303,  304,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
  316,  300,  318,  319,   -1,  304,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,  316,  334,  318,
   -1,   -1,   -1,  322,   -1,  341,   -1,   -1,  344,  345,
   -1,  330,  331,   -1,   -1,  334,   -1,   -1,  337,   -1,
   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,
   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,
  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,
   -1,  417,  418,  419,  420,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,  418,
  279,   -1,   -1,  265,   -1,  267,  285,   -1,  270,  288,
   -1,   -1,   -1,  275,   -1,   -1,  295,  279,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,  288,   -1,   -1,   -1,
   -1,   -1,   -1,  295,   -1,   -1,   -1,  316,  300,  318,
  319,   -1,  304,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,  316,  334,  318,   -1,   -1,   -1,
  322,   -1,  341,   -1,   -1,  344,  345,   -1,  330,  331,
   -1,   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,
  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,
   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  417,  418,
  419,  420,  264,  265,   -1,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,  418,  279,   -1,   -1,
  265,   -1,  267,  285,   -1,  270,  288,   -1,   -1,   -1,
  275,   -1,   -1,  295,  279,   -1,   -1,   -1,  300,   -1,
  302,  303,  304,  288,   -1,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,  316,  300,  318,  319,   -1,  304,
  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,
  332,  316,  334,  318,   -1,   -1,   -1,  322,   -1,  341,
   -1,   -1,  344,  345,   -1,  330,  331,   -1,   -1,  334,
   -1,   -1,  337,   -1,   -1,   -1,   -1,  359,  360,  361,
  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,
   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,
   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,
  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  256,   -1,   -1,   -1,  417,  418,  419,  420,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,  418,  279,   -1,   -1,   -1,   -1,   -1,
  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,
  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,
   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,
   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,
   -1,   -1,  417,  418,  419,  420,  264,  265,   -1,  267,
   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,
   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,   -1,   -1,
  288,   -1,   -1,   -1,  261,   -1,   -1,  295,   -1,   -1,
   -1,  262,  300,   -1,  302,  303,  304,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,  316,   -1,
  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,
  297,  329,  330,  331,  332,  302,  334,  298,   -1,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,  315,   -1,
  317,   -1,   -1,   -1,  321,   -1,   -1,   -1,   -1,   -1,
   -1,  359,  360,  361,  362,   -1,  333,   -1,   -1,  336,
   -1,  338,   -1,  371,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,
   -1,  368,  369,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  371,  372,  373,  374,  375,   -1,   -1,  378,  379,  417,
  418,  382,  383,  384,  385,  386,  387,  388,  389,  390,
   -1,  392,  393,  394,  395,  396,  397,  398,  399,  400,
  401,  402,  403,  404,  405,  406,  407,  408,  409,  410,
  411,  412,  413,   -1,  261,   -1,  263,   -1,  265,  420,
  267,   -1,  423,  270,   -1,  272,  273,   -1,  275,   -1,
  277,   -1,  279,   -1,  281,  282,  283,  284,   -1,   -1,
  287,  288,   -1,   -1,   -1,   -1,  293,  294,  295,  296,
  297,   -1,   -1,  300,   -1,  302,   -1,  304,   -1,  306,
  307,   -1,  309,  310,  311,  312,   -1,   -1,  315,  316,
  317,  318,   -1,   -1,  321,  322,  323,   -1,   -1,   -1,
   -1,   -1,   -1,  330,  331,   -1,  333,  334,   -1,  336,
  337,  338,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  362,   -1,  364,  365,  261,
   -1,   -1,   -1,  265,   -1,  267,   -1,   -1,  270,   -1,
  272,  273,   -1,  275,   -1,  277,   -1,  279,   -1,  281,
  282,  283,  284,   -1,   -1,  287,  288,   -1,   -1,   -1,
   -1,  293,   -1,  295,  296,  297,   -1,   -1,  300,   -1,
  302,   -1,  304,   -1,   -1,  307,   -1,  309,  310,  311,
  312,  418,   -1,   -1,  316,  317,  318,   -1,   -1,  321,
  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,
   -1,  333,  334,   -1,  336,  337,  338,   -1,   -1,   -1,
  342,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  261,   -1,
  362,   -1,  265,   -1,  267,   -1,  368,  270,   -1,  272,
  273,   -1,  275,   -1,  277,  377,  279,   -1,  281,  282,
  283,  284,   -1,   -1,  287,  288,   -1,   -1,   -1,   -1,
  293,   -1,  295,  296,  297,   -1,   -1,  300,   -1,  302,
   -1,  304,   -1,   -1,  307,   -1,  309,  310,  311,  312,
   -1,   -1,   -1,  316,  317,  318,  418,   -1,  321,  322,
  323,   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,   -1,
  333,  334,   -1,  336,  337,  338,   -1,   -1,   -1,  342,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  261,   -1,  362,
   -1,  265,   -1,  267,   -1,  368,  270,   -1,  272,  273,
   -1,  275,   -1,  277,  377,  279,   -1,  281,  282,  283,
  284,   -1,   -1,  287,  288,   -1,   -1,   -1,   -1,  293,
   -1,  295,  296,  297,   -1,   -1,  300,   -1,  302,   -1,
  304,   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,
   -1,   -1,  316,  317,  318,  418,   -1,  321,  322,  323,
   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,   -1,  333,
  334,   -1,  336,  337,  338,   -1,   -1,   -1,  342,   -1,
   -1,   -1,   -1,  261,   -1,   -1,   -1,  265,   -1,  267,
   -1,   -1,  270,   -1,  272,  273,   -1,  275,  362,  277,
   -1,  279,   -1,  281,  282,  283,  284,   -1,   -1,  287,
  288,   -1,   -1,  377,   -1,  293,   -1,  295,  296,  297,
   -1,   -1,  300,   -1,  302,   -1,  304,   -1,   -1,  307,
   -1,  309,  310,  311,  312,   -1,   -1,   -1,  316,  317,
  318,   -1,   -1,  321,  322,  323,   -1,   -1,   -1,   -1,
   -1,   -1,  330,  331,  418,  333,  334,   -1,  336,  337,
  338,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  261,   -1,   -1,
   -1,  265,   -1,  267,  362,   -1,  270,   -1,  272,  273,
  368,  275,   -1,  277,   -1,  279,   -1,  281,  282,  283,
  284,   -1,   -1,  287,  288,   -1,   -1,   -1,   -1,  293,
   -1,  295,  296,  297,   -1,   -1,  300,   -1,  302,  261,
  304,   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,
   -1,   -1,  316,  317,  318,   -1,   -1,  321,  322,  323,
  418,   -1,  284,   -1,   -1,   -1,  330,  331,   -1,  333,
  334,  261,  336,  337,  338,  297,   -1,   -1,  342,   -1,
  302,   -1,   -1,  305,   -1,  307,   -1,  309,  310,  311,
  312,   -1,   -1,   -1,  284,  317,   -1,   -1,  362,  321,
   -1,   -1,   -1,  325,  368,   -1,   -1,  297,   -1,   -1,
   -1,  333,  302,   -1,  336,   -1,  338,  307,   -1,  309,
  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,
   -1,  321,   -1,   -1,   -1,  357,   -1,   -1,   -1,   -1,
  362,   -1,   -1,  333,   -1,   -1,  336,  369,  338,  371,
   -1,  373,   -1,   -1,  418,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,  386,   -1,  275,  276,  277,   -1,
  279,   -1,  362,   -1,   -1,   -1,  285,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,  418,  306,   -1,   -1,
   -1,   -1,   -1,   -1,  313,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,  418,   -1,
   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  371,  372,   -1,  374,   -1,   -1,  377,  378,
  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,
   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,
   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,   -1,  279,   -1,  417,  418,
  419,  420,  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,   -1,  306,   -1,   -1,   -1,   -1,   -1,   -1,
  313,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,
   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,
   -1,  374,   -1,   -1,  377,  378,  379,  380,   -1,   -1,
   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,
  393,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,   -1,  279,   -1,  417,  418,  419,  420,  285,   -1,
   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,
  337,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,
  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,
   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,
   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
  417,  418,  419,  420,  285,   -1,   -1,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,
  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,   -1,  368,   -1,   -1,
  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,
   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,
   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,  417,  418,  419,  420,
  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,
  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,  367,   -1,   -1,   -1,  371,   -1,   -1,   -1,
   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,
   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,
   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,  417,  418,  419,  420,  285,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,  367,   -1,
   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,
  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,
   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,
   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,   -1,  279,   -1,  417,  418,
  419,  420,  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,
   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,
   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,
   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,
  393,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,   -1,  279,   -1,  417,  418,  419,  420,  285,   -1,
   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,
   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,
  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,
   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,
   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
  417,  418,  419,  420,  285,   -1,   -1,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,
  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,
   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,
   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,  417,  418,  419,  420,
  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,
  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,
   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,
   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,
   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,  417,  418,  419,  420,  285,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,
  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,
   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,
   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,   -1,  279,   -1,  417,  418,
  419,  420,  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,
   -1,   -1,  295,   -1,  261,   -1,  263,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  316,   -1,  318,  319,  284,   -1,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
  297,  334,   -1,   -1,   -1,  302,   -1,   -1,   -1,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,
  317,   -1,   -1,   -1,  321,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,   -1,   -1,  333,   -1,  371,  336,
   -1,  338,   -1,   -1,  377,  378,  379,  380,   -1,   -1,
   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,
  393,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,
   -1,  368,  369,   -1,   -1,   -1,   -1,   -1,   -1,  263,
   -1,  265,   -1,  267,  417,  418,  270,  420,  272,  273,
   -1,  275,   -1,  277,   -1,  279,   -1,  281,  282,  283,
   -1,   -1,   -1,  287,  288,   -1,   -1,   -1,   -1,  293,
   -1,  295,  296,   -1,   -1,   -1,  300,   -1,   -1,   -1,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  315,  316,   -1,  318,   -1,   -1,   -1,  322,  323,
   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,  264,  265,
  334,  267,   -1,  337,  270,  271,   -1,   -1,  342,  275,
  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,
   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
  364,  365,   -1,   -1,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,  377,   -1,   -1,   -1,   -1,   -1,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,
   -1,  337,   -1,   -1,   -1,   -1,   -1,   -1,  265,   -1,
  267,   -1,   -1,  270,  418,  272,   -1,   -1,  275,   -1,
   -1,   -1,  279,  359,  360,  361,  362,   -1,   -1,   -1,
   -1,  288,  265,   -1,  267,  371,   -1,  270,  295,  272,
  273,   -1,  275,  300,  277,  302,  279,  304,  281,  282,
  283,   -1,   -1,   -1,  287,  288,   -1,   -1,   -1,  316,
  293,  318,  295,  296,   -1,  322,  323,  300,   -1,   -1,
   -1,  304,   -1,  330,  331,   -1,   -1,  334,   -1,   -1,
  337,  417,  418,  316,   -1,  318,   -1,   -1,   -1,  322,
  323,   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,   -1,
  265,  334,  267,   -1,  337,  270,   -1,  272,  273,  342,
  275,   -1,  277,   -1,  279,   -1,  281,  282,  283,   -1,
   -1,   -1,  287,  288,   -1,   -1,   -1,   -1,  293,   -1,
  295,  296,   -1,   -1,   -1,  300,   -1,   -1,   -1,  304,
   -1,   -1,   -1,   -1,  377,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,   -1,   -1,   -1,  322,  323,   -1,
   -1,  418,   -1,   -1,   -1,  330,  331,   -1,   -1,  334,
   -1,   -1,  337,   -1,  265,   -1,  267,  342,   -1,  270,
   -1,   -1,  273,   -1,  275,  418,  277,   -1,  279,   -1,
  281,  282,  283,   -1,   -1,   -1,  287,  288,   -1,   -1,
   -1,   -1,  293,   -1,  295,   -1,  265,   -1,  267,  300,
   -1,  270,   -1,  304,  273,   -1,  275,   -1,  277,   -1,
  279,   -1,  281,  282,  283,  316,   -1,  318,  287,  288,
   -1,  322,   -1,   -1,  293,   -1,  295,   -1,   -1,  330,
  331,  300,   -1,  334,   -1,  304,  337,   -1,   -1,   -1,
  265,  342,  267,  418,   -1,  270,   -1,  316,   -1,  318,
  275,   -1,   -1,  322,  279,   -1,   -1,   -1,   -1,   -1,
   -1,  330,  331,  288,   -1,  334,   -1,   -1,  337,   -1,
  295,   -1,  265,  342,  267,  300,  377,  270,   -1,  304,
   -1,  306,  275,  308,   -1,   -1,  279,   -1,  313,   -1,
   -1,  316,   -1,  318,   -1,  288,   -1,  322,   -1,   -1,
  325,   -1,  295,   -1,   -1,  330,  331,  300,   -1,  334,
   -1,  304,  337,  306,   -1,  308,  265,  418,  267,   -1,
  313,  270,   -1,  316,   -1,  318,  275,   -1,   -1,  322,
  279,   -1,  325,   -1,   -1,   -1,   -1,  330,  331,  288,
   -1,  334,   -1,   -1,  337,   -1,  295,  372,  265,  418,
  267,  300,   -1,  270,   -1,  304,   -1,  306,  275,  308,
   -1,   -1,  279,   -1,  313,   -1,   -1,  316,   -1,  318,
   -1,  288,   -1,  322,   -1,   -1,  325,  370,  295,   -1,
   -1,  330,  331,  300,   -1,  334,   -1,  304,  337,  306,
   -1,  308,  265,  418,  267,   -1,  313,  270,   -1,  316,
   -1,  318,  275,   -1,   -1,  322,  279,   -1,  325,   -1,
   -1,   -1,   -1,  330,  331,  288,   -1,  334,   -1,   -1,
  337,   -1,  295,   -1,   -1,  418,   -1,  300,   -1,   -1,
   -1,  304,   -1,  306,   -1,   -1,   -1,  265,   -1,  267,
  313,   -1,  270,  316,   -1,  318,   -1,  275,   -1,  322,
   -1,  279,  325,   -1,   -1,  283,   -1,  330,  331,   -1,
  288,  334,   -1,   -1,  337,  293,   -1,  295,   -1,  418,
   -1,   -1,  300,   -1,   -1,  261,  304,  305,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  272,   -1,  316,   -1,
  318,  277,   -1,   -1,  322,  281,   -1,   -1,  284,   -1,
   -1,  418,  330,  331,   -1,   -1,  334,   -1,   -1,   -1,
  296,  297,   -1,   -1,   -1,  301,  302,   -1,   -1,   -1,
   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,
   -1,  317,   -1,   -1,   -1,  321,   -1,  323,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  418,   -1,  333,   -1,  335,
  336,  261,  338,   -1,   -1,   -1,  342,   -1,   -1,   -1,
   -1,   -1,  272,   -1,   -1,   -1,   -1,  277,   -1,   -1,
   -1,  281,   -1,   -1,  284,   -1,  362,   -1,   -1,   -1,
   -1,   -1,  368,  369,   -1,   -1,  296,  297,   -1,   -1,
  418,  301,  302,   -1,  261,   -1,   -1,  307,   -1,  309,
  310,  311,  312,   -1,   -1,  272,   -1,  317,   -1,   -1,
  277,  321,   -1,  323,  281,   -1,   -1,  284,   -1,   -1,
   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,  296,
  297,   -1,  342,   -1,  301,  302,   -1,  261,   -1,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,  272,   -1,
  317,   -1,  362,  277,  321,   -1,  323,  281,  368,  369,
  284,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,
   -1,  338,  296,  297,   -1,  342,   -1,  301,  302,  261,
   -1,   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,
   -1,   -1,   -1,  317,   -1,  362,   -1,  321,   -1,  323,
   -1,  368,  284,   -1,   -1,   -1,   -1,   -1,   -1,  333,
   -1,   -1,  336,   -1,  338,  297,   -1,  261,  342,   -1,
  302,   -1,   -1,   -1,   -1,  307,   -1,  309,  310,  311,
  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,  362,  321,
  284,   -1,   -1,   -1,  368,   -1,   -1,   -1,   -1,   -1,
   -1,  333,   -1,  297,  336,  261,  338,   -1,  302,   -1,
   -1,   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,
   -1,   -1,   -1,  317,   -1,   -1,   -1,  321,  284,   -1,
  362,   -1,  364,  365,   -1,   -1,  368,   -1,   -1,  333,
   -1,  297,  336,  261,  338,  263,  302,   -1,   -1,   -1,
   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,  315,
   -1,  317,   -1,   -1,   -1,  321,  284,   -1,  362,   -1,
  364,  365,   -1,   -1,  368,   -1,   -1,  333,   -1,  297,
  336,  261,  338,   -1,  302,   -1,   -1,   -1,   -1,  307,
   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,
   -1,   -1,   -1,  321,  284,   -1,  362,   -1,   -1,   -1,
   -1,  261,  368,  263,   -1,  333,   -1,  297,  336,   -1,
  338,   -1,  302,   -1,   -1,   -1,   -1,  307,   -1,  309,
  310,  311,  312,   -1,  284,   -1,   -1,  317,   -1,   -1,
   -1,  321,   -1,   -1,  362,   -1,   -1,  297,   -1,   -1,
  368,  261,  302,  333,   -1,   -1,  336,  307,  338,  309,
  310,  311,  312,   -1,   -1,  315,   -1,  317,   -1,   -1,
   -1,  321,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,
   -1,  261,  362,  333,  364,  365,  336,  297,  338,   -1,
   -1,  301,  302,   -1,   -1,   -1,   -1,  307,   -1,  309,
  310,  311,  312,   -1,  284,   -1,   -1,  317,   -1,   -1,
   -1,  321,  362,   -1,   -1,   -1,   -1,  297,   -1,   -1,
   -1,   -1,  302,  333,   -1,   -1,  336,  307,  338,  309,
  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,
   -1,  321,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  362,  333,   -1,   -1,  336,   -1,  338,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  362,
  };

#line 6654 "cs-parser.jay"

// <summary>
//  A class used to hold info about an operator declarator
// </summary>
class OperatorDeclaration {
	public readonly Operator.OpType optype;
	public readonly FullNamedExpression ret_type;
	public readonly Location location;

	public OperatorDeclaration (Operator.OpType op, FullNamedExpression ret_type, Location location)
	{
		optype = op;
		this.ret_type = ret_type;
		this.location = location;
	}
}

void Error_ExpectingTypeName (Expression expr)
{
	if (expr is Invocation){
		report.Error (1002, expr.Location, "Expecting `;'");
	} else {
		Expression.Error_InvalidExpressionStatement (report, expr.Location);
	}
}

void Error_ParameterModifierNotValid (string modifier, Location loc)
{
	report.Error (631, loc, "The parameter modifier `{0}' is not valid in this context",
			              modifier);
}

void Error_DuplicateParameterModifier (Location loc, Parameter.Modifier mod)
{
	report.Error (1107, loc, "Duplicate parameter modifier `{0}'",
  		Parameter.GetModifierSignature (mod));
}

void Error_TypeExpected (Location loc)
{
	report.Error (1031, loc, "Type expected");
}

void Error_UnsafeCodeNotAllowed (Location loc)
{
	report.Error (227, loc, "Unsafe code requires the `unsafe' command line option to be specified");
}

void Warning_EmptyStatement (Location loc)
{
	report.Warning (642, 3, loc, "Possible mistaken empty statement");
}

void Error_NamedArgumentExpected (NamedArgument a)
{
	report.Error (1738, a.Location, "Named arguments must appear after the positional arguments");
}

void Error_MissingInitializer (Location loc)
{
	report.Error (210, loc, "You must provide an initializer in a fixed or using statement declaration");
}

void push_current_container (TypeDefinition tc, object partial_token)
{
	if (module.Evaluator != null){
		tc.Definition.Modifiers = tc.ModFlags = (tc.ModFlags & ~Modifiers.AccessibilityMask) | Modifiers.PUBLIC;
		if (undo == null)
			undo = new Undo ();

		undo.AddTypeContainer (current_container, tc);
	}
	
	if (partial_token != null)
		current_container.AddPartial (tc);
	else
		current_container.AddTypeContainer (tc);
		
	++lexer.parsing_declaration;
	current_container = tc;
	current_type = tc;
}

TypeContainer pop_current_class ()
{
	var retval = current_container;

	current_container = current_container.Parent;
	current_type = current_type.Parent as TypeDefinition;

	return retval;
}

[System.Diagnostics.Conditional ("FULL_AST")]
void StoreModifierLocation (object token, Location loc)
{
	if (lbag == null)
		return;

	if (mod_locations == null)
  		mod_locations = new List<Tuple<Modifiers, Location>> ();

	mod_locations.Add (Tuple.Create ((Modifiers) token, loc));
}

List<Tuple<Modifiers, Location>> GetModifierLocations ()
{
	var result = mod_locations;
	mod_locations = null;
	return result;
}

string CheckAttributeTarget (string a, Location l)
{
	switch (a) {
	case "assembly" : case "module" : case "field" : case "method" : case "param" : case "property" : case "type" :
			return a;
	}

	report.Warning (658, 1, l,
		 "`{0}' is invalid attribute target. All attributes in this attribute section will be ignored", a);
	return string.Empty;
}

static bool IsUnaryOperator (Operator.OpType op)
{
	switch (op) {
		
	case Operator.OpType.LogicalNot: 
	case Operator.OpType.OnesComplement: 
	case Operator.OpType.Increment:
	case Operator.OpType.Decrement:
	case Operator.OpType.True: 
	case Operator.OpType.False: 
	case Operator.OpType.UnaryPlus: 
	case Operator.OpType.UnaryNegation:
		return true;
	}
	return false;
}

void syntax_error (Location l, string msg)
{
	report.Error (1003, l, "Syntax error, " + msg);
}

Tokenizer lexer;

public Tokenizer Lexer {
	get {
		return lexer;
	}
}		   

public CSharpParser (SeekableStreamReader reader, CompilationSourceFile file, ParserSession session)
	: this (reader, file, file.Compiler.Report, session)
{
}

public CSharpParser (SeekableStreamReader reader, CompilationSourceFile file, Report report, ParserSession session)
{
	this.file = file;
	current_container = current_namespace = file;
	
	this.module = file.Module;
	this.compiler = file.Compiler;
	this.settings = compiler.Settings;
	this.report = report;
	
	lang_version = settings.Version;
	yacc_verbose_flag = settings.VerboseParserFlag;
	doc_support = settings.DocumentationFile != null;
	lexer = new Tokenizer (reader, file, session);
	oob_stack = new Stack<object> ();
	lbag = session.LocationsBag;
	use_global_stacks = session.UseJayGlobalArrays;
	parameters_bucket = session.ParametersStack;
}

public void parse ()
{
	eof_token = Token.EOF;
	
	try {
		if (yacc_verbose_flag > 1)
			yyparse (lexer, new yydebug.yyDebugSimple ());
		else
			yyparse (lexer);
			
		Tokenizer tokenizer = lexer as Tokenizer;
		tokenizer.cleanup ();		
	} catch (Exception e){
	  	if (e is yyParser.yyUnexpectedEof) {
			Error_SyntaxError (yyToken);
			UnexpectedEOF = true;
			return;
		}
			
		if (e is yyParser.yyException) {
			report.Error (-25, lexer.Location, "Parsing error");
		} else {
			// Used by compiler-tester to test internal errors
			if (yacc_verbose_flag > 0 || e is FatalException)
				throw;
		
			report.Error (589, lexer.Location, "Internal compiler error during parsing" + e);
		}
	}
}

void CheckToken (int error, int yyToken, string msg, Location loc)
{
	if (yyToken >= Token.FIRST_KEYWORD && yyToken <= Token.LAST_KEYWORD)
		report.Error (error, loc, "{0}: `{1}' is a keyword", msg, GetTokenName (yyToken));
	else
		report.Error (error, loc, msg);
}

string ConsumeStoredComment ()
{
	string s = tmpComment;
	tmpComment = null;
	Lexer.doc_state = XmlCommentState.Allowed;
	return s;
}

void FeatureIsNotAvailable (Location loc, string feature)
{
	report.FeatureIsNotAvailable (compiler, loc, feature);
}

Location GetLocation (object obj)
{
	var lt = obj as Tokenizer.LocatedToken;
	if (lt != null)
		return lt.Location;
		
	var mn = obj as MemberName;
	if (mn != null)
		return mn.Location;
		
	var expr = obj as Expression;
	if (expr != null)
		return expr.Location;

	return lexer.Location;
}

void start_block (Location loc)
{
	if (current_block == null) {
		current_block = new ToplevelBlock (compiler, current_local_parameters, loc);
		parsing_anonymous_method = false;
	} else if (parsing_anonymous_method) {
		current_block = new ParametersBlock (current_block, current_local_parameters, loc);
		parsing_anonymous_method = false;
	} else {
		current_block = new ExplicitBlock (current_block, loc, Location.Null);
	}
}

Block
end_block (Location loc)
{
	Block retval = current_block.Explicit;
	retval.SetEndLocation (loc);
	current_block = retval.Parent;
	return retval;
}

void start_anonymous (bool isLambda, ParametersCompiled parameters, bool isAsync, Location loc)
{
	oob_stack.Push (current_anonymous_method);
	oob_stack.Push (current_local_parameters);
	oob_stack.Push (current_variable);
	oob_stack.Push (async_block);

	current_local_parameters = parameters;
	if (isLambda) {
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (loc, "lambda expressions");

		current_anonymous_method = new LambdaExpression (loc);
	} else {
		if (lang_version == LanguageVersion.ISO_1)
			FeatureIsNotAvailable (loc, "anonymous methods");
			
		current_anonymous_method = new AnonymousMethodExpression (loc);
	}
	current_anonymous_method.IsAsync = isAsync;
	
	async_block = isAsync;
	// Force the next block to be created as a ToplevelBlock
	parsing_anonymous_method = true;
}

/*
 * Completes the anonymous method processing, if lambda_expr is null, this
 * means that we have a Statement instead of an Expression embedded 
 */
AnonymousMethodExpression end_anonymous (ParametersBlock anon_block)
{
	AnonymousMethodExpression retval;

	if (async_block)
		anon_block.IsAsync = true;

	current_anonymous_method.Block = anon_block;
	retval = current_anonymous_method;

	async_block = (bool) oob_stack.Pop ();
	current_variable = (BlockVariableDeclaration) oob_stack.Pop ();
	current_local_parameters = (ParametersCompiled) oob_stack.Pop ();
	current_anonymous_method = (AnonymousMethodExpression) oob_stack.Pop ();

	return retval;
}

void Error_SyntaxError (int token)
{
	Error_SyntaxError (0, token);
}

void Error_SyntaxError (int error_code, int token)
{
	Error_SyntaxError (error_code, token, "Unexpected symbol");
}

void Error_SyntaxError (int error_code, int token, string msg)
{
	Lexer.CompleteOnEOF = false;

	// An error message has been reported by tokenizer
	if (token == Token.ERROR)
		return;

	string symbol = GetSymbolName (token);
	string expecting = GetExpecting ();
	var loc = lexer.Location - symbol.Length;
	
	if (error_code == 0) {
		if (expecting == "`identifier'") {
			if (token > Token.FIRST_KEYWORD && token < Token.LAST_KEYWORD) {
				report.Error (1041, loc, "Identifier expected, `{0}' is a keyword", symbol);
				return;
			}
			
			error_code = 1001;
			expecting = "identifier";
		} else if (expecting == "`)'") {
			error_code = 1026;
		} else {
			error_code = 1525;
		}
	}
	
	if (string.IsNullOrEmpty (expecting))
		report.Error (error_code, loc, "{1} `{0}'", symbol, msg);
	else
		report.Error (error_code, loc, "{2} `{0}', expecting {1}", symbol, expecting, msg);	  
}

string GetExpecting ()
{
	int [] tokens = yyExpectingTokens (yyExpectingState);
	var names = new List<string> (tokens.Length);
	bool has_type = false;
	bool has_identifier = false;
	for (int i = 0; i < tokens.Length; i++){
		int token = tokens [i];
		has_identifier |= token == Token.IDENTIFIER;
		
		string name = GetTokenName (token);
		if (name == "<internal>")
			continue;
			
		has_type |= name == "type";
		if (names.Contains (name))
			continue;
		
		names.Add (name);
	}

	//
	// Too many tokens to enumerate
	//
	if (names.Count > 8)
		return null;

	if (has_type && has_identifier)
		names.Remove ("identifier");

	if (names.Count == 1)
		return "`" + GetTokenName (tokens [0]) + "'";
	
	StringBuilder sb = new StringBuilder ();
	names.Sort ();
	int count = names.Count;
	for (int i = 0; i < count; i++){
		bool last = i + 1 == count;
		if (last)
			sb.Append ("or ");
		sb.Append ('`');
		sb.Append (names [i]);
		sb.Append (last ? "'" : count < 3 ? "' " : "', ");
	}
	return sb.ToString ();
}


string GetSymbolName (int token)
{
	switch (token){
	case Token.LITERAL:
		return ((Constant)lexer.Value).GetValue ().ToString ();
	case Token.IDENTIFIER:
		return ((Tokenizer.LocatedToken)lexer.Value).Value;

	case Token.BOOL:
		return "bool";
	case Token.BYTE:
		return "byte";
	case Token.CHAR:
		return "char";
	case Token.VOID:
		return "void";
	case Token.DECIMAL:
		return "decimal";
	case Token.DOUBLE:
		return "double";
	case Token.FLOAT:
		return "float";
	case Token.INT:
		return "int";
	case Token.LONG:
		return "long";
	case Token.SBYTE:
		return "sbyte";
	case Token.SHORT:
		return "short";
	case Token.STRING:
		return "string";
	case Token.UINT:
		return "uint";
	case Token.ULONG:
		return "ulong";
	case Token.USHORT:
		return "ushort";
	case Token.OBJECT:
		return "object";
		
	case Token.PLUS:
		return "+";
	case Token.UMINUS:
	case Token.MINUS:
		return "-";
	case Token.BANG:
		return "!";
	case Token.BITWISE_AND:
		return "&";
	case Token.BITWISE_OR:
		return "|";
	case Token.STAR:
		return "*";
	case Token.PERCENT:
		return "%";
	case Token.DIV:
		return "/";
	case Token.CARRET:
		return "^";
	case Token.OP_INC:
		return "++";
	case Token.OP_DEC:
		return "--";
	case Token.OP_SHIFT_LEFT:
		return "<<";
	case Token.OP_SHIFT_RIGHT:
		return ">>";
	case Token.OP_LT:
		return "<";
	case Token.OP_GT:
		return ">";
	case Token.OP_LE:
		return "<=";
	case Token.OP_GE:
		return ">=";
	case Token.OP_EQ:
		return "==";
	case Token.OP_NE:
		return "!=";
	case Token.OP_AND:
		return "&&";
	case Token.OP_OR:
		return "||";
	case Token.OP_PTR:
		return "->";
	case Token.OP_COALESCING:	
		return "??";
	case Token.OP_MULT_ASSIGN:
		return "*=";
	case Token.OP_DIV_ASSIGN:
		return "/=";
	case Token.OP_MOD_ASSIGN:
		return "%=";
	case Token.OP_ADD_ASSIGN:
		return "+=";
	case Token.OP_SUB_ASSIGN:
		return "-=";
	case Token.OP_SHIFT_LEFT_ASSIGN:
		return "<<=";
	case Token.OP_SHIFT_RIGHT_ASSIGN:
		return ">>=";
	case Token.OP_AND_ASSIGN:
		return "&=";
	case Token.OP_XOR_ASSIGN:
		return "^=";
	case Token.OP_OR_ASSIGN:
		return "|=";
	}

	return GetTokenName (token);
}

static string GetTokenName (int token)
{
	switch (token){
	case Token.ABSTRACT:
		return "abstract";
	case Token.AS:
		return "as";
	case Token.ADD:
		return "add";
	case Token.ASYNC:
		return "async";
	case Token.BASE:
		return "base";
	case Token.BREAK:
		return "break";
	case Token.CASE:
		return "case";
	case Token.CATCH:
		return "catch";
	case Token.CHECKED:
		return "checked";
	case Token.CLASS:
		return "class";
	case Token.CONST:
		return "const";
	case Token.CONTINUE:
		return "continue";
	case Token.DEFAULT:
		return "default";
	case Token.DELEGATE:
		return "delegate";
	case Token.DO:
		return "do";
	case Token.ELSE:
		return "else";
	case Token.ENUM:
		return "enum";
	case Token.EVENT:
		return "event";
	case Token.EXPLICIT:
		return "explicit";
	case Token.EXTERN:
	case Token.EXTERN_ALIAS:
		return "extern";
	case Token.FALSE:
		return "false";
	case Token.FINALLY:
		return "finally";
	case Token.FIXED:
		return "fixed";
	case Token.FOR:
		return "for";
	case Token.FOREACH:
		return "foreach";
	case Token.GOTO:
		return "goto";
	case Token.IF:
		return "if";
	case Token.IMPLICIT:
		return "implicit";
	case Token.IN:
		return "in";
	case Token.INTERFACE:
		return "interface";
	case Token.INTERNAL:
		return "internal";
	case Token.IS:
		return "is";
	case Token.LOCK:
		return "lock";
	case Token.NAMESPACE:
		return "namespace";
	case Token.NEW:
		return "new";
	case Token.NULL:
		return "null";
	case Token.OPERATOR:
		return "operator";
	case Token.OUT:
		return "out";
	case Token.OVERRIDE:
		return "override";
	case Token.PARAMS:
		return "params";
	case Token.PRIVATE:
		return "private";
	case Token.PROTECTED:
		return "protected";
	case Token.PUBLIC:
		return "public";
	case Token.READONLY:
		return "readonly";
	case Token.REF:
		return "ref";
	case Token.RETURN:
		return "return";
	case Token.REMOVE:
		return "remove";
	case Token.SEALED:
		return "sealed";
	case Token.SIZEOF:
		return "sizeof";
	case Token.STACKALLOC:
		return "stackalloc";
	case Token.STATIC:
		return "static";
	case Token.STRUCT:
		return "struct";
	case Token.SWITCH:
		return "switch";
	case Token.THIS:
		return "this";
	case Token.THROW:
		return "throw";
	case Token.TRUE:
		return "true";
	case Token.TRY:
		return "try";
	case Token.TYPEOF:
		return "typeof";
	case Token.UNCHECKED:
		return "unchecked";
	case Token.UNSAFE:
		return "unsafe";
	case Token.USING:
		return "using";
	case Token.VIRTUAL:
		return "virtual";
	case Token.VOLATILE:
		return "volatile";
	case Token.WHERE:
		return "where";
	case Token.WHILE:
		return "while";
	case Token.ARGLIST:
		return "__arglist";
	case Token.REFVALUE:
		return "__refvalue";
	case Token.REFTYPE:
		return "__reftype";
	case Token.MAKEREF:
		return "__makeref";
	case Token.PARTIAL:
		return "partial";
	case Token.ARROW:
		return "=>";
	case Token.FROM:
	case Token.FROM_FIRST:
		return "from";
	case Token.JOIN:
		return "join";
	case Token.ON:
		return "on";
	case Token.EQUALS:
		return "equals";
	case Token.SELECT:
		return "select";
	case Token.GROUP:
		return "group";
	case Token.BY:
		return "by";
	case Token.LET:
		return "let";
	case Token.ORDERBY:
		return "orderby";
	case Token.ASCENDING:
		return "ascending";
	case Token.DESCENDING:
		return "descending";
	case Token.INTO:
		return "into";
	case Token.GET:
		return "get";
	case Token.SET:
		return "set";
	case Token.OPEN_BRACE:
		return "{";
	case Token.CLOSE_BRACE:
		return "}";
	case Token.OPEN_BRACKET:
	case Token.OPEN_BRACKET_EXPR:
		return "[";
	case Token.CLOSE_BRACKET:
		return "]";
	case Token.OPEN_PARENS_CAST:
	case Token.OPEN_PARENS_LAMBDA:
	case Token.OPEN_PARENS:
		return "(";
	case Token.CLOSE_PARENS:
		return ")";
	case Token.DOT:
		return ".";
	case Token.COMMA:
		return ",";
	case Token.DEFAULT_COLON:
		return "default:";
	case Token.COLON:
		return ":";
	case Token.SEMICOLON:
		return ";";
	case Token.TILDE:
		return "~";
		
	case Token.PLUS:
	case Token.UMINUS:
	case Token.MINUS:
	case Token.BANG:
	case Token.OP_LT:
	case Token.OP_GT:
	case Token.BITWISE_AND:
	case Token.BITWISE_OR:
	case Token.STAR:
	case Token.PERCENT:
	case Token.DIV:
	case Token.CARRET:
	case Token.OP_INC:
	case Token.OP_DEC:
	case Token.OP_SHIFT_LEFT:
	case Token.OP_SHIFT_RIGHT:
	case Token.OP_LE:
	case Token.OP_GE:
	case Token.OP_EQ:
	case Token.OP_NE:
	case Token.OP_AND:
	case Token.OP_OR:
	case Token.OP_PTR:
	case Token.OP_COALESCING:	
	case Token.OP_MULT_ASSIGN:
	case Token.OP_DIV_ASSIGN:
	case Token.OP_MOD_ASSIGN:
	case Token.OP_ADD_ASSIGN:
	case Token.OP_SUB_ASSIGN:
	case Token.OP_SHIFT_LEFT_ASSIGN:
	case Token.OP_SHIFT_RIGHT_ASSIGN:
	case Token.OP_AND_ASSIGN:
	case Token.OP_XOR_ASSIGN:
	case Token.OP_OR_ASSIGN:
		return "<operator>";

	case Token.BOOL:
	case Token.BYTE:
	case Token.CHAR:
	case Token.VOID:
	case Token.DECIMAL:
	case Token.DOUBLE:
	case Token.FLOAT:
	case Token.INT:
	case Token.LONG:
	case Token.SBYTE:
	case Token.SHORT:
	case Token.STRING:
	case Token.UINT:
	case Token.ULONG:
	case Token.USHORT:
	case Token.OBJECT:
		return "type";
	
	case Token.ASSIGN:
		return "=";
	case Token.OP_GENERICS_LT:
	case Token.GENERIC_DIMENSION:
		return "<";
	case Token.OP_GENERICS_GT:
		return ">";
	case Token.INTERR:
	case Token.INTERR_NULLABLE:
		return "?";
	case Token.DOUBLE_COLON:
		return "::";
	case Token.LITERAL:
		return "value";
	case Token.IDENTIFIER:
	case Token.AWAIT:
		return "identifier";

	case Token.EOF:
		return "end-of-file";

		// All of these are internal.
	case Token.NONE:
	case Token.ERROR:
	case Token.FIRST_KEYWORD:
	case Token.EVAL_COMPILATION_UNIT_PARSER:
	case Token.EVAL_USING_DECLARATIONS_UNIT_PARSER:
	case Token.EVAL_STATEMENT_PARSER:
	case Token.LAST_KEYWORD:
	case Token.GENERATE_COMPLETION:
	case Token.COMPLETE_COMPLETION:
		return "<internal>";

		// A bit more robust.
	default:
		return yyNames [token];
        }
}

/* end end end */
}
#line default
namespace yydebug {
        using System;
	 internal interface yyDebug {
		 void push (int state, Object value);
		 void lex (int state, int token, string name, Object value);
		 void shift (int from, int to, int errorFlag);
		 void pop (int state);
		 void discard (int state, int token, string name, Object value);
		 void reduce (int from, int to, int rule, string text, int len);
		 void shift (int from, int to);
		 void accept (Object value);
		 void error (string message);
		 void reject ();
	 }
	 
	 class yyDebugSimple : yyDebug {
		 void println (string s){
			 Console.Error.WriteLine (s);
		 }
		 
		 public void push (int state, Object value) {
			 println ("push\tstate "+state+"\tvalue "+value);
		 }
		 
		 public void lex (int state, int token, string name, Object value) {
			 println("lex\tstate "+state+"\treading "+name+"\tvalue "+value);
		 }
		 
		 public void shift (int from, int to, int errorFlag) {
			 switch (errorFlag) {
			 default:				// normally
				 println("shift\tfrom state "+from+" to "+to);
				 break;
			 case 0: case 1: case 2:		// in error recovery
				 println("shift\tfrom state "+from+" to "+to
					     +"\t"+errorFlag+" left to recover");
				 break;
			 case 3:				// normally
				 println("shift\tfrom state "+from+" to "+to+"\ton error");
				 break;
			 }
		 }
		 
		 public void pop (int state) {
			 println("pop\tstate "+state+"\ton error");
		 }
		 
		 public void discard (int state, int token, string name, Object value) {
			 println("discard\tstate "+state+"\ttoken "+name+"\tvalue "+value);
		 }
		 
		 public void reduce (int from, int to, int rule, string text, int len) {
			 println("reduce\tstate "+from+"\tuncover "+to
				     +"\trule ("+rule+") "+text);
		 }
		 
		 public void shift (int from, int to) {
			 println("goto\tfrom state "+from+" to "+to);
		 }
		 
		 public void accept (Object value) {
			 println("accept\tvalue "+value);
		 }
		 
		 public void error (string message) {
			 println("error\t"+message);
		 }
		 
		 public void reject () {
			 println("reject");
		 }
		 
	 }
}
// %token constants
 class Token {
  public const int EOF = 257;
  public const int NONE = 258;
  public const int ERROR = 259;
  public const int FIRST_KEYWORD = 260;
  public const int ABSTRACT = 261;
  public const int AS = 262;
  public const int ADD = 263;
  public const int BASE = 264;
  public const int BOOL = 265;
  public const int BREAK = 266;
  public const int BYTE = 267;
  public const int CASE = 268;
  public const int CATCH = 269;
  public const int CHAR = 270;
  public const int CHECKED = 271;
  public const int CLASS = 272;
  public const int CONST = 273;
  public const int CONTINUE = 274;
  public const int DECIMAL = 275;
  public const int DEFAULT = 276;
  public const int DELEGATE = 277;
  public const int DO = 278;
  public const int DOUBLE = 279;
  public const int ELSE = 280;
  public const int ENUM = 281;
  public const int EVENT = 282;
  public const int EXPLICIT = 283;
  public const int EXTERN = 284;
  public const int FALSE = 285;
  public const int FINALLY = 286;
  public const int FIXED = 287;
  public const int FLOAT = 288;
  public const int FOR = 289;
  public const int FOREACH = 290;
  public const int GOTO = 291;
  public const int IF = 292;
  public const int IMPLICIT = 293;
  public const int IN = 294;
  public const int INT = 295;
  public const int INTERFACE = 296;
  public const int INTERNAL = 297;
  public const int IS = 298;
  public const int LOCK = 299;
  public const int LONG = 300;
  public const int NAMESPACE = 301;
  public const int NEW = 302;
  public const int NULL = 303;
  public const int OBJECT = 304;
  public const int OPERATOR = 305;
  public const int OUT = 306;
  public const int OVERRIDE = 307;
  public const int PARAMS = 308;
  public const int PRIVATE = 309;
  public const int PROTECTED = 310;
  public const int PUBLIC = 311;
  public const int READONLY = 312;
  public const int REF = 313;
  public const int RETURN = 314;
  public const int REMOVE = 315;
  public const int SBYTE = 316;
  public const int SEALED = 317;
  public const int SHORT = 318;
  public const int SIZEOF = 319;
  public const int STACKALLOC = 320;
  public const int STATIC = 321;
  public const int STRING = 322;
  public const int STRUCT = 323;
  public const int SWITCH = 324;
  public const int THIS = 325;
  public const int THROW = 326;
  public const int TRUE = 327;
  public const int TRY = 328;
  public const int TYPEOF = 329;
  public const int UINT = 330;
  public const int ULONG = 331;
  public const int UNCHECKED = 332;
  public const int UNSAFE = 333;
  public const int USHORT = 334;
  public const int USING = 335;
  public const int VIRTUAL = 336;
  public const int VOID = 337;
  public const int VOLATILE = 338;
  public const int WHERE = 339;
  public const int WHILE = 340;
  public const int ARGLIST = 341;
  public const int PARTIAL = 342;
  public const int ARROW = 343;
  public const int FROM = 344;
  public const int FROM_FIRST = 345;
  public const int JOIN = 346;
  public const int ON = 347;
  public const int EQUALS = 348;
  public const int SELECT = 349;
  public const int GROUP = 350;
  public const int BY = 351;
  public const int LET = 352;
  public const int ORDERBY = 353;
  public const int ASCENDING = 354;
  public const int DESCENDING = 355;
  public const int INTO = 356;
  public const int INTERR_NULLABLE = 357;
  public const int EXTERN_ALIAS = 358;
  public const int REFVALUE = 359;
  public const int REFTYPE = 360;
  public const int MAKEREF = 361;
  public const int ASYNC = 362;
  public const int AWAIT = 363;
  public const int GET = 364;
  public const int SET = 365;
  public const int LAST_KEYWORD = 366;
  public const int OPEN_BRACE = 367;
  public const int CLOSE_BRACE = 368;
  public const int OPEN_BRACKET = 369;
  public const int CLOSE_BRACKET = 370;
  public const int OPEN_PARENS = 371;
  public const int CLOSE_PARENS = 372;
  public const int DOT = 373;
  public const int COMMA = 374;
  public const int COLON = 375;
  public const int SEMICOLON = 376;
  public const int TILDE = 377;
  public const int PLUS = 378;
  public const int MINUS = 379;
  public const int BANG = 380;
  public const int ASSIGN = 381;
  public const int OP_LT = 382;
  public const int OP_GT = 383;
  public const int BITWISE_AND = 384;
  public const int BITWISE_OR = 385;
  public const int STAR = 386;
  public const int PERCENT = 387;
  public const int DIV = 388;
  public const int CARRET = 389;
  public const int INTERR = 390;
  public const int DOUBLE_COLON = 391;
  public const int OP_INC = 392;
  public const int OP_DEC = 393;
  public const int OP_SHIFT_LEFT = 394;
  public const int OP_SHIFT_RIGHT = 395;
  public const int OP_LE = 396;
  public const int OP_GE = 397;
  public const int OP_EQ = 398;
  public const int OP_NE = 399;
  public const int OP_AND = 400;
  public const int OP_OR = 401;
  public const int OP_MULT_ASSIGN = 402;
  public const int OP_DIV_ASSIGN = 403;
  public const int OP_MOD_ASSIGN = 404;
  public const int OP_ADD_ASSIGN = 405;
  public const int OP_SUB_ASSIGN = 406;
  public const int OP_SHIFT_LEFT_ASSIGN = 407;
  public const int OP_SHIFT_RIGHT_ASSIGN = 408;
  public const int OP_AND_ASSIGN = 409;
  public const int OP_XOR_ASSIGN = 410;
  public const int OP_OR_ASSIGN = 411;
  public const int OP_PTR = 412;
  public const int OP_COALESCING = 413;
  public const int OP_GENERICS_LT = 414;
  public const int OP_GENERICS_LT_DECL = 415;
  public const int OP_GENERICS_GT = 416;
  public const int LITERAL = 417;
  public const int IDENTIFIER = 418;
  public const int OPEN_PARENS_LAMBDA = 419;
  public const int OPEN_PARENS_CAST = 420;
  public const int GENERIC_DIMENSION = 421;
  public const int DEFAULT_COLON = 422;
  public const int OPEN_BRACKET_EXPR = 423;
  public const int EVAL_STATEMENT_PARSER = 424;
  public const int EVAL_COMPILATION_UNIT_PARSER = 425;
  public const int EVAL_USING_DECLARATIONS_UNIT_PARSER = 426;
  public const int DOC_SEE = 427;
  public const int GENERATE_COMPLETION = 428;
  public const int COMPLETE_COMPLETION = 429;
  public const int UMINUS = 430;
  public const int yyErrorCode = 256;
 }
 namespace yyParser {
  using System;
  /** thrown for irrecoverable syntax errors and stack overflow.
    */
  internal class yyException : System.Exception {
    public yyException (string message) : base (message) {
    }
  }
  internal class yyUnexpectedEof : yyException {
    public yyUnexpectedEof (string message) : base (message) {
    }
    public yyUnexpectedEof () : base ("") {
    }
  }

  /** must be implemented by a scanner object to supply input to the parser.
    */
  internal interface yyInput {
    /** move on to next token.
        @return false if positioned beyond tokens.
        @throws IOException on input error.
      */
    bool advance (); // throws java.io.IOException;
    /** classifies current token.
        Should not be called if advance() returned false.
        @return current %token or single character.
      */
    int token ();
    /** associated with current token.
        Should not be called if advance() returned false.
        @return value for token().
      */
    Object value ();
  }
 }
} // close outermost namespace, that MUST HAVE BEEN opened in the prolog
