﻿
/** 
 * @overview ASP.NET Core SignalR JavaScript Client.
 * @version 1.0.0.
 * @license
 * Copyright (c) .NET Foundation. All rights reserved.
 * Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.
 */
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
    typeof define === 'function' && define.amd ? define(factory) :
      (global.signalR = factory());
}(this, (function () {
  'use strict';

  var commonjsGlobal = typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

  function commonjsRequire() {
    throw new Error('Dynamic requires are not currently supported by rollup-plugin-commonjs');
  }

  function unwrapExports(x) {
    return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
  }

  function createCommonjsModule(fn, module) {
    return module = {
      exports: {}
    }, fn(module, module.exports), module.exports;
  }

  /*! *****************************************************************************
    Copyright (c) Microsoft Corporation. All rights reserved.
    Licensed under the Apache License, Version 2.0 (the "License"); you may not use
    this file except in compliance with the License. You may obtain a copy of the
    License at http://www.apache.org/licenses/LICENSE-2.0
    
    THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
    WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
    MERCHANTABLITY OR NON-INFRINGEMENT.
    
    See the Apache Version 2.0 License for specific language governing permissions
    and limitations under the License.
    ***************************************************************************** */
  /* global Reflect, Promise */

  var extendStatics = Object.setPrototypeOf ||
    ({
      __proto__: []
    }
      instanceof Array && function (d, b) {
        d.__proto__ = b;
      }) ||
    function (d, b) {
      for (var p in b)
        if (b.hasOwnProperty(p)) d[p] = b[p];
    };

  function __extends(d, b) {
    extendStatics(d, b);

    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  }

  var __assign = Object.assign || function __assign(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
      s = arguments[i];
      for (var p in s)
        if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
    }
    return t;
  };

  function __rest(s, e) {
    var t = {};
    for (var p in s)
      if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
      for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++)
        if (e.indexOf(p[i]) < 0)
          t[p[i]] = s[p[i]];
    return t;
  }

  function __decorate(decorators, target, key, desc) {
    var c = arguments.length,
      r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
      d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  }

  function __param(paramIndex, decorator) {
    return function (target, key) {
      decorator(target, key, paramIndex);
    }
  }

  function __metadata(metadataKey, metadataValue) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
  }

  function __awaiter(thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
      function fulfilled(value) {
        try {
          step(generator.next(value));
        } catch (e) {
          reject(e);
        }
      }

      function rejected(value) {
        try {
          step(generator["throw"](value));
        } catch (e) {
          reject(e);
        }
      }

      function step(result) {
        result.done ? resolve(result.value) : new P(function (resolve) {
          resolve(result.value);
        }).then(fulfilled, rejected);
      }
      step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
  }

  function __generator(thisArg, body) {
    var _ = {
      label: 0,
      sent: function () {
        if (t[0] & 1) throw t[1];
        return t[1];
      },
      trys: [],
      ops: []
    },
      f, y, t, g;
    return g = {
      next: verb(0),
      "throw": verb(1),
      "return": verb(2)
    }, typeof Symbol === "function" && (g[Symbol.iterator] = function () {
      return this;
    }), g;

    function verb(n) {
      return function (v) {
        return step([n, v]);
      };
    }

    function step(op) {
      if (f) throw new TypeError("Generator is already executing.");
      while (_) try {
        if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
        if (y = 0, t) op = [0, t.value];
        switch (op[0]) {
          case 0:
          case 1:
            t = op;
            break;
          case 4:
            _.label++;
            return {
              value: op[1],
              done: false
            };
          case 5:
            _.label++;
            y = op[1];
            op = [0];
            continue;
          case 7:
            op = _.ops.pop();
            _.trys.pop();
            continue;
          default:
            if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
              _ = 0;
              continue;
            }
            if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) {
              _.label = op[1];
              break;
            }
            if (op[0] === 6 && _.label < t[1]) {
              _.label = t[1];
              t = op;
              break;
            }
            if (t && _.label < t[2]) {
              _.label = t[2];
              _.ops.push(op);
              break;
            }
            if (t[2]) _.ops.pop();
            _.trys.pop();
            continue;
        }
        op = body.call(thisArg, _);
      } catch (e) {
        op = [6, e];
        y = 0;
      } finally {
          f = t = 0;
        }
      if (op[0] & 5) throw op[1];
      return {
        value: op[0] ? op[1] : void 0,
        done: true
      };
    }
  }

  function __exportStar(m, exports) {
    for (var p in m)
      if (!exports.hasOwnProperty(p)) exports[p] = m[p];
  }

  function __values(o) {
    var m = typeof Symbol === "function" && o[Symbol.iterator],
      i = 0;
    if (m) return m.call(o);
    return {
      next: function () {
        if (o && i >= o.length) o = void 0;
        return {
          value: o && o[i++],
          done: !o
        };
      }
    };
  }

  function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o),
      r, ar = [],
      e;
    try {
      while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    } catch (error) {
      e = {
        error: error
      };
    } finally {
      try {
        if (r && !r.done && (m = i["return"])) m.call(i);
      } finally {
        if (e) throw e.error;
      }
    }
    return ar;
  }

  function __spread() {
    for (var ar = [], i = 0; i < arguments.length; i++)
      ar = ar.concat(__read(arguments[i]));
    return ar;
  }

  function __await(v) {
    return this instanceof __await ? (this.v = v, this) : new __await(v);
  }

  function __asyncGenerator(thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []),
      i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () {
      return this;
    }, i;

    function verb(n) {
      if (g[n]) i[n] = function (v) {
        return new Promise(function (a, b) {
          q.push([n, v, a, b]) > 1 || resume(n, v);
        });
      };
    }

    function resume(n, v) {
      try {
        step(g[n](v));
      } catch (e) {
        settle(q[0][3], e);
      }
    }

    function step(r) {
      r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r);
    }

    function fulfill(value) {
      resume("next", value);
    }

    function reject(value) {
      resume("throw", value);
    }

    function settle(f, v) {
      if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]);
    }
  }

  function __asyncDelegator(o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) {
      throw e;
    }), verb("return"), i[Symbol.iterator] = function () {
      return this;
    }, i;

    function verb(n, f) {
      if (o[n]) i[n] = function (v) {
        return (p = !p) ? {
          value: __await(o[n](v)),
          done: n === "return"
        } : f ? f(v) : v;
      };
    }
  }

  function __asyncValues(o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator];
    return m ? m.call(o) : typeof __values === "function" ? __values(o) : o[Symbol.iterator]();
  }

  function __makeTemplateObject(cooked, raw) {
    if (Object.defineProperty) {
      Object.defineProperty(cooked, "raw", {
        value: raw
      });
    } else {
      cooked.raw = raw;
    }
    return cooked;
  }

  function __importStar(mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null)
      for (var k in mod)
        if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result.default = mod;
    return result;
  }

  function __importDefault(mod) {
    return (mod && mod.__esModule) ? mod : {
      default: mod
    };
  }


  var tslib_1 = Object.freeze({
    __extends: __extends,
    __assign: __assign,
    __rest: __rest,
    __decorate: __decorate,
    __param: __param,
    __metadata: __metadata,
    __awaiter: __awaiter,
    __generator: __generator,
    __exportStar: __exportStar,
    __values: __values,
    __read: __read,
    __spread: __spread,
    __await: __await,
    __asyncGenerator: __asyncGenerator,
    __asyncDelegator: __asyncDelegator,
    __asyncValues: __asyncValues,
    __makeTemplateObject: __makeTemplateObject,
    __importStar: __importStar,
    __importDefault: __importDefault
  });

  var es6Promise_auto = createCommonjsModule(function (module, exports) {
    /*!
     * @overview es6-promise - a tiny implementation of Promises/A+.
     * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
     * @license   Licensed under MIT license
     *            See https://raw.githubusercontent.com/stefanpenner/es6-promise/master/LICENSE
     * @version   v4.2.2+97478eb6
     */

    (function (global, factory) {
      module.exports = factory();
    }(commonjsGlobal, (function () {
      function objectOrFunction(x) {
        var type = typeof x;
        return x !== null && (type === 'object' || type === 'function');
      }

      function isFunction(x) {
        return typeof x === 'function';
      }



      var _isArray = void 0;
      if (Array.isArray) {
        _isArray = Array.isArray;
      } else {
        _isArray = function (x) {
          return Object.prototype.toString.call(x) === '[object Array]';
        };
      }

      var isArray = _isArray;

      var len = 0;
      var vertxNext = void 0;
      var customSchedulerFn = void 0;

      var asap = function asap(callback, arg) {
        queue[len] = callback;
        queue[len + 1] = arg;
        len += 2;
        if (len === 2) {
          // If len is 2, that means that we need to schedule an async flush.
          // If additional callbacks are queued before the queue is flushed, they
          // will be processed by this flush that we are scheduling.
          if (customSchedulerFn) {
            customSchedulerFn(flush);
          } else {
            scheduleFlush();
          }
        }
      };

      function setScheduler(scheduleFn) {
        customSchedulerFn = scheduleFn;
      }

      function setAsap(asapFn) {
        asap = asapFn;
      }

      var browserWindow = typeof window !== 'undefined' ? window : undefined;
      var browserGlobal = browserWindow || {};
      var BrowserMutationObserver = browserGlobal.MutationObserver || browserGlobal.WebKitMutationObserver;
      var isNode = typeof self === 'undefined' && typeof process !== 'undefined' && {}.toString.call(process) === '[object process]';

      // test for web worker but not in IE10
      var isWorker = typeof Uint8ClampedArray !== 'undefined' && typeof importScripts !== 'undefined' && typeof MessageChannel !== 'undefined';

      // node
      function useNextTick() {
        // node version 0.10.x displays a deprecation warning when nextTick is used recursively
        // see https://github.com/cujojs/when/issues/410 for details
        return function () {
          return process.nextTick(flush);
        };
      }

      // vertx
      function useVertxTimer() {
        if (typeof vertxNext !== 'undefined') {
          return function () {
            vertxNext(flush);
          };
        }

        return useSetTimeout();
      }

      function useMutationObserver() {
        var iterations = 0;
        var observer = new BrowserMutationObserver(flush);
        var node = document.createTextNode('');
        observer.observe(node, {
          characterData: true
        });

        return function () {
          node.data = iterations = ++iterations % 2;
        };
      }

      // web worker
      function useMessageChannel() {
        var channel = new MessageChannel();
        channel.port1.onmessage = flush;
        return function () {
          return channel.port2.postMessage(0);
        };
      }

      function useSetTimeout() {
        // Store setTimeout reference so es6-promise will be unaffected by
        // other code modifying setTimeout (like sinon.useFakeTimers())
        var globalSetTimeout = setTimeout;
        return function () {
          return globalSetTimeout(flush, 1);
        };
      }

      var queue = new Array(1000);

      function flush() {
        for (var i = 0; i < len; i += 2) {
          var callback = queue[i];
          var arg = queue[i + 1];

          callback(arg);

          queue[i] = undefined;
          queue[i + 1] = undefined;
        }

        len = 0;
      }

      function attemptVertx() {
        try {
          var r = commonjsRequire;
          var vertx = r('vertx');
          vertxNext = vertx.runOnLoop || vertx.runOnContext;
          return useVertxTimer();
        } catch (e) {
          return useSetTimeout();
        }
      }

      var scheduleFlush = void 0;
      // Decide what async method to use to triggering processing of queued callbacks:
      if (isNode) {
        scheduleFlush = useNextTick();
      } else if (BrowserMutationObserver) {
        scheduleFlush = useMutationObserver();
      } else if (isWorker) {
        scheduleFlush = useMessageChannel();
      } else if (browserWindow === undefined && typeof commonjsRequire === 'function') {
        scheduleFlush = attemptVertx();
      } else {
        scheduleFlush = useSetTimeout();
      }

      function then(onFulfillment, onRejection) {
        var parent = this;

        var child = new this.constructor(noop);

        if (child[PROMISE_ID] === undefined) {
          makePromise(child);
        }

        var _state = parent._state;


        if (_state) {
          var callback = arguments[_state - 1];
          asap(function () {
            return invokeCallback(_state, child, callback, parent._result);
          });
        } else {
          subscribe(parent, child, onFulfillment, onRejection);
        }

        return child;
      }

      /**
            `Promise.resolve` returns a promise that will become resolved with the
            passed `value`. It is shorthand for the following:
    
            ```javascript
            let promise = new Promise(function(resolve, reject){
              resolve(1);
            });
    
            promise.then(function(value){
              // value === 1
            });
            ```
    
            Instead of writing the above, your code now simply becomes the following:
    
            ```javascript
            let promise = Promise.resolve(1);
    
            promise.then(function(value){
              // value === 1
            });
            ```
    
            @method resolve
            @static
            @param {Any} value value that the returned promise will be resolved with
            Useful for tooling.
            @return {Promise} a promise that will become fulfilled with the given
            `value`
          */
      function resolve$1(object) {
        /*jshint validthis:true */
        var Constructor = this;

        if (object && typeof object === 'object' && object.constructor === Constructor) {
          return object;
        }

        var promise = new Constructor(noop);
        resolve(promise, object);
        return promise;
      }

      var PROMISE_ID = Math.random().toString(36).substring(16);

      function noop() { }

      var PENDING = void 0;
      var FULFILLED = 1;
      var REJECTED = 2;

      var GET_THEN_ERROR = new ErrorObject();

      function selfFulfillment() {
        return new TypeError("You cannot resolve a promise with itself");
      }

      function cannotReturnOwn() {
        return new TypeError('A promises callback cannot return that same promise.');
      }

      function getThen(promise) {
        try {
          return promise.then;
        } catch (error) {
          GET_THEN_ERROR.error = error;
          return GET_THEN_ERROR;
        }
      }

      function tryThen(then$$1, value, fulfillmentHandler, rejectionHandler) {
        try {
          then$$1.call(value, fulfillmentHandler, rejectionHandler);
        } catch (e) {
          return e;
        }
      }

      function handleForeignThenable(promise, thenable, then$$1) {
        asap(function (promise) {
          var sealed = false;
          var error = tryThen(then$$1, thenable, function (value) {
            if (sealed) {
              return;
            }
            sealed = true;
            if (thenable !== value) {
              resolve(promise, value);
            } else {
              fulfill(promise, value);
            }
          }, function (reason) {
            if (sealed) {
              return;
            }
            sealed = true;

            reject(promise, reason);
          }, 'Settle: ' + (promise._label || ' unknown promise'));

          if (!sealed && error) {
            sealed = true;
            reject(promise, error);
          }
        }, promise);
      }

      function handleOwnThenable(promise, thenable) {
        if (thenable._state === FULFILLED) {
          fulfill(promise, thenable._result);
        } else if (thenable._state === REJECTED) {
          reject(promise, thenable._result);
        } else {
          subscribe(thenable, undefined, function (value) {
            return resolve(promise, value);
          }, function (reason) {
            return reject(promise, reason);
          });
        }
      }

      function handleMaybeThenable(promise, maybeThenable, then$$1) {
        if (maybeThenable.constructor === promise.constructor && then$$1 === then && maybeThenable.constructor.resolve === resolve$1) {
          handleOwnThenable(promise, maybeThenable);
        } else {
          if (then$$1 === GET_THEN_ERROR) {
            reject(promise, GET_THEN_ERROR.error);
            GET_THEN_ERROR.error = null;
          } else if (then$$1 === undefined) {
            fulfill(promise, maybeThenable);
          } else if (isFunction(then$$1)) {
            handleForeignThenable(promise, maybeThenable, then$$1);
          } else {
            fulfill(promise, maybeThenable);
          }
        }
      }

      function resolve(promise, value) {
        if (promise === value) {
          reject(promise, selfFulfillment());
        } else if (objectOrFunction(value)) {
          handleMaybeThenable(promise, value, getThen(value));
        } else {
          fulfill(promise, value);
        }
      }

      function publishRejection(promise) {
        if (promise._onerror) {
          promise._onerror(promise._result);
        }

        publish(promise);
      }

      function fulfill(promise, value) {
        if (promise._state !== PENDING) {
          return;
        }

        promise._result = value;
        promise._state = FULFILLED;

        if (promise._subscribers.length !== 0) {
          asap(publish, promise);
        }
      }

      function reject(promise, reason) {
        if (promise._state !== PENDING) {
          return;
        }
        promise._state = REJECTED;
        promise._result = reason;

        asap(publishRejection, promise);
      }

      function subscribe(parent, child, onFulfillment, onRejection) {
        var _subscribers = parent._subscribers;
        var length = _subscribers.length;


        parent._onerror = null;

        _subscribers[length] = child;
        _subscribers[length + FULFILLED] = onFulfillment;
        _subscribers[length + REJECTED] = onRejection;

        if (length === 0 && parent._state) {
          asap(publish, parent);
        }
      }

      function publish(promise) {
        var subscribers = promise._subscribers;
        var settled = promise._state;

        if (subscribers.length === 0) {
          return;
        }

        var child = void 0,
          callback = void 0,
          detail = promise._result;

        for (var i = 0; i < subscribers.length; i += 3) {
          child = subscribers[i];
          callback = subscribers[i + settled];

          if (child) {
            invokeCallback(settled, child, callback, detail);
          } else {
            callback(detail);
          }
        }

        promise._subscribers.length = 0;
      }

      function ErrorObject() {
        this.error = null;
      }

      var TRY_CATCH_ERROR = new ErrorObject();

      function tryCatch(callback, detail) {
        try {
          return callback(detail);
        } catch (e) {
          TRY_CATCH_ERROR.error = e;
          return TRY_CATCH_ERROR;
        }
      }

      function invokeCallback(settled, promise, callback, detail) {
        var hasCallback = isFunction(callback),
          value = void 0,
          error = void 0,
          succeeded = void 0,
          failed = void 0;

        if (hasCallback) {
          value = tryCatch(callback, detail);

          if (value === TRY_CATCH_ERROR) {
            failed = true;
            error = value.error;
            value.error = null;
          } else {
            succeeded = true;
          }

          if (promise === value) {
            reject(promise, cannotReturnOwn());
            return;
          }
        } else {
          value = detail;
          succeeded = true;
        }

        if (promise._state !== PENDING) {
          // noop
        } else if (hasCallback && succeeded) {
          resolve(promise, value);
        } else if (failed) {
          reject(promise, error);
        } else if (settled === FULFILLED) {
          fulfill(promise, value);
        } else if (settled === REJECTED) {
          reject(promise, value);
        }
      }

      function initializePromise(promise, resolver) {
        try {
          resolver(function resolvePromise(value) {
            resolve(promise, value);
          }, function rejectPromise(reason) {
            reject(promise, reason);
          });
        } catch (e) {
          reject(promise, e);
        }
      }

      var id = 0;

      function nextId() {
        return id++;
      }

      function makePromise(promise) {
        promise[PROMISE_ID] = id++;
        promise._state = undefined;
        promise._result = undefined;
        promise._subscribers = [];
      }

      function validationError() {
        return new Error('Array Methods must be provided an Array');
      }

      function validationError() {
        return new Error('Array Methods must be provided an Array');
      }

      var Enumerator = function () {
        function Enumerator(Constructor, input) {
          this._instanceConstructor = Constructor;
          this.promise = new Constructor(noop);

          if (!this.promise[PROMISE_ID]) {
            makePromise(this.promise);
          }

          if (isArray(input)) {
            this.length = input.length;
            this._remaining = input.length;

            this._result = new Array(this.length);

            if (this.length === 0) {
              fulfill(this.promise, this._result);
            } else {
              this.length = this.length || 0;
              this._enumerate(input);
              if (this._remaining === 0) {
                fulfill(this.promise, this._result);
              }
            }
          } else {
            reject(this.promise, validationError());
          }
        }

        Enumerator.prototype._enumerate = function _enumerate(input) {
          for (var i = 0; this._state === PENDING && i < input.length; i++) {
            this._eachEntry(input[i], i);
          }
        };

        Enumerator.prototype._eachEntry = function _eachEntry(entry, i) {
          var c = this._instanceConstructor;
          var resolve$$1 = c.resolve;


          if (resolve$$1 === resolve$1) {
            var _then = getThen(entry);

            if (_then === then && entry._state !== PENDING) {
              this._settledAt(entry._state, i, entry._result);
            } else if (typeof _then !== 'function') {
              this._remaining--;
              this._result[i] = entry;
            } else if (c === Promise$2) {
              var promise = new c(noop);
              handleMaybeThenable(promise, entry, _then);
              this._willSettleAt(promise, i);
            } else {
              this._willSettleAt(new c(function (resolve$$1) {
                return resolve$$1(entry);
              }), i);
            }
          } else {
            this._willSettleAt(resolve$$1(entry), i);
          }
        };

        Enumerator.prototype._settledAt = function _settledAt(state, i, value) {
          var promise = this.promise;


          if (promise._state === PENDING) {
            this._remaining--;

            if (state === REJECTED) {
              reject(promise, value);
            } else {
              this._result[i] = value;
            }
          }

          if (this._remaining === 0) {
            fulfill(promise, this._result);
          }
        };

        Enumerator.prototype._willSettleAt = function _willSettleAt(promise, i) {
          var enumerator = this;

          subscribe(promise, undefined, function (value) {
            return enumerator._settledAt(FULFILLED, i, value);
          }, function (reason) {
            return enumerator._settledAt(REJECTED, i, reason);
          });
        };

        return Enumerator;
      }();

      function all(entries) {
        return new Enumerator(this, entries).promise;
      }

      function race(entries) {
        /*jshint validthis:true */
        var Constructor = this;

        if (!isArray(entries)) {
          return new Constructor(function (_, reject) {
            return reject(new TypeError('You must pass an array to race.'));
          });
        } else {
          return new Constructor(function (resolve, reject) {
            var length = entries.length;
            for (var i = 0; i < length; i++) {
              Constructor.resolve(entries[i]).then(resolve, reject);
            }
          });
        }
      }

      /**
            `Promise.reject` returns a promise rejected with the passed `reason`.
            It is shorthand for the following:
    
            ```javascript
            let promise = new Promise(function(resolve, reject){
              reject(new Error('WHOOPS'));
            });
    
            promise.then(function(value){
              // Code here doesn't run because the promise is rejected!
            }, function(reason){
              // reason.message === 'WHOOPS'
            });
            ```
    
            Instead of writing the above, your code now simply becomes the following:
    
            ```javascript
            let promise = Promise.reject(new Error('WHOOPS'));
    
            promise.then(function(value){
              // Code here doesn't run because the promise is rejected!
            }, function(reason){
              // reason.message === 'WHOOPS'
            });
            ```
    
            @method reject
            @static
            @param {Any} reason value that the returned promise will be rejected with.
            Useful for tooling.
            @return {Promise} a promise rejected with the given `reason`.
          */
      function reject$1(reason) {
        /*jshint validthis:true */
        var Constructor = this;
        var promise = new Constructor(noop);
        reject(promise, reason);
        return promise;
      }

      function needsResolver() {
        throw new TypeError('You must pass a resolver function as the first argument to the promise constructor');
      }

      function needsNew() {
        throw new TypeError("Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function.");
      }

      var Promise$2 = function () {
        function Promise(resolver) {
          this[PROMISE_ID] = nextId();
          this._result = this._state = undefined;
          this._subscribers = [];

          if (noop !== resolver) {
            typeof resolver !== 'function' && needsResolver();
            this instanceof Promise ? initializePromise(this, resolver) : needsNew();
          }
        }



        Promise.prototype.catch = function _catch(onRejection) {
          return this.then(null, onRejection);
        };

        Promise.prototype.finally = function _finally(callback) {
          var promise = this;
          var constructor = promise.constructor;

          return promise.then(function (value) {
            return constructor.resolve(callback()).then(function () {
              return value;
            });
          }, function (reason) {
            return constructor.resolve(callback()).then(function () {
              throw reason;
            });
          });
        };

        return Promise;
      }();

      Promise$2.prototype.then = then;
      Promise$2.all = all;
      Promise$2.race = race;
      Promise$2.resolve = resolve$1;
      Promise$2.reject = reject$1;
      Promise$2._setScheduler = setScheduler;
      Promise$2._setAsap = setAsap;
      Promise$2._asap = asap;

      /*global self*/
      function polyfill() {
        var local = void 0;

        if (typeof commonjsGlobal !== 'undefined') {
          local = commonjsGlobal;
        } else if (typeof self !== 'undefined') {
          local = self;
        } else {
          try {
            local = Function('return this')();
          } catch (e) {
            throw new Error('polyfill failed because global object is unavailable in this environment');
          }
        }

        var P = local.Promise;

        if (P) {
          var promiseToString = null;
          try {
            promiseToString = Object.prototype.toString.call(P.resolve());
          } catch (e) {
            // silently ignored
          }

          if (promiseToString === '[object Promise]' && !P.cast) {
            return;
          }
        }

        local.Promise = Promise$2;
      }

      // Strange compat..
      Promise$2.polyfill = polyfill;
      Promise$2.Promise = Promise$2;

      Promise$2.polyfill();

      return Promise$2;

    })));




  });

  var Errors = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });

    /** Error thrown when an HTTP request fails. */
    var HttpError = /** @class */ (function (_super) {
      tslib_1.__extends(HttpError, _super);
      /** Constructs a new instance of {@link HttpError}.
       *
       * @param {string} errorMessage A descriptive error message.
       * @param {number} statusCode The HTTP status code represented by this error.
       */
      function HttpError(errorMessage, statusCode) {
        var _newTarget = this.constructor;
        var _this = this;
        var trueProto = _newTarget.prototype;
        _this = _super.call(this, errorMessage) || this;
        _this.statusCode = statusCode;
        // Workaround issue in Typescript compiler
        // https://github.com/Microsoft/TypeScript/issues/13965#issuecomment-278570200
        _this.__proto__ = trueProto;
        return _this;
      }
      return HttpError;
    }(Error));
    exports.HttpError = HttpError;
    /** Error thrown when a timeout elapses. */
    var TimeoutError = /** @class */ (function (_super) {
      tslib_1.__extends(TimeoutError, _super);
      /** Constructs a new instance of {@link TimeoutError}.
       *
       * @param {string} errorMessage A descriptive error message.
       */
      function TimeoutError(errorMessage) {
        var _newTarget = this.constructor;
        if (errorMessage === void 0) {
          errorMessage = "A timeout occurred.";
        }
        var _this = this;
        var trueProto = _newTarget.prototype;
        _this = _super.call(this, errorMessage) || this;
        // Workaround issue in Typescript compiler
        // https://github.com/Microsoft/TypeScript/issues/13965#issuecomment-278570200
        _this.__proto__ = trueProto;
        return _this;
      }
      return TimeoutError;
    }(Error));
    exports.TimeoutError = TimeoutError;

  });

  unwrapExports(Errors);
  var Errors_1 = Errors.HttpError;
  var Errors_2 = Errors.TimeoutError;

  var ILogger = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    // These values are designed to match the ASP.NET Log Levels since that's the pattern we're emulating here.
    /** Indicates the severity of a log message.
     *
     * Log Levels are ordered in increasing severity. So `Debug` is more severe than `Trace`, etc.
     */
    var LogLevel;
    (function (LogLevel) {
      /** Log level for very low severity diagnostic messages. */
      LogLevel[LogLevel["Trace"] = 0] = "Trace";
      /** Log level for low severity diagnostic messages. */
      LogLevel[LogLevel["Debug"] = 1] = "Debug";
      /** Log level for informational diagnostic messages. */
      LogLevel[LogLevel["Information"] = 2] = "Information";
      /** Log level for diagnostic messages that indicate a non-fatal problem. */
      LogLevel[LogLevel["Warning"] = 3] = "Warning";
      /** Log level for diagnostic messages that indicate a failure in the current operation. */
      LogLevel[LogLevel["Error"] = 4] = "Error";
      /** Log level for diagnostic messages that indicate a failure that will terminate the entire application. */
      LogLevel[LogLevel["Critical"] = 5] = "Critical";
      /** The highest possible log level. Used when configuring logging to indicate that no log messages should be emitted. */
      LogLevel[LogLevel["None"] = 6] = "None";
    })(LogLevel = exports.LogLevel || (exports.LogLevel = {}));

  });

  unwrapExports(ILogger);
  var ILogger_1 = ILogger.LogLevel;

  var HttpClient_1 = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });



    /** Represents an HTTP response. */
    var HttpResponse = /** @class */ (function () {
      function HttpResponse(statusCode, statusText, content) {
        this.statusCode = statusCode;
        this.statusText = statusText;
        this.content = content;
      }
      return HttpResponse;
    }());
    exports.HttpResponse = HttpResponse;
    /** Abstraction over an HTTP client.
     *
     * This class provides an abstraction over an HTTP client so that a different implementation can be provided on different platforms.
     */
    var HttpClient = /** @class */ (function () {
      function HttpClient() { }
      HttpClient.prototype.get = function (url, options) {
        return this.send(tslib_1.__assign({}, options, {
          method: "GET",
          url: url
        }));
      };
      HttpClient.prototype.post = function (url, options) {
        return this.send(tslib_1.__assign({}, options, {
          method: "POST",
          url: url
        }));
      };
      HttpClient.prototype.delete = function (url, options) {
        return this.send(tslib_1.__assign({}, options, {
          method: "DELETE",
          url: url
        }));
      };
      return HttpClient;
    }());
    exports.HttpClient = HttpClient;
    /** Default implementation of {@link HttpClient}. */
    var DefaultHttpClient = /** @class */ (function (_super) {
      tslib_1.__extends(DefaultHttpClient, _super);
      /** Creates a new instance of the {@link DefaultHttpClient}, using the provided {@link ILogger} to log messages. */
      function DefaultHttpClient(logger) {
        var _this = _super.call(this) || this;
        _this.logger = logger;
        return _this;
      }
      /** @inheritDoc */
      var num = 1
      DefaultHttpClient.prototype.send = function (request) {
        var _this = this;

        return new Promise(function (resolve, reject) {
          var header = {
            "X-Requested-With": "XMLHttpRequest"
          }
          var responseType = 'text'
          if (request.headers != null) {
            Object.keys(request.headers)
              .forEach(function (header) {
                return header = {
                  header: request.headers[header]
                };
              });
          }
          if (request.responseType) {
            responseType = request.responseType;
            }

            var requestUrl;
            if (request.url.indexOf('/negotiate') !== 0) {
                requestUrl = request.url.replace('ws://', 'http://').replace('wss://', 'https://');
            } else {
                requestUrl = request.url;
            }

          const xmlrequest = wx.request({
              url: requestUrl,
            data: request.content || "",
            header: header,
            method: request.method,
            responseType: responseType,
            withCredentials: true,
            success: function (res) {
              if (request.abortSignal) {
                request.abortSignal.onabort = null;
              }
              const statusText = res.errMsg.split(':')[1]
              let responseText = JSON.stringify(res.data)
              if (typeof res.data == "object") {
                responseText = JSON.stringify(res.data)
              } else {
                responseText = res.data
              }
              if (res.statusCode >= 200 && res.statusCode < 300) {
                resolve(new HttpResponse(res.statusCode, statusText, responseText));
              } else {
                reject(new Errors.HttpError(responseText, res.statusCode));
              }
            },
            fail: function (res) {
              if (res.errMsg.includes('timeout')) {
                _this.logger.log(ILogger.LogLevel.Warning, "Timeout from HTTP request.");
                reject(new Errors.TimeoutError());
              } else {
                _this.logger.log(ILogger.LogLevel.Warning, "Error from HTTP request. " + res.statusCode + ": " + res.errMsg);
                reject(new Errors.HttpError(res.errMsg, res.statusCode));
              }
            },
            complete: function (res) { },
          })
          if (request.abortSignal) {
            request.abortSignal.onabort = function () {
              xmlrequest.abort();
            };
          }
        });
      };
      return DefaultHttpClient;
    }(HttpClient));
    exports.DefaultHttpClient = DefaultHttpClient;

  });
  unwrapExports(HttpClient_1);
  var HttpClient_2 = HttpClient_1.HttpResponse;
  var HttpClient_3 = HttpClient_1.HttpClient;
  var HttpClient_4 = HttpClient_1.DefaultHttpClient;

  var TextMessageFormat_1 = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    // Not exported from index
    var TextMessageFormat = /** @class */ (function () {
      function TextMessageFormat() { }
      TextMessageFormat.write = function (output) {
        return "" + output + TextMessageFormat.RecordSeparator;
      };
      TextMessageFormat.parse = function (input) {
        if (input[input.length - 1] !== TextMessageFormat.RecordSeparator) {
          throw new Error("Message is incomplete.");
        }
        var messages = input.split(TextMessageFormat.RecordSeparator);
        messages.pop();
        return messages;
      };
      TextMessageFormat.RecordSeparatorCode = 0x1e;
      TextMessageFormat.RecordSeparator = String.fromCharCode(TextMessageFormat.RecordSeparatorCode);
      return TextMessageFormat;
    }());
    exports.TextMessageFormat = TextMessageFormat;

  });

  unwrapExports(TextMessageFormat_1);
  var TextMessageFormat_2 = TextMessageFormat_1.TextMessageFormat;

  var HandshakeProtocol_1 = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });

    var HandshakeProtocol = /** @class */ (function () {
      function HandshakeProtocol() { }
      // Handshake request is always JSON
      HandshakeProtocol.prototype.writeHandshakeRequest = function (handshakeRequest) {
        return TextMessageFormat_1.TextMessageFormat.write(JSON.stringify(handshakeRequest));
      };
      HandshakeProtocol.prototype.parseHandshakeResponse = function (data) {
        var responseMessage;
        var messageData;
        var remainingData;
        if (data instanceof ArrayBuffer) {
          // Format is binary but still need to read JSON text from handshake response
          var binaryData = new Uint8Array(data);
          var separatorIndex = binaryData.indexOf(TextMessageFormat_1.TextMessageFormat.RecordSeparatorCode);
          if (separatorIndex === -1) {
            throw new Error("Message is incomplete.");
          }
          // content before separator is handshake response
          // optional content after is additional messages
          var responseLength = separatorIndex + 1;
          messageData = String.fromCharCode.apply(null, binaryData.slice(0, responseLength));
          remainingData = (binaryData.byteLength > responseLength) ? binaryData.slice(responseLength).buffer : null;
        } else {
          var textData = data;
          var separatorIndex = textData.indexOf(TextMessageFormat_1.TextMessageFormat.RecordSeparator);
          if (separatorIndex === -1) {
            throw new Error("Message is incomplete.");
          }
          // content before separator is handshake response
          // optional content after is additional messages
          var responseLength = separatorIndex + 1;
          messageData = textData.substring(0, responseLength);
          remainingData = (textData.length > responseLength) ? textData.substring(responseLength) : null;
        }
        // At this point we should have just the single handshake message
        var messages = TextMessageFormat_1.TextMessageFormat.parse(messageData);
        responseMessage = JSON.parse(messages[0]);
        // multiple messages could have arrived with handshake
        // return additional data to be parsed as usual, or null if all parsed
        return [remainingData, responseMessage];
      };
      return HandshakeProtocol;
    }());
    exports.HandshakeProtocol = HandshakeProtocol;

  });

  unwrapExports(HandshakeProtocol_1);
  var HandshakeProtocol_2 = HandshakeProtocol_1.HandshakeProtocol;

  var IHubProtocol = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    /** Defines the type of a Hub Message. */
    var MessageType;
    (function (MessageType) {
      /** Indicates the message is an Invocation message and implements the {@link InvocationMessage} interface. */
      MessageType[MessageType["Invocation"] = 1] = "Invocation";
      /** Indicates the message is a StreamItem message and implements the {@link StreamItemMessage} interface. */
      MessageType[MessageType["StreamItem"] = 2] = "StreamItem";
      /** Indicates the message is a Completion message and implements the {@link CompletionMessage} interface. */
      MessageType[MessageType["Completion"] = 3] = "Completion";
      /** Indicates the message is a Stream Invocation message and implements the {@link StreamInvocationMessage} interface. */
      MessageType[MessageType["StreamInvocation"] = 4] = "StreamInvocation";
      /** Indicates the message is a Cancel Invocation message and implements the {@link CancelInvocationMessage} interface. */
      MessageType[MessageType["CancelInvocation"] = 5] = "CancelInvocation";
      /** Indicates the message is a Ping message and implements the {@link PingMessage} interface. */
      MessageType[MessageType["Ping"] = 6] = "Ping";
      /** Indicates the message is a Close message and implements the {@link CloseMessage} interface. */
      MessageType[MessageType["Close"] = 7] = "Close";
    })(MessageType = exports.MessageType || (exports.MessageType = {}));

  });

  unwrapExports(IHubProtocol);
  var IHubProtocol_1 = IHubProtocol.MessageType;

  var Loggers = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    /** A logger that does nothing when log messages are sent to it. */
    var NullLogger = /** @class */ (function () {
      function NullLogger() { }
      /** @inheritDoc */
      NullLogger.prototype.log = function (logLevel, message) { };
      /** The singleton instance of the {@link NullLogger}. */
      NullLogger.instance = new NullLogger();
      return NullLogger;
    }());
    exports.NullLogger = NullLogger;

  });

  unwrapExports(Loggers);
  var Loggers_1 = Loggers.NullLogger;

  var Utils = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });



    var Arg = /** @class */ (function () {
      function Arg() { }
      Arg.isRequired = function (val, name) {
        if (val === null || val === undefined) {
          throw new Error("The '" + name + "' argument is required.");
        }
      };
      Arg.isIn = function (val, values, name) {
        // TypeScript enums have keys for **both** the name and the value of each enum member on the type itself.
        if (!(val in values)) {
          throw new Error("Unknown " + name + " value: " + val + ".");
        }
      };
      return Arg;
    }());
    exports.Arg = Arg;

    function getDataDetail(data, includeContent) {
      var length = null;
      if (data instanceof ArrayBuffer) {
        length = "Binary data of length " + data.byteLength;
        if (includeContent) {
          length += ". Content: '" + formatArrayBuffer(data) + "'";
        }
      } else if (typeof data === "string") {
        length = "String data of length " + data.length;
        if (includeContent) {
          length += ". Content: '" + data + "'.";
        }
      }
      return length;
    }
    exports.getDataDetail = getDataDetail;

    function formatArrayBuffer(data) {
      var view = new Uint8Array(data);
      // Uint8Array.map only supports returning another Uint8Array?
      var str = "";
      view.forEach(function (num) {
        var pad = num < 16 ? "0" : "";
        str += "0x" + pad + num.toString(16) + " ";
      });
      // Trim of trailing space.
      return str.substr(0, str.length - 1);
    }
    exports.formatArrayBuffer = formatArrayBuffer;

    function sendMessage(logger, transportName, httpClient, url, accessTokenFactory, content, logMessageContent) {
      return tslib_1.__awaiter(this, void 0, void 0, function () {
        var headers, token, response, _a;
        return tslib_1.__generator(this, function (_b) {
          switch (_b.label) {
            case 0:
              return [4 /*yield*/, accessTokenFactory()];
            case 1:
              token = _b.sent();
              if (token) {
                headers = (_a = {}, _a["Authorization"] = "Bearer " + token, _a);
              }
              logger.log(ILogger.LogLevel.Trace, "(" + transportName + " transport) sending data. " + getDataDetail(content, logMessageContent) + ".");
              return [4 /*yield*/, httpClient.post(url, {
                content: content,
                headers: headers,
              })];
            case 2:
              response = _b.sent();
              logger.log(ILogger.LogLevel.Trace, "(" + transportName + " transport) request complete. Response status: " + response.statusCode + ".");
              return [2 /*return*/];
          }
        });
      });
    }
    exports.sendMessage = sendMessage;

    function createLogger(logger) {
      if (logger === undefined) {
        return new ConsoleLogger(ILogger.LogLevel.Information);
      }
      if (logger === null) {
        return Loggers.NullLogger.instance;
      }
      if (logger.log) {
        return logger;
      }
      return new ConsoleLogger(logger);
    }
    exports.createLogger = createLogger;
    var Subject = /** @class */ (function () {
      function Subject(cancelCallback) {
        this.observers = [];
        this.cancelCallback = cancelCallback;
      }
      Subject.prototype.next = function (item) {
        for (var _i = 0, _a = this.observers; _i < _a.length; _i++) {
          var observer = _a[_i];
          observer.next(item);
        }
      };
      Subject.prototype.error = function (err) {
        for (var _i = 0, _a = this.observers; _i < _a.length; _i++) {
          var observer = _a[_i];
          if (observer.error) {
            observer.error(err);
          }
        }
      };
      Subject.prototype.complete = function () {
        for (var _i = 0, _a = this.observers; _i < _a.length; _i++) {
          var observer = _a[_i];
          if (observer.complete) {
            observer.complete();
          }
        }
      };
      Subject.prototype.subscribe = function (observer) {
        this.observers.push(observer);
        return new SubjectSubscription(this, observer);
      };
      return Subject;
    }());
    exports.Subject = Subject;
    var SubjectSubscription = /** @class */ (function () {
      function SubjectSubscription(subject, observer) {
        this.subject = subject;
        this.observer = observer;
      }
      SubjectSubscription.prototype.dispose = function () {
        var index = this.subject.observers.indexOf(this.observer);
        if (index > -1) {
          this.subject.observers.splice(index, 1);
        }
        if (this.subject.observers.length === 0) {
          this.subject.cancelCallback().catch(function (_) { });
        }
      };
      return SubjectSubscription;
    }());
    exports.SubjectSubscription = SubjectSubscription;
    var ConsoleLogger = /** @class */ (function () {
      function ConsoleLogger(minimumLogLevel) {
        this.minimumLogLevel = minimumLogLevel;
      }
      ConsoleLogger.prototype.log = function (logLevel, message) {
        if (logLevel >= this.minimumLogLevel) {
          switch (logLevel) {
            case ILogger.LogLevel.Critical:
            case ILogger.LogLevel.Error:
              console.error(ILogger.LogLevel[logLevel] + ": " + message);
              break;
            case ILogger.LogLevel.Warning:
              console.warn(ILogger.LogLevel[logLevel] + ": " + message);
              break;
            case ILogger.LogLevel.Information:
              console.info(ILogger.LogLevel[logLevel] + ": " + message);
              break;
            default:
              // console.debug only goes to attached debuggers in Node, so we use console.log for Trace and Debug
              console.log(ILogger.LogLevel[logLevel] + ": " + message);
              break;
          }
        }
      };
      return ConsoleLogger;
    }());
    exports.ConsoleLogger = ConsoleLogger;

  });

  unwrapExports(Utils);
  var Utils_1 = Utils.Arg;
  var Utils_2 = Utils.getDataDetail;
  var Utils_3 = Utils.formatArrayBuffer;
  var Utils_4 = Utils.sendMessage;
  var Utils_5 = Utils.createLogger;
  var Utils_6 = Utils.Subject;
  var Utils_7 = Utils.SubjectSubscription;
  var Utils_8 = Utils.ConsoleLogger;

  var HubConnection_1 = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });





    var DEFAULT_TIMEOUT_IN_MS = 30 * 1000;
    /** Represents a connection to a SignalR Hub. */
    var HubConnection = /** @class */ (function () {
      function HubConnection(connection, logger, protocol) {
        var _this = this;
        Utils.Arg.isRequired(connection, "connection");
        Utils.Arg.isRequired(logger, "logger");
        Utils.Arg.isRequired(protocol, "protocol");
        this.serverTimeoutInMilliseconds = DEFAULT_TIMEOUT_IN_MS;
        this.logger = logger;
        this.protocol = protocol;
        this.connection = connection;
        this.handshakeProtocol = new HandshakeProtocol_1.HandshakeProtocol();
        this.connection.onreceive = function (data) {
          return _this.processIncomingData(data);
        };
        this.connection.onclose = function (error) {
          return _this.connectionClosed(error);
        };
        this.callbacks = {};
        this.methods = {};
        this.closedCallbacks = [];
        this.id = 0;
      }
      /** @internal */
      // Using a public static factory method means we can have a private constructor and an _internal_
      // create method that can be used by HubConnectionBuilder. An "internal" constructor would just
      // be stripped away and the '.d.ts' file would have no constructor, which is interpreted as a
      // public parameter-less constructor.
      HubConnection.create = function (connection, logger, protocol) {
        return new HubConnection(connection, logger, protocol);
      };
      /** Starts the connection.
       *
       * @returns {Promise<void>} A Promise that resolves when the connection has been successfully established, or rejects with an error.
       */
      HubConnection.prototype.start = function () {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
          var handshakeRequest;
          return tslib_1.__generator(this, function (_a) {
            switch (_a.label) {
              case 0:
                handshakeRequest = {
                  protocol: this.protocol.name,
                  version: this.protocol.version,
                };
                this.logger.log(ILogger.LogLevel.Debug, "Starting HubConnection.");
                this.receivedHandshakeResponse = false;
                return [4 /*yield*/, this.connection.start(this.protocol.transferFormat)];
              case 1:
                _a.sent();
                this.logger.log(ILogger.LogLevel.Debug, "Sending handshake request.");
                return [4 /*yield*/, this.connection.send(this.handshakeProtocol.writeHandshakeRequest(handshakeRequest))];
              case 2:
                _a.sent();
                this.logger.log(ILogger.LogLevel.Information, "Using HubProtocol '" + this.protocol.name + "'.");
                // defensively cleanup timeout in case we receive a message from the server before we finish start
                this.cleanupTimeout();
                this.configureTimeout();
                return [2 /*return*/];
            }
          });
        });
      };
      /** Stops the connection.
       *
       * @returns {Promise<void>} A Promise that resolves when the connection has been successfully terminated, or rejects with an error.
       */
      HubConnection.prototype.stop = function () {
        this.logger.log(ILogger.LogLevel.Debug, "Stopping HubConnection.");
        this.cleanupTimeout();
        return this.connection.stop();
      };
      /** Invokes a streaming hub method on the server using the specified name and arguments.
       *
       * @typeparam T The type of the items returned by the server.
       * @param {string} methodName The name of the server method to invoke.
       * @param {any[]} args The arguments used to invoke the server method.
       * @returns {IStreamResult<T>} An object that yields results from the server as they are received.
       */
      HubConnection.prototype.stream = function (methodName) {
        var _this = this;
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
          args[_i - 1] = arguments[_i];
        }
        var invocationDescriptor = this.createStreamInvocation(methodName, args);
        var subject = new Utils.Subject(function () {
          var cancelInvocation = _this.createCancelInvocation(invocationDescriptor.invocationId);
          var cancelMessage = _this.protocol.writeMessage(cancelInvocation);
          delete _this.callbacks[invocationDescriptor.invocationId];
          return _this.connection.send(cancelMessage);
        });
        this.callbacks[invocationDescriptor.invocationId] = function (invocationEvent, error) {
          if (error) {
            subject.error(error);
            return;
          }
          if (invocationEvent.type === IHubProtocol.MessageType.Completion) {
            if (invocationEvent.error) {
              subject.error(new Error(invocationEvent.error));
            } else {
              subject.complete();
            }
          } else {
            subject.next((invocationEvent.item));
          }
        };
        var message = this.protocol.writeMessage(invocationDescriptor);
        this.connection.send(message)
          .catch(function (e) {
            subject.error(e);
            delete _this.callbacks[invocationDescriptor.invocationId];
          });
        return subject;
      };
      /** Invokes a hub method on the server using the specified name and arguments. Does not wait for a response from the receiver.
       *
       * The Promise returned by this method resolves when the client has sent the invocation to the server. The server may still
       * be processing the invocation.
       *
       * @param {string} methodName The name of the server method to invoke.
       * @param {any[]} args The arguments used to invoke the server method.
       * @returns {Promise<void>} A Promise that resolves when the invocation has been successfully sent, or rejects with an error.
       */
      HubConnection.prototype.send = function (methodName) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
          args[_i - 1] = arguments[_i];
        }
        var invocationDescriptor = this.createInvocation(methodName, args, true);
        var message = this.protocol.writeMessage(invocationDescriptor);
        return this.connection.send(message);
      };
      /** Invokes a hub method on the server using the specified name and arguments.
       *
       * The Promise returned by this method resolves when the server indicates it has finished invoking the method. When the promise
       * resolves, the server has finished invoking the method. If the server method returns a result, it is produced as the result of
       * resolving the Promise.
       *
       * @typeparam T The expected return type.
       * @param {string} methodName The name of the server method to invoke.
       * @param {any[]} args The arguments used to invoke the server method.
       * @returns {Promise<T>} A Promise that resolves with the result of the server method (if any), or rejects with an error.
       */
      HubConnection.prototype.invoke = function (methodName) {
        var _this = this;
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
          args[_i - 1] = arguments[_i];
        }
        var invocationDescriptor = this.createInvocation(methodName, args, false);
        var p = new Promise(function (resolve, reject) {
          _this.callbacks[invocationDescriptor.invocationId] = function (invocationEvent, error) {
            if (error) {
              reject(error);
              return;
            }
            if (invocationEvent.type === IHubProtocol.MessageType.Completion) {
              var completionMessage = invocationEvent;
              if (completionMessage.error) {
                reject(new Error(completionMessage.error));
              } else {
                resolve(completionMessage.result);
              }
            } else {
              reject(new Error("Unexpected message type: " + invocationEvent.type));
            }
          };
          var message = _this.protocol.writeMessage(invocationDescriptor);
          _this.connection.send(message)
            .catch(function (e) {
              reject(e);
              delete _this.callbacks[invocationDescriptor.invocationId];
            });
        });
        return p;
      };
      /** Registers a handler that will be invoked when the hub method with the specified method name is invoked.
       *
       * @param {string} methodName The name of the hub method to define.
       * @param {Function} newMethod The handler that will be raised when the hub method is invoked.
       */
      HubConnection.prototype.on = function (methodName, newMethod) {
        if (!methodName || !newMethod) {
          return;
        }
        methodName = methodName.toLowerCase();
        if (!this.methods[methodName]) {
          this.methods[methodName] = [];
        }
        // Preventing adding the same handler multiple times.
        if (this.methods[methodName].indexOf(newMethod) !== -1) {
          return;
        }
        this.methods[methodName].push(newMethod);
      };
      HubConnection.prototype.off = function (methodName, method) {
        if (!methodName) {
          return;
        }
        methodName = methodName.toLowerCase();
        var handlers = this.methods[methodName];
        if (!handlers) {
          return;
        }
        if (method) {
          var removeIdx = handlers.indexOf(method);
          if (removeIdx !== -1) {
            handlers.splice(removeIdx, 1);
            if (handlers.length === 0) {
              delete this.methods[methodName];
            }
          }
        } else {
          delete this.methods[methodName];
        }
      };
      /** Registers a handler that will be invoked when the connection is closed.
       *
       * @param {Function} callback The handler that will be invoked when the connection is closed. Optionally receives a single argument containing the error that caused the connection to close (if any).
       */
      HubConnection.prototype.onclose = function (callback) {
        if (callback) {
          this.closedCallbacks.push(callback);
        }
      };
      HubConnection.prototype.processIncomingData = function (data) {
        this.cleanupTimeout();
        if (!this.receivedHandshakeResponse) {
          data = this.processHandshakeResponse(data);
          this.receivedHandshakeResponse = true;
        }
        // Data may have all been read when processing handshake response
        if (data) {
          // Parse the messages
          var messages = this.protocol.parseMessages(data, this.logger);
          for (var _i = 0, messages_1 = messages; _i < messages_1.length; _i++) {
            var message = messages_1[_i];
            switch (message.type) {
              case IHubProtocol.MessageType.Invocation:
                this.invokeClientMethod(message);
                break;
              case IHubProtocol.MessageType.StreamItem:
              case IHubProtocol.MessageType.Completion:
                var callback = this.callbacks[message.invocationId];
                if (callback != null) {
                  if (message.type === IHubProtocol.MessageType.Completion) {
                    delete this.callbacks[message.invocationId];
                  }
                  callback(message);
                }
                break;
              case IHubProtocol.MessageType.Ping:
                // Don't care about pings
                break;
              case IHubProtocol.MessageType.Close:
                this.logger.log(ILogger.LogLevel.Information, "Close message received from server.");
                this.connection.stop(message.error ? new Error("Server returned an error on close: " + message.error) : null);
                break;
              default:
                this.logger.log(ILogger.LogLevel.Warning, "Invalid message type: " + message.type);
                break;
            }
          }
        }
        this.configureTimeout();
      };
      HubConnection.prototype.processHandshakeResponse = function (data) {
        var responseMessage;
        var remainingData;
        try {
          _a = this.handshakeProtocol.parseHandshakeResponse(data), remainingData = _a[0], responseMessage = _a[1];
        } catch (e) {
          var message = "Error parsing handshake response: " + e;
          this.logger.log(ILogger.LogLevel.Error, message);
          var error = new Error(message);
          this.connection.stop(error);
          throw error;
        }
        if (responseMessage.error) {
          var message = "Server returned handshake error: " + responseMessage.error;
          this.logger.log(ILogger.LogLevel.Error, message);
          this.connection.stop(new Error(message));
        } else {
          this.logger.log(ILogger.LogLevel.Debug, "Server handshake complete.");
        }
        return remainingData;
        var _a;
      };
      HubConnection.prototype.configureTimeout = function () {
        var _this = this;
        if (!this.connection.features || !this.connection.features.inherentKeepAlive) {
          // Set the timeout timer
          this.timeoutHandle = setTimeout(function () {
            return _this.serverTimeout();
          }, this.serverTimeoutInMilliseconds);
        }
      };
      HubConnection.prototype.serverTimeout = function () {
        // The server hasn't talked to us in a while. It doesn't like us anymore ... :(
        // Terminate the connection
        this.connection.stop(new Error("Server timeout elapsed without receiving a message from the server."));
      };
      HubConnection.prototype.invokeClientMethod = function (invocationMessage) {
        var _this = this;
        var methods = this.methods[invocationMessage.target.toLowerCase()];
        if (methods) {
          methods.forEach(function (m) {
            return m.apply(_this, invocationMessage.arguments);
          });
          if (invocationMessage.invocationId) {
            // This is not supported in v1. So we return an error to avoid blocking the server waiting for the response.
            var message = "Server requested a response, which is not supported in this version of the client.";
            this.logger.log(ILogger.LogLevel.Error, message);
            this.connection.stop(new Error(message));
          }
        } else {
          this.logger.log(ILogger.LogLevel.Warning, "No client method with the name '" + invocationMessage.target + "' found.");
        }
      };
      HubConnection.prototype.connectionClosed = function (error) {
        var _this = this;
        var callbacks = this.callbacks;
        this.callbacks = {};
        Object.keys(callbacks)
          .forEach(function (key) {
            var callback = callbacks[key];
            callback(undefined, error ? error : new Error("Invocation canceled due to connection being closed."));
          });
        this.cleanupTimeout();
        this.closedCallbacks.forEach(function (c) {
          return c.apply(_this, [error]);
        });
      };
      HubConnection.prototype.cleanupTimeout = function () {
        if (this.timeoutHandle) {
          clearTimeout(this.timeoutHandle);
        }
      };
      HubConnection.prototype.createInvocation = function (methodName, args, nonblocking) {
        if (nonblocking) {
          return {
            arguments: args,
            target: methodName,
            type: IHubProtocol.MessageType.Invocation,
          };
        } else {
          var id = this.id;
          this.id++;
          return {
            arguments: args,
            invocationId: id.toString(),
            target: methodName,
            type: IHubProtocol.MessageType.Invocation,
          };
        }
      };
      HubConnection.prototype.createStreamInvocation = function (methodName, args) {
        var id = this.id;
        this.id++;
        return {
          arguments: args,
          invocationId: id.toString(),
          target: methodName,
          type: IHubProtocol.MessageType.StreamInvocation,
        };
      };
      HubConnection.prototype.createCancelInvocation = function (id) {
        return {
          invocationId: id,
          type: IHubProtocol.MessageType.CancelInvocation,
        };
      };
      return HubConnection;
    }());
    exports.HubConnection = HubConnection;

  });

  unwrapExports(HubConnection_1);
  var HubConnection_2 = HubConnection_1.HubConnection;

  var ITransport = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    // This will be treated as a bit flag in the future, so we keep it using power-of-two values.
    /** Specifies a specific HTTP transport type. */
    var HttpTransportType;
    (function (HttpTransportType) {
      /** Specifies no transport preference. */
      HttpTransportType[HttpTransportType["None"] = 0] = "None";
      /** Specifies the WebSockets transport. */
      HttpTransportType[HttpTransportType["WebSockets"] = 1] = "WebSockets";
      /** Specifies the Server-Sent Events transport. */
      HttpTransportType[HttpTransportType["ServerSentEvents"] = 2] = "ServerSentEvents";
      /** Specifies the Long Polling transport. */
      HttpTransportType[HttpTransportType["LongPolling"] = 4] = "LongPolling";
    })(HttpTransportType = exports.HttpTransportType || (exports.HttpTransportType = {}));
    /** Specifies the transfer format for a connection. */
    var TransferFormat;
    (function (TransferFormat) {
      /** Specifies that only text data will be transmitted over the connection. */
      TransferFormat[TransferFormat["Text"] = 1] = "Text";
      /** Specifies that binary data will be transmitted over the connection. */
      TransferFormat[TransferFormat["Binary"] = 2] = "Binary";
    })(TransferFormat = exports.TransferFormat || (exports.TransferFormat = {}));

  });

  unwrapExports(ITransport);
  var ITransport_1 = ITransport.HttpTransportType;
  var ITransport_2 = ITransport.TransferFormat;

  var AbortController_1 = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    // Rough polyfill of https://developer.mozilla.org/en-US/docs/Web/API/AbortController
    // We don't actually ever use the API being polyfilled, we always use the polyfill because
    // it's a very new API right now.
    // Not exported from index.
    var AbortController = /** @class */ (function () {
      function AbortController() {
        this.isAborted = false;
      }
      AbortController.prototype.abort = function () {
        if (!this.isAborted) {
          this.isAborted = true;
          if (this.onabort) {
            this.onabort();
          }
        }
      };
      Object.defineProperty(AbortController.prototype, "signal", {
        get: function () {
          return this;
        },
        enumerable: true,
        configurable: true
      });
      Object.defineProperty(AbortController.prototype, "aborted", {
        get: function () {
          return this.isAborted;
        },
        enumerable: true,
        configurable: true
      });
      return AbortController;
    }());
    exports.AbortController = AbortController;

  });

  unwrapExports(AbortController_1);
  var AbortController_2 = AbortController_1.AbortController;

  var LongPollingTransport_1 = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });






    var SHUTDOWN_TIMEOUT = 5 * 1000;
    // Not exported from 'index', this type is internal.
    var LongPollingTransport = /** @class */ (function () {
      function LongPollingTransport(httpClient, accessTokenFactory, logger, logMessageContent, shutdownTimeout) {
        this.httpClient = httpClient;
        this.accessTokenFactory = accessTokenFactory || (function () {
          return null;
        });
        this.logger = logger;
        this.pollAbort = new AbortController_1.AbortController();
        this.logMessageContent = logMessageContent;
        this.shutdownTimeout = shutdownTimeout || SHUTDOWN_TIMEOUT;
      }
      Object.defineProperty(LongPollingTransport.prototype, "pollAborted", {
        // This is an internal type, not exported from 'index' so this is really just internal.
        get: function () {
          return this.pollAbort.aborted;
        },
        enumerable: true,
        configurable: true
      });
      LongPollingTransport.prototype.connect = function (url, transferFormat) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
          var pollOptions, token, closeError, pollUrl, response;
          return tslib_1.__generator(this, function (_a) {
            switch (_a.label) {
              case 0:
                Utils.Arg.isRequired(url, "url");
                Utils.Arg.isRequired(transferFormat, "transferFormat");
                Utils.Arg.isIn(transferFormat, ITransport.TransferFormat, "transferFormat");
                this.url = url;
                this.logger.log(ILogger.LogLevel.Trace, "(LongPolling transport) Connecting");
                if (transferFormat === ITransport.TransferFormat.Binary) {

                  // This will work if we fix: https://github.com/aspnet/SignalR/issues/742
                  throw new Error("Binary protocols over XmlHttpRequest not implementing advanced features are not supported.");
                }
                pollOptions = {
                  abortSignal: this.pollAbort.signal,
                  headers: {},
                  timeout: 90000,
                };
                if (transferFormat === ITransport.TransferFormat.Binary) {
                  pollOptions.responseType = "arraybuffer";
                }
                return [4 /*yield*/, this.accessTokenFactory()];
              case 1:
                token = _a.sent();
                this.updateHeaderToken(pollOptions, token);
                pollUrl = url + "&_=" + Date.now();
                this.logger.log(ILogger.LogLevel.Trace, "(LongPolling transport) polling: " + pollUrl);
                return [4 /*yield*/, this.httpClient.get(pollUrl, pollOptions)];
              case 2:
                response = _a.sent();
                if (response.statusCode !== 200) {
                  this.logger.log(ILogger.LogLevel.Error, "(LongPolling transport) Unexpected response code: " + response.statusCode);
                  // Mark running as false so that the poll immediately ends and runs the close logic
                  closeError = new Errors.HttpError(response.statusText, response.statusCode);
                  this.running = false;
                } else {
                  this.running = true;
                }
                this.poll(this.url, pollOptions, closeError);
                return [2 /*return*/, Promise.resolve()];
            }
          });
        });
      };
      LongPollingTransport.prototype.updateHeaderToken = function (request, token) {
        if (token) {
          // tslint:disable-next-line:no-string-literal
          request.headers["Authorization"] = "Bearer " + token;
          return;
        }
        // tslint:disable-next-line:no-string-literal
        if (request.headers["Authorization"]) {
          // tslint:disable-next-line:no-string-literal
          delete request.headers["Authorization"];
        }
      };
      LongPollingTransport.prototype.poll = function (url, pollOptions, closeError) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
          var token, pollUrl, response, e_1;
          return tslib_1.__generator(this, function (_a) {
            switch (_a.label) {
              case 0:
                _a.trys.push([0, , 8, 9]);
                _a.label = 1;
              case 1:
                if (!this.running) return [3 /*break*/, 7];
                return [4 /*yield*/, this.accessTokenFactory()];
              case 2:
                token = _a.sent();
                this.updateHeaderToken(pollOptions, token);
                _a.label = 3;
              case 3:
                _a.trys.push([3, 5, , 6]);
                pollUrl = url + "&_=" + Date.now();
                this.logger.log(ILogger.LogLevel.Trace, "(LongPolling transport) polling: " + pollUrl);
                return [4 /*yield*/, this.httpClient.get(pollUrl, pollOptions)];
              case 4:
                response = _a.sent();
                if (response.statusCode === 204) {
                  this.logger.log(ILogger.LogLevel.Information, "(LongPolling transport) Poll terminated by server");
                  this.running = false;
                } else if (response.statusCode !== 200) {
                  this.logger.log(ILogger.LogLevel.Error, "(LongPolling transport) Unexpected response code: " + response.statusCode);
                  // Unexpected status code
                  closeError = new Errors.HttpError(response.statusText, response.statusCode);
                  this.running = false;
                } else {
                  // Process the response
                  if (response.content) {
                    this.logger.log(ILogger.LogLevel.Trace, "(LongPolling transport) data received. " + Utils.getDataDetail(response.content, this.logMessageContent));
                    if (this.onreceive) {
                      this.onreceive(response.content);
                    }
                  } else {
                    // This is another way timeout manifest.
                    this.logger.log(ILogger.LogLevel.Trace, "(LongPolling transport) Poll timed out, reissuing.");
                  }
                }
                return [3 /*break*/, 6];
              case 5:
                e_1 = _a.sent();
                if (!this.running) {
                  // Log but disregard errors that occur after we were stopped by DELETE
                  this.logger.log(ILogger.LogLevel.Trace, "(LongPolling transport) Poll errored after shutdown: " + e_1.message);
                } else {
                  if (e_1 instanceof Errors.TimeoutError) {
                    // Ignore timeouts and reissue the poll.
                    this.logger.log(ILogger.LogLevel.Trace, "(LongPolling transport) Poll timed out, reissuing.");
                  } else {
                    // Close the connection with the error as the result.
                    closeError = e_1;
                    this.running = false;
                  }
                }
                return [3 /*break*/, 6];
              case 6:
                return [3 /*break*/, 1];
              case 7:
                return [3 /*break*/, 9];
              case 8:
                // Indicate that we've stopped so the shutdown timer doesn't get registered.
                this.stopped = true;
                // Clean up the shutdown timer if it was registered
                if (this.shutdownTimer) {
                  clearTimeout(this.shutdownTimer);
                }
                // Fire our onclosed event
                if (this.onclose) {
                  this.logger.log(ILogger.LogLevel.Trace, "(LongPolling transport) Firing onclose event. Error: " + (closeError || "<undefined>"));
                  this.onclose(closeError);
                }
                this.logger.log(ILogger.LogLevel.Trace, "(LongPolling transport) Transport finished.");
                return [7 /*endfinally*/];
              case 9:
                return [2 /*return*/];
            }
          });
        });
      };
      LongPollingTransport.prototype.send = function (data) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
          return tslib_1.__generator(this, function (_a) {
            if (!this.running) {
              return [2 /*return*/, Promise.reject(new Error("Cannot send until the transport is connected"))];
            }
            return [2 /*return*/, Utils.sendMessage(this.logger, "LongPolling", this.httpClient, this.url, this.accessTokenFactory, data, this.logMessageContent)];
          });
        });
      };
      LongPollingTransport.prototype.stop = function () {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
          var _this = this;
          var deleteOptions, token, response;
          return tslib_1.__generator(this, function (_a) {
            switch (_a.label) {
              case 0:
                _a.trys.push([0, , 3, 4]);
                this.running = false;
                this.logger.log(ILogger.LogLevel.Trace, "(LongPolling transport) sending DELETE request to " + this.url + ".");
                deleteOptions = {
                  headers: {},
                };
                return [4 /*yield*/, this.accessTokenFactory()];
              case 1:
                token = _a.sent();
                this.updateHeaderToken(deleteOptions, token);
                return [4 /*yield*/, this.httpClient.delete(this.url, deleteOptions)];
              case 2:
                response = _a.sent();
                this.logger.log(ILogger.LogLevel.Trace, "(LongPolling transport) DELETE request accepted.");
                return [3 /*break*/, 4];
              case 3:
                // Abort the poll after the shutdown timeout if the server doesn't stop the poll.
                if (!this.stopped) {
                  this.shutdownTimer = setTimeout(function () {
                    _this.logger.log(ILogger.LogLevel.Warning, "(LongPolling transport) server did not terminate after DELETE request, canceling poll.");
                    // Abort any outstanding poll
                    _this.pollAbort.abort();
                  }, this.shutdownTimeout);
                }
                return [7 /*endfinally*/];
              case 4:
                return [2 /*return*/];
            }
          });
        });
      };
      return LongPollingTransport;
    }());
    exports.LongPollingTransport = LongPollingTransport;

  });

  unwrapExports(LongPollingTransport_1);
  var LongPollingTransport_2 = LongPollingTransport_1.LongPollingTransport;

  var ServerSentEventsTransport_1 = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });




    var ServerSentEventsTransport = /** @class */ (function () {
      function ServerSentEventsTransport(httpClient, accessTokenFactory, logger, logMessageContent) {
        this.httpClient = httpClient;
        this.accessTokenFactory = accessTokenFactory || (function () {
          return null;
        });
        this.logger = logger;
        this.logMessageContent = logMessageContent;
      }
      ServerSentEventsTransport.prototype.connect = function (url, transferFormat) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
          var _this = this;
          var token;
          return tslib_1.__generator(this, function (_a) {
            switch (_a.label) {
              case 0:
                Utils.Arg.isRequired(url, "url");
                Utils.Arg.isRequired(transferFormat, "transferFormat");
                Utils.Arg.isIn(transferFormat, ITransport.TransferFormat, "transferFormat");
                if (typeof (EventSource) === "undefined") {
                  throw new Error("'EventSource' is not supported in your environment.");
                }
                this.logger.log(ILogger.LogLevel.Trace, "(SSE transport) Connecting");
                return [4 /*yield*/, this.accessTokenFactory()];
              case 1:
                token = _a.sent();
                if (token) {
                  url += (url.indexOf("?") < 0 ? "?" : "&") + ("access_token=" + encodeURIComponent(token));
                }
                this.url = url;
                return [2 /*return*/, new Promise(function (resolve, reject) {
                  var opened = false;
                  if (transferFormat !== ITransport.TransferFormat.Text) {
                    reject(new Error("The Server-Sent Events transport only supports the 'Text' transfer format"));
                  }
                  var eventSource = new EventSource(url, {
                    withCredentials: true
                  });
                  try {
                    eventSource.onmessage = function (e) {
                      if (_this.onreceive) {
                        try {
                          _this.logger.log(ILogger.LogLevel.Trace, "(SSE transport) data received. " + Utils.getDataDetail(e.data, _this.logMessageContent) + ".");
                          _this.onreceive(e.data);
                        } catch (error) {
                          if (_this.onclose) {
                            _this.onclose(error);
                          }
                          return;
                        }
                      }
                    };
                    eventSource.onerror = function (e) {
                      var error = new Error(e.message || "Error occurred");
                      if (opened) {
                        _this.close(error);
                      } else {
                        reject(error);
                      }
                    };
                    eventSource.onopen = function () {
                      _this.logger.log(ILogger.LogLevel.Information, "SSE connected to " + _this.url);
                      _this.eventSource = eventSource;
                      opened = true;
                      resolve();
                    };
                  } catch (e) {
                    return Promise.reject(e);
                  }
                })];
            }
          });
        });
      };
      ServerSentEventsTransport.prototype.send = function (data) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
          return tslib_1.__generator(this, function (_a) {
            if (!this.eventSource) {
              return [2 /*return*/, Promise.reject(new Error("Cannot send until the transport is connected"))];
            }
            return [2 /*return*/, Utils.sendMessage(this.logger, "SSE", this.httpClient, this.url, this.accessTokenFactory, data, this.logMessageContent)];
          });
        });
      };
      ServerSentEventsTransport.prototype.stop = function () {
        this.close();
        return Promise.resolve();
      };
      ServerSentEventsTransport.prototype.close = function (e) {
        if (this.eventSource) {
          this.eventSource.close();
          this.eventSource = null;
          if (this.onclose) {
            this.onclose(e);
          }
        }
      };
      return ServerSentEventsTransport;
    }());
    exports.ServerSentEventsTransport = ServerSentEventsTransport;

  });

  unwrapExports(ServerSentEventsTransport_1);
  var ServerSentEventsTransport_2 = ServerSentEventsTransport_1.ServerSentEventsTransport;

  var WebSocketTransport_1 = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });




    var WebSocketTransport = /** @class */ (function () {
      function WebSocketTransport(accessTokenFactory, logger, logMessageContent) {
        this.logger = logger;
        this.accessTokenFactory = accessTokenFactory || (function () {
          return null;
        });
        this.logMessageContent = logMessageContent;
      }
      WebSocketTransport.prototype.connect = function (url, transferFormat) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
          var _this = this;
          var token;
          return tslib_1.__generator(this, function (_a) {
            switch (_a.label) {
              case 0:
                Utils.Arg.isRequired(url, "url");
                Utils.Arg.isRequired(transferFormat, "transferFormat");
                Utils.Arg.isIn(transferFormat, ITransport.TransferFormat, "transferFormat");
                // if (typeof(WebSocket) === "undefined") {
                //   throw new Error("'WebSocket' is not supported in your environment.");
                // }
                this.logger.log(ILogger.LogLevel.Trace, "(WebSockets transport) Connecting");
                return [4 /*yield*/, this.accessTokenFactory()];
              case 1:
                token = _a.sent();
                if (token) {
                  url += (url.indexOf("?") < 0 ? "?" : "&") + ("access_token=" + encodeURIComponent(token));
                }
                return [2 /*return*/, new Promise(function (resolve, reject) {
                  url = url.replace(/^http/, "ws");
                  var webSocket = wx.connectSocket({
                    url: url,
                  })

                  if (transferFormat === ITransport.TransferFormat.Binary) {
                    webSocket.binaryType = "arraybuffer";
                  }
                  webSocket.onOpen(function (event) {
                    _this.logger.log(ILogger.LogLevel.Information, "WebSocket connected to " + url);
                    _this.webSocket = webSocket;
                    resolve();
                  });
                  webSocket.onError(function (event) {
                    reject(event.error);
                  });
                  webSocket.onMessage(function (message) {
                    _this.logger.log(ILogger.LogLevel.Trace, "(WebSockets transport) data received. " + Utils.getDataDetail(message.data, _this.logMessageContent) + ".");
                    if (_this.onreceive) {
                      _this.onreceive(message.data);
                    }
                  });
                  webSocket.onClose(function (event) {
                    // webSocket will be null if the transport did not start successfully
                    _this.logger.log(ILogger.LogLevel.Trace, "(WebSockets transport) socket closed.");
                    if (_this.onclose) {
                      if (event.wasClean === false || event.code !== 1000) {
                        _this.onclose(new Error("Websocket closed with status code: " + event.code + " (" + event.reason + ")"));
                      } else {
                        _this.onclose();
                      }
                    }
                  });
                })];
            }
          });
        });
      };
      WebSocketTransport.prototype.send = function (data) {

        if (this.webSocket && this.webSocket.readyState === 1) {
          this.logger.log(ILogger.LogLevel.Trace, "(WebSockets transport) sending data. " + Utils.getDataDetail(data, this.logMessageContent) + ".");
          this.webSocket.send({
            data: data,
          });
          return Promise.resolve();
        }
        return Promise.reject("WebSocket is not in the OPEN state");
      };
      WebSocketTransport.prototype.stop = function () {
        if (this.webSocket) {
          this.webSocket.close();
          this.webSocket = null;
        }
        return Promise.resolve();
      };
      return WebSocketTransport;
    }());
    exports.WebSocketTransport = WebSocketTransport;

  });

  unwrapExports(WebSocketTransport_1);
  var WebSocketTransport_2 = WebSocketTransport_1.WebSocketTransport;

  var HttpConnection_1 = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });








    var MAX_REDIRECTS = 100;
    var HttpConnection = /** @class */ (function () {
      function HttpConnection(url, options) {
        if (options === void 0) {
          options = {};
        }
        this.features = {};
        Utils.Arg.isRequired(url, "url");
        this.logger = Utils.createLogger(options.logger);
        this.baseUrl = this.resolveUrl(url);
        options = options || {};
        options.accessTokenFactory = options.accessTokenFactory || (function () {
          return null;
        });
        options.logMessageContent = options.logMessageContent || false;
        this.httpClient = options.httpClient || new HttpClient_1.DefaultHttpClient(this.logger);
        this.connectionState = 2 /* Disconnected */;
        this.options = options;
      }
      HttpConnection.prototype.start = function (transferFormat) {
        transferFormat = transferFormat || ITransport.TransferFormat.Binary;
        Utils.Arg.isIn(transferFormat, ITransport.TransferFormat, "transferFormat");
        this.logger.log(ILogger.LogLevel.Debug, "Starting connection with transfer format '" + ITransport.TransferFormat[transferFormat] + "'.");
        if (this.connectionState !== 2 /* Disconnected */) {
          return Promise.reject(new Error("Cannot start a connection that is not in the 'Disconnected' state."));
        }
        this.connectionState = 0 /* Connecting */;
        this.startPromise = this.startInternal(transferFormat);
        return this.startPromise;
      };
      HttpConnection.prototype.send = function (data) {
        if (this.connectionState !== 1 /* Connected */) {
          throw new Error("Cannot send data if the connection is not in the 'Connected' State.");
        }
        return this.transport.send(data);
      };
      HttpConnection.prototype.stop = function (error) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
          var e_1;
          return tslib_1.__generator(this, function (_a) {
            switch (_a.label) {
              case 0:
                this.connectionState = 2 /* Disconnected */;
                _a.label = 1;
              case 1:
                _a.trys.push([1, 3, , 4]);
                return [4 /*yield*/, this.startPromise];
              case 2:
                _a.sent();
                return [3 /*break*/, 4];
              case 3:
                e_1 = _a.sent();
                return [3 /*break*/, 4];
              case 4:
                if (!this.transport) return [3 /*break*/, 6];
                this.stopError = error;
                return [4 /*yield*/, this.transport.stop()];
              case 5:
                _a.sent();
                this.transport = null;
                _a.label = 6;
              case 6:
                return [2 /*return*/];
            }
          });
        });
      };
      HttpConnection.prototype.startInternal = function (transferFormat) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
          var _this = this;
          var url, negotiateResponse, redirects, _loop_1, this_1, state_1, e_2;
          return tslib_1.__generator(this, function (_a) {
            switch (_a.label) {
              case 0:
                url = this.baseUrl;
                this.accessTokenFactory = this.options.accessTokenFactory;
                _a.label = 1;
              case 1:
                _a.trys.push([1, 12, , 13]);
                if (!this.options.skipNegotiation) return [3 /*break*/, 5];
                if (!(this.options.transport === ITransport.HttpTransportType.WebSockets)) return [3 /*break*/, 3];
                // No need to add a connection ID in this case
                this.transport = this.constructTransport(ITransport.HttpTransportType.WebSockets);
                // We should just call connect directly in this case.
                // No fallback or negotiate in this case.
                return [4 /*yield*/, this.transport.connect(url, transferFormat)];
              case 2:
                // We should just call connect directly in this case.
                // No fallback or negotiate in this case.
                _a.sent();
                return [3 /*break*/, 4];
              case 3:
                throw Error("Negotiation can only be skipped when using the WebSocket transport directly.");
              case 4:
                return [3 /*break*/, 11];
              case 5:
                negotiateResponse = null;
                redirects = 0;
                _loop_1 = function () {
                  var accessToken_1;
                  return tslib_1.__generator(this, function (_a) {
                    switch (_a.label) {
                      case 0:
                        return [4 /*yield*/, this_1.getNegotiationResponse(url)];
                      case 1:
                        negotiateResponse = _a.sent();
                        // the user tries to stop the connection when it is being started
                        if (this_1.connectionState === 2 /* Disconnected */) {
                          return [2 /*return*/, {
                            value: void 0
                          }];
                        }
                        if (negotiateResponse.url) {
                          url = negotiateResponse.url;
                        }
                        if (negotiateResponse.accessToken) {
                          accessToken_1 = negotiateResponse.accessToken;
                          this_1.accessTokenFactory = function () {
                            return accessToken_1;
                          };
                        }
                        redirects++;
                        return [2 /*return*/];
                    }
                  });
                };
                this_1 = this;
                _a.label = 6;
              case 6:
                return [5 /*yield**/, _loop_1()];
              case 7:
                state_1 = _a.sent();
                if (typeof state_1 === "object")
                  return [2 /*return*/, state_1.value];
                _a.label = 8;
              case 8:
                if (negotiateResponse.url && redirects < MAX_REDIRECTS) return [3 /*break*/, 6];
                _a.label = 9;
              case 9:
                if (redirects === MAX_REDIRECTS && negotiateResponse.url) {
                  throw Error("Negotiate redirection limit exceeded.");
                }
                return [4 /*yield*/, this.createTransport(url, this.options.r, negotiateResponse, transferFormat)];
              case 10:
                _a.sent();
                _a.label = 11;
              case 11:
                if (this.transport instanceof LongPollingTransport_1.LongPollingTransport) {
                  this.features.inherentKeepAlive = true;
                }
                this.transport.onreceive = this.onreceive;
                this.transport.onclose = function (e) {
                  return _this.stopConnection(e);
                };
                // only change the state if we were connecting to not overwrite
                // the state if the connection is already marked as Disconnected
                this.changeState(0 /* Connecting */, 1 /* Connected */);
                return [3 /*break*/, 13];
              case 12:
                e_2 = _a.sent();
                this.logger.log(ILogger.LogLevel.Error, "Failed to start the connection: " + e_2);
                this.connectionState = 2 /* Disconnected */;
                this.transport = null;
                throw e_2;
              case 13:
                return [2 /*return*/];
            }
          });
        });
      };
      HttpConnection.prototype.getNegotiationResponse = function (url) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
          var token, headers, negotiateUrl, response, e_3, _a;
          return tslib_1.__generator(this, function (_b) {
            switch (_b.label) {
              case 0:
                return [4 /*yield*/, this.accessTokenFactory()];
              case 1:
                token = _b.sent();
                if (token) {
                  headers = (_a = {}, _a["Authorization"] = "Bearer " + token, _a);
                }
                negotiateUrl = this.resolveNegotiateUrl(url);
                this.logger.log(ILogger.LogLevel.Debug, "Sending negotiation request: " + negotiateUrl);
                _b.label = 2;
              case 2:
                _b.trys.push([2, 4, , 5]);
                return [4 /*yield*/, this.httpClient.post(negotiateUrl, {
                  content: "",
                  headers: headers,
                })];
              case 3:
                response = _b.sent();
                if (response.statusCode !== 200) {
                  throw Error("Unexpected status code returned from negotiate " + response.statusCode);
                }
                return [2 /*return*/, JSON.parse(response.content)];
              case 4:
                e_3 = _b.sent();
                this.logger.log(ILogger.LogLevel.Error, "Failed to complete negotiation with the server: " + e_3);
                throw e_3;
              case 5:
                return [2 /*return*/];
            }
          });
        });
      };
      HttpConnection.prototype.createConnectUrl = function (url, connectionId) {
        return url + (url.indexOf("?") === -1 ? "?" : "&") + ("id=" + connectionId);
      };
      HttpConnection.prototype.createTransport = function (url, requestedTransport, negotiateResponse, requestedTransferFormat) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
          var connectUrl, transports, _i, transports_1, endpoint, transport, ex_1;
          return tslib_1.__generator(this, function (_a) {
            switch (_a.label) {
              case 0:
                connectUrl = this.createConnectUrl(url, negotiateResponse.connectionId);
                if (!this.isITransport(requestedTransport)) return [3 /*break*/, 2];
                this.logger.log(ILogger.LogLevel.Debug, "Connection was provided an instance of ITransport, using that directly.");
                this.transport = requestedTransport;
                return [4 /*yield*/, this.transport.connect(connectUrl, requestedTransferFormat)];
              case 1:
                _a.sent();
                // only change the state if we were connecting to not overwrite
                // the state if the connection is already marked as Disconnected
                this.changeState(0 /* Connecting */, 1 /* Connected */);
                return [2 /*return*/];
              case 2:
                transports = negotiateResponse.availableTransports;
                _i = 0, transports_1 = transports;
                _a.label = 3;
              case 3:
                if (!(_i < transports_1.length)) return [3 /*break*/, 9];
                endpoint = transports_1[_i];
                this.connectionState = 0 /* Connecting */;
                // transport = this.resolveTransport(endpoint, requestedTransport, requestedTransferFormat);
                transport = 1;
                if (!(typeof transport === "number")) return [3 /*break*/, 8];
                this.transport = this.constructTransport(transport);////////////////////////////////
                if (!(negotiateResponse.connectionId === null)) return [3 /*break*/, 5];
                return [4 /*yield*/, this.getNegotiationResponse(url)];
              case 4:
                negotiateResponse = _a.sent();
                connectUrl = this.createConnectUrl(url, negotiateResponse.connectionId);
                _a.label = 5;
              case 5:
                _a.trys.push([5, 7, , 8]);
                return [4 /*yield*/, this.transport.connect(connectUrl, requestedTransferFormat)];
              case 6:
                _a.sent();
                this.changeState(0 /* Connecting */, 1 /* Connected */);
                return [2 /*return*/];
              case 7:
                ex_1 = _a.sent();
                this.logger.log(ILogger.LogLevel.Error, "Failed to start the transport '" + ITransport.HttpTransportType[transport] + "': " + ex_1);
                this.connectionState = 2 /* Disconnected */;
                negotiateResponse.connectionId = null;
                return [3 /*break*/, 8];
              case 8:
                _i++;
                return [3 /*break*/, 3];
              case 9:
                throw new Error("Unable to initialize any of the available transports.");
            }
          });
        });
      };
      HttpConnection.prototype.constructTransport = function (transport) {
        switch (transport) {
          case ITransport.HttpTransportType.WebSockets:
            return new WebSocketTransport_1.WebSocketTransport(this.accessTokenFactory, this.logger, this.options.logMessageContent);
          case ITransport.HttpTransportType.ServerSentEvents:
            return new ServerSentEventsTransport_1.ServerSentEventsTransport(this.httpClient, this.accessTokenFactory, this.logger, this.options.logMessageContent);
          case ITransport.HttpTransportType.LongPolling:
            return new LongPollingTransport_1.LongPollingTransport(this.httpClient, this.accessTokenFactory, this.logger, this.options.logMessageContent);
          default:
            throw new Error("Unknown transport: " + transport + ".");
        }
      };
      HttpConnection.prototype.resolveTransport = function (endpoint, requestedTransport, requestedTransferFormat) {
        var transport = ITransport.HttpTransportType[endpoint.transport];
        if (transport === null || transport === undefined) {
          this.logger.log(ILogger.LogLevel.Debug, "Skipping transport '" + endpoint.transport + "' because it is not supported by this client.");
        } else {
          var transferFormats = endpoint.transferFormats.map(function (s) {
            return ITransport.TransferFormat[s];
          });
          if (transportMatches(requestedTransport, transport)) {
            if (transferFormats.indexOf(requestedTransferFormat) >= 0) {
              if ((transport === ITransport.HttpTransportType.WebSockets && typeof WebSocket === "undefined") ||
                (transport === ITransport.HttpTransportType.ServerSentEvents && typeof EventSource === "undefined")) {
                this.logger.log(ILogger.LogLevel.Debug, "Skipping transport '" + ITransport.HttpTransportType[transport] + "' because it is not supported in your environment.'");
              } else {
                this.logger.log(ILogger.LogLevel.Debug, "Selecting transport '" + ITransport.HttpTransportType[transport] + "'");
                return transport;
              }
            } else {
              this.logger.log(ILogger.LogLevel.Debug, "Skipping transport '" + ITransport.HttpTransportType[transport] + "' because it does not support the requested transfer format '" + ITransport.TransferFormat[requestedTransferFormat] + "'.");
            }
          } else {
            this.logger.log(ILogger.LogLevel.Debug, "Skipping transport '" + ITransport.HttpTransportType[transport] + "' because it was disabled by the client.");
          }
        }
        return null;
      };
      HttpConnection.prototype.isITransport = function (transport) {
        return transport && typeof (transport) === "object" && "connect" in transport;
      };
      HttpConnection.prototype.changeState = function (from, to) {
        if (this.connectionState === from) {
          this.connectionState = to;
          return true;
        }
        return false;
      };
      HttpConnection.prototype.stopConnection = function (error) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
          return tslib_1.__generator(this, function (_a) {
            this.transport = null;
            // If we have a stopError, it takes precedence over the error from the transport
            error = this.stopError || error;
            if (error) {
              this.logger.log(ILogger.LogLevel.Error, "Connection disconnected with error '" + error + "'.");
            } else {
              this.logger.log(ILogger.LogLevel.Information, "Connection disconnected.");
            }
            this.connectionState = 2 /* Disconnected */;
            if (this.onclose) {
              this.onclose(error);
            }
            return [2 /*return*/];
          });
        });
      };
      HttpConnection.prototype.resolveUrl = function (url) {
        // startsWith is not supported in IE
          if (url.lastIndexOf("https://", 0) === 0 || url.lastIndexOf("http://", 0) === 0 || url.lastIndexOf("ws://", 0) === 0 || url.lastIndexOf("wss://", 0) === 0) {
          return url;
        }
        if (typeof window === "undefined" || !window || !window.document) {
          throw new Error("Cannot resolve '" + url + "'.");
        }
        // Setting the url to the href propery of an anchor tag handles normalization
        // for us. There are 3 main cases.
        // 1. Relative  path normalization e.g "b" -> "http://localhost:5000/a/b"
        // 2. Absolute path normalization e.g "/a/b" -> "http://localhost:5000/a/b"
        // 3. Networkpath reference normalization e.g "//localhost:5000/a/b" -> "http://localhost:5000/a/b"
        var aTag = window.document.createElement("a");
        aTag.href = url;
        this.logger.log(ILogger.LogLevel.Information, "Normalizing '" + url + "' to '" + aTag.href + "'.");
        return aTag.href;
      };
      HttpConnection.prototype.resolveNegotiateUrl = function (url) {
        var index = url.indexOf("?");
        var negotiateUrl = url.substring(0, index === -1 ? url.length : index);
        if (negotiateUrl[negotiateUrl.length - 1] !== "/") {
          negotiateUrl += "/";
        }
        negotiateUrl += "negotiate";
        negotiateUrl += index === -1 ? "" : url.substring(index);
        return negotiateUrl;
      };
      return HttpConnection;
    }());
    exports.HttpConnection = HttpConnection;

    function transportMatches(requestedTransport, actualTransport) {
      return !requestedTransport || ((actualTransport & requestedTransport) !== 0);
    }

  });

  unwrapExports(HttpConnection_1);
  var HttpConnection_2 = HttpConnection_1.HttpConnection;

  var JsonHubProtocol_1 = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });





    var JSON_HUB_PROTOCOL_NAME = "json";
    /** Implements the JSON Hub Protocol. */
    var JsonHubProtocol = /** @class */ (function () {
      function JsonHubProtocol() {
        /** @inheritDoc */
        this.name = JSON_HUB_PROTOCOL_NAME;
        /** @inheritDoc */
        this.version = 1;
        /** @inheritDoc */
        this.transferFormat = ITransport.TransferFormat.Text;
      }
      /** Creates an array of {@link HubMessage} objects from the specified serialized representation.
       *
       * @param {string} input A string containing the serialized representation.
       * @param {ILogger} logger A logger that will be used to log messages that occur during parsing.
       */
      JsonHubProtocol.prototype.parseMessages = function (input, logger) {
        // The interface does allow "ArrayBuffer" to be passed in, but this implementation does not. So let's throw a useful error.
        if (typeof input !== "string") {
          throw new Error("Invalid input for JSON hub protocol. Expected a string.");
        }
        if (!input) {
          return [];
        }
        if (logger === null) {
          logger = Loggers.NullLogger.instance;
        }
        // Parse the messages
        var messages = TextMessageFormat_1.TextMessageFormat.parse(input);
        var hubMessages = [];
        for (var _i = 0, messages_1 = messages; _i < messages_1.length; _i++) {
          var message = messages_1[_i];
          var parsedMessage = JSON.parse(message);
          if (typeof parsedMessage.type !== "number") {
            throw new Error("Invalid payload.");
          }
          switch (parsedMessage.type) {
            case IHubProtocol.MessageType.Invocation:
              this.isInvocationMessage(parsedMessage);
              break;
            case IHubProtocol.MessageType.StreamItem:
              this.isStreamItemMessage(parsedMessage);
              break;
            case IHubProtocol.MessageType.Completion:
              this.isCompletionMessage(parsedMessage);
              break;
            case IHubProtocol.MessageType.Ping:
              // Single value, no need to validate
              break;
            case IHubProtocol.MessageType.Close:
              // All optional values, no need to validate
              break;
            default:
              // Future protocol changes can add message types, old clients can ignore them
              logger.log(ILogger.LogLevel.Information, "Unknown message type '" + parsedMessage.type + "' ignored.");
              continue;
          }
          hubMessages.push(parsedMessage);
        }
        return hubMessages;
      };
      /** Writes the specified {@link HubMessage} to a string and returns it.
       *
       * @param {HubMessage} message The message to write.
       * @returns {string} A string containing the serialized representation of the message.
       */
      JsonHubProtocol.prototype.writeMessage = function (message) {
        return TextMessageFormat_1.TextMessageFormat.write(JSON.stringify(message));
      };
      JsonHubProtocol.prototype.isInvocationMessage = function (message) {
        this.assertNotEmptyString(message.target, "Invalid payload for Invocation message.");
        if (message.invocationId !== undefined) {
          this.assertNotEmptyString(message.invocationId, "Invalid payload for Invocation message.");
        }
      };
      JsonHubProtocol.prototype.isStreamItemMessage = function (message) {
        this.assertNotEmptyString(message.invocationId, "Invalid payload for StreamItem message.");
        if (message.item === undefined) {
          throw new Error("Invalid payload for StreamItem message.");
        }
      };
      JsonHubProtocol.prototype.isCompletionMessage = function (message) {
        if (message.result && message.error) {
          throw new Error("Invalid payload for Completion message.");
        }
        if (!message.result && message.error) {
          this.assertNotEmptyString(message.error, "Invalid payload for Completion message.");
        }
        this.assertNotEmptyString(message.invocationId, "Invalid payload for Completion message.");
      };
      JsonHubProtocol.prototype.assertNotEmptyString = function (value, errorMessage) {
        if (typeof value !== "string" || value === "") {
          throw new Error(errorMessage);
        }
      };
      return JsonHubProtocol;
    }());
    exports.JsonHubProtocol = JsonHubProtocol;

  });

  unwrapExports(JsonHubProtocol_1);
  var JsonHubProtocol_2 = JsonHubProtocol_1.JsonHubProtocol;

  var HubConnectionBuilder_1 = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });





    /** A builder for configuring {@link HubConnection} instances. */
    var HubConnectionBuilder = /** @class */ (function () {
      function HubConnectionBuilder() { }
      HubConnectionBuilder.prototype.configureLogging = function (logging) {
        Utils.Arg.isRequired(logging, "logging");
        if (isLogger(logging)) {
          this.logger = logging;
        } else {
          this.logger = new Utils.ConsoleLogger(logging);
        }
        return this;
      };
      HubConnectionBuilder.prototype.withUrl = function (url, transportTypeOrOptions) {
        Utils.Arg.isRequired(url, "url");
        this.url = url;
        // Flow-typing knows where it's at. Since HttpTransportType is a number and IHttpConnectionOptions is guaranteed
        // to be an object, we know (as does TypeScript) this comparison is all we need to figure out which overload was called.
        if (typeof transportTypeOrOptions === "object") {
          this.httpConnectionOptions = transportTypeOrOptions;
        } else {
          this.httpConnectionOptions = {
            transport: transportTypeOrOptions,
          };
        }
        return this;
      };
      /** Configures the {@link HubConnection} to use the specified Hub Protocol.
       *
       * @param {IHubProtocol} protocol The {@link IHubProtocol} implementation to use.
       */
      HubConnectionBuilder.prototype.withHubProtocol = function (protocol) {
        Utils.Arg.isRequired(protocol, "protocol");
        this.protocol = protocol;
        return this;
      };
      /** Creates a {@link HubConnection} from the configuration options specified in this builder.
       *
       * @returns {HubConnection} The configured {@link HubConnection}.
       */
      HubConnectionBuilder.prototype.build = function () {
        // If httpConnectionOptions has a logger, use it. Otherwise, override it with the one
        // provided to configureLogger
        var httpConnectionOptions = this.httpConnectionOptions || {};
        // If it's 'null', the user **explicitly** asked for null, don't mess with it.
        if (httpConnectionOptions.logger === undefined) {
          // If our logger is undefined or null, that's OK, the HttpConnection constructor will handle it.
          httpConnectionOptions.logger = this.logger;
        }
        // Now create the connection
        if (!this.url) {
          throw new Error("The 'HubConnectionBuilder.withUrl' method must be called before building the connection.");
        }
        var connection = new HttpConnection_1.HttpConnection(this.url, httpConnectionOptions);
        return HubConnection_1.HubConnection.create(connection, this.logger || Loggers.NullLogger.instance, this.protocol || new JsonHubProtocol_1.JsonHubProtocol());
      };
      return HubConnectionBuilder;
    }());
    exports.HubConnectionBuilder = HubConnectionBuilder;

    function isLogger(logger) {
      return logger.log !== undefined;
    }

  });

  unwrapExports(HubConnectionBuilder_1);
  var HubConnectionBuilder_2 = HubConnectionBuilder_1.HubConnectionBuilder;

  var cjs = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    // Version token that will be replaced by the prepack command
    /** The version of the SignalR client. */
    exports.VERSION = "0.0.0-DEV_BUILD";

    exports.HttpError = Errors.HttpError;
    exports.TimeoutError = Errors.TimeoutError;

    exports.DefaultHttpClient = HttpClient_1.DefaultHttpClient;
    exports.HttpClient = HttpClient_1.HttpClient;
    exports.HttpResponse = HttpClient_1.HttpResponse;

    exports.HubConnection = HubConnection_1.HubConnection;

    exports.HubConnectionBuilder = HubConnectionBuilder_1.HubConnectionBuilder;

    exports.MessageType = IHubProtocol.MessageType;

    exports.LogLevel = ILogger.LogLevel;

    exports.HttpTransportType = ITransport.HttpTransportType;
    exports.TransferFormat = ITransport.TransferFormat;

    exports.NullLogger = Loggers.NullLogger;

    exports.JsonHubProtocol = JsonHubProtocol_1.JsonHubProtocol;

  });

  unwrapExports(cjs);
  var cjs_1 = cjs.VERSION;
  var cjs_2 = cjs.HttpError;
  var cjs_3 = cjs.TimeoutError;
  var cjs_4 = cjs.DefaultHttpClient;
  var cjs_5 = cjs.HttpClient;
  var cjs_6 = cjs.HttpResponse;
  var cjs_7 = cjs.HubConnection;
  var cjs_8 = cjs.HubConnectionBuilder;
  var cjs_9 = cjs.MessageType;
  var cjs_10 = cjs.LogLevel;
  var cjs_11 = cjs.HttpTransportType;
  var cjs_12 = cjs.TransferFormat;
  var cjs_13 = cjs.NullLogger;
  var cjs_14 = cjs.JsonHubProtocol;

  var browserIndex = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });

    // This is where we add any polyfills we'll need for the browser. It is the entry module for browser-specific builds.

    // Copy from Array.prototype into Uint8Array to polyfill on IE. It's OK because the implementations of indexOf and slice use properties
    // that exist on Uint8Array with the same name, and JavaScript is magic.
    // We make them 'writable' because the Buffer polyfill messes with it as well.
    if (!Uint8Array.prototype.indexOf) {
      Object.defineProperty(Uint8Array.prototype, "indexOf", {
        value: Array.prototype.indexOf,
        writable: true,
      });
    }
    if (!Uint8Array.prototype.slice) {
      Object.defineProperty(Uint8Array.prototype, "slice", {
        value: Array.prototype.slice,
        writable: true,
      });
    }
    if (!Uint8Array.prototype.forEach) {
      Object.defineProperty(Uint8Array.prototype, "forEach", {
        value: Array.prototype.forEach,
        writable: true,
      });
    }
    tslib_1.__exportStar(cjs, exports);

  });

  var browserIndex$1 = unwrapExports(browserIndex);

  return browserIndex$1;

})));
//# sourceMappingURL=signalr.js.map