/*----------------------------------------------------------------
    Copyright (C) 2018 Senparc
 
    ļRequestHandler.cs
    ļ΢֧ 
    
    
    ʶSenparc - 20150722
    
    ޸ıʶSenparc - 20170623
    ޸ʹ ASCII ֵ
----------------------------------------------------------------*/

using System;
using System.Collections;
using System.Text;
using System.Text.RegularExpressions;
using Senparc.Weixin.Work.Helpers;
using Senparc.CO2NET.Helpers;

#if NET35 || NET40 || NET45 || NET461
using System.Web;
#else
using Microsoft.AspNetCore.Http;
#endif



namespace Senparc.Weixin.Work.TenPayLib
{
    /**
    'ǩ
     ============================================================================/// <summary>
    'api˵
    'Init();
    'ʼĬϸһЩֵ
    'SetKey(key_)'̻Կ
    'CreateMd5Sign(signParams);ֵMd5ǩ
    'GenPackage(packageParams);ȡpackage
    'CreateSHA1Sign(signParams);ǩSHA1
    'ParseXML();xml
    'GetDebugInfo(),ȡdebugϢ
     * 
     * ============================================================================
     */
    [Obsolete("ʹ Senparc.Weixin.TenPay.dllSenparc.Weixin.TenPay.V3 еĶӦ")]
    public class RequestHandler
    {

        public RequestHandler()
        {
            Parameters = new Hashtable();
        }


        public RequestHandler(HttpContext httpContext)
        {
            Parameters = new Hashtable();
#if NET35 || NET40 || NET45 || NET461
			this.HttpContext = httpContext ?? HttpContext.Current;
#else
            this.HttpContext = httpContext ?? new DefaultHttpContext();
#endif
        }

        /// <summary>
        /// Կ
        /// </summary>
        private string Key;

        protected HttpContext HttpContext;

        /// <summary>
        /// Ĳ
        /// </summary>
        protected Hashtable Parameters;

        /// <summary>
        /// debugϢ
        /// </summary>
        private string DebugInfo;

        /// <summary>
        /// ʼ
        /// </summary>
        public virtual void Init()
        {
        }
        /// <summary>
        /// ȡdebugϢ
        /// </summary>
        /// <returns></returns>
        public String GetDebugInfo()
        {
            return DebugInfo;
        }
        /// <summary>
        /// ȡԿ
        /// </summary>
        /// <returns></returns>
        public string GetKey()
        {
            return Key;
        }
        /// <summary>
        /// Կ
        /// </summary>
        /// <param name="key"></param>
        public void SetKey(string key)
        {
            this.Key = key;
        }

        /// <summary>
        /// òֵ
        /// </summary>
        /// <param name="parameter"></param>
        /// <param name="parameterValue"></param>
        public void SetParameter(string parameter, string parameterValue)
        {
            if (parameter != null && parameter != "")
            {
                if (Parameters.Contains(parameter))
                {
                    Parameters.Remove(parameter);
                }

                Parameters.Add(parameter, parameterValue);
            }
        }


        /// <summary>
        /// md5ժҪ,:a-z,ֵĲμǩ
        /// </summary>
        /// <param name="key"></param>
        /// <param name="value">ֵ</param>
        /// keyvalueͨһ
        /// <returns></returns>
        public virtual string CreateMd5Sign(string key, string value)
        {
            StringBuilder sb = new StringBuilder();

            ArrayList akeys = new ArrayList(Parameters.Keys);
            akeys.Sort(ASCIISort.Create());

            foreach (string k in akeys)
            {
                string v = (string)Parameters[k];
                if (null != v && "".CompareTo(v) != 0
                    && "sign".CompareTo(k) != 0 && "key".CompareTo(k) != 0)
                {
                    sb.Append(k + "=" + v + "&");
                }
            }

            sb.Append(key + "=" + value);
            string sign = EncryptHelper.GetMD5(sb.ToString(), GetCharset()).ToUpper();

            return sign;
        }

        /// <summary>
        /// XML
        /// </summary>
        /// <returns></returns>
        public string ParseXML()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("<xml>");
            foreach (string k in Parameters.Keys)
            {
                string v = (string)Parameters[k];
                if (Regex.IsMatch(v, @"^[0-9.]$"))
                {

                    sb.Append("<" + k + ">" + v + "</" + k + ">");
                }
                else
                {
                    sb.Append("<" + k + "><![CDATA[" + v + "]]></" + k + ">");
                }

            }
            sb.Append("</xml>");
            return sb.ToString();
        }



        /// <summary>
        /// debugϢ
        /// </summary>
        /// <param name="debugInfo"></param>
        public void SetDebugInfo(String debugInfo)
        {
            this.DebugInfo = debugInfo;
        }

        public Hashtable GetAllParameters()
        {
            return this.Parameters;
        }

        protected virtual string GetCharset()
        {
#if NET35 || NET40 || NET45 || NET461
            return this.HttpContext.Request.ContentEncoding.BodyName;
#else
            return Encoding.UTF8.WebName;
#endif
        }
    }
}
