#region Apache License Version 2.0
/*----------------------------------------------------------------

Copyright 2018 Jeffrey Su & Suzhou Senparc Network Technology Co.,Ltd.

Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
except in compliance with the License. You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software distributed under the
License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
either express or implied. See the License for the specific language governing permissions
and limitations under the License.

Detail: https://github.com/JeffreySu/WeiXinMPSDK/blob/master/license.md

----------------------------------------------------------------*/
#endregion Apache License Version 2.0

/*----------------------------------------------------------------
    Copyright (C) 2018 Senparc
 
    ļTenPayV3Util.cs
    ļ΢֧V3ļ
    
    
    ʶSenparc - 20150211
    
    ޸ıʶSenparc - 20150303
    ޸ӿ

    ޸ıʶSenparc - 20161014
    ޸޸TenPayUtil.BuildRandomStr()

    ޸ıʶSenparc - 20170516
    ޸v14.4.8 1TenPayLibV3.GetNoncestr()
                      2ŻBuildRandomStr()
             
    ޸ıʶSenparc - 20170522
    ޸v14.4.9 ޸TenPayUtil.GetNoncestr()GBKΪUTF8

    ޸ıʶSenparc - 20180331
    ޸v14.4.9 ޸TenPayUtil.GetNoncestr()GBKΪUTF8

----------------------------------------------------------------*/

using System;
using System.Text;
using System.Net;
using Senparc.Weixin.Helpers;
using Senparc.CO2NET.Helpers;

namespace Senparc.Weixin.MP.TenPayLibV3
{
    /// <summary>
    /// ΢֧
    /// </summary>
    [Obsolete("ʹ Senparc.Weixin.TenPay.dllSenparc.Weixin.TenPay.V3 еĶӦ")]
    public class TenPayV3Util
    {
        public static Random random = new Random();

        /// <summary>
        /// Noncestr
        /// </summary>
        /// <returns></returns>
        public static string GetNoncestr()
        {
            return EncryptHelper.GetMD5(Guid.NewGuid().ToString(), "UTF-8");
        }

        /// <summary>
        /// ȡ΢ʱʽ
        /// </summary>
        /// <returns></returns>
        public static string GetTimestamp()
        {
            TimeSpan ts = DateTime.UtcNow - new DateTime(1970, 1, 1, 0, 0, 0, 0);
            return Convert.ToInt64(ts.TotalSeconds).ToString();
        }

        /// <summary>
        /// ַURL
        /// </summary>
        /// <param name="instr"></param>
        /// <param name="charset"></param>
        /// <returns></returns>
        public static string UrlEncode(string instr, string charset)
        {
            //return instr;
            if (instr == null || instr.Trim() == "")
                return "";
            else
            {
                //string res;

                try
                {
#if NET35 || NET40 || NET45 || NET461
                    return System.Web.HttpUtility.UrlEncode(instr, Encoding.GetEncoding(charset));
#else
                    return WebUtility.UrlEncode(instr);
#endif
                }
                catch (Exception ex)
                {
#if NET35 || NET40 || NET45 || NET461
                    return System.Web.HttpUtility.UrlEncode(instr, Encoding.GetEncoding("GB2312"));
#else
                    return WebUtility.UrlEncode(instr);
#endif
                }

                //return res;
            }
        }

        /// <summary>
        /// ַURL
        /// </summary>
        /// <param name="instr"></param>
        /// <param name="charset"></param>
        /// <returns></returns>
        public static string UrlDecode(string instr, string charset)
        {
            if (instr == null || instr.Trim() == "")
                return "";
            else
            {
                //string res;

                try
                {
#if NET35 || NET40 || NET45 || NET461
                    return System.Web.HttpUtility.UrlDecode(instr, Encoding.GetEncoding(charset));
#else
                    return WebUtility.UrlDecode(instr);
#endif
                }
                catch (Exception ex)
                {
#if NET35 || NET40 || NET45 || NET461
                    return System.Web.HttpUtility.UrlDecode(instr, Encoding.GetEncoding("GB2312"));
#else
                    return WebUtility.UrlDecode(instr);
#endif
                }
                //return res;

            }
        }


        /// <summary>
        /// ȡʱ漴,滻׵еĺ10λˮ
        /// </summary>
        /// <returns></returns>
        public static UInt32 UnixStamp()
        {
#if NET35 || NET40 || NET45 || NET461
            TimeSpan ts = DateTime.Now - TimeZone.CurrentTimeZone.ToLocalTime(new DateTime(1970, 1, 1));
#else
            TimeSpan ts = DateTime.Now - new DateTime(1970, 1, 1);
#endif
            return Convert.ToUInt32(ts.TotalSeconds);
        }

        /// <summary>
        /// ȡ
        /// </summary>
        /// <param name="length"></param>
        /// <returns></returns>
        public static string BuildRandomStr(int length)
        {
            int num;

            lock (random)
            {
                num = random.Next();
            }

            string str = num.ToString();

            if (str.Length > length)
            {
                str = str.Substring(0, length);
            }
            else if (str.Length < length)
            {
                int n = length - str.Length;
                while (n > 0)
                {
                    str = str.Insert(0, "0");
                    n--;
                }
            }

            return str;
        }

        /// <summary>
        /// ڲظ
        /// </summary>
        /// <param name="length"></param>
        /// <returns></returns>
        public static string BuildDailyRandomStr(int length)
        {
            var stringFormat = DateTime.Now.ToString("HHmmss0000");//10λ

            return stringFormat;
        }


        /// <summary>
        /// ˿֪ͨϢн
        /// </summary>
        /// <param name="reqInfo"></param>
        /// <param name="mchKey"></param>
        /// <returns></returns>
        public static string DecodeRefundReqInfo(string reqInfo, string mchKey)
        {
            //οĵhttps://pay.weixin.qq.com/wiki/doc/api/native.php?chapter=9_16&index=11
            /*
               ܲ£ 
                1ԼܴAbase64룬õܴB
                2̻keymd5õ32λСдkey* ( key·΢̻ƽ̨(pay.weixin.qq.com)-->˻-->APIȫ-->Կ )

                3key*ԼܴBAES-256-ECBܣPKCS7Padding
             */
            //var base64Encode = Encoding.UTF8.GetString(Convert.FromBase64String(reqInfo));//(1)
            var base64Encode = reqInfo;//(1) EncryptHelper.AESDecrypt ڲһbase64룬ﲻҪ
            var md5Str = EncryptHelper.GetLowerMD5(mchKey, Encoding.UTF8);//(2)
            var result = EncryptHelper.AESDecrypt(base64Encode, md5Str);//(3)
            return result;
        }
    }
}
