﻿// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

using System.Diagnostics.Contracts;

namespace System.Web.Http.SelfHost.ServiceModel.Channels
{
    internal class CompletedAsyncResult<T> : AsyncResult
    {
        private T data;

        public CompletedAsyncResult(T data, AsyncCallback callback, object state)
            : base(callback, state)
        {
            this.data = data;
            Complete(true);
        }

        public static T End(IAsyncResult result)
        {
            Contract.Assert(result != null, "CompletedAsyncResult<T> was null.");
            Contract.Assert(result.IsCompleted, "CompletedAsyncResult<T> was not completed!");
            CompletedAsyncResult<T> completedResult = AsyncResult.End<CompletedAsyncResult<T>>(result);
            return completedResult.data;
        }
    }
}