﻿// Copyright (c) Microsoft Open Technologies, Inc. All rights reserved. See License.txt in the project root for license information.

using System.Diagnostics.CodeAnalysis;

namespace System.Web.Razor.Tokenizer.Symbols
{
    public enum VBKeyword
    {
        AddHandler,
        AndAlso,
        Byte,
        Catch,
        CDate,
        CInt,
        Const,
        CSng,

        [SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId = "Lng", Justification = "This is a VB Keyword. Note: Excluded here because it is a specific case")]
        CULng,
        Declare,
        DirectCast,
        Else,
        Enum,
        Exit,
        Friend,
        GetXmlNamespace,
        Handles,
        In,
        Is,
        Like,
        Mod,
        MyBase,
        New,
        AddressOf,
        As,
        ByVal,
        CBool,

        [SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId = "Dbl", Justification = "This is a VB Keyword. Note: Excluded here because it is a specific case")]
        CDbl,
        Class,
        Continue,
        CStr,
        CUShort,
        Default,
        Do,
        ElseIf,
        Erase,
        False,
        Function,
        Global,
        If,
        Inherits,
        IsNot,
        Long,
        Module,
        MyClass,
        Next,
        Alias,
        Boolean,
        Call,
        CByte,
        CDec,

        [SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId = "Lng", Justification = "This is a VB Keyword. Note: Excluded here because it is a specific case")]
        CLng,
        CSByte,
        CType,
        Date,
        Delegate,
        Double,
        End,
        Error,
        Finally,
        Get,
        GoSub,
        Implements,
        Integer,
        Let,
        Loop,
        MustInherit,
        Namespace,
        Not,
        And,
        ByRef,
        Case,
        CChar,
        Char,
        CObj,
        CShort,
        CUInt,
        Decimal,
        Dim,
        Each,
        EndIf,
        Event,
        For,
        GetType,
        GoTo,
        Imports,
        Interface,
        Lib,
        Me,
        MustOverride,
        Narrowing,
        Nothing,
        NotInheritable,
        On,
        Or,
        Overrides,
        Property,
        ReadOnly,
        Resume,
        Set,
        Single,
        String,
        Then,
        Try,
        ULong,
        Wend,
        With,
        NotOverridable,
        Operator,
        OrElse,
        ParamArray,
        Protected,
        ReDim,
        Return,
        Shadows,
        Static,
        Structure,
        Throw,
        TryCast,
        UShort,
        When,
        WithEvents,
        Object,
        Option,
        Overloads,
        Partial,
        Public,
        Rem,
        SByte,
        Shared,
        Step,
        Sub,
        To,
        TypeOf,
        Using,
        While,
        WriteOnly,
        Of,
        Optional,
        Overridable,
        Private,
        RaiseEvent,
        RemoveHandler,
        Select,
        Short,
        Stop,
        SyncLock,
        True,
        UInteger,
        Variant,
        Widening,
        Xor
    }
}
