﻿// Copyright (c) Microsoft Open Technologies, Inc. All rights reserved. See License.txt in the project root for license information.

namespace System.Web.Http.Description
{
    /// <summary>
    /// This attribute can be used on the controllers and actions to influence the behavior of <see cref="ApiExplorer"/>.
    /// </summary>
    [AttributeUsage(AttributeTargets.Class | AttributeTargets.Method, AllowMultiple = false)]
    public sealed class ApiExplorerSettingsAttribute : Attribute
    {
        /// <summary>
        /// Gets or sets a value indicating whether to exclude the controller or action from the ApiDescriptions generated by <see cref="ApiExplorer"/>.
        /// </summary>
        /// <value>
        ///   <c>true</c> if the controller or action should be ignored; otherwise, <c>false</c>.
        /// </value>
        public bool IgnoreApi { get; set; }
    }
}
