<div align="right">Language: :us:
<a title="Chinese" href="../docs/zh-CN/CODE_OF_CONDUCT.md">:cn:</a>
<a title="Russian" href="../docs/ru/CODE_OF_CONDUCT.md">:ru:</a></div>

# <div align="center"><a title="Go to homepage" href="https://theme-next.org"><img align="center" width="56" height="56" src="https://raw.githubusercontent.com/theme-next/hexo-theme-next/master/source/images/logo.svg?sanitize=true"></a> e x T</div>

[NexT](https://theme-next.org) is an elegant and powerful theme for [Hexo](https://hexo.io/). With it, you can build a static blog hosted on [GitHub Pages](https://pages.github.com/) to share your life and communicate with new friends.

A CODE_OF_CONDUCT dictates how conversation during code updates, issue communication, and pull requests should happen within [NexT](https://github.com/theme-next/hexo-theme-next) repository.  We expect all users to show respect and courtesy to others through our repositories. Anyone violating these rules will not be reviewed and will be blocked and expelled from our repositories immediately upon discovery.

## Table Of Contents

- [Our Pledge](#our-pledge)
- [Our Responsibilities](#our-responsibilities)
- [Our Standards](#our-standards)
- [Scope](#scope)
- [Enforcement](#enforcement)
- [Contacting Maintainers](#contacting-maintainers)
- [Attribution](#attribution)

## Our Pledge

As contributors and maintainers of this project, we pledge to respect all people who contribute through reporting issues, posting feature requests, updating documentation, submitting pull requests or patches, and other activities.

In the interest of fostering an open and welcoming environment, we are committed to making participation in our community a harassment-free experience for everyone, regardless of level of experience, gender, gender identity and expression, sexual identity and orientation, disability, personal appearance, body size, race, ethnicity, age, religion, or nationality.

## Our Responsibilities

Project maintainers have the right and responsibility to clarify the standards of acceptable behavior and are expected to remove, edit, or reject comments, commits, code, wiki edits, issues, and other contributions that are not aligned to this Code of Conduct, or to block temporarily or permanently any contributor for other behaviors that they deem inappropriate, threatening, offensive, or harmful.

## Our Standards

As a project on GitHub, this project is overed by the [GitHub Community Guidelines](https://help.github.com/articles/github-community-guidelines/). Additionally, as a project hosted on npm, it is covered by [npm Inc's Code of Conduct](https://www.npmjs.com/policies/conduct).

Examples of behavior that contributes to creating a positive environment include:

* Using welcoming and inclusive language.
* Being respectful of differing viewpoints and experiences.
* Gracefully accepting constructive feedback.
* Focusing on what is best for the community.
* Showing empathy and kindness towards other community members.

Examples of unacceptable behavior by participants include:

* The use of sexualized language or imagery and unwelcome sexual attention or advances
* Trolling, insulting/derogatory comments, and personal or political attacks
* Public or private harassment
* Publishing others’ private information, such as a physical or electronic address, without explicit permission
* Other conduct which could reasonably be considered inappropriate in a professional setting

## Scope

This Code of Conduct applies both within project spaces and in public spaces when an individual is representing the project or its community.

Depending on the violation, the maintainers may decide that violations of this code of conduct that have happened outside of the scope of the community may deem an individual unwelcome, and take appropriate action to maintain the comfort and safety of its members.

## Enforcement

If you see a Code of Conduct violation, follow these steps:

1. Let the person know that what they did is not appropriate and ask them to stop and/or edit their message(s) or commits. That person should immediately stop the behavior and correct the issue.
2. If this doesn’t happen, or if you're uncomfortable speaking up, [contact the maintainers](#contacting-maintainers). When reporting, please include any relevant details, links, screenshots, context, or other information that may be used to better understand and resolve the situation.
3. As soon as available, a maintainer will look into the issue, and take further action.

Once the maintainers get involved, they will follow a documented series of steps and do their best to preserve the well-being of project members.

All complaints will be reviewed and investigated and will result in a response that is deemed necessary and appropriate to the circumstances. The project team is obligated to maintain confidentiality with regard to the reporter of an incident. Further details of specific enforcement policies may be posted separately.

Thesehese are the steps maintainers will take for further enforcement, as needed:

1. Repeat the request to stop.
2. If the person doubles down, they will have offending messages removed or edited by a maintainers given an official warning. The PR or Issue may be locked.
3. If the behavior continues or is repeated later, the person will be blocked from participating for 24 hours.
4. If the behavior continues or is repeated after the temporary block, a long-term (6-12 months) ban will be used.

On top of this, maintainers may remove any offending messages, images, contributions, etc, as they deem necessary. Maintainers reserve full rights to skip any of these steps, at their discretion, if the violation is considered to be a serious and/or immediate threat to the well-being of members of the community. These include any threats, serious physical or verbal attacks, and other such behavior that would be completely unacceptable in any social setting that puts our members at risk.

Project maintainers who do not follow or enforce the Code of Conduct in good faith may face temporary or permanent repercussions as determined by other members of the project's leadership.

## Contacting Maintainers

You may get in touch with the maintainer team through any of the following methods:

* Through Email:
    * [support@theme-next.org](mailto:support@theme-next.org)

* Through Chat:
    * [Gitter](https://gitter.im/theme-next)
    * [Riot](https://riot.im/app/#/room/#NexT:matrix.org)
    * [Telegram](https://t.me/joinchat/GUNHXA-vZkgSMuimL1VmMw)

## Attribution

This Code of Conduct is adapted from the [Contributor Covenant](https://www.contributor-covenant.org/) and [WeAllJS Code of Conduct](https://wealljs.org/code-of-conduct).
