Contributing to Silhouette
==========================


How to contribute
-----------------

Silhouette is an open source project. Contributions are appreciated.

See the current [list of contributors](https://github.com/mohiva/play-silhouette/graphs/contributors) and join them!

Some ways in which you can contribute are: reporting errors, improving documentation, adding examples, adding support for more services, fixing bugs, suggesting new features, adding test cases, translating messages, and whatever else you can think of that may be helpful. If in doubt, just ask.


Development workflow
--------------------

Development is coordinated via [GitHub](https://github.com/mohiva/play-silhouette). Ideas for improvements are discussed using [issues](https://github.com/mohiva/play-silhouette/issues).

For a more streamlined experience for all people involved, we encourage contributors to follow the practices described at [GitHub workflow for submitting pull requests](http://docs.openshift.org/origin-m4/oo_contributors_guide.html#submitting-code).

Scala source code should follow the conventions documented in the [Scala Style Guide](http://docs.scala-lang.org/style/). Additionally, acronyms should be capitalized. To have your code automatically reformatted, run this command before committing your changes:

    scripts/reformat

After submitting your pull request, please [watch the result](https://travis-ci.org/mohiva/play-silhouette/pull_requests) of the automated Travis CI build and correct any reported errors or inconsistencies.


License and Copyright
---------------------

By submitting work via pull requests, issues, wiki, or any other means, contributors indicate their agreement to publish their work under this project's license and also attest that they are the authors of the work and grant a copyright license to the Mohiva Organisation, unless the contribution clearly states a different copyright notice (e.g., it contains original work by a third party).
