<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStoreClassesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('store_classes', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('store_id')->default(0)->comment("店铺ID");
            $table->text('class_id')->comment("栏目ID");
            $table->text('class_name')->comment("栏目名称");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('store_classes');
    }
}
