/*
 * Copyright (c) 2004-2007 Atheros Communications Inc.
 * All rights reserved.
 *
 * $ATH_LICENSE_HOSTSDK0_C$
 *
 * This file contains the definitions for AR6001 registers
 * that may be directly manipulated by Host software.
 */

#ifndef __AR6KHWREG_H__
#define __AR6KHWREG_H__

#ifdef __cplusplus
extern "C" {
#endif

/* Host registers */
#define HOST_INT_STATUS_ADDRESS                  0x00000400
#define CPU_INT_STATUS_ADDRESS                   0x00000401
#define ERROR_INT_STATUS_ADDRESS                 0x00000402
#define INT_STATUS_ENABLE_ADDRESS                0x00000418
#define CPU_INT_STATUS_ENABLE_ADDRESS            0x00000419
#define COUNT_ADDRESS                            0x00000420
#define COUNT_DEC_ADDRESS                        0x00000440
#define WINDOW_DATA_ADDRESS                      0x00000474
#define WINDOW_WRITE_ADDR_ADDRESS                0x00000478
#define WINDOW_READ_ADDR_ADDRESS                 0x0000047c

/* Target addresses */
#define RESET_CONTROL_ADDRESS                    0x0c000000
#define MC_REMAP_VALID_ADDRESS                   0x0c004080
#define MC_REMAP_SIZE_ADDRESS                    0x0c004100
#define MC_REMAP_COMPARE_ADDRESS                 0x0c004180
#define MC_REMAP_TARGET_ADDRESS                  0x0c004200
#define LOCAL_COUNT_ADDRESS                      0x0c014080
#define LOCAL_SCRATCH_ADDRESS                    0x0c0140c0


#define INT_STATUS_ENABLE_ERROR_MSB              7
#define INT_STATUS_ENABLE_ERROR_LSB              7
#define INT_STATUS_ENABLE_ERROR_MASK             0x00000080
#define INT_STATUS_ENABLE_ERROR_GET(x)           (((x) & INT_STATUS_ENABLE_ERROR_MASK) >> INT_STATUS_ENABLE_ERROR_LSB)
#define INT_STATUS_ENABLE_ERROR_SET(x)           (((x) << INT_STATUS_ENABLE_ERROR_LSB) & INT_STATUS_ENABLE_ERROR_MASK)

#define INT_STATUS_ENABLE_CPU_MSB                6
#define INT_STATUS_ENABLE_CPU_LSB                6
#define INT_STATUS_ENABLE_CPU_MASK               0x00000040
#define INT_STATUS_ENABLE_CPU_GET(x)             (((x) & INT_STATUS_ENABLE_CPU_MASK) >> INT_STATUS_ENABLE_CPU_LSB)
#define INT_STATUS_ENABLE_CPU_SET(x)             (((x) << INT_STATUS_ENABLE_CPU_LSB) & INT_STATUS_ENABLE_CPU_MASK)

#define INT_STATUS_ENABLE_COUNTER_MSB            4
#define INT_STATUS_ENABLE_COUNTER_LSB            4
#define INT_STATUS_ENABLE_COUNTER_MASK           0x00000010
#define INT_STATUS_ENABLE_COUNTER_GET(x)         (((x) & INT_STATUS_ENABLE_COUNTER_MASK) >> INT_STATUS_ENABLE_COUNTER_LSB)
#define INT_STATUS_ENABLE_COUNTER_SET(x)         (((x) << INT_STATUS_ENABLE_COUNTER_LSB) & INT_STATUS_ENABLE_COUNTER_MASK)

#define INT_STATUS_ENABLE_MBOX_DATA_MSB          3
#define INT_STATUS_ENABLE_MBOX_DATA_LSB          0
#define INT_STATUS_ENABLE_MBOX_DATA_MASK         0x0000000f
#define INT_STATUS_ENABLE_MBOX_DATA_GET(x)       (((x) & INT_STATUS_ENABLE_MBOX_DATA_MASK) >> INT_STATUS_ENABLE_MBOX_DATA_LSB)
#define INT_STATUS_ENABLE_MBOX_DATA_SET(x)       (((x) << INT_STATUS_ENABLE_MBOX_DATA_LSB) & INT_STATUS_ENABLE_MBOX_DATA_MASK)

#define ERROR_STATUS_ENABLE_RX_UNDERFLOW_MSB     1
#define ERROR_STATUS_ENABLE_RX_UNDERFLOW_LSB     1
#define ERROR_STATUS_ENABLE_RX_UNDERFLOW_MASK    0x00000002
#define ERROR_STATUS_ENABLE_RX_UNDERFLOW_GET(x)  (((x) & ERROR_STATUS_ENABLE_RX_UNDERFLOW_MASK) >> ERROR_STATUS_ENABLE_RX_UNDERFLOW_LSB)
#define ERROR_STATUS_ENABLE_RX_UNDERFLOW_SET(x)  (((x) << ERROR_STATUS_ENABLE_RX_UNDERFLOW_LSB) & ERROR_STATUS_ENABLE_RX_UNDERFLOW_MASK)

#define ERROR_STATUS_ENABLE_TX_OVERFLOW_MSB      0
#define ERROR_STATUS_ENABLE_TX_OVERFLOW_LSB      0
#define ERROR_STATUS_ENABLE_TX_OVERFLOW_MASK     0x00000001
#define ERROR_STATUS_ENABLE_TX_OVERFLOW_GET(x)   (((x) & ERROR_STATUS_ENABLE_TX_OVERFLOW_MASK) >> ERROR_STATUS_ENABLE_TX_OVERFLOW_LSB)
#define ERROR_STATUS_ENABLE_TX_OVERFLOW_SET(x)   (((x) << ERROR_STATUS_ENABLE_TX_OVERFLOW_LSB) & ERROR_STATUS_ENABLE_TX_OVERFLOW_MASK)


#define CPU_INT_STATUS_ENABLE_BIT_MSB            7
#define CPU_INT_STATUS_ENABLE_BIT_LSB            0
#define CPU_INT_STATUS_ENABLE_BIT_MASK           0x000000ff
#define CPU_INT_STATUS_ENABLE_BIT_GET(x)         (((x) & CPU_INT_STATUS_ENABLE_BIT_MASK) >> CPU_INT_STATUS_ENABLE_BIT_LSB)
#define CPU_INT_STATUS_ENABLE_BIT_SET(x)         (((x) << CPU_INT_STATUS_ENABLE_BIT_LSB) & CPU_INT_STATUS_ENABLE_BIT_MASK)

#define COUNTER_INT_STATUS_ENABLE_BIT_MSB        7
#define COUNTER_INT_STATUS_ENABLE_BIT_LSB        0
#define COUNTER_INT_STATUS_ENABLE_BIT_MASK       0x000000ff
#define COUNTER_INT_STATUS_ENABLE_BIT_GET(x)     (((x) & COUNTER_INT_STATUS_ENABLE_BIT_MASK) >> COUNTER_INT_STATUS_ENABLE_BIT_LSB)
#define COUNTER_INT_STATUS_ENABLE_BIT_SET(x)     (((x) << COUNTER_INT_STATUS_ENABLE_BIT_LSB) & COUNTER_INT_STATUS_ENABLE_BIT_MASK)

#define ERROR_INT_STATUS_WAKEUP_MSB              2
#define ERROR_INT_STATUS_WAKEUP_LSB              2
#define ERROR_INT_STATUS_WAKEUP_MASK             0x00000004
#define ERROR_INT_STATUS_WAKEUP_GET(x)           (((x) & ERROR_INT_STATUS_WAKEUP_MASK) >> ERROR_INT_STATUS_WAKEUP_LSB)
#define ERROR_INT_STATUS_WAKEUP_SET(x)           (((x) << ERROR_INT_STATUS_WAKEUP_LSB) & ERROR_INT_STATUS_WAKEUP_MASK)

#define ERROR_INT_STATUS_RX_UNDERFLOW_MSB        1
#define ERROR_INT_STATUS_RX_UNDERFLOW_LSB        1
#define ERROR_INT_STATUS_RX_UNDERFLOW_MASK       0x00000002
#define ERROR_INT_STATUS_RX_UNDERFLOW_GET(x)     (((x) & ERROR_INT_STATUS_RX_UNDERFLOW_MASK) >> ERROR_INT_STATUS_RX_UNDERFLOW_LSB)
#define ERROR_INT_STATUS_RX_UNDERFLOW_SET(x)     (((x) << ERROR_INT_STATUS_RX_UNDERFLOW_LSB) & ERROR_INT_STATUS_RX_UNDERFLOW_MASK)

#define ERROR_INT_STATUS_TX_OVERFLOW_MSB         0
#define ERROR_INT_STATUS_TX_OVERFLOW_LSB         0
#define ERROR_INT_STATUS_TX_OVERFLOW_MASK        0x00000001
#define ERROR_INT_STATUS_TX_OVERFLOW_GET(x)      (((x) & ERROR_INT_STATUS_TX_OVERFLOW_MASK) >> ERROR_INT_STATUS_TX_OVERFLOW_LSB)
#define ERROR_INT_STATUS_TX_OVERFLOW_SET(x)      (((x) << ERROR_INT_STATUS_TX_OVERFLOW_LSB) & ERROR_INT_STATUS_TX_OVERFLOW_MASK)

#define HOST_INT_STATUS_ERROR_MSB                7
#define HOST_INT_STATUS_ERROR_LSB                7
#define HOST_INT_STATUS_ERROR_MASK               0x00000080
#define HOST_INT_STATUS_ERROR_GET(x)             (((x) & HOST_INT_STATUS_ERROR_MASK) >> HOST_INT_STATUS_ERROR_LSB)
#define HOST_INT_STATUS_ERROR_SET(x)             (((x) << HOST_INT_STATUS_ERROR_LSB) & HOST_INT_STATUS_ERROR_MASK)

#define HOST_INT_STATUS_CPU_MSB                  6
#define HOST_INT_STATUS_CPU_LSB                  6
#define HOST_INT_STATUS_CPU_MASK                 0x00000040
#define HOST_INT_STATUS_CPU_GET(x)               (((x) & HOST_INT_STATUS_CPU_MASK) >> HOST_INT_STATUS_CPU_LSB)
#define HOST_INT_STATUS_CPU_SET(x)               (((x) << HOST_INT_STATUS_CPU_LSB) & HOST_INT_STATUS_CPU_MASK)

#define HOST_INT_STATUS_COUNTER_MSB              4
#define HOST_INT_STATUS_COUNTER_LSB              4
#define HOST_INT_STATUS_COUNTER_MASK             0x00000010
#define HOST_INT_STATUS_COUNTER_GET(x)           (((x) & HOST_INT_STATUS_COUNTER_MASK) >> HOST_INT_STATUS_COUNTER_LSB)
#define HOST_INT_STATUS_COUNTER_SET(x)           (((x) << HOST_INT_STATUS_COUNTER_LSB) & HOST_INT_STATUS_COUNTER_MASK)

#define RESET_CONTROL_WARM_RST_MSB               7
#define RESET_CONTROL_WARM_RST_LSB               7
#define RESET_CONTROL_WARM_RST_MASK              0x00000080
#define RESET_CONTROL_WARM_RST_GET(x)            (((x) & RESET_CONTROL_WARM_RST_MASK) >> RESET_CONTROL_WARM_RST_LSB)
#define RESET_CONTROL_WARM_RST_SET(x)            (((x) << RESET_CONTROL_WARM_RST_LSB) & RESET_CONTROL_WARM_RST_MASK)

#define RESET_CONTROL_COLD_RST_MSB               8
#define RESET_CONTROL_COLD_RST_LSB               8
#define RESET_CONTROL_COLD_RST_MASK              0x00000100
#define RESET_CONTROL_COLD_RST_GET(x)            (((x) & RESET_CONTROL_COLD_RST_MASK) >> RESET_CONTROL_COLD_RST_LSB)
#define RESET_CONTROL_COLD_RST_SET(x)            (((x) << RESET_CONTROL_COLD_RST_LSB) & RESET_CONTROL_COLD_RST_MASK)

#define RESET_CAUSE_LAST_MSB                     2
#define RESET_CAUSE_LAST_LSB                     0
#define RESET_CAUSE_LAST_MASK                    0x00000007
#define RESET_CAUSE_LAST_GET(x)                  (((x) & RESET_CAUSE_LAST_MASK) >> RESET_CAUSE_LAST_LSB)
#define RESET_CAUSE_LAST_SET(x)                  (((x) << RESET_CAUSE_LAST_LSB) & RESET_CAUSE_LAST_MASK)

#ifdef __cplusplus
}
#endif

#endif /* __AR6KHWREG_H__ */
