// This file is part of arduino-cli.
//
// Copyright 2020 ARDUINO SA (http://www.arduino.cc/)
//
// This software is released under the GNU General Public License version 3,
// which covers the main part of arduino-cli.
// The terms of this license can be found at:
// https://www.gnu.org/licenses/gpl-3.0.en.html
//
// You can be released from the requirements of the above licenses by purchasing
// a commercial license. Buying such a license is mandatory if you want to
// modify or otherwise use the software for commercial activities involving the
// Arduino software without disclosing the source code of your own applications.
// To purchase a commercial license, send an email to license@arduino.cc.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.11.3
// source: commands/upload.proto

package commands

import (
	proto "github.com/golang/protobuf/proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

type UploadReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Fully qualified board name of the target board (e.g., `arduino:avr:uno`).
	// If this field is not defined, the FQBN of the board attached to the sketch
	// via the `BoardAttach` method is used.
	Fqbn string `protobuf:"bytes,2,opt,name=fqbn,proto3" json:"fqbn,omitempty"`
	// Path where the sketch to be uploaded is stored. Unless the `import_file`
	// field is defined, the compiled binary is assumed to be at the location and
	// filename under this path where it is saved by the `Compile` method.
	SketchPath string `protobuf:"bytes,3,opt,name=sketch_path,json=sketchPath,proto3" json:"sketch_path,omitempty"`
	// The port of the board.
	Port string `protobuf:"bytes,4,opt,name=port,proto3" json:"port,omitempty"`
	// Whether to turn on verbose output during the upload.
	Verbose bool `protobuf:"varint,5,opt,name=verbose,proto3" json:"verbose,omitempty"`
	// After upload, verify that the contents of the memory on the board match the
	// uploaded binary.
	Verify bool `protobuf:"varint,6,opt,name=verify,proto3" json:"verify,omitempty"`
	// When `import_file` is specified, it overrides the `import_dir` and `sketch_path`
	// params.
	ImportFile string `protobuf:"bytes,7,opt,name=import_file,json=importFile,proto3" json:"import_file,omitempty"`
	// Custom path to a directory containing compiled files. When `import_dir` is
	// not specified, the standard build directory under `sketch_path` is used.
	ImportDir  string `protobuf:"bytes,8,opt,name=import_dir,json=importDir,proto3" json:"import_dir,omitempty"`
	Programmer string `protobuf:"bytes,9,opt,name=programmer,proto3" json:"programmer,omitempty"`
}

func (x *UploadReq) Reset() {
	*x = UploadReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_upload_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadReq) ProtoMessage() {}

func (x *UploadReq) ProtoReflect() protoreflect.Message {
	mi := &file_commands_upload_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadReq.ProtoReflect.Descriptor instead.
func (*UploadReq) Descriptor() ([]byte, []int) {
	return file_commands_upload_proto_rawDescGZIP(), []int{0}
}

func (x *UploadReq) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *UploadReq) GetFqbn() string {
	if x != nil {
		return x.Fqbn
	}
	return ""
}

func (x *UploadReq) GetSketchPath() string {
	if x != nil {
		return x.SketchPath
	}
	return ""
}

func (x *UploadReq) GetPort() string {
	if x != nil {
		return x.Port
	}
	return ""
}

func (x *UploadReq) GetVerbose() bool {
	if x != nil {
		return x.Verbose
	}
	return false
}

func (x *UploadReq) GetVerify() bool {
	if x != nil {
		return x.Verify
	}
	return false
}

func (x *UploadReq) GetImportFile() string {
	if x != nil {
		return x.ImportFile
	}
	return ""
}

func (x *UploadReq) GetImportDir() string {
	if x != nil {
		return x.ImportDir
	}
	return ""
}

func (x *UploadReq) GetProgrammer() string {
	if x != nil {
		return x.Programmer
	}
	return ""
}

type UploadResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The output of the upload process.
	OutStream []byte `protobuf:"bytes,1,opt,name=out_stream,json=outStream,proto3" json:"out_stream,omitempty"`
	// The error output of the upload process.
	ErrStream []byte `protobuf:"bytes,2,opt,name=err_stream,json=errStream,proto3" json:"err_stream,omitempty"`
}

func (x *UploadResp) Reset() {
	*x = UploadResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_upload_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadResp) ProtoMessage() {}

func (x *UploadResp) ProtoReflect() protoreflect.Message {
	mi := &file_commands_upload_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadResp.ProtoReflect.Descriptor instead.
func (*UploadResp) Descriptor() ([]byte, []int) {
	return file_commands_upload_proto_rawDescGZIP(), []int{1}
}

func (x *UploadResp) GetOutStream() []byte {
	if x != nil {
		return x.OutStream
	}
	return nil
}

func (x *UploadResp) GetErrStream() []byte {
	if x != nil {
		return x.ErrStream
	}
	return nil
}

type BurnBootloaderReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Fully qualified board name of the target board (e.g., `arduino:avr:uno`).
	Fqbn string `protobuf:"bytes,2,opt,name=fqbn,proto3" json:"fqbn,omitempty"`
	// The port of the programmer used to program the bootloader.
	Port string `protobuf:"bytes,3,opt,name=port,proto3" json:"port,omitempty"`
	// Whether to turn on verbose output during the programming.
	Verbose bool `protobuf:"varint,4,opt,name=verbose,proto3" json:"verbose,omitempty"`
	// After programming, verify the contents of the memory on the board match the
	// uploaded binary.
	Verify bool `protobuf:"varint,5,opt,name=verify,proto3" json:"verify,omitempty"`
	// The programmer to use for burning bootloader.
	Programmer string `protobuf:"bytes,6,opt,name=programmer,proto3" json:"programmer,omitempty"`
}

func (x *BurnBootloaderReq) Reset() {
	*x = BurnBootloaderReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_upload_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BurnBootloaderReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BurnBootloaderReq) ProtoMessage() {}

func (x *BurnBootloaderReq) ProtoReflect() protoreflect.Message {
	mi := &file_commands_upload_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BurnBootloaderReq.ProtoReflect.Descriptor instead.
func (*BurnBootloaderReq) Descriptor() ([]byte, []int) {
	return file_commands_upload_proto_rawDescGZIP(), []int{2}
}

func (x *BurnBootloaderReq) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *BurnBootloaderReq) GetFqbn() string {
	if x != nil {
		return x.Fqbn
	}
	return ""
}

func (x *BurnBootloaderReq) GetPort() string {
	if x != nil {
		return x.Port
	}
	return ""
}

func (x *BurnBootloaderReq) GetVerbose() bool {
	if x != nil {
		return x.Verbose
	}
	return false
}

func (x *BurnBootloaderReq) GetVerify() bool {
	if x != nil {
		return x.Verify
	}
	return false
}

func (x *BurnBootloaderReq) GetProgrammer() string {
	if x != nil {
		return x.Programmer
	}
	return ""
}

type BurnBootloaderResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The output of the burn bootloader process.
	OutStream []byte `protobuf:"bytes,1,opt,name=out_stream,json=outStream,proto3" json:"out_stream,omitempty"`
	// The error output of the burn bootloader process.
	ErrStream []byte `protobuf:"bytes,2,opt,name=err_stream,json=errStream,proto3" json:"err_stream,omitempty"`
}

func (x *BurnBootloaderResp) Reset() {
	*x = BurnBootloaderResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_upload_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BurnBootloaderResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BurnBootloaderResp) ProtoMessage() {}

func (x *BurnBootloaderResp) ProtoReflect() protoreflect.Message {
	mi := &file_commands_upload_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BurnBootloaderResp.ProtoReflect.Descriptor instead.
func (*BurnBootloaderResp) Descriptor() ([]byte, []int) {
	return file_commands_upload_proto_rawDescGZIP(), []int{3}
}

func (x *BurnBootloaderResp) GetOutStream() []byte {
	if x != nil {
		return x.OutStream
	}
	return nil
}

func (x *BurnBootloaderResp) GetErrStream() []byte {
	if x != nil {
		return x.ErrStream
	}
	return nil
}

type ListProgrammersAvailableForUploadReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	Fqbn     string    `protobuf:"bytes,2,opt,name=fqbn,proto3" json:"fqbn,omitempty"`
}

func (x *ListProgrammersAvailableForUploadReq) Reset() {
	*x = ListProgrammersAvailableForUploadReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_upload_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProgrammersAvailableForUploadReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProgrammersAvailableForUploadReq) ProtoMessage() {}

func (x *ListProgrammersAvailableForUploadReq) ProtoReflect() protoreflect.Message {
	mi := &file_commands_upload_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProgrammersAvailableForUploadReq.ProtoReflect.Descriptor instead.
func (*ListProgrammersAvailableForUploadReq) Descriptor() ([]byte, []int) {
	return file_commands_upload_proto_rawDescGZIP(), []int{4}
}

func (x *ListProgrammersAvailableForUploadReq) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *ListProgrammersAvailableForUploadReq) GetFqbn() string {
	if x != nil {
		return x.Fqbn
	}
	return ""
}

type ListProgrammersAvailableForUploadResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Programmers []*Programmer `protobuf:"bytes,1,rep,name=programmers,proto3" json:"programmers,omitempty"`
}

func (x *ListProgrammersAvailableForUploadResp) Reset() {
	*x = ListProgrammersAvailableForUploadResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_upload_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProgrammersAvailableForUploadResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProgrammersAvailableForUploadResp) ProtoMessage() {}

func (x *ListProgrammersAvailableForUploadResp) ProtoReflect() protoreflect.Message {
	mi := &file_commands_upload_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProgrammersAvailableForUploadResp.ProtoReflect.Descriptor instead.
func (*ListProgrammersAvailableForUploadResp) Descriptor() ([]byte, []int) {
	return file_commands_upload_proto_rawDescGZIP(), []int{5}
}

func (x *ListProgrammersAvailableForUploadResp) GetProgrammers() []*Programmer {
	if x != nil {
		return x.Programmers
	}
	return nil
}

var File_commands_upload_proto protoreflect.FileDescriptor

var file_commands_upload_proto_rawDesc = []byte{
	0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x75, 0x70, 0x6c, 0x6f, 0x61,
	0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75,
	0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73,
	0x1a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa5, 0x02, 0x0a, 0x09, 0x55, 0x70, 0x6c, 0x6f,
	0x61, 0x64, 0x52, 0x65, 0x71, 0x12, 0x3d, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64,
	0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x71, 0x62, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x66, 0x71, 0x62, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x6b, 0x65, 0x74,
	0x63, 0x68, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73,
	0x6b, 0x65, 0x74, 0x63, 0x68, 0x50, 0x61, 0x74, 0x68, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x6f, 0x72,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x18, 0x0a,
	0x07, 0x76, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07,
	0x76, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x76, 0x65, 0x72, 0x69, 0x66,
	0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x12,
	0x1f, 0x0a, 0x0b, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x46, 0x69, 0x6c, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x64, 0x69, 0x72, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x69, 0x72, 0x12,
	0x1e, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x22,
	0x4a, 0x0a, 0x0a, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x73, 0x70, 0x12, 0x1d, 0x0a,
	0x0a, 0x6f, 0x75, 0x74, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x09, 0x6f, 0x75, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x1d, 0x0a, 0x0a,
	0x65, 0x72, 0x72, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x09, 0x65, 0x72, 0x72, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0xcc, 0x01, 0x0a, 0x11,
	0x42, 0x75, 0x72, 0x6e, 0x42, 0x6f, 0x6f, 0x74, 0x6c, 0x6f, 0x61, 0x64, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x12, 0x3d, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x12, 0x0a, 0x04, 0x66, 0x71, 0x62, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x66, 0x71, 0x62, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x62,
	0x6f, 0x73, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x76, 0x65, 0x72, 0x62, 0x6f,
	0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x06, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x22, 0x52, 0x0a, 0x12, 0x42, 0x75,
	0x72, 0x6e, 0x42, 0x6f, 0x6f, 0x74, 0x6c, 0x6f, 0x61, 0x64, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70,
	0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x75, 0x74, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x6f, 0x75, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12,
	0x1d, 0x0a, 0x0a, 0x65, 0x72, 0x72, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x09, 0x65, 0x72, 0x72, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0x79,
	0x0a, 0x24, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72,
	0x73, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x55, 0x70, 0x6c,
	0x6f, 0x61, 0x64, 0x52, 0x65, 0x71, 0x12, 0x3d, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72,
	0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x73, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x71, 0x62, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x66, 0x71, 0x62, 0x6e, 0x22, 0x6e, 0x0a, 0x25, 0x4c, 0x69, 0x73,
	0x74, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x73, 0x41, 0x76, 0x61, 0x69,
	0x6c, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65,
	0x73, 0x70, 0x12, 0x45, 0x0a, 0x0b, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64,
	0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x2e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x52, 0x0b, 0x70, 0x72,
	0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x73, 0x42, 0x2d, 0x5a, 0x2b, 0x67, 0x69, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f,
	0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x72, 0x70, 0x63, 0x2f,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_commands_upload_proto_rawDescOnce sync.Once
	file_commands_upload_proto_rawDescData = file_commands_upload_proto_rawDesc
)

func file_commands_upload_proto_rawDescGZIP() []byte {
	file_commands_upload_proto_rawDescOnce.Do(func() {
		file_commands_upload_proto_rawDescData = protoimpl.X.CompressGZIP(file_commands_upload_proto_rawDescData)
	})
	return file_commands_upload_proto_rawDescData
}

var file_commands_upload_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_commands_upload_proto_goTypes = []interface{}{
	(*UploadReq)(nil),                             // 0: cc.arduino.cli.commands.UploadReq
	(*UploadResp)(nil),                            // 1: cc.arduino.cli.commands.UploadResp
	(*BurnBootloaderReq)(nil),                     // 2: cc.arduino.cli.commands.BurnBootloaderReq
	(*BurnBootloaderResp)(nil),                    // 3: cc.arduino.cli.commands.BurnBootloaderResp
	(*ListProgrammersAvailableForUploadReq)(nil),  // 4: cc.arduino.cli.commands.ListProgrammersAvailableForUploadReq
	(*ListProgrammersAvailableForUploadResp)(nil), // 5: cc.arduino.cli.commands.ListProgrammersAvailableForUploadResp
	(*Instance)(nil),                              // 6: cc.arduino.cli.commands.Instance
	(*Programmer)(nil),                            // 7: cc.arduino.cli.commands.Programmer
}
var file_commands_upload_proto_depIdxs = []int32{
	6, // 0: cc.arduino.cli.commands.UploadReq.instance:type_name -> cc.arduino.cli.commands.Instance
	6, // 1: cc.arduino.cli.commands.BurnBootloaderReq.instance:type_name -> cc.arduino.cli.commands.Instance
	6, // 2: cc.arduino.cli.commands.ListProgrammersAvailableForUploadReq.instance:type_name -> cc.arduino.cli.commands.Instance
	7, // 3: cc.arduino.cli.commands.ListProgrammersAvailableForUploadResp.programmers:type_name -> cc.arduino.cli.commands.Programmer
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_commands_upload_proto_init() }
func file_commands_upload_proto_init() {
	if File_commands_upload_proto != nil {
		return
	}
	file_commands_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_commands_upload_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UploadReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_upload_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UploadResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_upload_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BurnBootloaderReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_upload_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BurnBootloaderResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_upload_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProgrammersAvailableForUploadReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_upload_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProgrammersAvailableForUploadResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_commands_upload_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_commands_upload_proto_goTypes,
		DependencyIndexes: file_commands_upload_proto_depIdxs,
		MessageInfos:      file_commands_upload_proto_msgTypes,
	}.Build()
	File_commands_upload_proto = out.File
	file_commands_upload_proto_rawDesc = nil
	file_commands_upload_proto_goTypes = nil
	file_commands_upload_proto_depIdxs = nil
}
