// This file is part of arduino-cli.
//
// Copyright 2020 ARDUINO SA (http://www.arduino.cc/)
//
// This software is released under the GNU General Public License version 3,
// which covers the main part of arduino-cli.
// The terms of this license can be found at:
// https://www.gnu.org/licenses/gpl-3.0.en.html
//
// You can be released from the requirements of the above licenses by purchasing
// a commercial license. Buying such a license is mandatory if you want to
// modify or otherwise use the software for commercial activities involving the
// Arduino software without disclosing the source code of your own applications.
// To purchase a commercial license, send an email to license@arduino.cc.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.11.3
// source: commands/commands.proto

package commands

import (
	context "context"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

type InitReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start a Arduino Core Service instance that will provide only Library
	// Manager functionality.
	LibraryManagerOnly bool `protobuf:"varint,2,opt,name=library_manager_only,json=libraryManagerOnly,proto3" json:"library_manager_only,omitempty"`
}

func (x *InitReq) Reset() {
	*x = InitReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_commands_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InitReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitReq) ProtoMessage() {}

func (x *InitReq) ProtoReflect() protoreflect.Message {
	mi := &file_commands_commands_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitReq.ProtoReflect.Descriptor instead.
func (*InitReq) Descriptor() ([]byte, []int) {
	return file_commands_commands_proto_rawDescGZIP(), []int{0}
}

func (x *InitReq) GetLibraryManagerOnly() bool {
	if x != nil {
		return x.LibraryManagerOnly
	}
	return false
}

type InitResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An Arduino Core Service instance.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Error messages related to any problems encountered while parsing the
	// platforms index files.
	PlatformsIndexErrors []string `protobuf:"bytes,2,rep,name=platforms_index_errors,json=platformsIndexErrors,proto3" json:"platforms_index_errors,omitempty"`
	// Error message if a problem was encountered while parsing the libraries
	// index file.
	LibrariesIndexError string `protobuf:"bytes,3,opt,name=libraries_index_error,json=librariesIndexError,proto3" json:"libraries_index_error,omitempty"`
	// Progress of the downloads of platforms and libraries index files.
	DownloadProgress *DownloadProgress `protobuf:"bytes,4,opt,name=download_progress,json=downloadProgress,proto3" json:"download_progress,omitempty"`
	// Describes the current stage of the initialization.
	TaskProgress *TaskProgress `protobuf:"bytes,5,opt,name=task_progress,json=taskProgress,proto3" json:"task_progress,omitempty"`
}

func (x *InitResp) Reset() {
	*x = InitResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_commands_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InitResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitResp) ProtoMessage() {}

func (x *InitResp) ProtoReflect() protoreflect.Message {
	mi := &file_commands_commands_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitResp.ProtoReflect.Descriptor instead.
func (*InitResp) Descriptor() ([]byte, []int) {
	return file_commands_commands_proto_rawDescGZIP(), []int{1}
}

func (x *InitResp) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *InitResp) GetPlatformsIndexErrors() []string {
	if x != nil {
		return x.PlatformsIndexErrors
	}
	return nil
}

func (x *InitResp) GetLibrariesIndexError() string {
	if x != nil {
		return x.LibrariesIndexError
	}
	return ""
}

func (x *InitResp) GetDownloadProgress() *DownloadProgress {
	if x != nil {
		return x.DownloadProgress
	}
	return nil
}

func (x *InitResp) GetTaskProgress() *TaskProgress {
	if x != nil {
		return x.TaskProgress
	}
	return nil
}

type DestroyReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Arduino Core Service instance to destroy.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *DestroyReq) Reset() {
	*x = DestroyReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_commands_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DestroyReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DestroyReq) ProtoMessage() {}

func (x *DestroyReq) ProtoReflect() protoreflect.Message {
	mi := &file_commands_commands_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DestroyReq.ProtoReflect.Descriptor instead.
func (*DestroyReq) Descriptor() ([]byte, []int) {
	return file_commands_commands_proto_rawDescGZIP(), []int{2}
}

func (x *DestroyReq) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

type DestroyResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DestroyResp) Reset() {
	*x = DestroyResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_commands_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DestroyResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DestroyResp) ProtoMessage() {}

func (x *DestroyResp) ProtoReflect() protoreflect.Message {
	mi := &file_commands_commands_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DestroyResp.ProtoReflect.Descriptor instead.
func (*DestroyResp) Descriptor() ([]byte, []int) {
	return file_commands_commands_proto_rawDescGZIP(), []int{3}
}

type RescanReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the Init response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *RescanReq) Reset() {
	*x = RescanReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_commands_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RescanReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RescanReq) ProtoMessage() {}

func (x *RescanReq) ProtoReflect() protoreflect.Message {
	mi := &file_commands_commands_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RescanReq.ProtoReflect.Descriptor instead.
func (*RescanReq) Descriptor() ([]byte, []int) {
	return file_commands_commands_proto_rawDescGZIP(), []int{4}
}

func (x *RescanReq) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

type RescanResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Error messages related to any problems encountered while parsing the
	// platforms index file.
	PlatformsIndexErrors []string `protobuf:"bytes,1,rep,name=platforms_index_errors,json=platformsIndexErrors,proto3" json:"platforms_index_errors,omitempty"`
	// Error message if a problem was encountered while parsing the libraries
	// index file.
	LibrariesIndexError string `protobuf:"bytes,2,opt,name=libraries_index_error,json=librariesIndexError,proto3" json:"libraries_index_error,omitempty"`
}

func (x *RescanResp) Reset() {
	*x = RescanResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_commands_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RescanResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RescanResp) ProtoMessage() {}

func (x *RescanResp) ProtoReflect() protoreflect.Message {
	mi := &file_commands_commands_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RescanResp.ProtoReflect.Descriptor instead.
func (*RescanResp) Descriptor() ([]byte, []int) {
	return file_commands_commands_proto_rawDescGZIP(), []int{5}
}

func (x *RescanResp) GetPlatformsIndexErrors() []string {
	if x != nil {
		return x.PlatformsIndexErrors
	}
	return nil
}

func (x *RescanResp) GetLibrariesIndexError() string {
	if x != nil {
		return x.LibrariesIndexError
	}
	return ""
}

type UpdateIndexReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the Init response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *UpdateIndexReq) Reset() {
	*x = UpdateIndexReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_commands_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateIndexReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateIndexReq) ProtoMessage() {}

func (x *UpdateIndexReq) ProtoReflect() protoreflect.Message {
	mi := &file_commands_commands_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateIndexReq.ProtoReflect.Descriptor instead.
func (*UpdateIndexReq) Descriptor() ([]byte, []int) {
	return file_commands_commands_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateIndexReq) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

type UpdateIndexResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Progress of the platforms index download.
	DownloadProgress *DownloadProgress `protobuf:"bytes,1,opt,name=download_progress,json=downloadProgress,proto3" json:"download_progress,omitempty"`
}

func (x *UpdateIndexResp) Reset() {
	*x = UpdateIndexResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_commands_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateIndexResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateIndexResp) ProtoMessage() {}

func (x *UpdateIndexResp) ProtoReflect() protoreflect.Message {
	mi := &file_commands_commands_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateIndexResp.ProtoReflect.Descriptor instead.
func (*UpdateIndexResp) Descriptor() ([]byte, []int) {
	return file_commands_commands_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateIndexResp) GetDownloadProgress() *DownloadProgress {
	if x != nil {
		return x.DownloadProgress
	}
	return nil
}

type UpdateLibrariesIndexReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the Init response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *UpdateLibrariesIndexReq) Reset() {
	*x = UpdateLibrariesIndexReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_commands_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateLibrariesIndexReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateLibrariesIndexReq) ProtoMessage() {}

func (x *UpdateLibrariesIndexReq) ProtoReflect() protoreflect.Message {
	mi := &file_commands_commands_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateLibrariesIndexReq.ProtoReflect.Descriptor instead.
func (*UpdateLibrariesIndexReq) Descriptor() ([]byte, []int) {
	return file_commands_commands_proto_rawDescGZIP(), []int{8}
}

func (x *UpdateLibrariesIndexReq) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

type UpdateLibrariesIndexResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Progress of the libraries index download.
	DownloadProgress *DownloadProgress `protobuf:"bytes,1,opt,name=download_progress,json=downloadProgress,proto3" json:"download_progress,omitempty"`
}

func (x *UpdateLibrariesIndexResp) Reset() {
	*x = UpdateLibrariesIndexResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_commands_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateLibrariesIndexResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateLibrariesIndexResp) ProtoMessage() {}

func (x *UpdateLibrariesIndexResp) ProtoReflect() protoreflect.Message {
	mi := &file_commands_commands_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateLibrariesIndexResp.ProtoReflect.Descriptor instead.
func (*UpdateLibrariesIndexResp) Descriptor() ([]byte, []int) {
	return file_commands_commands_proto_rawDescGZIP(), []int{9}
}

func (x *UpdateLibrariesIndexResp) GetDownloadProgress() *DownloadProgress {
	if x != nil {
		return x.DownloadProgress
	}
	return nil
}

type UpdateCoreLibrariesIndexReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the Init response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *UpdateCoreLibrariesIndexReq) Reset() {
	*x = UpdateCoreLibrariesIndexReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_commands_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCoreLibrariesIndexReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCoreLibrariesIndexReq) ProtoMessage() {}

func (x *UpdateCoreLibrariesIndexReq) ProtoReflect() protoreflect.Message {
	mi := &file_commands_commands_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCoreLibrariesIndexReq.ProtoReflect.Descriptor instead.
func (*UpdateCoreLibrariesIndexReq) Descriptor() ([]byte, []int) {
	return file_commands_commands_proto_rawDescGZIP(), []int{10}
}

func (x *UpdateCoreLibrariesIndexReq) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

type UpdateCoreLibrariesIndexResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Progress of the index download.
	DownloadProgress *DownloadProgress `protobuf:"bytes,1,opt,name=download_progress,json=downloadProgress,proto3" json:"download_progress,omitempty"`
}

func (x *UpdateCoreLibrariesIndexResp) Reset() {
	*x = UpdateCoreLibrariesIndexResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_commands_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCoreLibrariesIndexResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCoreLibrariesIndexResp) ProtoMessage() {}

func (x *UpdateCoreLibrariesIndexResp) ProtoReflect() protoreflect.Message {
	mi := &file_commands_commands_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCoreLibrariesIndexResp.ProtoReflect.Descriptor instead.
func (*UpdateCoreLibrariesIndexResp) Descriptor() ([]byte, []int) {
	return file_commands_commands_proto_rawDescGZIP(), []int{11}
}

func (x *UpdateCoreLibrariesIndexResp) GetDownloadProgress() *DownloadProgress {
	if x != nil {
		return x.DownloadProgress
	}
	return nil
}

type OutdatedReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the Init response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *OutdatedReq) Reset() {
	*x = OutdatedReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_commands_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutdatedReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutdatedReq) ProtoMessage() {}

func (x *OutdatedReq) ProtoReflect() protoreflect.Message {
	mi := &file_commands_commands_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutdatedReq.ProtoReflect.Descriptor instead.
func (*OutdatedReq) Descriptor() ([]byte, []int) {
	return file_commands_commands_proto_rawDescGZIP(), []int{12}
}

func (x *OutdatedReq) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

type OutdatedResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of installed libraries that can be updated.
	OutdatedLibrary []*InstalledLibrary `protobuf:"bytes,1,rep,name=outdated_library,json=outdatedLibrary,proto3" json:"outdated_library,omitempty"`
	// List of installed cores that can be updated.
	OutdatedPlatform []*Platform `protobuf:"bytes,2,rep,name=outdated_platform,json=outdatedPlatform,proto3" json:"outdated_platform,omitempty"`
}

func (x *OutdatedResp) Reset() {
	*x = OutdatedResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_commands_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutdatedResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutdatedResp) ProtoMessage() {}

func (x *OutdatedResp) ProtoReflect() protoreflect.Message {
	mi := &file_commands_commands_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutdatedResp.ProtoReflect.Descriptor instead.
func (*OutdatedResp) Descriptor() ([]byte, []int) {
	return file_commands_commands_proto_rawDescGZIP(), []int{13}
}

func (x *OutdatedResp) GetOutdatedLibrary() []*InstalledLibrary {
	if x != nil {
		return x.OutdatedLibrary
	}
	return nil
}

func (x *OutdatedResp) GetOutdatedPlatform() []*Platform {
	if x != nil {
		return x.OutdatedPlatform
	}
	return nil
}

type UpgradeReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the Init response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *UpgradeReq) Reset() {
	*x = UpgradeReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_commands_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpgradeReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeReq) ProtoMessage() {}

func (x *UpgradeReq) ProtoReflect() protoreflect.Message {
	mi := &file_commands_commands_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeReq.ProtoReflect.Descriptor instead.
func (*UpgradeReq) Descriptor() ([]byte, []int) {
	return file_commands_commands_proto_rawDescGZIP(), []int{14}
}

func (x *UpgradeReq) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

type UpgradeResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Progress of the downloads of the platforms and libraries files.
	Progress *DownloadProgress `protobuf:"bytes,1,opt,name=progress,proto3" json:"progress,omitempty"`
	// Description of the current stage of the upgrade.
	TaskProgress *TaskProgress `protobuf:"bytes,2,opt,name=task_progress,json=taskProgress,proto3" json:"task_progress,omitempty"`
}

func (x *UpgradeResp) Reset() {
	*x = UpgradeResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_commands_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpgradeResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeResp) ProtoMessage() {}

func (x *UpgradeResp) ProtoReflect() protoreflect.Message {
	mi := &file_commands_commands_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeResp.ProtoReflect.Descriptor instead.
func (*UpgradeResp) Descriptor() ([]byte, []int) {
	return file_commands_commands_proto_rawDescGZIP(), []int{15}
}

func (x *UpgradeResp) GetProgress() *DownloadProgress {
	if x != nil {
		return x.Progress
	}
	return nil
}

func (x *UpgradeResp) GetTaskProgress() *TaskProgress {
	if x != nil {
		return x.TaskProgress
	}
	return nil
}

type VersionReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *VersionReq) Reset() {
	*x = VersionReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_commands_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VersionReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VersionReq) ProtoMessage() {}

func (x *VersionReq) ProtoReflect() protoreflect.Message {
	mi := &file_commands_commands_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VersionReq.ProtoReflect.Descriptor instead.
func (*VersionReq) Descriptor() ([]byte, []int) {
	return file_commands_commands_proto_rawDescGZIP(), []int{16}
}

type VersionResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The version of Arduino CLI in use.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *VersionResp) Reset() {
	*x = VersionResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_commands_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VersionResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VersionResp) ProtoMessage() {}

func (x *VersionResp) ProtoReflect() protoreflect.Message {
	mi := &file_commands_commands_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VersionResp.ProtoReflect.Descriptor instead.
func (*VersionResp) Descriptor() ([]byte, []int) {
	return file_commands_commands_proto_rawDescGZIP(), []int{17}
}

func (x *VersionResp) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type LoadSketchReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the Init response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Absolute path to single sketch file or a sketch folder
	SketchPath string `protobuf:"bytes,2,opt,name=sketch_path,json=sketchPath,proto3" json:"sketch_path,omitempty"`
}

func (x *LoadSketchReq) Reset() {
	*x = LoadSketchReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_commands_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoadSketchReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadSketchReq) ProtoMessage() {}

func (x *LoadSketchReq) ProtoReflect() protoreflect.Message {
	mi := &file_commands_commands_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadSketchReq.ProtoReflect.Descriptor instead.
func (*LoadSketchReq) Descriptor() ([]byte, []int) {
	return file_commands_commands_proto_rawDescGZIP(), []int{18}
}

func (x *LoadSketchReq) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *LoadSketchReq) GetSketchPath() string {
	if x != nil {
		return x.SketchPath
	}
	return ""
}

type LoadSketchResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Absolute path to a main sketch files
	MainFile string `protobuf:"bytes,1,opt,name=main_file,json=mainFile,proto3" json:"main_file,omitempty"`
	// Absolute path to folder that contains main_file
	LocationPath string `protobuf:"bytes,2,opt,name=location_path,json=locationPath,proto3" json:"location_path,omitempty"`
	// List of absolute paths to other sketch files
	OtherSketchFiles []string `protobuf:"bytes,3,rep,name=other_sketch_files,json=otherSketchFiles,proto3" json:"other_sketch_files,omitempty"`
	// List of absolute paths to additional sketch files
	AdditionalFiles []string `protobuf:"bytes,4,rep,name=additional_files,json=additionalFiles,proto3" json:"additional_files,omitempty"`
}

func (x *LoadSketchResp) Reset() {
	*x = LoadSketchResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_commands_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoadSketchResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadSketchResp) ProtoMessage() {}

func (x *LoadSketchResp) ProtoReflect() protoreflect.Message {
	mi := &file_commands_commands_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadSketchResp.ProtoReflect.Descriptor instead.
func (*LoadSketchResp) Descriptor() ([]byte, []int) {
	return file_commands_commands_proto_rawDescGZIP(), []int{19}
}

func (x *LoadSketchResp) GetMainFile() string {
	if x != nil {
		return x.MainFile
	}
	return ""
}

func (x *LoadSketchResp) GetLocationPath() string {
	if x != nil {
		return x.LocationPath
	}
	return ""
}

func (x *LoadSketchResp) GetOtherSketchFiles() []string {
	if x != nil {
		return x.OtherSketchFiles
	}
	return nil
}

func (x *LoadSketchResp) GetAdditionalFiles() []string {
	if x != nil {
		return x.AdditionalFiles
	}
	return nil
}

type ArchiveSketchReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Absolute path to Sketch file or folder containing Sketch file
	SketchPath string `protobuf:"bytes,1,opt,name=sketch_path,json=sketchPath,proto3" json:"sketch_path,omitempty"`
	// Absolute path to archive that will be created or folder that will contain it
	ArchivePath string `protobuf:"bytes,2,opt,name=archive_path,json=archivePath,proto3" json:"archive_path,omitempty"`
	// Specifies if build directory should be included in the archive
	IncludeBuildDir bool `protobuf:"varint,3,opt,name=include_build_dir,json=includeBuildDir,proto3" json:"include_build_dir,omitempty"`
}

func (x *ArchiveSketchReq) Reset() {
	*x = ArchiveSketchReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_commands_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArchiveSketchReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArchiveSketchReq) ProtoMessage() {}

func (x *ArchiveSketchReq) ProtoReflect() protoreflect.Message {
	mi := &file_commands_commands_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArchiveSketchReq.ProtoReflect.Descriptor instead.
func (*ArchiveSketchReq) Descriptor() ([]byte, []int) {
	return file_commands_commands_proto_rawDescGZIP(), []int{20}
}

func (x *ArchiveSketchReq) GetSketchPath() string {
	if x != nil {
		return x.SketchPath
	}
	return ""
}

func (x *ArchiveSketchReq) GetArchivePath() string {
	if x != nil {
		return x.ArchivePath
	}
	return ""
}

func (x *ArchiveSketchReq) GetIncludeBuildDir() bool {
	if x != nil {
		return x.IncludeBuildDir
	}
	return false
}

type ArchiveSketchResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ArchiveSketchResp) Reset() {
	*x = ArchiveSketchResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_commands_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArchiveSketchResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArchiveSketchResp) ProtoMessage() {}

func (x *ArchiveSketchResp) ProtoReflect() protoreflect.Message {
	mi := &file_commands_commands_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArchiveSketchResp.ProtoReflect.Descriptor instead.
func (*ArchiveSketchResp) Descriptor() ([]byte, []int) {
	return file_commands_commands_proto_rawDescGZIP(), []int{21}
}

var File_commands_commands_proto protoreflect.FileDescriptor

var file_commands_commands_proto_rawDesc = []byte{
	0x0a, 0x17, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x63, 0x63, 0x2e, 0x61, 0x72,
	0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x73, 0x1a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x14, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2f, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x16, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x15, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x12, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x6c, 0x69,
	0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x3b, 0x0a, 0x07, 0x49, 0x6e, 0x69, 0x74, 0x52,
	0x65, 0x71, 0x12, 0x30, 0x0a, 0x14, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x5f, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x12, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xd7, 0x02, 0x0a, 0x08, 0x49, 0x6e, 0x69, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x12, 0x3d, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x34, 0x0a, 0x16, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x5f, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x14, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72,
	0x69, 0x65, 0x73, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x56, 0x0a, 0x11, 0x64, 0x6f,
	0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69,
	0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e,
	0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x52, 0x10, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x12, 0x4a, 0x0a, 0x0d, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x52, 0x0c, 0x74, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x22, 0x4b,
	0x0a, 0x0a, 0x44, 0x65, 0x73, 0x74, 0x72, 0x6f, 0x79, 0x52, 0x65, 0x71, 0x12, 0x3d, 0x0a, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x0d, 0x0a, 0x0b, 0x44,
	0x65, 0x73, 0x74, 0x72, 0x6f, 0x79, 0x52, 0x65, 0x73, 0x70, 0x22, 0x4a, 0x0a, 0x09, 0x52, 0x65,
	0x73, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x12, 0x3d, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x76, 0x0a, 0x0a, 0x52, 0x65, 0x73, 0x63, 0x61, 0x6e,
	0x52, 0x65, 0x73, 0x70, 0x12, 0x34, 0x0a, 0x16, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x73, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x6c, 0x69,
	0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x6c, 0x69, 0x62, 0x72, 0x61,
	0x72, 0x69, 0x65, 0x73, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x4f,
	0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x71,
	0x12, 0x3d, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x21, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e,
	0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22,
	0x69, 0x0a, 0x0f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65,
	0x73, 0x70, 0x12, 0x56, 0x0a, 0x11, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x70,
	0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64,
	0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x10, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f,
	0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x22, 0x58, 0x0a, 0x17, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x52, 0x65, 0x71, 0x12, 0x3d, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64,
	0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x22, 0x72, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x69,
	0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x73, 0x70,
	0x12, 0x56, 0x0a, 0x11, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x70, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x63, 0x63,
	0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72,
	0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x10, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64,
	0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x22, 0x5c, 0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x72, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x71, 0x12, 0x3d, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x76, 0x0a, 0x1c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x43, 0x6f, 0x72, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x52, 0x65, 0x73, 0x70, 0x12, 0x56, 0x0a, 0x11, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f,
	0x61, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63,
	0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x44, 0x6f, 0x77, 0x6e,
	0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x10, 0x64, 0x6f,
	0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x22, 0x4c,
	0x0a, 0x0b, 0x4f, 0x75, 0x74, 0x64, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x71, 0x12, 0x3d, 0x0a,
	0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0xb4, 0x01, 0x0a,
	0x0c, 0x4f, 0x75, 0x74, 0x64, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x70, 0x12, 0x54, 0x0a,
	0x10, 0x6f, 0x75, 0x74, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72,
	0x79, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64,
	0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x4c, 0x69, 0x62, 0x72, 0x61,
	0x72, 0x79, 0x52, 0x0f, 0x6f, 0x75, 0x74, 0x64, 0x61, 0x74, 0x65, 0x64, 0x4c, 0x69, 0x62, 0x72,
	0x61, 0x72, 0x79, 0x12, 0x4e, 0x0a, 0x11, 0x6f, 0x75, 0x74, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x52, 0x10, 0x6f, 0x75, 0x74, 0x64, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x22, 0x4b, 0x0a, 0x0a, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52, 0x65,
	0x71, 0x12, 0x3d, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x22, 0xa0, 0x01, 0x0a, 0x0b, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x12, 0x45, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e,
	0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x44, 0x6f, 0x77,
	0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x08, 0x70,
	0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x4a, 0x0a, 0x0d, 0x74, 0x61, 0x73, 0x6b, 0x5f,
	0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x0c, 0x74, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x22, 0x0c, 0x0a, 0x0a, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x22, 0x27, 0x0a, 0x0b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70,
	0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x6f, 0x0a, 0x0d, 0x4c, 0x6f,
	0x61, 0x64, 0x53, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x71, 0x12, 0x3d, 0x0a, 0x08, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x6b,
	0x65, 0x74, 0x63, 0x68, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x73, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x50, 0x61, 0x74, 0x68, 0x22, 0xab, 0x01, 0x0a, 0x0e,
	0x4c, 0x6f, 0x61, 0x64, 0x53, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x12, 0x1b,
	0x0a, 0x09, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x6d, 0x61, 0x69, 0x6e, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x74, 0x68,
	0x12, 0x2c, 0x0a, 0x12, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x5f, 0x73, 0x6b, 0x65, 0x74, 0x63, 0x68,
	0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x6f, 0x74,
	0x68, 0x65, 0x72, 0x53, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x29,
	0x0a, 0x10, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x66, 0x69, 0x6c,
	0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x61, 0x6c, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x22, 0x82, 0x01, 0x0a, 0x10, 0x41, 0x72,
	0x63, 0x68, 0x69, 0x76, 0x65, 0x53, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x71, 0x12, 0x1f,
	0x0a, 0x0b, 0x73, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x50, 0x61, 0x74, 0x68, 0x12,
	0x21, 0x0a, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x50, 0x61,
	0x74, 0x68, 0x12, 0x2a, 0x0a, 0x11, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x5f, 0x64, 0x69, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x69,
	0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x44, 0x69, 0x72, 0x22, 0x13,
	0x0a, 0x11, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x53, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x52,
	0x65, 0x73, 0x70, 0x32, 0xda, 0x1a, 0x0a, 0x0b, 0x41, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x43,
	0x6f, 0x72, 0x65, 0x12, 0x4f, 0x0a, 0x04, 0x49, 0x6e, 0x69, 0x74, 0x12, 0x20, 0x2e, 0x63, 0x63,
	0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x49, 0x6e, 0x69, 0x74, 0x52, 0x65, 0x71, 0x1a, 0x21, 0x2e,
	0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x49, 0x6e, 0x69, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x22, 0x00, 0x30, 0x01, 0x12, 0x56, 0x0a, 0x07, 0x44, 0x65, 0x73, 0x74, 0x72, 0x6f, 0x79, 0x12,
	0x23, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x72, 0x6f,
	0x79, 0x52, 0x65, 0x71, 0x1a, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x44,
	0x65, 0x73, 0x74, 0x72, 0x6f, 0x79, 0x52, 0x65, 0x73, 0x70, 0x22, 0x00, 0x12, 0x53, 0x0a, 0x06,
	0x52, 0x65, 0x73, 0x63, 0x61, 0x6e, 0x12, 0x22, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75,
	0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73,
	0x2e, 0x52, 0x65, 0x73, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x1a, 0x23, 0x2e, 0x63, 0x63, 0x2e,
	0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x73, 0x2e, 0x52, 0x65, 0x73, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x22,
	0x00, 0x12, 0x64, 0x0a, 0x0b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x12, 0x27, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c,
	0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x71, 0x1a, 0x28, 0x2e, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52,
	0x65, 0x73, 0x70, 0x22, 0x00, 0x30, 0x01, 0x12, 0x7f, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12,
	0x30, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65,
	0x71, 0x1a, 0x31, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63,
	0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x52, 0x65, 0x73, 0x70, 0x22, 0x00, 0x30, 0x01, 0x12, 0x8b, 0x01, 0x0a, 0x18, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x72, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x34, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69,
	0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x72, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72,
	0x69, 0x65, 0x73, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x71, 0x1a, 0x35, 0x2e, 0x63, 0x63,
	0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x72, 0x65,
	0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65,
	0x73, 0x70, 0x22, 0x00, 0x30, 0x01, 0x12, 0x59, 0x0a, 0x08, 0x4f, 0x75, 0x74, 0x64, 0x61, 0x74,
	0x65, 0x64, 0x12, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e,
	0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x4f, 0x75, 0x74,
	0x64, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x71, 0x1a, 0x25, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72,
	0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x73, 0x2e, 0x4f, 0x75, 0x74, 0x64, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x70, 0x22,
	0x00, 0x12, 0x58, 0x0a, 0x07, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x12, 0x23, 0x2e, 0x63,
	0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52, 0x65,
	0x71, 0x1a, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63,
	0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x55, 0x70, 0x67, 0x72,
	0x61, 0x64, 0x65, 0x52, 0x65, 0x73, 0x70, 0x22, 0x00, 0x30, 0x01, 0x12, 0x56, 0x0a, 0x07, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75,
	0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73,
	0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x1a, 0x24, 0x2e, 0x63, 0x63,
	0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x22, 0x00, 0x12, 0x5f, 0x0a, 0x0a, 0x4c, 0x6f, 0x61, 0x64, 0x53, 0x6b, 0x65, 0x74, 0x63,
	0x68, 0x12, 0x26, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63,
	0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x4c, 0x6f, 0x61, 0x64,
	0x53, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x71, 0x1a, 0x27, 0x2e, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x53, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65,
	0x73, 0x70, 0x22, 0x00, 0x12, 0x68, 0x0a, 0x0d, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x53,
	0x6b, 0x65, 0x74, 0x63, 0x68, 0x12, 0x29, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69,
	0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e,
	0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x53, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x71,
	0x1a, 0x2a, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c,
	0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x41, 0x72, 0x63, 0x68, 0x69,
	0x76, 0x65, 0x53, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x22, 0x00, 0x12, 0x63,
	0x0a, 0x0c, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x28,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x1a, 0x29, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72,
	0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x73, 0x2e, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x12, 0x62, 0x0a, 0x0b, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x41, 0x74, 0x74, 0x61,
	0x63, 0x68, 0x12, 0x27, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e,
	0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x42, 0x6f, 0x61,
	0x72, 0x64, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x52, 0x65, 0x71, 0x1a, 0x28, 0x2e, 0x63, 0x63,
	0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x41, 0x74, 0x74, 0x61, 0x63,
	0x68, 0x52, 0x65, 0x73, 0x70, 0x30, 0x01, 0x12, 0x5a, 0x0a, 0x09, 0x42, 0x6f, 0x61, 0x72, 0x64,
	0x4c, 0x69, 0x73, 0x74, 0x12, 0x25, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x42,
	0x6f, 0x61, 0x72, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x1a, 0x26, 0x2e, 0x63, 0x63,
	0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x12, 0x63, 0x0a, 0x0c, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x6c, 0x6c, 0x12, 0x28, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x42, 0x6f,
	0x61, 0x72, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x1a, 0x29, 0x2e,
	0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x12, 0x56, 0x0a, 0x07, 0x43, 0x6f, 0x6d, 0x70,
	0x69, 0x6c, 0x65, 0x12, 0x23, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x43, 0x6f,
	0x6d, 0x70, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x1a, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72,
	0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x73, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x30, 0x01,
	0x12, 0x6e, 0x0a, 0x0f, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6c, 0x6c, 0x12, 0x2b, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x71,
	0x1a, 0x2c, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c,
	0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x30, 0x01,
	0x12, 0x71, 0x0a, 0x10, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x44, 0x6f, 0x77, 0x6e,
	0x6c, 0x6f, 0x61, 0x64, 0x12, 0x2c, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x50,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x52,
	0x65, 0x71, 0x1a, 0x2d, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e,
	0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x50, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x73,
	0x70, 0x30, 0x01, 0x12, 0x74, 0x0a, 0x11, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x55,
	0x6e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x12, 0x2d, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72,
	0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x73, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x55, 0x6e, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x1a, 0x2e, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64,
	0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x55, 0x6e, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x30, 0x01, 0x12, 0x6e, 0x0a, 0x0f, 0x50, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x12, 0x2b, 0x2e, 0x63,
	0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x55,
	0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52, 0x65, 0x71, 0x1a, 0x2c, 0x2e, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x55, 0x70, 0x67, 0x72,
	0x61, 0x64, 0x65, 0x52, 0x65, 0x73, 0x70, 0x30, 0x01, 0x12, 0x53, 0x0a, 0x06, 0x55, 0x70, 0x6c,
	0x6f, 0x61, 0x64, 0x12, 0x22, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x55, 0x70,
	0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x71, 0x1a, 0x23, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64,
	0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x2e, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x73, 0x70, 0x30, 0x01, 0x12, 0xa2,
	0x01, 0x0a, 0x21, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65,
	0x72, 0x73, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x55, 0x70,
	0x6c, 0x6f, 0x61, 0x64, 0x12, 0x3d, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x73, 0x41, 0x76,
	0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64,
	0x52, 0x65, 0x71, 0x1a, 0x3e, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x73, 0x41, 0x76, 0x61,
	0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52,
	0x65, 0x73, 0x70, 0x12, 0x6b, 0x0a, 0x0e, 0x42, 0x75, 0x72, 0x6e, 0x42, 0x6f, 0x6f, 0x74, 0x6c,
	0x6f, 0x61, 0x64, 0x65, 0x72, 0x12, 0x2a, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69,
	0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e,
	0x42, 0x75, 0x72, 0x6e, 0x42, 0x6f, 0x6f, 0x74, 0x6c, 0x6f, 0x61, 0x64, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x1a, 0x2b, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63,
	0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x42, 0x75, 0x72, 0x6e,
	0x42, 0x6f, 0x6f, 0x74, 0x6c, 0x6f, 0x61, 0x64, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x30, 0x01,
	0x12, 0x69, 0x0a, 0x0e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x12, 0x2a, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e,
	0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x50, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x71, 0x1a, 0x2b,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x12, 0x63, 0x0a, 0x0c, 0x50,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x28, 0x2e, 0x63, 0x63,
	0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x65, 0x71, 0x1a, 0x29, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69,
	0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e,
	0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x12, 0x6e, 0x0a, 0x0f, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x44, 0x6f, 0x77, 0x6e, 0x6c,
	0x6f, 0x61, 0x64, 0x12, 0x2b, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x4c, 0x69,
	0x62, 0x72, 0x61, 0x72, 0x79, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x71,
	0x1a, 0x2c, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c,
	0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61,
	0x72, 0x79, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x73, 0x70, 0x30, 0x01,
	0x12, 0x6b, 0x0a, 0x0e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6c, 0x6c, 0x12, 0x2a, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e,
	0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x4c, 0x69, 0x62,
	0x72, 0x61, 0x72, 0x79, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x1a, 0x2b,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x30, 0x01, 0x12, 0x71, 0x0a,
	0x10, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x55, 0x6e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c,
	0x6c, 0x12, 0x2c, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63,
	0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x4c, 0x69, 0x62, 0x72,
	0x61, 0x72, 0x79, 0x55, 0x6e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x1a,
	0x2d, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72,
	0x79, 0x55, 0x6e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x30, 0x01,
	0x12, 0x74, 0x0a, 0x11, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x55, 0x70, 0x67, 0x72, 0x61,
	0x64, 0x65, 0x41, 0x6c, 0x6c, 0x12, 0x2d, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69,
	0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e,
	0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x41, 0x6c,
	0x6c, 0x52, 0x65, 0x71, 0x1a, 0x2e, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x4c,
	0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x41, 0x6c, 0x6c,
	0x52, 0x65, 0x73, 0x70, 0x30, 0x01, 0x12, 0x8d, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x62, 0x72, 0x61,
	0x72, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65,
	0x6e, 0x63, 0x69, 0x65, 0x73, 0x12, 0x36, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69,
	0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e,
	0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x44, 0x65,
	0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x1a, 0x37, 0x2e,
	0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x52,
	0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x12, 0x66, 0x0a, 0x0d, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72,
	0x79, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x29, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64,
	0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52,
	0x65, 0x71, 0x1a, 0x2a, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e,
	0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x4c, 0x69, 0x62,
	0x72, 0x61, 0x72, 0x79, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x12, 0x60,
	0x0a, 0x0b, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x27, 0x2e,
	0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x1a, 0x28, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75,
	0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73,
	0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x42, 0x2d, 0x5a, 0x2b, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2d, 0x63,
	0x6c, 0x69, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_commands_commands_proto_rawDescOnce sync.Once
	file_commands_commands_proto_rawDescData = file_commands_commands_proto_rawDesc
)

func file_commands_commands_proto_rawDescGZIP() []byte {
	file_commands_commands_proto_rawDescOnce.Do(func() {
		file_commands_commands_proto_rawDescData = protoimpl.X.CompressGZIP(file_commands_commands_proto_rawDescData)
	})
	return file_commands_commands_proto_rawDescData
}

var file_commands_commands_proto_msgTypes = make([]protoimpl.MessageInfo, 22)
var file_commands_commands_proto_goTypes = []interface{}{
	(*InitReq)(nil),                               // 0: cc.arduino.cli.commands.InitReq
	(*InitResp)(nil),                              // 1: cc.arduino.cli.commands.InitResp
	(*DestroyReq)(nil),                            // 2: cc.arduino.cli.commands.DestroyReq
	(*DestroyResp)(nil),                           // 3: cc.arduino.cli.commands.DestroyResp
	(*RescanReq)(nil),                             // 4: cc.arduino.cli.commands.RescanReq
	(*RescanResp)(nil),                            // 5: cc.arduino.cli.commands.RescanResp
	(*UpdateIndexReq)(nil),                        // 6: cc.arduino.cli.commands.UpdateIndexReq
	(*UpdateIndexResp)(nil),                       // 7: cc.arduino.cli.commands.UpdateIndexResp
	(*UpdateLibrariesIndexReq)(nil),               // 8: cc.arduino.cli.commands.UpdateLibrariesIndexReq
	(*UpdateLibrariesIndexResp)(nil),              // 9: cc.arduino.cli.commands.UpdateLibrariesIndexResp
	(*UpdateCoreLibrariesIndexReq)(nil),           // 10: cc.arduino.cli.commands.UpdateCoreLibrariesIndexReq
	(*UpdateCoreLibrariesIndexResp)(nil),          // 11: cc.arduino.cli.commands.UpdateCoreLibrariesIndexResp
	(*OutdatedReq)(nil),                           // 12: cc.arduino.cli.commands.OutdatedReq
	(*OutdatedResp)(nil),                          // 13: cc.arduino.cli.commands.OutdatedResp
	(*UpgradeReq)(nil),                            // 14: cc.arduino.cli.commands.UpgradeReq
	(*UpgradeResp)(nil),                           // 15: cc.arduino.cli.commands.UpgradeResp
	(*VersionReq)(nil),                            // 16: cc.arduino.cli.commands.VersionReq
	(*VersionResp)(nil),                           // 17: cc.arduino.cli.commands.VersionResp
	(*LoadSketchReq)(nil),                         // 18: cc.arduino.cli.commands.LoadSketchReq
	(*LoadSketchResp)(nil),                        // 19: cc.arduino.cli.commands.LoadSketchResp
	(*ArchiveSketchReq)(nil),                      // 20: cc.arduino.cli.commands.ArchiveSketchReq
	(*ArchiveSketchResp)(nil),                     // 21: cc.arduino.cli.commands.ArchiveSketchResp
	(*Instance)(nil),                              // 22: cc.arduino.cli.commands.Instance
	(*DownloadProgress)(nil),                      // 23: cc.arduino.cli.commands.DownloadProgress
	(*TaskProgress)(nil),                          // 24: cc.arduino.cli.commands.TaskProgress
	(*InstalledLibrary)(nil),                      // 25: cc.arduino.cli.commands.InstalledLibrary
	(*Platform)(nil),                              // 26: cc.arduino.cli.commands.Platform
	(*BoardDetailsReq)(nil),                       // 27: cc.arduino.cli.commands.BoardDetailsReq
	(*BoardAttachReq)(nil),                        // 28: cc.arduino.cli.commands.BoardAttachReq
	(*BoardListReq)(nil),                          // 29: cc.arduino.cli.commands.BoardListReq
	(*BoardListAllReq)(nil),                       // 30: cc.arduino.cli.commands.BoardListAllReq
	(*CompileReq)(nil),                            // 31: cc.arduino.cli.commands.CompileReq
	(*PlatformInstallReq)(nil),                    // 32: cc.arduino.cli.commands.PlatformInstallReq
	(*PlatformDownloadReq)(nil),                   // 33: cc.arduino.cli.commands.PlatformDownloadReq
	(*PlatformUninstallReq)(nil),                  // 34: cc.arduino.cli.commands.PlatformUninstallReq
	(*PlatformUpgradeReq)(nil),                    // 35: cc.arduino.cli.commands.PlatformUpgradeReq
	(*UploadReq)(nil),                             // 36: cc.arduino.cli.commands.UploadReq
	(*ListProgrammersAvailableForUploadReq)(nil),  // 37: cc.arduino.cli.commands.ListProgrammersAvailableForUploadReq
	(*BurnBootloaderReq)(nil),                     // 38: cc.arduino.cli.commands.BurnBootloaderReq
	(*PlatformSearchReq)(nil),                     // 39: cc.arduino.cli.commands.PlatformSearchReq
	(*PlatformListReq)(nil),                       // 40: cc.arduino.cli.commands.PlatformListReq
	(*LibraryDownloadReq)(nil),                    // 41: cc.arduino.cli.commands.LibraryDownloadReq
	(*LibraryInstallReq)(nil),                     // 42: cc.arduino.cli.commands.LibraryInstallReq
	(*LibraryUninstallReq)(nil),                   // 43: cc.arduino.cli.commands.LibraryUninstallReq
	(*LibraryUpgradeAllReq)(nil),                  // 44: cc.arduino.cli.commands.LibraryUpgradeAllReq
	(*LibraryResolveDependenciesReq)(nil),         // 45: cc.arduino.cli.commands.LibraryResolveDependenciesReq
	(*LibrarySearchReq)(nil),                      // 46: cc.arduino.cli.commands.LibrarySearchReq
	(*LibraryListReq)(nil),                        // 47: cc.arduino.cli.commands.LibraryListReq
	(*BoardDetailsResp)(nil),                      // 48: cc.arduino.cli.commands.BoardDetailsResp
	(*BoardAttachResp)(nil),                       // 49: cc.arduino.cli.commands.BoardAttachResp
	(*BoardListResp)(nil),                         // 50: cc.arduino.cli.commands.BoardListResp
	(*BoardListAllResp)(nil),                      // 51: cc.arduino.cli.commands.BoardListAllResp
	(*CompileResp)(nil),                           // 52: cc.arduino.cli.commands.CompileResp
	(*PlatformInstallResp)(nil),                   // 53: cc.arduino.cli.commands.PlatformInstallResp
	(*PlatformDownloadResp)(nil),                  // 54: cc.arduino.cli.commands.PlatformDownloadResp
	(*PlatformUninstallResp)(nil),                 // 55: cc.arduino.cli.commands.PlatformUninstallResp
	(*PlatformUpgradeResp)(nil),                   // 56: cc.arduino.cli.commands.PlatformUpgradeResp
	(*UploadResp)(nil),                            // 57: cc.arduino.cli.commands.UploadResp
	(*ListProgrammersAvailableForUploadResp)(nil), // 58: cc.arduino.cli.commands.ListProgrammersAvailableForUploadResp
	(*BurnBootloaderResp)(nil),                    // 59: cc.arduino.cli.commands.BurnBootloaderResp
	(*PlatformSearchResp)(nil),                    // 60: cc.arduino.cli.commands.PlatformSearchResp
	(*PlatformListResp)(nil),                      // 61: cc.arduino.cli.commands.PlatformListResp
	(*LibraryDownloadResp)(nil),                   // 62: cc.arduino.cli.commands.LibraryDownloadResp
	(*LibraryInstallResp)(nil),                    // 63: cc.arduino.cli.commands.LibraryInstallResp
	(*LibraryUninstallResp)(nil),                  // 64: cc.arduino.cli.commands.LibraryUninstallResp
	(*LibraryUpgradeAllResp)(nil),                 // 65: cc.arduino.cli.commands.LibraryUpgradeAllResp
	(*LibraryResolveDependenciesResp)(nil),        // 66: cc.arduino.cli.commands.LibraryResolveDependenciesResp
	(*LibrarySearchResp)(nil),                     // 67: cc.arduino.cli.commands.LibrarySearchResp
	(*LibraryListResp)(nil),                       // 68: cc.arduino.cli.commands.LibraryListResp
}
var file_commands_commands_proto_depIdxs = []int32{
	22, // 0: cc.arduino.cli.commands.InitResp.instance:type_name -> cc.arduino.cli.commands.Instance
	23, // 1: cc.arduino.cli.commands.InitResp.download_progress:type_name -> cc.arduino.cli.commands.DownloadProgress
	24, // 2: cc.arduino.cli.commands.InitResp.task_progress:type_name -> cc.arduino.cli.commands.TaskProgress
	22, // 3: cc.arduino.cli.commands.DestroyReq.instance:type_name -> cc.arduino.cli.commands.Instance
	22, // 4: cc.arduino.cli.commands.RescanReq.instance:type_name -> cc.arduino.cli.commands.Instance
	22, // 5: cc.arduino.cli.commands.UpdateIndexReq.instance:type_name -> cc.arduino.cli.commands.Instance
	23, // 6: cc.arduino.cli.commands.UpdateIndexResp.download_progress:type_name -> cc.arduino.cli.commands.DownloadProgress
	22, // 7: cc.arduino.cli.commands.UpdateLibrariesIndexReq.instance:type_name -> cc.arduino.cli.commands.Instance
	23, // 8: cc.arduino.cli.commands.UpdateLibrariesIndexResp.download_progress:type_name -> cc.arduino.cli.commands.DownloadProgress
	22, // 9: cc.arduino.cli.commands.UpdateCoreLibrariesIndexReq.instance:type_name -> cc.arduino.cli.commands.Instance
	23, // 10: cc.arduino.cli.commands.UpdateCoreLibrariesIndexResp.download_progress:type_name -> cc.arduino.cli.commands.DownloadProgress
	22, // 11: cc.arduino.cli.commands.OutdatedReq.instance:type_name -> cc.arduino.cli.commands.Instance
	25, // 12: cc.arduino.cli.commands.OutdatedResp.outdated_library:type_name -> cc.arduino.cli.commands.InstalledLibrary
	26, // 13: cc.arduino.cli.commands.OutdatedResp.outdated_platform:type_name -> cc.arduino.cli.commands.Platform
	22, // 14: cc.arduino.cli.commands.UpgradeReq.instance:type_name -> cc.arduino.cli.commands.Instance
	23, // 15: cc.arduino.cli.commands.UpgradeResp.progress:type_name -> cc.arduino.cli.commands.DownloadProgress
	24, // 16: cc.arduino.cli.commands.UpgradeResp.task_progress:type_name -> cc.arduino.cli.commands.TaskProgress
	22, // 17: cc.arduino.cli.commands.LoadSketchReq.instance:type_name -> cc.arduino.cli.commands.Instance
	0,  // 18: cc.arduino.cli.commands.ArduinoCore.Init:input_type -> cc.arduino.cli.commands.InitReq
	2,  // 19: cc.arduino.cli.commands.ArduinoCore.Destroy:input_type -> cc.arduino.cli.commands.DestroyReq
	4,  // 20: cc.arduino.cli.commands.ArduinoCore.Rescan:input_type -> cc.arduino.cli.commands.RescanReq
	6,  // 21: cc.arduino.cli.commands.ArduinoCore.UpdateIndex:input_type -> cc.arduino.cli.commands.UpdateIndexReq
	8,  // 22: cc.arduino.cli.commands.ArduinoCore.UpdateLibrariesIndex:input_type -> cc.arduino.cli.commands.UpdateLibrariesIndexReq
	10, // 23: cc.arduino.cli.commands.ArduinoCore.UpdateCoreLibrariesIndex:input_type -> cc.arduino.cli.commands.UpdateCoreLibrariesIndexReq
	12, // 24: cc.arduino.cli.commands.ArduinoCore.Outdated:input_type -> cc.arduino.cli.commands.OutdatedReq
	14, // 25: cc.arduino.cli.commands.ArduinoCore.Upgrade:input_type -> cc.arduino.cli.commands.UpgradeReq
	16, // 26: cc.arduino.cli.commands.ArduinoCore.Version:input_type -> cc.arduino.cli.commands.VersionReq
	18, // 27: cc.arduino.cli.commands.ArduinoCore.LoadSketch:input_type -> cc.arduino.cli.commands.LoadSketchReq
	20, // 28: cc.arduino.cli.commands.ArduinoCore.ArchiveSketch:input_type -> cc.arduino.cli.commands.ArchiveSketchReq
	27, // 29: cc.arduino.cli.commands.ArduinoCore.BoardDetails:input_type -> cc.arduino.cli.commands.BoardDetailsReq
	28, // 30: cc.arduino.cli.commands.ArduinoCore.BoardAttach:input_type -> cc.arduino.cli.commands.BoardAttachReq
	29, // 31: cc.arduino.cli.commands.ArduinoCore.BoardList:input_type -> cc.arduino.cli.commands.BoardListReq
	30, // 32: cc.arduino.cli.commands.ArduinoCore.BoardListAll:input_type -> cc.arduino.cli.commands.BoardListAllReq
	31, // 33: cc.arduino.cli.commands.ArduinoCore.Compile:input_type -> cc.arduino.cli.commands.CompileReq
	32, // 34: cc.arduino.cli.commands.ArduinoCore.PlatformInstall:input_type -> cc.arduino.cli.commands.PlatformInstallReq
	33, // 35: cc.arduino.cli.commands.ArduinoCore.PlatformDownload:input_type -> cc.arduino.cli.commands.PlatformDownloadReq
	34, // 36: cc.arduino.cli.commands.ArduinoCore.PlatformUninstall:input_type -> cc.arduino.cli.commands.PlatformUninstallReq
	35, // 37: cc.arduino.cli.commands.ArduinoCore.PlatformUpgrade:input_type -> cc.arduino.cli.commands.PlatformUpgradeReq
	36, // 38: cc.arduino.cli.commands.ArduinoCore.Upload:input_type -> cc.arduino.cli.commands.UploadReq
	37, // 39: cc.arduino.cli.commands.ArduinoCore.ListProgrammersAvailableForUpload:input_type -> cc.arduino.cli.commands.ListProgrammersAvailableForUploadReq
	38, // 40: cc.arduino.cli.commands.ArduinoCore.BurnBootloader:input_type -> cc.arduino.cli.commands.BurnBootloaderReq
	39, // 41: cc.arduino.cli.commands.ArduinoCore.PlatformSearch:input_type -> cc.arduino.cli.commands.PlatformSearchReq
	40, // 42: cc.arduino.cli.commands.ArduinoCore.PlatformList:input_type -> cc.arduino.cli.commands.PlatformListReq
	41, // 43: cc.arduino.cli.commands.ArduinoCore.LibraryDownload:input_type -> cc.arduino.cli.commands.LibraryDownloadReq
	42, // 44: cc.arduino.cli.commands.ArduinoCore.LibraryInstall:input_type -> cc.arduino.cli.commands.LibraryInstallReq
	43, // 45: cc.arduino.cli.commands.ArduinoCore.LibraryUninstall:input_type -> cc.arduino.cli.commands.LibraryUninstallReq
	44, // 46: cc.arduino.cli.commands.ArduinoCore.LibraryUpgradeAll:input_type -> cc.arduino.cli.commands.LibraryUpgradeAllReq
	45, // 47: cc.arduino.cli.commands.ArduinoCore.LibraryResolveDependencies:input_type -> cc.arduino.cli.commands.LibraryResolveDependenciesReq
	46, // 48: cc.arduino.cli.commands.ArduinoCore.LibrarySearch:input_type -> cc.arduino.cli.commands.LibrarySearchReq
	47, // 49: cc.arduino.cli.commands.ArduinoCore.LibraryList:input_type -> cc.arduino.cli.commands.LibraryListReq
	1,  // 50: cc.arduino.cli.commands.ArduinoCore.Init:output_type -> cc.arduino.cli.commands.InitResp
	3,  // 51: cc.arduino.cli.commands.ArduinoCore.Destroy:output_type -> cc.arduino.cli.commands.DestroyResp
	5,  // 52: cc.arduino.cli.commands.ArduinoCore.Rescan:output_type -> cc.arduino.cli.commands.RescanResp
	7,  // 53: cc.arduino.cli.commands.ArduinoCore.UpdateIndex:output_type -> cc.arduino.cli.commands.UpdateIndexResp
	9,  // 54: cc.arduino.cli.commands.ArduinoCore.UpdateLibrariesIndex:output_type -> cc.arduino.cli.commands.UpdateLibrariesIndexResp
	11, // 55: cc.arduino.cli.commands.ArduinoCore.UpdateCoreLibrariesIndex:output_type -> cc.arduino.cli.commands.UpdateCoreLibrariesIndexResp
	13, // 56: cc.arduino.cli.commands.ArduinoCore.Outdated:output_type -> cc.arduino.cli.commands.OutdatedResp
	15, // 57: cc.arduino.cli.commands.ArduinoCore.Upgrade:output_type -> cc.arduino.cli.commands.UpgradeResp
	17, // 58: cc.arduino.cli.commands.ArduinoCore.Version:output_type -> cc.arduino.cli.commands.VersionResp
	19, // 59: cc.arduino.cli.commands.ArduinoCore.LoadSketch:output_type -> cc.arduino.cli.commands.LoadSketchResp
	21, // 60: cc.arduino.cli.commands.ArduinoCore.ArchiveSketch:output_type -> cc.arduino.cli.commands.ArchiveSketchResp
	48, // 61: cc.arduino.cli.commands.ArduinoCore.BoardDetails:output_type -> cc.arduino.cli.commands.BoardDetailsResp
	49, // 62: cc.arduino.cli.commands.ArduinoCore.BoardAttach:output_type -> cc.arduino.cli.commands.BoardAttachResp
	50, // 63: cc.arduino.cli.commands.ArduinoCore.BoardList:output_type -> cc.arduino.cli.commands.BoardListResp
	51, // 64: cc.arduino.cli.commands.ArduinoCore.BoardListAll:output_type -> cc.arduino.cli.commands.BoardListAllResp
	52, // 65: cc.arduino.cli.commands.ArduinoCore.Compile:output_type -> cc.arduino.cli.commands.CompileResp
	53, // 66: cc.arduino.cli.commands.ArduinoCore.PlatformInstall:output_type -> cc.arduino.cli.commands.PlatformInstallResp
	54, // 67: cc.arduino.cli.commands.ArduinoCore.PlatformDownload:output_type -> cc.arduino.cli.commands.PlatformDownloadResp
	55, // 68: cc.arduino.cli.commands.ArduinoCore.PlatformUninstall:output_type -> cc.arduino.cli.commands.PlatformUninstallResp
	56, // 69: cc.arduino.cli.commands.ArduinoCore.PlatformUpgrade:output_type -> cc.arduino.cli.commands.PlatformUpgradeResp
	57, // 70: cc.arduino.cli.commands.ArduinoCore.Upload:output_type -> cc.arduino.cli.commands.UploadResp
	58, // 71: cc.arduino.cli.commands.ArduinoCore.ListProgrammersAvailableForUpload:output_type -> cc.arduino.cli.commands.ListProgrammersAvailableForUploadResp
	59, // 72: cc.arduino.cli.commands.ArduinoCore.BurnBootloader:output_type -> cc.arduino.cli.commands.BurnBootloaderResp
	60, // 73: cc.arduino.cli.commands.ArduinoCore.PlatformSearch:output_type -> cc.arduino.cli.commands.PlatformSearchResp
	61, // 74: cc.arduino.cli.commands.ArduinoCore.PlatformList:output_type -> cc.arduino.cli.commands.PlatformListResp
	62, // 75: cc.arduino.cli.commands.ArduinoCore.LibraryDownload:output_type -> cc.arduino.cli.commands.LibraryDownloadResp
	63, // 76: cc.arduino.cli.commands.ArduinoCore.LibraryInstall:output_type -> cc.arduino.cli.commands.LibraryInstallResp
	64, // 77: cc.arduino.cli.commands.ArduinoCore.LibraryUninstall:output_type -> cc.arduino.cli.commands.LibraryUninstallResp
	65, // 78: cc.arduino.cli.commands.ArduinoCore.LibraryUpgradeAll:output_type -> cc.arduino.cli.commands.LibraryUpgradeAllResp
	66, // 79: cc.arduino.cli.commands.ArduinoCore.LibraryResolveDependencies:output_type -> cc.arduino.cli.commands.LibraryResolveDependenciesResp
	67, // 80: cc.arduino.cli.commands.ArduinoCore.LibrarySearch:output_type -> cc.arduino.cli.commands.LibrarySearchResp
	68, // 81: cc.arduino.cli.commands.ArduinoCore.LibraryList:output_type -> cc.arduino.cli.commands.LibraryListResp
	50, // [50:82] is the sub-list for method output_type
	18, // [18:50] is the sub-list for method input_type
	18, // [18:18] is the sub-list for extension type_name
	18, // [18:18] is the sub-list for extension extendee
	0,  // [0:18] is the sub-list for field type_name
}

func init() { file_commands_commands_proto_init() }
func file_commands_commands_proto_init() {
	if File_commands_commands_proto != nil {
		return
	}
	file_commands_common_proto_init()
	file_commands_board_proto_init()
	file_commands_compile_proto_init()
	file_commands_core_proto_init()
	file_commands_upload_proto_init()
	file_commands_lib_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_commands_commands_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InitReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_commands_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InitResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_commands_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DestroyReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_commands_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DestroyResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_commands_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RescanReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_commands_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RescanResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_commands_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateIndexReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_commands_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateIndexResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_commands_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateLibrariesIndexReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_commands_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateLibrariesIndexResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_commands_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCoreLibrariesIndexReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_commands_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCoreLibrariesIndexResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_commands_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutdatedReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_commands_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutdatedResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_commands_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpgradeReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_commands_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpgradeResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_commands_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VersionReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_commands_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VersionResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_commands_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoadSketchReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_commands_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoadSketchResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_commands_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArchiveSketchReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_commands_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArchiveSketchResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_commands_commands_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   22,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_commands_commands_proto_goTypes,
		DependencyIndexes: file_commands_commands_proto_depIdxs,
		MessageInfos:      file_commands_commands_proto_msgTypes,
	}.Build()
	File_commands_commands_proto = out.File
	file_commands_commands_proto_rawDesc = nil
	file_commands_commands_proto_goTypes = nil
	file_commands_commands_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ArduinoCoreClient is the client API for ArduinoCore service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ArduinoCoreClient interface {
	// Start a new instance of the Arduino Core Service
	Init(ctx context.Context, in *InitReq, opts ...grpc.CallOption) (ArduinoCore_InitClient, error)
	// Destroy an instance of the Arduino Core Service
	Destroy(ctx context.Context, in *DestroyReq, opts ...grpc.CallOption) (*DestroyResp, error)
	// Rescan instance of the Arduino Core Service
	Rescan(ctx context.Context, in *RescanReq, opts ...grpc.CallOption) (*RescanResp, error)
	// Update package index of the Arduino Core Service
	UpdateIndex(ctx context.Context, in *UpdateIndexReq, opts ...grpc.CallOption) (ArduinoCore_UpdateIndexClient, error)
	// Update libraries index
	UpdateLibrariesIndex(ctx context.Context, in *UpdateLibrariesIndexReq, opts ...grpc.CallOption) (ArduinoCore_UpdateLibrariesIndexClient, error)
	// Update packages indexes for both Cores and Libraries
	UpdateCoreLibrariesIndex(ctx context.Context, in *UpdateCoreLibrariesIndexReq, opts ...grpc.CallOption) (ArduinoCore_UpdateCoreLibrariesIndexClient, error)
	// Outdated returns a message with a list of outdated Cores and Libraries
	Outdated(ctx context.Context, in *OutdatedReq, opts ...grpc.CallOption) (*OutdatedResp, error)
	// Upgrade both Cores and Libraries
	Upgrade(ctx context.Context, in *UpgradeReq, opts ...grpc.CallOption) (ArduinoCore_UpgradeClient, error)
	// Get the version of Arduino CLI in use.
	Version(ctx context.Context, in *VersionReq, opts ...grpc.CallOption) (*VersionResp, error)
	// Returns all files composing a Sketch
	LoadSketch(ctx context.Context, in *LoadSketchReq, opts ...grpc.CallOption) (*LoadSketchResp, error)
	// Creates a zip file containing all files of specified Sketch
	ArchiveSketch(ctx context.Context, in *ArchiveSketchReq, opts ...grpc.CallOption) (*ArchiveSketchResp, error)
	// Requests details about a board
	BoardDetails(ctx context.Context, in *BoardDetailsReq, opts ...grpc.CallOption) (*BoardDetailsResp, error)
	// Attach a board to a sketch. When the `fqbn` field of a request is not
	// provided, the FQBN of the attached board will be used.
	BoardAttach(ctx context.Context, in *BoardAttachReq, opts ...grpc.CallOption) (ArduinoCore_BoardAttachClient, error)
	// List the boards currently connected to the computer.
	BoardList(ctx context.Context, in *BoardListReq, opts ...grpc.CallOption) (*BoardListResp, error)
	// List all the boards provided by installed platforms.
	BoardListAll(ctx context.Context, in *BoardListAllReq, opts ...grpc.CallOption) (*BoardListAllResp, error)
	// Compile an Arduino sketch.
	Compile(ctx context.Context, in *CompileReq, opts ...grpc.CallOption) (ArduinoCore_CompileClient, error)
	// Download and install a platform and its tool dependencies.
	PlatformInstall(ctx context.Context, in *PlatformInstallReq, opts ...grpc.CallOption) (ArduinoCore_PlatformInstallClient, error)
	// Download a platform and its tool dependencies to the `staging/packages`
	// subdirectory of the data directory.
	PlatformDownload(ctx context.Context, in *PlatformDownloadReq, opts ...grpc.CallOption) (ArduinoCore_PlatformDownloadClient, error)
	// Uninstall a platform as well as its tool dependencies that are not used by
	// other installed platforms.
	PlatformUninstall(ctx context.Context, in *PlatformUninstallReq, opts ...grpc.CallOption) (ArduinoCore_PlatformUninstallClient, error)
	// Upgrade an installed platform to the latest version.
	PlatformUpgrade(ctx context.Context, in *PlatformUpgradeReq, opts ...grpc.CallOption) (ArduinoCore_PlatformUpgradeClient, error)
	// Upload a compiled sketch to an Arduino board.
	Upload(ctx context.Context, in *UploadReq, opts ...grpc.CallOption) (ArduinoCore_UploadClient, error)
	ListProgrammersAvailableForUpload(ctx context.Context, in *ListProgrammersAvailableForUploadReq, opts ...grpc.CallOption) (*ListProgrammersAvailableForUploadResp, error)
	// Burn bootloader to a board.
	BurnBootloader(ctx context.Context, in *BurnBootloaderReq, opts ...grpc.CallOption) (ArduinoCore_BurnBootloaderClient, error)
	// Search for a platform in the platforms indexes.
	PlatformSearch(ctx context.Context, in *PlatformSearchReq, opts ...grpc.CallOption) (*PlatformSearchResp, error)
	// List all installed platforms.
	PlatformList(ctx context.Context, in *PlatformListReq, opts ...grpc.CallOption) (*PlatformListResp, error)
	// Download the archive file of an Arduino library in the libraries index to
	// the staging directory.
	LibraryDownload(ctx context.Context, in *LibraryDownloadReq, opts ...grpc.CallOption) (ArduinoCore_LibraryDownloadClient, error)
	// Download and install an Arduino library from the libraries index.
	LibraryInstall(ctx context.Context, in *LibraryInstallReq, opts ...grpc.CallOption) (ArduinoCore_LibraryInstallClient, error)
	// Uninstall an Arduino library.
	LibraryUninstall(ctx context.Context, in *LibraryUninstallReq, opts ...grpc.CallOption) (ArduinoCore_LibraryUninstallClient, error)
	// Upgrade all installed Arduino libraries to the newest version available.
	LibraryUpgradeAll(ctx context.Context, in *LibraryUpgradeAllReq, opts ...grpc.CallOption) (ArduinoCore_LibraryUpgradeAllClient, error)
	// List the recursive dependencies of a library, as defined by the `depends`
	// field of the library.properties files.
	LibraryResolveDependencies(ctx context.Context, in *LibraryResolveDependenciesReq, opts ...grpc.CallOption) (*LibraryResolveDependenciesResp, error)
	// Search the Arduino libraries index for libraries.
	LibrarySearch(ctx context.Context, in *LibrarySearchReq, opts ...grpc.CallOption) (*LibrarySearchResp, error)
	// List the installed libraries.
	LibraryList(ctx context.Context, in *LibraryListReq, opts ...grpc.CallOption) (*LibraryListResp, error)
}

type arduinoCoreClient struct {
	cc grpc.ClientConnInterface
}

func NewArduinoCoreClient(cc grpc.ClientConnInterface) ArduinoCoreClient {
	return &arduinoCoreClient{cc}
}

func (c *arduinoCoreClient) Init(ctx context.Context, in *InitReq, opts ...grpc.CallOption) (ArduinoCore_InitClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[0], "/cc.arduino.cli.commands.ArduinoCore/Init", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreInitClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_InitClient interface {
	Recv() (*InitResp, error)
	grpc.ClientStream
}

type arduinoCoreInitClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreInitClient) Recv() (*InitResp, error) {
	m := new(InitResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) Destroy(ctx context.Context, in *DestroyReq, opts ...grpc.CallOption) (*DestroyResp, error) {
	out := new(DestroyResp)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.ArduinoCore/Destroy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreClient) Rescan(ctx context.Context, in *RescanReq, opts ...grpc.CallOption) (*RescanResp, error) {
	out := new(RescanResp)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.ArduinoCore/Rescan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreClient) UpdateIndex(ctx context.Context, in *UpdateIndexReq, opts ...grpc.CallOption) (ArduinoCore_UpdateIndexClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[1], "/cc.arduino.cli.commands.ArduinoCore/UpdateIndex", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreUpdateIndexClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_UpdateIndexClient interface {
	Recv() (*UpdateIndexResp, error)
	grpc.ClientStream
}

type arduinoCoreUpdateIndexClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreUpdateIndexClient) Recv() (*UpdateIndexResp, error) {
	m := new(UpdateIndexResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) UpdateLibrariesIndex(ctx context.Context, in *UpdateLibrariesIndexReq, opts ...grpc.CallOption) (ArduinoCore_UpdateLibrariesIndexClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[2], "/cc.arduino.cli.commands.ArduinoCore/UpdateLibrariesIndex", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreUpdateLibrariesIndexClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_UpdateLibrariesIndexClient interface {
	Recv() (*UpdateLibrariesIndexResp, error)
	grpc.ClientStream
}

type arduinoCoreUpdateLibrariesIndexClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreUpdateLibrariesIndexClient) Recv() (*UpdateLibrariesIndexResp, error) {
	m := new(UpdateLibrariesIndexResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) UpdateCoreLibrariesIndex(ctx context.Context, in *UpdateCoreLibrariesIndexReq, opts ...grpc.CallOption) (ArduinoCore_UpdateCoreLibrariesIndexClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[3], "/cc.arduino.cli.commands.ArduinoCore/UpdateCoreLibrariesIndex", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreUpdateCoreLibrariesIndexClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_UpdateCoreLibrariesIndexClient interface {
	Recv() (*UpdateCoreLibrariesIndexResp, error)
	grpc.ClientStream
}

type arduinoCoreUpdateCoreLibrariesIndexClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreUpdateCoreLibrariesIndexClient) Recv() (*UpdateCoreLibrariesIndexResp, error) {
	m := new(UpdateCoreLibrariesIndexResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) Outdated(ctx context.Context, in *OutdatedReq, opts ...grpc.CallOption) (*OutdatedResp, error) {
	out := new(OutdatedResp)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.ArduinoCore/Outdated", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreClient) Upgrade(ctx context.Context, in *UpgradeReq, opts ...grpc.CallOption) (ArduinoCore_UpgradeClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[4], "/cc.arduino.cli.commands.ArduinoCore/Upgrade", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreUpgradeClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_UpgradeClient interface {
	Recv() (*UpgradeResp, error)
	grpc.ClientStream
}

type arduinoCoreUpgradeClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreUpgradeClient) Recv() (*UpgradeResp, error) {
	m := new(UpgradeResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) Version(ctx context.Context, in *VersionReq, opts ...grpc.CallOption) (*VersionResp, error) {
	out := new(VersionResp)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.ArduinoCore/Version", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreClient) LoadSketch(ctx context.Context, in *LoadSketchReq, opts ...grpc.CallOption) (*LoadSketchResp, error) {
	out := new(LoadSketchResp)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.ArduinoCore/LoadSketch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreClient) ArchiveSketch(ctx context.Context, in *ArchiveSketchReq, opts ...grpc.CallOption) (*ArchiveSketchResp, error) {
	out := new(ArchiveSketchResp)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.ArduinoCore/ArchiveSketch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreClient) BoardDetails(ctx context.Context, in *BoardDetailsReq, opts ...grpc.CallOption) (*BoardDetailsResp, error) {
	out := new(BoardDetailsResp)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.ArduinoCore/BoardDetails", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreClient) BoardAttach(ctx context.Context, in *BoardAttachReq, opts ...grpc.CallOption) (ArduinoCore_BoardAttachClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[5], "/cc.arduino.cli.commands.ArduinoCore/BoardAttach", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreBoardAttachClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_BoardAttachClient interface {
	Recv() (*BoardAttachResp, error)
	grpc.ClientStream
}

type arduinoCoreBoardAttachClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreBoardAttachClient) Recv() (*BoardAttachResp, error) {
	m := new(BoardAttachResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) BoardList(ctx context.Context, in *BoardListReq, opts ...grpc.CallOption) (*BoardListResp, error) {
	out := new(BoardListResp)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.ArduinoCore/BoardList", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreClient) BoardListAll(ctx context.Context, in *BoardListAllReq, opts ...grpc.CallOption) (*BoardListAllResp, error) {
	out := new(BoardListAllResp)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.ArduinoCore/BoardListAll", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreClient) Compile(ctx context.Context, in *CompileReq, opts ...grpc.CallOption) (ArduinoCore_CompileClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[6], "/cc.arduino.cli.commands.ArduinoCore/Compile", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreCompileClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_CompileClient interface {
	Recv() (*CompileResp, error)
	grpc.ClientStream
}

type arduinoCoreCompileClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreCompileClient) Recv() (*CompileResp, error) {
	m := new(CompileResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) PlatformInstall(ctx context.Context, in *PlatformInstallReq, opts ...grpc.CallOption) (ArduinoCore_PlatformInstallClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[7], "/cc.arduino.cli.commands.ArduinoCore/PlatformInstall", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCorePlatformInstallClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_PlatformInstallClient interface {
	Recv() (*PlatformInstallResp, error)
	grpc.ClientStream
}

type arduinoCorePlatformInstallClient struct {
	grpc.ClientStream
}

func (x *arduinoCorePlatformInstallClient) Recv() (*PlatformInstallResp, error) {
	m := new(PlatformInstallResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) PlatformDownload(ctx context.Context, in *PlatformDownloadReq, opts ...grpc.CallOption) (ArduinoCore_PlatformDownloadClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[8], "/cc.arduino.cli.commands.ArduinoCore/PlatformDownload", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCorePlatformDownloadClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_PlatformDownloadClient interface {
	Recv() (*PlatformDownloadResp, error)
	grpc.ClientStream
}

type arduinoCorePlatformDownloadClient struct {
	grpc.ClientStream
}

func (x *arduinoCorePlatformDownloadClient) Recv() (*PlatformDownloadResp, error) {
	m := new(PlatformDownloadResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) PlatformUninstall(ctx context.Context, in *PlatformUninstallReq, opts ...grpc.CallOption) (ArduinoCore_PlatformUninstallClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[9], "/cc.arduino.cli.commands.ArduinoCore/PlatformUninstall", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCorePlatformUninstallClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_PlatformUninstallClient interface {
	Recv() (*PlatformUninstallResp, error)
	grpc.ClientStream
}

type arduinoCorePlatformUninstallClient struct {
	grpc.ClientStream
}

func (x *arduinoCorePlatformUninstallClient) Recv() (*PlatformUninstallResp, error) {
	m := new(PlatformUninstallResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) PlatformUpgrade(ctx context.Context, in *PlatformUpgradeReq, opts ...grpc.CallOption) (ArduinoCore_PlatformUpgradeClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[10], "/cc.arduino.cli.commands.ArduinoCore/PlatformUpgrade", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCorePlatformUpgradeClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_PlatformUpgradeClient interface {
	Recv() (*PlatformUpgradeResp, error)
	grpc.ClientStream
}

type arduinoCorePlatformUpgradeClient struct {
	grpc.ClientStream
}

func (x *arduinoCorePlatformUpgradeClient) Recv() (*PlatformUpgradeResp, error) {
	m := new(PlatformUpgradeResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) Upload(ctx context.Context, in *UploadReq, opts ...grpc.CallOption) (ArduinoCore_UploadClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[11], "/cc.arduino.cli.commands.ArduinoCore/Upload", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreUploadClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_UploadClient interface {
	Recv() (*UploadResp, error)
	grpc.ClientStream
}

type arduinoCoreUploadClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreUploadClient) Recv() (*UploadResp, error) {
	m := new(UploadResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) ListProgrammersAvailableForUpload(ctx context.Context, in *ListProgrammersAvailableForUploadReq, opts ...grpc.CallOption) (*ListProgrammersAvailableForUploadResp, error) {
	out := new(ListProgrammersAvailableForUploadResp)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.ArduinoCore/ListProgrammersAvailableForUpload", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreClient) BurnBootloader(ctx context.Context, in *BurnBootloaderReq, opts ...grpc.CallOption) (ArduinoCore_BurnBootloaderClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[12], "/cc.arduino.cli.commands.ArduinoCore/BurnBootloader", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreBurnBootloaderClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_BurnBootloaderClient interface {
	Recv() (*BurnBootloaderResp, error)
	grpc.ClientStream
}

type arduinoCoreBurnBootloaderClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreBurnBootloaderClient) Recv() (*BurnBootloaderResp, error) {
	m := new(BurnBootloaderResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) PlatformSearch(ctx context.Context, in *PlatformSearchReq, opts ...grpc.CallOption) (*PlatformSearchResp, error) {
	out := new(PlatformSearchResp)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.ArduinoCore/PlatformSearch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreClient) PlatformList(ctx context.Context, in *PlatformListReq, opts ...grpc.CallOption) (*PlatformListResp, error) {
	out := new(PlatformListResp)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.ArduinoCore/PlatformList", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreClient) LibraryDownload(ctx context.Context, in *LibraryDownloadReq, opts ...grpc.CallOption) (ArduinoCore_LibraryDownloadClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[13], "/cc.arduino.cli.commands.ArduinoCore/LibraryDownload", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreLibraryDownloadClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_LibraryDownloadClient interface {
	Recv() (*LibraryDownloadResp, error)
	grpc.ClientStream
}

type arduinoCoreLibraryDownloadClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreLibraryDownloadClient) Recv() (*LibraryDownloadResp, error) {
	m := new(LibraryDownloadResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) LibraryInstall(ctx context.Context, in *LibraryInstallReq, opts ...grpc.CallOption) (ArduinoCore_LibraryInstallClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[14], "/cc.arduino.cli.commands.ArduinoCore/LibraryInstall", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreLibraryInstallClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_LibraryInstallClient interface {
	Recv() (*LibraryInstallResp, error)
	grpc.ClientStream
}

type arduinoCoreLibraryInstallClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreLibraryInstallClient) Recv() (*LibraryInstallResp, error) {
	m := new(LibraryInstallResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) LibraryUninstall(ctx context.Context, in *LibraryUninstallReq, opts ...grpc.CallOption) (ArduinoCore_LibraryUninstallClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[15], "/cc.arduino.cli.commands.ArduinoCore/LibraryUninstall", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreLibraryUninstallClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_LibraryUninstallClient interface {
	Recv() (*LibraryUninstallResp, error)
	grpc.ClientStream
}

type arduinoCoreLibraryUninstallClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreLibraryUninstallClient) Recv() (*LibraryUninstallResp, error) {
	m := new(LibraryUninstallResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) LibraryUpgradeAll(ctx context.Context, in *LibraryUpgradeAllReq, opts ...grpc.CallOption) (ArduinoCore_LibraryUpgradeAllClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArduinoCore_serviceDesc.Streams[16], "/cc.arduino.cli.commands.ArduinoCore/LibraryUpgradeAll", opts...)
	if err != nil {
		return nil, err
	}
	x := &arduinoCoreLibraryUpgradeAllClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArduinoCore_LibraryUpgradeAllClient interface {
	Recv() (*LibraryUpgradeAllResp, error)
	grpc.ClientStream
}

type arduinoCoreLibraryUpgradeAllClient struct {
	grpc.ClientStream
}

func (x *arduinoCoreLibraryUpgradeAllClient) Recv() (*LibraryUpgradeAllResp, error) {
	m := new(LibraryUpgradeAllResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *arduinoCoreClient) LibraryResolveDependencies(ctx context.Context, in *LibraryResolveDependenciesReq, opts ...grpc.CallOption) (*LibraryResolveDependenciesResp, error) {
	out := new(LibraryResolveDependenciesResp)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.ArduinoCore/LibraryResolveDependencies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreClient) LibrarySearch(ctx context.Context, in *LibrarySearchReq, opts ...grpc.CallOption) (*LibrarySearchResp, error) {
	out := new(LibrarySearchResp)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.ArduinoCore/LibrarySearch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *arduinoCoreClient) LibraryList(ctx context.Context, in *LibraryListReq, opts ...grpc.CallOption) (*LibraryListResp, error) {
	out := new(LibraryListResp)
	err := c.cc.Invoke(ctx, "/cc.arduino.cli.commands.ArduinoCore/LibraryList", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ArduinoCoreServer is the server API for ArduinoCore service.
type ArduinoCoreServer interface {
	// Start a new instance of the Arduino Core Service
	Init(*InitReq, ArduinoCore_InitServer) error
	// Destroy an instance of the Arduino Core Service
	Destroy(context.Context, *DestroyReq) (*DestroyResp, error)
	// Rescan instance of the Arduino Core Service
	Rescan(context.Context, *RescanReq) (*RescanResp, error)
	// Update package index of the Arduino Core Service
	UpdateIndex(*UpdateIndexReq, ArduinoCore_UpdateIndexServer) error
	// Update libraries index
	UpdateLibrariesIndex(*UpdateLibrariesIndexReq, ArduinoCore_UpdateLibrariesIndexServer) error
	// Update packages indexes for both Cores and Libraries
	UpdateCoreLibrariesIndex(*UpdateCoreLibrariesIndexReq, ArduinoCore_UpdateCoreLibrariesIndexServer) error
	// Outdated returns a message with a list of outdated Cores and Libraries
	Outdated(context.Context, *OutdatedReq) (*OutdatedResp, error)
	// Upgrade both Cores and Libraries
	Upgrade(*UpgradeReq, ArduinoCore_UpgradeServer) error
	// Get the version of Arduino CLI in use.
	Version(context.Context, *VersionReq) (*VersionResp, error)
	// Returns all files composing a Sketch
	LoadSketch(context.Context, *LoadSketchReq) (*LoadSketchResp, error)
	// Creates a zip file containing all files of specified Sketch
	ArchiveSketch(context.Context, *ArchiveSketchReq) (*ArchiveSketchResp, error)
	// Requests details about a board
	BoardDetails(context.Context, *BoardDetailsReq) (*BoardDetailsResp, error)
	// Attach a board to a sketch. When the `fqbn` field of a request is not
	// provided, the FQBN of the attached board will be used.
	BoardAttach(*BoardAttachReq, ArduinoCore_BoardAttachServer) error
	// List the boards currently connected to the computer.
	BoardList(context.Context, *BoardListReq) (*BoardListResp, error)
	// List all the boards provided by installed platforms.
	BoardListAll(context.Context, *BoardListAllReq) (*BoardListAllResp, error)
	// Compile an Arduino sketch.
	Compile(*CompileReq, ArduinoCore_CompileServer) error
	// Download and install a platform and its tool dependencies.
	PlatformInstall(*PlatformInstallReq, ArduinoCore_PlatformInstallServer) error
	// Download a platform and its tool dependencies to the `staging/packages`
	// subdirectory of the data directory.
	PlatformDownload(*PlatformDownloadReq, ArduinoCore_PlatformDownloadServer) error
	// Uninstall a platform as well as its tool dependencies that are not used by
	// other installed platforms.
	PlatformUninstall(*PlatformUninstallReq, ArduinoCore_PlatformUninstallServer) error
	// Upgrade an installed platform to the latest version.
	PlatformUpgrade(*PlatformUpgradeReq, ArduinoCore_PlatformUpgradeServer) error
	// Upload a compiled sketch to an Arduino board.
	Upload(*UploadReq, ArduinoCore_UploadServer) error
	ListProgrammersAvailableForUpload(context.Context, *ListProgrammersAvailableForUploadReq) (*ListProgrammersAvailableForUploadResp, error)
	// Burn bootloader to a board.
	BurnBootloader(*BurnBootloaderReq, ArduinoCore_BurnBootloaderServer) error
	// Search for a platform in the platforms indexes.
	PlatformSearch(context.Context, *PlatformSearchReq) (*PlatformSearchResp, error)
	// List all installed platforms.
	PlatformList(context.Context, *PlatformListReq) (*PlatformListResp, error)
	// Download the archive file of an Arduino library in the libraries index to
	// the staging directory.
	LibraryDownload(*LibraryDownloadReq, ArduinoCore_LibraryDownloadServer) error
	// Download and install an Arduino library from the libraries index.
	LibraryInstall(*LibraryInstallReq, ArduinoCore_LibraryInstallServer) error
	// Uninstall an Arduino library.
	LibraryUninstall(*LibraryUninstallReq, ArduinoCore_LibraryUninstallServer) error
	// Upgrade all installed Arduino libraries to the newest version available.
	LibraryUpgradeAll(*LibraryUpgradeAllReq, ArduinoCore_LibraryUpgradeAllServer) error
	// List the recursive dependencies of a library, as defined by the `depends`
	// field of the library.properties files.
	LibraryResolveDependencies(context.Context, *LibraryResolveDependenciesReq) (*LibraryResolveDependenciesResp, error)
	// Search the Arduino libraries index for libraries.
	LibrarySearch(context.Context, *LibrarySearchReq) (*LibrarySearchResp, error)
	// List the installed libraries.
	LibraryList(context.Context, *LibraryListReq) (*LibraryListResp, error)
}

// UnimplementedArduinoCoreServer can be embedded to have forward compatible implementations.
type UnimplementedArduinoCoreServer struct {
}

func (*UnimplementedArduinoCoreServer) Init(*InitReq, ArduinoCore_InitServer) error {
	return status.Errorf(codes.Unimplemented, "method Init not implemented")
}
func (*UnimplementedArduinoCoreServer) Destroy(context.Context, *DestroyReq) (*DestroyResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Destroy not implemented")
}
func (*UnimplementedArduinoCoreServer) Rescan(context.Context, *RescanReq) (*RescanResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Rescan not implemented")
}
func (*UnimplementedArduinoCoreServer) UpdateIndex(*UpdateIndexReq, ArduinoCore_UpdateIndexServer) error {
	return status.Errorf(codes.Unimplemented, "method UpdateIndex not implemented")
}
func (*UnimplementedArduinoCoreServer) UpdateLibrariesIndex(*UpdateLibrariesIndexReq, ArduinoCore_UpdateLibrariesIndexServer) error {
	return status.Errorf(codes.Unimplemented, "method UpdateLibrariesIndex not implemented")
}
func (*UnimplementedArduinoCoreServer) UpdateCoreLibrariesIndex(*UpdateCoreLibrariesIndexReq, ArduinoCore_UpdateCoreLibrariesIndexServer) error {
	return status.Errorf(codes.Unimplemented, "method UpdateCoreLibrariesIndex not implemented")
}
func (*UnimplementedArduinoCoreServer) Outdated(context.Context, *OutdatedReq) (*OutdatedResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Outdated not implemented")
}
func (*UnimplementedArduinoCoreServer) Upgrade(*UpgradeReq, ArduinoCore_UpgradeServer) error {
	return status.Errorf(codes.Unimplemented, "method Upgrade not implemented")
}
func (*UnimplementedArduinoCoreServer) Version(context.Context, *VersionReq) (*VersionResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Version not implemented")
}
func (*UnimplementedArduinoCoreServer) LoadSketch(context.Context, *LoadSketchReq) (*LoadSketchResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LoadSketch not implemented")
}
func (*UnimplementedArduinoCoreServer) ArchiveSketch(context.Context, *ArchiveSketchReq) (*ArchiveSketchResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ArchiveSketch not implemented")
}
func (*UnimplementedArduinoCoreServer) BoardDetails(context.Context, *BoardDetailsReq) (*BoardDetailsResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BoardDetails not implemented")
}
func (*UnimplementedArduinoCoreServer) BoardAttach(*BoardAttachReq, ArduinoCore_BoardAttachServer) error {
	return status.Errorf(codes.Unimplemented, "method BoardAttach not implemented")
}
func (*UnimplementedArduinoCoreServer) BoardList(context.Context, *BoardListReq) (*BoardListResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BoardList not implemented")
}
func (*UnimplementedArduinoCoreServer) BoardListAll(context.Context, *BoardListAllReq) (*BoardListAllResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BoardListAll not implemented")
}
func (*UnimplementedArduinoCoreServer) Compile(*CompileReq, ArduinoCore_CompileServer) error {
	return status.Errorf(codes.Unimplemented, "method Compile not implemented")
}
func (*UnimplementedArduinoCoreServer) PlatformInstall(*PlatformInstallReq, ArduinoCore_PlatformInstallServer) error {
	return status.Errorf(codes.Unimplemented, "method PlatformInstall not implemented")
}
func (*UnimplementedArduinoCoreServer) PlatformDownload(*PlatformDownloadReq, ArduinoCore_PlatformDownloadServer) error {
	return status.Errorf(codes.Unimplemented, "method PlatformDownload not implemented")
}
func (*UnimplementedArduinoCoreServer) PlatformUninstall(*PlatformUninstallReq, ArduinoCore_PlatformUninstallServer) error {
	return status.Errorf(codes.Unimplemented, "method PlatformUninstall not implemented")
}
func (*UnimplementedArduinoCoreServer) PlatformUpgrade(*PlatformUpgradeReq, ArduinoCore_PlatformUpgradeServer) error {
	return status.Errorf(codes.Unimplemented, "method PlatformUpgrade not implemented")
}
func (*UnimplementedArduinoCoreServer) Upload(*UploadReq, ArduinoCore_UploadServer) error {
	return status.Errorf(codes.Unimplemented, "method Upload not implemented")
}
func (*UnimplementedArduinoCoreServer) ListProgrammersAvailableForUpload(context.Context, *ListProgrammersAvailableForUploadReq) (*ListProgrammersAvailableForUploadResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProgrammersAvailableForUpload not implemented")
}
func (*UnimplementedArduinoCoreServer) BurnBootloader(*BurnBootloaderReq, ArduinoCore_BurnBootloaderServer) error {
	return status.Errorf(codes.Unimplemented, "method BurnBootloader not implemented")
}
func (*UnimplementedArduinoCoreServer) PlatformSearch(context.Context, *PlatformSearchReq) (*PlatformSearchResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PlatformSearch not implemented")
}
func (*UnimplementedArduinoCoreServer) PlatformList(context.Context, *PlatformListReq) (*PlatformListResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PlatformList not implemented")
}
func (*UnimplementedArduinoCoreServer) LibraryDownload(*LibraryDownloadReq, ArduinoCore_LibraryDownloadServer) error {
	return status.Errorf(codes.Unimplemented, "method LibraryDownload not implemented")
}
func (*UnimplementedArduinoCoreServer) LibraryInstall(*LibraryInstallReq, ArduinoCore_LibraryInstallServer) error {
	return status.Errorf(codes.Unimplemented, "method LibraryInstall not implemented")
}
func (*UnimplementedArduinoCoreServer) LibraryUninstall(*LibraryUninstallReq, ArduinoCore_LibraryUninstallServer) error {
	return status.Errorf(codes.Unimplemented, "method LibraryUninstall not implemented")
}
func (*UnimplementedArduinoCoreServer) LibraryUpgradeAll(*LibraryUpgradeAllReq, ArduinoCore_LibraryUpgradeAllServer) error {
	return status.Errorf(codes.Unimplemented, "method LibraryUpgradeAll not implemented")
}
func (*UnimplementedArduinoCoreServer) LibraryResolveDependencies(context.Context, *LibraryResolveDependenciesReq) (*LibraryResolveDependenciesResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LibraryResolveDependencies not implemented")
}
func (*UnimplementedArduinoCoreServer) LibrarySearch(context.Context, *LibrarySearchReq) (*LibrarySearchResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LibrarySearch not implemented")
}
func (*UnimplementedArduinoCoreServer) LibraryList(context.Context, *LibraryListReq) (*LibraryListResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LibraryList not implemented")
}

func RegisterArduinoCoreServer(s *grpc.Server, srv ArduinoCoreServer) {
	s.RegisterService(&_ArduinoCore_serviceDesc, srv)
}

func _ArduinoCore_Init_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(InitReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).Init(m, &arduinoCoreInitServer{stream})
}

type ArduinoCore_InitServer interface {
	Send(*InitResp) error
	grpc.ServerStream
}

type arduinoCoreInitServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreInitServer) Send(m *InitResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_Destroy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DestroyReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServer).Destroy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.ArduinoCore/Destroy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServer).Destroy(ctx, req.(*DestroyReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCore_Rescan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RescanReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServer).Rescan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.ArduinoCore/Rescan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServer).Rescan(ctx, req.(*RescanReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCore_UpdateIndex_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(UpdateIndexReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).UpdateIndex(m, &arduinoCoreUpdateIndexServer{stream})
}

type ArduinoCore_UpdateIndexServer interface {
	Send(*UpdateIndexResp) error
	grpc.ServerStream
}

type arduinoCoreUpdateIndexServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreUpdateIndexServer) Send(m *UpdateIndexResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_UpdateLibrariesIndex_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(UpdateLibrariesIndexReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).UpdateLibrariesIndex(m, &arduinoCoreUpdateLibrariesIndexServer{stream})
}

type ArduinoCore_UpdateLibrariesIndexServer interface {
	Send(*UpdateLibrariesIndexResp) error
	grpc.ServerStream
}

type arduinoCoreUpdateLibrariesIndexServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreUpdateLibrariesIndexServer) Send(m *UpdateLibrariesIndexResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_UpdateCoreLibrariesIndex_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(UpdateCoreLibrariesIndexReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).UpdateCoreLibrariesIndex(m, &arduinoCoreUpdateCoreLibrariesIndexServer{stream})
}

type ArduinoCore_UpdateCoreLibrariesIndexServer interface {
	Send(*UpdateCoreLibrariesIndexResp) error
	grpc.ServerStream
}

type arduinoCoreUpdateCoreLibrariesIndexServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreUpdateCoreLibrariesIndexServer) Send(m *UpdateCoreLibrariesIndexResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_Outdated_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OutdatedReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServer).Outdated(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.ArduinoCore/Outdated",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServer).Outdated(ctx, req.(*OutdatedReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCore_Upgrade_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(UpgradeReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).Upgrade(m, &arduinoCoreUpgradeServer{stream})
}

type ArduinoCore_UpgradeServer interface {
	Send(*UpgradeResp) error
	grpc.ServerStream
}

type arduinoCoreUpgradeServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreUpgradeServer) Send(m *UpgradeResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_Version_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VersionReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServer).Version(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.ArduinoCore/Version",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServer).Version(ctx, req.(*VersionReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCore_LoadSketch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LoadSketchReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServer).LoadSketch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.ArduinoCore/LoadSketch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServer).LoadSketch(ctx, req.(*LoadSketchReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCore_ArchiveSketch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ArchiveSketchReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServer).ArchiveSketch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.ArduinoCore/ArchiveSketch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServer).ArchiveSketch(ctx, req.(*ArchiveSketchReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCore_BoardDetails_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BoardDetailsReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServer).BoardDetails(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.ArduinoCore/BoardDetails",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServer).BoardDetails(ctx, req.(*BoardDetailsReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCore_BoardAttach_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(BoardAttachReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).BoardAttach(m, &arduinoCoreBoardAttachServer{stream})
}

type ArduinoCore_BoardAttachServer interface {
	Send(*BoardAttachResp) error
	grpc.ServerStream
}

type arduinoCoreBoardAttachServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreBoardAttachServer) Send(m *BoardAttachResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_BoardList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BoardListReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServer).BoardList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.ArduinoCore/BoardList",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServer).BoardList(ctx, req.(*BoardListReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCore_BoardListAll_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BoardListAllReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServer).BoardListAll(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.ArduinoCore/BoardListAll",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServer).BoardListAll(ctx, req.(*BoardListAllReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCore_Compile_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(CompileReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).Compile(m, &arduinoCoreCompileServer{stream})
}

type ArduinoCore_CompileServer interface {
	Send(*CompileResp) error
	grpc.ServerStream
}

type arduinoCoreCompileServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreCompileServer) Send(m *CompileResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_PlatformInstall_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(PlatformInstallReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).PlatformInstall(m, &arduinoCorePlatformInstallServer{stream})
}

type ArduinoCore_PlatformInstallServer interface {
	Send(*PlatformInstallResp) error
	grpc.ServerStream
}

type arduinoCorePlatformInstallServer struct {
	grpc.ServerStream
}

func (x *arduinoCorePlatformInstallServer) Send(m *PlatformInstallResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_PlatformDownload_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(PlatformDownloadReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).PlatformDownload(m, &arduinoCorePlatformDownloadServer{stream})
}

type ArduinoCore_PlatformDownloadServer interface {
	Send(*PlatformDownloadResp) error
	grpc.ServerStream
}

type arduinoCorePlatformDownloadServer struct {
	grpc.ServerStream
}

func (x *arduinoCorePlatformDownloadServer) Send(m *PlatformDownloadResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_PlatformUninstall_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(PlatformUninstallReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).PlatformUninstall(m, &arduinoCorePlatformUninstallServer{stream})
}

type ArduinoCore_PlatformUninstallServer interface {
	Send(*PlatformUninstallResp) error
	grpc.ServerStream
}

type arduinoCorePlatformUninstallServer struct {
	grpc.ServerStream
}

func (x *arduinoCorePlatformUninstallServer) Send(m *PlatformUninstallResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_PlatformUpgrade_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(PlatformUpgradeReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).PlatformUpgrade(m, &arduinoCorePlatformUpgradeServer{stream})
}

type ArduinoCore_PlatformUpgradeServer interface {
	Send(*PlatformUpgradeResp) error
	grpc.ServerStream
}

type arduinoCorePlatformUpgradeServer struct {
	grpc.ServerStream
}

func (x *arduinoCorePlatformUpgradeServer) Send(m *PlatformUpgradeResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_Upload_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(UploadReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).Upload(m, &arduinoCoreUploadServer{stream})
}

type ArduinoCore_UploadServer interface {
	Send(*UploadResp) error
	grpc.ServerStream
}

type arduinoCoreUploadServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreUploadServer) Send(m *UploadResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_ListProgrammersAvailableForUpload_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProgrammersAvailableForUploadReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServer).ListProgrammersAvailableForUpload(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.ArduinoCore/ListProgrammersAvailableForUpload",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServer).ListProgrammersAvailableForUpload(ctx, req.(*ListProgrammersAvailableForUploadReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCore_BurnBootloader_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(BurnBootloaderReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).BurnBootloader(m, &arduinoCoreBurnBootloaderServer{stream})
}

type ArduinoCore_BurnBootloaderServer interface {
	Send(*BurnBootloaderResp) error
	grpc.ServerStream
}

type arduinoCoreBurnBootloaderServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreBurnBootloaderServer) Send(m *BurnBootloaderResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_PlatformSearch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PlatformSearchReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServer).PlatformSearch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.ArduinoCore/PlatformSearch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServer).PlatformSearch(ctx, req.(*PlatformSearchReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCore_PlatformList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PlatformListReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServer).PlatformList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.ArduinoCore/PlatformList",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServer).PlatformList(ctx, req.(*PlatformListReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCore_LibraryDownload_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(LibraryDownloadReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).LibraryDownload(m, &arduinoCoreLibraryDownloadServer{stream})
}

type ArduinoCore_LibraryDownloadServer interface {
	Send(*LibraryDownloadResp) error
	grpc.ServerStream
}

type arduinoCoreLibraryDownloadServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreLibraryDownloadServer) Send(m *LibraryDownloadResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_LibraryInstall_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(LibraryInstallReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).LibraryInstall(m, &arduinoCoreLibraryInstallServer{stream})
}

type ArduinoCore_LibraryInstallServer interface {
	Send(*LibraryInstallResp) error
	grpc.ServerStream
}

type arduinoCoreLibraryInstallServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreLibraryInstallServer) Send(m *LibraryInstallResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_LibraryUninstall_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(LibraryUninstallReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).LibraryUninstall(m, &arduinoCoreLibraryUninstallServer{stream})
}

type ArduinoCore_LibraryUninstallServer interface {
	Send(*LibraryUninstallResp) error
	grpc.ServerStream
}

type arduinoCoreLibraryUninstallServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreLibraryUninstallServer) Send(m *LibraryUninstallResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_LibraryUpgradeAll_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(LibraryUpgradeAllReq)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArduinoCoreServer).LibraryUpgradeAll(m, &arduinoCoreLibraryUpgradeAllServer{stream})
}

type ArduinoCore_LibraryUpgradeAllServer interface {
	Send(*LibraryUpgradeAllResp) error
	grpc.ServerStream
}

type arduinoCoreLibraryUpgradeAllServer struct {
	grpc.ServerStream
}

func (x *arduinoCoreLibraryUpgradeAllServer) Send(m *LibraryUpgradeAllResp) error {
	return x.ServerStream.SendMsg(m)
}

func _ArduinoCore_LibraryResolveDependencies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LibraryResolveDependenciesReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServer).LibraryResolveDependencies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.ArduinoCore/LibraryResolveDependencies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServer).LibraryResolveDependencies(ctx, req.(*LibraryResolveDependenciesReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCore_LibrarySearch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LibrarySearchReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServer).LibrarySearch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.ArduinoCore/LibrarySearch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServer).LibrarySearch(ctx, req.(*LibrarySearchReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArduinoCore_LibraryList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LibraryListReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArduinoCoreServer).LibraryList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cc.arduino.cli.commands.ArduinoCore/LibraryList",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArduinoCoreServer).LibraryList(ctx, req.(*LibraryListReq))
	}
	return interceptor(ctx, in, info, handler)
}

var _ArduinoCore_serviceDesc = grpc.ServiceDesc{
	ServiceName: "cc.arduino.cli.commands.ArduinoCore",
	HandlerType: (*ArduinoCoreServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Destroy",
			Handler:    _ArduinoCore_Destroy_Handler,
		},
		{
			MethodName: "Rescan",
			Handler:    _ArduinoCore_Rescan_Handler,
		},
		{
			MethodName: "Outdated",
			Handler:    _ArduinoCore_Outdated_Handler,
		},
		{
			MethodName: "Version",
			Handler:    _ArduinoCore_Version_Handler,
		},
		{
			MethodName: "LoadSketch",
			Handler:    _ArduinoCore_LoadSketch_Handler,
		},
		{
			MethodName: "ArchiveSketch",
			Handler:    _ArduinoCore_ArchiveSketch_Handler,
		},
		{
			MethodName: "BoardDetails",
			Handler:    _ArduinoCore_BoardDetails_Handler,
		},
		{
			MethodName: "BoardList",
			Handler:    _ArduinoCore_BoardList_Handler,
		},
		{
			MethodName: "BoardListAll",
			Handler:    _ArduinoCore_BoardListAll_Handler,
		},
		{
			MethodName: "ListProgrammersAvailableForUpload",
			Handler:    _ArduinoCore_ListProgrammersAvailableForUpload_Handler,
		},
		{
			MethodName: "PlatformSearch",
			Handler:    _ArduinoCore_PlatformSearch_Handler,
		},
		{
			MethodName: "PlatformList",
			Handler:    _ArduinoCore_PlatformList_Handler,
		},
		{
			MethodName: "LibraryResolveDependencies",
			Handler:    _ArduinoCore_LibraryResolveDependencies_Handler,
		},
		{
			MethodName: "LibrarySearch",
			Handler:    _ArduinoCore_LibrarySearch_Handler,
		},
		{
			MethodName: "LibraryList",
			Handler:    _ArduinoCore_LibraryList_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Init",
			Handler:       _ArduinoCore_Init_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "UpdateIndex",
			Handler:       _ArduinoCore_UpdateIndex_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "UpdateLibrariesIndex",
			Handler:       _ArduinoCore_UpdateLibrariesIndex_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "UpdateCoreLibrariesIndex",
			Handler:       _ArduinoCore_UpdateCoreLibrariesIndex_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Upgrade",
			Handler:       _ArduinoCore_Upgrade_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "BoardAttach",
			Handler:       _ArduinoCore_BoardAttach_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Compile",
			Handler:       _ArduinoCore_Compile_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "PlatformInstall",
			Handler:       _ArduinoCore_PlatformInstall_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "PlatformDownload",
			Handler:       _ArduinoCore_PlatformDownload_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "PlatformUninstall",
			Handler:       _ArduinoCore_PlatformUninstall_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "PlatformUpgrade",
			Handler:       _ArduinoCore_PlatformUpgrade_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Upload",
			Handler:       _ArduinoCore_Upload_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "BurnBootloader",
			Handler:       _ArduinoCore_BurnBootloader_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "LibraryDownload",
			Handler:       _ArduinoCore_LibraryDownload_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "LibraryInstall",
			Handler:       _ArduinoCore_LibraryInstall_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "LibraryUninstall",
			Handler:       _ArduinoCore_LibraryUninstall_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "LibraryUpgradeAll",
			Handler:       _ArduinoCore_LibraryUpgradeAll_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "commands/commands.proto",
}
