// This file is part of arduino-cli.
//
// Copyright 2020 ARDUINO SA (http://www.arduino.cc/)
//
// This software is released under the GNU General Public License version 3,
// which covers the main part of arduino-cli.
// The terms of this license can be found at:
// https://www.gnu.org/licenses/gpl-3.0.en.html
//
// You can be released from the requirements of the above licenses by purchasing
// a commercial license. Buying such a license is mandatory if you want to
// modify or otherwise use the software for commercial activities involving the
// Arduino software without disclosing the source code of your own applications.
// To purchase a commercial license, send an email to license@arduino.cc.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.11.3
// source: debug/debug.proto

package debug

import (
	context "context"
	commands "github.com/arduino/arduino-cli/rpc/commands"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// The top-level message sent by the client for the `Debug` method.
// Multiple `DebugReq` messages can be sent but the first message
// must contain a `DebugReq` message to initialize the debug session.
// All subsequent messages must contain bytes to be sent to the debug session
// and must not contain a `DebugReq` message.
type DebugReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Provides information to the debug that specifies which is the target.
	// The first `StreamingOpenReq` message must contain a `DebugReq`
	// message.
	DebugReq *DebugConfigReq `protobuf:"bytes,1,opt,name=debugReq,proto3" json:"debugReq,omitempty"`
	// The data to be sent to the target being monitored.
	Data []byte `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	// Set this to true to send and Interrupt signal to the debugger process
	SendInterrupt bool `protobuf:"varint,3,opt,name=send_interrupt,json=sendInterrupt,proto3" json:"send_interrupt,omitempty"`
}

func (x *DebugReq) Reset() {
	*x = DebugReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_debug_debug_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DebugReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DebugReq) ProtoMessage() {}

func (x *DebugReq) ProtoReflect() protoreflect.Message {
	mi := &file_debug_debug_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DebugReq.ProtoReflect.Descriptor instead.
func (*DebugReq) Descriptor() ([]byte, []int) {
	return file_debug_debug_proto_rawDescGZIP(), []int{0}
}

func (x *DebugReq) GetDebugReq() *DebugConfigReq {
	if x != nil {
		return x.DebugReq
	}
	return nil
}

func (x *DebugReq) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *DebugReq) GetSendInterrupt() bool {
	if x != nil {
		return x.SendInterrupt
	}
	return false
}

type DebugConfigReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *commands.Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Fully qualified board name of the board in use
	// (e.g., `arduino:samd:mkr1000`). If this is omitted, the FQBN attached to
	// the sketch will be used.
	Fqbn string `protobuf:"bytes,2,opt,name=fqbn,proto3" json:"fqbn,omitempty"`
	// Path to the sketch that is running on the board. The compiled executable
	// is expected to be located under this path.
	SketchPath string `protobuf:"bytes,3,opt,name=sketch_path,json=sketchPath,proto3" json:"sketch_path,omitempty"`
	// Port of the debugger. Set to `none` if the debugger doesn't use a port.
	Port string `protobuf:"bytes,4,opt,name=port,proto3" json:"port,omitempty"`
	// Which GDB command interpreter to use.
	Interpreter string `protobuf:"bytes,5,opt,name=interpreter,proto3" json:"interpreter,omitempty"`
	// DEPRECATED: use import_dir instead
	//
	// Deprecated: Do not use.
	ImportFile string `protobuf:"bytes,7,opt,name=import_file,json=importFile,proto3" json:"import_file,omitempty"`
	// Directory containing the compiled executable. If `import_dir` is not
	// specified, the executable is assumed to be in
	// `{sketch_path}/build/{fqbn}/`.
	ImportDir string `protobuf:"bytes,8,opt,name=import_dir,json=importDir,proto3" json:"import_dir,omitempty"`
}

func (x *DebugConfigReq) Reset() {
	*x = DebugConfigReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_debug_debug_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DebugConfigReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DebugConfigReq) ProtoMessage() {}

func (x *DebugConfigReq) ProtoReflect() protoreflect.Message {
	mi := &file_debug_debug_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DebugConfigReq.ProtoReflect.Descriptor instead.
func (*DebugConfigReq) Descriptor() ([]byte, []int) {
	return file_debug_debug_proto_rawDescGZIP(), []int{1}
}

func (x *DebugConfigReq) GetInstance() *commands.Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *DebugConfigReq) GetFqbn() string {
	if x != nil {
		return x.Fqbn
	}
	return ""
}

func (x *DebugConfigReq) GetSketchPath() string {
	if x != nil {
		return x.SketchPath
	}
	return ""
}

func (x *DebugConfigReq) GetPort() string {
	if x != nil {
		return x.Port
	}
	return ""
}

func (x *DebugConfigReq) GetInterpreter() string {
	if x != nil {
		return x.Interpreter
	}
	return ""
}

// Deprecated: Do not use.
func (x *DebugConfigReq) GetImportFile() string {
	if x != nil {
		return x.ImportFile
	}
	return ""
}

func (x *DebugConfigReq) GetImportDir() string {
	if x != nil {
		return x.ImportDir
	}
	return ""
}

//
type DebugResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Incoming data from the debugger tool.
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	// Incoming error output from the debugger tool.
	Error string `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *DebugResp) Reset() {
	*x = DebugResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_debug_debug_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DebugResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DebugResp) ProtoMessage() {}

func (x *DebugResp) ProtoReflect() protoreflect.Message {
	mi := &file_debug_debug_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DebugResp.ProtoReflect.Descriptor instead.
func (*DebugResp) Descriptor() ([]byte, []int) {
	return file_debug_debug_proto_rawDescGZIP(), []int{2}
}

func (x *DebugResp) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *DebugResp) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

var File_debug_debug_proto protoreflect.FileDescriptor

var file_debug_debug_proto_rawDesc = []byte{
	0x0a, 0x11, 0x64, 0x65, 0x62, 0x75, 0x67, 0x2f, 0x64, 0x65, 0x62, 0x75, 0x67, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x14, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e,
	0x63, 0x6c, 0x69, 0x2e, 0x64, 0x65, 0x62, 0x75, 0x67, 0x1a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x87, 0x01, 0x0a, 0x08, 0x44, 0x65, 0x62, 0x75, 0x67, 0x52, 0x65, 0x71, 0x12, 0x40, 0x0a,
	0x08, 0x64, 0x65, 0x62, 0x75, 0x67, 0x52, 0x65, 0x71, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69,
	0x2e, 0x64, 0x65, 0x62, 0x75, 0x67, 0x2e, 0x44, 0x65, 0x62, 0x75, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x65, 0x71, 0x52, 0x08, 0x64, 0x65, 0x62, 0x75, 0x67, 0x52, 0x65, 0x71, 0x12,
	0x12, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x65, 0x6e, 0x64, 0x5f, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x72, 0x75, 0x70, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x73, 0x65, 0x6e,
	0x64, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x72, 0x75, 0x70, 0x74, 0x22, 0xfe, 0x01, 0x0a, 0x0e, 0x44,
	0x65, 0x62, 0x75, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x12, 0x3d, 0x0a,
	0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x66, 0x71, 0x62, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x66, 0x71, 0x62, 0x6e,
	0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x6b, 0x65, 0x74, 0x63, 0x68, 0x50, 0x61, 0x74,
	0x68, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x20, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72,
	0x65, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x70, 0x72, 0x65, 0x74, 0x65, 0x72, 0x12, 0x23, 0x0a, 0x0b, 0x69, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x0a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x64, 0x69, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x69, 0x72, 0x22, 0x35, 0x0a, 0x09, 0x44,
	0x65, 0x62, 0x75, 0x67, 0x52, 0x65, 0x73, 0x70, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12, 0x14, 0x0a, 0x05,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x32, 0x57, 0x0a, 0x05, 0x44, 0x65, 0x62, 0x75, 0x67, 0x12, 0x4e, 0x0a, 0x05, 0x44,
	0x65, 0x62, 0x75, 0x67, 0x12, 0x1e, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x64, 0x65, 0x62, 0x75, 0x67, 0x2e, 0x44, 0x65, 0x62, 0x75,
	0x67, 0x52, 0x65, 0x71, 0x1a, 0x1f, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x64, 0x65, 0x62, 0x75, 0x67, 0x2e, 0x44, 0x65, 0x62, 0x75,
	0x67, 0x52, 0x65, 0x73, 0x70, 0x22, 0x00, 0x28, 0x01, 0x30, 0x01, 0x42, 0x2a, 0x5a, 0x28, 0x67,
	0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x72, 0x70,
	0x63, 0x2f, 0x64, 0x65, 0x62, 0x75, 0x67, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_debug_debug_proto_rawDescOnce sync.Once
	file_debug_debug_proto_rawDescData = file_debug_debug_proto_rawDesc
)

func file_debug_debug_proto_rawDescGZIP() []byte {
	file_debug_debug_proto_rawDescOnce.Do(func() {
		file_debug_debug_proto_rawDescData = protoimpl.X.CompressGZIP(file_debug_debug_proto_rawDescData)
	})
	return file_debug_debug_proto_rawDescData
}

var file_debug_debug_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_debug_debug_proto_goTypes = []interface{}{
	(*DebugReq)(nil),          // 0: cc.arduino.cli.debug.DebugReq
	(*DebugConfigReq)(nil),    // 1: cc.arduino.cli.debug.DebugConfigReq
	(*DebugResp)(nil),         // 2: cc.arduino.cli.debug.DebugResp
	(*commands.Instance)(nil), // 3: cc.arduino.cli.commands.Instance
}
var file_debug_debug_proto_depIdxs = []int32{
	1, // 0: cc.arduino.cli.debug.DebugReq.debugReq:type_name -> cc.arduino.cli.debug.DebugConfigReq
	3, // 1: cc.arduino.cli.debug.DebugConfigReq.instance:type_name -> cc.arduino.cli.commands.Instance
	0, // 2: cc.arduino.cli.debug.Debug.Debug:input_type -> cc.arduino.cli.debug.DebugReq
	2, // 3: cc.arduino.cli.debug.Debug.Debug:output_type -> cc.arduino.cli.debug.DebugResp
	3, // [3:4] is the sub-list for method output_type
	2, // [2:3] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_debug_debug_proto_init() }
func file_debug_debug_proto_init() {
	if File_debug_debug_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_debug_debug_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DebugReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_debug_debug_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DebugConfigReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_debug_debug_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DebugResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_debug_debug_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_debug_debug_proto_goTypes,
		DependencyIndexes: file_debug_debug_proto_depIdxs,
		MessageInfos:      file_debug_debug_proto_msgTypes,
	}.Build()
	File_debug_debug_proto = out.File
	file_debug_debug_proto_rawDesc = nil
	file_debug_debug_proto_goTypes = nil
	file_debug_debug_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DebugClient is the client API for Debug service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DebugClient interface {
	// Start a debug session and communicate with the debugger tool.
	Debug(ctx context.Context, opts ...grpc.CallOption) (Debug_DebugClient, error)
}

type debugClient struct {
	cc grpc.ClientConnInterface
}

func NewDebugClient(cc grpc.ClientConnInterface) DebugClient {
	return &debugClient{cc}
}

func (c *debugClient) Debug(ctx context.Context, opts ...grpc.CallOption) (Debug_DebugClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Debug_serviceDesc.Streams[0], "/cc.arduino.cli.debug.Debug/Debug", opts...)
	if err != nil {
		return nil, err
	}
	x := &debugDebugClient{stream}
	return x, nil
}

type Debug_DebugClient interface {
	Send(*DebugReq) error
	Recv() (*DebugResp, error)
	grpc.ClientStream
}

type debugDebugClient struct {
	grpc.ClientStream
}

func (x *debugDebugClient) Send(m *DebugReq) error {
	return x.ClientStream.SendMsg(m)
}

func (x *debugDebugClient) Recv() (*DebugResp, error) {
	m := new(DebugResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// DebugServer is the server API for Debug service.
type DebugServer interface {
	// Start a debug session and communicate with the debugger tool.
	Debug(Debug_DebugServer) error
}

// UnimplementedDebugServer can be embedded to have forward compatible implementations.
type UnimplementedDebugServer struct {
}

func (*UnimplementedDebugServer) Debug(Debug_DebugServer) error {
	return status.Errorf(codes.Unimplemented, "method Debug not implemented")
}

func RegisterDebugServer(s *grpc.Server, srv DebugServer) {
	s.RegisterService(&_Debug_serviceDesc, srv)
}

func _Debug_Debug_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(DebugServer).Debug(&debugDebugServer{stream})
}

type Debug_DebugServer interface {
	Send(*DebugResp) error
	Recv() (*DebugReq, error)
	grpc.ServerStream
}

type debugDebugServer struct {
	grpc.ServerStream
}

func (x *debugDebugServer) Send(m *DebugResp) error {
	return x.ServerStream.SendMsg(m)
}

func (x *debugDebugServer) Recv() (*DebugReq, error) {
	m := new(DebugReq)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _Debug_serviceDesc = grpc.ServiceDesc{
	ServiceName: "cc.arduino.cli.debug.Debug",
	HandlerType: (*DebugServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Debug",
			Handler:       _Debug_Debug_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "debug/debug.proto",
}
