// This file is part of arduino-cli.
//
// Copyright 2020 ARDUINO SA (http://www.arduino.cc/)
//
// This software is released under the GNU General Public License version 3,
// which covers the main part of arduino-cli.
// The terms of this license can be found at:
// https://www.gnu.org/licenses/gpl-3.0.en.html
//
// You can be released from the requirements of the above licenses by purchasing
// a commercial license. Buying such a license is mandatory if you want to
// modify or otherwise use the software for commercial activities involving the
// Arduino software without disclosing the source code of your own applications.
// To purchase a commercial license, send an email to license@arduino.cc.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.11.3
// source: commands/lib.proto

package commands

import (
	proto "github.com/golang/protobuf/proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

type LibrarySearchStatus int32

const (
	// No search results were found.
	LibrarySearchStatus_failed LibrarySearchStatus = 0
	// Search results were found.
	LibrarySearchStatus_success LibrarySearchStatus = 1
)

// Enum value maps for LibrarySearchStatus.
var (
	LibrarySearchStatus_name = map[int32]string{
		0: "failed",
		1: "success",
	}
	LibrarySearchStatus_value = map[string]int32{
		"failed":  0,
		"success": 1,
	}
)

func (x LibrarySearchStatus) Enum() *LibrarySearchStatus {
	p := new(LibrarySearchStatus)
	*p = x
	return p
}

func (x LibrarySearchStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LibrarySearchStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_commands_lib_proto_enumTypes[0].Descriptor()
}

func (LibrarySearchStatus) Type() protoreflect.EnumType {
	return &file_commands_lib_proto_enumTypes[0]
}

func (x LibrarySearchStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LibrarySearchStatus.Descriptor instead.
func (LibrarySearchStatus) EnumDescriptor() ([]byte, []int) {
	return file_commands_lib_proto_rawDescGZIP(), []int{0}
}

type LibraryLayout int32

const (
	// Library is in the 1.0 Arduino library format.
	LibraryLayout_flat_layout LibraryLayout = 0
	// Library is in the 1.5 Arduino library format.
	LibraryLayout_recursive_layout LibraryLayout = 1
)

// Enum value maps for LibraryLayout.
var (
	LibraryLayout_name = map[int32]string{
		0: "flat_layout",
		1: "recursive_layout",
	}
	LibraryLayout_value = map[string]int32{
		"flat_layout":      0,
		"recursive_layout": 1,
	}
)

func (x LibraryLayout) Enum() *LibraryLayout {
	p := new(LibraryLayout)
	*p = x
	return p
}

func (x LibraryLayout) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LibraryLayout) Descriptor() protoreflect.EnumDescriptor {
	return file_commands_lib_proto_enumTypes[1].Descriptor()
}

func (LibraryLayout) Type() protoreflect.EnumType {
	return &file_commands_lib_proto_enumTypes[1]
}

func (x LibraryLayout) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LibraryLayout.Descriptor instead.
func (LibraryLayout) EnumDescriptor() ([]byte, []int) {
	return file_commands_lib_proto_rawDescGZIP(), []int{1}
}

type LibraryLocation int32

const (
	// In the `libraries` subdirectory of the Arduino IDE installation.
	LibraryLocation_ide_builtin LibraryLocation = 0
	// In the `libraries` subdirectory of the user directory (sketchbook).
	LibraryLocation_user LibraryLocation = 1
	// In the `libraries` subdirectory of a platform.
	LibraryLocation_platform_builtin LibraryLocation = 2
	// When `LibraryLocation` is used in a context where a board is specified,
	// this indicates the library is in the `libraries` subdirectory of a
	// platform referenced by the board's platform.
	LibraryLocation_referenced_platform_builtin LibraryLocation = 3
)

// Enum value maps for LibraryLocation.
var (
	LibraryLocation_name = map[int32]string{
		0: "ide_builtin",
		1: "user",
		2: "platform_builtin",
		3: "referenced_platform_builtin",
	}
	LibraryLocation_value = map[string]int32{
		"ide_builtin":                 0,
		"user":                        1,
		"platform_builtin":            2,
		"referenced_platform_builtin": 3,
	}
)

func (x LibraryLocation) Enum() *LibraryLocation {
	p := new(LibraryLocation)
	*p = x
	return p
}

func (x LibraryLocation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LibraryLocation) Descriptor() protoreflect.EnumDescriptor {
	return file_commands_lib_proto_enumTypes[2].Descriptor()
}

func (LibraryLocation) Type() protoreflect.EnumType {
	return &file_commands_lib_proto_enumTypes[2]
}

func (x LibraryLocation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LibraryLocation.Descriptor instead.
func (LibraryLocation) EnumDescriptor() ([]byte, []int) {
	return file_commands_lib_proto_rawDescGZIP(), []int{2}
}

type LibraryDownloadReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Name of the library.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The version of the library to download.
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *LibraryDownloadReq) Reset() {
	*x = LibraryDownloadReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_lib_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryDownloadReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryDownloadReq) ProtoMessage() {}

func (x *LibraryDownloadReq) ProtoReflect() protoreflect.Message {
	mi := &file_commands_lib_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryDownloadReq.ProtoReflect.Descriptor instead.
func (*LibraryDownloadReq) Descriptor() ([]byte, []int) {
	return file_commands_lib_proto_rawDescGZIP(), []int{0}
}

func (x *LibraryDownloadReq) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *LibraryDownloadReq) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LibraryDownloadReq) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type LibraryDownloadResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Progress of the library download.
	Progress *DownloadProgress `protobuf:"bytes,1,opt,name=progress,proto3" json:"progress,omitempty"`
}

func (x *LibraryDownloadResp) Reset() {
	*x = LibraryDownloadResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_lib_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryDownloadResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryDownloadResp) ProtoMessage() {}

func (x *LibraryDownloadResp) ProtoReflect() protoreflect.Message {
	mi := &file_commands_lib_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryDownloadResp.ProtoReflect.Descriptor instead.
func (*LibraryDownloadResp) Descriptor() ([]byte, []int) {
	return file_commands_lib_proto_rawDescGZIP(), []int{1}
}

func (x *LibraryDownloadResp) GetProgress() *DownloadProgress {
	if x != nil {
		return x.Progress
	}
	return nil
}

type LibraryInstallReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Name of the library.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The version of the library to install.
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *LibraryInstallReq) Reset() {
	*x = LibraryInstallReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_lib_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryInstallReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryInstallReq) ProtoMessage() {}

func (x *LibraryInstallReq) ProtoReflect() protoreflect.Message {
	mi := &file_commands_lib_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryInstallReq.ProtoReflect.Descriptor instead.
func (*LibraryInstallReq) Descriptor() ([]byte, []int) {
	return file_commands_lib_proto_rawDescGZIP(), []int{2}
}

func (x *LibraryInstallReq) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *LibraryInstallReq) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LibraryInstallReq) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type LibraryInstallResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Progress of the library download.
	Progress *DownloadProgress `protobuf:"bytes,1,opt,name=progress,proto3" json:"progress,omitempty"`
	// Description of the current stage of the installation.
	TaskProgress *TaskProgress `protobuf:"bytes,2,opt,name=task_progress,json=taskProgress,proto3" json:"task_progress,omitempty"`
}

func (x *LibraryInstallResp) Reset() {
	*x = LibraryInstallResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_lib_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryInstallResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryInstallResp) ProtoMessage() {}

func (x *LibraryInstallResp) ProtoReflect() protoreflect.Message {
	mi := &file_commands_lib_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryInstallResp.ProtoReflect.Descriptor instead.
func (*LibraryInstallResp) Descriptor() ([]byte, []int) {
	return file_commands_lib_proto_rawDescGZIP(), []int{3}
}

func (x *LibraryInstallResp) GetProgress() *DownloadProgress {
	if x != nil {
		return x.Progress
	}
	return nil
}

func (x *LibraryInstallResp) GetTaskProgress() *TaskProgress {
	if x != nil {
		return x.TaskProgress
	}
	return nil
}

type LibraryUninstallReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Name of the library.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The version of the library to uninstall.
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *LibraryUninstallReq) Reset() {
	*x = LibraryUninstallReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_lib_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryUninstallReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryUninstallReq) ProtoMessage() {}

func (x *LibraryUninstallReq) ProtoReflect() protoreflect.Message {
	mi := &file_commands_lib_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryUninstallReq.ProtoReflect.Descriptor instead.
func (*LibraryUninstallReq) Descriptor() ([]byte, []int) {
	return file_commands_lib_proto_rawDescGZIP(), []int{4}
}

func (x *LibraryUninstallReq) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *LibraryUninstallReq) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LibraryUninstallReq) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type LibraryUninstallResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Description of the current stage of the uninstallation.
	TaskProgress *TaskProgress `protobuf:"bytes,1,opt,name=task_progress,json=taskProgress,proto3" json:"task_progress,omitempty"`
}

func (x *LibraryUninstallResp) Reset() {
	*x = LibraryUninstallResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_lib_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryUninstallResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryUninstallResp) ProtoMessage() {}

func (x *LibraryUninstallResp) ProtoReflect() protoreflect.Message {
	mi := &file_commands_lib_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryUninstallResp.ProtoReflect.Descriptor instead.
func (*LibraryUninstallResp) Descriptor() ([]byte, []int) {
	return file_commands_lib_proto_rawDescGZIP(), []int{5}
}

func (x *LibraryUninstallResp) GetTaskProgress() *TaskProgress {
	if x != nil {
		return x.TaskProgress
	}
	return nil
}

type LibraryUpgradeAllReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *LibraryUpgradeAllReq) Reset() {
	*x = LibraryUpgradeAllReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_lib_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryUpgradeAllReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryUpgradeAllReq) ProtoMessage() {}

func (x *LibraryUpgradeAllReq) ProtoReflect() protoreflect.Message {
	mi := &file_commands_lib_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryUpgradeAllReq.ProtoReflect.Descriptor instead.
func (*LibraryUpgradeAllReq) Descriptor() ([]byte, []int) {
	return file_commands_lib_proto_rawDescGZIP(), []int{6}
}

func (x *LibraryUpgradeAllReq) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

type LibraryUpgradeAllResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Progress of the downloads of files needed for the upgrades.
	Progress *DownloadProgress `protobuf:"bytes,1,opt,name=progress,proto3" json:"progress,omitempty"`
	// Description of the current stage of the upgrade.
	TaskProgress *TaskProgress `protobuf:"bytes,2,opt,name=task_progress,json=taskProgress,proto3" json:"task_progress,omitempty"`
}

func (x *LibraryUpgradeAllResp) Reset() {
	*x = LibraryUpgradeAllResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_lib_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryUpgradeAllResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryUpgradeAllResp) ProtoMessage() {}

func (x *LibraryUpgradeAllResp) ProtoReflect() protoreflect.Message {
	mi := &file_commands_lib_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryUpgradeAllResp.ProtoReflect.Descriptor instead.
func (*LibraryUpgradeAllResp) Descriptor() ([]byte, []int) {
	return file_commands_lib_proto_rawDescGZIP(), []int{7}
}

func (x *LibraryUpgradeAllResp) GetProgress() *DownloadProgress {
	if x != nil {
		return x.Progress
	}
	return nil
}

func (x *LibraryUpgradeAllResp) GetTaskProgress() *TaskProgress {
	if x != nil {
		return x.TaskProgress
	}
	return nil
}

type LibraryResolveDependenciesReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Name of the library.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The version of the library to check dependencies of. If no version is
	// specified, dependencies of the newest version will be listed.
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *LibraryResolveDependenciesReq) Reset() {
	*x = LibraryResolveDependenciesReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_lib_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryResolveDependenciesReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryResolveDependenciesReq) ProtoMessage() {}

func (x *LibraryResolveDependenciesReq) ProtoReflect() protoreflect.Message {
	mi := &file_commands_lib_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryResolveDependenciesReq.ProtoReflect.Descriptor instead.
func (*LibraryResolveDependenciesReq) Descriptor() ([]byte, []int) {
	return file_commands_lib_proto_rawDescGZIP(), []int{8}
}

func (x *LibraryResolveDependenciesReq) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *LibraryResolveDependenciesReq) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LibraryResolveDependenciesReq) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type LibraryResolveDependenciesResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Dependencies of the library.
	Dependencies []*LibraryDependencyStatus `protobuf:"bytes,1,rep,name=dependencies,proto3" json:"dependencies,omitempty"`
}

func (x *LibraryResolveDependenciesResp) Reset() {
	*x = LibraryResolveDependenciesResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_lib_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryResolveDependenciesResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryResolveDependenciesResp) ProtoMessage() {}

func (x *LibraryResolveDependenciesResp) ProtoReflect() protoreflect.Message {
	mi := &file_commands_lib_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryResolveDependenciesResp.ProtoReflect.Descriptor instead.
func (*LibraryResolveDependenciesResp) Descriptor() ([]byte, []int) {
	return file_commands_lib_proto_rawDescGZIP(), []int{9}
}

func (x *LibraryResolveDependenciesResp) GetDependencies() []*LibraryDependencyStatus {
	if x != nil {
		return x.Dependencies
	}
	return nil
}

type LibraryDependencyStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the library dependency.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The required version of the library dependency.
	VersionRequired string `protobuf:"bytes,2,opt,name=versionRequired,proto3" json:"versionRequired,omitempty"`
	// Version of the library dependency currently installed.
	VersionInstalled string `protobuf:"bytes,3,opt,name=versionInstalled,proto3" json:"versionInstalled,omitempty"`
}

func (x *LibraryDependencyStatus) Reset() {
	*x = LibraryDependencyStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_lib_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryDependencyStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryDependencyStatus) ProtoMessage() {}

func (x *LibraryDependencyStatus) ProtoReflect() protoreflect.Message {
	mi := &file_commands_lib_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryDependencyStatus.ProtoReflect.Descriptor instead.
func (*LibraryDependencyStatus) Descriptor() ([]byte, []int) {
	return file_commands_lib_proto_rawDescGZIP(), []int{10}
}

func (x *LibraryDependencyStatus) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LibraryDependencyStatus) GetVersionRequired() string {
	if x != nil {
		return x.VersionRequired
	}
	return ""
}

func (x *LibraryDependencyStatus) GetVersionInstalled() string {
	if x != nil {
		return x.VersionInstalled
	}
	return ""
}

type LibrarySearchReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// The search query.
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
}

func (x *LibrarySearchReq) Reset() {
	*x = LibrarySearchReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_lib_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibrarySearchReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibrarySearchReq) ProtoMessage() {}

func (x *LibrarySearchReq) ProtoReflect() protoreflect.Message {
	mi := &file_commands_lib_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibrarySearchReq.ProtoReflect.Descriptor instead.
func (*LibrarySearchReq) Descriptor() ([]byte, []int) {
	return file_commands_lib_proto_rawDescGZIP(), []int{11}
}

func (x *LibrarySearchReq) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *LibrarySearchReq) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

type LibrarySearchResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The results of the search.
	Libraries []*SearchedLibrary `protobuf:"bytes,1,rep,name=libraries,proto3" json:"libraries,omitempty"`
	// Whether the search yielded results.
	Status LibrarySearchStatus `protobuf:"varint,2,opt,name=status,proto3,enum=cc.arduino.cli.commands.LibrarySearchStatus" json:"status,omitempty"`
}

func (x *LibrarySearchResp) Reset() {
	*x = LibrarySearchResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_lib_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibrarySearchResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibrarySearchResp) ProtoMessage() {}

func (x *LibrarySearchResp) ProtoReflect() protoreflect.Message {
	mi := &file_commands_lib_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibrarySearchResp.ProtoReflect.Descriptor instead.
func (*LibrarySearchResp) Descriptor() ([]byte, []int) {
	return file_commands_lib_proto_rawDescGZIP(), []int{12}
}

func (x *LibrarySearchResp) GetLibraries() []*SearchedLibrary {
	if x != nil {
		return x.Libraries
	}
	return nil
}

func (x *LibrarySearchResp) GetStatus() LibrarySearchStatus {
	if x != nil {
		return x.Status
	}
	return LibrarySearchStatus_failed
}

type SearchedLibrary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Library name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The index data for the available versions of the library. The key of the
	// map is the library version.
	Releases map[string]*LibraryRelease `protobuf:"bytes,2,rep,name=releases,proto3" json:"releases,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The index data for the latest version of the library.
	Latest *LibraryRelease `protobuf:"bytes,3,opt,name=latest,proto3" json:"latest,omitempty"`
}

func (x *SearchedLibrary) Reset() {
	*x = SearchedLibrary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_lib_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchedLibrary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchedLibrary) ProtoMessage() {}

func (x *SearchedLibrary) ProtoReflect() protoreflect.Message {
	mi := &file_commands_lib_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchedLibrary.ProtoReflect.Descriptor instead.
func (*SearchedLibrary) Descriptor() ([]byte, []int) {
	return file_commands_lib_proto_rawDescGZIP(), []int{13}
}

func (x *SearchedLibrary) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SearchedLibrary) GetReleases() map[string]*LibraryRelease {
	if x != nil {
		return x.Releases
	}
	return nil
}

func (x *SearchedLibrary) GetLatest() *LibraryRelease {
	if x != nil {
		return x.Latest
	}
	return nil
}

type LibraryRelease struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value of the `author` field in library.properties.
	Author string `protobuf:"bytes,1,opt,name=author,proto3" json:"author,omitempty"`
	// Value of the `version` field in library.properties.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// Value of the `maintainer` field in library.properties.
	Maintainer string `protobuf:"bytes,3,opt,name=maintainer,proto3" json:"maintainer,omitempty"`
	// Value of the `sentence` field in library.properties.
	Sentence string `protobuf:"bytes,4,opt,name=sentence,proto3" json:"sentence,omitempty"`
	// Value of the `paragraph` field in library.properties.
	Paragraph string `protobuf:"bytes,5,opt,name=paragraph,proto3" json:"paragraph,omitempty"`
	// Value of the `url` field in library.properties.
	Website string `protobuf:"bytes,6,opt,name=website,proto3" json:"website,omitempty"`
	// Value of the `category` field in library.properties.
	Category string `protobuf:"bytes,7,opt,name=category,proto3" json:"category,omitempty"`
	// Value of the `architectures` field in library.properties.
	Architectures []string `protobuf:"bytes,8,rep,name=architectures,proto3" json:"architectures,omitempty"`
	// The type categories of the library, as defined in the libraries index.
	// Possible values: `Arduino`, `Partner`, `Recommended`, `Contributed`,
	// `Retired`.
	Types []string `protobuf:"bytes,9,rep,name=types,proto3" json:"types,omitempty"`
	// Information about the library archive file.
	Resources *DownloadResource `protobuf:"bytes,10,opt,name=resources,proto3" json:"resources,omitempty"`
	// Value of the `license` field in library.properties.
	License string `protobuf:"bytes,11,opt,name=license,proto3" json:"license,omitempty"`
	// Value of the `includes` field in library.properties.
	ProvidesIncludes []string `protobuf:"bytes,12,rep,name=provides_includes,json=providesIncludes,proto3" json:"provides_includes,omitempty"`
	// The names of the library's dependencies, as defined by the 'depends'
	// field of library.properties.
	Dependencies []*LibraryDependency `protobuf:"bytes,13,rep,name=dependencies,proto3" json:"dependencies,omitempty"`
}

func (x *LibraryRelease) Reset() {
	*x = LibraryRelease{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_lib_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryRelease) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryRelease) ProtoMessage() {}

func (x *LibraryRelease) ProtoReflect() protoreflect.Message {
	mi := &file_commands_lib_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryRelease.ProtoReflect.Descriptor instead.
func (*LibraryRelease) Descriptor() ([]byte, []int) {
	return file_commands_lib_proto_rawDescGZIP(), []int{14}
}

func (x *LibraryRelease) GetAuthor() string {
	if x != nil {
		return x.Author
	}
	return ""
}

func (x *LibraryRelease) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *LibraryRelease) GetMaintainer() string {
	if x != nil {
		return x.Maintainer
	}
	return ""
}

func (x *LibraryRelease) GetSentence() string {
	if x != nil {
		return x.Sentence
	}
	return ""
}

func (x *LibraryRelease) GetParagraph() string {
	if x != nil {
		return x.Paragraph
	}
	return ""
}

func (x *LibraryRelease) GetWebsite() string {
	if x != nil {
		return x.Website
	}
	return ""
}

func (x *LibraryRelease) GetCategory() string {
	if x != nil {
		return x.Category
	}
	return ""
}

func (x *LibraryRelease) GetArchitectures() []string {
	if x != nil {
		return x.Architectures
	}
	return nil
}

func (x *LibraryRelease) GetTypes() []string {
	if x != nil {
		return x.Types
	}
	return nil
}

func (x *LibraryRelease) GetResources() *DownloadResource {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *LibraryRelease) GetLicense() string {
	if x != nil {
		return x.License
	}
	return ""
}

func (x *LibraryRelease) GetProvidesIncludes() []string {
	if x != nil {
		return x.ProvidesIncludes
	}
	return nil
}

func (x *LibraryRelease) GetDependencies() []*LibraryDependency {
	if x != nil {
		return x.Dependencies
	}
	return nil
}

type LibraryDependency struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Library name of the dependency.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Version constraint of the dependency.
	VersionConstraint string `protobuf:"bytes,2,opt,name=version_constraint,json=versionConstraint,proto3" json:"version_constraint,omitempty"`
}

func (x *LibraryDependency) Reset() {
	*x = LibraryDependency{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_lib_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryDependency) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryDependency) ProtoMessage() {}

func (x *LibraryDependency) ProtoReflect() protoreflect.Message {
	mi := &file_commands_lib_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryDependency.ProtoReflect.Descriptor instead.
func (*LibraryDependency) Descriptor() ([]byte, []int) {
	return file_commands_lib_proto_rawDescGZIP(), []int{15}
}

func (x *LibraryDependency) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LibraryDependency) GetVersionConstraint() string {
	if x != nil {
		return x.VersionConstraint
	}
	return ""
}

type DownloadResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Download URL of the library archive.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// Filename of the library archive.
	Archivefilename string `protobuf:"bytes,2,opt,name=archivefilename,proto3" json:"archivefilename,omitempty"`
	// Checksum of the library archive.
	Checksum string `protobuf:"bytes,3,opt,name=checksum,proto3" json:"checksum,omitempty"`
	// File size of the library archive.
	Size int64 `protobuf:"varint,4,opt,name=size,proto3" json:"size,omitempty"`
	// The directory under the staging subdirectory of the data directory the
	// library archive file will be downloaded to.
	Cachepath string `protobuf:"bytes,5,opt,name=cachepath,proto3" json:"cachepath,omitempty"`
}

func (x *DownloadResource) Reset() {
	*x = DownloadResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_lib_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DownloadResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownloadResource) ProtoMessage() {}

func (x *DownloadResource) ProtoReflect() protoreflect.Message {
	mi := &file_commands_lib_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DownloadResource.ProtoReflect.Descriptor instead.
func (*DownloadResource) Descriptor() ([]byte, []int) {
	return file_commands_lib_proto_rawDescGZIP(), []int{16}
}

func (x *DownloadResource) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *DownloadResource) GetArchivefilename() string {
	if x != nil {
		return x.Archivefilename
	}
	return ""
}

func (x *DownloadResource) GetChecksum() string {
	if x != nil {
		return x.Checksum
	}
	return ""
}

func (x *DownloadResource) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *DownloadResource) GetCachepath() string {
	if x != nil {
		return x.Cachepath
	}
	return ""
}

type LibraryListReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Whether to include built-in libraries (from platforms and the Arduino
	// IDE) in the listing.
	All bool `protobuf:"varint,2,opt,name=all,proto3" json:"all,omitempty"`
	// Whether to list only libraries for which there is a newer version than
	// the installed version available in the libraries index.
	Updatable bool `protobuf:"varint,3,opt,name=updatable,proto3" json:"updatable,omitempty"`
	// If set filters out the libraries not matching name
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// By setting this field all duplicate libraries are filtered out leaving
	// only the libraries that will be used to compile for the specified board FQBN.
	Fqbn string `protobuf:"bytes,5,opt,name=fqbn,proto3" json:"fqbn,omitempty"`
}

func (x *LibraryListReq) Reset() {
	*x = LibraryListReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_lib_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryListReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryListReq) ProtoMessage() {}

func (x *LibraryListReq) ProtoReflect() protoreflect.Message {
	mi := &file_commands_lib_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryListReq.ProtoReflect.Descriptor instead.
func (*LibraryListReq) Descriptor() ([]byte, []int) {
	return file_commands_lib_proto_rawDescGZIP(), []int{17}
}

func (x *LibraryListReq) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *LibraryListReq) GetAll() bool {
	if x != nil {
		return x.All
	}
	return false
}

func (x *LibraryListReq) GetUpdatable() bool {
	if x != nil {
		return x.Updatable
	}
	return false
}

func (x *LibraryListReq) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LibraryListReq) GetFqbn() string {
	if x != nil {
		return x.Fqbn
	}
	return ""
}

type LibraryListResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of installed libraries.
	InstalledLibrary []*InstalledLibrary `protobuf:"bytes,1,rep,name=installed_library,json=installedLibrary,proto3" json:"installed_library,omitempty"`
}

func (x *LibraryListResp) Reset() {
	*x = LibraryListResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_lib_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryListResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryListResp) ProtoMessage() {}

func (x *LibraryListResp) ProtoReflect() protoreflect.Message {
	mi := &file_commands_lib_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryListResp.ProtoReflect.Descriptor instead.
func (*LibraryListResp) Descriptor() ([]byte, []int) {
	return file_commands_lib_proto_rawDescGZIP(), []int{18}
}

func (x *LibraryListResp) GetInstalledLibrary() []*InstalledLibrary {
	if x != nil {
		return x.InstalledLibrary
	}
	return nil
}

type InstalledLibrary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Information about the library.
	Library *Library `protobuf:"bytes,1,opt,name=library,proto3" json:"library,omitempty"`
	// When the `updatable` field of the `LibraryList` request is set to `true`,
	// this will contain information on the latest version of the library in the
	// libraries index.
	Release *LibraryRelease `protobuf:"bytes,2,opt,name=release,proto3" json:"release,omitempty"`
}

func (x *InstalledLibrary) Reset() {
	*x = InstalledLibrary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_lib_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstalledLibrary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstalledLibrary) ProtoMessage() {}

func (x *InstalledLibrary) ProtoReflect() protoreflect.Message {
	mi := &file_commands_lib_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstalledLibrary.ProtoReflect.Descriptor instead.
func (*InstalledLibrary) Descriptor() ([]byte, []int) {
	return file_commands_lib_proto_rawDescGZIP(), []int{19}
}

func (x *InstalledLibrary) GetLibrary() *Library {
	if x != nil {
		return x.Library
	}
	return nil
}

func (x *InstalledLibrary) GetRelease() *LibraryRelease {
	if x != nil {
		return x.Release
	}
	return nil
}

type Library struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The library's directory name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Value of the `author` field in library.properties.
	Author string `protobuf:"bytes,2,opt,name=author,proto3" json:"author,omitempty"`
	// Value of the `maintainer` field in library.properties.
	Maintainer string `protobuf:"bytes,3,opt,name=maintainer,proto3" json:"maintainer,omitempty"`
	// Value of the `sentence` field in library.properties.
	Sentence string `protobuf:"bytes,4,opt,name=sentence,proto3" json:"sentence,omitempty"`
	// Value of the `paragraph` field in library.properties.
	Paragraph string `protobuf:"bytes,5,opt,name=paragraph,proto3" json:"paragraph,omitempty"`
	// Value of the `url` field in library.properties.
	Website string `protobuf:"bytes,6,opt,name=website,proto3" json:"website,omitempty"`
	// Value of the `category` field in library.properties.
	Category string `protobuf:"bytes,7,opt,name=category,proto3" json:"category,omitempty"`
	// Value of the `architectures` field in library.properties.
	Architectures []string `protobuf:"bytes,8,rep,name=architectures,proto3" json:"architectures,omitempty"`
	// The type categories of the library. Possible values: `Arduino`,
	// `Partner`, `Recommended`, `Contributed`, `Retired`.
	Types []string `protobuf:"bytes,9,rep,name=types,proto3" json:"types,omitempty"`
	// The path of the library directory.
	InstallDir string `protobuf:"bytes,10,opt,name=install_dir,json=installDir,proto3" json:"install_dir,omitempty"`
	// The location of the library's source files.
	SourceDir string `protobuf:"bytes,11,opt,name=source_dir,json=sourceDir,proto3" json:"source_dir,omitempty"`
	// The location of the library's `utility` directory.
	UtilityDir string `protobuf:"bytes,12,opt,name=utility_dir,json=utilityDir,proto3" json:"utility_dir,omitempty"`
	// If `location` is `platform_builtin` or `referenced_platform_builtin`, the
	// identifying string for the platform containing the library
	// (e.g., `arduino:avr@1.8.2`).
	ContainerPlatform string `protobuf:"bytes,14,opt,name=container_platform,json=containerPlatform,proto3" json:"container_platform,omitempty"`
	// Value of the `name` field in library.properties.
	RealName string `protobuf:"bytes,16,opt,name=real_name,json=realName,proto3" json:"real_name,omitempty"`
	// Value of the `dot_a_linkage` field in library.properties.
	DotALinkage bool `protobuf:"varint,17,opt,name=dot_a_linkage,json=dotALinkage,proto3" json:"dot_a_linkage,omitempty"`
	// Value of the `precompiled` field in library.properties.
	Precompiled bool `protobuf:"varint,18,opt,name=precompiled,proto3" json:"precompiled,omitempty"`
	// Value of the `ldflags` field in library.properties.
	LdFlags string `protobuf:"bytes,19,opt,name=ld_flags,json=ldFlags,proto3" json:"ld_flags,omitempty"`
	// A library.properties file is not present in the library's root directory.
	IsLegacy bool `protobuf:"varint,20,opt,name=is_legacy,json=isLegacy,proto3" json:"is_legacy,omitempty"`
	// Value of the `version` field in library.properties.
	Version string `protobuf:"bytes,21,opt,name=version,proto3" json:"version,omitempty"`
	// Value of the `license` field in library.properties.
	License string `protobuf:"bytes,22,opt,name=license,proto3" json:"license,omitempty"`
	// The data from the library's library.properties file, including unused
	// fields.
	Properties map[string]string `protobuf:"bytes,23,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The location type of the library installation.
	Location LibraryLocation `protobuf:"varint,24,opt,name=location,proto3,enum=cc.arduino.cli.commands.LibraryLocation" json:"location,omitempty"`
	// The library format type.
	Layout LibraryLayout `protobuf:"varint,25,opt,name=layout,proto3,enum=cc.arduino.cli.commands.LibraryLayout" json:"layout,omitempty"`
	// The example sketches provided by the library
	Examples []string `protobuf:"bytes,26,rep,name=examples,proto3" json:"examples,omitempty"`
	// Value of the `includes` field in library.properties or, if missing, the list of
	// include files available on the library source root directory.
	ProvidesIncludes []string `protobuf:"bytes,27,rep,name=provides_includes,json=providesIncludes,proto3" json:"provides_includes,omitempty"`
}

func (x *Library) Reset() {
	*x = Library{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_lib_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Library) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Library) ProtoMessage() {}

func (x *Library) ProtoReflect() protoreflect.Message {
	mi := &file_commands_lib_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Library.ProtoReflect.Descriptor instead.
func (*Library) Descriptor() ([]byte, []int) {
	return file_commands_lib_proto_rawDescGZIP(), []int{20}
}

func (x *Library) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Library) GetAuthor() string {
	if x != nil {
		return x.Author
	}
	return ""
}

func (x *Library) GetMaintainer() string {
	if x != nil {
		return x.Maintainer
	}
	return ""
}

func (x *Library) GetSentence() string {
	if x != nil {
		return x.Sentence
	}
	return ""
}

func (x *Library) GetParagraph() string {
	if x != nil {
		return x.Paragraph
	}
	return ""
}

func (x *Library) GetWebsite() string {
	if x != nil {
		return x.Website
	}
	return ""
}

func (x *Library) GetCategory() string {
	if x != nil {
		return x.Category
	}
	return ""
}

func (x *Library) GetArchitectures() []string {
	if x != nil {
		return x.Architectures
	}
	return nil
}

func (x *Library) GetTypes() []string {
	if x != nil {
		return x.Types
	}
	return nil
}

func (x *Library) GetInstallDir() string {
	if x != nil {
		return x.InstallDir
	}
	return ""
}

func (x *Library) GetSourceDir() string {
	if x != nil {
		return x.SourceDir
	}
	return ""
}

func (x *Library) GetUtilityDir() string {
	if x != nil {
		return x.UtilityDir
	}
	return ""
}

func (x *Library) GetContainerPlatform() string {
	if x != nil {
		return x.ContainerPlatform
	}
	return ""
}

func (x *Library) GetRealName() string {
	if x != nil {
		return x.RealName
	}
	return ""
}

func (x *Library) GetDotALinkage() bool {
	if x != nil {
		return x.DotALinkage
	}
	return false
}

func (x *Library) GetPrecompiled() bool {
	if x != nil {
		return x.Precompiled
	}
	return false
}

func (x *Library) GetLdFlags() string {
	if x != nil {
		return x.LdFlags
	}
	return ""
}

func (x *Library) GetIsLegacy() bool {
	if x != nil {
		return x.IsLegacy
	}
	return false
}

func (x *Library) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Library) GetLicense() string {
	if x != nil {
		return x.License
	}
	return ""
}

func (x *Library) GetProperties() map[string]string {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *Library) GetLocation() LibraryLocation {
	if x != nil {
		return x.Location
	}
	return LibraryLocation_ide_builtin
}

func (x *Library) GetLayout() LibraryLayout {
	if x != nil {
		return x.Layout
	}
	return LibraryLayout_flat_layout
}

func (x *Library) GetExamples() []string {
	if x != nil {
		return x.Examples
	}
	return nil
}

func (x *Library) GetProvidesIncludes() []string {
	if x != nil {
		return x.ProvidesIncludes
	}
	return nil
}

var File_commands_lib_proto protoreflect.FileDescriptor

var file_commands_lib_proto_rawDesc = []byte{
	0x0a, 0x12, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x6c, 0x69, 0x62, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x1a, 0x15, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x81, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79,
	0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x71, 0x12, 0x3d, 0x0a, 0x08, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18,
	0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x5c, 0x0a, 0x13, 0x4c, 0x69, 0x62, 0x72,
	0x61, 0x72, 0x79, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x73, 0x70, 0x12,
	0x45, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63,
	0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x44, 0x6f, 0x77, 0x6e,
	0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x08, 0x70, 0x72,
	0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x22, 0x80, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x62, 0x72, 0x61,
	0x72, 0x79, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x12, 0x3d, 0x0a, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xa7, 0x01, 0x0a, 0x12, 0x4c, 0x69,
	0x62, 0x72, 0x61, 0x72, 0x79, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70,
	0x12, 0x45, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e,
	0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x44, 0x6f, 0x77,
	0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x08, 0x70,
	0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x4a, 0x0a, 0x0d, 0x74, 0x61, 0x73, 0x6b, 0x5f,
	0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x0c, 0x74, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x22, 0x82, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x55,
	0x6e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x12, 0x3d, 0x0a, 0x08, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18,
	0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x62, 0x0a, 0x14, 0x4c, 0x69, 0x62, 0x72,
	0x61, 0x72, 0x79, 0x55, 0x6e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70,
	0x12, 0x4a, 0x0a, 0x0d, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64,
	0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x0c,
	0x74, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x22, 0x55, 0x0a, 0x14,
	0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x41, 0x6c,
	0x6c, 0x52, 0x65, 0x71, 0x12, 0x3d, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75,
	0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73,
	0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x22, 0xaa, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x55,
	0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x12, 0x45, 0x0a,
	0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f,
	0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x12, 0x4a, 0x0a, 0x0d, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x70, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x63, 0x63,
	0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x52, 0x0c, 0x74, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x22, 0x8c, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x52, 0x65, 0x73, 0x6f,
	0x6c, 0x76, 0x65, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x12, 0x3d, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0x76, 0x0a, 0x1e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76,
	0x65, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x12, 0x54, 0x0a, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64,
	0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65,
	0x6e, 0x63, 0x79, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e,
	0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x22, 0x83, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x62, 0x72,
	0x61, 0x72, 0x79, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x0f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
	0x64, 0x12, 0x2a, 0x0a, 0x10, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6c, 0x6c, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x22, 0x67, 0x0a,
	0x10, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65,
	0x71, 0x12, 0x3d, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x22, 0xa1, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x62, 0x72, 0x61,
	0x72, 0x79, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x12, 0x46, 0x0a, 0x09,
	0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x65, 0x64, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x52, 0x09, 0x6c, 0x69, 0x62, 0x72, 0x61,
	0x72, 0x69, 0x65, 0x73, 0x12, 0x44, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x4c,
	0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0xa0, 0x02, 0x0a, 0x0f, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x65, 0x64, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x52, 0x0a, 0x08, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x65, 0x64, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x2e, 0x52,
	0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x72, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x12, 0x3f, 0x0a, 0x06, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75,
	0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73,
	0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52,
	0x06, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x1a, 0x64, 0x0a, 0x0d, 0x52, 0x65, 0x6c, 0x65, 0x61,
	0x73, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3d, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x52, 0x65, 0x6c, 0x65, 0x61,
	0x73, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xee, 0x03,
	0x0a, 0x0e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65,
	0x12, 0x16, 0x0a, 0x06, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x0a, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x1c,
	0x0a, 0x09, 0x70, 0x61, 0x72, 0x61, 0x67, 0x72, 0x61, 0x70, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x61, 0x72, 0x61, 0x67, 0x72, 0x61, 0x70, 0x68, 0x12, 0x18, 0x0a, 0x07,
	0x77, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x77,
	0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f,
	0x72, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f,
	0x72, 0x79, 0x12, 0x24, 0x0a, 0x0d, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x72, 0x63, 0x68, 0x69,
	0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x79, 0x70, 0x65,
	0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x74, 0x79, 0x70, 0x65, 0x73, 0x12, 0x47,
	0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63,
	0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x44, 0x6f, 0x77, 0x6e,
	0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x09, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x6c, 0x69, 0x63, 0x65, 0x6e,
	0x73, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73,
	0x65, 0x12, 0x2b, 0x0a, 0x11, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x73, 0x5f, 0x69, 0x6e,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x70, 0x72,
	0x6f, 0x76, 0x69, 0x64, 0x65, 0x73, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x73, 0x12, 0x4e,
	0x0a, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x0d,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x4c,
	0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79,
	0x52, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x22, 0x56,
	0x0a, 0x11, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65,
	0x6e, 0x63, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x11, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x22, 0x9c, 0x01, 0x0a, 0x10, 0x44, 0x6f, 0x77, 0x6e, 0x6c,
	0x6f, 0x61, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75,
	0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x28, 0x0a,
	0x0f, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x66,
	0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x68, 0x65, 0x63, 0x6b,
	0x73, 0x75, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x68, 0x65, 0x63, 0x6b,
	0x73, 0x75, 0x6d, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x61, 0x63, 0x68, 0x65,
	0x70, 0x61, 0x74, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x61, 0x63, 0x68,
	0x65, 0x70, 0x61, 0x74, 0x68, 0x22, 0xa7, 0x01, 0x0a, 0x0e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72,
	0x79, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x12, 0x3d, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x63, 0x63, 0x2e,
	0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x73, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x61, 0x6c, 0x6c, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x03, 0x61, 0x6c, 0x6c, 0x12, 0x1c, 0x0a, 0x09, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x66,
	0x71, 0x62, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x66, 0x71, 0x62, 0x6e, 0x22,
	0x69, 0x0a, 0x0f, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x12, 0x56, 0x0a, 0x11, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x5f,
	0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65,
	0x64, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x52, 0x10, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c,
	0x6c, 0x65, 0x64, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x22, 0x91, 0x01, 0x0a, 0x10, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x12,
	0x3a, 0x0a, 0x07, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x20, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c,
	0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61,
	0x72, 0x79, 0x52, 0x07, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x12, 0x41, 0x0a, 0x07, 0x72,
	0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x63,
	0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x52, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x07, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x22, 0xc0,
	0x07, 0x0a, 0x07, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16,
	0x0a, 0x06, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x12, 0x1e, 0x0a, 0x0a, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x61, 0x69, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x6e,
	0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x6e,
	0x63, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x61, 0x67, 0x72, 0x61, 0x70, 0x68, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x72, 0x61, 0x67, 0x72, 0x61, 0x70, 0x68,
	0x12, 0x18, 0x0a, 0x07, 0x77, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x77, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x61,
	0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x61,
	0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x24, 0x0a, 0x0d, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74,
	0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x61,
	0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x14, 0x0a, 0x05,
	0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x74, 0x79, 0x70,
	0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x5f, 0x64, 0x69,
	0x72, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c,
	0x44, 0x69, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x64, 0x69,
	0x72, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44,
	0x69, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x64, 0x69,
	0x72, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x44, 0x69, 0x72, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x5f, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x11, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x65, 0x61, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x22, 0x0a, 0x0d, 0x64, 0x6f, 0x74, 0x5f, 0x61, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x61, 0x67, 0x65,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x64, 0x6f, 0x74, 0x41, 0x4c, 0x69, 0x6e, 0x6b,
	0x61, 0x67, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x70, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c,
	0x65, 0x64, 0x18, 0x12, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x70, 0x72, 0x65, 0x63, 0x6f, 0x6d,
	0x70, 0x69, 0x6c, 0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6c, 0x64, 0x5f, 0x66, 0x6c, 0x61, 0x67,
	0x73, 0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6c, 0x64, 0x46, 0x6c, 0x61, 0x67, 0x73,
	0x12, 0x1b, 0x0a, 0x09, 0x69, 0x73, 0x5f, 0x6c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x18, 0x14, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x08, 0x69, 0x73, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x12, 0x18, 0x0a,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x15, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x6c, 0x69, 0x63, 0x65, 0x6e,
	0x73, 0x65, 0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73,
	0x65, 0x12, 0x50, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18,
	0x17, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69,
	0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e,
	0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x12, 0x44, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x18, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69,
	0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e,
	0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x0a, 0x06, 0x6c, 0x61, 0x79,
	0x6f, 0x75, 0x74, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x4c, 0x61, 0x79, 0x6f, 0x75,
	0x74, 0x52, 0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x65, 0x78, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x73, 0x18, 0x1a, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x65, 0x78, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65,
	0x73, 0x5f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x73, 0x18, 0x1b, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x10, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x73, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x64,
	0x65, 0x73, 0x1a, 0x3d, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x2a, 0x2e, 0x0a, 0x13, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x0a, 0x0a, 0x06, 0x66, 0x61, 0x69, 0x6c,
	0x65, 0x64, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x10,
	0x01, 0x2a, 0x36, 0x0a, 0x0d, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x4c, 0x61, 0x79, 0x6f,
	0x75, 0x74, 0x12, 0x0f, 0x0a, 0x0b, 0x66, 0x6c, 0x61, 0x74, 0x5f, 0x6c, 0x61, 0x79, 0x6f, 0x75,
	0x74, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x72, 0x65, 0x63, 0x75, 0x72, 0x73, 0x69, 0x76, 0x65,
	0x5f, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x10, 0x01, 0x2a, 0x63, 0x0a, 0x0f, 0x4c, 0x69, 0x62,
	0x72, 0x61, 0x72, 0x79, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0f, 0x0a, 0x0b,
	0x69, 0x64, 0x65, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x74, 0x69, 0x6e, 0x10, 0x00, 0x12, 0x08, 0x0a,
	0x04, 0x75, 0x73, 0x65, 0x72, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x74, 0x69, 0x6e, 0x10, 0x02, 0x12, 0x1f, 0x0a,
	0x1b, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x62, 0x75, 0x69, 0x6c, 0x74, 0x69, 0x6e, 0x10, 0x03, 0x42, 0x2d,
	0x5a, 0x2b, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x72, 0x64,
	0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2d, 0x63, 0x6c, 0x69,
	0x2f, 0x72, 0x70, 0x63, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_commands_lib_proto_rawDescOnce sync.Once
	file_commands_lib_proto_rawDescData = file_commands_lib_proto_rawDesc
)

func file_commands_lib_proto_rawDescGZIP() []byte {
	file_commands_lib_proto_rawDescOnce.Do(func() {
		file_commands_lib_proto_rawDescData = protoimpl.X.CompressGZIP(file_commands_lib_proto_rawDescData)
	})
	return file_commands_lib_proto_rawDescData
}

var file_commands_lib_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_commands_lib_proto_msgTypes = make([]protoimpl.MessageInfo, 23)
var file_commands_lib_proto_goTypes = []interface{}{
	(LibrarySearchStatus)(0),               // 0: cc.arduino.cli.commands.LibrarySearchStatus
	(LibraryLayout)(0),                     // 1: cc.arduino.cli.commands.LibraryLayout
	(LibraryLocation)(0),                   // 2: cc.arduino.cli.commands.LibraryLocation
	(*LibraryDownloadReq)(nil),             // 3: cc.arduino.cli.commands.LibraryDownloadReq
	(*LibraryDownloadResp)(nil),            // 4: cc.arduino.cli.commands.LibraryDownloadResp
	(*LibraryInstallReq)(nil),              // 5: cc.arduino.cli.commands.LibraryInstallReq
	(*LibraryInstallResp)(nil),             // 6: cc.arduino.cli.commands.LibraryInstallResp
	(*LibraryUninstallReq)(nil),            // 7: cc.arduino.cli.commands.LibraryUninstallReq
	(*LibraryUninstallResp)(nil),           // 8: cc.arduino.cli.commands.LibraryUninstallResp
	(*LibraryUpgradeAllReq)(nil),           // 9: cc.arduino.cli.commands.LibraryUpgradeAllReq
	(*LibraryUpgradeAllResp)(nil),          // 10: cc.arduino.cli.commands.LibraryUpgradeAllResp
	(*LibraryResolveDependenciesReq)(nil),  // 11: cc.arduino.cli.commands.LibraryResolveDependenciesReq
	(*LibraryResolveDependenciesResp)(nil), // 12: cc.arduino.cli.commands.LibraryResolveDependenciesResp
	(*LibraryDependencyStatus)(nil),        // 13: cc.arduino.cli.commands.LibraryDependencyStatus
	(*LibrarySearchReq)(nil),               // 14: cc.arduino.cli.commands.LibrarySearchReq
	(*LibrarySearchResp)(nil),              // 15: cc.arduino.cli.commands.LibrarySearchResp
	(*SearchedLibrary)(nil),                // 16: cc.arduino.cli.commands.SearchedLibrary
	(*LibraryRelease)(nil),                 // 17: cc.arduino.cli.commands.LibraryRelease
	(*LibraryDependency)(nil),              // 18: cc.arduino.cli.commands.LibraryDependency
	(*DownloadResource)(nil),               // 19: cc.arduino.cli.commands.DownloadResource
	(*LibraryListReq)(nil),                 // 20: cc.arduino.cli.commands.LibraryListReq
	(*LibraryListResp)(nil),                // 21: cc.arduino.cli.commands.LibraryListResp
	(*InstalledLibrary)(nil),               // 22: cc.arduino.cli.commands.InstalledLibrary
	(*Library)(nil),                        // 23: cc.arduino.cli.commands.Library
	nil,                                    // 24: cc.arduino.cli.commands.SearchedLibrary.ReleasesEntry
	nil,                                    // 25: cc.arduino.cli.commands.Library.PropertiesEntry
	(*Instance)(nil),                       // 26: cc.arduino.cli.commands.Instance
	(*DownloadProgress)(nil),               // 27: cc.arduino.cli.commands.DownloadProgress
	(*TaskProgress)(nil),                   // 28: cc.arduino.cli.commands.TaskProgress
}
var file_commands_lib_proto_depIdxs = []int32{
	26, // 0: cc.arduino.cli.commands.LibraryDownloadReq.instance:type_name -> cc.arduino.cli.commands.Instance
	27, // 1: cc.arduino.cli.commands.LibraryDownloadResp.progress:type_name -> cc.arduino.cli.commands.DownloadProgress
	26, // 2: cc.arduino.cli.commands.LibraryInstallReq.instance:type_name -> cc.arduino.cli.commands.Instance
	27, // 3: cc.arduino.cli.commands.LibraryInstallResp.progress:type_name -> cc.arduino.cli.commands.DownloadProgress
	28, // 4: cc.arduino.cli.commands.LibraryInstallResp.task_progress:type_name -> cc.arduino.cli.commands.TaskProgress
	26, // 5: cc.arduino.cli.commands.LibraryUninstallReq.instance:type_name -> cc.arduino.cli.commands.Instance
	28, // 6: cc.arduino.cli.commands.LibraryUninstallResp.task_progress:type_name -> cc.arduino.cli.commands.TaskProgress
	26, // 7: cc.arduino.cli.commands.LibraryUpgradeAllReq.instance:type_name -> cc.arduino.cli.commands.Instance
	27, // 8: cc.arduino.cli.commands.LibraryUpgradeAllResp.progress:type_name -> cc.arduino.cli.commands.DownloadProgress
	28, // 9: cc.arduino.cli.commands.LibraryUpgradeAllResp.task_progress:type_name -> cc.arduino.cli.commands.TaskProgress
	26, // 10: cc.arduino.cli.commands.LibraryResolveDependenciesReq.instance:type_name -> cc.arduino.cli.commands.Instance
	13, // 11: cc.arduino.cli.commands.LibraryResolveDependenciesResp.dependencies:type_name -> cc.arduino.cli.commands.LibraryDependencyStatus
	26, // 12: cc.arduino.cli.commands.LibrarySearchReq.instance:type_name -> cc.arduino.cli.commands.Instance
	16, // 13: cc.arduino.cli.commands.LibrarySearchResp.libraries:type_name -> cc.arduino.cli.commands.SearchedLibrary
	0,  // 14: cc.arduino.cli.commands.LibrarySearchResp.status:type_name -> cc.arduino.cli.commands.LibrarySearchStatus
	24, // 15: cc.arduino.cli.commands.SearchedLibrary.releases:type_name -> cc.arduino.cli.commands.SearchedLibrary.ReleasesEntry
	17, // 16: cc.arduino.cli.commands.SearchedLibrary.latest:type_name -> cc.arduino.cli.commands.LibraryRelease
	19, // 17: cc.arduino.cli.commands.LibraryRelease.resources:type_name -> cc.arduino.cli.commands.DownloadResource
	18, // 18: cc.arduino.cli.commands.LibraryRelease.dependencies:type_name -> cc.arduino.cli.commands.LibraryDependency
	26, // 19: cc.arduino.cli.commands.LibraryListReq.instance:type_name -> cc.arduino.cli.commands.Instance
	22, // 20: cc.arduino.cli.commands.LibraryListResp.installed_library:type_name -> cc.arduino.cli.commands.InstalledLibrary
	23, // 21: cc.arduino.cli.commands.InstalledLibrary.library:type_name -> cc.arduino.cli.commands.Library
	17, // 22: cc.arduino.cli.commands.InstalledLibrary.release:type_name -> cc.arduino.cli.commands.LibraryRelease
	25, // 23: cc.arduino.cli.commands.Library.properties:type_name -> cc.arduino.cli.commands.Library.PropertiesEntry
	2,  // 24: cc.arduino.cli.commands.Library.location:type_name -> cc.arduino.cli.commands.LibraryLocation
	1,  // 25: cc.arduino.cli.commands.Library.layout:type_name -> cc.arduino.cli.commands.LibraryLayout
	17, // 26: cc.arduino.cli.commands.SearchedLibrary.ReleasesEntry.value:type_name -> cc.arduino.cli.commands.LibraryRelease
	27, // [27:27] is the sub-list for method output_type
	27, // [27:27] is the sub-list for method input_type
	27, // [27:27] is the sub-list for extension type_name
	27, // [27:27] is the sub-list for extension extendee
	0,  // [0:27] is the sub-list for field type_name
}

func init() { file_commands_lib_proto_init() }
func file_commands_lib_proto_init() {
	if File_commands_lib_proto != nil {
		return
	}
	file_commands_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_commands_lib_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LibraryDownloadReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_lib_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LibraryDownloadResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_lib_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LibraryInstallReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_lib_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LibraryInstallResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_lib_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LibraryUninstallReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_lib_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LibraryUninstallResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_lib_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LibraryUpgradeAllReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_lib_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LibraryUpgradeAllResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_lib_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LibraryResolveDependenciesReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_lib_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LibraryResolveDependenciesResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_lib_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LibraryDependencyStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_lib_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LibrarySearchReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_lib_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LibrarySearchResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_lib_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchedLibrary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_lib_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LibraryRelease); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_lib_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LibraryDependency); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_lib_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DownloadResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_lib_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LibraryListReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_lib_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LibraryListResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_lib_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstalledLibrary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_lib_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Library); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_commands_lib_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   23,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_commands_lib_proto_goTypes,
		DependencyIndexes: file_commands_lib_proto_depIdxs,
		EnumInfos:         file_commands_lib_proto_enumTypes,
		MessageInfos:      file_commands_lib_proto_msgTypes,
	}.Build()
	File_commands_lib_proto = out.File
	file_commands_lib_proto_rawDesc = nil
	file_commands_lib_proto_goTypes = nil
	file_commands_lib_proto_depIdxs = nil
}
