// This file is part of arduino-cli.
//
// Copyright 2020 ARDUINO SA (http://www.arduino.cc/)
//
// This software is released under the GNU General Public License version 3,
// which covers the main part of arduino-cli.
// The terms of this license can be found at:
// https://www.gnu.org/licenses/gpl-3.0.en.html
//
// You can be released from the requirements of the above licenses by purchasing
// a commercial license. Buying such a license is mandatory if you want to
// modify or otherwise use the software for commercial activities involving the
// Arduino software without disclosing the source code of your own applications.
// To purchase a commercial license, send an email to license@arduino.cc.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.11.3
// source: commands/core.proto

package commands

import (
	proto "github.com/golang/protobuf/proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

type PlatformInstallReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Vendor name of the platform (e.g., `arduino`).
	PlatformPackage string `protobuf:"bytes,2,opt,name=platform_package,json=platformPackage,proto3" json:"platform_package,omitempty"`
	// Architecture name of the platform (e.g., `avr`).
	Architecture string `protobuf:"bytes,3,opt,name=architecture,proto3" json:"architecture,omitempty"`
	// Platform version to install.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	// Set to true to not run (eventual) post install scripts for trusted platforms
	SkipPostInstall bool `protobuf:"varint,5,opt,name=skipPostInstall,proto3" json:"skipPostInstall,omitempty"`
}

func (x *PlatformInstallReq) Reset() {
	*x = PlatformInstallReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_core_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformInstallReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformInstallReq) ProtoMessage() {}

func (x *PlatformInstallReq) ProtoReflect() protoreflect.Message {
	mi := &file_commands_core_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformInstallReq.ProtoReflect.Descriptor instead.
func (*PlatformInstallReq) Descriptor() ([]byte, []int) {
	return file_commands_core_proto_rawDescGZIP(), []int{0}
}

func (x *PlatformInstallReq) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *PlatformInstallReq) GetPlatformPackage() string {
	if x != nil {
		return x.PlatformPackage
	}
	return ""
}

func (x *PlatformInstallReq) GetArchitecture() string {
	if x != nil {
		return x.Architecture
	}
	return ""
}

func (x *PlatformInstallReq) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *PlatformInstallReq) GetSkipPostInstall() bool {
	if x != nil {
		return x.SkipPostInstall
	}
	return false
}

type PlatformInstallResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Progress of the downloads of the platform and tool files.
	Progress *DownloadProgress `protobuf:"bytes,1,opt,name=progress,proto3" json:"progress,omitempty"`
	// Description of the current stage of the installation.
	TaskProgress *TaskProgress `protobuf:"bytes,2,opt,name=task_progress,json=taskProgress,proto3" json:"task_progress,omitempty"`
}

func (x *PlatformInstallResp) Reset() {
	*x = PlatformInstallResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_core_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformInstallResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformInstallResp) ProtoMessage() {}

func (x *PlatformInstallResp) ProtoReflect() protoreflect.Message {
	mi := &file_commands_core_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformInstallResp.ProtoReflect.Descriptor instead.
func (*PlatformInstallResp) Descriptor() ([]byte, []int) {
	return file_commands_core_proto_rawDescGZIP(), []int{1}
}

func (x *PlatformInstallResp) GetProgress() *DownloadProgress {
	if x != nil {
		return x.Progress
	}
	return nil
}

func (x *PlatformInstallResp) GetTaskProgress() *TaskProgress {
	if x != nil {
		return x.TaskProgress
	}
	return nil
}

type PlatformDownloadReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance        *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	PlatformPackage string    `protobuf:"bytes,2,opt,name=platform_package,json=platformPackage,proto3" json:"platform_package,omitempty"`
	// Architecture name of the platform (e.g., `avr`).
	Architecture string `protobuf:"bytes,3,opt,name=architecture,proto3" json:"architecture,omitempty"`
	// Platform version to download.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *PlatformDownloadReq) Reset() {
	*x = PlatformDownloadReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_core_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformDownloadReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformDownloadReq) ProtoMessage() {}

func (x *PlatformDownloadReq) ProtoReflect() protoreflect.Message {
	mi := &file_commands_core_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformDownloadReq.ProtoReflect.Descriptor instead.
func (*PlatformDownloadReq) Descriptor() ([]byte, []int) {
	return file_commands_core_proto_rawDescGZIP(), []int{2}
}

func (x *PlatformDownloadReq) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *PlatformDownloadReq) GetPlatformPackage() string {
	if x != nil {
		return x.PlatformPackage
	}
	return ""
}

func (x *PlatformDownloadReq) GetArchitecture() string {
	if x != nil {
		return x.Architecture
	}
	return ""
}

func (x *PlatformDownloadReq) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type PlatformDownloadResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Progress of the downloads of platform and tool files.
	Progress *DownloadProgress `protobuf:"bytes,1,opt,name=progress,proto3" json:"progress,omitempty"`
}

func (x *PlatformDownloadResp) Reset() {
	*x = PlatformDownloadResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_core_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformDownloadResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformDownloadResp) ProtoMessage() {}

func (x *PlatformDownloadResp) ProtoReflect() protoreflect.Message {
	mi := &file_commands_core_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformDownloadResp.ProtoReflect.Descriptor instead.
func (*PlatformDownloadResp) Descriptor() ([]byte, []int) {
	return file_commands_core_proto_rawDescGZIP(), []int{3}
}

func (x *PlatformDownloadResp) GetProgress() *DownloadProgress {
	if x != nil {
		return x.Progress
	}
	return nil
}

type PlatformUninstallReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Vendor name of the platform (e.g., `arduino`).
	PlatformPackage string `protobuf:"bytes,2,opt,name=platform_package,json=platformPackage,proto3" json:"platform_package,omitempty"`
	// Architecture name of the platform (e.g., `avr`).
	Architecture string `protobuf:"bytes,3,opt,name=architecture,proto3" json:"architecture,omitempty"`
}

func (x *PlatformUninstallReq) Reset() {
	*x = PlatformUninstallReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_core_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformUninstallReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformUninstallReq) ProtoMessage() {}

func (x *PlatformUninstallReq) ProtoReflect() protoreflect.Message {
	mi := &file_commands_core_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformUninstallReq.ProtoReflect.Descriptor instead.
func (*PlatformUninstallReq) Descriptor() ([]byte, []int) {
	return file_commands_core_proto_rawDescGZIP(), []int{4}
}

func (x *PlatformUninstallReq) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *PlatformUninstallReq) GetPlatformPackage() string {
	if x != nil {
		return x.PlatformPackage
	}
	return ""
}

func (x *PlatformUninstallReq) GetArchitecture() string {
	if x != nil {
		return x.Architecture
	}
	return ""
}

type PlatformUninstallResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Description of the current stage of the uninstall.
	TaskProgress *TaskProgress `protobuf:"bytes,1,opt,name=task_progress,json=taskProgress,proto3" json:"task_progress,omitempty"`
}

func (x *PlatformUninstallResp) Reset() {
	*x = PlatformUninstallResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_core_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformUninstallResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformUninstallResp) ProtoMessage() {}

func (x *PlatformUninstallResp) ProtoReflect() protoreflect.Message {
	mi := &file_commands_core_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformUninstallResp.ProtoReflect.Descriptor instead.
func (*PlatformUninstallResp) Descriptor() ([]byte, []int) {
	return file_commands_core_proto_rawDescGZIP(), []int{5}
}

func (x *PlatformUninstallResp) GetTaskProgress() *TaskProgress {
	if x != nil {
		return x.TaskProgress
	}
	return nil
}

type PlatformUpgradeReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Vendor name of the platform (e.g., `arduino`).
	PlatformPackage string `protobuf:"bytes,2,opt,name=platform_package,json=platformPackage,proto3" json:"platform_package,omitempty"`
	// Architecture name of the platform (e.g., `avr`).
	Architecture string `protobuf:"bytes,3,opt,name=architecture,proto3" json:"architecture,omitempty"`
	// Set to true to not run (eventual) post install scripts for trusted platforms
	SkipPostInstall bool `protobuf:"varint,4,opt,name=skipPostInstall,proto3" json:"skipPostInstall,omitempty"`
}

func (x *PlatformUpgradeReq) Reset() {
	*x = PlatformUpgradeReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_core_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformUpgradeReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformUpgradeReq) ProtoMessage() {}

func (x *PlatformUpgradeReq) ProtoReflect() protoreflect.Message {
	mi := &file_commands_core_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformUpgradeReq.ProtoReflect.Descriptor instead.
func (*PlatformUpgradeReq) Descriptor() ([]byte, []int) {
	return file_commands_core_proto_rawDescGZIP(), []int{6}
}

func (x *PlatformUpgradeReq) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *PlatformUpgradeReq) GetPlatformPackage() string {
	if x != nil {
		return x.PlatformPackage
	}
	return ""
}

func (x *PlatformUpgradeReq) GetArchitecture() string {
	if x != nil {
		return x.Architecture
	}
	return ""
}

func (x *PlatformUpgradeReq) GetSkipPostInstall() bool {
	if x != nil {
		return x.SkipPostInstall
	}
	return false
}

type PlatformUpgradeResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Progress of the downloads of the platform and tool files.
	Progress *DownloadProgress `protobuf:"bytes,1,opt,name=progress,proto3" json:"progress,omitempty"`
	// Description of the current stage of the upgrade.
	TaskProgress *TaskProgress `protobuf:"bytes,2,opt,name=task_progress,json=taskProgress,proto3" json:"task_progress,omitempty"`
}

func (x *PlatformUpgradeResp) Reset() {
	*x = PlatformUpgradeResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_core_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformUpgradeResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformUpgradeResp) ProtoMessage() {}

func (x *PlatformUpgradeResp) ProtoReflect() protoreflect.Message {
	mi := &file_commands_core_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformUpgradeResp.ProtoReflect.Descriptor instead.
func (*PlatformUpgradeResp) Descriptor() ([]byte, []int) {
	return file_commands_core_proto_rawDescGZIP(), []int{7}
}

func (x *PlatformUpgradeResp) GetProgress() *DownloadProgress {
	if x != nil {
		return x.Progress
	}
	return nil
}

func (x *PlatformUpgradeResp) GetTaskProgress() *TaskProgress {
	if x != nil {
		return x.TaskProgress
	}
	return nil
}

type PlatformSearchReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Keywords for the search.
	SearchArgs string `protobuf:"bytes,2,opt,name=search_args,json=searchArgs,proto3" json:"search_args,omitempty"`
	// Whether to show all available versions. `false` causes only the newest
	// versions of the cores to be listed in the search results.
	AllVersions bool `protobuf:"varint,3,opt,name=all_versions,json=allVersions,proto3" json:"all_versions,omitempty"`
}

func (x *PlatformSearchReq) Reset() {
	*x = PlatformSearchReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_core_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformSearchReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformSearchReq) ProtoMessage() {}

func (x *PlatformSearchReq) ProtoReflect() protoreflect.Message {
	mi := &file_commands_core_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformSearchReq.ProtoReflect.Descriptor instead.
func (*PlatformSearchReq) Descriptor() ([]byte, []int) {
	return file_commands_core_proto_rawDescGZIP(), []int{8}
}

func (x *PlatformSearchReq) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *PlatformSearchReq) GetSearchArgs() string {
	if x != nil {
		return x.SearchArgs
	}
	return ""
}

func (x *PlatformSearchReq) GetAllVersions() bool {
	if x != nil {
		return x.AllVersions
	}
	return false
}

type PlatformSearchResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results of the search.
	SearchOutput []*Platform `protobuf:"bytes,1,rep,name=search_output,json=searchOutput,proto3" json:"search_output,omitempty"`
}

func (x *PlatformSearchResp) Reset() {
	*x = PlatformSearchResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_core_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformSearchResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformSearchResp) ProtoMessage() {}

func (x *PlatformSearchResp) ProtoReflect() protoreflect.Message {
	mi := &file_commands_core_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformSearchResp.ProtoReflect.Descriptor instead.
func (*PlatformSearchResp) Descriptor() ([]byte, []int) {
	return file_commands_core_proto_rawDescGZIP(), []int{9}
}

func (x *PlatformSearchResp) GetSearchOutput() []*Platform {
	if x != nil {
		return x.SearchOutput
	}
	return nil
}

type PlatformListReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Set to true to only list platforms which have a newer version available
	// than the one currently installed.
	UpdatableOnly bool `protobuf:"varint,2,opt,name=updatable_only,json=updatableOnly,proto3" json:"updatable_only,omitempty"`
}

func (x *PlatformListReq) Reset() {
	*x = PlatformListReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_core_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformListReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformListReq) ProtoMessage() {}

func (x *PlatformListReq) ProtoReflect() protoreflect.Message {
	mi := &file_commands_core_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformListReq.ProtoReflect.Descriptor instead.
func (*PlatformListReq) Descriptor() ([]byte, []int) {
	return file_commands_core_proto_rawDescGZIP(), []int{10}
}

func (x *PlatformListReq) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *PlatformListReq) GetUpdatableOnly() bool {
	if x != nil {
		return x.UpdatableOnly
	}
	return false
}

type PlatformListResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The installed platforms.
	InstalledPlatform []*Platform `protobuf:"bytes,1,rep,name=installed_platform,json=installedPlatform,proto3" json:"installed_platform,omitempty"`
}

func (x *PlatformListResp) Reset() {
	*x = PlatformListResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_core_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlatformListResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlatformListResp) ProtoMessage() {}

func (x *PlatformListResp) ProtoReflect() protoreflect.Message {
	mi := &file_commands_core_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlatformListResp.ProtoReflect.Descriptor instead.
func (*PlatformListResp) Descriptor() ([]byte, []int) {
	return file_commands_core_proto_rawDescGZIP(), []int{11}
}

func (x *PlatformListResp) GetInstalledPlatform() []*Platform {
	if x != nil {
		return x.InstalledPlatform
	}
	return nil
}

type Platform struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Platform ID (e.g., `arduino:avr`).
	ID string `protobuf:"bytes,1,opt,name=ID,proto3" json:"ID,omitempty"`
	// Version of the platform.
	Installed string `protobuf:"bytes,2,opt,name=Installed,proto3" json:"Installed,omitempty"`
	// Newest available version of the platform.
	Latest string `protobuf:"bytes,3,opt,name=Latest,proto3" json:"Latest,omitempty"`
	// Name used to identify the platform to humans (e.g., "Arduino AVR Boards").
	Name string `protobuf:"bytes,4,opt,name=Name,proto3" json:"Name,omitempty"`
	// Maintainer of the platform's package.
	Maintainer string `protobuf:"bytes,5,opt,name=Maintainer,proto3" json:"Maintainer,omitempty"`
	// A URL provided by the author of the platform's package, intended to point
	// to their website.
	Website string `protobuf:"bytes,6,opt,name=Website,proto3" json:"Website,omitempty"`
	// Email of the maintainer of the platform's package.
	Email string `protobuf:"bytes,7,opt,name=Email,proto3" json:"Email,omitempty"`
	// List of boards provided by the platform. If the platform is installed,
	// this is the boards listed in the platform's boards.txt. If the platform is
	// not installed, this is an arbitrary list of board names provided by the
	// platform author for display and may not match boards.txt.
	Boards []*Board `protobuf:"bytes,8,rep,name=Boards,proto3" json:"Boards,omitempty"`
}

func (x *Platform) Reset() {
	*x = Platform{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_core_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Platform) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Platform) ProtoMessage() {}

func (x *Platform) ProtoReflect() protoreflect.Message {
	mi := &file_commands_core_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Platform.ProtoReflect.Descriptor instead.
func (*Platform) Descriptor() ([]byte, []int) {
	return file_commands_core_proto_rawDescGZIP(), []int{12}
}

func (x *Platform) GetID() string {
	if x != nil {
		return x.ID
	}
	return ""
}

func (x *Platform) GetInstalled() string {
	if x != nil {
		return x.Installed
	}
	return ""
}

func (x *Platform) GetLatest() string {
	if x != nil {
		return x.Latest
	}
	return ""
}

func (x *Platform) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Platform) GetMaintainer() string {
	if x != nil {
		return x.Maintainer
	}
	return ""
}

func (x *Platform) GetWebsite() string {
	if x != nil {
		return x.Website
	}
	return ""
}

func (x *Platform) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

func (x *Platform) GetBoards() []*Board {
	if x != nil {
		return x.Boards
	}
	return nil
}

type Board struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name used to identify the board to humans.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Fully qualified board name used to identify the board to machines. The FQBN
	// is only available for installed boards.
	Fqbn string `protobuf:"bytes,2,opt,name=fqbn,proto3" json:"fqbn,omitempty"`
}

func (x *Board) Reset() {
	*x = Board{}
	if protoimpl.UnsafeEnabled {
		mi := &file_commands_core_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Board) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Board) ProtoMessage() {}

func (x *Board) ProtoReflect() protoreflect.Message {
	mi := &file_commands_core_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Board.ProtoReflect.Descriptor instead.
func (*Board) Descriptor() ([]byte, []int) {
	return file_commands_core_proto_rawDescGZIP(), []int{13}
}

func (x *Board) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Board) GetFqbn() string {
	if x != nil {
		return x.Fqbn
	}
	return ""
}

var File_commands_core_proto protoreflect.FileDescriptor

var file_commands_core_proto_rawDesc = []byte{
	0x0a, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x1a, 0x15,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe6, 0x01, 0x0a, 0x12, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x12, 0x3d, 0x0a, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x50,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74,
	0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x72,
	0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0f, 0x73, 0x6b, 0x69, 0x70, 0x50, 0x6f, 0x73, 0x74,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x73,
	0x6b, 0x69, 0x70, 0x50, 0x6f, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x22, 0xa8,
	0x01, 0x0a, 0x13, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x12, 0x45, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72,
	0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x73, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x4a, 0x0a,
	0x0d, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x54,
	0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x0c, 0x74, 0x61, 0x73,
	0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x22, 0xbd, 0x01, 0x0a, 0x13, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65,
	0x71, 0x12, 0x3d, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x29, 0x0a, 0x10, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x70, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x61,
	0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12,
	0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x5d, 0x0a, 0x14, 0x50, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x73,
	0x70, 0x12, 0x45, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x44, 0x6f,
	0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x08,
	0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x22, 0xa4, 0x01, 0x0a, 0x14, 0x50, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x55, 0x6e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65,
	0x71, 0x12, 0x3d, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x29, 0x0a, 0x10, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x70, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x61,
	0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x22,
	0x63, 0x0a, 0x15, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x55, 0x6e, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x12, 0x4a, 0x0a, 0x0d, 0x74, 0x61, 0x73, 0x6b,
	0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x50, 0x72,
	0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x0c, 0x74, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x22, 0xcc, 0x01, 0x0a, 0x12, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52, 0x65, 0x71, 0x12, 0x3d, 0x0a, 0x08, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x50, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65,
	0x63, 0x74, 0x75, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x72, 0x63,
	0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x28, 0x0a, 0x0f, 0x73, 0x6b, 0x69,
	0x70, 0x50, 0x6f, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0f, 0x73, 0x6b, 0x69, 0x70, 0x50, 0x6f, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6c, 0x6c, 0x22, 0xa8, 0x01, 0x0a, 0x13, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52, 0x65, 0x73, 0x70, 0x12, 0x45, 0x0a, 0x08, 0x70,
	0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64,
	0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x12, 0x4a, 0x0a, 0x0d, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x52, 0x0c, 0x74, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x22, 0x96,
	0x01, 0x0a, 0x11, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x52, 0x65, 0x71, 0x12, 0x3d, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75,
	0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73,
	0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x61, 0x72,
	0x67, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x41, 0x72, 0x67, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x61, 0x6c, 0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x61, 0x6c, 0x6c, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x5c, 0x0a, 0x12, 0x50, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x12, 0x46, 0x0a,
	0x0d, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x50,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x52, 0x0c, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x22, 0x77, 0x0a, 0x0f, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x12, 0x3d, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x63, 0x63, 0x2e,
	0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x73, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0d, 0x75, 0x70, 0x64, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x64,
	0x0a, 0x10, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x12, 0x50, 0x0a, 0x12, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x5f,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x52, 0x11, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x50, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x22, 0xec, 0x01, 0x0a, 0x08, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x12, 0x0e, 0x0a, 0x02, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x49,
	0x44, 0x12, 0x1c, 0x0a, 0x09, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x12,
	0x16, 0x0a, 0x06, 0x4c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x4c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x4d,
	0x61, 0x69, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x57,
	0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x57, 0x65,
	0x62, 0x73, 0x69, 0x74, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x36, 0x0a, 0x06, 0x42,
	0x6f, 0x61, 0x72, 0x64, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x63, 0x63,
	0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x06, 0x42, 0x6f, 0x61,
	0x72, 0x64, 0x73, 0x22, 0x2f, 0x0a, 0x05, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x12, 0x0a, 0x04, 0x66, 0x71, 0x62, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x66, 0x71, 0x62, 0x6e, 0x42, 0x2d, 0x5a, 0x2b, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69,
	0x6e, 0x6f, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_commands_core_proto_rawDescOnce sync.Once
	file_commands_core_proto_rawDescData = file_commands_core_proto_rawDesc
)

func file_commands_core_proto_rawDescGZIP() []byte {
	file_commands_core_proto_rawDescOnce.Do(func() {
		file_commands_core_proto_rawDescData = protoimpl.X.CompressGZIP(file_commands_core_proto_rawDescData)
	})
	return file_commands_core_proto_rawDescData
}

var file_commands_core_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_commands_core_proto_goTypes = []interface{}{
	(*PlatformInstallReq)(nil),    // 0: cc.arduino.cli.commands.PlatformInstallReq
	(*PlatformInstallResp)(nil),   // 1: cc.arduino.cli.commands.PlatformInstallResp
	(*PlatformDownloadReq)(nil),   // 2: cc.arduino.cli.commands.PlatformDownloadReq
	(*PlatformDownloadResp)(nil),  // 3: cc.arduino.cli.commands.PlatformDownloadResp
	(*PlatformUninstallReq)(nil),  // 4: cc.arduino.cli.commands.PlatformUninstallReq
	(*PlatformUninstallResp)(nil), // 5: cc.arduino.cli.commands.PlatformUninstallResp
	(*PlatformUpgradeReq)(nil),    // 6: cc.arduino.cli.commands.PlatformUpgradeReq
	(*PlatformUpgradeResp)(nil),   // 7: cc.arduino.cli.commands.PlatformUpgradeResp
	(*PlatformSearchReq)(nil),     // 8: cc.arduino.cli.commands.PlatformSearchReq
	(*PlatformSearchResp)(nil),    // 9: cc.arduino.cli.commands.PlatformSearchResp
	(*PlatformListReq)(nil),       // 10: cc.arduino.cli.commands.PlatformListReq
	(*PlatformListResp)(nil),      // 11: cc.arduino.cli.commands.PlatformListResp
	(*Platform)(nil),              // 12: cc.arduino.cli.commands.Platform
	(*Board)(nil),                 // 13: cc.arduino.cli.commands.Board
	(*Instance)(nil),              // 14: cc.arduino.cli.commands.Instance
	(*DownloadProgress)(nil),      // 15: cc.arduino.cli.commands.DownloadProgress
	(*TaskProgress)(nil),          // 16: cc.arduino.cli.commands.TaskProgress
}
var file_commands_core_proto_depIdxs = []int32{
	14, // 0: cc.arduino.cli.commands.PlatformInstallReq.instance:type_name -> cc.arduino.cli.commands.Instance
	15, // 1: cc.arduino.cli.commands.PlatformInstallResp.progress:type_name -> cc.arduino.cli.commands.DownloadProgress
	16, // 2: cc.arduino.cli.commands.PlatformInstallResp.task_progress:type_name -> cc.arduino.cli.commands.TaskProgress
	14, // 3: cc.arduino.cli.commands.PlatformDownloadReq.instance:type_name -> cc.arduino.cli.commands.Instance
	15, // 4: cc.arduino.cli.commands.PlatformDownloadResp.progress:type_name -> cc.arduino.cli.commands.DownloadProgress
	14, // 5: cc.arduino.cli.commands.PlatformUninstallReq.instance:type_name -> cc.arduino.cli.commands.Instance
	16, // 6: cc.arduino.cli.commands.PlatformUninstallResp.task_progress:type_name -> cc.arduino.cli.commands.TaskProgress
	14, // 7: cc.arduino.cli.commands.PlatformUpgradeReq.instance:type_name -> cc.arduino.cli.commands.Instance
	15, // 8: cc.arduino.cli.commands.PlatformUpgradeResp.progress:type_name -> cc.arduino.cli.commands.DownloadProgress
	16, // 9: cc.arduino.cli.commands.PlatformUpgradeResp.task_progress:type_name -> cc.arduino.cli.commands.TaskProgress
	14, // 10: cc.arduino.cli.commands.PlatformSearchReq.instance:type_name -> cc.arduino.cli.commands.Instance
	12, // 11: cc.arduino.cli.commands.PlatformSearchResp.search_output:type_name -> cc.arduino.cli.commands.Platform
	14, // 12: cc.arduino.cli.commands.PlatformListReq.instance:type_name -> cc.arduino.cli.commands.Instance
	12, // 13: cc.arduino.cli.commands.PlatformListResp.installed_platform:type_name -> cc.arduino.cli.commands.Platform
	13, // 14: cc.arduino.cli.commands.Platform.Boards:type_name -> cc.arduino.cli.commands.Board
	15, // [15:15] is the sub-list for method output_type
	15, // [15:15] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_commands_core_proto_init() }
func file_commands_core_proto_init() {
	if File_commands_core_proto != nil {
		return
	}
	file_commands_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_commands_core_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformInstallReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_core_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformInstallResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_core_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformDownloadReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_core_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformDownloadResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_core_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformUninstallReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_core_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformUninstallResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_core_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformUpgradeReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_core_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformUpgradeResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_core_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformSearchReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_core_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformSearchResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_core_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformListReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_core_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlatformListResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_core_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Platform); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_commands_core_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Board); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_commands_core_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_commands_core_proto_goTypes,
		DependencyIndexes: file_commands_core_proto_depIdxs,
		MessageInfos:      file_commands_core_proto_msgTypes,
	}.Build()
	File_commands_core_proto = out.File
	file_commands_core_proto_rawDesc = nil
	file_commands_core_proto_goTypes = nil
	file_commands_core_proto_depIdxs = nil
}
