/*
Package grpc contains code generation logic to produce a server that serves gRPC
requests and a client that encode requests to and decode responses from a gRPC
server. It produces gRPC service definitions (.proto files) from Goa expressions
that were created by executing a design DSL. It then compiles the definition
using the protocol buffer compiler (protoc) using the Go gRPC plugin, and
generates code that hooks up the compiled protocol buffer types and gRPC code
with the types and code generated by Goa. It uses the "proto3" syntax to
generate gRPC service and protocol buffer message definitions.

In addition to the code generation logic, the grpc package contains:

    * A customizable server and client handler interface to handle unary and streaming RPCs.
    * Encoder and decoder interfaces to convert a protocol buffer type to a Goa type and vice versa.
    * Error handlers to encode and decode error responses.
    * Interceptors (a.k.a middlewares) to wrap additional functionality around unary and streaming RPCs.
*/
package grpc
