import { withPageAuthRequired } from '@auth0/nextjs-auth0'
import Layout from '../../components/layout'
import { User } from '../../interfaces'

type ProfileProps = {
  user: User
}

export default function Profile({ user }: ProfileProps) {
  return (
    <Layout user={user}>
      <h1>Profile</h1>

      <div>
        <h3>Profile (server rendered)</h3>
        <img src={user.picture} alt="user picture" />
        <p>nickname: {user.nickname}</p>
        <p>name: {user.name}</p>
      </div>
    </Layout>
  )
}

// Protected route, checking authentication status before rendering the page.(SSR)
// It's slower than a static page with client side authentication
export const getServerSideProps = withPageAuthRequired()
