import { useState } from 'react'
import { useChannel, usePresence } from '@ably-labs/react-hooks'
import type { Types } from 'ably'
import type { ProxyMessage, TextMessage } from '../types'

import Head from 'next/head'
import Image from 'next/image'
import styles from '../styles/Home.module.css'

export default function Home() {
  const [messages, setMessages] = useState<TextMessage[]>([])

  const [channel, ably] = useChannel(
    'some-channel-name',
    async (message: Types.Message) => {
      console.log('Received Ably message', message)
      setMessages((messages) => [...messages, message.data])
    }
  )

  const [presenceData, updateStatus] = usePresence('your-channel-name')

  const messageList = messages.map((message, index) => {
    return <li key={index}>{message.text}</li>
  })

  const presentClients = presenceData.map((msg, index) => (
    <li key={index}>
      {msg.clientId}: {msg.data}
    </li>
  ))

  return (
    <div className={styles.container}>
      <Head>
        <title>Create Next App</title>
        <meta name="description" content="Generated by create next app" />
        <link rel="icon" href="/favicon.ico" />
      </Head>

      <h1>Realtime Edge Messaging with Next and Ably</h1>
      <p>
        Use the buttons below to send and receive messages or to update your
        status.
      </p>

      <main className={styles.main}>
        <h2>Present Clients</h2>
        <button
          onClick={() => {
            updateStatus('hello')
          }}
        >
          Update status to hello
        </button>
        <ul>{presentClients}</ul>

        <h2>Ably Message Data</h2>
        <button
          className={styles.button}
          onClick={() => {
            const message: TextMessage = {
              text: `${ably.auth.clientId} sent a message`,
            }
            channel.publish('test-message', message)
          }}
        >
          Send A Message
        </button>
        <button
          className={styles.button}
          onClick={() => {
            const proxyMessage: ProxyMessage = {
              sender: `${ably.auth.clientId}`,
            }

            fetch('/api/send-message', {
              method: 'POST',
              headers: {
                'Content-Type': 'application/json',
              },
              body: JSON.stringify(proxyMessage),
            })
          }}
        >
          Send A Message From the Server
        </button>
        <ul>{messageList}</ul>
      </main>

      <footer className={styles.footer}>
        Powered by
        <a
          href="https://vercel.com?utm_source=create-next-app&utm_medium=default-template&utm_campaign=create-next-app"
          target="_blank"
          rel="noopener noreferrer"
        >
          <span>
            <Image
              src="/vercel.svg"
              alt="Vercel Logo"
              width={100}
              height={32}
            />
          </span>
        </a>
        and
        <a href="https://ably.com/">
          <img src="/ably.svg" alt="Ably Realtime" className={styles.logo} />
        </a>
      </footer>
    </div>
  )
}
