import Head from 'next/head'
import Image from 'next/image'
import React from 'react'

export default function Home() {
  return (
    <div className="global-container">
      <Head>
        <title>api.video sample app</title>
        <meta
          name="description"
          content="Generated by create next app & created by api.video"
        />
        <link rel="icon" href="/favicon.ico" />
      </Head>

      <header>
        <span>api.video sample app</span>
      </header>

      <main>
        <div className="texts-container">
          <p>
            Hey fellow dev! 👋 <br />
            In this basic sample app, you will find{' '}
            <a
              href="https://api.video"
              target="_blank"
              rel="noopener noreferrer"
            >
              api.video
            </a>{' '}
            features examples such as <a href="/uploader">video uploader</a>,{' '}
            <a href="/videos">videos list</a> and player components.
          </p>
          <p>
            api.video provides APIs and clients to handle all your video needs.
            <br />
            This app is built with the api.video{' '}
            <a
              href="https://github.com/apivideo/api.video-nodejs-client"
              target="_blank"
              rel="noopener noreferrer"
            >
              Node.js client
            </a>
            ,{' '}
            <a
              href="https://github.com/apivideo/api.video-typescript-uploader"
              target="_blank"
              rel="noopener noreferrer"
            >
              Typescript uploader
            </a>{' '}
            and{' '}
            <a
              target="_blank"
              rel="noopener noreferrer"
              href="https://github.com/apivideo/api.video-react-player"
            >
              React player component
            </a>
            .
          </p>
          <p>
            You can{' '}
            <a
              href="https://github.com/vercel/next.js/tree/canary/examples/with-apivideo"
              target="_blank"
              rel="noopener noreferrer"
            >
              check the source code on GitHub
            </a>
            .
          </p>
          <p>Please, choose a feature to explore.</p>
        </div>

        <div className="status-container">
          <a className="button" href="/uploader">
            Upload a video
          </a>
          <a className="button" href="/videos">
            See my videos
          </a>
        </div>
      </main>

      <footer>
        <a
          href="https://vercel.com?utm_source=create-next-app&utm_medium=default-template&utm_campaign=create-next-app"
          target="_blank"
          rel="noopener noreferrer"
        >
          Powered by{' '}
          <span>
            <Image src="/vercel.svg" alt="Vercel Logo" width={72} height={16} />
          </span>
        </a>
        <span>and</span>
        <a href="https://api.video" target="_blank" rel="noopener noreferrer">
          api.video
        </a>
      </footer>
    </div>
  )
}
