# Example app with [React Intl][]

This example app shows how to integrate [React Intl][] with Next.js.

## How to use

Execute [`create-next-app`](https://github.com/vercel/next.js/tree/canary/packages/create-next-app) with [npm](https://docs.npmjs.com/cli/init), [Yarn](https://yarnpkg.com/lang/en/docs/cli/create/), or [pnpm](https://pnpm.io) to bootstrap the example:

```bash
npx create-next-app --example with-react-intl with-react-intl-app
```

```bash
yarn create next-app --example with-react-intl with-react-intl-app
```

```bash
pnpm create next-app --example with-react-intl with-react-intl-app
```

Deploy it to the cloud with [Vercel](https://vercel.com/new?utm_source=github&utm_medium=readme&utm_campaign=next-example) ([Documentation](https://nextjs.org/docs/deployment)).

## Features of this example app

- React Intl integration with [custom App](https://github.com/vercel/next.js#custom-app) component
- `<IntlProvider>` creation with `locale`, `messages` props
- Default message extraction via `@formatjs/cli` integration
- Pre-compile messages into AST with `babel-plugin-formatjs` for performance
- Translation management

### Translation Management

This app stores translations and default strings in the `lang/` dir. The default messages (`en.json` in this example app) is also generated by the following script.

```bash
$ npm run i18n:extract
```

This file can then be sent to a translation service to perform localization for the other locales the app should support.

The translated messages files that exist at `lang/*.json` are only used during production, and are automatically provided to the `<IntlProvider>`. During development the `defaultMessage`s defined in the source code are used. To prepare the example app for localization and production run the build script and start the server in production mode:

```bash
$ npm run build
$ npm start
```

You can then switch your browser's language preferences to German or French and refresh the page to see the UI update accordingly.

[react intl]: https://formatjs.io
