module.exports = "\"use strict\";\nvar __create = Object.create;\nvar __defProp = Object.defineProperty;\nvar __getOwnPropDesc = Object.getOwnPropertyDescriptor;\nvar __getOwnPropNames = Object.getOwnPropertyNames;\nvar __getProtoOf = Object.getPrototypeOf;\nvar __hasOwnProp = Object.prototype.hasOwnProperty;\nvar __name = (target, value) => __defProp(target, \"name\", { value, configurable: true });\nvar __export = (target, all) => {\n  for (var name in all)\n    __defProp(target, name, { get: all[name], enumerable: true });\n};\nvar __copyProps = (to, from, except, desc) => {\n  if (from && typeof from === \"object\" || typeof from === \"function\") {\n    for (let key of __getOwnPropNames(from))\n      if (!__hasOwnProp.call(to, key) && key !== except)\n        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });\n  }\n  return to;\n};\nvar __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(\n  // If the importer is in node compatibility mode or this is not an ESM\n  // file that has been converted to a CommonJS file using a Babel-\n  // compatible transform (i.e. \"__esModule\" has not been set), then set\n  // \"default\" to the CommonJS \"module.exports\" for node compatibility.\n  isNodeMode || !mod || !mod.__esModule ? __defProp(target, \"default\", { value: mod, enumerable: true }) : target,\n  mod\n));\nvar __toCommonJS = (mod) => __copyProps(__defProp({}, \"__esModule\", { value: true }), mod);\n\n// src/primitives/crypto.js\nvar crypto_exports = {};\n__export(crypto_exports, {\n  Crypto: () => Crypto2,\n  CryptoKey: () => CryptoKey,\n  SubtleCrypto: () => SubtleCrypto3,\n  crypto: () => crypto2\n});\nmodule.exports = __toCommonJS(crypto_exports);\n\n// ../../node_modules/.pnpm/pvtsutils@1.3.2/node_modules/pvtsutils/build/index.es.js\nvar ARRAY_BUFFER_NAME = \"[object ArrayBuffer]\";\nvar _BufferSourceConverter = class _BufferSourceConverter {\n  static isArrayBuffer(data) {\n    return Object.prototype.toString.call(data) === ARRAY_BUFFER_NAME;\n  }\n  static toArrayBuffer(data) {\n    if (this.isArrayBuffer(data)) {\n      return data;\n    }\n    if (data.byteLength === data.buffer.byteLength) {\n      return data.buffer;\n    }\n    return this.toUint8Array(data).slice().buffer;\n  }\n  static toUint8Array(data) {\n    return this.toView(data, Uint8Array);\n  }\n  static toView(data, type) {\n    if (data.constructor === type) {\n      return data;\n    }\n    if (this.isArrayBuffer(data)) {\n      return new type(data);\n    }\n    if (this.isArrayBufferView(data)) {\n      return new type(data.buffer, data.byteOffset, data.byteLength);\n    }\n    throw new TypeError(\"The provided value is not of type '(ArrayBuffer or ArrayBufferView)'\");\n  }\n  static isBufferSource(data) {\n    return this.isArrayBufferView(data) || this.isArrayBuffer(data);\n  }\n  static isArrayBufferView(data) {\n    return ArrayBuffer.isView(data) || data && this.isArrayBuffer(data.buffer);\n  }\n  static isEqual(a, b) {\n    const aView = _BufferSourceConverter.toUint8Array(a);\n    const bView = _BufferSourceConverter.toUint8Array(b);\n    if (aView.length !== bView.byteLength) {\n      return false;\n    }\n    for (let i = 0; i < aView.length; i++) {\n      if (aView[i] !== bView[i]) {\n        return false;\n      }\n    }\n    return true;\n  }\n  static concat(...args) {\n    if (Array.isArray(args[0])) {\n      const buffers = args[0];\n      let size = 0;\n      for (const buffer of buffers) {\n        size += buffer.byteLength;\n      }\n      const res = new Uint8Array(size);\n      let offset = 0;\n      for (const buffer of buffers) {\n        const view = this.toUint8Array(buffer);\n        res.set(view, offset);\n        offset += view.length;\n      }\n      if (args[1]) {\n        return this.toView(res, args[1]);\n      }\n      return res.buffer;\n    } else {\n      return this.concat(args);\n    }\n  }\n};\n__name(_BufferSourceConverter, \"BufferSourceConverter\");\nvar BufferSourceConverter = _BufferSourceConverter;\nvar _Utf8Converter = class _Utf8Converter {\n  static fromString(text) {\n    const s = unescape(encodeURIComponent(text));\n    const uintArray = new Uint8Array(s.length);\n    for (let i = 0; i < s.length; i++) {\n      uintArray[i] = s.charCodeAt(i);\n    }\n    return uintArray.buffer;\n  }\n  static toString(buffer) {\n    const buf = BufferSourceConverter.toUint8Array(buffer);\n    let encodedString = \"\";\n    for (let i = 0; i < buf.length; i++) {\n      encodedString += String.fromCharCode(buf[i]);\n    }\n    const decodedString = decodeURIComponent(escape(encodedString));\n    return decodedString;\n  }\n};\n__name(_Utf8Converter, \"Utf8Converter\");\nvar Utf8Converter = _Utf8Converter;\nvar _Utf16Converter = class _Utf16Converter {\n  static toString(buffer, littleEndian = false) {\n    const arrayBuffer = BufferSourceConverter.toArrayBuffer(buffer);\n    const dataView = new DataView(arrayBuffer);\n    let res = \"\";\n    for (let i = 0; i < arrayBuffer.byteLength; i += 2) {\n      const code = dataView.getUint16(i, littleEndian);\n      res += String.fromCharCode(code);\n    }\n    return res;\n  }\n  static fromString(text, littleEndian = false) {\n    const res = new ArrayBuffer(text.length * 2);\n    const dataView = new DataView(res);\n    for (let i = 0; i < text.length; i++) {\n      dataView.setUint16(i * 2, text.charCodeAt(i), littleEndian);\n    }\n    return res;\n  }\n};\n__name(_Utf16Converter, \"Utf16Converter\");\nvar Utf16Converter = _Utf16Converter;\nvar _Convert = class _Convert {\n  static isHex(data) {\n    return typeof data === \"string\" && /^[a-z0-9]+$/i.test(data);\n  }\n  static isBase64(data) {\n    return typeof data === \"string\" && /^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/.test(data);\n  }\n  static isBase64Url(data) {\n    return typeof data === \"string\" && /^[a-zA-Z0-9-_]+$/i.test(data);\n  }\n  static ToString(buffer, enc = \"utf8\") {\n    const buf = BufferSourceConverter.toUint8Array(buffer);\n    switch (enc.toLowerCase()) {\n      case \"utf8\":\n        return this.ToUtf8String(buf);\n      case \"binary\":\n        return this.ToBinary(buf);\n      case \"hex\":\n        return this.ToHex(buf);\n      case \"base64\":\n        return this.ToBase64(buf);\n      case \"base64url\":\n        return this.ToBase64Url(buf);\n      case \"utf16le\":\n        return Utf16Converter.toString(buf, true);\n      case \"utf16\":\n      case \"utf16be\":\n        return Utf16Converter.toString(buf);\n      default:\n        throw new Error(`Unknown type of encoding '${enc}'`);\n    }\n  }\n  static FromString(str, enc = \"utf8\") {\n    if (!str) {\n      return new ArrayBuffer(0);\n    }\n    switch (enc.toLowerCase()) {\n      case \"utf8\":\n        return this.FromUtf8String(str);\n      case \"binary\":\n        return this.FromBinary(str);\n      case \"hex\":\n        return this.FromHex(str);\n      case \"base64\":\n        return this.FromBase64(str);\n      case \"base64url\":\n        return this.FromBase64Url(str);\n      case \"utf16le\":\n        return Utf16Converter.fromString(str, true);\n      case \"utf16\":\n      case \"utf16be\":\n        return Utf16Converter.fromString(str);\n      default:\n        throw new Error(`Unknown type of encoding '${enc}'`);\n    }\n  }\n  static ToBase64(buffer) {\n    const buf = BufferSourceConverter.toUint8Array(buffer);\n    if (typeof btoa !== \"undefined\") {\n      const binary = this.ToString(buf, \"binary\");\n      return btoa(binary);\n    } else {\n      return Buffer.from(buf).toString(\"base64\");\n    }\n  }\n  static FromBase64(base64) {\n    const formatted = this.formatString(base64);\n    if (!formatted) {\n      return new ArrayBuffer(0);\n    }\n    if (!_Convert.isBase64(formatted)) {\n      throw new TypeError(\"Argument 'base64Text' is not Base64 encoded\");\n    }\n    if (typeof atob !== \"undefined\") {\n      return this.FromBinary(atob(formatted));\n    } else {\n      return new Uint8Array(Buffer.from(formatted, \"base64\")).buffer;\n    }\n  }\n  static FromBase64Url(base64url) {\n    const formatted = this.formatString(base64url);\n    if (!formatted) {\n      return new ArrayBuffer(0);\n    }\n    if (!_Convert.isBase64Url(formatted)) {\n      throw new TypeError(\"Argument 'base64url' is not Base64Url encoded\");\n    }\n    return this.FromBase64(this.Base64Padding(formatted.replace(/\\-/g, \"+\").replace(/\\_/g, \"/\")));\n  }\n  static ToBase64Url(data) {\n    return this.ToBase64(data).replace(/\\+/g, \"-\").replace(/\\//g, \"_\").replace(/\\=/g, \"\");\n  }\n  static FromUtf8String(text, encoding = _Convert.DEFAULT_UTF8_ENCODING) {\n    switch (encoding) {\n      case \"ascii\":\n        return this.FromBinary(text);\n      case \"utf8\":\n        return Utf8Converter.fromString(text);\n      case \"utf16\":\n      case \"utf16be\":\n        return Utf16Converter.fromString(text);\n      case \"utf16le\":\n      case \"usc2\":\n        return Utf16Converter.fromString(text, true);\n      default:\n        throw new Error(`Unknown type of encoding '${encoding}'`);\n    }\n  }\n  static ToUtf8String(buffer, encoding = _Convert.DEFAULT_UTF8_ENCODING) {\n    switch (encoding) {\n      case \"ascii\":\n        return this.ToBinary(buffer);\n      case \"utf8\":\n        return Utf8Converter.toString(buffer);\n      case \"utf16\":\n      case \"utf16be\":\n        return Utf16Converter.toString(buffer);\n      case \"utf16le\":\n      case \"usc2\":\n        return Utf16Converter.toString(buffer, true);\n      default:\n        throw new Error(`Unknown type of encoding '${encoding}'`);\n    }\n  }\n  static FromBinary(text) {\n    const stringLength = text.length;\n    const resultView = new Uint8Array(stringLength);\n    for (let i = 0; i < stringLength; i++) {\n      resultView[i] = text.charCodeAt(i);\n    }\n    return resultView.buffer;\n  }\n  static ToBinary(buffer) {\n    const buf = BufferSourceConverter.toUint8Array(buffer);\n    let res = \"\";\n    for (let i = 0; i < buf.length; i++) {\n      res += String.fromCharCode(buf[i]);\n    }\n    return res;\n  }\n  static ToHex(buffer) {\n    const buf = BufferSourceConverter.toUint8Array(buffer);\n    const splitter = \"\";\n    const res = [];\n    const len = buf.length;\n    for (let i = 0; i < len; i++) {\n      const char = buf[i].toString(16).padStart(2, \"0\");\n      res.push(char);\n    }\n    return res.join(splitter);\n  }\n  static FromHex(hexString) {\n    let formatted = this.formatString(hexString);\n    if (!formatted) {\n      return new ArrayBuffer(0);\n    }\n    if (!_Convert.isHex(formatted)) {\n      throw new TypeError(\"Argument 'hexString' is not HEX encoded\");\n    }\n    if (formatted.length % 2) {\n      formatted = `0${formatted}`;\n    }\n    const res = new Uint8Array(formatted.length / 2);\n    for (let i = 0; i < formatted.length; i = i + 2) {\n      const c = formatted.slice(i, i + 2);\n      res[i / 2] = parseInt(c, 16);\n    }\n    return res.buffer;\n  }\n  static ToUtf16String(buffer, littleEndian = false) {\n    return Utf16Converter.toString(buffer, littleEndian);\n  }\n  static FromUtf16String(text, littleEndian = false) {\n    return Utf16Converter.fromString(text, littleEndian);\n  }\n  static Base64Padding(base64) {\n    const padCount = 4 - base64.length % 4;\n    if (padCount < 4) {\n      for (let i = 0; i < padCount; i++) {\n        base64 += \"=\";\n      }\n    }\n    return base64;\n  }\n  static formatString(data) {\n    return (data === null || data === void 0 ? void 0 : data.replace(/[\\n\\r\\t ]/g, \"\")) || \"\";\n  }\n};\n__name(_Convert, \"Convert\");\nvar Convert = _Convert;\nConvert.DEFAULT_UTF8_ENCODING = \"utf8\";\nfunction combine(...buf) {\n  const totalByteLength = buf.map((item) => item.byteLength).reduce((prev, cur) => prev + cur);\n  const res = new Uint8Array(totalByteLength);\n  let currentPos = 0;\n  buf.map((item) => new Uint8Array(item)).forEach((arr) => {\n    for (const item2 of arr) {\n      res[currentPos++] = item2;\n    }\n  });\n  return res.buffer;\n}\n__name(combine, \"combine\");\n\n// ../../node_modules/.pnpm/asn1js@3.0.5/node_modules/asn1js/build/index.es.js\nvar index_es_exports = {};\n__export(index_es_exports, {\n  Any: () => Any,\n  BaseBlock: () => BaseBlock,\n  BaseStringBlock: () => BaseStringBlock,\n  BitString: () => BitString,\n  BmpString: () => BmpString,\n  Boolean: () => Boolean,\n  CharacterString: () => CharacterString,\n  Choice: () => Choice,\n  Constructed: () => Constructed,\n  DATE: () => DATE,\n  DateTime: () => DateTime,\n  Duration: () => Duration,\n  EndOfContent: () => EndOfContent,\n  Enumerated: () => Enumerated,\n  GeneralString: () => GeneralString,\n  GeneralizedTime: () => GeneralizedTime,\n  GraphicString: () => GraphicString,\n  HexBlock: () => HexBlock,\n  IA5String: () => IA5String,\n  Integer: () => Integer,\n  Null: () => Null,\n  NumericString: () => NumericString,\n  ObjectIdentifier: () => ObjectIdentifier,\n  OctetString: () => OctetString,\n  Primitive: () => Primitive,\n  PrintableString: () => PrintableString,\n  RawData: () => RawData,\n  RelativeObjectIdentifier: () => RelativeObjectIdentifier,\n  Repeated: () => Repeated,\n  Sequence: () => Sequence,\n  Set: () => Set,\n  TIME: () => TIME,\n  TeletexString: () => TeletexString,\n  TimeOfDay: () => TimeOfDay,\n  UTCTime: () => UTCTime,\n  UniversalString: () => UniversalString,\n  Utf8String: () => Utf8String,\n  ValueBlock: () => ValueBlock,\n  VideotexString: () => VideotexString,\n  ViewWriter: () => ViewWriter,\n  VisibleString: () => VisibleString,\n  compareSchema: () => compareSchema,\n  fromBER: () => fromBER,\n  verifySchema: () => verifySchema\n});\n\n// ../../node_modules/.pnpm/pvutils@1.1.3/node_modules/pvutils/build/utils.es.js\nfunction utilFromBase(inputBuffer, inputBase) {\n  let result = 0;\n  if (inputBuffer.length === 1) {\n    return inputBuffer[0];\n  }\n  for (let i = inputBuffer.length - 1; i >= 0; i--) {\n    result += inputBuffer[inputBuffer.length - 1 - i] * Math.pow(2, inputBase * i);\n  }\n  return result;\n}\n__name(utilFromBase, \"utilFromBase\");\nfunction utilToBase(value, base, reserved = -1) {\n  const internalReserved = reserved;\n  let internalValue = value;\n  let result = 0;\n  let biggest = Math.pow(2, base);\n  for (let i = 1; i < 8; i++) {\n    if (value < biggest) {\n      let retBuf;\n      if (internalReserved < 0) {\n        retBuf = new ArrayBuffer(i);\n        result = i;\n      } else {\n        if (internalReserved < i) {\n          return new ArrayBuffer(0);\n        }\n        retBuf = new ArrayBuffer(internalReserved);\n        result = internalReserved;\n      }\n      const retView = new Uint8Array(retBuf);\n      for (let j = i - 1; j >= 0; j--) {\n        const basis = Math.pow(2, j * base);\n        retView[result - j - 1] = Math.floor(internalValue / basis);\n        internalValue -= retView[result - j - 1] * basis;\n      }\n      return retBuf;\n    }\n    biggest *= Math.pow(2, base);\n  }\n  return new ArrayBuffer(0);\n}\n__name(utilToBase, \"utilToBase\");\nfunction utilConcatView(...views) {\n  let outputLength = 0;\n  let prevLength = 0;\n  for (const view of views) {\n    outputLength += view.length;\n  }\n  const retBuf = new ArrayBuffer(outputLength);\n  const retView = new Uint8Array(retBuf);\n  for (const view of views) {\n    retView.set(view, prevLength);\n    prevLength += view.length;\n  }\n  return retView;\n}\n__name(utilConcatView, \"utilConcatView\");\nfunction utilDecodeTC() {\n  const buf = new Uint8Array(this.valueHex);\n  if (this.valueHex.byteLength >= 2) {\n    const condition1 = buf[0] === 255 && buf[1] & 128;\n    const condition2 = buf[0] === 0 && (buf[1] & 128) === 0;\n    if (condition1 || condition2) {\n      this.warnings.push(\"Needlessly long format\");\n    }\n  }\n  const bigIntBuffer = new ArrayBuffer(this.valueHex.byteLength);\n  const bigIntView = new Uint8Array(bigIntBuffer);\n  for (let i = 0; i < this.valueHex.byteLength; i++) {\n    bigIntView[i] = 0;\n  }\n  bigIntView[0] = buf[0] & 128;\n  const bigInt = utilFromBase(bigIntView, 8);\n  const smallIntBuffer = new ArrayBuffer(this.valueHex.byteLength);\n  const smallIntView = new Uint8Array(smallIntBuffer);\n  for (let j = 0; j < this.valueHex.byteLength; j++) {\n    smallIntView[j] = buf[j];\n  }\n  smallIntView[0] &= 127;\n  const smallInt = utilFromBase(smallIntView, 8);\n  return smallInt - bigInt;\n}\n__name(utilDecodeTC, \"utilDecodeTC\");\nfunction utilEncodeTC(value) {\n  const modValue = value < 0 ? value * -1 : value;\n  let bigInt = 128;\n  for (let i = 1; i < 8; i++) {\n    if (modValue <= bigInt) {\n      if (value < 0) {\n        const smallInt = bigInt - modValue;\n        const retBuf2 = utilToBase(smallInt, 8, i);\n        const retView2 = new Uint8Array(retBuf2);\n        retView2[0] |= 128;\n        return retBuf2;\n      }\n      let retBuf = utilToBase(modValue, 8, i);\n      let retView = new Uint8Array(retBuf);\n      if (retView[0] & 128) {\n        const tempBuf = retBuf.slice(0);\n        const tempView = new Uint8Array(tempBuf);\n        retBuf = new ArrayBuffer(retBuf.byteLength + 1);\n        retView = new Uint8Array(retBuf);\n        for (let k = 0; k < tempBuf.byteLength; k++) {\n          retView[k + 1] = tempView[k];\n        }\n        retView[0] = 0;\n      }\n      return retBuf;\n    }\n    bigInt *= Math.pow(2, 8);\n  }\n  return new ArrayBuffer(0);\n}\n__name(utilEncodeTC, \"utilEncodeTC\");\nfunction isEqualBuffer(inputBuffer1, inputBuffer2) {\n  if (inputBuffer1.byteLength !== inputBuffer2.byteLength) {\n    return false;\n  }\n  const view1 = new Uint8Array(inputBuffer1);\n  const view2 = new Uint8Array(inputBuffer2);\n  for (let i = 0; i < view1.length; i++) {\n    if (view1[i] !== view2[i]) {\n      return false;\n    }\n  }\n  return true;\n}\n__name(isEqualBuffer, \"isEqualBuffer\");\nfunction padNumber(inputNumber, fullLength) {\n  const str = inputNumber.toString(10);\n  if (fullLength < str.length) {\n    return \"\";\n  }\n  const dif = fullLength - str.length;\n  const padding = new Array(dif);\n  for (let i = 0; i < dif; i++) {\n    padding[i] = \"0\";\n  }\n  const paddingString = padding.join(\"\");\n  return paddingString.concat(str);\n}\n__name(padNumber, \"padNumber\");\nvar log2 = Math.log(2);\n\n// ../../node_modules/.pnpm/asn1js@3.0.5/node_modules/asn1js/build/index.es.js\nfunction assertBigInt() {\n  if (typeof BigInt === \"undefined\") {\n    throw new Error(\"BigInt is not defined. Your environment doesn't implement BigInt.\");\n  }\n}\n__name(assertBigInt, \"assertBigInt\");\nfunction concat(buffers) {\n  let outputLength = 0;\n  let prevLength = 0;\n  for (let i = 0; i < buffers.length; i++) {\n    const buffer = buffers[i];\n    outputLength += buffer.byteLength;\n  }\n  const retView = new Uint8Array(outputLength);\n  for (let i = 0; i < buffers.length; i++) {\n    const buffer = buffers[i];\n    retView.set(new Uint8Array(buffer), prevLength);\n    prevLength += buffer.byteLength;\n  }\n  return retView.buffer;\n}\n__name(concat, \"concat\");\nfunction checkBufferParams(baseBlock, inputBuffer, inputOffset, inputLength) {\n  if (!(inputBuffer instanceof Uint8Array)) {\n    baseBlock.error = \"Wrong parameter: inputBuffer must be 'Uint8Array'\";\n    return false;\n  }\n  if (!inputBuffer.byteLength) {\n    baseBlock.error = \"Wrong parameter: inputBuffer has zero length\";\n    return false;\n  }\n  if (inputOffset < 0) {\n    baseBlock.error = \"Wrong parameter: inputOffset less than zero\";\n    return false;\n  }\n  if (inputLength < 0) {\n    baseBlock.error = \"Wrong parameter: inputLength less than zero\";\n    return false;\n  }\n  if (inputBuffer.byteLength - inputOffset - inputLength < 0) {\n    baseBlock.error = \"End of input reached before message was fully decoded (inconsistent offset and length values)\";\n    return false;\n  }\n  return true;\n}\n__name(checkBufferParams, \"checkBufferParams\");\nvar _ViewWriter = class _ViewWriter {\n  constructor() {\n    this.items = [];\n  }\n  write(buf) {\n    this.items.push(buf);\n  }\n  final() {\n    return concat(this.items);\n  }\n};\n__name(_ViewWriter, \"ViewWriter\");\nvar ViewWriter = _ViewWriter;\nvar powers2 = [new Uint8Array([1])];\nvar digitsString = \"0123456789\";\nvar NAME = \"name\";\nvar VALUE_HEX_VIEW = \"valueHexView\";\nvar IS_HEX_ONLY = \"isHexOnly\";\nvar ID_BLOCK = \"idBlock\";\nvar TAG_CLASS = \"tagClass\";\nvar TAG_NUMBER = \"tagNumber\";\nvar IS_CONSTRUCTED = \"isConstructed\";\nvar FROM_BER = \"fromBER\";\nvar TO_BER = \"toBER\";\nvar LOCAL = \"local\";\nvar EMPTY_STRING = \"\";\nvar EMPTY_BUFFER = new ArrayBuffer(0);\nvar EMPTY_VIEW = new Uint8Array(0);\nvar END_OF_CONTENT_NAME = \"EndOfContent\";\nvar OCTET_STRING_NAME = \"OCTET STRING\";\nvar BIT_STRING_NAME = \"BIT STRING\";\nfunction HexBlock(BaseClass) {\n  var _a8;\n  var _a7;\n  return _a7 = (_a8 = class extends BaseClass {\n    constructor(...args) {\n      var _a9;\n      super(...args);\n      const params = args[0] || {};\n      this.isHexOnly = (_a9 = params.isHexOnly) !== null && _a9 !== void 0 ? _a9 : false;\n      this.valueHexView = params.valueHex ? BufferSourceConverter.toUint8Array(params.valueHex) : EMPTY_VIEW;\n    }\n    get valueHex() {\n      return this.valueHexView.slice().buffer;\n    }\n    set valueHex(value) {\n      this.valueHexView = new Uint8Array(value);\n    }\n    fromBER(inputBuffer, inputOffset, inputLength) {\n      const view = inputBuffer instanceof ArrayBuffer ? new Uint8Array(inputBuffer) : inputBuffer;\n      if (!checkBufferParams(this, view, inputOffset, inputLength)) {\n        return -1;\n      }\n      const endLength = inputOffset + inputLength;\n      this.valueHexView = view.subarray(inputOffset, endLength);\n      if (!this.valueHexView.length) {\n        this.warnings.push(\"Zero buffer length\");\n        return inputOffset;\n      }\n      this.blockLength = inputLength;\n      return endLength;\n    }\n    toBER(sizeOnly = false) {\n      if (!this.isHexOnly) {\n        this.error = \"Flag 'isHexOnly' is not set, abort\";\n        return EMPTY_BUFFER;\n      }\n      if (sizeOnly) {\n        return new ArrayBuffer(this.valueHexView.byteLength);\n      }\n      return this.valueHexView.byteLength === this.valueHexView.buffer.byteLength ? this.valueHexView.buffer : this.valueHexView.slice().buffer;\n    }\n    toJSON() {\n      return {\n        ...super.toJSON(),\n        isHexOnly: this.isHexOnly,\n        valueHex: Convert.ToHex(this.valueHexView)\n      };\n    }\n  }, __name(_a8, \"Some\"), _a8), _a7.NAME = \"hexBlock\", _a7;\n}\n__name(HexBlock, \"HexBlock\");\nvar _LocalBaseBlock = class _LocalBaseBlock {\n  constructor({ blockLength = 0, error = EMPTY_STRING, warnings = [], valueBeforeDecode = EMPTY_VIEW } = {}) {\n    this.blockLength = blockLength;\n    this.error = error;\n    this.warnings = warnings;\n    this.valueBeforeDecodeView = BufferSourceConverter.toUint8Array(valueBeforeDecode);\n  }\n  static blockName() {\n    return this.NAME;\n  }\n  get valueBeforeDecode() {\n    return this.valueBeforeDecodeView.slice().buffer;\n  }\n  set valueBeforeDecode(value) {\n    this.valueBeforeDecodeView = new Uint8Array(value);\n  }\n  toJSON() {\n    return {\n      blockName: this.constructor.NAME,\n      blockLength: this.blockLength,\n      error: this.error,\n      warnings: this.warnings,\n      valueBeforeDecode: Convert.ToHex(this.valueBeforeDecodeView)\n    };\n  }\n};\n__name(_LocalBaseBlock, \"LocalBaseBlock\");\nvar LocalBaseBlock = _LocalBaseBlock;\nLocalBaseBlock.NAME = \"baseBlock\";\nvar _ValueBlock = class _ValueBlock extends LocalBaseBlock {\n  fromBER(inputBuffer, inputOffset, inputLength) {\n    throw TypeError(\"User need to make a specific function in a class which extends 'ValueBlock'\");\n  }\n  toBER(sizeOnly, writer) {\n    throw TypeError(\"User need to make a specific function in a class which extends 'ValueBlock'\");\n  }\n};\n__name(_ValueBlock, \"ValueBlock\");\nvar ValueBlock = _ValueBlock;\nValueBlock.NAME = \"valueBlock\";\nvar _LocalIdentificationBlock = class _LocalIdentificationBlock extends HexBlock(LocalBaseBlock) {\n  constructor({ idBlock = {} } = {}) {\n    var _a7, _b, _c, _d;\n    super();\n    if (idBlock) {\n      this.isHexOnly = (_a7 = idBlock.isHexOnly) !== null && _a7 !== void 0 ? _a7 : false;\n      this.valueHexView = idBlock.valueHex ? BufferSourceConverter.toUint8Array(idBlock.valueHex) : EMPTY_VIEW;\n      this.tagClass = (_b = idBlock.tagClass) !== null && _b !== void 0 ? _b : -1;\n      this.tagNumber = (_c = idBlock.tagNumber) !== null && _c !== void 0 ? _c : -1;\n      this.isConstructed = (_d = idBlock.isConstructed) !== null && _d !== void 0 ? _d : false;\n    } else {\n      this.tagClass = -1;\n      this.tagNumber = -1;\n      this.isConstructed = false;\n    }\n  }\n  toBER(sizeOnly = false) {\n    let firstOctet = 0;\n    switch (this.tagClass) {\n      case 1:\n        firstOctet |= 0;\n        break;\n      case 2:\n        firstOctet |= 64;\n        break;\n      case 3:\n        firstOctet |= 128;\n        break;\n      case 4:\n        firstOctet |= 192;\n        break;\n      default:\n        this.error = \"Unknown tag class\";\n        return EMPTY_BUFFER;\n    }\n    if (this.isConstructed)\n      firstOctet |= 32;\n    if (this.tagNumber < 31 && !this.isHexOnly) {\n      const retView2 = new Uint8Array(1);\n      if (!sizeOnly) {\n        let number = this.tagNumber;\n        number &= 31;\n        firstOctet |= number;\n        retView2[0] = firstOctet;\n      }\n      return retView2.buffer;\n    }\n    if (!this.isHexOnly) {\n      const encodedBuf = utilToBase(this.tagNumber, 7);\n      const encodedView = new Uint8Array(encodedBuf);\n      const size = encodedBuf.byteLength;\n      const retView2 = new Uint8Array(size + 1);\n      retView2[0] = firstOctet | 31;\n      if (!sizeOnly) {\n        for (let i = 0; i < size - 1; i++)\n          retView2[i + 1] = encodedView[i] | 128;\n        retView2[size] = encodedView[size - 1];\n      }\n      return retView2.buffer;\n    }\n    const retView = new Uint8Array(this.valueHexView.byteLength + 1);\n    retView[0] = firstOctet | 31;\n    if (!sizeOnly) {\n      const curView = this.valueHexView;\n      for (let i = 0; i < curView.length - 1; i++)\n        retView[i + 1] = curView[i] | 128;\n      retView[this.valueHexView.byteLength] = curView[curView.length - 1];\n    }\n    return retView.buffer;\n  }\n  fromBER(inputBuffer, inputOffset, inputLength) {\n    const inputView = BufferSourceConverter.toUint8Array(inputBuffer);\n    if (!checkBufferParams(this, inputView, inputOffset, inputLength)) {\n      return -1;\n    }\n    const intBuffer = inputView.subarray(inputOffset, inputOffset + inputLength);\n    if (intBuffer.length === 0) {\n      this.error = \"Zero buffer length\";\n      return -1;\n    }\n    const tagClassMask = intBuffer[0] & 192;\n    switch (tagClassMask) {\n      case 0:\n        this.tagClass = 1;\n        break;\n      case 64:\n        this.tagClass = 2;\n        break;\n      case 128:\n        this.tagClass = 3;\n        break;\n      case 192:\n        this.tagClass = 4;\n        break;\n      default:\n        this.error = \"Unknown tag class\";\n        return -1;\n    }\n    this.isConstructed = (intBuffer[0] & 32) === 32;\n    this.isHexOnly = false;\n    const tagNumberMask = intBuffer[0] & 31;\n    if (tagNumberMask !== 31) {\n      this.tagNumber = tagNumberMask;\n      this.blockLength = 1;\n    } else {\n      let count = 1;\n      let intTagNumberBuffer = this.valueHexView = new Uint8Array(255);\n      let tagNumberBufferMaxLength = 255;\n      while (intBuffer[count] & 128) {\n        intTagNumberBuffer[count - 1] = intBuffer[count] & 127;\n        count++;\n        if (count >= intBuffer.length) {\n          this.error = \"End of input reached before message was fully decoded\";\n          return -1;\n        }\n        if (count === tagNumberBufferMaxLength) {\n          tagNumberBufferMaxLength += 255;\n          const tempBufferView2 = new Uint8Array(tagNumberBufferMaxLength);\n          for (let i = 0; i < intTagNumberBuffer.length; i++)\n            tempBufferView2[i] = intTagNumberBuffer[i];\n          intTagNumberBuffer = this.valueHexView = new Uint8Array(tagNumberBufferMaxLength);\n        }\n      }\n      this.blockLength = count + 1;\n      intTagNumberBuffer[count - 1] = intBuffer[count] & 127;\n      const tempBufferView = new Uint8Array(count);\n      for (let i = 0; i < count; i++)\n        tempBufferView[i] = intTagNumberBuffer[i];\n      intTagNumberBuffer = this.valueHexView = new Uint8Array(count);\n      intTagNumberBuffer.set(tempBufferView);\n      if (this.blockLength <= 9)\n        this.tagNumber = utilFromBase(intTagNumberBuffer, 7);\n      else {\n        this.isHexOnly = true;\n        this.warnings.push(\"Tag too long, represented as hex-coded\");\n      }\n    }\n    if (this.tagClass === 1 && this.isConstructed) {\n      switch (this.tagNumber) {\n        case 1:\n        case 2:\n        case 5:\n        case 6:\n        case 9:\n        case 13:\n        case 14:\n        case 23:\n        case 24:\n        case 31:\n        case 32:\n        case 33:\n        case 34:\n          this.error = \"Constructed encoding used for primitive type\";\n          return -1;\n      }\n    }\n    return inputOffset + this.blockLength;\n  }\n  toJSON() {\n    return {\n      ...super.toJSON(),\n      tagClass: this.tagClass,\n      tagNumber: this.tagNumber,\n      isConstructed: this.isConstructed\n    };\n  }\n};\n__name(_LocalIdentificationBlock, \"LocalIdentificationBlock\");\nvar LocalIdentificationBlock = _LocalIdentificationBlock;\nLocalIdentificationBlock.NAME = \"identificationBlock\";\nvar _LocalLengthBlock = class _LocalLengthBlock extends LocalBaseBlock {\n  constructor({ lenBlock = {} } = {}) {\n    var _a7, _b, _c;\n    super();\n    this.isIndefiniteForm = (_a7 = lenBlock.isIndefiniteForm) !== null && _a7 !== void 0 ? _a7 : false;\n    this.longFormUsed = (_b = lenBlock.longFormUsed) !== null && _b !== void 0 ? _b : false;\n    this.length = (_c = lenBlock.length) !== null && _c !== void 0 ? _c : 0;\n  }\n  fromBER(inputBuffer, inputOffset, inputLength) {\n    const view = BufferSourceConverter.toUint8Array(inputBuffer);\n    if (!checkBufferParams(this, view, inputOffset, inputLength)) {\n      return -1;\n    }\n    const intBuffer = view.subarray(inputOffset, inputOffset + inputLength);\n    if (intBuffer.length === 0) {\n      this.error = \"Zero buffer length\";\n      return -1;\n    }\n    if (intBuffer[0] === 255) {\n      this.error = \"Length block 0xFF is reserved by standard\";\n      return -1;\n    }\n    this.isIndefiniteForm = intBuffer[0] === 128;\n    if (this.isIndefiniteForm) {\n      this.blockLength = 1;\n      return inputOffset + this.blockLength;\n    }\n    this.longFormUsed = !!(intBuffer[0] & 128);\n    if (this.longFormUsed === false) {\n      this.length = intBuffer[0];\n      this.blockLength = 1;\n      return inputOffset + this.blockLength;\n    }\n    const count = intBuffer[0] & 127;\n    if (count > 8) {\n      this.error = \"Too big integer\";\n      return -1;\n    }\n    if (count + 1 > intBuffer.length) {\n      this.error = \"End of input reached before message was fully decoded\";\n      return -1;\n    }\n    const lenOffset = inputOffset + 1;\n    const lengthBufferView = view.subarray(lenOffset, lenOffset + count);\n    if (lengthBufferView[count - 1] === 0)\n      this.warnings.push(\"Needlessly long encoded length\");\n    this.length = utilFromBase(lengthBufferView, 8);\n    if (this.longFormUsed && this.length <= 127)\n      this.warnings.push(\"Unnecessary usage of long length form\");\n    this.blockLength = count + 1;\n    return inputOffset + this.blockLength;\n  }\n  toBER(sizeOnly = false) {\n    let retBuf;\n    let retView;\n    if (this.length > 127)\n      this.longFormUsed = true;\n    if (this.isIndefiniteForm) {\n      retBuf = new ArrayBuffer(1);\n      if (sizeOnly === false) {\n        retView = new Uint8Array(retBuf);\n        retView[0] = 128;\n      }\n      return retBuf;\n    }\n    if (this.longFormUsed) {\n      const encodedBuf = utilToBase(this.length, 8);\n      if (encodedBuf.byteLength > 127) {\n        this.error = \"Too big length\";\n        return EMPTY_BUFFER;\n      }\n      retBuf = new ArrayBuffer(encodedBuf.byteLength + 1);\n      if (sizeOnly)\n        return retBuf;\n      const encodedView = new Uint8Array(encodedBuf);\n      retView = new Uint8Array(retBuf);\n      retView[0] = encodedBuf.byteLength | 128;\n      for (let i = 0; i < encodedBuf.byteLength; i++)\n        retView[i + 1] = encodedView[i];\n      return retBuf;\n    }\n    retBuf = new ArrayBuffer(1);\n    if (sizeOnly === false) {\n      retView = new Uint8Array(retBuf);\n      retView[0] = this.length;\n    }\n    return retBuf;\n  }\n  toJSON() {\n    return {\n      ...super.toJSON(),\n      isIndefiniteForm: this.isIndefiniteForm,\n      longFormUsed: this.longFormUsed,\n      length: this.length\n    };\n  }\n};\n__name(_LocalLengthBlock, \"LocalLengthBlock\");\nvar LocalLengthBlock = _LocalLengthBlock;\nLocalLengthBlock.NAME = \"lengthBlock\";\nvar typeStore = {};\nvar _BaseBlock = class _BaseBlock extends LocalBaseBlock {\n  constructor({ name = EMPTY_STRING, optional = false, primitiveSchema, ...parameters } = {}, valueBlockType) {\n    super(parameters);\n    this.name = name;\n    this.optional = optional;\n    if (primitiveSchema) {\n      this.primitiveSchema = primitiveSchema;\n    }\n    this.idBlock = new LocalIdentificationBlock(parameters);\n    this.lenBlock = new LocalLengthBlock(parameters);\n    this.valueBlock = valueBlockType ? new valueBlockType(parameters) : new ValueBlock(parameters);\n  }\n  fromBER(inputBuffer, inputOffset, inputLength) {\n    const resultOffset = this.valueBlock.fromBER(inputBuffer, inputOffset, this.lenBlock.isIndefiniteForm ? inputLength : this.lenBlock.length);\n    if (resultOffset === -1) {\n      this.error = this.valueBlock.error;\n      return resultOffset;\n    }\n    if (!this.idBlock.error.length)\n      this.blockLength += this.idBlock.blockLength;\n    if (!this.lenBlock.error.length)\n      this.blockLength += this.lenBlock.blockLength;\n    if (!this.valueBlock.error.length)\n      this.blockLength += this.valueBlock.blockLength;\n    return resultOffset;\n  }\n  toBER(sizeOnly, writer) {\n    const _writer = writer || new ViewWriter();\n    if (!writer) {\n      prepareIndefiniteForm(this);\n    }\n    const idBlockBuf = this.idBlock.toBER(sizeOnly);\n    _writer.write(idBlockBuf);\n    if (this.lenBlock.isIndefiniteForm) {\n      _writer.write(new Uint8Array([128]).buffer);\n      this.valueBlock.toBER(sizeOnly, _writer);\n      _writer.write(new ArrayBuffer(2));\n    } else {\n      const valueBlockBuf = this.valueBlock.toBER(sizeOnly);\n      this.lenBlock.length = valueBlockBuf.byteLength;\n      const lenBlockBuf = this.lenBlock.toBER(sizeOnly);\n      _writer.write(lenBlockBuf);\n      _writer.write(valueBlockBuf);\n    }\n    if (!writer) {\n      return _writer.final();\n    }\n    return EMPTY_BUFFER;\n  }\n  toJSON() {\n    const object = {\n      ...super.toJSON(),\n      idBlock: this.idBlock.toJSON(),\n      lenBlock: this.lenBlock.toJSON(),\n      valueBlock: this.valueBlock.toJSON(),\n      name: this.name,\n      optional: this.optional\n    };\n    if (this.primitiveSchema)\n      object.primitiveSchema = this.primitiveSchema.toJSON();\n    return object;\n  }\n  toString(encoding = \"ascii\") {\n    if (encoding === \"ascii\") {\n      return this.onAsciiEncoding();\n    }\n    return Convert.ToHex(this.toBER());\n  }\n  onAsciiEncoding() {\n    return `${this.constructor.NAME} : ${Convert.ToHex(this.valueBlock.valueBeforeDecodeView)}`;\n  }\n  isEqual(other) {\n    if (this === other) {\n      return true;\n    }\n    if (!(other instanceof this.constructor)) {\n      return false;\n    }\n    const thisRaw = this.toBER();\n    const otherRaw = other.toBER();\n    return isEqualBuffer(thisRaw, otherRaw);\n  }\n};\n__name(_BaseBlock, \"BaseBlock\");\nvar BaseBlock = _BaseBlock;\nBaseBlock.NAME = \"BaseBlock\";\nfunction prepareIndefiniteForm(baseBlock) {\n  if (baseBlock instanceof typeStore.Constructed) {\n    for (const value of baseBlock.valueBlock.value) {\n      if (prepareIndefiniteForm(value)) {\n        baseBlock.lenBlock.isIndefiniteForm = true;\n      }\n    }\n  }\n  return !!baseBlock.lenBlock.isIndefiniteForm;\n}\n__name(prepareIndefiniteForm, \"prepareIndefiniteForm\");\nvar _BaseStringBlock = class _BaseStringBlock extends BaseBlock {\n  constructor({ value = EMPTY_STRING, ...parameters } = {}, stringValueBlockType) {\n    super(parameters, stringValueBlockType);\n    if (value) {\n      this.fromString(value);\n    }\n  }\n  getValue() {\n    return this.valueBlock.value;\n  }\n  setValue(value) {\n    this.valueBlock.value = value;\n  }\n  fromBER(inputBuffer, inputOffset, inputLength) {\n    const resultOffset = this.valueBlock.fromBER(inputBuffer, inputOffset, this.lenBlock.isIndefiniteForm ? inputLength : this.lenBlock.length);\n    if (resultOffset === -1) {\n      this.error = this.valueBlock.error;\n      return resultOffset;\n    }\n    this.fromBuffer(this.valueBlock.valueHexView);\n    if (!this.idBlock.error.length)\n      this.blockLength += this.idBlock.blockLength;\n    if (!this.lenBlock.error.length)\n      this.blockLength += this.lenBlock.blockLength;\n    if (!this.valueBlock.error.length)\n      this.blockLength += this.valueBlock.blockLength;\n    return resultOffset;\n  }\n  onAsciiEncoding() {\n    return `${this.constructor.NAME} : '${this.valueBlock.value}'`;\n  }\n};\n__name(_BaseStringBlock, \"BaseStringBlock\");\nvar BaseStringBlock = _BaseStringBlock;\nBaseStringBlock.NAME = \"BaseStringBlock\";\nvar _LocalPrimitiveValueBlock = class _LocalPrimitiveValueBlock extends HexBlock(ValueBlock) {\n  constructor({ isHexOnly = true, ...parameters } = {}) {\n    super(parameters);\n    this.isHexOnly = isHexOnly;\n  }\n};\n__name(_LocalPrimitiveValueBlock, \"LocalPrimitiveValueBlock\");\nvar LocalPrimitiveValueBlock = _LocalPrimitiveValueBlock;\nLocalPrimitiveValueBlock.NAME = \"PrimitiveValueBlock\";\nvar _a$w;\nvar _Primitive = class _Primitive extends BaseBlock {\n  constructor(parameters = {}) {\n    super(parameters, LocalPrimitiveValueBlock);\n    this.idBlock.isConstructed = false;\n  }\n};\n__name(_Primitive, \"Primitive\");\nvar Primitive = _Primitive;\n_a$w = Primitive;\n(() => {\n  typeStore.Primitive = _a$w;\n})();\nPrimitive.NAME = \"PRIMITIVE\";\nfunction localChangeType(inputObject, newType) {\n  if (inputObject instanceof newType) {\n    return inputObject;\n  }\n  const newObject = new newType();\n  newObject.idBlock = inputObject.idBlock;\n  newObject.lenBlock = inputObject.lenBlock;\n  newObject.warnings = inputObject.warnings;\n  newObject.valueBeforeDecodeView = inputObject.valueBeforeDecodeView;\n  return newObject;\n}\n__name(localChangeType, \"localChangeType\");\nfunction localFromBER(inputBuffer, inputOffset = 0, inputLength = inputBuffer.length) {\n  const incomingOffset = inputOffset;\n  let returnObject = new BaseBlock({}, ValueBlock);\n  const baseBlock = new LocalBaseBlock();\n  if (!checkBufferParams(baseBlock, inputBuffer, inputOffset, inputLength)) {\n    returnObject.error = baseBlock.error;\n    return {\n      offset: -1,\n      result: returnObject\n    };\n  }\n  const intBuffer = inputBuffer.subarray(inputOffset, inputOffset + inputLength);\n  if (!intBuffer.length) {\n    returnObject.error = \"Zero buffer length\";\n    return {\n      offset: -1,\n      result: returnObject\n    };\n  }\n  let resultOffset = returnObject.idBlock.fromBER(inputBuffer, inputOffset, inputLength);\n  if (returnObject.idBlock.warnings.length) {\n    returnObject.warnings.concat(returnObject.idBlock.warnings);\n  }\n  if (resultOffset === -1) {\n    returnObject.error = returnObject.idBlock.error;\n    return {\n      offset: -1,\n      result: returnObject\n    };\n  }\n  inputOffset = resultOffset;\n  inputLength -= returnObject.idBlock.blockLength;\n  resultOffset = returnObject.lenBlock.fromBER(inputBuffer, inputOffset, inputLength);\n  if (returnObject.lenBlock.warnings.length) {\n    returnObject.warnings.concat(returnObject.lenBlock.warnings);\n  }\n  if (resultOffset === -1) {\n    returnObject.error = returnObject.lenBlock.error;\n    return {\n      offset: -1,\n      result: returnObject\n    };\n  }\n  inputOffset = resultOffset;\n  inputLength -= returnObject.lenBlock.blockLength;\n  if (!returnObject.idBlock.isConstructed && returnObject.lenBlock.isIndefiniteForm) {\n    returnObject.error = \"Indefinite length form used for primitive encoding form\";\n    return {\n      offset: -1,\n      result: returnObject\n    };\n  }\n  let newASN1Type = BaseBlock;\n  switch (returnObject.idBlock.tagClass) {\n    case 1:\n      if (returnObject.idBlock.tagNumber >= 37 && returnObject.idBlock.isHexOnly === false) {\n        returnObject.error = \"UNIVERSAL 37 and upper tags are reserved by ASN.1 standard\";\n        return {\n          offset: -1,\n          result: returnObject\n        };\n      }\n      switch (returnObject.idBlock.tagNumber) {\n        case 0:\n          if (returnObject.idBlock.isConstructed && returnObject.lenBlock.length > 0) {\n            returnObject.error = \"Type [UNIVERSAL 0] is reserved\";\n            return {\n              offset: -1,\n              result: returnObject\n            };\n          }\n          newASN1Type = typeStore.EndOfContent;\n          break;\n        case 1:\n          newASN1Type = typeStore.Boolean;\n          break;\n        case 2:\n          newASN1Type = typeStore.Integer;\n          break;\n        case 3:\n          newASN1Type = typeStore.BitString;\n          break;\n        case 4:\n          newASN1Type = typeStore.OctetString;\n          break;\n        case 5:\n          newASN1Type = typeStore.Null;\n          break;\n        case 6:\n          newASN1Type = typeStore.ObjectIdentifier;\n          break;\n        case 10:\n          newASN1Type = typeStore.Enumerated;\n          break;\n        case 12:\n          newASN1Type = typeStore.Utf8String;\n          break;\n        case 13:\n          newASN1Type = typeStore.RelativeObjectIdentifier;\n          break;\n        case 14:\n          newASN1Type = typeStore.TIME;\n          break;\n        case 15:\n          returnObject.error = \"[UNIVERSAL 15] is reserved by ASN.1 standard\";\n          return {\n            offset: -1,\n            result: returnObject\n          };\n        case 16:\n          newASN1Type = typeStore.Sequence;\n          break;\n        case 17:\n          newASN1Type = typeStore.Set;\n          break;\n        case 18:\n          newASN1Type = typeStore.NumericString;\n          break;\n        case 19:\n          newASN1Type = typeStore.PrintableString;\n          break;\n        case 20:\n          newASN1Type = typeStore.TeletexString;\n          break;\n        case 21:\n          newASN1Type = typeStore.VideotexString;\n          break;\n        case 22:\n          newASN1Type = typeStore.IA5String;\n          break;\n        case 23:\n          newASN1Type = typeStore.UTCTime;\n          break;\n        case 24:\n          newASN1Type = typeStore.GeneralizedTime;\n          break;\n        case 25:\n          newASN1Type = typeStore.GraphicString;\n          break;\n        case 26:\n          newASN1Type = typeStore.VisibleString;\n          break;\n        case 27:\n          newASN1Type = typeStore.GeneralString;\n          break;\n        case 28:\n          newASN1Type = typeStore.UniversalString;\n          break;\n        case 29:\n          newASN1Type = typeStore.CharacterString;\n          break;\n        case 30:\n          newASN1Type = typeStore.BmpString;\n          break;\n        case 31:\n          newASN1Type = typeStore.DATE;\n          break;\n        case 32:\n          newASN1Type = typeStore.TimeOfDay;\n          break;\n        case 33:\n          newASN1Type = typeStore.DateTime;\n          break;\n        case 34:\n          newASN1Type = typeStore.Duration;\n          break;\n        default: {\n          const newObject = returnObject.idBlock.isConstructed ? new typeStore.Constructed() : new typeStore.Primitive();\n          newObject.idBlock = returnObject.idBlock;\n          newObject.lenBlock = returnObject.lenBlock;\n          newObject.warnings = returnObject.warnings;\n          returnObject = newObject;\n        }\n      }\n      break;\n    case 2:\n    case 3:\n    case 4:\n    default: {\n      newASN1Type = returnObject.idBlock.isConstructed ? typeStore.Constructed : typeStore.Primitive;\n    }\n  }\n  returnObject = localChangeType(returnObject, newASN1Type);\n  resultOffset = returnObject.fromBER(inputBuffer, inputOffset, returnObject.lenBlock.isIndefiniteForm ? inputLength : returnObject.lenBlock.length);\n  returnObject.valueBeforeDecodeView = inputBuffer.subarray(incomingOffset, incomingOffset + returnObject.blockLength);\n  return {\n    offset: resultOffset,\n    result: returnObject\n  };\n}\n__name(localFromBER, \"localFromBER\");\nfunction fromBER(inputBuffer) {\n  if (!inputBuffer.byteLength) {\n    const result = new BaseBlock({}, ValueBlock);\n    result.error = \"Input buffer has zero length\";\n    return {\n      offset: -1,\n      result\n    };\n  }\n  return localFromBER(BufferSourceConverter.toUint8Array(inputBuffer).slice(), 0, inputBuffer.byteLength);\n}\n__name(fromBER, \"fromBER\");\nfunction checkLen(indefiniteLength, length) {\n  if (indefiniteLength) {\n    return 1;\n  }\n  return length;\n}\n__name(checkLen, \"checkLen\");\nvar _LocalConstructedValueBlock = class _LocalConstructedValueBlock extends ValueBlock {\n  constructor({ value = [], isIndefiniteForm = false, ...parameters } = {}) {\n    super(parameters);\n    this.value = value;\n    this.isIndefiniteForm = isIndefiniteForm;\n  }\n  fromBER(inputBuffer, inputOffset, inputLength) {\n    const view = BufferSourceConverter.toUint8Array(inputBuffer);\n    if (!checkBufferParams(this, view, inputOffset, inputLength)) {\n      return -1;\n    }\n    this.valueBeforeDecodeView = view.subarray(inputOffset, inputOffset + inputLength);\n    if (this.valueBeforeDecodeView.length === 0) {\n      this.warnings.push(\"Zero buffer length\");\n      return inputOffset;\n    }\n    let currentOffset = inputOffset;\n    while (checkLen(this.isIndefiniteForm, inputLength) > 0) {\n      const returnObject = localFromBER(view, currentOffset, inputLength);\n      if (returnObject.offset === -1) {\n        this.error = returnObject.result.error;\n        this.warnings.concat(returnObject.result.warnings);\n        return -1;\n      }\n      currentOffset = returnObject.offset;\n      this.blockLength += returnObject.result.blockLength;\n      inputLength -= returnObject.result.blockLength;\n      this.value.push(returnObject.result);\n      if (this.isIndefiniteForm && returnObject.result.constructor.NAME === END_OF_CONTENT_NAME) {\n        break;\n      }\n    }\n    if (this.isIndefiniteForm) {\n      if (this.value[this.value.length - 1].constructor.NAME === END_OF_CONTENT_NAME) {\n        this.value.pop();\n      } else {\n        this.warnings.push(\"No EndOfContent block encoded\");\n      }\n    }\n    return currentOffset;\n  }\n  toBER(sizeOnly, writer) {\n    const _writer = writer || new ViewWriter();\n    for (let i = 0; i < this.value.length; i++) {\n      this.value[i].toBER(sizeOnly, _writer);\n    }\n    if (!writer) {\n      return _writer.final();\n    }\n    return EMPTY_BUFFER;\n  }\n  toJSON() {\n    const object = {\n      ...super.toJSON(),\n      isIndefiniteForm: this.isIndefiniteForm,\n      value: []\n    };\n    for (const value of this.value) {\n      object.value.push(value.toJSON());\n    }\n    return object;\n  }\n};\n__name(_LocalConstructedValueBlock, \"LocalConstructedValueBlock\");\nvar LocalConstructedValueBlock = _LocalConstructedValueBlock;\nLocalConstructedValueBlock.NAME = \"ConstructedValueBlock\";\nvar _a$v;\nvar _Constructed = class _Constructed extends BaseBlock {\n  constructor(parameters = {}) {\n    super(parameters, LocalConstructedValueBlock);\n    this.idBlock.isConstructed = true;\n  }\n  fromBER(inputBuffer, inputOffset, inputLength) {\n    this.valueBlock.isIndefiniteForm = this.lenBlock.isIndefiniteForm;\n    const resultOffset = this.valueBlock.fromBER(inputBuffer, inputOffset, this.lenBlock.isIndefiniteForm ? inputLength : this.lenBlock.length);\n    if (resultOffset === -1) {\n      this.error = this.valueBlock.error;\n      return resultOffset;\n    }\n    if (!this.idBlock.error.length)\n      this.blockLength += this.idBlock.blockLength;\n    if (!this.lenBlock.error.length)\n      this.blockLength += this.lenBlock.blockLength;\n    if (!this.valueBlock.error.length)\n      this.blockLength += this.valueBlock.blockLength;\n    return resultOffset;\n  }\n  onAsciiEncoding() {\n    const values = [];\n    for (const value of this.valueBlock.value) {\n      values.push(value.toString(\"ascii\").split(\"\\n\").map((o) => `  ${o}`).join(\"\\n\"));\n    }\n    const blockName = this.idBlock.tagClass === 3 ? `[${this.idBlock.tagNumber}]` : this.constructor.NAME;\n    return values.length ? `${blockName} :\n${values.join(\"\\n\")}` : `${blockName} :`;\n  }\n};\n__name(_Constructed, \"Constructed\");\nvar Constructed = _Constructed;\n_a$v = Constructed;\n(() => {\n  typeStore.Constructed = _a$v;\n})();\nConstructed.NAME = \"CONSTRUCTED\";\nvar _LocalEndOfContentValueBlock = class _LocalEndOfContentValueBlock extends ValueBlock {\n  fromBER(inputBuffer, inputOffset, inputLength) {\n    return inputOffset;\n  }\n  toBER(sizeOnly) {\n    return EMPTY_BUFFER;\n  }\n};\n__name(_LocalEndOfContentValueBlock, \"LocalEndOfContentValueBlock\");\nvar LocalEndOfContentValueBlock = _LocalEndOfContentValueBlock;\nLocalEndOfContentValueBlock.override = \"EndOfContentValueBlock\";\nvar _a$u;\nvar _EndOfContent = class _EndOfContent extends BaseBlock {\n  constructor(parameters = {}) {\n    super(parameters, LocalEndOfContentValueBlock);\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 0;\n  }\n};\n__name(_EndOfContent, \"EndOfContent\");\nvar EndOfContent = _EndOfContent;\n_a$u = EndOfContent;\n(() => {\n  typeStore.EndOfContent = _a$u;\n})();\nEndOfContent.NAME = END_OF_CONTENT_NAME;\nvar _a$t;\nvar _Null = class _Null extends BaseBlock {\n  constructor(parameters = {}) {\n    super(parameters, ValueBlock);\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 5;\n  }\n  fromBER(inputBuffer, inputOffset, inputLength) {\n    if (this.lenBlock.length > 0)\n      this.warnings.push(\"Non-zero length of value block for Null type\");\n    if (!this.idBlock.error.length)\n      this.blockLength += this.idBlock.blockLength;\n    if (!this.lenBlock.error.length)\n      this.blockLength += this.lenBlock.blockLength;\n    this.blockLength += inputLength;\n    if (inputOffset + inputLength > inputBuffer.byteLength) {\n      this.error = \"End of input reached before message was fully decoded (inconsistent offset and length values)\";\n      return -1;\n    }\n    return inputOffset + inputLength;\n  }\n  toBER(sizeOnly, writer) {\n    const retBuf = new ArrayBuffer(2);\n    if (!sizeOnly) {\n      const retView = new Uint8Array(retBuf);\n      retView[0] = 5;\n      retView[1] = 0;\n    }\n    if (writer) {\n      writer.write(retBuf);\n    }\n    return retBuf;\n  }\n  onAsciiEncoding() {\n    return `${this.constructor.NAME}`;\n  }\n};\n__name(_Null, \"Null\");\nvar Null = _Null;\n_a$t = Null;\n(() => {\n  typeStore.Null = _a$t;\n})();\nNull.NAME = \"NULL\";\nvar _LocalBooleanValueBlock = class _LocalBooleanValueBlock extends HexBlock(ValueBlock) {\n  constructor({ value, ...parameters } = {}) {\n    super(parameters);\n    if (parameters.valueHex) {\n      this.valueHexView = BufferSourceConverter.toUint8Array(parameters.valueHex);\n    } else {\n      this.valueHexView = new Uint8Array(1);\n    }\n    if (value) {\n      this.value = value;\n    }\n  }\n  get value() {\n    for (const octet of this.valueHexView) {\n      if (octet > 0) {\n        return true;\n      }\n    }\n    return false;\n  }\n  set value(value) {\n    this.valueHexView[0] = value ? 255 : 0;\n  }\n  fromBER(inputBuffer, inputOffset, inputLength) {\n    const inputView = BufferSourceConverter.toUint8Array(inputBuffer);\n    if (!checkBufferParams(this, inputView, inputOffset, inputLength)) {\n      return -1;\n    }\n    this.valueHexView = inputView.subarray(inputOffset, inputOffset + inputLength);\n    if (inputLength > 1)\n      this.warnings.push(\"Boolean value encoded in more then 1 octet\");\n    this.isHexOnly = true;\n    utilDecodeTC.call(this);\n    this.blockLength = inputLength;\n    return inputOffset + inputLength;\n  }\n  toBER() {\n    return this.valueHexView.slice();\n  }\n  toJSON() {\n    return {\n      ...super.toJSON(),\n      value: this.value\n    };\n  }\n};\n__name(_LocalBooleanValueBlock, \"LocalBooleanValueBlock\");\nvar LocalBooleanValueBlock = _LocalBooleanValueBlock;\nLocalBooleanValueBlock.NAME = \"BooleanValueBlock\";\nvar _a$s;\nvar _Boolean = class _Boolean extends BaseBlock {\n  constructor(parameters = {}) {\n    super(parameters, LocalBooleanValueBlock);\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 1;\n  }\n  getValue() {\n    return this.valueBlock.value;\n  }\n  setValue(value) {\n    this.valueBlock.value = value;\n  }\n  onAsciiEncoding() {\n    return `${this.constructor.NAME} : ${this.getValue}`;\n  }\n};\n__name(_Boolean, \"Boolean\");\nvar Boolean = _Boolean;\n_a$s = Boolean;\n(() => {\n  typeStore.Boolean = _a$s;\n})();\nBoolean.NAME = \"BOOLEAN\";\nvar _LocalOctetStringValueBlock = class _LocalOctetStringValueBlock extends HexBlock(LocalConstructedValueBlock) {\n  constructor({ isConstructed = false, ...parameters } = {}) {\n    super(parameters);\n    this.isConstructed = isConstructed;\n  }\n  fromBER(inputBuffer, inputOffset, inputLength) {\n    let resultOffset = 0;\n    if (this.isConstructed) {\n      this.isHexOnly = false;\n      resultOffset = LocalConstructedValueBlock.prototype.fromBER.call(this, inputBuffer, inputOffset, inputLength);\n      if (resultOffset === -1)\n        return resultOffset;\n      for (let i = 0; i < this.value.length; i++) {\n        const currentBlockName = this.value[i].constructor.NAME;\n        if (currentBlockName === END_OF_CONTENT_NAME) {\n          if (this.isIndefiniteForm)\n            break;\n          else {\n            this.error = \"EndOfContent is unexpected, OCTET STRING may consists of OCTET STRINGs only\";\n            return -1;\n          }\n        }\n        if (currentBlockName !== OCTET_STRING_NAME) {\n          this.error = \"OCTET STRING may consists of OCTET STRINGs only\";\n          return -1;\n        }\n      }\n    } else {\n      this.isHexOnly = true;\n      resultOffset = super.fromBER(inputBuffer, inputOffset, inputLength);\n      this.blockLength = inputLength;\n    }\n    return resultOffset;\n  }\n  toBER(sizeOnly, writer) {\n    if (this.isConstructed)\n      return LocalConstructedValueBlock.prototype.toBER.call(this, sizeOnly, writer);\n    return sizeOnly ? new ArrayBuffer(this.valueHexView.byteLength) : this.valueHexView.slice().buffer;\n  }\n  toJSON() {\n    return {\n      ...super.toJSON(),\n      isConstructed: this.isConstructed\n    };\n  }\n};\n__name(_LocalOctetStringValueBlock, \"LocalOctetStringValueBlock\");\nvar LocalOctetStringValueBlock = _LocalOctetStringValueBlock;\nLocalOctetStringValueBlock.NAME = \"OctetStringValueBlock\";\nvar _a$r;\nvar _OctetString = class _OctetString extends BaseBlock {\n  constructor({ idBlock = {}, lenBlock = {}, ...parameters } = {}) {\n    var _b, _c;\n    (_b = parameters.isConstructed) !== null && _b !== void 0 ? _b : parameters.isConstructed = !!((_c = parameters.value) === null || _c === void 0 ? void 0 : _c.length);\n    super({\n      idBlock: {\n        isConstructed: parameters.isConstructed,\n        ...idBlock\n      },\n      lenBlock: {\n        ...lenBlock,\n        isIndefiniteForm: !!parameters.isIndefiniteForm\n      },\n      ...parameters\n    }, LocalOctetStringValueBlock);\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 4;\n  }\n  fromBER(inputBuffer, inputOffset, inputLength) {\n    this.valueBlock.isConstructed = this.idBlock.isConstructed;\n    this.valueBlock.isIndefiniteForm = this.lenBlock.isIndefiniteForm;\n    if (inputLength === 0) {\n      if (this.idBlock.error.length === 0)\n        this.blockLength += this.idBlock.blockLength;\n      if (this.lenBlock.error.length === 0)\n        this.blockLength += this.lenBlock.blockLength;\n      return inputOffset;\n    }\n    if (!this.valueBlock.isConstructed) {\n      const view = inputBuffer instanceof ArrayBuffer ? new Uint8Array(inputBuffer) : inputBuffer;\n      const buf = view.subarray(inputOffset, inputOffset + inputLength);\n      try {\n        if (buf.byteLength) {\n          const asn = localFromBER(buf, 0, buf.byteLength);\n          if (asn.offset !== -1 && asn.offset === inputLength) {\n            this.valueBlock.value = [asn.result];\n          }\n        }\n      } catch (e) {\n      }\n    }\n    return super.fromBER(inputBuffer, inputOffset, inputLength);\n  }\n  onAsciiEncoding() {\n    if (this.valueBlock.isConstructed || this.valueBlock.value && this.valueBlock.value.length) {\n      return Constructed.prototype.onAsciiEncoding.call(this);\n    }\n    return `${this.constructor.NAME} : ${Convert.ToHex(this.valueBlock.valueHexView)}`;\n  }\n  getValue() {\n    if (!this.idBlock.isConstructed) {\n      return this.valueBlock.valueHexView.slice().buffer;\n    }\n    const array = [];\n    for (const content of this.valueBlock.value) {\n      if (content instanceof _OctetString) {\n        array.push(content.valueBlock.valueHexView);\n      }\n    }\n    return BufferSourceConverter.concat(array);\n  }\n};\n__name(_OctetString, \"OctetString\");\nvar OctetString = _OctetString;\n_a$r = OctetString;\n(() => {\n  typeStore.OctetString = _a$r;\n})();\nOctetString.NAME = OCTET_STRING_NAME;\nvar _LocalBitStringValueBlock = class _LocalBitStringValueBlock extends HexBlock(LocalConstructedValueBlock) {\n  constructor({ unusedBits = 0, isConstructed = false, ...parameters } = {}) {\n    super(parameters);\n    this.unusedBits = unusedBits;\n    this.isConstructed = isConstructed;\n    this.blockLength = this.valueHexView.byteLength;\n  }\n  fromBER(inputBuffer, inputOffset, inputLength) {\n    if (!inputLength) {\n      return inputOffset;\n    }\n    let resultOffset = -1;\n    if (this.isConstructed) {\n      resultOffset = LocalConstructedValueBlock.prototype.fromBER.call(this, inputBuffer, inputOffset, inputLength);\n      if (resultOffset === -1)\n        return resultOffset;\n      for (const value of this.value) {\n        const currentBlockName = value.constructor.NAME;\n        if (currentBlockName === END_OF_CONTENT_NAME) {\n          if (this.isIndefiniteForm)\n            break;\n          else {\n            this.error = \"EndOfContent is unexpected, BIT STRING may consists of BIT STRINGs only\";\n            return -1;\n          }\n        }\n        if (currentBlockName !== BIT_STRING_NAME) {\n          this.error = \"BIT STRING may consists of BIT STRINGs only\";\n          return -1;\n        }\n        const valueBlock = value.valueBlock;\n        if (this.unusedBits > 0 && valueBlock.unusedBits > 0) {\n          this.error = 'Using of \"unused bits\" inside constructive BIT STRING allowed for least one only';\n          return -1;\n        }\n        this.unusedBits = valueBlock.unusedBits;\n      }\n      return resultOffset;\n    }\n    const inputView = BufferSourceConverter.toUint8Array(inputBuffer);\n    if (!checkBufferParams(this, inputView, inputOffset, inputLength)) {\n      return -1;\n    }\n    const intBuffer = inputView.subarray(inputOffset, inputOffset + inputLength);\n    this.unusedBits = intBuffer[0];\n    if (this.unusedBits > 7) {\n      this.error = \"Unused bits for BitString must be in range 0-7\";\n      return -1;\n    }\n    if (!this.unusedBits) {\n      const buf = intBuffer.subarray(1);\n      try {\n        if (buf.byteLength) {\n          const asn = localFromBER(buf, 0, buf.byteLength);\n          if (asn.offset !== -1 && asn.offset === inputLength - 1) {\n            this.value = [asn.result];\n          }\n        }\n      } catch (e) {\n      }\n    }\n    this.valueHexView = intBuffer.subarray(1);\n    this.blockLength = intBuffer.length;\n    return inputOffset + inputLength;\n  }\n  toBER(sizeOnly, writer) {\n    if (this.isConstructed) {\n      return LocalConstructedValueBlock.prototype.toBER.call(this, sizeOnly, writer);\n    }\n    if (sizeOnly) {\n      return new ArrayBuffer(this.valueHexView.byteLength + 1);\n    }\n    if (!this.valueHexView.byteLength) {\n      return EMPTY_BUFFER;\n    }\n    const retView = new Uint8Array(this.valueHexView.length + 1);\n    retView[0] = this.unusedBits;\n    retView.set(this.valueHexView, 1);\n    return retView.buffer;\n  }\n  toJSON() {\n    return {\n      ...super.toJSON(),\n      unusedBits: this.unusedBits,\n      isConstructed: this.isConstructed\n    };\n  }\n};\n__name(_LocalBitStringValueBlock, \"LocalBitStringValueBlock\");\nvar LocalBitStringValueBlock = _LocalBitStringValueBlock;\nLocalBitStringValueBlock.NAME = \"BitStringValueBlock\";\nvar _a$q;\nvar _BitString = class _BitString extends BaseBlock {\n  constructor({ idBlock = {}, lenBlock = {}, ...parameters } = {}) {\n    var _b, _c;\n    (_b = parameters.isConstructed) !== null && _b !== void 0 ? _b : parameters.isConstructed = !!((_c = parameters.value) === null || _c === void 0 ? void 0 : _c.length);\n    super({\n      idBlock: {\n        isConstructed: parameters.isConstructed,\n        ...idBlock\n      },\n      lenBlock: {\n        ...lenBlock,\n        isIndefiniteForm: !!parameters.isIndefiniteForm\n      },\n      ...parameters\n    }, LocalBitStringValueBlock);\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 3;\n  }\n  fromBER(inputBuffer, inputOffset, inputLength) {\n    this.valueBlock.isConstructed = this.idBlock.isConstructed;\n    this.valueBlock.isIndefiniteForm = this.lenBlock.isIndefiniteForm;\n    return super.fromBER(inputBuffer, inputOffset, inputLength);\n  }\n  onAsciiEncoding() {\n    if (this.valueBlock.isConstructed || this.valueBlock.value && this.valueBlock.value.length) {\n      return Constructed.prototype.onAsciiEncoding.call(this);\n    } else {\n      const bits = [];\n      const valueHex = this.valueBlock.valueHexView;\n      for (const byte of valueHex) {\n        bits.push(byte.toString(2).padStart(8, \"0\"));\n      }\n      const bitsStr = bits.join(\"\");\n      return `${this.constructor.NAME} : ${bitsStr.substring(0, bitsStr.length - this.valueBlock.unusedBits)}`;\n    }\n  }\n};\n__name(_BitString, \"BitString\");\nvar BitString = _BitString;\n_a$q = BitString;\n(() => {\n  typeStore.BitString = _a$q;\n})();\nBitString.NAME = BIT_STRING_NAME;\nvar _a$p;\nfunction viewAdd(first, second) {\n  const c = new Uint8Array([0]);\n  const firstView = new Uint8Array(first);\n  const secondView = new Uint8Array(second);\n  let firstViewCopy = firstView.slice(0);\n  const firstViewCopyLength = firstViewCopy.length - 1;\n  const secondViewCopy = secondView.slice(0);\n  const secondViewCopyLength = secondViewCopy.length - 1;\n  let value = 0;\n  const max = secondViewCopyLength < firstViewCopyLength ? firstViewCopyLength : secondViewCopyLength;\n  let counter = 0;\n  for (let i = max; i >= 0; i--, counter++) {\n    switch (true) {\n      case counter < secondViewCopy.length:\n        value = firstViewCopy[firstViewCopyLength - counter] + secondViewCopy[secondViewCopyLength - counter] + c[0];\n        break;\n      default:\n        value = firstViewCopy[firstViewCopyLength - counter] + c[0];\n    }\n    c[0] = value / 10;\n    switch (true) {\n      case counter >= firstViewCopy.length:\n        firstViewCopy = utilConcatView(new Uint8Array([value % 10]), firstViewCopy);\n        break;\n      default:\n        firstViewCopy[firstViewCopyLength - counter] = value % 10;\n    }\n  }\n  if (c[0] > 0)\n    firstViewCopy = utilConcatView(c, firstViewCopy);\n  return firstViewCopy;\n}\n__name(viewAdd, \"viewAdd\");\nfunction power2(n) {\n  if (n >= powers2.length) {\n    for (let p = powers2.length; p <= n; p++) {\n      const c = new Uint8Array([0]);\n      let digits = powers2[p - 1].slice(0);\n      for (let i = digits.length - 1; i >= 0; i--) {\n        const newValue = new Uint8Array([(digits[i] << 1) + c[0]]);\n        c[0] = newValue[0] / 10;\n        digits[i] = newValue[0] % 10;\n      }\n      if (c[0] > 0)\n        digits = utilConcatView(c, digits);\n      powers2.push(digits);\n    }\n  }\n  return powers2[n];\n}\n__name(power2, \"power2\");\nfunction viewSub(first, second) {\n  let b = 0;\n  const firstView = new Uint8Array(first);\n  const secondView = new Uint8Array(second);\n  const firstViewCopy = firstView.slice(0);\n  const firstViewCopyLength = firstViewCopy.length - 1;\n  const secondViewCopy = secondView.slice(0);\n  const secondViewCopyLength = secondViewCopy.length - 1;\n  let value;\n  let counter = 0;\n  for (let i = secondViewCopyLength; i >= 0; i--, counter++) {\n    value = firstViewCopy[firstViewCopyLength - counter] - secondViewCopy[secondViewCopyLength - counter] - b;\n    switch (true) {\n      case value < 0:\n        b = 1;\n        firstViewCopy[firstViewCopyLength - counter] = value + 10;\n        break;\n      default:\n        b = 0;\n        firstViewCopy[firstViewCopyLength - counter] = value;\n    }\n  }\n  if (b > 0) {\n    for (let i = firstViewCopyLength - secondViewCopyLength + 1; i >= 0; i--, counter++) {\n      value = firstViewCopy[firstViewCopyLength - counter] - b;\n      if (value < 0) {\n        b = 1;\n        firstViewCopy[firstViewCopyLength - counter] = value + 10;\n      } else {\n        b = 0;\n        firstViewCopy[firstViewCopyLength - counter] = value;\n        break;\n      }\n    }\n  }\n  return firstViewCopy.slice();\n}\n__name(viewSub, \"viewSub\");\nvar _LocalIntegerValueBlock = class _LocalIntegerValueBlock extends HexBlock(ValueBlock) {\n  constructor({ value, ...parameters } = {}) {\n    super(parameters);\n    this._valueDec = 0;\n    if (parameters.valueHex) {\n      this.setValueHex();\n    }\n    if (value !== void 0) {\n      this.valueDec = value;\n    }\n  }\n  setValueHex() {\n    if (this.valueHexView.length >= 4) {\n      this.warnings.push(\"Too big Integer for decoding, hex only\");\n      this.isHexOnly = true;\n      this._valueDec = 0;\n    } else {\n      this.isHexOnly = false;\n      if (this.valueHexView.length > 0) {\n        this._valueDec = utilDecodeTC.call(this);\n      }\n    }\n  }\n  set valueDec(v) {\n    this._valueDec = v;\n    this.isHexOnly = false;\n    this.valueHexView = new Uint8Array(utilEncodeTC(v));\n  }\n  get valueDec() {\n    return this._valueDec;\n  }\n  fromDER(inputBuffer, inputOffset, inputLength, expectedLength = 0) {\n    const offset = this.fromBER(inputBuffer, inputOffset, inputLength);\n    if (offset === -1)\n      return offset;\n    const view = this.valueHexView;\n    if (view[0] === 0 && (view[1] & 128) !== 0) {\n      this.valueHexView = view.subarray(1);\n    } else {\n      if (expectedLength !== 0) {\n        if (view.length < expectedLength) {\n          if (expectedLength - view.length > 1)\n            expectedLength = view.length + 1;\n          this.valueHexView = view.subarray(expectedLength - view.length);\n        }\n      }\n    }\n    return offset;\n  }\n  toDER(sizeOnly = false) {\n    const view = this.valueHexView;\n    switch (true) {\n      case (view[0] & 128) !== 0:\n        {\n          const updatedView = new Uint8Array(this.valueHexView.length + 1);\n          updatedView[0] = 0;\n          updatedView.set(view, 1);\n          this.valueHexView = updatedView;\n        }\n        break;\n      case (view[0] === 0 && (view[1] & 128) === 0):\n        {\n          this.valueHexView = this.valueHexView.subarray(1);\n        }\n        break;\n    }\n    return this.toBER(sizeOnly);\n  }\n  fromBER(inputBuffer, inputOffset, inputLength) {\n    const resultOffset = super.fromBER(inputBuffer, inputOffset, inputLength);\n    if (resultOffset === -1) {\n      return resultOffset;\n    }\n    this.setValueHex();\n    return resultOffset;\n  }\n  toBER(sizeOnly) {\n    return sizeOnly ? new ArrayBuffer(this.valueHexView.length) : this.valueHexView.slice().buffer;\n  }\n  toJSON() {\n    return {\n      ...super.toJSON(),\n      valueDec: this.valueDec\n    };\n  }\n  toString() {\n    const firstBit = this.valueHexView.length * 8 - 1;\n    let digits = new Uint8Array(this.valueHexView.length * 8 / 3);\n    let bitNumber = 0;\n    let currentByte;\n    const asn1View = this.valueHexView;\n    let result = \"\";\n    let flag = false;\n    for (let byteNumber = asn1View.byteLength - 1; byteNumber >= 0; byteNumber--) {\n      currentByte = asn1View[byteNumber];\n      for (let i = 0; i < 8; i++) {\n        if ((currentByte & 1) === 1) {\n          switch (bitNumber) {\n            case firstBit:\n              digits = viewSub(power2(bitNumber), digits);\n              result = \"-\";\n              break;\n            default:\n              digits = viewAdd(digits, power2(bitNumber));\n          }\n        }\n        bitNumber++;\n        currentByte >>= 1;\n      }\n    }\n    for (let i = 0; i < digits.length; i++) {\n      if (digits[i])\n        flag = true;\n      if (flag)\n        result += digitsString.charAt(digits[i]);\n    }\n    if (flag === false)\n      result += digitsString.charAt(0);\n    return result;\n  }\n};\n__name(_LocalIntegerValueBlock, \"LocalIntegerValueBlock\");\nvar LocalIntegerValueBlock = _LocalIntegerValueBlock;\n_a$p = LocalIntegerValueBlock;\nLocalIntegerValueBlock.NAME = \"IntegerValueBlock\";\n(() => {\n  Object.defineProperty(_a$p.prototype, \"valueHex\", {\n    set: function(v) {\n      this.valueHexView = new Uint8Array(v);\n      this.setValueHex();\n    },\n    get: function() {\n      return this.valueHexView.slice().buffer;\n    }\n  });\n})();\nvar _a$o;\nvar _Integer = class _Integer extends BaseBlock {\n  constructor(parameters = {}) {\n    super(parameters, LocalIntegerValueBlock);\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 2;\n  }\n  toBigInt() {\n    assertBigInt();\n    return BigInt(this.valueBlock.toString());\n  }\n  static fromBigInt(value) {\n    assertBigInt();\n    const bigIntValue = BigInt(value);\n    const writer = new ViewWriter();\n    const hex = bigIntValue.toString(16).replace(/^-/, \"\");\n    const view = new Uint8Array(Convert.FromHex(hex));\n    if (bigIntValue < 0) {\n      const first = new Uint8Array(view.length + (view[0] & 128 ? 1 : 0));\n      first[0] |= 128;\n      const firstInt = BigInt(`0x${Convert.ToHex(first)}`);\n      const secondInt = firstInt + bigIntValue;\n      const second = BufferSourceConverter.toUint8Array(Convert.FromHex(secondInt.toString(16)));\n      second[0] |= 128;\n      writer.write(second);\n    } else {\n      if (view[0] & 128) {\n        writer.write(new Uint8Array([0]));\n      }\n      writer.write(view);\n    }\n    const res = new _Integer({\n      valueHex: writer.final()\n    });\n    return res;\n  }\n  convertToDER() {\n    const integer = new _Integer({ valueHex: this.valueBlock.valueHexView });\n    integer.valueBlock.toDER();\n    return integer;\n  }\n  convertFromDER() {\n    return new _Integer({\n      valueHex: this.valueBlock.valueHexView[0] === 0 ? this.valueBlock.valueHexView.subarray(1) : this.valueBlock.valueHexView\n    });\n  }\n  onAsciiEncoding() {\n    return `${this.constructor.NAME} : ${this.valueBlock.toString()}`;\n  }\n};\n__name(_Integer, \"Integer\");\nvar Integer = _Integer;\n_a$o = Integer;\n(() => {\n  typeStore.Integer = _a$o;\n})();\nInteger.NAME = \"INTEGER\";\nvar _a$n;\nvar _Enumerated = class _Enumerated extends Integer {\n  constructor(parameters = {}) {\n    super(parameters);\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 10;\n  }\n};\n__name(_Enumerated, \"Enumerated\");\nvar Enumerated = _Enumerated;\n_a$n = Enumerated;\n(() => {\n  typeStore.Enumerated = _a$n;\n})();\nEnumerated.NAME = \"ENUMERATED\";\nvar _LocalSidValueBlock = class _LocalSidValueBlock extends HexBlock(ValueBlock) {\n  constructor({ valueDec = -1, isFirstSid = false, ...parameters } = {}) {\n    super(parameters);\n    this.valueDec = valueDec;\n    this.isFirstSid = isFirstSid;\n  }\n  fromBER(inputBuffer, inputOffset, inputLength) {\n    if (!inputLength) {\n      return inputOffset;\n    }\n    const inputView = BufferSourceConverter.toUint8Array(inputBuffer);\n    if (!checkBufferParams(this, inputView, inputOffset, inputLength)) {\n      return -1;\n    }\n    const intBuffer = inputView.subarray(inputOffset, inputOffset + inputLength);\n    this.valueHexView = new Uint8Array(inputLength);\n    for (let i = 0; i < inputLength; i++) {\n      this.valueHexView[i] = intBuffer[i] & 127;\n      this.blockLength++;\n      if ((intBuffer[i] & 128) === 0)\n        break;\n    }\n    const tempView = new Uint8Array(this.blockLength);\n    for (let i = 0; i < this.blockLength; i++) {\n      tempView[i] = this.valueHexView[i];\n    }\n    this.valueHexView = tempView;\n    if ((intBuffer[this.blockLength - 1] & 128) !== 0) {\n      this.error = \"End of input reached before message was fully decoded\";\n      return -1;\n    }\n    if (this.valueHexView[0] === 0)\n      this.warnings.push(\"Needlessly long format of SID encoding\");\n    if (this.blockLength <= 8)\n      this.valueDec = utilFromBase(this.valueHexView, 7);\n    else {\n      this.isHexOnly = true;\n      this.warnings.push(\"Too big SID for decoding, hex only\");\n    }\n    return inputOffset + this.blockLength;\n  }\n  set valueBigInt(value) {\n    assertBigInt();\n    let bits = BigInt(value).toString(2);\n    while (bits.length % 7) {\n      bits = \"0\" + bits;\n    }\n    const bytes = new Uint8Array(bits.length / 7);\n    for (let i = 0; i < bytes.length; i++) {\n      bytes[i] = parseInt(bits.slice(i * 7, i * 7 + 7), 2) + (i + 1 < bytes.length ? 128 : 0);\n    }\n    this.fromBER(bytes.buffer, 0, bytes.length);\n  }\n  toBER(sizeOnly) {\n    if (this.isHexOnly) {\n      if (sizeOnly)\n        return new ArrayBuffer(this.valueHexView.byteLength);\n      const curView = this.valueHexView;\n      const retView2 = new Uint8Array(this.blockLength);\n      for (let i = 0; i < this.blockLength - 1; i++)\n        retView2[i] = curView[i] | 128;\n      retView2[this.blockLength - 1] = curView[this.blockLength - 1];\n      return retView2.buffer;\n    }\n    const encodedBuf = utilToBase(this.valueDec, 7);\n    if (encodedBuf.byteLength === 0) {\n      this.error = \"Error during encoding SID value\";\n      return EMPTY_BUFFER;\n    }\n    const retView = new Uint8Array(encodedBuf.byteLength);\n    if (!sizeOnly) {\n      const encodedView = new Uint8Array(encodedBuf);\n      const len = encodedBuf.byteLength - 1;\n      for (let i = 0; i < len; i++)\n        retView[i] = encodedView[i] | 128;\n      retView[len] = encodedView[len];\n    }\n    return retView;\n  }\n  toString() {\n    let result = \"\";\n    if (this.isHexOnly)\n      result = Convert.ToHex(this.valueHexView);\n    else {\n      if (this.isFirstSid) {\n        let sidValue = this.valueDec;\n        if (this.valueDec <= 39)\n          result = \"0.\";\n        else {\n          if (this.valueDec <= 79) {\n            result = \"1.\";\n            sidValue -= 40;\n          } else {\n            result = \"2.\";\n            sidValue -= 80;\n          }\n        }\n        result += sidValue.toString();\n      } else\n        result = this.valueDec.toString();\n    }\n    return result;\n  }\n  toJSON() {\n    return {\n      ...super.toJSON(),\n      valueDec: this.valueDec,\n      isFirstSid: this.isFirstSid\n    };\n  }\n};\n__name(_LocalSidValueBlock, \"LocalSidValueBlock\");\nvar LocalSidValueBlock = _LocalSidValueBlock;\nLocalSidValueBlock.NAME = \"sidBlock\";\nvar _LocalObjectIdentifierValueBlock = class _LocalObjectIdentifierValueBlock extends ValueBlock {\n  constructor({ value = EMPTY_STRING, ...parameters } = {}) {\n    super(parameters);\n    this.value = [];\n    if (value) {\n      this.fromString(value);\n    }\n  }\n  fromBER(inputBuffer, inputOffset, inputLength) {\n    let resultOffset = inputOffset;\n    while (inputLength > 0) {\n      const sidBlock = new LocalSidValueBlock();\n      resultOffset = sidBlock.fromBER(inputBuffer, resultOffset, inputLength);\n      if (resultOffset === -1) {\n        this.blockLength = 0;\n        this.error = sidBlock.error;\n        return resultOffset;\n      }\n      if (this.value.length === 0)\n        sidBlock.isFirstSid = true;\n      this.blockLength += sidBlock.blockLength;\n      inputLength -= sidBlock.blockLength;\n      this.value.push(sidBlock);\n    }\n    return resultOffset;\n  }\n  toBER(sizeOnly) {\n    const retBuffers = [];\n    for (let i = 0; i < this.value.length; i++) {\n      const valueBuf = this.value[i].toBER(sizeOnly);\n      if (valueBuf.byteLength === 0) {\n        this.error = this.value[i].error;\n        return EMPTY_BUFFER;\n      }\n      retBuffers.push(valueBuf);\n    }\n    return concat(retBuffers);\n  }\n  fromString(string) {\n    this.value = [];\n    let pos1 = 0;\n    let pos2 = 0;\n    let sid = \"\";\n    let flag = false;\n    do {\n      pos2 = string.indexOf(\".\", pos1);\n      if (pos2 === -1)\n        sid = string.substring(pos1);\n      else\n        sid = string.substring(pos1, pos2);\n      pos1 = pos2 + 1;\n      if (flag) {\n        const sidBlock = this.value[0];\n        let plus = 0;\n        switch (sidBlock.valueDec) {\n          case 0:\n            break;\n          case 1:\n            plus = 40;\n            break;\n          case 2:\n            plus = 80;\n            break;\n          default:\n            this.value = [];\n            return;\n        }\n        const parsedSID = parseInt(sid, 10);\n        if (isNaN(parsedSID))\n          return;\n        sidBlock.valueDec = parsedSID + plus;\n        flag = false;\n      } else {\n        const sidBlock = new LocalSidValueBlock();\n        if (sid > Number.MAX_SAFE_INTEGER) {\n          assertBigInt();\n          const sidValue = BigInt(sid);\n          sidBlock.valueBigInt = sidValue;\n        } else {\n          sidBlock.valueDec = parseInt(sid, 10);\n          if (isNaN(sidBlock.valueDec))\n            return;\n        }\n        if (!this.value.length) {\n          sidBlock.isFirstSid = true;\n          flag = true;\n        }\n        this.value.push(sidBlock);\n      }\n    } while (pos2 !== -1);\n  }\n  toString() {\n    let result = \"\";\n    let isHexOnly = false;\n    for (let i = 0; i < this.value.length; i++) {\n      isHexOnly = this.value[i].isHexOnly;\n      let sidStr = this.value[i].toString();\n      if (i !== 0)\n        result = `${result}.`;\n      if (isHexOnly) {\n        sidStr = `{${sidStr}}`;\n        if (this.value[i].isFirstSid)\n          result = `2.{${sidStr} - 80}`;\n        else\n          result += sidStr;\n      } else\n        result += sidStr;\n    }\n    return result;\n  }\n  toJSON() {\n    const object = {\n      ...super.toJSON(),\n      value: this.toString(),\n      sidArray: []\n    };\n    for (let i = 0; i < this.value.length; i++) {\n      object.sidArray.push(this.value[i].toJSON());\n    }\n    return object;\n  }\n};\n__name(_LocalObjectIdentifierValueBlock, \"LocalObjectIdentifierValueBlock\");\nvar LocalObjectIdentifierValueBlock = _LocalObjectIdentifierValueBlock;\nLocalObjectIdentifierValueBlock.NAME = \"ObjectIdentifierValueBlock\";\nvar _a$m;\nvar _ObjectIdentifier = class _ObjectIdentifier extends BaseBlock {\n  constructor(parameters = {}) {\n    super(parameters, LocalObjectIdentifierValueBlock);\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 6;\n  }\n  getValue() {\n    return this.valueBlock.toString();\n  }\n  setValue(value) {\n    this.valueBlock.fromString(value);\n  }\n  onAsciiEncoding() {\n    return `${this.constructor.NAME} : ${this.valueBlock.toString() || \"empty\"}`;\n  }\n  toJSON() {\n    return {\n      ...super.toJSON(),\n      value: this.getValue()\n    };\n  }\n};\n__name(_ObjectIdentifier, \"ObjectIdentifier\");\nvar ObjectIdentifier = _ObjectIdentifier;\n_a$m = ObjectIdentifier;\n(() => {\n  typeStore.ObjectIdentifier = _a$m;\n})();\nObjectIdentifier.NAME = \"OBJECT IDENTIFIER\";\nvar _LocalRelativeSidValueBlock = class _LocalRelativeSidValueBlock extends HexBlock(LocalBaseBlock) {\n  constructor({ valueDec = 0, ...parameters } = {}) {\n    super(parameters);\n    this.valueDec = valueDec;\n  }\n  fromBER(inputBuffer, inputOffset, inputLength) {\n    if (inputLength === 0)\n      return inputOffset;\n    const inputView = BufferSourceConverter.toUint8Array(inputBuffer);\n    if (!checkBufferParams(this, inputView, inputOffset, inputLength))\n      return -1;\n    const intBuffer = inputView.subarray(inputOffset, inputOffset + inputLength);\n    this.valueHexView = new Uint8Array(inputLength);\n    for (let i = 0; i < inputLength; i++) {\n      this.valueHexView[i] = intBuffer[i] & 127;\n      this.blockLength++;\n      if ((intBuffer[i] & 128) === 0)\n        break;\n    }\n    const tempView = new Uint8Array(this.blockLength);\n    for (let i = 0; i < this.blockLength; i++)\n      tempView[i] = this.valueHexView[i];\n    this.valueHexView = tempView;\n    if ((intBuffer[this.blockLength - 1] & 128) !== 0) {\n      this.error = \"End of input reached before message was fully decoded\";\n      return -1;\n    }\n    if (this.valueHexView[0] === 0)\n      this.warnings.push(\"Needlessly long format of SID encoding\");\n    if (this.blockLength <= 8)\n      this.valueDec = utilFromBase(this.valueHexView, 7);\n    else {\n      this.isHexOnly = true;\n      this.warnings.push(\"Too big SID for decoding, hex only\");\n    }\n    return inputOffset + this.blockLength;\n  }\n  toBER(sizeOnly) {\n    if (this.isHexOnly) {\n      if (sizeOnly)\n        return new ArrayBuffer(this.valueHexView.byteLength);\n      const curView = this.valueHexView;\n      const retView2 = new Uint8Array(this.blockLength);\n      for (let i = 0; i < this.blockLength - 1; i++)\n        retView2[i] = curView[i] | 128;\n      retView2[this.blockLength - 1] = curView[this.blockLength - 1];\n      return retView2.buffer;\n    }\n    const encodedBuf = utilToBase(this.valueDec, 7);\n    if (encodedBuf.byteLength === 0) {\n      this.error = \"Error during encoding SID value\";\n      return EMPTY_BUFFER;\n    }\n    const retView = new Uint8Array(encodedBuf.byteLength);\n    if (!sizeOnly) {\n      const encodedView = new Uint8Array(encodedBuf);\n      const len = encodedBuf.byteLength - 1;\n      for (let i = 0; i < len; i++)\n        retView[i] = encodedView[i] | 128;\n      retView[len] = encodedView[len];\n    }\n    return retView.buffer;\n  }\n  toString() {\n    let result = \"\";\n    if (this.isHexOnly)\n      result = Convert.ToHex(this.valueHexView);\n    else {\n      result = this.valueDec.toString();\n    }\n    return result;\n  }\n  toJSON() {\n    return {\n      ...super.toJSON(),\n      valueDec: this.valueDec\n    };\n  }\n};\n__name(_LocalRelativeSidValueBlock, \"LocalRelativeSidValueBlock\");\nvar LocalRelativeSidValueBlock = _LocalRelativeSidValueBlock;\nLocalRelativeSidValueBlock.NAME = \"relativeSidBlock\";\nvar _LocalRelativeObjectIdentifierValueBlock = class _LocalRelativeObjectIdentifierValueBlock extends ValueBlock {\n  constructor({ value = EMPTY_STRING, ...parameters } = {}) {\n    super(parameters);\n    this.value = [];\n    if (value) {\n      this.fromString(value);\n    }\n  }\n  fromBER(inputBuffer, inputOffset, inputLength) {\n    let resultOffset = inputOffset;\n    while (inputLength > 0) {\n      const sidBlock = new LocalRelativeSidValueBlock();\n      resultOffset = sidBlock.fromBER(inputBuffer, resultOffset, inputLength);\n      if (resultOffset === -1) {\n        this.blockLength = 0;\n        this.error = sidBlock.error;\n        return resultOffset;\n      }\n      this.blockLength += sidBlock.blockLength;\n      inputLength -= sidBlock.blockLength;\n      this.value.push(sidBlock);\n    }\n    return resultOffset;\n  }\n  toBER(sizeOnly, writer) {\n    const retBuffers = [];\n    for (let i = 0; i < this.value.length; i++) {\n      const valueBuf = this.value[i].toBER(sizeOnly);\n      if (valueBuf.byteLength === 0) {\n        this.error = this.value[i].error;\n        return EMPTY_BUFFER;\n      }\n      retBuffers.push(valueBuf);\n    }\n    return concat(retBuffers);\n  }\n  fromString(string) {\n    this.value = [];\n    let pos1 = 0;\n    let pos2 = 0;\n    let sid = \"\";\n    do {\n      pos2 = string.indexOf(\".\", pos1);\n      if (pos2 === -1)\n        sid = string.substring(pos1);\n      else\n        sid = string.substring(pos1, pos2);\n      pos1 = pos2 + 1;\n      const sidBlock = new LocalRelativeSidValueBlock();\n      sidBlock.valueDec = parseInt(sid, 10);\n      if (isNaN(sidBlock.valueDec))\n        return true;\n      this.value.push(sidBlock);\n    } while (pos2 !== -1);\n    return true;\n  }\n  toString() {\n    let result = \"\";\n    let isHexOnly = false;\n    for (let i = 0; i < this.value.length; i++) {\n      isHexOnly = this.value[i].isHexOnly;\n      let sidStr = this.value[i].toString();\n      if (i !== 0)\n        result = `${result}.`;\n      if (isHexOnly) {\n        sidStr = `{${sidStr}}`;\n        result += sidStr;\n      } else\n        result += sidStr;\n    }\n    return result;\n  }\n  toJSON() {\n    const object = {\n      ...super.toJSON(),\n      value: this.toString(),\n      sidArray: []\n    };\n    for (let i = 0; i < this.value.length; i++)\n      object.sidArray.push(this.value[i].toJSON());\n    return object;\n  }\n};\n__name(_LocalRelativeObjectIdentifierValueBlock, \"LocalRelativeObjectIdentifierValueBlock\");\nvar LocalRelativeObjectIdentifierValueBlock = _LocalRelativeObjectIdentifierValueBlock;\nLocalRelativeObjectIdentifierValueBlock.NAME = \"RelativeObjectIdentifierValueBlock\";\nvar _a$l;\nvar _RelativeObjectIdentifier = class _RelativeObjectIdentifier extends BaseBlock {\n  constructor(parameters = {}) {\n    super(parameters, LocalRelativeObjectIdentifierValueBlock);\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 13;\n  }\n  getValue() {\n    return this.valueBlock.toString();\n  }\n  setValue(value) {\n    this.valueBlock.fromString(value);\n  }\n  onAsciiEncoding() {\n    return `${this.constructor.NAME} : ${this.valueBlock.toString() || \"empty\"}`;\n  }\n  toJSON() {\n    return {\n      ...super.toJSON(),\n      value: this.getValue()\n    };\n  }\n};\n__name(_RelativeObjectIdentifier, \"RelativeObjectIdentifier\");\nvar RelativeObjectIdentifier = _RelativeObjectIdentifier;\n_a$l = RelativeObjectIdentifier;\n(() => {\n  typeStore.RelativeObjectIdentifier = _a$l;\n})();\nRelativeObjectIdentifier.NAME = \"RelativeObjectIdentifier\";\nvar _a$k;\nvar _Sequence = class _Sequence extends Constructed {\n  constructor(parameters = {}) {\n    super(parameters);\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 16;\n  }\n};\n__name(_Sequence, \"Sequence\");\nvar Sequence = _Sequence;\n_a$k = Sequence;\n(() => {\n  typeStore.Sequence = _a$k;\n})();\nSequence.NAME = \"SEQUENCE\";\nvar _a$j;\nvar _Set = class _Set extends Constructed {\n  constructor(parameters = {}) {\n    super(parameters);\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 17;\n  }\n};\n__name(_Set, \"Set\");\nvar Set = _Set;\n_a$j = Set;\n(() => {\n  typeStore.Set = _a$j;\n})();\nSet.NAME = \"SET\";\nvar _LocalStringValueBlock = class _LocalStringValueBlock extends HexBlock(ValueBlock) {\n  constructor({ ...parameters } = {}) {\n    super(parameters);\n    this.isHexOnly = true;\n    this.value = EMPTY_STRING;\n  }\n  toJSON() {\n    return {\n      ...super.toJSON(),\n      value: this.value\n    };\n  }\n};\n__name(_LocalStringValueBlock, \"LocalStringValueBlock\");\nvar LocalStringValueBlock = _LocalStringValueBlock;\nLocalStringValueBlock.NAME = \"StringValueBlock\";\nvar _LocalSimpleStringValueBlock = class _LocalSimpleStringValueBlock extends LocalStringValueBlock {\n};\n__name(_LocalSimpleStringValueBlock, \"LocalSimpleStringValueBlock\");\nvar LocalSimpleStringValueBlock = _LocalSimpleStringValueBlock;\nLocalSimpleStringValueBlock.NAME = \"SimpleStringValueBlock\";\nvar _LocalSimpleStringBlock = class _LocalSimpleStringBlock extends BaseStringBlock {\n  constructor({ ...parameters } = {}) {\n    super(parameters, LocalSimpleStringValueBlock);\n  }\n  fromBuffer(inputBuffer) {\n    this.valueBlock.value = String.fromCharCode.apply(null, BufferSourceConverter.toUint8Array(inputBuffer));\n  }\n  fromString(inputString) {\n    const strLen = inputString.length;\n    const view = this.valueBlock.valueHexView = new Uint8Array(strLen);\n    for (let i = 0; i < strLen; i++)\n      view[i] = inputString.charCodeAt(i);\n    this.valueBlock.value = inputString;\n  }\n};\n__name(_LocalSimpleStringBlock, \"LocalSimpleStringBlock\");\nvar LocalSimpleStringBlock = _LocalSimpleStringBlock;\nLocalSimpleStringBlock.NAME = \"SIMPLE STRING\";\nvar _LocalUtf8StringValueBlock = class _LocalUtf8StringValueBlock extends LocalSimpleStringBlock {\n  fromBuffer(inputBuffer) {\n    this.valueBlock.valueHexView = BufferSourceConverter.toUint8Array(inputBuffer);\n    try {\n      this.valueBlock.value = Convert.ToUtf8String(inputBuffer);\n    } catch (ex) {\n      this.warnings.push(`Error during \"decodeURIComponent\": ${ex}, using raw string`);\n      this.valueBlock.value = Convert.ToBinary(inputBuffer);\n    }\n  }\n  fromString(inputString) {\n    this.valueBlock.valueHexView = new Uint8Array(Convert.FromUtf8String(inputString));\n    this.valueBlock.value = inputString;\n  }\n};\n__name(_LocalUtf8StringValueBlock, \"LocalUtf8StringValueBlock\");\nvar LocalUtf8StringValueBlock = _LocalUtf8StringValueBlock;\nLocalUtf8StringValueBlock.NAME = \"Utf8StringValueBlock\";\nvar _a$i;\nvar _Utf8String = class _Utf8String extends LocalUtf8StringValueBlock {\n  constructor(parameters = {}) {\n    super(parameters);\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 12;\n  }\n};\n__name(_Utf8String, \"Utf8String\");\nvar Utf8String = _Utf8String;\n_a$i = Utf8String;\n(() => {\n  typeStore.Utf8String = _a$i;\n})();\nUtf8String.NAME = \"UTF8String\";\nvar _LocalBmpStringValueBlock = class _LocalBmpStringValueBlock extends LocalSimpleStringBlock {\n  fromBuffer(inputBuffer) {\n    this.valueBlock.value = Convert.ToUtf16String(inputBuffer);\n    this.valueBlock.valueHexView = BufferSourceConverter.toUint8Array(inputBuffer);\n  }\n  fromString(inputString) {\n    this.valueBlock.value = inputString;\n    this.valueBlock.valueHexView = new Uint8Array(Convert.FromUtf16String(inputString));\n  }\n};\n__name(_LocalBmpStringValueBlock, \"LocalBmpStringValueBlock\");\nvar LocalBmpStringValueBlock = _LocalBmpStringValueBlock;\nLocalBmpStringValueBlock.NAME = \"BmpStringValueBlock\";\nvar _a$h;\nvar _BmpString = class _BmpString extends LocalBmpStringValueBlock {\n  constructor({ ...parameters } = {}) {\n    super(parameters);\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 30;\n  }\n};\n__name(_BmpString, \"BmpString\");\nvar BmpString = _BmpString;\n_a$h = BmpString;\n(() => {\n  typeStore.BmpString = _a$h;\n})();\nBmpString.NAME = \"BMPString\";\nvar _LocalUniversalStringValueBlock = class _LocalUniversalStringValueBlock extends LocalSimpleStringBlock {\n  fromBuffer(inputBuffer) {\n    const copyBuffer = ArrayBuffer.isView(inputBuffer) ? inputBuffer.slice().buffer : inputBuffer.slice(0);\n    const valueView = new Uint8Array(copyBuffer);\n    for (let i = 0; i < valueView.length; i += 4) {\n      valueView[i] = valueView[i + 3];\n      valueView[i + 1] = valueView[i + 2];\n      valueView[i + 2] = 0;\n      valueView[i + 3] = 0;\n    }\n    this.valueBlock.value = String.fromCharCode.apply(null, new Uint32Array(copyBuffer));\n  }\n  fromString(inputString) {\n    const strLength = inputString.length;\n    const valueHexView = this.valueBlock.valueHexView = new Uint8Array(strLength * 4);\n    for (let i = 0; i < strLength; i++) {\n      const codeBuf = utilToBase(inputString.charCodeAt(i), 8);\n      const codeView = new Uint8Array(codeBuf);\n      if (codeView.length > 4)\n        continue;\n      const dif = 4 - codeView.length;\n      for (let j = codeView.length - 1; j >= 0; j--)\n        valueHexView[i * 4 + j + dif] = codeView[j];\n    }\n    this.valueBlock.value = inputString;\n  }\n};\n__name(_LocalUniversalStringValueBlock, \"LocalUniversalStringValueBlock\");\nvar LocalUniversalStringValueBlock = _LocalUniversalStringValueBlock;\nLocalUniversalStringValueBlock.NAME = \"UniversalStringValueBlock\";\nvar _a$g;\nvar _UniversalString = class _UniversalString extends LocalUniversalStringValueBlock {\n  constructor({ ...parameters } = {}) {\n    super(parameters);\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 28;\n  }\n};\n__name(_UniversalString, \"UniversalString\");\nvar UniversalString = _UniversalString;\n_a$g = UniversalString;\n(() => {\n  typeStore.UniversalString = _a$g;\n})();\nUniversalString.NAME = \"UniversalString\";\nvar _a$f;\nvar _NumericString = class _NumericString extends LocalSimpleStringBlock {\n  constructor(parameters = {}) {\n    super(parameters);\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 18;\n  }\n};\n__name(_NumericString, \"NumericString\");\nvar NumericString = _NumericString;\n_a$f = NumericString;\n(() => {\n  typeStore.NumericString = _a$f;\n})();\nNumericString.NAME = \"NumericString\";\nvar _a$e;\nvar _PrintableString = class _PrintableString extends LocalSimpleStringBlock {\n  constructor(parameters = {}) {\n    super(parameters);\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 19;\n  }\n};\n__name(_PrintableString, \"PrintableString\");\nvar PrintableString = _PrintableString;\n_a$e = PrintableString;\n(() => {\n  typeStore.PrintableString = _a$e;\n})();\nPrintableString.NAME = \"PrintableString\";\nvar _a$d;\nvar _TeletexString = class _TeletexString extends LocalSimpleStringBlock {\n  constructor(parameters = {}) {\n    super(parameters);\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 20;\n  }\n};\n__name(_TeletexString, \"TeletexString\");\nvar TeletexString = _TeletexString;\n_a$d = TeletexString;\n(() => {\n  typeStore.TeletexString = _a$d;\n})();\nTeletexString.NAME = \"TeletexString\";\nvar _a$c;\nvar _VideotexString = class _VideotexString extends LocalSimpleStringBlock {\n  constructor(parameters = {}) {\n    super(parameters);\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 21;\n  }\n};\n__name(_VideotexString, \"VideotexString\");\nvar VideotexString = _VideotexString;\n_a$c = VideotexString;\n(() => {\n  typeStore.VideotexString = _a$c;\n})();\nVideotexString.NAME = \"VideotexString\";\nvar _a$b;\nvar _IA5String = class _IA5String extends LocalSimpleStringBlock {\n  constructor(parameters = {}) {\n    super(parameters);\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 22;\n  }\n};\n__name(_IA5String, \"IA5String\");\nvar IA5String = _IA5String;\n_a$b = IA5String;\n(() => {\n  typeStore.IA5String = _a$b;\n})();\nIA5String.NAME = \"IA5String\";\nvar _a$a;\nvar _GraphicString = class _GraphicString extends LocalSimpleStringBlock {\n  constructor(parameters = {}) {\n    super(parameters);\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 25;\n  }\n};\n__name(_GraphicString, \"GraphicString\");\nvar GraphicString = _GraphicString;\n_a$a = GraphicString;\n(() => {\n  typeStore.GraphicString = _a$a;\n})();\nGraphicString.NAME = \"GraphicString\";\nvar _a$9;\nvar _VisibleString = class _VisibleString extends LocalSimpleStringBlock {\n  constructor(parameters = {}) {\n    super(parameters);\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 26;\n  }\n};\n__name(_VisibleString, \"VisibleString\");\nvar VisibleString = _VisibleString;\n_a$9 = VisibleString;\n(() => {\n  typeStore.VisibleString = _a$9;\n})();\nVisibleString.NAME = \"VisibleString\";\nvar _a$8;\nvar _GeneralString = class _GeneralString extends LocalSimpleStringBlock {\n  constructor(parameters = {}) {\n    super(parameters);\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 27;\n  }\n};\n__name(_GeneralString, \"GeneralString\");\nvar GeneralString = _GeneralString;\n_a$8 = GeneralString;\n(() => {\n  typeStore.GeneralString = _a$8;\n})();\nGeneralString.NAME = \"GeneralString\";\nvar _a$7;\nvar _CharacterString = class _CharacterString extends LocalSimpleStringBlock {\n  constructor(parameters = {}) {\n    super(parameters);\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 29;\n  }\n};\n__name(_CharacterString, \"CharacterString\");\nvar CharacterString = _CharacterString;\n_a$7 = CharacterString;\n(() => {\n  typeStore.CharacterString = _a$7;\n})();\nCharacterString.NAME = \"CharacterString\";\nvar _a$6;\nvar _UTCTime = class _UTCTime extends VisibleString {\n  constructor({ value, valueDate, ...parameters } = {}) {\n    super(parameters);\n    this.year = 0;\n    this.month = 0;\n    this.day = 0;\n    this.hour = 0;\n    this.minute = 0;\n    this.second = 0;\n    if (value) {\n      this.fromString(value);\n      this.valueBlock.valueHexView = new Uint8Array(value.length);\n      for (let i = 0; i < value.length; i++)\n        this.valueBlock.valueHexView[i] = value.charCodeAt(i);\n    }\n    if (valueDate) {\n      this.fromDate(valueDate);\n      this.valueBlock.valueHexView = new Uint8Array(this.toBuffer());\n    }\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 23;\n  }\n  fromBuffer(inputBuffer) {\n    this.fromString(String.fromCharCode.apply(null, BufferSourceConverter.toUint8Array(inputBuffer)));\n  }\n  toBuffer() {\n    const str = this.toString();\n    const buffer = new ArrayBuffer(str.length);\n    const view = new Uint8Array(buffer);\n    for (let i = 0; i < str.length; i++)\n      view[i] = str.charCodeAt(i);\n    return buffer;\n  }\n  fromDate(inputDate) {\n    this.year = inputDate.getUTCFullYear();\n    this.month = inputDate.getUTCMonth() + 1;\n    this.day = inputDate.getUTCDate();\n    this.hour = inputDate.getUTCHours();\n    this.minute = inputDate.getUTCMinutes();\n    this.second = inputDate.getUTCSeconds();\n  }\n  toDate() {\n    return new Date(Date.UTC(this.year, this.month - 1, this.day, this.hour, this.minute, this.second));\n  }\n  fromString(inputString) {\n    const parser = /(\\d{2})(\\d{2})(\\d{2})(\\d{2})(\\d{2})(\\d{2})Z/ig;\n    const parserArray = parser.exec(inputString);\n    if (parserArray === null) {\n      this.error = \"Wrong input string for conversion\";\n      return;\n    }\n    const year = parseInt(parserArray[1], 10);\n    if (year >= 50)\n      this.year = 1900 + year;\n    else\n      this.year = 2e3 + year;\n    this.month = parseInt(parserArray[2], 10);\n    this.day = parseInt(parserArray[3], 10);\n    this.hour = parseInt(parserArray[4], 10);\n    this.minute = parseInt(parserArray[5], 10);\n    this.second = parseInt(parserArray[6], 10);\n  }\n  toString(encoding = \"iso\") {\n    if (encoding === \"iso\") {\n      const outputArray = new Array(7);\n      outputArray[0] = padNumber(this.year < 2e3 ? this.year - 1900 : this.year - 2e3, 2);\n      outputArray[1] = padNumber(this.month, 2);\n      outputArray[2] = padNumber(this.day, 2);\n      outputArray[3] = padNumber(this.hour, 2);\n      outputArray[4] = padNumber(this.minute, 2);\n      outputArray[5] = padNumber(this.second, 2);\n      outputArray[6] = \"Z\";\n      return outputArray.join(\"\");\n    }\n    return super.toString(encoding);\n  }\n  onAsciiEncoding() {\n    return `${this.constructor.NAME} : ${this.toDate().toISOString()}`;\n  }\n  toJSON() {\n    return {\n      ...super.toJSON(),\n      year: this.year,\n      month: this.month,\n      day: this.day,\n      hour: this.hour,\n      minute: this.minute,\n      second: this.second\n    };\n  }\n};\n__name(_UTCTime, \"UTCTime\");\nvar UTCTime = _UTCTime;\n_a$6 = UTCTime;\n(() => {\n  typeStore.UTCTime = _a$6;\n})();\nUTCTime.NAME = \"UTCTime\";\nvar _a$5;\nvar _GeneralizedTime = class _GeneralizedTime extends UTCTime {\n  constructor(parameters = {}) {\n    var _b;\n    super(parameters);\n    (_b = this.millisecond) !== null && _b !== void 0 ? _b : this.millisecond = 0;\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 24;\n  }\n  fromDate(inputDate) {\n    super.fromDate(inputDate);\n    this.millisecond = inputDate.getUTCMilliseconds();\n  }\n  toDate() {\n    return new Date(Date.UTC(this.year, this.month - 1, this.day, this.hour, this.minute, this.second, this.millisecond));\n  }\n  fromString(inputString) {\n    let isUTC = false;\n    let timeString = \"\";\n    let dateTimeString = \"\";\n    let fractionPart = 0;\n    let parser;\n    let hourDifference = 0;\n    let minuteDifference = 0;\n    if (inputString[inputString.length - 1] === \"Z\") {\n      timeString = inputString.substring(0, inputString.length - 1);\n      isUTC = true;\n    } else {\n      const number = new Number(inputString[inputString.length - 1]);\n      if (isNaN(number.valueOf()))\n        throw new Error(\"Wrong input string for conversion\");\n      timeString = inputString;\n    }\n    if (isUTC) {\n      if (timeString.indexOf(\"+\") !== -1)\n        throw new Error(\"Wrong input string for conversion\");\n      if (timeString.indexOf(\"-\") !== -1)\n        throw new Error(\"Wrong input string for conversion\");\n    } else {\n      let multiplier = 1;\n      let differencePosition = timeString.indexOf(\"+\");\n      let differenceString = \"\";\n      if (differencePosition === -1) {\n        differencePosition = timeString.indexOf(\"-\");\n        multiplier = -1;\n      }\n      if (differencePosition !== -1) {\n        differenceString = timeString.substring(differencePosition + 1);\n        timeString = timeString.substring(0, differencePosition);\n        if (differenceString.length !== 2 && differenceString.length !== 4)\n          throw new Error(\"Wrong input string for conversion\");\n        let number = parseInt(differenceString.substring(0, 2), 10);\n        if (isNaN(number.valueOf()))\n          throw new Error(\"Wrong input string for conversion\");\n        hourDifference = multiplier * number;\n        if (differenceString.length === 4) {\n          number = parseInt(differenceString.substring(2, 4), 10);\n          if (isNaN(number.valueOf()))\n            throw new Error(\"Wrong input string for conversion\");\n          minuteDifference = multiplier * number;\n        }\n      }\n    }\n    let fractionPointPosition = timeString.indexOf(\".\");\n    if (fractionPointPosition === -1)\n      fractionPointPosition = timeString.indexOf(\",\");\n    if (fractionPointPosition !== -1) {\n      const fractionPartCheck = new Number(`0${timeString.substring(fractionPointPosition)}`);\n      if (isNaN(fractionPartCheck.valueOf()))\n        throw new Error(\"Wrong input string for conversion\");\n      fractionPart = fractionPartCheck.valueOf();\n      dateTimeString = timeString.substring(0, fractionPointPosition);\n    } else\n      dateTimeString = timeString;\n    switch (true) {\n      case dateTimeString.length === 8:\n        parser = /(\\d{4})(\\d{2})(\\d{2})/ig;\n        if (fractionPointPosition !== -1)\n          throw new Error(\"Wrong input string for conversion\");\n        break;\n      case dateTimeString.length === 10:\n        parser = /(\\d{4})(\\d{2})(\\d{2})(\\d{2})/ig;\n        if (fractionPointPosition !== -1) {\n          let fractionResult = 60 * fractionPart;\n          this.minute = Math.floor(fractionResult);\n          fractionResult = 60 * (fractionResult - this.minute);\n          this.second = Math.floor(fractionResult);\n          fractionResult = 1e3 * (fractionResult - this.second);\n          this.millisecond = Math.floor(fractionResult);\n        }\n        break;\n      case dateTimeString.length === 12:\n        parser = /(\\d{4})(\\d{2})(\\d{2})(\\d{2})(\\d{2})/ig;\n        if (fractionPointPosition !== -1) {\n          let fractionResult = 60 * fractionPart;\n          this.second = Math.floor(fractionResult);\n          fractionResult = 1e3 * (fractionResult - this.second);\n          this.millisecond = Math.floor(fractionResult);\n        }\n        break;\n      case dateTimeString.length === 14:\n        parser = /(\\d{4})(\\d{2})(\\d{2})(\\d{2})(\\d{2})(\\d{2})/ig;\n        if (fractionPointPosition !== -1) {\n          const fractionResult = 1e3 * fractionPart;\n          this.millisecond = Math.floor(fractionResult);\n        }\n        break;\n      default:\n        throw new Error(\"Wrong input string for conversion\");\n    }\n    const parserArray = parser.exec(dateTimeString);\n    if (parserArray === null)\n      throw new Error(\"Wrong input string for conversion\");\n    for (let j = 1; j < parserArray.length; j++) {\n      switch (j) {\n        case 1:\n          this.year = parseInt(parserArray[j], 10);\n          break;\n        case 2:\n          this.month = parseInt(parserArray[j], 10);\n          break;\n        case 3:\n          this.day = parseInt(parserArray[j], 10);\n          break;\n        case 4:\n          this.hour = parseInt(parserArray[j], 10) + hourDifference;\n          break;\n        case 5:\n          this.minute = parseInt(parserArray[j], 10) + minuteDifference;\n          break;\n        case 6:\n          this.second = parseInt(parserArray[j], 10);\n          break;\n        default:\n          throw new Error(\"Wrong input string for conversion\");\n      }\n    }\n    if (isUTC === false) {\n      const tempDate = new Date(this.year, this.month, this.day, this.hour, this.minute, this.second, this.millisecond);\n      this.year = tempDate.getUTCFullYear();\n      this.month = tempDate.getUTCMonth();\n      this.day = tempDate.getUTCDay();\n      this.hour = tempDate.getUTCHours();\n      this.minute = tempDate.getUTCMinutes();\n      this.second = tempDate.getUTCSeconds();\n      this.millisecond = tempDate.getUTCMilliseconds();\n    }\n  }\n  toString(encoding = \"iso\") {\n    if (encoding === \"iso\") {\n      const outputArray = [];\n      outputArray.push(padNumber(this.year, 4));\n      outputArray.push(padNumber(this.month, 2));\n      outputArray.push(padNumber(this.day, 2));\n      outputArray.push(padNumber(this.hour, 2));\n      outputArray.push(padNumber(this.minute, 2));\n      outputArray.push(padNumber(this.second, 2));\n      if (this.millisecond !== 0) {\n        outputArray.push(\".\");\n        outputArray.push(padNumber(this.millisecond, 3));\n      }\n      outputArray.push(\"Z\");\n      return outputArray.join(\"\");\n    }\n    return super.toString(encoding);\n  }\n  toJSON() {\n    return {\n      ...super.toJSON(),\n      millisecond: this.millisecond\n    };\n  }\n};\n__name(_GeneralizedTime, \"GeneralizedTime\");\nvar GeneralizedTime = _GeneralizedTime;\n_a$5 = GeneralizedTime;\n(() => {\n  typeStore.GeneralizedTime = _a$5;\n})();\nGeneralizedTime.NAME = \"GeneralizedTime\";\nvar _a$4;\nvar _DATE = class _DATE extends Utf8String {\n  constructor(parameters = {}) {\n    super(parameters);\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 31;\n  }\n};\n__name(_DATE, \"DATE\");\nvar DATE = _DATE;\n_a$4 = DATE;\n(() => {\n  typeStore.DATE = _a$4;\n})();\nDATE.NAME = \"DATE\";\nvar _a$3;\nvar _TimeOfDay = class _TimeOfDay extends Utf8String {\n  constructor(parameters = {}) {\n    super(parameters);\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 32;\n  }\n};\n__name(_TimeOfDay, \"TimeOfDay\");\nvar TimeOfDay = _TimeOfDay;\n_a$3 = TimeOfDay;\n(() => {\n  typeStore.TimeOfDay = _a$3;\n})();\nTimeOfDay.NAME = \"TimeOfDay\";\nvar _a$2;\nvar _DateTime = class _DateTime extends Utf8String {\n  constructor(parameters = {}) {\n    super(parameters);\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 33;\n  }\n};\n__name(_DateTime, \"DateTime\");\nvar DateTime = _DateTime;\n_a$2 = DateTime;\n(() => {\n  typeStore.DateTime = _a$2;\n})();\nDateTime.NAME = \"DateTime\";\nvar _a$1;\nvar _Duration = class _Duration extends Utf8String {\n  constructor(parameters = {}) {\n    super(parameters);\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 34;\n  }\n};\n__name(_Duration, \"Duration\");\nvar Duration = _Duration;\n_a$1 = Duration;\n(() => {\n  typeStore.Duration = _a$1;\n})();\nDuration.NAME = \"Duration\";\nvar _a;\nvar _TIME = class _TIME extends Utf8String {\n  constructor(parameters = {}) {\n    super(parameters);\n    this.idBlock.tagClass = 1;\n    this.idBlock.tagNumber = 14;\n  }\n};\n__name(_TIME, \"TIME\");\nvar TIME = _TIME;\n_a = TIME;\n(() => {\n  typeStore.TIME = _a;\n})();\nTIME.NAME = \"TIME\";\nvar _Any = class _Any {\n  constructor({ name = EMPTY_STRING, optional = false } = {}) {\n    this.name = name;\n    this.optional = optional;\n  }\n};\n__name(_Any, \"Any\");\nvar Any = _Any;\nvar _Choice = class _Choice extends Any {\n  constructor({ value = [], ...parameters } = {}) {\n    super(parameters);\n    this.value = value;\n  }\n};\n__name(_Choice, \"Choice\");\nvar Choice = _Choice;\nvar _Repeated = class _Repeated extends Any {\n  constructor({ value = new Any(), local = false, ...parameters } = {}) {\n    super(parameters);\n    this.value = value;\n    this.local = local;\n  }\n};\n__name(_Repeated, \"Repeated\");\nvar Repeated = _Repeated;\nvar _RawData = class _RawData {\n  constructor({ data = EMPTY_VIEW } = {}) {\n    this.dataView = BufferSourceConverter.toUint8Array(data);\n  }\n  get data() {\n    return this.dataView.slice().buffer;\n  }\n  set data(value) {\n    this.dataView = BufferSourceConverter.toUint8Array(value);\n  }\n  fromBER(inputBuffer, inputOffset, inputLength) {\n    const endLength = inputOffset + inputLength;\n    this.dataView = BufferSourceConverter.toUint8Array(inputBuffer).subarray(inputOffset, endLength);\n    return endLength;\n  }\n  toBER(sizeOnly) {\n    return this.dataView.slice().buffer;\n  }\n};\n__name(_RawData, \"RawData\");\nvar RawData = _RawData;\nfunction compareSchema(root, inputData, inputSchema) {\n  if (inputSchema instanceof Choice) {\n    for (let j = 0; j < inputSchema.value.length; j++) {\n      const result = compareSchema(root, inputData, inputSchema.value[j]);\n      if (result.verified) {\n        return {\n          verified: true,\n          result: root\n        };\n      }\n    }\n    {\n      const _result = {\n        verified: false,\n        result: {\n          error: \"Wrong values for Choice type\"\n        }\n      };\n      if (inputSchema.hasOwnProperty(NAME))\n        _result.name = inputSchema.name;\n      return _result;\n    }\n  }\n  if (inputSchema instanceof Any) {\n    if (inputSchema.hasOwnProperty(NAME))\n      root[inputSchema.name] = inputData;\n    return {\n      verified: true,\n      result: root\n    };\n  }\n  if (root instanceof Object === false) {\n    return {\n      verified: false,\n      result: { error: \"Wrong root object\" }\n    };\n  }\n  if (inputData instanceof Object === false) {\n    return {\n      verified: false,\n      result: { error: \"Wrong ASN.1 data\" }\n    };\n  }\n  if (inputSchema instanceof Object === false) {\n    return {\n      verified: false,\n      result: { error: \"Wrong ASN.1 schema\" }\n    };\n  }\n  if (ID_BLOCK in inputSchema === false) {\n    return {\n      verified: false,\n      result: { error: \"Wrong ASN.1 schema\" }\n    };\n  }\n  if (FROM_BER in inputSchema.idBlock === false) {\n    return {\n      verified: false,\n      result: { error: \"Wrong ASN.1 schema\" }\n    };\n  }\n  if (TO_BER in inputSchema.idBlock === false) {\n    return {\n      verified: false,\n      result: { error: \"Wrong ASN.1 schema\" }\n    };\n  }\n  const encodedId = inputSchema.idBlock.toBER(false);\n  if (encodedId.byteLength === 0) {\n    return {\n      verified: false,\n      result: { error: \"Error encoding idBlock for ASN.1 schema\" }\n    };\n  }\n  const decodedOffset = inputSchema.idBlock.fromBER(encodedId, 0, encodedId.byteLength);\n  if (decodedOffset === -1) {\n    return {\n      verified: false,\n      result: { error: \"Error decoding idBlock for ASN.1 schema\" }\n    };\n  }\n  if (inputSchema.idBlock.hasOwnProperty(TAG_CLASS) === false) {\n    return {\n      verified: false,\n      result: { error: \"Wrong ASN.1 schema\" }\n    };\n  }\n  if (inputSchema.idBlock.tagClass !== inputData.idBlock.tagClass) {\n    return {\n      verified: false,\n      result: root\n    };\n  }\n  if (inputSchema.idBlock.hasOwnProperty(TAG_NUMBER) === false) {\n    return {\n      verified: false,\n      result: { error: \"Wrong ASN.1 schema\" }\n    };\n  }\n  if (inputSchema.idBlock.tagNumber !== inputData.idBlock.tagNumber) {\n    return {\n      verified: false,\n      result: root\n    };\n  }\n  if (inputSchema.idBlock.hasOwnProperty(IS_CONSTRUCTED) === false) {\n    return {\n      verified: false,\n      result: { error: \"Wrong ASN.1 schema\" }\n    };\n  }\n  if (inputSchema.idBlock.isConstructed !== inputData.idBlock.isConstructed) {\n    return {\n      verified: false,\n      result: root\n    };\n  }\n  if (!(IS_HEX_ONLY in inputSchema.idBlock)) {\n    return {\n      verified: false,\n      result: { error: \"Wrong ASN.1 schema\" }\n    };\n  }\n  if (inputSchema.idBlock.isHexOnly !== inputData.idBlock.isHexOnly) {\n    return {\n      verified: false,\n      result: root\n    };\n  }\n  if (inputSchema.idBlock.isHexOnly) {\n    if (VALUE_HEX_VIEW in inputSchema.idBlock === false) {\n      return {\n        verified: false,\n        result: { error: \"Wrong ASN.1 schema\" }\n      };\n    }\n    const schemaView = inputSchema.idBlock.valueHexView;\n    const asn1View = inputData.idBlock.valueHexView;\n    if (schemaView.length !== asn1View.length) {\n      return {\n        verified: false,\n        result: root\n      };\n    }\n    for (let i = 0; i < schemaView.length; i++) {\n      if (schemaView[i] !== asn1View[1]) {\n        return {\n          verified: false,\n          result: root\n        };\n      }\n    }\n  }\n  if (inputSchema.name) {\n    inputSchema.name = inputSchema.name.replace(/^\\s+|\\s+$/g, EMPTY_STRING);\n    if (inputSchema.name)\n      root[inputSchema.name] = inputData;\n  }\n  if (inputSchema instanceof typeStore.Constructed) {\n    let admission = 0;\n    let result = {\n      verified: false,\n      result: {\n        error: \"Unknown error\"\n      }\n    };\n    let maxLength = inputSchema.valueBlock.value.length;\n    if (maxLength > 0) {\n      if (inputSchema.valueBlock.value[0] instanceof Repeated) {\n        maxLength = inputData.valueBlock.value.length;\n      }\n    }\n    if (maxLength === 0) {\n      return {\n        verified: true,\n        result: root\n      };\n    }\n    if (inputData.valueBlock.value.length === 0 && inputSchema.valueBlock.value.length !== 0) {\n      let _optional = true;\n      for (let i = 0; i < inputSchema.valueBlock.value.length; i++)\n        _optional = _optional && (inputSchema.valueBlock.value[i].optional || false);\n      if (_optional) {\n        return {\n          verified: true,\n          result: root\n        };\n      }\n      if (inputSchema.name) {\n        inputSchema.name = inputSchema.name.replace(/^\\s+|\\s+$/g, EMPTY_STRING);\n        if (inputSchema.name)\n          delete root[inputSchema.name];\n      }\n      root.error = \"Inconsistent object length\";\n      return {\n        verified: false,\n        result: root\n      };\n    }\n    for (let i = 0; i < maxLength; i++) {\n      if (i - admission >= inputData.valueBlock.value.length) {\n        if (inputSchema.valueBlock.value[i].optional === false) {\n          const _result = {\n            verified: false,\n            result: root\n          };\n          root.error = \"Inconsistent length between ASN.1 data and schema\";\n          if (inputSchema.name) {\n            inputSchema.name = inputSchema.name.replace(/^\\s+|\\s+$/g, EMPTY_STRING);\n            if (inputSchema.name) {\n              delete root[inputSchema.name];\n              _result.name = inputSchema.name;\n            }\n          }\n          return _result;\n        }\n      } else {\n        if (inputSchema.valueBlock.value[0] instanceof Repeated) {\n          result = compareSchema(root, inputData.valueBlock.value[i], inputSchema.valueBlock.value[0].value);\n          if (result.verified === false) {\n            if (inputSchema.valueBlock.value[0].optional)\n              admission++;\n            else {\n              if (inputSchema.name) {\n                inputSchema.name = inputSchema.name.replace(/^\\s+|\\s+$/g, EMPTY_STRING);\n                if (inputSchema.name)\n                  delete root[inputSchema.name];\n              }\n              return result;\n            }\n          }\n          if (NAME in inputSchema.valueBlock.value[0] && inputSchema.valueBlock.value[0].name.length > 0) {\n            let arrayRoot = {};\n            if (LOCAL in inputSchema.valueBlock.value[0] && inputSchema.valueBlock.value[0].local)\n              arrayRoot = inputData;\n            else\n              arrayRoot = root;\n            if (typeof arrayRoot[inputSchema.valueBlock.value[0].name] === \"undefined\")\n              arrayRoot[inputSchema.valueBlock.value[0].name] = [];\n            arrayRoot[inputSchema.valueBlock.value[0].name].push(inputData.valueBlock.value[i]);\n          }\n        } else {\n          result = compareSchema(root, inputData.valueBlock.value[i - admission], inputSchema.valueBlock.value[i]);\n          if (result.verified === false) {\n            if (inputSchema.valueBlock.value[i].optional)\n              admission++;\n            else {\n              if (inputSchema.name) {\n                inputSchema.name = inputSchema.name.replace(/^\\s+|\\s+$/g, EMPTY_STRING);\n                if (inputSchema.name)\n                  delete root[inputSchema.name];\n              }\n              return result;\n            }\n          }\n        }\n      }\n    }\n    if (result.verified === false) {\n      const _result = {\n        verified: false,\n        result: root\n      };\n      if (inputSchema.name) {\n        inputSchema.name = inputSchema.name.replace(/^\\s+|\\s+$/g, EMPTY_STRING);\n        if (inputSchema.name) {\n          delete root[inputSchema.name];\n          _result.name = inputSchema.name;\n        }\n      }\n      return _result;\n    }\n    return {\n      verified: true,\n      result: root\n    };\n  }\n  if (inputSchema.primitiveSchema && VALUE_HEX_VIEW in inputData.valueBlock) {\n    const asn1 = localFromBER(inputData.valueBlock.valueHexView);\n    if (asn1.offset === -1) {\n      const _result = {\n        verified: false,\n        result: asn1.result\n      };\n      if (inputSchema.name) {\n        inputSchema.name = inputSchema.name.replace(/^\\s+|\\s+$/g, EMPTY_STRING);\n        if (inputSchema.name) {\n          delete root[inputSchema.name];\n          _result.name = inputSchema.name;\n        }\n      }\n      return _result;\n    }\n    return compareSchema(root, asn1.result, inputSchema.primitiveSchema);\n  }\n  return {\n    verified: true,\n    result: root\n  };\n}\n__name(compareSchema, \"compareSchema\");\nfunction verifySchema(inputBuffer, inputSchema) {\n  if (inputSchema instanceof Object === false) {\n    return {\n      verified: false,\n      result: { error: \"Wrong ASN.1 schema type\" }\n    };\n  }\n  const asn1 = localFromBER(BufferSourceConverter.toUint8Array(inputBuffer));\n  if (asn1.offset === -1) {\n    return {\n      verified: false,\n      result: asn1.result\n    };\n  }\n  return compareSchema(asn1.result, asn1.result, inputSchema);\n}\n__name(verifySchema, \"verifySchema\");\n\n// ../../node_modules/.pnpm/@peculiar+asn1-schema@2.3.6/node_modules/@peculiar/asn1-schema/build/es2015/enums.js\nvar AsnTypeTypes;\n(function(AsnTypeTypes2) {\n  AsnTypeTypes2[AsnTypeTypes2[\"Sequence\"] = 0] = \"Sequence\";\n  AsnTypeTypes2[AsnTypeTypes2[\"Set\"] = 1] = \"Set\";\n  AsnTypeTypes2[AsnTypeTypes2[\"Choice\"] = 2] = \"Choice\";\n})(AsnTypeTypes || (AsnTypeTypes = {}));\nvar AsnPropTypes;\n(function(AsnPropTypes2) {\n  AsnPropTypes2[AsnPropTypes2[\"Any\"] = 1] = \"Any\";\n  AsnPropTypes2[AsnPropTypes2[\"Boolean\"] = 2] = \"Boolean\";\n  AsnPropTypes2[AsnPropTypes2[\"OctetString\"] = 3] = \"OctetString\";\n  AsnPropTypes2[AsnPropTypes2[\"BitString\"] = 4] = \"BitString\";\n  AsnPropTypes2[AsnPropTypes2[\"Integer\"] = 5] = \"Integer\";\n  AsnPropTypes2[AsnPropTypes2[\"Enumerated\"] = 6] = \"Enumerated\";\n  AsnPropTypes2[AsnPropTypes2[\"ObjectIdentifier\"] = 7] = \"ObjectIdentifier\";\n  AsnPropTypes2[AsnPropTypes2[\"Utf8String\"] = 8] = \"Utf8String\";\n  AsnPropTypes2[AsnPropTypes2[\"BmpString\"] = 9] = \"BmpString\";\n  AsnPropTypes2[AsnPropTypes2[\"UniversalString\"] = 10] = \"UniversalString\";\n  AsnPropTypes2[AsnPropTypes2[\"NumericString\"] = 11] = \"NumericString\";\n  AsnPropTypes2[AsnPropTypes2[\"PrintableString\"] = 12] = \"PrintableString\";\n  AsnPropTypes2[AsnPropTypes2[\"TeletexString\"] = 13] = \"TeletexString\";\n  AsnPropTypes2[AsnPropTypes2[\"VideotexString\"] = 14] = \"VideotexString\";\n  AsnPropTypes2[AsnPropTypes2[\"IA5String\"] = 15] = \"IA5String\";\n  AsnPropTypes2[AsnPropTypes2[\"GraphicString\"] = 16] = \"GraphicString\";\n  AsnPropTypes2[AsnPropTypes2[\"VisibleString\"] = 17] = \"VisibleString\";\n  AsnPropTypes2[AsnPropTypes2[\"GeneralString\"] = 18] = \"GeneralString\";\n  AsnPropTypes2[AsnPropTypes2[\"CharacterString\"] = 19] = \"CharacterString\";\n  AsnPropTypes2[AsnPropTypes2[\"UTCTime\"] = 20] = \"UTCTime\";\n  AsnPropTypes2[AsnPropTypes2[\"GeneralizedTime\"] = 21] = \"GeneralizedTime\";\n  AsnPropTypes2[AsnPropTypes2[\"DATE\"] = 22] = \"DATE\";\n  AsnPropTypes2[AsnPropTypes2[\"TimeOfDay\"] = 23] = \"TimeOfDay\";\n  AsnPropTypes2[AsnPropTypes2[\"DateTime\"] = 24] = \"DateTime\";\n  AsnPropTypes2[AsnPropTypes2[\"Duration\"] = 25] = \"Duration\";\n  AsnPropTypes2[AsnPropTypes2[\"TIME\"] = 26] = \"TIME\";\n  AsnPropTypes2[AsnPropTypes2[\"Null\"] = 27] = \"Null\";\n})(AsnPropTypes || (AsnPropTypes = {}));\n\n// ../../node_modules/.pnpm/@peculiar+asn1-schema@2.3.6/node_modules/@peculiar/asn1-schema/build/es2015/converters.js\nvar AsnAnyConverter = {\n  fromASN: (value) => value instanceof Null ? null : value.valueBeforeDecodeView,\n  toASN: (value) => {\n    if (value === null) {\n      return new Null();\n    }\n    const schema = fromBER(value);\n    if (schema.result.error) {\n      throw new Error(schema.result.error);\n    }\n    return schema.result;\n  }\n};\nvar AsnIntegerConverter = {\n  fromASN: (value) => value.valueBlock.valueHexView.byteLength >= 4 ? value.valueBlock.toString() : value.valueBlock.valueDec,\n  toASN: (value) => new Integer({ value: +value })\n};\nvar AsnEnumeratedConverter = {\n  fromASN: (value) => value.valueBlock.valueDec,\n  toASN: (value) => new Enumerated({ value })\n};\nvar AsnBitStringConverter = {\n  fromASN: (value) => value.valueBlock.valueHexView,\n  toASN: (value) => new BitString({ valueHex: value })\n};\nvar AsnObjectIdentifierConverter = {\n  fromASN: (value) => value.valueBlock.toString(),\n  toASN: (value) => new ObjectIdentifier({ value })\n};\nvar AsnBooleanConverter = {\n  fromASN: (value) => value.valueBlock.value,\n  toASN: (value) => new Boolean({ value })\n};\nvar AsnOctetStringConverter = {\n  fromASN: (value) => value.valueBlock.valueHexView,\n  toASN: (value) => new OctetString({ valueHex: value })\n};\nfunction createStringConverter(Asn1Type) {\n  return {\n    fromASN: (value) => value.valueBlock.value,\n    toASN: (value) => new Asn1Type({ value })\n  };\n}\n__name(createStringConverter, \"createStringConverter\");\nvar AsnUtf8StringConverter = createStringConverter(Utf8String);\nvar AsnBmpStringConverter = createStringConverter(BmpString);\nvar AsnUniversalStringConverter = createStringConverter(UniversalString);\nvar AsnNumericStringConverter = createStringConverter(NumericString);\nvar AsnPrintableStringConverter = createStringConverter(PrintableString);\nvar AsnTeletexStringConverter = createStringConverter(TeletexString);\nvar AsnVideotexStringConverter = createStringConverter(VideotexString);\nvar AsnIA5StringConverter = createStringConverter(IA5String);\nvar AsnGraphicStringConverter = createStringConverter(GraphicString);\nvar AsnVisibleStringConverter = createStringConverter(VisibleString);\nvar AsnGeneralStringConverter = createStringConverter(GeneralString);\nvar AsnCharacterStringConverter = createStringConverter(CharacterString);\nvar AsnUTCTimeConverter = {\n  fromASN: (value) => value.toDate(),\n  toASN: (value) => new UTCTime({ valueDate: value })\n};\nvar AsnGeneralizedTimeConverter = {\n  fromASN: (value) => value.toDate(),\n  toASN: (value) => new GeneralizedTime({ valueDate: value })\n};\nvar AsnNullConverter = {\n  fromASN: () => null,\n  toASN: () => {\n    return new Null();\n  }\n};\nfunction defaultConverter(type) {\n  switch (type) {\n    case AsnPropTypes.Any:\n      return AsnAnyConverter;\n    case AsnPropTypes.BitString:\n      return AsnBitStringConverter;\n    case AsnPropTypes.BmpString:\n      return AsnBmpStringConverter;\n    case AsnPropTypes.Boolean:\n      return AsnBooleanConverter;\n    case AsnPropTypes.CharacterString:\n      return AsnCharacterStringConverter;\n    case AsnPropTypes.Enumerated:\n      return AsnEnumeratedConverter;\n    case AsnPropTypes.GeneralString:\n      return AsnGeneralStringConverter;\n    case AsnPropTypes.GeneralizedTime:\n      return AsnGeneralizedTimeConverter;\n    case AsnPropTypes.GraphicString:\n      return AsnGraphicStringConverter;\n    case AsnPropTypes.IA5String:\n      return AsnIA5StringConverter;\n    case AsnPropTypes.Integer:\n      return AsnIntegerConverter;\n    case AsnPropTypes.Null:\n      return AsnNullConverter;\n    case AsnPropTypes.NumericString:\n      return AsnNumericStringConverter;\n    case AsnPropTypes.ObjectIdentifier:\n      return AsnObjectIdentifierConverter;\n    case AsnPropTypes.OctetString:\n      return AsnOctetStringConverter;\n    case AsnPropTypes.PrintableString:\n      return AsnPrintableStringConverter;\n    case AsnPropTypes.TeletexString:\n      return AsnTeletexStringConverter;\n    case AsnPropTypes.UTCTime:\n      return AsnUTCTimeConverter;\n    case AsnPropTypes.UniversalString:\n      return AsnUniversalStringConverter;\n    case AsnPropTypes.Utf8String:\n      return AsnUtf8StringConverter;\n    case AsnPropTypes.VideotexString:\n      return AsnVideotexStringConverter;\n    case AsnPropTypes.VisibleString:\n      return AsnVisibleStringConverter;\n    default:\n      return null;\n  }\n}\n__name(defaultConverter, \"defaultConverter\");\n\n// ../../node_modules/.pnpm/@peculiar+asn1-schema@2.3.6/node_modules/@peculiar/asn1-schema/build/es2015/helper.js\nfunction isConvertible(target) {\n  if (typeof target === \"function\" && target.prototype) {\n    if (target.prototype.toASN && target.prototype.fromASN) {\n      return true;\n    } else {\n      return isConvertible(target.prototype);\n    }\n  } else {\n    return !!(target && typeof target === \"object\" && \"toASN\" in target && \"fromASN\" in target);\n  }\n}\n__name(isConvertible, \"isConvertible\");\nfunction isTypeOfArray(target) {\n  var _a7;\n  if (target) {\n    const proto = Object.getPrototypeOf(target);\n    if (((_a7 = proto === null || proto === void 0 ? void 0 : proto.prototype) === null || _a7 === void 0 ? void 0 : _a7.constructor) === Array) {\n      return true;\n    }\n    return isTypeOfArray(proto);\n  }\n  return false;\n}\n__name(isTypeOfArray, \"isTypeOfArray\");\nfunction isArrayEqual(bytes1, bytes2) {\n  if (!(bytes1 && bytes2)) {\n    return false;\n  }\n  if (bytes1.byteLength !== bytes2.byteLength) {\n    return false;\n  }\n  const b1 = new Uint8Array(bytes1);\n  const b2 = new Uint8Array(bytes2);\n  for (let i = 0; i < bytes1.byteLength; i++) {\n    if (b1[i] !== b2[i]) {\n      return false;\n    }\n  }\n  return true;\n}\n__name(isArrayEqual, \"isArrayEqual\");\n\n// ../../node_modules/.pnpm/@peculiar+asn1-schema@2.3.6/node_modules/@peculiar/asn1-schema/build/es2015/schema.js\nvar _AsnSchemaStorage = class _AsnSchemaStorage {\n  constructor() {\n    this.items = /* @__PURE__ */ new WeakMap();\n  }\n  has(target) {\n    return this.items.has(target);\n  }\n  get(target, checkSchema = false) {\n    const schema = this.items.get(target);\n    if (!schema) {\n      throw new Error(`Cannot get schema for '${target.prototype.constructor.name}' target`);\n    }\n    if (checkSchema && !schema.schema) {\n      throw new Error(`Schema '${target.prototype.constructor.name}' doesn't contain ASN.1 schema. Call 'AsnSchemaStorage.cache'.`);\n    }\n    return schema;\n  }\n  cache(target) {\n    const schema = this.get(target);\n    if (!schema.schema) {\n      schema.schema = this.create(target, true);\n    }\n  }\n  createDefault(target) {\n    const schema = {\n      type: AsnTypeTypes.Sequence,\n      items: {}\n    };\n    const parentSchema = this.findParentSchema(target);\n    if (parentSchema) {\n      Object.assign(schema, parentSchema);\n      schema.items = Object.assign({}, schema.items, parentSchema.items);\n    }\n    return schema;\n  }\n  create(target, useNames) {\n    const schema = this.items.get(target) || this.createDefault(target);\n    const asn1Value = [];\n    for (const key in schema.items) {\n      const item = schema.items[key];\n      const name = useNames ? key : \"\";\n      let asn1Item;\n      if (typeof item.type === \"number\") {\n        const Asn1TypeName = AsnPropTypes[item.type];\n        const Asn1Type = index_es_exports[Asn1TypeName];\n        if (!Asn1Type) {\n          throw new Error(`Cannot get ASN1 class by name '${Asn1TypeName}'`);\n        }\n        asn1Item = new Asn1Type({ name });\n      } else if (isConvertible(item.type)) {\n        const instance = new item.type();\n        asn1Item = instance.toSchema(name);\n      } else if (item.optional) {\n        const itemSchema = this.get(item.type);\n        if (itemSchema.type === AsnTypeTypes.Choice) {\n          asn1Item = new Any({ name });\n        } else {\n          asn1Item = this.create(item.type, false);\n          asn1Item.name = name;\n        }\n      } else {\n        asn1Item = new Any({ name });\n      }\n      const optional = !!item.optional || item.defaultValue !== void 0;\n      if (item.repeated) {\n        asn1Item.name = \"\";\n        const Container = item.repeated === \"set\" ? Set : Sequence;\n        asn1Item = new Container({\n          name: \"\",\n          value: [\n            new Repeated({\n              name,\n              value: asn1Item\n            })\n          ]\n        });\n      }\n      if (item.context !== null && item.context !== void 0) {\n        if (item.implicit) {\n          if (typeof item.type === \"number\" || isConvertible(item.type)) {\n            const Container = item.repeated ? Constructed : Primitive;\n            asn1Value.push(new Container({\n              name,\n              optional,\n              idBlock: {\n                tagClass: 3,\n                tagNumber: item.context\n              }\n            }));\n          } else {\n            this.cache(item.type);\n            const isRepeated = !!item.repeated;\n            let value = !isRepeated ? this.get(item.type, true).schema : asn1Item;\n            value = \"valueBlock\" in value ? value.valueBlock.value : value.value;\n            asn1Value.push(new Constructed({\n              name: !isRepeated ? name : \"\",\n              optional,\n              idBlock: {\n                tagClass: 3,\n                tagNumber: item.context\n              },\n              value\n            }));\n          }\n        } else {\n          asn1Value.push(new Constructed({\n            optional,\n            idBlock: {\n              tagClass: 3,\n              tagNumber: item.context\n            },\n            value: [asn1Item]\n          }));\n        }\n      } else {\n        asn1Item.optional = optional;\n        asn1Value.push(asn1Item);\n      }\n    }\n    switch (schema.type) {\n      case AsnTypeTypes.Sequence:\n        return new Sequence({ value: asn1Value, name: \"\" });\n      case AsnTypeTypes.Set:\n        return new Set({ value: asn1Value, name: \"\" });\n      case AsnTypeTypes.Choice:\n        return new Choice({ value: asn1Value, name: \"\" });\n      default:\n        throw new Error(`Unsupported ASN1 type in use`);\n    }\n  }\n  set(target, schema) {\n    this.items.set(target, schema);\n    return this;\n  }\n  findParentSchema(target) {\n    const parent = Object.getPrototypeOf(target);\n    if (parent) {\n      const schema = this.items.get(parent);\n      return schema || this.findParentSchema(parent);\n    }\n    return null;\n  }\n};\n__name(_AsnSchemaStorage, \"AsnSchemaStorage\");\nvar AsnSchemaStorage = _AsnSchemaStorage;\n\n// ../../node_modules/.pnpm/@peculiar+asn1-schema@2.3.6/node_modules/@peculiar/asn1-schema/build/es2015/storage.js\nvar schemaStorage = new AsnSchemaStorage();\n\n// ../../node_modules/.pnpm/@peculiar+asn1-schema@2.3.6/node_modules/@peculiar/asn1-schema/build/es2015/decorators.js\nvar AsnType = /* @__PURE__ */ __name((options) => (target) => {\n  let schema;\n  if (!schemaStorage.has(target)) {\n    schema = schemaStorage.createDefault(target);\n    schemaStorage.set(target, schema);\n  } else {\n    schema = schemaStorage.get(target);\n  }\n  Object.assign(schema, options);\n}, \"AsnType\");\nvar AsnProp = /* @__PURE__ */ __name((options) => (target, propertyKey) => {\n  let schema;\n  if (!schemaStorage.has(target.constructor)) {\n    schema = schemaStorage.createDefault(target.constructor);\n    schemaStorage.set(target.constructor, schema);\n  } else {\n    schema = schemaStorage.get(target.constructor);\n  }\n  const copyOptions = Object.assign({}, options);\n  if (typeof copyOptions.type === \"number\" && !copyOptions.converter) {\n    const defaultConverter2 = defaultConverter(options.type);\n    if (!defaultConverter2) {\n      throw new Error(`Cannot get default converter for property '${propertyKey}' of ${target.constructor.name}`);\n    }\n    copyOptions.converter = defaultConverter2;\n  }\n  schema.items[propertyKey] = copyOptions;\n}, \"AsnProp\");\n\n// ../../node_modules/.pnpm/@peculiar+asn1-schema@2.3.6/node_modules/@peculiar/asn1-schema/build/es2015/errors/schema_validation.js\nvar _AsnSchemaValidationError = class _AsnSchemaValidationError extends Error {\n  constructor() {\n    super(...arguments);\n    this.schemas = [];\n  }\n};\n__name(_AsnSchemaValidationError, \"AsnSchemaValidationError\");\nvar AsnSchemaValidationError = _AsnSchemaValidationError;\n\n// ../../node_modules/.pnpm/@peculiar+asn1-schema@2.3.6/node_modules/@peculiar/asn1-schema/build/es2015/parser.js\nvar _AsnParser = class _AsnParser {\n  static parse(data, target) {\n    const asn1Parsed = fromBER(data);\n    if (asn1Parsed.result.error) {\n      throw new Error(asn1Parsed.result.error);\n    }\n    const res = this.fromASN(asn1Parsed.result, target);\n    return res;\n  }\n  static fromASN(asn1Schema, target) {\n    var _a7;\n    try {\n      if (isConvertible(target)) {\n        const value = new target();\n        return value.fromASN(asn1Schema);\n      }\n      const schema = schemaStorage.get(target);\n      schemaStorage.cache(target);\n      let targetSchema = schema.schema;\n      if (asn1Schema.constructor === Constructed && schema.type !== AsnTypeTypes.Choice) {\n        targetSchema = new Constructed({\n          idBlock: {\n            tagClass: 3,\n            tagNumber: asn1Schema.idBlock.tagNumber\n          },\n          value: schema.schema.valueBlock.value\n        });\n        for (const key in schema.items) {\n          delete asn1Schema[key];\n        }\n      }\n      const asn1ComparedSchema = compareSchema({}, asn1Schema, targetSchema);\n      if (!asn1ComparedSchema.verified) {\n        throw new AsnSchemaValidationError(`Data does not match to ${target.name} ASN1 schema. ${asn1ComparedSchema.result.error}`);\n      }\n      const res = new target();\n      if (isTypeOfArray(target)) {\n        if (!(\"value\" in asn1Schema.valueBlock && Array.isArray(asn1Schema.valueBlock.value))) {\n          throw new Error(`Cannot get items from the ASN.1 parsed value. ASN.1 object is not constructed.`);\n        }\n        const itemType = schema.itemType;\n        if (typeof itemType === \"number\") {\n          const converter = defaultConverter(itemType);\n          if (!converter) {\n            throw new Error(`Cannot get default converter for array item of ${target.name} ASN1 schema`);\n          }\n          return target.from(asn1Schema.valueBlock.value, (element) => converter.fromASN(element));\n        } else {\n          return target.from(asn1Schema.valueBlock.value, (element) => this.fromASN(element, itemType));\n        }\n      }\n      for (const key in schema.items) {\n        const asn1SchemaValue = asn1ComparedSchema.result[key];\n        if (!asn1SchemaValue) {\n          continue;\n        }\n        const schemaItem = schema.items[key];\n        const schemaItemType = schemaItem.type;\n        if (typeof schemaItemType === \"number\" || isConvertible(schemaItemType)) {\n          const converter = (_a7 = schemaItem.converter) !== null && _a7 !== void 0 ? _a7 : isConvertible(schemaItemType) ? new schemaItemType() : null;\n          if (!converter) {\n            throw new Error(\"Converter is empty\");\n          }\n          if (schemaItem.repeated) {\n            if (schemaItem.implicit) {\n              const Container = schemaItem.repeated === \"sequence\" ? Sequence : Set;\n              const newItem = new Container();\n              newItem.valueBlock = asn1SchemaValue.valueBlock;\n              const newItemAsn = fromBER(newItem.toBER(false));\n              if (newItemAsn.offset === -1) {\n                throw new Error(`Cannot parse the child item. ${newItemAsn.result.error}`);\n              }\n              if (!(\"value\" in newItemAsn.result.valueBlock && Array.isArray(newItemAsn.result.valueBlock.value))) {\n                throw new Error(\"Cannot get items from the ASN.1 parsed value. ASN.1 object is not constructed.\");\n              }\n              const value = newItemAsn.result.valueBlock.value;\n              res[key] = Array.from(value, (element) => converter.fromASN(element));\n            } else {\n              res[key] = Array.from(asn1SchemaValue, (element) => converter.fromASN(element));\n            }\n          } else {\n            let value = asn1SchemaValue;\n            if (schemaItem.implicit) {\n              let newItem;\n              if (isConvertible(schemaItemType)) {\n                newItem = new schemaItemType().toSchema(\"\");\n              } else {\n                const Asn1TypeName = AsnPropTypes[schemaItemType];\n                const Asn1Type = index_es_exports[Asn1TypeName];\n                if (!Asn1Type) {\n                  throw new Error(`Cannot get '${Asn1TypeName}' class from asn1js module`);\n                }\n                newItem = new Asn1Type();\n              }\n              newItem.valueBlock = value.valueBlock;\n              value = fromBER(newItem.toBER(false)).result;\n            }\n            res[key] = converter.fromASN(value);\n          }\n        } else {\n          if (schemaItem.repeated) {\n            if (!Array.isArray(asn1SchemaValue)) {\n              throw new Error(\"Cannot get list of items from the ASN.1 parsed value. ASN.1 value should be iterable.\");\n            }\n            res[key] = Array.from(asn1SchemaValue, (element) => this.fromASN(element, schemaItemType));\n          } else {\n            res[key] = this.fromASN(asn1SchemaValue, schemaItemType);\n          }\n        }\n      }\n      return res;\n    } catch (error) {\n      if (error instanceof AsnSchemaValidationError) {\n        error.schemas.push(target.name);\n      }\n      throw error;\n    }\n  }\n};\n__name(_AsnParser, \"AsnParser\");\nvar AsnParser = _AsnParser;\n\n// ../../node_modules/.pnpm/@peculiar+asn1-schema@2.3.6/node_modules/@peculiar/asn1-schema/build/es2015/serializer.js\nvar _AsnSerializer = class _AsnSerializer {\n  static serialize(obj) {\n    if (obj instanceof BaseBlock) {\n      return obj.toBER(false);\n    }\n    return this.toASN(obj).toBER(false);\n  }\n  static toASN(obj) {\n    if (obj && typeof obj === \"object\" && isConvertible(obj)) {\n      return obj.toASN();\n    }\n    if (!(obj && typeof obj === \"object\")) {\n      throw new TypeError(\"Parameter 1 should be type of Object.\");\n    }\n    const target = obj.constructor;\n    const schema = schemaStorage.get(target);\n    schemaStorage.cache(target);\n    let asn1Value = [];\n    if (schema.itemType) {\n      if (!Array.isArray(obj)) {\n        throw new TypeError(\"Parameter 1 should be type of Array.\");\n      }\n      if (typeof schema.itemType === \"number\") {\n        const converter = defaultConverter(schema.itemType);\n        if (!converter) {\n          throw new Error(`Cannot get default converter for array item of ${target.name} ASN1 schema`);\n        }\n        asn1Value = obj.map((o) => converter.toASN(o));\n      } else {\n        asn1Value = obj.map((o) => this.toAsnItem({ type: schema.itemType }, \"[]\", target, o));\n      }\n    } else {\n      for (const key in schema.items) {\n        const schemaItem = schema.items[key];\n        const objProp = obj[key];\n        if (objProp === void 0 || schemaItem.defaultValue === objProp || typeof schemaItem.defaultValue === \"object\" && typeof objProp === \"object\" && isArrayEqual(this.serialize(schemaItem.defaultValue), this.serialize(objProp))) {\n          continue;\n        }\n        const asn1Item = _AsnSerializer.toAsnItem(schemaItem, key, target, objProp);\n        if (typeof schemaItem.context === \"number\") {\n          if (schemaItem.implicit) {\n            if (!schemaItem.repeated && (typeof schemaItem.type === \"number\" || isConvertible(schemaItem.type))) {\n              const value = {};\n              value.valueHex = asn1Item instanceof Null ? asn1Item.valueBeforeDecodeView : asn1Item.valueBlock.toBER();\n              asn1Value.push(new Primitive({\n                optional: schemaItem.optional,\n                idBlock: {\n                  tagClass: 3,\n                  tagNumber: schemaItem.context\n                },\n                ...value\n              }));\n            } else {\n              asn1Value.push(new Constructed({\n                optional: schemaItem.optional,\n                idBlock: {\n                  tagClass: 3,\n                  tagNumber: schemaItem.context\n                },\n                value: asn1Item.valueBlock.value\n              }));\n            }\n          } else {\n            asn1Value.push(new Constructed({\n              optional: schemaItem.optional,\n              idBlock: {\n                tagClass: 3,\n                tagNumber: schemaItem.context\n              },\n              value: [asn1Item]\n            }));\n          }\n        } else if (schemaItem.repeated) {\n          asn1Value = asn1Value.concat(asn1Item);\n        } else {\n          asn1Value.push(asn1Item);\n        }\n      }\n    }\n    let asnSchema;\n    switch (schema.type) {\n      case AsnTypeTypes.Sequence:\n        asnSchema = new Sequence({ value: asn1Value });\n        break;\n      case AsnTypeTypes.Set:\n        asnSchema = new Set({ value: asn1Value });\n        break;\n      case AsnTypeTypes.Choice:\n        if (!asn1Value[0]) {\n          throw new Error(`Schema '${target.name}' has wrong data. Choice cannot be empty.`);\n        }\n        asnSchema = asn1Value[0];\n        break;\n    }\n    return asnSchema;\n  }\n  static toAsnItem(schemaItem, key, target, objProp) {\n    let asn1Item;\n    if (typeof schemaItem.type === \"number\") {\n      const converter = schemaItem.converter;\n      if (!converter) {\n        throw new Error(`Property '${key}' doesn't have converter for type ${AsnPropTypes[schemaItem.type]} in schema '${target.name}'`);\n      }\n      if (schemaItem.repeated) {\n        if (!Array.isArray(objProp)) {\n          throw new TypeError(\"Parameter 'objProp' should be type of Array.\");\n        }\n        const items = Array.from(objProp, (element) => converter.toASN(element));\n        const Container = schemaItem.repeated === \"sequence\" ? Sequence : Set;\n        asn1Item = new Container({\n          value: items\n        });\n      } else {\n        asn1Item = converter.toASN(objProp);\n      }\n    } else {\n      if (schemaItem.repeated) {\n        if (!Array.isArray(objProp)) {\n          throw new TypeError(\"Parameter 'objProp' should be type of Array.\");\n        }\n        const items = Array.from(objProp, (element) => this.toASN(element));\n        const Container = schemaItem.repeated === \"sequence\" ? Sequence : Set;\n        asn1Item = new Container({\n          value: items\n        });\n      } else {\n        asn1Item = this.toASN(objProp);\n      }\n    }\n    return asn1Item;\n  }\n};\n__name(_AsnSerializer, \"AsnSerializer\");\nvar AsnSerializer = _AsnSerializer;\n\n// ../../node_modules/.pnpm/@peculiar+asn1-schema@2.3.6/node_modules/@peculiar/asn1-schema/build/es2015/convert.js\nvar _AsnConvert = class _AsnConvert {\n  static serialize(obj) {\n    return AsnSerializer.serialize(obj);\n  }\n  static parse(data, target) {\n    return AsnParser.parse(data, target);\n  }\n  static toString(data) {\n    const buf = BufferSourceConverter.isBufferSource(data) ? BufferSourceConverter.toArrayBuffer(data) : _AsnConvert.serialize(data);\n    const asn = fromBER(buf);\n    if (asn.offset === -1) {\n      throw new Error(`Cannot decode ASN.1 data. ${asn.result.error}`);\n    }\n    return asn.result.toString();\n  }\n};\n__name(_AsnConvert, \"AsnConvert\");\nvar AsnConvert = _AsnConvert;\n\n// ../../node_modules/.pnpm/tslib@2.5.0/node_modules/tslib/tslib.es6.js\nfunction __decorate(decorators, target, key, desc) {\n  var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n  if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\")\n    r = Reflect.decorate(decorators, target, key, desc);\n  else\n    for (var i = decorators.length - 1; i >= 0; i--)\n      if (d = decorators[i])\n        r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n  return c > 3 && r && Object.defineProperty(target, key, r), r;\n}\n__name(__decorate, \"__decorate\");\n\n// ../../node_modules/.pnpm/@peculiar+json-schema@1.1.12/node_modules/@peculiar/json-schema/build/index.es.js\nvar _JsonError = class _JsonError extends Error {\n  constructor(message, innerError) {\n    super(innerError ? `${message}. See the inner exception for more details.` : message);\n    this.message = message;\n    this.innerError = innerError;\n  }\n};\n__name(_JsonError, \"JsonError\");\nvar JsonError = _JsonError;\nvar _TransformError = class _TransformError extends JsonError {\n  constructor(schema, message, innerError) {\n    super(message, innerError);\n    this.schema = schema;\n  }\n};\n__name(_TransformError, \"TransformError\");\nvar TransformError = _TransformError;\nvar _ParserError = class _ParserError extends TransformError {\n  constructor(schema, message, innerError) {\n    super(schema, `JSON doesn't match to '${schema.target.name}' schema. ${message}`, innerError);\n  }\n};\n__name(_ParserError, \"ParserError\");\nvar ParserError = _ParserError;\nvar _ValidationError = class _ValidationError extends JsonError {\n};\n__name(_ValidationError, \"ValidationError\");\nvar ValidationError = _ValidationError;\nvar _SerializerError = class _SerializerError extends JsonError {\n  constructor(schemaName, message, innerError) {\n    super(`Cannot serialize by '${schemaName}' schema. ${message}`, innerError);\n    this.schemaName = schemaName;\n  }\n};\n__name(_SerializerError, \"SerializerError\");\nvar SerializerError = _SerializerError;\nvar _KeyError = class _KeyError extends ParserError {\n  constructor(schema, keys, errors = {}) {\n    super(schema, \"Some keys doesn't match to schema\");\n    this.keys = keys;\n    this.errors = errors;\n  }\n};\n__name(_KeyError, \"KeyError\");\nvar KeyError = _KeyError;\nvar JsonPropTypes;\n(function(JsonPropTypes2) {\n  JsonPropTypes2[JsonPropTypes2[\"Any\"] = 0] = \"Any\";\n  JsonPropTypes2[JsonPropTypes2[\"Boolean\"] = 1] = \"Boolean\";\n  JsonPropTypes2[JsonPropTypes2[\"Number\"] = 2] = \"Number\";\n  JsonPropTypes2[JsonPropTypes2[\"String\"] = 3] = \"String\";\n})(JsonPropTypes || (JsonPropTypes = {}));\nfunction checkType(value, type) {\n  switch (type) {\n    case JsonPropTypes.Boolean:\n      return typeof value === \"boolean\";\n    case JsonPropTypes.Number:\n      return typeof value === \"number\";\n    case JsonPropTypes.String:\n      return typeof value === \"string\";\n  }\n  return true;\n}\n__name(checkType, \"checkType\");\nfunction throwIfTypeIsWrong(value, type) {\n  if (!checkType(value, type)) {\n    throw new TypeError(`Value must be ${JsonPropTypes[type]}`);\n  }\n}\n__name(throwIfTypeIsWrong, \"throwIfTypeIsWrong\");\nfunction isConvertible2(target) {\n  if (target && target.prototype) {\n    if (target.prototype.toJSON && target.prototype.fromJSON) {\n      return true;\n    } else {\n      return isConvertible2(target.prototype);\n    }\n  } else {\n    return !!(target && target.toJSON && target.fromJSON);\n  }\n}\n__name(isConvertible2, \"isConvertible\");\nvar _JsonSchemaStorage = class _JsonSchemaStorage {\n  constructor() {\n    this.items = /* @__PURE__ */ new Map();\n  }\n  has(target) {\n    return this.items.has(target) || !!this.findParentSchema(target);\n  }\n  get(target) {\n    const schema = this.items.get(target) || this.findParentSchema(target);\n    if (!schema) {\n      throw new Error(\"Cannot get schema for current target\");\n    }\n    return schema;\n  }\n  create(target) {\n    const schema = { names: {} };\n    const parentSchema = this.findParentSchema(target);\n    if (parentSchema) {\n      Object.assign(schema, parentSchema);\n      schema.names = {};\n      for (const name in parentSchema.names) {\n        schema.names[name] = Object.assign({}, parentSchema.names[name]);\n      }\n    }\n    schema.target = target;\n    return schema;\n  }\n  set(target, schema) {\n    this.items.set(target, schema);\n    return this;\n  }\n  findParentSchema(target) {\n    const parent = target.__proto__;\n    if (parent) {\n      const schema = this.items.get(parent);\n      return schema || this.findParentSchema(parent);\n    }\n    return null;\n  }\n};\n__name(_JsonSchemaStorage, \"JsonSchemaStorage\");\nvar JsonSchemaStorage = _JsonSchemaStorage;\nvar DEFAULT_SCHEMA = \"default\";\nvar schemaStorage2 = new JsonSchemaStorage();\nvar _PatternValidation = class _PatternValidation {\n  constructor(pattern) {\n    this.pattern = new RegExp(pattern);\n  }\n  validate(value) {\n    const pattern = new RegExp(this.pattern.source, this.pattern.flags);\n    if (typeof value !== \"string\") {\n      throw new ValidationError(\"Incoming value must be string\");\n    }\n    if (!pattern.exec(value)) {\n      throw new ValidationError(`Value doesn't match to pattern '${pattern.toString()}'`);\n    }\n  }\n};\n__name(_PatternValidation, \"PatternValidation\");\nvar PatternValidation = _PatternValidation;\nvar _InclusiveValidation = class _InclusiveValidation {\n  constructor(min = Number.MIN_VALUE, max = Number.MAX_VALUE) {\n    this.min = min;\n    this.max = max;\n  }\n  validate(value) {\n    throwIfTypeIsWrong(value, JsonPropTypes.Number);\n    if (!(this.min <= value && value <= this.max)) {\n      const min = this.min === Number.MIN_VALUE ? \"MIN\" : this.min;\n      const max = this.max === Number.MAX_VALUE ? \"MAX\" : this.max;\n      throw new ValidationError(`Value doesn't match to diapason [${min},${max}]`);\n    }\n  }\n};\n__name(_InclusiveValidation, \"InclusiveValidation\");\nvar InclusiveValidation = _InclusiveValidation;\nvar _ExclusiveValidation = class _ExclusiveValidation {\n  constructor(min = Number.MIN_VALUE, max = Number.MAX_VALUE) {\n    this.min = min;\n    this.max = max;\n  }\n  validate(value) {\n    throwIfTypeIsWrong(value, JsonPropTypes.Number);\n    if (!(this.min < value && value < this.max)) {\n      const min = this.min === Number.MIN_VALUE ? \"MIN\" : this.min;\n      const max = this.max === Number.MAX_VALUE ? \"MAX\" : this.max;\n      throw new ValidationError(`Value doesn't match to diapason (${min},${max})`);\n    }\n  }\n};\n__name(_ExclusiveValidation, \"ExclusiveValidation\");\nvar ExclusiveValidation = _ExclusiveValidation;\nvar _LengthValidation = class _LengthValidation {\n  constructor(length, minLength, maxLength) {\n    this.length = length;\n    this.minLength = minLength;\n    this.maxLength = maxLength;\n  }\n  validate(value) {\n    if (this.length !== void 0) {\n      if (value.length !== this.length) {\n        throw new ValidationError(`Value length must be exactly ${this.length}.`);\n      }\n      return;\n    }\n    if (this.minLength !== void 0) {\n      if (value.length < this.minLength) {\n        throw new ValidationError(`Value length must be more than ${this.minLength}.`);\n      }\n    }\n    if (this.maxLength !== void 0) {\n      if (value.length > this.maxLength) {\n        throw new ValidationError(`Value length must be less than ${this.maxLength}.`);\n      }\n    }\n  }\n};\n__name(_LengthValidation, \"LengthValidation\");\nvar LengthValidation = _LengthValidation;\nvar _EnumerationValidation = class _EnumerationValidation {\n  constructor(enumeration) {\n    this.enumeration = enumeration;\n  }\n  validate(value) {\n    throwIfTypeIsWrong(value, JsonPropTypes.String);\n    if (!this.enumeration.includes(value)) {\n      throw new ValidationError(`Value must be one of ${this.enumeration.map((v) => `'${v}'`).join(\", \")}`);\n    }\n  }\n};\n__name(_EnumerationValidation, \"EnumerationValidation\");\nvar EnumerationValidation = _EnumerationValidation;\nvar _JsonTransform = class _JsonTransform {\n  static checkValues(data, schemaItem) {\n    const values = Array.isArray(data) ? data : [data];\n    for (const value of values) {\n      for (const validation of schemaItem.validations) {\n        if (validation instanceof LengthValidation && schemaItem.repeated) {\n          validation.validate(data);\n        } else {\n          validation.validate(value);\n        }\n      }\n    }\n  }\n  static checkTypes(value, schemaItem) {\n    if (schemaItem.repeated && !Array.isArray(value)) {\n      throw new TypeError(\"Value must be Array\");\n    }\n    if (typeof schemaItem.type === \"number\") {\n      const values = Array.isArray(value) ? value : [value];\n      for (const v of values) {\n        throwIfTypeIsWrong(v, schemaItem.type);\n      }\n    }\n  }\n  static getSchemaByName(schema, name = DEFAULT_SCHEMA) {\n    return { ...schema.names[DEFAULT_SCHEMA], ...schema.names[name] };\n  }\n};\n__name(_JsonTransform, \"JsonTransform\");\nvar JsonTransform = _JsonTransform;\nvar _JsonSerializer = class _JsonSerializer extends JsonTransform {\n  static serialize(obj, options, replacer, space) {\n    const json = this.toJSON(obj, options);\n    return JSON.stringify(json, replacer, space);\n  }\n  static toJSON(obj, options = {}) {\n    let res;\n    let targetSchema = options.targetSchema;\n    const schemaName = options.schemaName || DEFAULT_SCHEMA;\n    if (isConvertible2(obj)) {\n      return obj.toJSON();\n    }\n    if (Array.isArray(obj)) {\n      res = [];\n      for (const item of obj) {\n        res.push(this.toJSON(item, options));\n      }\n    } else if (typeof obj === \"object\") {\n      if (targetSchema && !schemaStorage2.has(targetSchema)) {\n        throw new JsonError(\"Cannot get schema for `targetSchema` param\");\n      }\n      targetSchema = targetSchema || obj.constructor;\n      if (schemaStorage2.has(targetSchema)) {\n        const schema = schemaStorage2.get(targetSchema);\n        res = {};\n        const namedSchema = this.getSchemaByName(schema, schemaName);\n        for (const key in namedSchema) {\n          try {\n            const item = namedSchema[key];\n            const objItem = obj[key];\n            let value;\n            if (item.optional && objItem === void 0 || item.defaultValue !== void 0 && objItem === item.defaultValue) {\n              continue;\n            }\n            if (!item.optional && objItem === void 0) {\n              throw new SerializerError(targetSchema.name, `Property '${key}' is required.`);\n            }\n            if (typeof item.type === \"number\") {\n              if (item.converter) {\n                if (item.repeated) {\n                  value = objItem.map((el) => item.converter.toJSON(el, obj));\n                } else {\n                  value = item.converter.toJSON(objItem, obj);\n                }\n              } else {\n                value = objItem;\n              }\n            } else {\n              if (item.repeated) {\n                value = objItem.map((el) => this.toJSON(el, { schemaName }));\n              } else {\n                value = this.toJSON(objItem, { schemaName });\n              }\n            }\n            this.checkTypes(value, item);\n            this.checkValues(value, item);\n            res[item.name || key] = value;\n          } catch (e) {\n            if (e instanceof SerializerError) {\n              throw e;\n            } else {\n              throw new SerializerError(schema.target.name, `Property '${key}' is wrong. ${e.message}`, e);\n            }\n          }\n        }\n      } else {\n        res = {};\n        for (const key in obj) {\n          res[key] = this.toJSON(obj[key], { schemaName });\n        }\n      }\n    } else {\n      res = obj;\n    }\n    return res;\n  }\n};\n__name(_JsonSerializer, \"JsonSerializer\");\nvar JsonSerializer = _JsonSerializer;\nvar _JsonParser = class _JsonParser extends JsonTransform {\n  static parse(data, options) {\n    const obj = JSON.parse(data);\n    return this.fromJSON(obj, options);\n  }\n  static fromJSON(target, options) {\n    const targetSchema = options.targetSchema;\n    const schemaName = options.schemaName || DEFAULT_SCHEMA;\n    const obj = new targetSchema();\n    if (isConvertible2(obj)) {\n      return obj.fromJSON(target);\n    }\n    const schema = schemaStorage2.get(targetSchema);\n    const namedSchema = this.getSchemaByName(schema, schemaName);\n    const keyErrors = {};\n    if (options.strictProperty && !Array.isArray(target)) {\n      _JsonParser.checkStrictProperty(target, namedSchema, schema);\n    }\n    for (const key in namedSchema) {\n      try {\n        const item = namedSchema[key];\n        const name = item.name || key;\n        const value = target[name];\n        if (value === void 0 && (item.optional || item.defaultValue !== void 0)) {\n          continue;\n        }\n        if (!item.optional && value === void 0) {\n          throw new ParserError(schema, `Property '${name}' is required.`);\n        }\n        this.checkTypes(value, item);\n        this.checkValues(value, item);\n        if (typeof item.type === \"number\") {\n          if (item.converter) {\n            if (item.repeated) {\n              obj[key] = value.map((el) => item.converter.fromJSON(el, obj));\n            } else {\n              obj[key] = item.converter.fromJSON(value, obj);\n            }\n          } else {\n            obj[key] = value;\n          }\n        } else {\n          const newOptions = {\n            ...options,\n            targetSchema: item.type,\n            schemaName\n          };\n          if (item.repeated) {\n            obj[key] = value.map((el) => this.fromJSON(el, newOptions));\n          } else {\n            obj[key] = this.fromJSON(value, newOptions);\n          }\n        }\n      } catch (e) {\n        if (!(e instanceof ParserError)) {\n          e = new ParserError(schema, `Property '${key}' is wrong. ${e.message}`, e);\n        }\n        if (options.strictAllKeys) {\n          keyErrors[key] = e;\n        } else {\n          throw e;\n        }\n      }\n    }\n    const keys = Object.keys(keyErrors);\n    if (keys.length) {\n      throw new KeyError(schema, keys, keyErrors);\n    }\n    return obj;\n  }\n  static checkStrictProperty(target, namedSchema, schema) {\n    const jsonProps = Object.keys(target);\n    const schemaProps = Object.keys(namedSchema);\n    const keys = [];\n    for (const key of jsonProps) {\n      if (schemaProps.indexOf(key) === -1) {\n        keys.push(key);\n      }\n    }\n    if (keys.length) {\n      throw new KeyError(schema, keys);\n    }\n  }\n};\n__name(_JsonParser, \"JsonParser\");\nvar JsonParser = _JsonParser;\nfunction getValidations(item) {\n  const validations = [];\n  if (item.pattern) {\n    validations.push(new PatternValidation(item.pattern));\n  }\n  if (item.type === JsonPropTypes.Number || item.type === JsonPropTypes.Any) {\n    if (item.minInclusive !== void 0 || item.maxInclusive !== void 0) {\n      validations.push(new InclusiveValidation(item.minInclusive, item.maxInclusive));\n    }\n    if (item.minExclusive !== void 0 || item.maxExclusive !== void 0) {\n      validations.push(new ExclusiveValidation(item.minExclusive, item.maxExclusive));\n    }\n    if (item.enumeration !== void 0) {\n      validations.push(new EnumerationValidation(item.enumeration));\n    }\n  }\n  if (item.type === JsonPropTypes.String || item.repeated || item.type === JsonPropTypes.Any) {\n    if (item.length !== void 0 || item.minLength !== void 0 || item.maxLength !== void 0) {\n      validations.push(new LengthValidation(item.length, item.minLength, item.maxLength));\n    }\n  }\n  return validations;\n}\n__name(getValidations, \"getValidations\");\nvar JsonProp = /* @__PURE__ */ __name((options = {}) => (target, propertyKey) => {\n  const errorMessage = `Cannot set type for ${propertyKey} property of ${target.constructor.name} schema`;\n  let schema;\n  if (!schemaStorage2.has(target.constructor)) {\n    schema = schemaStorage2.create(target.constructor);\n    schemaStorage2.set(target.constructor, schema);\n  } else {\n    schema = schemaStorage2.get(target.constructor);\n    if (schema.target !== target.constructor) {\n      schema = schemaStorage2.create(target.constructor);\n      schemaStorage2.set(target.constructor, schema);\n    }\n  }\n  const defaultSchema = {\n    type: JsonPropTypes.Any,\n    validations: []\n  };\n  const copyOptions = Object.assign(defaultSchema, options);\n  copyOptions.validations = getValidations(copyOptions);\n  if (typeof copyOptions.type !== \"number\") {\n    if (!schemaStorage2.has(copyOptions.type) && !isConvertible2(copyOptions.type)) {\n      throw new Error(`${errorMessage}. Assigning type doesn't have schema.`);\n    }\n  }\n  let schemaNames;\n  if (Array.isArray(options.schema)) {\n    schemaNames = options.schema;\n  } else {\n    schemaNames = [options.schema || DEFAULT_SCHEMA];\n  }\n  for (const schemaName of schemaNames) {\n    if (!schema.names[schemaName]) {\n      schema.names[schemaName] = {};\n    }\n    const namedSchema = schema.names[schemaName];\n    namedSchema[propertyKey] = copyOptions;\n  }\n}, \"JsonProp\");\n\n// ../../node_modules/.pnpm/webcrypto-core@1.7.7/node_modules/webcrypto-core/build/webcrypto-core.es.js\nvar _CryptoError = class _CryptoError extends Error {\n};\n__name(_CryptoError, \"CryptoError\");\nvar CryptoError = _CryptoError;\nvar _AlgorithmError = class _AlgorithmError extends CryptoError {\n};\n__name(_AlgorithmError, \"AlgorithmError\");\nvar AlgorithmError = _AlgorithmError;\nvar _UnsupportedOperationError = class _UnsupportedOperationError extends CryptoError {\n  constructor(methodName) {\n    super(`Unsupported operation: ${methodName ? `${methodName}` : \"\"}`);\n  }\n};\n__name(_UnsupportedOperationError, \"UnsupportedOperationError\");\nvar UnsupportedOperationError = _UnsupportedOperationError;\nvar _OperationError = class _OperationError extends CryptoError {\n};\n__name(_OperationError, \"OperationError\");\nvar OperationError = _OperationError;\nvar _RequiredPropertyError = class _RequiredPropertyError extends CryptoError {\n  constructor(propName) {\n    super(`${propName}: Missing required property`);\n  }\n};\n__name(_RequiredPropertyError, \"RequiredPropertyError\");\nvar RequiredPropertyError = _RequiredPropertyError;\nfunction isJWK(data) {\n  return typeof data === \"object\" && \"kty\" in data;\n}\n__name(isJWK, \"isJWK\");\nvar _ProviderCrypto = class _ProviderCrypto {\n  async digest(...args) {\n    this.checkDigest.apply(this, args);\n    return this.onDigest.apply(this, args);\n  }\n  checkDigest(algorithm, data) {\n    this.checkAlgorithmName(algorithm);\n  }\n  async onDigest(algorithm, data) {\n    throw new UnsupportedOperationError(\"digest\");\n  }\n  async generateKey(...args) {\n    this.checkGenerateKey.apply(this, args);\n    return this.onGenerateKey.apply(this, args);\n  }\n  checkGenerateKey(algorithm, extractable, keyUsages, ...args) {\n    this.checkAlgorithmName(algorithm);\n    this.checkGenerateKeyParams(algorithm);\n    if (!(keyUsages && keyUsages.length)) {\n      throw new TypeError(`Usages cannot be empty when creating a key.`);\n    }\n    let allowedUsages;\n    if (Array.isArray(this.usages)) {\n      allowedUsages = this.usages;\n    } else {\n      allowedUsages = this.usages.privateKey.concat(this.usages.publicKey);\n    }\n    this.checkKeyUsages(keyUsages, allowedUsages);\n  }\n  checkGenerateKeyParams(algorithm) {\n  }\n  async onGenerateKey(algorithm, extractable, keyUsages, ...args) {\n    throw new UnsupportedOperationError(\"generateKey\");\n  }\n  async sign(...args) {\n    this.checkSign.apply(this, args);\n    return this.onSign.apply(this, args);\n  }\n  checkSign(algorithm, key, data, ...args) {\n    this.checkAlgorithmName(algorithm);\n    this.checkAlgorithmParams(algorithm);\n    this.checkCryptoKey(key, \"sign\");\n  }\n  async onSign(algorithm, key, data, ...args) {\n    throw new UnsupportedOperationError(\"sign\");\n  }\n  async verify(...args) {\n    this.checkVerify.apply(this, args);\n    return this.onVerify.apply(this, args);\n  }\n  checkVerify(algorithm, key, signature, data, ...args) {\n    this.checkAlgorithmName(algorithm);\n    this.checkAlgorithmParams(algorithm);\n    this.checkCryptoKey(key, \"verify\");\n  }\n  async onVerify(algorithm, key, signature, data, ...args) {\n    throw new UnsupportedOperationError(\"verify\");\n  }\n  async encrypt(...args) {\n    this.checkEncrypt.apply(this, args);\n    return this.onEncrypt.apply(this, args);\n  }\n  checkEncrypt(algorithm, key, data, options = {}, ...args) {\n    this.checkAlgorithmName(algorithm);\n    this.checkAlgorithmParams(algorithm);\n    this.checkCryptoKey(key, options.keyUsage ? \"encrypt\" : void 0);\n  }\n  async onEncrypt(algorithm, key, data, ...args) {\n    throw new UnsupportedOperationError(\"encrypt\");\n  }\n  async decrypt(...args) {\n    this.checkDecrypt.apply(this, args);\n    return this.onDecrypt.apply(this, args);\n  }\n  checkDecrypt(algorithm, key, data, options = {}, ...args) {\n    this.checkAlgorithmName(algorithm);\n    this.checkAlgorithmParams(algorithm);\n    this.checkCryptoKey(key, options.keyUsage ? \"decrypt\" : void 0);\n  }\n  async onDecrypt(algorithm, key, data, ...args) {\n    throw new UnsupportedOperationError(\"decrypt\");\n  }\n  async deriveBits(...args) {\n    this.checkDeriveBits.apply(this, args);\n    return this.onDeriveBits.apply(this, args);\n  }\n  checkDeriveBits(algorithm, baseKey, length, options = {}, ...args) {\n    this.checkAlgorithmName(algorithm);\n    this.checkAlgorithmParams(algorithm);\n    this.checkCryptoKey(baseKey, options.keyUsage ? \"deriveBits\" : void 0);\n    if (length % 8 !== 0) {\n      throw new OperationError(\"length: Is not multiple of 8\");\n    }\n  }\n  async onDeriveBits(algorithm, baseKey, length, ...args) {\n    throw new UnsupportedOperationError(\"deriveBits\");\n  }\n  async exportKey(...args) {\n    this.checkExportKey.apply(this, args);\n    return this.onExportKey.apply(this, args);\n  }\n  checkExportKey(format, key, ...args) {\n    this.checkKeyFormat(format);\n    this.checkCryptoKey(key);\n    if (!key.extractable) {\n      throw new CryptoError(\"key: Is not extractable\");\n    }\n  }\n  async onExportKey(format, key, ...args) {\n    throw new UnsupportedOperationError(\"exportKey\");\n  }\n  async importKey(...args) {\n    this.checkImportKey.apply(this, args);\n    return this.onImportKey.apply(this, args);\n  }\n  checkImportKey(format, keyData, algorithm, extractable, keyUsages, ...args) {\n    this.checkKeyFormat(format);\n    this.checkKeyData(format, keyData);\n    this.checkAlgorithmName(algorithm);\n    this.checkImportParams(algorithm);\n    if (Array.isArray(this.usages)) {\n      this.checkKeyUsages(keyUsages, this.usages);\n    }\n  }\n  async onImportKey(format, keyData, algorithm, extractable, keyUsages, ...args) {\n    throw new UnsupportedOperationError(\"importKey\");\n  }\n  checkAlgorithmName(algorithm) {\n    if (algorithm.name.toLowerCase() !== this.name.toLowerCase()) {\n      throw new AlgorithmError(\"Unrecognized name\");\n    }\n  }\n  checkAlgorithmParams(algorithm) {\n  }\n  checkDerivedKeyParams(algorithm) {\n  }\n  checkKeyUsages(usages, allowed) {\n    for (const usage of usages) {\n      if (allowed.indexOf(usage) === -1) {\n        throw new TypeError(\"Cannot create a key using the specified key usages\");\n      }\n    }\n  }\n  checkCryptoKey(key, keyUsage) {\n    this.checkAlgorithmName(key.algorithm);\n    if (keyUsage && key.usages.indexOf(keyUsage) === -1) {\n      throw new CryptoError(`key does not match that of operation`);\n    }\n  }\n  checkRequiredProperty(data, propName) {\n    if (!(propName in data)) {\n      throw new RequiredPropertyError(propName);\n    }\n  }\n  checkHashAlgorithm(algorithm, hashAlgorithms) {\n    for (const item of hashAlgorithms) {\n      if (item.toLowerCase() === algorithm.name.toLowerCase()) {\n        return;\n      }\n    }\n    throw new OperationError(`hash: Must be one of ${hashAlgorithms.join(\", \")}`);\n  }\n  checkImportParams(algorithm) {\n  }\n  checkKeyFormat(format) {\n    switch (format) {\n      case \"raw\":\n      case \"pkcs8\":\n      case \"spki\":\n      case \"jwk\":\n        break;\n      default:\n        throw new TypeError(\"format: Is invalid value. Must be 'jwk', 'raw', 'spki', or 'pkcs8'\");\n    }\n  }\n  checkKeyData(format, keyData) {\n    if (!keyData) {\n      throw new TypeError(\"keyData: Cannot be empty on empty on key importing\");\n    }\n    if (format === \"jwk\") {\n      if (!isJWK(keyData)) {\n        throw new TypeError(\"keyData: Is not JsonWebToken\");\n      }\n    } else if (!BufferSourceConverter.isBufferSource(keyData)) {\n      throw new TypeError(\"keyData: Is not ArrayBufferView or ArrayBuffer\");\n    }\n  }\n  prepareData(data) {\n    return BufferSourceConverter.toArrayBuffer(data);\n  }\n};\n__name(_ProviderCrypto, \"ProviderCrypto\");\nvar ProviderCrypto = _ProviderCrypto;\nvar _AesProvider = class _AesProvider extends ProviderCrypto {\n  checkGenerateKeyParams(algorithm) {\n    this.checkRequiredProperty(algorithm, \"length\");\n    if (typeof algorithm.length !== \"number\") {\n      throw new TypeError(\"length: Is not of type Number\");\n    }\n    switch (algorithm.length) {\n      case 128:\n      case 192:\n      case 256:\n        break;\n      default:\n        throw new TypeError(\"length: Must be 128, 192, or 256\");\n    }\n  }\n  checkDerivedKeyParams(algorithm) {\n    this.checkGenerateKeyParams(algorithm);\n  }\n};\n__name(_AesProvider, \"AesProvider\");\nvar AesProvider = _AesProvider;\nvar _AesCbcProvider = class _AesCbcProvider extends AesProvider {\n  constructor() {\n    super(...arguments);\n    this.name = \"AES-CBC\";\n    this.usages = [\"encrypt\", \"decrypt\", \"wrapKey\", \"unwrapKey\"];\n  }\n  checkAlgorithmParams(algorithm) {\n    this.checkRequiredProperty(algorithm, \"iv\");\n    if (!(algorithm.iv instanceof ArrayBuffer || ArrayBuffer.isView(algorithm.iv))) {\n      throw new TypeError(\"iv: Is not of type '(ArrayBuffer or ArrayBufferView)'\");\n    }\n    if (algorithm.iv.byteLength !== 16) {\n      throw new TypeError(\"iv: Must have length 16 bytes\");\n    }\n  }\n};\n__name(_AesCbcProvider, \"AesCbcProvider\");\nvar AesCbcProvider = _AesCbcProvider;\nvar _AesCmacProvider = class _AesCmacProvider extends AesProvider {\n  constructor() {\n    super(...arguments);\n    this.name = \"AES-CMAC\";\n    this.usages = [\"sign\", \"verify\"];\n  }\n  checkAlgorithmParams(algorithm) {\n    this.checkRequiredProperty(algorithm, \"length\");\n    if (typeof algorithm.length !== \"number\") {\n      throw new TypeError(\"length: Is not a Number\");\n    }\n    if (algorithm.length < 1) {\n      throw new OperationError(\"length: Must be more than 0\");\n    }\n  }\n};\n__name(_AesCmacProvider, \"AesCmacProvider\");\nvar AesCmacProvider = _AesCmacProvider;\nvar _AesCtrProvider = class _AesCtrProvider extends AesProvider {\n  constructor() {\n    super(...arguments);\n    this.name = \"AES-CTR\";\n    this.usages = [\"encrypt\", \"decrypt\", \"wrapKey\", \"unwrapKey\"];\n  }\n  checkAlgorithmParams(algorithm) {\n    this.checkRequiredProperty(algorithm, \"counter\");\n    if (!(algorithm.counter instanceof ArrayBuffer || ArrayBuffer.isView(algorithm.counter))) {\n      throw new TypeError(\"counter: Is not of type '(ArrayBuffer or ArrayBufferView)'\");\n    }\n    if (algorithm.counter.byteLength !== 16) {\n      throw new TypeError(\"iv: Must have length 16 bytes\");\n    }\n    this.checkRequiredProperty(algorithm, \"length\");\n    if (typeof algorithm.length !== \"number\") {\n      throw new TypeError(\"length: Is not a Number\");\n    }\n    if (algorithm.length < 1) {\n      throw new OperationError(\"length: Must be more than 0\");\n    }\n  }\n};\n__name(_AesCtrProvider, \"AesCtrProvider\");\nvar AesCtrProvider = _AesCtrProvider;\nvar _AesEcbProvider = class _AesEcbProvider extends AesProvider {\n  constructor() {\n    super(...arguments);\n    this.name = \"AES-ECB\";\n    this.usages = [\"encrypt\", \"decrypt\", \"wrapKey\", \"unwrapKey\"];\n  }\n};\n__name(_AesEcbProvider, \"AesEcbProvider\");\nvar AesEcbProvider = _AesEcbProvider;\nvar _AesGcmProvider = class _AesGcmProvider extends AesProvider {\n  constructor() {\n    super(...arguments);\n    this.name = \"AES-GCM\";\n    this.usages = [\"encrypt\", \"decrypt\", \"wrapKey\", \"unwrapKey\"];\n  }\n  checkAlgorithmParams(algorithm) {\n    this.checkRequiredProperty(algorithm, \"iv\");\n    if (!(algorithm.iv instanceof ArrayBuffer || ArrayBuffer.isView(algorithm.iv))) {\n      throw new TypeError(\"iv: Is not of type '(ArrayBuffer or ArrayBufferView)'\");\n    }\n    if (algorithm.iv.byteLength < 1) {\n      throw new OperationError(\"iv: Must have length more than 0 and less than 2^64 - 1\");\n    }\n    if (!(\"tagLength\" in algorithm)) {\n      algorithm.tagLength = 128;\n    }\n    switch (algorithm.tagLength) {\n      case 32:\n      case 64:\n      case 96:\n      case 104:\n      case 112:\n      case 120:\n      case 128:\n        break;\n      default:\n        throw new OperationError(\"tagLength: Must be one of 32, 64, 96, 104, 112, 120 or 128\");\n    }\n  }\n};\n__name(_AesGcmProvider, \"AesGcmProvider\");\nvar AesGcmProvider = _AesGcmProvider;\nvar _AesKwProvider = class _AesKwProvider extends AesProvider {\n  constructor() {\n    super(...arguments);\n    this.name = \"AES-KW\";\n    this.usages = [\"wrapKey\", \"unwrapKey\"];\n  }\n};\n__name(_AesKwProvider, \"AesKwProvider\");\nvar AesKwProvider = _AesKwProvider;\nvar _DesProvider = class _DesProvider extends ProviderCrypto {\n  constructor() {\n    super(...arguments);\n    this.usages = [\"encrypt\", \"decrypt\", \"wrapKey\", \"unwrapKey\"];\n  }\n  checkAlgorithmParams(algorithm) {\n    if (this.ivSize) {\n      this.checkRequiredProperty(algorithm, \"iv\");\n      if (!(algorithm.iv instanceof ArrayBuffer || ArrayBuffer.isView(algorithm.iv))) {\n        throw new TypeError(\"iv: Is not of type '(ArrayBuffer or ArrayBufferView)'\");\n      }\n      if (algorithm.iv.byteLength !== this.ivSize) {\n        throw new TypeError(`iv: Must have length ${this.ivSize} bytes`);\n      }\n    }\n  }\n  checkGenerateKeyParams(algorithm) {\n    this.checkRequiredProperty(algorithm, \"length\");\n    if (typeof algorithm.length !== \"number\") {\n      throw new TypeError(\"length: Is not of type Number\");\n    }\n    if (algorithm.length !== this.keySizeBits) {\n      throw new OperationError(`algorithm.length: Must be ${this.keySizeBits}`);\n    }\n  }\n  checkDerivedKeyParams(algorithm) {\n    this.checkGenerateKeyParams(algorithm);\n  }\n};\n__name(_DesProvider, \"DesProvider\");\nvar DesProvider = _DesProvider;\nvar _RsaProvider = class _RsaProvider extends ProviderCrypto {\n  constructor() {\n    super(...arguments);\n    this.hashAlgorithms = [\"SHA-1\", \"SHA-256\", \"SHA-384\", \"SHA-512\"];\n  }\n  checkGenerateKeyParams(algorithm) {\n    this.checkRequiredProperty(algorithm, \"hash\");\n    this.checkHashAlgorithm(algorithm.hash, this.hashAlgorithms);\n    this.checkRequiredProperty(algorithm, \"publicExponent\");\n    if (!(algorithm.publicExponent && algorithm.publicExponent instanceof Uint8Array)) {\n      throw new TypeError(\"publicExponent: Missing or not a Uint8Array\");\n    }\n    const publicExponent = Convert.ToBase64(algorithm.publicExponent);\n    if (!(publicExponent === \"Aw==\" || publicExponent === \"AQAB\")) {\n      throw new TypeError(\"publicExponent: Must be [3] or [1,0,1]\");\n    }\n    this.checkRequiredProperty(algorithm, \"modulusLength\");\n    if (algorithm.modulusLength % 8 || algorithm.modulusLength < 256 || algorithm.modulusLength > 16384) {\n      throw new TypeError(\"The modulus length must be a multiple of 8 bits and >= 256 and <= 16384\");\n    }\n  }\n  checkImportParams(algorithm) {\n    this.checkRequiredProperty(algorithm, \"hash\");\n    this.checkHashAlgorithm(algorithm.hash, this.hashAlgorithms);\n  }\n};\n__name(_RsaProvider, \"RsaProvider\");\nvar RsaProvider = _RsaProvider;\nvar _RsaSsaProvider = class _RsaSsaProvider extends RsaProvider {\n  constructor() {\n    super(...arguments);\n    this.name = \"RSASSA-PKCS1-v1_5\";\n    this.usages = {\n      privateKey: [\"sign\"],\n      publicKey: [\"verify\"]\n    };\n  }\n};\n__name(_RsaSsaProvider, \"RsaSsaProvider\");\nvar RsaSsaProvider = _RsaSsaProvider;\nvar _RsaPssProvider = class _RsaPssProvider extends RsaProvider {\n  constructor() {\n    super(...arguments);\n    this.name = \"RSA-PSS\";\n    this.usages = {\n      privateKey: [\"sign\"],\n      publicKey: [\"verify\"]\n    };\n  }\n  checkAlgorithmParams(algorithm) {\n    this.checkRequiredProperty(algorithm, \"saltLength\");\n    if (typeof algorithm.saltLength !== \"number\") {\n      throw new TypeError(\"saltLength: Is not a Number\");\n    }\n    if (algorithm.saltLength < 0) {\n      throw new RangeError(\"saltLength: Must be positive number\");\n    }\n  }\n};\n__name(_RsaPssProvider, \"RsaPssProvider\");\nvar RsaPssProvider = _RsaPssProvider;\nvar _RsaOaepProvider = class _RsaOaepProvider extends RsaProvider {\n  constructor() {\n    super(...arguments);\n    this.name = \"RSA-OAEP\";\n    this.usages = {\n      privateKey: [\"decrypt\", \"unwrapKey\"],\n      publicKey: [\"encrypt\", \"wrapKey\"]\n    };\n  }\n  checkAlgorithmParams(algorithm) {\n    if (algorithm.label && !(algorithm.label instanceof ArrayBuffer || ArrayBuffer.isView(algorithm.label))) {\n      throw new TypeError(\"label: Is not of type '(ArrayBuffer or ArrayBufferView)'\");\n    }\n  }\n};\n__name(_RsaOaepProvider, \"RsaOaepProvider\");\nvar RsaOaepProvider = _RsaOaepProvider;\nvar _EllipticProvider = class _EllipticProvider extends ProviderCrypto {\n  checkGenerateKeyParams(algorithm) {\n    this.checkRequiredProperty(algorithm, \"namedCurve\");\n    this.checkNamedCurve(algorithm.namedCurve);\n  }\n  checkNamedCurve(namedCurve) {\n    for (const item of this.namedCurves) {\n      if (item.toLowerCase() === namedCurve.toLowerCase()) {\n        return;\n      }\n    }\n    throw new OperationError(`namedCurve: Must be one of ${this.namedCurves.join(\", \")}`);\n  }\n};\n__name(_EllipticProvider, \"EllipticProvider\");\nvar EllipticProvider = _EllipticProvider;\nvar _EcdsaProvider = class _EcdsaProvider extends EllipticProvider {\n  constructor() {\n    super(...arguments);\n    this.name = \"ECDSA\";\n    this.hashAlgorithms = [\"SHA-1\", \"SHA-256\", \"SHA-384\", \"SHA-512\"];\n    this.usages = {\n      privateKey: [\"sign\"],\n      publicKey: [\"verify\"]\n    };\n    this.namedCurves = [\"P-256\", \"P-384\", \"P-521\", \"K-256\"];\n  }\n  checkAlgorithmParams(algorithm) {\n    this.checkRequiredProperty(algorithm, \"hash\");\n    this.checkHashAlgorithm(algorithm.hash, this.hashAlgorithms);\n  }\n};\n__name(_EcdsaProvider, \"EcdsaProvider\");\nvar EcdsaProvider = _EcdsaProvider;\nvar KEY_TYPES = [\"secret\", \"private\", \"public\"];\nvar _CryptoKey = class _CryptoKey {\n  static create(algorithm, type, extractable, usages) {\n    const key = new this();\n    key.algorithm = algorithm;\n    key.type = type;\n    key.extractable = extractable;\n    key.usages = usages;\n    return key;\n  }\n  static isKeyType(data) {\n    return KEY_TYPES.indexOf(data) !== -1;\n  }\n  get [Symbol.toStringTag]() {\n    return \"CryptoKey\";\n  }\n};\n__name(_CryptoKey, \"CryptoKey\");\nvar CryptoKey = _CryptoKey;\nvar _EcdhProvider = class _EcdhProvider extends EllipticProvider {\n  constructor() {\n    super(...arguments);\n    this.name = \"ECDH\";\n    this.usages = {\n      privateKey: [\"deriveBits\", \"deriveKey\"],\n      publicKey: []\n    };\n    this.namedCurves = [\"P-256\", \"P-384\", \"P-521\", \"K-256\"];\n  }\n  checkAlgorithmParams(algorithm) {\n    this.checkRequiredProperty(algorithm, \"public\");\n    if (!(algorithm.public instanceof CryptoKey)) {\n      throw new TypeError(\"public: Is not a CryptoKey\");\n    }\n    if (algorithm.public.type !== \"public\") {\n      throw new OperationError(\"public: Is not a public key\");\n    }\n    if (algorithm.public.algorithm.name !== this.name) {\n      throw new OperationError(`public: Is not ${this.name} key`);\n    }\n  }\n};\n__name(_EcdhProvider, \"EcdhProvider\");\nvar EcdhProvider = _EcdhProvider;\nvar _EcdhEsProvider = class _EcdhEsProvider extends EcdhProvider {\n  constructor() {\n    super(...arguments);\n    this.name = \"ECDH-ES\";\n    this.namedCurves = [\"X25519\", \"X448\"];\n  }\n};\n__name(_EcdhEsProvider, \"EcdhEsProvider\");\nvar EcdhEsProvider = _EcdhEsProvider;\nvar _EdDsaProvider = class _EdDsaProvider extends EllipticProvider {\n  constructor() {\n    super(...arguments);\n    this.name = \"EdDSA\";\n    this.usages = {\n      privateKey: [\"sign\"],\n      publicKey: [\"verify\"]\n    };\n    this.namedCurves = [\"Ed25519\", \"Ed448\"];\n  }\n};\n__name(_EdDsaProvider, \"EdDsaProvider\");\nvar EdDsaProvider = _EdDsaProvider;\nvar _a2;\nvar ObjectIdentifier2 = (_a2 = class {\n  constructor(value) {\n    if (value) {\n      this.value = value;\n    }\n  }\n}, __name(_a2, \"ObjectIdentifier\"), _a2);\n__decorate([\n  AsnProp({ type: AsnPropTypes.ObjectIdentifier })\n], ObjectIdentifier2.prototype, \"value\", void 0);\nObjectIdentifier2 = __decorate([\n  AsnType({ type: AsnTypeTypes.Choice })\n], ObjectIdentifier2);\nvar _AlgorithmIdentifier = class _AlgorithmIdentifier {\n  constructor(params) {\n    Object.assign(this, params);\n  }\n};\n__name(_AlgorithmIdentifier, \"AlgorithmIdentifier\");\nvar AlgorithmIdentifier = _AlgorithmIdentifier;\n__decorate([\n  AsnProp({\n    type: AsnPropTypes.ObjectIdentifier\n  })\n], AlgorithmIdentifier.prototype, \"algorithm\", void 0);\n__decorate([\n  AsnProp({\n    type: AsnPropTypes.Any,\n    optional: true\n  })\n], AlgorithmIdentifier.prototype, \"parameters\", void 0);\nvar _PrivateKeyInfo = class _PrivateKeyInfo {\n  constructor() {\n    this.version = 0;\n    this.privateKeyAlgorithm = new AlgorithmIdentifier();\n    this.privateKey = new ArrayBuffer(0);\n  }\n};\n__name(_PrivateKeyInfo, \"PrivateKeyInfo\");\nvar PrivateKeyInfo = _PrivateKeyInfo;\n__decorate([\n  AsnProp({ type: AsnPropTypes.Integer })\n], PrivateKeyInfo.prototype, \"version\", void 0);\n__decorate([\n  AsnProp({ type: AlgorithmIdentifier })\n], PrivateKeyInfo.prototype, \"privateKeyAlgorithm\", void 0);\n__decorate([\n  AsnProp({ type: AsnPropTypes.OctetString })\n], PrivateKeyInfo.prototype, \"privateKey\", void 0);\n__decorate([\n  AsnProp({ type: AsnPropTypes.Any, optional: true })\n], PrivateKeyInfo.prototype, \"attributes\", void 0);\nvar _PublicKeyInfo = class _PublicKeyInfo {\n  constructor() {\n    this.publicKeyAlgorithm = new AlgorithmIdentifier();\n    this.publicKey = new ArrayBuffer(0);\n  }\n};\n__name(_PublicKeyInfo, \"PublicKeyInfo\");\nvar PublicKeyInfo = _PublicKeyInfo;\n__decorate([\n  AsnProp({ type: AlgorithmIdentifier })\n], PublicKeyInfo.prototype, \"publicKeyAlgorithm\", void 0);\n__decorate([\n  AsnProp({ type: AsnPropTypes.BitString })\n], PublicKeyInfo.prototype, \"publicKey\", void 0);\nvar JsonBase64UrlArrayBufferConverter = {\n  fromJSON: (value) => Convert.FromBase64Url(value),\n  toJSON: (value) => Convert.ToBase64Url(new Uint8Array(value))\n};\nvar AsnIntegerArrayBufferConverter = {\n  fromASN: (value) => {\n    const valueHex = value.valueBlock.valueHex;\n    return !new Uint8Array(valueHex)[0] ? value.valueBlock.valueHex.slice(1) : value.valueBlock.valueHex;\n  },\n  toASN: (value) => {\n    const valueHex = new Uint8Array(value)[0] > 127 ? combine(new Uint8Array([0]).buffer, value) : value;\n    return new Integer({ valueHex });\n  }\n};\nvar _RsaPrivateKey = class _RsaPrivateKey {\n  constructor() {\n    this.version = 0;\n    this.modulus = new ArrayBuffer(0);\n    this.publicExponent = new ArrayBuffer(0);\n    this.privateExponent = new ArrayBuffer(0);\n    this.prime1 = new ArrayBuffer(0);\n    this.prime2 = new ArrayBuffer(0);\n    this.exponent1 = new ArrayBuffer(0);\n    this.exponent2 = new ArrayBuffer(0);\n    this.coefficient = new ArrayBuffer(0);\n  }\n};\n__name(_RsaPrivateKey, \"RsaPrivateKey\");\nvar RsaPrivateKey = _RsaPrivateKey;\n__decorate([\n  AsnProp({ type: AsnPropTypes.Integer, converter: AsnIntegerConverter })\n], RsaPrivateKey.prototype, \"version\", void 0);\n__decorate([\n  AsnProp({ type: AsnPropTypes.Integer, converter: AsnIntegerArrayBufferConverter }),\n  JsonProp({ name: \"n\", converter: JsonBase64UrlArrayBufferConverter })\n], RsaPrivateKey.prototype, \"modulus\", void 0);\n__decorate([\n  AsnProp({ type: AsnPropTypes.Integer, converter: AsnIntegerArrayBufferConverter }),\n  JsonProp({ name: \"e\", converter: JsonBase64UrlArrayBufferConverter })\n], RsaPrivateKey.prototype, \"publicExponent\", void 0);\n__decorate([\n  AsnProp({ type: AsnPropTypes.Integer, converter: AsnIntegerArrayBufferConverter }),\n  JsonProp({ name: \"d\", converter: JsonBase64UrlArrayBufferConverter })\n], RsaPrivateKey.prototype, \"privateExponent\", void 0);\n__decorate([\n  AsnProp({ type: AsnPropTypes.Integer, converter: AsnIntegerArrayBufferConverter }),\n  JsonProp({ name: \"p\", converter: JsonBase64UrlArrayBufferConverter })\n], RsaPrivateKey.prototype, \"prime1\", void 0);\n__decorate([\n  AsnProp({ type: AsnPropTypes.Integer, converter: AsnIntegerArrayBufferConverter }),\n  JsonProp({ name: \"q\", converter: JsonBase64UrlArrayBufferConverter })\n], RsaPrivateKey.prototype, \"prime2\", void 0);\n__decorate([\n  AsnProp({ type: AsnPropTypes.Integer, converter: AsnIntegerArrayBufferConverter }),\n  JsonProp({ name: \"dp\", converter: JsonBase64UrlArrayBufferConverter })\n], RsaPrivateKey.prototype, \"exponent1\", void 0);\n__decorate([\n  AsnProp({ type: AsnPropTypes.Integer, converter: AsnIntegerArrayBufferConverter }),\n  JsonProp({ name: \"dq\", converter: JsonBase64UrlArrayBufferConverter })\n], RsaPrivateKey.prototype, \"exponent2\", void 0);\n__decorate([\n  AsnProp({ type: AsnPropTypes.Integer, converter: AsnIntegerArrayBufferConverter }),\n  JsonProp({ name: \"qi\", converter: JsonBase64UrlArrayBufferConverter })\n], RsaPrivateKey.prototype, \"coefficient\", void 0);\n__decorate([\n  AsnProp({ type: AsnPropTypes.Any, optional: true })\n], RsaPrivateKey.prototype, \"otherPrimeInfos\", void 0);\nvar _RsaPublicKey = class _RsaPublicKey {\n  constructor() {\n    this.modulus = new ArrayBuffer(0);\n    this.publicExponent = new ArrayBuffer(0);\n  }\n};\n__name(_RsaPublicKey, \"RsaPublicKey\");\nvar RsaPublicKey = _RsaPublicKey;\n__decorate([\n  AsnProp({ type: AsnPropTypes.Integer, converter: AsnIntegerArrayBufferConverter }),\n  JsonProp({ name: \"n\", converter: JsonBase64UrlArrayBufferConverter })\n], RsaPublicKey.prototype, \"modulus\", void 0);\n__decorate([\n  AsnProp({ type: AsnPropTypes.Integer, converter: AsnIntegerArrayBufferConverter }),\n  JsonProp({ name: \"e\", converter: JsonBase64UrlArrayBufferConverter })\n], RsaPublicKey.prototype, \"publicExponent\", void 0);\nvar _a3;\nvar EcPublicKey = (_a3 = class {\n  constructor(value) {\n    this.value = new ArrayBuffer(0);\n    if (value) {\n      this.value = value;\n    }\n  }\n  toJSON() {\n    let bytes = new Uint8Array(this.value);\n    if (bytes[0] !== 4) {\n      throw new CryptoError(\"Wrong ECPoint. Current version supports only Uncompressed (0x04) point\");\n    }\n    bytes = new Uint8Array(this.value.slice(1));\n    const size = bytes.length / 2;\n    const offset = 0;\n    const json = {\n      x: Convert.ToBase64Url(bytes.buffer.slice(offset, offset + size)),\n      y: Convert.ToBase64Url(bytes.buffer.slice(offset + size, offset + size + size))\n    };\n    return json;\n  }\n  fromJSON(json) {\n    if (!(\"x\" in json)) {\n      throw new Error(\"x: Missing required property\");\n    }\n    if (!(\"y\" in json)) {\n      throw new Error(\"y: Missing required property\");\n    }\n    const x = Convert.FromBase64Url(json.x);\n    const y = Convert.FromBase64Url(json.y);\n    const value = combine(new Uint8Array([4]).buffer, x, y);\n    this.value = new Uint8Array(value).buffer;\n    return this;\n  }\n}, __name(_a3, \"EcPublicKey\"), _a3);\n__decorate([\n  AsnProp({ type: AsnPropTypes.OctetString })\n], EcPublicKey.prototype, \"value\", void 0);\nEcPublicKey = __decorate([\n  AsnType({ type: AsnTypeTypes.Choice })\n], EcPublicKey);\nvar _EcPrivateKey = class _EcPrivateKey {\n  constructor() {\n    this.version = 1;\n    this.privateKey = new ArrayBuffer(0);\n  }\n  fromJSON(json) {\n    if (!(\"d\" in json)) {\n      throw new Error(\"d: Missing required property\");\n    }\n    this.privateKey = Convert.FromBase64Url(json.d);\n    if (\"x\" in json) {\n      const publicKey = new EcPublicKey();\n      publicKey.fromJSON(json);\n      const asn = AsnSerializer.toASN(publicKey);\n      if (\"valueHex\" in asn.valueBlock) {\n        this.publicKey = asn.valueBlock.valueHex;\n      }\n    }\n    return this;\n  }\n  toJSON() {\n    const jwk = {};\n    jwk.d = Convert.ToBase64Url(this.privateKey);\n    if (this.publicKey) {\n      Object.assign(jwk, new EcPublicKey(this.publicKey).toJSON());\n    }\n    return jwk;\n  }\n};\n__name(_EcPrivateKey, \"EcPrivateKey\");\nvar EcPrivateKey = _EcPrivateKey;\n__decorate([\n  AsnProp({ type: AsnPropTypes.Integer, converter: AsnIntegerConverter })\n], EcPrivateKey.prototype, \"version\", void 0);\n__decorate([\n  AsnProp({ type: AsnPropTypes.OctetString })\n], EcPrivateKey.prototype, \"privateKey\", void 0);\n__decorate([\n  AsnProp({ context: 0, type: AsnPropTypes.Any, optional: true })\n], EcPrivateKey.prototype, \"parameters\", void 0);\n__decorate([\n  AsnProp({ context: 1, type: AsnPropTypes.BitString, optional: true })\n], EcPrivateKey.prototype, \"publicKey\", void 0);\nvar AsnIntegerWithoutPaddingConverter = {\n  fromASN: (value) => {\n    const bytes = new Uint8Array(value.valueBlock.valueHex);\n    return bytes[0] === 0 ? bytes.buffer.slice(1) : bytes.buffer;\n  },\n  toASN: (value) => {\n    const bytes = new Uint8Array(value);\n    if (bytes[0] > 127) {\n      const newValue = new Uint8Array(bytes.length + 1);\n      newValue.set(bytes, 1);\n      return new Integer({ valueHex: newValue.buffer });\n    }\n    return new Integer({ valueHex: value });\n  }\n};\nvar index$2 = /* @__PURE__ */ Object.freeze({\n  __proto__: null,\n  AsnIntegerWithoutPaddingConverter\n});\nvar _EcUtils = class _EcUtils {\n  static decodePoint(data, pointSize) {\n    const view = BufferSourceConverter.toUint8Array(data);\n    if (view.length === 0 || view[0] !== 4) {\n      throw new Error(\"Only uncompressed point format supported\");\n    }\n    const n = (view.length - 1) / 2;\n    if (n !== Math.ceil(pointSize / 8)) {\n      throw new Error(\"Point does not match field size\");\n    }\n    const xb = view.slice(1, n + 1);\n    const yb = view.slice(n + 1, n + 1 + n);\n    return { x: xb, y: yb };\n  }\n  static encodePoint(point, pointSize) {\n    const size = Math.ceil(pointSize / 8);\n    if (point.x.byteLength !== size || point.y.byteLength !== size) {\n      throw new Error(\"X,Y coordinates don't match point size criteria\");\n    }\n    const x = BufferSourceConverter.toUint8Array(point.x);\n    const y = BufferSourceConverter.toUint8Array(point.y);\n    const res = new Uint8Array(size * 2 + 1);\n    res[0] = 4;\n    res.set(x, 1);\n    res.set(y, size + 1);\n    return res;\n  }\n  static getSize(pointSize) {\n    return Math.ceil(pointSize / 8);\n  }\n  static encodeSignature(signature, pointSize) {\n    const size = this.getSize(pointSize);\n    const r = BufferSourceConverter.toUint8Array(signature.r);\n    const s = BufferSourceConverter.toUint8Array(signature.s);\n    const res = new Uint8Array(size * 2);\n    res.set(this.padStart(r, size));\n    res.set(this.padStart(s, size), size);\n    return res;\n  }\n  static decodeSignature(data, pointSize) {\n    const size = this.getSize(pointSize);\n    const view = BufferSourceConverter.toUint8Array(data);\n    if (view.length !== size * 2) {\n      throw new Error(\"Incorrect size of the signature\");\n    }\n    const r = view.slice(0, size);\n    const s = view.slice(size);\n    return {\n      r: this.trimStart(r),\n      s: this.trimStart(s)\n    };\n  }\n  static trimStart(data) {\n    let i = 0;\n    while (i < data.length - 1 && data[i] === 0) {\n      i++;\n    }\n    if (i === 0) {\n      return data;\n    }\n    return data.slice(i, data.length);\n  }\n  static padStart(data, size) {\n    if (size === data.length) {\n      return data;\n    }\n    const res = new Uint8Array(size);\n    res.set(data, size - data.length);\n    return res;\n  }\n};\n__name(_EcUtils, \"EcUtils\");\nvar EcUtils = _EcUtils;\nvar _EcDsaSignature = class _EcDsaSignature {\n  constructor() {\n    this.r = new ArrayBuffer(0);\n    this.s = new ArrayBuffer(0);\n  }\n  static fromWebCryptoSignature(value) {\n    const pointSize = value.byteLength / 2;\n    const point = EcUtils.decodeSignature(value, pointSize * 8);\n    const ecSignature = new _EcDsaSignature();\n    ecSignature.r = BufferSourceConverter.toArrayBuffer(point.r);\n    ecSignature.s = BufferSourceConverter.toArrayBuffer(point.s);\n    return ecSignature;\n  }\n  toWebCryptoSignature(pointSize) {\n    pointSize !== null && pointSize !== void 0 ? pointSize : pointSize = Math.max(this.r.byteLength, this.s.byteLength) * 8;\n    const signature = EcUtils.encodeSignature(this, pointSize);\n    return signature.buffer;\n  }\n};\n__name(_EcDsaSignature, \"EcDsaSignature\");\nvar EcDsaSignature = _EcDsaSignature;\n__decorate([\n  AsnProp({ type: AsnPropTypes.Integer, converter: AsnIntegerWithoutPaddingConverter })\n], EcDsaSignature.prototype, \"r\", void 0);\n__decorate([\n  AsnProp({ type: AsnPropTypes.Integer, converter: AsnIntegerWithoutPaddingConverter })\n], EcDsaSignature.prototype, \"s\", void 0);\nvar _OneAsymmetricKey = class _OneAsymmetricKey extends PrivateKeyInfo {\n};\n__name(_OneAsymmetricKey, \"OneAsymmetricKey\");\nvar OneAsymmetricKey = _OneAsymmetricKey;\n__decorate([\n  AsnProp({ context: 1, implicit: true, type: AsnPropTypes.BitString, optional: true })\n], OneAsymmetricKey.prototype, \"publicKey\", void 0);\nvar _a4;\nvar EdPrivateKey = (_a4 = class {\n  constructor() {\n    this.value = new ArrayBuffer(0);\n  }\n  fromJSON(json) {\n    if (!json.d) {\n      throw new Error(\"d: Missing required property\");\n    }\n    this.value = Convert.FromBase64Url(json.d);\n    return this;\n  }\n  toJSON() {\n    const jwk = {\n      d: Convert.ToBase64Url(this.value)\n    };\n    return jwk;\n  }\n}, __name(_a4, \"EdPrivateKey\"), _a4);\n__decorate([\n  AsnProp({ type: AsnPropTypes.OctetString })\n], EdPrivateKey.prototype, \"value\", void 0);\nEdPrivateKey = __decorate([\n  AsnType({ type: AsnTypeTypes.Choice })\n], EdPrivateKey);\nvar _a5;\nvar EdPublicKey = (_a5 = class {\n  constructor(value) {\n    this.value = new ArrayBuffer(0);\n    if (value) {\n      this.value = value;\n    }\n  }\n  toJSON() {\n    const json = {\n      x: Convert.ToBase64Url(this.value)\n    };\n    return json;\n  }\n  fromJSON(json) {\n    if (!(\"x\" in json)) {\n      throw new Error(\"x: Missing required property\");\n    }\n    this.value = Convert.FromBase64Url(json.x);\n    return this;\n  }\n}, __name(_a5, \"EdPublicKey\"), _a5);\n__decorate([\n  AsnProp({ type: AsnPropTypes.BitString })\n], EdPublicKey.prototype, \"value\", void 0);\nEdPublicKey = __decorate([\n  AsnType({ type: AsnTypeTypes.Choice })\n], EdPublicKey);\nvar _a6;\nvar CurvePrivateKey = (_a6 = class {\n}, __name(_a6, \"CurvePrivateKey\"), _a6);\n__decorate([\n  AsnProp({ type: AsnPropTypes.OctetString }),\n  JsonProp({ type: JsonPropTypes.String, converter: JsonBase64UrlArrayBufferConverter })\n], CurvePrivateKey.prototype, \"d\", void 0);\nCurvePrivateKey = __decorate([\n  AsnType({ type: AsnTypeTypes.Choice })\n], CurvePrivateKey);\nvar idSecp256r1 = \"1.2.840.10045.3.1.7\";\nvar idEllipticCurve = \"1.3.132.0\";\nvar idSecp384r1 = `${idEllipticCurve}.34`;\nvar idSecp521r1 = `${idEllipticCurve}.35`;\nvar idSecp256k1 = `${idEllipticCurve}.10`;\nvar idVersionOne = \"1.3.36.3.3.2.8.1.1\";\nvar idBrainpoolP160r1 = `${idVersionOne}.1`;\nvar idBrainpoolP160t1 = `${idVersionOne}.2`;\nvar idBrainpoolP192r1 = `${idVersionOne}.3`;\nvar idBrainpoolP192t1 = `${idVersionOne}.4`;\nvar idBrainpoolP224r1 = `${idVersionOne}.5`;\nvar idBrainpoolP224t1 = `${idVersionOne}.6`;\nvar idBrainpoolP256r1 = `${idVersionOne}.7`;\nvar idBrainpoolP256t1 = `${idVersionOne}.8`;\nvar idBrainpoolP320r1 = `${idVersionOne}.9`;\nvar idBrainpoolP320t1 = `${idVersionOne}.10`;\nvar idBrainpoolP384r1 = `${idVersionOne}.11`;\nvar idBrainpoolP384t1 = `${idVersionOne}.12`;\nvar idBrainpoolP512r1 = `${idVersionOne}.13`;\nvar idBrainpoolP512t1 = `${idVersionOne}.14`;\nvar idX25519 = \"1.3.101.110\";\nvar idX448 = \"1.3.101.111\";\nvar idEd25519 = \"1.3.101.112\";\nvar idEd448 = \"1.3.101.113\";\nvar index$1 = /* @__PURE__ */ Object.freeze({\n  __proto__: null,\n  AlgorithmIdentifier,\n  get CurvePrivateKey() {\n    return CurvePrivateKey;\n  },\n  EcDsaSignature,\n  EcPrivateKey,\n  get EcPublicKey() {\n    return EcPublicKey;\n  },\n  get EdPrivateKey() {\n    return EdPrivateKey;\n  },\n  get EdPublicKey() {\n    return EdPublicKey;\n  },\n  get ObjectIdentifier() {\n    return ObjectIdentifier2;\n  },\n  OneAsymmetricKey,\n  PrivateKeyInfo,\n  PublicKeyInfo,\n  RsaPrivateKey,\n  RsaPublicKey,\n  converters: index$2,\n  idBrainpoolP160r1,\n  idBrainpoolP160t1,\n  idBrainpoolP192r1,\n  idBrainpoolP192t1,\n  idBrainpoolP224r1,\n  idBrainpoolP224t1,\n  idBrainpoolP256r1,\n  idBrainpoolP256t1,\n  idBrainpoolP320r1,\n  idBrainpoolP320t1,\n  idBrainpoolP384r1,\n  idBrainpoolP384t1,\n  idBrainpoolP512r1,\n  idBrainpoolP512t1,\n  idEd25519,\n  idEd448,\n  idEllipticCurve,\n  idSecp256k1,\n  idSecp256r1,\n  idSecp384r1,\n  idSecp521r1,\n  idVersionOne,\n  idX25519,\n  idX448\n});\nvar _EcCurves = class _EcCurves {\n  constructor() {\n  }\n  static register(item) {\n    const oid = new ObjectIdentifier2();\n    oid.value = item.id;\n    const raw = AsnConvert.serialize(oid);\n    this.items.push({\n      ...item,\n      raw\n    });\n    this.names.push(item.name);\n  }\n  static find(nameOrId) {\n    nameOrId = nameOrId.toUpperCase();\n    for (const item of this.items) {\n      if (item.name.toUpperCase() === nameOrId || item.id.toUpperCase() === nameOrId) {\n        return item;\n      }\n    }\n    return null;\n  }\n  static get(nameOrId) {\n    const res = this.find(nameOrId);\n    if (!res) {\n      throw new Error(`Unsupported EC named curve '${nameOrId}'`);\n    }\n    return res;\n  }\n};\n__name(_EcCurves, \"EcCurves\");\nvar EcCurves = _EcCurves;\nEcCurves.items = [];\nEcCurves.names = [];\nEcCurves.register({ name: \"P-256\", id: idSecp256r1, size: 256 });\nEcCurves.register({ name: \"P-384\", id: idSecp384r1, size: 384 });\nEcCurves.register({ name: \"P-521\", id: idSecp521r1, size: 521 });\nEcCurves.register({ name: \"K-256\", id: idSecp256k1, size: 256 });\nEcCurves.register({ name: \"brainpoolP160r1\", id: idBrainpoolP160r1, size: 160 });\nEcCurves.register({ name: \"brainpoolP160t1\", id: idBrainpoolP160t1, size: 160 });\nEcCurves.register({ name: \"brainpoolP192r1\", id: idBrainpoolP192r1, size: 192 });\nEcCurves.register({ name: \"brainpoolP192t1\", id: idBrainpoolP192t1, size: 192 });\nEcCurves.register({ name: \"brainpoolP224r1\", id: idBrainpoolP224r1, size: 224 });\nEcCurves.register({ name: \"brainpoolP224t1\", id: idBrainpoolP224t1, size: 224 });\nEcCurves.register({ name: \"brainpoolP256r1\", id: idBrainpoolP256r1, size: 256 });\nEcCurves.register({ name: \"brainpoolP256t1\", id: idBrainpoolP256t1, size: 256 });\nEcCurves.register({ name: \"brainpoolP320r1\", id: idBrainpoolP320r1, size: 320 });\nEcCurves.register({ name: \"brainpoolP320t1\", id: idBrainpoolP320t1, size: 320 });\nEcCurves.register({ name: \"brainpoolP384r1\", id: idBrainpoolP384r1, size: 384 });\nEcCurves.register({ name: \"brainpoolP384t1\", id: idBrainpoolP384t1, size: 384 });\nEcCurves.register({ name: \"brainpoolP512r1\", id: idBrainpoolP512r1, size: 512 });\nEcCurves.register({ name: \"brainpoolP512t1\", id: idBrainpoolP512t1, size: 512 });\nvar _HmacProvider = class _HmacProvider extends ProviderCrypto {\n  constructor() {\n    super(...arguments);\n    this.name = \"HMAC\";\n    this.hashAlgorithms = [\"SHA-1\", \"SHA-256\", \"SHA-384\", \"SHA-512\"];\n    this.usages = [\"sign\", \"verify\"];\n  }\n  getDefaultLength(algName) {\n    switch (algName.toUpperCase()) {\n      case \"SHA-1\":\n      case \"SHA-256\":\n      case \"SHA-384\":\n      case \"SHA-512\":\n        return 512;\n      default:\n        throw new Error(`Unknown algorithm name '${algName}'`);\n    }\n  }\n  checkGenerateKeyParams(algorithm) {\n    this.checkRequiredProperty(algorithm, \"hash\");\n    this.checkHashAlgorithm(algorithm.hash, this.hashAlgorithms);\n    if (\"length\" in algorithm) {\n      if (typeof algorithm.length !== \"number\") {\n        throw new TypeError(\"length: Is not a Number\");\n      }\n      if (algorithm.length < 1) {\n        throw new RangeError(\"length: Number is out of range\");\n      }\n    }\n  }\n  checkImportParams(algorithm) {\n    this.checkRequiredProperty(algorithm, \"hash\");\n    this.checkHashAlgorithm(algorithm.hash, this.hashAlgorithms);\n  }\n};\n__name(_HmacProvider, \"HmacProvider\");\nvar HmacProvider = _HmacProvider;\nvar _Pbkdf2Provider = class _Pbkdf2Provider extends ProviderCrypto {\n  constructor() {\n    super(...arguments);\n    this.name = \"PBKDF2\";\n    this.hashAlgorithms = [\"SHA-1\", \"SHA-256\", \"SHA-384\", \"SHA-512\"];\n    this.usages = [\"deriveBits\", \"deriveKey\"];\n  }\n  checkAlgorithmParams(algorithm) {\n    this.checkRequiredProperty(algorithm, \"hash\");\n    this.checkHashAlgorithm(algorithm.hash, this.hashAlgorithms);\n    this.checkRequiredProperty(algorithm, \"salt\");\n    if (!(algorithm.salt instanceof ArrayBuffer || ArrayBuffer.isView(algorithm.salt))) {\n      throw new TypeError(\"salt: Is not of type '(ArrayBuffer or ArrayBufferView)'\");\n    }\n    this.checkRequiredProperty(algorithm, \"iterations\");\n    if (typeof algorithm.iterations !== \"number\") {\n      throw new TypeError(\"iterations: Is not a Number\");\n    }\n    if (algorithm.iterations < 1) {\n      throw new TypeError(\"iterations: Is less than 1\");\n    }\n  }\n  checkImportKey(format, keyData, algorithm, extractable, keyUsages, ...args) {\n    super.checkImportKey(format, keyData, algorithm, extractable, keyUsages);\n    if (extractable) {\n      throw new SyntaxError(\"extractable: Must be 'false'\");\n    }\n  }\n};\n__name(_Pbkdf2Provider, \"Pbkdf2Provider\");\nvar Pbkdf2Provider = _Pbkdf2Provider;\nvar _HkdfProvider = class _HkdfProvider extends ProviderCrypto {\n  constructor() {\n    super(...arguments);\n    this.name = \"HKDF\";\n    this.hashAlgorithms = [\"SHA-1\", \"SHA-256\", \"SHA-384\", \"SHA-512\"];\n    this.usages = [\"deriveKey\", \"deriveBits\"];\n  }\n  checkAlgorithmParams(algorithm) {\n    this.checkRequiredProperty(algorithm, \"hash\");\n    this.checkHashAlgorithm(algorithm.hash, this.hashAlgorithms);\n    this.checkRequiredProperty(algorithm, \"salt\");\n    if (!BufferSourceConverter.isBufferSource(algorithm.salt)) {\n      throw new TypeError(\"salt: Is not of type '(ArrayBuffer or ArrayBufferView)'\");\n    }\n    this.checkRequiredProperty(algorithm, \"info\");\n    if (!BufferSourceConverter.isBufferSource(algorithm.info)) {\n      throw new TypeError(\"salt: Is not of type '(ArrayBuffer or ArrayBufferView)'\");\n    }\n  }\n  checkImportKey(format, keyData, algorithm, extractable, keyUsages, ...args) {\n    super.checkImportKey(format, keyData, algorithm, extractable, keyUsages);\n    if (extractable) {\n      throw new SyntaxError(\"extractable: Must be 'false'\");\n    }\n  }\n};\n__name(_HkdfProvider, \"HkdfProvider\");\nvar HkdfProvider = _HkdfProvider;\nvar _ShakeProvider = class _ShakeProvider extends ProviderCrypto {\n  constructor() {\n    super(...arguments);\n    this.usages = [];\n    this.defaultLength = 0;\n  }\n  digest(...args) {\n    args[0] = { length: this.defaultLength, ...args[0] };\n    return super.digest.apply(this, args);\n  }\n  checkDigest(algorithm, data) {\n    super.checkDigest(algorithm, data);\n    const length = algorithm.length || 0;\n    if (typeof length !== \"number\") {\n      throw new TypeError(\"length: Is not a Number\");\n    }\n    if (length < 0) {\n      throw new TypeError(\"length: Is negative\");\n    }\n  }\n};\n__name(_ShakeProvider, \"ShakeProvider\");\nvar ShakeProvider = _ShakeProvider;\nvar _Shake128Provider = class _Shake128Provider extends ShakeProvider {\n  constructor() {\n    super(...arguments);\n    this.name = \"shake128\";\n    this.defaultLength = 16;\n  }\n};\n__name(_Shake128Provider, \"Shake128Provider\");\nvar Shake128Provider = _Shake128Provider;\nvar _Shake256Provider = class _Shake256Provider extends ShakeProvider {\n  constructor() {\n    super(...arguments);\n    this.name = \"shake256\";\n    this.defaultLength = 32;\n  }\n};\n__name(_Shake256Provider, \"Shake256Provider\");\nvar Shake256Provider = _Shake256Provider;\nvar _Crypto = class _Crypto {\n  get [Symbol.toStringTag]() {\n    return \"Crypto\";\n  }\n  randomUUID() {\n    const b = this.getRandomValues(new Uint8Array(16));\n    b[6] = b[6] & 15 | 64;\n    b[8] = b[8] & 63 | 128;\n    const uuid = Convert.ToHex(b).toLowerCase();\n    return `${uuid.substring(0, 8)}-${uuid.substring(8, 12)}-${uuid.substring(12, 16)}-${uuid.substring(16, 20)}-${uuid.substring(20)}`;\n  }\n};\n__name(_Crypto, \"Crypto\");\nvar Crypto = _Crypto;\nvar _ProviderStorage = class _ProviderStorage {\n  constructor() {\n    this.items = {};\n  }\n  get(algorithmName) {\n    return this.items[algorithmName.toLowerCase()] || null;\n  }\n  set(provider) {\n    this.items[provider.name.toLowerCase()] = provider;\n  }\n  removeAt(algorithmName) {\n    const provider = this.get(algorithmName.toLowerCase());\n    if (provider) {\n      delete this.items[algorithmName];\n    }\n    return provider;\n  }\n  has(name) {\n    return !!this.get(name);\n  }\n  get length() {\n    return Object.keys(this.items).length;\n  }\n  get algorithms() {\n    const algorithms = [];\n    for (const key in this.items) {\n      const provider = this.items[key];\n      algorithms.push(provider.name);\n    }\n    return algorithms.sort();\n  }\n};\n__name(_ProviderStorage, \"ProviderStorage\");\nvar ProviderStorage = _ProviderStorage;\nvar _SubtleCrypto = class _SubtleCrypto {\n  constructor() {\n    this.providers = new ProviderStorage();\n  }\n  static isHashedAlgorithm(data) {\n    return data && typeof data === \"object\" && \"name\" in data && \"hash\" in data ? true : false;\n  }\n  get [Symbol.toStringTag]() {\n    return \"SubtleCrypto\";\n  }\n  async digest(...args) {\n    this.checkRequiredArguments(args, 2, \"digest\");\n    const [algorithm, data, ...params] = args;\n    const preparedAlgorithm = this.prepareAlgorithm(algorithm);\n    const preparedData = BufferSourceConverter.toArrayBuffer(data);\n    const provider = this.getProvider(preparedAlgorithm.name);\n    const result = await provider.digest(preparedAlgorithm, preparedData, ...params);\n    return result;\n  }\n  async generateKey(...args) {\n    this.checkRequiredArguments(args, 3, \"generateKey\");\n    const [algorithm, extractable, keyUsages, ...params] = args;\n    const preparedAlgorithm = this.prepareAlgorithm(algorithm);\n    const provider = this.getProvider(preparedAlgorithm.name);\n    const result = await provider.generateKey({ ...preparedAlgorithm, name: provider.name }, extractable, keyUsages, ...params);\n    return result;\n  }\n  async sign(...args) {\n    this.checkRequiredArguments(args, 3, \"sign\");\n    const [algorithm, key, data, ...params] = args;\n    this.checkCryptoKey(key);\n    const preparedAlgorithm = this.prepareAlgorithm(algorithm);\n    const preparedData = BufferSourceConverter.toArrayBuffer(data);\n    const provider = this.getProvider(preparedAlgorithm.name);\n    const result = await provider.sign({ ...preparedAlgorithm, name: provider.name }, key, preparedData, ...params);\n    return result;\n  }\n  async verify(...args) {\n    this.checkRequiredArguments(args, 4, \"verify\");\n    const [algorithm, key, signature, data, ...params] = args;\n    this.checkCryptoKey(key);\n    const preparedAlgorithm = this.prepareAlgorithm(algorithm);\n    const preparedData = BufferSourceConverter.toArrayBuffer(data);\n    const preparedSignature = BufferSourceConverter.toArrayBuffer(signature);\n    const provider = this.getProvider(preparedAlgorithm.name);\n    const result = await provider.verify({ ...preparedAlgorithm, name: provider.name }, key, preparedSignature, preparedData, ...params);\n    return result;\n  }\n  async encrypt(...args) {\n    this.checkRequiredArguments(args, 3, \"encrypt\");\n    const [algorithm, key, data, ...params] = args;\n    this.checkCryptoKey(key);\n    const preparedAlgorithm = this.prepareAlgorithm(algorithm);\n    const preparedData = BufferSourceConverter.toArrayBuffer(data);\n    const provider = this.getProvider(preparedAlgorithm.name);\n    const result = await provider.encrypt({ ...preparedAlgorithm, name: provider.name }, key, preparedData, { keyUsage: true }, ...params);\n    return result;\n  }\n  async decrypt(...args) {\n    this.checkRequiredArguments(args, 3, \"decrypt\");\n    const [algorithm, key, data, ...params] = args;\n    this.checkCryptoKey(key);\n    const preparedAlgorithm = this.prepareAlgorithm(algorithm);\n    const preparedData = BufferSourceConverter.toArrayBuffer(data);\n    const provider = this.getProvider(preparedAlgorithm.name);\n    const result = await provider.decrypt({ ...preparedAlgorithm, name: provider.name }, key, preparedData, { keyUsage: true }, ...params);\n    return result;\n  }\n  async deriveBits(...args) {\n    this.checkRequiredArguments(args, 3, \"deriveBits\");\n    const [algorithm, baseKey, length, ...params] = args;\n    this.checkCryptoKey(baseKey);\n    const preparedAlgorithm = this.prepareAlgorithm(algorithm);\n    const provider = this.getProvider(preparedAlgorithm.name);\n    const result = await provider.deriveBits({ ...preparedAlgorithm, name: provider.name }, baseKey, length, { keyUsage: true }, ...params);\n    return result;\n  }\n  async deriveKey(...args) {\n    this.checkRequiredArguments(args, 5, \"deriveKey\");\n    const [algorithm, baseKey, derivedKeyType, extractable, keyUsages, ...params] = args;\n    const preparedDerivedKeyType = this.prepareAlgorithm(derivedKeyType);\n    const importProvider = this.getProvider(preparedDerivedKeyType.name);\n    importProvider.checkDerivedKeyParams(preparedDerivedKeyType);\n    const preparedAlgorithm = this.prepareAlgorithm(algorithm);\n    const provider = this.getProvider(preparedAlgorithm.name);\n    provider.checkCryptoKey(baseKey, \"deriveKey\");\n    const derivedBits = await provider.deriveBits({ ...preparedAlgorithm, name: provider.name }, baseKey, derivedKeyType.length || 512, { keyUsage: false }, ...params);\n    return this.importKey(\"raw\", derivedBits, derivedKeyType, extractable, keyUsages, ...params);\n  }\n  async exportKey(...args) {\n    this.checkRequiredArguments(args, 2, \"exportKey\");\n    const [format, key, ...params] = args;\n    this.checkCryptoKey(key);\n    const provider = this.getProvider(key.algorithm.name);\n    const result = await provider.exportKey(format, key, ...params);\n    return result;\n  }\n  async importKey(...args) {\n    this.checkRequiredArguments(args, 5, \"importKey\");\n    const [format, keyData, algorithm, extractable, keyUsages, ...params] = args;\n    const preparedAlgorithm = this.prepareAlgorithm(algorithm);\n    const provider = this.getProvider(preparedAlgorithm.name);\n    if ([\"pkcs8\", \"spki\", \"raw\"].indexOf(format) !== -1) {\n      const preparedData = BufferSourceConverter.toArrayBuffer(keyData);\n      return provider.importKey(format, preparedData, { ...preparedAlgorithm, name: provider.name }, extractable, keyUsages, ...params);\n    } else {\n      if (!keyData.kty) {\n        throw new TypeError(\"keyData: Is not JSON\");\n      }\n    }\n    return provider.importKey(format, keyData, { ...preparedAlgorithm, name: provider.name }, extractable, keyUsages, ...params);\n  }\n  async wrapKey(format, key, wrappingKey, wrapAlgorithm, ...args) {\n    let keyData = await this.exportKey(format, key, ...args);\n    if (format === \"jwk\") {\n      const json = JSON.stringify(keyData);\n      keyData = Convert.FromUtf8String(json);\n    }\n    const preparedAlgorithm = this.prepareAlgorithm(wrapAlgorithm);\n    const preparedData = BufferSourceConverter.toArrayBuffer(keyData);\n    const provider = this.getProvider(preparedAlgorithm.name);\n    return provider.encrypt({ ...preparedAlgorithm, name: provider.name }, wrappingKey, preparedData, { keyUsage: false }, ...args);\n  }\n  async unwrapKey(format, wrappedKey, unwrappingKey, unwrapAlgorithm, unwrappedKeyAlgorithm, extractable, keyUsages, ...args) {\n    const preparedAlgorithm = this.prepareAlgorithm(unwrapAlgorithm);\n    const preparedData = BufferSourceConverter.toArrayBuffer(wrappedKey);\n    const provider = this.getProvider(preparedAlgorithm.name);\n    let keyData = await provider.decrypt({ ...preparedAlgorithm, name: provider.name }, unwrappingKey, preparedData, { keyUsage: false }, ...args);\n    if (format === \"jwk\") {\n      try {\n        keyData = JSON.parse(Convert.ToUtf8String(keyData));\n      } catch (e) {\n        const error = new TypeError(\"wrappedKey: Is not a JSON\");\n        error.internal = e;\n        throw error;\n      }\n    }\n    return this.importKey(format, keyData, unwrappedKeyAlgorithm, extractable, keyUsages, ...args);\n  }\n  checkRequiredArguments(args, size, methodName) {\n    if (args.length < size) {\n      throw new TypeError(`Failed to execute '${methodName}' on 'SubtleCrypto': ${size} arguments required, but only ${args.length} present`);\n    }\n  }\n  prepareAlgorithm(algorithm) {\n    if (typeof algorithm === \"string\") {\n      return {\n        name: algorithm\n      };\n    }\n    if (_SubtleCrypto.isHashedAlgorithm(algorithm)) {\n      const preparedAlgorithm = { ...algorithm };\n      preparedAlgorithm.hash = this.prepareAlgorithm(algorithm.hash);\n      return preparedAlgorithm;\n    }\n    return { ...algorithm };\n  }\n  getProvider(name) {\n    const provider = this.providers.get(name);\n    if (!provider) {\n      throw new AlgorithmError(\"Unrecognized name\");\n    }\n    return provider;\n  }\n  checkCryptoKey(key) {\n    if (!(key instanceof CryptoKey)) {\n      throw new TypeError(`Key is not of type 'CryptoKey'`);\n    }\n  }\n};\n__name(_SubtleCrypto, \"SubtleCrypto\");\nvar SubtleCrypto = _SubtleCrypto;\n\n// ../../node_modules/.pnpm/@peculiar+webcrypto@1.4.3/node_modules/@peculiar/webcrypto/build/webcrypto.es.js\nvar crypto = __toESM(require(\"crypto\"));\nvar import_crypto = __toESM(require(\"crypto\"));\nvar process = __toESM(require(\"process\"));\nvar JsonBase64UrlConverter = {\n  fromJSON: (value) => Buffer.from(Convert.FromBase64Url(value)),\n  toJSON: (value) => Convert.ToBase64Url(value)\n};\nvar _CryptoKey2 = class _CryptoKey2 extends CryptoKey {\n  constructor() {\n    super(...arguments);\n    this.data = Buffer.alloc(0);\n    this.algorithm = { name: \"\" };\n    this.extractable = false;\n    this.type = \"secret\";\n    this.usages = [];\n    this.kty = \"oct\";\n    this.alg = \"\";\n  }\n};\n__name(_CryptoKey2, \"CryptoKey\");\nvar CryptoKey2 = _CryptoKey2;\n__decorate([\n  JsonProp({ name: \"ext\", type: JsonPropTypes.Boolean, optional: true })\n], CryptoKey2.prototype, \"extractable\", void 0);\n__decorate([\n  JsonProp({ name: \"key_ops\", type: JsonPropTypes.String, repeated: true, optional: true })\n], CryptoKey2.prototype, \"usages\", void 0);\n__decorate([\n  JsonProp({ type: JsonPropTypes.String })\n], CryptoKey2.prototype, \"kty\", void 0);\n__decorate([\n  JsonProp({ type: JsonPropTypes.String, optional: true })\n], CryptoKey2.prototype, \"alg\", void 0);\nvar _SymmetricKey = class _SymmetricKey extends CryptoKey2 {\n  constructor() {\n    super(...arguments);\n    this.kty = \"oct\";\n    this.type = \"secret\";\n  }\n};\n__name(_SymmetricKey, \"SymmetricKey\");\nvar SymmetricKey = _SymmetricKey;\nvar _AsymmetricKey = class _AsymmetricKey extends CryptoKey2 {\n};\n__name(_AsymmetricKey, \"AsymmetricKey\");\nvar AsymmetricKey = _AsymmetricKey;\nvar _AesCryptoKey = class _AesCryptoKey extends SymmetricKey {\n  get alg() {\n    switch (this.algorithm.name.toUpperCase()) {\n      case \"AES-CBC\":\n        return `A${this.algorithm.length}CBC`;\n      case \"AES-CTR\":\n        return `A${this.algorithm.length}CTR`;\n      case \"AES-GCM\":\n        return `A${this.algorithm.length}GCM`;\n      case \"AES-KW\":\n        return `A${this.algorithm.length}KW`;\n      case \"AES-CMAC\":\n        return `A${this.algorithm.length}CMAC`;\n      case \"AES-ECB\":\n        return `A${this.algorithm.length}ECB`;\n      default:\n        throw new AlgorithmError(\"Unsupported algorithm name\");\n    }\n  }\n  set alg(value) {\n  }\n};\n__name(_AesCryptoKey, \"AesCryptoKey\");\nvar AesCryptoKey = _AesCryptoKey;\n__decorate([\n  JsonProp({ name: \"k\", converter: JsonBase64UrlConverter })\n], AesCryptoKey.prototype, \"data\", void 0);\nvar _AesCrypto = class _AesCrypto {\n  static async generateKey(algorithm, extractable, keyUsages) {\n    const key = new AesCryptoKey();\n    key.algorithm = algorithm;\n    key.extractable = extractable;\n    key.usages = keyUsages;\n    key.data = import_crypto.default.randomBytes(algorithm.length >> 3);\n    return key;\n  }\n  static async exportKey(format, key) {\n    if (!(key instanceof AesCryptoKey)) {\n      throw new Error(\"key: Is not AesCryptoKey\");\n    }\n    switch (format.toLowerCase()) {\n      case \"jwk\":\n        return JsonSerializer.toJSON(key);\n      case \"raw\":\n        return new Uint8Array(key.data).buffer;\n      default:\n        throw new OperationError(\"format: Must be 'jwk' or 'raw'\");\n    }\n  }\n  static async importKey(format, keyData, algorithm, extractable, keyUsages) {\n    let key;\n    switch (format.toLowerCase()) {\n      case \"jwk\":\n        key = JsonParser.fromJSON(keyData, { targetSchema: AesCryptoKey });\n        break;\n      case \"raw\":\n        key = new AesCryptoKey();\n        key.data = Buffer.from(keyData);\n        break;\n      default:\n        throw new OperationError(\"format: Must be 'jwk' or 'raw'\");\n    }\n    key.algorithm = algorithm;\n    key.algorithm.length = key.data.length << 3;\n    key.extractable = extractable;\n    key.usages = keyUsages;\n    switch (key.algorithm.length) {\n      case 128:\n      case 192:\n      case 256:\n        break;\n      default:\n        throw new OperationError(\"keyData: Is wrong key length\");\n    }\n    return key;\n  }\n  static async encrypt(algorithm, key, data) {\n    switch (algorithm.name.toUpperCase()) {\n      case \"AES-CBC\":\n        return this.encryptAesCBC(algorithm, key, Buffer.from(data));\n      case \"AES-CTR\":\n        return this.encryptAesCTR(algorithm, key, Buffer.from(data));\n      case \"AES-GCM\":\n        return this.encryptAesGCM(algorithm, key, Buffer.from(data));\n      case \"AES-KW\":\n        return this.encryptAesKW(algorithm, key, Buffer.from(data));\n      case \"AES-ECB\":\n        return this.encryptAesECB(algorithm, key, Buffer.from(data));\n      default:\n        throw new OperationError(\"algorithm: Is not recognized\");\n    }\n  }\n  static async decrypt(algorithm, key, data) {\n    if (!(key instanceof AesCryptoKey)) {\n      throw new Error(\"key: Is not AesCryptoKey\");\n    }\n    switch (algorithm.name.toUpperCase()) {\n      case \"AES-CBC\":\n        return this.decryptAesCBC(algorithm, key, Buffer.from(data));\n      case \"AES-CTR\":\n        return this.decryptAesCTR(algorithm, key, Buffer.from(data));\n      case \"AES-GCM\":\n        return this.decryptAesGCM(algorithm, key, Buffer.from(data));\n      case \"AES-KW\":\n        return this.decryptAesKW(algorithm, key, Buffer.from(data));\n      case \"AES-ECB\":\n        return this.decryptAesECB(algorithm, key, Buffer.from(data));\n      default:\n        throw new OperationError(\"algorithm: Is not recognized\");\n    }\n  }\n  static async encryptAesCBC(algorithm, key, data) {\n    const cipher = import_crypto.default.createCipheriv(`aes-${key.algorithm.length}-cbc`, key.data, new Uint8Array(algorithm.iv));\n    let enc = cipher.update(data);\n    enc = Buffer.concat([enc, cipher.final()]);\n    const res = new Uint8Array(enc).buffer;\n    return res;\n  }\n  static async decryptAesCBC(algorithm, key, data) {\n    const decipher = import_crypto.default.createDecipheriv(`aes-${key.algorithm.length}-cbc`, key.data, new Uint8Array(algorithm.iv));\n    let dec = decipher.update(data);\n    dec = Buffer.concat([dec, decipher.final()]);\n    return new Uint8Array(dec).buffer;\n  }\n  static async encryptAesCTR(algorithm, key, data) {\n    const cipher = import_crypto.default.createCipheriv(`aes-${key.algorithm.length}-ctr`, key.data, Buffer.from(algorithm.counter));\n    let enc = cipher.update(data);\n    enc = Buffer.concat([enc, cipher.final()]);\n    const res = new Uint8Array(enc).buffer;\n    return res;\n  }\n  static async decryptAesCTR(algorithm, key, data) {\n    const decipher = import_crypto.default.createDecipheriv(`aes-${key.algorithm.length}-ctr`, key.data, new Uint8Array(algorithm.counter));\n    let dec = decipher.update(data);\n    dec = Buffer.concat([dec, decipher.final()]);\n    return new Uint8Array(dec).buffer;\n  }\n  static async encryptAesGCM(algorithm, key, data) {\n    const cipher = import_crypto.default.createCipheriv(`aes-${key.algorithm.length}-gcm`, key.data, Buffer.from(algorithm.iv), {\n      authTagLength: (algorithm.tagLength || 128) >> 3\n    });\n    if (algorithm.additionalData) {\n      cipher.setAAD(Buffer.from(algorithm.additionalData));\n    }\n    let enc = cipher.update(data);\n    enc = Buffer.concat([enc, cipher.final(), cipher.getAuthTag()]);\n    const res = new Uint8Array(enc).buffer;\n    return res;\n  }\n  static async decryptAesGCM(algorithm, key, data) {\n    const decipher = import_crypto.default.createDecipheriv(`aes-${key.algorithm.length}-gcm`, key.data, new Uint8Array(algorithm.iv));\n    const tagLength = (algorithm.tagLength || 128) >> 3;\n    const enc = data.slice(0, data.length - tagLength);\n    const tag = data.slice(data.length - tagLength);\n    if (algorithm.additionalData) {\n      decipher.setAAD(Buffer.from(algorithm.additionalData));\n    }\n    decipher.setAuthTag(tag);\n    let dec = decipher.update(enc);\n    dec = Buffer.concat([dec, decipher.final()]);\n    return new Uint8Array(dec).buffer;\n  }\n  static async encryptAesKW(algorithm, key, data) {\n    const cipher = import_crypto.default.createCipheriv(`id-aes${key.algorithm.length}-wrap`, key.data, this.AES_KW_IV);\n    let enc = cipher.update(data);\n    enc = Buffer.concat([enc, cipher.final()]);\n    return new Uint8Array(enc).buffer;\n  }\n  static async decryptAesKW(algorithm, key, data) {\n    const decipher = import_crypto.default.createDecipheriv(`id-aes${key.algorithm.length}-wrap`, key.data, this.AES_KW_IV);\n    let dec = decipher.update(data);\n    dec = Buffer.concat([dec, decipher.final()]);\n    return new Uint8Array(dec).buffer;\n  }\n  static async encryptAesECB(algorithm, key, data) {\n    const cipher = import_crypto.default.createCipheriv(`aes-${key.algorithm.length}-ecb`, key.data, new Uint8Array(0));\n    let enc = cipher.update(data);\n    enc = Buffer.concat([enc, cipher.final()]);\n    const res = new Uint8Array(enc).buffer;\n    return res;\n  }\n  static async decryptAesECB(algorithm, key, data) {\n    const decipher = import_crypto.default.createDecipheriv(`aes-${key.algorithm.length}-ecb`, key.data, new Uint8Array(0));\n    let dec = decipher.update(data);\n    dec = Buffer.concat([dec, decipher.final()]);\n    return new Uint8Array(dec).buffer;\n  }\n};\n__name(_AesCrypto, \"AesCrypto\");\nvar AesCrypto = _AesCrypto;\nAesCrypto.AES_KW_IV = Buffer.from(\"A6A6A6A6A6A6A6A6\", \"hex\");\nvar keyStorage = /* @__PURE__ */ new WeakMap();\nfunction getCryptoKey(key) {\n  const res = keyStorage.get(key);\n  if (!res) {\n    throw new OperationError(\"Cannot get CryptoKey from secure storage\");\n  }\n  return res;\n}\n__name(getCryptoKey, \"getCryptoKey\");\nfunction setCryptoKey(value) {\n  const key = CryptoKey.create(value.algorithm, value.type, value.extractable, value.usages);\n  Object.freeze(key);\n  keyStorage.set(key, value);\n  return key;\n}\n__name(setCryptoKey, \"setCryptoKey\");\nvar _AesCbcProvider2 = class _AesCbcProvider2 extends AesCbcProvider {\n  async onGenerateKey(algorithm, extractable, keyUsages) {\n    const key = await AesCrypto.generateKey({\n      name: this.name,\n      length: algorithm.length\n    }, extractable, keyUsages);\n    return setCryptoKey(key);\n  }\n  async onEncrypt(algorithm, key, data) {\n    return AesCrypto.encrypt(algorithm, getCryptoKey(key), new Uint8Array(data));\n  }\n  async onDecrypt(algorithm, key, data) {\n    return AesCrypto.decrypt(algorithm, getCryptoKey(key), new Uint8Array(data));\n  }\n  async onExportKey(format, key) {\n    return AesCrypto.exportKey(format, getCryptoKey(key));\n  }\n  async onImportKey(format, keyData, algorithm, extractable, keyUsages) {\n    const key = await AesCrypto.importKey(format, keyData, { name: algorithm.name }, extractable, keyUsages);\n    return setCryptoKey(key);\n  }\n  checkCryptoKey(key, keyUsage) {\n    super.checkCryptoKey(key, keyUsage);\n    if (!(getCryptoKey(key) instanceof AesCryptoKey)) {\n      throw new TypeError(\"key: Is not a AesCryptoKey\");\n    }\n  }\n};\n__name(_AesCbcProvider2, \"AesCbcProvider\");\nvar AesCbcProvider2 = _AesCbcProvider2;\nvar zero = Buffer.from([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]);\nvar rb = Buffer.from([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 135]);\nvar blockSize = 16;\nfunction bitShiftLeft(buffer) {\n  const shifted = Buffer.alloc(buffer.length);\n  const last = buffer.length - 1;\n  for (let index = 0; index < last; index++) {\n    shifted[index] = buffer[index] << 1;\n    if (buffer[index + 1] & 128) {\n      shifted[index] += 1;\n    }\n  }\n  shifted[last] = buffer[last] << 1;\n  return shifted;\n}\n__name(bitShiftLeft, \"bitShiftLeft\");\nfunction xor(a, b) {\n  const length = Math.min(a.length, b.length);\n  const output = Buffer.alloc(length);\n  for (let index = 0; index < length; index++) {\n    output[index] = a[index] ^ b[index];\n  }\n  return output;\n}\n__name(xor, \"xor\");\nfunction aes(key, message) {\n  const cipher = crypto.createCipheriv(`aes${key.length << 3}`, key, zero);\n  const result = cipher.update(message);\n  cipher.final();\n  return result;\n}\n__name(aes, \"aes\");\nfunction getMessageBlock(message, blockIndex) {\n  const block = Buffer.alloc(blockSize);\n  const start = blockIndex * blockSize;\n  const end = start + blockSize;\n  message.copy(block, 0, start, end);\n  return block;\n}\n__name(getMessageBlock, \"getMessageBlock\");\nfunction getPaddedMessageBlock(message, blockIndex) {\n  const block = Buffer.alloc(blockSize);\n  const start = blockIndex * blockSize;\n  const end = message.length;\n  block.fill(0);\n  message.copy(block, 0, start, end);\n  block[end - start] = 128;\n  return block;\n}\n__name(getPaddedMessageBlock, \"getPaddedMessageBlock\");\nfunction generateSubkeys(key) {\n  const l = aes(key, zero);\n  let subkey1 = bitShiftLeft(l);\n  if (l[0] & 128) {\n    subkey1 = xor(subkey1, rb);\n  }\n  let subkey2 = bitShiftLeft(subkey1);\n  if (subkey1[0] & 128) {\n    subkey2 = xor(subkey2, rb);\n  }\n  return { subkey1, subkey2 };\n}\n__name(generateSubkeys, \"generateSubkeys\");\nfunction aesCmac(key, message) {\n  const subkeys = generateSubkeys(key);\n  let blockCount = Math.ceil(message.length / blockSize);\n  let lastBlockCompleteFlag;\n  let lastBlock;\n  if (blockCount === 0) {\n    blockCount = 1;\n    lastBlockCompleteFlag = false;\n  } else {\n    lastBlockCompleteFlag = message.length % blockSize === 0;\n  }\n  const lastBlockIndex = blockCount - 1;\n  if (lastBlockCompleteFlag) {\n    lastBlock = xor(getMessageBlock(message, lastBlockIndex), subkeys.subkey1);\n  } else {\n    lastBlock = xor(getPaddedMessageBlock(message, lastBlockIndex), subkeys.subkey2);\n  }\n  let x = zero;\n  let y;\n  for (let index = 0; index < lastBlockIndex; index++) {\n    y = xor(x, getMessageBlock(message, index));\n    x = aes(key, y);\n  }\n  y = xor(lastBlock, x);\n  return aes(key, y);\n}\n__name(aesCmac, \"aesCmac\");\nvar _AesCmacProvider2 = class _AesCmacProvider2 extends AesCmacProvider {\n  async onGenerateKey(algorithm, extractable, keyUsages) {\n    const key = await AesCrypto.generateKey({\n      name: this.name,\n      length: algorithm.length\n    }, extractable, keyUsages);\n    return setCryptoKey(key);\n  }\n  async onSign(algorithm, key, data) {\n    const result = aesCmac(getCryptoKey(key).data, Buffer.from(data));\n    return new Uint8Array(result).buffer;\n  }\n  async onVerify(algorithm, key, signature, data) {\n    const signature2 = await this.sign(algorithm, key, data);\n    return Buffer.from(signature).compare(Buffer.from(signature2)) === 0;\n  }\n  async onExportKey(format, key) {\n    return AesCrypto.exportKey(format, getCryptoKey(key));\n  }\n  async onImportKey(format, keyData, algorithm, extractable, keyUsages) {\n    const res = await AesCrypto.importKey(format, keyData, { name: algorithm.name }, extractable, keyUsages);\n    return setCryptoKey(res);\n  }\n  checkCryptoKey(key, keyUsage) {\n    super.checkCryptoKey(key, keyUsage);\n    if (!(getCryptoKey(key) instanceof AesCryptoKey)) {\n      throw new TypeError(\"key: Is not a AesCryptoKey\");\n    }\n  }\n};\n__name(_AesCmacProvider2, \"AesCmacProvider\");\nvar AesCmacProvider2 = _AesCmacProvider2;\nvar _AesCtrProvider2 = class _AesCtrProvider2 extends AesCtrProvider {\n  async onGenerateKey(algorithm, extractable, keyUsages) {\n    const key = await AesCrypto.generateKey({\n      name: this.name,\n      length: algorithm.length\n    }, extractable, keyUsages);\n    return setCryptoKey(key);\n  }\n  async onEncrypt(algorithm, key, data) {\n    return AesCrypto.encrypt(algorithm, getCryptoKey(key), new Uint8Array(data));\n  }\n  async onDecrypt(algorithm, key, data) {\n    return AesCrypto.decrypt(algorithm, getCryptoKey(key), new Uint8Array(data));\n  }\n  async onExportKey(format, key) {\n    return AesCrypto.exportKey(format, getCryptoKey(key));\n  }\n  async onImportKey(format, keyData, algorithm, extractable, keyUsages) {\n    const res = await AesCrypto.importKey(format, keyData, { name: algorithm.name }, extractable, keyUsages);\n    return setCryptoKey(res);\n  }\n  checkCryptoKey(key, keyUsage) {\n    super.checkCryptoKey(key, keyUsage);\n    if (!(getCryptoKey(key) instanceof AesCryptoKey)) {\n      throw new TypeError(\"key: Is not a AesCryptoKey\");\n    }\n  }\n};\n__name(_AesCtrProvider2, \"AesCtrProvider\");\nvar AesCtrProvider2 = _AesCtrProvider2;\nvar _AesGcmProvider2 = class _AesGcmProvider2 extends AesGcmProvider {\n  async onGenerateKey(algorithm, extractable, keyUsages) {\n    const key = await AesCrypto.generateKey({\n      name: this.name,\n      length: algorithm.length\n    }, extractable, keyUsages);\n    return setCryptoKey(key);\n  }\n  async onEncrypt(algorithm, key, data) {\n    return AesCrypto.encrypt(algorithm, getCryptoKey(key), new Uint8Array(data));\n  }\n  async onDecrypt(algorithm, key, data) {\n    return AesCrypto.decrypt(algorithm, getCryptoKey(key), new Uint8Array(data));\n  }\n  async onExportKey(format, key) {\n    return AesCrypto.exportKey(format, getCryptoKey(key));\n  }\n  async onImportKey(format, keyData, algorithm, extractable, keyUsages) {\n    const res = await AesCrypto.importKey(format, keyData, { name: algorithm.name }, extractable, keyUsages);\n    return setCryptoKey(res);\n  }\n  checkCryptoKey(key, keyUsage) {\n    super.checkCryptoKey(key, keyUsage);\n    if (!(getCryptoKey(key) instanceof AesCryptoKey)) {\n      throw new TypeError(\"key: Is not a AesCryptoKey\");\n    }\n  }\n};\n__name(_AesGcmProvider2, \"AesGcmProvider\");\nvar AesGcmProvider2 = _AesGcmProvider2;\nvar _AesKwProvider2 = class _AesKwProvider2 extends AesKwProvider {\n  async onGenerateKey(algorithm, extractable, keyUsages) {\n    const res = await AesCrypto.generateKey({\n      name: this.name,\n      length: algorithm.length\n    }, extractable, keyUsages);\n    return setCryptoKey(res);\n  }\n  async onExportKey(format, key) {\n    return AesCrypto.exportKey(format, getCryptoKey(key));\n  }\n  async onImportKey(format, keyData, algorithm, extractable, keyUsages) {\n    const res = await AesCrypto.importKey(format, keyData, { name: algorithm.name }, extractable, keyUsages);\n    return setCryptoKey(res);\n  }\n  async onEncrypt(algorithm, key, data) {\n    return AesCrypto.encrypt(algorithm, getCryptoKey(key), new Uint8Array(data));\n  }\n  async onDecrypt(algorithm, key, data) {\n    return AesCrypto.decrypt(algorithm, getCryptoKey(key), new Uint8Array(data));\n  }\n  checkCryptoKey(key, keyUsage) {\n    super.checkCryptoKey(key, keyUsage);\n    if (!(getCryptoKey(key) instanceof AesCryptoKey)) {\n      throw new TypeError(\"key: Is not a AesCryptoKey\");\n    }\n  }\n};\n__name(_AesKwProvider2, \"AesKwProvider\");\nvar AesKwProvider2 = _AesKwProvider2;\nvar _AesEcbProvider2 = class _AesEcbProvider2 extends AesEcbProvider {\n  async onGenerateKey(algorithm, extractable, keyUsages) {\n    const key = await AesCrypto.generateKey({\n      name: this.name,\n      length: algorithm.length\n    }, extractable, keyUsages);\n    return setCryptoKey(key);\n  }\n  async onEncrypt(algorithm, key, data) {\n    return AesCrypto.encrypt(algorithm, getCryptoKey(key), new Uint8Array(data));\n  }\n  async onDecrypt(algorithm, key, data) {\n    return AesCrypto.decrypt(algorithm, getCryptoKey(key), new Uint8Array(data));\n  }\n  async onExportKey(format, key) {\n    return AesCrypto.exportKey(format, getCryptoKey(key));\n  }\n  async onImportKey(format, keyData, algorithm, extractable, keyUsages) {\n    const res = await AesCrypto.importKey(format, keyData, { name: algorithm.name }, extractable, keyUsages);\n    return setCryptoKey(res);\n  }\n  checkCryptoKey(key, keyUsage) {\n    super.checkCryptoKey(key, keyUsage);\n    if (!(getCryptoKey(key) instanceof AesCryptoKey)) {\n      throw new TypeError(\"key: Is not a AesCryptoKey\");\n    }\n  }\n};\n__name(_AesEcbProvider2, \"AesEcbProvider\");\nvar AesEcbProvider2 = _AesEcbProvider2;\nvar _DesCryptoKey = class _DesCryptoKey extends SymmetricKey {\n  get alg() {\n    switch (this.algorithm.name.toUpperCase()) {\n      case \"DES-CBC\":\n        return `DES-CBC`;\n      case \"DES-EDE3-CBC\":\n        return `3DES-CBC`;\n      default:\n        throw new AlgorithmError(\"Unsupported algorithm name\");\n    }\n  }\n  set alg(value) {\n  }\n};\n__name(_DesCryptoKey, \"DesCryptoKey\");\nvar DesCryptoKey = _DesCryptoKey;\n__decorate([\n  JsonProp({ name: \"k\", converter: JsonBase64UrlConverter })\n], DesCryptoKey.prototype, \"data\", void 0);\nvar _DesCrypto = class _DesCrypto {\n  static async generateKey(algorithm, extractable, keyUsages) {\n    const key = new DesCryptoKey();\n    key.algorithm = algorithm;\n    key.extractable = extractable;\n    key.usages = keyUsages;\n    key.data = import_crypto.default.randomBytes(algorithm.length >> 3);\n    return key;\n  }\n  static async exportKey(format, key) {\n    switch (format.toLowerCase()) {\n      case \"jwk\":\n        return JsonSerializer.toJSON(key);\n      case \"raw\":\n        return new Uint8Array(key.data).buffer;\n      default:\n        throw new OperationError(\"format: Must be 'jwk' or 'raw'\");\n    }\n  }\n  static async importKey(format, keyData, algorithm, extractable, keyUsages) {\n    let key;\n    switch (format.toLowerCase()) {\n      case \"jwk\":\n        key = JsonParser.fromJSON(keyData, { targetSchema: DesCryptoKey });\n        break;\n      case \"raw\":\n        key = new DesCryptoKey();\n        key.data = Buffer.from(keyData);\n        break;\n      default:\n        throw new OperationError(\"format: Must be 'jwk' or 'raw'\");\n    }\n    key.algorithm = algorithm;\n    key.extractable = extractable;\n    key.usages = keyUsages;\n    return key;\n  }\n  static async encrypt(algorithm, key, data) {\n    switch (algorithm.name.toUpperCase()) {\n      case \"DES-CBC\":\n        return this.encryptDesCBC(algorithm, key, Buffer.from(data));\n      case \"DES-EDE3-CBC\":\n        return this.encryptDesEDE3CBC(algorithm, key, Buffer.from(data));\n      default:\n        throw new OperationError(\"algorithm: Is not recognized\");\n    }\n  }\n  static async decrypt(algorithm, key, data) {\n    if (!(key instanceof DesCryptoKey)) {\n      throw new Error(\"key: Is not DesCryptoKey\");\n    }\n    switch (algorithm.name.toUpperCase()) {\n      case \"DES-CBC\":\n        return this.decryptDesCBC(algorithm, key, Buffer.from(data));\n      case \"DES-EDE3-CBC\":\n        return this.decryptDesEDE3CBC(algorithm, key, Buffer.from(data));\n      default:\n        throw new OperationError(\"algorithm: Is not recognized\");\n    }\n  }\n  static async encryptDesCBC(algorithm, key, data) {\n    const cipher = import_crypto.default.createCipheriv(`des-cbc`, key.data, new Uint8Array(algorithm.iv));\n    let enc = cipher.update(data);\n    enc = Buffer.concat([enc, cipher.final()]);\n    const res = new Uint8Array(enc).buffer;\n    return res;\n  }\n  static async decryptDesCBC(algorithm, key, data) {\n    const decipher = import_crypto.default.createDecipheriv(`des-cbc`, key.data, new Uint8Array(algorithm.iv));\n    let dec = decipher.update(data);\n    dec = Buffer.concat([dec, decipher.final()]);\n    return new Uint8Array(dec).buffer;\n  }\n  static async encryptDesEDE3CBC(algorithm, key, data) {\n    const cipher = import_crypto.default.createCipheriv(`des-ede3-cbc`, key.data, Buffer.from(algorithm.iv));\n    let enc = cipher.update(data);\n    enc = Buffer.concat([enc, cipher.final()]);\n    const res = new Uint8Array(enc).buffer;\n    return res;\n  }\n  static async decryptDesEDE3CBC(algorithm, key, data) {\n    const decipher = import_crypto.default.createDecipheriv(`des-ede3-cbc`, key.data, new Uint8Array(algorithm.iv));\n    let dec = decipher.update(data);\n    dec = Buffer.concat([dec, decipher.final()]);\n    return new Uint8Array(dec).buffer;\n  }\n};\n__name(_DesCrypto, \"DesCrypto\");\nvar DesCrypto = _DesCrypto;\nvar _DesCbcProvider = class _DesCbcProvider extends DesProvider {\n  constructor() {\n    super(...arguments);\n    this.keySizeBits = 64;\n    this.ivSize = 8;\n    this.name = \"DES-CBC\";\n  }\n  async onGenerateKey(algorithm, extractable, keyUsages) {\n    const key = await DesCrypto.generateKey({\n      name: this.name,\n      length: this.keySizeBits\n    }, extractable, keyUsages);\n    return setCryptoKey(key);\n  }\n  async onEncrypt(algorithm, key, data) {\n    return DesCrypto.encrypt(algorithm, getCryptoKey(key), new Uint8Array(data));\n  }\n  async onDecrypt(algorithm, key, data) {\n    return DesCrypto.decrypt(algorithm, getCryptoKey(key), new Uint8Array(data));\n  }\n  async onExportKey(format, key) {\n    return DesCrypto.exportKey(format, getCryptoKey(key));\n  }\n  async onImportKey(format, keyData, algorithm, extractable, keyUsages) {\n    const key = await DesCrypto.importKey(format, keyData, { name: this.name, length: this.keySizeBits }, extractable, keyUsages);\n    if (key.data.length !== this.keySizeBits >> 3) {\n      throw new OperationError(\"keyData: Wrong key size\");\n    }\n    return setCryptoKey(key);\n  }\n  checkCryptoKey(key, keyUsage) {\n    super.checkCryptoKey(key, keyUsage);\n    if (!(getCryptoKey(key) instanceof DesCryptoKey)) {\n      throw new TypeError(\"key: Is not a DesCryptoKey\");\n    }\n  }\n};\n__name(_DesCbcProvider, \"DesCbcProvider\");\nvar DesCbcProvider = _DesCbcProvider;\nvar _DesEde3CbcProvider = class _DesEde3CbcProvider extends DesProvider {\n  constructor() {\n    super(...arguments);\n    this.keySizeBits = 192;\n    this.ivSize = 8;\n    this.name = \"DES-EDE3-CBC\";\n  }\n  async onGenerateKey(algorithm, extractable, keyUsages) {\n    const key = await DesCrypto.generateKey({\n      name: this.name,\n      length: this.keySizeBits\n    }, extractable, keyUsages);\n    return setCryptoKey(key);\n  }\n  async onEncrypt(algorithm, key, data) {\n    return DesCrypto.encrypt(algorithm, getCryptoKey(key), new Uint8Array(data));\n  }\n  async onDecrypt(algorithm, key, data) {\n    return DesCrypto.decrypt(algorithm, getCryptoKey(key), new Uint8Array(data));\n  }\n  async onExportKey(format, key) {\n    return DesCrypto.exportKey(format, getCryptoKey(key));\n  }\n  async onImportKey(format, keyData, algorithm, extractable, keyUsages) {\n    const key = await DesCrypto.importKey(format, keyData, { name: this.name, length: this.keySizeBits }, extractable, keyUsages);\n    if (key.data.length !== this.keySizeBits >> 3) {\n      throw new OperationError(\"keyData: Wrong key size\");\n    }\n    return setCryptoKey(key);\n  }\n  checkCryptoKey(key, keyUsage) {\n    super.checkCryptoKey(key, keyUsage);\n    if (!(getCryptoKey(key) instanceof DesCryptoKey)) {\n      throw new TypeError(\"key: Is not a DesCryptoKey\");\n    }\n  }\n};\n__name(_DesEde3CbcProvider, \"DesEde3CbcProvider\");\nvar DesEde3CbcProvider = _DesEde3CbcProvider;\nfunction getJwkAlgorithm(algorithm) {\n  switch (algorithm.name.toUpperCase()) {\n    case \"RSA-OAEP\": {\n      const mdSize = /(\\d+)$/.exec(algorithm.hash.name)[1];\n      return `RSA-OAEP${mdSize !== \"1\" ? `-${mdSize}` : \"\"}`;\n    }\n    case \"RSASSA-PKCS1-V1_5\":\n      return `RS${/(\\d+)$/.exec(algorithm.hash.name)[1]}`;\n    case \"RSA-PSS\":\n      return `PS${/(\\d+)$/.exec(algorithm.hash.name)[1]}`;\n    case \"RSA-PKCS1\":\n      return `RS1`;\n    default:\n      throw new OperationError(\"algorithm: Is not recognized\");\n  }\n}\n__name(getJwkAlgorithm, \"getJwkAlgorithm\");\nvar _RsaPrivateKey2 = class _RsaPrivateKey2 extends AsymmetricKey {\n  constructor() {\n    super(...arguments);\n    this.type = \"private\";\n  }\n  getKey() {\n    const keyInfo = AsnParser.parse(this.data, index$1.PrivateKeyInfo);\n    return AsnParser.parse(keyInfo.privateKey, index$1.RsaPrivateKey);\n  }\n  toJSON() {\n    const key = this.getKey();\n    const json = {\n      kty: \"RSA\",\n      alg: getJwkAlgorithm(this.algorithm),\n      key_ops: this.usages,\n      ext: this.extractable\n    };\n    return Object.assign(json, JsonSerializer.toJSON(key));\n  }\n  fromJSON(json) {\n    const key = JsonParser.fromJSON(json, { targetSchema: index$1.RsaPrivateKey });\n    const keyInfo = new index$1.PrivateKeyInfo();\n    keyInfo.privateKeyAlgorithm.algorithm = \"1.2.840.113549.1.1.1\";\n    keyInfo.privateKeyAlgorithm.parameters = null;\n    keyInfo.privateKey = AsnSerializer.serialize(key);\n    this.data = Buffer.from(AsnSerializer.serialize(keyInfo));\n  }\n};\n__name(_RsaPrivateKey2, \"RsaPrivateKey\");\nvar RsaPrivateKey2 = _RsaPrivateKey2;\nvar _RsaPublicKey2 = class _RsaPublicKey2 extends AsymmetricKey {\n  constructor() {\n    super(...arguments);\n    this.type = \"public\";\n  }\n  getKey() {\n    const keyInfo = AsnParser.parse(this.data, index$1.PublicKeyInfo);\n    return AsnParser.parse(keyInfo.publicKey, index$1.RsaPublicKey);\n  }\n  toJSON() {\n    const key = this.getKey();\n    const json = {\n      kty: \"RSA\",\n      alg: getJwkAlgorithm(this.algorithm),\n      key_ops: this.usages,\n      ext: this.extractable\n    };\n    return Object.assign(json, JsonSerializer.toJSON(key));\n  }\n  fromJSON(json) {\n    const key = JsonParser.fromJSON(json, { targetSchema: index$1.RsaPublicKey });\n    const keyInfo = new index$1.PublicKeyInfo();\n    keyInfo.publicKeyAlgorithm.algorithm = \"1.2.840.113549.1.1.1\";\n    keyInfo.publicKeyAlgorithm.parameters = null;\n    keyInfo.publicKey = AsnSerializer.serialize(key);\n    this.data = Buffer.from(AsnSerializer.serialize(keyInfo));\n  }\n};\n__name(_RsaPublicKey2, \"RsaPublicKey\");\nvar RsaPublicKey2 = _RsaPublicKey2;\nvar _RsaCrypto = class _RsaCrypto {\n  static async generateKey(algorithm, extractable, keyUsages) {\n    const privateKey = new RsaPrivateKey2();\n    privateKey.algorithm = algorithm;\n    privateKey.extractable = extractable;\n    privateKey.usages = keyUsages.filter((usage) => this.privateKeyUsages.indexOf(usage) !== -1);\n    const publicKey = new RsaPublicKey2();\n    publicKey.algorithm = algorithm;\n    publicKey.extractable = true;\n    publicKey.usages = keyUsages.filter((usage) => this.publicKeyUsages.indexOf(usage) !== -1);\n    const publicExponent = Buffer.concat([\n      Buffer.alloc(4 - algorithm.publicExponent.byteLength, 0),\n      Buffer.from(algorithm.publicExponent)\n    ]).readInt32BE(0);\n    const keys = import_crypto.default.generateKeyPairSync(\"rsa\", {\n      modulusLength: algorithm.modulusLength,\n      publicExponent,\n      publicKeyEncoding: {\n        format: \"der\",\n        type: \"spki\"\n      },\n      privateKeyEncoding: {\n        format: \"der\",\n        type: \"pkcs8\"\n      }\n    });\n    privateKey.data = keys.privateKey;\n    publicKey.data = keys.publicKey;\n    const res = {\n      privateKey,\n      publicKey\n    };\n    return res;\n  }\n  static async exportKey(format, key) {\n    switch (format.toLowerCase()) {\n      case \"jwk\":\n        return JsonSerializer.toJSON(key);\n      case \"pkcs8\":\n      case \"spki\":\n        return new Uint8Array(key.data).buffer;\n      default:\n        throw new OperationError(\"format: Must be 'jwk', 'pkcs8' or 'spki'\");\n    }\n  }\n  static async importKey(format, keyData, algorithm, extractable, keyUsages) {\n    switch (format.toLowerCase()) {\n      case \"jwk\": {\n        const jwk = keyData;\n        if (jwk.d) {\n          const asnKey = JsonParser.fromJSON(keyData, { targetSchema: index$1.RsaPrivateKey });\n          return this.importPrivateKey(asnKey, algorithm, extractable, keyUsages);\n        } else {\n          const asnKey = JsonParser.fromJSON(keyData, { targetSchema: index$1.RsaPublicKey });\n          return this.importPublicKey(asnKey, algorithm, extractable, keyUsages);\n        }\n      }\n      case \"spki\": {\n        const keyInfo = AsnParser.parse(new Uint8Array(keyData), index$1.PublicKeyInfo);\n        const asnKey = AsnParser.parse(keyInfo.publicKey, index$1.RsaPublicKey);\n        return this.importPublicKey(asnKey, algorithm, extractable, keyUsages);\n      }\n      case \"pkcs8\": {\n        const keyInfo = AsnParser.parse(new Uint8Array(keyData), index$1.PrivateKeyInfo);\n        const asnKey = AsnParser.parse(keyInfo.privateKey, index$1.RsaPrivateKey);\n        return this.importPrivateKey(asnKey, algorithm, extractable, keyUsages);\n      }\n      default:\n        throw new OperationError(\"format: Must be 'jwk', 'pkcs8' or 'spki'\");\n    }\n  }\n  static async sign(algorithm, key, data) {\n    switch (algorithm.name.toUpperCase()) {\n      case \"RSA-PSS\":\n      case \"RSASSA-PKCS1-V1_5\":\n        return this.signRsa(algorithm, key, data);\n      default:\n        throw new OperationError(\"algorithm: Is not recognized\");\n    }\n  }\n  static async verify(algorithm, key, signature, data) {\n    switch (algorithm.name.toUpperCase()) {\n      case \"RSA-PSS\":\n      case \"RSASSA-PKCS1-V1_5\":\n        return this.verifySSA(algorithm, key, data, signature);\n      default:\n        throw new OperationError(\"algorithm: Is not recognized\");\n    }\n  }\n  static async encrypt(algorithm, key, data) {\n    switch (algorithm.name.toUpperCase()) {\n      case \"RSA-OAEP\":\n        return this.encryptOAEP(algorithm, key, data);\n      default:\n        throw new OperationError(\"algorithm: Is not recognized\");\n    }\n  }\n  static async decrypt(algorithm, key, data) {\n    switch (algorithm.name.toUpperCase()) {\n      case \"RSA-OAEP\":\n        return this.decryptOAEP(algorithm, key, data);\n      default:\n        throw new OperationError(\"algorithm: Is not recognized\");\n    }\n  }\n  static importPrivateKey(asnKey, algorithm, extractable, keyUsages) {\n    const keyInfo = new index$1.PrivateKeyInfo();\n    keyInfo.privateKeyAlgorithm.algorithm = \"1.2.840.113549.1.1.1\";\n    keyInfo.privateKeyAlgorithm.parameters = null;\n    keyInfo.privateKey = AsnSerializer.serialize(asnKey);\n    const key = new RsaPrivateKey2();\n    key.data = Buffer.from(AsnSerializer.serialize(keyInfo));\n    key.algorithm = Object.assign({}, algorithm);\n    key.algorithm.publicExponent = new Uint8Array(asnKey.publicExponent);\n    key.algorithm.modulusLength = asnKey.modulus.byteLength << 3;\n    key.extractable = extractable;\n    key.usages = keyUsages;\n    return key;\n  }\n  static importPublicKey(asnKey, algorithm, extractable, keyUsages) {\n    const keyInfo = new index$1.PublicKeyInfo();\n    keyInfo.publicKeyAlgorithm.algorithm = \"1.2.840.113549.1.1.1\";\n    keyInfo.publicKeyAlgorithm.parameters = null;\n    keyInfo.publicKey = AsnSerializer.serialize(asnKey);\n    const key = new RsaPublicKey2();\n    key.data = Buffer.from(AsnSerializer.serialize(keyInfo));\n    key.algorithm = Object.assign({}, algorithm);\n    key.algorithm.publicExponent = new Uint8Array(asnKey.publicExponent);\n    key.algorithm.modulusLength = asnKey.modulus.byteLength << 3;\n    key.extractable = extractable;\n    key.usages = keyUsages;\n    return key;\n  }\n  static getCryptoAlgorithm(alg) {\n    switch (alg.hash.name.toUpperCase()) {\n      case \"SHA-1\":\n        return \"RSA-SHA1\";\n      case \"SHA-256\":\n        return \"RSA-SHA256\";\n      case \"SHA-384\":\n        return \"RSA-SHA384\";\n      case \"SHA-512\":\n        return \"RSA-SHA512\";\n      case \"SHA3-256\":\n        return \"RSA-SHA3-256\";\n      case \"SHA3-384\":\n        return \"RSA-SHA3-384\";\n      case \"SHA3-512\":\n        return \"RSA-SHA3-512\";\n      default:\n        throw new OperationError(\"algorithm.hash: Is not recognized\");\n    }\n  }\n  static signRsa(algorithm, key, data) {\n    const cryptoAlg = this.getCryptoAlgorithm(key.algorithm);\n    const signer = import_crypto.default.createSign(cryptoAlg);\n    signer.update(Buffer.from(data));\n    if (!key.pem) {\n      key.pem = `-----BEGIN PRIVATE KEY-----\n${key.data.toString(\"base64\")}\n-----END PRIVATE KEY-----`;\n    }\n    const options = {\n      key: key.pem\n    };\n    if (algorithm.name.toUpperCase() === \"RSA-PSS\") {\n      options.padding = import_crypto.default.constants.RSA_PKCS1_PSS_PADDING;\n      options.saltLength = algorithm.saltLength;\n    }\n    const signature = signer.sign(options);\n    return new Uint8Array(signature).buffer;\n  }\n  static verifySSA(algorithm, key, data, signature) {\n    const cryptoAlg = this.getCryptoAlgorithm(key.algorithm);\n    const signer = import_crypto.default.createVerify(cryptoAlg);\n    signer.update(Buffer.from(data));\n    if (!key.pem) {\n      key.pem = `-----BEGIN PUBLIC KEY-----\n${key.data.toString(\"base64\")}\n-----END PUBLIC KEY-----`;\n    }\n    const options = {\n      key: key.pem\n    };\n    if (algorithm.name.toUpperCase() === \"RSA-PSS\") {\n      options.padding = import_crypto.default.constants.RSA_PKCS1_PSS_PADDING;\n      options.saltLength = algorithm.saltLength;\n    }\n    const ok = signer.verify(options, signature);\n    return ok;\n  }\n  static encryptOAEP(algorithm, key, data) {\n    const options = {\n      key: `-----BEGIN PUBLIC KEY-----\n${key.data.toString(\"base64\")}\n-----END PUBLIC KEY-----`,\n      padding: import_crypto.default.constants.RSA_PKCS1_OAEP_PADDING\n    };\n    if (algorithm.label)\n      ;\n    return new Uint8Array(import_crypto.default.publicEncrypt(options, data)).buffer;\n  }\n  static decryptOAEP(algorithm, key, data) {\n    const options = {\n      key: `-----BEGIN PRIVATE KEY-----\n${key.data.toString(\"base64\")}\n-----END PRIVATE KEY-----`,\n      padding: import_crypto.default.constants.RSA_PKCS1_OAEP_PADDING\n    };\n    if (algorithm.label)\n      ;\n    return new Uint8Array(import_crypto.default.privateDecrypt(options, data)).buffer;\n  }\n};\n__name(_RsaCrypto, \"RsaCrypto\");\nvar RsaCrypto = _RsaCrypto;\nRsaCrypto.publicKeyUsages = [\"verify\", \"encrypt\", \"wrapKey\"];\nRsaCrypto.privateKeyUsages = [\"sign\", \"decrypt\", \"unwrapKey\"];\nvar _RsaSsaProvider2 = class _RsaSsaProvider2 extends RsaSsaProvider {\n  constructor() {\n    super(...arguments);\n    this.hashAlgorithms = [\n      \"SHA-1\",\n      \"SHA-256\",\n      \"SHA-384\",\n      \"SHA-512\",\n      \"shake128\",\n      \"shake256\",\n      \"SHA3-256\",\n      \"SHA3-384\",\n      \"SHA3-512\"\n    ];\n  }\n  async onGenerateKey(algorithm, extractable, keyUsages) {\n    const keys = await RsaCrypto.generateKey({\n      ...algorithm,\n      name: this.name\n    }, extractable, keyUsages);\n    return {\n      privateKey: setCryptoKey(keys.privateKey),\n      publicKey: setCryptoKey(keys.publicKey)\n    };\n  }\n  async onSign(algorithm, key, data) {\n    return RsaCrypto.sign(algorithm, getCryptoKey(key), new Uint8Array(data));\n  }\n  async onVerify(algorithm, key, signature, data) {\n    return RsaCrypto.verify(algorithm, getCryptoKey(key), new Uint8Array(signature), new Uint8Array(data));\n  }\n  async onExportKey(format, key) {\n    return RsaCrypto.exportKey(format, getCryptoKey(key));\n  }\n  async onImportKey(format, keyData, algorithm, extractable, keyUsages) {\n    const key = await RsaCrypto.importKey(format, keyData, { ...algorithm, name: this.name }, extractable, keyUsages);\n    return setCryptoKey(key);\n  }\n  checkCryptoKey(key, keyUsage) {\n    super.checkCryptoKey(key, keyUsage);\n    const internalKey = getCryptoKey(key);\n    if (!(internalKey instanceof RsaPrivateKey2 || internalKey instanceof RsaPublicKey2)) {\n      throw new TypeError(\"key: Is not RSA CryptoKey\");\n    }\n  }\n};\n__name(_RsaSsaProvider2, \"RsaSsaProvider\");\nvar RsaSsaProvider2 = _RsaSsaProvider2;\nvar _RsaPssProvider2 = class _RsaPssProvider2 extends RsaPssProvider {\n  constructor() {\n    super(...arguments);\n    this.hashAlgorithms = [\n      \"SHA-1\",\n      \"SHA-256\",\n      \"SHA-384\",\n      \"SHA-512\",\n      \"shake128\",\n      \"shake256\",\n      \"SHA3-256\",\n      \"SHA3-384\",\n      \"SHA3-512\"\n    ];\n  }\n  async onGenerateKey(algorithm, extractable, keyUsages) {\n    const keys = await RsaCrypto.generateKey({\n      ...algorithm,\n      name: this.name\n    }, extractable, keyUsages);\n    return {\n      privateKey: setCryptoKey(keys.privateKey),\n      publicKey: setCryptoKey(keys.publicKey)\n    };\n  }\n  async onSign(algorithm, key, data) {\n    return RsaCrypto.sign(algorithm, getCryptoKey(key), new Uint8Array(data));\n  }\n  async onVerify(algorithm, key, signature, data) {\n    return RsaCrypto.verify(algorithm, getCryptoKey(key), new Uint8Array(signature), new Uint8Array(data));\n  }\n  async onExportKey(format, key) {\n    return RsaCrypto.exportKey(format, getCryptoKey(key));\n  }\n  async onImportKey(format, keyData, algorithm, extractable, keyUsages) {\n    const key = await RsaCrypto.importKey(format, keyData, { ...algorithm, name: this.name }, extractable, keyUsages);\n    return setCryptoKey(key);\n  }\n  checkCryptoKey(key, keyUsage) {\n    super.checkCryptoKey(key, keyUsage);\n    const internalKey = getCryptoKey(key);\n    if (!(internalKey instanceof RsaPrivateKey2 || internalKey instanceof RsaPublicKey2)) {\n      throw new TypeError(\"key: Is not RSA CryptoKey\");\n    }\n  }\n};\n__name(_RsaPssProvider2, \"RsaPssProvider\");\nvar RsaPssProvider2 = _RsaPssProvider2;\nvar _ShaCrypto = class _ShaCrypto {\n  static size(algorithm) {\n    switch (algorithm.name.toUpperCase()) {\n      case \"SHA-1\":\n        return 160;\n      case \"SHA-256\":\n      case \"SHA3-256\":\n        return 256;\n      case \"SHA-384\":\n      case \"SHA3-384\":\n        return 384;\n      case \"SHA-512\":\n      case \"SHA3-512\":\n        return 512;\n      default:\n        throw new Error(\"Unrecognized name\");\n    }\n  }\n  static getAlgorithmName(algorithm) {\n    switch (algorithm.name.toUpperCase()) {\n      case \"SHA-1\":\n        return \"sha1\";\n      case \"SHA-256\":\n        return \"sha256\";\n      case \"SHA-384\":\n        return \"sha384\";\n      case \"SHA-512\":\n        return \"sha512\";\n      case \"SHA3-256\":\n        return \"sha3-256\";\n      case \"SHA3-384\":\n        return \"sha3-384\";\n      case \"SHA3-512\":\n        return \"sha3-512\";\n      default:\n        throw new Error(\"Unrecognized name\");\n    }\n  }\n  static digest(algorithm, data) {\n    const hashAlg = this.getAlgorithmName(algorithm);\n    const hash = import_crypto.default.createHash(hashAlg).update(Buffer.from(data)).digest();\n    return new Uint8Array(hash).buffer;\n  }\n};\n__name(_ShaCrypto, \"ShaCrypto\");\nvar ShaCrypto = _ShaCrypto;\nvar _RsaOaepProvider2 = class _RsaOaepProvider2 extends RsaOaepProvider {\n  async onGenerateKey(algorithm, extractable, keyUsages) {\n    const keys = await RsaCrypto.generateKey({\n      ...algorithm,\n      name: this.name\n    }, extractable, keyUsages);\n    return {\n      privateKey: setCryptoKey(keys.privateKey),\n      publicKey: setCryptoKey(keys.publicKey)\n    };\n  }\n  async onEncrypt(algorithm, key, data) {\n    const internalKey = getCryptoKey(key);\n    const dataView = new Uint8Array(data);\n    const keySize = Math.ceil(internalKey.algorithm.modulusLength >> 3);\n    const hashSize = ShaCrypto.size(internalKey.algorithm.hash) >> 3;\n    const dataLength = dataView.byteLength;\n    const psLength = keySize - dataLength - 2 * hashSize - 2;\n    if (dataLength > keySize - 2 * hashSize - 2) {\n      throw new Error(\"Data too large\");\n    }\n    const message = new Uint8Array(keySize);\n    const seed = message.subarray(1, hashSize + 1);\n    const dataBlock = message.subarray(hashSize + 1);\n    dataBlock.set(dataView, hashSize + psLength + 1);\n    const labelHash = import_crypto.default.createHash(internalKey.algorithm.hash.name.replace(\"-\", \"\")).update(BufferSourceConverter.toUint8Array(algorithm.label || new Uint8Array(0))).digest();\n    dataBlock.set(labelHash, 0);\n    dataBlock[hashSize + psLength] = 1;\n    import_crypto.default.randomFillSync(seed);\n    const dataBlockMask = this.mgf1(internalKey.algorithm.hash, seed, dataBlock.length);\n    for (let i = 0; i < dataBlock.length; i++) {\n      dataBlock[i] ^= dataBlockMask[i];\n    }\n    const seedMask = this.mgf1(internalKey.algorithm.hash, dataBlock, seed.length);\n    for (let i = 0; i < seed.length; i++) {\n      seed[i] ^= seedMask[i];\n    }\n    if (!internalKey.pem) {\n      internalKey.pem = `-----BEGIN PUBLIC KEY-----\n${internalKey.data.toString(\"base64\")}\n-----END PUBLIC KEY-----`;\n    }\n    const pkcs0 = import_crypto.default.publicEncrypt({\n      key: internalKey.pem,\n      padding: import_crypto.default.constants.RSA_NO_PADDING\n    }, Buffer.from(message));\n    return new Uint8Array(pkcs0).buffer;\n  }\n  async onDecrypt(algorithm, key, data) {\n    const internalKey = getCryptoKey(key);\n    const keySize = Math.ceil(internalKey.algorithm.modulusLength >> 3);\n    const hashSize = ShaCrypto.size(internalKey.algorithm.hash) >> 3;\n    const dataLength = data.byteLength;\n    if (dataLength !== keySize) {\n      throw new Error(\"Bad data\");\n    }\n    if (!internalKey.pem) {\n      internalKey.pem = `-----BEGIN PRIVATE KEY-----\n${internalKey.data.toString(\"base64\")}\n-----END PRIVATE KEY-----`;\n    }\n    let pkcs0 = import_crypto.default.privateDecrypt({\n      key: internalKey.pem,\n      padding: import_crypto.default.constants.RSA_NO_PADDING\n    }, Buffer.from(data));\n    const z = pkcs0[0];\n    const seed = pkcs0.subarray(1, hashSize + 1);\n    const dataBlock = pkcs0.subarray(hashSize + 1);\n    if (z !== 0) {\n      throw new Error(\"Decryption failed\");\n    }\n    const seedMask = this.mgf1(internalKey.algorithm.hash, dataBlock, seed.length);\n    for (let i = 0; i < seed.length; i++) {\n      seed[i] ^= seedMask[i];\n    }\n    const dataBlockMask = this.mgf1(internalKey.algorithm.hash, seed, dataBlock.length);\n    for (let i = 0; i < dataBlock.length; i++) {\n      dataBlock[i] ^= dataBlockMask[i];\n    }\n    const labelHash = import_crypto.default.createHash(internalKey.algorithm.hash.name.replace(\"-\", \"\")).update(BufferSourceConverter.toUint8Array(algorithm.label || new Uint8Array(0))).digest();\n    for (let i = 0; i < hashSize; i++) {\n      if (labelHash[i] !== dataBlock[i]) {\n        throw new Error(\"Decryption failed\");\n      }\n    }\n    let psEnd = hashSize;\n    for (; psEnd < dataBlock.length; psEnd++) {\n      const psz = dataBlock[psEnd];\n      if (psz === 1) {\n        break;\n      }\n      if (psz !== 0) {\n        throw new Error(\"Decryption failed\");\n      }\n    }\n    if (psEnd === dataBlock.length) {\n      throw new Error(\"Decryption failed\");\n    }\n    pkcs0 = dataBlock.subarray(psEnd + 1);\n    return new Uint8Array(pkcs0).buffer;\n  }\n  async onExportKey(format, key) {\n    return RsaCrypto.exportKey(format, getCryptoKey(key));\n  }\n  async onImportKey(format, keyData, algorithm, extractable, keyUsages) {\n    const key = await RsaCrypto.importKey(format, keyData, { ...algorithm, name: this.name }, extractable, keyUsages);\n    return setCryptoKey(key);\n  }\n  checkCryptoKey(key, keyUsage) {\n    super.checkCryptoKey(key, keyUsage);\n    const internalKey = getCryptoKey(key);\n    if (!(internalKey instanceof RsaPrivateKey2 || internalKey instanceof RsaPublicKey2)) {\n      throw new TypeError(\"key: Is not RSA CryptoKey\");\n    }\n  }\n  mgf1(algorithm, seed, length = 0) {\n    const hashSize = ShaCrypto.size(algorithm) >> 3;\n    const mask = new Uint8Array(length);\n    const counter = new Uint8Array(4);\n    const chunks = Math.ceil(length / hashSize);\n    for (let i = 0; i < chunks; i++) {\n      counter[0] = i >>> 24;\n      counter[1] = i >>> 16 & 255;\n      counter[2] = i >>> 8 & 255;\n      counter[3] = i & 255;\n      const submask = mask.subarray(i * hashSize);\n      let chunk = import_crypto.default.createHash(algorithm.name.replace(\"-\", \"\")).update(seed).update(counter).digest();\n      if (chunk.length > submask.length) {\n        chunk = chunk.subarray(0, submask.length);\n      }\n      submask.set(chunk);\n    }\n    return mask;\n  }\n};\n__name(_RsaOaepProvider2, \"RsaOaepProvider\");\nvar RsaOaepProvider2 = _RsaOaepProvider2;\nvar _RsaEsProvider = class _RsaEsProvider extends ProviderCrypto {\n  constructor() {\n    super(...arguments);\n    this.name = \"RSAES-PKCS1-v1_5\";\n    this.usages = {\n      publicKey: [\"encrypt\", \"wrapKey\"],\n      privateKey: [\"decrypt\", \"unwrapKey\"]\n    };\n  }\n  async onGenerateKey(algorithm, extractable, keyUsages) {\n    const keys = await RsaCrypto.generateKey({\n      ...algorithm,\n      name: this.name\n    }, extractable, keyUsages);\n    return {\n      privateKey: setCryptoKey(keys.privateKey),\n      publicKey: setCryptoKey(keys.publicKey)\n    };\n  }\n  checkGenerateKeyParams(algorithm) {\n    this.checkRequiredProperty(algorithm, \"publicExponent\");\n    if (!(algorithm.publicExponent && algorithm.publicExponent instanceof Uint8Array)) {\n      throw new TypeError(\"publicExponent: Missing or not a Uint8Array\");\n    }\n    const publicExponent = Convert.ToBase64(algorithm.publicExponent);\n    if (!(publicExponent === \"Aw==\" || publicExponent === \"AQAB\")) {\n      throw new TypeError(\"publicExponent: Must be [3] or [1,0,1]\");\n    }\n    this.checkRequiredProperty(algorithm, \"modulusLength\");\n    switch (algorithm.modulusLength) {\n      case 1024:\n      case 2048:\n      case 4096:\n        break;\n      default:\n        throw new TypeError(\"modulusLength: Must be 1024, 2048, or 4096\");\n    }\n  }\n  async onEncrypt(algorithm, key, data) {\n    const options = this.toCryptoOptions(key);\n    const enc = crypto.publicEncrypt(options, new Uint8Array(data));\n    return new Uint8Array(enc).buffer;\n  }\n  async onDecrypt(algorithm, key, data) {\n    const options = this.toCryptoOptions(key);\n    const dec = crypto.privateDecrypt(options, new Uint8Array(data));\n    return new Uint8Array(dec).buffer;\n  }\n  async onExportKey(format, key) {\n    return RsaCrypto.exportKey(format, getCryptoKey(key));\n  }\n  async onImportKey(format, keyData, algorithm, extractable, keyUsages) {\n    const key = await RsaCrypto.importKey(format, keyData, { ...algorithm, name: this.name }, extractable, keyUsages);\n    return setCryptoKey(key);\n  }\n  checkCryptoKey(key, keyUsage) {\n    super.checkCryptoKey(key, keyUsage);\n    const internalKey = getCryptoKey(key);\n    if (!(internalKey instanceof RsaPrivateKey2 || internalKey instanceof RsaPublicKey2)) {\n      throw new TypeError(\"key: Is not RSA CryptoKey\");\n    }\n  }\n  toCryptoOptions(key) {\n    const type = key.type.toUpperCase();\n    return {\n      key: `-----BEGIN ${type} KEY-----\n${getCryptoKey(key).data.toString(\"base64\")}\n-----END ${type} KEY-----`,\n      padding: crypto.constants.RSA_PKCS1_PADDING\n    };\n  }\n};\n__name(_RsaEsProvider, \"RsaEsProvider\");\nvar RsaEsProvider = _RsaEsProvider;\nvar namedOIDs = {\n  \"1.2.840.10045.3.1.7\": \"P-256\",\n  \"P-256\": \"1.2.840.10045.3.1.7\",\n  \"1.3.132.0.34\": \"P-384\",\n  \"P-384\": \"1.3.132.0.34\",\n  \"1.3.132.0.35\": \"P-521\",\n  \"P-521\": \"1.3.132.0.35\",\n  \"1.3.132.0.10\": \"K-256\",\n  \"K-256\": \"1.3.132.0.10\",\n  \"brainpoolP160r1\": \"1.3.36.3.3.2.8.1.1.1\",\n  \"1.3.36.3.3.2.8.1.1.1\": \"brainpoolP160r1\",\n  \"brainpoolP160t1\": \"1.3.36.3.3.2.8.1.1.2\",\n  \"1.3.36.3.3.2.8.1.1.2\": \"brainpoolP160t1\",\n  \"brainpoolP192r1\": \"1.3.36.3.3.2.8.1.1.3\",\n  \"1.3.36.3.3.2.8.1.1.3\": \"brainpoolP192r1\",\n  \"brainpoolP192t1\": \"1.3.36.3.3.2.8.1.1.4\",\n  \"1.3.36.3.3.2.8.1.1.4\": \"brainpoolP192t1\",\n  \"brainpoolP224r1\": \"1.3.36.3.3.2.8.1.1.5\",\n  \"1.3.36.3.3.2.8.1.1.5\": \"brainpoolP224r1\",\n  \"brainpoolP224t1\": \"1.3.36.3.3.2.8.1.1.6\",\n  \"1.3.36.3.3.2.8.1.1.6\": \"brainpoolP224t1\",\n  \"brainpoolP256r1\": \"1.3.36.3.3.2.8.1.1.7\",\n  \"1.3.36.3.3.2.8.1.1.7\": \"brainpoolP256r1\",\n  \"brainpoolP256t1\": \"1.3.36.3.3.2.8.1.1.8\",\n  \"1.3.36.3.3.2.8.1.1.8\": \"brainpoolP256t1\",\n  \"brainpoolP320r1\": \"1.3.36.3.3.2.8.1.1.9\",\n  \"1.3.36.3.3.2.8.1.1.9\": \"brainpoolP320r1\",\n  \"brainpoolP320t1\": \"1.3.36.3.3.2.8.1.1.10\",\n  \"1.3.36.3.3.2.8.1.1.10\": \"brainpoolP320t1\",\n  \"brainpoolP384r1\": \"1.3.36.3.3.2.8.1.1.11\",\n  \"1.3.36.3.3.2.8.1.1.11\": \"brainpoolP384r1\",\n  \"brainpoolP384t1\": \"1.3.36.3.3.2.8.1.1.12\",\n  \"1.3.36.3.3.2.8.1.1.12\": \"brainpoolP384t1\",\n  \"brainpoolP512r1\": \"1.3.36.3.3.2.8.1.1.13\",\n  \"1.3.36.3.3.2.8.1.1.13\": \"brainpoolP512r1\",\n  \"brainpoolP512t1\": \"1.3.36.3.3.2.8.1.1.14\",\n  \"1.3.36.3.3.2.8.1.1.14\": \"brainpoolP512t1\"\n};\nfunction getOidByNamedCurve$1(namedCurve) {\n  const oid = namedOIDs[namedCurve];\n  if (!oid) {\n    throw new OperationError(`Cannot convert WebCrypto named curve '${namedCurve}' to OID`);\n  }\n  return oid;\n}\n__name(getOidByNamedCurve$1, \"getOidByNamedCurve$1\");\nvar _EcPrivateKey2 = class _EcPrivateKey2 extends AsymmetricKey {\n  constructor() {\n    super(...arguments);\n    this.type = \"private\";\n  }\n  getKey() {\n    const keyInfo = AsnParser.parse(this.data, index$1.PrivateKeyInfo);\n    return AsnParser.parse(keyInfo.privateKey, index$1.EcPrivateKey);\n  }\n  toJSON() {\n    const key = this.getKey();\n    const json = {\n      kty: \"EC\",\n      crv: this.algorithm.namedCurve,\n      key_ops: this.usages,\n      ext: this.extractable\n    };\n    return Object.assign(json, JsonSerializer.toJSON(key));\n  }\n  fromJSON(json) {\n    if (!json.crv) {\n      throw new OperationError(`Cannot get named curve from JWK. Property 'crv' is required`);\n    }\n    const keyInfo = new index$1.PrivateKeyInfo();\n    keyInfo.privateKeyAlgorithm.algorithm = \"1.2.840.10045.2.1\";\n    keyInfo.privateKeyAlgorithm.parameters = AsnSerializer.serialize(new index$1.ObjectIdentifier(getOidByNamedCurve$1(json.crv)));\n    const key = JsonParser.fromJSON(json, { targetSchema: index$1.EcPrivateKey });\n    keyInfo.privateKey = AsnSerializer.serialize(key);\n    this.data = Buffer.from(AsnSerializer.serialize(keyInfo));\n    return this;\n  }\n};\n__name(_EcPrivateKey2, \"EcPrivateKey\");\nvar EcPrivateKey2 = _EcPrivateKey2;\nvar _EcPublicKey = class _EcPublicKey extends AsymmetricKey {\n  constructor() {\n    super(...arguments);\n    this.type = \"public\";\n  }\n  getKey() {\n    const keyInfo = AsnParser.parse(this.data, index$1.PublicKeyInfo);\n    return new index$1.EcPublicKey(keyInfo.publicKey);\n  }\n  toJSON() {\n    const key = this.getKey();\n    const json = {\n      kty: \"EC\",\n      crv: this.algorithm.namedCurve,\n      key_ops: this.usages,\n      ext: this.extractable\n    };\n    return Object.assign(json, JsonSerializer.toJSON(key));\n  }\n  fromJSON(json) {\n    if (!json.crv) {\n      throw new OperationError(`Cannot get named curve from JWK. Property 'crv' is required`);\n    }\n    const key = JsonParser.fromJSON(json, { targetSchema: index$1.EcPublicKey });\n    const keyInfo = new index$1.PublicKeyInfo();\n    keyInfo.publicKeyAlgorithm.algorithm = \"1.2.840.10045.2.1\";\n    keyInfo.publicKeyAlgorithm.parameters = AsnSerializer.serialize(new index$1.ObjectIdentifier(getOidByNamedCurve$1(json.crv)));\n    keyInfo.publicKey = AsnSerializer.toASN(key).valueHex;\n    this.data = Buffer.from(AsnSerializer.serialize(keyInfo));\n    return this;\n  }\n};\n__name(_EcPublicKey, \"EcPublicKey\");\nvar EcPublicKey2 = _EcPublicKey;\nvar _Sha1Provider = class _Sha1Provider extends ProviderCrypto {\n  constructor() {\n    super(...arguments);\n    this.name = \"SHA-1\";\n    this.usages = [];\n  }\n  async onDigest(algorithm, data) {\n    return ShaCrypto.digest(algorithm, data);\n  }\n};\n__name(_Sha1Provider, \"Sha1Provider\");\nvar Sha1Provider = _Sha1Provider;\nvar _Sha256Provider = class _Sha256Provider extends ProviderCrypto {\n  constructor() {\n    super(...arguments);\n    this.name = \"SHA-256\";\n    this.usages = [];\n  }\n  async onDigest(algorithm, data) {\n    return ShaCrypto.digest(algorithm, data);\n  }\n};\n__name(_Sha256Provider, \"Sha256Provider\");\nvar Sha256Provider = _Sha256Provider;\nvar _Sha384Provider = class _Sha384Provider extends ProviderCrypto {\n  constructor() {\n    super(...arguments);\n    this.name = \"SHA-384\";\n    this.usages = [];\n  }\n  async onDigest(algorithm, data) {\n    return ShaCrypto.digest(algorithm, data);\n  }\n};\n__name(_Sha384Provider, \"Sha384Provider\");\nvar Sha384Provider = _Sha384Provider;\nvar _Sha512Provider = class _Sha512Provider extends ProviderCrypto {\n  constructor() {\n    super(...arguments);\n    this.name = \"SHA-512\";\n    this.usages = [];\n  }\n  async onDigest(algorithm, data) {\n    return ShaCrypto.digest(algorithm, data);\n  }\n};\n__name(_Sha512Provider, \"Sha512Provider\");\nvar Sha512Provider = _Sha512Provider;\nvar _Sha3256Provider = class _Sha3256Provider extends ProviderCrypto {\n  constructor() {\n    super(...arguments);\n    this.name = \"SHA3-256\";\n    this.usages = [];\n  }\n  async onDigest(algorithm, data) {\n    return ShaCrypto.digest(algorithm, data);\n  }\n};\n__name(_Sha3256Provider, \"Sha3256Provider\");\nvar Sha3256Provider = _Sha3256Provider;\nvar _Sha3384Provider = class _Sha3384Provider extends ProviderCrypto {\n  constructor() {\n    super(...arguments);\n    this.name = \"SHA3-384\";\n    this.usages = [];\n  }\n  async onDigest(algorithm, data) {\n    return ShaCrypto.digest(algorithm, data);\n  }\n};\n__name(_Sha3384Provider, \"Sha3384Provider\");\nvar Sha3384Provider = _Sha3384Provider;\nvar _Sha3512Provider = class _Sha3512Provider extends ProviderCrypto {\n  constructor() {\n    super(...arguments);\n    this.name = \"SHA3-512\";\n    this.usages = [];\n  }\n  async onDigest(algorithm, data) {\n    return ShaCrypto.digest(algorithm, data);\n  }\n};\n__name(_Sha3512Provider, \"Sha3512Provider\");\nvar Sha3512Provider = _Sha3512Provider;\nvar _EcCrypto = class _EcCrypto {\n  static async generateKey(algorithm, extractable, keyUsages) {\n    const privateKey = new EcPrivateKey2();\n    privateKey.algorithm = algorithm;\n    privateKey.extractable = extractable;\n    privateKey.usages = keyUsages.filter((usage) => this.privateKeyUsages.indexOf(usage) !== -1);\n    const publicKey = new EcPublicKey2();\n    publicKey.algorithm = algorithm;\n    publicKey.extractable = true;\n    publicKey.usages = keyUsages.filter((usage) => this.publicKeyUsages.indexOf(usage) !== -1);\n    const keys = import_crypto.default.generateKeyPairSync(\"ec\", {\n      namedCurve: this.getOpenSSLNamedCurve(algorithm.namedCurve),\n      publicKeyEncoding: {\n        format: \"der\",\n        type: \"spki\"\n      },\n      privateKeyEncoding: {\n        format: \"der\",\n        type: \"pkcs8\"\n      }\n    });\n    privateKey.data = keys.privateKey;\n    publicKey.data = keys.publicKey;\n    const res = {\n      privateKey,\n      publicKey\n    };\n    return res;\n  }\n  static async sign(algorithm, key, data) {\n    const cryptoAlg = ShaCrypto.getAlgorithmName(algorithm.hash);\n    const signer = import_crypto.default.createSign(cryptoAlg);\n    signer.update(Buffer.from(data));\n    if (!key.pem) {\n      key.pem = `-----BEGIN PRIVATE KEY-----\n${key.data.toString(\"base64\")}\n-----END PRIVATE KEY-----`;\n    }\n    const options = {\n      key: key.pem\n    };\n    const signature = signer.sign(options);\n    const ecSignature = AsnParser.parse(signature, index$1.EcDsaSignature);\n    const signatureRaw = EcUtils.encodeSignature(ecSignature, EcCurves.get(key.algorithm.namedCurve).size);\n    return signatureRaw.buffer;\n  }\n  static async verify(algorithm, key, signature, data) {\n    const cryptoAlg = ShaCrypto.getAlgorithmName(algorithm.hash);\n    const signer = import_crypto.default.createVerify(cryptoAlg);\n    signer.update(Buffer.from(data));\n    if (!key.pem) {\n      key.pem = `-----BEGIN PUBLIC KEY-----\n${key.data.toString(\"base64\")}\n-----END PUBLIC KEY-----`;\n    }\n    const options = {\n      key: key.pem\n    };\n    const ecSignature = new index$1.EcDsaSignature();\n    const namedCurve = EcCurves.get(key.algorithm.namedCurve);\n    const signaturePoint = EcUtils.decodeSignature(signature, namedCurve.size);\n    ecSignature.r = BufferSourceConverter.toArrayBuffer(signaturePoint.r);\n    ecSignature.s = BufferSourceConverter.toArrayBuffer(signaturePoint.s);\n    const ecSignatureRaw = Buffer.from(AsnSerializer.serialize(ecSignature));\n    const ok = signer.verify(options, ecSignatureRaw);\n    return ok;\n  }\n  static async deriveBits(algorithm, baseKey, length) {\n    const cryptoAlg = this.getOpenSSLNamedCurve(baseKey.algorithm.namedCurve);\n    const ecdh = import_crypto.default.createECDH(cryptoAlg);\n    const asnPrivateKey = AsnParser.parse(baseKey.data, index$1.PrivateKeyInfo);\n    const asnEcPrivateKey = AsnParser.parse(asnPrivateKey.privateKey, index$1.EcPrivateKey);\n    ecdh.setPrivateKey(Buffer.from(asnEcPrivateKey.privateKey));\n    const asnPublicKey = AsnParser.parse(algorithm.public.data, index$1.PublicKeyInfo);\n    const bits = ecdh.computeSecret(Buffer.from(asnPublicKey.publicKey));\n    if (length === null) {\n      return bits;\n    }\n    return new Uint8Array(bits).buffer.slice(0, length >> 3);\n  }\n  static async exportKey(format, key) {\n    switch (format.toLowerCase()) {\n      case \"jwk\":\n        return JsonSerializer.toJSON(key);\n      case \"pkcs8\":\n      case \"spki\":\n        return new Uint8Array(key.data).buffer;\n      case \"raw\": {\n        const publicKeyInfo = AsnParser.parse(key.data, index$1.PublicKeyInfo);\n        return publicKeyInfo.publicKey;\n      }\n      default:\n        throw new OperationError(\"format: Must be 'jwk', 'raw', pkcs8' or 'spki'\");\n    }\n  }\n  static async importKey(format, keyData, algorithm, extractable, keyUsages) {\n    switch (format.toLowerCase()) {\n      case \"jwk\": {\n        const jwk = keyData;\n        if (jwk.d) {\n          const asnKey = JsonParser.fromJSON(keyData, { targetSchema: index$1.EcPrivateKey });\n          return this.importPrivateKey(asnKey, algorithm, extractable, keyUsages);\n        } else {\n          const asnKey = JsonParser.fromJSON(keyData, { targetSchema: index$1.EcPublicKey });\n          return this.importPublicKey(asnKey, algorithm, extractable, keyUsages);\n        }\n      }\n      case \"raw\": {\n        const asnKey = new index$1.EcPublicKey(keyData);\n        return this.importPublicKey(asnKey, algorithm, extractable, keyUsages);\n      }\n      case \"spki\": {\n        const keyInfo = AsnParser.parse(new Uint8Array(keyData), index$1.PublicKeyInfo);\n        const asnKey = new index$1.EcPublicKey(keyInfo.publicKey);\n        this.assertKeyParameters(keyInfo.publicKeyAlgorithm.parameters, algorithm.namedCurve);\n        return this.importPublicKey(asnKey, algorithm, extractable, keyUsages);\n      }\n      case \"pkcs8\": {\n        const keyInfo = AsnParser.parse(new Uint8Array(keyData), index$1.PrivateKeyInfo);\n        const asnKey = AsnParser.parse(keyInfo.privateKey, index$1.EcPrivateKey);\n        this.assertKeyParameters(keyInfo.privateKeyAlgorithm.parameters, algorithm.namedCurve);\n        return this.importPrivateKey(asnKey, algorithm, extractable, keyUsages);\n      }\n      default:\n        throw new OperationError(\"format: Must be 'jwk', 'raw', 'pkcs8' or 'spki'\");\n    }\n  }\n  static assertKeyParameters(parameters, namedCurve) {\n    if (!parameters) {\n      throw new CryptoError(\"Key info doesn't have required parameters\");\n    }\n    let namedCurveIdentifier = \"\";\n    try {\n      namedCurveIdentifier = AsnParser.parse(parameters, index$1.ObjectIdentifier).value;\n    } catch (e) {\n      throw new CryptoError(\"Cannot read key info parameters\");\n    }\n    if (getOidByNamedCurve$1(namedCurve) !== namedCurveIdentifier) {\n      throw new CryptoError(\"Key info parameter doesn't match to named curve\");\n    }\n  }\n  static async importPrivateKey(asnKey, algorithm, extractable, keyUsages) {\n    const keyInfo = new index$1.PrivateKeyInfo();\n    keyInfo.privateKeyAlgorithm.algorithm = \"1.2.840.10045.2.1\";\n    keyInfo.privateKeyAlgorithm.parameters = AsnSerializer.serialize(new index$1.ObjectIdentifier(getOidByNamedCurve$1(algorithm.namedCurve)));\n    keyInfo.privateKey = AsnSerializer.serialize(asnKey);\n    const key = new EcPrivateKey2();\n    key.data = Buffer.from(AsnSerializer.serialize(keyInfo));\n    key.algorithm = Object.assign({}, algorithm);\n    key.extractable = extractable;\n    key.usages = keyUsages;\n    return key;\n  }\n  static async importPublicKey(asnKey, algorithm, extractable, keyUsages) {\n    const keyInfo = new index$1.PublicKeyInfo();\n    keyInfo.publicKeyAlgorithm.algorithm = \"1.2.840.10045.2.1\";\n    const namedCurve = getOidByNamedCurve$1(algorithm.namedCurve);\n    keyInfo.publicKeyAlgorithm.parameters = AsnSerializer.serialize(new index$1.ObjectIdentifier(namedCurve));\n    keyInfo.publicKey = asnKey.value;\n    const key = new EcPublicKey2();\n    key.data = Buffer.from(AsnSerializer.serialize(keyInfo));\n    key.algorithm = Object.assign({}, algorithm);\n    key.extractable = extractable;\n    key.usages = keyUsages;\n    return key;\n  }\n  static getOpenSSLNamedCurve(curve) {\n    switch (curve.toUpperCase()) {\n      case \"P-256\":\n        return \"prime256v1\";\n      case \"K-256\":\n        return \"secp256k1\";\n      case \"P-384\":\n        return \"secp384r1\";\n      case \"P-521\":\n        return \"secp521r1\";\n      default:\n        return curve;\n    }\n  }\n};\n__name(_EcCrypto, \"EcCrypto\");\nvar EcCrypto = _EcCrypto;\nEcCrypto.publicKeyUsages = [\"verify\"];\nEcCrypto.privateKeyUsages = [\"sign\", \"deriveKey\", \"deriveBits\"];\nvar _EcdsaProvider2 = class _EcdsaProvider2 extends EcdsaProvider {\n  constructor() {\n    super(...arguments);\n    this.namedCurves = EcCurves.names;\n    this.hashAlgorithms = [\n      \"SHA-1\",\n      \"SHA-256\",\n      \"SHA-384\",\n      \"SHA-512\",\n      \"shake128\",\n      \"shake256\",\n      \"SHA3-256\",\n      \"SHA3-384\",\n      \"SHA3-512\"\n    ];\n  }\n  async onGenerateKey(algorithm, extractable, keyUsages) {\n    const keys = await EcCrypto.generateKey({\n      ...algorithm,\n      name: this.name\n    }, extractable, keyUsages);\n    return {\n      privateKey: setCryptoKey(keys.privateKey),\n      publicKey: setCryptoKey(keys.publicKey)\n    };\n  }\n  async onSign(algorithm, key, data) {\n    return EcCrypto.sign(algorithm, getCryptoKey(key), new Uint8Array(data));\n  }\n  async onVerify(algorithm, key, signature, data) {\n    return EcCrypto.verify(algorithm, getCryptoKey(key), new Uint8Array(signature), new Uint8Array(data));\n  }\n  async onExportKey(format, key) {\n    return EcCrypto.exportKey(format, getCryptoKey(key));\n  }\n  async onImportKey(format, keyData, algorithm, extractable, keyUsages) {\n    const key = await EcCrypto.importKey(format, keyData, { ...algorithm, name: this.name }, extractable, keyUsages);\n    return setCryptoKey(key);\n  }\n  checkCryptoKey(key, keyUsage) {\n    super.checkCryptoKey(key, keyUsage);\n    const internalKey = getCryptoKey(key);\n    if (!(internalKey instanceof EcPrivateKey2 || internalKey instanceof EcPublicKey2)) {\n      throw new TypeError(\"key: Is not EC CryptoKey\");\n    }\n  }\n};\n__name(_EcdsaProvider2, \"EcdsaProvider\");\nvar EcdsaProvider2 = _EcdsaProvider2;\nvar _EcdhProvider2 = class _EcdhProvider2 extends EcdhProvider {\n  constructor() {\n    super(...arguments);\n    this.namedCurves = EcCurves.names;\n  }\n  async onGenerateKey(algorithm, extractable, keyUsages) {\n    const keys = await EcCrypto.generateKey({\n      ...algorithm,\n      name: this.name\n    }, extractable, keyUsages);\n    return {\n      privateKey: setCryptoKey(keys.privateKey),\n      publicKey: setCryptoKey(keys.publicKey)\n    };\n  }\n  async onExportKey(format, key) {\n    return EcCrypto.exportKey(format, getCryptoKey(key));\n  }\n  async onImportKey(format, keyData, algorithm, extractable, keyUsages) {\n    const key = await EcCrypto.importKey(format, keyData, { ...algorithm, name: this.name }, extractable, keyUsages);\n    return setCryptoKey(key);\n  }\n  checkCryptoKey(key, keyUsage) {\n    super.checkCryptoKey(key, keyUsage);\n    const internalKey = getCryptoKey(key);\n    if (!(internalKey instanceof EcPrivateKey2 || internalKey instanceof EcPublicKey2)) {\n      throw new TypeError(\"key: Is not EC CryptoKey\");\n    }\n  }\n  async onDeriveBits(algorithm, baseKey, length) {\n    const bits = await EcCrypto.deriveBits({ ...algorithm, public: getCryptoKey(algorithm.public) }, getCryptoKey(baseKey), length);\n    return bits;\n  }\n};\n__name(_EcdhProvider2, \"EcdhProvider\");\nvar EcdhProvider2 = _EcdhProvider2;\nvar edOIDs = {\n  [index$1.idEd448]: \"Ed448\",\n  \"ed448\": index$1.idEd448,\n  [index$1.idX448]: \"X448\",\n  \"x448\": index$1.idX448,\n  [index$1.idEd25519]: \"Ed25519\",\n  \"ed25519\": index$1.idEd25519,\n  [index$1.idX25519]: \"X25519\",\n  \"x25519\": index$1.idX25519\n};\nfunction getOidByNamedCurve(namedCurve) {\n  const oid = edOIDs[namedCurve.toLowerCase()];\n  if (!oid) {\n    throw new OperationError(`Cannot convert WebCrypto named curve '${namedCurve}' to OID`);\n  }\n  return oid;\n}\n__name(getOidByNamedCurve, \"getOidByNamedCurve\");\nvar _EdPrivateKey = class _EdPrivateKey extends AsymmetricKey {\n  constructor() {\n    super(...arguments);\n    this.type = \"private\";\n  }\n  getKey() {\n    const keyInfo = AsnParser.parse(this.data, index$1.PrivateKeyInfo);\n    return AsnParser.parse(keyInfo.privateKey, index$1.CurvePrivateKey);\n  }\n  toJSON() {\n    const key = this.getKey();\n    const json = {\n      kty: \"OKP\",\n      crv: this.algorithm.namedCurve,\n      key_ops: this.usages,\n      ext: this.extractable\n    };\n    return Object.assign(json, JsonSerializer.toJSON(key));\n  }\n  fromJSON(json) {\n    if (!json.crv) {\n      throw new OperationError(`Cannot get named curve from JWK. Property 'crv' is required`);\n    }\n    const keyInfo = new index$1.PrivateKeyInfo();\n    keyInfo.privateKeyAlgorithm.algorithm = getOidByNamedCurve(json.crv);\n    const key = JsonParser.fromJSON(json, { targetSchema: index$1.CurvePrivateKey });\n    keyInfo.privateKey = AsnSerializer.serialize(key);\n    this.data = Buffer.from(AsnSerializer.serialize(keyInfo));\n    return this;\n  }\n};\n__name(_EdPrivateKey, \"EdPrivateKey\");\nvar EdPrivateKey2 = _EdPrivateKey;\nvar _EdPublicKey = class _EdPublicKey extends AsymmetricKey {\n  constructor() {\n    super(...arguments);\n    this.type = \"public\";\n  }\n  getKey() {\n    const keyInfo = AsnParser.parse(this.data, index$1.PublicKeyInfo);\n    return keyInfo.publicKey;\n  }\n  toJSON() {\n    const key = this.getKey();\n    const json = {\n      kty: \"OKP\",\n      crv: this.algorithm.namedCurve,\n      key_ops: this.usages,\n      ext: this.extractable\n    };\n    return Object.assign(json, {\n      x: Convert.ToBase64Url(key)\n    });\n  }\n  fromJSON(json) {\n    if (!json.crv) {\n      throw new OperationError(`Cannot get named curve from JWK. Property 'crv' is required`);\n    }\n    if (!json.x) {\n      throw new OperationError(`Cannot get property from JWK. Property 'x' is required`);\n    }\n    const keyInfo = new index$1.PublicKeyInfo();\n    keyInfo.publicKeyAlgorithm.algorithm = getOidByNamedCurve(json.crv);\n    keyInfo.publicKey = Convert.FromBase64Url(json.x);\n    this.data = Buffer.from(AsnSerializer.serialize(keyInfo));\n    return this;\n  }\n};\n__name(_EdPublicKey, \"EdPublicKey\");\nvar EdPublicKey2 = _EdPublicKey;\nvar _EdCrypto = class _EdCrypto {\n  static async generateKey(algorithm, extractable, keyUsages) {\n    const privateKey = new EdPrivateKey2();\n    privateKey.algorithm = algorithm;\n    privateKey.extractable = extractable;\n    privateKey.usages = keyUsages.filter((usage) => this.privateKeyUsages.indexOf(usage) !== -1);\n    const publicKey = new EdPublicKey2();\n    publicKey.algorithm = algorithm;\n    publicKey.extractable = true;\n    publicKey.usages = keyUsages.filter((usage) => this.publicKeyUsages.indexOf(usage) !== -1);\n    const type = algorithm.namedCurve.toLowerCase();\n    const keys = import_crypto.default.generateKeyPairSync(type, {\n      publicKeyEncoding: {\n        format: \"der\",\n        type: \"spki\"\n      },\n      privateKeyEncoding: {\n        format: \"der\",\n        type: \"pkcs8\"\n      }\n    });\n    privateKey.data = keys.privateKey;\n    publicKey.data = keys.publicKey;\n    const res = {\n      privateKey,\n      publicKey\n    };\n    return res;\n  }\n  static async sign(algorithm, key, data) {\n    if (!key.pem) {\n      key.pem = `-----BEGIN PRIVATE KEY-----\n${key.data.toString(\"base64\")}\n-----END PRIVATE KEY-----`;\n    }\n    const options = {\n      key: key.pem\n    };\n    const signature = import_crypto.default.sign(null, Buffer.from(data), options);\n    return BufferSourceConverter.toArrayBuffer(signature);\n  }\n  static async verify(algorithm, key, signature, data) {\n    if (!key.pem) {\n      key.pem = `-----BEGIN PUBLIC KEY-----\n${key.data.toString(\"base64\")}\n-----END PUBLIC KEY-----`;\n    }\n    const options = {\n      key: key.pem\n    };\n    const ok = import_crypto.default.verify(null, Buffer.from(data), options, Buffer.from(signature));\n    return ok;\n  }\n  static async deriveBits(algorithm, baseKey, length) {\n    const publicKey = import_crypto.default.createPublicKey({\n      key: algorithm.public.data,\n      format: \"der\",\n      type: \"spki\"\n    });\n    const privateKey = import_crypto.default.createPrivateKey({\n      key: baseKey.data,\n      format: \"der\",\n      type: \"pkcs8\"\n    });\n    const bits = import_crypto.default.diffieHellman({\n      publicKey,\n      privateKey\n    });\n    return new Uint8Array(bits).buffer.slice(0, length >> 3);\n  }\n  static async exportKey(format, key) {\n    switch (format.toLowerCase()) {\n      case \"jwk\":\n        return JsonSerializer.toJSON(key);\n      case \"pkcs8\":\n      case \"spki\":\n        return new Uint8Array(key.data).buffer;\n      case \"raw\": {\n        const publicKeyInfo = AsnParser.parse(key.data, index$1.PublicKeyInfo);\n        return publicKeyInfo.publicKey;\n      }\n      default:\n        throw new OperationError(\"format: Must be 'jwk', 'raw', pkcs8' or 'spki'\");\n    }\n  }\n  static async importKey(format, keyData, algorithm, extractable, keyUsages) {\n    switch (format.toLowerCase()) {\n      case \"jwk\": {\n        const jwk = keyData;\n        if (jwk.d) {\n          const asnKey = JsonParser.fromJSON(keyData, { targetSchema: index$1.CurvePrivateKey });\n          return this.importPrivateKey(asnKey, algorithm, extractable, keyUsages);\n        } else {\n          if (!jwk.x) {\n            throw new TypeError(\"keyData: Cannot get required 'x' filed\");\n          }\n          return this.importPublicKey(Convert.FromBase64Url(jwk.x), algorithm, extractable, keyUsages);\n        }\n      }\n      case \"raw\": {\n        return this.importPublicKey(keyData, algorithm, extractable, keyUsages);\n      }\n      case \"spki\": {\n        const keyInfo = AsnParser.parse(new Uint8Array(keyData), index$1.PublicKeyInfo);\n        return this.importPublicKey(keyInfo.publicKey, algorithm, extractable, keyUsages);\n      }\n      case \"pkcs8\": {\n        const keyInfo = AsnParser.parse(new Uint8Array(keyData), index$1.PrivateKeyInfo);\n        const asnKey = AsnParser.parse(keyInfo.privateKey, index$1.CurvePrivateKey);\n        return this.importPrivateKey(asnKey, algorithm, extractable, keyUsages);\n      }\n      default:\n        throw new OperationError(\"format: Must be 'jwk', 'raw', 'pkcs8' or 'spki'\");\n    }\n  }\n  static importPrivateKey(asnKey, algorithm, extractable, keyUsages) {\n    const key = new EdPrivateKey2();\n    key.fromJSON({\n      crv: algorithm.namedCurve,\n      d: Convert.ToBase64Url(asnKey.d)\n    });\n    key.algorithm = Object.assign({}, algorithm);\n    key.extractable = extractable;\n    key.usages = keyUsages;\n    return key;\n  }\n  static async importPublicKey(asnKey, algorithm, extractable, keyUsages) {\n    const key = new EdPublicKey2();\n    key.fromJSON({\n      crv: algorithm.namedCurve,\n      x: Convert.ToBase64Url(asnKey)\n    });\n    key.algorithm = Object.assign({}, algorithm);\n    key.extractable = extractable;\n    key.usages = keyUsages;\n    return key;\n  }\n};\n__name(_EdCrypto, \"EdCrypto\");\nvar EdCrypto = _EdCrypto;\nEdCrypto.publicKeyUsages = [\"verify\"];\nEdCrypto.privateKeyUsages = [\"sign\", \"deriveKey\", \"deriveBits\"];\nvar _EdDsaProvider2 = class _EdDsaProvider2 extends EdDsaProvider {\n  async onGenerateKey(algorithm, extractable, keyUsages) {\n    const keys = await EdCrypto.generateKey({\n      name: this.name,\n      namedCurve: algorithm.namedCurve.replace(/^ed/i, \"Ed\")\n    }, extractable, keyUsages);\n    return {\n      privateKey: setCryptoKey(keys.privateKey),\n      publicKey: setCryptoKey(keys.publicKey)\n    };\n  }\n  async onSign(algorithm, key, data) {\n    return EdCrypto.sign(algorithm, getCryptoKey(key), new Uint8Array(data));\n  }\n  async onVerify(algorithm, key, signature, data) {\n    return EdCrypto.verify(algorithm, getCryptoKey(key), new Uint8Array(signature), new Uint8Array(data));\n  }\n  async onExportKey(format, key) {\n    return EdCrypto.exportKey(format, getCryptoKey(key));\n  }\n  async onImportKey(format, keyData, algorithm, extractable, keyUsages) {\n    const key = await EdCrypto.importKey(format, keyData, { ...algorithm, name: this.name }, extractable, keyUsages);\n    return setCryptoKey(key);\n  }\n};\n__name(_EdDsaProvider2, \"EdDsaProvider\");\nvar EdDsaProvider2 = _EdDsaProvider2;\nvar _EcdhEsProvider2 = class _EcdhEsProvider2 extends EcdhEsProvider {\n  async onGenerateKey(algorithm, extractable, keyUsages) {\n    const keys = await EdCrypto.generateKey({\n      name: this.name,\n      namedCurve: algorithm.namedCurve.toUpperCase()\n    }, extractable, keyUsages);\n    return {\n      privateKey: setCryptoKey(keys.privateKey),\n      publicKey: setCryptoKey(keys.publicKey)\n    };\n  }\n  async onDeriveBits(algorithm, baseKey, length) {\n    const bits = await EdCrypto.deriveBits({ ...algorithm, public: getCryptoKey(algorithm.public) }, getCryptoKey(baseKey), length);\n    return bits;\n  }\n  async onExportKey(format, key) {\n    return EdCrypto.exportKey(format, getCryptoKey(key));\n  }\n  async onImportKey(format, keyData, algorithm, extractable, keyUsages) {\n    const key = await EdCrypto.importKey(format, keyData, { ...algorithm, name: this.name }, extractable, keyUsages);\n    return setCryptoKey(key);\n  }\n};\n__name(_EcdhEsProvider2, \"EcdhEsProvider\");\nvar EcdhEsProvider2 = _EcdhEsProvider2;\nvar _PbkdfCryptoKey = class _PbkdfCryptoKey extends CryptoKey2 {\n};\n__name(_PbkdfCryptoKey, \"PbkdfCryptoKey\");\nvar PbkdfCryptoKey = _PbkdfCryptoKey;\nvar _Pbkdf2Provider2 = class _Pbkdf2Provider2 extends Pbkdf2Provider {\n  async onDeriveBits(algorithm, baseKey, length) {\n    return new Promise((resolve, reject) => {\n      const salt = BufferSourceConverter.toArrayBuffer(algorithm.salt);\n      const hash = algorithm.hash.name.replace(\"-\", \"\");\n      import_crypto.default.pbkdf2(getCryptoKey(baseKey).data, Buffer.from(salt), algorithm.iterations, length >> 3, hash, (err, derivedBits) => {\n        if (err) {\n          reject(err);\n        } else {\n          resolve(new Uint8Array(derivedBits).buffer);\n        }\n      });\n    });\n  }\n  async onImportKey(format, keyData, algorithm, extractable, keyUsages) {\n    if (format === \"raw\") {\n      const key = new PbkdfCryptoKey();\n      key.data = Buffer.from(keyData);\n      key.algorithm = { name: this.name };\n      key.extractable = false;\n      key.usages = keyUsages;\n      return setCryptoKey(key);\n    }\n    throw new OperationError(\"format: Must be 'raw'\");\n  }\n  checkCryptoKey(key, keyUsage) {\n    super.checkCryptoKey(key, keyUsage);\n    if (!(getCryptoKey(key) instanceof PbkdfCryptoKey)) {\n      throw new TypeError(\"key: Is not PBKDF CryptoKey\");\n    }\n  }\n};\n__name(_Pbkdf2Provider2, \"Pbkdf2Provider\");\nvar Pbkdf2Provider2 = _Pbkdf2Provider2;\nvar _HmacCryptoKey = class _HmacCryptoKey extends CryptoKey2 {\n  get alg() {\n    const hash = this.algorithm.hash.name.toUpperCase();\n    return `HS${hash.replace(\"SHA-\", \"\")}`;\n  }\n  set alg(value) {\n  }\n};\n__name(_HmacCryptoKey, \"HmacCryptoKey\");\nvar HmacCryptoKey = _HmacCryptoKey;\n__decorate([\n  JsonProp({ name: \"k\", converter: JsonBase64UrlConverter })\n], HmacCryptoKey.prototype, \"data\", void 0);\nvar _HmacProvider2 = class _HmacProvider2 extends HmacProvider {\n  async onGenerateKey(algorithm, extractable, keyUsages) {\n    const length = (algorithm.length || this.getDefaultLength(algorithm.hash.name)) >> 3 << 3;\n    const key = new HmacCryptoKey();\n    key.algorithm = {\n      ...algorithm,\n      length,\n      name: this.name\n    };\n    key.extractable = extractable;\n    key.usages = keyUsages;\n    key.data = import_crypto.default.randomBytes(length >> 3);\n    return setCryptoKey(key);\n  }\n  async onSign(algorithm, key, data) {\n    const cryptoAlg = ShaCrypto.getAlgorithmName(key.algorithm.hash);\n    const hmac = import_crypto.default.createHmac(cryptoAlg, getCryptoKey(key).data).update(Buffer.from(data)).digest();\n    return new Uint8Array(hmac).buffer;\n  }\n  async onVerify(algorithm, key, signature, data) {\n    const cryptoAlg = ShaCrypto.getAlgorithmName(key.algorithm.hash);\n    const hmac = import_crypto.default.createHmac(cryptoAlg, getCryptoKey(key).data).update(Buffer.from(data)).digest();\n    return hmac.compare(Buffer.from(signature)) === 0;\n  }\n  async onImportKey(format, keyData, algorithm, extractable, keyUsages) {\n    let key;\n    switch (format.toLowerCase()) {\n      case \"jwk\":\n        key = JsonParser.fromJSON(keyData, { targetSchema: HmacCryptoKey });\n        break;\n      case \"raw\":\n        key = new HmacCryptoKey();\n        key.data = Buffer.from(keyData);\n        break;\n      default:\n        throw new OperationError(\"format: Must be 'jwk' or 'raw'\");\n    }\n    key.algorithm = {\n      hash: { name: algorithm.hash.name },\n      name: this.name,\n      length: key.data.length << 3\n    };\n    key.extractable = extractable;\n    key.usages = keyUsages;\n    return setCryptoKey(key);\n  }\n  async onExportKey(format, key) {\n    switch (format.toLowerCase()) {\n      case \"jwk\":\n        return JsonSerializer.toJSON(getCryptoKey(key));\n      case \"raw\":\n        return new Uint8Array(getCryptoKey(key).data).buffer;\n      default:\n        throw new OperationError(\"format: Must be 'jwk' or 'raw'\");\n    }\n  }\n  checkCryptoKey(key, keyUsage) {\n    super.checkCryptoKey(key, keyUsage);\n    if (!(getCryptoKey(key) instanceof HmacCryptoKey)) {\n      throw new TypeError(\"key: Is not HMAC CryptoKey\");\n    }\n  }\n};\n__name(_HmacProvider2, \"HmacProvider\");\nvar HmacProvider2 = _HmacProvider2;\nvar _HkdfCryptoKey = class _HkdfCryptoKey extends CryptoKey2 {\n};\n__name(_HkdfCryptoKey, \"HkdfCryptoKey\");\nvar HkdfCryptoKey = _HkdfCryptoKey;\nvar _HkdfProvider2 = class _HkdfProvider2 extends HkdfProvider {\n  async onImportKey(format, keyData, algorithm, extractable, keyUsages) {\n    if (format.toLowerCase() !== \"raw\") {\n      throw new OperationError(\"Operation not supported\");\n    }\n    const key = new HkdfCryptoKey();\n    key.data = Buffer.from(keyData);\n    key.algorithm = { name: this.name };\n    key.extractable = extractable;\n    key.usages = keyUsages;\n    return setCryptoKey(key);\n  }\n  async onDeriveBits(params, baseKey, length) {\n    const hash = params.hash.name.replace(\"-\", \"\");\n    const hashLength = import_crypto.default.createHash(hash).digest().length;\n    const byteLength = length / 8;\n    const info = BufferSourceConverter.toUint8Array(params.info);\n    const PRK = import_crypto.default.createHmac(hash, BufferSourceConverter.toUint8Array(params.salt)).update(BufferSourceConverter.toUint8Array(getCryptoKey(baseKey).data)).digest();\n    const blocks = [Buffer.alloc(0)];\n    const blockCount = Math.ceil(byteLength / hashLength) + 1;\n    for (let i = 1; i < blockCount; ++i) {\n      blocks.push(import_crypto.default.createHmac(hash, PRK).update(Buffer.concat([blocks[i - 1], info, Buffer.from([i])])).digest());\n    }\n    return Buffer.concat(blocks).slice(0, byteLength);\n  }\n  checkCryptoKey(key, keyUsage) {\n    super.checkCryptoKey(key, keyUsage);\n    if (!(getCryptoKey(key) instanceof HkdfCryptoKey)) {\n      throw new TypeError(\"key: Is not HKDF CryptoKey\");\n    }\n  }\n};\n__name(_HkdfProvider2, \"HkdfProvider\");\nvar HkdfProvider2 = _HkdfProvider2;\nvar _ShakeCrypto = class _ShakeCrypto {\n  static digest(algorithm, data) {\n    const hash = import_crypto.default.createHash(algorithm.name.toLowerCase(), { outputLength: algorithm.length }).update(Buffer.from(data)).digest();\n    return new Uint8Array(hash).buffer;\n  }\n};\n__name(_ShakeCrypto, \"ShakeCrypto\");\nvar ShakeCrypto = _ShakeCrypto;\nvar _Shake128Provider2 = class _Shake128Provider2 extends Shake128Provider {\n  async onDigest(algorithm, data) {\n    return ShakeCrypto.digest(algorithm, data);\n  }\n};\n__name(_Shake128Provider2, \"Shake128Provider\");\nvar Shake128Provider2 = _Shake128Provider2;\nvar _Shake256Provider2 = class _Shake256Provider2 extends Shake256Provider {\n  async onDigest(algorithm, data) {\n    return ShakeCrypto.digest(algorithm, data);\n  }\n};\n__name(_Shake256Provider2, \"Shake256Provider\");\nvar Shake256Provider2 = _Shake256Provider2;\nvar _SubtleCrypto2 = class _SubtleCrypto2 extends SubtleCrypto {\n  constructor() {\n    var _a7;\n    super();\n    this.providers.set(new AesCbcProvider2());\n    this.providers.set(new AesCtrProvider2());\n    this.providers.set(new AesGcmProvider2());\n    this.providers.set(new AesCmacProvider2());\n    this.providers.set(new AesKwProvider2());\n    this.providers.set(new AesEcbProvider2());\n    const ciphers = crypto.getCiphers();\n    if (ciphers.includes(\"des-cbc\")) {\n      this.providers.set(new DesCbcProvider());\n    }\n    this.providers.set(new DesEde3CbcProvider());\n    this.providers.set(new RsaSsaProvider2());\n    this.providers.set(new RsaPssProvider2());\n    this.providers.set(new RsaOaepProvider2());\n    this.providers.set(new RsaEsProvider());\n    this.providers.set(new EcdsaProvider2());\n    this.providers.set(new EcdhProvider2());\n    this.providers.set(new Sha1Provider());\n    this.providers.set(new Sha256Provider());\n    this.providers.set(new Sha384Provider());\n    this.providers.set(new Sha512Provider());\n    this.providers.set(new Pbkdf2Provider2());\n    this.providers.set(new HmacProvider2());\n    this.providers.set(new HkdfProvider2());\n    const nodeMajorVersion = (_a7 = /^v(\\d+)/.exec(process.version)) === null || _a7 === void 0 ? void 0 : _a7[1];\n    if (nodeMajorVersion && parseInt(nodeMajorVersion, 10) >= 12) {\n      this.providers.set(new Shake128Provider2());\n      this.providers.set(new Shake256Provider2());\n    }\n    const hashes = crypto.getHashes();\n    if (hashes.includes(\"sha3-256\")) {\n      this.providers.set(new Sha3256Provider());\n    }\n    if (hashes.includes(\"sha3-384\")) {\n      this.providers.set(new Sha3384Provider());\n    }\n    if (hashes.includes(\"sha3-512\")) {\n      this.providers.set(new Sha3512Provider());\n    }\n    if (nodeMajorVersion && parseInt(nodeMajorVersion, 10) >= 14) {\n      this.providers.set(new EdDsaProvider2());\n      this.providers.set(new EcdhEsProvider2());\n    }\n  }\n};\n__name(_SubtleCrypto2, \"SubtleCrypto\");\nvar SubtleCrypto2 = _SubtleCrypto2;\nvar _Crypto2 = class _Crypto2 extends Crypto {\n  constructor() {\n    super(...arguments);\n    this.subtle = new SubtleCrypto2();\n  }\n  getRandomValues(array) {\n    if (!ArrayBuffer.isView(array)) {\n      throw new TypeError(\"Failed to execute 'getRandomValues' on 'Crypto': parameter 1 is not of type 'ArrayBufferView'\");\n    }\n    const buffer = Buffer.from(array.buffer, array.byteOffset, array.byteLength);\n    import_crypto.default.randomFillSync(buffer);\n    return array;\n  }\n};\n__name(_Crypto2, \"Crypto\");\nvar Crypto2 = _Crypto2;\n\n// src/primitives/crypto.js\nfunction SubtleCrypto3() {\n  if (!(this instanceof SubtleCrypto3))\n    return new SubtleCrypto3();\n  throw TypeError(\"Illegal constructor\");\n}\n__name(SubtleCrypto3, \"SubtleCrypto\");\nvar crypto2 = new Crypto2();\n// Annotate the CommonJS export names for ESM import in node:\n0 && (module.exports = {\n  Crypto,\n  CryptoKey,\n  SubtleCrypto,\n  crypto\n});\n"