# 0.5.0 Migration Guide

## nginx-vhosts

- The nginx-vhosts template language is now [sigil](https://github.com/gliderlabs/sigil)
  - No need to escape literal `$` characters (or other "bash-isms")
  - Template variables are represented as {{ .VARIABLE_NAME }}
  - A detailed list of template variables can be found [here](/dokku/nginx#available-template-variables)
- A custom nginx-vhosts template must be named `nginx.conf.sigil`
  - The default path for this custom template is the root of your repo (i.e. `/app` in the container or `WORKDIR` if defined in a dockerfile app)
  - Dokku no longer looks for this file in `/home/dokku/myapp` on the dokku server
  - Check out an example template [here](/dokku/nginx/)
- Support for server-wide SSL certs have been dropped in favor of using the `certs` plugin
  - `dokku certs:add myapp < certs.tar`
- All domains for an SSL-enabled app will be redirected to https by default
  - This can be overridden with a custom template
- Replaced "magic" `NO_VHOST` variable with `domains:enable/disable`
- Simplified zero downtime control
  - `checks:enable/disable`

## Dockerfile apps with exposed ports

- Dockerfiles with `EXPOSE` clauses will get [all **tcp** ports proxied by default](/dokku/deployment/dockerfiles/#exposed-ports)
  - Note that nginx will proxy the same port numbers to listen publicly
  - UDP ports can be exposed by disabling the [nginx proxy](/dokku/proxy/) with `dokku proxy:disable myapp`
