use strict;
# This is automatically generated by author/import-moose-test.pl.
# DO NOT EDIT THIS FILE. ANY CHANGES WILL BE LOST!!!
use t::lib::MooseCompat;
use warnings;

use Test::More;
$TODO = q{Mouse is not yet completed};
use Test::Exception;

{
    package MyClass;
    use Mouse;

    sub DEMOLISH { }
}

my $object = MyClass->new;

# Removing the metaclass simulates the case where the metaclass object
# goes out of scope _before_ the object itself, which under normal
# circumstances only happens during global destruction.
Mouse::Util::remove_metaclass_by_name('MyClass');

# The bug happened when DEMOLISHALL called
# Mouse::Util::class_of($object) and did not get a metaclass object
# back.
lives_ok { $object->DESTROY }
'can call DESTROY on an object without a metaclass object in the CMOP cache';


MyClass->meta->make_immutable;
Mouse::Util::remove_metaclass_by_name('MyClass');

# The bug didn't manifest for immutable objects, but this test should
# help us prevent it happening in the future.
lives_ok { $object->DESTROY }
'can call DESTROY on an object without a metaclass object in the CMOP cache (immutable version)';

done_testing;
