#!/usr/bin/env perl
# This is automatically generated by author/import-moose-test.pl.
# DO NOT EDIT THIS FILE. ANY CHANGES WILL BE LOST!!!
use t::lib::MooseCompat;
use strict;
use warnings;
use lib 't/lib';
use Test::More;
$TODO = q{Mouse is not yet completed};
use Test::Exception;

our $called = 0;
{
    package Foo::Trait::Constructor;
    use Mouse::Role;

    around _generate_BUILDALL => sub {
        my $orig = shift;
        my $self = shift;
        return $self->$orig(@_) . '$::called++;';
    }
}

{
    package Foo;
    use Mouse;
    Mouse::Util::MetaRole::apply_metaroles(
        for => __PACKAGE__,
        class_metaroles => {
            constructor => ['Foo::Trait::Constructor'],
        }
    );
}

Foo->new;
is($called, 0, "no calls before inlining");
Foo->meta->make_immutable;

Foo->new;
is($called, 1, "inlined constructor has trait modifications");

ok(Foo->meta->constructor_class->meta->does_role('Foo::Trait::Constructor'),
   "class has correct constructor traits");

{
    package Foo::Sub;
    use Mouse;
    extends 'Foo';
}

$called = 0;

Foo::Sub->new;
is($called, 0, "no calls before inlining");

Foo::Sub->meta->make_immutable;

Foo::Sub->new;
is($called, 1, "inherits constructor trait properly");

ok(Foo::Sub->meta->constructor_class->meta->can('does_role')
&& Foo::Sub->meta->constructor_class->meta->does_role('Foo::Trait::Constructor'),
   "subclass inherits constructor traits");

{
    package Foo2::Role;
    use Mouse::Role;
}
{
    package Foo2;
    use Mouse -traits => ['Foo2::Role'];
}
{
    package Bar2;
    use Mouse;
}
{
    package Baz2;
    use Mouse;
    my $meta = __PACKAGE__->meta;
    ::lives_ok { $meta->superclasses('Foo2') } "can set superclasses once";
    ::isa_ok($meta, Foo2->meta->meta->name);
    ::lives_ok { $meta->superclasses('Bar2') } "can still set superclasses";
    ::isa_ok($meta, Bar2->meta->meta->name);
    ::is_deeply([sort map { $_->name } $meta->meta->calculate_all_roles_with_inheritance],
                ['Foo2::Role'],
                "still have the role attached");
    ::ok(!$meta->is_immutable,
       "immutable superclass doesn't make this class immutable");
    ::lives_ok { $meta->make_immutable } "can still make immutable";
}
{
    package Foo3::Role;
    use Mouse::Role;
}
{
    package Bar3;
    use Mouse -traits => ['Foo3::Role'];
}
{
    package Baz3;
    use Mouse -traits => ['Foo3::Role'];
    my $meta = __PACKAGE__->meta;
    ::lives_ok { $meta->superclasses('Foo2') } "can set superclasses once";
    ::isa_ok($meta, Foo2->meta->meta->name);
    ::is_deeply([sort map { $_->name } $meta->meta->calculate_all_roles_with_inheritance],
                ['Foo2::Role', 'Foo3::Role'],
                "reconciled roles correctly");
    ::lives_ok { $meta->superclasses('Bar3') } "can still set superclasses";
    ::isa_ok($meta, Bar3->meta->meta->name);
    ::is_deeply([sort map { $_->name } $meta->meta->calculate_all_roles_with_inheritance],
                ['Foo2::Role', 'Foo3::Role'],
                "roles still the same");
    ::ok(!$meta->is_immutable,
       "immutable superclass doesn't make this class immutable");
    ::lives_ok { $meta->make_immutable } "can still make immutable";
}
{
    package Quux3;
    use Mouse;
}
{
    package Quuux3;
    use Mouse -traits => ['Foo3::Role'];
    my $meta = __PACKAGE__->meta;
    ::lives_ok { $meta->superclasses('Foo2') } "can set superclasses once";
    ::isa_ok($meta, Foo2->meta->meta->name);
    ::is_deeply([sort map { $_->name } $meta->meta->calculate_all_roles_with_inheritance],
                ['Foo2::Role', 'Foo3::Role'],
                "reconciled roles correctly");
    ::lives_ok { $meta->superclasses('Quux3') } "can still set superclasses";
    ::isa_ok($meta, Quux3->meta->meta->name);
    ::is_deeply([sort map { $_->name } $meta->meta->calculate_all_roles_with_inheritance],
                ['Foo2::Role', 'Foo3::Role'],
                "roles still the same");
    ::ok(!$meta->is_immutable,
       "immutable superclass doesn't make this class immutable");
    ::lives_ok { $meta->make_immutable } "can still make immutable";
}

{
    package Foo4::Role;
    use Mouse::Role;
}
{
    package Foo4;
    use Mouse -traits => ['Foo4::Role'];
    __PACKAGE__->meta->make_immutable;
}
{
    package Bar4;
    use Mouse;
}
{
    package Baz4;
    use Mouse;
    my $meta = __PACKAGE__->meta;
    ::lives_ok { $meta->superclasses('Foo4') } "can set superclasses once";
    ::isa_ok($meta, Foo4->meta->_get_mutable_metaclass_name);
    ::lives_ok { $meta->superclasses('Bar4') } "can still set superclasses";
    ::isa_ok($meta, Bar4->meta->meta->name);
    ::is_deeply([sort map { $_->name } $meta->meta->calculate_all_roles_with_inheritance],
                ['Foo4::Role'],
                "still have the role attached");
    ::ok(!$meta->is_immutable,
       "immutable superclass doesn't make this class immutable");
    ::lives_ok { $meta->make_immutable } "can still make immutable";
}
{
    package Foo5::Role;
    use Mouse::Role;
}
{
    package Bar5;
    use Mouse -traits => ['Foo5::Role'];
}
{
    package Baz5;
    use Mouse -traits => ['Foo5::Role'];
    my $meta = __PACKAGE__->meta;
    ::lives_ok { $meta->superclasses('Foo4') } "can set superclasses once";
    ::isa_ok($meta, Foo4->meta->_get_mutable_metaclass_name);
    ::is_deeply([sort map { $_->name } $meta->meta->calculate_all_roles_with_inheritance],
                ['Foo4::Role', 'Foo5::Role'],
                "reconciled roles correctly");
    ::lives_ok { $meta->superclasses('Bar5') } "can still set superclasses";
    ::isa_ok($meta, Bar5->meta->meta->name);
    ::is_deeply([sort map { $_->name } $meta->meta->calculate_all_roles_with_inheritance],
                ['Foo4::Role', 'Foo5::Role'],
                "roles still the same");
    ::ok(!$meta->is_immutable,
       "immutable superclass doesn't make this class immutable");
    ::lives_ok { $meta->make_immutable } "can still make immutable";
}
{
    package Quux5;
    use Mouse;
}
{
    package Quuux5;
    use Mouse -traits => ['Foo5::Role'];
    my $meta = __PACKAGE__->meta;
    ::lives_ok { $meta->superclasses('Foo4') } "can set superclasses once";
    ::isa_ok($meta, Foo4->meta->_get_mutable_metaclass_name);
    ::is_deeply([sort map { $_->name } $meta->meta->calculate_all_roles_with_inheritance],
                ['Foo4::Role', 'Foo5::Role'],
                "reconciled roles correctly");
    ::lives_ok { $meta->superclasses('Quux5') } "can still set superclasses";
    ::isa_ok($meta, Quux5->meta->meta->name);
    ::is_deeply([sort map { $_->name } $meta->meta->calculate_all_roles_with_inheritance],
                ['Foo4::Role', 'Foo5::Role'],
                "roles still the same");
    ::ok(!$meta->is_immutable,
       "immutable superclass doesn't make this class immutable");
    ::lives_ok { $meta->make_immutable } "can still make immutable";
}

{
    package Foo5::Meta::Role;
    use Mouse::Role;
}
{
    package Foo5::SuperClass::WithMetaRole;
    use Mouse -traits =>'Foo5::Meta::Role';
}
{
    package Foo5::SuperClass::After::Attribute;
    use Mouse;
}
{
    package Foo5;
    use Mouse;
    my @superclasses = ('Foo5::SuperClass::WithMetaRole');
    extends @superclasses;

    has an_attribute_generating_methods => ( is => 'ro' );

    push(@superclasses, 'Foo5::SuperClass::After::Attribute');

    ::lives_ok {
        extends @superclasses;
    } 'MI extends after_generated_methods with metaclass roles';
    ::lives_ok {
        extends reverse @superclasses;
    }
    'MI extends after_generated_methods with metaclass roles (reverse)';
}

{
    package Foo6::Meta::Role;
    use Mouse::Role;
}
{
    package Foo6::SuperClass::WithMetaRole;
    use Mouse -traits =>'Foo6::Meta::Role';
}
{
    package Foo6::Meta::OtherRole;
    use Mouse::Role;
}
{
    package Foo6::SuperClass::After::Attribute;
    use Mouse -traits =>'Foo6::Meta::OtherRole';
}
{
    package Foo6;
    use Mouse;
    my @superclasses = ('Foo6::SuperClass::WithMetaRole');
    extends @superclasses;

    has an_attribute_generating_methods => ( is => 'ro' );

    push(@superclasses, 'Foo6::SuperClass::After::Attribute');

    ::throws_ok {
        extends @superclasses;
    } qr/compat.*pristine/,
    'unsafe MI extends after_generated_methods with metaclass roles';
    ::throws_ok {
        extends reverse @superclasses;
    } qr/compat.*pristine/,
    'unsafe MI extends after_generated_methods with metaclass roles (reverse)';
}

{
    package Foo7::Meta::Trait;
    use Mouse::Role;
}

{
    package Foo7;
    use Mouse -traits => ['Foo7::Meta::Trait'];
}

{
    package Bar7;
    # in an external file
    use Mouse -traits => ['Bar7::Meta::Trait'];
    ::lives_ok { extends 'Foo7' } "role reconciliation works";
}

{
    package Bar72;
    # in an external file
    use Mouse -traits => ['Bar7::Meta::Trait2'];
    ::lives_ok { extends 'Foo7' } "role reconciliation works";
}

done_testing;
