//+build windows
//+private
package sync2

import "core:time"
import win32 "core:sys/windows"

_Mutex :: struct {
	srwlock: win32.SRWLOCK,
}

_mutex_lock :: proc(m: ^Mutex) {
	win32.AcquireSRWLockExclusive(&m.impl.srwlock);
}

_mutex_unlock :: proc(m: ^Mutex) {
	win32.ReleaseSRWLockExclusive(&m.impl.srwlock);
}

_mutex_try_lock :: proc(m: ^Mutex) -> bool {
	return bool(win32.TryAcquireSRWLockExclusive(&m.impl.srwlock));
}

_RW_Mutex :: struct {
	srwlock: win32.SRWLOCK,
}

_rw_mutex_lock :: proc(rw: ^RW_Mutex) {
	win32.AcquireSRWLockExclusive(&rw.impl.srwlock);
}

_rw_mutex_unlock :: proc(rw: ^RW_Mutex) {
	win32.ReleaseSRWLockExclusive(&rw.impl.srwlock);
}

_rw_mutex_try_lock :: proc(rw: ^RW_Mutex) -> bool {
	return bool(win32.TryAcquireSRWLockExclusive(&rw.impl.srwlock));
}

_rw_mutex_shared_lock :: proc(rw: ^RW_Mutex) {
	win32.AcquireSRWLockShared(&rw.impl.srwlock);
}

_rw_mutex_shared_unlock :: proc(rw: ^RW_Mutex) {
	win32.ReleaseSRWLockShared(&rw.impl.srwlock);
}

_rw_mutex_try_shared_lock :: proc(rw: ^RW_Mutex) -> bool {
	return bool(win32.TryAcquireSRWLockShared(&rw.impl.srwlock));
}



_Cond :: struct {
	cond: win32.CONDITION_VARIABLE,
}

_cond_wait :: proc(c: ^Cond, m: ^Mutex) {
	_ = win32.SleepConditionVariableSRW(&c.impl.cond, &m.impl.srwlock, win32.INFINITE, 0);
}

_cond_wait_with_timeout :: proc(c: ^Cond, m: ^Mutex, timeout: time.Duration) -> bool {
	ms := win32.DWORD((max(time.duration_nanoseconds(timeout), 0) + 999999)/1000000);
	return cast(bool)win32.SleepConditionVariableSRW(&c.impl.cond, &m.impl.srwlock, ms, 0);
}

_cond_signal :: proc(c: ^Cond) {
	win32.WakeConditionVariable(&c.impl.cond);
}

_cond_broadcast :: proc(c: ^Cond) {
	win32.WakeAllConditionVariable(&c.impl.cond);
}
