define(["require", "exports", "module"], function(require, exports, module) {
    var AttractionBehavior = function(attractor,radius,strength,jitter){
        if(arguments.length < 3){
            throw new Error("Constructor received incorrect Parameters");
        }
        this.jitter = jitter || 0;
        this.attractor = attractor;
        this.strength = strength;
        this.setRadius(radius);
    };

    AttractionBehavior.prototype = {
        applyBehavior: function(p){ //apply() is reserved, so this is now applyBehavior
            var delta = this.attractor.sub(p);
            var dist = delta.magSquared();
            if(dist < this.radiusSquared){
                var f = delta.normalizeTo((1.0 - dist / this.radiusSquared)).jitter(this.jitter).scaleSelf(this.attrStrength);
                p.addForce(f);
            }
        },

        configure: function(timeStep){
            this.timeStep = timeStep;
            this.setStrength(this.strength);
        },

        getAttractor: function(){
            return this.attractor;
        },

        getJitter: function(){
            return this.jitter;
        },

        getRadius: function(){
            return this.radius;
        },

        getStrength: function(){
            return this.strength;
        },

        setAttractor: function(attractor){
            this.attractor = attractor;
        },

        setJitter: function(jitter){
            this.jitter = jitter;
        },

        setRadius: function(r){
            this.radius = r;
            this.radiusSquared = r * r;
        },

        setStrength: function(strength){
            this.strength = strength;
            this.attrStrength = strength * this.timeStep;
        }
    };

    module.exports = AttractionBehavior;

});
