define([
    './mathUtils',
    './CircularInterpolation'
], function( mathUtils, CircularInterpolation ) {


    /**
    * @class This class provides an adjustable zoom lens to either bundle or dilate values
    * around a focal point within a given interval. For a example use cases, please
    * have a look at the provided ScaleMapDataViz and ZoomLens examples.
    * @member toxi
    */
    var	ZoomLensInterpolation = function(lensPos, lensStrength) {
        this.leftImpl = new CircularInterpolation();
        this.rightImpl = new CircularInterpolation();
        this.lensPos = lensPos || 0.5;
        this.lensStrength = lensStrength || 1;
        this.absStrength = Math.abs(this.lensStrength);
        this.leftImpl.setFlipped(this.lensStrength > 0);
        this.rightImpl.setFlipped(this.lensStrength < 0);
    };

    ZoomLensInterpolation.prototype = {
        interpolate: function(min,max,t) {
            var val = min + (max - min) * t;
            if (t < this.lensPos) {
                val += (this.leftImpl.interpolate(min, min + (max - min) * this.lensPos, t/ this.lensPos) - val)* this.absStrength;
            } else {
                val += (this.rightImpl.interpolate(min + (max - min) * this.lensPos, max,(t - this.lensPos) / (1 - this.lensPos)) - val) * this.absStrength;
            }
            return val;
        },

        setLensPos: function(pos, smooth) {
            this.lensPos += (mathUtils.clipNormalized(pos) - this.lensPos) * smooth;
        },

        setLensStrength: function(str, smooth) {
            this.lensStrength += (mathUtils.clip(str, -1, 1) - this.lensStrength) * smooth;
            this.absStrength = mathUtils.abs(this.lensStrength);
            this.leftImpl.setFlipped(this.lensStrength > 0);
            this.rightImpl.setFlipped(this.lensStrength < 0);
        }
    };

    return ZoomLensInterpolation;
});

