# Learn LINQ interactively
![dotnet try Enabled](https://img.shields.io/badge/Try_.NET-Enabled-501078.svg)

<p align ="center">
<img src ="https://user-images.githubusercontent.com/2546640/56708992-deee8780-66ec-11e9-9991-eb85abb1d10a.png" width="350">
</p>

Language-Integrated Query (LINQ) is a set of technologies based on the integration of query capabilities directly into the C# language. Traditionally, queries against data are expressed as simple strings without type checking at compile time or IntelliSense support. Furthermore, you have to learn a different query language for each type of data source: SQL databases, XML documents, various Web services, and so on. With LINQ, a query is a first-class language construct, just like classes, methods, events. You write queries against strongly typed collections of objects by using language keywords and familiar operators. The LINQ family of technologies provides a consistent query experience for objects (LINQ to Objects), relational databases (Entity Framework), and XML (LINQ to XML).

You can explore LINQ in this interactive tutorial. Each lesson teaches a new LINQ concept. You start with the fundamental syntax. From there, each additional lesson adds new concepts. If you already have some experience with LINQ, you can skip to specific sections that interest you.

## Lessons in this tutorial

- [LINQ Query Syntax](docs/query-syntax.md)
- [Understand query evaluation](docs/lazy-evaluation.md)
- More in upcoming PRs
