# What's new in C# 8.0 - exploration

This exploration enables you to experiment with the features that have been released in C# 8.0, preview 2. You can try the code in the samples, modify it, and see the effects of using the new features in a variety of scenarios.

You can try the following features that first appeared in preview 2:

- [Pattern matching enhancements](./patterns.md):
- [Static local functions](static-local-functions.md)
- [Using declarations](using-declarations-ref-structs.md)

The following language features first appeared in C# 8.0 preview 1:

- [Nullable reference types](nullable-reference-types.md)
- [Asynchronous streams](asynchronous-streams.md)
- [Indices and ranges](indices-and-ranges.md)

> *Note*:
> This exploration was last updated for C# 8.0 preview 2.

You can try all of the features in the upcoming version of C# by stepping through the different sections of this tutorial. Or, you can select any of the preceding links to go to the feature you want to explore first.

#### Next: [More patterns in more places &raquo;](./patterns.md)
