/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// TGUI - Texus' Graphical User Interface
// Copyright (C) 2012-2021 Bruno Van de Velde (vdv_b@tgui.eu)
//
// This software is provided 'as-is', without any express or implied warranty.
// In no event will the authors be held liable for any damages arising from the use of this software.
//
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it freely,
// subject to the following restrictions:
//
// 1. The origin of this software must not be misrepresented;
//    you must not claim that you wrote the original software.
//    If you use this software in a product, an acknowledgment
//    in the product documentation would be appreciated but is not required.
//
// 2. Altered source versions must be plainly marked as such,
//    and must not be misrepresented as being the original software.
//
// 3. This notice may not be removed or altered from any source distribution.
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


#ifndef TGUI_RANGE_SLIDER_RENDERER_HPP
#define TGUI_RANGE_SLIDER_RENDERER_HPP


#include <TGUI/Renderers/SliderRenderer.hpp>

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

namespace tgui
{
    class TGUI_API RangeSliderRenderer : public SliderRenderer
    {
    public:

        using SliderRenderer::SliderRenderer;


        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Changes the color of the track between the selection start and selection end
        ///
        /// @param color  The new selected track color
        ///
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        void setSelectedTrackColor(Color color);


        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Returns the color of the track between the selection start and selection end
        ///
        /// @return Selected track color
        ///
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        Color getSelectedTrackColor() const;


        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Changes the color of the track between the selection start and selection end in hover state (when the mouse
        ///        is on top of it)
        ///
        /// @param color  The new hover selected track color
        ///
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        void setSelectedTrackColorHover(Color color);


        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Returns the color of the track between the selection start and selection end in hover state (when the mouse
        ///        is on top of it)
        ///
        /// @return Hover selected track color
        ///
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        Color getSelectedTrackColorHover() const;


        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Changes the image of the track between the selection start and selection end
        ///
        /// @param texture  The new selected track texture
        ///
        /// When this image is set, the selected track color property will be ignored.
        ///
        /// This texture is stretched to have the same size as the entire slider and is then clipped to the selected region.
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        void setTextureSelectedTrack(const Texture& texture);


        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Returns the image of the track between the selection start and selection end
        ///
        /// @return Selected track texture
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        const Texture& getTextureSelectedTrack() const;


        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Changes the image of the track between the selection start and selection end in hover state
        ///
        /// @param texture  The new selected track texture
        ///
        /// @see setTextureSelectedTrack
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        void setTextureSelectedTrackHover(const Texture& texture);


        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// @brief Returns the image of the track between the selection start and selection end in hover state
        ///
        /// @return Selected hovered track texture
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        const Texture& getTextureSelectedTrackHover() const;


        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    };

    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#endif // TGUI_RANGE_SLIDER_RENDERER_HPP
